# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DataGroupRecord',
    'NodeFqdn',
    'PolicyRule',
    'PolicyRuleAction',
    'PolicyRuleCondition',
    'ProfileClientSslCertKeyChain',
    'ProfileHttpEnforcement',
    'ProfileHttpHttpStrictTransportSecurity',
    'ProfileRewriteCookieRule',
    'ProfileRewriteRequest',
    'ProfileRewriteResponse',
    'ProfileRewriteUriRulesClient',
    'ProfileRewriteUriRulesServer',
    'SnatOrigin',
    'GetDataGroupRecordResult',
    'GetNodeFqdnResult',
    'GetPolicyRuleResult',
    'GetPolicyRuleActionResult',
    'GetPolicyRuleConditionResult',
]

@pulumi.output_type
class DataGroupRecord(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 data: Optional[builtins.str] = None):
        """
        :param builtins.str name: , sets the value of the record's `name` attribute, must be of type defined in `type` attribute
        :param builtins.str data: , sets the value of the record's `data` attribute, specifying a value here will create a record in the form of `name := data`
        """
        pulumi.set(__self__, "name", name)
        if data is not None:
            pulumi.set(__self__, "data", data)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        , sets the value of the record's `name` attribute, must be of type defined in `type` attribute
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def data(self) -> Optional[builtins.str]:
        """
        , sets the value of the record's `data` attribute, specifying a value here will create a record in the form of `name := data`
        """
        return pulumi.get(self, "data")


@pulumi.output_type
class NodeFqdn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressFamily":
            suggest = "address_family"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeFqdn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeFqdn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeFqdn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_family: Optional[builtins.str] = None,
                 autopopulate: Optional[builtins.str] = None,
                 downinterval: Optional[builtins.int] = None,
                 interval: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str address_family: Specifies the node's address family. The default is 'unspecified', or IP-agnostic. This needs to be specified inside the fqdn (fully qualified domain name).
        :param builtins.str autopopulate: Specifies whether the node should scale to the IP address set returned by DNS.
        :param builtins.int downinterval: Specifies the number of attempts to resolve a domain name. The default is 5.
        :param builtins.str interval: Specifies the amount of time before sending the next DNS query. Default is 3600. This needs to be specified inside the fqdn (fully qualified domain name).
        :param builtins.str name: Name of the node
        """
        if address_family is not None:
            pulumi.set(__self__, "address_family", address_family)
        if autopopulate is not None:
            pulumi.set(__self__, "autopopulate", autopopulate)
        if downinterval is not None:
            pulumi.set(__self__, "downinterval", downinterval)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="addressFamily")
    def address_family(self) -> Optional[builtins.str]:
        """
        Specifies the node's address family. The default is 'unspecified', or IP-agnostic. This needs to be specified inside the fqdn (fully qualified domain name).
        """
        return pulumi.get(self, "address_family")

    @property
    @pulumi.getter
    def autopopulate(self) -> Optional[builtins.str]:
        """
        Specifies whether the node should scale to the IP address set returned by DNS.
        """
        return pulumi.get(self, "autopopulate")

    @property
    @pulumi.getter
    def downinterval(self) -> Optional[builtins.int]:
        """
        Specifies the number of attempts to resolve a domain name. The default is 5.
        """
        return pulumi.get(self, "downinterval")

    @property
    @pulumi.getter
    def interval(self) -> Optional[builtins.str]:
        """
        Specifies the amount of time before sending the next DNS query. Default is 3600. This needs to be specified inside the fqdn (fully qualified domain name).
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the node
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PolicyRule(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 actions: Optional[Sequence['outputs.PolicyRuleAction']] = None,
                 conditions: Optional[Sequence['outputs.PolicyRuleCondition']] = None,
                 description: Optional[builtins.str] = None):
        """
        :param builtins.str name: Name of Rule to be applied in policy.
        :param Sequence['PolicyRuleActionArgs'] actions: Block type. See action block for more details.
        :param Sequence['PolicyRuleConditionArgs'] conditions: Block type. See condition block for more details.
        :param builtins.str description: Specifies descriptive text that identifies the irule attached to policy.
        """
        pulumi.set(__self__, "name", name)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of Rule to be applied in policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def actions(self) -> Optional[Sequence['outputs.PolicyRuleAction']]:
        """
        Block type. See action block for more details.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.PolicyRuleCondition']]:
        """
        Block type. See condition block for more details.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Specifies descriptive text that identifies the irule attached to policy.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class PolicyRuleAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appService":
            suggest = "app_service"
        elif key == "clonePool":
            suggest = "clone_pool"
        elif key == "cookieHash":
            suggest = "cookie_hash"
        elif key == "cookieInsert":
            suggest = "cookie_insert"
        elif key == "cookiePassive":
            suggest = "cookie_passive"
        elif key == "cookieRewrite":
            suggest = "cookie_rewrite"
        elif key == "destinationAddress":
            suggest = "destination_address"
        elif key == "expirySecs":
            suggest = "expiry_secs"
        elif key == "fromProfile":
            suggest = "from_profile"
        elif key == "httpBasicAuth":
            suggest = "http_basic_auth"
        elif key == "httpCookie":
            suggest = "http_cookie"
        elif key == "httpHeader":
            suggest = "http_header"
        elif key == "httpHost":
            suggest = "http_host"
        elif key == "httpReferer":
            suggest = "http_referer"
        elif key == "httpReply":
            suggest = "http_reply"
        elif key == "httpSetCookie":
            suggest = "http_set_cookie"
        elif key == "httpUri":
            suggest = "http_uri"
        elif key == "internalVirtual":
            suggest = "internal_virtual"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "ltmPolicy":
            suggest = "ltm_policy"
        elif key == "queryString":
            suggest = "query_string"
        elif key == "requestAdapt":
            suggest = "request_adapt"
        elif key == "responseAdapt":
            suggest = "response_adapt"
        elif key == "serverSsl":
            suggest = "server_ssl"
        elif key == "setVariable":
            suggest = "set_variable"
        elif key == "sourceAddress":
            suggest = "source_address"
        elif key == "sslClientHello":
            suggest = "ssl_client_hello"
        elif key == "sslServerHandshake":
            suggest = "ssl_server_handshake"
        elif key == "sslServerHello":
            suggest = "ssl_server_hello"
        elif key == "sslSessionId":
            suggest = "ssl_session_id"
        elif key == "tcpNagle":
            suggest = "tcp_nagle"
        elif key == "tmName":
            suggest = "tm_name"
        elif key == "vlanId":
            suggest = "vlan_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyRuleAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyRuleAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyRuleAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_service: Optional[builtins.str] = None,
                 application: Optional[builtins.str] = None,
                 asm: Optional[builtins.bool] = None,
                 avr: Optional[builtins.bool] = None,
                 cache: Optional[builtins.bool] = None,
                 carp: Optional[builtins.bool] = None,
                 category: Optional[builtins.str] = None,
                 classify: Optional[builtins.bool] = None,
                 clone_pool: Optional[builtins.str] = None,
                 code: Optional[builtins.int] = None,
                 compress: Optional[builtins.bool] = None,
                 connection: Optional[builtins.bool] = None,
                 content: Optional[builtins.str] = None,
                 cookie_hash: Optional[builtins.bool] = None,
                 cookie_insert: Optional[builtins.bool] = None,
                 cookie_passive: Optional[builtins.bool] = None,
                 cookie_rewrite: Optional[builtins.bool] = None,
                 decompress: Optional[builtins.bool] = None,
                 defer: Optional[builtins.bool] = None,
                 destination_address: Optional[builtins.bool] = None,
                 disable: Optional[builtins.bool] = None,
                 domain: Optional[builtins.str] = None,
                 enable: Optional[builtins.bool] = None,
                 expiry: Optional[builtins.str] = None,
                 expiry_secs: Optional[builtins.int] = None,
                 expression: Optional[builtins.str] = None,
                 extension: Optional[builtins.str] = None,
                 facility: Optional[builtins.str] = None,
                 forward: Optional[builtins.bool] = None,
                 from_profile: Optional[builtins.str] = None,
                 hash: Optional[builtins.bool] = None,
                 host: Optional[builtins.str] = None,
                 http: Optional[builtins.bool] = None,
                 http_basic_auth: Optional[builtins.bool] = None,
                 http_cookie: Optional[builtins.bool] = None,
                 http_header: Optional[builtins.bool] = None,
                 http_host: Optional[builtins.bool] = None,
                 http_referer: Optional[builtins.bool] = None,
                 http_reply: Optional[builtins.bool] = None,
                 http_set_cookie: Optional[builtins.bool] = None,
                 http_uri: Optional[builtins.bool] = None,
                 ifile: Optional[builtins.str] = None,
                 insert: Optional[builtins.bool] = None,
                 internal_virtual: Optional[builtins.str] = None,
                 ip_address: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 l7dos: Optional[builtins.bool] = None,
                 length: Optional[builtins.int] = None,
                 location: Optional[builtins.str] = None,
                 log: Optional[builtins.bool] = None,
                 ltm_policy: Optional[builtins.bool] = None,
                 member: Optional[builtins.str] = None,
                 message: Optional[builtins.str] = None,
                 netmask: Optional[builtins.str] = None,
                 nexthop: Optional[builtins.str] = None,
                 node: Optional[builtins.str] = None,
                 offset: Optional[builtins.int] = None,
                 path: Optional[builtins.str] = None,
                 pem: Optional[builtins.bool] = None,
                 persist: Optional[builtins.bool] = None,
                 pin: Optional[builtins.bool] = None,
                 policy: Optional[builtins.str] = None,
                 pool: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None,
                 priority: Optional[builtins.str] = None,
                 profile: Optional[builtins.str] = None,
                 protocol: Optional[builtins.str] = None,
                 query_string: Optional[builtins.str] = None,
                 rateclass: Optional[builtins.str] = None,
                 redirect: Optional[builtins.bool] = None,
                 remove: Optional[builtins.bool] = None,
                 replace: Optional[builtins.bool] = None,
                 request: Optional[builtins.bool] = None,
                 request_adapt: Optional[builtins.bool] = None,
                 reset: Optional[builtins.bool] = None,
                 response: Optional[builtins.bool] = None,
                 response_adapt: Optional[builtins.bool] = None,
                 scheme: Optional[builtins.str] = None,
                 script: Optional[builtins.str] = None,
                 select: Optional[builtins.bool] = None,
                 server_ssl: Optional[builtins.bool] = None,
                 set_variable: Optional[builtins.bool] = None,
                 shutdown: Optional[builtins.bool] = None,
                 snat: Optional[builtins.str] = None,
                 snatpool: Optional[builtins.str] = None,
                 source_address: Optional[builtins.bool] = None,
                 ssl_client_hello: Optional[builtins.bool] = None,
                 ssl_server_handshake: Optional[builtins.bool] = None,
                 ssl_server_hello: Optional[builtins.bool] = None,
                 ssl_session_id: Optional[builtins.bool] = None,
                 status: Optional[builtins.int] = None,
                 tcl: Optional[builtins.bool] = None,
                 tcp_nagle: Optional[builtins.bool] = None,
                 text: Optional[builtins.str] = None,
                 timeout: Optional[builtins.int] = None,
                 tm_name: Optional[builtins.str] = None,
                 uie: Optional[builtins.bool] = None,
                 universal: Optional[builtins.bool] = None,
                 value: Optional[builtins.str] = None,
                 virtual: Optional[builtins.str] = None,
                 vlan: Optional[builtins.str] = None,
                 vlan_id: Optional[builtins.int] = None,
                 wam: Optional[builtins.bool] = None,
                 write: Optional[builtins.bool] = None):
        """
        :param builtins.bool connection: This action is set to `true` by default, it needs to be explicitly set to `false` for actions it conflicts with.
        :param builtins.bool forward: This action will affect forwarding.
        :param builtins.str pool: This action will direct the stream to this pool.
        """
        if app_service is not None:
            pulumi.set(__self__, "app_service", app_service)
        if application is not None:
            pulumi.set(__self__, "application", application)
        if asm is not None:
            pulumi.set(__self__, "asm", asm)
        if avr is not None:
            pulumi.set(__self__, "avr", avr)
        if cache is not None:
            pulumi.set(__self__, "cache", cache)
        if carp is not None:
            pulumi.set(__self__, "carp", carp)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if classify is not None:
            pulumi.set(__self__, "classify", classify)
        if clone_pool is not None:
            pulumi.set(__self__, "clone_pool", clone_pool)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if compress is not None:
            pulumi.set(__self__, "compress", compress)
        if connection is not None:
            pulumi.set(__self__, "connection", connection)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if cookie_hash is not None:
            pulumi.set(__self__, "cookie_hash", cookie_hash)
        if cookie_insert is not None:
            pulumi.set(__self__, "cookie_insert", cookie_insert)
        if cookie_passive is not None:
            pulumi.set(__self__, "cookie_passive", cookie_passive)
        if cookie_rewrite is not None:
            pulumi.set(__self__, "cookie_rewrite", cookie_rewrite)
        if decompress is not None:
            pulumi.set(__self__, "decompress", decompress)
        if defer is not None:
            pulumi.set(__self__, "defer", defer)
        if destination_address is not None:
            pulumi.set(__self__, "destination_address", destination_address)
        if disable is not None:
            pulumi.set(__self__, "disable", disable)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)
        if expiry_secs is not None:
            pulumi.set(__self__, "expiry_secs", expiry_secs)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if facility is not None:
            pulumi.set(__self__, "facility", facility)
        if forward is not None:
            pulumi.set(__self__, "forward", forward)
        if from_profile is not None:
            pulumi.set(__self__, "from_profile", from_profile)
        if hash is not None:
            pulumi.set(__self__, "hash", hash)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if http is not None:
            pulumi.set(__self__, "http", http)
        if http_basic_auth is not None:
            pulumi.set(__self__, "http_basic_auth", http_basic_auth)
        if http_cookie is not None:
            pulumi.set(__self__, "http_cookie", http_cookie)
        if http_header is not None:
            pulumi.set(__self__, "http_header", http_header)
        if http_host is not None:
            pulumi.set(__self__, "http_host", http_host)
        if http_referer is not None:
            pulumi.set(__self__, "http_referer", http_referer)
        if http_reply is not None:
            pulumi.set(__self__, "http_reply", http_reply)
        if http_set_cookie is not None:
            pulumi.set(__self__, "http_set_cookie", http_set_cookie)
        if http_uri is not None:
            pulumi.set(__self__, "http_uri", http_uri)
        if ifile is not None:
            pulumi.set(__self__, "ifile", ifile)
        if insert is not None:
            pulumi.set(__self__, "insert", insert)
        if internal_virtual is not None:
            pulumi.set(__self__, "internal_virtual", internal_virtual)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if l7dos is not None:
            pulumi.set(__self__, "l7dos", l7dos)
        if length is not None:
            pulumi.set(__self__, "length", length)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if log is not None:
            pulumi.set(__self__, "log", log)
        if ltm_policy is not None:
            pulumi.set(__self__, "ltm_policy", ltm_policy)
        if member is not None:
            pulumi.set(__self__, "member", member)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if netmask is not None:
            pulumi.set(__self__, "netmask", netmask)
        if nexthop is not None:
            pulumi.set(__self__, "nexthop", nexthop)
        if node is not None:
            pulumi.set(__self__, "node", node)
        if offset is not None:
            pulumi.set(__self__, "offset", offset)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if pem is not None:
            pulumi.set(__self__, "pem", pem)
        if persist is not None:
            pulumi.set(__self__, "persist", persist)
        if pin is not None:
            pulumi.set(__self__, "pin", pin)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if pool is not None:
            pulumi.set(__self__, "pool", pool)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if query_string is not None:
            pulumi.set(__self__, "query_string", query_string)
        if rateclass is not None:
            pulumi.set(__self__, "rateclass", rateclass)
        if redirect is not None:
            pulumi.set(__self__, "redirect", redirect)
        if remove is not None:
            pulumi.set(__self__, "remove", remove)
        if replace is not None:
            pulumi.set(__self__, "replace", replace)
        if request is not None:
            pulumi.set(__self__, "request", request)
        if request_adapt is not None:
            pulumi.set(__self__, "request_adapt", request_adapt)
        if reset is not None:
            pulumi.set(__self__, "reset", reset)
        if response is not None:
            pulumi.set(__self__, "response", response)
        if response_adapt is not None:
            pulumi.set(__self__, "response_adapt", response_adapt)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if select is not None:
            pulumi.set(__self__, "select", select)
        if server_ssl is not None:
            pulumi.set(__self__, "server_ssl", server_ssl)
        if set_variable is not None:
            pulumi.set(__self__, "set_variable", set_variable)
        if shutdown is not None:
            pulumi.set(__self__, "shutdown", shutdown)
        if snat is not None:
            pulumi.set(__self__, "snat", snat)
        if snatpool is not None:
            pulumi.set(__self__, "snatpool", snatpool)
        if source_address is not None:
            pulumi.set(__self__, "source_address", source_address)
        if ssl_client_hello is not None:
            pulumi.set(__self__, "ssl_client_hello", ssl_client_hello)
        if ssl_server_handshake is not None:
            pulumi.set(__self__, "ssl_server_handshake", ssl_server_handshake)
        if ssl_server_hello is not None:
            pulumi.set(__self__, "ssl_server_hello", ssl_server_hello)
        if ssl_session_id is not None:
            pulumi.set(__self__, "ssl_session_id", ssl_session_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tcl is not None:
            pulumi.set(__self__, "tcl", tcl)
        if tcp_nagle is not None:
            pulumi.set(__self__, "tcp_nagle", tcp_nagle)
        if text is not None:
            pulumi.set(__self__, "text", text)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if tm_name is not None:
            pulumi.set(__self__, "tm_name", tm_name)
        if uie is not None:
            pulumi.set(__self__, "uie", uie)
        if universal is not None:
            pulumi.set(__self__, "universal", universal)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if virtual is not None:
            pulumi.set(__self__, "virtual", virtual)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)
        if wam is not None:
            pulumi.set(__self__, "wam", wam)
        if write is not None:
            pulumi.set(__self__, "write", write)

    @property
    @pulumi.getter(name="appService")
    def app_service(self) -> Optional[builtins.str]:
        return pulumi.get(self, "app_service")

    @property
    @pulumi.getter
    def application(self) -> Optional[builtins.str]:
        return pulumi.get(self, "application")

    @property
    @pulumi.getter
    def asm(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "asm")

    @property
    @pulumi.getter
    def avr(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "avr")

    @property
    @pulumi.getter
    def cache(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "cache")

    @property
    @pulumi.getter
    def carp(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "carp")

    @property
    @pulumi.getter
    def category(self) -> Optional[builtins.str]:
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def classify(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "classify")

    @property
    @pulumi.getter(name="clonePool")
    def clone_pool(self) -> Optional[builtins.str]:
        return pulumi.get(self, "clone_pool")

    @property
    @pulumi.getter
    def code(self) -> Optional[builtins.int]:
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def compress(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "compress")

    @property
    @pulumi.getter
    def connection(self) -> Optional[builtins.bool]:
        """
        This action is set to `true` by default, it needs to be explicitly set to `false` for actions it conflicts with.
        """
        return pulumi.get(self, "connection")

    @property
    @pulumi.getter
    def content(self) -> Optional[builtins.str]:
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="cookieHash")
    def cookie_hash(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "cookie_hash")

    @property
    @pulumi.getter(name="cookieInsert")
    def cookie_insert(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "cookie_insert")

    @property
    @pulumi.getter(name="cookiePassive")
    def cookie_passive(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "cookie_passive")

    @property
    @pulumi.getter(name="cookieRewrite")
    def cookie_rewrite(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "cookie_rewrite")

    @property
    @pulumi.getter
    def decompress(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "decompress")

    @property
    @pulumi.getter
    def defer(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "defer")

    @property
    @pulumi.getter(name="destinationAddress")
    def destination_address(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "destination_address")

    @property
    @pulumi.getter
    def disable(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "disable")

    @property
    @pulumi.getter
    def domain(self) -> Optional[builtins.str]:
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def enable(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def expiry(self) -> Optional[builtins.str]:
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter(name="expirySecs")
    def expiry_secs(self) -> Optional[builtins.int]:
        return pulumi.get(self, "expiry_secs")

    @property
    @pulumi.getter
    def expression(self) -> Optional[builtins.str]:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def extension(self) -> Optional[builtins.str]:
        return pulumi.get(self, "extension")

    @property
    @pulumi.getter
    def facility(self) -> Optional[builtins.str]:
        return pulumi.get(self, "facility")

    @property
    @pulumi.getter
    def forward(self) -> Optional[builtins.bool]:
        """
        This action will affect forwarding.
        """
        return pulumi.get(self, "forward")

    @property
    @pulumi.getter(name="fromProfile")
    def from_profile(self) -> Optional[builtins.str]:
        return pulumi.get(self, "from_profile")

    @property
    @pulumi.getter
    def hash(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "hash")

    @property
    @pulumi.getter
    def host(self) -> Optional[builtins.str]:
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def http(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "http")

    @property
    @pulumi.getter(name="httpBasicAuth")
    def http_basic_auth(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "http_basic_auth")

    @property
    @pulumi.getter(name="httpCookie")
    def http_cookie(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "http_cookie")

    @property
    @pulumi.getter(name="httpHeader")
    def http_header(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "http_header")

    @property
    @pulumi.getter(name="httpHost")
    def http_host(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "http_host")

    @property
    @pulumi.getter(name="httpReferer")
    def http_referer(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "http_referer")

    @property
    @pulumi.getter(name="httpReply")
    def http_reply(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "http_reply")

    @property
    @pulumi.getter(name="httpSetCookie")
    def http_set_cookie(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "http_set_cookie")

    @property
    @pulumi.getter(name="httpUri")
    def http_uri(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "http_uri")

    @property
    @pulumi.getter
    def ifile(self) -> Optional[builtins.str]:
        return pulumi.get(self, "ifile")

    @property
    @pulumi.getter
    def insert(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "insert")

    @property
    @pulumi.getter(name="internalVirtual")
    def internal_virtual(self) -> Optional[builtins.str]:
        return pulumi.get(self, "internal_virtual")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[builtins.str]:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def l7dos(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "l7dos")

    @property
    @pulumi.getter
    def length(self) -> Optional[builtins.int]:
        return pulumi.get(self, "length")

    @property
    @pulumi.getter
    def location(self) -> Optional[builtins.str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def log(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "log")

    @property
    @pulumi.getter(name="ltmPolicy")
    def ltm_policy(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "ltm_policy")

    @property
    @pulumi.getter
    def member(self) -> Optional[builtins.str]:
        return pulumi.get(self, "member")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def netmask(self) -> Optional[builtins.str]:
        return pulumi.get(self, "netmask")

    @property
    @pulumi.getter
    def nexthop(self) -> Optional[builtins.str]:
        return pulumi.get(self, "nexthop")

    @property
    @pulumi.getter
    def node(self) -> Optional[builtins.str]:
        return pulumi.get(self, "node")

    @property
    @pulumi.getter
    def offset(self) -> Optional[builtins.int]:
        return pulumi.get(self, "offset")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def pem(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "pem")

    @property
    @pulumi.getter
    def persist(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "persist")

    @property
    @pulumi.getter
    def pin(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "pin")

    @property
    @pulumi.getter
    def policy(self) -> Optional[builtins.str]:
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def pool(self) -> Optional[builtins.str]:
        """
        This action will direct the stream to this pool.
        """
        return pulumi.get(self, "pool")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def priority(self) -> Optional[builtins.str]:
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def profile(self) -> Optional[builtins.str]:
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[builtins.str]:
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> Optional[builtins.str]:
        return pulumi.get(self, "query_string")

    @property
    @pulumi.getter
    def rateclass(self) -> Optional[builtins.str]:
        return pulumi.get(self, "rateclass")

    @property
    @pulumi.getter
    def redirect(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "redirect")

    @property
    @pulumi.getter
    def remove(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "remove")

    @property
    @pulumi.getter
    def replace(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "replace")

    @property
    @pulumi.getter
    def request(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "request")

    @property
    @pulumi.getter(name="requestAdapt")
    def request_adapt(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "request_adapt")

    @property
    @pulumi.getter
    def reset(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "reset")

    @property
    @pulumi.getter
    def response(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "response")

    @property
    @pulumi.getter(name="responseAdapt")
    def response_adapt(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "response_adapt")

    @property
    @pulumi.getter
    def scheme(self) -> Optional[builtins.str]:
        return pulumi.get(self, "scheme")

    @property
    @pulumi.getter
    def script(self) -> Optional[builtins.str]:
        return pulumi.get(self, "script")

    @property
    @pulumi.getter
    def select(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "select")

    @property
    @pulumi.getter(name="serverSsl")
    def server_ssl(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "server_ssl")

    @property
    @pulumi.getter(name="setVariable")
    def set_variable(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "set_variable")

    @property
    @pulumi.getter
    def shutdown(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "shutdown")

    @property
    @pulumi.getter
    def snat(self) -> Optional[builtins.str]:
        return pulumi.get(self, "snat")

    @property
    @pulumi.getter
    def snatpool(self) -> Optional[builtins.str]:
        return pulumi.get(self, "snatpool")

    @property
    @pulumi.getter(name="sourceAddress")
    def source_address(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "source_address")

    @property
    @pulumi.getter(name="sslClientHello")
    def ssl_client_hello(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "ssl_client_hello")

    @property
    @pulumi.getter(name="sslServerHandshake")
    def ssl_server_handshake(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "ssl_server_handshake")

    @property
    @pulumi.getter(name="sslServerHello")
    def ssl_server_hello(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "ssl_server_hello")

    @property
    @pulumi.getter(name="sslSessionId")
    def ssl_session_id(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "ssl_session_id")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.int]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tcl(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "tcl")

    @property
    @pulumi.getter(name="tcpNagle")
    def tcp_nagle(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "tcp_nagle")

    @property
    @pulumi.getter
    def text(self) -> Optional[builtins.str]:
        return pulumi.get(self, "text")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[builtins.int]:
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="tmName")
    def tm_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "tm_name")

    @property
    @pulumi.getter
    def uie(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "uie")

    @property
    @pulumi.getter
    def universal(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "universal")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def virtual(self) -> Optional[builtins.str]:
        return pulumi.get(self, "virtual")

    @property
    @pulumi.getter
    def vlan(self) -> Optional[builtins.str]:
        return pulumi.get(self, "vlan")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[builtins.int]:
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter
    def wam(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "wam")

    @property
    @pulumi.getter
    def write(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "write")


@pulumi.output_type
class PolicyRuleCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appService":
            suggest = "app_service"
        elif key == "browserType":
            suggest = "browser_type"
        elif key == "browserVersion":
            suggest = "browser_version"
        elif key == "caseInsensitive":
            suggest = "case_insensitive"
        elif key == "caseSensitive":
            suggest = "case_sensitive"
        elif key == "cipherBits":
            suggest = "cipher_bits"
        elif key == "clientAccepted":
            suggest = "client_accepted"
        elif key == "clientSsl":
            suggest = "client_ssl"
        elif key == "commonName":
            suggest = "common_name"
        elif key == "countryCode":
            suggest = "country_code"
        elif key == "countryName":
            suggest = "country_name"
        elif key == "cpuUsage":
            suggest = "cpu_usage"
        elif key == "deviceMake":
            suggest = "device_make"
        elif key == "deviceModel":
            suggest = "device_model"
        elif key == "endsWith":
            suggest = "ends_with"
        elif key == "greaterOrEqual":
            suggest = "greater_or_equal"
        elif key == "httpBasicAuth":
            suggest = "http_basic_auth"
        elif key == "httpCookie":
            suggest = "http_cookie"
        elif key == "httpHeader":
            suggest = "http_header"
        elif key == "httpHost":
            suggest = "http_host"
        elif key == "httpMethod":
            suggest = "http_method"
        elif key == "httpReferer":
            suggest = "http_referer"
        elif key == "httpSetCookie":
            suggest = "http_set_cookie"
        elif key == "httpStatus":
            suggest = "http_status"
        elif key == "httpUri":
            suggest = "http_uri"
        elif key == "httpUserAgent":
            suggest = "http_user_agent"
        elif key == "httpVersion":
            suggest = "http_version"
        elif key == "lessOrEqual":
            suggest = "less_or_equal"
        elif key == "not":
            suggest = "not_"
        elif key == "pathSegment":
            suggest = "path_segment"
        elif key == "queryParameter":
            suggest = "query_parameter"
        elif key == "queryString":
            suggest = "query_string"
        elif key == "regionCode":
            suggest = "region_code"
        elif key == "regionName":
            suggest = "region_name"
        elif key == "routeDomain":
            suggest = "route_domain"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "sslCert":
            suggest = "ssl_cert"
        elif key == "sslClientHello":
            suggest = "ssl_client_hello"
        elif key == "sslExtension":
            suggest = "ssl_extension"
        elif key == "sslServerHandshake":
            suggest = "ssl_server_handshake"
        elif key == "sslServerHello":
            suggest = "ssl_server_hello"
        elif key == "startsWith":
            suggest = "starts_with"
        elif key == "tmName":
            suggest = "tm_name"
        elif key == "unnamedQueryParameter":
            suggest = "unnamed_query_parameter"
        elif key == "userAgentToken":
            suggest = "user_agent_token"
        elif key == "vlanId":
            suggest = "vlan_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyRuleCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyRuleCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyRuleCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[builtins.bool] = None,
                 all: Optional[builtins.bool] = None,
                 app_service: Optional[builtins.str] = None,
                 browser_type: Optional[builtins.bool] = None,
                 browser_version: Optional[builtins.bool] = None,
                 case_insensitive: Optional[builtins.bool] = None,
                 case_sensitive: Optional[builtins.bool] = None,
                 cipher: Optional[builtins.bool] = None,
                 cipher_bits: Optional[builtins.bool] = None,
                 client_accepted: Optional[builtins.bool] = None,
                 client_ssl: Optional[builtins.bool] = None,
                 code: Optional[builtins.bool] = None,
                 common_name: Optional[builtins.bool] = None,
                 contains: Optional[builtins.bool] = None,
                 continent: Optional[builtins.bool] = None,
                 country_code: Optional[builtins.bool] = None,
                 country_name: Optional[builtins.bool] = None,
                 cpu_usage: Optional[builtins.bool] = None,
                 datagroup: Optional[builtins.str] = None,
                 device_make: Optional[builtins.bool] = None,
                 device_model: Optional[builtins.bool] = None,
                 domain: Optional[builtins.bool] = None,
                 ends_with: Optional[builtins.bool] = None,
                 equals: Optional[builtins.bool] = None,
                 exists: Optional[builtins.bool] = None,
                 expiry: Optional[builtins.bool] = None,
                 extension: Optional[builtins.bool] = None,
                 external: Optional[builtins.bool] = None,
                 geoip: Optional[builtins.bool] = None,
                 greater: Optional[builtins.bool] = None,
                 greater_or_equal: Optional[builtins.bool] = None,
                 host: Optional[builtins.bool] = None,
                 http_basic_auth: Optional[builtins.bool] = None,
                 http_cookie: Optional[builtins.bool] = None,
                 http_header: Optional[builtins.bool] = None,
                 http_host: Optional[builtins.bool] = None,
                 http_method: Optional[builtins.bool] = None,
                 http_referer: Optional[builtins.bool] = None,
                 http_set_cookie: Optional[builtins.bool] = None,
                 http_status: Optional[builtins.bool] = None,
                 http_uri: Optional[builtins.bool] = None,
                 http_user_agent: Optional[builtins.bool] = None,
                 http_version: Optional[builtins.bool] = None,
                 index: Optional[builtins.int] = None,
                 internal: Optional[builtins.bool] = None,
                 isp: Optional[builtins.bool] = None,
                 last15secs: Optional[builtins.bool] = None,
                 last1min: Optional[builtins.bool] = None,
                 last5mins: Optional[builtins.bool] = None,
                 less: Optional[builtins.bool] = None,
                 less_or_equal: Optional[builtins.bool] = None,
                 local: Optional[builtins.bool] = None,
                 major: Optional[builtins.bool] = None,
                 matches: Optional[builtins.bool] = None,
                 minor: Optional[builtins.bool] = None,
                 missing: Optional[builtins.bool] = None,
                 mss: Optional[builtins.bool] = None,
                 not_: Optional[builtins.bool] = None,
                 org: Optional[builtins.bool] = None,
                 password: Optional[builtins.bool] = None,
                 path: Optional[builtins.bool] = None,
                 path_segment: Optional[builtins.bool] = None,
                 port: Optional[builtins.bool] = None,
                 present: Optional[builtins.bool] = None,
                 protocol: Optional[builtins.bool] = None,
                 query_parameter: Optional[builtins.bool] = None,
                 query_string: Optional[builtins.bool] = None,
                 region_code: Optional[builtins.bool] = None,
                 region_name: Optional[builtins.bool] = None,
                 remote: Optional[builtins.bool] = None,
                 request: Optional[builtins.bool] = None,
                 response: Optional[builtins.bool] = None,
                 route_domain: Optional[builtins.bool] = None,
                 rtt: Optional[builtins.bool] = None,
                 scheme: Optional[builtins.bool] = None,
                 server_name: Optional[builtins.bool] = None,
                 ssl_cert: Optional[builtins.bool] = None,
                 ssl_client_hello: Optional[builtins.bool] = None,
                 ssl_extension: Optional[builtins.bool] = None,
                 ssl_server_handshake: Optional[builtins.bool] = None,
                 ssl_server_hello: Optional[builtins.bool] = None,
                 starts_with: Optional[builtins.bool] = None,
                 tcp: Optional[builtins.bool] = None,
                 text: Optional[builtins.bool] = None,
                 tm_name: Optional[builtins.str] = None,
                 unnamed_query_parameter: Optional[builtins.bool] = None,
                 user_agent_token: Optional[builtins.bool] = None,
                 username: Optional[builtins.bool] = None,
                 value: Optional[builtins.bool] = None,
                 values: Optional[Sequence[builtins.str]] = None,
                 version: Optional[builtins.bool] = None,
                 vlan: Optional[builtins.bool] = None,
                 vlan_id: Optional[builtins.bool] = None):
        if address is not None:
            pulumi.set(__self__, "address", address)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if app_service is not None:
            pulumi.set(__self__, "app_service", app_service)
        if browser_type is not None:
            pulumi.set(__self__, "browser_type", browser_type)
        if browser_version is not None:
            pulumi.set(__self__, "browser_version", browser_version)
        if case_insensitive is not None:
            pulumi.set(__self__, "case_insensitive", case_insensitive)
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)
        if cipher is not None:
            pulumi.set(__self__, "cipher", cipher)
        if cipher_bits is not None:
            pulumi.set(__self__, "cipher_bits", cipher_bits)
        if client_accepted is not None:
            pulumi.set(__self__, "client_accepted", client_accepted)
        if client_ssl is not None:
            pulumi.set(__self__, "client_ssl", client_ssl)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if contains is not None:
            pulumi.set(__self__, "contains", contains)
        if continent is not None:
            pulumi.set(__self__, "continent", continent)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if country_name is not None:
            pulumi.set(__self__, "country_name", country_name)
        if cpu_usage is not None:
            pulumi.set(__self__, "cpu_usage", cpu_usage)
        if datagroup is not None:
            pulumi.set(__self__, "datagroup", datagroup)
        if device_make is not None:
            pulumi.set(__self__, "device_make", device_make)
        if device_model is not None:
            pulumi.set(__self__, "device_model", device_model)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if ends_with is not None:
            pulumi.set(__self__, "ends_with", ends_with)
        if equals is not None:
            pulumi.set(__self__, "equals", equals)
        if exists is not None:
            pulumi.set(__self__, "exists", exists)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if external is not None:
            pulumi.set(__self__, "external", external)
        if geoip is not None:
            pulumi.set(__self__, "geoip", geoip)
        if greater is not None:
            pulumi.set(__self__, "greater", greater)
        if greater_or_equal is not None:
            pulumi.set(__self__, "greater_or_equal", greater_or_equal)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if http_basic_auth is not None:
            pulumi.set(__self__, "http_basic_auth", http_basic_auth)
        if http_cookie is not None:
            pulumi.set(__self__, "http_cookie", http_cookie)
        if http_header is not None:
            pulumi.set(__self__, "http_header", http_header)
        if http_host is not None:
            pulumi.set(__self__, "http_host", http_host)
        if http_method is not None:
            pulumi.set(__self__, "http_method", http_method)
        if http_referer is not None:
            pulumi.set(__self__, "http_referer", http_referer)
        if http_set_cookie is not None:
            pulumi.set(__self__, "http_set_cookie", http_set_cookie)
        if http_status is not None:
            pulumi.set(__self__, "http_status", http_status)
        if http_uri is not None:
            pulumi.set(__self__, "http_uri", http_uri)
        if http_user_agent is not None:
            pulumi.set(__self__, "http_user_agent", http_user_agent)
        if http_version is not None:
            pulumi.set(__self__, "http_version", http_version)
        if index is not None:
            pulumi.set(__self__, "index", index)
        if internal is not None:
            pulumi.set(__self__, "internal", internal)
        if isp is not None:
            pulumi.set(__self__, "isp", isp)
        if last15secs is not None:
            pulumi.set(__self__, "last15secs", last15secs)
        if last1min is not None:
            pulumi.set(__self__, "last1min", last1min)
        if last5mins is not None:
            pulumi.set(__self__, "last5mins", last5mins)
        if less is not None:
            pulumi.set(__self__, "less", less)
        if less_or_equal is not None:
            pulumi.set(__self__, "less_or_equal", less_or_equal)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if major is not None:
            pulumi.set(__self__, "major", major)
        if matches is not None:
            pulumi.set(__self__, "matches", matches)
        if minor is not None:
            pulumi.set(__self__, "minor", minor)
        if missing is not None:
            pulumi.set(__self__, "missing", missing)
        if mss is not None:
            pulumi.set(__self__, "mss", mss)
        if not_ is not None:
            pulumi.set(__self__, "not_", not_)
        if org is not None:
            pulumi.set(__self__, "org", org)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if path_segment is not None:
            pulumi.set(__self__, "path_segment", path_segment)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if present is not None:
            pulumi.set(__self__, "present", present)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if query_parameter is not None:
            pulumi.set(__self__, "query_parameter", query_parameter)
        if query_string is not None:
            pulumi.set(__self__, "query_string", query_string)
        if region_code is not None:
            pulumi.set(__self__, "region_code", region_code)
        if region_name is not None:
            pulumi.set(__self__, "region_name", region_name)
        if remote is not None:
            pulumi.set(__self__, "remote", remote)
        if request is not None:
            pulumi.set(__self__, "request", request)
        if response is not None:
            pulumi.set(__self__, "response", response)
        if route_domain is not None:
            pulumi.set(__self__, "route_domain", route_domain)
        if rtt is not None:
            pulumi.set(__self__, "rtt", rtt)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if ssl_cert is not None:
            pulumi.set(__self__, "ssl_cert", ssl_cert)
        if ssl_client_hello is not None:
            pulumi.set(__self__, "ssl_client_hello", ssl_client_hello)
        if ssl_extension is not None:
            pulumi.set(__self__, "ssl_extension", ssl_extension)
        if ssl_server_handshake is not None:
            pulumi.set(__self__, "ssl_server_handshake", ssl_server_handshake)
        if ssl_server_hello is not None:
            pulumi.set(__self__, "ssl_server_hello", ssl_server_hello)
        if starts_with is not None:
            pulumi.set(__self__, "starts_with", starts_with)
        if tcp is not None:
            pulumi.set(__self__, "tcp", tcp)
        if text is not None:
            pulumi.set(__self__, "text", text)
        if tm_name is not None:
            pulumi.set(__self__, "tm_name", tm_name)
        if unnamed_query_parameter is not None:
            pulumi.set(__self__, "unnamed_query_parameter", unnamed_query_parameter)
        if user_agent_token is not None:
            pulumi.set(__self__, "user_agent_token", user_agent_token)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if values is not None:
            pulumi.set(__self__, "values", values)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)

    @property
    @pulumi.getter
    def address(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def all(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="appService")
    def app_service(self) -> Optional[builtins.str]:
        return pulumi.get(self, "app_service")

    @property
    @pulumi.getter(name="browserType")
    def browser_type(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "browser_type")

    @property
    @pulumi.getter(name="browserVersion")
    def browser_version(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "browser_version")

    @property
    @pulumi.getter(name="caseInsensitive")
    def case_insensitive(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "case_insensitive")

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "case_sensitive")

    @property
    @pulumi.getter
    def cipher(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "cipher")

    @property
    @pulumi.getter(name="cipherBits")
    def cipher_bits(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "cipher_bits")

    @property
    @pulumi.getter(name="clientAccepted")
    def client_accepted(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "client_accepted")

    @property
    @pulumi.getter(name="clientSsl")
    def client_ssl(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "client_ssl")

    @property
    @pulumi.getter
    def code(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter
    def contains(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "contains")

    @property
    @pulumi.getter
    def continent(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "continent")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter(name="countryName")
    def country_name(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "country_name")

    @property
    @pulumi.getter(name="cpuUsage")
    def cpu_usage(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "cpu_usage")

    @property
    @pulumi.getter
    def datagroup(self) -> Optional[builtins.str]:
        return pulumi.get(self, "datagroup")

    @property
    @pulumi.getter(name="deviceMake")
    def device_make(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "device_make")

    @property
    @pulumi.getter(name="deviceModel")
    def device_model(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "device_model")

    @property
    @pulumi.getter
    def domain(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="endsWith")
    def ends_with(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "ends_with")

    @property
    @pulumi.getter
    def equals(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "equals")

    @property
    @pulumi.getter
    def exists(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "exists")

    @property
    @pulumi.getter
    def expiry(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter
    def extension(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "extension")

    @property
    @pulumi.getter
    def external(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "external")

    @property
    @pulumi.getter
    def geoip(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "geoip")

    @property
    @pulumi.getter
    def greater(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "greater")

    @property
    @pulumi.getter(name="greaterOrEqual")
    def greater_or_equal(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "greater_or_equal")

    @property
    @pulumi.getter
    def host(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="httpBasicAuth")
    def http_basic_auth(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "http_basic_auth")

    @property
    @pulumi.getter(name="httpCookie")
    def http_cookie(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "http_cookie")

    @property
    @pulumi.getter(name="httpHeader")
    def http_header(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "http_header")

    @property
    @pulumi.getter(name="httpHost")
    def http_host(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "http_host")

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "http_method")

    @property
    @pulumi.getter(name="httpReferer")
    def http_referer(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "http_referer")

    @property
    @pulumi.getter(name="httpSetCookie")
    def http_set_cookie(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "http_set_cookie")

    @property
    @pulumi.getter(name="httpStatus")
    def http_status(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "http_status")

    @property
    @pulumi.getter(name="httpUri")
    def http_uri(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "http_uri")

    @property
    @pulumi.getter(name="httpUserAgent")
    def http_user_agent(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "http_user_agent")

    @property
    @pulumi.getter(name="httpVersion")
    def http_version(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "http_version")

    @property
    @pulumi.getter
    def index(self) -> Optional[builtins.int]:
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def internal(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "internal")

    @property
    @pulumi.getter
    def isp(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "isp")

    @property
    @pulumi.getter
    def last15secs(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "last15secs")

    @property
    @pulumi.getter
    def last1min(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "last1min")

    @property
    @pulumi.getter
    def last5mins(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "last5mins")

    @property
    @pulumi.getter
    def less(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "less")

    @property
    @pulumi.getter(name="lessOrEqual")
    def less_or_equal(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "less_or_equal")

    @property
    @pulumi.getter
    def local(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "local")

    @property
    @pulumi.getter
    def major(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "major")

    @property
    @pulumi.getter
    def matches(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "matches")

    @property
    @pulumi.getter
    def minor(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "minor")

    @property
    @pulumi.getter
    def missing(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "missing")

    @property
    @pulumi.getter
    def mss(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "mss")

    @property
    @pulumi.getter(name="not")
    def not_(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "not_")

    @property
    @pulumi.getter
    def org(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "org")

    @property
    @pulumi.getter
    def password(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="pathSegment")
    def path_segment(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "path_segment")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def present(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "present")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="queryParameter")
    def query_parameter(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "query_parameter")

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "query_string")

    @property
    @pulumi.getter(name="regionCode")
    def region_code(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "region_code")

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "region_name")

    @property
    @pulumi.getter
    def remote(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "remote")

    @property
    @pulumi.getter
    def request(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "request")

    @property
    @pulumi.getter
    def response(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "response")

    @property
    @pulumi.getter(name="routeDomain")
    def route_domain(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "route_domain")

    @property
    @pulumi.getter
    def rtt(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "rtt")

    @property
    @pulumi.getter
    def scheme(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "scheme")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="sslCert")
    def ssl_cert(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "ssl_cert")

    @property
    @pulumi.getter(name="sslClientHello")
    def ssl_client_hello(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "ssl_client_hello")

    @property
    @pulumi.getter(name="sslExtension")
    def ssl_extension(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "ssl_extension")

    @property
    @pulumi.getter(name="sslServerHandshake")
    def ssl_server_handshake(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "ssl_server_handshake")

    @property
    @pulumi.getter(name="sslServerHello")
    def ssl_server_hello(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "ssl_server_hello")

    @property
    @pulumi.getter(name="startsWith")
    def starts_with(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "starts_with")

    @property
    @pulumi.getter
    def tcp(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "tcp")

    @property
    @pulumi.getter
    def text(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "text")

    @property
    @pulumi.getter(name="tmName")
    def tm_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "tm_name")

    @property
    @pulumi.getter(name="unnamedQueryParameter")
    def unnamed_query_parameter(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "unnamed_query_parameter")

    @property
    @pulumi.getter(name="userAgentToken")
    def user_agent_token(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "user_agent_token")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def vlan(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "vlan")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "vlan_id")


@pulumi.output_type
class ProfileClientSslCertKeyChain(dict):
    def __init__(__self__, *,
                 cert: Optional[builtins.str] = None,
                 chain: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 passphrase: Optional[builtins.str] = None):
        """
        :param builtins.str cert: Specifies the name of the certificate that the system uses for client-side SSL processing. The default is `default`
        :param builtins.str chain: Specifies a certificate chain file that a server can use for authentication. The default is `None`.
        :param builtins.str key: Specifies the file name of the SSL key. The default is `default`
        :param builtins.str name: Name of Cert-key-chain
        :param builtins.str passphrase: Type the name of the pass phrase used to encrypt the key.
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if chain is not None:
            pulumi.set(__self__, "chain", chain)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if passphrase is not None:
            pulumi.set(__self__, "passphrase", passphrase)

    @property
    @pulumi.getter
    def cert(self) -> Optional[builtins.str]:
        """
        Specifies the name of the certificate that the system uses for client-side SSL processing. The default is `default`
        """
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter
    def chain(self) -> Optional[builtins.str]:
        """
        Specifies a certificate chain file that a server can use for authentication. The default is `None`.
        """
        return pulumi.get(self, "chain")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        Specifies the file name of the SSL key. The default is `default`
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of Cert-key-chain
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def passphrase(self) -> Optional[builtins.str]:
        """
        Type the name of the pass phrase used to encrypt the key.
        """
        return pulumi.get(self, "passphrase")


@pulumi.output_type
class ProfileHttpEnforcement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "knownMethods":
            suggest = "known_methods"
        elif key == "maxHeaderCount":
            suggest = "max_header_count"
        elif key == "maxHeaderSize":
            suggest = "max_header_size"
        elif key == "unknownMethod":
            suggest = "unknown_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProfileHttpEnforcement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProfileHttpEnforcement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProfileHttpEnforcement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 known_methods: Optional[Sequence[builtins.str]] = None,
                 max_header_count: Optional[builtins.int] = None,
                 max_header_size: Optional[builtins.int] = None,
                 unknown_method: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] known_methods: Specifies which HTTP methods count as being known. Removing RFC-defined methods from this list will cause the HTTP filter to not recognize them. Default value is [CONNECT DELETE GET HEAD LOCK OPTIONS POST PROPFIND PUT TRACE UNLOCK].If no value is specified while creating, then default value will be assigned by BigIP. In order to remove it, [""] list is to be passed. If known_methods is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value , we need to pass [CONNECT DELETE GET HEAD LOCK OPTIONS POST PROPFIND PUT TRACE UNLOCK] explicitly.
        :param builtins.int max_header_count: Specifies the maximum number of headers allowed in HTTP request/response. The default is 64 headers.If no value is specified while creating, then default value will be assigned by BigIP. If max_header_count is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "64" explicitly.
        :param builtins.int max_header_size: Specifies the maximum header size. The default value is 32768. If no string is specified while creating, then default value will be assigned by BigIP. If max_header_size is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "32768" explicitly.
        :param builtins.str unknown_method: Specifies whether to allow, reject or switch to pass-through mode when an unknown HTTP method is parsed. Default value is "allow". If no string is specified while creating, then default value will be assigned by BigIP. If unknown_method is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "allow" explicitly.
        """
        if known_methods is not None:
            pulumi.set(__self__, "known_methods", known_methods)
        if max_header_count is not None:
            pulumi.set(__self__, "max_header_count", max_header_count)
        if max_header_size is not None:
            pulumi.set(__self__, "max_header_size", max_header_size)
        if unknown_method is not None:
            pulumi.set(__self__, "unknown_method", unknown_method)

    @property
    @pulumi.getter(name="knownMethods")
    def known_methods(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies which HTTP methods count as being known. Removing RFC-defined methods from this list will cause the HTTP filter to not recognize them. Default value is [CONNECT DELETE GET HEAD LOCK OPTIONS POST PROPFIND PUT TRACE UNLOCK].If no value is specified while creating, then default value will be assigned by BigIP. In order to remove it, [""] list is to be passed. If known_methods is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value , we need to pass [CONNECT DELETE GET HEAD LOCK OPTIONS POST PROPFIND PUT TRACE UNLOCK] explicitly.
        """
        return pulumi.get(self, "known_methods")

    @property
    @pulumi.getter(name="maxHeaderCount")
    def max_header_count(self) -> Optional[builtins.int]:
        """
        Specifies the maximum number of headers allowed in HTTP request/response. The default is 64 headers.If no value is specified while creating, then default value will be assigned by BigIP. If max_header_count is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "64" explicitly.
        """
        return pulumi.get(self, "max_header_count")

    @property
    @pulumi.getter(name="maxHeaderSize")
    def max_header_size(self) -> Optional[builtins.int]:
        """
        Specifies the maximum header size. The default value is 32768. If no string is specified while creating, then default value will be assigned by BigIP. If max_header_size is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "32768" explicitly.
        """
        return pulumi.get(self, "max_header_size")

    @property
    @pulumi.getter(name="unknownMethod")
    def unknown_method(self) -> Optional[builtins.str]:
        """
        Specifies whether to allow, reject or switch to pass-through mode when an unknown HTTP method is parsed. Default value is "allow". If no string is specified while creating, then default value will be assigned by BigIP. If unknown_method is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "allow" explicitly.
        """
        return pulumi.get(self, "unknown_method")


@pulumi.output_type
class ProfileHttpHttpStrictTransportSecurity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeSubdomains":
            suggest = "include_subdomains"
        elif key == "maximumAge":
            suggest = "maximum_age"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProfileHttpHttpStrictTransportSecurity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProfileHttpHttpStrictTransportSecurity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProfileHttpHttpStrictTransportSecurity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 include_subdomains: Optional[builtins.str] = None,
                 maximum_age: Optional[builtins.int] = None,
                 mode: Optional[builtins.str] = None,
                 preload: Optional[builtins.str] = None):
        """
        :param builtins.str include_subdomains: The Include Subdomains setting applies the HSTS policy to the HSTS host and its subdomains. The default is "enabled". If no string is specified during Create, then default value will be assigned by BigIp. If include_subdomains is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "enabled" explicitly.
        :param builtins.int maximum_age: The Maximum Age value specifies the length of time, in seconds, that HSTS functionality requests that clients only use HTTPS to connect to the current host and any subdomains of the current host's domain name.  The default is 16070400 seconds. If no value is specified during Create, then default value will be assigned by BigIp. If maximum_age is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value , we need to pass 16070400 explicitly.
        :param builtins.str mode: The Mode setting enables and disables HSTS functionality within the HTTP profile. The default is "disabled". If no string is specified during Create, then default value will be assigned by BigIp. If mode is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "disabled" explicitly.
        :param builtins.str preload: An HSTS preload list is a list of domains built into a web browser. When you enable the Preload setting, the domain for the web site that this HTTP profile is associated with is submitted for inclusion in the browser's preload list. The default is "disabled". If no string is specified during Create, then default value will be assigned by BigIp. If preload is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "disabled" explicitly.
        """
        if include_subdomains is not None:
            pulumi.set(__self__, "include_subdomains", include_subdomains)
        if maximum_age is not None:
            pulumi.set(__self__, "maximum_age", maximum_age)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if preload is not None:
            pulumi.set(__self__, "preload", preload)

    @property
    @pulumi.getter(name="includeSubdomains")
    def include_subdomains(self) -> Optional[builtins.str]:
        """
        The Include Subdomains setting applies the HSTS policy to the HSTS host and its subdomains. The default is "enabled". If no string is specified during Create, then default value will be assigned by BigIp. If include_subdomains is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "enabled" explicitly.
        """
        return pulumi.get(self, "include_subdomains")

    @property
    @pulumi.getter(name="maximumAge")
    def maximum_age(self) -> Optional[builtins.int]:
        """
        The Maximum Age value specifies the length of time, in seconds, that HSTS functionality requests that clients only use HTTPS to connect to the current host and any subdomains of the current host's domain name.  The default is 16070400 seconds. If no value is specified during Create, then default value will be assigned by BigIp. If maximum_age is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value , we need to pass 16070400 explicitly.
        """
        return pulumi.get(self, "maximum_age")

    @property
    @pulumi.getter
    def mode(self) -> Optional[builtins.str]:
        """
        The Mode setting enables and disables HSTS functionality within the HTTP profile. The default is "disabled". If no string is specified during Create, then default value will be assigned by BigIp. If mode is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "disabled" explicitly.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def preload(self) -> Optional[builtins.str]:
        """
        An HSTS preload list is a list of domains built into a web browser. When you enable the Preload setting, the domain for the web site that this HTTP profile is associated with is submitted for inclusion in the browser's preload list. The default is "disabled". If no string is specified during Create, then default value will be assigned by BigIp. If preload is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "disabled" explicitly.
        """
        return pulumi.get(self, "preload")


@pulumi.output_type
class ProfileRewriteCookieRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientDomain":
            suggest = "client_domain"
        elif key == "clientPath":
            suggest = "client_path"
        elif key == "ruleName":
            suggest = "rule_name"
        elif key == "serverDomain":
            suggest = "server_domain"
        elif key == "serverPath":
            suggest = "server_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProfileRewriteCookieRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProfileRewriteCookieRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProfileRewriteCookieRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_domain: builtins.str,
                 client_path: builtins.str,
                 rule_name: builtins.str,
                 server_domain: builtins.str,
                 server_path: builtins.str):
        """
        :param builtins.str rule_name: Name of the cookie rewrite rule.
        """
        pulumi.set(__self__, "client_domain", client_domain)
        pulumi.set(__self__, "client_path", client_path)
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "server_domain", server_domain)
        pulumi.set(__self__, "server_path", server_path)

    @property
    @pulumi.getter(name="clientDomain")
    def client_domain(self) -> builtins.str:
        return pulumi.get(self, "client_domain")

    @property
    @pulumi.getter(name="clientPath")
    def client_path(self) -> builtins.str:
        return pulumi.get(self, "client_path")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> builtins.str:
        """
        Name of the cookie rewrite rule.
        """
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter(name="serverDomain")
    def server_domain(self) -> builtins.str:
        return pulumi.get(self, "server_domain")

    @property
    @pulumi.getter(name="serverPath")
    def server_path(self) -> builtins.str:
        return pulumi.get(self, "server_path")


@pulumi.output_type
class ProfileRewriteRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "insertXfwdFor":
            suggest = "insert_xfwd_for"
        elif key == "insertXfwdHost":
            suggest = "insert_xfwd_host"
        elif key == "insertXfwdProtocol":
            suggest = "insert_xfwd_protocol"
        elif key == "rewriteHeaders":
            suggest = "rewrite_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProfileRewriteRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProfileRewriteRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProfileRewriteRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 insert_xfwd_for: Optional[builtins.str] = None,
                 insert_xfwd_host: Optional[builtins.str] = None,
                 insert_xfwd_protocol: Optional[builtins.str] = None,
                 rewrite_headers: Optional[builtins.str] = None):
        """
        :param builtins.str insert_xfwd_for: Enable to add the X-Forwarded For (XFF) header, to specify the originating IP address of the client. Valid choices are: `enabled, disabled`
        :param builtins.str insert_xfwd_host: Enable to add the X-Forwarded Host header, to specify the originating host of the client. Valid choices are: `enabled, disabled`
        :param builtins.str insert_xfwd_protocol: Enable to add the X-Forwarded Proto header, to specify the originating protocol of the client. Valid choices are: `enabled, disabled`
        :param builtins.str rewrite_headers: Enable to rewrite headers in Request settings. Valid choices are: `enabled, disabled`
        """
        if insert_xfwd_for is not None:
            pulumi.set(__self__, "insert_xfwd_for", insert_xfwd_for)
        if insert_xfwd_host is not None:
            pulumi.set(__self__, "insert_xfwd_host", insert_xfwd_host)
        if insert_xfwd_protocol is not None:
            pulumi.set(__self__, "insert_xfwd_protocol", insert_xfwd_protocol)
        if rewrite_headers is not None:
            pulumi.set(__self__, "rewrite_headers", rewrite_headers)

    @property
    @pulumi.getter(name="insertXfwdFor")
    def insert_xfwd_for(self) -> Optional[builtins.str]:
        """
        Enable to add the X-Forwarded For (XFF) header, to specify the originating IP address of the client. Valid choices are: `enabled, disabled`
        """
        return pulumi.get(self, "insert_xfwd_for")

    @property
    @pulumi.getter(name="insertXfwdHost")
    def insert_xfwd_host(self) -> Optional[builtins.str]:
        """
        Enable to add the X-Forwarded Host header, to specify the originating host of the client. Valid choices are: `enabled, disabled`
        """
        return pulumi.get(self, "insert_xfwd_host")

    @property
    @pulumi.getter(name="insertXfwdProtocol")
    def insert_xfwd_protocol(self) -> Optional[builtins.str]:
        """
        Enable to add the X-Forwarded Proto header, to specify the originating protocol of the client. Valid choices are: `enabled, disabled`
        """
        return pulumi.get(self, "insert_xfwd_protocol")

    @property
    @pulumi.getter(name="rewriteHeaders")
    def rewrite_headers(self) -> Optional[builtins.str]:
        """
        Enable to rewrite headers in Request settings. Valid choices are: `enabled, disabled`
        """
        return pulumi.get(self, "rewrite_headers")


@pulumi.output_type
class ProfileRewriteResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rewriteContent":
            suggest = "rewrite_content"
        elif key == "rewriteHeaders":
            suggest = "rewrite_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProfileRewriteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProfileRewriteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProfileRewriteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rewrite_content: Optional[builtins.str] = None,
                 rewrite_headers: Optional[builtins.str] = None):
        """
        :param builtins.str rewrite_content: Enable to rewrite links in content in the response. Valid choices are: `enabled, disabled`
        :param builtins.str rewrite_headers: Enable to rewrite headers in the response. Valid choices are: `enabled, disabled`
        """
        if rewrite_content is not None:
            pulumi.set(__self__, "rewrite_content", rewrite_content)
        if rewrite_headers is not None:
            pulumi.set(__self__, "rewrite_headers", rewrite_headers)

    @property
    @pulumi.getter(name="rewriteContent")
    def rewrite_content(self) -> Optional[builtins.str]:
        """
        Enable to rewrite links in content in the response. Valid choices are: `enabled, disabled`
        """
        return pulumi.get(self, "rewrite_content")

    @property
    @pulumi.getter(name="rewriteHeaders")
    def rewrite_headers(self) -> Optional[builtins.str]:
        """
        Enable to rewrite headers in the response. Valid choices are: `enabled, disabled`
        """
        return pulumi.get(self, "rewrite_headers")


@pulumi.output_type
class ProfileRewriteUriRulesClient(dict):
    def __init__(__self__, *,
                 host: builtins.str,
                 scheme: builtins.str,
                 path: Optional[builtins.str] = None,
                 port: Optional[builtins.str] = None):
        """
        :param builtins.str host: Host part of the uri, e.g. `www.foo.com`.
        :param builtins.str scheme: Scheme part of the uri, e.g. `https`, `ftp`.
        :param builtins.str path: Path part of the uri, must always end with `/`. Default value is: `/`
        :param builtins.str port: Port part of the uri. Default value is: `none`
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "scheme", scheme)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def host(self) -> builtins.str:
        """
        Host part of the uri, e.g. `www.foo.com`.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def scheme(self) -> builtins.str:
        """
        Scheme part of the uri, e.g. `https`, `ftp`.
        """
        return pulumi.get(self, "scheme")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        Path part of the uri, must always end with `/`. Default value is: `/`
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.str]:
        """
        Port part of the uri. Default value is: `none`
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ProfileRewriteUriRulesServer(dict):
    def __init__(__self__, *,
                 host: builtins.str,
                 scheme: builtins.str,
                 path: Optional[builtins.str] = None,
                 port: Optional[builtins.str] = None):
        """
        :param builtins.str host: Host part of the uri, e.g. `www.foo.com`.
        :param builtins.str scheme: Scheme part of the uri, e.g. `https`, `ftp`.
        :param builtins.str path: Path part of the uri, must always end with `/`. Default value is: `/`
        :param builtins.str port: Port part of the uri. Default value is: `none`
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "scheme", scheme)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def host(self) -> builtins.str:
        """
        Host part of the uri, e.g. `www.foo.com`.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def scheme(self) -> builtins.str:
        """
        Scheme part of the uri, e.g. `https`, `ftp`.
        """
        return pulumi.get(self, "scheme")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        Path part of the uri, must always end with `/`. Default value is: `/`
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.str]:
        """
        Port part of the uri. Default value is: `none`
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class SnatOrigin(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appService":
            suggest = "app_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SnatOrigin. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SnatOrigin.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SnatOrigin.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_service: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str app_service: app service
        :param builtins.str name: Name of the SNAT, name of SNAT should be full path. Full path is the combination of the `partition + SNAT name`,For example `/Common/test-snat`.
        """
        if app_service is not None:
            pulumi.set(__self__, "app_service", app_service)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="appService")
    def app_service(self) -> Optional[builtins.str]:
        """
        app service
        """
        return pulumi.get(self, "app_service")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the SNAT, name of SNAT should be full path. Full path is the combination of the `partition + SNAT name`,For example `/Common/test-snat`.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetDataGroupRecordResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 data: Optional[builtins.str] = None):
        """
        :param builtins.str name: Name of the datagroup
        """
        pulumi.set(__self__, "name", name)
        if data is not None:
            pulumi.set(__self__, "data", data)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the datagroup
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def data(self) -> Optional[builtins.str]:
        return pulumi.get(self, "data")


@pulumi.output_type
class GetNodeFqdnResult(dict):
    def __init__(__self__, *,
                 autopopulate: builtins.str,
                 downinterval: builtins.int,
                 interval: builtins.str,
                 address_family: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str autopopulate: Specifies if the node should scale to the IP address set returned by DNS.
        :param builtins.int downinterval: The number of attempts to resolve a domain name.
        :param builtins.str interval: The amount of time before sending the next DNS query.
        :param builtins.str address_family: The FQDN node's address family.
        :param builtins.str name: Name of the node.
        """
        pulumi.set(__self__, "autopopulate", autopopulate)
        pulumi.set(__self__, "downinterval", downinterval)
        pulumi.set(__self__, "interval", interval)
        if address_family is not None:
            pulumi.set(__self__, "address_family", address_family)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def autopopulate(self) -> builtins.str:
        """
        Specifies if the node should scale to the IP address set returned by DNS.
        """
        return pulumi.get(self, "autopopulate")

    @property
    @pulumi.getter
    def downinterval(self) -> builtins.int:
        """
        The number of attempts to resolve a domain name.
        """
        return pulumi.get(self, "downinterval")

    @property
    @pulumi.getter
    def interval(self) -> builtins.str:
        """
        The amount of time before sending the next DNS query.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="addressFamily")
    def address_family(self) -> Optional[builtins.str]:
        """
        The FQDN node's address family.
        """
        return pulumi.get(self, "address_family")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the node.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetPolicyRuleResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 actions: Optional[Sequence['outputs.GetPolicyRuleActionResult']] = None,
                 conditions: Optional[Sequence['outputs.GetPolicyRuleConditionResult']] = None):
        """
        :param builtins.str name: Name of the policy which includes partion ( /partition/policy-name )
        """
        pulumi.set(__self__, "name", name)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the policy which includes partion ( /partition/policy-name )
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def actions(self) -> Optional[Sequence['outputs.GetPolicyRuleActionResult']]:
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.GetPolicyRuleConditionResult']]:
        return pulumi.get(self, "conditions")


@pulumi.output_type
class GetPolicyRuleActionResult(dict):
    def __init__(__self__, *,
                 app_service: builtins.str,
                 application: builtins.str,
                 asm: builtins.bool,
                 avr: builtins.bool,
                 cache: builtins.bool,
                 carp: builtins.bool,
                 category: builtins.str,
                 classify: builtins.bool,
                 clone_pool: builtins.str,
                 code: builtins.int,
                 compress: builtins.bool,
                 connection: builtins.bool,
                 content: builtins.str,
                 cookie_hash: builtins.bool,
                 cookie_insert: builtins.bool,
                 cookie_passive: builtins.bool,
                 cookie_rewrite: builtins.bool,
                 decompress: builtins.bool,
                 defer: builtins.bool,
                 destination_address: builtins.bool,
                 disable: builtins.bool,
                 domain: builtins.str,
                 enable: builtins.bool,
                 expiry: builtins.str,
                 expiry_secs: builtins.int,
                 expression: builtins.str,
                 extension: builtins.str,
                 facility: builtins.str,
                 from_profile: builtins.str,
                 hash: builtins.bool,
                 host: builtins.str,
                 http: builtins.bool,
                 http_basic_auth: builtins.bool,
                 http_cookie: builtins.bool,
                 http_header: builtins.bool,
                 http_referer: builtins.bool,
                 http_reply: builtins.bool,
                 http_set_cookie: builtins.bool,
                 http_uri: builtins.bool,
                 ifile: builtins.str,
                 insert: builtins.bool,
                 internal_virtual: builtins.str,
                 ip_address: builtins.str,
                 key: builtins.str,
                 l7dos: builtins.bool,
                 length: builtins.int,
                 location: builtins.str,
                 log: builtins.bool,
                 ltm_policy: builtins.bool,
                 member: builtins.str,
                 message: builtins.str,
                 netmask: builtins.str,
                 nexthop: builtins.str,
                 node: builtins.str,
                 offset: builtins.int,
                 path: builtins.str,
                 pem: builtins.bool,
                 persist: builtins.bool,
                 pin: builtins.bool,
                 policy: builtins.str,
                 pool: builtins.str,
                 port: builtins.int,
                 priority: builtins.str,
                 profile: builtins.str,
                 protocol: builtins.str,
                 query_string: builtins.str,
                 rateclass: builtins.str,
                 redirect: builtins.bool,
                 remove: builtins.bool,
                 replace: builtins.bool,
                 request: builtins.bool,
                 request_adapt: builtins.bool,
                 reset: builtins.bool,
                 response: builtins.bool,
                 response_adapt: builtins.bool,
                 scheme: builtins.str,
                 script: builtins.str,
                 select: builtins.bool,
                 server_ssl: builtins.bool,
                 set_variable: builtins.bool,
                 shutdown: builtins.bool,
                 snat: builtins.str,
                 snatpool: builtins.str,
                 source_address: builtins.bool,
                 ssl_client_hello: builtins.bool,
                 ssl_server_handshake: builtins.bool,
                 ssl_server_hello: builtins.bool,
                 ssl_session_id: builtins.bool,
                 status: builtins.int,
                 tcl: builtins.bool,
                 tcp_nagle: builtins.bool,
                 text: builtins.str,
                 timeout: builtins.int,
                 tm_name: builtins.str,
                 uie: builtins.bool,
                 universal: builtins.bool,
                 value: builtins.str,
                 virtual: builtins.str,
                 vlan: builtins.str,
                 vlan_id: builtins.int,
                 wam: builtins.bool,
                 write: builtins.bool,
                 forward: Optional[builtins.bool] = None,
                 http_host: Optional[builtins.bool] = None):
        pulumi.set(__self__, "app_service", app_service)
        pulumi.set(__self__, "application", application)
        pulumi.set(__self__, "asm", asm)
        pulumi.set(__self__, "avr", avr)
        pulumi.set(__self__, "cache", cache)
        pulumi.set(__self__, "carp", carp)
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "classify", classify)
        pulumi.set(__self__, "clone_pool", clone_pool)
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "compress", compress)
        pulumi.set(__self__, "connection", connection)
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "cookie_hash", cookie_hash)
        pulumi.set(__self__, "cookie_insert", cookie_insert)
        pulumi.set(__self__, "cookie_passive", cookie_passive)
        pulumi.set(__self__, "cookie_rewrite", cookie_rewrite)
        pulumi.set(__self__, "decompress", decompress)
        pulumi.set(__self__, "defer", defer)
        pulumi.set(__self__, "destination_address", destination_address)
        pulumi.set(__self__, "disable", disable)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "expiry", expiry)
        pulumi.set(__self__, "expiry_secs", expiry_secs)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "extension", extension)
        pulumi.set(__self__, "facility", facility)
        pulumi.set(__self__, "from_profile", from_profile)
        pulumi.set(__self__, "hash", hash)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "http", http)
        pulumi.set(__self__, "http_basic_auth", http_basic_auth)
        pulumi.set(__self__, "http_cookie", http_cookie)
        pulumi.set(__self__, "http_header", http_header)
        pulumi.set(__self__, "http_referer", http_referer)
        pulumi.set(__self__, "http_reply", http_reply)
        pulumi.set(__self__, "http_set_cookie", http_set_cookie)
        pulumi.set(__self__, "http_uri", http_uri)
        pulumi.set(__self__, "ifile", ifile)
        pulumi.set(__self__, "insert", insert)
        pulumi.set(__self__, "internal_virtual", internal_virtual)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "l7dos", l7dos)
        pulumi.set(__self__, "length", length)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "log", log)
        pulumi.set(__self__, "ltm_policy", ltm_policy)
        pulumi.set(__self__, "member", member)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "netmask", netmask)
        pulumi.set(__self__, "nexthop", nexthop)
        pulumi.set(__self__, "node", node)
        pulumi.set(__self__, "offset", offset)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "pem", pem)
        pulumi.set(__self__, "persist", persist)
        pulumi.set(__self__, "pin", pin)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "pool", pool)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "profile", profile)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "query_string", query_string)
        pulumi.set(__self__, "rateclass", rateclass)
        pulumi.set(__self__, "redirect", redirect)
        pulumi.set(__self__, "remove", remove)
        pulumi.set(__self__, "replace", replace)
        pulumi.set(__self__, "request", request)
        pulumi.set(__self__, "request_adapt", request_adapt)
        pulumi.set(__self__, "reset", reset)
        pulumi.set(__self__, "response", response)
        pulumi.set(__self__, "response_adapt", response_adapt)
        pulumi.set(__self__, "scheme", scheme)
        pulumi.set(__self__, "script", script)
        pulumi.set(__self__, "select", select)
        pulumi.set(__self__, "server_ssl", server_ssl)
        pulumi.set(__self__, "set_variable", set_variable)
        pulumi.set(__self__, "shutdown", shutdown)
        pulumi.set(__self__, "snat", snat)
        pulumi.set(__self__, "snatpool", snatpool)
        pulumi.set(__self__, "source_address", source_address)
        pulumi.set(__self__, "ssl_client_hello", ssl_client_hello)
        pulumi.set(__self__, "ssl_server_handshake", ssl_server_handshake)
        pulumi.set(__self__, "ssl_server_hello", ssl_server_hello)
        pulumi.set(__self__, "ssl_session_id", ssl_session_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tcl", tcl)
        pulumi.set(__self__, "tcp_nagle", tcp_nagle)
        pulumi.set(__self__, "text", text)
        pulumi.set(__self__, "timeout", timeout)
        pulumi.set(__self__, "tm_name", tm_name)
        pulumi.set(__self__, "uie", uie)
        pulumi.set(__self__, "universal", universal)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "virtual", virtual)
        pulumi.set(__self__, "vlan", vlan)
        pulumi.set(__self__, "vlan_id", vlan_id)
        pulumi.set(__self__, "wam", wam)
        pulumi.set(__self__, "write", write)
        if forward is not None:
            pulumi.set(__self__, "forward", forward)
        if http_host is not None:
            pulumi.set(__self__, "http_host", http_host)

    @property
    @pulumi.getter(name="appService")
    def app_service(self) -> builtins.str:
        return pulumi.get(self, "app_service")

    @property
    @pulumi.getter
    def application(self) -> builtins.str:
        return pulumi.get(self, "application")

    @property
    @pulumi.getter
    def asm(self) -> builtins.bool:
        return pulumi.get(self, "asm")

    @property
    @pulumi.getter
    def avr(self) -> builtins.bool:
        return pulumi.get(self, "avr")

    @property
    @pulumi.getter
    def cache(self) -> builtins.bool:
        return pulumi.get(self, "cache")

    @property
    @pulumi.getter
    def carp(self) -> builtins.bool:
        return pulumi.get(self, "carp")

    @property
    @pulumi.getter
    def category(self) -> builtins.str:
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def classify(self) -> builtins.bool:
        return pulumi.get(self, "classify")

    @property
    @pulumi.getter(name="clonePool")
    def clone_pool(self) -> builtins.str:
        return pulumi.get(self, "clone_pool")

    @property
    @pulumi.getter
    def code(self) -> builtins.int:
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def compress(self) -> builtins.bool:
        return pulumi.get(self, "compress")

    @property
    @pulumi.getter
    def connection(self) -> builtins.bool:
        return pulumi.get(self, "connection")

    @property
    @pulumi.getter
    def content(self) -> builtins.str:
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="cookieHash")
    def cookie_hash(self) -> builtins.bool:
        return pulumi.get(self, "cookie_hash")

    @property
    @pulumi.getter(name="cookieInsert")
    def cookie_insert(self) -> builtins.bool:
        return pulumi.get(self, "cookie_insert")

    @property
    @pulumi.getter(name="cookiePassive")
    def cookie_passive(self) -> builtins.bool:
        return pulumi.get(self, "cookie_passive")

    @property
    @pulumi.getter(name="cookieRewrite")
    def cookie_rewrite(self) -> builtins.bool:
        return pulumi.get(self, "cookie_rewrite")

    @property
    @pulumi.getter
    def decompress(self) -> builtins.bool:
        return pulumi.get(self, "decompress")

    @property
    @pulumi.getter
    def defer(self) -> builtins.bool:
        return pulumi.get(self, "defer")

    @property
    @pulumi.getter(name="destinationAddress")
    def destination_address(self) -> builtins.bool:
        return pulumi.get(self, "destination_address")

    @property
    @pulumi.getter
    def disable(self) -> builtins.bool:
        return pulumi.get(self, "disable")

    @property
    @pulumi.getter
    def domain(self) -> builtins.str:
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def enable(self) -> builtins.bool:
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def expiry(self) -> builtins.str:
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter(name="expirySecs")
    def expiry_secs(self) -> builtins.int:
        return pulumi.get(self, "expiry_secs")

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def extension(self) -> builtins.str:
        return pulumi.get(self, "extension")

    @property
    @pulumi.getter
    def facility(self) -> builtins.str:
        return pulumi.get(self, "facility")

    @property
    @pulumi.getter(name="fromProfile")
    def from_profile(self) -> builtins.str:
        return pulumi.get(self, "from_profile")

    @property
    @pulumi.getter
    def hash(self) -> builtins.bool:
        return pulumi.get(self, "hash")

    @property
    @pulumi.getter
    def host(self) -> builtins.str:
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def http(self) -> builtins.bool:
        return pulumi.get(self, "http")

    @property
    @pulumi.getter(name="httpBasicAuth")
    def http_basic_auth(self) -> builtins.bool:
        return pulumi.get(self, "http_basic_auth")

    @property
    @pulumi.getter(name="httpCookie")
    def http_cookie(self) -> builtins.bool:
        return pulumi.get(self, "http_cookie")

    @property
    @pulumi.getter(name="httpHeader")
    def http_header(self) -> builtins.bool:
        return pulumi.get(self, "http_header")

    @property
    @pulumi.getter(name="httpReferer")
    def http_referer(self) -> builtins.bool:
        return pulumi.get(self, "http_referer")

    @property
    @pulumi.getter(name="httpReply")
    def http_reply(self) -> builtins.bool:
        return pulumi.get(self, "http_reply")

    @property
    @pulumi.getter(name="httpSetCookie")
    def http_set_cookie(self) -> builtins.bool:
        return pulumi.get(self, "http_set_cookie")

    @property
    @pulumi.getter(name="httpUri")
    def http_uri(self) -> builtins.bool:
        return pulumi.get(self, "http_uri")

    @property
    @pulumi.getter
    def ifile(self) -> builtins.str:
        return pulumi.get(self, "ifile")

    @property
    @pulumi.getter
    def insert(self) -> builtins.bool:
        return pulumi.get(self, "insert")

    @property
    @pulumi.getter(name="internalVirtual")
    def internal_virtual(self) -> builtins.str:
        return pulumi.get(self, "internal_virtual")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> builtins.str:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def l7dos(self) -> builtins.bool:
        return pulumi.get(self, "l7dos")

    @property
    @pulumi.getter
    def length(self) -> builtins.int:
        return pulumi.get(self, "length")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def log(self) -> builtins.bool:
        return pulumi.get(self, "log")

    @property
    @pulumi.getter(name="ltmPolicy")
    def ltm_policy(self) -> builtins.bool:
        return pulumi.get(self, "ltm_policy")

    @property
    @pulumi.getter
    def member(self) -> builtins.str:
        return pulumi.get(self, "member")

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def netmask(self) -> builtins.str:
        return pulumi.get(self, "netmask")

    @property
    @pulumi.getter
    def nexthop(self) -> builtins.str:
        return pulumi.get(self, "nexthop")

    @property
    @pulumi.getter
    def node(self) -> builtins.str:
        return pulumi.get(self, "node")

    @property
    @pulumi.getter
    def offset(self) -> builtins.int:
        return pulumi.get(self, "offset")

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def pem(self) -> builtins.bool:
        return pulumi.get(self, "pem")

    @property
    @pulumi.getter
    def persist(self) -> builtins.bool:
        return pulumi.get(self, "persist")

    @property
    @pulumi.getter
    def pin(self) -> builtins.bool:
        return pulumi.get(self, "pin")

    @property
    @pulumi.getter
    def policy(self) -> builtins.str:
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def pool(self) -> builtins.str:
        return pulumi.get(self, "pool")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def priority(self) -> builtins.str:
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def profile(self) -> builtins.str:
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter
    def protocol(self) -> builtins.str:
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> builtins.str:
        return pulumi.get(self, "query_string")

    @property
    @pulumi.getter
    def rateclass(self) -> builtins.str:
        return pulumi.get(self, "rateclass")

    @property
    @pulumi.getter
    def redirect(self) -> builtins.bool:
        return pulumi.get(self, "redirect")

    @property
    @pulumi.getter
    def remove(self) -> builtins.bool:
        return pulumi.get(self, "remove")

    @property
    @pulumi.getter
    def replace(self) -> builtins.bool:
        return pulumi.get(self, "replace")

    @property
    @pulumi.getter
    def request(self) -> builtins.bool:
        return pulumi.get(self, "request")

    @property
    @pulumi.getter(name="requestAdapt")
    def request_adapt(self) -> builtins.bool:
        return pulumi.get(self, "request_adapt")

    @property
    @pulumi.getter
    def reset(self) -> builtins.bool:
        return pulumi.get(self, "reset")

    @property
    @pulumi.getter
    def response(self) -> builtins.bool:
        return pulumi.get(self, "response")

    @property
    @pulumi.getter(name="responseAdapt")
    def response_adapt(self) -> builtins.bool:
        return pulumi.get(self, "response_adapt")

    @property
    @pulumi.getter
    def scheme(self) -> builtins.str:
        return pulumi.get(self, "scheme")

    @property
    @pulumi.getter
    def script(self) -> builtins.str:
        return pulumi.get(self, "script")

    @property
    @pulumi.getter
    def select(self) -> builtins.bool:
        return pulumi.get(self, "select")

    @property
    @pulumi.getter(name="serverSsl")
    def server_ssl(self) -> builtins.bool:
        return pulumi.get(self, "server_ssl")

    @property
    @pulumi.getter(name="setVariable")
    def set_variable(self) -> builtins.bool:
        return pulumi.get(self, "set_variable")

    @property
    @pulumi.getter
    def shutdown(self) -> builtins.bool:
        return pulumi.get(self, "shutdown")

    @property
    @pulumi.getter
    def snat(self) -> builtins.str:
        return pulumi.get(self, "snat")

    @property
    @pulumi.getter
    def snatpool(self) -> builtins.str:
        return pulumi.get(self, "snatpool")

    @property
    @pulumi.getter(name="sourceAddress")
    def source_address(self) -> builtins.bool:
        return pulumi.get(self, "source_address")

    @property
    @pulumi.getter(name="sslClientHello")
    def ssl_client_hello(self) -> builtins.bool:
        return pulumi.get(self, "ssl_client_hello")

    @property
    @pulumi.getter(name="sslServerHandshake")
    def ssl_server_handshake(self) -> builtins.bool:
        return pulumi.get(self, "ssl_server_handshake")

    @property
    @pulumi.getter(name="sslServerHello")
    def ssl_server_hello(self) -> builtins.bool:
        return pulumi.get(self, "ssl_server_hello")

    @property
    @pulumi.getter(name="sslSessionId")
    def ssl_session_id(self) -> builtins.bool:
        return pulumi.get(self, "ssl_session_id")

    @property
    @pulumi.getter
    def status(self) -> builtins.int:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tcl(self) -> builtins.bool:
        return pulumi.get(self, "tcl")

    @property
    @pulumi.getter(name="tcpNagle")
    def tcp_nagle(self) -> builtins.bool:
        return pulumi.get(self, "tcp_nagle")

    @property
    @pulumi.getter
    def text(self) -> builtins.str:
        return pulumi.get(self, "text")

    @property
    @pulumi.getter
    def timeout(self) -> builtins.int:
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="tmName")
    def tm_name(self) -> builtins.str:
        return pulumi.get(self, "tm_name")

    @property
    @pulumi.getter
    def uie(self) -> builtins.bool:
        return pulumi.get(self, "uie")

    @property
    @pulumi.getter
    def universal(self) -> builtins.bool:
        return pulumi.get(self, "universal")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def virtual(self) -> builtins.str:
        return pulumi.get(self, "virtual")

    @property
    @pulumi.getter
    def vlan(self) -> builtins.str:
        return pulumi.get(self, "vlan")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> builtins.int:
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter
    def wam(self) -> builtins.bool:
        return pulumi.get(self, "wam")

    @property
    @pulumi.getter
    def write(self) -> builtins.bool:
        return pulumi.get(self, "write")

    @property
    @pulumi.getter
    def forward(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "forward")

    @property
    @pulumi.getter(name="httpHost")
    def http_host(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "http_host")


@pulumi.output_type
class GetPolicyRuleConditionResult(dict):
    def __init__(__self__, *,
                 address: builtins.bool,
                 all: builtins.bool,
                 app_service: builtins.str,
                 browser_type: builtins.bool,
                 browser_version: builtins.bool,
                 case_insensitive: builtins.bool,
                 case_sensitive: builtins.bool,
                 cipher: builtins.bool,
                 cipher_bits: builtins.bool,
                 client_ssl: builtins.bool,
                 code: builtins.bool,
                 common_name: builtins.bool,
                 contains: builtins.bool,
                 continent: builtins.bool,
                 country_code: builtins.bool,
                 country_name: builtins.bool,
                 cpu_usage: builtins.bool,
                 datagroup: builtins.str,
                 device_make: builtins.bool,
                 device_model: builtins.bool,
                 domain: builtins.bool,
                 ends_with: builtins.bool,
                 equals: builtins.bool,
                 expiry: builtins.bool,
                 extension: builtins.bool,
                 external: builtins.bool,
                 geoip: builtins.bool,
                 greater: builtins.bool,
                 greater_or_equal: builtins.bool,
                 host: builtins.bool,
                 http_basic_auth: builtins.bool,
                 http_cookie: builtins.bool,
                 http_header: builtins.bool,
                 http_host: builtins.bool,
                 http_method: builtins.bool,
                 http_referer: builtins.bool,
                 http_set_cookie: builtins.bool,
                 http_status: builtins.bool,
                 http_uri: builtins.bool,
                 http_user_agent: builtins.bool,
                 http_version: builtins.bool,
                 index: builtins.int,
                 internal: builtins.bool,
                 isp: builtins.bool,
                 last15secs: builtins.bool,
                 last1min: builtins.bool,
                 last5mins: builtins.bool,
                 less: builtins.bool,
                 less_or_equal: builtins.bool,
                 local: builtins.bool,
                 major: builtins.bool,
                 matches: builtins.bool,
                 minor: builtins.bool,
                 missing: builtins.bool,
                 mss: builtins.bool,
                 not_: builtins.bool,
                 org: builtins.bool,
                 password: builtins.bool,
                 path: builtins.bool,
                 path_segment: builtins.bool,
                 port: builtins.bool,
                 present: builtins.bool,
                 protocol: builtins.bool,
                 query_parameter: builtins.bool,
                 query_string: builtins.bool,
                 region_code: builtins.bool,
                 region_name: builtins.bool,
                 remote: builtins.bool,
                 request: builtins.bool,
                 response: builtins.bool,
                 route_domain: builtins.bool,
                 rtt: builtins.bool,
                 scheme: builtins.bool,
                 server_name: builtins.bool,
                 ssl_cert: builtins.bool,
                 ssl_client_hello: builtins.bool,
                 ssl_extension: builtins.bool,
                 ssl_server_handshake: builtins.bool,
                 ssl_server_hello: builtins.bool,
                 starts_with: builtins.bool,
                 tcp: builtins.bool,
                 text: builtins.bool,
                 tm_name: builtins.str,
                 unnamed_query_parameter: builtins.bool,
                 user_agent_token: builtins.bool,
                 username: builtins.bool,
                 value: builtins.bool,
                 values: Sequence[builtins.str],
                 version: builtins.bool,
                 vlan: builtins.bool,
                 vlan_id: builtins.bool):
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "all", all)
        pulumi.set(__self__, "app_service", app_service)
        pulumi.set(__self__, "browser_type", browser_type)
        pulumi.set(__self__, "browser_version", browser_version)
        pulumi.set(__self__, "case_insensitive", case_insensitive)
        pulumi.set(__self__, "case_sensitive", case_sensitive)
        pulumi.set(__self__, "cipher", cipher)
        pulumi.set(__self__, "cipher_bits", cipher_bits)
        pulumi.set(__self__, "client_ssl", client_ssl)
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "contains", contains)
        pulumi.set(__self__, "continent", continent)
        pulumi.set(__self__, "country_code", country_code)
        pulumi.set(__self__, "country_name", country_name)
        pulumi.set(__self__, "cpu_usage", cpu_usage)
        pulumi.set(__self__, "datagroup", datagroup)
        pulumi.set(__self__, "device_make", device_make)
        pulumi.set(__self__, "device_model", device_model)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "ends_with", ends_with)
        pulumi.set(__self__, "equals", equals)
        pulumi.set(__self__, "expiry", expiry)
        pulumi.set(__self__, "extension", extension)
        pulumi.set(__self__, "external", external)
        pulumi.set(__self__, "geoip", geoip)
        pulumi.set(__self__, "greater", greater)
        pulumi.set(__self__, "greater_or_equal", greater_or_equal)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "http_basic_auth", http_basic_auth)
        pulumi.set(__self__, "http_cookie", http_cookie)
        pulumi.set(__self__, "http_header", http_header)
        pulumi.set(__self__, "http_host", http_host)
        pulumi.set(__self__, "http_method", http_method)
        pulumi.set(__self__, "http_referer", http_referer)
        pulumi.set(__self__, "http_set_cookie", http_set_cookie)
        pulumi.set(__self__, "http_status", http_status)
        pulumi.set(__self__, "http_uri", http_uri)
        pulumi.set(__self__, "http_user_agent", http_user_agent)
        pulumi.set(__self__, "http_version", http_version)
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "internal", internal)
        pulumi.set(__self__, "isp", isp)
        pulumi.set(__self__, "last15secs", last15secs)
        pulumi.set(__self__, "last1min", last1min)
        pulumi.set(__self__, "last5mins", last5mins)
        pulumi.set(__self__, "less", less)
        pulumi.set(__self__, "less_or_equal", less_or_equal)
        pulumi.set(__self__, "local", local)
        pulumi.set(__self__, "major", major)
        pulumi.set(__self__, "matches", matches)
        pulumi.set(__self__, "minor", minor)
        pulumi.set(__self__, "missing", missing)
        pulumi.set(__self__, "mss", mss)
        pulumi.set(__self__, "not_", not_)
        pulumi.set(__self__, "org", org)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "path_segment", path_segment)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "present", present)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "query_parameter", query_parameter)
        pulumi.set(__self__, "query_string", query_string)
        pulumi.set(__self__, "region_code", region_code)
        pulumi.set(__self__, "region_name", region_name)
        pulumi.set(__self__, "remote", remote)
        pulumi.set(__self__, "request", request)
        pulumi.set(__self__, "response", response)
        pulumi.set(__self__, "route_domain", route_domain)
        pulumi.set(__self__, "rtt", rtt)
        pulumi.set(__self__, "scheme", scheme)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "ssl_cert", ssl_cert)
        pulumi.set(__self__, "ssl_client_hello", ssl_client_hello)
        pulumi.set(__self__, "ssl_extension", ssl_extension)
        pulumi.set(__self__, "ssl_server_handshake", ssl_server_handshake)
        pulumi.set(__self__, "ssl_server_hello", ssl_server_hello)
        pulumi.set(__self__, "starts_with", starts_with)
        pulumi.set(__self__, "tcp", tcp)
        pulumi.set(__self__, "text", text)
        pulumi.set(__self__, "tm_name", tm_name)
        pulumi.set(__self__, "unnamed_query_parameter", unnamed_query_parameter)
        pulumi.set(__self__, "user_agent_token", user_agent_token)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "values", values)
        pulumi.set(__self__, "version", version)
        pulumi.set(__self__, "vlan", vlan)
        pulumi.set(__self__, "vlan_id", vlan_id)

    @property
    @pulumi.getter
    def address(self) -> builtins.bool:
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def all(self) -> builtins.bool:
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="appService")
    def app_service(self) -> builtins.str:
        return pulumi.get(self, "app_service")

    @property
    @pulumi.getter(name="browserType")
    def browser_type(self) -> builtins.bool:
        return pulumi.get(self, "browser_type")

    @property
    @pulumi.getter(name="browserVersion")
    def browser_version(self) -> builtins.bool:
        return pulumi.get(self, "browser_version")

    @property
    @pulumi.getter(name="caseInsensitive")
    def case_insensitive(self) -> builtins.bool:
        return pulumi.get(self, "case_insensitive")

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> builtins.bool:
        return pulumi.get(self, "case_sensitive")

    @property
    @pulumi.getter
    def cipher(self) -> builtins.bool:
        return pulumi.get(self, "cipher")

    @property
    @pulumi.getter(name="cipherBits")
    def cipher_bits(self) -> builtins.bool:
        return pulumi.get(self, "cipher_bits")

    @property
    @pulumi.getter(name="clientSsl")
    def client_ssl(self) -> builtins.bool:
        return pulumi.get(self, "client_ssl")

    @property
    @pulumi.getter
    def code(self) -> builtins.bool:
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> builtins.bool:
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter
    def contains(self) -> builtins.bool:
        return pulumi.get(self, "contains")

    @property
    @pulumi.getter
    def continent(self) -> builtins.bool:
        return pulumi.get(self, "continent")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> builtins.bool:
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter(name="countryName")
    def country_name(self) -> builtins.bool:
        return pulumi.get(self, "country_name")

    @property
    @pulumi.getter(name="cpuUsage")
    def cpu_usage(self) -> builtins.bool:
        return pulumi.get(self, "cpu_usage")

    @property
    @pulumi.getter
    def datagroup(self) -> builtins.str:
        return pulumi.get(self, "datagroup")

    @property
    @pulumi.getter(name="deviceMake")
    def device_make(self) -> builtins.bool:
        return pulumi.get(self, "device_make")

    @property
    @pulumi.getter(name="deviceModel")
    def device_model(self) -> builtins.bool:
        return pulumi.get(self, "device_model")

    @property
    @pulumi.getter
    def domain(self) -> builtins.bool:
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="endsWith")
    def ends_with(self) -> builtins.bool:
        return pulumi.get(self, "ends_with")

    @property
    @pulumi.getter
    def equals(self) -> builtins.bool:
        return pulumi.get(self, "equals")

    @property
    @pulumi.getter
    def expiry(self) -> builtins.bool:
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter
    def extension(self) -> builtins.bool:
        return pulumi.get(self, "extension")

    @property
    @pulumi.getter
    def external(self) -> builtins.bool:
        return pulumi.get(self, "external")

    @property
    @pulumi.getter
    def geoip(self) -> builtins.bool:
        return pulumi.get(self, "geoip")

    @property
    @pulumi.getter
    def greater(self) -> builtins.bool:
        return pulumi.get(self, "greater")

    @property
    @pulumi.getter(name="greaterOrEqual")
    def greater_or_equal(self) -> builtins.bool:
        return pulumi.get(self, "greater_or_equal")

    @property
    @pulumi.getter
    def host(self) -> builtins.bool:
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="httpBasicAuth")
    def http_basic_auth(self) -> builtins.bool:
        return pulumi.get(self, "http_basic_auth")

    @property
    @pulumi.getter(name="httpCookie")
    def http_cookie(self) -> builtins.bool:
        return pulumi.get(self, "http_cookie")

    @property
    @pulumi.getter(name="httpHeader")
    def http_header(self) -> builtins.bool:
        return pulumi.get(self, "http_header")

    @property
    @pulumi.getter(name="httpHost")
    def http_host(self) -> builtins.bool:
        return pulumi.get(self, "http_host")

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> builtins.bool:
        return pulumi.get(self, "http_method")

    @property
    @pulumi.getter(name="httpReferer")
    def http_referer(self) -> builtins.bool:
        return pulumi.get(self, "http_referer")

    @property
    @pulumi.getter(name="httpSetCookie")
    def http_set_cookie(self) -> builtins.bool:
        return pulumi.get(self, "http_set_cookie")

    @property
    @pulumi.getter(name="httpStatus")
    def http_status(self) -> builtins.bool:
        return pulumi.get(self, "http_status")

    @property
    @pulumi.getter(name="httpUri")
    def http_uri(self) -> builtins.bool:
        return pulumi.get(self, "http_uri")

    @property
    @pulumi.getter(name="httpUserAgent")
    def http_user_agent(self) -> builtins.bool:
        return pulumi.get(self, "http_user_agent")

    @property
    @pulumi.getter(name="httpVersion")
    def http_version(self) -> builtins.bool:
        return pulumi.get(self, "http_version")

    @property
    @pulumi.getter
    def index(self) -> builtins.int:
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def internal(self) -> builtins.bool:
        return pulumi.get(self, "internal")

    @property
    @pulumi.getter
    def isp(self) -> builtins.bool:
        return pulumi.get(self, "isp")

    @property
    @pulumi.getter
    def last15secs(self) -> builtins.bool:
        return pulumi.get(self, "last15secs")

    @property
    @pulumi.getter
    def last1min(self) -> builtins.bool:
        return pulumi.get(self, "last1min")

    @property
    @pulumi.getter
    def last5mins(self) -> builtins.bool:
        return pulumi.get(self, "last5mins")

    @property
    @pulumi.getter
    def less(self) -> builtins.bool:
        return pulumi.get(self, "less")

    @property
    @pulumi.getter(name="lessOrEqual")
    def less_or_equal(self) -> builtins.bool:
        return pulumi.get(self, "less_or_equal")

    @property
    @pulumi.getter
    def local(self) -> builtins.bool:
        return pulumi.get(self, "local")

    @property
    @pulumi.getter
    def major(self) -> builtins.bool:
        return pulumi.get(self, "major")

    @property
    @pulumi.getter
    def matches(self) -> builtins.bool:
        return pulumi.get(self, "matches")

    @property
    @pulumi.getter
    def minor(self) -> builtins.bool:
        return pulumi.get(self, "minor")

    @property
    @pulumi.getter
    def missing(self) -> builtins.bool:
        return pulumi.get(self, "missing")

    @property
    @pulumi.getter
    def mss(self) -> builtins.bool:
        return pulumi.get(self, "mss")

    @property
    @pulumi.getter(name="not")
    def not_(self) -> builtins.bool:
        return pulumi.get(self, "not_")

    @property
    @pulumi.getter
    def org(self) -> builtins.bool:
        return pulumi.get(self, "org")

    @property
    @pulumi.getter
    def password(self) -> builtins.bool:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def path(self) -> builtins.bool:
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="pathSegment")
    def path_segment(self) -> builtins.bool:
        return pulumi.get(self, "path_segment")

    @property
    @pulumi.getter
    def port(self) -> builtins.bool:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def present(self) -> builtins.bool:
        return pulumi.get(self, "present")

    @property
    @pulumi.getter
    def protocol(self) -> builtins.bool:
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="queryParameter")
    def query_parameter(self) -> builtins.bool:
        return pulumi.get(self, "query_parameter")

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> builtins.bool:
        return pulumi.get(self, "query_string")

    @property
    @pulumi.getter(name="regionCode")
    def region_code(self) -> builtins.bool:
        return pulumi.get(self, "region_code")

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> builtins.bool:
        return pulumi.get(self, "region_name")

    @property
    @pulumi.getter
    def remote(self) -> builtins.bool:
        return pulumi.get(self, "remote")

    @property
    @pulumi.getter
    def request(self) -> builtins.bool:
        return pulumi.get(self, "request")

    @property
    @pulumi.getter
    def response(self) -> builtins.bool:
        return pulumi.get(self, "response")

    @property
    @pulumi.getter(name="routeDomain")
    def route_domain(self) -> builtins.bool:
        return pulumi.get(self, "route_domain")

    @property
    @pulumi.getter
    def rtt(self) -> builtins.bool:
        return pulumi.get(self, "rtt")

    @property
    @pulumi.getter
    def scheme(self) -> builtins.bool:
        return pulumi.get(self, "scheme")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> builtins.bool:
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="sslCert")
    def ssl_cert(self) -> builtins.bool:
        return pulumi.get(self, "ssl_cert")

    @property
    @pulumi.getter(name="sslClientHello")
    def ssl_client_hello(self) -> builtins.bool:
        return pulumi.get(self, "ssl_client_hello")

    @property
    @pulumi.getter(name="sslExtension")
    def ssl_extension(self) -> builtins.bool:
        return pulumi.get(self, "ssl_extension")

    @property
    @pulumi.getter(name="sslServerHandshake")
    def ssl_server_handshake(self) -> builtins.bool:
        return pulumi.get(self, "ssl_server_handshake")

    @property
    @pulumi.getter(name="sslServerHello")
    def ssl_server_hello(self) -> builtins.bool:
        return pulumi.get(self, "ssl_server_hello")

    @property
    @pulumi.getter(name="startsWith")
    def starts_with(self) -> builtins.bool:
        return pulumi.get(self, "starts_with")

    @property
    @pulumi.getter
    def tcp(self) -> builtins.bool:
        return pulumi.get(self, "tcp")

    @property
    @pulumi.getter
    def text(self) -> builtins.bool:
        return pulumi.get(self, "text")

    @property
    @pulumi.getter(name="tmName")
    def tm_name(self) -> builtins.str:
        return pulumi.get(self, "tm_name")

    @property
    @pulumi.getter(name="unnamedQueryParameter")
    def unnamed_query_parameter(self) -> builtins.bool:
        return pulumi.get(self, "unnamed_query_parameter")

    @property
    @pulumi.getter(name="userAgentToken")
    def user_agent_token(self) -> builtins.bool:
        return pulumi.get(self, "user_agent_token")

    @property
    @pulumi.getter
    def username(self) -> builtins.bool:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def value(self) -> builtins.bool:
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def version(self) -> builtins.bool:
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def vlan(self) -> builtins.bool:
        return pulumi.get(self, "vlan")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> builtins.bool:
        return pulumi.get(self, "vlan_id")


