# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PolicyArgs', 'Policy']

@pulumi.input_type
class PolicyArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 controls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 published_copy: Optional[pulumi.Input[builtins.str]] = None,
                 requires: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyRuleArgs']]]] = None,
                 strategy: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Policy resource.
        :param pulumi.Input[builtins.str] name: Name of the Policy ( policy name should be in full path which is combination of partition and policy name )
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] controls: Specifies the controls
        :param pulumi.Input[builtins.str] description: Specifies descriptive text that identifies the ltm policy.
        :param pulumi.Input[builtins.str] published_copy: If you want to publish the policy else it will be deployed in Drafts mode. This attribute is deprecated and will be removed in a future release.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] requires: Specifies the protocol
        :param pulumi.Input[Sequence[pulumi.Input['PolicyRuleArgs']]] rules: List of Rules can be applied using the policy. Each rule is block type with following arguments.
        :param pulumi.Input[builtins.str] strategy: Specifies the match strategy
        """
        pulumi.set(__self__, "name", name)
        if controls is not None:
            pulumi.set(__self__, "controls", controls)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if published_copy is not None:
            warnings.warn("""This attribute is not required anymore because the resource automatically publishes the policy, for that reason this field is deprecated and will be removed in a future release.""", DeprecationWarning)
            pulumi.log.warn("""published_copy is deprecated: This attribute is not required anymore because the resource automatically publishes the policy, for that reason this field is deprecated and will be removed in a future release.""")
        if published_copy is not None:
            pulumi.set(__self__, "published_copy", published_copy)
        if requires is not None:
            pulumi.set(__self__, "requires", requires)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the Policy ( policy name should be in full path which is combination of partition and policy name )
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def controls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the controls
        """
        return pulumi.get(self, "controls")

    @controls.setter
    def controls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "controls", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies descriptive text that identifies the ltm policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="publishedCopy")
    @_utilities.deprecated("""This attribute is not required anymore because the resource automatically publishes the policy, for that reason this field is deprecated and will be removed in a future release.""")
    def published_copy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If you want to publish the policy else it will be deployed in Drafts mode. This attribute is deprecated and will be removed in a future release.
        """
        return pulumi.get(self, "published_copy")

    @published_copy.setter
    def published_copy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "published_copy", value)

    @property
    @pulumi.getter
    def requires(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the protocol
        """
        return pulumi.get(self, "requires")

    @requires.setter
    def requires(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "requires", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyRuleArgs']]]]:
        """
        List of Rules can be applied using the policy. Each rule is block type with following arguments.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def strategy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the match strategy
        """
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "strategy", value)


@pulumi.input_type
class _PolicyState:
    def __init__(__self__, *,
                 controls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 published_copy: Optional[pulumi.Input[builtins.str]] = None,
                 requires: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyRuleArgs']]]] = None,
                 strategy: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Policy resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] controls: Specifies the controls
        :param pulumi.Input[builtins.str] description: Specifies descriptive text that identifies the ltm policy.
        :param pulumi.Input[builtins.str] name: Name of the Policy ( policy name should be in full path which is combination of partition and policy name )
        :param pulumi.Input[builtins.str] published_copy: If you want to publish the policy else it will be deployed in Drafts mode. This attribute is deprecated and will be removed in a future release.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] requires: Specifies the protocol
        :param pulumi.Input[Sequence[pulumi.Input['PolicyRuleArgs']]] rules: List of Rules can be applied using the policy. Each rule is block type with following arguments.
        :param pulumi.Input[builtins.str] strategy: Specifies the match strategy
        """
        if controls is not None:
            pulumi.set(__self__, "controls", controls)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if published_copy is not None:
            warnings.warn("""This attribute is not required anymore because the resource automatically publishes the policy, for that reason this field is deprecated and will be removed in a future release.""", DeprecationWarning)
            pulumi.log.warn("""published_copy is deprecated: This attribute is not required anymore because the resource automatically publishes the policy, for that reason this field is deprecated and will be removed in a future release.""")
        if published_copy is not None:
            pulumi.set(__self__, "published_copy", published_copy)
        if requires is not None:
            pulumi.set(__self__, "requires", requires)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)

    @property
    @pulumi.getter
    def controls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the controls
        """
        return pulumi.get(self, "controls")

    @controls.setter
    def controls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "controls", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies descriptive text that identifies the ltm policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Policy ( policy name should be in full path which is combination of partition and policy name )
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publishedCopy")
    @_utilities.deprecated("""This attribute is not required anymore because the resource automatically publishes the policy, for that reason this field is deprecated and will be removed in a future release.""")
    def published_copy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If you want to publish the policy else it will be deployed in Drafts mode. This attribute is deprecated and will be removed in a future release.
        """
        return pulumi.get(self, "published_copy")

    @published_copy.setter
    def published_copy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "published_copy", value)

    @property
    @pulumi.getter
    def requires(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the protocol
        """
        return pulumi.get(self, "requires")

    @requires.setter
    def requires(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "requires", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyRuleArgs']]]]:
        """
        List of Rules can be applied using the policy. Each rule is block type with following arguments.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def strategy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the match strategy
        """
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "strategy", value)


@pulumi.type_token("f5bigip:ltm/policy:Policy")
class Policy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 controls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 published_copy: Optional[pulumi.Input[builtins.str]] = None,
                 requires: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyRuleArgs', 'PolicyRuleArgsDict']]]]] = None,
                 strategy: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        `ltm.Policy` Configures ltm policies to manage traffic assigned to a virtual server

        For resources should be named with their `full path`. The full path is the combination of the `partition + name` of the resource. For example `/Common/test-policy`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        mypool = f5bigip.ltm.Pool("mypool",
            name="/Common/test-pool",
            allow_nat="yes",
            allow_snat="yes",
            load_balancing_mode="round-robin")
        test_policy = f5bigip.ltm.Policy("test-policy",
            name="/Common/test-policy",
            strategy="first-match",
            requires=["http"],
            controls=["forwarding"],
            rules=[{
                "name": "rule6",
                "actions": [{
                    "forward": True,
                    "connection": False,
                    "pool": mypool.name,
                }],
            }],
            opts = pulumi.ResourceOptions(depends_on=[mypool]))
        ```

        ## Importing

        An existing policy can be imported into this resource by supplying policy Name in `full path` as `id`.
        An example is below:
        ```sh
        $ terraform import bigip_ltm_policy.policy-import-test /Common/policy2
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] controls: Specifies the controls
        :param pulumi.Input[builtins.str] description: Specifies descriptive text that identifies the ltm policy.
        :param pulumi.Input[builtins.str] name: Name of the Policy ( policy name should be in full path which is combination of partition and policy name )
        :param pulumi.Input[builtins.str] published_copy: If you want to publish the policy else it will be deployed in Drafts mode. This attribute is deprecated and will be removed in a future release.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] requires: Specifies the protocol
        :param pulumi.Input[Sequence[pulumi.Input[Union['PolicyRuleArgs', 'PolicyRuleArgsDict']]]] rules: List of Rules can be applied using the policy. Each rule is block type with following arguments.
        :param pulumi.Input[builtins.str] strategy: Specifies the match strategy
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `ltm.Policy` Configures ltm policies to manage traffic assigned to a virtual server

        For resources should be named with their `full path`. The full path is the combination of the `partition + name` of the resource. For example `/Common/test-policy`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        mypool = f5bigip.ltm.Pool("mypool",
            name="/Common/test-pool",
            allow_nat="yes",
            allow_snat="yes",
            load_balancing_mode="round-robin")
        test_policy = f5bigip.ltm.Policy("test-policy",
            name="/Common/test-policy",
            strategy="first-match",
            requires=["http"],
            controls=["forwarding"],
            rules=[{
                "name": "rule6",
                "actions": [{
                    "forward": True,
                    "connection": False,
                    "pool": mypool.name,
                }],
            }],
            opts = pulumi.ResourceOptions(depends_on=[mypool]))
        ```

        ## Importing

        An existing policy can be imported into this resource by supplying policy Name in `full path` as `id`.
        An example is below:
        ```sh
        $ terraform import bigip_ltm_policy.policy-import-test /Common/policy2
        ```

        :param str resource_name: The name of the resource.
        :param PolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 controls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 published_copy: Optional[pulumi.Input[builtins.str]] = None,
                 requires: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyRuleArgs', 'PolicyRuleArgsDict']]]]] = None,
                 strategy: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyArgs.__new__(PolicyArgs)

            __props__.__dict__["controls"] = controls
            __props__.__dict__["description"] = description
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["published_copy"] = published_copy
            __props__.__dict__["requires"] = requires
            __props__.__dict__["rules"] = rules
            __props__.__dict__["strategy"] = strategy
        super(Policy, __self__).__init__(
            'f5bigip:ltm/policy:Policy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            controls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            published_copy: Optional[pulumi.Input[builtins.str]] = None,
            requires: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyRuleArgs', 'PolicyRuleArgsDict']]]]] = None,
            strategy: Optional[pulumi.Input[builtins.str]] = None) -> 'Policy':
        """
        Get an existing Policy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] controls: Specifies the controls
        :param pulumi.Input[builtins.str] description: Specifies descriptive text that identifies the ltm policy.
        :param pulumi.Input[builtins.str] name: Name of the Policy ( policy name should be in full path which is combination of partition and policy name )
        :param pulumi.Input[builtins.str] published_copy: If you want to publish the policy else it will be deployed in Drafts mode. This attribute is deprecated and will be removed in a future release.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] requires: Specifies the protocol
        :param pulumi.Input[Sequence[pulumi.Input[Union['PolicyRuleArgs', 'PolicyRuleArgsDict']]]] rules: List of Rules can be applied using the policy. Each rule is block type with following arguments.
        :param pulumi.Input[builtins.str] strategy: Specifies the match strategy
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyState.__new__(_PolicyState)

        __props__.__dict__["controls"] = controls
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["published_copy"] = published_copy
        __props__.__dict__["requires"] = requires
        __props__.__dict__["rules"] = rules
        __props__.__dict__["strategy"] = strategy
        return Policy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def controls(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Specifies the controls
        """
        return pulumi.get(self, "controls")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies descriptive text that identifies the ltm policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Policy ( policy name should be in full path which is combination of partition and policy name )
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publishedCopy")
    @_utilities.deprecated("""This attribute is not required anymore because the resource automatically publishes the policy, for that reason this field is deprecated and will be removed in a future release.""")
    def published_copy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        If you want to publish the policy else it will be deployed in Drafts mode. This attribute is deprecated and will be removed in a future release.
        """
        return pulumi.get(self, "published_copy")

    @property
    @pulumi.getter
    def requires(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Specifies the protocol
        """
        return pulumi.get(self, "requires")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.PolicyRule']]]:
        """
        List of Rules can be applied using the policy. Each rule is block type with following arguments.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def strategy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the match strategy
        """
        return pulumi.get(self, "strategy")

