# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ProfileFastL4Args', 'ProfileFastL4']

@pulumi.input_type
class ProfileFastL4Args:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 client_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 defaults_from: Optional[pulumi.Input[builtins.str]] = None,
                 explicitflow_migration: Optional[pulumi.Input[builtins.str]] = None,
                 hardware_syncookie: Optional[pulumi.Input[builtins.str]] = None,
                 idle_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 iptos_toclient: Optional[pulumi.Input[builtins.str]] = None,
                 iptos_toserver: Optional[pulumi.Input[builtins.str]] = None,
                 keepalive_interval: Optional[pulumi.Input[builtins.str]] = None,
                 late_binding: Optional[pulumi.Input[builtins.str]] = None,
                 loose_close: Optional[pulumi.Input[builtins.str]] = None,
                 loose_initiation: Optional[pulumi.Input[builtins.str]] = None,
                 partition: Optional[pulumi.Input[builtins.str]] = None,
                 receive_windowsize: Optional[pulumi.Input[builtins.int]] = None,
                 tcp_handshake_timeout: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ProfileFastL4 resource.
        :param pulumi.Input[builtins.str] name: Name of the LTM fastL4 Profile.The full path is the combination of the `partition + name` of the resource (For example `/Common/my-fastl4profile`) or  `partition + directory + name` of the resource  (example: `/Common/test/my-fastl4profile`)
        :param pulumi.Input[builtins.int] client_timeout: Specifies late binding client timeout in seconds. This setting specifies the number of seconds allowed for a client to transmit enough data to select a server when late binding is enabled. If it expires timeout-recovery mode will dictate what action to take.
        :param pulumi.Input[builtins.str] defaults_from: Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        :param pulumi.Input[builtins.str] explicitflow_migration: Enables or disables late binding explicit flow migration that allows iRules to control when flows move from software to hardware. Explicit flow migration is disabled by default hence BIG-IP automatically migrates flows from software to hardware.
        :param pulumi.Input[builtins.str] hardware_syncookie: Enables or disables hardware SYN cookie support when PVA10 is present on the system. Note that when you set the hardware syncookie option to enabled, you may also want to set the following bigdb database variables using the "/sys modify db" command, based on your requirements: pva.SynCookies.Full.ConnectionThreshold (default: 500000), pva.SynCookies.Assist.ConnectionThreshold (default: 500000) pva.SynCookies.ClientWindow (default: 0). The default value is disabled.
        :param pulumi.Input[builtins.str] idle_timeout: Specifies an idle timeout in seconds. This setting specifies the number of seconds that a connection is idle before the connection is eligible for deletion.When you specify an idle timeout for the Fast L4 profile, the value must be greater than the bigdb database variable Pva.Scrub time in msec for it to work properly.The default value is 300 seconds.
        :param pulumi.Input[builtins.str] iptos_toclient: Specifies an IP ToS number for the client side. This option specifies the Type of Service level that the traffic management system assigns to IP packets when sending them to clients. The default value is 65535 (pass-through), which indicates, do not modify.
        :param pulumi.Input[builtins.str] iptos_toserver: Specifies an IP ToS number for the server side. This setting specifies the Type of Service level that the traffic management system assigns to IP packets when sending them to servers. The default value is 65535 (pass-through), which indicates, do not modify.
        :param pulumi.Input[builtins.str] keepalive_interval: Specifies the keep alive probe interval, in seconds. The default value is disabled (0 seconds).
        :param pulumi.Input[builtins.str] late_binding: Enables intelligent selection of a back-end server or pool, using an iRule to make the selection. The default is `disabled`.
        :param pulumi.Input[builtins.str] loose_close: Specifies, when checked (enabled), that the system closes a loosely-initiated connection when the system receives the first FIN packet from either the client or the server. The default is disabled.
        :param pulumi.Input[builtins.str] loose_initiation: Specifies, when checked (enabled), that the system initializes a connection when it receives any TCP packet, rather that requiring a SYN packet for connection initiation. The default is disabled. We recommend that if you enable the Loose Initiation option, you also enable the Loose Close option.
        :param pulumi.Input[builtins.str] partition: name of partition
        :param pulumi.Input[builtins.int] receive_windowsize: Specifies the amount of data the BIG-IP system can accept without acknowledging the server. The default is 0 (zero).
        :param pulumi.Input[builtins.str] tcp_handshake_timeout: Specifies the acceptable duration for a TCP handshake, that is, the maximum idle time between a client synchronization (SYN) and a client acknowledgment (ACK).The default is `5 seconds`.
        """
        pulumi.set(__self__, "name", name)
        if client_timeout is not None:
            pulumi.set(__self__, "client_timeout", client_timeout)
        if defaults_from is not None:
            pulumi.set(__self__, "defaults_from", defaults_from)
        if explicitflow_migration is not None:
            pulumi.set(__self__, "explicitflow_migration", explicitflow_migration)
        if hardware_syncookie is not None:
            pulumi.set(__self__, "hardware_syncookie", hardware_syncookie)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if iptos_toclient is not None:
            pulumi.set(__self__, "iptos_toclient", iptos_toclient)
        if iptos_toserver is not None:
            pulumi.set(__self__, "iptos_toserver", iptos_toserver)
        if keepalive_interval is not None:
            pulumi.set(__self__, "keepalive_interval", keepalive_interval)
        if late_binding is not None:
            pulumi.set(__self__, "late_binding", late_binding)
        if loose_close is not None:
            pulumi.set(__self__, "loose_close", loose_close)
        if loose_initiation is not None:
            pulumi.set(__self__, "loose_initiation", loose_initiation)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if receive_windowsize is not None:
            pulumi.set(__self__, "receive_windowsize", receive_windowsize)
        if tcp_handshake_timeout is not None:
            pulumi.set(__self__, "tcp_handshake_timeout", tcp_handshake_timeout)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the LTM fastL4 Profile.The full path is the combination of the `partition + name` of the resource (For example `/Common/my-fastl4profile`) or  `partition + directory + name` of the resource  (example: `/Common/test/my-fastl4profile`)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="clientTimeout")
    def client_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies late binding client timeout in seconds. This setting specifies the number of seconds allowed for a client to transmit enough data to select a server when late binding is enabled. If it expires timeout-recovery mode will dictate what action to take.
        """
        return pulumi.get(self, "client_timeout")

    @client_timeout.setter
    def client_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "client_timeout", value)

    @property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        """
        return pulumi.get(self, "defaults_from")

    @defaults_from.setter
    def defaults_from(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "defaults_from", value)

    @property
    @pulumi.getter(name="explicitflowMigration")
    def explicitflow_migration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enables or disables late binding explicit flow migration that allows iRules to control when flows move from software to hardware. Explicit flow migration is disabled by default hence BIG-IP automatically migrates flows from software to hardware.
        """
        return pulumi.get(self, "explicitflow_migration")

    @explicitflow_migration.setter
    def explicitflow_migration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "explicitflow_migration", value)

    @property
    @pulumi.getter(name="hardwareSyncookie")
    def hardware_syncookie(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enables or disables hardware SYN cookie support when PVA10 is present on the system. Note that when you set the hardware syncookie option to enabled, you may also want to set the following bigdb database variables using the "/sys modify db" command, based on your requirements: pva.SynCookies.Full.ConnectionThreshold (default: 500000), pva.SynCookies.Assist.ConnectionThreshold (default: 500000) pva.SynCookies.ClientWindow (default: 0). The default value is disabled.
        """
        return pulumi.get(self, "hardware_syncookie")

    @hardware_syncookie.setter
    def hardware_syncookie(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hardware_syncookie", value)

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies an idle timeout in seconds. This setting specifies the number of seconds that a connection is idle before the connection is eligible for deletion.When you specify an idle timeout for the Fast L4 profile, the value must be greater than the bigdb database variable Pva.Scrub time in msec for it to work properly.The default value is 300 seconds.
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idle_timeout", value)

    @property
    @pulumi.getter(name="iptosToclient")
    def iptos_toclient(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies an IP ToS number for the client side. This option specifies the Type of Service level that the traffic management system assigns to IP packets when sending them to clients. The default value is 65535 (pass-through), which indicates, do not modify.
        """
        return pulumi.get(self, "iptos_toclient")

    @iptos_toclient.setter
    def iptos_toclient(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iptos_toclient", value)

    @property
    @pulumi.getter(name="iptosToserver")
    def iptos_toserver(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies an IP ToS number for the server side. This setting specifies the Type of Service level that the traffic management system assigns to IP packets when sending them to servers. The default value is 65535 (pass-through), which indicates, do not modify.
        """
        return pulumi.get(self, "iptos_toserver")

    @iptos_toserver.setter
    def iptos_toserver(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iptos_toserver", value)

    @property
    @pulumi.getter(name="keepaliveInterval")
    def keepalive_interval(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the keep alive probe interval, in seconds. The default value is disabled (0 seconds).
        """
        return pulumi.get(self, "keepalive_interval")

    @keepalive_interval.setter
    def keepalive_interval(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "keepalive_interval", value)

    @property
    @pulumi.getter(name="lateBinding")
    def late_binding(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enables intelligent selection of a back-end server or pool, using an iRule to make the selection. The default is `disabled`.
        """
        return pulumi.get(self, "late_binding")

    @late_binding.setter
    def late_binding(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "late_binding", value)

    @property
    @pulumi.getter(name="looseClose")
    def loose_close(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies, when checked (enabled), that the system closes a loosely-initiated connection when the system receives the first FIN packet from either the client or the server. The default is disabled.
        """
        return pulumi.get(self, "loose_close")

    @loose_close.setter
    def loose_close(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "loose_close", value)

    @property
    @pulumi.getter(name="looseInitiation")
    def loose_initiation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies, when checked (enabled), that the system initializes a connection when it receives any TCP packet, rather that requiring a SYN packet for connection initiation. The default is disabled. We recommend that if you enable the Loose Initiation option, you also enable the Loose Close option.
        """
        return pulumi.get(self, "loose_initiation")

    @loose_initiation.setter
    def loose_initiation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "loose_initiation", value)

    @property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        name of partition
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "partition", value)

    @property
    @pulumi.getter(name="receiveWindowsize")
    def receive_windowsize(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the amount of data the BIG-IP system can accept without acknowledging the server. The default is 0 (zero).
        """
        return pulumi.get(self, "receive_windowsize")

    @receive_windowsize.setter
    def receive_windowsize(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "receive_windowsize", value)

    @property
    @pulumi.getter(name="tcpHandshakeTimeout")
    def tcp_handshake_timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the acceptable duration for a TCP handshake, that is, the maximum idle time between a client synchronization (SYN) and a client acknowledgment (ACK).The default is `5 seconds`.
        """
        return pulumi.get(self, "tcp_handshake_timeout")

    @tcp_handshake_timeout.setter
    def tcp_handshake_timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tcp_handshake_timeout", value)


@pulumi.input_type
class _ProfileFastL4State:
    def __init__(__self__, *,
                 client_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 defaults_from: Optional[pulumi.Input[builtins.str]] = None,
                 explicitflow_migration: Optional[pulumi.Input[builtins.str]] = None,
                 hardware_syncookie: Optional[pulumi.Input[builtins.str]] = None,
                 idle_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 iptos_toclient: Optional[pulumi.Input[builtins.str]] = None,
                 iptos_toserver: Optional[pulumi.Input[builtins.str]] = None,
                 keepalive_interval: Optional[pulumi.Input[builtins.str]] = None,
                 late_binding: Optional[pulumi.Input[builtins.str]] = None,
                 loose_close: Optional[pulumi.Input[builtins.str]] = None,
                 loose_initiation: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 partition: Optional[pulumi.Input[builtins.str]] = None,
                 receive_windowsize: Optional[pulumi.Input[builtins.int]] = None,
                 tcp_handshake_timeout: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProfileFastL4 resources.
        :param pulumi.Input[builtins.int] client_timeout: Specifies late binding client timeout in seconds. This setting specifies the number of seconds allowed for a client to transmit enough data to select a server when late binding is enabled. If it expires timeout-recovery mode will dictate what action to take.
        :param pulumi.Input[builtins.str] defaults_from: Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        :param pulumi.Input[builtins.str] explicitflow_migration: Enables or disables late binding explicit flow migration that allows iRules to control when flows move from software to hardware. Explicit flow migration is disabled by default hence BIG-IP automatically migrates flows from software to hardware.
        :param pulumi.Input[builtins.str] hardware_syncookie: Enables or disables hardware SYN cookie support when PVA10 is present on the system. Note that when you set the hardware syncookie option to enabled, you may also want to set the following bigdb database variables using the "/sys modify db" command, based on your requirements: pva.SynCookies.Full.ConnectionThreshold (default: 500000), pva.SynCookies.Assist.ConnectionThreshold (default: 500000) pva.SynCookies.ClientWindow (default: 0). The default value is disabled.
        :param pulumi.Input[builtins.str] idle_timeout: Specifies an idle timeout in seconds. This setting specifies the number of seconds that a connection is idle before the connection is eligible for deletion.When you specify an idle timeout for the Fast L4 profile, the value must be greater than the bigdb database variable Pva.Scrub time in msec for it to work properly.The default value is 300 seconds.
        :param pulumi.Input[builtins.str] iptos_toclient: Specifies an IP ToS number for the client side. This option specifies the Type of Service level that the traffic management system assigns to IP packets when sending them to clients. The default value is 65535 (pass-through), which indicates, do not modify.
        :param pulumi.Input[builtins.str] iptos_toserver: Specifies an IP ToS number for the server side. This setting specifies the Type of Service level that the traffic management system assigns to IP packets when sending them to servers. The default value is 65535 (pass-through), which indicates, do not modify.
        :param pulumi.Input[builtins.str] keepalive_interval: Specifies the keep alive probe interval, in seconds. The default value is disabled (0 seconds).
        :param pulumi.Input[builtins.str] late_binding: Enables intelligent selection of a back-end server or pool, using an iRule to make the selection. The default is `disabled`.
        :param pulumi.Input[builtins.str] loose_close: Specifies, when checked (enabled), that the system closes a loosely-initiated connection when the system receives the first FIN packet from either the client or the server. The default is disabled.
        :param pulumi.Input[builtins.str] loose_initiation: Specifies, when checked (enabled), that the system initializes a connection when it receives any TCP packet, rather that requiring a SYN packet for connection initiation. The default is disabled. We recommend that if you enable the Loose Initiation option, you also enable the Loose Close option.
        :param pulumi.Input[builtins.str] name: Name of the LTM fastL4 Profile.The full path is the combination of the `partition + name` of the resource (For example `/Common/my-fastl4profile`) or  `partition + directory + name` of the resource  (example: `/Common/test/my-fastl4profile`)
        :param pulumi.Input[builtins.str] partition: name of partition
        :param pulumi.Input[builtins.int] receive_windowsize: Specifies the amount of data the BIG-IP system can accept without acknowledging the server. The default is 0 (zero).
        :param pulumi.Input[builtins.str] tcp_handshake_timeout: Specifies the acceptable duration for a TCP handshake, that is, the maximum idle time between a client synchronization (SYN) and a client acknowledgment (ACK).The default is `5 seconds`.
        """
        if client_timeout is not None:
            pulumi.set(__self__, "client_timeout", client_timeout)
        if defaults_from is not None:
            pulumi.set(__self__, "defaults_from", defaults_from)
        if explicitflow_migration is not None:
            pulumi.set(__self__, "explicitflow_migration", explicitflow_migration)
        if hardware_syncookie is not None:
            pulumi.set(__self__, "hardware_syncookie", hardware_syncookie)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if iptos_toclient is not None:
            pulumi.set(__self__, "iptos_toclient", iptos_toclient)
        if iptos_toserver is not None:
            pulumi.set(__self__, "iptos_toserver", iptos_toserver)
        if keepalive_interval is not None:
            pulumi.set(__self__, "keepalive_interval", keepalive_interval)
        if late_binding is not None:
            pulumi.set(__self__, "late_binding", late_binding)
        if loose_close is not None:
            pulumi.set(__self__, "loose_close", loose_close)
        if loose_initiation is not None:
            pulumi.set(__self__, "loose_initiation", loose_initiation)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if receive_windowsize is not None:
            pulumi.set(__self__, "receive_windowsize", receive_windowsize)
        if tcp_handshake_timeout is not None:
            pulumi.set(__self__, "tcp_handshake_timeout", tcp_handshake_timeout)

    @property
    @pulumi.getter(name="clientTimeout")
    def client_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies late binding client timeout in seconds. This setting specifies the number of seconds allowed for a client to transmit enough data to select a server when late binding is enabled. If it expires timeout-recovery mode will dictate what action to take.
        """
        return pulumi.get(self, "client_timeout")

    @client_timeout.setter
    def client_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "client_timeout", value)

    @property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        """
        return pulumi.get(self, "defaults_from")

    @defaults_from.setter
    def defaults_from(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "defaults_from", value)

    @property
    @pulumi.getter(name="explicitflowMigration")
    def explicitflow_migration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enables or disables late binding explicit flow migration that allows iRules to control when flows move from software to hardware. Explicit flow migration is disabled by default hence BIG-IP automatically migrates flows from software to hardware.
        """
        return pulumi.get(self, "explicitflow_migration")

    @explicitflow_migration.setter
    def explicitflow_migration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "explicitflow_migration", value)

    @property
    @pulumi.getter(name="hardwareSyncookie")
    def hardware_syncookie(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enables or disables hardware SYN cookie support when PVA10 is present on the system. Note that when you set the hardware syncookie option to enabled, you may also want to set the following bigdb database variables using the "/sys modify db" command, based on your requirements: pva.SynCookies.Full.ConnectionThreshold (default: 500000), pva.SynCookies.Assist.ConnectionThreshold (default: 500000) pva.SynCookies.ClientWindow (default: 0). The default value is disabled.
        """
        return pulumi.get(self, "hardware_syncookie")

    @hardware_syncookie.setter
    def hardware_syncookie(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hardware_syncookie", value)

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies an idle timeout in seconds. This setting specifies the number of seconds that a connection is idle before the connection is eligible for deletion.When you specify an idle timeout for the Fast L4 profile, the value must be greater than the bigdb database variable Pva.Scrub time in msec for it to work properly.The default value is 300 seconds.
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idle_timeout", value)

    @property
    @pulumi.getter(name="iptosToclient")
    def iptos_toclient(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies an IP ToS number for the client side. This option specifies the Type of Service level that the traffic management system assigns to IP packets when sending them to clients. The default value is 65535 (pass-through), which indicates, do not modify.
        """
        return pulumi.get(self, "iptos_toclient")

    @iptos_toclient.setter
    def iptos_toclient(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iptos_toclient", value)

    @property
    @pulumi.getter(name="iptosToserver")
    def iptos_toserver(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies an IP ToS number for the server side. This setting specifies the Type of Service level that the traffic management system assigns to IP packets when sending them to servers. The default value is 65535 (pass-through), which indicates, do not modify.
        """
        return pulumi.get(self, "iptos_toserver")

    @iptos_toserver.setter
    def iptos_toserver(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iptos_toserver", value)

    @property
    @pulumi.getter(name="keepaliveInterval")
    def keepalive_interval(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the keep alive probe interval, in seconds. The default value is disabled (0 seconds).
        """
        return pulumi.get(self, "keepalive_interval")

    @keepalive_interval.setter
    def keepalive_interval(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "keepalive_interval", value)

    @property
    @pulumi.getter(name="lateBinding")
    def late_binding(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enables intelligent selection of a back-end server or pool, using an iRule to make the selection. The default is `disabled`.
        """
        return pulumi.get(self, "late_binding")

    @late_binding.setter
    def late_binding(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "late_binding", value)

    @property
    @pulumi.getter(name="looseClose")
    def loose_close(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies, when checked (enabled), that the system closes a loosely-initiated connection when the system receives the first FIN packet from either the client or the server. The default is disabled.
        """
        return pulumi.get(self, "loose_close")

    @loose_close.setter
    def loose_close(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "loose_close", value)

    @property
    @pulumi.getter(name="looseInitiation")
    def loose_initiation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies, when checked (enabled), that the system initializes a connection when it receives any TCP packet, rather that requiring a SYN packet for connection initiation. The default is disabled. We recommend that if you enable the Loose Initiation option, you also enable the Loose Close option.
        """
        return pulumi.get(self, "loose_initiation")

    @loose_initiation.setter
    def loose_initiation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "loose_initiation", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the LTM fastL4 Profile.The full path is the combination of the `partition + name` of the resource (For example `/Common/my-fastl4profile`) or  `partition + directory + name` of the resource  (example: `/Common/test/my-fastl4profile`)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        name of partition
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "partition", value)

    @property
    @pulumi.getter(name="receiveWindowsize")
    def receive_windowsize(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the amount of data the BIG-IP system can accept without acknowledging the server. The default is 0 (zero).
        """
        return pulumi.get(self, "receive_windowsize")

    @receive_windowsize.setter
    def receive_windowsize(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "receive_windowsize", value)

    @property
    @pulumi.getter(name="tcpHandshakeTimeout")
    def tcp_handshake_timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the acceptable duration for a TCP handshake, that is, the maximum idle time between a client synchronization (SYN) and a client acknowledgment (ACK).The default is `5 seconds`.
        """
        return pulumi.get(self, "tcp_handshake_timeout")

    @tcp_handshake_timeout.setter
    def tcp_handshake_timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tcp_handshake_timeout", value)


@pulumi.type_token("f5bigip:ltm/profileFastL4:ProfileFastL4")
class ProfileFastL4(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 defaults_from: Optional[pulumi.Input[builtins.str]] = None,
                 explicitflow_migration: Optional[pulumi.Input[builtins.str]] = None,
                 hardware_syncookie: Optional[pulumi.Input[builtins.str]] = None,
                 idle_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 iptos_toclient: Optional[pulumi.Input[builtins.str]] = None,
                 iptos_toserver: Optional[pulumi.Input[builtins.str]] = None,
                 keepalive_interval: Optional[pulumi.Input[builtins.str]] = None,
                 late_binding: Optional[pulumi.Input[builtins.str]] = None,
                 loose_close: Optional[pulumi.Input[builtins.str]] = None,
                 loose_initiation: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 partition: Optional[pulumi.Input[builtins.str]] = None,
                 receive_windowsize: Optional[pulumi.Input[builtins.int]] = None,
                 tcp_handshake_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        `ltm.ProfileFastL4` Configures a custom LTM fastL4 profile for use by health checks.

        Resources should be named with their `full path`. The full path is the combination of the `partition + name` of the resource (For example `/Common/my-fastl4profile`) or  `partition + directory + name` of the resource  (example: `/Common/test/my-fastl4profile`)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        profile_fastl4 = f5bigip.ltm.ProfileFastL4("profile_fastl4",
            name="/Common/sjfastl4profile",
            defaults_from="/Common/fastL4",
            client_timeout=40,
            explicitflow_migration="enabled",
            hardware_syncookie="enabled",
            idle_timeout="200",
            iptos_toclient="pass-through",
            iptos_toserver="pass-through",
            keepalive_interval="disabled")
        ```

        ## Import

        BIG-IP LTM fastl4 profiles can be imported using the `name`, e.g.

        ```sh
        $ pulumi import f5bigip:ltm/profileFastL4:ProfileFastL4 test-fastl4 /Common/test-fastl4
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] client_timeout: Specifies late binding client timeout in seconds. This setting specifies the number of seconds allowed for a client to transmit enough data to select a server when late binding is enabled. If it expires timeout-recovery mode will dictate what action to take.
        :param pulumi.Input[builtins.str] defaults_from: Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        :param pulumi.Input[builtins.str] explicitflow_migration: Enables or disables late binding explicit flow migration that allows iRules to control when flows move from software to hardware. Explicit flow migration is disabled by default hence BIG-IP automatically migrates flows from software to hardware.
        :param pulumi.Input[builtins.str] hardware_syncookie: Enables or disables hardware SYN cookie support when PVA10 is present on the system. Note that when you set the hardware syncookie option to enabled, you may also want to set the following bigdb database variables using the "/sys modify db" command, based on your requirements: pva.SynCookies.Full.ConnectionThreshold (default: 500000), pva.SynCookies.Assist.ConnectionThreshold (default: 500000) pva.SynCookies.ClientWindow (default: 0). The default value is disabled.
        :param pulumi.Input[builtins.str] idle_timeout: Specifies an idle timeout in seconds. This setting specifies the number of seconds that a connection is idle before the connection is eligible for deletion.When you specify an idle timeout for the Fast L4 profile, the value must be greater than the bigdb database variable Pva.Scrub time in msec for it to work properly.The default value is 300 seconds.
        :param pulumi.Input[builtins.str] iptos_toclient: Specifies an IP ToS number for the client side. This option specifies the Type of Service level that the traffic management system assigns to IP packets when sending them to clients. The default value is 65535 (pass-through), which indicates, do not modify.
        :param pulumi.Input[builtins.str] iptos_toserver: Specifies an IP ToS number for the server side. This setting specifies the Type of Service level that the traffic management system assigns to IP packets when sending them to servers. The default value is 65535 (pass-through), which indicates, do not modify.
        :param pulumi.Input[builtins.str] keepalive_interval: Specifies the keep alive probe interval, in seconds. The default value is disabled (0 seconds).
        :param pulumi.Input[builtins.str] late_binding: Enables intelligent selection of a back-end server or pool, using an iRule to make the selection. The default is `disabled`.
        :param pulumi.Input[builtins.str] loose_close: Specifies, when checked (enabled), that the system closes a loosely-initiated connection when the system receives the first FIN packet from either the client or the server. The default is disabled.
        :param pulumi.Input[builtins.str] loose_initiation: Specifies, when checked (enabled), that the system initializes a connection when it receives any TCP packet, rather that requiring a SYN packet for connection initiation. The default is disabled. We recommend that if you enable the Loose Initiation option, you also enable the Loose Close option.
        :param pulumi.Input[builtins.str] name: Name of the LTM fastL4 Profile.The full path is the combination of the `partition + name` of the resource (For example `/Common/my-fastl4profile`) or  `partition + directory + name` of the resource  (example: `/Common/test/my-fastl4profile`)
        :param pulumi.Input[builtins.str] partition: name of partition
        :param pulumi.Input[builtins.int] receive_windowsize: Specifies the amount of data the BIG-IP system can accept without acknowledging the server. The default is 0 (zero).
        :param pulumi.Input[builtins.str] tcp_handshake_timeout: Specifies the acceptable duration for a TCP handshake, that is, the maximum idle time between a client synchronization (SYN) and a client acknowledgment (ACK).The default is `5 seconds`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProfileFastL4Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `ltm.ProfileFastL4` Configures a custom LTM fastL4 profile for use by health checks.

        Resources should be named with their `full path`. The full path is the combination of the `partition + name` of the resource (For example `/Common/my-fastl4profile`) or  `partition + directory + name` of the resource  (example: `/Common/test/my-fastl4profile`)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        profile_fastl4 = f5bigip.ltm.ProfileFastL4("profile_fastl4",
            name="/Common/sjfastl4profile",
            defaults_from="/Common/fastL4",
            client_timeout=40,
            explicitflow_migration="enabled",
            hardware_syncookie="enabled",
            idle_timeout="200",
            iptos_toclient="pass-through",
            iptos_toserver="pass-through",
            keepalive_interval="disabled")
        ```

        ## Import

        BIG-IP LTM fastl4 profiles can be imported using the `name`, e.g.

        ```sh
        $ pulumi import f5bigip:ltm/profileFastL4:ProfileFastL4 test-fastl4 /Common/test-fastl4
        ```

        :param str resource_name: The name of the resource.
        :param ProfileFastL4Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProfileFastL4Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 defaults_from: Optional[pulumi.Input[builtins.str]] = None,
                 explicitflow_migration: Optional[pulumi.Input[builtins.str]] = None,
                 hardware_syncookie: Optional[pulumi.Input[builtins.str]] = None,
                 idle_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 iptos_toclient: Optional[pulumi.Input[builtins.str]] = None,
                 iptos_toserver: Optional[pulumi.Input[builtins.str]] = None,
                 keepalive_interval: Optional[pulumi.Input[builtins.str]] = None,
                 late_binding: Optional[pulumi.Input[builtins.str]] = None,
                 loose_close: Optional[pulumi.Input[builtins.str]] = None,
                 loose_initiation: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 partition: Optional[pulumi.Input[builtins.str]] = None,
                 receive_windowsize: Optional[pulumi.Input[builtins.int]] = None,
                 tcp_handshake_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProfileFastL4Args.__new__(ProfileFastL4Args)

            __props__.__dict__["client_timeout"] = client_timeout
            __props__.__dict__["defaults_from"] = defaults_from
            __props__.__dict__["explicitflow_migration"] = explicitflow_migration
            __props__.__dict__["hardware_syncookie"] = hardware_syncookie
            __props__.__dict__["idle_timeout"] = idle_timeout
            __props__.__dict__["iptos_toclient"] = iptos_toclient
            __props__.__dict__["iptos_toserver"] = iptos_toserver
            __props__.__dict__["keepalive_interval"] = keepalive_interval
            __props__.__dict__["late_binding"] = late_binding
            __props__.__dict__["loose_close"] = loose_close
            __props__.__dict__["loose_initiation"] = loose_initiation
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["partition"] = partition
            __props__.__dict__["receive_windowsize"] = receive_windowsize
            __props__.__dict__["tcp_handshake_timeout"] = tcp_handshake_timeout
        super(ProfileFastL4, __self__).__init__(
            'f5bigip:ltm/profileFastL4:ProfileFastL4',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_timeout: Optional[pulumi.Input[builtins.int]] = None,
            defaults_from: Optional[pulumi.Input[builtins.str]] = None,
            explicitflow_migration: Optional[pulumi.Input[builtins.str]] = None,
            hardware_syncookie: Optional[pulumi.Input[builtins.str]] = None,
            idle_timeout: Optional[pulumi.Input[builtins.str]] = None,
            iptos_toclient: Optional[pulumi.Input[builtins.str]] = None,
            iptos_toserver: Optional[pulumi.Input[builtins.str]] = None,
            keepalive_interval: Optional[pulumi.Input[builtins.str]] = None,
            late_binding: Optional[pulumi.Input[builtins.str]] = None,
            loose_close: Optional[pulumi.Input[builtins.str]] = None,
            loose_initiation: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            partition: Optional[pulumi.Input[builtins.str]] = None,
            receive_windowsize: Optional[pulumi.Input[builtins.int]] = None,
            tcp_handshake_timeout: Optional[pulumi.Input[builtins.str]] = None) -> 'ProfileFastL4':
        """
        Get an existing ProfileFastL4 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] client_timeout: Specifies late binding client timeout in seconds. This setting specifies the number of seconds allowed for a client to transmit enough data to select a server when late binding is enabled. If it expires timeout-recovery mode will dictate what action to take.
        :param pulumi.Input[builtins.str] defaults_from: Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        :param pulumi.Input[builtins.str] explicitflow_migration: Enables or disables late binding explicit flow migration that allows iRules to control when flows move from software to hardware. Explicit flow migration is disabled by default hence BIG-IP automatically migrates flows from software to hardware.
        :param pulumi.Input[builtins.str] hardware_syncookie: Enables or disables hardware SYN cookie support when PVA10 is present on the system. Note that when you set the hardware syncookie option to enabled, you may also want to set the following bigdb database variables using the "/sys modify db" command, based on your requirements: pva.SynCookies.Full.ConnectionThreshold (default: 500000), pva.SynCookies.Assist.ConnectionThreshold (default: 500000) pva.SynCookies.ClientWindow (default: 0). The default value is disabled.
        :param pulumi.Input[builtins.str] idle_timeout: Specifies an idle timeout in seconds. This setting specifies the number of seconds that a connection is idle before the connection is eligible for deletion.When you specify an idle timeout for the Fast L4 profile, the value must be greater than the bigdb database variable Pva.Scrub time in msec for it to work properly.The default value is 300 seconds.
        :param pulumi.Input[builtins.str] iptos_toclient: Specifies an IP ToS number for the client side. This option specifies the Type of Service level that the traffic management system assigns to IP packets when sending them to clients. The default value is 65535 (pass-through), which indicates, do not modify.
        :param pulumi.Input[builtins.str] iptos_toserver: Specifies an IP ToS number for the server side. This setting specifies the Type of Service level that the traffic management system assigns to IP packets when sending them to servers. The default value is 65535 (pass-through), which indicates, do not modify.
        :param pulumi.Input[builtins.str] keepalive_interval: Specifies the keep alive probe interval, in seconds. The default value is disabled (0 seconds).
        :param pulumi.Input[builtins.str] late_binding: Enables intelligent selection of a back-end server or pool, using an iRule to make the selection. The default is `disabled`.
        :param pulumi.Input[builtins.str] loose_close: Specifies, when checked (enabled), that the system closes a loosely-initiated connection when the system receives the first FIN packet from either the client or the server. The default is disabled.
        :param pulumi.Input[builtins.str] loose_initiation: Specifies, when checked (enabled), that the system initializes a connection when it receives any TCP packet, rather that requiring a SYN packet for connection initiation. The default is disabled. We recommend that if you enable the Loose Initiation option, you also enable the Loose Close option.
        :param pulumi.Input[builtins.str] name: Name of the LTM fastL4 Profile.The full path is the combination of the `partition + name` of the resource (For example `/Common/my-fastl4profile`) or  `partition + directory + name` of the resource  (example: `/Common/test/my-fastl4profile`)
        :param pulumi.Input[builtins.str] partition: name of partition
        :param pulumi.Input[builtins.int] receive_windowsize: Specifies the amount of data the BIG-IP system can accept without acknowledging the server. The default is 0 (zero).
        :param pulumi.Input[builtins.str] tcp_handshake_timeout: Specifies the acceptable duration for a TCP handshake, that is, the maximum idle time between a client synchronization (SYN) and a client acknowledgment (ACK).The default is `5 seconds`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProfileFastL4State.__new__(_ProfileFastL4State)

        __props__.__dict__["client_timeout"] = client_timeout
        __props__.__dict__["defaults_from"] = defaults_from
        __props__.__dict__["explicitflow_migration"] = explicitflow_migration
        __props__.__dict__["hardware_syncookie"] = hardware_syncookie
        __props__.__dict__["idle_timeout"] = idle_timeout
        __props__.__dict__["iptos_toclient"] = iptos_toclient
        __props__.__dict__["iptos_toserver"] = iptos_toserver
        __props__.__dict__["keepalive_interval"] = keepalive_interval
        __props__.__dict__["late_binding"] = late_binding
        __props__.__dict__["loose_close"] = loose_close
        __props__.__dict__["loose_initiation"] = loose_initiation
        __props__.__dict__["name"] = name
        __props__.__dict__["partition"] = partition
        __props__.__dict__["receive_windowsize"] = receive_windowsize
        __props__.__dict__["tcp_handshake_timeout"] = tcp_handshake_timeout
        return ProfileFastL4(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clientTimeout")
    def client_timeout(self) -> pulumi.Output[builtins.int]:
        """
        Specifies late binding client timeout in seconds. This setting specifies the number of seconds allowed for a client to transmit enough data to select a server when late binding is enabled. If it expires timeout-recovery mode will dictate what action to take.
        """
        return pulumi.get(self, "client_timeout")

    @property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        """
        return pulumi.get(self, "defaults_from")

    @property
    @pulumi.getter(name="explicitflowMigration")
    def explicitflow_migration(self) -> pulumi.Output[builtins.str]:
        """
        Enables or disables late binding explicit flow migration that allows iRules to control when flows move from software to hardware. Explicit flow migration is disabled by default hence BIG-IP automatically migrates flows from software to hardware.
        """
        return pulumi.get(self, "explicitflow_migration")

    @property
    @pulumi.getter(name="hardwareSyncookie")
    def hardware_syncookie(self) -> pulumi.Output[builtins.str]:
        """
        Enables or disables hardware SYN cookie support when PVA10 is present on the system. Note that when you set the hardware syncookie option to enabled, you may also want to set the following bigdb database variables using the "/sys modify db" command, based on your requirements: pva.SynCookies.Full.ConnectionThreshold (default: 500000), pva.SynCookies.Assist.ConnectionThreshold (default: 500000) pva.SynCookies.ClientWindow (default: 0). The default value is disabled.
        """
        return pulumi.get(self, "hardware_syncookie")

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> pulumi.Output[builtins.str]:
        """
        Specifies an idle timeout in seconds. This setting specifies the number of seconds that a connection is idle before the connection is eligible for deletion.When you specify an idle timeout for the Fast L4 profile, the value must be greater than the bigdb database variable Pva.Scrub time in msec for it to work properly.The default value is 300 seconds.
        """
        return pulumi.get(self, "idle_timeout")

    @property
    @pulumi.getter(name="iptosToclient")
    def iptos_toclient(self) -> pulumi.Output[builtins.str]:
        """
        Specifies an IP ToS number for the client side. This option specifies the Type of Service level that the traffic management system assigns to IP packets when sending them to clients. The default value is 65535 (pass-through), which indicates, do not modify.
        """
        return pulumi.get(self, "iptos_toclient")

    @property
    @pulumi.getter(name="iptosToserver")
    def iptos_toserver(self) -> pulumi.Output[builtins.str]:
        """
        Specifies an IP ToS number for the server side. This setting specifies the Type of Service level that the traffic management system assigns to IP packets when sending them to servers. The default value is 65535 (pass-through), which indicates, do not modify.
        """
        return pulumi.get(self, "iptos_toserver")

    @property
    @pulumi.getter(name="keepaliveInterval")
    def keepalive_interval(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the keep alive probe interval, in seconds. The default value is disabled (0 seconds).
        """
        return pulumi.get(self, "keepalive_interval")

    @property
    @pulumi.getter(name="lateBinding")
    def late_binding(self) -> pulumi.Output[builtins.str]:
        """
        Enables intelligent selection of a back-end server or pool, using an iRule to make the selection. The default is `disabled`.
        """
        return pulumi.get(self, "late_binding")

    @property
    @pulumi.getter(name="looseClose")
    def loose_close(self) -> pulumi.Output[builtins.str]:
        """
        Specifies, when checked (enabled), that the system closes a loosely-initiated connection when the system receives the first FIN packet from either the client or the server. The default is disabled.
        """
        return pulumi.get(self, "loose_close")

    @property
    @pulumi.getter(name="looseInitiation")
    def loose_initiation(self) -> pulumi.Output[builtins.str]:
        """
        Specifies, when checked (enabled), that the system initializes a connection when it receives any TCP packet, rather that requiring a SYN packet for connection initiation. The default is disabled. We recommend that if you enable the Loose Initiation option, you also enable the Loose Close option.
        """
        return pulumi.get(self, "loose_initiation")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the LTM fastL4 Profile.The full path is the combination of the `partition + name` of the resource (For example `/Common/my-fastl4profile`) or  `partition + directory + name` of the resource  (example: `/Common/test/my-fastl4profile`)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def partition(self) -> pulumi.Output[builtins.str]:
        """
        name of partition
        """
        return pulumi.get(self, "partition")

    @property
    @pulumi.getter(name="receiveWindowsize")
    def receive_windowsize(self) -> pulumi.Output[builtins.int]:
        """
        Specifies the amount of data the BIG-IP system can accept without acknowledging the server. The default is 0 (zero).
        """
        return pulumi.get(self, "receive_windowsize")

    @property
    @pulumi.getter(name="tcpHandshakeTimeout")
    def tcp_handshake_timeout(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the acceptable duration for a TCP handshake, that is, the maximum idle time between a client synchronization (SYN) and a client acknowledgment (ACK).The default is `5 seconds`.
        """
        return pulumi.get(self, "tcp_handshake_timeout")

