# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ProfileHttpCompressArgs', 'ProfileHttpCompress']

@pulumi.input_type
class ProfileHttpCompressArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 compression_buffersize: Optional[pulumi.Input[builtins.int]] = None,
                 content_type_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 content_type_includes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 cpu_saver: Optional[pulumi.Input[builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[builtins.str]] = None,
                 gzip_compression_level: Optional[pulumi.Input[builtins.int]] = None,
                 gzip_memory_level: Optional[pulumi.Input[builtins.int]] = None,
                 gzip_window_size: Optional[pulumi.Input[builtins.int]] = None,
                 keep_accept_encoding: Optional[pulumi.Input[builtins.str]] = None,
                 uri_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 uri_includes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 vary_header: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ProfileHttpCompress resource.
        :param pulumi.Input[builtins.str] name: Name of the LTM http compress profile,named with their `full path`.The full path is the combination of the `partition + name` (example: `/Common/my-httpcompresprofile` ) or  `partition + directory + name` of the resource  (example: `my-httpcompresprofile`)
        :param pulumi.Input[builtins.int] compression_buffersize: Specifies the maximum number of compressed bytes that the system buffers before inserting a Content-Length header (which specifies the compressed size) into the response. The default is `4096` bytes.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] content_type_excludes: Excludes a specified list of content types from compression of HTTP Content-Type responses. Use a string list to specify a list of content types you want to compress.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] content_type_includes: Specifies a list of content types for compression of HTTP Content-Type responses. Use a string list to specify a list of content types you want to compress.
        :param pulumi.Input[builtins.str] cpu_saver: Specifies, when checked (enabled), that the system monitors the percent CPU usage and adjusts compression rates automatically when the CPU usage reaches either the CPU Saver High Threshold or the CPU Saver Low Threshold. The default is `enabled`.
        :param pulumi.Input[builtins.str] defaults_from: Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        :param pulumi.Input[builtins.int] gzip_compression_level: Specifies the degree to which the system compresses the content. Higher compression levels cause the compression process to be slower. The default is 1 - Least Compression (Fastest)
        :param pulumi.Input[builtins.int] gzip_memory_level: Specifies the number of bytes of memory that the system uses for internal compression buffers when compressing a server response. The default is `8 kilobytes/8192 bytes`.
        :param pulumi.Input[builtins.int] gzip_window_size: Specifies the number of kilobytes in the window size that the system uses when compressing a server response. The default is `16` kilobytes
        :param pulumi.Input[builtins.str] keep_accept_encoding: Specifies, when checked (enabled), that the system does not remove the Accept-Encoding: header from an HTTP request. The default is `disabled`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] uri_excludes: Disables compression on a specified list of HTTP Request-URI responses. Use a regular expression to specify a list of URIs you do not want to compress.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] uri_includes: Enables compression on a specified list of HTTP Request-URI responses. Use a regular expression to specify a list of URIs you want to compress.
        :param pulumi.Input[builtins.str] vary_header: Specifies, when checked (enabled), that the system inserts a Vary header into cacheable server responses. The default is `enabled`.
        """
        pulumi.set(__self__, "name", name)
        if compression_buffersize is not None:
            pulumi.set(__self__, "compression_buffersize", compression_buffersize)
        if content_type_excludes is not None:
            pulumi.set(__self__, "content_type_excludes", content_type_excludes)
        if content_type_includes is not None:
            pulumi.set(__self__, "content_type_includes", content_type_includes)
        if cpu_saver is not None:
            pulumi.set(__self__, "cpu_saver", cpu_saver)
        if defaults_from is not None:
            pulumi.set(__self__, "defaults_from", defaults_from)
        if gzip_compression_level is not None:
            pulumi.set(__self__, "gzip_compression_level", gzip_compression_level)
        if gzip_memory_level is not None:
            pulumi.set(__self__, "gzip_memory_level", gzip_memory_level)
        if gzip_window_size is not None:
            pulumi.set(__self__, "gzip_window_size", gzip_window_size)
        if keep_accept_encoding is not None:
            pulumi.set(__self__, "keep_accept_encoding", keep_accept_encoding)
        if uri_excludes is not None:
            pulumi.set(__self__, "uri_excludes", uri_excludes)
        if uri_includes is not None:
            pulumi.set(__self__, "uri_includes", uri_includes)
        if vary_header is not None:
            pulumi.set(__self__, "vary_header", vary_header)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the LTM http compress profile,named with their `full path`.The full path is the combination of the `partition + name` (example: `/Common/my-httpcompresprofile` ) or  `partition + directory + name` of the resource  (example: `my-httpcompresprofile`)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="compressionBuffersize")
    def compression_buffersize(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the maximum number of compressed bytes that the system buffers before inserting a Content-Length header (which specifies the compressed size) into the response. The default is `4096` bytes.
        """
        return pulumi.get(self, "compression_buffersize")

    @compression_buffersize.setter
    def compression_buffersize(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "compression_buffersize", value)

    @property
    @pulumi.getter(name="contentTypeExcludes")
    def content_type_excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Excludes a specified list of content types from compression of HTTP Content-Type responses. Use a string list to specify a list of content types you want to compress.
        """
        return pulumi.get(self, "content_type_excludes")

    @content_type_excludes.setter
    def content_type_excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "content_type_excludes", value)

    @property
    @pulumi.getter(name="contentTypeIncludes")
    def content_type_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of content types for compression of HTTP Content-Type responses. Use a string list to specify a list of content types you want to compress.
        """
        return pulumi.get(self, "content_type_includes")

    @content_type_includes.setter
    def content_type_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "content_type_includes", value)

    @property
    @pulumi.getter(name="cpuSaver")
    def cpu_saver(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies, when checked (enabled), that the system monitors the percent CPU usage and adjusts compression rates automatically when the CPU usage reaches either the CPU Saver High Threshold or the CPU Saver Low Threshold. The default is `enabled`.
        """
        return pulumi.get(self, "cpu_saver")

    @cpu_saver.setter
    def cpu_saver(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cpu_saver", value)

    @property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        """
        return pulumi.get(self, "defaults_from")

    @defaults_from.setter
    def defaults_from(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "defaults_from", value)

    @property
    @pulumi.getter(name="gzipCompressionLevel")
    def gzip_compression_level(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the degree to which the system compresses the content. Higher compression levels cause the compression process to be slower. The default is 1 - Least Compression (Fastest)
        """
        return pulumi.get(self, "gzip_compression_level")

    @gzip_compression_level.setter
    def gzip_compression_level(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "gzip_compression_level", value)

    @property
    @pulumi.getter(name="gzipMemoryLevel")
    def gzip_memory_level(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of bytes of memory that the system uses for internal compression buffers when compressing a server response. The default is `8 kilobytes/8192 bytes`.
        """
        return pulumi.get(self, "gzip_memory_level")

    @gzip_memory_level.setter
    def gzip_memory_level(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "gzip_memory_level", value)

    @property
    @pulumi.getter(name="gzipWindowSize")
    def gzip_window_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of kilobytes in the window size that the system uses when compressing a server response. The default is `16` kilobytes
        """
        return pulumi.get(self, "gzip_window_size")

    @gzip_window_size.setter
    def gzip_window_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "gzip_window_size", value)

    @property
    @pulumi.getter(name="keepAcceptEncoding")
    def keep_accept_encoding(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies, when checked (enabled), that the system does not remove the Accept-Encoding: header from an HTTP request. The default is `disabled`.
        """
        return pulumi.get(self, "keep_accept_encoding")

    @keep_accept_encoding.setter
    def keep_accept_encoding(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "keep_accept_encoding", value)

    @property
    @pulumi.getter(name="uriExcludes")
    def uri_excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Disables compression on a specified list of HTTP Request-URI responses. Use a regular expression to specify a list of URIs you do not want to compress.
        """
        return pulumi.get(self, "uri_excludes")

    @uri_excludes.setter
    def uri_excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "uri_excludes", value)

    @property
    @pulumi.getter(name="uriIncludes")
    def uri_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Enables compression on a specified list of HTTP Request-URI responses. Use a regular expression to specify a list of URIs you want to compress.
        """
        return pulumi.get(self, "uri_includes")

    @uri_includes.setter
    def uri_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "uri_includes", value)

    @property
    @pulumi.getter(name="varyHeader")
    def vary_header(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies, when checked (enabled), that the system inserts a Vary header into cacheable server responses. The default is `enabled`.
        """
        return pulumi.get(self, "vary_header")

    @vary_header.setter
    def vary_header(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vary_header", value)


@pulumi.input_type
class _ProfileHttpCompressState:
    def __init__(__self__, *,
                 compression_buffersize: Optional[pulumi.Input[builtins.int]] = None,
                 content_type_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 content_type_includes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 cpu_saver: Optional[pulumi.Input[builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[builtins.str]] = None,
                 gzip_compression_level: Optional[pulumi.Input[builtins.int]] = None,
                 gzip_memory_level: Optional[pulumi.Input[builtins.int]] = None,
                 gzip_window_size: Optional[pulumi.Input[builtins.int]] = None,
                 keep_accept_encoding: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 uri_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 uri_includes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 vary_header: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProfileHttpCompress resources.
        :param pulumi.Input[builtins.int] compression_buffersize: Specifies the maximum number of compressed bytes that the system buffers before inserting a Content-Length header (which specifies the compressed size) into the response. The default is `4096` bytes.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] content_type_excludes: Excludes a specified list of content types from compression of HTTP Content-Type responses. Use a string list to specify a list of content types you want to compress.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] content_type_includes: Specifies a list of content types for compression of HTTP Content-Type responses. Use a string list to specify a list of content types you want to compress.
        :param pulumi.Input[builtins.str] cpu_saver: Specifies, when checked (enabled), that the system monitors the percent CPU usage and adjusts compression rates automatically when the CPU usage reaches either the CPU Saver High Threshold or the CPU Saver Low Threshold. The default is `enabled`.
        :param pulumi.Input[builtins.str] defaults_from: Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        :param pulumi.Input[builtins.int] gzip_compression_level: Specifies the degree to which the system compresses the content. Higher compression levels cause the compression process to be slower. The default is 1 - Least Compression (Fastest)
        :param pulumi.Input[builtins.int] gzip_memory_level: Specifies the number of bytes of memory that the system uses for internal compression buffers when compressing a server response. The default is `8 kilobytes/8192 bytes`.
        :param pulumi.Input[builtins.int] gzip_window_size: Specifies the number of kilobytes in the window size that the system uses when compressing a server response. The default is `16` kilobytes
        :param pulumi.Input[builtins.str] keep_accept_encoding: Specifies, when checked (enabled), that the system does not remove the Accept-Encoding: header from an HTTP request. The default is `disabled`.
        :param pulumi.Input[builtins.str] name: Name of the LTM http compress profile,named with their `full path`.The full path is the combination of the `partition + name` (example: `/Common/my-httpcompresprofile` ) or  `partition + directory + name` of the resource  (example: `my-httpcompresprofile`)
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] uri_excludes: Disables compression on a specified list of HTTP Request-URI responses. Use a regular expression to specify a list of URIs you do not want to compress.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] uri_includes: Enables compression on a specified list of HTTP Request-URI responses. Use a regular expression to specify a list of URIs you want to compress.
        :param pulumi.Input[builtins.str] vary_header: Specifies, when checked (enabled), that the system inserts a Vary header into cacheable server responses. The default is `enabled`.
        """
        if compression_buffersize is not None:
            pulumi.set(__self__, "compression_buffersize", compression_buffersize)
        if content_type_excludes is not None:
            pulumi.set(__self__, "content_type_excludes", content_type_excludes)
        if content_type_includes is not None:
            pulumi.set(__self__, "content_type_includes", content_type_includes)
        if cpu_saver is not None:
            pulumi.set(__self__, "cpu_saver", cpu_saver)
        if defaults_from is not None:
            pulumi.set(__self__, "defaults_from", defaults_from)
        if gzip_compression_level is not None:
            pulumi.set(__self__, "gzip_compression_level", gzip_compression_level)
        if gzip_memory_level is not None:
            pulumi.set(__self__, "gzip_memory_level", gzip_memory_level)
        if gzip_window_size is not None:
            pulumi.set(__self__, "gzip_window_size", gzip_window_size)
        if keep_accept_encoding is not None:
            pulumi.set(__self__, "keep_accept_encoding", keep_accept_encoding)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if uri_excludes is not None:
            pulumi.set(__self__, "uri_excludes", uri_excludes)
        if uri_includes is not None:
            pulumi.set(__self__, "uri_includes", uri_includes)
        if vary_header is not None:
            pulumi.set(__self__, "vary_header", vary_header)

    @property
    @pulumi.getter(name="compressionBuffersize")
    def compression_buffersize(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the maximum number of compressed bytes that the system buffers before inserting a Content-Length header (which specifies the compressed size) into the response. The default is `4096` bytes.
        """
        return pulumi.get(self, "compression_buffersize")

    @compression_buffersize.setter
    def compression_buffersize(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "compression_buffersize", value)

    @property
    @pulumi.getter(name="contentTypeExcludes")
    def content_type_excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Excludes a specified list of content types from compression of HTTP Content-Type responses. Use a string list to specify a list of content types you want to compress.
        """
        return pulumi.get(self, "content_type_excludes")

    @content_type_excludes.setter
    def content_type_excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "content_type_excludes", value)

    @property
    @pulumi.getter(name="contentTypeIncludes")
    def content_type_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of content types for compression of HTTP Content-Type responses. Use a string list to specify a list of content types you want to compress.
        """
        return pulumi.get(self, "content_type_includes")

    @content_type_includes.setter
    def content_type_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "content_type_includes", value)

    @property
    @pulumi.getter(name="cpuSaver")
    def cpu_saver(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies, when checked (enabled), that the system monitors the percent CPU usage and adjusts compression rates automatically when the CPU usage reaches either the CPU Saver High Threshold or the CPU Saver Low Threshold. The default is `enabled`.
        """
        return pulumi.get(self, "cpu_saver")

    @cpu_saver.setter
    def cpu_saver(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cpu_saver", value)

    @property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        """
        return pulumi.get(self, "defaults_from")

    @defaults_from.setter
    def defaults_from(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "defaults_from", value)

    @property
    @pulumi.getter(name="gzipCompressionLevel")
    def gzip_compression_level(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the degree to which the system compresses the content. Higher compression levels cause the compression process to be slower. The default is 1 - Least Compression (Fastest)
        """
        return pulumi.get(self, "gzip_compression_level")

    @gzip_compression_level.setter
    def gzip_compression_level(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "gzip_compression_level", value)

    @property
    @pulumi.getter(name="gzipMemoryLevel")
    def gzip_memory_level(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of bytes of memory that the system uses for internal compression buffers when compressing a server response. The default is `8 kilobytes/8192 bytes`.
        """
        return pulumi.get(self, "gzip_memory_level")

    @gzip_memory_level.setter
    def gzip_memory_level(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "gzip_memory_level", value)

    @property
    @pulumi.getter(name="gzipWindowSize")
    def gzip_window_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of kilobytes in the window size that the system uses when compressing a server response. The default is `16` kilobytes
        """
        return pulumi.get(self, "gzip_window_size")

    @gzip_window_size.setter
    def gzip_window_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "gzip_window_size", value)

    @property
    @pulumi.getter(name="keepAcceptEncoding")
    def keep_accept_encoding(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies, when checked (enabled), that the system does not remove the Accept-Encoding: header from an HTTP request. The default is `disabled`.
        """
        return pulumi.get(self, "keep_accept_encoding")

    @keep_accept_encoding.setter
    def keep_accept_encoding(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "keep_accept_encoding", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the LTM http compress profile,named with their `full path`.The full path is the combination of the `partition + name` (example: `/Common/my-httpcompresprofile` ) or  `partition + directory + name` of the resource  (example: `my-httpcompresprofile`)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="uriExcludes")
    def uri_excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Disables compression on a specified list of HTTP Request-URI responses. Use a regular expression to specify a list of URIs you do not want to compress.
        """
        return pulumi.get(self, "uri_excludes")

    @uri_excludes.setter
    def uri_excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "uri_excludes", value)

    @property
    @pulumi.getter(name="uriIncludes")
    def uri_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Enables compression on a specified list of HTTP Request-URI responses. Use a regular expression to specify a list of URIs you want to compress.
        """
        return pulumi.get(self, "uri_includes")

    @uri_includes.setter
    def uri_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "uri_includes", value)

    @property
    @pulumi.getter(name="varyHeader")
    def vary_header(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies, when checked (enabled), that the system inserts a Vary header into cacheable server responses. The default is `enabled`.
        """
        return pulumi.get(self, "vary_header")

    @vary_header.setter
    def vary_header(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vary_header", value)


@pulumi.type_token("f5bigip:ltm/profileHttpCompress:ProfileHttpCompress")
class ProfileHttpCompress(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compression_buffersize: Optional[pulumi.Input[builtins.int]] = None,
                 content_type_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 content_type_includes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 cpu_saver: Optional[pulumi.Input[builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[builtins.str]] = None,
                 gzip_compression_level: Optional[pulumi.Input[builtins.int]] = None,
                 gzip_memory_level: Optional[pulumi.Input[builtins.int]] = None,
                 gzip_window_size: Optional[pulumi.Input[builtins.int]] = None,
                 keep_accept_encoding: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 uri_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 uri_includes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 vary_header: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        `ltm.ProfileHttpCompress`  Virtual server HTTP compression profile configuration

        Resources should be named with their `full path`.The full path is the combination of the `partition + name` (example: `/Common/my-httpcompresprofile` ) or  `partition + directory + name` of the resource  (example: `/Common/test/my-httpcompresprofile`)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        sjhttpcompression = f5bigip.ltm.ProfileHttpCompress("sjhttpcompression",
            name="/Common/sjhttpcompression2",
            defaults_from="/Common/httpcompression",
            uri_excludes=[
                "www.abc.f5.com",
                "www.abc2.f5.com",
            ],
            uri_includes=["www.xyzbc.cisco.com"],
            content_type_includes=["nicecontent.com"],
            content_type_excludes=["nicecontentexclude.com"])
        ```

        ## Import

        BIG-IP LTM HTTP Compress profiles can be imported using the `name`, e.g.

        ```sh
        $ pulumi import f5bigip:ltm/profileHttpCompress:ProfileHttpCompress test-httpcomprs_import /Common/test-httpcomprs
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] compression_buffersize: Specifies the maximum number of compressed bytes that the system buffers before inserting a Content-Length header (which specifies the compressed size) into the response. The default is `4096` bytes.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] content_type_excludes: Excludes a specified list of content types from compression of HTTP Content-Type responses. Use a string list to specify a list of content types you want to compress.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] content_type_includes: Specifies a list of content types for compression of HTTP Content-Type responses. Use a string list to specify a list of content types you want to compress.
        :param pulumi.Input[builtins.str] cpu_saver: Specifies, when checked (enabled), that the system monitors the percent CPU usage and adjusts compression rates automatically when the CPU usage reaches either the CPU Saver High Threshold or the CPU Saver Low Threshold. The default is `enabled`.
        :param pulumi.Input[builtins.str] defaults_from: Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        :param pulumi.Input[builtins.int] gzip_compression_level: Specifies the degree to which the system compresses the content. Higher compression levels cause the compression process to be slower. The default is 1 - Least Compression (Fastest)
        :param pulumi.Input[builtins.int] gzip_memory_level: Specifies the number of bytes of memory that the system uses for internal compression buffers when compressing a server response. The default is `8 kilobytes/8192 bytes`.
        :param pulumi.Input[builtins.int] gzip_window_size: Specifies the number of kilobytes in the window size that the system uses when compressing a server response. The default is `16` kilobytes
        :param pulumi.Input[builtins.str] keep_accept_encoding: Specifies, when checked (enabled), that the system does not remove the Accept-Encoding: header from an HTTP request. The default is `disabled`.
        :param pulumi.Input[builtins.str] name: Name of the LTM http compress profile,named with their `full path`.The full path is the combination of the `partition + name` (example: `/Common/my-httpcompresprofile` ) or  `partition + directory + name` of the resource  (example: `my-httpcompresprofile`)
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] uri_excludes: Disables compression on a specified list of HTTP Request-URI responses. Use a regular expression to specify a list of URIs you do not want to compress.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] uri_includes: Enables compression on a specified list of HTTP Request-URI responses. Use a regular expression to specify a list of URIs you want to compress.
        :param pulumi.Input[builtins.str] vary_header: Specifies, when checked (enabled), that the system inserts a Vary header into cacheable server responses. The default is `enabled`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProfileHttpCompressArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `ltm.ProfileHttpCompress`  Virtual server HTTP compression profile configuration

        Resources should be named with their `full path`.The full path is the combination of the `partition + name` (example: `/Common/my-httpcompresprofile` ) or  `partition + directory + name` of the resource  (example: `/Common/test/my-httpcompresprofile`)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        sjhttpcompression = f5bigip.ltm.ProfileHttpCompress("sjhttpcompression",
            name="/Common/sjhttpcompression2",
            defaults_from="/Common/httpcompression",
            uri_excludes=[
                "www.abc.f5.com",
                "www.abc2.f5.com",
            ],
            uri_includes=["www.xyzbc.cisco.com"],
            content_type_includes=["nicecontent.com"],
            content_type_excludes=["nicecontentexclude.com"])
        ```

        ## Import

        BIG-IP LTM HTTP Compress profiles can be imported using the `name`, e.g.

        ```sh
        $ pulumi import f5bigip:ltm/profileHttpCompress:ProfileHttpCompress test-httpcomprs_import /Common/test-httpcomprs
        ```

        :param str resource_name: The name of the resource.
        :param ProfileHttpCompressArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProfileHttpCompressArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compression_buffersize: Optional[pulumi.Input[builtins.int]] = None,
                 content_type_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 content_type_includes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 cpu_saver: Optional[pulumi.Input[builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[builtins.str]] = None,
                 gzip_compression_level: Optional[pulumi.Input[builtins.int]] = None,
                 gzip_memory_level: Optional[pulumi.Input[builtins.int]] = None,
                 gzip_window_size: Optional[pulumi.Input[builtins.int]] = None,
                 keep_accept_encoding: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 uri_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 uri_includes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 vary_header: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProfileHttpCompressArgs.__new__(ProfileHttpCompressArgs)

            __props__.__dict__["compression_buffersize"] = compression_buffersize
            __props__.__dict__["content_type_excludes"] = content_type_excludes
            __props__.__dict__["content_type_includes"] = content_type_includes
            __props__.__dict__["cpu_saver"] = cpu_saver
            __props__.__dict__["defaults_from"] = defaults_from
            __props__.__dict__["gzip_compression_level"] = gzip_compression_level
            __props__.__dict__["gzip_memory_level"] = gzip_memory_level
            __props__.__dict__["gzip_window_size"] = gzip_window_size
            __props__.__dict__["keep_accept_encoding"] = keep_accept_encoding
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["uri_excludes"] = uri_excludes
            __props__.__dict__["uri_includes"] = uri_includes
            __props__.__dict__["vary_header"] = vary_header
        super(ProfileHttpCompress, __self__).__init__(
            'f5bigip:ltm/profileHttpCompress:ProfileHttpCompress',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compression_buffersize: Optional[pulumi.Input[builtins.int]] = None,
            content_type_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            content_type_includes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            cpu_saver: Optional[pulumi.Input[builtins.str]] = None,
            defaults_from: Optional[pulumi.Input[builtins.str]] = None,
            gzip_compression_level: Optional[pulumi.Input[builtins.int]] = None,
            gzip_memory_level: Optional[pulumi.Input[builtins.int]] = None,
            gzip_window_size: Optional[pulumi.Input[builtins.int]] = None,
            keep_accept_encoding: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            uri_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            uri_includes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            vary_header: Optional[pulumi.Input[builtins.str]] = None) -> 'ProfileHttpCompress':
        """
        Get an existing ProfileHttpCompress resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] compression_buffersize: Specifies the maximum number of compressed bytes that the system buffers before inserting a Content-Length header (which specifies the compressed size) into the response. The default is `4096` bytes.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] content_type_excludes: Excludes a specified list of content types from compression of HTTP Content-Type responses. Use a string list to specify a list of content types you want to compress.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] content_type_includes: Specifies a list of content types for compression of HTTP Content-Type responses. Use a string list to specify a list of content types you want to compress.
        :param pulumi.Input[builtins.str] cpu_saver: Specifies, when checked (enabled), that the system monitors the percent CPU usage and adjusts compression rates automatically when the CPU usage reaches either the CPU Saver High Threshold or the CPU Saver Low Threshold. The default is `enabled`.
        :param pulumi.Input[builtins.str] defaults_from: Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        :param pulumi.Input[builtins.int] gzip_compression_level: Specifies the degree to which the system compresses the content. Higher compression levels cause the compression process to be slower. The default is 1 - Least Compression (Fastest)
        :param pulumi.Input[builtins.int] gzip_memory_level: Specifies the number of bytes of memory that the system uses for internal compression buffers when compressing a server response. The default is `8 kilobytes/8192 bytes`.
        :param pulumi.Input[builtins.int] gzip_window_size: Specifies the number of kilobytes in the window size that the system uses when compressing a server response. The default is `16` kilobytes
        :param pulumi.Input[builtins.str] keep_accept_encoding: Specifies, when checked (enabled), that the system does not remove the Accept-Encoding: header from an HTTP request. The default is `disabled`.
        :param pulumi.Input[builtins.str] name: Name of the LTM http compress profile,named with their `full path`.The full path is the combination of the `partition + name` (example: `/Common/my-httpcompresprofile` ) or  `partition + directory + name` of the resource  (example: `my-httpcompresprofile`)
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] uri_excludes: Disables compression on a specified list of HTTP Request-URI responses. Use a regular expression to specify a list of URIs you do not want to compress.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] uri_includes: Enables compression on a specified list of HTTP Request-URI responses. Use a regular expression to specify a list of URIs you want to compress.
        :param pulumi.Input[builtins.str] vary_header: Specifies, when checked (enabled), that the system inserts a Vary header into cacheable server responses. The default is `enabled`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProfileHttpCompressState.__new__(_ProfileHttpCompressState)

        __props__.__dict__["compression_buffersize"] = compression_buffersize
        __props__.__dict__["content_type_excludes"] = content_type_excludes
        __props__.__dict__["content_type_includes"] = content_type_includes
        __props__.__dict__["cpu_saver"] = cpu_saver
        __props__.__dict__["defaults_from"] = defaults_from
        __props__.__dict__["gzip_compression_level"] = gzip_compression_level
        __props__.__dict__["gzip_memory_level"] = gzip_memory_level
        __props__.__dict__["gzip_window_size"] = gzip_window_size
        __props__.__dict__["keep_accept_encoding"] = keep_accept_encoding
        __props__.__dict__["name"] = name
        __props__.__dict__["uri_excludes"] = uri_excludes
        __props__.__dict__["uri_includes"] = uri_includes
        __props__.__dict__["vary_header"] = vary_header
        return ProfileHttpCompress(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compressionBuffersize")
    def compression_buffersize(self) -> pulumi.Output[builtins.int]:
        """
        Specifies the maximum number of compressed bytes that the system buffers before inserting a Content-Length header (which specifies the compressed size) into the response. The default is `4096` bytes.
        """
        return pulumi.get(self, "compression_buffersize")

    @property
    @pulumi.getter(name="contentTypeExcludes")
    def content_type_excludes(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Excludes a specified list of content types from compression of HTTP Content-Type responses. Use a string list to specify a list of content types you want to compress.
        """
        return pulumi.get(self, "content_type_excludes")

    @property
    @pulumi.getter(name="contentTypeIncludes")
    def content_type_includes(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Specifies a list of content types for compression of HTTP Content-Type responses. Use a string list to specify a list of content types you want to compress.
        """
        return pulumi.get(self, "content_type_includes")

    @property
    @pulumi.getter(name="cpuSaver")
    def cpu_saver(self) -> pulumi.Output[builtins.str]:
        """
        Specifies, when checked (enabled), that the system monitors the percent CPU usage and adjusts compression rates automatically when the CPU usage reaches either the CPU Saver High Threshold or the CPU Saver Low Threshold. The default is `enabled`.
        """
        return pulumi.get(self, "cpu_saver")

    @property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        """
        return pulumi.get(self, "defaults_from")

    @property
    @pulumi.getter(name="gzipCompressionLevel")
    def gzip_compression_level(self) -> pulumi.Output[builtins.int]:
        """
        Specifies the degree to which the system compresses the content. Higher compression levels cause the compression process to be slower. The default is 1 - Least Compression (Fastest)
        """
        return pulumi.get(self, "gzip_compression_level")

    @property
    @pulumi.getter(name="gzipMemoryLevel")
    def gzip_memory_level(self) -> pulumi.Output[builtins.int]:
        """
        Specifies the number of bytes of memory that the system uses for internal compression buffers when compressing a server response. The default is `8 kilobytes/8192 bytes`.
        """
        return pulumi.get(self, "gzip_memory_level")

    @property
    @pulumi.getter(name="gzipWindowSize")
    def gzip_window_size(self) -> pulumi.Output[builtins.int]:
        """
        Specifies the number of kilobytes in the window size that the system uses when compressing a server response. The default is `16` kilobytes
        """
        return pulumi.get(self, "gzip_window_size")

    @property
    @pulumi.getter(name="keepAcceptEncoding")
    def keep_accept_encoding(self) -> pulumi.Output[builtins.str]:
        """
        Specifies, when checked (enabled), that the system does not remove the Accept-Encoding: header from an HTTP request. The default is `disabled`.
        """
        return pulumi.get(self, "keep_accept_encoding")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the LTM http compress profile,named with their `full path`.The full path is the combination of the `partition + name` (example: `/Common/my-httpcompresprofile` ) or  `partition + directory + name` of the resource  (example: `my-httpcompresprofile`)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="uriExcludes")
    def uri_excludes(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Disables compression on a specified list of HTTP Request-URI responses. Use a regular expression to specify a list of URIs you do not want to compress.
        """
        return pulumi.get(self, "uri_excludes")

    @property
    @pulumi.getter(name="uriIncludes")
    def uri_includes(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Enables compression on a specified list of HTTP Request-URI responses. Use a regular expression to specify a list of URIs you want to compress.
        """
        return pulumi.get(self, "uri_includes")

    @property
    @pulumi.getter(name="varyHeader")
    def vary_header(self) -> pulumi.Output[builtins.str]:
        """
        Specifies, when checked (enabled), that the system inserts a Vary header into cacheable server responses. The default is `enabled`.
        """
        return pulumi.get(self, "vary_header")

