# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProfileRewriteArgs', 'ProfileRewrite']

@pulumi.input_type
class ProfileRewriteArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 rewrite_mode: pulumi.Input[builtins.str],
                 bypass_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ca_file: Optional[pulumi.Input[builtins.str]] = None,
                 cache_type: Optional[pulumi.Input[builtins.str]] = None,
                 cookie_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileRewriteCookieRuleArgs']]]] = None,
                 crl_file: Optional[pulumi.Input[builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[builtins.str]] = None,
                 requests: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileRewriteRequestArgs']]]] = None,
                 responses: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileRewriteResponseArgs']]]] = None,
                 rewrite_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 signing_cert: Optional[pulumi.Input[builtins.str]] = None,
                 signing_key: Optional[pulumi.Input[builtins.str]] = None,
                 signing_key_password: Optional[pulumi.Input[builtins.str]] = None,
                 split_tunneling: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ProfileRewrite resource.
        :param pulumi.Input[builtins.str] name: Name of the rewrite profile. ( profile name should be in full path which is combination of partition and profile name )
        :param pulumi.Input[builtins.str] rewrite_mode: Specifies the type of Client caching. Valid choices are: `portal, uri-translation`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] bypass_lists: Specifies a list of URIs to bypass inside a web page when the page is accessed using Portal Access.
        :param pulumi.Input[builtins.str] ca_file: Specifies a CA against which to verify signed Java applets signatures. (name should be in full path which is combination of partition and CA file name )
        :param pulumi.Input[builtins.str] cache_type: Specifies the type of Client caching. Valid choices are: `cache-css-js, cache-all, no-cache, cache-img-css-js`. Default value: `cache-img-css-js`
        :param pulumi.Input[Sequence[pulumi.Input['ProfileRewriteCookieRuleArgs']]] cookie_rules: Specifies the cookie rewrite rules. Block type. Each request is block type with following arguments.
        :param pulumi.Input[builtins.str] crl_file: Specifies a CRL against which to verify signed Java applets signature certificates. The default option is `none`.
        :param pulumi.Input[builtins.str] defaults_from: Specifies the profile from which this profile inherits settings. The default is the system-supplied `rewrite` profile.
        :param pulumi.Input[Sequence[pulumi.Input['ProfileRewriteRequestArgs']]] requests: Block type. Each request is block type with following arguments.
        :param pulumi.Input[Sequence[pulumi.Input['ProfileRewriteResponseArgs']]] responses: Block type. Each request is block type with following arguments.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] rewrite_lists: Specifies a list of URIs to rewrite inside a web page when the page is accessed using Portal Access.
        :param pulumi.Input[builtins.str] signing_cert: Specifies a certificate to use for re-signing of signed Java applets after patching. (name should be in full path which is combination of partition and certificate name )
        :param pulumi.Input[builtins.str] signing_key: Specifies a certificate to use for re-signing of signed Java applets after patching. (name should be in full path which is combination of partition and key name )
        :param pulumi.Input[builtins.str] signing_key_password: Specifies a pass phrase to use for encrypting the private signing key. Since it's a sensitive entity idempotency will fail in the update call.
        :param pulumi.Input[builtins.str] split_tunneling: Specifies the type of Client caching. Valid choices are: `true, false`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rewrite_mode", rewrite_mode)
        if bypass_lists is not None:
            pulumi.set(__self__, "bypass_lists", bypass_lists)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if cache_type is not None:
            pulumi.set(__self__, "cache_type", cache_type)
        if cookie_rules is not None:
            pulumi.set(__self__, "cookie_rules", cookie_rules)
        if crl_file is not None:
            pulumi.set(__self__, "crl_file", crl_file)
        if defaults_from is not None:
            pulumi.set(__self__, "defaults_from", defaults_from)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)
        if responses is not None:
            pulumi.set(__self__, "responses", responses)
        if rewrite_lists is not None:
            pulumi.set(__self__, "rewrite_lists", rewrite_lists)
        if signing_cert is not None:
            pulumi.set(__self__, "signing_cert", signing_cert)
        if signing_key is not None:
            pulumi.set(__self__, "signing_key", signing_key)
        if signing_key_password is not None:
            pulumi.set(__self__, "signing_key_password", signing_key_password)
        if split_tunneling is not None:
            pulumi.set(__self__, "split_tunneling", split_tunneling)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the rewrite profile. ( profile name should be in full path which is combination of partition and profile name )
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="rewriteMode")
    def rewrite_mode(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the type of Client caching. Valid choices are: `portal, uri-translation`
        """
        return pulumi.get(self, "rewrite_mode")

    @rewrite_mode.setter
    def rewrite_mode(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "rewrite_mode", value)

    @property
    @pulumi.getter(name="bypassLists")
    def bypass_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of URIs to bypass inside a web page when the page is accessed using Portal Access.
        """
        return pulumi.get(self, "bypass_lists")

    @bypass_lists.setter
    def bypass_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "bypass_lists", value)

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a CA against which to verify signed Java applets signatures. (name should be in full path which is combination of partition and CA file name )
        """
        return pulumi.get(self, "ca_file")

    @ca_file.setter
    def ca_file(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ca_file", value)

    @property
    @pulumi.getter(name="cacheType")
    def cache_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the type of Client caching. Valid choices are: `cache-css-js, cache-all, no-cache, cache-img-css-js`. Default value: `cache-img-css-js`
        """
        return pulumi.get(self, "cache_type")

    @cache_type.setter
    def cache_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cache_type", value)

    @property
    @pulumi.getter(name="cookieRules")
    def cookie_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProfileRewriteCookieRuleArgs']]]]:
        """
        Specifies the cookie rewrite rules. Block type. Each request is block type with following arguments.
        """
        return pulumi.get(self, "cookie_rules")

    @cookie_rules.setter
    def cookie_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileRewriteCookieRuleArgs']]]]):
        pulumi.set(self, "cookie_rules", value)

    @property
    @pulumi.getter(name="crlFile")
    def crl_file(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a CRL against which to verify signed Java applets signature certificates. The default option is `none`.
        """
        return pulumi.get(self, "crl_file")

    @crl_file.setter
    def crl_file(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "crl_file", value)

    @property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the profile from which this profile inherits settings. The default is the system-supplied `rewrite` profile.
        """
        return pulumi.get(self, "defaults_from")

    @defaults_from.setter
    def defaults_from(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "defaults_from", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProfileRewriteRequestArgs']]]]:
        """
        Block type. Each request is block type with following arguments.
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileRewriteRequestArgs']]]]):
        pulumi.set(self, "requests", value)

    @property
    @pulumi.getter
    def responses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProfileRewriteResponseArgs']]]]:
        """
        Block type. Each request is block type with following arguments.
        """
        return pulumi.get(self, "responses")

    @responses.setter
    def responses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileRewriteResponseArgs']]]]):
        pulumi.set(self, "responses", value)

    @property
    @pulumi.getter(name="rewriteLists")
    def rewrite_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of URIs to rewrite inside a web page when the page is accessed using Portal Access.
        """
        return pulumi.get(self, "rewrite_lists")

    @rewrite_lists.setter
    def rewrite_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "rewrite_lists", value)

    @property
    @pulumi.getter(name="signingCert")
    def signing_cert(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a certificate to use for re-signing of signed Java applets after patching. (name should be in full path which is combination of partition and certificate name )
        """
        return pulumi.get(self, "signing_cert")

    @signing_cert.setter
    def signing_cert(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "signing_cert", value)

    @property
    @pulumi.getter(name="signingKey")
    def signing_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a certificate to use for re-signing of signed Java applets after patching. (name should be in full path which is combination of partition and key name )
        """
        return pulumi.get(self, "signing_key")

    @signing_key.setter
    def signing_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "signing_key", value)

    @property
    @pulumi.getter(name="signingKeyPassword")
    def signing_key_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a pass phrase to use for encrypting the private signing key. Since it's a sensitive entity idempotency will fail in the update call.
        """
        return pulumi.get(self, "signing_key_password")

    @signing_key_password.setter
    def signing_key_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "signing_key_password", value)

    @property
    @pulumi.getter(name="splitTunneling")
    def split_tunneling(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the type of Client caching. Valid choices are: `true, false`
        """
        return pulumi.get(self, "split_tunneling")

    @split_tunneling.setter
    def split_tunneling(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "split_tunneling", value)


@pulumi.input_type
class _ProfileRewriteState:
    def __init__(__self__, *,
                 bypass_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ca_file: Optional[pulumi.Input[builtins.str]] = None,
                 cache_type: Optional[pulumi.Input[builtins.str]] = None,
                 cookie_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileRewriteCookieRuleArgs']]]] = None,
                 crl_file: Optional[pulumi.Input[builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 requests: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileRewriteRequestArgs']]]] = None,
                 responses: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileRewriteResponseArgs']]]] = None,
                 rewrite_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 rewrite_mode: Optional[pulumi.Input[builtins.str]] = None,
                 signing_cert: Optional[pulumi.Input[builtins.str]] = None,
                 signing_key: Optional[pulumi.Input[builtins.str]] = None,
                 signing_key_password: Optional[pulumi.Input[builtins.str]] = None,
                 split_tunneling: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProfileRewrite resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] bypass_lists: Specifies a list of URIs to bypass inside a web page when the page is accessed using Portal Access.
        :param pulumi.Input[builtins.str] ca_file: Specifies a CA against which to verify signed Java applets signatures. (name should be in full path which is combination of partition and CA file name )
        :param pulumi.Input[builtins.str] cache_type: Specifies the type of Client caching. Valid choices are: `cache-css-js, cache-all, no-cache, cache-img-css-js`. Default value: `cache-img-css-js`
        :param pulumi.Input[Sequence[pulumi.Input['ProfileRewriteCookieRuleArgs']]] cookie_rules: Specifies the cookie rewrite rules. Block type. Each request is block type with following arguments.
        :param pulumi.Input[builtins.str] crl_file: Specifies a CRL against which to verify signed Java applets signature certificates. The default option is `none`.
        :param pulumi.Input[builtins.str] defaults_from: Specifies the profile from which this profile inherits settings. The default is the system-supplied `rewrite` profile.
        :param pulumi.Input[builtins.str] name: Name of the rewrite profile. ( profile name should be in full path which is combination of partition and profile name )
        :param pulumi.Input[Sequence[pulumi.Input['ProfileRewriteRequestArgs']]] requests: Block type. Each request is block type with following arguments.
        :param pulumi.Input[Sequence[pulumi.Input['ProfileRewriteResponseArgs']]] responses: Block type. Each request is block type with following arguments.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] rewrite_lists: Specifies a list of URIs to rewrite inside a web page when the page is accessed using Portal Access.
        :param pulumi.Input[builtins.str] rewrite_mode: Specifies the type of Client caching. Valid choices are: `portal, uri-translation`
        :param pulumi.Input[builtins.str] signing_cert: Specifies a certificate to use for re-signing of signed Java applets after patching. (name should be in full path which is combination of partition and certificate name )
        :param pulumi.Input[builtins.str] signing_key: Specifies a certificate to use for re-signing of signed Java applets after patching. (name should be in full path which is combination of partition and key name )
        :param pulumi.Input[builtins.str] signing_key_password: Specifies a pass phrase to use for encrypting the private signing key. Since it's a sensitive entity idempotency will fail in the update call.
        :param pulumi.Input[builtins.str] split_tunneling: Specifies the type of Client caching. Valid choices are: `true, false`
        """
        if bypass_lists is not None:
            pulumi.set(__self__, "bypass_lists", bypass_lists)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if cache_type is not None:
            pulumi.set(__self__, "cache_type", cache_type)
        if cookie_rules is not None:
            pulumi.set(__self__, "cookie_rules", cookie_rules)
        if crl_file is not None:
            pulumi.set(__self__, "crl_file", crl_file)
        if defaults_from is not None:
            pulumi.set(__self__, "defaults_from", defaults_from)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)
        if responses is not None:
            pulumi.set(__self__, "responses", responses)
        if rewrite_lists is not None:
            pulumi.set(__self__, "rewrite_lists", rewrite_lists)
        if rewrite_mode is not None:
            pulumi.set(__self__, "rewrite_mode", rewrite_mode)
        if signing_cert is not None:
            pulumi.set(__self__, "signing_cert", signing_cert)
        if signing_key is not None:
            pulumi.set(__self__, "signing_key", signing_key)
        if signing_key_password is not None:
            pulumi.set(__self__, "signing_key_password", signing_key_password)
        if split_tunneling is not None:
            pulumi.set(__self__, "split_tunneling", split_tunneling)

    @property
    @pulumi.getter(name="bypassLists")
    def bypass_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of URIs to bypass inside a web page when the page is accessed using Portal Access.
        """
        return pulumi.get(self, "bypass_lists")

    @bypass_lists.setter
    def bypass_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "bypass_lists", value)

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a CA against which to verify signed Java applets signatures. (name should be in full path which is combination of partition and CA file name )
        """
        return pulumi.get(self, "ca_file")

    @ca_file.setter
    def ca_file(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ca_file", value)

    @property
    @pulumi.getter(name="cacheType")
    def cache_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the type of Client caching. Valid choices are: `cache-css-js, cache-all, no-cache, cache-img-css-js`. Default value: `cache-img-css-js`
        """
        return pulumi.get(self, "cache_type")

    @cache_type.setter
    def cache_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cache_type", value)

    @property
    @pulumi.getter(name="cookieRules")
    def cookie_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProfileRewriteCookieRuleArgs']]]]:
        """
        Specifies the cookie rewrite rules. Block type. Each request is block type with following arguments.
        """
        return pulumi.get(self, "cookie_rules")

    @cookie_rules.setter
    def cookie_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileRewriteCookieRuleArgs']]]]):
        pulumi.set(self, "cookie_rules", value)

    @property
    @pulumi.getter(name="crlFile")
    def crl_file(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a CRL against which to verify signed Java applets signature certificates. The default option is `none`.
        """
        return pulumi.get(self, "crl_file")

    @crl_file.setter
    def crl_file(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "crl_file", value)

    @property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the profile from which this profile inherits settings. The default is the system-supplied `rewrite` profile.
        """
        return pulumi.get(self, "defaults_from")

    @defaults_from.setter
    def defaults_from(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "defaults_from", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the rewrite profile. ( profile name should be in full path which is combination of partition and profile name )
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProfileRewriteRequestArgs']]]]:
        """
        Block type. Each request is block type with following arguments.
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileRewriteRequestArgs']]]]):
        pulumi.set(self, "requests", value)

    @property
    @pulumi.getter
    def responses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProfileRewriteResponseArgs']]]]:
        """
        Block type. Each request is block type with following arguments.
        """
        return pulumi.get(self, "responses")

    @responses.setter
    def responses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileRewriteResponseArgs']]]]):
        pulumi.set(self, "responses", value)

    @property
    @pulumi.getter(name="rewriteLists")
    def rewrite_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of URIs to rewrite inside a web page when the page is accessed using Portal Access.
        """
        return pulumi.get(self, "rewrite_lists")

    @rewrite_lists.setter
    def rewrite_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "rewrite_lists", value)

    @property
    @pulumi.getter(name="rewriteMode")
    def rewrite_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the type of Client caching. Valid choices are: `portal, uri-translation`
        """
        return pulumi.get(self, "rewrite_mode")

    @rewrite_mode.setter
    def rewrite_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rewrite_mode", value)

    @property
    @pulumi.getter(name="signingCert")
    def signing_cert(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a certificate to use for re-signing of signed Java applets after patching. (name should be in full path which is combination of partition and certificate name )
        """
        return pulumi.get(self, "signing_cert")

    @signing_cert.setter
    def signing_cert(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "signing_cert", value)

    @property
    @pulumi.getter(name="signingKey")
    def signing_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a certificate to use for re-signing of signed Java applets after patching. (name should be in full path which is combination of partition and key name )
        """
        return pulumi.get(self, "signing_key")

    @signing_key.setter
    def signing_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "signing_key", value)

    @property
    @pulumi.getter(name="signingKeyPassword")
    def signing_key_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a pass phrase to use for encrypting the private signing key. Since it's a sensitive entity idempotency will fail in the update call.
        """
        return pulumi.get(self, "signing_key_password")

    @signing_key_password.setter
    def signing_key_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "signing_key_password", value)

    @property
    @pulumi.getter(name="splitTunneling")
    def split_tunneling(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the type of Client caching. Valid choices are: `true, false`
        """
        return pulumi.get(self, "split_tunneling")

    @split_tunneling.setter
    def split_tunneling(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "split_tunneling", value)


@pulumi.type_token("f5bigip:ltm/profileRewrite:ProfileRewrite")
class ProfileRewrite(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bypass_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ca_file: Optional[pulumi.Input[builtins.str]] = None,
                 cache_type: Optional[pulumi.Input[builtins.str]] = None,
                 cookie_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProfileRewriteCookieRuleArgs', 'ProfileRewriteCookieRuleArgsDict']]]]] = None,
                 crl_file: Optional[pulumi.Input[builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 requests: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProfileRewriteRequestArgs', 'ProfileRewriteRequestArgsDict']]]]] = None,
                 responses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProfileRewriteResponseArgs', 'ProfileRewriteResponseArgsDict']]]]] = None,
                 rewrite_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 rewrite_mode: Optional[pulumi.Input[builtins.str]] = None,
                 signing_cert: Optional[pulumi.Input[builtins.str]] = None,
                 signing_key: Optional[pulumi.Input[builtins.str]] = None,
                 signing_key_password: Optional[pulumi.Input[builtins.str]] = None,
                 split_tunneling: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        `bigip_ltm_rewrite_profile` Configures ltm policies to manage traffic assigned to a virtual server

        For resources should be named with their `full path`. The full path is the combination of the `partition + name` of the resource. For example `/Common/test-profile`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        test_profile = f5bigip.ltm.ProfileRewrite("test-profile",
            name="/Common/tf_profile",
            defaults_from="/Common/rewrite",
            bypass_lists=["http://notouch.com"],
            rewrite_lists=["http://some.com"],
            rewrite_mode="portal",
            cache_type="cache-img-css-js",
            ca_file="/Common/ca-bundle.crt",
            crl_file="none",
            signing_cert="/Common/default.crt",
            signing_key="/Common/default.key",
            split_tunneling="true")
        test_profile2 = f5bigip.ltm.ProfileRewrite("test-profile2",
            name="/Common/tf_profile_translate",
            defaults_from="/Common/rewrite",
            rewrite_mode="uri-translation",
            requests=[{
                "insert_xfwd_for": "enabled",
                "insert_xfwd_host": "disabled",
                "insert_xfwd_protocol": "enabled",
                "rewrite_headers": "disabled",
            }],
            responses=[{
                "rewrite_content": "enabled",
                "rewrite_headers": "disabled",
            }],
            cookie_rules=[
                {
                    "rule_name": "cookie1",
                    "client_domain": "wrong.com",
                    "client_path": "/this/",
                    "server_domain": "wrong.com",
                    "server_path": "/this/",
                },
                {
                    "rule_name": "cookie2",
                    "client_domain": "incorrect.com",
                    "client_path": "/this/",
                    "server_domain": "absolute.com",
                    "server_path": "/this/",
                },
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] bypass_lists: Specifies a list of URIs to bypass inside a web page when the page is accessed using Portal Access.
        :param pulumi.Input[builtins.str] ca_file: Specifies a CA against which to verify signed Java applets signatures. (name should be in full path which is combination of partition and CA file name )
        :param pulumi.Input[builtins.str] cache_type: Specifies the type of Client caching. Valid choices are: `cache-css-js, cache-all, no-cache, cache-img-css-js`. Default value: `cache-img-css-js`
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProfileRewriteCookieRuleArgs', 'ProfileRewriteCookieRuleArgsDict']]]] cookie_rules: Specifies the cookie rewrite rules. Block type. Each request is block type with following arguments.
        :param pulumi.Input[builtins.str] crl_file: Specifies a CRL against which to verify signed Java applets signature certificates. The default option is `none`.
        :param pulumi.Input[builtins.str] defaults_from: Specifies the profile from which this profile inherits settings. The default is the system-supplied `rewrite` profile.
        :param pulumi.Input[builtins.str] name: Name of the rewrite profile. ( profile name should be in full path which is combination of partition and profile name )
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProfileRewriteRequestArgs', 'ProfileRewriteRequestArgsDict']]]] requests: Block type. Each request is block type with following arguments.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProfileRewriteResponseArgs', 'ProfileRewriteResponseArgsDict']]]] responses: Block type. Each request is block type with following arguments.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] rewrite_lists: Specifies a list of URIs to rewrite inside a web page when the page is accessed using Portal Access.
        :param pulumi.Input[builtins.str] rewrite_mode: Specifies the type of Client caching. Valid choices are: `portal, uri-translation`
        :param pulumi.Input[builtins.str] signing_cert: Specifies a certificate to use for re-signing of signed Java applets after patching. (name should be in full path which is combination of partition and certificate name )
        :param pulumi.Input[builtins.str] signing_key: Specifies a certificate to use for re-signing of signed Java applets after patching. (name should be in full path which is combination of partition and key name )
        :param pulumi.Input[builtins.str] signing_key_password: Specifies a pass phrase to use for encrypting the private signing key. Since it's a sensitive entity idempotency will fail in the update call.
        :param pulumi.Input[builtins.str] split_tunneling: Specifies the type of Client caching. Valid choices are: `true, false`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProfileRewriteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `bigip_ltm_rewrite_profile` Configures ltm policies to manage traffic assigned to a virtual server

        For resources should be named with their `full path`. The full path is the combination of the `partition + name` of the resource. For example `/Common/test-profile`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        test_profile = f5bigip.ltm.ProfileRewrite("test-profile",
            name="/Common/tf_profile",
            defaults_from="/Common/rewrite",
            bypass_lists=["http://notouch.com"],
            rewrite_lists=["http://some.com"],
            rewrite_mode="portal",
            cache_type="cache-img-css-js",
            ca_file="/Common/ca-bundle.crt",
            crl_file="none",
            signing_cert="/Common/default.crt",
            signing_key="/Common/default.key",
            split_tunneling="true")
        test_profile2 = f5bigip.ltm.ProfileRewrite("test-profile2",
            name="/Common/tf_profile_translate",
            defaults_from="/Common/rewrite",
            rewrite_mode="uri-translation",
            requests=[{
                "insert_xfwd_for": "enabled",
                "insert_xfwd_host": "disabled",
                "insert_xfwd_protocol": "enabled",
                "rewrite_headers": "disabled",
            }],
            responses=[{
                "rewrite_content": "enabled",
                "rewrite_headers": "disabled",
            }],
            cookie_rules=[
                {
                    "rule_name": "cookie1",
                    "client_domain": "wrong.com",
                    "client_path": "/this/",
                    "server_domain": "wrong.com",
                    "server_path": "/this/",
                },
                {
                    "rule_name": "cookie2",
                    "client_domain": "incorrect.com",
                    "client_path": "/this/",
                    "server_domain": "absolute.com",
                    "server_path": "/this/",
                },
            ])
        ```

        :param str resource_name: The name of the resource.
        :param ProfileRewriteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProfileRewriteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bypass_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ca_file: Optional[pulumi.Input[builtins.str]] = None,
                 cache_type: Optional[pulumi.Input[builtins.str]] = None,
                 cookie_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProfileRewriteCookieRuleArgs', 'ProfileRewriteCookieRuleArgsDict']]]]] = None,
                 crl_file: Optional[pulumi.Input[builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 requests: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProfileRewriteRequestArgs', 'ProfileRewriteRequestArgsDict']]]]] = None,
                 responses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProfileRewriteResponseArgs', 'ProfileRewriteResponseArgsDict']]]]] = None,
                 rewrite_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 rewrite_mode: Optional[pulumi.Input[builtins.str]] = None,
                 signing_cert: Optional[pulumi.Input[builtins.str]] = None,
                 signing_key: Optional[pulumi.Input[builtins.str]] = None,
                 signing_key_password: Optional[pulumi.Input[builtins.str]] = None,
                 split_tunneling: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProfileRewriteArgs.__new__(ProfileRewriteArgs)

            __props__.__dict__["bypass_lists"] = bypass_lists
            __props__.__dict__["ca_file"] = ca_file
            __props__.__dict__["cache_type"] = cache_type
            __props__.__dict__["cookie_rules"] = cookie_rules
            __props__.__dict__["crl_file"] = crl_file
            __props__.__dict__["defaults_from"] = defaults_from
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["requests"] = requests
            __props__.__dict__["responses"] = responses
            __props__.__dict__["rewrite_lists"] = rewrite_lists
            if rewrite_mode is None and not opts.urn:
                raise TypeError("Missing required property 'rewrite_mode'")
            __props__.__dict__["rewrite_mode"] = rewrite_mode
            __props__.__dict__["signing_cert"] = signing_cert
            __props__.__dict__["signing_key"] = signing_key
            __props__.__dict__["signing_key_password"] = None if signing_key_password is None else pulumi.Output.secret(signing_key_password)
            __props__.__dict__["split_tunneling"] = split_tunneling
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["signingKeyPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ProfileRewrite, __self__).__init__(
            'f5bigip:ltm/profileRewrite:ProfileRewrite',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bypass_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            ca_file: Optional[pulumi.Input[builtins.str]] = None,
            cache_type: Optional[pulumi.Input[builtins.str]] = None,
            cookie_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProfileRewriteCookieRuleArgs', 'ProfileRewriteCookieRuleArgsDict']]]]] = None,
            crl_file: Optional[pulumi.Input[builtins.str]] = None,
            defaults_from: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            requests: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProfileRewriteRequestArgs', 'ProfileRewriteRequestArgsDict']]]]] = None,
            responses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProfileRewriteResponseArgs', 'ProfileRewriteResponseArgsDict']]]]] = None,
            rewrite_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            rewrite_mode: Optional[pulumi.Input[builtins.str]] = None,
            signing_cert: Optional[pulumi.Input[builtins.str]] = None,
            signing_key: Optional[pulumi.Input[builtins.str]] = None,
            signing_key_password: Optional[pulumi.Input[builtins.str]] = None,
            split_tunneling: Optional[pulumi.Input[builtins.str]] = None) -> 'ProfileRewrite':
        """
        Get an existing ProfileRewrite resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] bypass_lists: Specifies a list of URIs to bypass inside a web page when the page is accessed using Portal Access.
        :param pulumi.Input[builtins.str] ca_file: Specifies a CA against which to verify signed Java applets signatures. (name should be in full path which is combination of partition and CA file name )
        :param pulumi.Input[builtins.str] cache_type: Specifies the type of Client caching. Valid choices are: `cache-css-js, cache-all, no-cache, cache-img-css-js`. Default value: `cache-img-css-js`
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProfileRewriteCookieRuleArgs', 'ProfileRewriteCookieRuleArgsDict']]]] cookie_rules: Specifies the cookie rewrite rules. Block type. Each request is block type with following arguments.
        :param pulumi.Input[builtins.str] crl_file: Specifies a CRL against which to verify signed Java applets signature certificates. The default option is `none`.
        :param pulumi.Input[builtins.str] defaults_from: Specifies the profile from which this profile inherits settings. The default is the system-supplied `rewrite` profile.
        :param pulumi.Input[builtins.str] name: Name of the rewrite profile. ( profile name should be in full path which is combination of partition and profile name )
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProfileRewriteRequestArgs', 'ProfileRewriteRequestArgsDict']]]] requests: Block type. Each request is block type with following arguments.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProfileRewriteResponseArgs', 'ProfileRewriteResponseArgsDict']]]] responses: Block type. Each request is block type with following arguments.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] rewrite_lists: Specifies a list of URIs to rewrite inside a web page when the page is accessed using Portal Access.
        :param pulumi.Input[builtins.str] rewrite_mode: Specifies the type of Client caching. Valid choices are: `portal, uri-translation`
        :param pulumi.Input[builtins.str] signing_cert: Specifies a certificate to use for re-signing of signed Java applets after patching. (name should be in full path which is combination of partition and certificate name )
        :param pulumi.Input[builtins.str] signing_key: Specifies a certificate to use for re-signing of signed Java applets after patching. (name should be in full path which is combination of partition and key name )
        :param pulumi.Input[builtins.str] signing_key_password: Specifies a pass phrase to use for encrypting the private signing key. Since it's a sensitive entity idempotency will fail in the update call.
        :param pulumi.Input[builtins.str] split_tunneling: Specifies the type of Client caching. Valid choices are: `true, false`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProfileRewriteState.__new__(_ProfileRewriteState)

        __props__.__dict__["bypass_lists"] = bypass_lists
        __props__.__dict__["ca_file"] = ca_file
        __props__.__dict__["cache_type"] = cache_type
        __props__.__dict__["cookie_rules"] = cookie_rules
        __props__.__dict__["crl_file"] = crl_file
        __props__.__dict__["defaults_from"] = defaults_from
        __props__.__dict__["name"] = name
        __props__.__dict__["requests"] = requests
        __props__.__dict__["responses"] = responses
        __props__.__dict__["rewrite_lists"] = rewrite_lists
        __props__.__dict__["rewrite_mode"] = rewrite_mode
        __props__.__dict__["signing_cert"] = signing_cert
        __props__.__dict__["signing_key"] = signing_key
        __props__.__dict__["signing_key_password"] = signing_key_password
        __props__.__dict__["split_tunneling"] = split_tunneling
        return ProfileRewrite(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bypassLists")
    def bypass_lists(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Specifies a list of URIs to bypass inside a web page when the page is accessed using Portal Access.
        """
        return pulumi.get(self, "bypass_lists")

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> pulumi.Output[builtins.str]:
        """
        Specifies a CA against which to verify signed Java applets signatures. (name should be in full path which is combination of partition and CA file name )
        """
        return pulumi.get(self, "ca_file")

    @property
    @pulumi.getter(name="cacheType")
    def cache_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the type of Client caching. Valid choices are: `cache-css-js, cache-all, no-cache, cache-img-css-js`. Default value: `cache-img-css-js`
        """
        return pulumi.get(self, "cache_type")

    @property
    @pulumi.getter(name="cookieRules")
    def cookie_rules(self) -> pulumi.Output[Optional[Sequence['outputs.ProfileRewriteCookieRule']]]:
        """
        Specifies the cookie rewrite rules. Block type. Each request is block type with following arguments.
        """
        return pulumi.get(self, "cookie_rules")

    @property
    @pulumi.getter(name="crlFile")
    def crl_file(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies a CRL against which to verify signed Java applets signature certificates. The default option is `none`.
        """
        return pulumi.get(self, "crl_file")

    @property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the profile from which this profile inherits settings. The default is the system-supplied `rewrite` profile.
        """
        return pulumi.get(self, "defaults_from")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the rewrite profile. ( profile name should be in full path which is combination of partition and profile name )
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def requests(self) -> pulumi.Output[Sequence['outputs.ProfileRewriteRequest']]:
        """
        Block type. Each request is block type with following arguments.
        """
        return pulumi.get(self, "requests")

    @property
    @pulumi.getter
    def responses(self) -> pulumi.Output[Sequence['outputs.ProfileRewriteResponse']]:
        """
        Block type. Each request is block type with following arguments.
        """
        return pulumi.get(self, "responses")

    @property
    @pulumi.getter(name="rewriteLists")
    def rewrite_lists(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Specifies a list of URIs to rewrite inside a web page when the page is accessed using Portal Access.
        """
        return pulumi.get(self, "rewrite_lists")

    @property
    @pulumi.getter(name="rewriteMode")
    def rewrite_mode(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the type of Client caching. Valid choices are: `portal, uri-translation`
        """
        return pulumi.get(self, "rewrite_mode")

    @property
    @pulumi.getter(name="signingCert")
    def signing_cert(self) -> pulumi.Output[builtins.str]:
        """
        Specifies a certificate to use for re-signing of signed Java applets after patching. (name should be in full path which is combination of partition and certificate name )
        """
        return pulumi.get(self, "signing_cert")

    @property
    @pulumi.getter(name="signingKey")
    def signing_key(self) -> pulumi.Output[builtins.str]:
        """
        Specifies a certificate to use for re-signing of signed Java applets after patching. (name should be in full path which is combination of partition and key name )
        """
        return pulumi.get(self, "signing_key")

    @property
    @pulumi.getter(name="signingKeyPassword")
    def signing_key_password(self) -> pulumi.Output[builtins.str]:
        """
        Specifies a pass phrase to use for encrypting the private signing key. Since it's a sensitive entity idempotency will fail in the update call.
        """
        return pulumi.get(self, "signing_key_password")

    @property
    @pulumi.getter(name="splitTunneling")
    def split_tunneling(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the type of Client caching. Valid choices are: `true, false`
        """
        return pulumi.get(self, "split_tunneling")

