# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProfileRewriteUriRulesArgs', 'ProfileRewriteUriRules']

@pulumi.input_type
class ProfileRewriteUriRulesArgs:
    def __init__(__self__, *,
                 clients: pulumi.Input[Sequence[pulumi.Input['ProfileRewriteUriRulesClientArgs']]],
                 profile_name: pulumi.Input[builtins.str],
                 rule_name: pulumi.Input[builtins.str],
                 servers: pulumi.Input[Sequence[pulumi.Input['ProfileRewriteUriRulesServerArgs']]],
                 rule_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ProfileRewriteUriRules resource.
        :param pulumi.Input[Sequence[pulumi.Input['ProfileRewriteUriRulesClientArgs']]] clients: Block type. Each request is block type with following arguments.
        :param pulumi.Input[builtins.str] profile_name: Name of the rewrite profile. ( policy name should be in full path which is combination of partition and policy name )
        :param pulumi.Input[builtins.str] rule_name: Specifies the name of the uri rule.
        :param pulumi.Input[Sequence[pulumi.Input['ProfileRewriteUriRulesServerArgs']]] servers: Block type. Each request is block type with following arguments.
        :param pulumi.Input[builtins.str] rule_type: Specifies the type of the uri rule. Valid choices are: `request, response, both`. Default value is: `both`
        """
        pulumi.set(__self__, "clients", clients)
        pulumi.set(__self__, "profile_name", profile_name)
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "servers", servers)
        if rule_type is not None:
            pulumi.set(__self__, "rule_type", rule_type)

    @property
    @pulumi.getter
    def clients(self) -> pulumi.Input[Sequence[pulumi.Input['ProfileRewriteUriRulesClientArgs']]]:
        """
        Block type. Each request is block type with following arguments.
        """
        return pulumi.get(self, "clients")

    @clients.setter
    def clients(self, value: pulumi.Input[Sequence[pulumi.Input['ProfileRewriteUriRulesClientArgs']]]):
        pulumi.set(self, "clients", value)

    @property
    @pulumi.getter(name="profileName")
    def profile_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the rewrite profile. ( policy name should be in full path which is combination of partition and policy name )
        """
        return pulumi.get(self, "profile_name")

    @profile_name.setter
    def profile_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "profile_name", value)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the name of the uri rule.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "rule_name", value)

    @property
    @pulumi.getter
    def servers(self) -> pulumi.Input[Sequence[pulumi.Input['ProfileRewriteUriRulesServerArgs']]]:
        """
        Block type. Each request is block type with following arguments.
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: pulumi.Input[Sequence[pulumi.Input['ProfileRewriteUriRulesServerArgs']]]):
        pulumi.set(self, "servers", value)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the type of the uri rule. Valid choices are: `request, response, both`. Default value is: `both`
        """
        return pulumi.get(self, "rule_type")

    @rule_type.setter
    def rule_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rule_type", value)


@pulumi.input_type
class _ProfileRewriteUriRulesState:
    def __init__(__self__, *,
                 clients: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileRewriteUriRulesClientArgs']]]] = None,
                 profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 rule_type: Optional[pulumi.Input[builtins.str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileRewriteUriRulesServerArgs']]]] = None):
        """
        Input properties used for looking up and filtering ProfileRewriteUriRules resources.
        :param pulumi.Input[Sequence[pulumi.Input['ProfileRewriteUriRulesClientArgs']]] clients: Block type. Each request is block type with following arguments.
        :param pulumi.Input[builtins.str] profile_name: Name of the rewrite profile. ( policy name should be in full path which is combination of partition and policy name )
        :param pulumi.Input[builtins.str] rule_name: Specifies the name of the uri rule.
        :param pulumi.Input[builtins.str] rule_type: Specifies the type of the uri rule. Valid choices are: `request, response, both`. Default value is: `both`
        :param pulumi.Input[Sequence[pulumi.Input['ProfileRewriteUriRulesServerArgs']]] servers: Block type. Each request is block type with following arguments.
        """
        if clients is not None:
            pulumi.set(__self__, "clients", clients)
        if profile_name is not None:
            pulumi.set(__self__, "profile_name", profile_name)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if rule_type is not None:
            pulumi.set(__self__, "rule_type", rule_type)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)

    @property
    @pulumi.getter
    def clients(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProfileRewriteUriRulesClientArgs']]]]:
        """
        Block type. Each request is block type with following arguments.
        """
        return pulumi.get(self, "clients")

    @clients.setter
    def clients(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileRewriteUriRulesClientArgs']]]]):
        pulumi.set(self, "clients", value)

    @property
    @pulumi.getter(name="profileName")
    def profile_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the rewrite profile. ( policy name should be in full path which is combination of partition and policy name )
        """
        return pulumi.get(self, "profile_name")

    @profile_name.setter
    def profile_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_name", value)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the uri rule.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the type of the uri rule. Valid choices are: `request, response, both`. Default value is: `both`
        """
        return pulumi.get(self, "rule_type")

    @rule_type.setter
    def rule_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rule_type", value)

    @property
    @pulumi.getter
    def servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProfileRewriteUriRulesServerArgs']]]]:
        """
        Block type. Each request is block type with following arguments.
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileRewriteUriRulesServerArgs']]]]):
        pulumi.set(self, "servers", value)


@pulumi.type_token("f5bigip:ltm/profileRewriteUriRules:ProfileRewriteUriRules")
class ProfileRewriteUriRules(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 clients: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProfileRewriteUriRulesClientArgs', 'ProfileRewriteUriRulesClientArgsDict']]]]] = None,
                 profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 rule_type: Optional[pulumi.Input[builtins.str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProfileRewriteUriRulesServerArgs', 'ProfileRewriteUriRulesServerArgsDict']]]]] = None,
                 __props__=None):
        """
        `ltm.ProfileRewriteUriRules` Configures uri rewrite rules attached to the ltm rewrite profile

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        tftest = f5bigip.ltm.ProfileRewrite("tftest",
            name="/Common/tf_profile",
            defaults_from="/Common/rewrite",
            rewrite_mode="uri-translation")
        tftestrule1 = f5bigip.ltm.ProfileRewriteUriRules("tftestrule1",
            profile_name=tftest.name,
            rule_name="tf_rule",
            rule_type="request",
            clients=[{
                "host": "www.foo.com",
                "scheme": "https",
            }],
            servers=[{
                "host": "www.bar.com",
                "path": "/this/",
                "scheme": "https",
                "port": "8888",
            }])
        tftestrule2 = f5bigip.ltm.ProfileRewriteUriRules("tftestrule2",
            profile_name=tftest.name,
            rule_name="tf_rule2",
            clients=[{
                "host": "www.baz.com",
                "path": "/that/",
                "scheme": "ftp",
                "port": "8888",
            }],
            servers=[{
                "host": "www.buz.com",
                "path": "/those/",
                "scheme": "ftps",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProfileRewriteUriRulesClientArgs', 'ProfileRewriteUriRulesClientArgsDict']]]] clients: Block type. Each request is block type with following arguments.
        :param pulumi.Input[builtins.str] profile_name: Name of the rewrite profile. ( policy name should be in full path which is combination of partition and policy name )
        :param pulumi.Input[builtins.str] rule_name: Specifies the name of the uri rule.
        :param pulumi.Input[builtins.str] rule_type: Specifies the type of the uri rule. Valid choices are: `request, response, both`. Default value is: `both`
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProfileRewriteUriRulesServerArgs', 'ProfileRewriteUriRulesServerArgsDict']]]] servers: Block type. Each request is block type with following arguments.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProfileRewriteUriRulesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `ltm.ProfileRewriteUriRules` Configures uri rewrite rules attached to the ltm rewrite profile

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        tftest = f5bigip.ltm.ProfileRewrite("tftest",
            name="/Common/tf_profile",
            defaults_from="/Common/rewrite",
            rewrite_mode="uri-translation")
        tftestrule1 = f5bigip.ltm.ProfileRewriteUriRules("tftestrule1",
            profile_name=tftest.name,
            rule_name="tf_rule",
            rule_type="request",
            clients=[{
                "host": "www.foo.com",
                "scheme": "https",
            }],
            servers=[{
                "host": "www.bar.com",
                "path": "/this/",
                "scheme": "https",
                "port": "8888",
            }])
        tftestrule2 = f5bigip.ltm.ProfileRewriteUriRules("tftestrule2",
            profile_name=tftest.name,
            rule_name="tf_rule2",
            clients=[{
                "host": "www.baz.com",
                "path": "/that/",
                "scheme": "ftp",
                "port": "8888",
            }],
            servers=[{
                "host": "www.buz.com",
                "path": "/those/",
                "scheme": "ftps",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param ProfileRewriteUriRulesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProfileRewriteUriRulesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 clients: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProfileRewriteUriRulesClientArgs', 'ProfileRewriteUriRulesClientArgsDict']]]]] = None,
                 profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 rule_type: Optional[pulumi.Input[builtins.str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProfileRewriteUriRulesServerArgs', 'ProfileRewriteUriRulesServerArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProfileRewriteUriRulesArgs.__new__(ProfileRewriteUriRulesArgs)

            if clients is None and not opts.urn:
                raise TypeError("Missing required property 'clients'")
            __props__.__dict__["clients"] = clients
            if profile_name is None and not opts.urn:
                raise TypeError("Missing required property 'profile_name'")
            __props__.__dict__["profile_name"] = profile_name
            if rule_name is None and not opts.urn:
                raise TypeError("Missing required property 'rule_name'")
            __props__.__dict__["rule_name"] = rule_name
            __props__.__dict__["rule_type"] = rule_type
            if servers is None and not opts.urn:
                raise TypeError("Missing required property 'servers'")
            __props__.__dict__["servers"] = servers
        super(ProfileRewriteUriRules, __self__).__init__(
            'f5bigip:ltm/profileRewriteUriRules:ProfileRewriteUriRules',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            clients: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProfileRewriteUriRulesClientArgs', 'ProfileRewriteUriRulesClientArgsDict']]]]] = None,
            profile_name: Optional[pulumi.Input[builtins.str]] = None,
            rule_name: Optional[pulumi.Input[builtins.str]] = None,
            rule_type: Optional[pulumi.Input[builtins.str]] = None,
            servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProfileRewriteUriRulesServerArgs', 'ProfileRewriteUriRulesServerArgsDict']]]]] = None) -> 'ProfileRewriteUriRules':
        """
        Get an existing ProfileRewriteUriRules resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProfileRewriteUriRulesClientArgs', 'ProfileRewriteUriRulesClientArgsDict']]]] clients: Block type. Each request is block type with following arguments.
        :param pulumi.Input[builtins.str] profile_name: Name of the rewrite profile. ( policy name should be in full path which is combination of partition and policy name )
        :param pulumi.Input[builtins.str] rule_name: Specifies the name of the uri rule.
        :param pulumi.Input[builtins.str] rule_type: Specifies the type of the uri rule. Valid choices are: `request, response, both`. Default value is: `both`
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProfileRewriteUriRulesServerArgs', 'ProfileRewriteUriRulesServerArgsDict']]]] servers: Block type. Each request is block type with following arguments.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProfileRewriteUriRulesState.__new__(_ProfileRewriteUriRulesState)

        __props__.__dict__["clients"] = clients
        __props__.__dict__["profile_name"] = profile_name
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["rule_type"] = rule_type
        __props__.__dict__["servers"] = servers
        return ProfileRewriteUriRules(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def clients(self) -> pulumi.Output[Sequence['outputs.ProfileRewriteUriRulesClient']]:
        """
        Block type. Each request is block type with following arguments.
        """
        return pulumi.get(self, "clients")

    @property
    @pulumi.getter(name="profileName")
    def profile_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the rewrite profile. ( policy name should be in full path which is combination of partition and policy name )
        """
        return pulumi.get(self, "profile_name")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the uri rule.
        """
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the type of the uri rule. Valid choices are: `request, response, both`. Default value is: `both`
        """
        return pulumi.get(self, "rule_type")

    @property
    @pulumi.getter
    def servers(self) -> pulumi.Output[Sequence['outputs.ProfileRewriteUriRulesServer']]:
        """
        Block type. Each request is block type with following arguments.
        """
        return pulumi.get(self, "servers")

