# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ProfileTcpArgs', 'ProfileTcp']

@pulumi.input_type
class ProfileTcpArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 close_wait_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 congestion_control: Optional[pulumi.Input[builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[builtins.str]] = None,
                 deferred_accept: Optional[pulumi.Input[builtins.str]] = None,
                 delayed_acks: Optional[pulumi.Input[builtins.str]] = None,
                 early_retransmit: Optional[pulumi.Input[builtins.str]] = None,
                 fast_open: Optional[pulumi.Input[builtins.str]] = None,
                 finwait2timeout: Optional[pulumi.Input[builtins.int]] = None,
                 finwait_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 idle_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 initial_congestion_windowsize: Optional[pulumi.Input[builtins.int]] = None,
                 keepalive_interval: Optional[pulumi.Input[builtins.int]] = None,
                 nagle: Optional[pulumi.Input[builtins.str]] = None,
                 partition: Optional[pulumi.Input[builtins.str]] = None,
                 proxybuffer_high: Optional[pulumi.Input[builtins.int]] = None,
                 receive_windowsize: Optional[pulumi.Input[builtins.int]] = None,
                 send_buffersize: Optional[pulumi.Input[builtins.int]] = None,
                 tailloss_probe: Optional[pulumi.Input[builtins.str]] = None,
                 timewait_recycle: Optional[pulumi.Input[builtins.str]] = None,
                 verified_accept: Optional[pulumi.Input[builtins.str]] = None,
                 zerowindow_timeout: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a ProfileTcp resource.
        :param pulumi.Input[builtins.str] name: Name of the LTM TCP Profile,name should be `full path`. The full path is the combination of the `partition + name` (example: /Common/my-pool ) or  `partition + directory + name` of the resource  (example: /Common/test/my-pool )
        :param pulumi.Input[builtins.int] close_wait_timeout: Specifies the number of seconds that a connection remains in a LAST-ACK state before quitting. A value of 0 represents a term of forever (or until the maxrtx of the FIN state). The default value is 5 seconds.
        :param pulumi.Input[builtins.str] congestion_control: Specifies the algorithm to use to share network resources among competing users to reduce congestion. The default is High Speed.
        :param pulumi.Input[builtins.str] defaults_from: Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        :param pulumi.Input[builtins.str] deferred_accept: Specifies, when enabled, that the system defers allocation of the connection chain context until the client response is received. This option is useful for dealing with 3-way handshake DOS attacks. The default value is disabled.
        :param pulumi.Input[builtins.str] delayed_acks: Specifies, when checked (enabled), that the system can send fewer than one ACK (acknowledgment) segment per data segment received. By default, this setting is enabled.
        :param pulumi.Input[builtins.str] early_retransmit: Enabling this setting allows TCP to assume a packet is lost after fewer than the standard number of duplicate ACKs, if there is no way to send new data and generate more duplicate ACKs.
        :param pulumi.Input[builtins.str] fast_open: When enabled, permits TCP Fast Open, allowing properly equipped TCP clients to send data with the SYN packet. Default is `enabled`. If `fast_open` set to `enabled`, argument `verified_accept` can't be set to `enabled`.
        :param pulumi.Input[builtins.int] finwait2timeout: Specifies the number of seconds that a connection is in the FIN-WAIT-2 state before quitting. The default value is 300 seconds. A value of 0 (zero) represents a term of forever (or until the maxrtx of the FIN state).
        :param pulumi.Input[builtins.int] finwait_timeout: Specifies the number of seconds that a connection is in the FIN-WAIT-1 or closing state before quitting. The default value is 5 seconds. A value of 0 (zero) represents a term of forever (or until the maxrtx of the FIN state). You can also specify immediate or indefinite.
        :param pulumi.Input[builtins.int] idle_timeout: Specifies the number of seconds that a connection is idle before the connection is eligible for deletion. The default value is 300 seconds.
        :param pulumi.Input[builtins.int] initial_congestion_windowsize: Specifies the initial congestion window size for connections to this destination. Actual window size is this value multiplied by the MSS (Maximum Segment Size) for the same connection. The default is 10. Valid values range from 0 to 64.
        :param pulumi.Input[builtins.int] keepalive_interval: Specifies the keep alive probe interval, in seconds. The default value is 1800 seconds.
        :param pulumi.Input[builtins.str] nagle: Specifies whether the system applies Nagle's algorithm to reduce the number of short segments on the network.If you select Auto, the system determines whether to use Nagle's algorithm based on network conditions. By default, this setting is disabled.
        :param pulumi.Input[builtins.str] partition: name of partition
        :param pulumi.Input[builtins.int] proxybuffer_high: Specifies the proxy buffer level, in bytes, at which the receive window is closed.
        :param pulumi.Input[builtins.int] receive_windowsize: Specifies the maximum advertised RECEIVE window size. This value represents the maximum number of bytes to which the RECEIVE window can scale. The default is 65535 bytes.
        :param pulumi.Input[builtins.int] send_buffersize: Specifies the SEND window size. The default is 131072 bytes.
        :param pulumi.Input[builtins.str] tailloss_probe: Enabling this setting allows TCP to send a probe segment to trigger fast recovery instead of recovering a loss via a retransmission timeout,By default, this setting is enabled.
        :param pulumi.Input[builtins.str] timewait_recycle: Using this setting enabled, the system can recycle a wait-state connection immediately upon receipt of a new connection request instead of having to wait until the connection times out of the wait state. By default, this setting is enabled.
        :param pulumi.Input[builtins.str] verified_accept: Specifies, when checked (enabled), that the system can actually communicate with the server before establishing a client connection. To determine this, the system sends the server a SYN packet before responding to the client's SYN with a SYN-ACK. When unchecked, the system accepts the client connection before selecting a server to talk to. By default, this setting is `disabled`.
        :param pulumi.Input[builtins.int] zerowindow_timeout: Specifies the timeout in milliseconds for terminating a connection with an effective zero length TCP transmit window.
        """
        pulumi.set(__self__, "name", name)
        if close_wait_timeout is not None:
            pulumi.set(__self__, "close_wait_timeout", close_wait_timeout)
        if congestion_control is not None:
            pulumi.set(__self__, "congestion_control", congestion_control)
        if defaults_from is not None:
            pulumi.set(__self__, "defaults_from", defaults_from)
        if deferred_accept is not None:
            pulumi.set(__self__, "deferred_accept", deferred_accept)
        if delayed_acks is not None:
            pulumi.set(__self__, "delayed_acks", delayed_acks)
        if early_retransmit is not None:
            pulumi.set(__self__, "early_retransmit", early_retransmit)
        if fast_open is not None:
            pulumi.set(__self__, "fast_open", fast_open)
        if finwait2timeout is not None:
            pulumi.set(__self__, "finwait2timeout", finwait2timeout)
        if finwait_timeout is not None:
            pulumi.set(__self__, "finwait_timeout", finwait_timeout)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if initial_congestion_windowsize is not None:
            pulumi.set(__self__, "initial_congestion_windowsize", initial_congestion_windowsize)
        if keepalive_interval is not None:
            pulumi.set(__self__, "keepalive_interval", keepalive_interval)
        if nagle is not None:
            pulumi.set(__self__, "nagle", nagle)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if proxybuffer_high is not None:
            pulumi.set(__self__, "proxybuffer_high", proxybuffer_high)
        if receive_windowsize is not None:
            pulumi.set(__self__, "receive_windowsize", receive_windowsize)
        if send_buffersize is not None:
            pulumi.set(__self__, "send_buffersize", send_buffersize)
        if tailloss_probe is not None:
            pulumi.set(__self__, "tailloss_probe", tailloss_probe)
        if timewait_recycle is not None:
            pulumi.set(__self__, "timewait_recycle", timewait_recycle)
        if verified_accept is not None:
            pulumi.set(__self__, "verified_accept", verified_accept)
        if zerowindow_timeout is not None:
            pulumi.set(__self__, "zerowindow_timeout", zerowindow_timeout)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the LTM TCP Profile,name should be `full path`. The full path is the combination of the `partition + name` (example: /Common/my-pool ) or  `partition + directory + name` of the resource  (example: /Common/test/my-pool )
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="closeWaitTimeout")
    def close_wait_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of seconds that a connection remains in a LAST-ACK state before quitting. A value of 0 represents a term of forever (or until the maxrtx of the FIN state). The default value is 5 seconds.
        """
        return pulumi.get(self, "close_wait_timeout")

    @close_wait_timeout.setter
    def close_wait_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "close_wait_timeout", value)

    @property
    @pulumi.getter(name="congestionControl")
    def congestion_control(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the algorithm to use to share network resources among competing users to reduce congestion. The default is High Speed.
        """
        return pulumi.get(self, "congestion_control")

    @congestion_control.setter
    def congestion_control(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "congestion_control", value)

    @property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        """
        return pulumi.get(self, "defaults_from")

    @defaults_from.setter
    def defaults_from(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "defaults_from", value)

    @property
    @pulumi.getter(name="deferredAccept")
    def deferred_accept(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies, when enabled, that the system defers allocation of the connection chain context until the client response is received. This option is useful for dealing with 3-way handshake DOS attacks. The default value is disabled.
        """
        return pulumi.get(self, "deferred_accept")

    @deferred_accept.setter
    def deferred_accept(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deferred_accept", value)

    @property
    @pulumi.getter(name="delayedAcks")
    def delayed_acks(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies, when checked (enabled), that the system can send fewer than one ACK (acknowledgment) segment per data segment received. By default, this setting is enabled.
        """
        return pulumi.get(self, "delayed_acks")

    @delayed_acks.setter
    def delayed_acks(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delayed_acks", value)

    @property
    @pulumi.getter(name="earlyRetransmit")
    def early_retransmit(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enabling this setting allows TCP to assume a packet is lost after fewer than the standard number of duplicate ACKs, if there is no way to send new data and generate more duplicate ACKs.
        """
        return pulumi.get(self, "early_retransmit")

    @early_retransmit.setter
    def early_retransmit(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "early_retransmit", value)

    @property
    @pulumi.getter(name="fastOpen")
    def fast_open(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When enabled, permits TCP Fast Open, allowing properly equipped TCP clients to send data with the SYN packet. Default is `enabled`. If `fast_open` set to `enabled`, argument `verified_accept` can't be set to `enabled`.
        """
        return pulumi.get(self, "fast_open")

    @fast_open.setter
    def fast_open(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fast_open", value)

    @property
    @pulumi.getter
    def finwait2timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of seconds that a connection is in the FIN-WAIT-2 state before quitting. The default value is 300 seconds. A value of 0 (zero) represents a term of forever (or until the maxrtx of the FIN state).
        """
        return pulumi.get(self, "finwait2timeout")

    @finwait2timeout.setter
    def finwait2timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "finwait2timeout", value)

    @property
    @pulumi.getter(name="finwaitTimeout")
    def finwait_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of seconds that a connection is in the FIN-WAIT-1 or closing state before quitting. The default value is 5 seconds. A value of 0 (zero) represents a term of forever (or until the maxrtx of the FIN state). You can also specify immediate or indefinite.
        """
        return pulumi.get(self, "finwait_timeout")

    @finwait_timeout.setter
    def finwait_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "finwait_timeout", value)

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of seconds that a connection is idle before the connection is eligible for deletion. The default value is 300 seconds.
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "idle_timeout", value)

    @property
    @pulumi.getter(name="initialCongestionWindowsize")
    def initial_congestion_windowsize(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the initial congestion window size for connections to this destination. Actual window size is this value multiplied by the MSS (Maximum Segment Size) for the same connection. The default is 10. Valid values range from 0 to 64.
        """
        return pulumi.get(self, "initial_congestion_windowsize")

    @initial_congestion_windowsize.setter
    def initial_congestion_windowsize(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "initial_congestion_windowsize", value)

    @property
    @pulumi.getter(name="keepaliveInterval")
    def keepalive_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the keep alive probe interval, in seconds. The default value is 1800 seconds.
        """
        return pulumi.get(self, "keepalive_interval")

    @keepalive_interval.setter
    def keepalive_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "keepalive_interval", value)

    @property
    @pulumi.getter
    def nagle(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether the system applies Nagle's algorithm to reduce the number of short segments on the network.If you select Auto, the system determines whether to use Nagle's algorithm based on network conditions. By default, this setting is disabled.
        """
        return pulumi.get(self, "nagle")

    @nagle.setter
    def nagle(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "nagle", value)

    @property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        name of partition
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "partition", value)

    @property
    @pulumi.getter(name="proxybufferHigh")
    def proxybuffer_high(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the proxy buffer level, in bytes, at which the receive window is closed.
        """
        return pulumi.get(self, "proxybuffer_high")

    @proxybuffer_high.setter
    def proxybuffer_high(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "proxybuffer_high", value)

    @property
    @pulumi.getter(name="receiveWindowsize")
    def receive_windowsize(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the maximum advertised RECEIVE window size. This value represents the maximum number of bytes to which the RECEIVE window can scale. The default is 65535 bytes.
        """
        return pulumi.get(self, "receive_windowsize")

    @receive_windowsize.setter
    def receive_windowsize(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "receive_windowsize", value)

    @property
    @pulumi.getter(name="sendBuffersize")
    def send_buffersize(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the SEND window size. The default is 131072 bytes.
        """
        return pulumi.get(self, "send_buffersize")

    @send_buffersize.setter
    def send_buffersize(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "send_buffersize", value)

    @property
    @pulumi.getter(name="taillossProbe")
    def tailloss_probe(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enabling this setting allows TCP to send a probe segment to trigger fast recovery instead of recovering a loss via a retransmission timeout,By default, this setting is enabled.
        """
        return pulumi.get(self, "tailloss_probe")

    @tailloss_probe.setter
    def tailloss_probe(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tailloss_probe", value)

    @property
    @pulumi.getter(name="timewaitRecycle")
    def timewait_recycle(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Using this setting enabled, the system can recycle a wait-state connection immediately upon receipt of a new connection request instead of having to wait until the connection times out of the wait state. By default, this setting is enabled.
        """
        return pulumi.get(self, "timewait_recycle")

    @timewait_recycle.setter
    def timewait_recycle(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timewait_recycle", value)

    @property
    @pulumi.getter(name="verifiedAccept")
    def verified_accept(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies, when checked (enabled), that the system can actually communicate with the server before establishing a client connection. To determine this, the system sends the server a SYN packet before responding to the client's SYN with a SYN-ACK. When unchecked, the system accepts the client connection before selecting a server to talk to. By default, this setting is `disabled`.
        """
        return pulumi.get(self, "verified_accept")

    @verified_accept.setter
    def verified_accept(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "verified_accept", value)

    @property
    @pulumi.getter(name="zerowindowTimeout")
    def zerowindow_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the timeout in milliseconds for terminating a connection with an effective zero length TCP transmit window.
        """
        return pulumi.get(self, "zerowindow_timeout")

    @zerowindow_timeout.setter
    def zerowindow_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "zerowindow_timeout", value)


@pulumi.input_type
class _ProfileTcpState:
    def __init__(__self__, *,
                 close_wait_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 congestion_control: Optional[pulumi.Input[builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[builtins.str]] = None,
                 deferred_accept: Optional[pulumi.Input[builtins.str]] = None,
                 delayed_acks: Optional[pulumi.Input[builtins.str]] = None,
                 early_retransmit: Optional[pulumi.Input[builtins.str]] = None,
                 fast_open: Optional[pulumi.Input[builtins.str]] = None,
                 finwait2timeout: Optional[pulumi.Input[builtins.int]] = None,
                 finwait_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 idle_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 initial_congestion_windowsize: Optional[pulumi.Input[builtins.int]] = None,
                 keepalive_interval: Optional[pulumi.Input[builtins.int]] = None,
                 nagle: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 partition: Optional[pulumi.Input[builtins.str]] = None,
                 proxybuffer_high: Optional[pulumi.Input[builtins.int]] = None,
                 receive_windowsize: Optional[pulumi.Input[builtins.int]] = None,
                 send_buffersize: Optional[pulumi.Input[builtins.int]] = None,
                 tailloss_probe: Optional[pulumi.Input[builtins.str]] = None,
                 timewait_recycle: Optional[pulumi.Input[builtins.str]] = None,
                 verified_accept: Optional[pulumi.Input[builtins.str]] = None,
                 zerowindow_timeout: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering ProfileTcp resources.
        :param pulumi.Input[builtins.int] close_wait_timeout: Specifies the number of seconds that a connection remains in a LAST-ACK state before quitting. A value of 0 represents a term of forever (or until the maxrtx of the FIN state). The default value is 5 seconds.
        :param pulumi.Input[builtins.str] congestion_control: Specifies the algorithm to use to share network resources among competing users to reduce congestion. The default is High Speed.
        :param pulumi.Input[builtins.str] defaults_from: Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        :param pulumi.Input[builtins.str] deferred_accept: Specifies, when enabled, that the system defers allocation of the connection chain context until the client response is received. This option is useful for dealing with 3-way handshake DOS attacks. The default value is disabled.
        :param pulumi.Input[builtins.str] delayed_acks: Specifies, when checked (enabled), that the system can send fewer than one ACK (acknowledgment) segment per data segment received. By default, this setting is enabled.
        :param pulumi.Input[builtins.str] early_retransmit: Enabling this setting allows TCP to assume a packet is lost after fewer than the standard number of duplicate ACKs, if there is no way to send new data and generate more duplicate ACKs.
        :param pulumi.Input[builtins.str] fast_open: When enabled, permits TCP Fast Open, allowing properly equipped TCP clients to send data with the SYN packet. Default is `enabled`. If `fast_open` set to `enabled`, argument `verified_accept` can't be set to `enabled`.
        :param pulumi.Input[builtins.int] finwait2timeout: Specifies the number of seconds that a connection is in the FIN-WAIT-2 state before quitting. The default value is 300 seconds. A value of 0 (zero) represents a term of forever (or until the maxrtx of the FIN state).
        :param pulumi.Input[builtins.int] finwait_timeout: Specifies the number of seconds that a connection is in the FIN-WAIT-1 or closing state before quitting. The default value is 5 seconds. A value of 0 (zero) represents a term of forever (or until the maxrtx of the FIN state). You can also specify immediate or indefinite.
        :param pulumi.Input[builtins.int] idle_timeout: Specifies the number of seconds that a connection is idle before the connection is eligible for deletion. The default value is 300 seconds.
        :param pulumi.Input[builtins.int] initial_congestion_windowsize: Specifies the initial congestion window size for connections to this destination. Actual window size is this value multiplied by the MSS (Maximum Segment Size) for the same connection. The default is 10. Valid values range from 0 to 64.
        :param pulumi.Input[builtins.int] keepalive_interval: Specifies the keep alive probe interval, in seconds. The default value is 1800 seconds.
        :param pulumi.Input[builtins.str] nagle: Specifies whether the system applies Nagle's algorithm to reduce the number of short segments on the network.If you select Auto, the system determines whether to use Nagle's algorithm based on network conditions. By default, this setting is disabled.
        :param pulumi.Input[builtins.str] name: Name of the LTM TCP Profile,name should be `full path`. The full path is the combination of the `partition + name` (example: /Common/my-pool ) or  `partition + directory + name` of the resource  (example: /Common/test/my-pool )
        :param pulumi.Input[builtins.str] partition: name of partition
        :param pulumi.Input[builtins.int] proxybuffer_high: Specifies the proxy buffer level, in bytes, at which the receive window is closed.
        :param pulumi.Input[builtins.int] receive_windowsize: Specifies the maximum advertised RECEIVE window size. This value represents the maximum number of bytes to which the RECEIVE window can scale. The default is 65535 bytes.
        :param pulumi.Input[builtins.int] send_buffersize: Specifies the SEND window size. The default is 131072 bytes.
        :param pulumi.Input[builtins.str] tailloss_probe: Enabling this setting allows TCP to send a probe segment to trigger fast recovery instead of recovering a loss via a retransmission timeout,By default, this setting is enabled.
        :param pulumi.Input[builtins.str] timewait_recycle: Using this setting enabled, the system can recycle a wait-state connection immediately upon receipt of a new connection request instead of having to wait until the connection times out of the wait state. By default, this setting is enabled.
        :param pulumi.Input[builtins.str] verified_accept: Specifies, when checked (enabled), that the system can actually communicate with the server before establishing a client connection. To determine this, the system sends the server a SYN packet before responding to the client's SYN with a SYN-ACK. When unchecked, the system accepts the client connection before selecting a server to talk to. By default, this setting is `disabled`.
        :param pulumi.Input[builtins.int] zerowindow_timeout: Specifies the timeout in milliseconds for terminating a connection with an effective zero length TCP transmit window.
        """
        if close_wait_timeout is not None:
            pulumi.set(__self__, "close_wait_timeout", close_wait_timeout)
        if congestion_control is not None:
            pulumi.set(__self__, "congestion_control", congestion_control)
        if defaults_from is not None:
            pulumi.set(__self__, "defaults_from", defaults_from)
        if deferred_accept is not None:
            pulumi.set(__self__, "deferred_accept", deferred_accept)
        if delayed_acks is not None:
            pulumi.set(__self__, "delayed_acks", delayed_acks)
        if early_retransmit is not None:
            pulumi.set(__self__, "early_retransmit", early_retransmit)
        if fast_open is not None:
            pulumi.set(__self__, "fast_open", fast_open)
        if finwait2timeout is not None:
            pulumi.set(__self__, "finwait2timeout", finwait2timeout)
        if finwait_timeout is not None:
            pulumi.set(__self__, "finwait_timeout", finwait_timeout)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if initial_congestion_windowsize is not None:
            pulumi.set(__self__, "initial_congestion_windowsize", initial_congestion_windowsize)
        if keepalive_interval is not None:
            pulumi.set(__self__, "keepalive_interval", keepalive_interval)
        if nagle is not None:
            pulumi.set(__self__, "nagle", nagle)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if proxybuffer_high is not None:
            pulumi.set(__self__, "proxybuffer_high", proxybuffer_high)
        if receive_windowsize is not None:
            pulumi.set(__self__, "receive_windowsize", receive_windowsize)
        if send_buffersize is not None:
            pulumi.set(__self__, "send_buffersize", send_buffersize)
        if tailloss_probe is not None:
            pulumi.set(__self__, "tailloss_probe", tailloss_probe)
        if timewait_recycle is not None:
            pulumi.set(__self__, "timewait_recycle", timewait_recycle)
        if verified_accept is not None:
            pulumi.set(__self__, "verified_accept", verified_accept)
        if zerowindow_timeout is not None:
            pulumi.set(__self__, "zerowindow_timeout", zerowindow_timeout)

    @property
    @pulumi.getter(name="closeWaitTimeout")
    def close_wait_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of seconds that a connection remains in a LAST-ACK state before quitting. A value of 0 represents a term of forever (or until the maxrtx of the FIN state). The default value is 5 seconds.
        """
        return pulumi.get(self, "close_wait_timeout")

    @close_wait_timeout.setter
    def close_wait_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "close_wait_timeout", value)

    @property
    @pulumi.getter(name="congestionControl")
    def congestion_control(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the algorithm to use to share network resources among competing users to reduce congestion. The default is High Speed.
        """
        return pulumi.get(self, "congestion_control")

    @congestion_control.setter
    def congestion_control(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "congestion_control", value)

    @property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        """
        return pulumi.get(self, "defaults_from")

    @defaults_from.setter
    def defaults_from(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "defaults_from", value)

    @property
    @pulumi.getter(name="deferredAccept")
    def deferred_accept(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies, when enabled, that the system defers allocation of the connection chain context until the client response is received. This option is useful for dealing with 3-way handshake DOS attacks. The default value is disabled.
        """
        return pulumi.get(self, "deferred_accept")

    @deferred_accept.setter
    def deferred_accept(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deferred_accept", value)

    @property
    @pulumi.getter(name="delayedAcks")
    def delayed_acks(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies, when checked (enabled), that the system can send fewer than one ACK (acknowledgment) segment per data segment received. By default, this setting is enabled.
        """
        return pulumi.get(self, "delayed_acks")

    @delayed_acks.setter
    def delayed_acks(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delayed_acks", value)

    @property
    @pulumi.getter(name="earlyRetransmit")
    def early_retransmit(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enabling this setting allows TCP to assume a packet is lost after fewer than the standard number of duplicate ACKs, if there is no way to send new data and generate more duplicate ACKs.
        """
        return pulumi.get(self, "early_retransmit")

    @early_retransmit.setter
    def early_retransmit(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "early_retransmit", value)

    @property
    @pulumi.getter(name="fastOpen")
    def fast_open(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When enabled, permits TCP Fast Open, allowing properly equipped TCP clients to send data with the SYN packet. Default is `enabled`. If `fast_open` set to `enabled`, argument `verified_accept` can't be set to `enabled`.
        """
        return pulumi.get(self, "fast_open")

    @fast_open.setter
    def fast_open(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fast_open", value)

    @property
    @pulumi.getter
    def finwait2timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of seconds that a connection is in the FIN-WAIT-2 state before quitting. The default value is 300 seconds. A value of 0 (zero) represents a term of forever (or until the maxrtx of the FIN state).
        """
        return pulumi.get(self, "finwait2timeout")

    @finwait2timeout.setter
    def finwait2timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "finwait2timeout", value)

    @property
    @pulumi.getter(name="finwaitTimeout")
    def finwait_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of seconds that a connection is in the FIN-WAIT-1 or closing state before quitting. The default value is 5 seconds. A value of 0 (zero) represents a term of forever (or until the maxrtx of the FIN state). You can also specify immediate or indefinite.
        """
        return pulumi.get(self, "finwait_timeout")

    @finwait_timeout.setter
    def finwait_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "finwait_timeout", value)

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of seconds that a connection is idle before the connection is eligible for deletion. The default value is 300 seconds.
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "idle_timeout", value)

    @property
    @pulumi.getter(name="initialCongestionWindowsize")
    def initial_congestion_windowsize(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the initial congestion window size for connections to this destination. Actual window size is this value multiplied by the MSS (Maximum Segment Size) for the same connection. The default is 10. Valid values range from 0 to 64.
        """
        return pulumi.get(self, "initial_congestion_windowsize")

    @initial_congestion_windowsize.setter
    def initial_congestion_windowsize(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "initial_congestion_windowsize", value)

    @property
    @pulumi.getter(name="keepaliveInterval")
    def keepalive_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the keep alive probe interval, in seconds. The default value is 1800 seconds.
        """
        return pulumi.get(self, "keepalive_interval")

    @keepalive_interval.setter
    def keepalive_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "keepalive_interval", value)

    @property
    @pulumi.getter
    def nagle(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether the system applies Nagle's algorithm to reduce the number of short segments on the network.If you select Auto, the system determines whether to use Nagle's algorithm based on network conditions. By default, this setting is disabled.
        """
        return pulumi.get(self, "nagle")

    @nagle.setter
    def nagle(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "nagle", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the LTM TCP Profile,name should be `full path`. The full path is the combination of the `partition + name` (example: /Common/my-pool ) or  `partition + directory + name` of the resource  (example: /Common/test/my-pool )
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        name of partition
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "partition", value)

    @property
    @pulumi.getter(name="proxybufferHigh")
    def proxybuffer_high(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the proxy buffer level, in bytes, at which the receive window is closed.
        """
        return pulumi.get(self, "proxybuffer_high")

    @proxybuffer_high.setter
    def proxybuffer_high(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "proxybuffer_high", value)

    @property
    @pulumi.getter(name="receiveWindowsize")
    def receive_windowsize(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the maximum advertised RECEIVE window size. This value represents the maximum number of bytes to which the RECEIVE window can scale. The default is 65535 bytes.
        """
        return pulumi.get(self, "receive_windowsize")

    @receive_windowsize.setter
    def receive_windowsize(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "receive_windowsize", value)

    @property
    @pulumi.getter(name="sendBuffersize")
    def send_buffersize(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the SEND window size. The default is 131072 bytes.
        """
        return pulumi.get(self, "send_buffersize")

    @send_buffersize.setter
    def send_buffersize(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "send_buffersize", value)

    @property
    @pulumi.getter(name="taillossProbe")
    def tailloss_probe(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enabling this setting allows TCP to send a probe segment to trigger fast recovery instead of recovering a loss via a retransmission timeout,By default, this setting is enabled.
        """
        return pulumi.get(self, "tailloss_probe")

    @tailloss_probe.setter
    def tailloss_probe(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tailloss_probe", value)

    @property
    @pulumi.getter(name="timewaitRecycle")
    def timewait_recycle(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Using this setting enabled, the system can recycle a wait-state connection immediately upon receipt of a new connection request instead of having to wait until the connection times out of the wait state. By default, this setting is enabled.
        """
        return pulumi.get(self, "timewait_recycle")

    @timewait_recycle.setter
    def timewait_recycle(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timewait_recycle", value)

    @property
    @pulumi.getter(name="verifiedAccept")
    def verified_accept(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies, when checked (enabled), that the system can actually communicate with the server before establishing a client connection. To determine this, the system sends the server a SYN packet before responding to the client's SYN with a SYN-ACK. When unchecked, the system accepts the client connection before selecting a server to talk to. By default, this setting is `disabled`.
        """
        return pulumi.get(self, "verified_accept")

    @verified_accept.setter
    def verified_accept(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "verified_accept", value)

    @property
    @pulumi.getter(name="zerowindowTimeout")
    def zerowindow_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the timeout in milliseconds for terminating a connection with an effective zero length TCP transmit window.
        """
        return pulumi.get(self, "zerowindow_timeout")

    @zerowindow_timeout.setter
    def zerowindow_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "zerowindow_timeout", value)


@pulumi.type_token("f5bigip:ltm/profileTcp:ProfileTcp")
class ProfileTcp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 close_wait_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 congestion_control: Optional[pulumi.Input[builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[builtins.str]] = None,
                 deferred_accept: Optional[pulumi.Input[builtins.str]] = None,
                 delayed_acks: Optional[pulumi.Input[builtins.str]] = None,
                 early_retransmit: Optional[pulumi.Input[builtins.str]] = None,
                 fast_open: Optional[pulumi.Input[builtins.str]] = None,
                 finwait2timeout: Optional[pulumi.Input[builtins.int]] = None,
                 finwait_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 idle_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 initial_congestion_windowsize: Optional[pulumi.Input[builtins.int]] = None,
                 keepalive_interval: Optional[pulumi.Input[builtins.int]] = None,
                 nagle: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 partition: Optional[pulumi.Input[builtins.str]] = None,
                 proxybuffer_high: Optional[pulumi.Input[builtins.int]] = None,
                 receive_windowsize: Optional[pulumi.Input[builtins.int]] = None,
                 send_buffersize: Optional[pulumi.Input[builtins.int]] = None,
                 tailloss_probe: Optional[pulumi.Input[builtins.str]] = None,
                 timewait_recycle: Optional[pulumi.Input[builtins.str]] = None,
                 verified_accept: Optional[pulumi.Input[builtins.str]] = None,
                 zerowindow_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        `ltm.ProfileTcp` Configures a custom TCP LTM Profile for use by health checks.

        Resources should be named with their `full path`. The full path is the combination of the `partition + name` (example: /Common/my-pool ) or  `partition + directory + name` of the resource  (example: /Common/test/my-pool )

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        sanjose_tcp_lan_profile = f5bigip.ltm.ProfileTcp("sanjose-tcp-lan-profile",
            name="/Common/sanjose-tcp-lan-profile",
            idle_timeout=200,
            close_wait_timeout=5,
            finwait2timeout=5,
            finwait_timeout=300,
            keepalive_interval=1700,
            deferred_accept="enabled",
            fast_open="enabled")
        ```

        ## Importing

        An existing tcp profile can be imported into this resource by supplying tcp profile Name in `full path` as `id`.
        An example is below:
        ```sh
        $ terraform import bigip_ltm_profile_tcp.tcp-lan-profile-import /Common/test-tcp-lan-profile
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] close_wait_timeout: Specifies the number of seconds that a connection remains in a LAST-ACK state before quitting. A value of 0 represents a term of forever (or until the maxrtx of the FIN state). The default value is 5 seconds.
        :param pulumi.Input[builtins.str] congestion_control: Specifies the algorithm to use to share network resources among competing users to reduce congestion. The default is High Speed.
        :param pulumi.Input[builtins.str] defaults_from: Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        :param pulumi.Input[builtins.str] deferred_accept: Specifies, when enabled, that the system defers allocation of the connection chain context until the client response is received. This option is useful for dealing with 3-way handshake DOS attacks. The default value is disabled.
        :param pulumi.Input[builtins.str] delayed_acks: Specifies, when checked (enabled), that the system can send fewer than one ACK (acknowledgment) segment per data segment received. By default, this setting is enabled.
        :param pulumi.Input[builtins.str] early_retransmit: Enabling this setting allows TCP to assume a packet is lost after fewer than the standard number of duplicate ACKs, if there is no way to send new data and generate more duplicate ACKs.
        :param pulumi.Input[builtins.str] fast_open: When enabled, permits TCP Fast Open, allowing properly equipped TCP clients to send data with the SYN packet. Default is `enabled`. If `fast_open` set to `enabled`, argument `verified_accept` can't be set to `enabled`.
        :param pulumi.Input[builtins.int] finwait2timeout: Specifies the number of seconds that a connection is in the FIN-WAIT-2 state before quitting. The default value is 300 seconds. A value of 0 (zero) represents a term of forever (or until the maxrtx of the FIN state).
        :param pulumi.Input[builtins.int] finwait_timeout: Specifies the number of seconds that a connection is in the FIN-WAIT-1 or closing state before quitting. The default value is 5 seconds. A value of 0 (zero) represents a term of forever (or until the maxrtx of the FIN state). You can also specify immediate or indefinite.
        :param pulumi.Input[builtins.int] idle_timeout: Specifies the number of seconds that a connection is idle before the connection is eligible for deletion. The default value is 300 seconds.
        :param pulumi.Input[builtins.int] initial_congestion_windowsize: Specifies the initial congestion window size for connections to this destination. Actual window size is this value multiplied by the MSS (Maximum Segment Size) for the same connection. The default is 10. Valid values range from 0 to 64.
        :param pulumi.Input[builtins.int] keepalive_interval: Specifies the keep alive probe interval, in seconds. The default value is 1800 seconds.
        :param pulumi.Input[builtins.str] nagle: Specifies whether the system applies Nagle's algorithm to reduce the number of short segments on the network.If you select Auto, the system determines whether to use Nagle's algorithm based on network conditions. By default, this setting is disabled.
        :param pulumi.Input[builtins.str] name: Name of the LTM TCP Profile,name should be `full path`. The full path is the combination of the `partition + name` (example: /Common/my-pool ) or  `partition + directory + name` of the resource  (example: /Common/test/my-pool )
        :param pulumi.Input[builtins.str] partition: name of partition
        :param pulumi.Input[builtins.int] proxybuffer_high: Specifies the proxy buffer level, in bytes, at which the receive window is closed.
        :param pulumi.Input[builtins.int] receive_windowsize: Specifies the maximum advertised RECEIVE window size. This value represents the maximum number of bytes to which the RECEIVE window can scale. The default is 65535 bytes.
        :param pulumi.Input[builtins.int] send_buffersize: Specifies the SEND window size. The default is 131072 bytes.
        :param pulumi.Input[builtins.str] tailloss_probe: Enabling this setting allows TCP to send a probe segment to trigger fast recovery instead of recovering a loss via a retransmission timeout,By default, this setting is enabled.
        :param pulumi.Input[builtins.str] timewait_recycle: Using this setting enabled, the system can recycle a wait-state connection immediately upon receipt of a new connection request instead of having to wait until the connection times out of the wait state. By default, this setting is enabled.
        :param pulumi.Input[builtins.str] verified_accept: Specifies, when checked (enabled), that the system can actually communicate with the server before establishing a client connection. To determine this, the system sends the server a SYN packet before responding to the client's SYN with a SYN-ACK. When unchecked, the system accepts the client connection before selecting a server to talk to. By default, this setting is `disabled`.
        :param pulumi.Input[builtins.int] zerowindow_timeout: Specifies the timeout in milliseconds for terminating a connection with an effective zero length TCP transmit window.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProfileTcpArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `ltm.ProfileTcp` Configures a custom TCP LTM Profile for use by health checks.

        Resources should be named with their `full path`. The full path is the combination of the `partition + name` (example: /Common/my-pool ) or  `partition + directory + name` of the resource  (example: /Common/test/my-pool )

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        sanjose_tcp_lan_profile = f5bigip.ltm.ProfileTcp("sanjose-tcp-lan-profile",
            name="/Common/sanjose-tcp-lan-profile",
            idle_timeout=200,
            close_wait_timeout=5,
            finwait2timeout=5,
            finwait_timeout=300,
            keepalive_interval=1700,
            deferred_accept="enabled",
            fast_open="enabled")
        ```

        ## Importing

        An existing tcp profile can be imported into this resource by supplying tcp profile Name in `full path` as `id`.
        An example is below:
        ```sh
        $ terraform import bigip_ltm_profile_tcp.tcp-lan-profile-import /Common/test-tcp-lan-profile
        ```

        :param str resource_name: The name of the resource.
        :param ProfileTcpArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProfileTcpArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 close_wait_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 congestion_control: Optional[pulumi.Input[builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[builtins.str]] = None,
                 deferred_accept: Optional[pulumi.Input[builtins.str]] = None,
                 delayed_acks: Optional[pulumi.Input[builtins.str]] = None,
                 early_retransmit: Optional[pulumi.Input[builtins.str]] = None,
                 fast_open: Optional[pulumi.Input[builtins.str]] = None,
                 finwait2timeout: Optional[pulumi.Input[builtins.int]] = None,
                 finwait_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 idle_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 initial_congestion_windowsize: Optional[pulumi.Input[builtins.int]] = None,
                 keepalive_interval: Optional[pulumi.Input[builtins.int]] = None,
                 nagle: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 partition: Optional[pulumi.Input[builtins.str]] = None,
                 proxybuffer_high: Optional[pulumi.Input[builtins.int]] = None,
                 receive_windowsize: Optional[pulumi.Input[builtins.int]] = None,
                 send_buffersize: Optional[pulumi.Input[builtins.int]] = None,
                 tailloss_probe: Optional[pulumi.Input[builtins.str]] = None,
                 timewait_recycle: Optional[pulumi.Input[builtins.str]] = None,
                 verified_accept: Optional[pulumi.Input[builtins.str]] = None,
                 zerowindow_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProfileTcpArgs.__new__(ProfileTcpArgs)

            __props__.__dict__["close_wait_timeout"] = close_wait_timeout
            __props__.__dict__["congestion_control"] = congestion_control
            __props__.__dict__["defaults_from"] = defaults_from
            __props__.__dict__["deferred_accept"] = deferred_accept
            __props__.__dict__["delayed_acks"] = delayed_acks
            __props__.__dict__["early_retransmit"] = early_retransmit
            __props__.__dict__["fast_open"] = fast_open
            __props__.__dict__["finwait2timeout"] = finwait2timeout
            __props__.__dict__["finwait_timeout"] = finwait_timeout
            __props__.__dict__["idle_timeout"] = idle_timeout
            __props__.__dict__["initial_congestion_windowsize"] = initial_congestion_windowsize
            __props__.__dict__["keepalive_interval"] = keepalive_interval
            __props__.__dict__["nagle"] = nagle
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["partition"] = partition
            __props__.__dict__["proxybuffer_high"] = proxybuffer_high
            __props__.__dict__["receive_windowsize"] = receive_windowsize
            __props__.__dict__["send_buffersize"] = send_buffersize
            __props__.__dict__["tailloss_probe"] = tailloss_probe
            __props__.__dict__["timewait_recycle"] = timewait_recycle
            __props__.__dict__["verified_accept"] = verified_accept
            __props__.__dict__["zerowindow_timeout"] = zerowindow_timeout
        super(ProfileTcp, __self__).__init__(
            'f5bigip:ltm/profileTcp:ProfileTcp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            close_wait_timeout: Optional[pulumi.Input[builtins.int]] = None,
            congestion_control: Optional[pulumi.Input[builtins.str]] = None,
            defaults_from: Optional[pulumi.Input[builtins.str]] = None,
            deferred_accept: Optional[pulumi.Input[builtins.str]] = None,
            delayed_acks: Optional[pulumi.Input[builtins.str]] = None,
            early_retransmit: Optional[pulumi.Input[builtins.str]] = None,
            fast_open: Optional[pulumi.Input[builtins.str]] = None,
            finwait2timeout: Optional[pulumi.Input[builtins.int]] = None,
            finwait_timeout: Optional[pulumi.Input[builtins.int]] = None,
            idle_timeout: Optional[pulumi.Input[builtins.int]] = None,
            initial_congestion_windowsize: Optional[pulumi.Input[builtins.int]] = None,
            keepalive_interval: Optional[pulumi.Input[builtins.int]] = None,
            nagle: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            partition: Optional[pulumi.Input[builtins.str]] = None,
            proxybuffer_high: Optional[pulumi.Input[builtins.int]] = None,
            receive_windowsize: Optional[pulumi.Input[builtins.int]] = None,
            send_buffersize: Optional[pulumi.Input[builtins.int]] = None,
            tailloss_probe: Optional[pulumi.Input[builtins.str]] = None,
            timewait_recycle: Optional[pulumi.Input[builtins.str]] = None,
            verified_accept: Optional[pulumi.Input[builtins.str]] = None,
            zerowindow_timeout: Optional[pulumi.Input[builtins.int]] = None) -> 'ProfileTcp':
        """
        Get an existing ProfileTcp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] close_wait_timeout: Specifies the number of seconds that a connection remains in a LAST-ACK state before quitting. A value of 0 represents a term of forever (or until the maxrtx of the FIN state). The default value is 5 seconds.
        :param pulumi.Input[builtins.str] congestion_control: Specifies the algorithm to use to share network resources among competing users to reduce congestion. The default is High Speed.
        :param pulumi.Input[builtins.str] defaults_from: Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        :param pulumi.Input[builtins.str] deferred_accept: Specifies, when enabled, that the system defers allocation of the connection chain context until the client response is received. This option is useful for dealing with 3-way handshake DOS attacks. The default value is disabled.
        :param pulumi.Input[builtins.str] delayed_acks: Specifies, when checked (enabled), that the system can send fewer than one ACK (acknowledgment) segment per data segment received. By default, this setting is enabled.
        :param pulumi.Input[builtins.str] early_retransmit: Enabling this setting allows TCP to assume a packet is lost after fewer than the standard number of duplicate ACKs, if there is no way to send new data and generate more duplicate ACKs.
        :param pulumi.Input[builtins.str] fast_open: When enabled, permits TCP Fast Open, allowing properly equipped TCP clients to send data with the SYN packet. Default is `enabled`. If `fast_open` set to `enabled`, argument `verified_accept` can't be set to `enabled`.
        :param pulumi.Input[builtins.int] finwait2timeout: Specifies the number of seconds that a connection is in the FIN-WAIT-2 state before quitting. The default value is 300 seconds. A value of 0 (zero) represents a term of forever (or until the maxrtx of the FIN state).
        :param pulumi.Input[builtins.int] finwait_timeout: Specifies the number of seconds that a connection is in the FIN-WAIT-1 or closing state before quitting. The default value is 5 seconds. A value of 0 (zero) represents a term of forever (or until the maxrtx of the FIN state). You can also specify immediate or indefinite.
        :param pulumi.Input[builtins.int] idle_timeout: Specifies the number of seconds that a connection is idle before the connection is eligible for deletion. The default value is 300 seconds.
        :param pulumi.Input[builtins.int] initial_congestion_windowsize: Specifies the initial congestion window size for connections to this destination. Actual window size is this value multiplied by the MSS (Maximum Segment Size) for the same connection. The default is 10. Valid values range from 0 to 64.
        :param pulumi.Input[builtins.int] keepalive_interval: Specifies the keep alive probe interval, in seconds. The default value is 1800 seconds.
        :param pulumi.Input[builtins.str] nagle: Specifies whether the system applies Nagle's algorithm to reduce the number of short segments on the network.If you select Auto, the system determines whether to use Nagle's algorithm based on network conditions. By default, this setting is disabled.
        :param pulumi.Input[builtins.str] name: Name of the LTM TCP Profile,name should be `full path`. The full path is the combination of the `partition + name` (example: /Common/my-pool ) or  `partition + directory + name` of the resource  (example: /Common/test/my-pool )
        :param pulumi.Input[builtins.str] partition: name of partition
        :param pulumi.Input[builtins.int] proxybuffer_high: Specifies the proxy buffer level, in bytes, at which the receive window is closed.
        :param pulumi.Input[builtins.int] receive_windowsize: Specifies the maximum advertised RECEIVE window size. This value represents the maximum number of bytes to which the RECEIVE window can scale. The default is 65535 bytes.
        :param pulumi.Input[builtins.int] send_buffersize: Specifies the SEND window size. The default is 131072 bytes.
        :param pulumi.Input[builtins.str] tailloss_probe: Enabling this setting allows TCP to send a probe segment to trigger fast recovery instead of recovering a loss via a retransmission timeout,By default, this setting is enabled.
        :param pulumi.Input[builtins.str] timewait_recycle: Using this setting enabled, the system can recycle a wait-state connection immediately upon receipt of a new connection request instead of having to wait until the connection times out of the wait state. By default, this setting is enabled.
        :param pulumi.Input[builtins.str] verified_accept: Specifies, when checked (enabled), that the system can actually communicate with the server before establishing a client connection. To determine this, the system sends the server a SYN packet before responding to the client's SYN with a SYN-ACK. When unchecked, the system accepts the client connection before selecting a server to talk to. By default, this setting is `disabled`.
        :param pulumi.Input[builtins.int] zerowindow_timeout: Specifies the timeout in milliseconds for terminating a connection with an effective zero length TCP transmit window.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProfileTcpState.__new__(_ProfileTcpState)

        __props__.__dict__["close_wait_timeout"] = close_wait_timeout
        __props__.__dict__["congestion_control"] = congestion_control
        __props__.__dict__["defaults_from"] = defaults_from
        __props__.__dict__["deferred_accept"] = deferred_accept
        __props__.__dict__["delayed_acks"] = delayed_acks
        __props__.__dict__["early_retransmit"] = early_retransmit
        __props__.__dict__["fast_open"] = fast_open
        __props__.__dict__["finwait2timeout"] = finwait2timeout
        __props__.__dict__["finwait_timeout"] = finwait_timeout
        __props__.__dict__["idle_timeout"] = idle_timeout
        __props__.__dict__["initial_congestion_windowsize"] = initial_congestion_windowsize
        __props__.__dict__["keepalive_interval"] = keepalive_interval
        __props__.__dict__["nagle"] = nagle
        __props__.__dict__["name"] = name
        __props__.__dict__["partition"] = partition
        __props__.__dict__["proxybuffer_high"] = proxybuffer_high
        __props__.__dict__["receive_windowsize"] = receive_windowsize
        __props__.__dict__["send_buffersize"] = send_buffersize
        __props__.__dict__["tailloss_probe"] = tailloss_probe
        __props__.__dict__["timewait_recycle"] = timewait_recycle
        __props__.__dict__["verified_accept"] = verified_accept
        __props__.__dict__["zerowindow_timeout"] = zerowindow_timeout
        return ProfileTcp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="closeWaitTimeout")
    def close_wait_timeout(self) -> pulumi.Output[builtins.int]:
        """
        Specifies the number of seconds that a connection remains in a LAST-ACK state before quitting. A value of 0 represents a term of forever (or until the maxrtx of the FIN state). The default value is 5 seconds.
        """
        return pulumi.get(self, "close_wait_timeout")

    @property
    @pulumi.getter(name="congestionControl")
    def congestion_control(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the algorithm to use to share network resources among competing users to reduce congestion. The default is High Speed.
        """
        return pulumi.get(self, "congestion_control")

    @property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        """
        return pulumi.get(self, "defaults_from")

    @property
    @pulumi.getter(name="deferredAccept")
    def deferred_accept(self) -> pulumi.Output[builtins.str]:
        """
        Specifies, when enabled, that the system defers allocation of the connection chain context until the client response is received. This option is useful for dealing with 3-way handshake DOS attacks. The default value is disabled.
        """
        return pulumi.get(self, "deferred_accept")

    @property
    @pulumi.getter(name="delayedAcks")
    def delayed_acks(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies, when checked (enabled), that the system can send fewer than one ACK (acknowledgment) segment per data segment received. By default, this setting is enabled.
        """
        return pulumi.get(self, "delayed_acks")

    @property
    @pulumi.getter(name="earlyRetransmit")
    def early_retransmit(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Enabling this setting allows TCP to assume a packet is lost after fewer than the standard number of duplicate ACKs, if there is no way to send new data and generate more duplicate ACKs.
        """
        return pulumi.get(self, "early_retransmit")

    @property
    @pulumi.getter(name="fastOpen")
    def fast_open(self) -> pulumi.Output[builtins.str]:
        """
        When enabled, permits TCP Fast Open, allowing properly equipped TCP clients to send data with the SYN packet. Default is `enabled`. If `fast_open` set to `enabled`, argument `verified_accept` can't be set to `enabled`.
        """
        return pulumi.get(self, "fast_open")

    @property
    @pulumi.getter
    def finwait2timeout(self) -> pulumi.Output[builtins.int]:
        """
        Specifies the number of seconds that a connection is in the FIN-WAIT-2 state before quitting. The default value is 300 seconds. A value of 0 (zero) represents a term of forever (or until the maxrtx of the FIN state).
        """
        return pulumi.get(self, "finwait2timeout")

    @property
    @pulumi.getter(name="finwaitTimeout")
    def finwait_timeout(self) -> pulumi.Output[builtins.int]:
        """
        Specifies the number of seconds that a connection is in the FIN-WAIT-1 or closing state before quitting. The default value is 5 seconds. A value of 0 (zero) represents a term of forever (or until the maxrtx of the FIN state). You can also specify immediate or indefinite.
        """
        return pulumi.get(self, "finwait_timeout")

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> pulumi.Output[builtins.int]:
        """
        Specifies the number of seconds that a connection is idle before the connection is eligible for deletion. The default value is 300 seconds.
        """
        return pulumi.get(self, "idle_timeout")

    @property
    @pulumi.getter(name="initialCongestionWindowsize")
    def initial_congestion_windowsize(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the initial congestion window size for connections to this destination. Actual window size is this value multiplied by the MSS (Maximum Segment Size) for the same connection. The default is 10. Valid values range from 0 to 64.
        """
        return pulumi.get(self, "initial_congestion_windowsize")

    @property
    @pulumi.getter(name="keepaliveInterval")
    def keepalive_interval(self) -> pulumi.Output[builtins.int]:
        """
        Specifies the keep alive probe interval, in seconds. The default value is 1800 seconds.
        """
        return pulumi.get(self, "keepalive_interval")

    @property
    @pulumi.getter
    def nagle(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies whether the system applies Nagle's algorithm to reduce the number of short segments on the network.If you select Auto, the system determines whether to use Nagle's algorithm based on network conditions. By default, this setting is disabled.
        """
        return pulumi.get(self, "nagle")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the LTM TCP Profile,name should be `full path`. The full path is the combination of the `partition + name` (example: /Common/my-pool ) or  `partition + directory + name` of the resource  (example: /Common/test/my-pool )
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def partition(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        name of partition
        """
        return pulumi.get(self, "partition")

    @property
    @pulumi.getter(name="proxybufferHigh")
    def proxybuffer_high(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the proxy buffer level, in bytes, at which the receive window is closed.
        """
        return pulumi.get(self, "proxybuffer_high")

    @property
    @pulumi.getter(name="receiveWindowsize")
    def receive_windowsize(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the maximum advertised RECEIVE window size. This value represents the maximum number of bytes to which the RECEIVE window can scale. The default is 65535 bytes.
        """
        return pulumi.get(self, "receive_windowsize")

    @property
    @pulumi.getter(name="sendBuffersize")
    def send_buffersize(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the SEND window size. The default is 131072 bytes.
        """
        return pulumi.get(self, "send_buffersize")

    @property
    @pulumi.getter(name="taillossProbe")
    def tailloss_probe(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Enabling this setting allows TCP to send a probe segment to trigger fast recovery instead of recovering a loss via a retransmission timeout,By default, this setting is enabled.
        """
        return pulumi.get(self, "tailloss_probe")

    @property
    @pulumi.getter(name="timewaitRecycle")
    def timewait_recycle(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Using this setting enabled, the system can recycle a wait-state connection immediately upon receipt of a new connection request instead of having to wait until the connection times out of the wait state. By default, this setting is enabled.
        """
        return pulumi.get(self, "timewait_recycle")

    @property
    @pulumi.getter(name="verifiedAccept")
    def verified_accept(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies, when checked (enabled), that the system can actually communicate with the server before establishing a client connection. To determine this, the system sends the server a SYN packet before responding to the client's SYN with a SYN-ACK. When unchecked, the system accepts the client connection before selecting a server to talk to. By default, this setting is `disabled`.
        """
        return pulumi.get(self, "verified_accept")

    @property
    @pulumi.getter(name="zerowindowTimeout")
    def zerowindow_timeout(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the timeout in milliseconds for terminating a connection with an effective zero length TCP transmit window.
        """
        return pulumi.get(self, "zerowindow_timeout")

