# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VirtualServerArgs', 'VirtualServer']

@pulumi.input_type
class VirtualServerArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 client_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 connection_limit: Optional[pulumi.Input[builtins.int]] = None,
                 default_persistence_profile: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination: Optional[pulumi.Input[builtins.str]] = None,
                 fallback_persistence_profile: Optional[pulumi.Input[builtins.str]] = None,
                 firewall_enforced_policy: Optional[pulumi.Input[builtins.str]] = None,
                 ip_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 irules: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 mask: Optional[pulumi.Input[builtins.str]] = None,
                 per_flow_request_access_policy: Optional[pulumi.Input[builtins.str]] = None,
                 persistence_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 pool: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 security_log_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 server_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 snatpool: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 source_address_translation: Optional[pulumi.Input[builtins.str]] = None,
                 source_port: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 trafficmatching_criteria: Optional[pulumi.Input[builtins.str]] = None,
                 translate_address: Optional[pulumi.Input[builtins.str]] = None,
                 translate_port: Optional[pulumi.Input[builtins.str]] = None,
                 vlans: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 vlans_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a VirtualServer resource.
        :param pulumi.Input[builtins.str] name: Name of the virtual server
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] client_profiles: List of client context profiles associated on the virtual server. Not mutually exclusive with profiles and server_profiles
        :param pulumi.Input[builtins.int] connection_limit: Specifies the maximum number of connections allowed for the virtual server.
        :param pulumi.Input[builtins.str] description: Description of Virtual server
        :param pulumi.Input[builtins.str] destination: Destination IP
        :param pulumi.Input[builtins.str] fallback_persistence_profile: Specifies a fallback persistence profile for the Virtual Server to use when the default persistence profile is not available.
        :param pulumi.Input[builtins.str] firewall_enforced_policy: Applies the specified AFM policy to the virtual in an enforcing way,when creating a new virtual, if this parameter is not specified, the enforced is disabled.This should be in full path ex: `/Common/afm-test-policy`.
        :param pulumi.Input[builtins.str] ip_protocol: Specifies a network protocol name you want the system to use to direct traffic on this virtual server. The default is `tcp`. valid options are [`any`,`udp`,`tcp`]
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] irules: The iRules list you want run on this virtual server. iRules help automate the intercepting, processing, and routing of application traffic.
        :param pulumi.Input[builtins.str] mask: Mask can either be in CIDR notation or decimal, i.e.: 24 or 255.255.255.0. A CIDR mask of 0 is the same as 0.0.0.0
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] persistence_profiles: List of persistence profiles associated with the Virtual Server.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] policies: Specifies the policies for the virtual server.
        :param pulumi.Input[builtins.str] pool: Default pool name
        :param pulumi.Input[builtins.int] port: Listen port for the virtual server
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] profiles: List of profiles associated both client and server contexts on the virtual server. This includes protocol, ssl, http, etc.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_log_profiles: Specifies the log profile applied to the virtual server.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] server_profiles: List of server context profiles associated on the virtual server. Not mutually exclusive with profiles and client_profiles
        :param pulumi.Input[builtins.str] snatpool: Specifies the name of an existing SNAT pool that you want the virtual server to use to implement selective and intelligent SNATs.
        :param pulumi.Input[builtins.str] source: Specifies an IP address or network from which the virtual server will accept traffic.
        :param pulumi.Input[builtins.str] source_address_translation: Can be either omitted for `none` or the values `automap` options : [`snat`,`automap`,`none`].
        :param pulumi.Input[builtins.str] source_port: Specifies whether the system preserves the source port of the connection. The default is `preserve`.
        :param pulumi.Input[builtins.str] state: Specifies whether the virtual server and its resources are available for load balancing. The default is Enabled
        :param pulumi.Input[builtins.str] trafficmatching_criteria: Specifies destination traffic matching information to which the virtual server sends traffic
        :param pulumi.Input[builtins.str] translate_address: Enables or disables address translation for the virtual server. Turn address translation off for a virtual server if you want to use the virtual server to load balance connections to any address. This option is useful when the system is load balancing devices that have the same IP address.
        :param pulumi.Input[builtins.str] translate_port: Enables or disables port translation. Turn port translation off for a virtual server if you want to use the virtual server to load balance connections to any service
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vlans: The virtual server is enabled/disabled on this set of VLANs,enable/disabled will be desided by attribute `vlan_enabled`
        :param pulumi.Input[builtins.bool] vlans_enabled: Enables the virtual server on the VLANs specified by the `vlans` option.
               By default it is `false` i.e vlanDisabled on specified vlans, if we want enable virtual server on VLANs specified by `vlans`, mark this attribute to `true`.
        """
        pulumi.set(__self__, "name", name)
        if client_profiles is not None:
            pulumi.set(__self__, "client_profiles", client_profiles)
        if connection_limit is not None:
            pulumi.set(__self__, "connection_limit", connection_limit)
        if default_persistence_profile is not None:
            pulumi.set(__self__, "default_persistence_profile", default_persistence_profile)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if fallback_persistence_profile is not None:
            pulumi.set(__self__, "fallback_persistence_profile", fallback_persistence_profile)
        if firewall_enforced_policy is not None:
            pulumi.set(__self__, "firewall_enforced_policy", firewall_enforced_policy)
        if ip_protocol is not None:
            pulumi.set(__self__, "ip_protocol", ip_protocol)
        if irules is not None:
            pulumi.set(__self__, "irules", irules)
        if mask is not None:
            pulumi.set(__self__, "mask", mask)
        if per_flow_request_access_policy is not None:
            pulumi.set(__self__, "per_flow_request_access_policy", per_flow_request_access_policy)
        if persistence_profiles is not None:
            pulumi.set(__self__, "persistence_profiles", persistence_profiles)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if pool is not None:
            pulumi.set(__self__, "pool", pool)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if profiles is not None:
            pulumi.set(__self__, "profiles", profiles)
        if security_log_profiles is not None:
            pulumi.set(__self__, "security_log_profiles", security_log_profiles)
        if server_profiles is not None:
            pulumi.set(__self__, "server_profiles", server_profiles)
        if snatpool is not None:
            pulumi.set(__self__, "snatpool", snatpool)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_address_translation is not None:
            pulumi.set(__self__, "source_address_translation", source_address_translation)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if trafficmatching_criteria is not None:
            pulumi.set(__self__, "trafficmatching_criteria", trafficmatching_criteria)
        if translate_address is not None:
            pulumi.set(__self__, "translate_address", translate_address)
        if translate_port is not None:
            pulumi.set(__self__, "translate_port", translate_port)
        if vlans is not None:
            pulumi.set(__self__, "vlans", vlans)
        if vlans_enabled is not None:
            pulumi.set(__self__, "vlans_enabled", vlans_enabled)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the virtual server
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="clientProfiles")
    def client_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of client context profiles associated on the virtual server. Not mutually exclusive with profiles and server_profiles
        """
        return pulumi.get(self, "client_profiles")

    @client_profiles.setter
    def client_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "client_profiles", value)

    @property
    @pulumi.getter(name="connectionLimit")
    def connection_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the maximum number of connections allowed for the virtual server.
        """
        return pulumi.get(self, "connection_limit")

    @connection_limit.setter
    def connection_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "connection_limit", value)

    @property
    @pulumi.getter(name="defaultPersistenceProfile")
    def default_persistence_profile(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "default_persistence_profile")

    @default_persistence_profile.setter
    def default_persistence_profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_persistence_profile", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of Virtual server
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Destination IP
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="fallbackPersistenceProfile")
    def fallback_persistence_profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a fallback persistence profile for the Virtual Server to use when the default persistence profile is not available.
        """
        return pulumi.get(self, "fallback_persistence_profile")

    @fallback_persistence_profile.setter
    def fallback_persistence_profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fallback_persistence_profile", value)

    @property
    @pulumi.getter(name="firewallEnforcedPolicy")
    def firewall_enforced_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Applies the specified AFM policy to the virtual in an enforcing way,when creating a new virtual, if this parameter is not specified, the enforced is disabled.This should be in full path ex: `/Common/afm-test-policy`.
        """
        return pulumi.get(self, "firewall_enforced_policy")

    @firewall_enforced_policy.setter
    def firewall_enforced_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "firewall_enforced_policy", value)

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a network protocol name you want the system to use to direct traffic on this virtual server. The default is `tcp`. valid options are [`any`,`udp`,`tcp`]
        """
        return pulumi.get(self, "ip_protocol")

    @ip_protocol.setter
    def ip_protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_protocol", value)

    @property
    @pulumi.getter
    def irules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The iRules list you want run on this virtual server. iRules help automate the intercepting, processing, and routing of application traffic.
        """
        return pulumi.get(self, "irules")

    @irules.setter
    def irules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "irules", value)

    @property
    @pulumi.getter
    def mask(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Mask can either be in CIDR notation or decimal, i.e.: 24 or 255.255.255.0. A CIDR mask of 0 is the same as 0.0.0.0
        """
        return pulumi.get(self, "mask")

    @mask.setter
    def mask(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mask", value)

    @property
    @pulumi.getter(name="perFlowRequestAccessPolicy")
    def per_flow_request_access_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "per_flow_request_access_policy")

    @per_flow_request_access_policy.setter
    def per_flow_request_access_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "per_flow_request_access_policy", value)

    @property
    @pulumi.getter(name="persistenceProfiles")
    def persistence_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of persistence profiles associated with the Virtual Server.
        """
        return pulumi.get(self, "persistence_profiles")

    @persistence_profiles.setter
    def persistence_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "persistence_profiles", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the policies for the virtual server.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter
    def pool(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Default pool name
        """
        return pulumi.get(self, "pool")

    @pool.setter
    def pool(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pool", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Listen port for the virtual server
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of profiles associated both client and server contexts on the virtual server. This includes protocol, ssl, http, etc.
        """
        return pulumi.get(self, "profiles")

    @profiles.setter
    def profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "profiles", value)

    @property
    @pulumi.getter(name="securityLogProfiles")
    def security_log_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the log profile applied to the virtual server.
        """
        return pulumi.get(self, "security_log_profiles")

    @security_log_profiles.setter
    def security_log_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_log_profiles", value)

    @property
    @pulumi.getter(name="serverProfiles")
    def server_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of server context profiles associated on the virtual server. Not mutually exclusive with profiles and client_profiles
        """
        return pulumi.get(self, "server_profiles")

    @server_profiles.setter
    def server_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "server_profiles", value)

    @property
    @pulumi.getter
    def snatpool(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of an existing SNAT pool that you want the virtual server to use to implement selective and intelligent SNATs.
        """
        return pulumi.get(self, "snatpool")

    @snatpool.setter
    def snatpool(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snatpool", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies an IP address or network from which the virtual server will accept traffic.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="sourceAddressTranslation")
    def source_address_translation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Can be either omitted for `none` or the values `automap` options : [`snat`,`automap`,`none`].
        """
        return pulumi.get(self, "source_address_translation")

    @source_address_translation.setter
    def source_address_translation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_address_translation", value)

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether the system preserves the source port of the connection. The default is `preserve`.
        """
        return pulumi.get(self, "source_port")

    @source_port.setter
    def source_port(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_port", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether the virtual server and its resources are available for load balancing. The default is Enabled
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="trafficmatchingCriteria")
    def trafficmatching_criteria(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies destination traffic matching information to which the virtual server sends traffic
        """
        return pulumi.get(self, "trafficmatching_criteria")

    @trafficmatching_criteria.setter
    def trafficmatching_criteria(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trafficmatching_criteria", value)

    @property
    @pulumi.getter(name="translateAddress")
    def translate_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enables or disables address translation for the virtual server. Turn address translation off for a virtual server if you want to use the virtual server to load balance connections to any address. This option is useful when the system is load balancing devices that have the same IP address.
        """
        return pulumi.get(self, "translate_address")

    @translate_address.setter
    def translate_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "translate_address", value)

    @property
    @pulumi.getter(name="translatePort")
    def translate_port(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enables or disables port translation. Turn port translation off for a virtual server if you want to use the virtual server to load balance connections to any service
        """
        return pulumi.get(self, "translate_port")

    @translate_port.setter
    def translate_port(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "translate_port", value)

    @property
    @pulumi.getter
    def vlans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The virtual server is enabled/disabled on this set of VLANs,enable/disabled will be desided by attribute `vlan_enabled`
        """
        return pulumi.get(self, "vlans")

    @vlans.setter
    def vlans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "vlans", value)

    @property
    @pulumi.getter(name="vlansEnabled")
    def vlans_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables the virtual server on the VLANs specified by the `vlans` option.
        By default it is `false` i.e vlanDisabled on specified vlans, if we want enable virtual server on VLANs specified by `vlans`, mark this attribute to `true`.
        """
        return pulumi.get(self, "vlans_enabled")

    @vlans_enabled.setter
    def vlans_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "vlans_enabled", value)


@pulumi.input_type
class _VirtualServerState:
    def __init__(__self__, *,
                 client_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 connection_limit: Optional[pulumi.Input[builtins.int]] = None,
                 default_persistence_profile: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination: Optional[pulumi.Input[builtins.str]] = None,
                 fallback_persistence_profile: Optional[pulumi.Input[builtins.str]] = None,
                 firewall_enforced_policy: Optional[pulumi.Input[builtins.str]] = None,
                 ip_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 irules: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 mask: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 per_flow_request_access_policy: Optional[pulumi.Input[builtins.str]] = None,
                 persistence_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 pool: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 security_log_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 server_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 snatpool: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 source_address_translation: Optional[pulumi.Input[builtins.str]] = None,
                 source_port: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 trafficmatching_criteria: Optional[pulumi.Input[builtins.str]] = None,
                 translate_address: Optional[pulumi.Input[builtins.str]] = None,
                 translate_port: Optional[pulumi.Input[builtins.str]] = None,
                 vlans: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 vlans_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering VirtualServer resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] client_profiles: List of client context profiles associated on the virtual server. Not mutually exclusive with profiles and server_profiles
        :param pulumi.Input[builtins.int] connection_limit: Specifies the maximum number of connections allowed for the virtual server.
        :param pulumi.Input[builtins.str] description: Description of Virtual server
        :param pulumi.Input[builtins.str] destination: Destination IP
        :param pulumi.Input[builtins.str] fallback_persistence_profile: Specifies a fallback persistence profile for the Virtual Server to use when the default persistence profile is not available.
        :param pulumi.Input[builtins.str] firewall_enforced_policy: Applies the specified AFM policy to the virtual in an enforcing way,when creating a new virtual, if this parameter is not specified, the enforced is disabled.This should be in full path ex: `/Common/afm-test-policy`.
        :param pulumi.Input[builtins.str] ip_protocol: Specifies a network protocol name you want the system to use to direct traffic on this virtual server. The default is `tcp`. valid options are [`any`,`udp`,`tcp`]
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] irules: The iRules list you want run on this virtual server. iRules help automate the intercepting, processing, and routing of application traffic.
        :param pulumi.Input[builtins.str] mask: Mask can either be in CIDR notation or decimal, i.e.: 24 or 255.255.255.0. A CIDR mask of 0 is the same as 0.0.0.0
        :param pulumi.Input[builtins.str] name: Name of the virtual server
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] persistence_profiles: List of persistence profiles associated with the Virtual Server.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] policies: Specifies the policies for the virtual server.
        :param pulumi.Input[builtins.str] pool: Default pool name
        :param pulumi.Input[builtins.int] port: Listen port for the virtual server
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] profiles: List of profiles associated both client and server contexts on the virtual server. This includes protocol, ssl, http, etc.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_log_profiles: Specifies the log profile applied to the virtual server.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] server_profiles: List of server context profiles associated on the virtual server. Not mutually exclusive with profiles and client_profiles
        :param pulumi.Input[builtins.str] snatpool: Specifies the name of an existing SNAT pool that you want the virtual server to use to implement selective and intelligent SNATs.
        :param pulumi.Input[builtins.str] source: Specifies an IP address or network from which the virtual server will accept traffic.
        :param pulumi.Input[builtins.str] source_address_translation: Can be either omitted for `none` or the values `automap` options : [`snat`,`automap`,`none`].
        :param pulumi.Input[builtins.str] source_port: Specifies whether the system preserves the source port of the connection. The default is `preserve`.
        :param pulumi.Input[builtins.str] state: Specifies whether the virtual server and its resources are available for load balancing. The default is Enabled
        :param pulumi.Input[builtins.str] trafficmatching_criteria: Specifies destination traffic matching information to which the virtual server sends traffic
        :param pulumi.Input[builtins.str] translate_address: Enables or disables address translation for the virtual server. Turn address translation off for a virtual server if you want to use the virtual server to load balance connections to any address. This option is useful when the system is load balancing devices that have the same IP address.
        :param pulumi.Input[builtins.str] translate_port: Enables or disables port translation. Turn port translation off for a virtual server if you want to use the virtual server to load balance connections to any service
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vlans: The virtual server is enabled/disabled on this set of VLANs,enable/disabled will be desided by attribute `vlan_enabled`
        :param pulumi.Input[builtins.bool] vlans_enabled: Enables the virtual server on the VLANs specified by the `vlans` option.
               By default it is `false` i.e vlanDisabled on specified vlans, if we want enable virtual server on VLANs specified by `vlans`, mark this attribute to `true`.
        """
        if client_profiles is not None:
            pulumi.set(__self__, "client_profiles", client_profiles)
        if connection_limit is not None:
            pulumi.set(__self__, "connection_limit", connection_limit)
        if default_persistence_profile is not None:
            pulumi.set(__self__, "default_persistence_profile", default_persistence_profile)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if fallback_persistence_profile is not None:
            pulumi.set(__self__, "fallback_persistence_profile", fallback_persistence_profile)
        if firewall_enforced_policy is not None:
            pulumi.set(__self__, "firewall_enforced_policy", firewall_enforced_policy)
        if ip_protocol is not None:
            pulumi.set(__self__, "ip_protocol", ip_protocol)
        if irules is not None:
            pulumi.set(__self__, "irules", irules)
        if mask is not None:
            pulumi.set(__self__, "mask", mask)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if per_flow_request_access_policy is not None:
            pulumi.set(__self__, "per_flow_request_access_policy", per_flow_request_access_policy)
        if persistence_profiles is not None:
            pulumi.set(__self__, "persistence_profiles", persistence_profiles)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if pool is not None:
            pulumi.set(__self__, "pool", pool)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if profiles is not None:
            pulumi.set(__self__, "profiles", profiles)
        if security_log_profiles is not None:
            pulumi.set(__self__, "security_log_profiles", security_log_profiles)
        if server_profiles is not None:
            pulumi.set(__self__, "server_profiles", server_profiles)
        if snatpool is not None:
            pulumi.set(__self__, "snatpool", snatpool)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_address_translation is not None:
            pulumi.set(__self__, "source_address_translation", source_address_translation)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if trafficmatching_criteria is not None:
            pulumi.set(__self__, "trafficmatching_criteria", trafficmatching_criteria)
        if translate_address is not None:
            pulumi.set(__self__, "translate_address", translate_address)
        if translate_port is not None:
            pulumi.set(__self__, "translate_port", translate_port)
        if vlans is not None:
            pulumi.set(__self__, "vlans", vlans)
        if vlans_enabled is not None:
            pulumi.set(__self__, "vlans_enabled", vlans_enabled)

    @property
    @pulumi.getter(name="clientProfiles")
    def client_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of client context profiles associated on the virtual server. Not mutually exclusive with profiles and server_profiles
        """
        return pulumi.get(self, "client_profiles")

    @client_profiles.setter
    def client_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "client_profiles", value)

    @property
    @pulumi.getter(name="connectionLimit")
    def connection_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the maximum number of connections allowed for the virtual server.
        """
        return pulumi.get(self, "connection_limit")

    @connection_limit.setter
    def connection_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "connection_limit", value)

    @property
    @pulumi.getter(name="defaultPersistenceProfile")
    def default_persistence_profile(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "default_persistence_profile")

    @default_persistence_profile.setter
    def default_persistence_profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_persistence_profile", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of Virtual server
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Destination IP
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="fallbackPersistenceProfile")
    def fallback_persistence_profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a fallback persistence profile for the Virtual Server to use when the default persistence profile is not available.
        """
        return pulumi.get(self, "fallback_persistence_profile")

    @fallback_persistence_profile.setter
    def fallback_persistence_profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fallback_persistence_profile", value)

    @property
    @pulumi.getter(name="firewallEnforcedPolicy")
    def firewall_enforced_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Applies the specified AFM policy to the virtual in an enforcing way,when creating a new virtual, if this parameter is not specified, the enforced is disabled.This should be in full path ex: `/Common/afm-test-policy`.
        """
        return pulumi.get(self, "firewall_enforced_policy")

    @firewall_enforced_policy.setter
    def firewall_enforced_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "firewall_enforced_policy", value)

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a network protocol name you want the system to use to direct traffic on this virtual server. The default is `tcp`. valid options are [`any`,`udp`,`tcp`]
        """
        return pulumi.get(self, "ip_protocol")

    @ip_protocol.setter
    def ip_protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_protocol", value)

    @property
    @pulumi.getter
    def irules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The iRules list you want run on this virtual server. iRules help automate the intercepting, processing, and routing of application traffic.
        """
        return pulumi.get(self, "irules")

    @irules.setter
    def irules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "irules", value)

    @property
    @pulumi.getter
    def mask(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Mask can either be in CIDR notation or decimal, i.e.: 24 or 255.255.255.0. A CIDR mask of 0 is the same as 0.0.0.0
        """
        return pulumi.get(self, "mask")

    @mask.setter
    def mask(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mask", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the virtual server
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="perFlowRequestAccessPolicy")
    def per_flow_request_access_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "per_flow_request_access_policy")

    @per_flow_request_access_policy.setter
    def per_flow_request_access_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "per_flow_request_access_policy", value)

    @property
    @pulumi.getter(name="persistenceProfiles")
    def persistence_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of persistence profiles associated with the Virtual Server.
        """
        return pulumi.get(self, "persistence_profiles")

    @persistence_profiles.setter
    def persistence_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "persistence_profiles", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the policies for the virtual server.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter
    def pool(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Default pool name
        """
        return pulumi.get(self, "pool")

    @pool.setter
    def pool(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pool", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Listen port for the virtual server
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of profiles associated both client and server contexts on the virtual server. This includes protocol, ssl, http, etc.
        """
        return pulumi.get(self, "profiles")

    @profiles.setter
    def profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "profiles", value)

    @property
    @pulumi.getter(name="securityLogProfiles")
    def security_log_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the log profile applied to the virtual server.
        """
        return pulumi.get(self, "security_log_profiles")

    @security_log_profiles.setter
    def security_log_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_log_profiles", value)

    @property
    @pulumi.getter(name="serverProfiles")
    def server_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of server context profiles associated on the virtual server. Not mutually exclusive with profiles and client_profiles
        """
        return pulumi.get(self, "server_profiles")

    @server_profiles.setter
    def server_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "server_profiles", value)

    @property
    @pulumi.getter
    def snatpool(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of an existing SNAT pool that you want the virtual server to use to implement selective and intelligent SNATs.
        """
        return pulumi.get(self, "snatpool")

    @snatpool.setter
    def snatpool(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snatpool", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies an IP address or network from which the virtual server will accept traffic.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="sourceAddressTranslation")
    def source_address_translation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Can be either omitted for `none` or the values `automap` options : [`snat`,`automap`,`none`].
        """
        return pulumi.get(self, "source_address_translation")

    @source_address_translation.setter
    def source_address_translation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_address_translation", value)

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether the system preserves the source port of the connection. The default is `preserve`.
        """
        return pulumi.get(self, "source_port")

    @source_port.setter
    def source_port(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_port", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether the virtual server and its resources are available for load balancing. The default is Enabled
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="trafficmatchingCriteria")
    def trafficmatching_criteria(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies destination traffic matching information to which the virtual server sends traffic
        """
        return pulumi.get(self, "trafficmatching_criteria")

    @trafficmatching_criteria.setter
    def trafficmatching_criteria(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trafficmatching_criteria", value)

    @property
    @pulumi.getter(name="translateAddress")
    def translate_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enables or disables address translation for the virtual server. Turn address translation off for a virtual server if you want to use the virtual server to load balance connections to any address. This option is useful when the system is load balancing devices that have the same IP address.
        """
        return pulumi.get(self, "translate_address")

    @translate_address.setter
    def translate_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "translate_address", value)

    @property
    @pulumi.getter(name="translatePort")
    def translate_port(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enables or disables port translation. Turn port translation off for a virtual server if you want to use the virtual server to load balance connections to any service
        """
        return pulumi.get(self, "translate_port")

    @translate_port.setter
    def translate_port(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "translate_port", value)

    @property
    @pulumi.getter
    def vlans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The virtual server is enabled/disabled on this set of VLANs,enable/disabled will be desided by attribute `vlan_enabled`
        """
        return pulumi.get(self, "vlans")

    @vlans.setter
    def vlans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "vlans", value)

    @property
    @pulumi.getter(name="vlansEnabled")
    def vlans_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables the virtual server on the VLANs specified by the `vlans` option.
        By default it is `false` i.e vlanDisabled on specified vlans, if we want enable virtual server on VLANs specified by `vlans`, mark this attribute to `true`.
        """
        return pulumi.get(self, "vlans_enabled")

    @vlans_enabled.setter
    def vlans_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "vlans_enabled", value)


@pulumi.type_token("f5bigip:ltm/virtualServer:VirtualServer")
class VirtualServer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 connection_limit: Optional[pulumi.Input[builtins.int]] = None,
                 default_persistence_profile: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination: Optional[pulumi.Input[builtins.str]] = None,
                 fallback_persistence_profile: Optional[pulumi.Input[builtins.str]] = None,
                 firewall_enforced_policy: Optional[pulumi.Input[builtins.str]] = None,
                 ip_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 irules: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 mask: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 per_flow_request_access_policy: Optional[pulumi.Input[builtins.str]] = None,
                 persistence_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 pool: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 security_log_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 server_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 snatpool: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 source_address_translation: Optional[pulumi.Input[builtins.str]] = None,
                 source_port: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 trafficmatching_criteria: Optional[pulumi.Input[builtins.str]] = None,
                 translate_address: Optional[pulumi.Input[builtins.str]] = None,
                 translate_port: Optional[pulumi.Input[builtins.str]] = None,
                 vlans: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 vlans_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        `ltm.VirtualServer` Configures Virtual Server

        For resources should be named with their `full path`. The full path is the combination of the `partition + name` of the resource (example: `/Common/test-virtualserver` ) or `partition + directory + name` of the resource (example: `/Common/test/test-virtualserver` ).
        When including directory in `fullpath` we have to make sure it is created in the given partition before using it.

        ## Importing

        An existing virtual-server can be imported into this resource by supplying virtual-server Name in `full path` as `id`.
        An example is below:
        ```sh
        $ terraform import bigip_ltm_virtual_server.http /Common/terraform_vs_http
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] client_profiles: List of client context profiles associated on the virtual server. Not mutually exclusive with profiles and server_profiles
        :param pulumi.Input[builtins.int] connection_limit: Specifies the maximum number of connections allowed for the virtual server.
        :param pulumi.Input[builtins.str] description: Description of Virtual server
        :param pulumi.Input[builtins.str] destination: Destination IP
        :param pulumi.Input[builtins.str] fallback_persistence_profile: Specifies a fallback persistence profile for the Virtual Server to use when the default persistence profile is not available.
        :param pulumi.Input[builtins.str] firewall_enforced_policy: Applies the specified AFM policy to the virtual in an enforcing way,when creating a new virtual, if this parameter is not specified, the enforced is disabled.This should be in full path ex: `/Common/afm-test-policy`.
        :param pulumi.Input[builtins.str] ip_protocol: Specifies a network protocol name you want the system to use to direct traffic on this virtual server. The default is `tcp`. valid options are [`any`,`udp`,`tcp`]
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] irules: The iRules list you want run on this virtual server. iRules help automate the intercepting, processing, and routing of application traffic.
        :param pulumi.Input[builtins.str] mask: Mask can either be in CIDR notation or decimal, i.e.: 24 or 255.255.255.0. A CIDR mask of 0 is the same as 0.0.0.0
        :param pulumi.Input[builtins.str] name: Name of the virtual server
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] persistence_profiles: List of persistence profiles associated with the Virtual Server.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] policies: Specifies the policies for the virtual server.
        :param pulumi.Input[builtins.str] pool: Default pool name
        :param pulumi.Input[builtins.int] port: Listen port for the virtual server
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] profiles: List of profiles associated both client and server contexts on the virtual server. This includes protocol, ssl, http, etc.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_log_profiles: Specifies the log profile applied to the virtual server.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] server_profiles: List of server context profiles associated on the virtual server. Not mutually exclusive with profiles and client_profiles
        :param pulumi.Input[builtins.str] snatpool: Specifies the name of an existing SNAT pool that you want the virtual server to use to implement selective and intelligent SNATs.
        :param pulumi.Input[builtins.str] source: Specifies an IP address or network from which the virtual server will accept traffic.
        :param pulumi.Input[builtins.str] source_address_translation: Can be either omitted for `none` or the values `automap` options : [`snat`,`automap`,`none`].
        :param pulumi.Input[builtins.str] source_port: Specifies whether the system preserves the source port of the connection. The default is `preserve`.
        :param pulumi.Input[builtins.str] state: Specifies whether the virtual server and its resources are available for load balancing. The default is Enabled
        :param pulumi.Input[builtins.str] trafficmatching_criteria: Specifies destination traffic matching information to which the virtual server sends traffic
        :param pulumi.Input[builtins.str] translate_address: Enables or disables address translation for the virtual server. Turn address translation off for a virtual server if you want to use the virtual server to load balance connections to any address. This option is useful when the system is load balancing devices that have the same IP address.
        :param pulumi.Input[builtins.str] translate_port: Enables or disables port translation. Turn port translation off for a virtual server if you want to use the virtual server to load balance connections to any service
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vlans: The virtual server is enabled/disabled on this set of VLANs,enable/disabled will be desided by attribute `vlan_enabled`
        :param pulumi.Input[builtins.bool] vlans_enabled: Enables the virtual server on the VLANs specified by the `vlans` option.
               By default it is `false` i.e vlanDisabled on specified vlans, if we want enable virtual server on VLANs specified by `vlans`, mark this attribute to `true`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `ltm.VirtualServer` Configures Virtual Server

        For resources should be named with their `full path`. The full path is the combination of the `partition + name` of the resource (example: `/Common/test-virtualserver` ) or `partition + directory + name` of the resource (example: `/Common/test/test-virtualserver` ).
        When including directory in `fullpath` we have to make sure it is created in the given partition before using it.

        ## Importing

        An existing virtual-server can be imported into this resource by supplying virtual-server Name in `full path` as `id`.
        An example is below:
        ```sh
        $ terraform import bigip_ltm_virtual_server.http /Common/terraform_vs_http
        ```

        :param str resource_name: The name of the resource.
        :param VirtualServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 connection_limit: Optional[pulumi.Input[builtins.int]] = None,
                 default_persistence_profile: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination: Optional[pulumi.Input[builtins.str]] = None,
                 fallback_persistence_profile: Optional[pulumi.Input[builtins.str]] = None,
                 firewall_enforced_policy: Optional[pulumi.Input[builtins.str]] = None,
                 ip_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 irules: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 mask: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 per_flow_request_access_policy: Optional[pulumi.Input[builtins.str]] = None,
                 persistence_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 pool: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 security_log_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 server_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 snatpool: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 source_address_translation: Optional[pulumi.Input[builtins.str]] = None,
                 source_port: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 trafficmatching_criteria: Optional[pulumi.Input[builtins.str]] = None,
                 translate_address: Optional[pulumi.Input[builtins.str]] = None,
                 translate_port: Optional[pulumi.Input[builtins.str]] = None,
                 vlans: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 vlans_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualServerArgs.__new__(VirtualServerArgs)

            __props__.__dict__["client_profiles"] = client_profiles
            __props__.__dict__["connection_limit"] = connection_limit
            __props__.__dict__["default_persistence_profile"] = default_persistence_profile
            __props__.__dict__["description"] = description
            __props__.__dict__["destination"] = destination
            __props__.__dict__["fallback_persistence_profile"] = fallback_persistence_profile
            __props__.__dict__["firewall_enforced_policy"] = firewall_enforced_policy
            __props__.__dict__["ip_protocol"] = ip_protocol
            __props__.__dict__["irules"] = irules
            __props__.__dict__["mask"] = mask
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["per_flow_request_access_policy"] = per_flow_request_access_policy
            __props__.__dict__["persistence_profiles"] = persistence_profiles
            __props__.__dict__["policies"] = policies
            __props__.__dict__["pool"] = pool
            __props__.__dict__["port"] = port
            __props__.__dict__["profiles"] = profiles
            __props__.__dict__["security_log_profiles"] = security_log_profiles
            __props__.__dict__["server_profiles"] = server_profiles
            __props__.__dict__["snatpool"] = snatpool
            __props__.__dict__["source"] = source
            __props__.__dict__["source_address_translation"] = source_address_translation
            __props__.__dict__["source_port"] = source_port
            __props__.__dict__["state"] = state
            __props__.__dict__["trafficmatching_criteria"] = trafficmatching_criteria
            __props__.__dict__["translate_address"] = translate_address
            __props__.__dict__["translate_port"] = translate_port
            __props__.__dict__["vlans"] = vlans
            __props__.__dict__["vlans_enabled"] = vlans_enabled
        super(VirtualServer, __self__).__init__(
            'f5bigip:ltm/virtualServer:VirtualServer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            connection_limit: Optional[pulumi.Input[builtins.int]] = None,
            default_persistence_profile: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            destination: Optional[pulumi.Input[builtins.str]] = None,
            fallback_persistence_profile: Optional[pulumi.Input[builtins.str]] = None,
            firewall_enforced_policy: Optional[pulumi.Input[builtins.str]] = None,
            ip_protocol: Optional[pulumi.Input[builtins.str]] = None,
            irules: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            mask: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            per_flow_request_access_policy: Optional[pulumi.Input[builtins.str]] = None,
            persistence_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            policies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            pool: Optional[pulumi.Input[builtins.str]] = None,
            port: Optional[pulumi.Input[builtins.int]] = None,
            profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            security_log_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            server_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            snatpool: Optional[pulumi.Input[builtins.str]] = None,
            source: Optional[pulumi.Input[builtins.str]] = None,
            source_address_translation: Optional[pulumi.Input[builtins.str]] = None,
            source_port: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            trafficmatching_criteria: Optional[pulumi.Input[builtins.str]] = None,
            translate_address: Optional[pulumi.Input[builtins.str]] = None,
            translate_port: Optional[pulumi.Input[builtins.str]] = None,
            vlans: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            vlans_enabled: Optional[pulumi.Input[builtins.bool]] = None) -> 'VirtualServer':
        """
        Get an existing VirtualServer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] client_profiles: List of client context profiles associated on the virtual server. Not mutually exclusive with profiles and server_profiles
        :param pulumi.Input[builtins.int] connection_limit: Specifies the maximum number of connections allowed for the virtual server.
        :param pulumi.Input[builtins.str] description: Description of Virtual server
        :param pulumi.Input[builtins.str] destination: Destination IP
        :param pulumi.Input[builtins.str] fallback_persistence_profile: Specifies a fallback persistence profile for the Virtual Server to use when the default persistence profile is not available.
        :param pulumi.Input[builtins.str] firewall_enforced_policy: Applies the specified AFM policy to the virtual in an enforcing way,when creating a new virtual, if this parameter is not specified, the enforced is disabled.This should be in full path ex: `/Common/afm-test-policy`.
        :param pulumi.Input[builtins.str] ip_protocol: Specifies a network protocol name you want the system to use to direct traffic on this virtual server. The default is `tcp`. valid options are [`any`,`udp`,`tcp`]
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] irules: The iRules list you want run on this virtual server. iRules help automate the intercepting, processing, and routing of application traffic.
        :param pulumi.Input[builtins.str] mask: Mask can either be in CIDR notation or decimal, i.e.: 24 or 255.255.255.0. A CIDR mask of 0 is the same as 0.0.0.0
        :param pulumi.Input[builtins.str] name: Name of the virtual server
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] persistence_profiles: List of persistence profiles associated with the Virtual Server.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] policies: Specifies the policies for the virtual server.
        :param pulumi.Input[builtins.str] pool: Default pool name
        :param pulumi.Input[builtins.int] port: Listen port for the virtual server
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] profiles: List of profiles associated both client and server contexts on the virtual server. This includes protocol, ssl, http, etc.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_log_profiles: Specifies the log profile applied to the virtual server.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] server_profiles: List of server context profiles associated on the virtual server. Not mutually exclusive with profiles and client_profiles
        :param pulumi.Input[builtins.str] snatpool: Specifies the name of an existing SNAT pool that you want the virtual server to use to implement selective and intelligent SNATs.
        :param pulumi.Input[builtins.str] source: Specifies an IP address or network from which the virtual server will accept traffic.
        :param pulumi.Input[builtins.str] source_address_translation: Can be either omitted for `none` or the values `automap` options : [`snat`,`automap`,`none`].
        :param pulumi.Input[builtins.str] source_port: Specifies whether the system preserves the source port of the connection. The default is `preserve`.
        :param pulumi.Input[builtins.str] state: Specifies whether the virtual server and its resources are available for load balancing. The default is Enabled
        :param pulumi.Input[builtins.str] trafficmatching_criteria: Specifies destination traffic matching information to which the virtual server sends traffic
        :param pulumi.Input[builtins.str] translate_address: Enables or disables address translation for the virtual server. Turn address translation off for a virtual server if you want to use the virtual server to load balance connections to any address. This option is useful when the system is load balancing devices that have the same IP address.
        :param pulumi.Input[builtins.str] translate_port: Enables or disables port translation. Turn port translation off for a virtual server if you want to use the virtual server to load balance connections to any service
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vlans: The virtual server is enabled/disabled on this set of VLANs,enable/disabled will be desided by attribute `vlan_enabled`
        :param pulumi.Input[builtins.bool] vlans_enabled: Enables the virtual server on the VLANs specified by the `vlans` option.
               By default it is `false` i.e vlanDisabled on specified vlans, if we want enable virtual server on VLANs specified by `vlans`, mark this attribute to `true`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualServerState.__new__(_VirtualServerState)

        __props__.__dict__["client_profiles"] = client_profiles
        __props__.__dict__["connection_limit"] = connection_limit
        __props__.__dict__["default_persistence_profile"] = default_persistence_profile
        __props__.__dict__["description"] = description
        __props__.__dict__["destination"] = destination
        __props__.__dict__["fallback_persistence_profile"] = fallback_persistence_profile
        __props__.__dict__["firewall_enforced_policy"] = firewall_enforced_policy
        __props__.__dict__["ip_protocol"] = ip_protocol
        __props__.__dict__["irules"] = irules
        __props__.__dict__["mask"] = mask
        __props__.__dict__["name"] = name
        __props__.__dict__["per_flow_request_access_policy"] = per_flow_request_access_policy
        __props__.__dict__["persistence_profiles"] = persistence_profiles
        __props__.__dict__["policies"] = policies
        __props__.__dict__["pool"] = pool
        __props__.__dict__["port"] = port
        __props__.__dict__["profiles"] = profiles
        __props__.__dict__["security_log_profiles"] = security_log_profiles
        __props__.__dict__["server_profiles"] = server_profiles
        __props__.__dict__["snatpool"] = snatpool
        __props__.__dict__["source"] = source
        __props__.__dict__["source_address_translation"] = source_address_translation
        __props__.__dict__["source_port"] = source_port
        __props__.__dict__["state"] = state
        __props__.__dict__["trafficmatching_criteria"] = trafficmatching_criteria
        __props__.__dict__["translate_address"] = translate_address
        __props__.__dict__["translate_port"] = translate_port
        __props__.__dict__["vlans"] = vlans
        __props__.__dict__["vlans_enabled"] = vlans_enabled
        return VirtualServer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clientProfiles")
    def client_profiles(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of client context profiles associated on the virtual server. Not mutually exclusive with profiles and server_profiles
        """
        return pulumi.get(self, "client_profiles")

    @property
    @pulumi.getter(name="connectionLimit")
    def connection_limit(self) -> pulumi.Output[builtins.int]:
        """
        Specifies the maximum number of connections allowed for the virtual server.
        """
        return pulumi.get(self, "connection_limit")

    @property
    @pulumi.getter(name="defaultPersistenceProfile")
    def default_persistence_profile(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "default_persistence_profile")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of Virtual server
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Destination IP
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="fallbackPersistenceProfile")
    def fallback_persistence_profile(self) -> pulumi.Output[builtins.str]:
        """
        Specifies a fallback persistence profile for the Virtual Server to use when the default persistence profile is not available.
        """
        return pulumi.get(self, "fallback_persistence_profile")

    @property
    @pulumi.getter(name="firewallEnforcedPolicy")
    def firewall_enforced_policy(self) -> pulumi.Output[builtins.str]:
        """
        Applies the specified AFM policy to the virtual in an enforcing way,when creating a new virtual, if this parameter is not specified, the enforced is disabled.This should be in full path ex: `/Common/afm-test-policy`.
        """
        return pulumi.get(self, "firewall_enforced_policy")

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies a network protocol name you want the system to use to direct traffic on this virtual server. The default is `tcp`. valid options are [`any`,`udp`,`tcp`]
        """
        return pulumi.get(self, "ip_protocol")

    @property
    @pulumi.getter
    def irules(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The iRules list you want run on this virtual server. iRules help automate the intercepting, processing, and routing of application traffic.
        """
        return pulumi.get(self, "irules")

    @property
    @pulumi.getter
    def mask(self) -> pulumi.Output[builtins.str]:
        """
        Mask can either be in CIDR notation or decimal, i.e.: 24 or 255.255.255.0. A CIDR mask of 0 is the same as 0.0.0.0
        """
        return pulumi.get(self, "mask")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the virtual server
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="perFlowRequestAccessPolicy")
    def per_flow_request_access_policy(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "per_flow_request_access_policy")

    @property
    @pulumi.getter(name="persistenceProfiles")
    def persistence_profiles(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of persistence profiles associated with the Virtual Server.
        """
        return pulumi.get(self, "persistence_profiles")

    @property
    @pulumi.getter
    def policies(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Specifies the policies for the virtual server.
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter
    def pool(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Default pool name
        """
        return pulumi.get(self, "pool")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[builtins.int]:
        """
        Listen port for the virtual server
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def profiles(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of profiles associated both client and server contexts on the virtual server. This includes protocol, ssl, http, etc.
        """
        return pulumi.get(self, "profiles")

    @property
    @pulumi.getter(name="securityLogProfiles")
    def security_log_profiles(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Specifies the log profile applied to the virtual server.
        """
        return pulumi.get(self, "security_log_profiles")

    @property
    @pulumi.getter(name="serverProfiles")
    def server_profiles(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of server context profiles associated on the virtual server. Not mutually exclusive with profiles and client_profiles
        """
        return pulumi.get(self, "server_profiles")

    @property
    @pulumi.getter
    def snatpool(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of an existing SNAT pool that you want the virtual server to use to implement selective and intelligent SNATs.
        """
        return pulumi.get(self, "snatpool")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[builtins.str]:
        """
        Specifies an IP address or network from which the virtual server will accept traffic.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="sourceAddressTranslation")
    def source_address_translation(self) -> pulumi.Output[builtins.str]:
        """
        Can be either omitted for `none` or the values `automap` options : [`snat`,`automap`,`none`].
        """
        return pulumi.get(self, "source_address_translation")

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> pulumi.Output[builtins.str]:
        """
        Specifies whether the system preserves the source port of the connection. The default is `preserve`.
        """
        return pulumi.get(self, "source_port")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies whether the virtual server and its resources are available for load balancing. The default is Enabled
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="trafficmatchingCriteria")
    def trafficmatching_criteria(self) -> pulumi.Output[builtins.str]:
        """
        Specifies destination traffic matching information to which the virtual server sends traffic
        """
        return pulumi.get(self, "trafficmatching_criteria")

    @property
    @pulumi.getter(name="translateAddress")
    def translate_address(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Enables or disables address translation for the virtual server. Turn address translation off for a virtual server if you want to use the virtual server to load balance connections to any address. This option is useful when the system is load balancing devices that have the same IP address.
        """
        return pulumi.get(self, "translate_address")

    @property
    @pulumi.getter(name="translatePort")
    def translate_port(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Enables or disables port translation. Turn port translation off for a virtual server if you want to use the virtual server to load balance connections to any service
        """
        return pulumi.get(self, "translate_port")

    @property
    @pulumi.getter
    def vlans(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The virtual server is enabled/disabled on this set of VLANs,enable/disabled will be desided by attribute `vlan_enabled`
        """
        return pulumi.get(self, "vlans")

    @property
    @pulumi.getter(name="vlansEnabled")
    def vlans_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enables the virtual server on the VLANs specified by the `vlans` option.
        By default it is `false` i.e vlanDisabled on specified vlans, if we want enable virtual server on VLANs specified by `vlans`, mark this attribute to `true`.
        """
        return pulumi.get(self, "vlans_enabled")

