# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RouteArgs', 'Route']

@pulumi.input_type
class RouteArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 network: pulumi.Input[builtins.str],
                 gw: Optional[pulumi.Input[builtins.str]] = None,
                 reject: Optional[pulumi.Input[builtins.bool]] = None,
                 tunnel_ref: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Route resource.
        :param pulumi.Input[builtins.str] name: Name of the route.Name of Route should be full path,full path is the combination of the `partition + route name`,For ex: `/Common/test-net-route`.
        :param pulumi.Input[builtins.str] network: The destination subnet and netmask for the route.
        :param pulumi.Input[builtins.str] gw: Specifies a gateway address for the route.
        :param pulumi.Input[builtins.bool] reject: reject route
        :param pulumi.Input[builtins.str] tunnel_ref: tunnel_ref to route traffic
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network", network)
        if gw is not None:
            pulumi.set(__self__, "gw", gw)
        if reject is not None:
            pulumi.set(__self__, "reject", reject)
        if tunnel_ref is not None:
            pulumi.set(__self__, "tunnel_ref", tunnel_ref)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the route.Name of Route should be full path,full path is the combination of the `partition + route name`,For ex: `/Common/test-net-route`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> pulumi.Input[builtins.str]:
        """
        The destination subnet and netmask for the route.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def gw(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a gateway address for the route.
        """
        return pulumi.get(self, "gw")

    @gw.setter
    def gw(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gw", value)

    @property
    @pulumi.getter
    def reject(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        reject route
        """
        return pulumi.get(self, "reject")

    @reject.setter
    def reject(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reject", value)

    @property
    @pulumi.getter(name="tunnelRef")
    def tunnel_ref(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        tunnel_ref to route traffic
        """
        return pulumi.get(self, "tunnel_ref")

    @tunnel_ref.setter
    def tunnel_ref(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_ref", value)


@pulumi.input_type
class _RouteState:
    def __init__(__self__, *,
                 gw: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 reject: Optional[pulumi.Input[builtins.bool]] = None,
                 tunnel_ref: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Route resources.
        :param pulumi.Input[builtins.str] gw: Specifies a gateway address for the route.
        :param pulumi.Input[builtins.str] name: Name of the route.Name of Route should be full path,full path is the combination of the `partition + route name`,For ex: `/Common/test-net-route`.
        :param pulumi.Input[builtins.str] network: The destination subnet and netmask for the route.
        :param pulumi.Input[builtins.bool] reject: reject route
        :param pulumi.Input[builtins.str] tunnel_ref: tunnel_ref to route traffic
        """
        if gw is not None:
            pulumi.set(__self__, "gw", gw)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if reject is not None:
            pulumi.set(__self__, "reject", reject)
        if tunnel_ref is not None:
            pulumi.set(__self__, "tunnel_ref", tunnel_ref)

    @property
    @pulumi.getter
    def gw(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a gateway address for the route.
        """
        return pulumi.get(self, "gw")

    @gw.setter
    def gw(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gw", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the route.Name of Route should be full path,full path is the combination of the `partition + route name`,For ex: `/Common/test-net-route`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The destination subnet and netmask for the route.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def reject(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        reject route
        """
        return pulumi.get(self, "reject")

    @reject.setter
    def reject(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reject", value)

    @property
    @pulumi.getter(name="tunnelRef")
    def tunnel_ref(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        tunnel_ref to route traffic
        """
        return pulumi.get(self, "tunnel_ref")

    @tunnel_ref.setter
    def tunnel_ref(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_ref", value)


@pulumi.type_token("f5bigip:net/route:Route")
class Route(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gw: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 reject: Optional[pulumi.Input[builtins.bool]] = None,
                 tunnel_ref: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        `net.Route` Manages a route configuration

        For resources should be named with their "full path". The full path is the combination of the partition + name of the resource. For example /Common/my-pool.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        route2 = f5bigip.net.Route("route2",
            name="/Common/external-route",
            network="10.10.10.0/24",
            gw="1.1.1.2")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] gw: Specifies a gateway address for the route.
        :param pulumi.Input[builtins.str] name: Name of the route.Name of Route should be full path,full path is the combination of the `partition + route name`,For ex: `/Common/test-net-route`.
        :param pulumi.Input[builtins.str] network: The destination subnet and netmask for the route.
        :param pulumi.Input[builtins.bool] reject: reject route
        :param pulumi.Input[builtins.str] tunnel_ref: tunnel_ref to route traffic
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `net.Route` Manages a route configuration

        For resources should be named with their "full path". The full path is the combination of the partition + name of the resource. For example /Common/my-pool.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        route2 = f5bigip.net.Route("route2",
            name="/Common/external-route",
            network="10.10.10.0/24",
            gw="1.1.1.2")
        ```

        :param str resource_name: The name of the resource.
        :param RouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gw: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 reject: Optional[pulumi.Input[builtins.bool]] = None,
                 tunnel_ref: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteArgs.__new__(RouteArgs)

            __props__.__dict__["gw"] = gw
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            __props__.__dict__["reject"] = reject
            __props__.__dict__["tunnel_ref"] = tunnel_ref
        super(Route, __self__).__init__(
            'f5bigip:net/route:Route',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            gw: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network: Optional[pulumi.Input[builtins.str]] = None,
            reject: Optional[pulumi.Input[builtins.bool]] = None,
            tunnel_ref: Optional[pulumi.Input[builtins.str]] = None) -> 'Route':
        """
        Get an existing Route resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] gw: Specifies a gateway address for the route.
        :param pulumi.Input[builtins.str] name: Name of the route.Name of Route should be full path,full path is the combination of the `partition + route name`,For ex: `/Common/test-net-route`.
        :param pulumi.Input[builtins.str] network: The destination subnet and netmask for the route.
        :param pulumi.Input[builtins.bool] reject: reject route
        :param pulumi.Input[builtins.str] tunnel_ref: tunnel_ref to route traffic
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouteState.__new__(_RouteState)

        __props__.__dict__["gw"] = gw
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["reject"] = reject
        __props__.__dict__["tunnel_ref"] = tunnel_ref
        return Route(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def gw(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies a gateway address for the route.
        """
        return pulumi.get(self, "gw")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the route.Name of Route should be full path,full path is the combination of the `partition + route name`,For ex: `/Common/test-net-route`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[builtins.str]:
        """
        The destination subnet and netmask for the route.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def reject(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        reject route
        """
        return pulumi.get(self, "reject")

    @property
    @pulumi.getter(name="tunnelRef")
    def tunnel_ref(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        tunnel_ref to route traffic
        """
        return pulumi.get(self, "tunnel_ref")

