# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 api_retries: Optional[pulumi.Input[builtins.int]] = None,
                 api_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 login_ref: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.str]] = None,
                 teem_disable: Optional[pulumi.Input[builtins.bool]] = None,
                 token_auth: Optional[pulumi.Input[builtins.bool]] = None,
                 token_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 token_value: Optional[pulumi.Input[builtins.str]] = None,
                 trusted_cert_path: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 validate_certs_disable: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[builtins.str] address: Domain name/IP of the BigIP
        :param pulumi.Input[builtins.int] api_retries: Amount of times to retry AS3 API requests. Default: 10.
        :param pulumi.Input[builtins.int] api_timeout: A timeout for AS3 requests, represented as a number of seconds. Default: 60
        :param pulumi.Input[builtins.str] login_ref: Login reference for token authentication (see BIG-IP REST docs for details)
        :param pulumi.Input[builtins.str] password: The user's password. Leave empty if using token_value
        :param pulumi.Input[builtins.str] port: Management Port to connect to Bigip
        :param pulumi.Input[builtins.bool] teem_disable: If this flag set to true,sending telemetry data to TEEM will be disabled
        :param pulumi.Input[builtins.bool] token_auth: Enable to use token authentication. Can be set via the BIGIP_TOKEN_AUTH environment variable
        :param pulumi.Input[builtins.int] token_timeout: A lifespan to request for the AS3 auth token, represented as a number of seconds. Default: 1200
        :param pulumi.Input[builtins.str] token_value: A token generated outside the provider, in place of password
        :param pulumi.Input[builtins.str] trusted_cert_path: Valid Trusted Certificate path
        :param pulumi.Input[builtins.str] username: Username with API access to the BigIP
        :param pulumi.Input[builtins.bool] validate_certs_disable: If set to true, Disables TLS certificate check on BIG-IP. Default : True
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if api_retries is not None:
            pulumi.set(__self__, "api_retries", api_retries)
        if api_timeout is not None:
            pulumi.set(__self__, "api_timeout", api_timeout)
        if login_ref is not None:
            pulumi.set(__self__, "login_ref", login_ref)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if teem_disable is not None:
            pulumi.set(__self__, "teem_disable", teem_disable)
        if token_auth is not None:
            pulumi.set(__self__, "token_auth", token_auth)
        if token_timeout is not None:
            pulumi.set(__self__, "token_timeout", token_timeout)
        if token_value is not None:
            pulumi.set(__self__, "token_value", token_value)
        if trusted_cert_path is not None:
            pulumi.set(__self__, "trusted_cert_path", trusted_cert_path)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if validate_certs_disable is not None:
            pulumi.set(__self__, "validate_certs_disable", validate_certs_disable)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Domain name/IP of the BigIP
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="apiRetries")
    def api_retries(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Amount of times to retry AS3 API requests. Default: 10.
        """
        return pulumi.get(self, "api_retries")

    @api_retries.setter
    def api_retries(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "api_retries", value)

    @property
    @pulumi.getter(name="apiTimeout")
    def api_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        A timeout for AS3 requests, represented as a number of seconds. Default: 60
        """
        return pulumi.get(self, "api_timeout")

    @api_timeout.setter
    def api_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "api_timeout", value)

    @property
    @pulumi.getter(name="loginRef")
    def login_ref(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Login reference for token authentication (see BIG-IP REST docs for details)
        """
        return pulumi.get(self, "login_ref")

    @login_ref.setter
    def login_ref(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "login_ref", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user's password. Leave empty if using token_value
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Management Port to connect to Bigip
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="teemDisable")
    def teem_disable(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If this flag set to true,sending telemetry data to TEEM will be disabled
        """
        return pulumi.get(self, "teem_disable")

    @teem_disable.setter
    def teem_disable(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "teem_disable", value)

    @property
    @pulumi.getter(name="tokenAuth")
    def token_auth(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable to use token authentication. Can be set via the BIGIP_TOKEN_AUTH environment variable
        """
        return pulumi.get(self, "token_auth")

    @token_auth.setter
    def token_auth(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "token_auth", value)

    @property
    @pulumi.getter(name="tokenTimeout")
    def token_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        A lifespan to request for the AS3 auth token, represented as a number of seconds. Default: 1200
        """
        return pulumi.get(self, "token_timeout")

    @token_timeout.setter
    def token_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "token_timeout", value)

    @property
    @pulumi.getter(name="tokenValue")
    def token_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A token generated outside the provider, in place of password
        """
        return pulumi.get(self, "token_value")

    @token_value.setter
    def token_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "token_value", value)

    @property
    @pulumi.getter(name="trustedCertPath")
    def trusted_cert_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Valid Trusted Certificate path
        """
        return pulumi.get(self, "trusted_cert_path")

    @trusted_cert_path.setter
    def trusted_cert_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trusted_cert_path", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Username with API access to the BigIP
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="validateCertsDisable")
    def validate_certs_disable(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to true, Disables TLS certificate check on BIG-IP. Default : True
        """
        return pulumi.get(self, "validate_certs_disable")

    @validate_certs_disable.setter
    def validate_certs_disable(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "validate_certs_disable", value)


@pulumi.type_token("pulumi:providers:f5bigip")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 api_retries: Optional[pulumi.Input[builtins.int]] = None,
                 api_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 login_ref: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.str]] = None,
                 teem_disable: Optional[pulumi.Input[builtins.bool]] = None,
                 token_auth: Optional[pulumi.Input[builtins.bool]] = None,
                 token_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 token_value: Optional[pulumi.Input[builtins.str]] = None,
                 trusted_cert_path: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 validate_certs_disable: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        The provider type for the bigip package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] address: Domain name/IP of the BigIP
        :param pulumi.Input[builtins.int] api_retries: Amount of times to retry AS3 API requests. Default: 10.
        :param pulumi.Input[builtins.int] api_timeout: A timeout for AS3 requests, represented as a number of seconds. Default: 60
        :param pulumi.Input[builtins.str] login_ref: Login reference for token authentication (see BIG-IP REST docs for details)
        :param pulumi.Input[builtins.str] password: The user's password. Leave empty if using token_value
        :param pulumi.Input[builtins.str] port: Management Port to connect to Bigip
        :param pulumi.Input[builtins.bool] teem_disable: If this flag set to true,sending telemetry data to TEEM will be disabled
        :param pulumi.Input[builtins.bool] token_auth: Enable to use token authentication. Can be set via the BIGIP_TOKEN_AUTH environment variable
        :param pulumi.Input[builtins.int] token_timeout: A lifespan to request for the AS3 auth token, represented as a number of seconds. Default: 1200
        :param pulumi.Input[builtins.str] token_value: A token generated outside the provider, in place of password
        :param pulumi.Input[builtins.str] trusted_cert_path: Valid Trusted Certificate path
        :param pulumi.Input[builtins.str] username: Username with API access to the BigIP
        :param pulumi.Input[builtins.bool] validate_certs_disable: If set to true, Disables TLS certificate check on BIG-IP. Default : True
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the bigip package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 api_retries: Optional[pulumi.Input[builtins.int]] = None,
                 api_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 login_ref: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.str]] = None,
                 teem_disable: Optional[pulumi.Input[builtins.bool]] = None,
                 token_auth: Optional[pulumi.Input[builtins.bool]] = None,
                 token_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 token_value: Optional[pulumi.Input[builtins.str]] = None,
                 trusted_cert_path: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 validate_certs_disable: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["address"] = address
            __props__.__dict__["api_retries"] = pulumi.Output.from_input(api_retries).apply(pulumi.runtime.to_json) if api_retries is not None else None
            __props__.__dict__["api_timeout"] = pulumi.Output.from_input(api_timeout).apply(pulumi.runtime.to_json) if api_timeout is not None else None
            __props__.__dict__["login_ref"] = login_ref
            __props__.__dict__["password"] = password
            __props__.__dict__["port"] = port
            __props__.__dict__["teem_disable"] = pulumi.Output.from_input(teem_disable).apply(pulumi.runtime.to_json) if teem_disable is not None else None
            __props__.__dict__["token_auth"] = pulumi.Output.from_input(token_auth).apply(pulumi.runtime.to_json) if token_auth is not None else None
            __props__.__dict__["token_timeout"] = pulumi.Output.from_input(token_timeout).apply(pulumi.runtime.to_json) if token_timeout is not None else None
            __props__.__dict__["token_value"] = token_value
            __props__.__dict__["trusted_cert_path"] = trusted_cert_path
            __props__.__dict__["username"] = username
            __props__.__dict__["validate_certs_disable"] = pulumi.Output.from_input(validate_certs_disable).apply(pulumi.runtime.to_json) if validate_certs_disable is not None else None
        super(Provider, __self__).__init__(
            'f5bigip',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Domain name/IP of the BigIP
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="loginRef")
    def login_ref(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Login reference for token authentication (see BIG-IP REST docs for details)
        """
        return pulumi.get(self, "login_ref")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The user's password. Leave empty if using token_value
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Management Port to connect to Bigip
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="tokenValue")
    def token_value(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A token generated outside the provider, in place of password
        """
        return pulumi.get(self, "token_value")

    @property
    @pulumi.getter(name="trustedCertPath")
    def trusted_cert_path(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Valid Trusted Certificate path
        """
        return pulumi.get(self, "trusted_cert_path")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Username with API access to the BigIP
        """
        return pulumi.get(self, "username")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:f5bigip/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

