# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SaasBotDefenseProfileArgs', 'SaasBotDefenseProfile']

@pulumi.input_type
class SaasBotDefenseProfileArgs:
    def __init__(__self__, *,
                 api_key: pulumi.Input[builtins.str],
                 application_id: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 protected_endpoints: pulumi.Input[Sequence[pulumi.Input['SaasBotDefenseProfileProtectedEndpointArgs']]],
                 shape_protection_pool: pulumi.Input[builtins.str],
                 ssl_profile: pulumi.Input[builtins.str],
                 tenant_id: pulumi.Input[builtins.str],
                 defaults_from: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a SaasBotDefenseProfile resource.
        :param pulumi.Input[builtins.str] api_key: Specifies the API key, enter the value provided by F5 Support.
        :param pulumi.Input[builtins.str] application_id: Specifies the Bot Defense API application ID, enter the value provided by F5 Support
        :param pulumi.Input[builtins.str] name: Unique name for the Distributed Cloud Services Bot Defense profile
        :param pulumi.Input[Sequence[pulumi.Input['SaasBotDefenseProfileProtectedEndpointArgs']]] protected_endpoints: Use these settings to configure which pages on the website will be protected by BD
        :param pulumi.Input[builtins.str] shape_protection_pool: Specifies the web hostname to which API requests are made
        :param pulumi.Input[builtins.str] ssl_profile: Specifies a server-side SSL profile that is different from what the application pool uses
        :param pulumi.Input[builtins.str] tenant_id: Specifies the tenant ID, enter the value provided by F5 Support
        :param pulumi.Input[builtins.str] defaults_from: Distributed Cloud Services Bot Defense parent profile from which this profile will inherit settings.
        :param pulumi.Input[builtins.str] description: Specifies descriptive text that identifies the BD profile.
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protected_endpoints", protected_endpoints)
        pulumi.set(__self__, "shape_protection_pool", shape_protection_pool)
        pulumi.set(__self__, "ssl_profile", ssl_profile)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if defaults_from is not None:
            pulumi.set(__self__, "defaults_from", defaults_from)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the API key, enter the value provided by F5 Support.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the Bot Defense API application ID, enter the value provided by F5 Support
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Unique name for the Distributed Cloud Services Bot Defense profile
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="protectedEndpoints")
    def protected_endpoints(self) -> pulumi.Input[Sequence[pulumi.Input['SaasBotDefenseProfileProtectedEndpointArgs']]]:
        """
        Use these settings to configure which pages on the website will be protected by BD
        """
        return pulumi.get(self, "protected_endpoints")

    @protected_endpoints.setter
    def protected_endpoints(self, value: pulumi.Input[Sequence[pulumi.Input['SaasBotDefenseProfileProtectedEndpointArgs']]]):
        pulumi.set(self, "protected_endpoints", value)

    @property
    @pulumi.getter(name="shapeProtectionPool")
    def shape_protection_pool(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the web hostname to which API requests are made
        """
        return pulumi.get(self, "shape_protection_pool")

    @shape_protection_pool.setter
    def shape_protection_pool(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "shape_protection_pool", value)

    @property
    @pulumi.getter(name="sslProfile")
    def ssl_profile(self) -> pulumi.Input[builtins.str]:
        """
        Specifies a server-side SSL profile that is different from what the application pool uses
        """
        return pulumi.get(self, "ssl_profile")

    @ssl_profile.setter
    def ssl_profile(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ssl_profile", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the tenant ID, enter the value provided by F5 Support
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Distributed Cloud Services Bot Defense parent profile from which this profile will inherit settings.
        """
        return pulumi.get(self, "defaults_from")

    @defaults_from.setter
    def defaults_from(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "defaults_from", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies descriptive text that identifies the BD profile.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _SaasBotDefenseProfileState:
    def __init__(__self__, *,
                 api_key: Optional[pulumi.Input[builtins.str]] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 protected_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['SaasBotDefenseProfileProtectedEndpointArgs']]]] = None,
                 shape_protection_pool: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_profile: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SaasBotDefenseProfile resources.
        :param pulumi.Input[builtins.str] api_key: Specifies the API key, enter the value provided by F5 Support.
        :param pulumi.Input[builtins.str] application_id: Specifies the Bot Defense API application ID, enter the value provided by F5 Support
        :param pulumi.Input[builtins.str] defaults_from: Distributed Cloud Services Bot Defense parent profile from which this profile will inherit settings.
        :param pulumi.Input[builtins.str] description: Specifies descriptive text that identifies the BD profile.
        :param pulumi.Input[builtins.str] name: Unique name for the Distributed Cloud Services Bot Defense profile
        :param pulumi.Input[Sequence[pulumi.Input['SaasBotDefenseProfileProtectedEndpointArgs']]] protected_endpoints: Use these settings to configure which pages on the website will be protected by BD
        :param pulumi.Input[builtins.str] shape_protection_pool: Specifies the web hostname to which API requests are made
        :param pulumi.Input[builtins.str] ssl_profile: Specifies a server-side SSL profile that is different from what the application pool uses
        :param pulumi.Input[builtins.str] tenant_id: Specifies the tenant ID, enter the value provided by F5 Support
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if defaults_from is not None:
            pulumi.set(__self__, "defaults_from", defaults_from)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protected_endpoints is not None:
            pulumi.set(__self__, "protected_endpoints", protected_endpoints)
        if shape_protection_pool is not None:
            pulumi.set(__self__, "shape_protection_pool", shape_protection_pool)
        if ssl_profile is not None:
            pulumi.set(__self__, "ssl_profile", ssl_profile)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the API key, enter the value provided by F5 Support.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Bot Defense API application ID, enter the value provided by F5 Support
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Distributed Cloud Services Bot Defense parent profile from which this profile will inherit settings.
        """
        return pulumi.get(self, "defaults_from")

    @defaults_from.setter
    def defaults_from(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "defaults_from", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies descriptive text that identifies the BD profile.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique name for the Distributed Cloud Services Bot Defense profile
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="protectedEndpoints")
    def protected_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SaasBotDefenseProfileProtectedEndpointArgs']]]]:
        """
        Use these settings to configure which pages on the website will be protected by BD
        """
        return pulumi.get(self, "protected_endpoints")

    @protected_endpoints.setter
    def protected_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SaasBotDefenseProfileProtectedEndpointArgs']]]]):
        pulumi.set(self, "protected_endpoints", value)

    @property
    @pulumi.getter(name="shapeProtectionPool")
    def shape_protection_pool(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the web hostname to which API requests are made
        """
        return pulumi.get(self, "shape_protection_pool")

    @shape_protection_pool.setter
    def shape_protection_pool(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shape_protection_pool", value)

    @property
    @pulumi.getter(name="sslProfile")
    def ssl_profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a server-side SSL profile that is different from what the application pool uses
        """
        return pulumi.get(self, "ssl_profile")

    @ssl_profile.setter
    def ssl_profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_profile", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the tenant ID, enter the value provided by F5 Support
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.type_token("f5bigip:index/saasBotDefenseProfile:SaasBotDefenseProfile")
class SaasBotDefenseProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[builtins.str]] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 protected_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SaasBotDefenseProfileProtectedEndpointArgs', 'SaasBotDefenseProfileProtectedEndpointArgsDict']]]]] = None,
                 shape_protection_pool: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_profile: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a SaasBotDefenseProfile resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_key: Specifies the API key, enter the value provided by F5 Support.
        :param pulumi.Input[builtins.str] application_id: Specifies the Bot Defense API application ID, enter the value provided by F5 Support
        :param pulumi.Input[builtins.str] defaults_from: Distributed Cloud Services Bot Defense parent profile from which this profile will inherit settings.
        :param pulumi.Input[builtins.str] description: Specifies descriptive text that identifies the BD profile.
        :param pulumi.Input[builtins.str] name: Unique name for the Distributed Cloud Services Bot Defense profile
        :param pulumi.Input[Sequence[pulumi.Input[Union['SaasBotDefenseProfileProtectedEndpointArgs', 'SaasBotDefenseProfileProtectedEndpointArgsDict']]]] protected_endpoints: Use these settings to configure which pages on the website will be protected by BD
        :param pulumi.Input[builtins.str] shape_protection_pool: Specifies the web hostname to which API requests are made
        :param pulumi.Input[builtins.str] ssl_profile: Specifies a server-side SSL profile that is different from what the application pool uses
        :param pulumi.Input[builtins.str] tenant_id: Specifies the tenant ID, enter the value provided by F5 Support
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SaasBotDefenseProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a SaasBotDefenseProfile resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param SaasBotDefenseProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SaasBotDefenseProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[builtins.str]] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 protected_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SaasBotDefenseProfileProtectedEndpointArgs', 'SaasBotDefenseProfileProtectedEndpointArgsDict']]]]] = None,
                 shape_protection_pool: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_profile: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SaasBotDefenseProfileArgs.__new__(SaasBotDefenseProfileArgs)

            if api_key is None and not opts.urn:
                raise TypeError("Missing required property 'api_key'")
            __props__.__dict__["api_key"] = None if api_key is None else pulumi.Output.secret(api_key)
            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = None if application_id is None else pulumi.Output.secret(application_id)
            __props__.__dict__["defaults_from"] = defaults_from
            __props__.__dict__["description"] = description
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if protected_endpoints is None and not opts.urn:
                raise TypeError("Missing required property 'protected_endpoints'")
            __props__.__dict__["protected_endpoints"] = protected_endpoints
            if shape_protection_pool is None and not opts.urn:
                raise TypeError("Missing required property 'shape_protection_pool'")
            __props__.__dict__["shape_protection_pool"] = shape_protection_pool
            if ssl_profile is None and not opts.urn:
                raise TypeError("Missing required property 'ssl_profile'")
            __props__.__dict__["ssl_profile"] = ssl_profile
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apiKey", "applicationId"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SaasBotDefenseProfile, __self__).__init__(
            'f5bigip:index/saasBotDefenseProfile:SaasBotDefenseProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_key: Optional[pulumi.Input[builtins.str]] = None,
            application_id: Optional[pulumi.Input[builtins.str]] = None,
            defaults_from: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            protected_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SaasBotDefenseProfileProtectedEndpointArgs', 'SaasBotDefenseProfileProtectedEndpointArgsDict']]]]] = None,
            shape_protection_pool: Optional[pulumi.Input[builtins.str]] = None,
            ssl_profile: Optional[pulumi.Input[builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[builtins.str]] = None) -> 'SaasBotDefenseProfile':
        """
        Get an existing SaasBotDefenseProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_key: Specifies the API key, enter the value provided by F5 Support.
        :param pulumi.Input[builtins.str] application_id: Specifies the Bot Defense API application ID, enter the value provided by F5 Support
        :param pulumi.Input[builtins.str] defaults_from: Distributed Cloud Services Bot Defense parent profile from which this profile will inherit settings.
        :param pulumi.Input[builtins.str] description: Specifies descriptive text that identifies the BD profile.
        :param pulumi.Input[builtins.str] name: Unique name for the Distributed Cloud Services Bot Defense profile
        :param pulumi.Input[Sequence[pulumi.Input[Union['SaasBotDefenseProfileProtectedEndpointArgs', 'SaasBotDefenseProfileProtectedEndpointArgsDict']]]] protected_endpoints: Use these settings to configure which pages on the website will be protected by BD
        :param pulumi.Input[builtins.str] shape_protection_pool: Specifies the web hostname to which API requests are made
        :param pulumi.Input[builtins.str] ssl_profile: Specifies a server-side SSL profile that is different from what the application pool uses
        :param pulumi.Input[builtins.str] tenant_id: Specifies the tenant ID, enter the value provided by F5 Support
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SaasBotDefenseProfileState.__new__(_SaasBotDefenseProfileState)

        __props__.__dict__["api_key"] = api_key
        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["defaults_from"] = defaults_from
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["protected_endpoints"] = protected_endpoints
        __props__.__dict__["shape_protection_pool"] = shape_protection_pool
        __props__.__dict__["ssl_profile"] = ssl_profile
        __props__.__dict__["tenant_id"] = tenant_id
        return SaasBotDefenseProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the API key, enter the value provided by F5 Support.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Bot Defense API application ID, enter the value provided by F5 Support
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Distributed Cloud Services Bot Defense parent profile from which this profile will inherit settings.
        """
        return pulumi.get(self, "defaults_from")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Specifies descriptive text that identifies the BD profile.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Unique name for the Distributed Cloud Services Bot Defense profile
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="protectedEndpoints")
    def protected_endpoints(self) -> pulumi.Output[Sequence['outputs.SaasBotDefenseProfileProtectedEndpoint']]:
        """
        Use these settings to configure which pages on the website will be protected by BD
        """
        return pulumi.get(self, "protected_endpoints")

    @property
    @pulumi.getter(name="shapeProtectionPool")
    def shape_protection_pool(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the web hostname to which API requests are made
        """
        return pulumi.get(self, "shape_protection_pool")

    @property
    @pulumi.getter(name="sslProfile")
    def ssl_profile(self) -> pulumi.Output[builtins.str]:
        """
        Specifies a server-side SSL profile that is different from what the application pool uses
        """
        return pulumi.get(self, "ssl_profile")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the tenant ID, enter the value provided by F5 Support
        """
        return pulumi.get(self, "tenant_id")

