# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CertificateArgs', 'Certificate']

@pulumi.input_type
class CertificateArgs:
    def __init__(__self__, *,
                 content: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 full_path: Optional[pulumi.Input[builtins.str]] = None,
                 issuer_cert: Optional[pulumi.Input[builtins.str]] = None,
                 monitoring_type: Optional[pulumi.Input[builtins.str]] = None,
                 ocsp: Optional[pulumi.Input[builtins.str]] = None,
                 partition: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Certificate resource.
        :param pulumi.Input[builtins.str] content: Content of certificate on Disk
        :param pulumi.Input[builtins.str] name: Name of the SSL Certificate to be Imported on to BIGIP
        :param pulumi.Input[builtins.str] full_path: Full Path Name of ssl certificate
        :param pulumi.Input[builtins.str] issuer_cert: Specifies the issuer certificate.
        :param pulumi.Input[builtins.str] monitoring_type: Specifies the type of monitoring used.
        :param pulumi.Input[builtins.str] ocsp: Specifies the OCSP responder.
        :param pulumi.Input[builtins.str] partition: Partition of ssl certificate
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "name", name)
        if full_path is not None:
            pulumi.set(__self__, "full_path", full_path)
        if issuer_cert is not None:
            pulumi.set(__self__, "issuer_cert", issuer_cert)
        if monitoring_type is not None:
            pulumi.set(__self__, "monitoring_type", monitoring_type)
        if ocsp is not None:
            pulumi.set(__self__, "ocsp", ocsp)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Input[builtins.str]:
        """
        Content of certificate on Disk
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the SSL Certificate to be Imported on to BIGIP
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="fullPath")
    def full_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Full Path Name of ssl certificate
        """
        return pulumi.get(self, "full_path")

    @full_path.setter
    def full_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "full_path", value)

    @property
    @pulumi.getter(name="issuerCert")
    def issuer_cert(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the issuer certificate.
        """
        return pulumi.get(self, "issuer_cert")

    @issuer_cert.setter
    def issuer_cert(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "issuer_cert", value)

    @property
    @pulumi.getter(name="monitoringType")
    def monitoring_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the type of monitoring used.
        """
        return pulumi.get(self, "monitoring_type")

    @monitoring_type.setter
    def monitoring_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "monitoring_type", value)

    @property
    @pulumi.getter
    def ocsp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the OCSP responder.
        """
        return pulumi.get(self, "ocsp")

    @ocsp.setter
    def ocsp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ocsp", value)

    @property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Partition of ssl certificate
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "partition", value)


@pulumi.input_type
class _CertificateState:
    def __init__(__self__, *,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 full_path: Optional[pulumi.Input[builtins.str]] = None,
                 issuer_cert: Optional[pulumi.Input[builtins.str]] = None,
                 monitoring_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ocsp: Optional[pulumi.Input[builtins.str]] = None,
                 partition: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Certificate resources.
        :param pulumi.Input[builtins.str] content: Content of certificate on Disk
        :param pulumi.Input[builtins.str] full_path: Full Path Name of ssl certificate
        :param pulumi.Input[builtins.str] issuer_cert: Specifies the issuer certificate.
        :param pulumi.Input[builtins.str] monitoring_type: Specifies the type of monitoring used.
        :param pulumi.Input[builtins.str] name: Name of the SSL Certificate to be Imported on to BIGIP
        :param pulumi.Input[builtins.str] ocsp: Specifies the OCSP responder.
        :param pulumi.Input[builtins.str] partition: Partition of ssl certificate
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if full_path is not None:
            pulumi.set(__self__, "full_path", full_path)
        if issuer_cert is not None:
            pulumi.set(__self__, "issuer_cert", issuer_cert)
        if monitoring_type is not None:
            pulumi.set(__self__, "monitoring_type", monitoring_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ocsp is not None:
            pulumi.set(__self__, "ocsp", ocsp)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Content of certificate on Disk
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="fullPath")
    def full_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Full Path Name of ssl certificate
        """
        return pulumi.get(self, "full_path")

    @full_path.setter
    def full_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "full_path", value)

    @property
    @pulumi.getter(name="issuerCert")
    def issuer_cert(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the issuer certificate.
        """
        return pulumi.get(self, "issuer_cert")

    @issuer_cert.setter
    def issuer_cert(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "issuer_cert", value)

    @property
    @pulumi.getter(name="monitoringType")
    def monitoring_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the type of monitoring used.
        """
        return pulumi.get(self, "monitoring_type")

    @monitoring_type.setter
    def monitoring_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "monitoring_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the SSL Certificate to be Imported on to BIGIP
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def ocsp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the OCSP responder.
        """
        return pulumi.get(self, "ocsp")

    @ocsp.setter
    def ocsp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ocsp", value)

    @property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Partition of ssl certificate
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "partition", value)


@pulumi.type_token("f5bigip:ssl/certificate:Certificate")
class Certificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 full_path: Optional[pulumi.Input[builtins.str]] = None,
                 issuer_cert: Optional[pulumi.Input[builtins.str]] = None,
                 monitoring_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ocsp: Optional[pulumi.Input[builtins.str]] = None,
                 partition: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        `ssl.Certificate` This resource will import SSL certificates on BIG-IP LTM.
        Certificates can be imported from certificate files on the local disk, in PEM format

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip
        import pulumi_std as std

        test_cert = f5bigip.ssl.Certificate("test-cert",
            name="servercert.crt",
            content=std.file(input="servercert.crt").result,
            partition="Common")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] content: Content of certificate on Disk
        :param pulumi.Input[builtins.str] full_path: Full Path Name of ssl certificate
        :param pulumi.Input[builtins.str] issuer_cert: Specifies the issuer certificate.
        :param pulumi.Input[builtins.str] monitoring_type: Specifies the type of monitoring used.
        :param pulumi.Input[builtins.str] name: Name of the SSL Certificate to be Imported on to BIGIP
        :param pulumi.Input[builtins.str] ocsp: Specifies the OCSP responder.
        :param pulumi.Input[builtins.str] partition: Partition of ssl certificate
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `ssl.Certificate` This resource will import SSL certificates on BIG-IP LTM.
        Certificates can be imported from certificate files on the local disk, in PEM format

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip
        import pulumi_std as std

        test_cert = f5bigip.ssl.Certificate("test-cert",
            name="servercert.crt",
            content=std.file(input="servercert.crt").result,
            partition="Common")
        ```

        :param str resource_name: The name of the resource.
        :param CertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 full_path: Optional[pulumi.Input[builtins.str]] = None,
                 issuer_cert: Optional[pulumi.Input[builtins.str]] = None,
                 monitoring_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ocsp: Optional[pulumi.Input[builtins.str]] = None,
                 partition: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateArgs.__new__(CertificateArgs)

            if content is None and not opts.urn:
                raise TypeError("Missing required property 'content'")
            __props__.__dict__["content"] = None if content is None else pulumi.Output.secret(content)
            __props__.__dict__["full_path"] = full_path
            __props__.__dict__["issuer_cert"] = issuer_cert
            __props__.__dict__["monitoring_type"] = monitoring_type
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["ocsp"] = ocsp
            __props__.__dict__["partition"] = partition
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["content"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Certificate, __self__).__init__(
            'f5bigip:ssl/certificate:Certificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            content: Optional[pulumi.Input[builtins.str]] = None,
            full_path: Optional[pulumi.Input[builtins.str]] = None,
            issuer_cert: Optional[pulumi.Input[builtins.str]] = None,
            monitoring_type: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            ocsp: Optional[pulumi.Input[builtins.str]] = None,
            partition: Optional[pulumi.Input[builtins.str]] = None) -> 'Certificate':
        """
        Get an existing Certificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] content: Content of certificate on Disk
        :param pulumi.Input[builtins.str] full_path: Full Path Name of ssl certificate
        :param pulumi.Input[builtins.str] issuer_cert: Specifies the issuer certificate.
        :param pulumi.Input[builtins.str] monitoring_type: Specifies the type of monitoring used.
        :param pulumi.Input[builtins.str] name: Name of the SSL Certificate to be Imported on to BIGIP
        :param pulumi.Input[builtins.str] ocsp: Specifies the OCSP responder.
        :param pulumi.Input[builtins.str] partition: Partition of ssl certificate
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateState.__new__(_CertificateState)

        __props__.__dict__["content"] = content
        __props__.__dict__["full_path"] = full_path
        __props__.__dict__["issuer_cert"] = issuer_cert
        __props__.__dict__["monitoring_type"] = monitoring_type
        __props__.__dict__["name"] = name
        __props__.__dict__["ocsp"] = ocsp
        __props__.__dict__["partition"] = partition
        return Certificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Output[builtins.str]:
        """
        Content of certificate on Disk
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="fullPath")
    def full_path(self) -> pulumi.Output[builtins.str]:
        """
        Full Path Name of ssl certificate
        """
        return pulumi.get(self, "full_path")

    @property
    @pulumi.getter(name="issuerCert")
    def issuer_cert(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the issuer certificate.
        """
        return pulumi.get(self, "issuer_cert")

    @property
    @pulumi.getter(name="monitoringType")
    def monitoring_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the type of monitoring used.
        """
        return pulumi.get(self, "monitoring_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the SSL Certificate to be Imported on to BIGIP
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ocsp(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the OCSP responder.
        """
        return pulumi.get(self, "ocsp")

    @property
    @pulumi.getter
    def partition(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Partition of ssl certificate
        """
        return pulumi.get(self, "partition")

