# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetCertificateResult',
    'AwaitableGetCertificateResult',
    'get_certificate',
    'get_certificate_output',
]

@pulumi.output_type
class GetCertificateResult:
    """
    A collection of values returned by getCertificate.
    """
    def __init__(__self__, certificate=None, id=None, name=None, partition=None):
        if certificate and not isinstance(certificate, str):
            raise TypeError("Expected argument 'certificate' to be a str")
        pulumi.set(__self__, "certificate", certificate)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if partition and not isinstance(partition, str):
            raise TypeError("Expected argument 'partition' to be a str")
        pulumi.set(__self__, "partition", partition)

    @property
    @pulumi.getter
    def certificate(self) -> builtins.str:
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of ssl_certificate configured on bigip with full path
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def partition(self) -> builtins.str:
        """
        Bigip partition in which ssl-certificate is configured
        """
        return pulumi.get(self, "partition")


class AwaitableGetCertificateResult(GetCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateResult(
            certificate=self.certificate,
            id=self.id,
            name=self.name,
            partition=self.partition)


def get_certificate(name: Optional[builtins.str] = None,
                    partition: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateResult:
    """
    Use this data source (`ssl.Certificate`) to get the ssl-certificate details available on BIG-IP

    ## Example Usage

    ```python
    import pulumi
    import pulumi_f5bigip as f5bigip

    test = f5bigip.ssl.get_certificate(name="terraform_ssl_certificate",
        partition="Common")
    pulumi.export("bigipSslCertificateName", test.name)
    ```


    :param builtins.str name: Name of the ssl_certificate
    :param builtins.str partition: partition of the ltm ssl_certificate
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['partition'] = partition
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('f5bigip:ssl/getCertificate:getCertificate', __args__, opts=opts, typ=GetCertificateResult).value

    return AwaitableGetCertificateResult(
        certificate=pulumi.get(__ret__, 'certificate'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        partition=pulumi.get(__ret__, 'partition'))
def get_certificate_output(name: Optional[pulumi.Input[builtins.str]] = None,
                           partition: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCertificateResult]:
    """
    Use this data source (`ssl.Certificate`) to get the ssl-certificate details available on BIG-IP

    ## Example Usage

    ```python
    import pulumi
    import pulumi_f5bigip as f5bigip

    test = f5bigip.ssl.get_certificate(name="terraform_ssl_certificate",
        partition="Common")
    pulumi.export("bigipSslCertificateName", test.name)
    ```


    :param builtins.str name: Name of the ssl_certificate
    :param builtins.str partition: partition of the ltm ssl_certificate
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['partition'] = partition
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('f5bigip:ssl/getCertificate:getCertificate', __args__, opts=opts, typ=GetCertificateResult)
    return __ret__.apply(lambda __response__: GetCertificateResult(
        certificate=pulumi.get(__response__, 'certificate'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        partition=pulumi.get(__response__, 'partition')))
