# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetVWanConfigResult',
    'AwaitableGetVWanConfigResult',
    'get_v_wan_config',
    'get_v_wan_config_output',
]

@pulumi.output_type
class GetVWanConfigResult:
    """
    A collection of values returned by getVWanConfig.
    """
    def __init__(__self__, azure_vwan_name=None, azure_vwan_resourcegroup=None, azure_vwan_vpnsite=None, bigip_gw_ip=None, hub_address_space=None, hub_connected_subnets=None, id=None, preshared_key=None, vwan_gw_addresses=None):
        if azure_vwan_name and not isinstance(azure_vwan_name, str):
            raise TypeError("Expected argument 'azure_vwan_name' to be a str")
        pulumi.set(__self__, "azure_vwan_name", azure_vwan_name)
        if azure_vwan_resourcegroup and not isinstance(azure_vwan_resourcegroup, str):
            raise TypeError("Expected argument 'azure_vwan_resourcegroup' to be a str")
        pulumi.set(__self__, "azure_vwan_resourcegroup", azure_vwan_resourcegroup)
        if azure_vwan_vpnsite and not isinstance(azure_vwan_vpnsite, str):
            raise TypeError("Expected argument 'azure_vwan_vpnsite' to be a str")
        pulumi.set(__self__, "azure_vwan_vpnsite", azure_vwan_vpnsite)
        if bigip_gw_ip and not isinstance(bigip_gw_ip, str):
            raise TypeError("Expected argument 'bigip_gw_ip' to be a str")
        pulumi.set(__self__, "bigip_gw_ip", bigip_gw_ip)
        if hub_address_space and not isinstance(hub_address_space, str):
            raise TypeError("Expected argument 'hub_address_space' to be a str")
        pulumi.set(__self__, "hub_address_space", hub_address_space)
        if hub_connected_subnets and not isinstance(hub_connected_subnets, list):
            raise TypeError("Expected argument 'hub_connected_subnets' to be a list")
        pulumi.set(__self__, "hub_connected_subnets", hub_connected_subnets)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if preshared_key and not isinstance(preshared_key, str):
            raise TypeError("Expected argument 'preshared_key' to be a str")
        pulumi.set(__self__, "preshared_key", preshared_key)
        if vwan_gw_addresses and not isinstance(vwan_gw_addresses, list):
            raise TypeError("Expected argument 'vwan_gw_addresses' to be a list")
        pulumi.set(__self__, "vwan_gw_addresses", vwan_gw_addresses)

    @property
    @pulumi.getter(name="azureVwanName")
    def azure_vwan_name(self) -> builtins.str:
        return pulumi.get(self, "azure_vwan_name")

    @property
    @pulumi.getter(name="azureVwanResourcegroup")
    def azure_vwan_resourcegroup(self) -> builtins.str:
        return pulumi.get(self, "azure_vwan_resourcegroup")

    @property
    @pulumi.getter(name="azureVwanVpnsite")
    def azure_vwan_vpnsite(self) -> builtins.str:
        return pulumi.get(self, "azure_vwan_vpnsite")

    @property
    @pulumi.getter(name="bigipGwIp")
    def bigip_gw_ip(self) -> builtins.str:
        """
        (type `string`) provides IP address of BIGIP G/W for IPSec Endpoint.
        """
        return pulumi.get(self, "bigip_gw_ip")

    @property
    @pulumi.getter(name="hubAddressSpace")
    def hub_address_space(self) -> builtins.str:
        """
        (type `string`) Provides IP Address space used on vWAN Hub.
        """
        return pulumi.get(self, "hub_address_space")

    @property
    @pulumi.getter(name="hubConnectedSubnets")
    def hub_connected_subnets(self) -> Sequence[builtins.str]:
        """
        (type `list`) Provides Subnets connected to vWAN Hub.
        """
        return pulumi.get(self, "hub_connected_subnets")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="presharedKey")
    def preshared_key(self) -> builtins.str:
        """
        (type `string`) provides pre-shared-key used for IPSec Tunnel creation.
        """
        return pulumi.get(self, "preshared_key")

    @property
    @pulumi.getter(name="vwanGwAddresses")
    def vwan_gw_addresses(self) -> Sequence[builtins.str]:
        """
        (type `list`) Provides vWAN Gateway Address for IPSec End point
        """
        return pulumi.get(self, "vwan_gw_addresses")


class AwaitableGetVWanConfigResult(GetVWanConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVWanConfigResult(
            azure_vwan_name=self.azure_vwan_name,
            azure_vwan_resourcegroup=self.azure_vwan_resourcegroup,
            azure_vwan_vpnsite=self.azure_vwan_vpnsite,
            bigip_gw_ip=self.bigip_gw_ip,
            hub_address_space=self.hub_address_space,
            hub_connected_subnets=self.hub_connected_subnets,
            id=self.id,
            preshared_key=self.preshared_key,
            vwan_gw_addresses=self.vwan_gw_addresses)


def get_v_wan_config(azure_vwan_name: Optional[builtins.str] = None,
                     azure_vwan_resourcegroup: Optional[builtins.str] = None,
                     azure_vwan_vpnsite: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVWanConfigResult:
    """
    Use this data source (`ssl_get_v_wan_config`) to get the vWAN site config from Azure VWAN Site

    ## Example Usage

    ```python
    import pulumi
    import pulumi_f5bigip as f5bigip

    vwanconfig = f5bigip.ssl.get_v_wan_config(azure_vwan_resourcegroup="azurevwan-bigip-rg-9c8d",
        azure_vwan_name="azurevwan-bigip-vwan-9c8d",
        azure_vwan_vpnsite="azurevwan-bigip-vsite-9c8d")
    ```

    ## Pre-required Environment Settings:

    * `AZURE_CLIENT_ID` - (Required) Set this environment variable with the Azure app client ID to use.

    * `AZURE_CLIENT_SECRET` - (Required) Set this environment variable with the Azure app secret to use.

    * `AZURE_SUBSCRIPTION_ID` - (Required) Set this environment variable with the Azure subscription ID to use.

    * `AZURE_TENANT_ID` - (Required) Set this environment variable with the Tenant ID to which to authenticate.

    * `STORAGE_ACCOUNT_NAME` - (Required) Set this environment variable with the storage account for download config.

    * `STORAGE_ACCOUNT_KEY` - (Required) Specifies the storage account key to authenticate,set this Environment variable with account key value.


    :param builtins.str azure_vwan_name: Name of the Azure vWAN Name
    :param builtins.str azure_vwan_resourcegroup: Name of the Azure vWAN resource group
    :param builtins.str azure_vwan_vpnsite: Name of the Azure vWAN VPN site from which configuration to be download
    """
    __args__ = dict()
    __args__['azureVwanName'] = azure_vwan_name
    __args__['azureVwanResourcegroup'] = azure_vwan_resourcegroup
    __args__['azureVwanVpnsite'] = azure_vwan_vpnsite
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('f5bigip:ssl/getVWanConfig:getVWanConfig', __args__, opts=opts, typ=GetVWanConfigResult).value

    return AwaitableGetVWanConfigResult(
        azure_vwan_name=pulumi.get(__ret__, 'azure_vwan_name'),
        azure_vwan_resourcegroup=pulumi.get(__ret__, 'azure_vwan_resourcegroup'),
        azure_vwan_vpnsite=pulumi.get(__ret__, 'azure_vwan_vpnsite'),
        bigip_gw_ip=pulumi.get(__ret__, 'bigip_gw_ip'),
        hub_address_space=pulumi.get(__ret__, 'hub_address_space'),
        hub_connected_subnets=pulumi.get(__ret__, 'hub_connected_subnets'),
        id=pulumi.get(__ret__, 'id'),
        preshared_key=pulumi.get(__ret__, 'preshared_key'),
        vwan_gw_addresses=pulumi.get(__ret__, 'vwan_gw_addresses'))
def get_v_wan_config_output(azure_vwan_name: Optional[pulumi.Input[builtins.str]] = None,
                            azure_vwan_resourcegroup: Optional[pulumi.Input[builtins.str]] = None,
                            azure_vwan_vpnsite: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVWanConfigResult]:
    """
    Use this data source (`ssl_get_v_wan_config`) to get the vWAN site config from Azure VWAN Site

    ## Example Usage

    ```python
    import pulumi
    import pulumi_f5bigip as f5bigip

    vwanconfig = f5bigip.ssl.get_v_wan_config(azure_vwan_resourcegroup="azurevwan-bigip-rg-9c8d",
        azure_vwan_name="azurevwan-bigip-vwan-9c8d",
        azure_vwan_vpnsite="azurevwan-bigip-vsite-9c8d")
    ```

    ## Pre-required Environment Settings:

    * `AZURE_CLIENT_ID` - (Required) Set this environment variable with the Azure app client ID to use.

    * `AZURE_CLIENT_SECRET` - (Required) Set this environment variable with the Azure app secret to use.

    * `AZURE_SUBSCRIPTION_ID` - (Required) Set this environment variable with the Azure subscription ID to use.

    * `AZURE_TENANT_ID` - (Required) Set this environment variable with the Tenant ID to which to authenticate.

    * `STORAGE_ACCOUNT_NAME` - (Required) Set this environment variable with the storage account for download config.

    * `STORAGE_ACCOUNT_KEY` - (Required) Specifies the storage account key to authenticate,set this Environment variable with account key value.


    :param builtins.str azure_vwan_name: Name of the Azure vWAN Name
    :param builtins.str azure_vwan_resourcegroup: Name of the Azure vWAN resource group
    :param builtins.str azure_vwan_vpnsite: Name of the Azure vWAN VPN site from which configuration to be download
    """
    __args__ = dict()
    __args__['azureVwanName'] = azure_vwan_name
    __args__['azureVwanResourcegroup'] = azure_vwan_resourcegroup
    __args__['azureVwanVpnsite'] = azure_vwan_vpnsite
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('f5bigip:ssl/getVWanConfig:getVWanConfig', __args__, opts=opts, typ=GetVWanConfigResult)
    return __ret__.apply(lambda __response__: GetVWanConfigResult(
        azure_vwan_name=pulumi.get(__response__, 'azure_vwan_name'),
        azure_vwan_resourcegroup=pulumi.get(__response__, 'azure_vwan_resourcegroup'),
        azure_vwan_vpnsite=pulumi.get(__response__, 'azure_vwan_vpnsite'),
        bigip_gw_ip=pulumi.get(__response__, 'bigip_gw_ip'),
        hub_address_space=pulumi.get(__response__, 'hub_address_space'),
        hub_connected_subnets=pulumi.get(__response__, 'hub_connected_subnets'),
        id=pulumi.get(__response__, 'id'),
        preshared_key=pulumi.get(__response__, 'preshared_key'),
        vwan_gw_addresses=pulumi.get(__response__, 'vwan_gw_addresses')))
