# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IAppArgs', 'IApp']

@pulumi.input_type
class IAppArgs:
    def __init__(__self__, *,
                 jsonfile: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 devicegroup: Optional[pulumi.Input[builtins.str]] = None,
                 execute_action: Optional[pulumi.Input[builtins.str]] = None,
                 inherited_devicegroup: Optional[pulumi.Input[builtins.str]] = None,
                 inherited_traffic_group: Optional[pulumi.Input[builtins.str]] = None,
                 lists: Optional[pulumi.Input[Sequence[pulumi.Input['IAppListArgs']]]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['IAppMetadataArgs']]]] = None,
                 partition: Optional[pulumi.Input[builtins.str]] = None,
                 strict_updates: Optional[pulumi.Input[builtins.str]] = None,
                 tables: Optional[pulumi.Input[Sequence[pulumi.Input['IAppTableArgs']]]] = None,
                 template: Optional[pulumi.Input[builtins.str]] = None,
                 template_modified: Optional[pulumi.Input[builtins.str]] = None,
                 template_prerequisite_errors: Optional[pulumi.Input[builtins.str]] = None,
                 traffic_group: Optional[pulumi.Input[builtins.str]] = None,
                 variables: Optional[pulumi.Input[Sequence[pulumi.Input['IAppVariableArgs']]]] = None):
        """
        The set of arguments for constructing a IApp resource.
        :param pulumi.Input[builtins.str] jsonfile: Refer to the Json file which will be deployed on F5 BIG-IP.
        :param pulumi.Input[builtins.str] name: Name of the iApp.
        :param pulumi.Input[builtins.str] description: User defined description.
        :param pulumi.Input[builtins.str] devicegroup: BIG-IP password
        :param pulumi.Input[builtins.str] execute_action: Run the specified template action associated with the application, this option can be specified in `json` with `executeAction`, value specified with `execute_action` attribute take precedence over `json` value
        :param pulumi.Input[builtins.str] inherited_devicegroup: Read-only. Shows whether the application folder will automatically remain with the same device-group as its parent folder. Use 'device-group default' or 'device-group non-default' to set this.
        :param pulumi.Input[builtins.str] inherited_traffic_group: Read-only. Shows whether the application folder will automatically remain with the same traffic-group as its parent folder. Use 'traffic-group default' or 'traffic-group non-default' to set this.
        :param pulumi.Input[Sequence[pulumi.Input['IAppListArgs']]] lists: string values
        :param pulumi.Input[Sequence[pulumi.Input['IAppMetadataArgs']]] metadatas: User defined generic data for the application service. It is a name and value pair.
        :param pulumi.Input[builtins.str] partition: Displays the administrative partition within which the application resides.
        :param pulumi.Input[builtins.str] strict_updates: Specifies whether configuration objects contained in the application may be directly modified, outside the context of the system's application management interfaces.
        :param pulumi.Input[builtins.str] template: The template defines the configuration for the application. This may be changed after the application has been created to move the application to a new template.
        :param pulumi.Input[builtins.str] template_modified: Indicates that the application template used to deploy the application has been modified. The application should be updated to make use of the latest changes.
        :param pulumi.Input[builtins.str] template_prerequisite_errors: Indicates any missing prerequisites associated with the template that defines this application.
        :param pulumi.Input[builtins.str] traffic_group: The name of the traffic group that the application service is assigned to.
        """
        pulumi.set(__self__, "jsonfile", jsonfile)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if devicegroup is not None:
            pulumi.set(__self__, "devicegroup", devicegroup)
        if execute_action is not None:
            pulumi.set(__self__, "execute_action", execute_action)
        if inherited_devicegroup is not None:
            pulumi.set(__self__, "inherited_devicegroup", inherited_devicegroup)
        if inherited_traffic_group is not None:
            pulumi.set(__self__, "inherited_traffic_group", inherited_traffic_group)
        if lists is not None:
            pulumi.set(__self__, "lists", lists)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if strict_updates is not None:
            pulumi.set(__self__, "strict_updates", strict_updates)
        if tables is not None:
            pulumi.set(__self__, "tables", tables)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if template_modified is not None:
            pulumi.set(__self__, "template_modified", template_modified)
        if template_prerequisite_errors is not None:
            pulumi.set(__self__, "template_prerequisite_errors", template_prerequisite_errors)
        if traffic_group is not None:
            pulumi.set(__self__, "traffic_group", traffic_group)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter
    def jsonfile(self) -> pulumi.Input[builtins.str]:
        """
        Refer to the Json file which will be deployed on F5 BIG-IP.
        """
        return pulumi.get(self, "jsonfile")

    @jsonfile.setter
    def jsonfile(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "jsonfile", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the iApp.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User defined description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def devicegroup(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        BIG-IP password
        """
        return pulumi.get(self, "devicegroup")

    @devicegroup.setter
    def devicegroup(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "devicegroup", value)

    @property
    @pulumi.getter(name="executeAction")
    def execute_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Run the specified template action associated with the application, this option can be specified in `json` with `executeAction`, value specified with `execute_action` attribute take precedence over `json` value
        """
        return pulumi.get(self, "execute_action")

    @execute_action.setter
    def execute_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "execute_action", value)

    @property
    @pulumi.getter(name="inheritedDevicegroup")
    def inherited_devicegroup(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Read-only. Shows whether the application folder will automatically remain with the same device-group as its parent folder. Use 'device-group default' or 'device-group non-default' to set this.
        """
        return pulumi.get(self, "inherited_devicegroup")

    @inherited_devicegroup.setter
    def inherited_devicegroup(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "inherited_devicegroup", value)

    @property
    @pulumi.getter(name="inheritedTrafficGroup")
    def inherited_traffic_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Read-only. Shows whether the application folder will automatically remain with the same traffic-group as its parent folder. Use 'traffic-group default' or 'traffic-group non-default' to set this.
        """
        return pulumi.get(self, "inherited_traffic_group")

    @inherited_traffic_group.setter
    def inherited_traffic_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "inherited_traffic_group", value)

    @property
    @pulumi.getter
    def lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IAppListArgs']]]]:
        """
        string values
        """
        return pulumi.get(self, "lists")

    @lists.setter
    def lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IAppListArgs']]]]):
        pulumi.set(self, "lists", value)

    @property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IAppMetadataArgs']]]]:
        """
        User defined generic data for the application service. It is a name and value pair.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IAppMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Displays the administrative partition within which the application resides.
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "partition", value)

    @property
    @pulumi.getter(name="strictUpdates")
    def strict_updates(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether configuration objects contained in the application may be directly modified, outside the context of the system's application management interfaces.
        """
        return pulumi.get(self, "strict_updates")

    @strict_updates.setter
    def strict_updates(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "strict_updates", value)

    @property
    @pulumi.getter
    def tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IAppTableArgs']]]]:
        return pulumi.get(self, "tables")

    @tables.setter
    def tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IAppTableArgs']]]]):
        pulumi.set(self, "tables", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The template defines the configuration for the application. This may be changed after the application has been created to move the application to a new template.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter(name="templateModified")
    def template_modified(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates that the application template used to deploy the application has been modified. The application should be updated to make use of the latest changes.
        """
        return pulumi.get(self, "template_modified")

    @template_modified.setter
    def template_modified(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_modified", value)

    @property
    @pulumi.getter(name="templatePrerequisiteErrors")
    def template_prerequisite_errors(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates any missing prerequisites associated with the template that defines this application.
        """
        return pulumi.get(self, "template_prerequisite_errors")

    @template_prerequisite_errors.setter
    def template_prerequisite_errors(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_prerequisite_errors", value)

    @property
    @pulumi.getter(name="trafficGroup")
    def traffic_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the traffic group that the application service is assigned to.
        """
        return pulumi.get(self, "traffic_group")

    @traffic_group.setter
    def traffic_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "traffic_group", value)

    @property
    @pulumi.getter
    def variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IAppVariableArgs']]]]:
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IAppVariableArgs']]]]):
        pulumi.set(self, "variables", value)


@pulumi.input_type
class _IAppState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 devicegroup: Optional[pulumi.Input[builtins.str]] = None,
                 execute_action: Optional[pulumi.Input[builtins.str]] = None,
                 inherited_devicegroup: Optional[pulumi.Input[builtins.str]] = None,
                 inherited_traffic_group: Optional[pulumi.Input[builtins.str]] = None,
                 jsonfile: Optional[pulumi.Input[builtins.str]] = None,
                 lists: Optional[pulumi.Input[Sequence[pulumi.Input['IAppListArgs']]]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['IAppMetadataArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 partition: Optional[pulumi.Input[builtins.str]] = None,
                 strict_updates: Optional[pulumi.Input[builtins.str]] = None,
                 tables: Optional[pulumi.Input[Sequence[pulumi.Input['IAppTableArgs']]]] = None,
                 template: Optional[pulumi.Input[builtins.str]] = None,
                 template_modified: Optional[pulumi.Input[builtins.str]] = None,
                 template_prerequisite_errors: Optional[pulumi.Input[builtins.str]] = None,
                 traffic_group: Optional[pulumi.Input[builtins.str]] = None,
                 variables: Optional[pulumi.Input[Sequence[pulumi.Input['IAppVariableArgs']]]] = None):
        """
        Input properties used for looking up and filtering IApp resources.
        :param pulumi.Input[builtins.str] description: User defined description.
        :param pulumi.Input[builtins.str] devicegroup: BIG-IP password
        :param pulumi.Input[builtins.str] execute_action: Run the specified template action associated with the application, this option can be specified in `json` with `executeAction`, value specified with `execute_action` attribute take precedence over `json` value
        :param pulumi.Input[builtins.str] inherited_devicegroup: Read-only. Shows whether the application folder will automatically remain with the same device-group as its parent folder. Use 'device-group default' or 'device-group non-default' to set this.
        :param pulumi.Input[builtins.str] inherited_traffic_group: Read-only. Shows whether the application folder will automatically remain with the same traffic-group as its parent folder. Use 'traffic-group default' or 'traffic-group non-default' to set this.
        :param pulumi.Input[builtins.str] jsonfile: Refer to the Json file which will be deployed on F5 BIG-IP.
        :param pulumi.Input[Sequence[pulumi.Input['IAppListArgs']]] lists: string values
        :param pulumi.Input[Sequence[pulumi.Input['IAppMetadataArgs']]] metadatas: User defined generic data for the application service. It is a name and value pair.
        :param pulumi.Input[builtins.str] name: Name of the iApp.
        :param pulumi.Input[builtins.str] partition: Displays the administrative partition within which the application resides.
        :param pulumi.Input[builtins.str] strict_updates: Specifies whether configuration objects contained in the application may be directly modified, outside the context of the system's application management interfaces.
        :param pulumi.Input[builtins.str] template: The template defines the configuration for the application. This may be changed after the application has been created to move the application to a new template.
        :param pulumi.Input[builtins.str] template_modified: Indicates that the application template used to deploy the application has been modified. The application should be updated to make use of the latest changes.
        :param pulumi.Input[builtins.str] template_prerequisite_errors: Indicates any missing prerequisites associated with the template that defines this application.
        :param pulumi.Input[builtins.str] traffic_group: The name of the traffic group that the application service is assigned to.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if devicegroup is not None:
            pulumi.set(__self__, "devicegroup", devicegroup)
        if execute_action is not None:
            pulumi.set(__self__, "execute_action", execute_action)
        if inherited_devicegroup is not None:
            pulumi.set(__self__, "inherited_devicegroup", inherited_devicegroup)
        if inherited_traffic_group is not None:
            pulumi.set(__self__, "inherited_traffic_group", inherited_traffic_group)
        if jsonfile is not None:
            pulumi.set(__self__, "jsonfile", jsonfile)
        if lists is not None:
            pulumi.set(__self__, "lists", lists)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if strict_updates is not None:
            pulumi.set(__self__, "strict_updates", strict_updates)
        if tables is not None:
            pulumi.set(__self__, "tables", tables)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if template_modified is not None:
            pulumi.set(__self__, "template_modified", template_modified)
        if template_prerequisite_errors is not None:
            pulumi.set(__self__, "template_prerequisite_errors", template_prerequisite_errors)
        if traffic_group is not None:
            pulumi.set(__self__, "traffic_group", traffic_group)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User defined description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def devicegroup(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        BIG-IP password
        """
        return pulumi.get(self, "devicegroup")

    @devicegroup.setter
    def devicegroup(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "devicegroup", value)

    @property
    @pulumi.getter(name="executeAction")
    def execute_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Run the specified template action associated with the application, this option can be specified in `json` with `executeAction`, value specified with `execute_action` attribute take precedence over `json` value
        """
        return pulumi.get(self, "execute_action")

    @execute_action.setter
    def execute_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "execute_action", value)

    @property
    @pulumi.getter(name="inheritedDevicegroup")
    def inherited_devicegroup(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Read-only. Shows whether the application folder will automatically remain with the same device-group as its parent folder. Use 'device-group default' or 'device-group non-default' to set this.
        """
        return pulumi.get(self, "inherited_devicegroup")

    @inherited_devicegroup.setter
    def inherited_devicegroup(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "inherited_devicegroup", value)

    @property
    @pulumi.getter(name="inheritedTrafficGroup")
    def inherited_traffic_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Read-only. Shows whether the application folder will automatically remain with the same traffic-group as its parent folder. Use 'traffic-group default' or 'traffic-group non-default' to set this.
        """
        return pulumi.get(self, "inherited_traffic_group")

    @inherited_traffic_group.setter
    def inherited_traffic_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "inherited_traffic_group", value)

    @property
    @pulumi.getter
    def jsonfile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Refer to the Json file which will be deployed on F5 BIG-IP.
        """
        return pulumi.get(self, "jsonfile")

    @jsonfile.setter
    def jsonfile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "jsonfile", value)

    @property
    @pulumi.getter
    def lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IAppListArgs']]]]:
        """
        string values
        """
        return pulumi.get(self, "lists")

    @lists.setter
    def lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IAppListArgs']]]]):
        pulumi.set(self, "lists", value)

    @property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IAppMetadataArgs']]]]:
        """
        User defined generic data for the application service. It is a name and value pair.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IAppMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the iApp.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Displays the administrative partition within which the application resides.
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "partition", value)

    @property
    @pulumi.getter(name="strictUpdates")
    def strict_updates(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether configuration objects contained in the application may be directly modified, outside the context of the system's application management interfaces.
        """
        return pulumi.get(self, "strict_updates")

    @strict_updates.setter
    def strict_updates(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "strict_updates", value)

    @property
    @pulumi.getter
    def tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IAppTableArgs']]]]:
        return pulumi.get(self, "tables")

    @tables.setter
    def tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IAppTableArgs']]]]):
        pulumi.set(self, "tables", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The template defines the configuration for the application. This may be changed after the application has been created to move the application to a new template.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter(name="templateModified")
    def template_modified(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates that the application template used to deploy the application has been modified. The application should be updated to make use of the latest changes.
        """
        return pulumi.get(self, "template_modified")

    @template_modified.setter
    def template_modified(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_modified", value)

    @property
    @pulumi.getter(name="templatePrerequisiteErrors")
    def template_prerequisite_errors(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates any missing prerequisites associated with the template that defines this application.
        """
        return pulumi.get(self, "template_prerequisite_errors")

    @template_prerequisite_errors.setter
    def template_prerequisite_errors(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_prerequisite_errors", value)

    @property
    @pulumi.getter(name="trafficGroup")
    def traffic_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the traffic group that the application service is assigned to.
        """
        return pulumi.get(self, "traffic_group")

    @traffic_group.setter
    def traffic_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "traffic_group", value)

    @property
    @pulumi.getter
    def variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IAppVariableArgs']]]]:
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IAppVariableArgs']]]]):
        pulumi.set(self, "variables", value)


@pulumi.type_token("f5bigip:sys/iApp:IApp")
class IApp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 devicegroup: Optional[pulumi.Input[builtins.str]] = None,
                 execute_action: Optional[pulumi.Input[builtins.str]] = None,
                 inherited_devicegroup: Optional[pulumi.Input[builtins.str]] = None,
                 inherited_traffic_group: Optional[pulumi.Input[builtins.str]] = None,
                 jsonfile: Optional[pulumi.Input[builtins.str]] = None,
                 lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IAppListArgs', 'IAppListArgsDict']]]]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IAppMetadataArgs', 'IAppMetadataArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 partition: Optional[pulumi.Input[builtins.str]] = None,
                 strict_updates: Optional[pulumi.Input[builtins.str]] = None,
                 tables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IAppTableArgs', 'IAppTableArgsDict']]]]] = None,
                 template: Optional[pulumi.Input[builtins.str]] = None,
                 template_modified: Optional[pulumi.Input[builtins.str]] = None,
                 template_prerequisite_errors: Optional[pulumi.Input[builtins.str]] = None,
                 traffic_group: Optional[pulumi.Input[builtins.str]] = None,
                 variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IAppVariableArgs', 'IAppVariableArgsDict']]]]] = None,
                 __props__=None):
        """
        `sys.IApp` resource helps you to deploy Application Services template that can be used to automate and orchestrate Layer 4-7 applications service deployments using F5 Network.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip
        import pulumi_std as std

        simplehttp = f5bigip.sys.IApp("simplehttp",
            name="simplehttp",
            jsonfile=std.file(input="simplehttp.json").result)
        ```

        ### Json File

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: User defined description.
        :param pulumi.Input[builtins.str] devicegroup: BIG-IP password
        :param pulumi.Input[builtins.str] execute_action: Run the specified template action associated with the application, this option can be specified in `json` with `executeAction`, value specified with `execute_action` attribute take precedence over `json` value
        :param pulumi.Input[builtins.str] inherited_devicegroup: Read-only. Shows whether the application folder will automatically remain with the same device-group as its parent folder. Use 'device-group default' or 'device-group non-default' to set this.
        :param pulumi.Input[builtins.str] inherited_traffic_group: Read-only. Shows whether the application folder will automatically remain with the same traffic-group as its parent folder. Use 'traffic-group default' or 'traffic-group non-default' to set this.
        :param pulumi.Input[builtins.str] jsonfile: Refer to the Json file which will be deployed on F5 BIG-IP.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IAppListArgs', 'IAppListArgsDict']]]] lists: string values
        :param pulumi.Input[Sequence[pulumi.Input[Union['IAppMetadataArgs', 'IAppMetadataArgsDict']]]] metadatas: User defined generic data for the application service. It is a name and value pair.
        :param pulumi.Input[builtins.str] name: Name of the iApp.
        :param pulumi.Input[builtins.str] partition: Displays the administrative partition within which the application resides.
        :param pulumi.Input[builtins.str] strict_updates: Specifies whether configuration objects contained in the application may be directly modified, outside the context of the system's application management interfaces.
        :param pulumi.Input[builtins.str] template: The template defines the configuration for the application. This may be changed after the application has been created to move the application to a new template.
        :param pulumi.Input[builtins.str] template_modified: Indicates that the application template used to deploy the application has been modified. The application should be updated to make use of the latest changes.
        :param pulumi.Input[builtins.str] template_prerequisite_errors: Indicates any missing prerequisites associated with the template that defines this application.
        :param pulumi.Input[builtins.str] traffic_group: The name of the traffic group that the application service is assigned to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IAppArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `sys.IApp` resource helps you to deploy Application Services template that can be used to automate and orchestrate Layer 4-7 applications service deployments using F5 Network.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip
        import pulumi_std as std

        simplehttp = f5bigip.sys.IApp("simplehttp",
            name="simplehttp",
            jsonfile=std.file(input="simplehttp.json").result)
        ```

        ### Json File

        :param str resource_name: The name of the resource.
        :param IAppArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IAppArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 devicegroup: Optional[pulumi.Input[builtins.str]] = None,
                 execute_action: Optional[pulumi.Input[builtins.str]] = None,
                 inherited_devicegroup: Optional[pulumi.Input[builtins.str]] = None,
                 inherited_traffic_group: Optional[pulumi.Input[builtins.str]] = None,
                 jsonfile: Optional[pulumi.Input[builtins.str]] = None,
                 lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IAppListArgs', 'IAppListArgsDict']]]]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IAppMetadataArgs', 'IAppMetadataArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 partition: Optional[pulumi.Input[builtins.str]] = None,
                 strict_updates: Optional[pulumi.Input[builtins.str]] = None,
                 tables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IAppTableArgs', 'IAppTableArgsDict']]]]] = None,
                 template: Optional[pulumi.Input[builtins.str]] = None,
                 template_modified: Optional[pulumi.Input[builtins.str]] = None,
                 template_prerequisite_errors: Optional[pulumi.Input[builtins.str]] = None,
                 traffic_group: Optional[pulumi.Input[builtins.str]] = None,
                 variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IAppVariableArgs', 'IAppVariableArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IAppArgs.__new__(IAppArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["devicegroup"] = devicegroup
            __props__.__dict__["execute_action"] = execute_action
            __props__.__dict__["inherited_devicegroup"] = inherited_devicegroup
            __props__.__dict__["inherited_traffic_group"] = inherited_traffic_group
            if jsonfile is None and not opts.urn:
                raise TypeError("Missing required property 'jsonfile'")
            __props__.__dict__["jsonfile"] = jsonfile
            __props__.__dict__["lists"] = lists
            __props__.__dict__["metadatas"] = metadatas
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["partition"] = partition
            __props__.__dict__["strict_updates"] = strict_updates
            __props__.__dict__["tables"] = tables
            __props__.__dict__["template"] = template
            __props__.__dict__["template_modified"] = template_modified
            __props__.__dict__["template_prerequisite_errors"] = template_prerequisite_errors
            __props__.__dict__["traffic_group"] = traffic_group
            __props__.__dict__["variables"] = variables
        super(IApp, __self__).__init__(
            'f5bigip:sys/iApp:IApp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            devicegroup: Optional[pulumi.Input[builtins.str]] = None,
            execute_action: Optional[pulumi.Input[builtins.str]] = None,
            inherited_devicegroup: Optional[pulumi.Input[builtins.str]] = None,
            inherited_traffic_group: Optional[pulumi.Input[builtins.str]] = None,
            jsonfile: Optional[pulumi.Input[builtins.str]] = None,
            lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IAppListArgs', 'IAppListArgsDict']]]]] = None,
            metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IAppMetadataArgs', 'IAppMetadataArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            partition: Optional[pulumi.Input[builtins.str]] = None,
            strict_updates: Optional[pulumi.Input[builtins.str]] = None,
            tables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IAppTableArgs', 'IAppTableArgsDict']]]]] = None,
            template: Optional[pulumi.Input[builtins.str]] = None,
            template_modified: Optional[pulumi.Input[builtins.str]] = None,
            template_prerequisite_errors: Optional[pulumi.Input[builtins.str]] = None,
            traffic_group: Optional[pulumi.Input[builtins.str]] = None,
            variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IAppVariableArgs', 'IAppVariableArgsDict']]]]] = None) -> 'IApp':
        """
        Get an existing IApp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: User defined description.
        :param pulumi.Input[builtins.str] devicegroup: BIG-IP password
        :param pulumi.Input[builtins.str] execute_action: Run the specified template action associated with the application, this option can be specified in `json` with `executeAction`, value specified with `execute_action` attribute take precedence over `json` value
        :param pulumi.Input[builtins.str] inherited_devicegroup: Read-only. Shows whether the application folder will automatically remain with the same device-group as its parent folder. Use 'device-group default' or 'device-group non-default' to set this.
        :param pulumi.Input[builtins.str] inherited_traffic_group: Read-only. Shows whether the application folder will automatically remain with the same traffic-group as its parent folder. Use 'traffic-group default' or 'traffic-group non-default' to set this.
        :param pulumi.Input[builtins.str] jsonfile: Refer to the Json file which will be deployed on F5 BIG-IP.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IAppListArgs', 'IAppListArgsDict']]]] lists: string values
        :param pulumi.Input[Sequence[pulumi.Input[Union['IAppMetadataArgs', 'IAppMetadataArgsDict']]]] metadatas: User defined generic data for the application service. It is a name and value pair.
        :param pulumi.Input[builtins.str] name: Name of the iApp.
        :param pulumi.Input[builtins.str] partition: Displays the administrative partition within which the application resides.
        :param pulumi.Input[builtins.str] strict_updates: Specifies whether configuration objects contained in the application may be directly modified, outside the context of the system's application management interfaces.
        :param pulumi.Input[builtins.str] template: The template defines the configuration for the application. This may be changed after the application has been created to move the application to a new template.
        :param pulumi.Input[builtins.str] template_modified: Indicates that the application template used to deploy the application has been modified. The application should be updated to make use of the latest changes.
        :param pulumi.Input[builtins.str] template_prerequisite_errors: Indicates any missing prerequisites associated with the template that defines this application.
        :param pulumi.Input[builtins.str] traffic_group: The name of the traffic group that the application service is assigned to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IAppState.__new__(_IAppState)

        __props__.__dict__["description"] = description
        __props__.__dict__["devicegroup"] = devicegroup
        __props__.__dict__["execute_action"] = execute_action
        __props__.__dict__["inherited_devicegroup"] = inherited_devicegroup
        __props__.__dict__["inherited_traffic_group"] = inherited_traffic_group
        __props__.__dict__["jsonfile"] = jsonfile
        __props__.__dict__["lists"] = lists
        __props__.__dict__["metadatas"] = metadatas
        __props__.__dict__["name"] = name
        __props__.__dict__["partition"] = partition
        __props__.__dict__["strict_updates"] = strict_updates
        __props__.__dict__["tables"] = tables
        __props__.__dict__["template"] = template
        __props__.__dict__["template_modified"] = template_modified
        __props__.__dict__["template_prerequisite_errors"] = template_prerequisite_errors
        __props__.__dict__["traffic_group"] = traffic_group
        __props__.__dict__["variables"] = variables
        return IApp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User defined description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def devicegroup(self) -> pulumi.Output[builtins.str]:
        """
        BIG-IP password
        """
        return pulumi.get(self, "devicegroup")

    @property
    @pulumi.getter(name="executeAction")
    def execute_action(self) -> pulumi.Output[builtins.str]:
        """
        Run the specified template action associated with the application, this option can be specified in `json` with `executeAction`, value specified with `execute_action` attribute take precedence over `json` value
        """
        return pulumi.get(self, "execute_action")

    @property
    @pulumi.getter(name="inheritedDevicegroup")
    def inherited_devicegroup(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Read-only. Shows whether the application folder will automatically remain with the same device-group as its parent folder. Use 'device-group default' or 'device-group non-default' to set this.
        """
        return pulumi.get(self, "inherited_devicegroup")

    @property
    @pulumi.getter(name="inheritedTrafficGroup")
    def inherited_traffic_group(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Read-only. Shows whether the application folder will automatically remain with the same traffic-group as its parent folder. Use 'traffic-group default' or 'traffic-group non-default' to set this.
        """
        return pulumi.get(self, "inherited_traffic_group")

    @property
    @pulumi.getter
    def jsonfile(self) -> pulumi.Output[builtins.str]:
        """
        Refer to the Json file which will be deployed on F5 BIG-IP.
        """
        return pulumi.get(self, "jsonfile")

    @property
    @pulumi.getter
    def lists(self) -> pulumi.Output[Optional[Sequence['outputs.IAppList']]]:
        """
        string values
        """
        return pulumi.get(self, "lists")

    @property
    @pulumi.getter
    def metadatas(self) -> pulumi.Output[Optional[Sequence['outputs.IAppMetadata']]]:
        """
        User defined generic data for the application service. It is a name and value pair.
        """
        return pulumi.get(self, "metadatas")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the iApp.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def partition(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Displays the administrative partition within which the application resides.
        """
        return pulumi.get(self, "partition")

    @property
    @pulumi.getter(name="strictUpdates")
    def strict_updates(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies whether configuration objects contained in the application may be directly modified, outside the context of the system's application management interfaces.
        """
        return pulumi.get(self, "strict_updates")

    @property
    @pulumi.getter
    def tables(self) -> pulumi.Output[Optional[Sequence['outputs.IAppTable']]]:
        return pulumi.get(self, "tables")

    @property
    @pulumi.getter
    def template(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The template defines the configuration for the application. This may be changed after the application has been created to move the application to a new template.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="templateModified")
    def template_modified(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Indicates that the application template used to deploy the application has been modified. The application should be updated to make use of the latest changes.
        """
        return pulumi.get(self, "template_modified")

    @property
    @pulumi.getter(name="templatePrerequisiteErrors")
    def template_prerequisite_errors(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Indicates any missing prerequisites associated with the template that defines this application.
        """
        return pulumi.get(self, "template_prerequisite_errors")

    @property
    @pulumi.getter(name="trafficGroup")
    def traffic_group(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the traffic group that the application service is assigned to.
        """
        return pulumi.get(self, "traffic_group")

    @property
    @pulumi.getter
    def variables(self) -> pulumi.Output[Optional[Sequence['outputs.IAppVariable']]]:
        return pulumi.get(self, "variables")

