# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['OcspArgs', 'Ocsp']

@pulumi.input_type
class OcspArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 cache_error_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 cache_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 clock_skew: Optional[pulumi.Input[builtins.int]] = None,
                 concurrent_connections_limit: Optional[pulumi.Input[builtins.int]] = None,
                 connection_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 dns_resolver: Optional[pulumi.Input[builtins.str]] = None,
                 passphrase: Optional[pulumi.Input[builtins.str]] = None,
                 proxy_server_pool: Optional[pulumi.Input[builtins.str]] = None,
                 responder_url: Optional[pulumi.Input[builtins.str]] = None,
                 route_domain: Optional[pulumi.Input[builtins.str]] = None,
                 sign_hash: Optional[pulumi.Input[builtins.str]] = None,
                 signer_cert: Optional[pulumi.Input[builtins.str]] = None,
                 signer_key: Optional[pulumi.Input[builtins.str]] = None,
                 status_age: Optional[pulumi.Input[builtins.int]] = None,
                 strict_resp_cert_check: Optional[pulumi.Input[builtins.str]] = None,
                 trusted_responders: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Ocsp resource.
        :param pulumi.Input[builtins.str] name: Name of the OCSP Responder. Name should be in pattern `/partition/ocsp_name`.
        :param pulumi.Input[builtins.int] cache_error_timeout: Specifies the lifetime of an error response in the cache, in seconds. This value must be greater than connection_timeout. The default value is `3600`.
        :param pulumi.Input[builtins.str] cache_timeout: Specifies the lifetime of the OCSP response in the cache, in seconds. The default value is `indefinite`.
        :param pulumi.Input[builtins.int] clock_skew: Specifies the time interval that the BIG-IP system allows for clock skew, in seconds. The default value is `300`.
        :param pulumi.Input[builtins.int] concurrent_connections_limit: Specifies the maximum number of connections per second allowed for the OCSP certificate validator. The default value is `50`.
        :param pulumi.Input[builtins.int] connection_timeout: Specifies the time interval that the BIG-IP system waits for before ending the connection to the OCSP responder, in seconds. The default value is `8`.
        :param pulumi.Input[builtins.str] dns_resolver: Specifies the internal DNS resolver the BIG-IP system uses to fetch the OCSP response.
        :param pulumi.Input[builtins.str] passphrase: Specifies a passphrase used to sign an OCSP request.
        :param pulumi.Input[builtins.str] proxy_server_pool: Specifies the proxy server pool the BIG-IP system uses to fetch the OCSP response.
        :param pulumi.Input[builtins.str] responder_url: Specifies the URL of the OCSP responder.
        :param pulumi.Input[builtins.str] route_domain: Specifies the route domain for the OCSP responder.
        :param pulumi.Input[builtins.str] sign_hash: Specifies the hash algorithm used to sign the OCSP request. The default value is `sha256`.
        :param pulumi.Input[builtins.str] signer_cert: Specifies the certificate used to sign the OCSP request.
        :param pulumi.Input[builtins.str] signer_key: Specifies the key used to sign the OCSP request.
        :param pulumi.Input[builtins.int] status_age: Specifies the maximum allowed lag time that the BIG-IP system accepts for the 'thisUpdate' time in the OCSP response, in seconds. The default value is `0`.
        :param pulumi.Input[builtins.str] strict_resp_cert_check: Specifies whether the responder's certificate is checked for an OCSP signing extension. The default value is `enabled`.
        :param pulumi.Input[builtins.str] trusted_responders: Specifies the certificates used for validating the OCSP response.
        """
        pulumi.set(__self__, "name", name)
        if cache_error_timeout is not None:
            pulumi.set(__self__, "cache_error_timeout", cache_error_timeout)
        if cache_timeout is not None:
            pulumi.set(__self__, "cache_timeout", cache_timeout)
        if clock_skew is not None:
            pulumi.set(__self__, "clock_skew", clock_skew)
        if concurrent_connections_limit is not None:
            pulumi.set(__self__, "concurrent_connections_limit", concurrent_connections_limit)
        if connection_timeout is not None:
            pulumi.set(__self__, "connection_timeout", connection_timeout)
        if dns_resolver is not None:
            pulumi.set(__self__, "dns_resolver", dns_resolver)
        if passphrase is not None:
            pulumi.set(__self__, "passphrase", passphrase)
        if proxy_server_pool is not None:
            pulumi.set(__self__, "proxy_server_pool", proxy_server_pool)
        if responder_url is not None:
            pulumi.set(__self__, "responder_url", responder_url)
        if route_domain is not None:
            pulumi.set(__self__, "route_domain", route_domain)
        if sign_hash is not None:
            pulumi.set(__self__, "sign_hash", sign_hash)
        if signer_cert is not None:
            pulumi.set(__self__, "signer_cert", signer_cert)
        if signer_key is not None:
            pulumi.set(__self__, "signer_key", signer_key)
        if status_age is not None:
            pulumi.set(__self__, "status_age", status_age)
        if strict_resp_cert_check is not None:
            pulumi.set(__self__, "strict_resp_cert_check", strict_resp_cert_check)
        if trusted_responders is not None:
            pulumi.set(__self__, "trusted_responders", trusted_responders)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the OCSP Responder. Name should be in pattern `/partition/ocsp_name`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="cacheErrorTimeout")
    def cache_error_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the lifetime of an error response in the cache, in seconds. This value must be greater than connection_timeout. The default value is `3600`.
        """
        return pulumi.get(self, "cache_error_timeout")

    @cache_error_timeout.setter
    def cache_error_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cache_error_timeout", value)

    @property
    @pulumi.getter(name="cacheTimeout")
    def cache_timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the lifetime of the OCSP response in the cache, in seconds. The default value is `indefinite`.
        """
        return pulumi.get(self, "cache_timeout")

    @cache_timeout.setter
    def cache_timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cache_timeout", value)

    @property
    @pulumi.getter(name="clockSkew")
    def clock_skew(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the time interval that the BIG-IP system allows for clock skew, in seconds. The default value is `300`.
        """
        return pulumi.get(self, "clock_skew")

    @clock_skew.setter
    def clock_skew(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "clock_skew", value)

    @property
    @pulumi.getter(name="concurrentConnectionsLimit")
    def concurrent_connections_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the maximum number of connections per second allowed for the OCSP certificate validator. The default value is `50`.
        """
        return pulumi.get(self, "concurrent_connections_limit")

    @concurrent_connections_limit.setter
    def concurrent_connections_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "concurrent_connections_limit", value)

    @property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the time interval that the BIG-IP system waits for before ending the connection to the OCSP responder, in seconds. The default value is `8`.
        """
        return pulumi.get(self, "connection_timeout")

    @connection_timeout.setter
    def connection_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "connection_timeout", value)

    @property
    @pulumi.getter(name="dnsResolver")
    def dns_resolver(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the internal DNS resolver the BIG-IP system uses to fetch the OCSP response.
        """
        return pulumi.get(self, "dns_resolver")

    @dns_resolver.setter
    def dns_resolver(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dns_resolver", value)

    @property
    @pulumi.getter
    def passphrase(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a passphrase used to sign an OCSP request.
        """
        return pulumi.get(self, "passphrase")

    @passphrase.setter
    def passphrase(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "passphrase", value)

    @property
    @pulumi.getter(name="proxyServerPool")
    def proxy_server_pool(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the proxy server pool the BIG-IP system uses to fetch the OCSP response.
        """
        return pulumi.get(self, "proxy_server_pool")

    @proxy_server_pool.setter
    def proxy_server_pool(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "proxy_server_pool", value)

    @property
    @pulumi.getter(name="responderUrl")
    def responder_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the URL of the OCSP responder.
        """
        return pulumi.get(self, "responder_url")

    @responder_url.setter
    def responder_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "responder_url", value)

    @property
    @pulumi.getter(name="routeDomain")
    def route_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the route domain for the OCSP responder.
        """
        return pulumi.get(self, "route_domain")

    @route_domain.setter
    def route_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_domain", value)

    @property
    @pulumi.getter(name="signHash")
    def sign_hash(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the hash algorithm used to sign the OCSP request. The default value is `sha256`.
        """
        return pulumi.get(self, "sign_hash")

    @sign_hash.setter
    def sign_hash(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sign_hash", value)

    @property
    @pulumi.getter(name="signerCert")
    def signer_cert(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the certificate used to sign the OCSP request.
        """
        return pulumi.get(self, "signer_cert")

    @signer_cert.setter
    def signer_cert(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "signer_cert", value)

    @property
    @pulumi.getter(name="signerKey")
    def signer_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the key used to sign the OCSP request.
        """
        return pulumi.get(self, "signer_key")

    @signer_key.setter
    def signer_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "signer_key", value)

    @property
    @pulumi.getter(name="statusAge")
    def status_age(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the maximum allowed lag time that the BIG-IP system accepts for the 'thisUpdate' time in the OCSP response, in seconds. The default value is `0`.
        """
        return pulumi.get(self, "status_age")

    @status_age.setter
    def status_age(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "status_age", value)

    @property
    @pulumi.getter(name="strictRespCertCheck")
    def strict_resp_cert_check(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether the responder's certificate is checked for an OCSP signing extension. The default value is `enabled`.
        """
        return pulumi.get(self, "strict_resp_cert_check")

    @strict_resp_cert_check.setter
    def strict_resp_cert_check(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "strict_resp_cert_check", value)

    @property
    @pulumi.getter(name="trustedResponders")
    def trusted_responders(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the certificates used for validating the OCSP response.
        """
        return pulumi.get(self, "trusted_responders")

    @trusted_responders.setter
    def trusted_responders(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trusted_responders", value)


@pulumi.input_type
class _OcspState:
    def __init__(__self__, *,
                 cache_error_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 cache_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 clock_skew: Optional[pulumi.Input[builtins.int]] = None,
                 concurrent_connections_limit: Optional[pulumi.Input[builtins.int]] = None,
                 connection_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 dns_resolver: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 passphrase: Optional[pulumi.Input[builtins.str]] = None,
                 proxy_server_pool: Optional[pulumi.Input[builtins.str]] = None,
                 responder_url: Optional[pulumi.Input[builtins.str]] = None,
                 route_domain: Optional[pulumi.Input[builtins.str]] = None,
                 sign_hash: Optional[pulumi.Input[builtins.str]] = None,
                 signer_cert: Optional[pulumi.Input[builtins.str]] = None,
                 signer_key: Optional[pulumi.Input[builtins.str]] = None,
                 status_age: Optional[pulumi.Input[builtins.int]] = None,
                 strict_resp_cert_check: Optional[pulumi.Input[builtins.str]] = None,
                 trusted_responders: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Ocsp resources.
        :param pulumi.Input[builtins.int] cache_error_timeout: Specifies the lifetime of an error response in the cache, in seconds. This value must be greater than connection_timeout. The default value is `3600`.
        :param pulumi.Input[builtins.str] cache_timeout: Specifies the lifetime of the OCSP response in the cache, in seconds. The default value is `indefinite`.
        :param pulumi.Input[builtins.int] clock_skew: Specifies the time interval that the BIG-IP system allows for clock skew, in seconds. The default value is `300`.
        :param pulumi.Input[builtins.int] concurrent_connections_limit: Specifies the maximum number of connections per second allowed for the OCSP certificate validator. The default value is `50`.
        :param pulumi.Input[builtins.int] connection_timeout: Specifies the time interval that the BIG-IP system waits for before ending the connection to the OCSP responder, in seconds. The default value is `8`.
        :param pulumi.Input[builtins.str] dns_resolver: Specifies the internal DNS resolver the BIG-IP system uses to fetch the OCSP response.
        :param pulumi.Input[builtins.str] name: Name of the OCSP Responder. Name should be in pattern `/partition/ocsp_name`.
        :param pulumi.Input[builtins.str] passphrase: Specifies a passphrase used to sign an OCSP request.
        :param pulumi.Input[builtins.str] proxy_server_pool: Specifies the proxy server pool the BIG-IP system uses to fetch the OCSP response.
        :param pulumi.Input[builtins.str] responder_url: Specifies the URL of the OCSP responder.
        :param pulumi.Input[builtins.str] route_domain: Specifies the route domain for the OCSP responder.
        :param pulumi.Input[builtins.str] sign_hash: Specifies the hash algorithm used to sign the OCSP request. The default value is `sha256`.
        :param pulumi.Input[builtins.str] signer_cert: Specifies the certificate used to sign the OCSP request.
        :param pulumi.Input[builtins.str] signer_key: Specifies the key used to sign the OCSP request.
        :param pulumi.Input[builtins.int] status_age: Specifies the maximum allowed lag time that the BIG-IP system accepts for the 'thisUpdate' time in the OCSP response, in seconds. The default value is `0`.
        :param pulumi.Input[builtins.str] strict_resp_cert_check: Specifies whether the responder's certificate is checked for an OCSP signing extension. The default value is `enabled`.
        :param pulumi.Input[builtins.str] trusted_responders: Specifies the certificates used for validating the OCSP response.
        """
        if cache_error_timeout is not None:
            pulumi.set(__self__, "cache_error_timeout", cache_error_timeout)
        if cache_timeout is not None:
            pulumi.set(__self__, "cache_timeout", cache_timeout)
        if clock_skew is not None:
            pulumi.set(__self__, "clock_skew", clock_skew)
        if concurrent_connections_limit is not None:
            pulumi.set(__self__, "concurrent_connections_limit", concurrent_connections_limit)
        if connection_timeout is not None:
            pulumi.set(__self__, "connection_timeout", connection_timeout)
        if dns_resolver is not None:
            pulumi.set(__self__, "dns_resolver", dns_resolver)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if passphrase is not None:
            pulumi.set(__self__, "passphrase", passphrase)
        if proxy_server_pool is not None:
            pulumi.set(__self__, "proxy_server_pool", proxy_server_pool)
        if responder_url is not None:
            pulumi.set(__self__, "responder_url", responder_url)
        if route_domain is not None:
            pulumi.set(__self__, "route_domain", route_domain)
        if sign_hash is not None:
            pulumi.set(__self__, "sign_hash", sign_hash)
        if signer_cert is not None:
            pulumi.set(__self__, "signer_cert", signer_cert)
        if signer_key is not None:
            pulumi.set(__self__, "signer_key", signer_key)
        if status_age is not None:
            pulumi.set(__self__, "status_age", status_age)
        if strict_resp_cert_check is not None:
            pulumi.set(__self__, "strict_resp_cert_check", strict_resp_cert_check)
        if trusted_responders is not None:
            pulumi.set(__self__, "trusted_responders", trusted_responders)

    @property
    @pulumi.getter(name="cacheErrorTimeout")
    def cache_error_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the lifetime of an error response in the cache, in seconds. This value must be greater than connection_timeout. The default value is `3600`.
        """
        return pulumi.get(self, "cache_error_timeout")

    @cache_error_timeout.setter
    def cache_error_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cache_error_timeout", value)

    @property
    @pulumi.getter(name="cacheTimeout")
    def cache_timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the lifetime of the OCSP response in the cache, in seconds. The default value is `indefinite`.
        """
        return pulumi.get(self, "cache_timeout")

    @cache_timeout.setter
    def cache_timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cache_timeout", value)

    @property
    @pulumi.getter(name="clockSkew")
    def clock_skew(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the time interval that the BIG-IP system allows for clock skew, in seconds. The default value is `300`.
        """
        return pulumi.get(self, "clock_skew")

    @clock_skew.setter
    def clock_skew(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "clock_skew", value)

    @property
    @pulumi.getter(name="concurrentConnectionsLimit")
    def concurrent_connections_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the maximum number of connections per second allowed for the OCSP certificate validator. The default value is `50`.
        """
        return pulumi.get(self, "concurrent_connections_limit")

    @concurrent_connections_limit.setter
    def concurrent_connections_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "concurrent_connections_limit", value)

    @property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the time interval that the BIG-IP system waits for before ending the connection to the OCSP responder, in seconds. The default value is `8`.
        """
        return pulumi.get(self, "connection_timeout")

    @connection_timeout.setter
    def connection_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "connection_timeout", value)

    @property
    @pulumi.getter(name="dnsResolver")
    def dns_resolver(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the internal DNS resolver the BIG-IP system uses to fetch the OCSP response.
        """
        return pulumi.get(self, "dns_resolver")

    @dns_resolver.setter
    def dns_resolver(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dns_resolver", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the OCSP Responder. Name should be in pattern `/partition/ocsp_name`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def passphrase(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a passphrase used to sign an OCSP request.
        """
        return pulumi.get(self, "passphrase")

    @passphrase.setter
    def passphrase(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "passphrase", value)

    @property
    @pulumi.getter(name="proxyServerPool")
    def proxy_server_pool(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the proxy server pool the BIG-IP system uses to fetch the OCSP response.
        """
        return pulumi.get(self, "proxy_server_pool")

    @proxy_server_pool.setter
    def proxy_server_pool(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "proxy_server_pool", value)

    @property
    @pulumi.getter(name="responderUrl")
    def responder_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the URL of the OCSP responder.
        """
        return pulumi.get(self, "responder_url")

    @responder_url.setter
    def responder_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "responder_url", value)

    @property
    @pulumi.getter(name="routeDomain")
    def route_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the route domain for the OCSP responder.
        """
        return pulumi.get(self, "route_domain")

    @route_domain.setter
    def route_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_domain", value)

    @property
    @pulumi.getter(name="signHash")
    def sign_hash(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the hash algorithm used to sign the OCSP request. The default value is `sha256`.
        """
        return pulumi.get(self, "sign_hash")

    @sign_hash.setter
    def sign_hash(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sign_hash", value)

    @property
    @pulumi.getter(name="signerCert")
    def signer_cert(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the certificate used to sign the OCSP request.
        """
        return pulumi.get(self, "signer_cert")

    @signer_cert.setter
    def signer_cert(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "signer_cert", value)

    @property
    @pulumi.getter(name="signerKey")
    def signer_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the key used to sign the OCSP request.
        """
        return pulumi.get(self, "signer_key")

    @signer_key.setter
    def signer_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "signer_key", value)

    @property
    @pulumi.getter(name="statusAge")
    def status_age(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the maximum allowed lag time that the BIG-IP system accepts for the 'thisUpdate' time in the OCSP response, in seconds. The default value is `0`.
        """
        return pulumi.get(self, "status_age")

    @status_age.setter
    def status_age(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "status_age", value)

    @property
    @pulumi.getter(name="strictRespCertCheck")
    def strict_resp_cert_check(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether the responder's certificate is checked for an OCSP signing extension. The default value is `enabled`.
        """
        return pulumi.get(self, "strict_resp_cert_check")

    @strict_resp_cert_check.setter
    def strict_resp_cert_check(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "strict_resp_cert_check", value)

    @property
    @pulumi.getter(name="trustedResponders")
    def trusted_responders(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the certificates used for validating the OCSP response.
        """
        return pulumi.get(self, "trusted_responders")

    @trusted_responders.setter
    def trusted_responders(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trusted_responders", value)


@pulumi.type_token("f5bigip:sys/ocsp:Ocsp")
class Ocsp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_error_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 cache_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 clock_skew: Optional[pulumi.Input[builtins.int]] = None,
                 concurrent_connections_limit: Optional[pulumi.Input[builtins.int]] = None,
                 connection_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 dns_resolver: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 passphrase: Optional[pulumi.Input[builtins.str]] = None,
                 proxy_server_pool: Optional[pulumi.Input[builtins.str]] = None,
                 responder_url: Optional[pulumi.Input[builtins.str]] = None,
                 route_domain: Optional[pulumi.Input[builtins.str]] = None,
                 sign_hash: Optional[pulumi.Input[builtins.str]] = None,
                 signer_cert: Optional[pulumi.Input[builtins.str]] = None,
                 signer_key: Optional[pulumi.Input[builtins.str]] = None,
                 status_age: Optional[pulumi.Input[builtins.int]] = None,
                 strict_resp_cert_check: Optional[pulumi.Input[builtins.str]] = None,
                 trusted_responders: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        `sys.Ocsp` Manages F5 BIG-IP OCSP responder using iControl REST.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        test_ocsp = f5bigip.sys.Ocsp("test-ocsp",
            name="/Uncommon/test-ocsp",
            proxy_server_pool="/Common/test-poolxyz",
            signer_key="/Common/le-ssl",
            signer_cert="/Common/le-ssl",
            passphrase="testabcdef")
        ```

        ## Importing

        An existing OCSP can be imported into this resource by supplying the full path name  ex : `/partition/name`
        An example is below:
        ```sh
        $ terraform import bigip_sys_ocsp.test-ocsp /Common/test-ocsp
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] cache_error_timeout: Specifies the lifetime of an error response in the cache, in seconds. This value must be greater than connection_timeout. The default value is `3600`.
        :param pulumi.Input[builtins.str] cache_timeout: Specifies the lifetime of the OCSP response in the cache, in seconds. The default value is `indefinite`.
        :param pulumi.Input[builtins.int] clock_skew: Specifies the time interval that the BIG-IP system allows for clock skew, in seconds. The default value is `300`.
        :param pulumi.Input[builtins.int] concurrent_connections_limit: Specifies the maximum number of connections per second allowed for the OCSP certificate validator. The default value is `50`.
        :param pulumi.Input[builtins.int] connection_timeout: Specifies the time interval that the BIG-IP system waits for before ending the connection to the OCSP responder, in seconds. The default value is `8`.
        :param pulumi.Input[builtins.str] dns_resolver: Specifies the internal DNS resolver the BIG-IP system uses to fetch the OCSP response.
        :param pulumi.Input[builtins.str] name: Name of the OCSP Responder. Name should be in pattern `/partition/ocsp_name`.
        :param pulumi.Input[builtins.str] passphrase: Specifies a passphrase used to sign an OCSP request.
        :param pulumi.Input[builtins.str] proxy_server_pool: Specifies the proxy server pool the BIG-IP system uses to fetch the OCSP response.
        :param pulumi.Input[builtins.str] responder_url: Specifies the URL of the OCSP responder.
        :param pulumi.Input[builtins.str] route_domain: Specifies the route domain for the OCSP responder.
        :param pulumi.Input[builtins.str] sign_hash: Specifies the hash algorithm used to sign the OCSP request. The default value is `sha256`.
        :param pulumi.Input[builtins.str] signer_cert: Specifies the certificate used to sign the OCSP request.
        :param pulumi.Input[builtins.str] signer_key: Specifies the key used to sign the OCSP request.
        :param pulumi.Input[builtins.int] status_age: Specifies the maximum allowed lag time that the BIG-IP system accepts for the 'thisUpdate' time in the OCSP response, in seconds. The default value is `0`.
        :param pulumi.Input[builtins.str] strict_resp_cert_check: Specifies whether the responder's certificate is checked for an OCSP signing extension. The default value is `enabled`.
        :param pulumi.Input[builtins.str] trusted_responders: Specifies the certificates used for validating the OCSP response.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OcspArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `sys.Ocsp` Manages F5 BIG-IP OCSP responder using iControl REST.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        test_ocsp = f5bigip.sys.Ocsp("test-ocsp",
            name="/Uncommon/test-ocsp",
            proxy_server_pool="/Common/test-poolxyz",
            signer_key="/Common/le-ssl",
            signer_cert="/Common/le-ssl",
            passphrase="testabcdef")
        ```

        ## Importing

        An existing OCSP can be imported into this resource by supplying the full path name  ex : `/partition/name`
        An example is below:
        ```sh
        $ terraform import bigip_sys_ocsp.test-ocsp /Common/test-ocsp
        ```

        :param str resource_name: The name of the resource.
        :param OcspArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OcspArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_error_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 cache_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 clock_skew: Optional[pulumi.Input[builtins.int]] = None,
                 concurrent_connections_limit: Optional[pulumi.Input[builtins.int]] = None,
                 connection_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 dns_resolver: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 passphrase: Optional[pulumi.Input[builtins.str]] = None,
                 proxy_server_pool: Optional[pulumi.Input[builtins.str]] = None,
                 responder_url: Optional[pulumi.Input[builtins.str]] = None,
                 route_domain: Optional[pulumi.Input[builtins.str]] = None,
                 sign_hash: Optional[pulumi.Input[builtins.str]] = None,
                 signer_cert: Optional[pulumi.Input[builtins.str]] = None,
                 signer_key: Optional[pulumi.Input[builtins.str]] = None,
                 status_age: Optional[pulumi.Input[builtins.int]] = None,
                 strict_resp_cert_check: Optional[pulumi.Input[builtins.str]] = None,
                 trusted_responders: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OcspArgs.__new__(OcspArgs)

            __props__.__dict__["cache_error_timeout"] = cache_error_timeout
            __props__.__dict__["cache_timeout"] = cache_timeout
            __props__.__dict__["clock_skew"] = clock_skew
            __props__.__dict__["concurrent_connections_limit"] = concurrent_connections_limit
            __props__.__dict__["connection_timeout"] = connection_timeout
            __props__.__dict__["dns_resolver"] = dns_resolver
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["passphrase"] = None if passphrase is None else pulumi.Output.secret(passphrase)
            __props__.__dict__["proxy_server_pool"] = proxy_server_pool
            __props__.__dict__["responder_url"] = responder_url
            __props__.__dict__["route_domain"] = route_domain
            __props__.__dict__["sign_hash"] = sign_hash
            __props__.__dict__["signer_cert"] = signer_cert
            __props__.__dict__["signer_key"] = signer_key
            __props__.__dict__["status_age"] = status_age
            __props__.__dict__["strict_resp_cert_check"] = strict_resp_cert_check
            __props__.__dict__["trusted_responders"] = trusted_responders
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["passphrase"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Ocsp, __self__).__init__(
            'f5bigip:sys/ocsp:Ocsp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cache_error_timeout: Optional[pulumi.Input[builtins.int]] = None,
            cache_timeout: Optional[pulumi.Input[builtins.str]] = None,
            clock_skew: Optional[pulumi.Input[builtins.int]] = None,
            concurrent_connections_limit: Optional[pulumi.Input[builtins.int]] = None,
            connection_timeout: Optional[pulumi.Input[builtins.int]] = None,
            dns_resolver: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            passphrase: Optional[pulumi.Input[builtins.str]] = None,
            proxy_server_pool: Optional[pulumi.Input[builtins.str]] = None,
            responder_url: Optional[pulumi.Input[builtins.str]] = None,
            route_domain: Optional[pulumi.Input[builtins.str]] = None,
            sign_hash: Optional[pulumi.Input[builtins.str]] = None,
            signer_cert: Optional[pulumi.Input[builtins.str]] = None,
            signer_key: Optional[pulumi.Input[builtins.str]] = None,
            status_age: Optional[pulumi.Input[builtins.int]] = None,
            strict_resp_cert_check: Optional[pulumi.Input[builtins.str]] = None,
            trusted_responders: Optional[pulumi.Input[builtins.str]] = None) -> 'Ocsp':
        """
        Get an existing Ocsp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] cache_error_timeout: Specifies the lifetime of an error response in the cache, in seconds. This value must be greater than connection_timeout. The default value is `3600`.
        :param pulumi.Input[builtins.str] cache_timeout: Specifies the lifetime of the OCSP response in the cache, in seconds. The default value is `indefinite`.
        :param pulumi.Input[builtins.int] clock_skew: Specifies the time interval that the BIG-IP system allows for clock skew, in seconds. The default value is `300`.
        :param pulumi.Input[builtins.int] concurrent_connections_limit: Specifies the maximum number of connections per second allowed for the OCSP certificate validator. The default value is `50`.
        :param pulumi.Input[builtins.int] connection_timeout: Specifies the time interval that the BIG-IP system waits for before ending the connection to the OCSP responder, in seconds. The default value is `8`.
        :param pulumi.Input[builtins.str] dns_resolver: Specifies the internal DNS resolver the BIG-IP system uses to fetch the OCSP response.
        :param pulumi.Input[builtins.str] name: Name of the OCSP Responder. Name should be in pattern `/partition/ocsp_name`.
        :param pulumi.Input[builtins.str] passphrase: Specifies a passphrase used to sign an OCSP request.
        :param pulumi.Input[builtins.str] proxy_server_pool: Specifies the proxy server pool the BIG-IP system uses to fetch the OCSP response.
        :param pulumi.Input[builtins.str] responder_url: Specifies the URL of the OCSP responder.
        :param pulumi.Input[builtins.str] route_domain: Specifies the route domain for the OCSP responder.
        :param pulumi.Input[builtins.str] sign_hash: Specifies the hash algorithm used to sign the OCSP request. The default value is `sha256`.
        :param pulumi.Input[builtins.str] signer_cert: Specifies the certificate used to sign the OCSP request.
        :param pulumi.Input[builtins.str] signer_key: Specifies the key used to sign the OCSP request.
        :param pulumi.Input[builtins.int] status_age: Specifies the maximum allowed lag time that the BIG-IP system accepts for the 'thisUpdate' time in the OCSP response, in seconds. The default value is `0`.
        :param pulumi.Input[builtins.str] strict_resp_cert_check: Specifies whether the responder's certificate is checked for an OCSP signing extension. The default value is `enabled`.
        :param pulumi.Input[builtins.str] trusted_responders: Specifies the certificates used for validating the OCSP response.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OcspState.__new__(_OcspState)

        __props__.__dict__["cache_error_timeout"] = cache_error_timeout
        __props__.__dict__["cache_timeout"] = cache_timeout
        __props__.__dict__["clock_skew"] = clock_skew
        __props__.__dict__["concurrent_connections_limit"] = concurrent_connections_limit
        __props__.__dict__["connection_timeout"] = connection_timeout
        __props__.__dict__["dns_resolver"] = dns_resolver
        __props__.__dict__["name"] = name
        __props__.__dict__["passphrase"] = passphrase
        __props__.__dict__["proxy_server_pool"] = proxy_server_pool
        __props__.__dict__["responder_url"] = responder_url
        __props__.__dict__["route_domain"] = route_domain
        __props__.__dict__["sign_hash"] = sign_hash
        __props__.__dict__["signer_cert"] = signer_cert
        __props__.__dict__["signer_key"] = signer_key
        __props__.__dict__["status_age"] = status_age
        __props__.__dict__["strict_resp_cert_check"] = strict_resp_cert_check
        __props__.__dict__["trusted_responders"] = trusted_responders
        return Ocsp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cacheErrorTimeout")
    def cache_error_timeout(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the lifetime of an error response in the cache, in seconds. This value must be greater than connection_timeout. The default value is `3600`.
        """
        return pulumi.get(self, "cache_error_timeout")

    @property
    @pulumi.getter(name="cacheTimeout")
    def cache_timeout(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the lifetime of the OCSP response in the cache, in seconds. The default value is `indefinite`.
        """
        return pulumi.get(self, "cache_timeout")

    @property
    @pulumi.getter(name="clockSkew")
    def clock_skew(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the time interval that the BIG-IP system allows for clock skew, in seconds. The default value is `300`.
        """
        return pulumi.get(self, "clock_skew")

    @property
    @pulumi.getter(name="concurrentConnectionsLimit")
    def concurrent_connections_limit(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the maximum number of connections per second allowed for the OCSP certificate validator. The default value is `50`.
        """
        return pulumi.get(self, "concurrent_connections_limit")

    @property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the time interval that the BIG-IP system waits for before ending the connection to the OCSP responder, in seconds. The default value is `8`.
        """
        return pulumi.get(self, "connection_timeout")

    @property
    @pulumi.getter(name="dnsResolver")
    def dns_resolver(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the internal DNS resolver the BIG-IP system uses to fetch the OCSP response.
        """
        return pulumi.get(self, "dns_resolver")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the OCSP Responder. Name should be in pattern `/partition/ocsp_name`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def passphrase(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies a passphrase used to sign an OCSP request.
        """
        return pulumi.get(self, "passphrase")

    @property
    @pulumi.getter(name="proxyServerPool")
    def proxy_server_pool(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the proxy server pool the BIG-IP system uses to fetch the OCSP response.
        """
        return pulumi.get(self, "proxy_server_pool")

    @property
    @pulumi.getter(name="responderUrl")
    def responder_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the URL of the OCSP responder.
        """
        return pulumi.get(self, "responder_url")

    @property
    @pulumi.getter(name="routeDomain")
    def route_domain(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the route domain for the OCSP responder.
        """
        return pulumi.get(self, "route_domain")

    @property
    @pulumi.getter(name="signHash")
    def sign_hash(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the hash algorithm used to sign the OCSP request. The default value is `sha256`.
        """
        return pulumi.get(self, "sign_hash")

    @property
    @pulumi.getter(name="signerCert")
    def signer_cert(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the certificate used to sign the OCSP request.
        """
        return pulumi.get(self, "signer_cert")

    @property
    @pulumi.getter(name="signerKey")
    def signer_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the key used to sign the OCSP request.
        """
        return pulumi.get(self, "signer_key")

    @property
    @pulumi.getter(name="statusAge")
    def status_age(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the maximum allowed lag time that the BIG-IP system accepts for the 'thisUpdate' time in the OCSP response, in seconds. The default value is `0`.
        """
        return pulumi.get(self, "status_age")

    @property
    @pulumi.getter(name="strictRespCertCheck")
    def strict_resp_cert_check(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies whether the responder's certificate is checked for an OCSP signing extension. The default value is `enabled`.
        """
        return pulumi.get(self, "strict_resp_cert_check")

    @property
    @pulumi.getter(name="trustedResponders")
    def trusted_responders(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the certificates used for validating the OCSP response.
        """
        return pulumi.get(self, "trusted_responders")

