# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GuestArgs', 'Guest']

@pulumi.input_type
class GuestArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 allowed_slots: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 cores_per_slot: Optional[pulumi.Input[builtins.int]] = None,
                 delete_virtual_disk: Optional[pulumi.Input[builtins.bool]] = None,
                 initial_hotfix: Optional[pulumi.Input[builtins.str]] = None,
                 initial_image: Optional[pulumi.Input[builtins.str]] = None,
                 mgmt_address: Optional[pulumi.Input[builtins.str]] = None,
                 mgmt_network: Optional[pulumi.Input[builtins.str]] = None,
                 mgmt_route: Optional[pulumi.Input[builtins.str]] = None,
                 min_number_of_slots: Optional[pulumi.Input[builtins.int]] = None,
                 number_of_slots: Optional[pulumi.Input[builtins.int]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 vlans: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Guest resource.
        :param pulumi.Input[builtins.str] name: Name of the vCMP guest
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] allowed_slots: Contains those slots to which the guest is allowed to be assigned.
        :param pulumi.Input[builtins.int] cores_per_slot: Specifies the number of cores the system allocates to the guest.
        :param pulumi.Input[builtins.bool] delete_virtual_disk: Indicates if virtual disk associated with vCMP guest should be removed during remove operation.  The default is `true`
        :param pulumi.Input[builtins.str] initial_hotfix: Specifies the hotfix ISO image file which is applied on top of the base image.
        :param pulumi.Input[builtins.str] initial_image: Specifies the base software release ISO image file for installing the TMOS hypervisor instance.
        :param pulumi.Input[builtins.str] mgmt_address: Specifies the IP address and subnet or subnet mask you use to access the guest when you want to manage a module running within the guest.
        :param pulumi.Input[builtins.str] mgmt_network: Specifies the method by which the management address is used in the vCMP guest. options : [`bridged`,`isolated`,`host-only`].
        :param pulumi.Input[builtins.str] mgmt_route: Specifies the gateway address for the `mgmt_address`. Can be set to `none` to remove the value from the configuration.
        :param pulumi.Input[builtins.int] min_number_of_slots: Specifies the minimum number of slots the guest must be assigned to in order to deploy.
        :param pulumi.Input[builtins.int] number_of_slots: Specifies the number of slots for the system to use when creating the guest.
        :param pulumi.Input[builtins.str] state: Specifies the state of the vCMP guest on the system. options : [`configured`,`provisioned`,`deployed`].
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vlans: Specifies the list of VLANs the vCMP guest uses to communicate with other guests, the host, and with the external network. The naming format must be the combination of the partition + name. For example /Common/my-vlan
        """
        pulumi.set(__self__, "name", name)
        if allowed_slots is not None:
            pulumi.set(__self__, "allowed_slots", allowed_slots)
        if cores_per_slot is not None:
            pulumi.set(__self__, "cores_per_slot", cores_per_slot)
        if delete_virtual_disk is not None:
            pulumi.set(__self__, "delete_virtual_disk", delete_virtual_disk)
        if initial_hotfix is not None:
            pulumi.set(__self__, "initial_hotfix", initial_hotfix)
        if initial_image is not None:
            pulumi.set(__self__, "initial_image", initial_image)
        if mgmt_address is not None:
            pulumi.set(__self__, "mgmt_address", mgmt_address)
        if mgmt_network is not None:
            pulumi.set(__self__, "mgmt_network", mgmt_network)
        if mgmt_route is not None:
            pulumi.set(__self__, "mgmt_route", mgmt_route)
        if min_number_of_slots is not None:
            pulumi.set(__self__, "min_number_of_slots", min_number_of_slots)
        if number_of_slots is not None:
            pulumi.set(__self__, "number_of_slots", number_of_slots)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if vlans is not None:
            pulumi.set(__self__, "vlans", vlans)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the vCMP guest
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="allowedSlots")
    def allowed_slots(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        Contains those slots to which the guest is allowed to be assigned.
        """
        return pulumi.get(self, "allowed_slots")

    @allowed_slots.setter
    def allowed_slots(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "allowed_slots", value)

    @property
    @pulumi.getter(name="coresPerSlot")
    def cores_per_slot(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of cores the system allocates to the guest.
        """
        return pulumi.get(self, "cores_per_slot")

    @cores_per_slot.setter
    def cores_per_slot(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cores_per_slot", value)

    @property
    @pulumi.getter(name="deleteVirtualDisk")
    def delete_virtual_disk(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates if virtual disk associated with vCMP guest should be removed during remove operation.  The default is `true`
        """
        return pulumi.get(self, "delete_virtual_disk")

    @delete_virtual_disk.setter
    def delete_virtual_disk(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_virtual_disk", value)

    @property
    @pulumi.getter(name="initialHotfix")
    def initial_hotfix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the hotfix ISO image file which is applied on top of the base image.
        """
        return pulumi.get(self, "initial_hotfix")

    @initial_hotfix.setter
    def initial_hotfix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "initial_hotfix", value)

    @property
    @pulumi.getter(name="initialImage")
    def initial_image(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the base software release ISO image file for installing the TMOS hypervisor instance.
        """
        return pulumi.get(self, "initial_image")

    @initial_image.setter
    def initial_image(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "initial_image", value)

    @property
    @pulumi.getter(name="mgmtAddress")
    def mgmt_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the IP address and subnet or subnet mask you use to access the guest when you want to manage a module running within the guest.
        """
        return pulumi.get(self, "mgmt_address")

    @mgmt_address.setter
    def mgmt_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mgmt_address", value)

    @property
    @pulumi.getter(name="mgmtNetwork")
    def mgmt_network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the method by which the management address is used in the vCMP guest. options : [`bridged`,`isolated`,`host-only`].
        """
        return pulumi.get(self, "mgmt_network")

    @mgmt_network.setter
    def mgmt_network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mgmt_network", value)

    @property
    @pulumi.getter(name="mgmtRoute")
    def mgmt_route(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the gateway address for the `mgmt_address`. Can be set to `none` to remove the value from the configuration.
        """
        return pulumi.get(self, "mgmt_route")

    @mgmt_route.setter
    def mgmt_route(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mgmt_route", value)

    @property
    @pulumi.getter(name="minNumberOfSlots")
    def min_number_of_slots(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the minimum number of slots the guest must be assigned to in order to deploy.
        """
        return pulumi.get(self, "min_number_of_slots")

    @min_number_of_slots.setter
    def min_number_of_slots(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_number_of_slots", value)

    @property
    @pulumi.getter(name="numberOfSlots")
    def number_of_slots(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of slots for the system to use when creating the guest.
        """
        return pulumi.get(self, "number_of_slots")

    @number_of_slots.setter
    def number_of_slots(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "number_of_slots", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the state of the vCMP guest on the system. options : [`configured`,`provisioned`,`deployed`].
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def vlans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the list of VLANs the vCMP guest uses to communicate with other guests, the host, and with the external network. The naming format must be the combination of the partition + name. For example /Common/my-vlan
        """
        return pulumi.get(self, "vlans")

    @vlans.setter
    def vlans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "vlans", value)


@pulumi.input_type
class _GuestState:
    def __init__(__self__, *,
                 allowed_slots: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 cores_per_slot: Optional[pulumi.Input[builtins.int]] = None,
                 delete_virtual_disk: Optional[pulumi.Input[builtins.bool]] = None,
                 full_path: Optional[pulumi.Input[builtins.str]] = None,
                 initial_hotfix: Optional[pulumi.Input[builtins.str]] = None,
                 initial_image: Optional[pulumi.Input[builtins.str]] = None,
                 mgmt_address: Optional[pulumi.Input[builtins.str]] = None,
                 mgmt_network: Optional[pulumi.Input[builtins.str]] = None,
                 mgmt_route: Optional[pulumi.Input[builtins.str]] = None,
                 min_number_of_slots: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 number_of_slots: Optional[pulumi.Input[builtins.int]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_disk: Optional[pulumi.Input[builtins.str]] = None,
                 vlans: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Guest resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] allowed_slots: Contains those slots to which the guest is allowed to be assigned.
        :param pulumi.Input[builtins.int] cores_per_slot: Specifies the number of cores the system allocates to the guest.
        :param pulumi.Input[builtins.bool] delete_virtual_disk: Indicates if virtual disk associated with vCMP guest should be removed during remove operation.  The default is `true`
        :param pulumi.Input[builtins.str] full_path: Resource name including prepended partition path.
        :param pulumi.Input[builtins.str] initial_hotfix: Specifies the hotfix ISO image file which is applied on top of the base image.
        :param pulumi.Input[builtins.str] initial_image: Specifies the base software release ISO image file for installing the TMOS hypervisor instance.
        :param pulumi.Input[builtins.str] mgmt_address: Specifies the IP address and subnet or subnet mask you use to access the guest when you want to manage a module running within the guest.
        :param pulumi.Input[builtins.str] mgmt_network: Specifies the method by which the management address is used in the vCMP guest. options : [`bridged`,`isolated`,`host-only`].
        :param pulumi.Input[builtins.str] mgmt_route: Specifies the gateway address for the `mgmt_address`. Can be set to `none` to remove the value from the configuration.
        :param pulumi.Input[builtins.int] min_number_of_slots: Specifies the minimum number of slots the guest must be assigned to in order to deploy.
        :param pulumi.Input[builtins.str] name: Name of the vCMP guest
        :param pulumi.Input[builtins.int] number_of_slots: Specifies the number of slots for the system to use when creating the guest.
        :param pulumi.Input[builtins.str] state: Specifies the state of the vCMP guest on the system. options : [`configured`,`provisioned`,`deployed`].
        :param pulumi.Input[builtins.str] virtual_disk: Virtual disk associated with vCMP guest.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vlans: Specifies the list of VLANs the vCMP guest uses to communicate with other guests, the host, and with the external network. The naming format must be the combination of the partition + name. For example /Common/my-vlan
        """
        if allowed_slots is not None:
            pulumi.set(__self__, "allowed_slots", allowed_slots)
        if cores_per_slot is not None:
            pulumi.set(__self__, "cores_per_slot", cores_per_slot)
        if delete_virtual_disk is not None:
            pulumi.set(__self__, "delete_virtual_disk", delete_virtual_disk)
        if full_path is not None:
            pulumi.set(__self__, "full_path", full_path)
        if initial_hotfix is not None:
            pulumi.set(__self__, "initial_hotfix", initial_hotfix)
        if initial_image is not None:
            pulumi.set(__self__, "initial_image", initial_image)
        if mgmt_address is not None:
            pulumi.set(__self__, "mgmt_address", mgmt_address)
        if mgmt_network is not None:
            pulumi.set(__self__, "mgmt_network", mgmt_network)
        if mgmt_route is not None:
            pulumi.set(__self__, "mgmt_route", mgmt_route)
        if min_number_of_slots is not None:
            pulumi.set(__self__, "min_number_of_slots", min_number_of_slots)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_slots is not None:
            pulumi.set(__self__, "number_of_slots", number_of_slots)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if virtual_disk is not None:
            pulumi.set(__self__, "virtual_disk", virtual_disk)
        if vlans is not None:
            pulumi.set(__self__, "vlans", vlans)

    @property
    @pulumi.getter(name="allowedSlots")
    def allowed_slots(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        Contains those slots to which the guest is allowed to be assigned.
        """
        return pulumi.get(self, "allowed_slots")

    @allowed_slots.setter
    def allowed_slots(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "allowed_slots", value)

    @property
    @pulumi.getter(name="coresPerSlot")
    def cores_per_slot(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of cores the system allocates to the guest.
        """
        return pulumi.get(self, "cores_per_slot")

    @cores_per_slot.setter
    def cores_per_slot(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cores_per_slot", value)

    @property
    @pulumi.getter(name="deleteVirtualDisk")
    def delete_virtual_disk(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates if virtual disk associated with vCMP guest should be removed during remove operation.  The default is `true`
        """
        return pulumi.get(self, "delete_virtual_disk")

    @delete_virtual_disk.setter
    def delete_virtual_disk(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_virtual_disk", value)

    @property
    @pulumi.getter(name="fullPath")
    def full_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource name including prepended partition path.
        """
        return pulumi.get(self, "full_path")

    @full_path.setter
    def full_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "full_path", value)

    @property
    @pulumi.getter(name="initialHotfix")
    def initial_hotfix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the hotfix ISO image file which is applied on top of the base image.
        """
        return pulumi.get(self, "initial_hotfix")

    @initial_hotfix.setter
    def initial_hotfix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "initial_hotfix", value)

    @property
    @pulumi.getter(name="initialImage")
    def initial_image(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the base software release ISO image file for installing the TMOS hypervisor instance.
        """
        return pulumi.get(self, "initial_image")

    @initial_image.setter
    def initial_image(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "initial_image", value)

    @property
    @pulumi.getter(name="mgmtAddress")
    def mgmt_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the IP address and subnet or subnet mask you use to access the guest when you want to manage a module running within the guest.
        """
        return pulumi.get(self, "mgmt_address")

    @mgmt_address.setter
    def mgmt_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mgmt_address", value)

    @property
    @pulumi.getter(name="mgmtNetwork")
    def mgmt_network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the method by which the management address is used in the vCMP guest. options : [`bridged`,`isolated`,`host-only`].
        """
        return pulumi.get(self, "mgmt_network")

    @mgmt_network.setter
    def mgmt_network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mgmt_network", value)

    @property
    @pulumi.getter(name="mgmtRoute")
    def mgmt_route(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the gateway address for the `mgmt_address`. Can be set to `none` to remove the value from the configuration.
        """
        return pulumi.get(self, "mgmt_route")

    @mgmt_route.setter
    def mgmt_route(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mgmt_route", value)

    @property
    @pulumi.getter(name="minNumberOfSlots")
    def min_number_of_slots(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the minimum number of slots the guest must be assigned to in order to deploy.
        """
        return pulumi.get(self, "min_number_of_slots")

    @min_number_of_slots.setter
    def min_number_of_slots(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_number_of_slots", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the vCMP guest
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numberOfSlots")
    def number_of_slots(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of slots for the system to use when creating the guest.
        """
        return pulumi.get(self, "number_of_slots")

    @number_of_slots.setter
    def number_of_slots(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "number_of_slots", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the state of the vCMP guest on the system. options : [`configured`,`provisioned`,`deployed`].
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="virtualDisk")
    def virtual_disk(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Virtual disk associated with vCMP guest.
        """
        return pulumi.get(self, "virtual_disk")

    @virtual_disk.setter
    def virtual_disk(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "virtual_disk", value)

    @property
    @pulumi.getter
    def vlans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the list of VLANs the vCMP guest uses to communicate with other guests, the host, and with the external network. The naming format must be the combination of the partition + name. For example /Common/my-vlan
        """
        return pulumi.get(self, "vlans")

    @vlans.setter
    def vlans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "vlans", value)


@pulumi.type_token("f5bigip:vcmp/guest:Guest")
class Guest(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_slots: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 cores_per_slot: Optional[pulumi.Input[builtins.int]] = None,
                 delete_virtual_disk: Optional[pulumi.Input[builtins.bool]] = None,
                 initial_hotfix: Optional[pulumi.Input[builtins.str]] = None,
                 initial_image: Optional[pulumi.Input[builtins.str]] = None,
                 mgmt_address: Optional[pulumi.Input[builtins.str]] = None,
                 mgmt_network: Optional[pulumi.Input[builtins.str]] = None,
                 mgmt_route: Optional[pulumi.Input[builtins.str]] = None,
                 min_number_of_slots: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 number_of_slots: Optional[pulumi.Input[builtins.int]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 vlans: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        `vcmp.Guest` Manages a vCMP guest configuration

        Resource does not wait for vCMP guest to reach the desired state, it only ensures that a desired configuration is set on the target device.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        vcmp_test = f5bigip.vcmp.Guest("vcmp-test",
            name="tf_guest",
            initial_image="12.1.2.iso",
            mgmt_network="bridged",
            mgmt_address="10.1.1.1/24",
            mgmt_route="none",
            state="provisioned",
            cores_per_slot=2,
            number_of_slots=1,
            min_number_of_slots=1)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] allowed_slots: Contains those slots to which the guest is allowed to be assigned.
        :param pulumi.Input[builtins.int] cores_per_slot: Specifies the number of cores the system allocates to the guest.
        :param pulumi.Input[builtins.bool] delete_virtual_disk: Indicates if virtual disk associated with vCMP guest should be removed during remove operation.  The default is `true`
        :param pulumi.Input[builtins.str] initial_hotfix: Specifies the hotfix ISO image file which is applied on top of the base image.
        :param pulumi.Input[builtins.str] initial_image: Specifies the base software release ISO image file for installing the TMOS hypervisor instance.
        :param pulumi.Input[builtins.str] mgmt_address: Specifies the IP address and subnet or subnet mask you use to access the guest when you want to manage a module running within the guest.
        :param pulumi.Input[builtins.str] mgmt_network: Specifies the method by which the management address is used in the vCMP guest. options : [`bridged`,`isolated`,`host-only`].
        :param pulumi.Input[builtins.str] mgmt_route: Specifies the gateway address for the `mgmt_address`. Can be set to `none` to remove the value from the configuration.
        :param pulumi.Input[builtins.int] min_number_of_slots: Specifies the minimum number of slots the guest must be assigned to in order to deploy.
        :param pulumi.Input[builtins.str] name: Name of the vCMP guest
        :param pulumi.Input[builtins.int] number_of_slots: Specifies the number of slots for the system to use when creating the guest.
        :param pulumi.Input[builtins.str] state: Specifies the state of the vCMP guest on the system. options : [`configured`,`provisioned`,`deployed`].
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vlans: Specifies the list of VLANs the vCMP guest uses to communicate with other guests, the host, and with the external network. The naming format must be the combination of the partition + name. For example /Common/my-vlan
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GuestArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `vcmp.Guest` Manages a vCMP guest configuration

        Resource does not wait for vCMP guest to reach the desired state, it only ensures that a desired configuration is set on the target device.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        vcmp_test = f5bigip.vcmp.Guest("vcmp-test",
            name="tf_guest",
            initial_image="12.1.2.iso",
            mgmt_network="bridged",
            mgmt_address="10.1.1.1/24",
            mgmt_route="none",
            state="provisioned",
            cores_per_slot=2,
            number_of_slots=1,
            min_number_of_slots=1)
        ```

        :param str resource_name: The name of the resource.
        :param GuestArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GuestArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_slots: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 cores_per_slot: Optional[pulumi.Input[builtins.int]] = None,
                 delete_virtual_disk: Optional[pulumi.Input[builtins.bool]] = None,
                 initial_hotfix: Optional[pulumi.Input[builtins.str]] = None,
                 initial_image: Optional[pulumi.Input[builtins.str]] = None,
                 mgmt_address: Optional[pulumi.Input[builtins.str]] = None,
                 mgmt_network: Optional[pulumi.Input[builtins.str]] = None,
                 mgmt_route: Optional[pulumi.Input[builtins.str]] = None,
                 min_number_of_slots: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 number_of_slots: Optional[pulumi.Input[builtins.int]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 vlans: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GuestArgs.__new__(GuestArgs)

            __props__.__dict__["allowed_slots"] = allowed_slots
            __props__.__dict__["cores_per_slot"] = cores_per_slot
            __props__.__dict__["delete_virtual_disk"] = delete_virtual_disk
            __props__.__dict__["initial_hotfix"] = initial_hotfix
            __props__.__dict__["initial_image"] = initial_image
            __props__.__dict__["mgmt_address"] = mgmt_address
            __props__.__dict__["mgmt_network"] = mgmt_network
            __props__.__dict__["mgmt_route"] = mgmt_route
            __props__.__dict__["min_number_of_slots"] = min_number_of_slots
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["number_of_slots"] = number_of_slots
            __props__.__dict__["state"] = state
            __props__.__dict__["vlans"] = vlans
            __props__.__dict__["full_path"] = None
            __props__.__dict__["virtual_disk"] = None
        super(Guest, __self__).__init__(
            'f5bigip:vcmp/guest:Guest',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_slots: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
            cores_per_slot: Optional[pulumi.Input[builtins.int]] = None,
            delete_virtual_disk: Optional[pulumi.Input[builtins.bool]] = None,
            full_path: Optional[pulumi.Input[builtins.str]] = None,
            initial_hotfix: Optional[pulumi.Input[builtins.str]] = None,
            initial_image: Optional[pulumi.Input[builtins.str]] = None,
            mgmt_address: Optional[pulumi.Input[builtins.str]] = None,
            mgmt_network: Optional[pulumi.Input[builtins.str]] = None,
            mgmt_route: Optional[pulumi.Input[builtins.str]] = None,
            min_number_of_slots: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            number_of_slots: Optional[pulumi.Input[builtins.int]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            virtual_disk: Optional[pulumi.Input[builtins.str]] = None,
            vlans: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'Guest':
        """
        Get an existing Guest resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] allowed_slots: Contains those slots to which the guest is allowed to be assigned.
        :param pulumi.Input[builtins.int] cores_per_slot: Specifies the number of cores the system allocates to the guest.
        :param pulumi.Input[builtins.bool] delete_virtual_disk: Indicates if virtual disk associated with vCMP guest should be removed during remove operation.  The default is `true`
        :param pulumi.Input[builtins.str] full_path: Resource name including prepended partition path.
        :param pulumi.Input[builtins.str] initial_hotfix: Specifies the hotfix ISO image file which is applied on top of the base image.
        :param pulumi.Input[builtins.str] initial_image: Specifies the base software release ISO image file for installing the TMOS hypervisor instance.
        :param pulumi.Input[builtins.str] mgmt_address: Specifies the IP address and subnet or subnet mask you use to access the guest when you want to manage a module running within the guest.
        :param pulumi.Input[builtins.str] mgmt_network: Specifies the method by which the management address is used in the vCMP guest. options : [`bridged`,`isolated`,`host-only`].
        :param pulumi.Input[builtins.str] mgmt_route: Specifies the gateway address for the `mgmt_address`. Can be set to `none` to remove the value from the configuration.
        :param pulumi.Input[builtins.int] min_number_of_slots: Specifies the minimum number of slots the guest must be assigned to in order to deploy.
        :param pulumi.Input[builtins.str] name: Name of the vCMP guest
        :param pulumi.Input[builtins.int] number_of_slots: Specifies the number of slots for the system to use when creating the guest.
        :param pulumi.Input[builtins.str] state: Specifies the state of the vCMP guest on the system. options : [`configured`,`provisioned`,`deployed`].
        :param pulumi.Input[builtins.str] virtual_disk: Virtual disk associated with vCMP guest.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vlans: Specifies the list of VLANs the vCMP guest uses to communicate with other guests, the host, and with the external network. The naming format must be the combination of the partition + name. For example /Common/my-vlan
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GuestState.__new__(_GuestState)

        __props__.__dict__["allowed_slots"] = allowed_slots
        __props__.__dict__["cores_per_slot"] = cores_per_slot
        __props__.__dict__["delete_virtual_disk"] = delete_virtual_disk
        __props__.__dict__["full_path"] = full_path
        __props__.__dict__["initial_hotfix"] = initial_hotfix
        __props__.__dict__["initial_image"] = initial_image
        __props__.__dict__["mgmt_address"] = mgmt_address
        __props__.__dict__["mgmt_network"] = mgmt_network
        __props__.__dict__["mgmt_route"] = mgmt_route
        __props__.__dict__["min_number_of_slots"] = min_number_of_slots
        __props__.__dict__["name"] = name
        __props__.__dict__["number_of_slots"] = number_of_slots
        __props__.__dict__["state"] = state
        __props__.__dict__["virtual_disk"] = virtual_disk
        __props__.__dict__["vlans"] = vlans
        return Guest(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedSlots")
    def allowed_slots(self) -> pulumi.Output[Sequence[builtins.int]]:
        """
        Contains those slots to which the guest is allowed to be assigned.
        """
        return pulumi.get(self, "allowed_slots")

    @property
    @pulumi.getter(name="coresPerSlot")
    def cores_per_slot(self) -> pulumi.Output[builtins.int]:
        """
        Specifies the number of cores the system allocates to the guest.
        """
        return pulumi.get(self, "cores_per_slot")

    @property
    @pulumi.getter(name="deleteVirtualDisk")
    def delete_virtual_disk(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates if virtual disk associated with vCMP guest should be removed during remove operation.  The default is `true`
        """
        return pulumi.get(self, "delete_virtual_disk")

    @property
    @pulumi.getter(name="fullPath")
    def full_path(self) -> pulumi.Output[builtins.str]:
        """
        Resource name including prepended partition path.
        """
        return pulumi.get(self, "full_path")

    @property
    @pulumi.getter(name="initialHotfix")
    def initial_hotfix(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the hotfix ISO image file which is applied on top of the base image.
        """
        return pulumi.get(self, "initial_hotfix")

    @property
    @pulumi.getter(name="initialImage")
    def initial_image(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the base software release ISO image file for installing the TMOS hypervisor instance.
        """
        return pulumi.get(self, "initial_image")

    @property
    @pulumi.getter(name="mgmtAddress")
    def mgmt_address(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the IP address and subnet or subnet mask you use to access the guest when you want to manage a module running within the guest.
        """
        return pulumi.get(self, "mgmt_address")

    @property
    @pulumi.getter(name="mgmtNetwork")
    def mgmt_network(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the method by which the management address is used in the vCMP guest. options : [`bridged`,`isolated`,`host-only`].
        """
        return pulumi.get(self, "mgmt_network")

    @property
    @pulumi.getter(name="mgmtRoute")
    def mgmt_route(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the gateway address for the `mgmt_address`. Can be set to `none` to remove the value from the configuration.
        """
        return pulumi.get(self, "mgmt_route")

    @property
    @pulumi.getter(name="minNumberOfSlots")
    def min_number_of_slots(self) -> pulumi.Output[builtins.int]:
        """
        Specifies the minimum number of slots the guest must be assigned to in order to deploy.
        """
        return pulumi.get(self, "min_number_of_slots")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the vCMP guest
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numberOfSlots")
    def number_of_slots(self) -> pulumi.Output[builtins.int]:
        """
        Specifies the number of slots for the system to use when creating the guest.
        """
        return pulumi.get(self, "number_of_slots")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the state of the vCMP guest on the system. options : [`configured`,`provisioned`,`deployed`].
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="virtualDisk")
    def virtual_disk(self) -> pulumi.Output[builtins.str]:
        """
        Virtual disk associated with vCMP guest.
        """
        return pulumi.get(self, "virtual_disk")

    @property
    @pulumi.getter
    def vlans(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Specifies the list of VLANs the vCMP guest uses to communicate with other guests, the host, and with the external network. The naming format must be the combination of the partition + name. For example /Common/my-vlan
        """
        return pulumi.get(self, "vlans")

