# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WafPolicyArgs', 'WafPolicy']

@pulumi.input_type
class WafPolicyArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 template_name: pulumi.Input[builtins.str],
                 application_language: Optional[pulumi.Input[builtins.str]] = None,
                 case_insensitive: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_passivemode: Optional[pulumi.Input[builtins.bool]] = None,
                 enforcement_mode: Optional[pulumi.Input[builtins.str]] = None,
                 file_types: Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyFileTypeArgs']]]] = None,
                 graphql_profiles: Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyGraphqlProfileArgs']]]] = None,
                 host_names: Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyHostNameArgs']]]] = None,
                 ip_exceptions: Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyIpExceptionArgs']]]] = None,
                 modifications: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 open_api_files: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 partition: Optional[pulumi.Input[builtins.str]] = None,
                 policy_builders: Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyPolicyBuilderArgs']]]] = None,
                 policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 policy_import_json: Optional[pulumi.Input[builtins.str]] = None,
                 protocol_independent: Optional[pulumi.Input[builtins.bool]] = None,
                 server_technologies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 signature_sets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 signatures: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 signatures_settings: Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicySignaturesSettingArgs']]]] = None,
                 template_link: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a WafPolicy resource.
        :param pulumi.Input[builtins.str] name: The unique user-given name of the policy. Policy names cannot contain spaces or special characters. Allowed characters are a-z, A-Z, 0-9, dot, dash (-), colon (:) and underscore (_).
        :param pulumi.Input[builtins.str] template_name: Specifies the name of the template used for the policy creation.
        :param pulumi.Input[builtins.str] application_language: The character encoding for the web application. The character encoding determines how the policy processes the character sets. The default is `utf-8`
        :param pulumi.Input[builtins.bool] case_insensitive: Specifies whether the security policy treats microservice URLs, file types, URLs, and parameters as case sensitive or not. When this setting is enabled, the system stores these security policy elements in lowercase in the security policy configuration
        :param pulumi.Input[builtins.str] description: Specifies the description of the policy.
        :param pulumi.Input[builtins.bool] enable_passivemode: Passive Mode allows the policy to be associated with a Performance L4 Virtual Server (using a FastL4 profile). With FastL4, traffic is analyzed but is not modified in any way.
        :param pulumi.Input[builtins.str] enforcement_mode: How the system processes a request that triggers a security policy violation
        :param pulumi.Input[Sequence[pulumi.Input['WafPolicyFileTypeArgs']]] file_types: `file_types` takes list of file-types options to be used for policy builder.
               See file types below for more details.
        :param pulumi.Input[Sequence[pulumi.Input['WafPolicyGraphqlProfileArgs']]] graphql_profiles: `graphql_profiles` takes list of graphql profile options to be used for policy builder.
               See graphql profiles below for more details.
        :param pulumi.Input[Sequence[pulumi.Input['WafPolicyHostNameArgs']]] host_names: specify the list of host name that is used to access the application
        :param pulumi.Input[Sequence[pulumi.Input['WafPolicyIpExceptionArgs']]] ip_exceptions: `ip_exceptions` takes list of IP address exception,An IP address exception is an IP address that you want the system to treat in a specific way for a security policy.For example, you can specify IP addresses from which the system should always trust traffic.
               See IP Exceptions below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] modifications: the modifications section includes actions that modify the declarative policy as it is defined in the adjustments
               section. The modifications section is updated manually, with the changes generally driven by the learning suggestions
               provided by the BIG-IP.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] open_api_files: This section defines the Link for open api files on the policy.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] parameters: This section defines parameters that the security policy permits in requests.
        :param pulumi.Input[builtins.str] partition: Specifies the partition of the policy. Default is `Common`
        :param pulumi.Input[Sequence[pulumi.Input['WafPolicyPolicyBuilderArgs']]] policy_builders: `policy_builder` block will provide `learning_mode` options to be used for policy builder.
               See policy builder below for more details.
        :param pulumi.Input[builtins.str] policy_id: The id of the A.WAF Policy as it would be calculated on the BIG-IP.
        :param pulumi.Input[builtins.str] policy_import_json: The payload of the WAF Policy to be used for IMPORT on to BIG-IP.
        :param pulumi.Input[builtins.bool] protocol_independent: When creating a security policy, you can determine whether a security policy differentiates between HTTP and HTTPS URLs. If enabled, the security policy differentiates between HTTP and HTTPS URLs. If disabled, the security policy configures URLs without specifying a specific protocol. This is useful for applications that behave the same for HTTP and HTTPS, and it keeps the security policy from including the same URL twice.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] server_technologies: The server technology is a server-side application, framework, web server or operating system type that is configured in the policy in order to adapt the policy to the checks needed for the respective technology.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] signature_sets: Defines behavior when signatures found within a signature-set are detected in a request. Settings are culmulative, so if a signature is found in any set with block enabled, that signature will have block enabled.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] signatures: This section defines the properties of a signature on the policy.
        :param pulumi.Input[Sequence[pulumi.Input['WafPolicySignaturesSettingArgs']]] signatures_settings: bulk signature setting
        :param pulumi.Input[builtins.str] template_link: Specifies the Link of the template used for the policy creation.
        :param pulumi.Input[builtins.str] type: The type of policy you want to create. The default policy type is `security`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] urls: In a security policy, you can manually specify the HTTP URLs that are allowed (or disallowed) in traffic to the web application being protected. If you are using automatic policy building (and the policy includes learning URLs), the system can determine which URLs to add, based on legitimate traffic.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "template_name", template_name)
        if application_language is not None:
            pulumi.set(__self__, "application_language", application_language)
        if case_insensitive is not None:
            pulumi.set(__self__, "case_insensitive", case_insensitive)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_passivemode is not None:
            pulumi.set(__self__, "enable_passivemode", enable_passivemode)
        if enforcement_mode is not None:
            pulumi.set(__self__, "enforcement_mode", enforcement_mode)
        if file_types is not None:
            pulumi.set(__self__, "file_types", file_types)
        if graphql_profiles is not None:
            pulumi.set(__self__, "graphql_profiles", graphql_profiles)
        if host_names is not None:
            pulumi.set(__self__, "host_names", host_names)
        if ip_exceptions is not None:
            pulumi.set(__self__, "ip_exceptions", ip_exceptions)
        if modifications is not None:
            pulumi.set(__self__, "modifications", modifications)
        if open_api_files is not None:
            pulumi.set(__self__, "open_api_files", open_api_files)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if policy_builders is not None:
            pulumi.set(__self__, "policy_builders", policy_builders)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if policy_import_json is not None:
            pulumi.set(__self__, "policy_import_json", policy_import_json)
        if protocol_independent is not None:
            pulumi.set(__self__, "protocol_independent", protocol_independent)
        if server_technologies is not None:
            pulumi.set(__self__, "server_technologies", server_technologies)
        if signature_sets is not None:
            pulumi.set(__self__, "signature_sets", signature_sets)
        if signatures is not None:
            pulumi.set(__self__, "signatures", signatures)
        if signatures_settings is not None:
            pulumi.set(__self__, "signatures_settings", signatures_settings)
        if template_link is not None:
            pulumi.set(__self__, "template_link", template_link)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if urls is not None:
            pulumi.set(__self__, "urls", urls)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The unique user-given name of the policy. Policy names cannot contain spaces or special characters. Allowed characters are a-z, A-Z, 0-9, dot, dash (-), colon (:) and underscore (_).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the name of the template used for the policy creation.
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "template_name", value)

    @property
    @pulumi.getter(name="applicationLanguage")
    def application_language(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The character encoding for the web application. The character encoding determines how the policy processes the character sets. The default is `utf-8`
        """
        return pulumi.get(self, "application_language")

    @application_language.setter
    def application_language(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_language", value)

    @property
    @pulumi.getter(name="caseInsensitive")
    def case_insensitive(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the security policy treats microservice URLs, file types, URLs, and parameters as case sensitive or not. When this setting is enabled, the system stores these security policy elements in lowercase in the security policy configuration
        """
        return pulumi.get(self, "case_insensitive")

    @case_insensitive.setter
    def case_insensitive(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "case_insensitive", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the description of the policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enablePassivemode")
    def enable_passivemode(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Passive Mode allows the policy to be associated with a Performance L4 Virtual Server (using a FastL4 profile). With FastL4, traffic is analyzed but is not modified in any way.
        """
        return pulumi.get(self, "enable_passivemode")

    @enable_passivemode.setter
    def enable_passivemode(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_passivemode", value)

    @property
    @pulumi.getter(name="enforcementMode")
    def enforcement_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        How the system processes a request that triggers a security policy violation
        """
        return pulumi.get(self, "enforcement_mode")

    @enforcement_mode.setter
    def enforcement_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enforcement_mode", value)

    @property
    @pulumi.getter(name="fileTypes")
    def file_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyFileTypeArgs']]]]:
        """
        `file_types` takes list of file-types options to be used for policy builder.
        See file types below for more details.
        """
        return pulumi.get(self, "file_types")

    @file_types.setter
    def file_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyFileTypeArgs']]]]):
        pulumi.set(self, "file_types", value)

    @property
    @pulumi.getter(name="graphqlProfiles")
    def graphql_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyGraphqlProfileArgs']]]]:
        """
        `graphql_profiles` takes list of graphql profile options to be used for policy builder.
        See graphql profiles below for more details.
        """
        return pulumi.get(self, "graphql_profiles")

    @graphql_profiles.setter
    def graphql_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyGraphqlProfileArgs']]]]):
        pulumi.set(self, "graphql_profiles", value)

    @property
    @pulumi.getter(name="hostNames")
    def host_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyHostNameArgs']]]]:
        """
        specify the list of host name that is used to access the application
        """
        return pulumi.get(self, "host_names")

    @host_names.setter
    def host_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyHostNameArgs']]]]):
        pulumi.set(self, "host_names", value)

    @property
    @pulumi.getter(name="ipExceptions")
    def ip_exceptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyIpExceptionArgs']]]]:
        """
        `ip_exceptions` takes list of IP address exception,An IP address exception is an IP address that you want the system to treat in a specific way for a security policy.For example, you can specify IP addresses from which the system should always trust traffic.
        See IP Exceptions below for more details.
        """
        return pulumi.get(self, "ip_exceptions")

    @ip_exceptions.setter
    def ip_exceptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyIpExceptionArgs']]]]):
        pulumi.set(self, "ip_exceptions", value)

    @property
    @pulumi.getter
    def modifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        the modifications section includes actions that modify the declarative policy as it is defined in the adjustments
        section. The modifications section is updated manually, with the changes generally driven by the learning suggestions
        provided by the BIG-IP.
        """
        return pulumi.get(self, "modifications")

    @modifications.setter
    def modifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "modifications", value)

    @property
    @pulumi.getter(name="openApiFiles")
    def open_api_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        This section defines the Link for open api files on the policy.
        """
        return pulumi.get(self, "open_api_files")

    @open_api_files.setter
    def open_api_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "open_api_files", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        This section defines parameters that the security policy permits in requests.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the partition of the policy. Default is `Common`
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "partition", value)

    @property
    @pulumi.getter(name="policyBuilders")
    def policy_builders(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyPolicyBuilderArgs']]]]:
        """
        `policy_builder` block will provide `learning_mode` options to be used for policy builder.
        See policy builder below for more details.
        """
        return pulumi.get(self, "policy_builders")

    @policy_builders.setter
    def policy_builders(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyPolicyBuilderArgs']]]]):
        pulumi.set(self, "policy_builders", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the A.WAF Policy as it would be calculated on the BIG-IP.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="policyImportJson")
    def policy_import_json(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The payload of the WAF Policy to be used for IMPORT on to BIG-IP.
        """
        return pulumi.get(self, "policy_import_json")

    @policy_import_json.setter
    def policy_import_json(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_import_json", value)

    @property
    @pulumi.getter(name="protocolIndependent")
    def protocol_independent(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When creating a security policy, you can determine whether a security policy differentiates between HTTP and HTTPS URLs. If enabled, the security policy differentiates between HTTP and HTTPS URLs. If disabled, the security policy configures URLs without specifying a specific protocol. This is useful for applications that behave the same for HTTP and HTTPS, and it keeps the security policy from including the same URL twice.
        """
        return pulumi.get(self, "protocol_independent")

    @protocol_independent.setter
    def protocol_independent(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "protocol_independent", value)

    @property
    @pulumi.getter(name="serverTechnologies")
    def server_technologies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The server technology is a server-side application, framework, web server or operating system type that is configured in the policy in order to adapt the policy to the checks needed for the respective technology.
        """
        return pulumi.get(self, "server_technologies")

    @server_technologies.setter
    def server_technologies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "server_technologies", value)

    @property
    @pulumi.getter(name="signatureSets")
    def signature_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Defines behavior when signatures found within a signature-set are detected in a request. Settings are culmulative, so if a signature is found in any set with block enabled, that signature will have block enabled.
        """
        return pulumi.get(self, "signature_sets")

    @signature_sets.setter
    def signature_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "signature_sets", value)

    @property
    @pulumi.getter
    def signatures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        This section defines the properties of a signature on the policy.
        """
        return pulumi.get(self, "signatures")

    @signatures.setter
    def signatures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "signatures", value)

    @property
    @pulumi.getter(name="signaturesSettings")
    def signatures_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicySignaturesSettingArgs']]]]:
        """
        bulk signature setting
        """
        return pulumi.get(self, "signatures_settings")

    @signatures_settings.setter
    def signatures_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicySignaturesSettingArgs']]]]):
        pulumi.set(self, "signatures_settings", value)

    @property
    @pulumi.getter(name="templateLink")
    def template_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Link of the template used for the policy creation.
        """
        return pulumi.get(self, "template_link")

    @template_link.setter
    def template_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_link", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of policy you want to create. The default policy type is `security`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        In a security policy, you can manually specify the HTTP URLs that are allowed (or disallowed) in traffic to the web application being protected. If you are using automatic policy building (and the policy includes learning URLs), the system can determine which URLs to add, based on legitimate traffic.
        """
        return pulumi.get(self, "urls")

    @urls.setter
    def urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "urls", value)


@pulumi.input_type
class _WafPolicyState:
    def __init__(__self__, *,
                 application_language: Optional[pulumi.Input[builtins.str]] = None,
                 case_insensitive: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_passivemode: Optional[pulumi.Input[builtins.bool]] = None,
                 enforcement_mode: Optional[pulumi.Input[builtins.str]] = None,
                 file_types: Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyFileTypeArgs']]]] = None,
                 graphql_profiles: Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyGraphqlProfileArgs']]]] = None,
                 host_names: Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyHostNameArgs']]]] = None,
                 ip_exceptions: Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyIpExceptionArgs']]]] = None,
                 modifications: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 open_api_files: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 partition: Optional[pulumi.Input[builtins.str]] = None,
                 policy_builders: Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyPolicyBuilderArgs']]]] = None,
                 policy_export_json: Optional[pulumi.Input[builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 policy_import_json: Optional[pulumi.Input[builtins.str]] = None,
                 protocol_independent: Optional[pulumi.Input[builtins.bool]] = None,
                 server_technologies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 signature_sets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 signatures: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 signatures_settings: Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicySignaturesSettingArgs']]]] = None,
                 template_link: Optional[pulumi.Input[builtins.str]] = None,
                 template_name: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering WafPolicy resources.
        :param pulumi.Input[builtins.str] application_language: The character encoding for the web application. The character encoding determines how the policy processes the character sets. The default is `utf-8`
        :param pulumi.Input[builtins.bool] case_insensitive: Specifies whether the security policy treats microservice URLs, file types, URLs, and parameters as case sensitive or not. When this setting is enabled, the system stores these security policy elements in lowercase in the security policy configuration
        :param pulumi.Input[builtins.str] description: Specifies the description of the policy.
        :param pulumi.Input[builtins.bool] enable_passivemode: Passive Mode allows the policy to be associated with a Performance L4 Virtual Server (using a FastL4 profile). With FastL4, traffic is analyzed but is not modified in any way.
        :param pulumi.Input[builtins.str] enforcement_mode: How the system processes a request that triggers a security policy violation
        :param pulumi.Input[Sequence[pulumi.Input['WafPolicyFileTypeArgs']]] file_types: `file_types` takes list of file-types options to be used for policy builder.
               See file types below for more details.
        :param pulumi.Input[Sequence[pulumi.Input['WafPolicyGraphqlProfileArgs']]] graphql_profiles: `graphql_profiles` takes list of graphql profile options to be used for policy builder.
               See graphql profiles below for more details.
        :param pulumi.Input[Sequence[pulumi.Input['WafPolicyHostNameArgs']]] host_names: specify the list of host name that is used to access the application
        :param pulumi.Input[Sequence[pulumi.Input['WafPolicyIpExceptionArgs']]] ip_exceptions: `ip_exceptions` takes list of IP address exception,An IP address exception is an IP address that you want the system to treat in a specific way for a security policy.For example, you can specify IP addresses from which the system should always trust traffic.
               See IP Exceptions below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] modifications: the modifications section includes actions that modify the declarative policy as it is defined in the adjustments
               section. The modifications section is updated manually, with the changes generally driven by the learning suggestions
               provided by the BIG-IP.
        :param pulumi.Input[builtins.str] name: The unique user-given name of the policy. Policy names cannot contain spaces or special characters. Allowed characters are a-z, A-Z, 0-9, dot, dash (-), colon (:) and underscore (_).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] open_api_files: This section defines the Link for open api files on the policy.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] parameters: This section defines parameters that the security policy permits in requests.
        :param pulumi.Input[builtins.str] partition: Specifies the partition of the policy. Default is `Common`
        :param pulumi.Input[Sequence[pulumi.Input['WafPolicyPolicyBuilderArgs']]] policy_builders: `policy_builder` block will provide `learning_mode` options to be used for policy builder.
               See policy builder below for more details.
        :param pulumi.Input[builtins.str] policy_export_json: Exported WAF policy deployed on BIGIP.
        :param pulumi.Input[builtins.str] policy_id: The id of the A.WAF Policy as it would be calculated on the BIG-IP.
        :param pulumi.Input[builtins.str] policy_import_json: The payload of the WAF Policy to be used for IMPORT on to BIG-IP.
        :param pulumi.Input[builtins.bool] protocol_independent: When creating a security policy, you can determine whether a security policy differentiates between HTTP and HTTPS URLs. If enabled, the security policy differentiates between HTTP and HTTPS URLs. If disabled, the security policy configures URLs without specifying a specific protocol. This is useful for applications that behave the same for HTTP and HTTPS, and it keeps the security policy from including the same URL twice.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] server_technologies: The server technology is a server-side application, framework, web server or operating system type that is configured in the policy in order to adapt the policy to the checks needed for the respective technology.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] signature_sets: Defines behavior when signatures found within a signature-set are detected in a request. Settings are culmulative, so if a signature is found in any set with block enabled, that signature will have block enabled.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] signatures: This section defines the properties of a signature on the policy.
        :param pulumi.Input[Sequence[pulumi.Input['WafPolicySignaturesSettingArgs']]] signatures_settings: bulk signature setting
        :param pulumi.Input[builtins.str] template_link: Specifies the Link of the template used for the policy creation.
        :param pulumi.Input[builtins.str] template_name: Specifies the name of the template used for the policy creation.
        :param pulumi.Input[builtins.str] type: The type of policy you want to create. The default policy type is `security`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] urls: In a security policy, you can manually specify the HTTP URLs that are allowed (or disallowed) in traffic to the web application being protected. If you are using automatic policy building (and the policy includes learning URLs), the system can determine which URLs to add, based on legitimate traffic.
        """
        if application_language is not None:
            pulumi.set(__self__, "application_language", application_language)
        if case_insensitive is not None:
            pulumi.set(__self__, "case_insensitive", case_insensitive)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_passivemode is not None:
            pulumi.set(__self__, "enable_passivemode", enable_passivemode)
        if enforcement_mode is not None:
            pulumi.set(__self__, "enforcement_mode", enforcement_mode)
        if file_types is not None:
            pulumi.set(__self__, "file_types", file_types)
        if graphql_profiles is not None:
            pulumi.set(__self__, "graphql_profiles", graphql_profiles)
        if host_names is not None:
            pulumi.set(__self__, "host_names", host_names)
        if ip_exceptions is not None:
            pulumi.set(__self__, "ip_exceptions", ip_exceptions)
        if modifications is not None:
            pulumi.set(__self__, "modifications", modifications)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if open_api_files is not None:
            pulumi.set(__self__, "open_api_files", open_api_files)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if policy_builders is not None:
            pulumi.set(__self__, "policy_builders", policy_builders)
        if policy_export_json is not None:
            pulumi.set(__self__, "policy_export_json", policy_export_json)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if policy_import_json is not None:
            pulumi.set(__self__, "policy_import_json", policy_import_json)
        if protocol_independent is not None:
            pulumi.set(__self__, "protocol_independent", protocol_independent)
        if server_technologies is not None:
            pulumi.set(__self__, "server_technologies", server_technologies)
        if signature_sets is not None:
            pulumi.set(__self__, "signature_sets", signature_sets)
        if signatures is not None:
            pulumi.set(__self__, "signatures", signatures)
        if signatures_settings is not None:
            pulumi.set(__self__, "signatures_settings", signatures_settings)
        if template_link is not None:
            pulumi.set(__self__, "template_link", template_link)
        if template_name is not None:
            pulumi.set(__self__, "template_name", template_name)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if urls is not None:
            pulumi.set(__self__, "urls", urls)

    @property
    @pulumi.getter(name="applicationLanguage")
    def application_language(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The character encoding for the web application. The character encoding determines how the policy processes the character sets. The default is `utf-8`
        """
        return pulumi.get(self, "application_language")

    @application_language.setter
    def application_language(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_language", value)

    @property
    @pulumi.getter(name="caseInsensitive")
    def case_insensitive(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the security policy treats microservice URLs, file types, URLs, and parameters as case sensitive or not. When this setting is enabled, the system stores these security policy elements in lowercase in the security policy configuration
        """
        return pulumi.get(self, "case_insensitive")

    @case_insensitive.setter
    def case_insensitive(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "case_insensitive", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the description of the policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enablePassivemode")
    def enable_passivemode(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Passive Mode allows the policy to be associated with a Performance L4 Virtual Server (using a FastL4 profile). With FastL4, traffic is analyzed but is not modified in any way.
        """
        return pulumi.get(self, "enable_passivemode")

    @enable_passivemode.setter
    def enable_passivemode(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_passivemode", value)

    @property
    @pulumi.getter(name="enforcementMode")
    def enforcement_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        How the system processes a request that triggers a security policy violation
        """
        return pulumi.get(self, "enforcement_mode")

    @enforcement_mode.setter
    def enforcement_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enforcement_mode", value)

    @property
    @pulumi.getter(name="fileTypes")
    def file_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyFileTypeArgs']]]]:
        """
        `file_types` takes list of file-types options to be used for policy builder.
        See file types below for more details.
        """
        return pulumi.get(self, "file_types")

    @file_types.setter
    def file_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyFileTypeArgs']]]]):
        pulumi.set(self, "file_types", value)

    @property
    @pulumi.getter(name="graphqlProfiles")
    def graphql_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyGraphqlProfileArgs']]]]:
        """
        `graphql_profiles` takes list of graphql profile options to be used for policy builder.
        See graphql profiles below for more details.
        """
        return pulumi.get(self, "graphql_profiles")

    @graphql_profiles.setter
    def graphql_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyGraphqlProfileArgs']]]]):
        pulumi.set(self, "graphql_profiles", value)

    @property
    @pulumi.getter(name="hostNames")
    def host_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyHostNameArgs']]]]:
        """
        specify the list of host name that is used to access the application
        """
        return pulumi.get(self, "host_names")

    @host_names.setter
    def host_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyHostNameArgs']]]]):
        pulumi.set(self, "host_names", value)

    @property
    @pulumi.getter(name="ipExceptions")
    def ip_exceptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyIpExceptionArgs']]]]:
        """
        `ip_exceptions` takes list of IP address exception,An IP address exception is an IP address that you want the system to treat in a specific way for a security policy.For example, you can specify IP addresses from which the system should always trust traffic.
        See IP Exceptions below for more details.
        """
        return pulumi.get(self, "ip_exceptions")

    @ip_exceptions.setter
    def ip_exceptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyIpExceptionArgs']]]]):
        pulumi.set(self, "ip_exceptions", value)

    @property
    @pulumi.getter
    def modifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        the modifications section includes actions that modify the declarative policy as it is defined in the adjustments
        section. The modifications section is updated manually, with the changes generally driven by the learning suggestions
        provided by the BIG-IP.
        """
        return pulumi.get(self, "modifications")

    @modifications.setter
    def modifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "modifications", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique user-given name of the policy. Policy names cannot contain spaces or special characters. Allowed characters are a-z, A-Z, 0-9, dot, dash (-), colon (:) and underscore (_).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="openApiFiles")
    def open_api_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        This section defines the Link for open api files on the policy.
        """
        return pulumi.get(self, "open_api_files")

    @open_api_files.setter
    def open_api_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "open_api_files", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        This section defines parameters that the security policy permits in requests.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the partition of the policy. Default is `Common`
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "partition", value)

    @property
    @pulumi.getter(name="policyBuilders")
    def policy_builders(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyPolicyBuilderArgs']]]]:
        """
        `policy_builder` block will provide `learning_mode` options to be used for policy builder.
        See policy builder below for more details.
        """
        return pulumi.get(self, "policy_builders")

    @policy_builders.setter
    def policy_builders(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicyPolicyBuilderArgs']]]]):
        pulumi.set(self, "policy_builders", value)

    @property
    @pulumi.getter(name="policyExportJson")
    def policy_export_json(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Exported WAF policy deployed on BIGIP.
        """
        return pulumi.get(self, "policy_export_json")

    @policy_export_json.setter
    def policy_export_json(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_export_json", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the A.WAF Policy as it would be calculated on the BIG-IP.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="policyImportJson")
    def policy_import_json(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The payload of the WAF Policy to be used for IMPORT on to BIG-IP.
        """
        return pulumi.get(self, "policy_import_json")

    @policy_import_json.setter
    def policy_import_json(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_import_json", value)

    @property
    @pulumi.getter(name="protocolIndependent")
    def protocol_independent(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When creating a security policy, you can determine whether a security policy differentiates between HTTP and HTTPS URLs. If enabled, the security policy differentiates between HTTP and HTTPS URLs. If disabled, the security policy configures URLs without specifying a specific protocol. This is useful for applications that behave the same for HTTP and HTTPS, and it keeps the security policy from including the same URL twice.
        """
        return pulumi.get(self, "protocol_independent")

    @protocol_independent.setter
    def protocol_independent(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "protocol_independent", value)

    @property
    @pulumi.getter(name="serverTechnologies")
    def server_technologies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The server technology is a server-side application, framework, web server or operating system type that is configured in the policy in order to adapt the policy to the checks needed for the respective technology.
        """
        return pulumi.get(self, "server_technologies")

    @server_technologies.setter
    def server_technologies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "server_technologies", value)

    @property
    @pulumi.getter(name="signatureSets")
    def signature_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Defines behavior when signatures found within a signature-set are detected in a request. Settings are culmulative, so if a signature is found in any set with block enabled, that signature will have block enabled.
        """
        return pulumi.get(self, "signature_sets")

    @signature_sets.setter
    def signature_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "signature_sets", value)

    @property
    @pulumi.getter
    def signatures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        This section defines the properties of a signature on the policy.
        """
        return pulumi.get(self, "signatures")

    @signatures.setter
    def signatures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "signatures", value)

    @property
    @pulumi.getter(name="signaturesSettings")
    def signatures_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicySignaturesSettingArgs']]]]:
        """
        bulk signature setting
        """
        return pulumi.get(self, "signatures_settings")

    @signatures_settings.setter
    def signatures_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WafPolicySignaturesSettingArgs']]]]):
        pulumi.set(self, "signatures_settings", value)

    @property
    @pulumi.getter(name="templateLink")
    def template_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Link of the template used for the policy creation.
        """
        return pulumi.get(self, "template_link")

    @template_link.setter
    def template_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_link", value)

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the template used for the policy creation.
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of policy you want to create. The default policy type is `security`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        In a security policy, you can manually specify the HTTP URLs that are allowed (or disallowed) in traffic to the web application being protected. If you are using automatic policy building (and the policy includes learning URLs), the system can determine which URLs to add, based on legitimate traffic.
        """
        return pulumi.get(self, "urls")

    @urls.setter
    def urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "urls", value)


@pulumi.type_token("f5bigip:index/wafPolicy:WafPolicy")
class WafPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_language: Optional[pulumi.Input[builtins.str]] = None,
                 case_insensitive: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_passivemode: Optional[pulumi.Input[builtins.bool]] = None,
                 enforcement_mode: Optional[pulumi.Input[builtins.str]] = None,
                 file_types: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WafPolicyFileTypeArgs', 'WafPolicyFileTypeArgsDict']]]]] = None,
                 graphql_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WafPolicyGraphqlProfileArgs', 'WafPolicyGraphqlProfileArgsDict']]]]] = None,
                 host_names: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WafPolicyHostNameArgs', 'WafPolicyHostNameArgsDict']]]]] = None,
                 ip_exceptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WafPolicyIpExceptionArgs', 'WafPolicyIpExceptionArgsDict']]]]] = None,
                 modifications: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 open_api_files: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 partition: Optional[pulumi.Input[builtins.str]] = None,
                 policy_builders: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WafPolicyPolicyBuilderArgs', 'WafPolicyPolicyBuilderArgsDict']]]]] = None,
                 policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 policy_import_json: Optional[pulumi.Input[builtins.str]] = None,
                 protocol_independent: Optional[pulumi.Input[builtins.bool]] = None,
                 server_technologies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 signature_sets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 signatures: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 signatures_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WafPolicySignaturesSettingArgs', 'WafPolicySignaturesSettingArgsDict']]]]] = None,
                 template_link: Optional[pulumi.Input[builtins.str]] = None,
                 template_name: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        param1 = f5bigip.ssl.get_waf_entity_parameter(name="Param1",
            type="explicit",
            data_type="alpha-numeric",
            perform_staging=True)
        param2 = f5bigip.ssl.get_waf_entity_parameter(name="Param2",
            type="explicit",
            data_type="alpha-numeric",
            perform_staging=True)
        url = f5bigip.ssl.get_waf_entity_url(name="URL1",
            protocol="http")
        url2 = f5bigip.ssl.get_waf_entity_url(name="URL2")
        test_awaf = f5bigip.WafPolicy("test-awaf",
            name="testpolicyravi",
            partition="Common",
            template_name="POLICY_TEMPLATE_RAPID_DEPLOYMENT",
            application_language="utf-8",
            enforcement_mode="blocking",
            server_technologies=[
                "MySQL",
                "Unix/Linux",
                "MongoDB",
            ],
            parameters=[
                param1.json,
                param2.json,
            ],
            urls=[
                url.json,
                url2.json,
            ])
        ```

        ## Import

        An existing WAF Policy or if the WAF Policy has been manually created or modified on the BIG-IP WebUI, it can be imported using its `id`.

        e.g:

        ```sh
        $ pulumi import f5bigip:index/wafPolicy:WafPolicy example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_language: The character encoding for the web application. The character encoding determines how the policy processes the character sets. The default is `utf-8`
        :param pulumi.Input[builtins.bool] case_insensitive: Specifies whether the security policy treats microservice URLs, file types, URLs, and parameters as case sensitive or not. When this setting is enabled, the system stores these security policy elements in lowercase in the security policy configuration
        :param pulumi.Input[builtins.str] description: Specifies the description of the policy.
        :param pulumi.Input[builtins.bool] enable_passivemode: Passive Mode allows the policy to be associated with a Performance L4 Virtual Server (using a FastL4 profile). With FastL4, traffic is analyzed but is not modified in any way.
        :param pulumi.Input[builtins.str] enforcement_mode: How the system processes a request that triggers a security policy violation
        :param pulumi.Input[Sequence[pulumi.Input[Union['WafPolicyFileTypeArgs', 'WafPolicyFileTypeArgsDict']]]] file_types: `file_types` takes list of file-types options to be used for policy builder.
               See file types below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WafPolicyGraphqlProfileArgs', 'WafPolicyGraphqlProfileArgsDict']]]] graphql_profiles: `graphql_profiles` takes list of graphql profile options to be used for policy builder.
               See graphql profiles below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WafPolicyHostNameArgs', 'WafPolicyHostNameArgsDict']]]] host_names: specify the list of host name that is used to access the application
        :param pulumi.Input[Sequence[pulumi.Input[Union['WafPolicyIpExceptionArgs', 'WafPolicyIpExceptionArgsDict']]]] ip_exceptions: `ip_exceptions` takes list of IP address exception,An IP address exception is an IP address that you want the system to treat in a specific way for a security policy.For example, you can specify IP addresses from which the system should always trust traffic.
               See IP Exceptions below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] modifications: the modifications section includes actions that modify the declarative policy as it is defined in the adjustments
               section. The modifications section is updated manually, with the changes generally driven by the learning suggestions
               provided by the BIG-IP.
        :param pulumi.Input[builtins.str] name: The unique user-given name of the policy. Policy names cannot contain spaces or special characters. Allowed characters are a-z, A-Z, 0-9, dot, dash (-), colon (:) and underscore (_).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] open_api_files: This section defines the Link for open api files on the policy.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] parameters: This section defines parameters that the security policy permits in requests.
        :param pulumi.Input[builtins.str] partition: Specifies the partition of the policy. Default is `Common`
        :param pulumi.Input[Sequence[pulumi.Input[Union['WafPolicyPolicyBuilderArgs', 'WafPolicyPolicyBuilderArgsDict']]]] policy_builders: `policy_builder` block will provide `learning_mode` options to be used for policy builder.
               See policy builder below for more details.
        :param pulumi.Input[builtins.str] policy_id: The id of the A.WAF Policy as it would be calculated on the BIG-IP.
        :param pulumi.Input[builtins.str] policy_import_json: The payload of the WAF Policy to be used for IMPORT on to BIG-IP.
        :param pulumi.Input[builtins.bool] protocol_independent: When creating a security policy, you can determine whether a security policy differentiates between HTTP and HTTPS URLs. If enabled, the security policy differentiates between HTTP and HTTPS URLs. If disabled, the security policy configures URLs without specifying a specific protocol. This is useful for applications that behave the same for HTTP and HTTPS, and it keeps the security policy from including the same URL twice.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] server_technologies: The server technology is a server-side application, framework, web server or operating system type that is configured in the policy in order to adapt the policy to the checks needed for the respective technology.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] signature_sets: Defines behavior when signatures found within a signature-set are detected in a request. Settings are culmulative, so if a signature is found in any set with block enabled, that signature will have block enabled.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] signatures: This section defines the properties of a signature on the policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WafPolicySignaturesSettingArgs', 'WafPolicySignaturesSettingArgsDict']]]] signatures_settings: bulk signature setting
        :param pulumi.Input[builtins.str] template_link: Specifies the Link of the template used for the policy creation.
        :param pulumi.Input[builtins.str] template_name: Specifies the name of the template used for the policy creation.
        :param pulumi.Input[builtins.str] type: The type of policy you want to create. The default policy type is `security`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] urls: In a security policy, you can manually specify the HTTP URLs that are allowed (or disallowed) in traffic to the web application being protected. If you are using automatic policy building (and the policy includes learning URLs), the system can determine which URLs to add, based on legitimate traffic.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WafPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        param1 = f5bigip.ssl.get_waf_entity_parameter(name="Param1",
            type="explicit",
            data_type="alpha-numeric",
            perform_staging=True)
        param2 = f5bigip.ssl.get_waf_entity_parameter(name="Param2",
            type="explicit",
            data_type="alpha-numeric",
            perform_staging=True)
        url = f5bigip.ssl.get_waf_entity_url(name="URL1",
            protocol="http")
        url2 = f5bigip.ssl.get_waf_entity_url(name="URL2")
        test_awaf = f5bigip.WafPolicy("test-awaf",
            name="testpolicyravi",
            partition="Common",
            template_name="POLICY_TEMPLATE_RAPID_DEPLOYMENT",
            application_language="utf-8",
            enforcement_mode="blocking",
            server_technologies=[
                "MySQL",
                "Unix/Linux",
                "MongoDB",
            ],
            parameters=[
                param1.json,
                param2.json,
            ],
            urls=[
                url.json,
                url2.json,
            ])
        ```

        ## Import

        An existing WAF Policy or if the WAF Policy has been manually created or modified on the BIG-IP WebUI, it can be imported using its `id`.

        e.g:

        ```sh
        $ pulumi import f5bigip:index/wafPolicy:WafPolicy example <id>
        ```

        :param str resource_name: The name of the resource.
        :param WafPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WafPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_language: Optional[pulumi.Input[builtins.str]] = None,
                 case_insensitive: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_passivemode: Optional[pulumi.Input[builtins.bool]] = None,
                 enforcement_mode: Optional[pulumi.Input[builtins.str]] = None,
                 file_types: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WafPolicyFileTypeArgs', 'WafPolicyFileTypeArgsDict']]]]] = None,
                 graphql_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WafPolicyGraphqlProfileArgs', 'WafPolicyGraphqlProfileArgsDict']]]]] = None,
                 host_names: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WafPolicyHostNameArgs', 'WafPolicyHostNameArgsDict']]]]] = None,
                 ip_exceptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WafPolicyIpExceptionArgs', 'WafPolicyIpExceptionArgsDict']]]]] = None,
                 modifications: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 open_api_files: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 partition: Optional[pulumi.Input[builtins.str]] = None,
                 policy_builders: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WafPolicyPolicyBuilderArgs', 'WafPolicyPolicyBuilderArgsDict']]]]] = None,
                 policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 policy_import_json: Optional[pulumi.Input[builtins.str]] = None,
                 protocol_independent: Optional[pulumi.Input[builtins.bool]] = None,
                 server_technologies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 signature_sets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 signatures: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 signatures_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WafPolicySignaturesSettingArgs', 'WafPolicySignaturesSettingArgsDict']]]]] = None,
                 template_link: Optional[pulumi.Input[builtins.str]] = None,
                 template_name: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WafPolicyArgs.__new__(WafPolicyArgs)

            __props__.__dict__["application_language"] = application_language
            __props__.__dict__["case_insensitive"] = case_insensitive
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_passivemode"] = enable_passivemode
            __props__.__dict__["enforcement_mode"] = enforcement_mode
            __props__.__dict__["file_types"] = file_types
            __props__.__dict__["graphql_profiles"] = graphql_profiles
            __props__.__dict__["host_names"] = host_names
            __props__.__dict__["ip_exceptions"] = ip_exceptions
            __props__.__dict__["modifications"] = modifications
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["open_api_files"] = open_api_files
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["partition"] = partition
            __props__.__dict__["policy_builders"] = policy_builders
            __props__.__dict__["policy_id"] = policy_id
            __props__.__dict__["policy_import_json"] = policy_import_json
            __props__.__dict__["protocol_independent"] = protocol_independent
            __props__.__dict__["server_technologies"] = server_technologies
            __props__.__dict__["signature_sets"] = signature_sets
            __props__.__dict__["signatures"] = signatures
            __props__.__dict__["signatures_settings"] = signatures_settings
            __props__.__dict__["template_link"] = template_link
            if template_name is None and not opts.urn:
                raise TypeError("Missing required property 'template_name'")
            __props__.__dict__["template_name"] = template_name
            __props__.__dict__["type"] = type
            __props__.__dict__["urls"] = urls
            __props__.__dict__["policy_export_json"] = None
        super(WafPolicy, __self__).__init__(
            'f5bigip:index/wafPolicy:WafPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_language: Optional[pulumi.Input[builtins.str]] = None,
            case_insensitive: Optional[pulumi.Input[builtins.bool]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            enable_passivemode: Optional[pulumi.Input[builtins.bool]] = None,
            enforcement_mode: Optional[pulumi.Input[builtins.str]] = None,
            file_types: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WafPolicyFileTypeArgs', 'WafPolicyFileTypeArgsDict']]]]] = None,
            graphql_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WafPolicyGraphqlProfileArgs', 'WafPolicyGraphqlProfileArgsDict']]]]] = None,
            host_names: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WafPolicyHostNameArgs', 'WafPolicyHostNameArgsDict']]]]] = None,
            ip_exceptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WafPolicyIpExceptionArgs', 'WafPolicyIpExceptionArgsDict']]]]] = None,
            modifications: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            open_api_files: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            partition: Optional[pulumi.Input[builtins.str]] = None,
            policy_builders: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WafPolicyPolicyBuilderArgs', 'WafPolicyPolicyBuilderArgsDict']]]]] = None,
            policy_export_json: Optional[pulumi.Input[builtins.str]] = None,
            policy_id: Optional[pulumi.Input[builtins.str]] = None,
            policy_import_json: Optional[pulumi.Input[builtins.str]] = None,
            protocol_independent: Optional[pulumi.Input[builtins.bool]] = None,
            server_technologies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            signature_sets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            signatures: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            signatures_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WafPolicySignaturesSettingArgs', 'WafPolicySignaturesSettingArgsDict']]]]] = None,
            template_link: Optional[pulumi.Input[builtins.str]] = None,
            template_name: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'WafPolicy':
        """
        Get an existing WafPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_language: The character encoding for the web application. The character encoding determines how the policy processes the character sets. The default is `utf-8`
        :param pulumi.Input[builtins.bool] case_insensitive: Specifies whether the security policy treats microservice URLs, file types, URLs, and parameters as case sensitive or not. When this setting is enabled, the system stores these security policy elements in lowercase in the security policy configuration
        :param pulumi.Input[builtins.str] description: Specifies the description of the policy.
        :param pulumi.Input[builtins.bool] enable_passivemode: Passive Mode allows the policy to be associated with a Performance L4 Virtual Server (using a FastL4 profile). With FastL4, traffic is analyzed but is not modified in any way.
        :param pulumi.Input[builtins.str] enforcement_mode: How the system processes a request that triggers a security policy violation
        :param pulumi.Input[Sequence[pulumi.Input[Union['WafPolicyFileTypeArgs', 'WafPolicyFileTypeArgsDict']]]] file_types: `file_types` takes list of file-types options to be used for policy builder.
               See file types below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WafPolicyGraphqlProfileArgs', 'WafPolicyGraphqlProfileArgsDict']]]] graphql_profiles: `graphql_profiles` takes list of graphql profile options to be used for policy builder.
               See graphql profiles below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WafPolicyHostNameArgs', 'WafPolicyHostNameArgsDict']]]] host_names: specify the list of host name that is used to access the application
        :param pulumi.Input[Sequence[pulumi.Input[Union['WafPolicyIpExceptionArgs', 'WafPolicyIpExceptionArgsDict']]]] ip_exceptions: `ip_exceptions` takes list of IP address exception,An IP address exception is an IP address that you want the system to treat in a specific way for a security policy.For example, you can specify IP addresses from which the system should always trust traffic.
               See IP Exceptions below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] modifications: the modifications section includes actions that modify the declarative policy as it is defined in the adjustments
               section. The modifications section is updated manually, with the changes generally driven by the learning suggestions
               provided by the BIG-IP.
        :param pulumi.Input[builtins.str] name: The unique user-given name of the policy. Policy names cannot contain spaces or special characters. Allowed characters are a-z, A-Z, 0-9, dot, dash (-), colon (:) and underscore (_).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] open_api_files: This section defines the Link for open api files on the policy.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] parameters: This section defines parameters that the security policy permits in requests.
        :param pulumi.Input[builtins.str] partition: Specifies the partition of the policy. Default is `Common`
        :param pulumi.Input[Sequence[pulumi.Input[Union['WafPolicyPolicyBuilderArgs', 'WafPolicyPolicyBuilderArgsDict']]]] policy_builders: `policy_builder` block will provide `learning_mode` options to be used for policy builder.
               See policy builder below for more details.
        :param pulumi.Input[builtins.str] policy_export_json: Exported WAF policy deployed on BIGIP.
        :param pulumi.Input[builtins.str] policy_id: The id of the A.WAF Policy as it would be calculated on the BIG-IP.
        :param pulumi.Input[builtins.str] policy_import_json: The payload of the WAF Policy to be used for IMPORT on to BIG-IP.
        :param pulumi.Input[builtins.bool] protocol_independent: When creating a security policy, you can determine whether a security policy differentiates between HTTP and HTTPS URLs. If enabled, the security policy differentiates between HTTP and HTTPS URLs. If disabled, the security policy configures URLs without specifying a specific protocol. This is useful for applications that behave the same for HTTP and HTTPS, and it keeps the security policy from including the same URL twice.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] server_technologies: The server technology is a server-side application, framework, web server or operating system type that is configured in the policy in order to adapt the policy to the checks needed for the respective technology.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] signature_sets: Defines behavior when signatures found within a signature-set are detected in a request. Settings are culmulative, so if a signature is found in any set with block enabled, that signature will have block enabled.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] signatures: This section defines the properties of a signature on the policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WafPolicySignaturesSettingArgs', 'WafPolicySignaturesSettingArgsDict']]]] signatures_settings: bulk signature setting
        :param pulumi.Input[builtins.str] template_link: Specifies the Link of the template used for the policy creation.
        :param pulumi.Input[builtins.str] template_name: Specifies the name of the template used for the policy creation.
        :param pulumi.Input[builtins.str] type: The type of policy you want to create. The default policy type is `security`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] urls: In a security policy, you can manually specify the HTTP URLs that are allowed (or disallowed) in traffic to the web application being protected. If you are using automatic policy building (and the policy includes learning URLs), the system can determine which URLs to add, based on legitimate traffic.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WafPolicyState.__new__(_WafPolicyState)

        __props__.__dict__["application_language"] = application_language
        __props__.__dict__["case_insensitive"] = case_insensitive
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_passivemode"] = enable_passivemode
        __props__.__dict__["enforcement_mode"] = enforcement_mode
        __props__.__dict__["file_types"] = file_types
        __props__.__dict__["graphql_profiles"] = graphql_profiles
        __props__.__dict__["host_names"] = host_names
        __props__.__dict__["ip_exceptions"] = ip_exceptions
        __props__.__dict__["modifications"] = modifications
        __props__.__dict__["name"] = name
        __props__.__dict__["open_api_files"] = open_api_files
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["partition"] = partition
        __props__.__dict__["policy_builders"] = policy_builders
        __props__.__dict__["policy_export_json"] = policy_export_json
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["policy_import_json"] = policy_import_json
        __props__.__dict__["protocol_independent"] = protocol_independent
        __props__.__dict__["server_technologies"] = server_technologies
        __props__.__dict__["signature_sets"] = signature_sets
        __props__.__dict__["signatures"] = signatures
        __props__.__dict__["signatures_settings"] = signatures_settings
        __props__.__dict__["template_link"] = template_link
        __props__.__dict__["template_name"] = template_name
        __props__.__dict__["type"] = type
        __props__.__dict__["urls"] = urls
        return WafPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationLanguage")
    def application_language(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The character encoding for the web application. The character encoding determines how the policy processes the character sets. The default is `utf-8`
        """
        return pulumi.get(self, "application_language")

    @property
    @pulumi.getter(name="caseInsensitive")
    def case_insensitive(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether the security policy treats microservice URLs, file types, URLs, and parameters as case sensitive or not. When this setting is enabled, the system stores these security policy elements in lowercase in the security policy configuration
        """
        return pulumi.get(self, "case_insensitive")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the description of the policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enablePassivemode")
    def enable_passivemode(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Passive Mode allows the policy to be associated with a Performance L4 Virtual Server (using a FastL4 profile). With FastL4, traffic is analyzed but is not modified in any way.
        """
        return pulumi.get(self, "enable_passivemode")

    @property
    @pulumi.getter(name="enforcementMode")
    def enforcement_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        How the system processes a request that triggers a security policy violation
        """
        return pulumi.get(self, "enforcement_mode")

    @property
    @pulumi.getter(name="fileTypes")
    def file_types(self) -> pulumi.Output[Optional[Sequence['outputs.WafPolicyFileType']]]:
        """
        `file_types` takes list of file-types options to be used for policy builder.
        See file types below for more details.
        """
        return pulumi.get(self, "file_types")

    @property
    @pulumi.getter(name="graphqlProfiles")
    def graphql_profiles(self) -> pulumi.Output[Optional[Sequence['outputs.WafPolicyGraphqlProfile']]]:
        """
        `graphql_profiles` takes list of graphql profile options to be used for policy builder.
        See graphql profiles below for more details.
        """
        return pulumi.get(self, "graphql_profiles")

    @property
    @pulumi.getter(name="hostNames")
    def host_names(self) -> pulumi.Output[Optional[Sequence['outputs.WafPolicyHostName']]]:
        """
        specify the list of host name that is used to access the application
        """
        return pulumi.get(self, "host_names")

    @property
    @pulumi.getter(name="ipExceptions")
    def ip_exceptions(self) -> pulumi.Output[Optional[Sequence['outputs.WafPolicyIpException']]]:
        """
        `ip_exceptions` takes list of IP address exception,An IP address exception is an IP address that you want the system to treat in a specific way for a security policy.For example, you can specify IP addresses from which the system should always trust traffic.
        See IP Exceptions below for more details.
        """
        return pulumi.get(self, "ip_exceptions")

    @property
    @pulumi.getter
    def modifications(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        the modifications section includes actions that modify the declarative policy as it is defined in the adjustments
        section. The modifications section is updated manually, with the changes generally driven by the learning suggestions
        provided by the BIG-IP.
        """
        return pulumi.get(self, "modifications")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The unique user-given name of the policy. Policy names cannot contain spaces or special characters. Allowed characters are a-z, A-Z, 0-9, dot, dash (-), colon (:) and underscore (_).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="openApiFiles")
    def open_api_files(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        This section defines the Link for open api files on the policy.
        """
        return pulumi.get(self, "open_api_files")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        This section defines parameters that the security policy permits in requests.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def partition(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the partition of the policy. Default is `Common`
        """
        return pulumi.get(self, "partition")

    @property
    @pulumi.getter(name="policyBuilders")
    def policy_builders(self) -> pulumi.Output[Optional[Sequence['outputs.WafPolicyPolicyBuilder']]]:
        """
        `policy_builder` block will provide `learning_mode` options to be used for policy builder.
        See policy builder below for more details.
        """
        return pulumi.get(self, "policy_builders")

    @property
    @pulumi.getter(name="policyExportJson")
    def policy_export_json(self) -> pulumi.Output[builtins.str]:
        """
        Exported WAF policy deployed on BIGIP.
        """
        return pulumi.get(self, "policy_export_json")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[builtins.str]:
        """
        The id of the A.WAF Policy as it would be calculated on the BIG-IP.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="policyImportJson")
    def policy_import_json(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The payload of the WAF Policy to be used for IMPORT on to BIG-IP.
        """
        return pulumi.get(self, "policy_import_json")

    @property
    @pulumi.getter(name="protocolIndependent")
    def protocol_independent(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        When creating a security policy, you can determine whether a security policy differentiates between HTTP and HTTPS URLs. If enabled, the security policy differentiates between HTTP and HTTPS URLs. If disabled, the security policy configures URLs without specifying a specific protocol. This is useful for applications that behave the same for HTTP and HTTPS, and it keeps the security policy from including the same URL twice.
        """
        return pulumi.get(self, "protocol_independent")

    @property
    @pulumi.getter(name="serverTechnologies")
    def server_technologies(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The server technology is a server-side application, framework, web server or operating system type that is configured in the policy in order to adapt the policy to the checks needed for the respective technology.
        """
        return pulumi.get(self, "server_technologies")

    @property
    @pulumi.getter(name="signatureSets")
    def signature_sets(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Defines behavior when signatures found within a signature-set are detected in a request. Settings are culmulative, so if a signature is found in any set with block enabled, that signature will have block enabled.
        """
        return pulumi.get(self, "signature_sets")

    @property
    @pulumi.getter
    def signatures(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        This section defines the properties of a signature on the policy.
        """
        return pulumi.get(self, "signatures")

    @property
    @pulumi.getter(name="signaturesSettings")
    def signatures_settings(self) -> pulumi.Output[Optional[Sequence['outputs.WafPolicySignaturesSetting']]]:
        """
        bulk signature setting
        """
        return pulumi.get(self, "signatures_settings")

    @property
    @pulumi.getter(name="templateLink")
    def template_link(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the Link of the template used for the policy creation.
        """
        return pulumi.get(self, "template_link")

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the template used for the policy creation.
        """
        return pulumi.get(self, "template_name")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The type of policy you want to create. The default policy type is `security`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def urls(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        In a security policy, you can manually specify the HTTP URLs that are allowed (or disallowed) in traffic to the web application being protected. If you are using automatic policy building (and the policy includes learning URLs), the system can determine which URLs to add, based on legitimate traffic.
        """
        return pulumi.get(self, "urls")

