# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CustomDashboardArgs', 'CustomDashboard']

@pulumi.input_type
class CustomDashboardArgs:
    def __init__(__self__, *,
                 dashboard_items: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDashboardDashboardItemArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CustomDashboard resource.
        :param pulumi.Input[Sequence[pulumi.Input['CustomDashboardDashboardItemArgs']]] dashboard_items: A list of dashboard items.
        :param pulumi.Input[_builtins.str] description: A short description of the dashboard.
        :param pulumi.Input[_builtins.str] name: A human-readable name.
        """
        if dashboard_items is not None:
            pulumi.set(__self__, "dashboard_items", dashboard_items)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="dashboardItems")
    def dashboard_items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomDashboardDashboardItemArgs']]]]:
        """
        A list of dashboard items.
        """
        return pulumi.get(self, "dashboard_items")

    @dashboard_items.setter
    def dashboard_items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDashboardDashboardItemArgs']]]]):
        pulumi.set(self, "dashboard_items", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A short description of the dashboard.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-readable name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _CustomDashboardState:
    def __init__(__self__, *,
                 dashboard_items: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDashboardDashboardItemArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CustomDashboard resources.
        :param pulumi.Input[Sequence[pulumi.Input['CustomDashboardDashboardItemArgs']]] dashboard_items: A list of dashboard items.
        :param pulumi.Input[_builtins.str] description: A short description of the dashboard.
        :param pulumi.Input[_builtins.str] name: A human-readable name.
        """
        if dashboard_items is not None:
            pulumi.set(__self__, "dashboard_items", dashboard_items)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="dashboardItems")
    def dashboard_items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomDashboardDashboardItemArgs']]]]:
        """
        A list of dashboard items.
        """
        return pulumi.get(self, "dashboard_items")

    @dashboard_items.setter
    def dashboard_items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDashboardDashboardItemArgs']]]]):
        pulumi.set(self, "dashboard_items", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A short description of the dashboard.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-readable name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("fastly:index/customDashboard:CustomDashboard")
class CustomDashboard(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dashboard_items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomDashboardDashboardItemArgs', 'CustomDashboardDashboardItemArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Custom Dashboard which can be viewed in the Fastly Control Panel.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_fastly as fastly

        example = fastly.CustomDashboard("example",
            name="Example Custom Dashboard",
            description="This is an example custom dashboard. A few dashboard items are provided to help you get started.",
            dashboard_items=[
                {
                    "id": "example1",
                    "title": "Total Requests",
                    "subtitle": "Number of requests processed.",
                    "data_source": {
                        "type": "stats.edge",
                        "config": {
                            "metrics": ["requests"],
                        },
                    },
                    "visualization": {
                        "type": "chart",
                        "config": {
                            "format": "requests",
                            "plot_type": "line",
                        },
                    },
                },
                {
                    "id": "example2",
                    "title": "Hit Ratio",
                    "subtitle": "Ratio of requests served from Fastly.",
                    "data_source": {
                        "type": "stats.edge",
                        "config": {
                            "metrics": ["hit_ratio"],
                        },
                    },
                    "visualization": {
                        "type": "chart",
                        "config": {
                            "format": "percent",
                            "plot_type": "donut",
                            "calculation_method": "latest",
                        },
                    },
                },
                {
                    "id": "example3",
                    "title": "Client & Server Errors",
                    "subtitle": "Total errors served from the client or server.",
                    "data_source": {
                        "type": "stats.edge",
                        "config": {
                            "metrics": [
                                "status_4xx",
                                "status_5xx",
                            ],
                        },
                    },
                    "visualization": {
                        "type": "chart",
                        "config": {
                            "format": "requests",
                            "plot_type": "bar",
                        },
                    },
                },
                {
                    "id": "example4",
                    "title": "Domain Requests",
                    "subtitle": "Requests by Domain.",
                    "span": 6,
                    "data_source": {
                        "type": "stats.domain",
                        "config": {
                            "metrics": ["requests"],
                        },
                    },
                    "visualization": {
                        "type": "chart",
                        "config": {
                            "format": "requests",
                            "plot_type": "line",
                        },
                    },
                },
                {
                    "id": "example5",
                    "title": "Origin Responses",
                    "subtitle": "Responses by Origin.",
                    "span": 6,
                    "data_source": {
                        "type": "stats.origin",
                        "config": {
                            "metrics": ["all_responses"],
                        },
                    },
                    "visualization": {
                        "type": "chart",
                        "config": {
                            "plot_type": "line",
                        },
                    },
                },
                {
                    "id": "example6",
                    "title": "Total Bandwidth",
                    "subtitle": "Total bandwidth served.",
                    "span": 12,
                    "data_source": {
                        "type": "stats.edge",
                        "config": {
                            "metrics": ["bandwidth"],
                        },
                    },
                    "visualization": {
                        "type": "chart",
                        "config": {
                            "format": "bytes",
                            "plot_type": "bar",
                        },
                    },
                },
                {
                    "id": "example7",
                    "title": "Products - Image Optimizer & Real-Time Log Streaming",
                    "subtitle": "Total IO images served and log statements sent.",
                    "span": 8,
                    "data_source": {
                        "type": "stats.edge",
                        "config": {
                            "metrics": [
                                "imgopto",
                                "log",
                            ],
                        },
                    },
                    "visualization": {
                        "type": "chart",
                        "config": {
                            "plot_type": "line",
                        },
                    },
                },
                {
                    "id": "example8",
                    "title": "Transport Protocols & Security",
                    "subtitle": "HTTP Protocols & TLS.",
                    "data_source": {
                        "type": "stats.edge",
                        "config": {
                            "metrics": [
                                "http1",
                                "http2",
                                "http3",
                                "tls_v10",
                                "tls_v11",
                                "tls_v12",
                                "tls_v13",
                            ],
                        },
                    },
                    "visualization": {
                        "type": "chart",
                        "config": {
                            "format": "requests",
                            "plot_type": "line",
                        },
                    },
                },
                {
                    "id": "example9",
                    "title": "Origin Miss Latency",
                    "subtitle": "Miss latency times for your origins.",
                    "span": 12,
                    "data_source": {
                        "type": "stats.edge",
                        "config": {
                            "metrics": ["origin_latency"],
                        },
                    },
                    "visualization": {
                        "type": "chart",
                        "config": {
                            "format": "milliseconds",
                            "plot_type": "line",
                        },
                    },
                },
                {
                    "id": "example10",
                    "title": "DDoS - Request Flood Attempts",
                    "subtitle": "Number of connections the limit-streams action was applied.",
                    "span": 6,
                    "data_source": {
                        "type": "stats.edge",
                        "config": {
                            "metrics": [
                                "ddos_action_limit_streams_connections",
                                "ddos_action_limit_streams_requests",
                            ],
                        },
                    },
                    "visualization": {
                        "type": "chart",
                        "config": {
                            "format": "requests",
                            "plot_type": "line",
                        },
                    },
                },
                {
                    "id": "example11",
                    "title": "DDoS - Malicious Bot Attack",
                    "subtitle": "Number of times the blackhole action was taken.",
                    "span": 6,
                    "data_source": {
                        "type": "stats.edge",
                        "config": {
                            "metrics": [
                                "ddos_action_close",
                                "ddos_action_blackhole",
                            ],
                        },
                    },
                    "visualization": {
                        "type": "chart",
                        "config": {
                            "format": "number",
                            "plot_type": "line",
                        },
                    },
                },
            ])
        ```

        ## Import

        Fastly Custom Dashboards can be imported using their ID, e.g.

        ```sh
        $ pulumi import fastly:index/customDashboard:CustomDashboard example xxxxxxxxxxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomDashboardDashboardItemArgs', 'CustomDashboardDashboardItemArgsDict']]]] dashboard_items: A list of dashboard items.
        :param pulumi.Input[_builtins.str] description: A short description of the dashboard.
        :param pulumi.Input[_builtins.str] name: A human-readable name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CustomDashboardArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Custom Dashboard which can be viewed in the Fastly Control Panel.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_fastly as fastly

        example = fastly.CustomDashboard("example",
            name="Example Custom Dashboard",
            description="This is an example custom dashboard. A few dashboard items are provided to help you get started.",
            dashboard_items=[
                {
                    "id": "example1",
                    "title": "Total Requests",
                    "subtitle": "Number of requests processed.",
                    "data_source": {
                        "type": "stats.edge",
                        "config": {
                            "metrics": ["requests"],
                        },
                    },
                    "visualization": {
                        "type": "chart",
                        "config": {
                            "format": "requests",
                            "plot_type": "line",
                        },
                    },
                },
                {
                    "id": "example2",
                    "title": "Hit Ratio",
                    "subtitle": "Ratio of requests served from Fastly.",
                    "data_source": {
                        "type": "stats.edge",
                        "config": {
                            "metrics": ["hit_ratio"],
                        },
                    },
                    "visualization": {
                        "type": "chart",
                        "config": {
                            "format": "percent",
                            "plot_type": "donut",
                            "calculation_method": "latest",
                        },
                    },
                },
                {
                    "id": "example3",
                    "title": "Client & Server Errors",
                    "subtitle": "Total errors served from the client or server.",
                    "data_source": {
                        "type": "stats.edge",
                        "config": {
                            "metrics": [
                                "status_4xx",
                                "status_5xx",
                            ],
                        },
                    },
                    "visualization": {
                        "type": "chart",
                        "config": {
                            "format": "requests",
                            "plot_type": "bar",
                        },
                    },
                },
                {
                    "id": "example4",
                    "title": "Domain Requests",
                    "subtitle": "Requests by Domain.",
                    "span": 6,
                    "data_source": {
                        "type": "stats.domain",
                        "config": {
                            "metrics": ["requests"],
                        },
                    },
                    "visualization": {
                        "type": "chart",
                        "config": {
                            "format": "requests",
                            "plot_type": "line",
                        },
                    },
                },
                {
                    "id": "example5",
                    "title": "Origin Responses",
                    "subtitle": "Responses by Origin.",
                    "span": 6,
                    "data_source": {
                        "type": "stats.origin",
                        "config": {
                            "metrics": ["all_responses"],
                        },
                    },
                    "visualization": {
                        "type": "chart",
                        "config": {
                            "plot_type": "line",
                        },
                    },
                },
                {
                    "id": "example6",
                    "title": "Total Bandwidth",
                    "subtitle": "Total bandwidth served.",
                    "span": 12,
                    "data_source": {
                        "type": "stats.edge",
                        "config": {
                            "metrics": ["bandwidth"],
                        },
                    },
                    "visualization": {
                        "type": "chart",
                        "config": {
                            "format": "bytes",
                            "plot_type": "bar",
                        },
                    },
                },
                {
                    "id": "example7",
                    "title": "Products - Image Optimizer & Real-Time Log Streaming",
                    "subtitle": "Total IO images served and log statements sent.",
                    "span": 8,
                    "data_source": {
                        "type": "stats.edge",
                        "config": {
                            "metrics": [
                                "imgopto",
                                "log",
                            ],
                        },
                    },
                    "visualization": {
                        "type": "chart",
                        "config": {
                            "plot_type": "line",
                        },
                    },
                },
                {
                    "id": "example8",
                    "title": "Transport Protocols & Security",
                    "subtitle": "HTTP Protocols & TLS.",
                    "data_source": {
                        "type": "stats.edge",
                        "config": {
                            "metrics": [
                                "http1",
                                "http2",
                                "http3",
                                "tls_v10",
                                "tls_v11",
                                "tls_v12",
                                "tls_v13",
                            ],
                        },
                    },
                    "visualization": {
                        "type": "chart",
                        "config": {
                            "format": "requests",
                            "plot_type": "line",
                        },
                    },
                },
                {
                    "id": "example9",
                    "title": "Origin Miss Latency",
                    "subtitle": "Miss latency times for your origins.",
                    "span": 12,
                    "data_source": {
                        "type": "stats.edge",
                        "config": {
                            "metrics": ["origin_latency"],
                        },
                    },
                    "visualization": {
                        "type": "chart",
                        "config": {
                            "format": "milliseconds",
                            "plot_type": "line",
                        },
                    },
                },
                {
                    "id": "example10",
                    "title": "DDoS - Request Flood Attempts",
                    "subtitle": "Number of connections the limit-streams action was applied.",
                    "span": 6,
                    "data_source": {
                        "type": "stats.edge",
                        "config": {
                            "metrics": [
                                "ddos_action_limit_streams_connections",
                                "ddos_action_limit_streams_requests",
                            ],
                        },
                    },
                    "visualization": {
                        "type": "chart",
                        "config": {
                            "format": "requests",
                            "plot_type": "line",
                        },
                    },
                },
                {
                    "id": "example11",
                    "title": "DDoS - Malicious Bot Attack",
                    "subtitle": "Number of times the blackhole action was taken.",
                    "span": 6,
                    "data_source": {
                        "type": "stats.edge",
                        "config": {
                            "metrics": [
                                "ddos_action_close",
                                "ddos_action_blackhole",
                            ],
                        },
                    },
                    "visualization": {
                        "type": "chart",
                        "config": {
                            "format": "number",
                            "plot_type": "line",
                        },
                    },
                },
            ])
        ```

        ## Import

        Fastly Custom Dashboards can be imported using their ID, e.g.

        ```sh
        $ pulumi import fastly:index/customDashboard:CustomDashboard example xxxxxxxxxxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param CustomDashboardArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomDashboardArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dashboard_items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomDashboardDashboardItemArgs', 'CustomDashboardDashboardItemArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomDashboardArgs.__new__(CustomDashboardArgs)

            __props__.__dict__["dashboard_items"] = dashboard_items
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
        super(CustomDashboard, __self__).__init__(
            'fastly:index/customDashboard:CustomDashboard',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dashboard_items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomDashboardDashboardItemArgs', 'CustomDashboardDashboardItemArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'CustomDashboard':
        """
        Get an existing CustomDashboard resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomDashboardDashboardItemArgs', 'CustomDashboardDashboardItemArgsDict']]]] dashboard_items: A list of dashboard items.
        :param pulumi.Input[_builtins.str] description: A short description of the dashboard.
        :param pulumi.Input[_builtins.str] name: A human-readable name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomDashboardState.__new__(_CustomDashboardState)

        __props__.__dict__["dashboard_items"] = dashboard_items
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        return CustomDashboard(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dashboardItems")
    def dashboard_items(self) -> pulumi.Output[Optional[Sequence['outputs.CustomDashboardDashboardItem']]]:
        """
        A list of dashboard items.
        """
        return pulumi.get(self, "dashboard_items")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A short description of the dashboard.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A human-readable name.
        """
        return pulumi.get(self, "name")

