# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DomainV1ServiceLinkArgs', 'DomainV1ServiceLink']

@pulumi.input_type
class DomainV1ServiceLinkArgs:
    def __init__(__self__, *,
                 domain_id: pulumi.Input[_builtins.str],
                 service_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a DomainV1ServiceLink resource.
        :param pulumi.Input[_builtins.str] domain_id: The Domain Identifier of the versionless domain being linked (UUID).
        :param pulumi.Input[_builtins.str] service_id: The service_id associated with your domain
        """
        pulumi.set(__self__, "domain_id", domain_id)
        pulumi.set(__self__, "service_id", service_id)

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Domain Identifier of the versionless domain being linked (UUID).
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Input[_builtins.str]:
        """
        The service_id associated with your domain
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_id", value)


@pulumi.input_type
class _DomainV1ServiceLinkState:
    def __init__(__self__, *,
                 domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DomainV1ServiceLink resources.
        :param pulumi.Input[_builtins.str] domain_id: The Domain Identifier of the versionless domain being linked (UUID).
        :param pulumi.Input[_builtins.str] service_id: The service_id associated with your domain
        """
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Domain Identifier of the versionless domain being linked (UUID).
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service_id associated with your domain
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_id", value)


@pulumi.type_token("fastly:index/domainV1ServiceLink:DomainV1ServiceLink")
class DomainV1ServiceLink(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Domain service links are for managing versionless domains for services. The link associates an existing service
        with an existing domain, but doesn't create or delete either resource.

        If you are managing your versionless domain with a service link, you may not also use a `resource_fastly_domain_v1` block as well.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain_id: The Domain Identifier of the versionless domain being linked (UUID).
        :param pulumi.Input[_builtins.str] service_id: The service_id associated with your domain
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainV1ServiceLinkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Domain service links are for managing versionless domains for services. The link associates an existing service
        with an existing domain, but doesn't create or delete either resource.

        If you are managing your versionless domain with a service link, you may not also use a `resource_fastly_domain_v1` block as well.

        :param str resource_name: The name of the resource.
        :param DomainV1ServiceLinkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainV1ServiceLinkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainV1ServiceLinkArgs.__new__(DomainV1ServiceLinkArgs)

            if domain_id is None and not opts.urn:
                raise TypeError("Missing required property 'domain_id'")
            __props__.__dict__["domain_id"] = domain_id
            if service_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_id'")
            __props__.__dict__["service_id"] = service_id
        super(DomainV1ServiceLink, __self__).__init__(
            'fastly:index/domainV1ServiceLink:DomainV1ServiceLink',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            domain_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'DomainV1ServiceLink':
        """
        Get an existing DomainV1ServiceLink resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain_id: The Domain Identifier of the versionless domain being linked (UUID).
        :param pulumi.Input[_builtins.str] service_id: The service_id associated with your domain
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainV1ServiceLinkState.__new__(_DomainV1ServiceLinkState)

        __props__.__dict__["domain_id"] = domain_id
        __props__.__dict__["service_id"] = service_id
        return DomainV1ServiceLink(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Domain Identifier of the versionless domain being linked (UUID).
        """
        return pulumi.get(self, "domain_id")

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[_builtins.str]:
        """
        The service_id associated with your domain
        """
        return pulumi.get(self, "service_id")

