# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NgwafAccountRuleArgs', 'NgwafAccountRule']

@pulumi.input_type
class NgwafAccountRuleArgs:
    def __init__(__self__, *,
                 actions: pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleActionArgs']]],
                 applies_tos: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 description: pulumi.Input[_builtins.str],
                 enabled: pulumi.Input[_builtins.bool],
                 type: pulumi.Input[_builtins.str],
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleConditionArgs']]]] = None,
                 group_conditions: Optional[pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleGroupConditionArgs']]]] = None,
                 group_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 multival_conditions: Optional[pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleMultivalConditionArgs']]]] = None,
                 request_logging: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NgwafAccountRule resource.
        :param pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleActionArgs']]] actions: List of actions to perform when the rule matches.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applies_tos: The list of workspace IDs this signal applies to, or the wildcard `*` if it applies to all workspaces.
        :param pulumi.Input[_builtins.str] description: The description of the rule.
        :param pulumi.Input[_builtins.bool] enabled: Whether the rule is currently enabled.
        :param pulumi.Input[_builtins.str] type: The type of the rule. Accepted values are `request` and `signal`.
        :param pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleConditionArgs']]] conditions: Flat list of individual conditions. Each must include `field`, `operator`, and `value`.
        :param pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleGroupConditionArgs']]] group_conditions: List of grouped conditions with nested logic. Each group must define a `group_operator` and at least one condition.
        :param pulumi.Input[_builtins.str] group_operator: Logical operator to apply to group conditions. Accepted values are `any` and `all`.
        :param pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleMultivalConditionArgs']]] multival_conditions: List of multival conditions with nested logic. Each multival list must define a `field, operator, group_operator` and at least one condition.
        :param pulumi.Input[_builtins.str] request_logging: Logging behavior for matching requests. Accepted values are `sampled` and `none`.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "applies_tos", applies_tos)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "type", type)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if group_conditions is not None:
            pulumi.set(__self__, "group_conditions", group_conditions)
        if group_operator is not None:
            pulumi.set(__self__, "group_operator", group_operator)
        if multival_conditions is not None:
            pulumi.set(__self__, "multival_conditions", multival_conditions)
        if request_logging is not None:
            pulumi.set(__self__, "request_logging", request_logging)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleActionArgs']]]:
        """
        List of actions to perform when the rule matches.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleActionArgs']]]):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter(name="appliesTos")
    def applies_tos(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of workspace IDs this signal applies to, or the wildcard `*` if it applies to all workspaces.
        """
        return pulumi.get(self, "applies_tos")

    @applies_tos.setter
    def applies_tos(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "applies_tos", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        The description of the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether the rule is currently enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the rule. Accepted values are `request` and `signal`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleConditionArgs']]]]:
        """
        Flat list of individual conditions. Each must include `field`, `operator`, and `value`.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @_builtins.property
    @pulumi.getter(name="groupConditions")
    def group_conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleGroupConditionArgs']]]]:
        """
        List of grouped conditions with nested logic. Each group must define a `group_operator` and at least one condition.
        """
        return pulumi.get(self, "group_conditions")

    @group_conditions.setter
    def group_conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleGroupConditionArgs']]]]):
        pulumi.set(self, "group_conditions", value)

    @_builtins.property
    @pulumi.getter(name="groupOperator")
    def group_operator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Logical operator to apply to group conditions. Accepted values are `any` and `all`.
        """
        return pulumi.get(self, "group_operator")

    @group_operator.setter
    def group_operator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_operator", value)

    @_builtins.property
    @pulumi.getter(name="multivalConditions")
    def multival_conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleMultivalConditionArgs']]]]:
        """
        List of multival conditions with nested logic. Each multival list must define a `field, operator, group_operator` and at least one condition.
        """
        return pulumi.get(self, "multival_conditions")

    @multival_conditions.setter
    def multival_conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleMultivalConditionArgs']]]]):
        pulumi.set(self, "multival_conditions", value)

    @_builtins.property
    @pulumi.getter(name="requestLogging")
    def request_logging(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Logging behavior for matching requests. Accepted values are `sampled` and `none`.
        """
        return pulumi.get(self, "request_logging")

    @request_logging.setter
    def request_logging(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_logging", value)


@pulumi.input_type
class _NgwafAccountRuleState:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleActionArgs']]]] = None,
                 applies_tos: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleConditionArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_conditions: Optional[pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleGroupConditionArgs']]]] = None,
                 group_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 multival_conditions: Optional[pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleMultivalConditionArgs']]]] = None,
                 request_logging: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NgwafAccountRule resources.
        :param pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleActionArgs']]] actions: List of actions to perform when the rule matches.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applies_tos: The list of workspace IDs this signal applies to, or the wildcard `*` if it applies to all workspaces.
        :param pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleConditionArgs']]] conditions: Flat list of individual conditions. Each must include `field`, `operator`, and `value`.
        :param pulumi.Input[_builtins.str] description: The description of the rule.
        :param pulumi.Input[_builtins.bool] enabled: Whether the rule is currently enabled.
        :param pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleGroupConditionArgs']]] group_conditions: List of grouped conditions with nested logic. Each group must define a `group_operator` and at least one condition.
        :param pulumi.Input[_builtins.str] group_operator: Logical operator to apply to group conditions. Accepted values are `any` and `all`.
        :param pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleMultivalConditionArgs']]] multival_conditions: List of multival conditions with nested logic. Each multival list must define a `field, operator, group_operator` and at least one condition.
        :param pulumi.Input[_builtins.str] request_logging: Logging behavior for matching requests. Accepted values are `sampled` and `none`.
        :param pulumi.Input[_builtins.str] type: The type of the rule. Accepted values are `request` and `signal`.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if applies_tos is not None:
            pulumi.set(__self__, "applies_tos", applies_tos)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if group_conditions is not None:
            pulumi.set(__self__, "group_conditions", group_conditions)
        if group_operator is not None:
            pulumi.set(__self__, "group_operator", group_operator)
        if multival_conditions is not None:
            pulumi.set(__self__, "multival_conditions", multival_conditions)
        if request_logging is not None:
            pulumi.set(__self__, "request_logging", request_logging)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleActionArgs']]]]:
        """
        List of actions to perform when the rule matches.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter(name="appliesTos")
    def applies_tos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of workspace IDs this signal applies to, or the wildcard `*` if it applies to all workspaces.
        """
        return pulumi.get(self, "applies_tos")

    @applies_tos.setter
    def applies_tos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "applies_tos", value)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleConditionArgs']]]]:
        """
        Flat list of individual conditions. Each must include `field`, `operator`, and `value`.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the rule is currently enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="groupConditions")
    def group_conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleGroupConditionArgs']]]]:
        """
        List of grouped conditions with nested logic. Each group must define a `group_operator` and at least one condition.
        """
        return pulumi.get(self, "group_conditions")

    @group_conditions.setter
    def group_conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleGroupConditionArgs']]]]):
        pulumi.set(self, "group_conditions", value)

    @_builtins.property
    @pulumi.getter(name="groupOperator")
    def group_operator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Logical operator to apply to group conditions. Accepted values are `any` and `all`.
        """
        return pulumi.get(self, "group_operator")

    @group_operator.setter
    def group_operator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_operator", value)

    @_builtins.property
    @pulumi.getter(name="multivalConditions")
    def multival_conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleMultivalConditionArgs']]]]:
        """
        List of multival conditions with nested logic. Each multival list must define a `field, operator, group_operator` and at least one condition.
        """
        return pulumi.get(self, "multival_conditions")

    @multival_conditions.setter
    def multival_conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NgwafAccountRuleMultivalConditionArgs']]]]):
        pulumi.set(self, "multival_conditions", value)

    @_builtins.property
    @pulumi.getter(name="requestLogging")
    def request_logging(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Logging behavior for matching requests. Accepted values are `sampled` and `none`.
        """
        return pulumi.get(self, "request_logging")

    @request_logging.setter
    def request_logging(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_logging", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the rule. Accepted values are `request` and `signal`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("fastly:index/ngwafAccountRule:NgwafAccountRule")
class NgwafAccountRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgwafAccountRuleActionArgs', 'NgwafAccountRuleActionArgsDict']]]]] = None,
                 applies_tos: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgwafAccountRuleConditionArgs', 'NgwafAccountRuleConditionArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgwafAccountRuleGroupConditionArgs', 'NgwafAccountRuleGroupConditionArgsDict']]]]] = None,
                 group_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 multival_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgwafAccountRuleMultivalConditionArgs', 'NgwafAccountRuleMultivalConditionArgsDict']]]]] = None,
                 request_logging: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Fastly Next-Gen WAF Account Rule.\\
        Account-level rules apply across one or more workspaces and are useful for defining shared or global WAF logic.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        example = fastly.NgwafAccountRule("example",
            applies_tos=["*"],
            type="request",
            description="example",
            enabled=True,
            request_logging="sampled",
            group_operator="all",
            actions=[{
                "type": "block",
            }],
            conditions=[{
                "field": "ip",
                "operator": "equals",
                "value": "1.2.3.4",
            }],
            group_conditions=[{
                "group_operator": "all",
                "conditions": [{
                    "field": "method",
                    "operator": "equals",
                    "value": "POST",
                }],
            }])
        ```

        ## Import

        Fastly Next-Gen WAF account rules can be imported using just the rule ID, e.g.:

        ```sh
        $ pulumi import fastly:index/ngwafAccountRule:NgwafAccountRule demo <ruleID>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NgwafAccountRuleActionArgs', 'NgwafAccountRuleActionArgsDict']]]] actions: List of actions to perform when the rule matches.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applies_tos: The list of workspace IDs this signal applies to, or the wildcard `*` if it applies to all workspaces.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NgwafAccountRuleConditionArgs', 'NgwafAccountRuleConditionArgsDict']]]] conditions: Flat list of individual conditions. Each must include `field`, `operator`, and `value`.
        :param pulumi.Input[_builtins.str] description: The description of the rule.
        :param pulumi.Input[_builtins.bool] enabled: Whether the rule is currently enabled.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NgwafAccountRuleGroupConditionArgs', 'NgwafAccountRuleGroupConditionArgsDict']]]] group_conditions: List of grouped conditions with nested logic. Each group must define a `group_operator` and at least one condition.
        :param pulumi.Input[_builtins.str] group_operator: Logical operator to apply to group conditions. Accepted values are `any` and `all`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NgwafAccountRuleMultivalConditionArgs', 'NgwafAccountRuleMultivalConditionArgsDict']]]] multival_conditions: List of multival conditions with nested logic. Each multival list must define a `field, operator, group_operator` and at least one condition.
        :param pulumi.Input[_builtins.str] request_logging: Logging behavior for matching requests. Accepted values are `sampled` and `none`.
        :param pulumi.Input[_builtins.str] type: The type of the rule. Accepted values are `request` and `signal`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NgwafAccountRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Fastly Next-Gen WAF Account Rule.\\
        Account-level rules apply across one or more workspaces and are useful for defining shared or global WAF logic.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        example = fastly.NgwafAccountRule("example",
            applies_tos=["*"],
            type="request",
            description="example",
            enabled=True,
            request_logging="sampled",
            group_operator="all",
            actions=[{
                "type": "block",
            }],
            conditions=[{
                "field": "ip",
                "operator": "equals",
                "value": "1.2.3.4",
            }],
            group_conditions=[{
                "group_operator": "all",
                "conditions": [{
                    "field": "method",
                    "operator": "equals",
                    "value": "POST",
                }],
            }])
        ```

        ## Import

        Fastly Next-Gen WAF account rules can be imported using just the rule ID, e.g.:

        ```sh
        $ pulumi import fastly:index/ngwafAccountRule:NgwafAccountRule demo <ruleID>
        ```

        :param str resource_name: The name of the resource.
        :param NgwafAccountRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NgwafAccountRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgwafAccountRuleActionArgs', 'NgwafAccountRuleActionArgsDict']]]]] = None,
                 applies_tos: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgwafAccountRuleConditionArgs', 'NgwafAccountRuleConditionArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgwafAccountRuleGroupConditionArgs', 'NgwafAccountRuleGroupConditionArgsDict']]]]] = None,
                 group_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 multival_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgwafAccountRuleMultivalConditionArgs', 'NgwafAccountRuleMultivalConditionArgsDict']]]]] = None,
                 request_logging: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NgwafAccountRuleArgs.__new__(NgwafAccountRuleArgs)

            if actions is None and not opts.urn:
                raise TypeError("Missing required property 'actions'")
            __props__.__dict__["actions"] = actions
            if applies_tos is None and not opts.urn:
                raise TypeError("Missing required property 'applies_tos'")
            __props__.__dict__["applies_tos"] = applies_tos
            __props__.__dict__["conditions"] = conditions
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["group_conditions"] = group_conditions
            __props__.__dict__["group_operator"] = group_operator
            __props__.__dict__["multival_conditions"] = multival_conditions
            __props__.__dict__["request_logging"] = request_logging
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(NgwafAccountRule, __self__).__init__(
            'fastly:index/ngwafAccountRule:NgwafAccountRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgwafAccountRuleActionArgs', 'NgwafAccountRuleActionArgsDict']]]]] = None,
            applies_tos: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgwafAccountRuleConditionArgs', 'NgwafAccountRuleConditionArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            group_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgwafAccountRuleGroupConditionArgs', 'NgwafAccountRuleGroupConditionArgsDict']]]]] = None,
            group_operator: Optional[pulumi.Input[_builtins.str]] = None,
            multival_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgwafAccountRuleMultivalConditionArgs', 'NgwafAccountRuleMultivalConditionArgsDict']]]]] = None,
            request_logging: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'NgwafAccountRule':
        """
        Get an existing NgwafAccountRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NgwafAccountRuleActionArgs', 'NgwafAccountRuleActionArgsDict']]]] actions: List of actions to perform when the rule matches.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applies_tos: The list of workspace IDs this signal applies to, or the wildcard `*` if it applies to all workspaces.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NgwafAccountRuleConditionArgs', 'NgwafAccountRuleConditionArgsDict']]]] conditions: Flat list of individual conditions. Each must include `field`, `operator`, and `value`.
        :param pulumi.Input[_builtins.str] description: The description of the rule.
        :param pulumi.Input[_builtins.bool] enabled: Whether the rule is currently enabled.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NgwafAccountRuleGroupConditionArgs', 'NgwafAccountRuleGroupConditionArgsDict']]]] group_conditions: List of grouped conditions with nested logic. Each group must define a `group_operator` and at least one condition.
        :param pulumi.Input[_builtins.str] group_operator: Logical operator to apply to group conditions. Accepted values are `any` and `all`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NgwafAccountRuleMultivalConditionArgs', 'NgwafAccountRuleMultivalConditionArgsDict']]]] multival_conditions: List of multival conditions with nested logic. Each multival list must define a `field, operator, group_operator` and at least one condition.
        :param pulumi.Input[_builtins.str] request_logging: Logging behavior for matching requests. Accepted values are `sampled` and `none`.
        :param pulumi.Input[_builtins.str] type: The type of the rule. Accepted values are `request` and `signal`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NgwafAccountRuleState.__new__(_NgwafAccountRuleState)

        __props__.__dict__["actions"] = actions
        __props__.__dict__["applies_tos"] = applies_tos
        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["group_conditions"] = group_conditions
        __props__.__dict__["group_operator"] = group_operator
        __props__.__dict__["multival_conditions"] = multival_conditions
        __props__.__dict__["request_logging"] = request_logging
        __props__.__dict__["type"] = type
        return NgwafAccountRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> pulumi.Output[Sequence['outputs.NgwafAccountRuleAction']]:
        """
        List of actions to perform when the rule matches.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter(name="appliesTos")
    def applies_tos(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of workspace IDs this signal applies to, or the wildcard `*` if it applies to all workspaces.
        """
        return pulumi.get(self, "applies_tos")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Optional[Sequence['outputs.NgwafAccountRuleCondition']]]:
        """
        Flat list of individual conditions. Each must include `field`, `operator`, and `value`.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the rule is currently enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="groupConditions")
    def group_conditions(self) -> pulumi.Output[Optional[Sequence['outputs.NgwafAccountRuleGroupCondition']]]:
        """
        List of grouped conditions with nested logic. Each group must define a `group_operator` and at least one condition.
        """
        return pulumi.get(self, "group_conditions")

    @_builtins.property
    @pulumi.getter(name="groupOperator")
    def group_operator(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Logical operator to apply to group conditions. Accepted values are `any` and `all`.
        """
        return pulumi.get(self, "group_operator")

    @_builtins.property
    @pulumi.getter(name="multivalConditions")
    def multival_conditions(self) -> pulumi.Output[Optional[Sequence['outputs.NgwafAccountRuleMultivalCondition']]]:
        """
        List of multival conditions with nested logic. Each multival list must define a `field, operator, group_operator` and at least one condition.
        """
        return pulumi.get(self, "multival_conditions")

    @_builtins.property
    @pulumi.getter(name="requestLogging")
    def request_logging(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Logging behavior for matching requests. Accepted values are `sampled` and `none`.
        """
        return pulumi.get(self, "request_logging")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the rule. Accepted values are `request` and `signal`.
        """
        return pulumi.get(self, "type")

