# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['NgwafAlertOpsgenieIntegrationArgs', 'NgwafAlertOpsgenieIntegration']

@pulumi.input_type
class NgwafAlertOpsgenieIntegrationArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[_builtins.str],
                 workspace_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NgwafAlertOpsgenieIntegration resource.
        :param pulumi.Input[_builtins.str] key: The Opsgenie key.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        :param pulumi.Input[_builtins.str] description: The description of the alert.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        The Opsgenie key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the alert.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _NgwafAlertOpsgenieIntegrationState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NgwafAlertOpsgenieIntegration resources.
        :param pulumi.Input[_builtins.str] description: The description of the alert.
        :param pulumi.Input[_builtins.str] key: The Opsgenie key.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the alert.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Opsgenie key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("fastly:index/ngwafAlertOpsgenieIntegration:NgwafAlertOpsgenieIntegration")
class NgwafAlertOpsgenieIntegration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides Fastly Next-Gen WAF Alert Opsgenie integrations, which provide a connection to Opsgenie.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        demo_opsgenie_alert = fastly.NgwafAlertOpsgenieIntegration("demo_opsgenie_alert",
            description="A description",
            key="123456789",
            workspace_id=demo["id"])
        ```

        ## Import

        Fastly Next-Gen WAF Alert Opsgenie integrations can be imported using their ID and the ID of the workspace they belong to.

        ```sh
        $ pulumi import fastly:index/ngwafAlertOpsgenieIntegration:NgwafAlertOpsgenieIntegration example <workspace_id>/<alert_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the alert.
        :param pulumi.Input[_builtins.str] key: The Opsgenie key.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NgwafAlertOpsgenieIntegrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides Fastly Next-Gen WAF Alert Opsgenie integrations, which provide a connection to Opsgenie.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        demo_opsgenie_alert = fastly.NgwafAlertOpsgenieIntegration("demo_opsgenie_alert",
            description="A description",
            key="123456789",
            workspace_id=demo["id"])
        ```

        ## Import

        Fastly Next-Gen WAF Alert Opsgenie integrations can be imported using their ID and the ID of the workspace they belong to.

        ```sh
        $ pulumi import fastly:index/ngwafAlertOpsgenieIntegration:NgwafAlertOpsgenieIntegration example <workspace_id>/<alert_id>
        ```

        :param str resource_name: The name of the resource.
        :param NgwafAlertOpsgenieIntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NgwafAlertOpsgenieIntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NgwafAlertOpsgenieIntegrationArgs.__new__(NgwafAlertOpsgenieIntegrationArgs)

            __props__.__dict__["description"] = description
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = None if key is None else pulumi.Output.secret(key)
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["key"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(NgwafAlertOpsgenieIntegration, __self__).__init__(
            'fastly:index/ngwafAlertOpsgenieIntegration:NgwafAlertOpsgenieIntegration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'NgwafAlertOpsgenieIntegration':
        """
        Get an existing NgwafAlertOpsgenieIntegration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the alert.
        :param pulumi.Input[_builtins.str] key: The Opsgenie key.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NgwafAlertOpsgenieIntegrationState.__new__(_NgwafAlertOpsgenieIntegrationState)

        __props__.__dict__["description"] = description
        __props__.__dict__["key"] = key
        __props__.__dict__["workspace_id"] = workspace_id
        return NgwafAlertOpsgenieIntegration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the alert.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[_builtins.str]:
        """
        The Opsgenie key.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

