# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['NgwafVirtualPatchesArgs', 'NgwafVirtualPatches']

@pulumi.input_type
class NgwafVirtualPatchesArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 enabled: pulumi.Input[_builtins.bool],
                 virtual_patch_id: pulumi.Input[_builtins.str],
                 workspace_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a NgwafVirtualPatches resource.
        :param pulumi.Input[_builtins.str] action: Action to take when a signal for virtual patch is detected. Accepted values are `log` and `block`.
        :param pulumi.Input[_builtins.bool] enabled: Control for enabling and disabling a virtual patch.
        :param pulumi.Input[_builtins.str] virtual_patch_id: The ID of the virtual patch.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "virtual_patch_id", virtual_patch_id)
        pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        Action to take when a signal for virtual patch is detected. Accepted values are `log` and `block`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Control for enabling and disabling a virtual patch.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="virtualPatchId")
    def virtual_patch_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the virtual patch.
        """
        return pulumi.get(self, "virtual_patch_id")

    @virtual_patch_id.setter
    def virtual_patch_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "virtual_patch_id", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class _NgwafVirtualPatchesState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 virtual_patch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NgwafVirtualPatches resources.
        :param pulumi.Input[_builtins.str] action: Action to take when a signal for virtual patch is detected. Accepted values are `log` and `block`.
        :param pulumi.Input[_builtins.bool] enabled: Control for enabling and disabling a virtual patch.
        :param pulumi.Input[_builtins.str] virtual_patch_id: The ID of the virtual patch.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if virtual_patch_id is not None:
            pulumi.set(__self__, "virtual_patch_id", virtual_patch_id)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Action to take when a signal for virtual patch is detected. Accepted values are `log` and `block`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Control for enabling and disabling a virtual patch.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="virtualPatchId")
    def virtual_patch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the virtual patch.
        """
        return pulumi.get(self, "virtual_patch_id")

    @virtual_patch_id.setter
    def virtual_patch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_patch_id", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("fastly:index/ngwafVirtualPatches:NgwafVirtualPatches")
class NgwafVirtualPatches(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 virtual_patch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Fastly Next-Gen WAF Virtual Patch.  Virtual patching
        rules block or log requests matching specific vulnerabilities.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        demo = fastly.NgwafVirtualPatches("demo",
            action="block",
            enabled=True,
            virtual_patch_id="CVE-2017-5638",
            workspace_id=demo_fastly_ngwaf_workspace["id"])
        ```

        ## Import

        Fastly Next-Gen WAF Virtual Patches can be imported using their workspace and Virtual Patch ID, e.g.

        ```sh
        $ pulumi import fastly:index/ngwafVirtualPatches:NgwafVirtualPatches demo <workspace_id>/<virtual_patch_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: Action to take when a signal for virtual patch is detected. Accepted values are `log` and `block`.
        :param pulumi.Input[_builtins.bool] enabled: Control for enabling and disabling a virtual patch.
        :param pulumi.Input[_builtins.str] virtual_patch_id: The ID of the virtual patch.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NgwafVirtualPatchesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Fastly Next-Gen WAF Virtual Patch.  Virtual patching
        rules block or log requests matching specific vulnerabilities.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        demo = fastly.NgwafVirtualPatches("demo",
            action="block",
            enabled=True,
            virtual_patch_id="CVE-2017-5638",
            workspace_id=demo_fastly_ngwaf_workspace["id"])
        ```

        ## Import

        Fastly Next-Gen WAF Virtual Patches can be imported using their workspace and Virtual Patch ID, e.g.

        ```sh
        $ pulumi import fastly:index/ngwafVirtualPatches:NgwafVirtualPatches demo <workspace_id>/<virtual_patch_id>
        ```

        :param str resource_name: The name of the resource.
        :param NgwafVirtualPatchesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NgwafVirtualPatchesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 virtual_patch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NgwafVirtualPatchesArgs.__new__(NgwafVirtualPatchesArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if virtual_patch_id is None and not opts.urn:
                raise TypeError("Missing required property 'virtual_patch_id'")
            __props__.__dict__["virtual_patch_id"] = virtual_patch_id
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
        super(NgwafVirtualPatches, __self__).__init__(
            'fastly:index/ngwafVirtualPatches:NgwafVirtualPatches',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            virtual_patch_id: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'NgwafVirtualPatches':
        """
        Get an existing NgwafVirtualPatches resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: Action to take when a signal for virtual patch is detected. Accepted values are `log` and `block`.
        :param pulumi.Input[_builtins.bool] enabled: Control for enabling and disabling a virtual patch.
        :param pulumi.Input[_builtins.str] virtual_patch_id: The ID of the virtual patch.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NgwafVirtualPatchesState.__new__(_NgwafVirtualPatchesState)

        __props__.__dict__["action"] = action
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["virtual_patch_id"] = virtual_patch_id
        __props__.__dict__["workspace_id"] = workspace_id
        return NgwafVirtualPatches(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[_builtins.str]:
        """
        Action to take when a signal for virtual patch is detected. Accepted values are `log` and `block`.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Control for enabling and disabling a virtual patch.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="virtualPatchId")
    def virtual_patch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the virtual patch.
        """
        return pulumi.get(self, "virtual_patch_id")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

