<a id="mypy-boto3-medialive"></a>

# mypy-boto3-medialive

[![PyPI - mypy-boto3-medialive](https://img.shields.io/pypi/v/mypy-boto3-medialive.svg?color=blue)](https://pypi.org/project/mypy-boto3-medialive)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-medialive.svg?color=blue)](https://pypi.org/project/mypy-boto3-medialive)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-medialive?color=blue)](https://pypistats.org/packages/mypy-boto3-medialive)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.MediaLive 1.18.30](https://boto3.amazonaws.com/v1/documentation/api/1.18.30/reference/services/medialive.html#MediaLive)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-medialive docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_medialive/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-medialive](#mypy-boto3-medialive)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `MediaLive` service.

```bash
python -m pip install boto3-stubs[medialive]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[medialive]` in your environment:
  `python -m pip install 'boto3-stubs[medialive]'`

Both type checking and auto-complete should work for `MediaLive` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[medialive]` in your environment:
  `python -m pip install 'boto3-stubs[medialive]'`

Both type checking and auto-complete should work for `MediaLive` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[medialive]` in your environment:
  `python -m pip install 'boto3-stubs[medialive]'`
- Run `mypy` as usual

Type checking should work for `MediaLive` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[medialive]` in your environment:
  `python -m pip install 'boto3-stubs[medialive]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `MediaLive` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`MediaLiveClient` provides annotations for `boto3.client("medialive")`.

```python
import boto3

from mypy_boto3_medialive import MediaLiveClient

client: MediaLiveClient = boto3.client("medialive")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: MediaLiveClient = session.client("medialive")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_medialive.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_medialive import MediaLiveClient
from mypy_boto3_medialive.paginator import (
    DescribeSchedulePaginator,
    ListChannelsPaginator,
    ListInputDeviceTransfersPaginator,
    ListInputDevicesPaginator,
    ListInputSecurityGroupsPaginator,
    ListInputsPaginator,
    ListMultiplexProgramsPaginator,
    ListMultiplexesPaginator,
    ListOfferingsPaginator,
    ListReservationsPaginator,
)

client: MediaLiveClient = boto3.client("medialive")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_schedule_paginator: DescribeSchedulePaginator = client.get_paginator("describe_schedule")
list_channels_paginator: ListChannelsPaginator = client.get_paginator("list_channels")
list_input_device_transfers_paginator: ListInputDeviceTransfersPaginator = client.get_paginator("list_input_device_transfers")
list_input_devices_paginator: ListInputDevicesPaginator = client.get_paginator("list_input_devices")
list_input_security_groups_paginator: ListInputSecurityGroupsPaginator = client.get_paginator("list_input_security_groups")
list_inputs_paginator: ListInputsPaginator = client.get_paginator("list_inputs")
list_multiplex_programs_paginator: ListMultiplexProgramsPaginator = client.get_paginator("list_multiplex_programs")
list_multiplexes_paginator: ListMultiplexesPaginator = client.get_paginator("list_multiplexes")
list_offerings_paginator: ListOfferingsPaginator = client.get_paginator("list_offerings")
list_reservations_paginator: ListReservationsPaginator = client.get_paginator("list_reservations")
```

<a id="waiters-annotations"></a>

### Waiters annotations

`mypy_boto3_medialive.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_medialive import MediaLiveClient
from mypy_boto3_medialive.waiter import (
    ChannelCreatedWaiter,
    ChannelDeletedWaiter,
    ChannelRunningWaiter,
    ChannelStoppedWaiter,
    InputAttachedWaiter,
    InputDeletedWaiter,
    InputDetachedWaiter,
    MultiplexCreatedWaiter,
    MultiplexDeletedWaiter,
    MultiplexRunningWaiter,
    MultiplexStoppedWaiter,
)

client: MediaLiveClient = boto3.client("medialive")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
channel_created_waiter: ChannelCreatedWaiter = client.get_waiter("channel_created")
channel_deleted_waiter: ChannelDeletedWaiter = client.get_waiter("channel_deleted")
channel_running_waiter: ChannelRunningWaiter = client.get_waiter("channel_running")
channel_stopped_waiter: ChannelStoppedWaiter = client.get_waiter("channel_stopped")
input_attached_waiter: InputAttachedWaiter = client.get_waiter("input_attached")
input_deleted_waiter: InputDeletedWaiter = client.get_waiter("input_deleted")
input_detached_waiter: InputDetachedWaiter = client.get_waiter("input_detached")
multiplex_created_waiter: MultiplexCreatedWaiter = client.get_waiter("multiplex_created")
multiplex_deleted_waiter: MultiplexDeletedWaiter = client.get_waiter("multiplex_deleted")
multiplex_running_waiter: MultiplexRunningWaiter = client.get_waiter("multiplex_running")
multiplex_stopped_waiter: MultiplexStoppedWaiter = client.get_waiter("multiplex_stopped")
```

<a id="literals"></a>

### Literals

`mypy_boto3_medialive.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_medialive.literals import (
    AacCodingModeType,
    AacInputTypeType,
    AacProfileType,
    AacRateControlModeType,
    AacRawFormatType,
    AacSpecType,
    AacVbrQualityType,
    Ac3BitstreamModeType,
    Ac3CodingModeType,
    Ac3DrcProfileType,
    Ac3LfeFilterType,
    Ac3MetadataControlType,
    AcceptHeaderType,
    AfdSignalingType,
    AudioDescriptionAudioTypeControlType,
    AudioDescriptionLanguageCodeControlType,
    AudioLanguageSelectionPolicyType,
    AudioNormalizationAlgorithmControlType,
    AudioNormalizationAlgorithmType,
    AudioOnlyHlsSegmentTypeType,
    AudioOnlyHlsTrackTypeType,
    AudioTypeType,
    AuthenticationSchemeType,
    AvailBlankingStateType,
    BlackoutSlateNetworkEndBlackoutType,
    BlackoutSlateStateType,
    BurnInAlignmentType,
    BurnInBackgroundColorType,
    BurnInFontColorType,
    BurnInOutlineColorType,
    BurnInShadowColorType,
    BurnInTeletextGridControlType,
    CdiInputResolutionType,
    ChannelClassType,
    ChannelCreatedWaiterName,
    ChannelDeletedWaiterName,
    ChannelRunningWaiterName,
    ChannelStateType,
    ChannelStoppedWaiterName,
    ContentTypeType,
    DescribeSchedulePaginatorName,
    DeviceSettingsSyncStateType,
    DeviceUpdateStatusType,
    DvbSdtOutputSdtType,
    DvbSubDestinationAlignmentType,
    DvbSubDestinationBackgroundColorType,
    DvbSubDestinationFontColorType,
    DvbSubDestinationOutlineColorType,
    DvbSubDestinationShadowColorType,
    DvbSubDestinationTeletextGridControlType,
    DvbSubOcrLanguageType,
    Eac3AttenuationControlType,
    Eac3BitstreamModeType,
    Eac3CodingModeType,
    Eac3DcFilterType,
    Eac3DrcLineType,
    Eac3DrcRfType,
    Eac3LfeControlType,
    Eac3LfeFilterType,
    Eac3MetadataControlType,
    Eac3PassthroughControlType,
    Eac3PhaseControlType,
    Eac3StereoDownmixType,
    Eac3SurroundExModeType,
    Eac3SurroundModeType,
    EbuTtDDestinationStyleControlType,
    EbuTtDFillLineGapControlType,
    EmbeddedConvert608To708Type,
    EmbeddedScte20DetectionType,
    FeatureActivationsInputPrepareScheduleActionsType,
    FecOutputIncludeFecType,
    FixedAfdType,
    Fmp4NielsenId3BehaviorType,
    Fmp4TimedMetadataBehaviorType,
    FollowPointType,
    FrameCaptureIntervalUnitType,
    GlobalConfigurationInputEndActionType,
    GlobalConfigurationLowFramerateInputsType,
    GlobalConfigurationOutputLockingModeType,
    GlobalConfigurationOutputTimingSourceType,
    H264AdaptiveQuantizationType,
    H264ColorMetadataType,
    H264EntropyEncodingType,
    H264FlickerAqType,
    H264ForceFieldPicturesType,
    H264FramerateControlType,
    H264GopBReferenceType,
    H264GopSizeUnitsType,
    H264LevelType,
    H264LookAheadRateControlType,
    H264ParControlType,
    H264ProfileType,
    H264QualityLevelType,
    H264RateControlModeType,
    H264ScanTypeType,
    H264SceneChangeDetectType,
    H264SpatialAqType,
    H264SubGopLengthType,
    H264SyntaxType,
    H264TemporalAqType,
    H264TimecodeInsertionBehaviorType,
    H265AdaptiveQuantizationType,
    H265AlternativeTransferFunctionType,
    H265ColorMetadataType,
    H265FlickerAqType,
    H265GopSizeUnitsType,
    H265LevelType,
    H265LookAheadRateControlType,
    H265ProfileType,
    H265RateControlModeType,
    H265ScanTypeType,
    H265SceneChangeDetectType,
    H265TierType,
    H265TimecodeInsertionBehaviorType,
    HlsAdMarkersType,
    HlsAkamaiHttpTransferModeType,
    HlsCaptionLanguageSettingType,
    HlsClientCacheType,
    HlsCodecSpecificationType,
    HlsDirectoryStructureType,
    HlsDiscontinuityTagsType,
    HlsEncryptionTypeType,
    HlsH265PackagingTypeType,
    HlsId3SegmentTaggingStateType,
    HlsIncompleteSegmentBehaviorType,
    HlsIvInManifestType,
    HlsIvSourceType,
    HlsManifestCompressionType,
    HlsManifestDurationFormatType,
    HlsMediaStoreStorageClassType,
    HlsModeType,
    HlsOutputSelectionType,
    HlsProgramDateTimeType,
    HlsRedundantManifestType,
    HlsScte35SourceTypeType,
    HlsSegmentationModeType,
    HlsStreamInfResolutionType,
    HlsTimedMetadataId3FrameType,
    HlsTsFileModeType,
    HlsWebdavHttpTransferModeType,
    IFrameOnlyPlaylistTypeType,
    InputAttachedWaiterName,
    InputClassType,
    InputCodecType,
    InputDeblockFilterType,
    InputDeletedWaiterName,
    InputDenoiseFilterType,
    InputDetachedWaiterName,
    InputDeviceActiveInputType,
    InputDeviceConfiguredInputType,
    InputDeviceConnectionStateType,
    InputDeviceIpSchemeType,
    InputDeviceScanTypeType,
    InputDeviceStateType,
    InputDeviceTransferTypeType,
    InputDeviceTypeType,
    InputFilterType,
    InputLossActionForHlsOutType,
    InputLossActionForMsSmoothOutType,
    InputLossActionForRtmpOutType,
    InputLossActionForUdpOutType,
    InputLossImageTypeType,
    InputMaximumBitrateType,
    InputPreferenceType,
    InputResolutionType,
    InputSecurityGroupStateType,
    InputSourceEndBehaviorType,
    InputSourceTypeType,
    InputStateType,
    InputTimecodeSourceType,
    InputTypeType,
    LastFrameClippingBehaviorType,
    ListChannelsPaginatorName,
    ListInputDeviceTransfersPaginatorName,
    ListInputDevicesPaginatorName,
    ListInputSecurityGroupsPaginatorName,
    ListInputsPaginatorName,
    ListMultiplexProgramsPaginatorName,
    ListMultiplexesPaginatorName,
    ListOfferingsPaginatorName,
    ListReservationsPaginatorName,
    LogLevelType,
    M2tsAbsentInputAudioBehaviorType,
    M2tsAribCaptionsPidControlType,
    M2tsAribType,
    M2tsAudioBufferModelType,
    M2tsAudioIntervalType,
    M2tsAudioStreamTypeType,
    M2tsBufferModelType,
    M2tsCcDescriptorType,
    M2tsEbifControlType,
    M2tsEbpPlacementType,
    M2tsEsRateInPesType,
    M2tsKlvType,
    M2tsNielsenId3BehaviorType,
    M2tsPcrControlType,
    M2tsRateModeType,
    M2tsScte35ControlType,
    M2tsSegmentationMarkersType,
    M2tsSegmentationStyleType,
    M2tsTimedMetadataBehaviorType,
    M3u8NielsenId3BehaviorType,
    M3u8PcrControlType,
    M3u8Scte35BehaviorType,
    M3u8TimedMetadataBehaviorType,
    MotionGraphicsInsertionType,
    Mp2CodingModeType,
    Mpeg2AdaptiveQuantizationType,
    Mpeg2ColorMetadataType,
    Mpeg2ColorSpaceType,
    Mpeg2DisplayRatioType,
    Mpeg2GopSizeUnitsType,
    Mpeg2ScanTypeType,
    Mpeg2SubGopLengthType,
    Mpeg2TimecodeInsertionBehaviorType,
    MsSmoothH265PackagingTypeType,
    MultiplexCreatedWaiterName,
    MultiplexDeletedWaiterName,
    MultiplexRunningWaiterName,
    MultiplexStateType,
    MultiplexStoppedWaiterName,
    NetworkInputServerValidationType,
    NielsenPcmToId3TaggingStateType,
    OfferingDurationUnitsType,
    OfferingTypeType,
    PipelineIdType,
    PreferredChannelPipelineType,
    ReservationCodecType,
    ReservationMaximumBitrateType,
    ReservationMaximumFramerateType,
    ReservationResolutionType,
    ReservationResourceTypeType,
    ReservationSpecialFeatureType,
    ReservationStateType,
    ReservationVideoQualityType,
    RtmpAdMarkersType,
    RtmpCacheFullBehaviorType,
    RtmpCaptionDataType,
    RtmpOutputCertificateModeType,
    S3CannedAclType,
    Scte20Convert608To708Type,
    Scte27OcrLanguageType,
    Scte35AposNoRegionalBlackoutBehaviorType,
    Scte35AposWebDeliveryAllowedBehaviorType,
    Scte35ArchiveAllowedFlagType,
    Scte35DeviceRestrictionsType,
    Scte35NoRegionalBlackoutFlagType,
    Scte35SegmentationCancelIndicatorType,
    Scte35SpliceInsertNoRegionalBlackoutBehaviorType,
    Scte35SpliceInsertWebDeliveryAllowedBehaviorType,
    Scte35WebDeliveryAllowedFlagType,
    SmoothGroupAudioOnlyTimecodeControlType,
    SmoothGroupCertificateModeType,
    SmoothGroupEventIdModeType,
    SmoothGroupEventStopBehaviorType,
    SmoothGroupSegmentationModeType,
    SmoothGroupSparseTrackTypeType,
    SmoothGroupStreamManifestBehaviorType,
    SmoothGroupTimestampOffsetModeType,
    Smpte2038DataPreferenceType,
    TemporalFilterPostFilterSharpeningType,
    TemporalFilterStrengthType,
    TimecodeConfigSourceType,
    TtmlDestinationStyleControlType,
    UdpTimedMetadataId3FrameType,
    VideoDescriptionRespondToAfdType,
    VideoDescriptionScalingBehaviorType,
    VideoSelectorColorSpaceType,
    VideoSelectorColorSpaceUsageType,
    WavCodingModeType,
    WebvttDestinationStyleControlType,
)

def check_value(value: AacCodingModeType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_medialive.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_medialive.type_defs import (
    AacSettingsTypeDef,
    Ac3SettingsTypeDef,
    AcceptInputDeviceTransferRequestRequestTypeDef,
    AncillarySourceSettingsTypeDef,
    ArchiveCdnSettingsTypeDef,
    ArchiveContainerSettingsTypeDef,
    ArchiveGroupSettingsTypeDef,
    ArchiveOutputSettingsTypeDef,
    ArchiveS3SettingsTypeDef,
    AudioChannelMappingTypeDef,
    AudioCodecSettingsTypeDef,
    AudioDescriptionTypeDef,
    AudioHlsRenditionSelectionTypeDef,
    AudioLanguageSelectionTypeDef,
    AudioNormalizationSettingsTypeDef,
    AudioOnlyHlsSettingsTypeDef,
    AudioPidSelectionTypeDef,
    AudioSelectorSettingsTypeDef,
    AudioSelectorTypeDef,
    AudioSilenceFailoverSettingsTypeDef,
    AudioTrackSelectionTypeDef,
    AudioTrackTypeDef,
    AutomaticInputFailoverSettingsTypeDef,
    AvailBlankingTypeDef,
    AvailConfigurationTypeDef,
    AvailSettingsTypeDef,
    BatchDeleteRequestRequestTypeDef,
    BatchDeleteResponseTypeDef,
    BatchFailedResultModelTypeDef,
    BatchScheduleActionCreateRequestTypeDef,
    BatchScheduleActionCreateResultTypeDef,
    BatchScheduleActionDeleteRequestTypeDef,
    BatchScheduleActionDeleteResultTypeDef,
    BatchStartRequestRequestTypeDef,
    BatchStartResponseTypeDef,
    BatchStopRequestRequestTypeDef,
    BatchStopResponseTypeDef,
    BatchSuccessfulResultModelTypeDef,
    BatchUpdateScheduleRequestRequestTypeDef,
    BatchUpdateScheduleResponseTypeDef,
    BlackoutSlateTypeDef,
    BurnInDestinationSettingsTypeDef,
    CancelInputDeviceTransferRequestRequestTypeDef,
    CaptionDescriptionTypeDef,
    CaptionDestinationSettingsTypeDef,
    CaptionLanguageMappingTypeDef,
    CaptionRectangleTypeDef,
    CaptionSelectorSettingsTypeDef,
    CaptionSelectorTypeDef,
    CdiInputSpecificationTypeDef,
    ChannelEgressEndpointTypeDef,
    ChannelSummaryTypeDef,
    ChannelTypeDef,
    CreateChannelRequestRequestTypeDef,
    CreateChannelResponseTypeDef,
    CreateInputRequestRequestTypeDef,
    CreateInputResponseTypeDef,
    CreateInputSecurityGroupRequestRequestTypeDef,
    CreateInputSecurityGroupResponseTypeDef,
    CreateMultiplexProgramRequestRequestTypeDef,
    CreateMultiplexProgramResponseTypeDef,
    CreateMultiplexRequestRequestTypeDef,
    CreateMultiplexResponseTypeDef,
    CreatePartnerInputRequestRequestTypeDef,
    CreatePartnerInputResponseTypeDef,
    CreateTagsRequestRequestTypeDef,
    DeleteChannelRequestRequestTypeDef,
    DeleteChannelResponseTypeDef,
    DeleteInputRequestRequestTypeDef,
    DeleteInputSecurityGroupRequestRequestTypeDef,
    DeleteMultiplexProgramRequestRequestTypeDef,
    DeleteMultiplexProgramResponseTypeDef,
    DeleteMultiplexRequestRequestTypeDef,
    DeleteMultiplexResponseTypeDef,
    DeleteReservationRequestRequestTypeDef,
    DeleteReservationResponseTypeDef,
    DeleteScheduleRequestRequestTypeDef,
    DeleteTagsRequestRequestTypeDef,
    DescribeChannelRequestRequestTypeDef,
    DescribeChannelResponseTypeDef,
    DescribeInputDeviceRequestRequestTypeDef,
    DescribeInputDeviceResponseTypeDef,
    DescribeInputDeviceThumbnailRequestRequestTypeDef,
    DescribeInputDeviceThumbnailResponseTypeDef,
    DescribeInputRequestRequestTypeDef,
    DescribeInputResponseTypeDef,
    DescribeInputSecurityGroupRequestRequestTypeDef,
    DescribeInputSecurityGroupResponseTypeDef,
    DescribeMultiplexProgramRequestRequestTypeDef,
    DescribeMultiplexProgramResponseTypeDef,
    DescribeMultiplexRequestRequestTypeDef,
    DescribeMultiplexResponseTypeDef,
    DescribeOfferingRequestRequestTypeDef,
    DescribeOfferingResponseTypeDef,
    DescribeReservationRequestRequestTypeDef,
    DescribeReservationResponseTypeDef,
    DescribeScheduleRequestRequestTypeDef,
    DescribeScheduleResponseTypeDef,
    DvbNitSettingsTypeDef,
    DvbSdtSettingsTypeDef,
    DvbSubDestinationSettingsTypeDef,
    DvbSubSourceSettingsTypeDef,
    DvbTdtSettingsTypeDef,
    Eac3SettingsTypeDef,
    EbuTtDDestinationSettingsTypeDef,
    EmbeddedSourceSettingsTypeDef,
    EncoderSettingsTypeDef,
    FailoverConditionSettingsTypeDef,
    FailoverConditionTypeDef,
    FeatureActivationsTypeDef,
    FecOutputSettingsTypeDef,
    FixedModeScheduleActionStartSettingsTypeDef,
    Fmp4HlsSettingsTypeDef,
    FollowModeScheduleActionStartSettingsTypeDef,
    FrameCaptureCdnSettingsTypeDef,
    FrameCaptureGroupSettingsTypeDef,
    FrameCaptureOutputSettingsTypeDef,
    FrameCaptureS3SettingsTypeDef,
    FrameCaptureSettingsTypeDef,
    GlobalConfigurationTypeDef,
    H264ColorSpaceSettingsTypeDef,
    H264FilterSettingsTypeDef,
    H264SettingsTypeDef,
    H265ColorSpaceSettingsTypeDef,
    H265FilterSettingsTypeDef,
    H265SettingsTypeDef,
    Hdr10SettingsTypeDef,
    HlsAkamaiSettingsTypeDef,
    HlsBasicPutSettingsTypeDef,
    HlsCdnSettingsTypeDef,
    HlsGroupSettingsTypeDef,
    HlsId3SegmentTaggingScheduleActionSettingsTypeDef,
    HlsInputSettingsTypeDef,
    HlsMediaStoreSettingsTypeDef,
    HlsOutputSettingsTypeDef,
    HlsS3SettingsTypeDef,
    HlsSettingsTypeDef,
    HlsTimedMetadataScheduleActionSettingsTypeDef,
    HlsWebdavSettingsTypeDef,
    InputAttachmentTypeDef,
    InputChannelLevelTypeDef,
    InputClippingSettingsTypeDef,
    InputDestinationRequestTypeDef,
    InputDestinationTypeDef,
    InputDestinationVpcTypeDef,
    InputDeviceConfigurableSettingsTypeDef,
    InputDeviceHdSettingsTypeDef,
    InputDeviceNetworkSettingsTypeDef,
    InputDeviceRequestTypeDef,
    InputDeviceSettingsTypeDef,
    InputDeviceSummaryTypeDef,
    InputDeviceUhdSettingsTypeDef,
    InputLocationTypeDef,
    InputLossBehaviorTypeDef,
    InputLossFailoverSettingsTypeDef,
    InputPrepareScheduleActionSettingsTypeDef,
    InputSecurityGroupTypeDef,
    InputSettingsTypeDef,
    InputSourceRequestTypeDef,
    InputSourceTypeDef,
    InputSpecificationTypeDef,
    InputSwitchScheduleActionSettingsTypeDef,
    InputTypeDef,
    InputVpcRequestTypeDef,
    InputWhitelistRuleCidrTypeDef,
    InputWhitelistRuleTypeDef,
    KeyProviderSettingsTypeDef,
    ListChannelsRequestRequestTypeDef,
    ListChannelsResponseTypeDef,
    ListInputDeviceTransfersRequestRequestTypeDef,
    ListInputDeviceTransfersResponseTypeDef,
    ListInputDevicesRequestRequestTypeDef,
    ListInputDevicesResponseTypeDef,
    ListInputSecurityGroupsRequestRequestTypeDef,
    ListInputSecurityGroupsResponseTypeDef,
    ListInputsRequestRequestTypeDef,
    ListInputsResponseTypeDef,
    ListMultiplexProgramsRequestRequestTypeDef,
    ListMultiplexProgramsResponseTypeDef,
    ListMultiplexesRequestRequestTypeDef,
    ListMultiplexesResponseTypeDef,
    ListOfferingsRequestRequestTypeDef,
    ListOfferingsResponseTypeDef,
    ListReservationsRequestRequestTypeDef,
    ListReservationsResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    M2tsSettingsTypeDef,
    M3u8SettingsTypeDef,
    MediaConnectFlowRequestTypeDef,
    MediaConnectFlowTypeDef,
    MediaPackageGroupSettingsTypeDef,
    MediaPackageOutputDestinationSettingsTypeDef,
    MotionGraphicsActivateScheduleActionSettingsTypeDef,
    MotionGraphicsConfigurationTypeDef,
    MotionGraphicsSettingsTypeDef,
    Mp2SettingsTypeDef,
    Mpeg2FilterSettingsTypeDef,
    Mpeg2SettingsTypeDef,
    MsSmoothGroupSettingsTypeDef,
    MsSmoothOutputSettingsTypeDef,
    MultiplexMediaConnectOutputDestinationSettingsTypeDef,
    MultiplexOutputDestinationTypeDef,
    MultiplexOutputSettingsTypeDef,
    MultiplexProgramChannelDestinationSettingsTypeDef,
    MultiplexProgramPacketIdentifiersMapTypeDef,
    MultiplexProgramPipelineDetailTypeDef,
    MultiplexProgramServiceDescriptorTypeDef,
    MultiplexProgramSettingsTypeDef,
    MultiplexProgramSummaryTypeDef,
    MultiplexProgramTypeDef,
    MultiplexSettingsSummaryTypeDef,
    MultiplexSettingsTypeDef,
    MultiplexStatmuxVideoSettingsTypeDef,
    MultiplexSummaryTypeDef,
    MultiplexTypeDef,
    MultiplexVideoSettingsTypeDef,
    NetworkInputSettingsTypeDef,
    NielsenConfigurationTypeDef,
    OfferingTypeDef,
    OutputDestinationSettingsTypeDef,
    OutputDestinationTypeDef,
    OutputGroupSettingsTypeDef,
    OutputGroupTypeDef,
    OutputLocationRefTypeDef,
    OutputSettingsTypeDef,
    OutputTypeDef,
    PaginatorConfigTypeDef,
    PauseStateScheduleActionSettingsTypeDef,
    PipelineDetailTypeDef,
    PipelinePauseStateSettingsTypeDef,
    PurchaseOfferingRequestRequestTypeDef,
    PurchaseOfferingResponseTypeDef,
    RejectInputDeviceTransferRequestRequestTypeDef,
    RemixSettingsTypeDef,
    ReservationResourceSpecificationTypeDef,
    ReservationTypeDef,
    ResponseMetadataTypeDef,
    RtmpGroupSettingsTypeDef,
    RtmpOutputSettingsTypeDef,
    ScheduleActionSettingsTypeDef,
    ScheduleActionStartSettingsTypeDef,
    ScheduleActionTypeDef,
    Scte20SourceSettingsTypeDef,
    Scte27SourceSettingsTypeDef,
    Scte35DeliveryRestrictionsTypeDef,
    Scte35DescriptorSettingsTypeDef,
    Scte35DescriptorTypeDef,
    Scte35ReturnToNetworkScheduleActionSettingsTypeDef,
    Scte35SegmentationDescriptorTypeDef,
    Scte35SpliceInsertScheduleActionSettingsTypeDef,
    Scte35SpliceInsertTypeDef,
    Scte35TimeSignalAposTypeDef,
    Scte35TimeSignalScheduleActionSettingsTypeDef,
    StandardHlsSettingsTypeDef,
    StartChannelRequestRequestTypeDef,
    StartChannelResponseTypeDef,
    StartMultiplexRequestRequestTypeDef,
    StartMultiplexResponseTypeDef,
    StartTimecodeTypeDef,
    StaticImageActivateScheduleActionSettingsTypeDef,
    StaticImageDeactivateScheduleActionSettingsTypeDef,
    StaticKeySettingsTypeDef,
    StopChannelRequestRequestTypeDef,
    StopChannelResponseTypeDef,
    StopMultiplexRequestRequestTypeDef,
    StopMultiplexResponseTypeDef,
    StopTimecodeTypeDef,
    TeletextSourceSettingsTypeDef,
    TemporalFilterSettingsTypeDef,
    TimecodeConfigTypeDef,
    TransferInputDeviceRequestRequestTypeDef,
    TransferringInputDeviceSummaryTypeDef,
    TtmlDestinationSettingsTypeDef,
    UdpContainerSettingsTypeDef,
    UdpGroupSettingsTypeDef,
    UdpOutputSettingsTypeDef,
    UpdateChannelClassRequestRequestTypeDef,
    UpdateChannelClassResponseTypeDef,
    UpdateChannelRequestRequestTypeDef,
    UpdateChannelResponseTypeDef,
    UpdateInputDeviceRequestRequestTypeDef,
    UpdateInputDeviceResponseTypeDef,
    UpdateInputRequestRequestTypeDef,
    UpdateInputResponseTypeDef,
    UpdateInputSecurityGroupRequestRequestTypeDef,
    UpdateInputSecurityGroupResponseTypeDef,
    UpdateMultiplexProgramRequestRequestTypeDef,
    UpdateMultiplexProgramResponseTypeDef,
    UpdateMultiplexRequestRequestTypeDef,
    UpdateMultiplexResponseTypeDef,
    UpdateReservationRequestRequestTypeDef,
    UpdateReservationResponseTypeDef,
    VideoBlackFailoverSettingsTypeDef,
    VideoCodecSettingsTypeDef,
    VideoDescriptionTypeDef,
    VideoSelectorColorSpaceSettingsTypeDef,
    VideoSelectorPidTypeDef,
    VideoSelectorProgramIdTypeDef,
    VideoSelectorSettingsTypeDef,
    VideoSelectorTypeDef,
    VpcOutputSettingsDescriptionTypeDef,
    VpcOutputSettingsTypeDef,
    WaiterConfigTypeDef,
    WavSettingsTypeDef,
    WebvttDestinationSettingsTypeDef,
)

def get_structure() -> AacSettingsTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-medialive` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-medialive docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_medialive/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
