# MHR Visualization Notebook

This directory contains a Jupyter notebook for visualizing MHR (Momentum Human Rig) model.

## File Overview

- `MHR visualization.ipynb` - Jupyter notebook containing data visualization and analysis code for MHR data

## How to Use with Google Colab

Google Colab is a free cloud-based Jupyter notebook environment that requires no setup and runs entirely in the cloud. We provide a few options for using the notebook with Google Colab:

### Option 1: Upload to Google Colab (Recommended)

1. Go to [Google Colab](https://colab.research.google.com/)
2. Click on **File** → **Upload notebook**
3. Choose the **Upload** tab
4. Click **Choose File** and select `MHR visualization.ipynb` from your local machine
5. The notebook will open in a new Colab tab and you can start running cells

### Option 2: Open from Google Drive

1. Upload `MHR visualization.ipynb` to your Google Drive
2. Navigate to the file in Google Drive
3. Right-click on the file
4. Select **Open with** → **Google Colaboratory**
5. If Google Colaboratory is not in the list:
   - Click **Connect more apps**
   - Search for "Colaboratory"
   - Install and connect the app

### Option 3: Direct URL
1. Copy the GitHub URL of the notebook
2. Go to [Google Colab](https://colab.research.google.com/)
3. Click **File** → **Open notebook**
4. Select the **GitHub** tab
5. Paste the URL or enter the repository details
6. Select the notebook to open

## Running the Notebook

Once opened in Google Colab:

1. **Install Dependencies**: If the notebook requires specific packages, run any installation cells at the beginning (usually with `!pip install` commands)

2. **Run Cells**: Execute cells sequentially using:
   - **Shift + Enter** to run the current cell and move to the next
   - **Ctrl/Cmd + Enter** to run the current cell and stay on it
   - **Runtime** → **Run all** to execute all cells

## Resources

- [Google Colab Documentation](https://colab.research.google.com/notebooks/intro.ipynb)
- [Jupyter Notebook Documentation](https://jupyter-notebook.readthedocs.io/)
- [Google Colab FAQ](https://research.google.com/colaboratory/faq.html)
