---
title: Community
icon: community
description: >
    The Nexios community is a place for developers to connect, share knowledge, and help each other build amazing applications with Nexios.
head:
  - - meta
    - property: og:title
      content: Community
    - property: og:description
      content: The Nexios community is a place for developers to connect, share knowledge, and help each other build amazing applications with Nexios.
---
# 👋 Welcome to the Nexios Community!

We're thrilled to have you here! The Nexios community is a place for developers to connect, share knowledge, and help each other build amazing applications with Nexios.

## 🌟 Open Source at Heart

Nexios is proudly **100% open source** and community-driven. We believe in the power of collaboration and transparency in building great software. Our entire ecosystem is built on open source principles:

- **Core Framework**: The main Nexios framework is completely open source under the MIT license
- **Community Contributions**: The [nexios-contrib](https://github.com/nexios-labs/nexios-contrib) package provides community-driven extensions and middleware
- **Transparent Development**: All development happens in the open on GitHub with public discussions and roadmaps

### Nexios Contrib Package

The **nexios-contrib** package is our community-driven collection of extensions, middleware, and add-ons that extend Nexios's capabilities. It includes:

- **URL Normalization Middleware** - Clean and consistent URL handling
- **Trusted Host Middleware** - Security against Host header attacks  
- **ETag Middleware** - Automatic ETag generation and conditional requests
- **JSON-RPC Support** - Full JSON-RPC 2.0 server and client implementation

Install all contrib packages at once:
```bash
pip install nexios_contrib
```

Or explore individual packages in the [nexios-contrib repository](https://github.com/nexios-labs/nexios-contrib).

### Open Source Philosophy

We believe that great software is built by communities, not just companies. That's why:

- **Everything is MIT Licensed** - Use Nexios in any project, commercial or personal
- **No Vendor Lock-in** - You own your code and can modify anything
- **Community-First** - Major decisions are discussed openly with the community
- **Transparent Roadmap** - Our development priorities are public and community-influenced
- **Welcoming to All** - We maintain an inclusive environment for developers of all skill levels

## Get Involved

### Core Framework
- **GitHub Discussions**: [Join the conversation](https://github.com/orgs/nexios-labs/discussions)
- **Report Issues**: [GitHub Issues](https://github.com/nexios-labs/nexios/issues)
- **Contribute**: Check out our [Contributing Guide](/community/contribution-guide)

### Community Contributions (nexios-contrib)
- **Contribute Packages**: [nexios-contrib repository](https://github.com/nexios-labs/nexios-contrib)
- **Package Issues**: [Report contrib-specific issues](https://github.com/nexios-labs/nexios-contrib/issues)
- **Package Ideas**: Share your middleware and extension ideas in discussions

### Ways to Contribute
- **Code**: Submit bug fixes, new features, or performance improvements
- **Documentation**: Help improve our docs, tutorials, and examples
- **Community**: Answer questions, help other developers, share your projects
- **Testing**: Report bugs, test new features, improve test coverage
- **Ideas**: Suggest new features or improvements through GitHub discussions

## Stay Updated

- **GitHub**: Star and watch our [GitHub repository](https://github.com/nexios-labs/nexios)
- **Twitter**: Follow us [@NexiosLabs](https://twitter.com/NexiosLabs) for updates

## Code of Conduct

Please review our [Code of Conduct](https://github.com/nexios-labs/nexios/CODE_OF_CONDUCT.md) to help us maintain a welcoming and inclusive community.

---

We can't wait to see what you'll build with Nexios! 🚀