# coding: utf-8

"""
    Hatchet API

    The Hatchet API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from datetime import datetime
from typing import Any, Dict, List, Optional, Tuple, Union

from pydantic import Field, StrictBool, StrictFloat, StrictInt, StrictStr, validate_call
from typing_extensions import Annotated

from hatchet_sdk.clients.rest.api_client import ApiClient, RequestSerialized
from hatchet_sdk.clients.rest.api_response import ApiResponse
from hatchet_sdk.clients.rest.models.v1_task_event_list import V1TaskEventList
from hatchet_sdk.clients.rest.models.v1_task_status import V1TaskStatus
from hatchet_sdk.clients.rest.models.v1_task_summary_list import V1TaskSummaryList
from hatchet_sdk.clients.rest.models.v1_task_timing_list import V1TaskTimingList
from hatchet_sdk.clients.rest.models.v1_trigger_workflow_run_request import (
    V1TriggerWorkflowRunRequest,
)
from hatchet_sdk.clients.rest.models.v1_workflow_run_details import V1WorkflowRunDetails
from hatchet_sdk.clients.rest.models.v1_workflow_run_display_name_list import (
    V1WorkflowRunDisplayNameList,
)
from hatchet_sdk.clients.rest.rest import RESTResponseType


class WorkflowRunsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def v1_workflow_run_create(
        self,
        tenant: Annotated[
            str,
            Field(
                min_length=36, strict=True, max_length=36, description="The tenant id"
            ),
        ],
        v1_trigger_workflow_run_request: Annotated[
            V1TriggerWorkflowRunRequest, Field(description="The workflow run to create")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V1WorkflowRunDetails:
        """Create workflow run

        Trigger a new workflow run

        :param tenant: The tenant id (required)
        :type tenant: str
        :param v1_trigger_workflow_run_request: The workflow run to create (required)
        :type v1_trigger_workflow_run_request: V1TriggerWorkflowRunRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v1_workflow_run_create_serialize(
            tenant=tenant,
            v1_trigger_workflow_run_request=v1_trigger_workflow_run_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "V1WorkflowRunDetails",
            "400": "APIErrors",
            "403": "APIErrors",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def v1_workflow_run_create_with_http_info(
        self,
        tenant: Annotated[
            str,
            Field(
                min_length=36, strict=True, max_length=36, description="The tenant id"
            ),
        ],
        v1_trigger_workflow_run_request: Annotated[
            V1TriggerWorkflowRunRequest, Field(description="The workflow run to create")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V1WorkflowRunDetails]:
        """Create workflow run

        Trigger a new workflow run

        :param tenant: The tenant id (required)
        :type tenant: str
        :param v1_trigger_workflow_run_request: The workflow run to create (required)
        :type v1_trigger_workflow_run_request: V1TriggerWorkflowRunRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v1_workflow_run_create_serialize(
            tenant=tenant,
            v1_trigger_workflow_run_request=v1_trigger_workflow_run_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "V1WorkflowRunDetails",
            "400": "APIErrors",
            "403": "APIErrors",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def v1_workflow_run_create_without_preload_content(
        self,
        tenant: Annotated[
            str,
            Field(
                min_length=36, strict=True, max_length=36, description="The tenant id"
            ),
        ],
        v1_trigger_workflow_run_request: Annotated[
            V1TriggerWorkflowRunRequest, Field(description="The workflow run to create")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create workflow run

        Trigger a new workflow run

        :param tenant: The tenant id (required)
        :type tenant: str
        :param v1_trigger_workflow_run_request: The workflow run to create (required)
        :type v1_trigger_workflow_run_request: V1TriggerWorkflowRunRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v1_workflow_run_create_serialize(
            tenant=tenant,
            v1_trigger_workflow_run_request=v1_trigger_workflow_run_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "V1WorkflowRunDetails",
            "400": "APIErrors",
            "403": "APIErrors",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _v1_workflow_run_create_serialize(
        self,
        tenant,
        v1_trigger_workflow_run_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tenant is not None:
            _path_params["tenant"] = tenant
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v1_trigger_workflow_run_request is not None:
            _body_params = v1_trigger_workflow_run_request

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["cookieAuth", "bearerAuth"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/api/v1/stable/tenants/{tenant}/workflow-runs/trigger",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def v1_workflow_run_display_names_list(
        self,
        tenant: Annotated[
            str,
            Field(
                min_length=36, strict=True, max_length=36, description="The tenant id"
            ),
        ],
        external_ids: Annotated[
            List[Annotated[str, Field(min_length=36, strict=True, max_length=36)]],
            Field(
                description="The external ids of the workflow runs to get display names for"
            ),
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V1WorkflowRunDisplayNameList:
        """List workflow runs

        Lists displayable names of workflow runs for a tenant

        :param tenant: The tenant id (required)
        :type tenant: str
        :param external_ids: The external ids of the workflow runs to get display names for (required)
        :type external_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v1_workflow_run_display_names_list_serialize(
            tenant=tenant,
            external_ids=external_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "V1WorkflowRunDisplayNameList",
            "400": "APIErrors",
            "403": "APIErrors",
            "501": "APIErrors",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def v1_workflow_run_display_names_list_with_http_info(
        self,
        tenant: Annotated[
            str,
            Field(
                min_length=36, strict=True, max_length=36, description="The tenant id"
            ),
        ],
        external_ids: Annotated[
            List[Annotated[str, Field(min_length=36, strict=True, max_length=36)]],
            Field(
                description="The external ids of the workflow runs to get display names for"
            ),
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V1WorkflowRunDisplayNameList]:
        """List workflow runs

        Lists displayable names of workflow runs for a tenant

        :param tenant: The tenant id (required)
        :type tenant: str
        :param external_ids: The external ids of the workflow runs to get display names for (required)
        :type external_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v1_workflow_run_display_names_list_serialize(
            tenant=tenant,
            external_ids=external_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "V1WorkflowRunDisplayNameList",
            "400": "APIErrors",
            "403": "APIErrors",
            "501": "APIErrors",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def v1_workflow_run_display_names_list_without_preload_content(
        self,
        tenant: Annotated[
            str,
            Field(
                min_length=36, strict=True, max_length=36, description="The tenant id"
            ),
        ],
        external_ids: Annotated[
            List[Annotated[str, Field(min_length=36, strict=True, max_length=36)]],
            Field(
                description="The external ids of the workflow runs to get display names for"
            ),
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List workflow runs

        Lists displayable names of workflow runs for a tenant

        :param tenant: The tenant id (required)
        :type tenant: str
        :param external_ids: The external ids of the workflow runs to get display names for (required)
        :type external_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v1_workflow_run_display_names_list_serialize(
            tenant=tenant,
            external_ids=external_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "V1WorkflowRunDisplayNameList",
            "400": "APIErrors",
            "403": "APIErrors",
            "501": "APIErrors",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _v1_workflow_run_display_names_list_serialize(
        self,
        tenant,
        external_ids,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            "external_ids": "multi",
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tenant is not None:
            _path_params["tenant"] = tenant
        # process the query parameters
        if external_ids is not None:

            _query_params.append(("external_ids", external_ids))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json"]
            )

        # authentication setting
        _auth_settings: List[str] = ["cookieAuth", "bearerAuth"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/v1/stable/tenants/{tenant}/workflow-runs/display-names",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def v1_workflow_run_get(
        self,
        v1_workflow_run: Annotated[
            str,
            Field(
                min_length=36,
                strict=True,
                max_length=36,
                description="The workflow run id to get",
            ),
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V1WorkflowRunDetails:
        """List tasks

        Get a workflow run and its metadata to display on the \"detail\" page

        :param v1_workflow_run: The workflow run id to get (required)
        :type v1_workflow_run: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v1_workflow_run_get_serialize(
            v1_workflow_run=v1_workflow_run,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "V1WorkflowRunDetails",
            "400": "APIErrors",
            "403": "APIErrors",
            "501": "APIErrors",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def v1_workflow_run_get_with_http_info(
        self,
        v1_workflow_run: Annotated[
            str,
            Field(
                min_length=36,
                strict=True,
                max_length=36,
                description="The workflow run id to get",
            ),
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V1WorkflowRunDetails]:
        """List tasks

        Get a workflow run and its metadata to display on the \"detail\" page

        :param v1_workflow_run: The workflow run id to get (required)
        :type v1_workflow_run: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v1_workflow_run_get_serialize(
            v1_workflow_run=v1_workflow_run,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "V1WorkflowRunDetails",
            "400": "APIErrors",
            "403": "APIErrors",
            "501": "APIErrors",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def v1_workflow_run_get_without_preload_content(
        self,
        v1_workflow_run: Annotated[
            str,
            Field(
                min_length=36,
                strict=True,
                max_length=36,
                description="The workflow run id to get",
            ),
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List tasks

        Get a workflow run and its metadata to display on the \"detail\" page

        :param v1_workflow_run: The workflow run id to get (required)
        :type v1_workflow_run: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v1_workflow_run_get_serialize(
            v1_workflow_run=v1_workflow_run,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "V1WorkflowRunDetails",
            "400": "APIErrors",
            "403": "APIErrors",
            "501": "APIErrors",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _v1_workflow_run_get_serialize(
        self,
        v1_workflow_run,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if v1_workflow_run is not None:
            _path_params["v1-workflow-run"] = v1_workflow_run
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json"]
            )

        # authentication setting
        _auth_settings: List[str] = ["cookieAuth", "bearerAuth"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/v1/stable/workflow-runs/{v1-workflow-run}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def v1_workflow_run_get_status(
        self,
        v1_workflow_run: Annotated[
            str,
            Field(
                min_length=36,
                strict=True,
                max_length=36,
                description="The workflow run id to get the status for",
            ),
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V1TaskStatus:
        """Get workflow run status

        Get the status of a workflow run.

        :param v1_workflow_run: The workflow run id to get the status for (required)
        :type v1_workflow_run: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v1_workflow_run_get_status_serialize(
            v1_workflow_run=v1_workflow_run,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "V1TaskStatus",
            "400": "APIErrors",
            "403": "APIErrors",
            "404": "APIErrors",
            "501": "APIErrors",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def v1_workflow_run_get_status_with_http_info(
        self,
        v1_workflow_run: Annotated[
            str,
            Field(
                min_length=36,
                strict=True,
                max_length=36,
                description="The workflow run id to get the status for",
            ),
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V1TaskStatus]:
        """Get workflow run status

        Get the status of a workflow run.

        :param v1_workflow_run: The workflow run id to get the status for (required)
        :type v1_workflow_run: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v1_workflow_run_get_status_serialize(
            v1_workflow_run=v1_workflow_run,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "V1TaskStatus",
            "400": "APIErrors",
            "403": "APIErrors",
            "404": "APIErrors",
            "501": "APIErrors",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def v1_workflow_run_get_status_without_preload_content(
        self,
        v1_workflow_run: Annotated[
            str,
            Field(
                min_length=36,
                strict=True,
                max_length=36,
                description="The workflow run id to get the status for",
            ),
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get workflow run status

        Get the status of a workflow run.

        :param v1_workflow_run: The workflow run id to get the status for (required)
        :type v1_workflow_run: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v1_workflow_run_get_status_serialize(
            v1_workflow_run=v1_workflow_run,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "V1TaskStatus",
            "400": "APIErrors",
            "403": "APIErrors",
            "404": "APIErrors",
            "501": "APIErrors",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _v1_workflow_run_get_status_serialize(
        self,
        v1_workflow_run,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if v1_workflow_run is not None:
            _path_params["v1-workflow-run"] = v1_workflow_run
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json"]
            )

        # authentication setting
        _auth_settings: List[str] = ["cookieAuth", "bearerAuth"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/v1/stable/workflow-runs/{v1-workflow-run}/status",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def v1_workflow_run_get_timings(
        self,
        v1_workflow_run: Annotated[
            str,
            Field(
                min_length=36,
                strict=True,
                max_length=36,
                description="The workflow run id to get",
            ),
        ],
        depth: Annotated[
            Optional[StrictInt], Field(description="The depth to retrieve children")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V1TaskTimingList:
        """List timings for a workflow run

        Get the timings for a workflow run

        :param v1_workflow_run: The workflow run id to get (required)
        :type v1_workflow_run: str
        :param depth: The depth to retrieve children
        :type depth: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v1_workflow_run_get_timings_serialize(
            v1_workflow_run=v1_workflow_run,
            depth=depth,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "V1TaskTimingList",
            "400": "APIErrors",
            "403": "APIErrors",
            "501": "APIErrors",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def v1_workflow_run_get_timings_with_http_info(
        self,
        v1_workflow_run: Annotated[
            str,
            Field(
                min_length=36,
                strict=True,
                max_length=36,
                description="The workflow run id to get",
            ),
        ],
        depth: Annotated[
            Optional[StrictInt], Field(description="The depth to retrieve children")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V1TaskTimingList]:
        """List timings for a workflow run

        Get the timings for a workflow run

        :param v1_workflow_run: The workflow run id to get (required)
        :type v1_workflow_run: str
        :param depth: The depth to retrieve children
        :type depth: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v1_workflow_run_get_timings_serialize(
            v1_workflow_run=v1_workflow_run,
            depth=depth,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "V1TaskTimingList",
            "400": "APIErrors",
            "403": "APIErrors",
            "501": "APIErrors",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def v1_workflow_run_get_timings_without_preload_content(
        self,
        v1_workflow_run: Annotated[
            str,
            Field(
                min_length=36,
                strict=True,
                max_length=36,
                description="The workflow run id to get",
            ),
        ],
        depth: Annotated[
            Optional[StrictInt], Field(description="The depth to retrieve children")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List timings for a workflow run

        Get the timings for a workflow run

        :param v1_workflow_run: The workflow run id to get (required)
        :type v1_workflow_run: str
        :param depth: The depth to retrieve children
        :type depth: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v1_workflow_run_get_timings_serialize(
            v1_workflow_run=v1_workflow_run,
            depth=depth,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "V1TaskTimingList",
            "400": "APIErrors",
            "403": "APIErrors",
            "501": "APIErrors",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _v1_workflow_run_get_timings_serialize(
        self,
        v1_workflow_run,
        depth,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if v1_workflow_run is not None:
            _path_params["v1-workflow-run"] = v1_workflow_run
        # process the query parameters
        if depth is not None:

            _query_params.append(("depth", depth))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json"]
            )

        # authentication setting
        _auth_settings: List[str] = ["cookieAuth", "bearerAuth"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/v1/stable/workflow-runs/{v1-workflow-run}/task-timings",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def v1_workflow_run_list(
        self,
        tenant: Annotated[
            str,
            Field(
                min_length=36, strict=True, max_length=36, description="The tenant id"
            ),
        ],
        since: Annotated[datetime, Field(description="The earliest date to filter by")],
        only_tasks: Annotated[
            StrictBool,
            Field(description="Whether to include DAGs or only to include tasks"),
        ],
        offset: Annotated[
            Optional[StrictInt], Field(description="The number to skip")
        ] = None,
        limit: Annotated[
            Optional[StrictInt], Field(description="The number to limit by")
        ] = None,
        statuses: Annotated[
            Optional[List[V1TaskStatus]],
            Field(description="A list of statuses to filter by"),
        ] = None,
        until: Annotated[
            Optional[datetime], Field(description="The latest date to filter by")
        ] = None,
        additional_metadata: Annotated[
            Optional[List[StrictStr]],
            Field(description="Additional metadata k-v pairs to filter by"),
        ] = None,
        workflow_ids: Annotated[
            Optional[
                List[Annotated[str, Field(min_length=36, strict=True, max_length=36)]]
            ],
            Field(description="The workflow ids to find runs for"),
        ] = None,
        worker_id: Annotated[
            Optional[Annotated[str, Field(min_length=36, strict=True, max_length=36)]],
            Field(description="The worker id to filter by"),
        ] = None,
        parent_task_external_id: Annotated[
            Optional[Annotated[str, Field(min_length=36, strict=True, max_length=36)]],
            Field(description="The parent task external id to filter by"),
        ] = None,
        triggering_event_external_id: Annotated[
            Optional[Annotated[str, Field(min_length=36, strict=True, max_length=36)]],
            Field(
                description="The external id of the event that triggered the workflow run"
            ),
        ] = None,
        include_payloads: Annotated[
            Optional[StrictBool],
            Field(
                description="A flag for whether or not to include the input and output payloads in the response. Defaults to `true` if unset."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V1TaskSummaryList:
        """List workflow runs

        Lists workflow runs for a tenant.

        :param tenant: The tenant id (required)
        :type tenant: str
        :param since: The earliest date to filter by (required)
        :type since: datetime
        :param only_tasks: Whether to include DAGs or only to include tasks (required)
        :type only_tasks: bool
        :param offset: The number to skip
        :type offset: int
        :param limit: The number to limit by
        :type limit: int
        :param statuses: A list of statuses to filter by
        :type statuses: List[V1TaskStatus]
        :param until: The latest date to filter by
        :type until: datetime
        :param additional_metadata: Additional metadata k-v pairs to filter by
        :type additional_metadata: List[str]
        :param workflow_ids: The workflow ids to find runs for
        :type workflow_ids: List[str]
        :param worker_id: The worker id to filter by
        :type worker_id: str
        :param parent_task_external_id: The parent task external id to filter by
        :type parent_task_external_id: str
        :param triggering_event_external_id: The external id of the event that triggered the workflow run
        :type triggering_event_external_id: str
        :param include_payloads: A flag for whether or not to include the input and output payloads in the response. Defaults to `true` if unset.
        :type include_payloads: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v1_workflow_run_list_serialize(
            tenant=tenant,
            since=since,
            only_tasks=only_tasks,
            offset=offset,
            limit=limit,
            statuses=statuses,
            until=until,
            additional_metadata=additional_metadata,
            workflow_ids=workflow_ids,
            worker_id=worker_id,
            parent_task_external_id=parent_task_external_id,
            triggering_event_external_id=triggering_event_external_id,
            include_payloads=include_payloads,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "V1TaskSummaryList",
            "400": "APIErrors",
            "403": "APIErrors",
            "501": "APIErrors",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def v1_workflow_run_list_with_http_info(
        self,
        tenant: Annotated[
            str,
            Field(
                min_length=36, strict=True, max_length=36, description="The tenant id"
            ),
        ],
        since: Annotated[datetime, Field(description="The earliest date to filter by")],
        only_tasks: Annotated[
            StrictBool,
            Field(description="Whether to include DAGs or only to include tasks"),
        ],
        offset: Annotated[
            Optional[StrictInt], Field(description="The number to skip")
        ] = None,
        limit: Annotated[
            Optional[StrictInt], Field(description="The number to limit by")
        ] = None,
        statuses: Annotated[
            Optional[List[V1TaskStatus]],
            Field(description="A list of statuses to filter by"),
        ] = None,
        until: Annotated[
            Optional[datetime], Field(description="The latest date to filter by")
        ] = None,
        additional_metadata: Annotated[
            Optional[List[StrictStr]],
            Field(description="Additional metadata k-v pairs to filter by"),
        ] = None,
        workflow_ids: Annotated[
            Optional[
                List[Annotated[str, Field(min_length=36, strict=True, max_length=36)]]
            ],
            Field(description="The workflow ids to find runs for"),
        ] = None,
        worker_id: Annotated[
            Optional[Annotated[str, Field(min_length=36, strict=True, max_length=36)]],
            Field(description="The worker id to filter by"),
        ] = None,
        parent_task_external_id: Annotated[
            Optional[Annotated[str, Field(min_length=36, strict=True, max_length=36)]],
            Field(description="The parent task external id to filter by"),
        ] = None,
        triggering_event_external_id: Annotated[
            Optional[Annotated[str, Field(min_length=36, strict=True, max_length=36)]],
            Field(
                description="The external id of the event that triggered the workflow run"
            ),
        ] = None,
        include_payloads: Annotated[
            Optional[StrictBool],
            Field(
                description="A flag for whether or not to include the input and output payloads in the response. Defaults to `true` if unset."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V1TaskSummaryList]:
        """List workflow runs

        Lists workflow runs for a tenant.

        :param tenant: The tenant id (required)
        :type tenant: str
        :param since: The earliest date to filter by (required)
        :type since: datetime
        :param only_tasks: Whether to include DAGs or only to include tasks (required)
        :type only_tasks: bool
        :param offset: The number to skip
        :type offset: int
        :param limit: The number to limit by
        :type limit: int
        :param statuses: A list of statuses to filter by
        :type statuses: List[V1TaskStatus]
        :param until: The latest date to filter by
        :type until: datetime
        :param additional_metadata: Additional metadata k-v pairs to filter by
        :type additional_metadata: List[str]
        :param workflow_ids: The workflow ids to find runs for
        :type workflow_ids: List[str]
        :param worker_id: The worker id to filter by
        :type worker_id: str
        :param parent_task_external_id: The parent task external id to filter by
        :type parent_task_external_id: str
        :param triggering_event_external_id: The external id of the event that triggered the workflow run
        :type triggering_event_external_id: str
        :param include_payloads: A flag for whether or not to include the input and output payloads in the response. Defaults to `true` if unset.
        :type include_payloads: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v1_workflow_run_list_serialize(
            tenant=tenant,
            since=since,
            only_tasks=only_tasks,
            offset=offset,
            limit=limit,
            statuses=statuses,
            until=until,
            additional_metadata=additional_metadata,
            workflow_ids=workflow_ids,
            worker_id=worker_id,
            parent_task_external_id=parent_task_external_id,
            triggering_event_external_id=triggering_event_external_id,
            include_payloads=include_payloads,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "V1TaskSummaryList",
            "400": "APIErrors",
            "403": "APIErrors",
            "501": "APIErrors",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def v1_workflow_run_list_without_preload_content(
        self,
        tenant: Annotated[
            str,
            Field(
                min_length=36, strict=True, max_length=36, description="The tenant id"
            ),
        ],
        since: Annotated[datetime, Field(description="The earliest date to filter by")],
        only_tasks: Annotated[
            StrictBool,
            Field(description="Whether to include DAGs or only to include tasks"),
        ],
        offset: Annotated[
            Optional[StrictInt], Field(description="The number to skip")
        ] = None,
        limit: Annotated[
            Optional[StrictInt], Field(description="The number to limit by")
        ] = None,
        statuses: Annotated[
            Optional[List[V1TaskStatus]],
            Field(description="A list of statuses to filter by"),
        ] = None,
        until: Annotated[
            Optional[datetime], Field(description="The latest date to filter by")
        ] = None,
        additional_metadata: Annotated[
            Optional[List[StrictStr]],
            Field(description="Additional metadata k-v pairs to filter by"),
        ] = None,
        workflow_ids: Annotated[
            Optional[
                List[Annotated[str, Field(min_length=36, strict=True, max_length=36)]]
            ],
            Field(description="The workflow ids to find runs for"),
        ] = None,
        worker_id: Annotated[
            Optional[Annotated[str, Field(min_length=36, strict=True, max_length=36)]],
            Field(description="The worker id to filter by"),
        ] = None,
        parent_task_external_id: Annotated[
            Optional[Annotated[str, Field(min_length=36, strict=True, max_length=36)]],
            Field(description="The parent task external id to filter by"),
        ] = None,
        triggering_event_external_id: Annotated[
            Optional[Annotated[str, Field(min_length=36, strict=True, max_length=36)]],
            Field(
                description="The external id of the event that triggered the workflow run"
            ),
        ] = None,
        include_payloads: Annotated[
            Optional[StrictBool],
            Field(
                description="A flag for whether or not to include the input and output payloads in the response. Defaults to `true` if unset."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List workflow runs

        Lists workflow runs for a tenant.

        :param tenant: The tenant id (required)
        :type tenant: str
        :param since: The earliest date to filter by (required)
        :type since: datetime
        :param only_tasks: Whether to include DAGs or only to include tasks (required)
        :type only_tasks: bool
        :param offset: The number to skip
        :type offset: int
        :param limit: The number to limit by
        :type limit: int
        :param statuses: A list of statuses to filter by
        :type statuses: List[V1TaskStatus]
        :param until: The latest date to filter by
        :type until: datetime
        :param additional_metadata: Additional metadata k-v pairs to filter by
        :type additional_metadata: List[str]
        :param workflow_ids: The workflow ids to find runs for
        :type workflow_ids: List[str]
        :param worker_id: The worker id to filter by
        :type worker_id: str
        :param parent_task_external_id: The parent task external id to filter by
        :type parent_task_external_id: str
        :param triggering_event_external_id: The external id of the event that triggered the workflow run
        :type triggering_event_external_id: str
        :param include_payloads: A flag for whether or not to include the input and output payloads in the response. Defaults to `true` if unset.
        :type include_payloads: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v1_workflow_run_list_serialize(
            tenant=tenant,
            since=since,
            only_tasks=only_tasks,
            offset=offset,
            limit=limit,
            statuses=statuses,
            until=until,
            additional_metadata=additional_metadata,
            workflow_ids=workflow_ids,
            worker_id=worker_id,
            parent_task_external_id=parent_task_external_id,
            triggering_event_external_id=triggering_event_external_id,
            include_payloads=include_payloads,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "V1TaskSummaryList",
            "400": "APIErrors",
            "403": "APIErrors",
            "501": "APIErrors",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _v1_workflow_run_list_serialize(
        self,
        tenant,
        since,
        only_tasks,
        offset,
        limit,
        statuses,
        until,
        additional_metadata,
        workflow_ids,
        worker_id,
        parent_task_external_id,
        triggering_event_external_id,
        include_payloads,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            "statuses": "multi",
            "additional_metadata": "multi",
            "workflow_ids": "multi",
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tenant is not None:
            _path_params["tenant"] = tenant
        # process the query parameters
        if offset is not None:

            _query_params.append(("offset", offset))

        if limit is not None:

            _query_params.append(("limit", limit))

        if statuses is not None:

            _query_params.append(("statuses", statuses))

        if since is not None:
            if isinstance(since, datetime):
                _query_params.append(
                    (
                        "since",
                        since.strftime(self.api_client.configuration.datetime_format),
                    )
                )
            else:
                _query_params.append(("since", since))

        if until is not None:
            if isinstance(until, datetime):
                _query_params.append(
                    (
                        "until",
                        until.strftime(self.api_client.configuration.datetime_format),
                    )
                )
            else:
                _query_params.append(("until", until))

        if additional_metadata is not None:

            _query_params.append(("additional_metadata", additional_metadata))

        if workflow_ids is not None:

            _query_params.append(("workflow_ids", workflow_ids))

        if worker_id is not None:

            _query_params.append(("worker_id", worker_id))

        if only_tasks is not None:

            _query_params.append(("only_tasks", only_tasks))

        if parent_task_external_id is not None:

            _query_params.append(("parent_task_external_id", parent_task_external_id))

        if triggering_event_external_id is not None:

            _query_params.append(
                ("triggering_event_external_id", triggering_event_external_id)
            )

        if include_payloads is not None:

            _query_params.append(("include_payloads", include_payloads))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json"]
            )

        # authentication setting
        _auth_settings: List[str] = ["cookieAuth", "bearerAuth"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/v1/stable/tenants/{tenant}/workflow-runs",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def v1_workflow_run_task_events_list(
        self,
        v1_workflow_run: Annotated[
            str,
            Field(
                min_length=36,
                strict=True,
                max_length=36,
                description="The workflow run id to find runs for",
            ),
        ],
        offset: Annotated[
            Optional[StrictInt], Field(description="The number to skip")
        ] = None,
        limit: Annotated[
            Optional[StrictInt], Field(description="The number to limit by")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V1TaskEventList:
        """List tasks

        List all tasks for a workflow run

        :param v1_workflow_run: The workflow run id to find runs for (required)
        :type v1_workflow_run: str
        :param offset: The number to skip
        :type offset: int
        :param limit: The number to limit by
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v1_workflow_run_task_events_list_serialize(
            v1_workflow_run=v1_workflow_run,
            offset=offset,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "V1TaskEventList",
            "400": "APIErrors",
            "403": "APIErrors",
            "501": "APIErrors",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def v1_workflow_run_task_events_list_with_http_info(
        self,
        v1_workflow_run: Annotated[
            str,
            Field(
                min_length=36,
                strict=True,
                max_length=36,
                description="The workflow run id to find runs for",
            ),
        ],
        offset: Annotated[
            Optional[StrictInt], Field(description="The number to skip")
        ] = None,
        limit: Annotated[
            Optional[StrictInt], Field(description="The number to limit by")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V1TaskEventList]:
        """List tasks

        List all tasks for a workflow run

        :param v1_workflow_run: The workflow run id to find runs for (required)
        :type v1_workflow_run: str
        :param offset: The number to skip
        :type offset: int
        :param limit: The number to limit by
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v1_workflow_run_task_events_list_serialize(
            v1_workflow_run=v1_workflow_run,
            offset=offset,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "V1TaskEventList",
            "400": "APIErrors",
            "403": "APIErrors",
            "501": "APIErrors",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def v1_workflow_run_task_events_list_without_preload_content(
        self,
        v1_workflow_run: Annotated[
            str,
            Field(
                min_length=36,
                strict=True,
                max_length=36,
                description="The workflow run id to find runs for",
            ),
        ],
        offset: Annotated[
            Optional[StrictInt], Field(description="The number to skip")
        ] = None,
        limit: Annotated[
            Optional[StrictInt], Field(description="The number to limit by")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List tasks

        List all tasks for a workflow run

        :param v1_workflow_run: The workflow run id to find runs for (required)
        :type v1_workflow_run: str
        :param offset: The number to skip
        :type offset: int
        :param limit: The number to limit by
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v1_workflow_run_task_events_list_serialize(
            v1_workflow_run=v1_workflow_run,
            offset=offset,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "V1TaskEventList",
            "400": "APIErrors",
            "403": "APIErrors",
            "501": "APIErrors",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _v1_workflow_run_task_events_list_serialize(
        self,
        v1_workflow_run,
        offset,
        limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if v1_workflow_run is not None:
            _path_params["v1-workflow-run"] = v1_workflow_run
        # process the query parameters
        if offset is not None:

            _query_params.append(("offset", offset))

        if limit is not None:

            _query_params.append(("limit", limit))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json"]
            )

        # authentication setting
        _auth_settings: List[str] = ["cookieAuth", "bearerAuth"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/api/v1/stable/workflow-runs/{v1-workflow-run}/task-events",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )
