# coding: utf-8

"""
    Hatchet API

    The Hatchet API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing_extensions import Self

from hatchet_sdk.clients.rest.models.v1_task_status import V1TaskStatus


class V1TaskFilter(BaseModel):
    """
    V1TaskFilter
    """  # noqa: E501

    since: datetime
    until: Optional[datetime] = None
    statuses: Optional[List[V1TaskStatus]] = None
    workflow_ids: Optional[List[StrictStr]] = Field(default=None, alias="workflowIds")
    additional_metadata: Optional[List[StrictStr]] = Field(
        default=None, alias="additionalMetadata"
    )
    __properties: ClassVar[List[str]] = [
        "since",
        "until",
        "statuses",
        "workflowIds",
        "additionalMetadata",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1TaskFilter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1TaskFilter from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "since": obj.get("since"),
                "until": obj.get("until"),
                "statuses": obj.get("statuses"),
                "workflowIds": obj.get("workflowIds"),
                "additionalMetadata": obj.get("additionalMetadata"),
            }
        )
        return _obj
