# coding: utf-8

"""
    Hatchet API

    The Hatchet API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field
from typing_extensions import Self

from hatchet_sdk.clients.rest.models.v1_task_event import V1TaskEvent
from hatchet_sdk.clients.rest.models.v1_task_summary import V1TaskSummary
from hatchet_sdk.clients.rest.models.v1_workflow_run import V1WorkflowRun
from hatchet_sdk.clients.rest.models.workflow_run_shape_item_for_workflow_run_details import (
    WorkflowRunShapeItemForWorkflowRunDetails,
)


class V1WorkflowRunDetails(BaseModel):
    """
    V1WorkflowRunDetails
    """  # noqa: E501

    run: V1WorkflowRun
    task_events: List[V1TaskEvent] = Field(
        description="The list of task events for the workflow run", alias="taskEvents"
    )
    shape: List[WorkflowRunShapeItemForWorkflowRunDetails]
    tasks: List[V1TaskSummary]
    workflow_config: Optional[Dict[str, Any]] = Field(
        default=None, alias="workflowConfig"
    )
    __properties: ClassVar[List[str]] = [
        "run",
        "taskEvents",
        "shape",
        "tasks",
        "workflowConfig",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1WorkflowRunDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of run
        if self.run:
            _dict["run"] = self.run.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in task_events (list)
        _items = []
        if self.task_events:
            for _item_task_events in self.task_events:
                if _item_task_events:
                    _items.append(_item_task_events.to_dict())
            _dict["taskEvents"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in shape (list)
        _items = []
        if self.shape:
            for _item_shape in self.shape:
                if _item_shape:
                    _items.append(_item_shape.to_dict())
            _dict["shape"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tasks (list)
        _items = []
        if self.tasks:
            for _item_tasks in self.tasks:
                if _item_tasks:
                    _items.append(_item_tasks.to_dict())
            _dict["tasks"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1WorkflowRunDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "run": (
                    V1WorkflowRun.from_dict(obj["run"])
                    if obj.get("run") is not None
                    else None
                ),
                "taskEvents": (
                    [V1TaskEvent.from_dict(_item) for _item in obj["taskEvents"]]
                    if obj.get("taskEvents") is not None
                    else None
                ),
                "shape": (
                    [
                        WorkflowRunShapeItemForWorkflowRunDetails.from_dict(_item)
                        for _item in obj["shape"]
                    ]
                    if obj.get("shape") is not None
                    else None
                ),
                "tasks": (
                    [V1TaskSummary.from_dict(_item) for _item in obj["tasks"]]
                    if obj.get("tasks") is not None
                    else None
                ),
                "workflowConfig": obj.get("workflowConfig"),
            }
        )
        return _obj
