# coding: utf-8

"""
    Hatchet API

    The Hatchet API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing_extensions import Self


class StepRunArchive(BaseModel):
    """
    StepRunArchive
    """  # noqa: E501

    step_run_id: StrictStr = Field(alias="stepRunId")
    order: StrictInt
    input: Optional[StrictStr] = None
    output: Optional[StrictStr] = None
    started_at: Optional[datetime] = Field(default=None, alias="startedAt")
    error: Optional[StrictStr] = None
    retry_count: StrictInt = Field(alias="retryCount")
    created_at: datetime = Field(alias="createdAt")
    started_at_epoch: Optional[StrictInt] = Field(default=None, alias="startedAtEpoch")
    finished_at: Optional[datetime] = Field(default=None, alias="finishedAt")
    finished_at_epoch: Optional[StrictInt] = Field(
        default=None, alias="finishedAtEpoch"
    )
    timeout_at: Optional[datetime] = Field(default=None, alias="timeoutAt")
    timeout_at_epoch: Optional[StrictInt] = Field(default=None, alias="timeoutAtEpoch")
    cancelled_at: Optional[datetime] = Field(default=None, alias="cancelledAt")
    cancelled_at_epoch: Optional[StrictInt] = Field(
        default=None, alias="cancelledAtEpoch"
    )
    cancelled_reason: Optional[StrictStr] = Field(default=None, alias="cancelledReason")
    cancelled_error: Optional[StrictStr] = Field(default=None, alias="cancelledError")
    __properties: ClassVar[List[str]] = [
        "stepRunId",
        "order",
        "input",
        "output",
        "startedAt",
        "error",
        "retryCount",
        "createdAt",
        "startedAtEpoch",
        "finishedAt",
        "finishedAtEpoch",
        "timeoutAt",
        "timeoutAtEpoch",
        "cancelledAt",
        "cancelledAtEpoch",
        "cancelledReason",
        "cancelledError",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StepRunArchive from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StepRunArchive from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "stepRunId": obj.get("stepRunId"),
                "order": obj.get("order"),
                "input": obj.get("input"),
                "output": obj.get("output"),
                "startedAt": obj.get("startedAt"),
                "error": obj.get("error"),
                "retryCount": obj.get("retryCount"),
                "createdAt": obj.get("createdAt"),
                "startedAtEpoch": obj.get("startedAtEpoch"),
                "finishedAt": obj.get("finishedAt"),
                "finishedAtEpoch": obj.get("finishedAtEpoch"),
                "timeoutAt": obj.get("timeoutAt"),
                "timeoutAtEpoch": obj.get("timeoutAtEpoch"),
                "cancelledAt": obj.get("cancelledAt"),
                "cancelledAtEpoch": obj.get("cancelledAtEpoch"),
                "cancelledReason": obj.get("cancelledReason"),
                "cancelledError": obj.get("cancelledError"),
            }
        )
        return _obj
