# coding: utf-8

"""
    Hatchet API

    The Hatchet API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing_extensions import Self

from hatchet_sdk.v0.clients.rest.models.step_run_event_reason import StepRunEventReason
from hatchet_sdk.v0.clients.rest.models.step_run_event_severity import (
    StepRunEventSeverity,
)


class StepRunEvent(BaseModel):
    """
    StepRunEvent
    """  # noqa: E501

    id: StrictInt
    time_first_seen: datetime = Field(alias="timeFirstSeen")
    time_last_seen: datetime = Field(alias="timeLastSeen")
    step_run_id: Optional[StrictStr] = Field(default=None, alias="stepRunId")
    workflow_run_id: Optional[StrictStr] = Field(default=None, alias="workflowRunId")
    reason: StepRunEventReason
    severity: StepRunEventSeverity
    message: StrictStr
    count: StrictInt
    data: Optional[Dict[str, Any]] = None
    __properties: ClassVar[List[str]] = [
        "id",
        "timeFirstSeen",
        "timeLastSeen",
        "stepRunId",
        "workflowRunId",
        "reason",
        "severity",
        "message",
        "count",
        "data",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StepRunEvent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StepRunEvent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "timeFirstSeen": obj.get("timeFirstSeen"),
                "timeLastSeen": obj.get("timeLastSeen"),
                "stepRunId": obj.get("stepRunId"),
                "workflowRunId": obj.get("workflowRunId"),
                "reason": obj.get("reason"),
                "severity": obj.get("severity"),
                "message": obj.get("message"),
                "count": obj.get("count"),
                "data": obj.get("data"),
            }
        )
        return _obj
