# coding: utf-8

"""
    Hatchet API

    The Hatchet API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing_extensions import Self

from hatchet_sdk.v0.clients.rest.models.queue_metrics import QueueMetrics


class TenantQueueMetrics(BaseModel):
    """
    TenantQueueMetrics
    """  # noqa: E501

    total: Optional[QueueMetrics] = Field(
        default=None, description="The total queue metrics."
    )
    workflow: Optional[Dict[str, QueueMetrics]] = None
    queues: Optional[Dict[str, StrictInt]] = None
    __properties: ClassVar[List[str]] = ["total", "workflow", "queues"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TenantQueueMetrics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of total
        if self.total:
            _dict["total"] = self.total.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in workflow (dict)
        _field_dict = {}
        if self.workflow:
            for _key_workflow in self.workflow:
                if self.workflow[_key_workflow]:
                    _field_dict[_key_workflow] = self.workflow[_key_workflow].to_dict()
            _dict["workflow"] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TenantQueueMetrics from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "total": (
                    QueueMetrics.from_dict(obj["total"])
                    if obj.get("total") is not None
                    else None
                ),
                "workflow": (
                    dict(
                        (_k, QueueMetrics.from_dict(_v))
                        for _k, _v in obj["workflow"].items()
                    )
                    if obj.get("workflow") is not None
                    else None
                ),
                "queues": obj.get("queues"),
            }
        )
        return _obj
