"""
Stub file generated for MotionBuilder 2022 using:
https://github.com/nils-soderman/pyfbsdk-stub-generator
"""
# pylint: disable=all
from __future__ import annotations
from typing import overload, Any, Iterator, Literal, Self
import callbackframework
from enum import EnumMeta as __EnumMeta
class Enumeration(int, metaclass=__EnumMeta):
	__slots__:tuple
	names:dict[str, Self]
	values:dict[int, Self]
	@overload
	def __init__(self,value:str|int=0,/):...
	@overload
	def __init__(self,value:str|bytes|bytearray,/,base:int): ...
class FBAccessMode(Enumeration):
	"""pyfbsdk

	Data access modes."""
	kFBAccessModeDisk=0
	"""Access data directly to disk using a cache system."""
	kFBAccessModeMemory=1
	"""Access data from memory, which means that it will copyed entirely into it."""
class FBAlphaSource(Enumeration):
	"""Shader transparency computation.

	There are different way to compute transparency, and this lists the supported options."""
	kFBAlphaSource2DTransparency=4
	"""2D Transparency."""
	kFBAlphaSourceAccurateAlpha=1
	"""Accurate Transparency."""
	kFBAlphaSourceAdditiveAlpha=5
	"""Additive Transparency."""
	kFBAlphaSourceMatteAlpha=3
	"""Matte."""
	kFBAlphaSourceNoAlpha=0
	"""No transparency."""
	kFBAlphaSourceTransluscentAlpha=2
	"""Translucent."""
	kFBAlphaSourceTransluscentZSortAlpha=6
	"""Translucent(Models Z Sort)."""
class FBAnimationLayerMergeOptions(Enumeration):
	"""Merge option for animation layers."""
	kFBAnimLayerMerge_AllLayers_AllProperties=3
	"""Merge the animation of all properties of the selected models from all the layers to the BaseAnimation layer."""
	kFBAnimLayerMerge_AllLayers_CompleteScene=5
	"""Merge the animation of all properties from all the layers to the BaseAnimation layer."""
	kFBAnimLayerMerge_AllLayers_SelectedProperties=1
	"""Merge the animation of the selected properties of the selected models from all the layers to the BaseAnimation layer."""
	kFBAnimLayerMerge_SelectedLayers_AllProperties=2
	"""Merge the animation of all properties of the selected models from the selected layers to the selected layer with the lowest index."""
	kFBAnimLayerMerge_SelectedLayers_CompleteScene=4
	"""Merge the animation of all properties from the selected layers to the selected layer with the lowest index."""
	kFBAnimLayerMerge_SelectedLayers_SelectedProperties=0
	"""Merge the animation of the selected properties of the selected models from the selected layers to the selected layer with the lowest index."""
class FBAnimationNodeConnectorType(Enumeration):
	"""Different types for the animation node connectors."""
	kFBAnimationNodeConnectorTypeConnectedIn=1
	"""The animation node input connector is connected to an animation node output connector (valid for input connector only)."""
	kFBAnimationNodeConnectorTypeConnectedOut=2
	"""The animation node output connector is connected to at least one animation node input connector (valid for output connector only)."""
	kFBAnimationNodeConnectorTypeConstantIn=3
	"""The animation node input connector has a constant value set to it (valid for input connector only)."""
	kFBAnimationNodeConnectorTypeNone=0
	"""The animation node connector is not connected and doesn't have a constant value set to it."""
class FBArrangeMode(Enumeration):
	"""Modes for arranging objects in schematic view."""
	kHorizontalMode=0
	"""Arrange all objects horizontally."""
	kVerticalMode=1
	"""Arrange all objects vertically."""
class FBAssetMngFileOptions(Enumeration):
	"""Behavior of the application when working with managed files."""
	kFileAddOnNewSave=16
	"""Add new file automatically on save."""
	kFileAddOnNewSave_Ask=32
	"""Ask for adding new file on save."""
	kFileCheckInOnClose=64
	"""Check in file automatically when closing it."""
	kFileCheckInOnClose_Ask=128
	"""Ask for check in file when closing it."""
	kFileCheckOutOnLoad=1
	"""Check out file automatically on load."""
	kFileCheckOutOnLoad_Ask=2
	"""Ask for checkout on load."""
	kFileOptionsAll=-1
	kFileUploadOnSave=4
	"""Upload file automatically on save."""
	kFileUploadOnSave_Ask=8
	"""Ask for upload on save."""
class FBAssetMngMenuOptions(Enumeration):
	"""Show or hide version control menu items.

	Let you specify which functionalities will be available from the menus."""
	kMenuAddToDatabase=2
	"""File -> Add to database."""
	kMenuAll=-1
	"""Support everything."""
	kMenuCheckIn=16
	"""Version Control -> Check In."""
	kMenuCheckOut=32
	"""Version Control -> Check Out."""
	kMenuEnable=4096
	"""Version Control -> Disable Version Control Integration."""
	kMenuFileAll=7
	"""Support all elements from the File menu."""
	kMenuGetLatest=8
	"""Version Control -> Get Latest."""
	kMenuOpenFromDatabase=1
	"""File -> Open from database."""
	kMenuShowExplorer=512
	"""Version Control -> Show Explorer."""
	kMenuShowHistory=128
	"""Version Control -> Show History."""
	kMenuShowProperties=256
	"""Version Control -> Show Properties."""
	kMenuShowReferenceMng=1024
	"""Version Control -> Show Reference Manager."""
	kMenuShowSettings=2048
	"""Version Control -> Show Settings."""
	kMenuSourceControlAll=8184
	"""Support all elements from the Version Control menu."""
	kMenuSourceControlMin=6264
	"""Support only the basics functionalities."""
	kMenuUndoCheckOut=64
	"""Version Control -> Undo Check Out."""
	kMenuUploadToDatabase=4
	"""File -> Upload to database."""
class FBAttachType(Enumeration):
	"""Types of attachments between UI regions.

	[See samples: Attach.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_attach_8py-example.html) [BoxLayout.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_box_layout_8py-example.html) [RadioButton.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_radio_button_8py-example.html)"""
	kFBAttachBottom=3
	"""Attach to bottom [max(y1,y2)]"""
	kFBAttachCenter=6
	"""Attach to center [center(x1,y1,x2,y2)]"""
	kFBAttachHeight=5
	"""Attach to height [abs(y2-y1)]"""
	kFBAttachLeft=0
	"""Attach to left [min(x1,x2)]"""
	kFBAttachNone=7
	"""No attachment."""
	kFBAttachRight=1
	"""Attach to right [max(x1,x2)]"""
	kFBAttachTop=2
	"""Attach to top [min(y1,y2)]"""
	kFBAttachWidth=4
	"""Attach to width [abs(x2-x1)]"""
class FBAttenuationType(Enumeration):
	"""Light attenuation types."""
	kFBAttenuationCubic=3
	"""Cubic attenuation."""
	kFBAttenuationLinear=1
	"""Linear attenuation."""
	kFBAttenuationNone=0
	"""No attenuation."""
	kFBAttenuationQuadratic=2
	"""Quadratic attenuation."""
class FBAudioBitDepthMode(Enumeration):
	"""Enum [FBAudioBitDepthMode](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_audio_bit_depth_mode.html "Enum FBAudioBitDepthMode.")."""
	kFBAudioBitDepthMode_16=1
	"""16 bits, Wave file render support."""
	kFBAudioBitDepthMode_24=2
	"""24 bits, Wave file render support."""
	kFBAudioBitDepthMode_8=0
	"""8 bits, Wave file render support."""
	kFBAudioBitDepthMode_FP=3
	"""FP type audio, Wave file render not support."""
class FBAudioChannelMode(Enumeration):
	"""Enum [FBAudioChannelMode](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_audio_channel_mode.html "Enum FBAudioChannelMode.")."""
	kFBAudioChannelModeMono=0
	"""1 channel, Wave file render support."""
	kFBAudioChannelModeStereo=1
	"""2 channels, Wave file render support."""
	kFBAudioChannelMode_4=2
	"""4 channels, Wave file render not support."""
	kFBAudioChannelMode_8=3
	"""8 channels, Wave file render not support."""
class FBAudioOutputLocation(Enumeration):
	"""Type of locations where the audio is rendered when rendering a scene using a video format."""
	FBAudioOutputLocationCount=3
	"""Count."""
	FBAudioOutputLocationEmbedded=0
	"""The audio is embedded within the video output file."""
	FBAudioOutputLocationEmbeddedAndStandalone=2
	"""The audio is embedded within the video output file and is also rendered in a standalone output file."""
	FBAudioOutputLocationStandalone=1
	"""The audio is rendered in a standalone output file."""
class FBAudioRateMode(Enumeration):
	"""Enum [FBAudioRateMode](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_audio_rate_mode.html "Enum FBAudioRateMode.")."""
	kFBAudioRateMode_100000=15
	"""100000 hz, Wave file render not support."""
	kFBAudioRateMode_12000=2
	"""12000 hz, Wave file render support."""
	kFBAudioRateMode_12500=3
	"""12500 hz, Wave file render not support."""
	kFBAudioRateMode_16000=4
	"""16000 hz, Wave file render support."""
	kFBAudioRateMode_22050=5
	"""22050 hz, Wave file render support."""
	kFBAudioRateMode_24000=6
	"""24000 hz, Wave file render support."""
	kFBAudioRateMode_25000=7
	"""25000 hz, Wave file render not support."""
	kFBAudioRateMode_32000=8
	"""32000 hz, Wave file render support."""
	kFBAudioRateMode_44100=9
	"""44100 hz, Wave file render support."""
	kFBAudioRateMode_48000=10
	"""48000 hz, Wave file render support."""
	kFBAudioRateMode_50000=11
	"""50000 hz, Wave file render not support."""
	kFBAudioRateMode_64000=12
	"""64000 hz, Wave file render support."""
	kFBAudioRateMode_8000=0
	"""8000 hz, Wave file render support."""
	kFBAudioRateMode_88200=13
	"""88200 hz, Wave file render support."""
	kFBAudioRateMode_96000=14
	"""96000 hz, Wave file render support."""
	kFBRAudioateMode_11025=1
	"""11025 hz, Wave file render support."""
class FBBatchFileFormat(Enumeration):
	"""Different file formats for the batch."""
	kFBBatchFileFormatAMC=2
	"""File format for Acclaim AMC."""
	kFBBatchFileFormatBVH=3
	"""File format for Biovision BVH."""
	kFBBatchFileFormatC3D=1
	"""File format for Vicon C3D."""
	kFBBatchFileFormatFBX=5
	"""File format for FBX (animation only)."""
	kFBBatchFileFormatHTR=4
	"""File format for Motion Analysis HTR."""
	kFBBatchFileFormatTRC=0
	"""File format for Motion Analysis TRC."""
class FBBatchOnContainsBatchTakes(Enumeration):
	"""Different actions to perform when a scene already contains batch takes while in a batch process."""
	kFBBatchOnContainsBatchTakesSaveAllTakes=1
	"""Save all the takes."""
	kFBBatchOnContainsBatchTakesSaveBatchTakesOnly=0
	"""Save only the batch takes."""
class FBBatchOnTakeExist(Enumeration):
	"""Different actions to perform when a take already exist while in a batch process."""
	kFBBatchOnTakeExistOverwrite=0
	"""Overwrite the take."""
	kFBBatchOnTakeExistSkip=1
	"""Skip the take."""
class FBBatchProcessType(Enumeration):
	"""Different process type for the batch."""
	kFBBatchProcessTypeConvert=2
	"""Does the load and save."""
	kFBBatchProcessTypeLoad=0
	"""Load the files and plot the character with every take."""
	kFBBatchProcessTypeSave=1
	"""Save the takes in different files."""
class FBBatchStatus(Enumeration):
	"""Different return values of the Batch process."""
	kFBBatchStatusActorInputMarkersetHasNoReferenceModel=7
	kFBBatchStatusActorInputMarkersetNotCorrectlyAssociated=8
	kFBBatchStatusActorInputMarkersetNotSpecified=6
	kFBBatchStatusAsfSkeletonFileNotSpecified=12
	kFBBatchStatusCantOpenAsfSkeletonFile=13
	kFBBatchStatusCharacterHasNoReference=4
	kFBBatchStatusCharacterNotCharacterized=3
	kFBBatchStatusCharacterNotSpecified=2
	kFBBatchStatusError=1
	kFBBatchStatusInputActorNotSpecified=5
	kFBBatchStatusInputCharacterHasNoReference=10
	kFBBatchStatusInputCharacterNotCharacterized=9
	kFBBatchStatusInputDirectoryNotValid=11
	kFBBatchStatusOutputDirectoryNotValid=14
	kFBBatchStatusSuccess=0
class FBBodyNodeId(Enumeration):
	"""All body nodes.

	[See sample: ExportAnimationLibrary.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_export_animation_library_8py-example.html)"""
	kFBChestNodeId=10
	"""Spine 1."""
	kFBHeadNodeId=20
	"""Required."""
	kFBHipsNodeId=0
	"""Required."""
	kFBHipsTranslationNodeId=169
	kFBInvalidNodeId=-1
	kFBLastNodeId=210
	kFBLastNodeId_Old=170
	kFBLeftAnkleNodeId=3
	"""Required."""
	kFBLeftCollarNodeId=11
	kFBLeftElbowNodeId=13
	"""Required."""
	kFBLeftElbowRollNode1Id=175
	"""New leaf roll bone."""
	kFBLeftElbowRollNode2Id=183
	"""New leaf roll bone."""
	kFBLeftElbowRollNode3Id=191
	"""New leaf roll bone."""
	kFBLeftElbowRollNode4Id=199
	"""New leaf roll bone."""
	kFBLeftElbowRollNode5Id=207
	"""New leaf roll bone."""
	kFBLeftElbowRollNodeId=26
	kFBLeftExtraFingerANodeId=89
	"""New extra finger bone."""
	kFBLeftExtraFingerBNodeId=90
	"""New extra finger bone."""
	kFBLeftExtraFingerCNodeId=91
	"""New extra finger bone."""
	kFBLeftExtraFingerDNodeId=92
	"""New extra finger bone."""
	kFBLeftExtraFingerInNodeId=88
	"""New extra finger bone."""
	kFBLeftExtraFootFingerANodeId=149
	"""New extra finger bone."""
	kFBLeftExtraFootFingerBNodeId=150
	"""New extra finger bone."""
	kFBLeftExtraFootFingerCNodeId=151
	"""New extra finger bone."""
	kFBLeftExtraFootFingerDNodeId=152
	"""New extra finger bone."""
	kFBLeftExtraFootFingerInNodeId=148
	"""New extra finger bone."""
	kFBLeftFootIndexANodeId=104
	kFBLeftFootIndexBNodeId=105
	kFBLeftFootIndexCNodeId=106
	kFBLeftFootIndexDNodeId=107
	kFBLeftFootIndexInNodeId=103
	kFBLeftFootMiddleANodeId=109
	kFBLeftFootMiddleBNodeId=110
	kFBLeftFootMiddleCNodeId=111
	kFBLeftFootMiddleDNodeId=112
	kFBLeftFootMiddleInNodeId=108
	kFBLeftFootNodeId=4
	kFBLeftFootPinkyANodeId=119
	kFBLeftFootPinkyBNodeId=120
	kFBLeftFootPinkyCNodeId=121
	kFBLeftFootPinkyDNodeId=122
	kFBLeftFootPinkyInNodeId=118
	kFBLeftFootRingANodeId=114
	kFBLeftFootRingBNodeId=115
	kFBLeftFootRingCNodeId=116
	kFBLeftFootRingDNodeId=117
	kFBLeftFootRingInNodeId=113
	kFBLeftFootThumbANodeId=99
	kFBLeftFootThumbBNodeId=100
	kFBLeftFootThumbCNodeId=101
	kFBLeftFootThumbDNodeId=102
	kFBLeftFootThumbInNodeId=98
	kFBLeftHandNodeId=158
	kFBLeftHipNodeId=1
	"""Required."""
	kFBLeftHipRollNode1Id=170
	"""New leaf roll bone."""
	kFBLeftHipRollNode2Id=178
	"""New leaf roll bone."""
	kFBLeftHipRollNode3Id=186
	"""New leaf roll bone."""
	kFBLeftHipRollNode4Id=194
	"""New leaf roll bone."""
	kFBLeftHipRollNode5Id=202
	"""New leaf roll bone."""
	kFBLeftHipRollNodeId=21
	kFBLeftIndexANodeId=40
	kFBLeftIndexBNodeId=41
	kFBLeftIndexCNodeId=42
	kFBLeftIndexDNodeId=71
	kFBLeftIndexInNodeId=70
	kFBLeftKneeNodeId=2
	"""Required."""
	kFBLeftKneeRollNode1Id=171
	"""New leaf roll bone."""
	kFBLeftKneeRollNode2Id=179
	"""New leaf roll bone."""
	kFBLeftKneeRollNode3Id=187
	"""New leaf roll bone."""
	kFBLeftKneeRollNode4Id=195
	"""New leaf roll bone."""
	kFBLeftKneeRollNode5Id=203
	"""New leaf roll bone."""
	kFBLeftKneeRollNodeId=22
	kFBLeftMiddleANodeId=43
	kFBLeftMiddleBNodeId=44
	kFBLeftMiddleCNodeId=45
	kFBLeftMiddleDNodeId=73
	kFBLeftMiddleInNodeId=72
	kFBLeftPinkyANodeId=49
	kFBLeftPinkyBNodeId=50
	kFBLeftPinkyCNodeId=51
	kFBLeftPinkyDNodeId=77
	kFBLeftPinkyInNodeId=76
	kFBLeftRingANodeId=46
	kFBLeftRingBNodeId=47
	kFBLeftRingCNodeId=48
	kFBLeftRingDNodeId=75
	kFBLeftRingInNodeId=74
	kFBLeftShoulderNodeId=12
	"""Required."""
	kFBLeftShoulderRollNode1Id=174
	"""New leaf roll bone."""
	kFBLeftShoulderRollNode2Id=182
	"""New leaf roll bone."""
	kFBLeftShoulderRollNode3Id=190
	"""New leaf roll bone."""
	kFBLeftShoulderRollNode4Id=198
	"""New leaf roll bone."""
	kFBLeftShoulderRollNode5Id=206
	"""New leaf roll bone."""
	kFBLeftShoulderRollNodeId=25
	kFBLeftThumbANodeId=37
	kFBLeftThumbBNodeId=38
	kFBLeftThumbCNodeId=39
	kFBLeftThumbDNodeId=69
	kFBLeftThumbInNodeId=68
	kFBLeftWristNodeId=14
	"""Required."""
	kFBNeck1NodeId=160
	kFBNeck2NodeId=161
	kFBNeck3NodeId=162
	kFBNeck4NodeId=163
	kFBNeck5NodeId=164
	kFBNeck6NodeId=165
	kFBNeck7NodeId=166
	kFBNeck8NodeId=167
	kFBNeck9NodeId=168
	kFBNeckNodeId=19
	kFBReferenceNodeId=67
	kFBRightAnkleNodeId=7
	"""Required."""
	kFBRightCollarNodeId=15
	kFBRightElbowNodeId=17
	"""Required."""
	kFBRightElbowRollNode1Id=177
	"""New leaf roll bone."""
	kFBRightElbowRollNode2Id=185
	"""New leaf roll bone."""
	kFBRightElbowRollNode3Id=193
	"""New leaf roll bone."""
	kFBRightElbowRollNode4Id=201
	"""New leaf roll bone."""
	kFBRightElbowRollNode5Id=209
	"""New leaf roll bone."""
	kFBRightElbowRollNodeId=28
	kFBRightExtraFingerANodeId=94
	"""New extra finger bone."""
	kFBRightExtraFingerBNodeId=95
	"""New extra finger bone."""
	kFBRightExtraFingerCNodeId=96
	"""New extra finger bone."""
	kFBRightExtraFingerDNodeId=97
	"""New extra finger bone."""
	kFBRightExtraFingerInNodeId=93
	"""New extra finger bone."""
	kFBRightExtraFootFingerANodeId=154
	"""New extra finger bone."""
	kFBRightExtraFootFingerBNodeId=155
	"""New extra finger bone."""
	kFBRightExtraFootFingerCNodeId=156
	"""New extra finger bone."""
	kFBRightExtraFootFingerDNodeId=157
	"""New extra finger bone."""
	kFBRightExtraFootFingerInNodeId=153
	"""New extra finger bone."""
	kFBRightFootIndexANodeId=129
	kFBRightFootIndexBNodeId=130
	kFBRightFootIndexCNodeId=131
	kFBRightFootIndexDNodeId=132
	kFBRightFootIndexInNodeId=128
	kFBRightFootMiddleANodeId=134
	kFBRightFootMiddleBNodeId=135
	kFBRightFootMiddleCNodeId=136
	kFBRightFootMiddleDNodeId=137
	kFBRightFootMiddleInNodeId=133
	kFBRightFootNodeId=8
	kFBRightFootPinkyANodeId=144
	kFBRightFootPinkyBNodeId=145
	kFBRightFootPinkyCNodeId=146
	kFBRightFootPinkyDNodeId=147
	kFBRightFootPinkyInNodeId=143
	kFBRightFootRingANodeId=139
	kFBRightFootRingBNodeId=140
	kFBRightFootRingCNodeId=141
	kFBRightFootRingDNodeId=142
	kFBRightFootRingInNodeId=138
	kFBRightFootThumbANodeId=124
	kFBRightFootThumbBNodeId=125
	kFBRightFootThumbCNodeId=126
	kFBRightFootThumbDNodeId=127
	kFBRightFootThumbInNodeId=123
	kFBRightHandNodeId=159
	kFBRightHipNodeId=5
	"""Required."""
	kFBRightHipRollNode1Id=172
	"""New leaf roll bone."""
	kFBRightHipRollNode2Id=180
	"""New leaf roll bone."""
	kFBRightHipRollNode3Id=188
	"""New leaf roll bone."""
	kFBRightHipRollNode4Id=196
	"""New leaf roll bone."""
	kFBRightHipRollNode5Id=204
	"""New leaf roll bone."""
	kFBRightHipRollNodeId=23
	kFBRightIndexANodeId=55
	kFBRightIndexBNodeId=56
	kFBRightIndexCNodeId=57
	kFBRightIndexDNodeId=81
	kFBRightIndexInNodeId=80
	kFBRightKneeNodeId=6
	"""Required."""
	kFBRightKneeRollNode1Id=173
	"""New leaf roll bone."""
	kFBRightKneeRollNode2Id=181
	"""New leaf roll bone."""
	kFBRightKneeRollNode3Id=189
	"""New leaf roll bone."""
	kFBRightKneeRollNode4Id=197
	"""New leaf roll bone."""
	kFBRightKneeRollNode5Id=205
	"""New leaf roll bone."""
	kFBRightKneeRollNodeId=24
	kFBRightMiddleANodeId=58
	kFBRightMiddleBNodeId=59
	kFBRightMiddleCNodeId=60
	kFBRightMiddleDNodeId=83
	kFBRightMiddleInNodeId=82
	kFBRightPinkyANodeId=64
	kFBRightPinkyBNodeId=65
	kFBRightPinkyCNodeId=66
	kFBRightPinkyDNodeId=87
	kFBRightPinkyInNodeId=86
	kFBRightRingANodeId=61
	kFBRightRingBNodeId=62
	kFBRightRingCNodeId=63
	kFBRightRingDNodeId=85
	kFBRightRingInNodeId=84
	kFBRightShoulderNodeId=16
	"""Required."""
	kFBRightShoulderRollNode1Id=176
	"""New leaf roll bone."""
	kFBRightShoulderRollNode2Id=184
	"""New leaf roll bone."""
	kFBRightShoulderRollNode3Id=192
	"""New leaf roll bone."""
	kFBRightShoulderRollNode4Id=200
	"""New leaf roll bone."""
	kFBRightShoulderRollNode5Id=208
	"""New leaf roll bone."""
	kFBRightShoulderRollNodeId=27
	kFBRightThumbANodeId=52
	kFBRightThumbBNodeId=53
	kFBRightThumbCNodeId=54
	kFBRightThumbDNodeId=79
	kFBRightThumbInNodeId=78
	kFBRightWristNodeId=18
	"""Required."""
	kFBSpine2NodeId=29
	kFBSpine3NodeId=30
	kFBSpine4NodeId=31
	kFBSpine5NodeId=32
	kFBSpine6NodeId=33
	kFBSpine7NodeId=34
	kFBSpine8NodeId=35
	kFBSpine9NodeId=36
	kFBWaistNodeId=9
	"""Required, Spine 0."""
class FBBodyPartId(Enumeration):
	"""Body part for character."""
	kFBCtrlSetPartChest=2
	"""Chest Body Part."""
	kFBCtrlSetPartHead=7
	"""Head Body Part."""
	kFBCtrlSetPartHips=1
	"""Hips Body Part."""
	kFBCtrlSetPartLeftArm=3
	"""Left Arm Body Part."""
	kFBCtrlSetPartLeftFoot=10
	"""Left Foot Body Part."""
	kFBCtrlSetPartLeftHand=8
	"""Left Hand Body Part."""
	kFBCtrlSetPartLeftLeg=5
	"""Left Leg Body Part."""
	kFBCtrlSetPartNone=0
	"""No part selected."""
	kFBCtrlSetPartRightArm=4
	"""Right Arm Body Part."""
	kFBCtrlSetPartRightFoot=11
	"""Right Foot Body Part."""
	kFBCtrlSetPartRightHand=9
	"""Right Hand Body Part."""
	kFBCtrlSetPartRightLeg=6
	"""Right Leg Body Part."""
	kFBLastCtrlSetPartIndex=12
	"""Part count."""
class FBBorderStyle(Enumeration):
	"""Different border types available.

	[See samples: Border.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_border_8py-example.html) [TabPanel.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_tab_panel_8py-example.html)"""
	kFBEmbossBorder=2
	"""Embossed border."""
	kFBEmbossEdgeSmoothBorder=4
	"""Edged smooth border."""
	kFBEmbossSmoothBorder=3
	"""Smooth border."""
	kFBEmbossSmoothEdgeBorder=5
	"""Smoothed edges border."""
	kFBHighlightBorder=9
	"""Highlight border."""
	kFBNoBorder=0
	"""No border."""
	kFBPickingBorder=10
	"""Picking border."""
	kFBStandardBorder=1
	"""Standard border."""
	kFBStandardEdgeSmoothBorder=7
	"""Standard edged smooth border."""
	kFBStandardSmoothBorder=6
	"""Standard smooth border."""
	kFBStandardSmoothEdgeBorder=8
	"""Standard smoothed edges border."""
class FBButtonLook(Enumeration):
	"""Button look.

	[See sample: Button.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_button_8py-example.html)"""
	kFBLookAlphaBackground=99
	kFBLookColorChange=1
	kFBLookFlat=3
	kFBLookNormal=0
	kFBLookPush=2
class FBButtonState(Enumeration):
	"""Possible button states.

	Currently, only two button states are possible."""
	kFBButtonState0=0
	"""State is 0, usually meaning not active."""
	kFBButtonState1=1
	"""State is 1, usually meaning active."""
class FBButtonStyle(Enumeration):
	"""Style of buttons.

	Not all button styles are completely functional.

	[See samples: Button.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_button_8py-example.html) [RadioButton.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_radio_button_8py-example.html)"""
	kFB2States=3
	"""2 state button (2 colors)."""
	kFBBitmap2States=4
	"""2 state button with 2 bitmaps."""
	kFBBitmapButton=1
	"""Button with bitmap on it."""
	kFBCheckbox=3
	"""Check box."""
	kFBPushButton=0
	"""Normal button."""
	kFBRadioButton=2
	"""Radio button."""
class FBCameraAntiAliasingMethod(Enumeration):
	"""Antialiasing methods."""
	kFBAntiAliasingSoftware=0
	"""Antaliasing in software."""
	kFBAntialiasingMultiSamplingOnyx=1
	"""Multisampling (only on Onyx)."""
class FBCameraApertureMode(Enumeration):
	"""Aperture modes."""
	kFBApertureFocalLength=3
	"""Focal Length aperture varies."""
	kFBApertureHorizontal=1
	"""Horizontal aperture varies."""
	kFBApertureVertHoriz=2
	"""Vertical and horizontal aperture varies."""
	kFBApertureVertical=0
	"""Vertical aperture varies."""
class FBCameraDistanceMode(Enumeration):
	"""Camera plane distance modes."""
	kFBDistModeAbsoluteFromCamera=1
	"""Camera plane distance absolute from camera."""
	kFBDistModeRelativeToInterest=0
	"""Camera plane distance relative to interest."""
class FBCameraFilmBackType(Enumeration):
	"""Filmback types."""
	kFBFilmBack16mmTheatrical=1
	"""16mm Theatrical."""
	kFBFilmBack35mm185Projection=6
	"""35mm 185 Projection."""
	kFBFilmBack35mmAcademy=3
	"""35mm Academy."""
	kFBFilmBack35mmAnamorphic=7
	"""35mm Anamorphic."""
	kFBFilmBack35mmFullAperture=5
	"""35mm Full Aperture."""
	kFBFilmBack35mmTVProjection=4
	"""35mm TV Projection."""
	kFBFilmBack70mmProjection=8
	"""70mm Projection."""
	kFBFilmBackCustom=0
	"""Custom Filmback."""
	kFBFilmBackDynavision=10
	"""Dynavision."""
	kFBFilmBackIMAX=11
	"""IMAX."""
	kFBFilmBackSuper16mm=2
	"""Super16mm."""
	kFBFilmBackVistaVision=9
	"""Vista Vision."""
class FBCameraFocusDistanceSource(Enumeration):
	"""Focus distance sources."""
	kFBFocusDistanceCameraInterest=0
	"""Interest as source."""
	kFBFocusDistanceModel=2
	"""Another model's position as source."""
	kFBFocusDistanceSpecificDistance=1
	"""Specific distance as source."""
class FBCameraFrameSizeMode(Enumeration):
	"""Frame size modes."""
	kFBFrameSizeFixedHeightResolution=4
	"""Fixed height resolution."""
	kFBFrameSizeFixedRatio=1
	"""Fixed ratio."""
	kFBFrameSizeFixedResolution=2
	"""Fixed resolution."""
	kFBFrameSizeFixedWidthResolution=3
	"""Fixed width resolution."""
	kFBFrameSizeWindow=0
	"""Frame size of window."""
class FBCameraMatrixType(Enumeration):
	"""Camera matrix types in OpenGL convention."""
	kFBModelView=1
	"""Camera's combined Model-View matrix."""
	kFBModelViewProj=2
	"""Camera's combined Model-View-Projection matrix."""
	kFBProjInverse=3
	"""Camera's Projection Inverse matrix."""
	kFBProjection=0
	"""Camera's Projection matrix."""
class FBCameraResolutionMode(Enumeration):
	"""Resolution modes."""
	kFBResolution128x128=9
	"""128x128."""
	kFBResolution320x200=7
	"""320x200."""
	kFBResolution320x240=8
	"""320x240."""
	kFBResolution640x480=6
	"""640x480."""
	kFBResolutionCustom=0
	"""Custom resolution mode or From Camera as a render setting."""
	kFBResolutionD1NTSC=1
	"""D1 NTSC."""
	kFBResolutionD1PAL=4
	"""D1 PAL."""
	kFBResolutionFullScreen=10
	"""FullScreen."""
	kFBResolutionHD=5
	"""HD 1920x1080."""
	kFBResolutionNTSC=2
	"""NTSC."""
	kFBResolutionPAL=3
	"""PAL."""
class FBCameraSafeAreaMode(Enumeration):
	"""Safe area modes."""
	kFBSafeAreaRound=1
	"""Round safe area."""
	kFBSafeAreaSquare=0
	"""Square safe area."""
class FBCameraSamplingType(Enumeration):
	"""Antialiasing sampling types."""
	kFBSamplingStochastic=1
	"""Stochastic sampling."""
	kFBSamplingUniform=0
	"""Uniform sampling."""
class FBCameraStereoType(Enumeration):
	kFBCameraStereoConverged=1
	kFBCameraStereoNone=0
	kFBCameraStereoOff_Axis=2
	kFBCameraStereoParallel=3
class FBCameraType(Enumeration):
	"""Focus distance types."""
	kFBCameraTypeOrthogonal=1
	"""Specific distance as source."""
	kFBCameraTypePerspective=0
	"""Interest as source."""
class FBCameraViewPlaneMode(Enumeration):
	"""Camera plane viewing modes."""
	kFBViewPlaneAlways=1
	"""Always draw camera plane."""
	kFBViewPlaneDisabled=0
	"""Camera plane disabled."""
	kFBViewPlaneWhenMedia=2
	"""Camera plane when media."""
class FBCellStyle(Enumeration):
	"""Different styles of spreadsheet cell styles."""
	kFBCellStyle2StatesButton=5
	"""2 state button."""
	kFBCellStyle3StatesButton=6
	"""3 state button."""
	kFBCellStyleButton=4
	"""Button."""
	kFBCellStyleDefault=0
	"""Default cell style."""
	kFBCellStyleDouble=2
	"""Double."""
	kFBCellStyleInteger=3
	"""Integer."""
	kFBCellStyleMenu=7
	"""Menu."""
	kFBCellStyleString=1
	"""String."""
	kFBCellStyleTime=10
	"""Time."""
	kFBCellStyleView=9
	"""View (user definable, you need to specify the view using [FBSpread::SetCellView()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_spread.html#a025dbf3b076a2788386cb9f99900a159 "Set a cell's internal toolkit view."))."""
	kFBCellStyleVoid=8
	"""Void (no value)."""
class FBCharacterContactBehaviour(Enumeration):
	"""Character Contact Behaviour."""
	kFBLastContactBehaviour=3
	kFBParamContactAlwaysSync=2
	kFBParamContactNeverSync=0
	kFBParamContactSyncOnKey=1
class FBCharacterExtensionRetargetMode(Enumeration):
	"""Character extension Retarget Mode"""
	kFBRetargetModeAuto=1
	kFBRetargetModeManual=2
	kFBRetargetModeOff=0
class FBCharacterExtensionStancePoseMode(Enumeration):
	"""Character Extension Stance Pose mode when the stance pose is activated on a character."""
	kFBStancePose_Always=4
	kFBStancePose_Never=0
	kFBStancePose_Reference_Selected=2
	kFBStancePose_Selected=1
	kFBStancePose_Self_Or_Reference_Selected=3
class FBCharacterHipsTranslationMode(Enumeration):
	"""Character Hips Translation modes."""
	kFBLastHipsTranslationMode=2
	kFBParamHipsTranslationBodyRigid=1
	kFBParamHipsTranslationWorldRigid=0
class FBCharacterInputType(Enumeration):
	"""Character Input/Output types."""
	kFBCharacterInputActor=0
	kFBCharacterInputCharacter=1
	kFBCharacterInputMarkerSet=2
	kFBCharacterInputMoCap=5
	kFBCharacterInputStance=4
	kFBCharacterOutputMarkerSet=3
class FBCharacterKeyingMode(Enumeration):
	"""Character keying modes."""
	kFBCharacterKeyingBodyPart=1
	kFBCharacterKeyingFullBody=0
	kFBCharacterKeyingFullBodyNoPull=3
	kFBCharacterKeyingSelection=2
class FBCharacterLoadAnimationMethod(Enumeration):
	"""This enumeration is used to choose how to load an animation file on a character."""
	kFBCharacterLoadConnect=0
	"""Only connect the loaded character as an input."""
	kFBCharacterLoadCopy=1
	"""Copy keys from loaded character to target character."""
	kFBCharacterLoadPlot=4
	"""Plot animation from loaded character to target character."""
	kFBCharacterLoadPlotIfSampled=3
	"""If loaded animation seems sampled, plot animation from loaded character to target character; else retarget."""
	kFBCharacterLoadRetarget=2
	"""Retarget (copy and correct) keys from loaded character to target character."""
class FBCharacterPlotWhere(Enumeration):
	"""Where to plot a character."""
	kFBCharacterPlotOnControlRig=0
	kFBCharacterPlotOnSkeleton=1
class FBCharacterPoseFlag(Enumeration):
	"""Character Pose Options flags."""
	kFBCharacterPoseGravity=2
	kFBCharacterPoseMatchFKTranslation=256
	kFBCharacterPoseMatchPivot=64
	kFBCharacterPoseMatchR=32
	kFBCharacterPoseMatchTX=4
	kFBCharacterPoseMatchTY=8
	kFBCharacterPoseMatchTZ=16
	kFBCharacterPoseMirror=1
	kFBCharacterPoseNoFlag=0
	kFBCharacterPoseUseKeyingGroup=128
class FBCharacterPoseKeyingMode(Enumeration):
	"""Character Pose Keying Mode."""
	kFBCharacterPoseKeyingModeBodyPart=1
	kFBCharacterPoseKeyingModeCount=2
	kFBCharacterPoseKeyingModeFullBody=0
	kFBCharacterPoseKeyingModeInvalid=-1
class FBCharacterResetProperties(Enumeration):
	"""Character Reset Properties Type."""
	kFBCharacterResetPropertiesAll=0
	kFBCharacterResetPropertiesDefinition=2
	kFBCharacterResetPropertiesSolving=1
class FBCharacterRollSolver(Enumeration):
	"""Character Roll Solver version."""
	kFBLastRollSolver=2
	kFBParamRollSolver70=0
	kFBParamRollSolver75=1
class FBClipEnd(Enumeration):
	"""Clip end actions."""
	kFBClipEndEnd=0
	"""On clip end stop clip."""
	kFBClipEndLoop=1
	"""On clip end loop clip."""
class FBClusterMode(Enumeration):
	"""Different clustering modes."""
	kFBClusterAdditive=1
	"""Add the values together."""
	kFBClusterNormalize=0
	"""Normalize (values between 0.0 and 1.0 )"""
	kFBClusterTotal100=2
	"""The balanced values will add up to 100 percent."""
class FBCommPortType(Enumeration):
	"""Communication port type."""
	kFBInternal=2
	"""Internal."""
	kFBPhysical=0
	"""Physical."""
	kFBVirtual=1
	"""Virtual."""
class FBCommType(Enumeration):
	"""Communications type.

	Different base types of communications. There is always the 'other' type in order to use another type of communication."""
	kFBCommTypeNetworkTCP=2
	"""Network (TCP) device."""
	kFBCommTypeNetworkUDP=4
	"""Network (UDP) device."""
	kFBCommTypeNone=0
	"""A non-communicating device."""
	kFBCommTypeOther=32
	"""Any other type of communications."""
	kFBCommTypeSerial=1
	"""Serial communications."""
	kFBCommTypeSharedMemory=8
	"""Accessing shared memory."""
	kFBCommTypeSimulator=16
	"""Software simulator."""
class FBCommandState(Enumeration):
	"""[FBCommandState](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_command_state.html "FBCommandState.")."""
	kFBCommandStateMute=1
	"""Mute."""
	kFBCommandStateMuteBecauseSolo=3
	"""Mute because of solo."""
	kFBCommandStateSolo=2
	"""Solo."""
	kFBCommandStateStandard=0
	"""Standard."""
class FBConnectionAction(Enumeration):
	"""Possible actions when a notify plug event occurs."""
	kFBBeginChange=18
	"""Begin change on destination."""
	kFBBeginReplaceDst=14
	"""Begin replace destination during merge."""
	kFBBeginReplaceSrc=12
	"""Begin replace source during merge."""
	kFBCandidate=22
	"""Data candidate event, before the data is set."""
	kFBCandidateGlobal=24
	"""Data candidate event, global candidate."""
	kFBCandidated=23
	"""Data candidate event, after the data is set."""
	kFBConnect=2
	kFBConnectDst=3
	"""Connect destination to source."""
	kFBConnectSrc=2
	"""Connect source to destination."""
	kFBConnected=4
	kFBConnectedDst=5
	"""Connected destination to source."""
	kFBConnectedOwner=20
	"""Connected owner to destination."""
	kFBConnectedSrc=4
	"""Connected source to destination."""
	kFBDescription=36
	"""Component description event."""
	kFBDestroy=26
	"""Component destroy."""
	kFBDetached=25
	"""Component detached from scene."""
	kFBDisconnect=8
	kFBDisconnectDst=9
	"""Disconnect destination from source."""
	kFBDisconnectOwner=21
	"""Disconnect owner from destination."""
	kFBDisconnectSrc=8
	"""Disconnect source from destination."""
	kFBDisconnected=10
	kFBDisconnectedDst=11
	"""Disconnected destination from source."""
	kFBDisconnectedSrc=10
	"""Disconnected source from destination."""
	kFBEndChange=19
	"""End change on destination."""
	kFBEndReplaceDst=15
	"""End replace destination during merge."""
	kFBEndReplaceSrc=13
	"""End replace source during merge."""
	kFBKeyingCandidate=39
	"""Component keying candidate event."""
	kFBKeyingCurveChange=40
	"""Component curve has changed."""
	kFBKeyingCurveEndChange=41
	"""Component curve changes in Dopesheet completed."""
	kFBKeyingDeleteKey=38
	"""Component keying delete event."""
	kFBKeyingKey=37
	"""Component keying add event."""
	kFBPrefixRename=34
	"""Component prefix is going to be renamed."""
	kFBPrefixRenamed=35
	"""Component prefix has been renamed."""
	kFBRename=31
	"""Component is going to be renamed."""
	kFBRenamed=32
	"""Component has been renamed."""
	kFBReorderSrc=16
	"""Reorder of source."""
	kFBReorderedSrc=17
	"""Source has been reordered."""
	kFBRequestConnectDst=1
	"""Request connection of destination to source."""
	kFBRequestConnectSrc=0
	"""Request connection of source to destination."""
	kFBRequestDisconnectDst=7
	"""Request disconnection of destination to source."""
	kFBRequestDisconnectSrc=6
	"""Request disconnection of source to destination."""
	kFBRequestPrefixRename=33
	"""Compoent request Prefix Rename."""
	kFBRequestRename=30
	"""Component request rename."""
	kFBReselect=29
	"""Component re-selection."""
	kFBSelect=27
	"""Component selection."""
	kFBUnselect=28
	"""Component de-selection."""
class FBConnectionType(Enumeration):
	"""Connection types available between plugs."""
	kFBConnectionTypeNone=0
	"""Default connection type."""
	kFBConnectionTypeSystem=1
	"""System connection type."""
class FBConsoleChannelType(Enumeration):
	"""Console channel types."""
	kFBConsoleButton=1
	"""Button."""
	kFBConsoleDisplay=6
	"""Display."""
	kFBConsoleEncoder=4
	"""Generic encoder."""
	kFBConsoleJoystick=7
	"""Joystick."""
	kFBConsoleKey=5
	"""Key."""
	kFBConsoleNull=0
	"""Generic type."""
	kFBConsoleSlider=2
	"""Slider."""
	kFBConsoleTransport=3
	"""Transport."""
class FBConstantKeyReducerThresholdType(Enumeration):
	"""Different threshold types for the Constant Key Reducer filter."""
	kFBDefaultThreshold=3
	"""All other curves threshold."""
	kFBRotationThreshold=1
	"""Rotation threshold."""
	kFBScalingThreshold=2
	"""Scaling threshold."""
	kFBTranslationThreshold=0
	"""Translation threshold."""
class FBConstructionHistoryState(Enumeration):
	"""Construction history manager state."""
	kFBConstructionHistory_Listening=0
	"""Construction history is currently listening and recording operations."""
	kFBConstructionHistory_Replaying=1
	"""Construction history is currently replaying an operation."""
class FBControlSetType(Enumeration):
	"""Character ControlSet type."""
	kFBControlSetTypeFKIK=1
	kFBControlSetTypeIKOnly=2
	kFBControlSetTypeNone=0
class FBControllerMode(Enumeration):
	"""Controller modes for optical model."""
	kFBControllerLabelling=1
	"""Labelling controller."""
	kFBControllerNone=0
	"""No controller mode."""
	kFBControllerRigidBody=3
	"""Rigid body controller."""
	kFBControllerSegment=2
	"""Segment controller."""
class FBDataAsStringFlag(Enumeration):
	"""[FBDataAsStringFlag](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_data_as_string_flag.html "FBDataAsStringFlag.")."""
	kFBDataAsStringPersistence=1
	"""Convert data to string type for storage."""
	kFBDataAsStringUI=0
	"""Convert data to string type for UI display."""
class FBDeckTransportMode(Enumeration):
	"""[FBDeckTransportMode](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_deck_transport_mode.html "FBDeckTransportMode.")."""
	kFBDeckTransportMain=2
	"""Transport main."""
	kFBDeckTransportMaster=2
	kFBDeckTransportNone=0
	"""No transport interaction."""
	kFBDeckTransportSlave=1
	kFBDeckTransportSync=1
	"""Sync to transport controls."""
class FBDeformerType(Enumeration):
	"""Determine the deformer type.

	kFBDeformerSkeleton Skeleton (Bone) driven skinning deformer.kFBDeformerPointCache Pre-recorded point cache deformer.kFBGeometryMapping_BY_POLYGON_VERTEX There will be one mapping coordinate for each vertex, for each polygon/strip it is part of. This means that a vertex will have as many mapping coordinates as polygons it is part of.kFBGeometryMapping_BY_POLYGON There can be only one mapping coordinate for the whole polygon/strip.kFBGeometryMapping_BY_EDGE There will be one mapping coordinate for each unique edge in the mesh. This is meant to be used with smoothing layer elements.kFBGeometryMapping_ALL_SAME There can be only one mapping coordinate for the whole surface."""
	kFBDeformerPointCache=2
	kFBDeformerSkeleton=1
	kFBDeformerUnkown=0
class FBDeviceKeyboardKey(Enumeration):
	"""Keyboard keys (for input)."""
	kFBDKey0=20
	"""'0'."""
	kFBDKey1=11
	"""'1'."""
	kFBDKey2=12
	"""'2'."""
	kFBDKey3=13
	"""'3'."""
	kFBDKey4=14
	"""'4'."""
	kFBDKey5=15
	"""'5'."""
	kFBDKey6=16
	"""'6'."""
	kFBDKey7=17
	"""'7'."""
	kFBDKey8=18
	"""'8'."""
	kFBDKey9=19
	"""'9'."""
	kFBDKeyArrowDown=7
	"""Down."""
	kFBDKeyArrowLeft=4
	"""Left."""
	kFBDKeyArrowRight=6
	"""Right."""
	kFBDKeyArrowUp=5
	"""Up."""
	kFBDKeyEnd=2
	"""End."""
	kFBDKeyEscape=9
	"""Escape."""
	kFBDKeyF1=21
	"""'F1'."""
	kFBDKeyF10=30
	"""'F10'."""
	kFBDKeyF11=31
	"""'F11'."""
	kFBDKeyF12=32
	"""'F12'."""
	kFBDKeyF2=22
	"""'F2'."""
	kFBDKeyF3=23
	"""'F3'."""
	kFBDKeyF4=24
	"""'F4'."""
	kFBDKeyF5=25
	"""'F5'"""
	kFBDKeyF6=26
	"""'F6'."""
	kFBDKeyF7=27
	"""'F7'."""
	kFBDKeyF8=28
	"""'F8'."""
	kFBDKeyF9=29
	"""'F9'."""
	kFBDKeyHome=3
	"""Home."""
	kFBDKeyPageDown=1
	"""Page Down."""
	kFBDKeyPageUp=0
	"""Page Up."""
	kFBDKeyReturn=8
	"""Return."""
	kFBDKeySpace=10
	"""Space bar."""
class FBDeviceSamplingMode(Enumeration):
	"""Recording types.

	The different values for this will control the way the keys are added when the device is being recorded. There are four different types of recording keys for devices:Hardware Timestamping. This case is when the hardware provides timestamps with each packet.Hardware Frequency. The hardware is guaranteed to provide packets at a given frequency.Auto Frequency Packets are coming in at a fixed, unknown frequency. The recorded data will be resampled to be equidistant.Software Timestamping. The application will provide a timestamp for each packet depending on when it receives the data."""
	kFBAutoFrequency=2
	"""Device is running at unknown, fixed frequency."""
	kFBHardwareFrequency=1
	"""Device is running at known, fixed frequency."""
	kFBHardwareTimestamp=0
	"""Device supplies timestamp."""
	kFBSoftwareTimestamp=3
	"""The software will timestamp packets as they arrive."""
class FBDisplayMode(Enumeration):
	"""Model display options."""
	kFBDisplayModeCount=5
	"""End of enum, this value indicates the number of display modes available."""
	kFBDisplayModeDefault=0
	"""Use default display mode."""
	kFBDisplayModeFlatShade=3
	"""Flat shading."""
	kFBDisplayModeHardShade=2
	"""Hard shading."""
	kFBDisplayModeTexture=1
	"""Textures are displayed."""
	kFBDisplayModeWireFrame=4
	"""Wire-frame rendering."""
class FBDisplayWhat(Enumeration):
	"""Model display mask This mask determines what types of models are displayed by the renderer."""
	kFBDisplay3dIcon=64
	"""3D icons are displayed (3D icons are 3D elements that do not exist in the scene)."""
	kFBDisplayAll=255
	"""Everything is displayed."""
	kFBDisplayCamera=32
	"""Cameras are displayed."""
	kFBDisplayCenter=8
	"""Centers are displayed."""
	kFBDisplayLight=16
	"""Lights are displayed."""
	kFBDisplayMarker=2
	"""Markers are displayed."""
	kFBDisplayNone=0
	"""Nothing is displayed."""
	kFBDisplayNull=1
	"""Null models are displayed."""
	kFBDisplaySkeleton=4
	"""Skeletons and bones are displayed."""
class FBDragAndDropState(Enumeration):
	"""State of Drag and Drop.

	[See samples: PropertyDrop.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_property_drop_8py-example.html) [Spread.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_spread_8py-example.html)"""
	kFBDragAndDropBegin=0
	"""Begin a drag and drop sequence."""
	kFBDragAndDropDrag=1
	"""Dragging."""
	kFBDragAndDropDrop=2
	"""Dropping."""
	kFBDragAndDropEnd=3
	"""End of drag and drop."""
	kFBDragOnEmpty=4
	"""Empty the drag and drop stack."""
	kFBDragOnEmptyDrop=5
	"""Dropping empty stack."""
class FBEffectorId(Enumeration):
	"""All effector nodes."""
	kFBChestEndEffectorId=10
	kFBChestOriginEffectorId=9
	kFBHeadEffectorId=15
	kFBHipsEffectorId=0
	kFBInvalidEffectorId=-1
	kFBLastEffectorId=44
	kFBLeftAnkleEffectorId=1
	kFBLeftElbowEffectorId=7
	kFBLeftFootEffectorId=11
	kFBLeftFootExtraFingerEffectorId=37
	kFBLeftFootIndexEffectorId=33
	kFBLeftFootMiddleEffectorId=34
	kFBLeftFootPinkyEffectorId=36
	kFBLeftFootRingEffectorId=35
	kFBLeftFootThumbEffectorId=32
	kFBLeftHandEffectorId=18
	kFBLeftHandExtraFingerEffectorId=25
	kFBLeftHandIndexEffectorId=21
	kFBLeftHandMiddleEffectorId=22
	kFBLeftHandPinkyEffectorId=24
	kFBLeftHandRingEffectorId=23
	kFBLeftHandThumbEffectorId=20
	kFBLeftHipEffectorId=16
	kFBLeftKneeEffectorId=5
	kFBLeftShoulderEffectorId=13
	kFBLeftWristEffectorId=3
	kFBRightAnkleEffectorId=2
	kFBRightElbowEffectorId=8
	kFBRightFootEffectorId=12
	kFBRightFootExtraFingerEffectorId=43
	kFBRightFootIndexEffectorId=39
	kFBRightFootMiddleEffectorId=40
	kFBRightFootPinkyEffectorId=42
	kFBRightFootRingEffectorId=41
	kFBRightFootThumbEffectorId=38
	kFBRightHandEffectorId=19
	kFBRightHandExtraFingerEffectorId=31
	kFBRightHandIndexEffectorId=27
	kFBRightHandMiddleEffectorId=28
	kFBRightHandPinkyEffectorId=30
	kFBRightHandRingEffectorId=29
	kFBRightHandThumbEffectorId=26
	kFBRightHipEffectorId=17
	kFBRightKneeEffectorId=6
	kFBRightShoulderEffectorId=14
	kFBRightWristEffectorId=4
class FBEffectorSetID(Enumeration):
	"""Effector ID identifier."""
	EFBffectorSetAux7=7
	FBEffectorSetAux1=1
	FBEffectorSetAux10=10
	FBEffectorSetAux11=11
	FBEffectorSetAux12=12
	FBEffectorSetAux13=13
	FBEffectorSetAux14=14
	FBEffectorSetAux2=2
	FBEffectorSetAux3=3
	FBEffectorSetAux4=4
	FBEffectorSetAux5=5
	FBEffectorSetAux6=6
	FBEffectorSetAux8=8
	FBEffectorSetAux9=9
	FBEffectorSetDefault=0
	FBLastEffectorSetIndex=15
class FBElementAction(Enumeration):
	"""[Enumeration](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_enumeration.html "Enumeration mapping.") that describe the different actions available on a scene element depending on the current context."""
	kFBElementActionAppend=1
	"""Append the elements to the current scene elements (when loading or merging)."""
	kFBElementActionDiscard=3
	"""Do not consider the element (when loading, merging and saving)."""
	kFBElementActionMerge=2
	"""Merge the elements from the file in the current scene (when merging)."""
	kFBElementActionSave=0
	"""Save the element (when saving)."""
class FBEventAnimationNodeType(Enumeration):
	"""Event based on animation node.

	Types of transformation."""
	kFBEventAnimationNodeConstraintChange=1
	kFBEventAnimationNodeDataChange=0
	kFBEventAnimationNodeNone=2
class FBEventName(Enumeration):
	"""These events are used internally by the Python Callback mecanism.

	These are not meant to be manipulated by a user."""
	kFBEventActivate=0
	kFBEventCellChange=35
	kFBEventChange=34
	kFBEventColumnClick=37
	kFBEventDoubleClick=9
	kFBEventDragAndDrop=2
	kFBEventEnter=26
	kFBEventExit=27
	kFBEventExpose=6
	kFBEventFileExit=48
	kFBEventFileMerge=49
	kFBEventFileNew=43
	kFBEventFileNewCompleted=42
	kFBEventFileOpen=45
	kFBEventFileOpenCompleted=44
	kFBEventFileSave=47
	kFBEventFileSaveCompleted=46
	kFBEventIdle=28
	kFBEventInput=3
	kFBEventMenu=4
	kFBEventOnClick=24
	kFBEventOnClickCheck=25
	kFBEventResize=7
	kFBEventRowClick=36
	kFBEventShow=1
	kFBEventTransaction=8
	kFBEventTreeCollapsed=41
	kFBEventTreeCollapsing=40
	kFBEventTreeExpanded=39
	kFBEventTreeExpanding=38
	kFBEventTreeSelect=5
	kFBEventUnbindSDK=54
class FBExistingClipAction(Enumeration):
	"""Action to perform, when preparing an Audio In object to record, when the action clip associated to the recording path is already in the scene."""
	kFBExistingClipAbortOperation=2
	"""Cancel preparing the audio in to record."""
	kFBExistingClipAskUser=0
	"""Ask the user for desired operation via a dialog."""
	kFBExistingClipRemove=1
	"""Remove the action clip from the scene."""
class FBExistingFileAction(Enumeration):
	"""Action to perform, when preparing an Audio In object to record, when the action clip associated to the recording path already exists on disk and is not empty."""
	kFBExistingFileAbortOperation=3
	"""Cancel preparing the audio in to record."""
	kFBExistingFileAppend=2
	"""Append the new recording to existing recording. Warning: Be sure that the current file format match your recording option!"""
	kFBExistingFileAskUser=0
	"""Ask the user for desired operation via a dialog."""
	kFBExistingFileOverwrite=1
	"""Overwrite the existing file on disk."""
class FBExtrapolationMode(Enumeration):
	"""Modes for pre / post extrapolation."""
	kFCurveExtrapolationConst=1
	kFCurveExtrapolationKeepSlope=4
	kFCurveExtrapolationMirrorRepetition=3
	kFCurveExtrapolationRelativeRepetition=5
	kFCurveExtrapolationRepetition=2
class FBFCurveEventType(Enumeration):
	"""This enum indicates what modification was made to a tracked FCurve."""
	kFBFCurveEventTypeDerivativedChanged=16
	"""A key left/right/both derivative was changed, please note that this event can affect the key specified in the event index and the following key."""
	kFBFCurveEventTypeKeyAdded=1
	"""A new key was added."""
	kFBFCurveEventTypeKeyBiasChanged=16384
	"""A key bias was changed (only valid on TCB key)"""
	kFBFCurveEventTypeKeyContinuityChanged=8192
	"""A key continuity was changed (only valid on TCB key)"""
	kFBFCurveEventTypeKeyInterpolationChanged=32
	"""A key interpolation mode was changed."""
	kFBFCurveEventTypeKeyMassOperation=131072
	"""An operation affecting multiple keys was made."""
	kFBFCurveEventTypeKeyPostExtrapolationChanged=65536
	"""A curve post-extrapolation value was changed."""
	kFBFCurveEventTypeKeyPreExtrapolationChanged=32768
	"""A curve pre-extrapolation value was changed."""
	kFBFCurveEventTypeKeyRemoved=2
	"""A key was removed."""
	kFBFCurveEventTypeKeyTangentBreakChanged=128
	"""A key break mode was changed."""
	kFBFCurveEventTypeKeyTangentChanged=64
	"""A key tangent was changed."""
	kFBFCurveEventTypeKeyTangentClampModeChanged=256
	"""A key clamping mode was changed."""
	kFBFCurveEventTypeKeyTangentConstantChanged=512
	"""A key constant mode was changed."""
	kFBFCurveEventTypeKeyTensionChanged=4096
	"""A key tension was changed (only valid on TCB key)"""
	kFBFCurveEventTypeKeyTimeChanged=4
	"""A key time was changed."""
	kFBFCurveEventTypeKeyValueChanged=8
	"""A key value was changed."""
	kFBFCurveEventTypeKeyVelocityChanged=1024
	"""A key velocity was changed."""
	kFBFCurveEventTypeKeyWeightChanged=2048
	"""A key left/right weight was changed, please note that this event can affect the key specified in the event index and the following key."""
	kFBFCurveEventTypeUnknownOperation=0
	"""Invalid event."""
class FBFileFormatAndVersion(Enumeration):
	kFBDefaultFormatAndVersion=8
	"""Default Format and Version."""
	kFBFBX2010=0
	"""It's FBX Version 6. Note: it's not equivalent to MotionBuilder 2010 Native FBX format."""
	kFBFBX2011=1
	"""FBX Version 2011."""
	kFBFBX2012=2
	"""FBX Version 2012."""
	kFBFBX2013=3
	"""FBX Version 2013."""
	kFBFBX2014_2015=4
	"""FBX Version 2014/2015."""
	kFBFBX2016=5
	"""FBX Version 2016."""
	kFBFBX2018=6
	"""FBX Version 2018."""
	kFBFBX2019=7
	"""FBX Version 2019."""
	kFBFBX2020=8
	"""FBX Version 2020."""
class FBFileMonitoringType(Enumeration):
	"""File Monitoring Type."""
	kFBFileMonitoring_ANIMATIONCLIP=2
	"""Animation clip change monitoring."""
	kFBFileMonitoring_FILEREFERENCE=3
	"""File Reference change monitoring."""
	kFBFileMonitoring_InvalidIndex=0
	"""Invalid value."""
	kFBFileMonitoring_MAINSCENE=1
	"""Main Scene change monitoring."""
	kFBFileMonitoring_PYTHONEDITORSCRIPT=4
	"""Python Editor Script change monitoring."""
class FBFilePopupStyle(Enumeration):
	"""Different types of file popup windows.

	[See samples: FBFilePopup.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_f_b_file_popup_8py-example.html) [FBFolderPopup.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_f_b_folder_popup_8py-example.html)"""
	kFBFilePopupOpen=0
	"""Open file popup (Shows 'Open Directory')."""
	kFBFilePopupSave=1
	"""Save file popup (Shows 'Save Directory')."""
class FBFilterType(Enumeration):
	"""Filter types.

	A filter can be of one or both types in order to process data on single or multiple curves of data. Ex: a gimble killer filter needs to be of type vector because the three curves are inter-dependant."""
	kFBFilterNumber=1
	"""Filter single FCurves."""
	kFBFilterVector=2
	"""Filter a vector (3 FCurves)."""
class FBFloorContactID(Enumeration):
	"""Floor contact for the given index."""
	FBLastCharacterMember=4
	FBLeftFootMemberIndex=2
	FBLeftHandMemberIndex=0
	FBRightFootMemberIndex=3
	FBRightHandMemberIndex=1
class FBFogMode(Enumeration):
	"""Fog falloff modes."""
	kFBFogModeExponential=1
	"""Exponential falloff."""
	kFBFogModeLinear=0
	"""Linear falloff."""
	kFBFogModeSquareExponential=2
	"""Squared exponential falloff."""
class FBGapMode(Enumeration):
	"""Gap interpolation modes."""
	kFBGapBezier=3
	"""Bezier interpolation."""
	kFBGapConstant=1
	"""Constant interpolation."""
	kFBGapCurve=4
	"""Cubic/curve interpolation."""
	kFBGapLinear=2
	"""Linear interpolation."""
	kFBGapRigidBody=0
	"""Use rigid body information."""
	kFBGapSample=5
	"""Sampled data."""
class FBGenerationMode(Enumeration):
	"""Generation modes for optical model."""
	kFBGenerationFast=1
	"""Fast re-generation."""
	kFBGenerationNone=0
	"""No re-generation."""
class FBGeometryArrayElementType(Enumeration):
	"""Type of data when requesting an array."""
	kFBGeometryArrayElementType_Float=2
	kFBGeometryArrayElementType_Float2=3
	kFBGeometryArrayElementType_Float3=4
	"""Each element is an array of 3 float."""
	kFBGeometryArrayElementType_Float4=5
	"""Each element is an array of 4 float."""
	kFBGeometryArrayElementType_FloatMatrix4x4=6
	kFBGeometryArrayElementType_Integer=1
	kFBGeometryArrayElementType_IntegerArrayPointer=7
	kFBGeometryArrayElementType_Unknown=0
class FBGeometryArrayID(Enumeration):
	"""ID to use when requesting a specific array of data for a model.

	[See sample: VertexArrayManipulation.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_geometry_0c_vertex_array_manipulation_8py-example.html)"""
	kFBGeometryArrayID_Binormal=8
	"""ID to the Binormal array."""
	kFBGeometryArrayID_Color=16
	"""ID to the Vertex Color Array."""
	kFBGeometryArrayID_Normal=2
	"""ID to the Normal by Point array."""
	kFBGeometryArrayID_Point=1
	"""ID to the Point array."""
	kFBGeometryArrayID_Tangent=4
	"""ID to the Tangent array."""
class FBGeometryMappingMode(Enumeration):
	"""Determine how the element is mapped on a surface.

	kFBGeometryMapping_NONE The mapping is undetermined.kFBGeometryMapping_BY_CONTROL_POINT There will be one mapping coordinate for each surface control point/vertex.kFBGeometryMapping_BY_POLYGON_VERTEX There will be one mapping coordinate for each vertex, for each polygon/strip it is part of. This means that a vertex will have as many mapping coordinates as polygons it is part of.kFBGeometryMapping_BY_POLYGON There can be only one mapping coordinate for the whole polygon/strip.kFBGeometryMapping_BY_EDGE There will be one mapping coordinate for each unique edge in the mesh. This is meant to be used with smoothing layer elements.kFBGeometryMapping_ALL_SAME There can be only one mapping coordinate for the whole surface."""
	kFBGeometryMapping_ALL_SAME=5
	kFBGeometryMapping_BY_CONTROL_POINT=1
	kFBGeometryMapping_BY_EDGE=4
	kFBGeometryMapping_BY_POLYGON=3
	kFBGeometryMapping_BY_POLYGON_VERTEX=2
	kFBGeometryMapping_NONE=0
class FBGeometryPrimitiveType(Enumeration):
	kFBGeometry_LINES=1
	kFBGeometry_LINE_LOOP=2
	kFBGeometry_LINE_STRIP=3
	kFBGeometry_POINTS=0
	kFBGeometry_POLYGON=9
	kFBGeometry_QUADS=7
	kFBGeometry_QUADS_STRIP=8
	kFBGeometry_TRIANGLES=4
	kFBGeometry_TRIANGLE_FAN=6
	kFBGeometry_TRIANGLE_STRIP=5
class FBGeometryReferenceMode(Enumeration):
	"""Determine how the mapping information is stored in the array of coordinate.

	kFBGeometryReference_DIRECT This indicates that the mapping information for the n'th element is found in the n'th place of DirectArray.kFBGeometryReference_INDEX, This indicates that the mapping information for the n'th element is found in the n'th place of IndexArray.kFBGeometryReference_INDEX_TO_DIRECT This indicates that the KLayerElementTemplate::mIndexArray contains, for the n'th element, an index in the KLayerElementTemplate::mDirectArray array of mapping elements. eINDEX_TO_DIRECT is usually useful to store coordinates for eBY_POLYGON_VERTEX mapping mode elements. Since the same coordinates are usually repeated a large number of times, it saves spaces to store the coordinate only one time and refer to them with an index. Materials and Textures are also referenced with this mode and the actual Material/Texture can be accessed via the KLayerElementTemplate::mDirectArray"""
	kFBGeometryReference_DIRECT=0
	kFBGeometryReference_INDEX=1
	kFBGeometryReference_INDEX_TO_DIRECT=2
class FBGlobalEvalCallbackTiming(Enumeration):
	"""Global Evaluation callback timing.

	Let the user to register callback function at different stage of background evaluation."""
	kFBGlobalEvalCallbackAfterDAG=1
	"""Invoked after all DAG (Transformation & Deformation) evaluation tasks finished in evaluation pipeline / thread."""
	kFBGlobalEvalCallbackAfterDeform=2
	"""Invoked after all deformation tasks finished in evaluation pipeline / thread."""
	kFBGlobalEvalCallbackAfterPlottingFrame=7
	"""Invoked after plotting a frame."""
	kFBGlobalEvalCallbackAfterRender=5
	"""Invoked in rendering pipeline, after any rendering tasks finish (just before swapping GL back/front buffer)."""
	kFBGlobalEvalCallbackBeforeDAG=0
	"""Invoked before any DAG (Transformation & Deformation) evaluation tasks started in evaluation pipeline / thread."""
	kFBGlobalEvalCallbackBeforePlottingFrame=6
	"""Invoked before plotting a frame."""
	kFBGlobalEvalCallbackBeforeRender=4
	"""Invoked in rendering pipeline, before any rendering tasks start (immediately after clearing GL back buffer)."""
	kFBGlobalEvalCallbackSyn=3
	"""Invoked when both evaluation & rendering pipelines / threads are stopped. Useful for some complicated scene change tasks to avoid race condition."""
class FBHUDElementHAlignment(Enumeration):
	kFBHUDCenter=2
	"""Center."""
	kFBHUDLeft=0
	"""Left alignment."""
	kFBHUDRight=1
	"""Right alignment."""
class FBHUDElementVAlignment(Enumeration):
	kFBHUDBottom=0
	"""Bottom alignment."""
	kFBHUDTop=1
	"""Top alignment."""
	kFBHUDVCenter=2
	"""Center."""
class FBIconPosition(Enumeration):
	"""Different icon positions possible."""
	kFBIconLeft=0
	"""Icon on left of text."""
	kFBIconTop=1
	"""Icon on top of text."""
class FBImageFormat(Enumeration):
	"""Image formats."""
	kFBImageFormatABGR32=5
	kFBImageFormatARGB32=6
	kFBImageFormatBGR16=4
	kFBImageFormatBGR24=3
	kFBImageFormatBGRA32=2
	kFBImageFormatRGB24=1
	kFBImageFormatRGBA32=0
	kFBImageFormatUnknown=7
class FBImageInterleaveType(Enumeration):
	"""Image field interleave types."""
	kFBImageInterleaveTypeAverage=3
	kFBImageInterleaveTypeEven=2
	kFBImageInterleaveTypeFullFrame=0
	kFBImageInterleaveTypeOdd=1
class FBImageInterpolationType(Enumeration):
	"""Image interpolation types."""
	kFBImageInterpolationTypeDuplicate=1
	kFBImageInterpolationTypeLinear=2
	kFBImageInterpolationTypeNone=0
class FBImageType(Enumeration):
	"""Image types."""
	kFBImageTypeField=1
	kFBImageTypeFrame=0
class FBInputKey(Enumeration):
	"""Keyboard inputs."""
	kFBKeyBackSpace=8
	"""Backspace."""
	kFBKeyDel=302
	"""Delete."""
	kFBKeyDown=296
	"""Down."""
	kFBKeyEnd=291
	"""End."""
	kFBKeyEscape=27
	"""Escape."""
	kFBKeyF1=368
	"""F1."""
	kFBKeyF10=377
	"""F10."""
	kFBKeyF11=378
	"""F11."""
	kFBKeyF12=379
	"""F12."""
	kFBKeyF2=369
	"""F2."""
	kFBKeyF3=370
	"""F3."""
	kFBKeyF4=371
	"""F4."""
	kFBKeyF5=372
	"""F5."""
	kFBKeyF6=373
	"""F6."""
	kFBKeyF7=374
	"""F7."""
	kFBKeyF8=375
	"""F8."""
	kFBKeyF9=376
	"""F9."""
	kFBKeyHome=292
	"""Home."""
	kFBKeyIns=301
	"""Insert."""
	kFBKeyLeft=293
	"""Left."""
	kFBKeyPageDown=290
	"""Page Down."""
	kFBKeyPageUp=289
	"""Page Up."""
	kFBKeyReturn=13
	"""Return."""
	kFBKeyRight=295
	"""Right."""
	kFBKeyTab=9
	"""Tab."""
	kFBKeyUp=294
	"""Up."""
class FBInputModifier(Enumeration):
	"""Input Modifiers (Ctrl, Alt, Shift)."""
	kFBKeyAlt=4
	"""Alt was pressed."""
	kFBKeyCtrl=2
	"""Control was pressed."""
	kFBKeyNone=0
	"""No modifier."""
	kFBKeyShift=1
	"""Shift was pressed."""
class FBInputType(Enumeration):
	"""Types of input events.

	[See sample: KeyboardMapper.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_complex_tools_0c_keyboard_mapper_8py-example.html)"""
	kFBButtonDoubleClick=5
	"""A mouse button was double clicked."""
	kFBButtonPress=2
	"""A mouse button was pressed."""
	kFBButtonRelease=3
	"""A mouse button was released."""
	kFBDragging=9
	"""The mouse is dragging items."""
	kFBDropping=10
	"""The mouse is dropping items."""
	kFBKeyPress=0
	"""A keyboard key was pressed."""
	kFBKeyPressRaw=11
	"""A keyboard key was pressed."""
	kFBKeyRelease=1
	"""A keyboard key was released."""
	kFBKeyReleaseRaw=12
	"""A keyboard key was released."""
	kFBMotionNotify=4
	"""The mouse has been moved."""
	kFBMouseEnter=6
	"""The mouse pointer is entering the window."""
	kFBMouseLeave=7
	"""The mouse pointer is leaving the window."""
	kFBMouseWheelNotify=8
	"""The mouse wheel has moved."""
	kFBUnknownInput=13
	"""The internal event could not be translated."""
class FBInsertSegmentMode(Enumeration):
	"""Insert segment modes."""
	kFBInsertSegmentFromStart=2
	"""Insert from start."""
	kFBInsertSegmentToEnd=1
	"""Insert to end."""
	kFBInsertSegmentWhole=0
	"""Insert whole."""
class FBInterpolation(Enumeration):
	"""Types of interpolation for an FCurve."""
	kFBInterpolationConstant=0
	"""Constant interpolation."""
	kFBInterpolationCubic=2
	"""Cubic interpolation."""
	kFBInterpolationCustom=3
	"""Custom interpolation."""
	kFBInterpolationLinear=1
	"""Linear interpolation."""
class FBInterpolatorCurveType(Enumeration):
	"""Types of interpolator for an FCurve."""
	kFBInterpolatorCurveFastIn=6
	kFBInterpolatorCurveFastOut=7
	kFBInterpolatorCurveLast=8
	kFBInterpolatorCurveLinearIn=0
	kFBInterpolatorCurveLinearOut=1
	kFBInterpolatorCurveSlowIn=4
	kFBInterpolatorCurveSlowOut=5
	kFBInterpolatorCurveSmoothIn=2
	kFBInterpolatorCurveSmoothOut=3
class FBKeyingGroupType(Enumeration):
	"""Keying group types."""
	kFBKeyingGroupGlobal=0
	"""All selected objects with the same properties as those defined in the keying group will be keyed."""
	kFBKeyingGroupLocal=2
	"""Only properties of objects specified in the keying group will be keyed."""
	kFBKeyingGroupObjectType=1
	"""All selected objects of the specified type in the keying group with the same properties as those defined in the keying group will be keyed."""
class FBLayerMode(Enumeration):
	"""Layer mode."""
	kFBLayerModeAdditive=0
	"""Layer value will be added to the other layers to computed the final value."""
	kFBLayerModeInvalidIndex=-1
	"""Invalid value."""
	kFBLayerModeOverride=1
	"""Layer value will override the value of the other precedent layers."""
	kFBLayerModeOverridePassthrough=2
	"""If the layer has a weight of 75%, the precedent layers will have a combined effect of 25% on the final value. Setting the weight to 100% is similar to setting the layer in override."""
class FBLayerRotationMode(Enumeration):
	"""Rotation mode for layer."""
	kFBLayerRotationModeEulerRotation=0
	"""The rotation will be computed component by component."""
	kFBLayerRotationModeInvalidIndex=-1
	"""Invalid value."""
	kFBLayerRotationModeQuaternionRotation=1
	"""The rotation will be computed using quaternion."""
class FBLightType(Enumeration):
	"""Light types."""
	kFBLightTypeArea=3
	"""Area light."""
	kFBLightTypeInfinite=1
	"""Infinite light (plane)."""
	kFBLightTypePoint=0
	"""Point light."""
	kFBLightTypeSpot=2
	"""Spot light."""
class FBListStyle(Enumeration):
	"""List style or direction.

	[See samples: List.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_list_8py-example.html) [ToolCommunicationReceiver.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_tool_communication_receiver_8py-example.html)"""
	kFBDropDownList=0
	"""Drop down list."""
	kFBVerticalList=1
	"""Vertical list."""
class FBManipulatorPickType(Enumeration):
	"""Types of manipulator picking."""
	FBPickObjects=0
	"""Pick objects."""
	FBPickPoints=1
	"""Pick points."""
	FBPickSurfaces=2
	"""Pick surfaces."""
class FBManipulatorTransformType(Enumeration):
	"""Manipulator transform stles."""
	kFBManipulatorTransformNone=0
	"""No manipulator."""
	kFBManipulatorTransformRotation=2
	"""Rotation manipulator."""
	kFBManipulatorTransformScaling=3
	"""Scaling manipulator."""
	kFBManipulatorTransformTranslation=1
	"""Translation manipulator."""
class FBMarkerLook(Enumeration):
	"""Look of the marker."""
	kFBMarkerLookAimRollGoal=13
	"""Aim & Roll goal."""
	kFBMarkerLookBone=7
	"""Bone."""
	kFBMarkerLookBox=9
	"""Box."""
	kFBMarkerLookCapsule=4
	"""Capsule."""
	kFBMarkerLookCircle=6
	"""Circle."""
	kFBMarkerLookCube=0
	"""Cube."""
	kFBMarkerLookHardCross=1
	"""Thick cross."""
	kFBMarkerLookLightCross=2
	"""Wireframe cross."""
	kFBMarkerLookNone=10
	"""None."""
	kFBMarkerLookRigidGoal=11
	"""Rigid goal."""
	kFBMarkerLookRotationGoal=12
	"""Rotation goal."""
	kFBMarkerLookSphere=3
	"""Sphere."""
	kFBMarkerLookSquare=5
	"""Square."""
	kFBMarkerLookStick=8
	"""Box with a sphere on one end."""
class FBMarkerResolutionLevel(Enumeration):
	"""Resolution of marker mesh sphere and capsule (Quality)."""
	kFBMarkerHighResolution=2
	"""Highest resolution."""
	kFBMarkerLowResolution=0
	"""Lowest resolution."""
	kFBMarkerMediumResolution=1
	"""Medium resolution."""
class FBMarkerType(Enumeration):
	"""Type of the marker."""
	kFBMarkerTypeFKEffector=2
	"""FK effector."""
	kFBMarkerTypeIKEffector=3
	"""IK effector."""
	kFBMarkerTypeOptical=1
	"""Optical."""
	kFBMarkerTypeStandard=0
	"""Standard."""
class FBMaterialTextureType(Enumeration):
	"""Various Material texture channels' type.

	[See samples: LayeredTexture.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_material_and_texture_0c_layered_texture_8py-example.html) [MaterialAndTexture.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_material_and_texture_0c_material_and_texture_8py-example.html) [TextureAnimation.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_material_and_texture_0c_texture_animation_8py-example.html) [VideoInput.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_video_0c_video_input_8py-example.html) [VideoMemory.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_video_0c_video_memory_8py-example.html)"""
	kFBMaterialTextureAmbient=2
	kFBMaterialTextureAmbientFactor=3
	kFBMaterialTextureBump=9
	kFBMaterialTextureDiffuse=4
	kFBMaterialTextureDiffuseFactor=5
	kFBMaterialTextureEmissive=0
	kFBMaterialTextureEmissiveFactor=1
	kFBMaterialTextureNormalMap=10
	kFBMaterialTextureReflection=13
	kFBMaterialTextureReflectionFactor=14
	kFBMaterialTextureShiness=8
	kFBMaterialTextureSpecular=6
	kFBMaterialTextureSpecularFactor=7
	kFBMaterialTextureTransparent=11
	kFBMaterialTextureTransparentFactor=12
class FBMenuItemType(Enumeration):
	"""Types of menu items available."""
	kFBMenuItemMotionExport=2
	"""Motion Files->Export."""
	kFBMenuItemMotionImport=0
	"""Motion Files->Import."""
	kFBMenuItemSceneExport=3
	"""Scenes->Export."""
	kFBMenuItemSceneImport=1
	"""Scenes->Import."""
class FBMergeLayerMode(Enumeration):
	"""Merge layer mode for animation layers.

	This will specify the mode of the resulting merged layer, if applicable (To BaseAnimation layer mode cannot be modified)."""
	kFBMergeLayerModeAdditive=1
	"""The resulting layer will be in additive mode, if possible."""
	kFBMergeLayerModeAutomatic=0
	"""The resulting layer will be in override mode if one of the source layer is in override, otherwise, it will be in additive mode."""
	kFBMergeLayerModeOverride=2
	"""The resulting layer will be in override mode, if possible."""
class FBMirrorPlaneType(Enumeration):
	"""Mirror Plane Type."""
	kFBMirrorPlaneTypeAuto=0
	kFBMirrorPlaneTypeCount=6
	kFBMirrorPlaneTypeEquation=5
	kFBMirrorPlaneTypeInvalid=-1
	kFBMirrorPlaneTypeUser=4
	kFBMirrorPlaneTypeXY=2
	kFBMirrorPlaneTypeXZ=3
	kFBMirrorPlaneTypeZY=1
class FBModelCullingMode(Enumeration):
	"""Model Culling Mode."""
	kFBCullingOff=0
	"""Culling Off."""
	kFBCullingOnCCW=1
	"""Culling with Counter Clock Wise."""
	kFBCullingOnCW=2
	"""Culling with Clock Wise."""
class FBModelEvaluationTaskType(Enumeration):
	kFBModelEvaluationBBox=1
	"""Model's bouding box computation task (approximately for deformable model)"""
	kFBModelEvaluationDeform=2
	"""Model's deformation task (for deformable model)"""
	kFBModelEvaluationTransform=0
	"""Model's transformation evaluation task (Global )"""
class FBModelHiercharyTraverserType(Enumeration):
	"""Types of hierarchy traverser search type."""
	kModelTraverserBreadthFirst=1
	"""Breadth-first search."""
	kModelTraverserDepthFirst=0
	"""Depth-first search."""
class FBModelRotationOrder(Enumeration):
	"""Ways to apply Rotation."""
	kFBEulerXYZ=0
	"""XYZ Euler Order."""
	kFBEulerXZY=1
	"""XZY Euler Order."""
	kFBEulerYXZ=3
	"""YXZ Euler Order."""
	kFBEulerYZX=2
	"""YZX Euler Order."""
	kFBEulerZXY=4
	"""ZXY Euler Order."""
	kFBEulerZYX=5
	"""ZYX Euler Order."""
	kFBSphericXYZ=6
	"""Spheric XYZ Order."""
class FBModelSelection(Enumeration):
	"""Different model selection available."""
	kFBAllModels=6
	"""Will imports motion into the hierarchies of all models in your scene. This is the only merge option when nothing is selected."""
	kFBCreateModels=1
	"""Will create the models in the motion file, used when there is no model to match in the scene."""
	kFBInHierarchy=5
	"""Will find the root node and will try to merge the data on the hierarchy, only useful if one model is selected."""
	kFBNone=0
	"""No selection mode specified."""
	kFBPrefixGroupContainingModel=4
	"""Will finds the top node with the same prefix and imports the motion as if you selected kFBInHierarchy. If the selected node has the prefix, this merge option is the same as selecting kFBSelectedModelAndChildren. If no nodes are found with the prefix, this merge option operates the same as kFBSelectedModels. Only available when one model is selected."""
	kFBSelectedModelAndChildren=3
	"""Will try to match the models from the file to those selected in the scene, as well as the children of the selected models."""
	kFBSelectedModels=2
	"""Will Merges data with only the selected nodes or models."""
class FBModelShadingMode(Enumeration):
	"""Modes for model shading.

	[See samples: FBModelCube.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_f_b_model_cube_8py-example.html) [GeometryInstancing.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_geometry_0c_geometry_instancing_8py-example.html) [VertexArrayManipulation.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_geometry_0c_vertex_array_manipulation_8py-example.html) [VertexColor.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_geometry_0c_vertex_color_8py-example.html)"""
	kFBModelShadingAll=6
	"""Lighted, shaded, textured shading."""
	kFBModelShadingDefault=0
	"""Default shading."""
	kFBModelShadingFlat=2
	"""Flat shading."""
	kFBModelShadingHard=4
	"""Hard shading."""
	kFBModelShadingLight=3
	"""Lighted shading."""
	kFBModelShadingTexture=5
	"""Textured shading."""
	kFBModelShadingWire=1
	"""Wireframe shading."""
class FBModelTemplateStyle(Enumeration):
	"""Model template styles When creating model templates, this parameter will affect the actual model created (associated with the model template)."""
	kFBModelTemplateCamera=6
	"""Camera."""
	kFBModelTemplateCameraInterest=8
	"""Camera interest."""
	kFBModelTemplateGeometry=7
	"""Generic geometry."""
	kFBModelTemplateLight=9
	"""Light."""
	kFBModelTemplateMarker=2
	"""Marker."""
	kFBModelTemplateNone=0
	"""No style."""
	kFBModelTemplateNull=1
	"""Null."""
	kFBModelTemplateOptical=10
	"""Optical model (not supported yet)."""
	kFBModelTemplateRoot=3
	"""Root (3 axes)."""
	kFBModelTemplateSensor=4
	"""Yellow magnetic sensor."""
	kFBModelTemplateSkeleton=5
	"""Skeleton limb."""
class FBModelTransformationType(Enumeration):
	"""Types of transformation vector/matrices possible.

	[See samples: FBModelCube.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_f_b_model_cube_8py-example.html) [GeometryInstancing.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_geometry_0c_geometry_instancing_8py-example.html) [VertexArrayManipulation.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_geometry_0c_vertex_array_manipulation_8py-example.html)"""
	kModelInverse_Rotation=6
	"""Inverse rotation."""
	kModelInverse_Scaling=8
	"""Inverse scaling."""
	kModelInverse_Transformation=5
	"""Inverse transformation."""
	kModelInverse_Transformation_Geometry=9
	"""Inverse of transformation plus geometry offset."""
	kModelInverse_Translation=7
	"""Inverse translation."""
	kModelRotation=1
	"""Rotation."""
	kModelScaling=3
	"""Scaling."""
	kModelTransformation=0
	"""Transformation."""
	kModelTransformation_Geometry=4
	"""Transformation plus geometry offset"""
	kModelTranslation=2
	"""Translation."""
class FBNamespaceAction(Enumeration):
	"""Namespace flags.

	[See samples: FBGetSelectedModels.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_f_b_get_selected_models_8py-example.html) [FBGroup.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_f_b_group_8py-example.html)"""
	kFBConcatNamespace=0
	"""Use to add a namespace name to object."""
	kFBRemoveAllNamespace=2
	"""Remove all the namespace name."""
	kFBReplaceNamespace=1
	"""Use to replace a define namespace."""
class FBNewKeyInterpolationType(Enumeration):
	"""Key Interpolation Type to use when creating new keys."""
	kFBNewKeyInterpolation_Auto=0
	"""Auto interpolation type."""
	kFBNewKeyInterpolation_Custom0=9
	"""Custom 0 interpolation type."""
	kFBNewKeyInterpolation_Custom1=10
	"""Custom 1 interpolation type."""
	kFBNewKeyInterpolation_Custom2=11
	"""Custom 2 interpolation type."""
	kFBNewKeyInterpolation_Fixed=8
	"""Fixed interpolation type."""
	kFBNewKeyInterpolation_Linear=3
	"""Linear interpolation type."""
	kFBNewKeyInterpolation_None=-1
	"""Invalid interpolation type, could be returned by the system if it is in an uninitialized state. Don't use this mode."""
	kFBNewKeyInterpolation_Smooth=6
	"""Smooth interpolation type."""
	kFBNewKeyInterpolation_SmoothClamp=7
	"""Smooth Clamp interpolation type."""
	kFBNewKeyInterpolation_Spline=1
	"""Spline interpolation type."""
	kFBNewKeyInterpolation_SplineClamp=2
	"""Spline Clamp interpolation type."""
	kFBNewKeyInterpolation_Step=4
	"""Step interpolation type."""
	kFBNewKeyInterpolation_TCB=5
	"""TCB interpolation type."""
class FBNurbType(Enumeration):
	"""Surface types."""
	kFBNurbTypeClosed=1
	"""Closed Type Nurb."""
	kFBNurbTypeOpen=2
	"""Open Type Nurb."""
	kFBNurbTypePeriodic=0
	"""Periodic Type Nurb."""
class FBObjectFlag(Enumeration):
	"""Available flags for any component."""
	kFBFlagAllocated=32768
	"""Object is allocated, so it must call 'delete this' on destroy."""
	kFBFlagBrowsable=512
	"""Visible in the Scene Navigator/Schematic View/Property View/Model View. If disabled, the object representation in the navigator will not be visible. In the Schematic View, system object are not shown and other objects will still be visible, but a red X will be drawn on them. It is not possible to select the object in the Schematic View. After disabling that flag of a selected object, it will still be selected to allow a script based on selection to work. It will then be possible for a user to deselect the object, but it will not be possible to select it."""
	kFBFlagClonable=16
	"""Can be cloned. If disabled, the "Duplicate" option will be removed in the contextual menu."""
	kFBFlagDeletable=2
	"""Can be deleted."""
	kFBFlagDetachable=2048
	"""Object can be "detached". Used by the apply manager contextual menu."""
	kFBFlagKeyable=16384
	"""Object can Key his property. (System Camera can't)"""
	kFBFlagMergeable=256
	"""Can be merged."""
	kFBFlagNamespaceEditable=8388608
	"""Allow editing on the namespace objects. If disabled, the "Add/Remove Namespace..." option is removed from the contextual menu."""
	kFBFlagNewable=64
	"""Deleted on File->New."""
	kFBFlagParentable=1024
	"""Object (model) can be "parented". Used by the apply manager contextual menu."""
	kFBFlagRenamable=128
	"""Can be renamed."""
	kFBFlagSavable=4
	"""Can be saved."""
	kFBFlagSelectable=1
	"""Can be selected. If disabled, representation of the object, like in the navigator, can still be selected and can still affect the original object."""
	kFBFlagStorable6=131072
	"""System/Obsolete."""
	kFBFlagStorableData6=262144
	"""System/Obsolete."""
	kFBFlagStory=65536
	"""Object created/used by the Story tool. Useful flag for filtering Story objects."""
	kFBFlagSystem=32
	"""Created from System (not from user)"""
	kFBFlagUndoable=4096
	"""Object can undo its actions and states, in a global Undo Stack."""
	kFBFlagUndoableSeparately=8192
	"""Object which has kFlagUndoableSeparately flag turned on will have a separate Undo Stack."""
	kFBFlagUniqueName=2097152
	"""< Used in FBX SDK native IO, force bindary format for the bindary data."""
	kFBFlagVisible=8
	"""Can be visible. If disabled, the object will still be available in the navigator, it is only hidden in the viewer."""
class FBObjectPoseMirrorOptionsFlag(Enumeration):
	"""ObjectPoseMirrorOptions flags."""
	kFBObjectPoseMirrorOptionsNoFlag=0
	kFBObjectPoseMirrorOptionsUpdateLocal=1
	kFBObjectPoseMirrorOptionsUpdateLocalMirrorParent=2
	kFBObjectPoseMirrorOptionsUpdateLocalRef=4
	kFBObjectPoseMirrorOptionsUpdateLocalRefMirrorRef=8
class FBObjectPoseOptionsFlag(Enumeration):
	"""ObjectPoseOptions flags."""
	kFBObjectPoseOptionsNoFlag=0
	kFBObjectPoseOptionsRotation=8
	kFBObjectPoseOptionsScaling=16
	kFBObjectPoseOptionsTranslationX=1
	kFBObjectPoseOptionsTranslationY=2
	kFBObjectPoseOptionsTranslationZ=4
class FBObjectStatus(Enumeration):
	"""Available lifetime status for any component."""
	kFBStatusClearing=32
	"""Object is in clearing operations (File new)."""
	kFBStatusCreating=1
	"""Object is in creation operations."""
	kFBStatusDestroying=16
	"""Object is in destruction operations."""
	kFBStatusMerging=8
	"""Object is in Merging operations."""
	kFBStatusRetrieving=4
	"""Object is in retrieving operations."""
	kFBStatusStoring=2
	"""Object is in storing operations."""
class FBOneClickApplication(Enumeration):
	"""Possible application for One-Click interop with MotionBuilder."""
	kFBOneClick3dsMax=2
	"""3ds Max."""
	kFBOneClickMaya=1
	"""Maya."""
	kFBOneClickNone=0
	"""No application."""
	kFBOneClickSoftimage=3
	"""Softimage."""
class FBOrientation(Enumeration):
	"""General directions for UI components.  DEPRICATED use ParallelEvaluation on [FBEvaluateManager](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_evaluate_manager.html) insteadAvailable DAG parallel schedule algorithm

	[See samples: Container.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_container_8py-example.html) [Slider.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_slider_8py-example.html)"""
	kFBHorizontal=0
	"""Horizontal."""
	kFBVertical=1
	"""Vertical"""
class FBParallelScheduleType(Enumeration):
	kFBParallelScheduleAdvanced=2
	"""Advanced parallel schedule, task dependency analyzation will be able to across ative constraint, and plus motion hierarchy."""
	kFBParallelScheduleSerial=0
	"""No parallel schedule, use sequential evaluation order instead."""
	kFBParallelScheduleSimple=1
	"""Simple parallel schedule, mainly analyze the task dependency based on Motion Hierarchy (scene graph), but don't across active constraint."""
class FBParity(Enumeration):
	"""Parity modes."""
	kFBParityEven=2
	"""Even parity."""
	kFBParityNone=0
	"""No parity."""
	kFBParityOdd=1
	"""Odd parity."""
class FBPickingMode(Enumeration):
	"""3D picking mode."""
	kFBPickingModeCount=3
	"""End of enum, this valued indicates the number of picking modes available."""
	kFBPickingModeModelsOnly=2
	"""Models-only mode (no nulls or skeletons are displayed)."""
	kFBPickingModeStandard=0
	"""Standard picking mode."""
	kFBPickingModeXRay=1
	"""X-Ray picking mode (obstructed models are displayed in overlay)."""
class FBPlayMode(Enumeration):
	"""Play modes."""
	kFBPlayModeLoop=3
	"""Loop clip."""
	kFBPlayModeNoPlay=0
	"""No play (most common)."""
	kFBPlayModePlay=2
	"""Play clip."""
	kFBPlayModePlayToEnd=4
	"""Play clip to end."""
	kFBPlayModePreviewToEnd=1
	"""Preview clip until end."""
class FBPlayerControlChangeType(Enumeration):
	"""Types of player control change events."""
	kFBPlayerControlGoto=6
	"""Goto."""
	kFBPlayerControlNone=0
	"""None."""
	kFBPlayerControlPlay=1
	"""Play."""
	kFBPlayerControlPlayReverse=2
	"""Play reverse."""
	kFBPlayerControlRecordModeOff=8
	"""Record mode off."""
	kFBPlayerControlRecordModeOn=7
	"""Record mode on."""
	kFBPlayerControlStepBackward=5
	"""Step backward."""
	kFBPlayerControlStepForward=4
	"""Step forward."""
	kFBPlayerControlStop=3
	"""Stop."""
class FBPlotAllowed(Enumeration):
	"""[FBPlotAllowed](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_plot_allowed.html "FBPlotAllowed")"""
	kFBPlotAllowed_Both=3
	kFBPlotAllowed_ControlRig=2
	kFBPlotAllowed_None=0
	kFBPlotAllowed_Skeleton=1
class FBPlotTangentMode(Enumeration):
	"""The tangent mode for plotted curve."""
	kFBPlotTangentModeAuto=4
	kFBPlotTangentModeSmooth=0
	kFBPlotTangentModeSmoothClamp=1
	kFBPlotTangentModeSpline=2
	kFBPlotTangentModeSplineClamp=3
class FBPlugModificationFlag(Enumeration):
	kFBAllConnectionModified=507904
	kFBAllCustomPropertyModified=1572864
	kFBAllDataModified=768
	kFBAllKeyingModified=3072
	kFBAllModifiedMask=2096896
	kFBAllStateModified=12288
	kFBContentAllModifiedMask=1321472
	kFBContentConnectionModified=262144
	"""Owner object/namespace has connection modified property/objects."""
	kFBContentCustomPropertyModified=1048576
	"""Owner object/Namespace has dirty property/objects."""
	kFBContentDataModified=512
	"""Owner object/Namespace has data dirty property/objects."""
	kFBContentKeyingModified=2048
	"""Owner object/Namespace has data dirty property/objects."""
	kFBContentStateModified=8192
	"""Owner object/Namespace has state dirty property/objects."""
	kFBPlugAllContent=0
	"""None Modified."""
	kFBSelfAllModifiedMask=775424
	kFBSelfConnectionDstObjectModified=65536
	"""The dst object of this plug has been modified."""
	kFBSelfConnectionDstPropertyModified=131072
	"""The dst property of this plug has been modified."""
	kFBSelfConnectionModifiedMask=245760
	kFBSelfConnectionSrcObjectModified=16384
	"""The src object of this plug has been modified."""
	kFBSelfConnectionSrcPropertyModified=32768
	"""The src property of this plug has been modified."""
	kFBSelfCustomPropertyModified=524288
	"""Object custom property change."""
	kFBSelfDataModified=256
	"""Object/Property itself has been dirty, in case of property get dirty, its owner object will be set dirty as well."""
	kFBSelfKeyingModified=1024
	"""Object/Property itself has been dirty, in case of property get dirty, its owner object will be set dirty as well."""
	kFBSelfStateModified=4096
	"""Object/Property naming change."""
class FBPlugStatusFlag(Enumeration):
	kFBOwnedByUndo=2097152
	"""Plug is owned by undo framework."""
	kFBPlugStatusFlagNone=0
	"""Plug has no status set."""
	kFBStatusMask=2097152
class FBPopupInputType(Enumeration):
	"""User input types for a popup.

	[See samples: RePrefixAllMarkers.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_re_prefix_all_markers_8py-example.html) [SelectModelsWithNameContainingSubstring.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_select_models_with_name_containing_substring_8py-example.html) [FBMessageBoxGetUserValue.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_f_b_message_box_get_user_value_8py-example.html)"""
	kFBPopupBool=0
	"""Boolean input."""
	kFBPopupChar=1
	"""Character input."""
	kFBPopupDouble=5
	"""Double input."""
	kFBPopupFloat=4
	"""Float input."""
	kFBPopupInt=3
	"""Integer input."""
	kFBPopupPassword=6
	"""Password input (String with '*'s)."""
	kFBPopupString=2
	"""String input."""
class FBPoseTransformType(Enumeration):
	"""Transform mode of pose."""
	kFBPoseTransformGlobal=1
	kFBPoseTransformInvalid=-1
	kFBPoseTransformLocal=0
	kFBPoseTransformLocalRef=2
	kFBPoseTransformTypeCount=3
class FBPoseType(Enumeration):
	"""Types of pose."""
	kFBBindPose=0
	"""Bind pose."""
	kFBRestPose=1
	"""Rest pose."""
class FBProfilingMode(Enumeration):
	"""Available Profiling modes."""
	kFBProfilingModeAllHi=6
	"""Collect profiling for all known tasks . For large scenes there should be an influence on performance."""
	kFBProfilingModeAllLow=5
	"""Collect profiling for all known tasks that doesn't increase remarkably with scene size. For large scenes this will not influence performance."""
	kFBProfilingModeDevices=3
	"""Collect profiling for device Input/Output and Device Evaluation."""
	kFBProfilingModeDisabled=0
	"""All profiling disabled, this include Viewer profiling. For the other modes, when EvaluationDepth is 0, only base information is profiled, such as FPS and evaluation rate."""
	kFBProfilingModeEvaluation=1
	"""Collect profiling for all known evaluation tasks (default mode)."""
	kFBProfilingModeRendering=2
	"""Collect profiling for all known rendering tasks."""
	kFBProfilingModeSDK=4
	"""Collect profiling for SDK."""
class FBPropertyComponents(Enumeration):
	"""Property Components Bit Field (XYZ, RGB, RGBA, UV, XYZW, etc.)."""
	kFBPropertyComponent0=1
	"""First component (e.g.: X, Red, etc.)."""
	kFBPropertyComponent1=2
	"""Second component (e.g.: Y, Green, etc.)."""
	kFBPropertyComponent2=4
	"""Third component (e.g.: Z, Blue, etc.)."""
	kFBPropertyComponent3=8
	"""Fourth component (e.g.: W, Alpha, etc.)."""
	kFBPropertyComponentAll=15
	"""All components."""
class FBPropertyFlag(Enumeration):
	"""Available flags for [FBProperty](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property.html "Generic application property.") objects. PropertyList: Actor.

	Property flags are not saved into FBX files.

	[See sample: PropertyDrop.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_property_drop_8py-example.html)

	These classes are under development and may change dramatically between versions."""
	kFBDrivenSetByMain=1024
	"""Driven property can be modified, valid only when the main property is modified."""
	kFBDynamicHidden=512
	"""This flag is used to show/hide the property in the propertiview. When turn on/ff DynamicHidden flag, this property will show/hide. The nodes hidden by this flag still exist in UI."""
	kFBLoadedUserProperty=2048
	"""This property is loaded from file."""
	kFBPropertyFlagAnimated=16
	kFBPropertyFlagDisableProperty=4
	kFBPropertyFlagDrivenProperty=8
	"""This is property is connected and driven by other same type of main property, and it always ask value from its main property."""
	kFBPropertyFlagForceStaticProperty=2
	kFBPropertyFlagHideProperty=1
	"""This flag is used to show/hide the property in the propertiview. However, when turn on/off HidePropertry flag, this property won't show/hide unless you reload the UI. The nodes hidden by this flag are removed from UI."""
	kFBPropertyFlagNotSavable=32
	"""Should not be saved to or loaded from an FBX file."""
	kFBPropertyFlagNotSet=0
	kFBPropertyFlagNotUserDeletable=128
	kFBPropertyFlagReadOnly=64
	kFBSlaveSetByMaster=1024
	kFBValueAllocated=256
	"""The value has been allocated and must be delete in destructor."""
class FBPropertyStateEventType(Enumeration):
	"""This enum indicates what modification was made to the animation of a tracked property. Property class: const char * (String)."""
	kFBPropertyStateEventTypeAttached=1
	"""Property connector was added (can happen when undoing a delete operation, which set back the property active in the scene)"""
	kFBPropertyStateEventTypeDestroyed=4
	"""Property connector was destroyed (property animation was deleted)"""
	kFBPropertyStateEventTypeDetached=2
	"""Property connector was detached (property animation was delete from the scene, but it still keep in case an undo operation is done)"""
	kFBPropertyStateEventTypeMassOperation=8
	"""Property was heavily modified (switching to story tool, story clip deleted...)"""
	kFBPropertyStateEventTypeUnknownOperation=0
	"""Invalid event."""
class FBPropertyType(Enumeration):
	"""Property types.

	[See sample: CustomProperty.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_custom_property_8py-example.html)"""
	kFBPT_Action=18
	"""action."""
	kFBPT_ColorRGB=16
	"""colorrgb."""
	kFBPT_ColorRGBA=17
	"""colorrgba."""
	kFBPT_Reference=19
	"""reference."""
	kFBPT_Time=9
	"""time."""
	kFBPT_TimeCode=10
	"""timecode."""
	kFBPT_TimeSpan=20
	"""timespan."""
	kFBPT_Vector2D=22
	"""vector2d."""
	kFBPT_Vector3D=15
	"""vector3d."""
	kFBPT_Vector4D=14
	"""vector4d."""
	kFBPT_bool=4
	"""bool."""
	kFBPT_charptr=7
	"""charptr."""
	kFBPT_double=6
	"""double."""
	kFBPT_enum=8
	"""enum."""
	kFBPT_event=12
	"""event."""
	kFBPT_float=5
	"""float."""
	kFBPT_int=1
	"""int."""
	kFBPT_kReference=21
	"""kReference."""
	kFBPT_object=11
	"""object."""
	kFBPT_stringlist=13
	"""stringlist."""
	kFBPT_unknown=0
	"""unknow."""
class FBPropertyViewType(Enumeration):
	"""Property view set type."""
	kFBViewByObject=2
	"""Object property view."""
	kFBViewByObjectType=1
	"""Class type property view."""
	kFBViewGlobal=0
	"""Global property view."""
class FBRSType(Enumeration):
	"""RS type for serial port."""
	kFBRS232=0
	"""RS-232 serial protocol."""
	kFBRS422=1
	"""RS-422 serial protocol."""
class FBRecalcMarkerSetOffset(Enumeration):
	"""Recalculate MarkerSet offset for?"""
	kFBRecalcMarkerSetOffsetROnly=1
	"""Recalculate MarkerSet offset for R Only."""
	kFBRecalcMarkerSetOffsetTR=0
	"""Recalculate MarkerSet offset for TR."""
class FBRenderingPass(Enumeration):
	"""Rendering Pass.

	Use with [FBShader::RenderingPass](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_shader.html#aaeb747d0fcc5d53368c2efb2285991aa "Read Write Property: Rendering pass object are shaded in.") properties to make the shader be called at any pass. Passes will be called in the order of the enum."""
	kFBPassAddColor=128
	"""Models are blended additively."""
	kFBPassFlat=2
	"""Lighting off."""
	kFBPassInvalid=0
	"""No pass selected."""
	kFBPassLighted=4
	"""Lighting on."""
	kFBPassMatte=8
	"""Alpha > 0.5 will show up."""
	kFBPassPostRender=512
	"""After everything."""
	kFBPassPreRender=1
	"""Before anything."""
	kFBPassTranslucent=64
	"""Models are blended."""
	kFBPassTranslucentZSort=256
	"""Models are sorted and blended."""
	kFBPassZTranslucent=16
	"""Writes to depth buffer."""
	kFBPassZTranslucentAlphaTest=32
	"""Writes to depth buffer where Alpha > 0.5."""
class FBRigidBodyMode(Enumeration):
	"""Rigid body modes."""
	kFBRigidBodyBest=1
	"""Best rigid body mode."""
	kFBRigidBodyFast=0
	"""Fast rigid body mode."""
class FBRootHMode(Enumeration):
	kFBRootHAbsoluteDifference=0
	kFBRootHRelativeDifference=1
class FBRootRMode(Enumeration):
	kFBRootRAbsoluteDifference=0
	kFBRootRRelativeDifference=1
class FBRootSpeedMode(Enumeration):
	kFBRootSpeedAbsoluteDifference=0
	kFBRootSpeedRelativeDifference=1
class FBRootXZMode(Enumeration):
	kFBRootXZAbsoluteDifference=0
	kFBRootXZRelativeDifference=1
class FBRotationFilter(Enumeration):
	"""Rotation filters."""
	kFBRotationFilterGimbleKiller=1
	kFBRotationFilterNone=0
	kFBRotationFilterUnroll=2
class FBRotationOrder(Enumeration):
	"""Specify the Euler rotation order."""
	kFBXYZ=0
	"""XYZ"""
	kFBXZY=1
	"""XZY."""
	kFBYXZ=2
	"""YXZ."""
	kFBYZX=3
	"""YZX"""
	kFBZXY=4
	"""ZXY"""
	kFBZYX=5
	"""ZYX."""
class FBSceneChangeType(Enumeration):
	"""Types of model selection events.

	[See sample: PropertyDrop.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_property_drop_8py-example.html)"""
	kFBSceneChangeActivate=19
	"""Activate."""
	kFBSceneChangeAddChild=4
	"""Child added."""
	kFBSceneChangeAttach=2
	"""Object attached."""
	kFBSceneChangeChangeName=30
	"""Object change name."""
	kFBSceneChangeChangedName=31
	"""Object changed name."""
	kFBSceneChangeChangedParent=35
	"""Object changed parent."""
	kFBSceneChangeClearBegin=23
	"""Begin clearing file (file new)"""
	kFBSceneChangeClearEnd=24
	"""End clearing file (file new)"""
	kFBSceneChangeDeactivate=20
	"""Deactivate."""
	kFBSceneChangeDestroy=1
	"""Object destroyed."""
	kFBSceneChangeDetach=3
	"""Object detached."""
	kFBSceneChangeFocus=34
	"""Object have focus."""
	kFBSceneChangeHardSelect=18
	"""Hard selection."""
	kFBSceneChangeLoadBegin=21
	"""Begin loading file."""
	kFBSceneChangeLoadEnd=22
	"""End loading file."""
	kFBSceneChangeMergeTransactionBegin=27
	"""Begin merge transaction."""
	kFBSceneChangeMergeTransactionEnd=28
	"""End merge transaction."""
	kFBSceneChangeNone=0
	"""Unknown event."""
	kFBSceneChangePreParent=32
	"""Before object parenting."""
	kFBSceneChangePreUnparent=33
	"""Before object unparenting."""
	kFBSceneChangeReSelect=29
	"""Re-selection."""
	kFBSceneChangeRemoveChild=5
	"""Child removed."""
	kFBSceneChangeRename=8
	"""Before object rename."""
	kFBSceneChangeRenamePrefix=9
	"""Before object rename prefix."""
	kFBSceneChangeRenameUnique=10
	"""Before object rename unique."""
	kFBSceneChangeRenameUniquePrefix=11
	"""Before object rename unique prefix."""
	kFBSceneChangeRenamed=12
	"""After object rename."""
	kFBSceneChangeRenamedPrefix=13
	"""After object rename prefix."""
	kFBSceneChangeRenamedUnique=14
	"""After object rename unique."""
	kFBSceneChangeRenamedUniquePrefix=15
	"""After object rename unique prefix."""
	kFBSceneChangeReorder=36
	"""Object reorder."""
	kFBSceneChangeReordered=37
	"""Object reordered."""
	kFBSceneChangeSelect=6
	"""Object selection."""
	kFBSceneChangeSoftSelect=16
	"""Soft selection."""
	kFBSceneChangeSoftUnselect=17
	"""Soft deselection."""
	kFBSceneChangeTransactionBegin=25
	"""Begin transaction."""
	kFBSceneChangeTransactionEnd=26
	"""End transaction."""
	kFBSceneChangeUnselect=7
	"""Object deselection."""
class FBSegmentMode(Enumeration):
	"""Segment modes."""
	kFBSegmentAll=2
	"""Use all."""
	kFBSegmentMarker=0
	"""Use marker."""
	kFBSegmentRigidBody=1
	"""Use rigid body."""
class FBShadowFrameType(Enumeration):
	"""Shadow calculation methods."""
	kFBShadowFrameTypeShadowCaster=1
	"""Bases the shadow calculation on the shadow of the caster."""
	kFBShadowFrameTypeShadowCubeMap=2
	"""Undocumented or unsupported."""
	kFBShadowFrameTypeShadowReceiver=0
	"""Bases the shadow calculation on the shadow of the receiver."""
class FBShadowType(Enumeration):
	"""Shadow types.

	The different types of shadow mapping."""
	kFBShadowTypeLightMapProjectiveTexture=2
	"""Uses a texture projection as a shadow."""
	kFBShadowTypeShadowOpaquePlanar=5
	"""Similar to the Planar Shadow, except that it treats all objects as opaque."""
	kFBShadowTypeShadowProjectiveTexture=1
	"""Uses a texture projection to create a shadow."""
	kFBShadowTypeShadowTranslucentPlanar=0
	"""Use this shadow type to create darkened shadow areas only on planar surfaces."""
	kFBShadowTypeZLightMapProjectiveTexture=4
	"""Similar to the Projective Light Map except that it uses a boolean algorithm to create a self-shadow."""
	kFBShadowTypeZShadowProjectiveTexture=3
	"""Similar to the Projective Shadow, except that it uses a boolean algorithm to create a self-shadow."""
class FBSkeletonLook(Enumeration):
	"""Look of the skeleton."""
	kFBSkeletonLookBone=0
	"""Bone."""
	kFBSkeletonLookBox=6
	"""Box."""
	kFBSkeletonLookCapsule=5
	"""Capsule."""
	kFBSkeletonLookCircle=7
	"""Circle."""
	kFBSkeletonLookCube=1
	"""Cube."""
	kFBSkeletonLookHardCross=2
	"""Thick cross."""
	kFBSkeletonLookLightCross=3
	"""Wireframe cross."""
	kFBSkeletonLookSphere=4
	"""Sphere."""
	kFBSkeletonLookSquare=8
	"""Square."""
	kFBSkeletonLookStick=9
	"""Box with a sphere on one end."""
class FBSkeletonNodeId(Enumeration):
	"""All Skeleton nodes"""
	kFBSkeletonChestIndex=10
	kFBSkeletonHeadIndex=20
	kFBSkeletonHipsIndex=0
	kFBSkeletonInvalidIndex=-1
	kFBSkeletonLastIndex=52
	kFBSkeletonLeftAnkleIndex=3
	kFBSkeletonLeftCollarIndex=11
	kFBSkeletonLeftElbowIndex=13
	kFBSkeletonLeftFootIndex=4
	kFBSkeletonLeftHipIndex=1
	kFBSkeletonLeftIndexAIndex=24
	kFBSkeletonLeftIndexBIndex=25
	kFBSkeletonLeftIndexCIndex=26
	kFBSkeletonLeftKneeIndex=2
	kFBSkeletonLeftMiddleAIndex=27
	kFBSkeletonLeftMiddleBIndex=28
	kFBSkeletonLeftMiddleCIndex=29
	kFBSkeletonLeftPinkyAIndex=33
	kFBSkeletonLeftPinkyBIndex=34
	kFBSkeletonLeftPinkyCIndex=35
	kFBSkeletonLeftRingAIndex=30
	kFBSkeletonLeftRingBIndex=31
	kFBSkeletonLeftRingCIndex=32
	kFBSkeletonLeftShoulderIndex=12
	kFBSkeletonLeftThumbAIndex=21
	kFBSkeletonLeftThumbBIndex=22
	kFBSkeletonLeftThumbCIndex=23
	kFBSkeletonLeftWristIndex=14
	kFBSkeletonNeckIndex=19
	kFBSkeletonReferenceIndex=51
	kFBSkeletonRightAnkleIndex=7
	kFBSkeletonRightCollarIndex=15
	kFBSkeletonRightElbowIndex=17
	kFBSkeletonRightFootIndex=8
	kFBSkeletonRightHipIndex=5
	kFBSkeletonRightIndexAIndex=39
	kFBSkeletonRightIndexBIndex=40
	kFBSkeletonRightIndexCIndex=41
	kFBSkeletonRightKneeIndex=6
	kFBSkeletonRightMiddleAIndex=42
	kFBSkeletonRightMiddleBIndex=43
	kFBSkeletonRightMiddleCIndex=44
	kFBSkeletonRightPinkyAIndex=48
	kFBSkeletonRightPinkyBIndex=49
	kFBSkeletonRightPinkyCIndex=50
	kFBSkeletonRightRingAIndex=45
	kFBSkeletonRightRingBIndex=46
	kFBSkeletonRightRingCIndex=47
	kFBSkeletonRightShoulderIndex=16
	kFBSkeletonRightThumbAIndex=36
	kFBSkeletonRightThumbBIndex=37
	kFBSkeletonRightThumbCIndex=38
	kFBSkeletonRightWristIndex=18
	kFBSkeletonWaistIndex=9
class FBSkeletonResolutionLevel(Enumeration):
	"""Resolution of skeleton sphere, capsule and stick (Quality)."""
	kFBSkeletonHighResolution=2
	"""Highest resolution."""
	kFBSkeletonLowResolution=0
	"""Lowest resolution."""
	kFBSkeletonMediumResolution=1
	"""Medium resolution."""
class FBSplitStyle(Enumeration):
	"""Type of split style (sub-division) for layout."""
	kFBHSplit=1
	"""Horizontal split."""
	kFBHVSplit=3
	"""Horizontal and Vertical split."""
	kFBNoSplit=0
	"""No split."""
	kFBVSplit=2
	"""Vertical split."""
class FBStereoDisplayMode(Enumeration):
	kFBStereoDisplayActive=3
	"""Display in active mode. User must enable OpenGL quad stereo buffer, and choose approriate stereo mode in video card hardware's config app."""
	kFBStereoDisplayAnaglyph=6
	"""Display in Analygh stereo mode."""
	kFBStereoDisplayAnaglyphLuminance=7
	"""Display in Luminance Analygh stereo mode."""
	kFBStereoDisplayCenterEye=0
	"""Display in Center Eye Camera, No Stereo effect."""
	kFBStereoDisplayCheckerboard=5
	"""Display in Checkboard Interlace stereo mode."""
	kFBStereoDisplayFreeviewCrossed=9
	"""Display in crossed free view stereo mode."""
	kFBStereoDisplayFreeviewParallel=8
	"""Display in parallel free view stereo mode."""
	kFBStereoDisplayHorizontalInterlace=4
	"""Display in Horizontal Interlace stereo mode."""
	kFBStereoDisplayLeftEye=1
	"""Display in Left Eye Caerma, No Stereo effect."""
	kFBStereoDisplayModeCount=10
	"""update this count value when add new mode"""
	kFBStereoDisplayRightEye=2
	"""Display in Right Eye Caerma, No Stereo effect."""
class FBStoryClipAlignmentType(Enumeration):
	"""Alignment Types when aligning clips."""
	kFBStoryClipAlignmentBeginningNext=3
	"""Align selected clips to the beginning of the next clip."""
	kFBStoryClipAlignmentBeginningNextAllAligned=4
	"""Align selected clips to the beginning of the next clip, all clips will be align to the selected clip position."""
	kFBStoryClipAlignmentBeginningNextWithOffset=7
	"""Align selected clips to the beginning of the next clip, while keeping the relative offset."""
	kFBStoryClipAlignmentCurrentTimeline=0
	"""Align all selected clips with the current time."""
	kFBStoryClipAlignmentCurrentTimelineWithOffset=5
	"""Align all selected clips with the current time, while keeping the relative offset."""
	kFBStoryClipAlignmentEndPrevious=1
	"""Align selected clips to the end of the previous clip."""
	kFBStoryClipAlignmentEndPreviousAllAligned=2
	"""Align selected clips to the end of the previous clip, all clips will be align to the selected clip position."""
	kFBStoryClipAlignmentEndPreviousWithOffset=6
	"""Align selected clips to the end of the previous clip, while keeping the relative offset."""
class FBStoryClipChangeType(Enumeration):
	"""Types of clip change events, matching KEventClip.eType Expose only kFBStoryClipMoveClip and kFBStoryClipRemoved for now."""
	kFBStoryClipMoveBlend=3
	"""Clip move blend."""
	kFBStoryClipMoveClip=1
	"""Clip moved."""
	kFBStoryClipMoveData=2
	"""Clip data moved."""
	kFBStoryClipNotSet=0
	"""Clip none."""
	kFBStoryClipRemoved=5
	"""Clip removed."""
	kFBStoryClipUpdateUI=4
	"""Clip UI update."""
class FBStoryClipCompMode(Enumeration):
	"""Compensation Modes for story character clips."""
	kFBStoryClipAuto=1
	"""Automatic compensation."""
	kFBStoryClipOff=0
	"""No compensation."""
	kFBStoryClipUser=2
	"""User defined compensation."""
class FBStoryClipGhostTimeMode(Enumeration):
	"""Time mode to display ghost."""
	kFBStoryClipGhostCurrent=0
	"""Show the ghost at current time of the clip."""
	kFBStoryClipGhostCustom=3
	"""Show the ghost at custom time of the clip. See GhostManipulatorCustomTime property."""
	kFBStoryClipGhostStart=1
	"""Show the ghost at start time of the clip."""
	kFBStoryClipGhostStop=2
	"""Show the ghost at stop time of the clip."""
class FBStoryClipMatchingRotationType(Enumeration):
	"""Matching Rotation Types, when matching clips to each other."""
	kFBStoryClipMatchingRotationDefault=3
	"""Uses the matching translation type stored in the Application configuration file: [Story] > MatchRotation. This value, in the configuration file, is update each time a matching is done, with the selected value."""
	kFBStoryClipMatchingRotationGravityXZ=2
	"""Rotates a selected clip's match object around the global Y axis."""
	kFBStoryClipMatchingRotationNone=0
	"""The clip's match object is not rotated to match another clip's animation."""
	kFBStoryClipMatchingRotationXYZ=1
	"""Rotates a selected clip's match object to the same orientation as the previous clip's match object."""
class FBStoryClipMatchingTimeType(Enumeration):
	"""Matching Time Types, when matching clips to each other."""
	kFBStoryClipMatchingTimeBetweenPreviousAndSelectedClip=2
	"""Matches the selected clip and the previous clip at the middle of the blend."""
	kFBStoryClipMatchingTimeBetweenSelectedAndNextClip=5
	"""Matches the selected clip and the next clip at the middle of the blend."""
	kFBStoryClipMatchingTimeCurrentTime=0
	"""Matches the start of the selected clip to the previous/next clip at the current time."""
	kFBStoryClipMatchingTimeDefault=7
	"""Uses the matching time type stored in the Application configuration file: [Story] > MatchWhen. This value, in the configuration file, is update each time a matching is done, with the selected value."""
	kFBStoryClipMatchingTimeEndOfPreviousClip=3
	"""Matches the end of the blend with the selected clip to the end of the previous clip."""
	kFBStoryClipMatchingTimeEndOfSelectedClip=6
	"""Matches the end of the selected clip to the end of the blend with the previous clip."""
	kFBStoryClipMatchingTimeStartOfNextClip=4
	"""Matches the start of the blend with the selected clip to the start of the next clip."""
	kFBStoryClipMatchingTimeStartOfSelectedClip=1
	"""Matches the start of the selected clip to the start of the blend with the previous clip."""
class FBStoryClipMatchingTranslationType(Enumeration):
	"""Matching Translation, Types when matching clips to each other."""
	kFBStoryClipMatchingTranslationDefault=3
	"""Uses the matching translation type stored in the Application configuration file: [Story] > MatchTranslation. This value, in the configuration file, is update each time a matching is done, with the selected value."""
	kFBStoryClipMatchingTranslationGravityXZ=2
	"""Translates a selected clip's match object along the global X and Z axes."""
	kFBStoryClipMatchingTranslationNone=0
	"""The clip's match object is not translated to match another clip's animation."""
	kFBStoryClipMatchingTranslationXYZ=1
	"""Translates a selected clip's match object to the same location as the previous clip's match object."""
class FBStoryClipMirrorPlane(Enumeration):
	"""Several mirror planes to mirror animation."""
	kFBStoryClipMirrorPlaneXY=0
	"""X-Y plane."""
	kFBStoryClipMirrorPlaneXZ=2
	"""X-Z plane."""
	kFBStoryClipMirrorPlaneZY=1
	"""Z-Y plane."""
class FBStoryClipNodeFunction(Enumeration):
	"""Node function."""
	kFBStoryClipNodeAverage=0
	"""Average."""
	kFBStoryClipNodeFloorProjection=1
	"""Project on XZ plane."""
	kFBStoryClipNodeNone=2
	"""None."""
class FBStoryClipShowGhostMode(Enumeration):
	"""Show Ghost Modes for story animation clips."""
	kFBStoryClipAlways=0
	"""Always show the ghost."""
	kFBStoryClipTimeCursor=1
	"""Show the ghost only on time cursor."""
	kFBStoryClipTimeCustom=2
	"""Show the ghost for custom time frame."""
class FBStoryClipSolveMode(Enumeration):
	"""Solve Modes for story character clips."""
	kFBStoryClipAnimFkIk=2
	"""Solve forward and inverse kinematic animation."""
	kFBStoryClipAnimSkeleton=1
	"""Solve skeleton animation."""
	kFBStoryClipAnimSkeletonIk=3
	"""Solve skeleton inverse kinematic animation."""
	kFBStoryClipRetargetSkeleton=0
	"""Solve retarget skeleton."""
class FBStoryClipTimeWarpInterpolatorType(Enumeration):
	"""Types of TimeWrap Interpolator for Story Clips."""
	kFBStoryClipTimeWarpInterpolatorCustom=0
	"""'Custom' TimeWarp Interpolation"""
	kFBStoryClipTimeWarpInterpolatorGoingFaster=3
	"""'Going Faster' TimeWarp Interpolation"""
	kFBStoryClipTimeWarpInterpolatorGoingFasterReversed=7
	"""'Reversed, Going Faster' TimeWarp Interpolation"""
	kFBStoryClipTimeWarpInterpolatorLinear=1
	"""'Normal' TimeWarp Interpolation"""
	kFBStoryClipTimeWarpInterpolatorLinearReversed=5
	"""'Reversed' TimeWarp Interpolation"""
	kFBStoryClipTimeWarpInterpolatorSlowingDown=4
	"""'Slowing Down' TimeWarp Interpolation"""
	kFBStoryClipTimeWarpInterpolatorSlowingDownReversed=8
	"""'Reversed, Slowing Down' TimeWarp Interpolation"""
	kFBStoryClipTimeWarpInterpolatorSmoothedEnds=2
	"""'Smoothed Ends' TimeWarp Interpolation"""
	kFBStoryClipTimeWarpInterpolatorSmoothedEndsReversed=6
	"""'Reversed, Smoothed Ends' TimeWarp Interpolation"""
class FBStoryGroupClipAlignmentType(Enumeration):
	"""Alignment Types when aligning groups."""
	kFBStoryGroupClipAlignmentBeginningNextWithOffset=2
	"""Align the clips contained in the group clip to the beginning of the next clip, while keeping the relative offset."""
	kFBStoryGroupClipAlignmentCurrentTimeline=0
	"""Align the clips contained in the group clip with the current time."""
	kFBStoryGroupClipAlignmentEndPreviousWithOffset=1
	"""Align the clips contained in the group clip to the end of the previous clip, while keeping the relative offset."""
class FBStoryTrackBodyPart(Enumeration):
	"""Body Parts for story track character."""
	kFBStoryTrackBodyPartAll=10239
	kFBStoryTrackBodyPartExtensions=4096
	kFBStoryTrackBodyPartHead=1
	kFBStoryTrackBodyPartLeftArm=14
	kFBStoryTrackBodyPartLeftFoot=128
	kFBStoryTrackBodyPartLeftHand=4
	kFBStoryTrackBodyPartLeftLeg=384
	kFBStoryTrackBodyPartLeftShoulder=2
	kFBStoryTrackBodyPartLowerBody=1920
	kFBStoryTrackBodyPartNone=0
	kFBStoryTrackBodyPartProps=2048
	kFBStoryTrackBodyPartRightArm=112
	kFBStoryTrackBodyPartRightFoot=512
	kFBStoryTrackBodyPartRightHand=32
	kFBStoryTrackBodyPartRightLeg=1536
	kFBStoryTrackBodyPartRightShoulder=16
	kFBStoryTrackBodyPartSpine=8192
	kFBStoryTrackBodyPartUpperBody=8319
class FBStoryTrackGhostShowMode(Enumeration):
	"""Ghost Show Modes for story animation tracks."""
	kFBStoryTrackShowAllClips=0
	"""Show the ghosts for all the clips on the track."""
	kFBStoryTrackShowCurrentTimeAdjacentClips=1
	"""Show the ghosts only for the previous clip, current clip, and next clip relative to current time."""
class FBStoryTrackRefMode(Enumeration):
	"""References Modes for story animation tracks."""
	kFBStoryTrackAdditive=1
	"""Additive track."""
	kFBStoryTrackOverride=0
	"""Override track."""
class FBStoryTrackType(Enumeration):
	"""Types for new story tracks.

	[See samples: CreateShotClip.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_create_shot_clip_8py-example.html) [AudioTrackSetupTool.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_complex_tools_0c_audio_track_setup_tool_8py-example.html)"""
	kFBStoryTrackAnimation=0
	"""Animation track."""
	kFBStoryTrackAudio=6
	"""Audio track."""
	kFBStoryTrackCamera=1
	"""Camera animation track."""
	kFBStoryTrackCharacter=2
	"""Character animation track."""
	kFBStoryTrackCommand=4
	"""Command track."""
	kFBStoryTrackConstraint=3
	"""Constraint track."""
	kFBStoryTrackShot=5
	"""Shot track."""
	kFBStoryTrackVideo=7
	"""Video track."""
class FBSurfaceMode(Enumeration):
	"""Surface modes."""
	kFBSurfaceModeHigh=4
	"""High quality."""
	kFBSurfaceModeHighNoNormals=3
	"""High quality, no normals."""
	kFBSurfaceModeLow=2
	"""Low quality."""
	kFBSurfaceModeLowNoNormals=1
	"""Low quality, no normals."""
	kFBSurfaceModeRaw=0
	"""Raw data."""
class FBSurfaceType(Enumeration):
	"""Surface types."""
	kFBSurfaceTypeBezier=0
	"""Bezier surface."""
	kFBSurfaceTypeBezierQuadric=1
	"""Bezier Quadric surface."""
	kFBSurfaceTypeBspline=3
	"""BSpline surface."""
	kFBSurfaceTypeCardinal=2
	"""Cardinal surface."""
	kFBSurfaceTypeLinear=4
	"""Linear surface."""
class FBSyncActivationAndVisibilityMode(Enumeration):
	"""Sync mode for Constraints' Activeness and Models' visibility belonging to the Character Extension."""
	kFBSyncMode_None=0
	kFBSyncMode_WithContolRig=1
	kFBSyncMode_WithOthersThanControlRig=2
class FBTCPIPSocketType(Enumeration):
	"""Types of TCP/IP Sockets."""
	kFBTCPIP_DGRAM=1
	"""Datagrams (UDP)."""
	kFBTCPIP_RAW=2
	"""Raw data (TCP)."""
	kFBTCPIP_Stream=0
	"""Streaming data (TCP)."""
class FBTakeChangeType(Enumeration):
	"""Types of take change events."""
	kFBTakeChangeAdded=0
	kFBTakeChangeClosed=3
	kFBTakeChangeMoved=6
	kFBTakeChangeNone=7
	kFBTakeChangeOpened=2
	kFBTakeChangeRemoved=1
	kFBTakeChangeRenamed=4
	kFBTakeChangeUpdated=5
class FBTakeSpanOnLoad(Enumeration):
	"""This enumeration indicate the how to set the take start and end points on after a load."""
	kFBFrameAnimation=2
	"""Have the take's span match the first and last key in the take."""
	kFBImportFromFile=1
	"""Set the current take's span according what is set in the loaded file."""
	kFBLeaveAsIs=0
	"""Use the current take's start and end point as defined before the load."""
class FBTangentClampMode(Enumeration):
	"""Different clamping modes for the tangents."""
	kFBTangentClampModeClamped=1
	"""The tangent will be flattened when the key is placed at the same value as an adjacent key."""
	kFBTangentClampModeNone=0
	"""The tangent will act normally."""
class FBTangentConstantMode(Enumeration):
	"""Different constant modes for the tangents."""
	kFBTangentConstantModeNext=1
	"""The tangent will contain the value of the next keyframe."""
	kFBTangentConstantModeNormal=0
	"""The tangent will contain the value of the current keyframe until the next keyframe."""
class FBTangentCustomIndex(Enumeration):
	"""Custom tangent index for the tangents."""
	kFBTangentCustomIndex0=0
	"""First custom tangent type registered in the system."""
	kFBTangentCustomIndex1=1
	"""Second custom tangent type registered in the system."""
	kFBTangentCustomIndex2=2
	"""Third custom tangent type registered in the system."""
class FBTangentMode(Enumeration):
	"""Methods of tangent calculation.

	This is only relevant when interpolation is CUBIC."""
	kFBTangentModeAuto=0
	"""This is the equivalent to a cardinal spline with no parametrization. In the UI, it is identified as Smooth."""
	kFBTangentModeBreak=3
	"""Like USER but left slope may differ from right."""
	kFBTangentModeClampProgressive=5
	"""Time independent, will flatten the tangent handles when the key value goes over or under the previous and next key values. In the UI, it is identified as Auto."""
	kFBTangentModeTCB=1
	"""TCB spline (3 parameters: TENSION, CONTINUITY, BIAS)"""
	kFBTangentModeTimeIndependent=4
	"""Time independent, is calculated based upon the slope between the previous and next key values. In the UI, it is identified as Spline."""
	kFBTangentModeUser=2
	"""Used to represent all splines with no lost data (HERMITE, BEZIER, CATMUL, etc.)"""
class FBTangentWeightMode(Enumeration):
	"""Active tangent weight, no/one/both side are active on a key.

	Please note, the left value is for the next key, as the current key contains the tangent weight information for the next key. To disable the weight on the left side of a key at index "i", you need to disable "kFBTangentWeightModeNextLeft" the "i-1" key."""
	kFBTangentWeightModeBoth=3
	"""Right tangent and next key left tangent weight are active."""
	kFBTangentWeightModeNextLeft=2
	"""Next key left tangent weight active."""
	kFBTangentWeightModeNone=0
	"""Tangent weight disabled."""
	kFBTangentWeightModeRight=1
	"""Right tangent weight active."""
class FBTextJustify(Enumeration):
	"""Text justification styles.

	[See samples: Button.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_button_8py-example.html) [Label.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_label_8py-example.html)"""
	kFBTextJustifyCenter=2
	"""Center alignment."""
	kFBTextJustifyLeft=0
	"""Left justify."""
	kFBTextJustifyRight=1
	"""Right justify."""
class FBTextStyle(Enumeration):
	"""Text appearance styles.

	[See sample: Label.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_label_8py-example.html)"""
	kFBTextStyleBold=1
	"""Bold."""
	kFBTextStyleItalic=2
	"""Italic."""
	kFBTextStyleNone=0
	"""Normal."""
	kFBTextStyleUnderlined=4
	"""Underlined."""
class FBTextureBlendMode(Enumeration):
	"""Texture blend modes.

	How the texture is blended with another.

	[See samples: LayeredTexture.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_material_and_texture_0c_layered_texture_8py-example.html) [TextureAnimation.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_material_and_texture_0c_texture_animation_8py-example.html)"""
	kFBTextureBlendAdditive=1
	"""Layer addition."""
	kFBTextureBlendModulate=2
	"""Layer multiplication."""
	kFBTextureBlendModulate2=3
	"""Layer multiplication + brightness."""
	kFBTextureBlendTranslucent=0
	"""Layer transparency."""
class FBTextureMapping(Enumeration):
	"""Texture mapping modes.

	How the texture is mapped."""
	kFBTextureMappingCylindrical=6
	"""Cylindrical mapping."""
	kFBTextureMappingEnvironment=7
	"""Environment mapping."""
	kFBTextureMappingProjection=8
	"""Projection mapping."""
	kFBTextureMappingSpherical=5
	"""Spherical mapping."""
	kFBTextureMappingUV=1
	"""UV mapping."""
	kFBTextureMappingXY=2
	"""XY mapping."""
	kFBTextureMappingXZ=4
	"""XZ mapping."""
	kFBTextureMappingYZ=3
	"""YZ mapping."""
	kFBTextureNoMapping=0
	"""No mapping."""
class FBTextureUseType(Enumeration):
	"""Texture Use Type.

	How the texture is used."""
	kFBTextureUseAll=0
	"""All textures."""
	kFBTextureUseBumpNormalMap=6
	"""Bump Normal Map, work with model."""
	kFBTextureUseColor=1
	"""standard color type, work with material."""
	kFBTextureUseLightMap=3
	"""Light Map, work with model."""
	kFBTextureUseShadowMap=2
	"""Shadow Map, work with model."""
	kFBTextureUseSphereReflexionMap=5
	"""Sphere Reflexion Map, work with model."""
	kFBTextureUseSphericalReflexionMap=4
	"""Spherical Reflexion Map, work with model."""
class FBTimeMarkAction(Enumeration):
	"""Time (Global & Take) Mark assigned action."""
	kFBTimeMarkAction_Loop=2
	"""When reaching the mark, the playback loops to previous global mark (or start frame if any)."""
	kFBTimeMarkAction_None=0
	"""No action. The mark is just visual hint."""
	kFBTimeMarkAction_Stop=1
	"""When reaching the mark, the playback stops."""
class FBTimeMode(Enumeration):
	"""Different time modes available."""
	kFBTimeMode1000Frames=1
	"""1000 : 1 millisecond"""
	kFBTimeMode100Frames=4
	"""100"""
	kFBTimeMode11988Frames=3
	"""~119.88"""
	kFBTimeMode120Frames=2
	"""120"""
	kFBTimeMode23976Frames=16
	"""~23.976"""
	kFBTimeMode24Frames=15
	"""24"""
	kFBTimeMode25Frames=14
	"""25"""
	kFBTimeMode2997Frames=13
	"""~29.97 full"""
	kFBTimeMode2997Frames_Drop=12
	"""~29.97 drop"""
	kFBTimeMode30Frames=11
	"""30"""
	kFBTimeMode48Frames=10
	"""48"""
	kFBTimeMode50Frames=9
	"""50"""
	kFBTimeMode5994Frames=8
	"""~59.94"""
	kFBTimeMode60Frames=7
	"""60"""
	kFBTimeMode72Frames=6
	"""72"""
	kFBTimeMode96Frames=5
	"""96"""
	kFBTimeModeCustom=17
	"""Custom framerate."""
	kFBTimeModeDefault=0
	"""Default Time Mode."""
class FBTimeReferential(Enumeration):
	"""[FBCommandState](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_command_state.html "FBCommandState.")."""
	kFBTimeReferentialAction=0
	"""Action."""
	kFBTimeReferentialEdit=2
	"""Edit."""
	kFBTimeReferentialShot=1
	"""Shot."""
class FBToolPossibleDockPosition(Enumeration):
	kFBToolPossibleDockPosBottom=8
	kFBToolPossibleDockPosLeft=2
	kFBToolPossibleDockPosNone=0
	kFBToolPossibleDockPosRight=4
	kFBToolPossibleDockPosTop=1
class FBTransportLoopMode(Enumeration):
	"""Available loop modes for the transport control."""
	kFBTransportLoopCurrentTake=1
	"""Playback looping the current take."""
	kFBTransportLoopThroughAllTakes=2
	"""Playback from the current take through all takes in order then stops."""
	kFBTransportNoLoop=0
	"""Playback not looping."""
class FBTransportMode(Enumeration):
	"""Transport modes."""
	kFBTransportGoto=15
	kFBTransportGotoPrepare=16
	"""!< Goto."""
	kFBTransportGotoReady=17
	kFBTransportJog=12
	kFBTransportJogPrepare=13
	"""!< Jog."""
	kFBTransportJogReady=14
	kFBTransportPlay=0
	kFBTransportPlayPrepare=1
	"""!< Play mode"""
	kFBTransportPlayReady=2
	kFBTransportPlayReverse=9
	kFBTransportPlayReversePrepare=10
	"""!< Play reverse."""
	kFBTransportPlayReverseReady=11
	kFBTransportShuttle=6
	kFBTransportShuttlePrepare=7
	"""!< Shuttle mode"""
	kFBTransportShuttleReady=8
	kFBTransportStepBackward=21
	kFBTransportStepBackwardPrepare=22
	"""!< Step backward."""
	kFBTransportStepBackwardReady=23
	kFBTransportStepForward=18
	kFBTransportStepForwardPrepare=19
	"""!< Step forward"""
	kFBTransportStepForwardReady=20
	kFBTransportStop=3
	kFBTransportStopPost=4
	"""!< Stop mode"""
	kFBTransportStopReady=5
class FBTransportPlaySpeed(Enumeration):
	"""Available transport control play speed."""
	kFBSpeed_10x=11
	"""10x"""
	kFBSpeed_1_10x=0
	"""0.10x"""
	kFBSpeed_1_2x=4
	"""0.50x"""
	kFBSpeed_1_3x=3
	"""0.33x"""
	kFBSpeed_1_4x=2
	"""0.25x"""
	kFBSpeed_1_5x=1
	"""0.20x"""
	kFBSpeed_1x=5
	"""1x"""
	kFBSpeed_2x=7
	"""2x"""
	kFBSpeed_3x=8
	"""3x"""
	kFBSpeed_4x=9
	"""4x"""
	kFBSpeed_5x=10
	"""5x"""
	kFBSpeed_ALL_FR=6
	"""All frames."""
	kFBSpeed_Custom=12
	"""Custom speed."""
class FBTransportSnapMode(Enumeration):
	"""Available snap methods for the transport control."""
	kFBTransportSnapModeNoSnap=0
	"""No snapping is applied."""
	kFBTransportSnapModePlayOnFrames=2
	"""When playing, plays to exact frames."""
	kFBTransportSnapModeSnapAndPlayOnFrames=3
	"""Combines both Snap and Play on frames modes."""
	kFBTransportSnapModeSnapOnFrames=1
	"""Snaps to an exact frame when modifying the current time."""
class FBTransportTimeFormat(Enumeration):
	"""Available transport control time display."""
	kFBTimeFormatFrame=1
	"""Frame time display mode."""
	kFBTimeFormatTimecode=0
	"""Timecode time display mode."""
class FBTriggerStyle(Enumeration):
	"""Audio clips' trigger styles."""
	kFBTriggerStyleContinue=0
	"""Previously triggered clips that are still playing won't be stopped and mixing will occur."""
	kFBTriggerStyleCut=1
	"""Previously triggered clips that are still playing will be stopped."""
	kFBTriggerStyleToggle=2
	"""If a previously triggered clip is playing, it will only be stopped, otherwise a new starts playing. No mixing and no loop."""
class FBUpAxis(Enumeration):
	"""This enumeration indicates which up axis is used in the motion file (so far, only effective when loading c3d files)."""
	kFBUpAxisY=0
	"""Use the Y-axis as the up axis."""
	kFBUpAxisZ=1
	"""Use the Z-axis as the up axis."""
class FBUseChnMode(Enumeration):
	"""Use Channel modes."""
	kFBUseChannelBoth=2
	"""Default mode, where each channel play in its respective speaker."""
	kFBUseChannelLeftOnly=0
	"""Left channel will be played in both speakers."""
	kFBUseChannelRightOnly=1
	"""Right channel will be played in both speakers."""
class FBVideoCodecMode(Enumeration):
	"""Enum [FBVideoRenderDepth](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_video_render_depth.html "Enum FBVideoRenderDepth.").

	[See sample: render.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_rendering_0crender_8py-example.html)"""
	FBVideoCodecAsk=0
	"""Pop codec selection dialog each render."""
	FBVideoCodecStored=2
	"""Pop dialog and stored its value"""
	FBVideoCodecUncompressed=1
	"""Assume uncompressed codec."""
class FBVideoFormat(Enumeration):
	"""Video color modes."""
	kFBVideoFormat_422=9
	kFBVideoFormat_ABGR_32=7
	kFBVideoFormat_ARGB_32=8
	kFBVideoFormat_Any=0
	kFBVideoFormat_BGRA_32=4
	kFBVideoFormat_BGR_16=6
	kFBVideoFormat_BGR_24=5
	kFBVideoFormat_Other=1
	kFBVideoFormat_RGBA_32=2
	kFBVideoFormat_RGB_24=3
class FBVideoInterlaceMode(Enumeration):
	"""Video interlace modes."""
	kFBVideoInterlaceFullFrameEven=3
	"""Full frame (even field)."""
	kFBVideoInterlaceFullFrameOdd=4
	"""Full frame (odd field)."""
	kFBVideoInterlaceHalfFrameEven=1
	"""Half frame (even field)."""
	kFBVideoInterlaceHalfFrameOdd=2
	"""Half frame (odd field)."""
	kFBVideoInterlaceNone=0
	"""No interacling."""
class FBVideoLiveType(Enumeration):
	"""Video Live type."""
	kFBVideoLiveBasic=1
	"""Basic video input, like webcam and dv camera."""
	kFBVideoLiveDefault=0
	"""Generic video input, type not specified."""
class FBVideoProxyMode(Enumeration):
	"""Video proxy modes."""
	kFBVideoProxyAlways=2
	"""Always video proxy."""
	kFBVideoProxyNone=0
	"""No video proxy."""
	kFBVideoProxyOnPlay=1
	"""Video proxy on play."""
class FBVideoRenderDepth(Enumeration):
	"""Enum [FBVideoRenderDepth](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_video_render_depth.html "Enum FBVideoRenderDepth.").

	[See samples: render.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_rendering_0crender_8py-example.html) [render.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_rendering_0crender_8py-example.html)"""
	FBVideoRender24Bits=0
	"""24 bits"""
	FBVideoRender32Bits=1
	"""32 bits"""
	FBVideoRenderDepthCount=2
	"""Depth Count."""
class FBVideoRenderFieldMode(Enumeration):
	"""Enum [FBVideoRenderFieldMode](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_video_render_field_mode.html "Enum FBVideoRenderFieldMode.")."""
	FBFieldModeCount=5
	"""Count."""
	FBFieldModeField0=1
	"""Field 0."""
	FBFieldModeField1=2
	"""Field 1."""
	FBFieldModeHalfField0=3
	"""Half Field 0."""
	FBFieldModeHalfField1=4
	"""Half Field 1."""
	FBFieldModeNoField=0
	"""No Field."""
class FBVideoRenderViewingMode(Enumeration):
	"""Enum [FBVideoRenderViewingMode](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_video_render_viewing_mode.html "Enum FBVideoRenderViewingMode.")."""
	FBViewingModeCount=4
	"""Count."""
	FBViewingModeCurrent=3
	"""Current."""
	FBViewingModeModelsOnly=1
	"""Model Only."""
	FBViewingModeStandard=0
	"""Standard."""
	FBViewingModeXRay=2
	"""X-Ray."""
class FBVideoResolution(Enumeration):
	"""Video Resolution (1D)"""
	kFBVideo_RES_1=1
	kFBVideo_RES_128=8
	kFBVideo_RES_16=5
	kFBVideo_RES_1K=11
	kFBVideo_RES_2=2
	kFBVideo_RES_256=9
	kFBVideo_RES_2K=12
	kFBVideo_RES_32=6
	kFBVideo_RES_4=3
	kFBVideo_RES_4K=13
	kFBVideo_RES_512=10
	kFBVideo_RES_64=7
	kFBVideo_RES_8=4
	kFBVideo_RES_8K=14
	kFBVideo_RES_FULL=0
class FBVideoStorageMode(Enumeration):
	"""Video storage modes."""
	kFBVideoStorageDisk=0
	"""Storage on disk."""
	kFBVideoStorageDiskAsync=2
	"""Storage on disk async access."""
	kFBVideoStorageMemory=1
	"""Storage in memory."""
class FBViewerMode(Enumeration):
	"""Different viewer modes for the 3D viewer."""
	kFBViewerModeFourWindow=3
	"""View four panes."""
	kFBViewerModeOneWindow=0
	"""View one pane."""
	kFBViewerModeSchematic=4
	"""Schematic view."""
	kFBViewerModeThreeWindow=2
	"""View three panes."""
	kFBViewerModeTwoWindow=1
	"""View two panes."""
class FBVisibilityState(Enumeration):
	"""Visibility state."""
	kFBVisibilityAll=1
	"""All objects requested are visible."""
	kFBVisibilityAny=0
	"""Any object requested is visible."""
	kFBVisibilityInvalid=3
	"""Invalid visibility request."""
	kFBVisibilitySome=2
	"""Some objects (at least one, but not all) requested are visible."""
class kDeviceIOs(Enumeration):
	kIOPlayModeRead=1
	kIOPlayModeWrite=3
	kIOStopModeRead=0
	kIOStopModeWrite=2
class kDeviceOperations(Enumeration):
	kOpAutoDetect=2
	kOpDone=5
	kOpInit=0
	kOpReset=4
	kOpStart=1
	kOpStop=3
class FBAddRegionParam:
	"""This class provide a placeholder to put values necessary to create a Region with [FBLayout.AddRegion](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_layout.html#ada9608d3cc29bcfcb802803c582c7e82 "Add a region to the layout.").

	Each region components: X, Y, Width and Height needs its own [FBAddRegionParam](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_add_region_param.html "This class provide a placeholder to put values necessary to create a Region with FBLayout...."). ex: x = [FBAddRegionParam](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_add_region_param.html "This class provide a placeholder to put values necessary to create a Region with FBLayout....")(0,[FBAttachType.kFBAttachLeft](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_attach_type.html#a515a9fce5f31a6a352618a99ccebd358 "Attach to left [min(x1,x2)]"),"") y = [FBAddRegionParam](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_add_region_param.html "This class provide a placeholder to put values necessary to create a Region with FBLayout....")(0,[FBAttachType.kFBAttachTop](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_attach_type.html#acf522b0b312ed5f748dd443b9c1f725b "Attach to top [min(y1,y2)]"),"") w = [FBAddRegionParam](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_add_region_param.html "This class provide a placeholder to put values necessary to create a Region with FBLayout....")(0,[FBAttachType.kFBAttachRight](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_attach_type.html#adb2cd1fac6e9229996167824546e0c00 "Attach to right [max(x1,x2)]"),"") h = [FBAddRegionParam](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_add_region_param.html "This class provide a placeholder to put values necessary to create a Region with FBLayout....")(25,[FBAttachType.kFBAttachNone](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_attach_type.html#acd7210d36736844518c582980ef225b8 "No attachment."),"") mainLyt.AddRegion("main","main", x, y, w, h)"""
	mMult:FBPropertyFloat
	"""Read Property: Multiplier of relative value."""
	mPos:FBPropertyInt
	"""Read Property: Offset in pixel according depending on the use of [FBAddRegionParam](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_add_region_param.html "This class provide a placeholder to put values necessary to create a Region with FBLayout....") (X, Y, W or H)."""
	mRelative:str
	"""Read Property: Name of Region to attach relative to."""
	mType:FBAttachType
	"""Read Property: Type of Attachment."""
	def __init__(self,Pos:int,Type:FBAttachType,Relative:str,Mult:float=1.0,/):
		"""Initialize a region params.

		### Parameters:
			- Pos: Offset in pixel according depending on the use of [FBAddRegionParam](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_add_region_param.html "This class provide a placeholder to put values necessary to create a Region with FBLayout....") (X, Y, W or H)
			- Type: Type of Attachment.
			- Relative: Name of Region to attach relative to.
			- Mult: Multiplier of relative value."""
		...
class FBAudioRenderOptions:
	"""Audio Render Options structure.

	Contain options to control how the audio rendering will occur.

	[See sample: AudioRendering.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_audio_0c_audio_rendering_8py-example.html)"""
	BitDepthMode:FBAudioBitDepthMode
	"""Property: Bit depth for one sample of audio. 8, 16 and 24 bits available for audio render, 16 bits default."""
	ChannelMode:FBAudioChannelMode
	"""Property: Audio render channel number, 1 for Mono(left channel right channel render mixed to one channel), 2 for Stereo(left channel right channel render separately)."""
	OutputFileName:str
	"""Property: Audio Render destination file."""
	RateMode:FBAudioRateMode
	"""Property: Rate mode for number of samples per second. 44100 hz default,8000, 11025,12000,16000,22050,24000,32000,44100,48000,64000,88200,96000 available for audio render."""
	TimeSpan:FBTimeSpan
	"""Property: Start and stop selection time to render."""
	def __init__(self):...
class FBBatchOptions:
	"""Option parameters for the batch process."""
	Character:FBCharacter
	"""Read Write Property: The character to receive the animation."""
	FrameAnimation:bool
	"""Read Write Property: Set timeline start and end time to corespond with the start and end of animation."""
	InputDirectory:str
	"""Read Write Property: The directory containning the input files."""
	InputFileFormat:FBBatchFileFormat
	"""Read Write Property: File format of the input files."""
	KeepCharacterConstraint:bool
	"""Read Write Property: To keep the character constaint when saving."""
	KeepDummyBones:bool
	"""Read Write Property: To keep dummy bones."""
	OnContainsBatchTakesAction:FBBatchOnContainsBatchTakes
	"""Read Write Property: Action to perform when a scene already contains batch takes while in a batch process."""
	OnTakeExistAction:FBBatchOnTakeExist
	"""Read Write Property: Action to perform when a take already exist while in a batch process."""
	OutputDirectory:str
	"""Read Write Property: The directory containning the output files."""
	OutputFileFormat:FBBatchFileFormat
	"""Read Write Property: File format of the output files."""
	OverwriteScaling:bool
	"""Read Write Property: Set the scaling to a default setting of 1.0."""
	PlotToCharacter:bool
	"""Read Write Property: To plot the animation on the character."""
	PlotToControlSet:bool
	"""Read Write Property: To plot the animation on the control set."""
	ProcessType:FBBatchProcessType
	"""Read Write Property: What process should be done? Load, Save or Both."""
	SkeletonFile:str
	"""Read Write Property: The Skeleton file (for Acclaim AMC files)."""
	StartAnimationAtZero:bool
	"""Read Write Property: Set the time of all loaded files to 0."""
	UseBatchSuffix:bool
	"""Read Write Property: Add a batch suffix to the name of the files."""
	UseSingleTake:bool
	"""Read Write Property: Use only one take to convert all files."""
	WriteRate:bool
	"""Read Write Property: Write frame rate in Acclaim AMC files."""
	WriteTranslation:bool
	"""Read Write Property: Write translation animation data included with Acclaim AMC files."""
	def __init__(self):...
class FBCallback:
	"""This class is used for the internal callback framework and is not meant to be used by clients."""
	Callback:Any
	"""Read Property: Python callback that will called when the [FBCallback](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_callback.html "This class is used for the internal callback framework and is not meant to be used by clients.") is executed."""
	EventType:FBEventName
	"""Read Property: Event type to which this callback is connected."""
	Wrapper:Any
	"""Read Property: Pyfbsdk Wrapper that is the owner of the callback."""
	def __init__(self,arg2,arg3:FBEventName,arg4,/):...
class FBCharacterPoseOptions:
	"""Stores options for operations on poses.

	This class exposes the object used to store the options for operations on object poses. Before using a [FBCharacterPoseOptions](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_character_pose_options.html "Stores options for operations on poses."), you need to specify the various members of the object. Here are the default values of a [FBCharacterPoseOptions](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_character_pose_options.html "Stores options for operations on poses.") object: mCharacterPoseKeyingMode = kFBCharacterPoseKeyingModeFullBody mModelToMatch = NULL mMirrorPlaneType = kFBMirrorPlaneTypeAuto mMirrorPlaneEquation = 1.0, 0.0, 0.0, 0.0 mMirrorPlaneTiltAngle = 90.0 mMirrorPlanePanAngle = 0.0 Flag = kFBCharacterPoseNoFlag You need to change at least the Flag value by using [SetFlag()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_character_pose_options.html#af1e61ff84dbda2a16ac7f0eb5c05f0d4 "Set a flag value.") to set how the pose will be pasted; see the [FBCharacterPoseFlag](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_character_pose_flag.html "Character Pose Options flags.") enum for the various options."""
	mCharacterPoseKeyingMode:FBCharacterPoseKeyingMode
	"""CharacterPoseKeyingMode (FullBody or BodyPart)."""
	mMirrorPlaneEquation:FBVector4d
	"""Mirror plane equation (used when mMirrorPlaneType = kFBMirrorPlaneTypeEquation)."""
	mMirrorPlanePanAngle:float
	"""Mirror plane pan angle in degrees (used when mMirrorPlaneType = kFBMirrorPlaneTypeUser)."""
	mMirrorPlaneTiltAngle:float
	"""Mirror plane tilt angle in degrees (used when mMirrorPlaneType = kFBMirrorPlaneTypeUser)."""
	mMirrorPlaneType:FBMirrorPlaneType
	"""Mirror plane type."""
	mModelToMatch:FBModel
	"""Model to match."""
	def ClearFlag(self)->None:
		"""Clear all flags."""
		...
	def GetFlag(self,Flag:FBCharacterPoseFlag,/)->bool:
		"""Get a flag value.

		### Parameters:
			- Flag: Flag to get.

		### Returns:
		Value of the flag."""
		...
	def SetFlag(self,Flag:FBCharacterPoseFlag,Value:bool,/)->None:
		"""Set a flag value.

		### Parameters:
			- Flag: Flag to set.
			- Value: Value to set."""
		...
	def __init__(self):...
class FBColor:
	"""[FBColor](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_color.html "FBColor class.") class.

	Color vector.

	This class creates a list like object, which can be modified using the list protocol method. But unlike lists, its length is fixed: it always contain 3 floating point values. Thus it does not support the any list methods that would affect its length. The values within can be changed, usually via the bracket operator.

	```python
	# Supported list protocol methods:
	color = FBColor()
	len(color)
	print(color[0])
	color[0] = 1.0
	```
	### Warning:
	Slicing is not supported by this object.

	[See samples: LayeredTexture.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_material_and_texture_0c_layered_texture_8py-example.html) [SetAllCamerasBackgroundColor.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_set_all_cameras_background_color_8py-example.html) [SetAllCamerasBackgroundColorFromCurrentCamera.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_set_all_cameras_background_color_from_current_camera_8py-example.html) [SetAllCamerasBackgroundColorFromFirstSelectedCamera.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_set_all_cameras_background_color_from_first_selected_camera_8py-example.html)"""
	@overload
	def CopyFrom(self,arg2:FBColor,/)->FBColor:...
	@overload
	def CopyFrom(self,arg2:list,/)->FBColor:...
	def GetBufferAddress(self)->int:...
	def GetList(self)->list:...
	def IsEqual(self,arg2:FBColor,/)->bool:...
	def NotEqual(self,arg2:FBColor,/)->bool:...
	@overload
	def __add__(self,arg2:FBColor,/)->FBColor:...
	@overload
	def __add__(self,arg2,/)->FBColor:...
	def __getitem__(self,Index:int,/)->float:
		"""Returns the ith component Corresponds to python: print color[1].

		### Parameters:
			- Index: Index of the components to get (0:Red, 1:Green, 2:Blue)

		### Returns:
		Color component value."""
		...
	@overload
	def __iadd__(self,arg2:FBColor,/)->FBColor:...
	@overload
	def __iadd__(self,arg2,/)->FBColor:...
	@overload
	def __idiv__(self,arg2:FBColor,/)->FBColor:...
	@overload
	def __idiv__(self,arg2,/)->FBColor:...
	@overload
	def __imul__(self,arg2:FBColor,/)->FBColor:...
	@overload
	def __imul__(self,arg2,/)->FBColor:...
	@overload
	def __init__(self):
		"""Default constructor, all values within are set to 0.0, except for the Alpha value which is set to 1.0."""
		...
	@overload
	def __init__(self,Color:FBColor,/):
		"""Copy constructor. Copy values from another instance."""
		...
	@overload
	def __init__(self,R:float,G:float,B:float,/):
		"""Explicitely construct a vector by specifying its RGBA values. Should the Alpha value not be relevant, just set it to 1.0."""
		...
	@overload
	def __init__(self,arg2:tuple[float,float,float],/):
		"""A vector can be built from any python object with supports the tuple interface and is of a lenght of 3."""
		...
	@overload
	def __init__(self,arg2:list,/):...
	@overload
	def __isub__(self,arg2:FBColor,/)->FBColor:...
	@overload
	def __isub__(self,arg2,/)->FBColor:...
	def __len__(self)->int:
		"""Returns the number of elements.

		Corresponds to python: len(object)"""
		...
	@overload
	def __mul__(self,arg2:FBColor,/)->FBColor:...
	@overload
	def __mul__(self,arg2,/)->FBColor:...
	def __neg__(self)->FBColor:...
	def __setitem__(self,Index:int,ComponentValue:float,/):
		"""Sets the ith components Corresponds to python: color[1] = 0.5.

		### Parameters:
			- Index: Index of the components to set (0:Red, 1:Green, 2:Blue)
			- ComponentValue: Value of component to set"""
		...
	@overload
	def __sub__(self,arg2:FBColor,/)->FBColor:...
	@overload
	def __sub__(self,arg2,/)->FBColor:...
	@overload
	def __truediv__(self,arg2:FBColor,/)->FBColor:...
	@overload
	def __truediv__(self,arg2,/)->FBColor:...
	def __iter__(self)->Iterator[float]:...
class FBColorAndAlpha:
	"""[FBColorAndAlpha](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_color_and_alpha.html "FBColorAndAlpha class.") class.

	Color and alpha vector.

	This class creates a list like object, which can be modified using the list protocol method. But unlike lists, its length is fixed: it always contain 4 floating point values. Thus it does not support the any list methods that would affect its length. The values within can be changed, usually via the bracket operator.

	```python
	# Supported list protocol methods:
	color = FBColorAndAlpha()
	len(color)
	print(color[0])
	color[0] = 1.0
	```
	### Warning:
	Slicing is not supported by this object."""
	@overload
	def CopyFrom(self,arg2:FBColorAndAlpha,/)->FBColorAndAlpha:...
	@overload
	def CopyFrom(self,arg2:list,/)->FBColorAndAlpha:...
	def GetBufferAddress(self)->int:...
	def GetList(self)->list:...
	def IsEqual(self,arg2:FBColorAndAlpha,/)->bool:...
	def NotEqual(self,arg2:FBColorAndAlpha,/)->bool:...
	@overload
	def __add__(self,arg2:FBColorAndAlpha,/)->FBColorAndAlpha:...
	@overload
	def __add__(self,arg2,/)->FBColorAndAlpha:...
	def __getitem__(self,Index:int,/)->float:
		"""Returns the ith component Corresponds to python: print color[1].

		### Parameters:
			- Index: Index of the components to get (0:Red, 1:Green, 2:Blue)

		### Returns:
		Color component value."""
		...
	@overload
	def __iadd__(self,arg2:FBColorAndAlpha,/)->FBColorAndAlpha:...
	@overload
	def __iadd__(self,arg2,/)->FBColorAndAlpha:...
	@overload
	def __idiv__(self,arg2:FBColorAndAlpha,/)->FBColorAndAlpha:...
	@overload
	def __idiv__(self,arg2,/)->FBColorAndAlpha:...
	@overload
	def __imul__(self,arg2:FBColorAndAlpha,/)->FBColorAndAlpha:...
	@overload
	def __imul__(self,arg2,/)->FBColorAndAlpha:...
	@overload
	def __init__(self):
		"""Default constructor, all values within are set to 0.0, except for the Alpha value which is set to 1.0."""
		...
	@overload
	def __init__(self,Vector:FBColorAndAlpha,/):
		"""Copy Constructor."""
		...
	@overload
	def __init__(self,R:float,G:float,B:float,Alpha:float|None=None,/):
		"""Explicitely construct a vector by specifying its RGBA values. Should the Alpha value not be relevant, just set it to 1.0."""
		...
	@overload
	def __init__(self,Color:FBColor,/):
		"""Copy constructor. Copy values from another instance."""
		...
	@overload
	def __init__(self,arg2:list,/):...
	@overload
	def __isub__(self,arg2:FBColorAndAlpha,/)->FBColorAndAlpha:...
	@overload
	def __isub__(self,arg2,/)->FBColorAndAlpha:...
	def __len__(self)->int:
		"""Returns the number of elements.

		Corresponds to python: len(object)"""
		...
	@overload
	def __mul__(self,arg2:FBColorAndAlpha,/)->FBColorAndAlpha:...
	@overload
	def __mul__(self,arg2,/)->FBColorAndAlpha:...
	def __neg__(self)->FBColorAndAlpha:...
	def __setitem__(self,Index:int,ComponentValue:float,/):
		"""Sets the ith components Corresponds to python: color[1] = 0.5.

		### Parameters:
			- Index: Index of the components to set (0:Red, 1:Green, 2:Blue)
			- ComponentValue: Value of component to set"""
		...
	@overload
	def __sub__(self,arg2:FBColorAndAlpha,/)->FBColorAndAlpha:...
	@overload
	def __sub__(self,arg2,/)->FBColorAndAlpha:...
	@overload
	def __truediv__(self,arg2:FBColorAndAlpha,/)->FBColorAndAlpha:...
	@overload
	def __truediv__(self,arg2,/)->FBColorAndAlpha:...
	def __iter__(self)->Iterator[float]:...
class FBComponentList:
	"""[FBComponentList](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component_list.html "FBComponentList class.") class.

	This class implements a special sort of list that can only contain instances of [FBComponent](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html "MotionBuilder SDK base class.") objects. To users it behaves as a tuple, since it is not possible to add new objects in the list. Only methods or function that uses [FBComponentList](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component_list.html "FBComponentList class.") as argument can insert new objects. Users can query the content of the list with the bracket operator.

	```python
	# Supported list protocol methods:
	l = FBComponentList()
	len(l)
	print(l[0])
	```"""
	def Add(self,arg2:FBComponent,/)->None:...
	def Clear(self)->None:...
	def GetCount(self)->int:...
	def __getitem__(self,Index:int,/)->FBComponent:
		"""Returns the ith component Corresponds to python: print l[1].

		### Parameters:
			- Index: Index of the components to get

		### Returns:
		[FBComponent](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html "MotionBuilder SDK base class.") element value"""
		...
	def __init__(self):...
	def __len__(self)->int:
		"""Returns the number of elements.

		Corresponds to python: len(object)"""
		...
	def append(self,arg2:FBComponent,/)->None:...
	def count(self)->int:...
	def removeAll(self)->None:...
	def __iter__(self)->Iterator[FBComponent]:...
class FBConfigFile:
	"""Interface to the application config files.

	This class allows client code to generate, modify and query configuration files. Config files will be automatically created when needed. They will be located in the /bin/config folder or an explicitly specified folder depending on the constructor used.

	[See samples: FBConfigFile.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_f_b_config_file_8py-example.html) [ActionScriptMgr.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_complex_tools_0c_action_script_mgr_8py-example.html) [ActionScriptMgr.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_complex_tools_0c_action_script_mgr_8py-example.html) [KeyboardMapper.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_complex_tools_0c_keyboard_mapper_8py-example.html) [ShotTrackSetupTool.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_complex_tools_0c_shot_track_setup_tool_8py-example.html)"""
	def ClearFile(self)->None:
		"""Remove all content from the config file."""
		...
	def Get(self,SectionName:str,ItemName:str,DefaultValue:str|None=None,/)->str:
		"""Get an item's value.

		Get an item's value by looking inside a specific section of the config file.
		### Parameters:
			- SectionName: Name of the section.
			- ItemName: Name of the item.
			- DefaultValue: Default value that will be returned if the item is not found.

		### Returns:
		The value assigned to the item in the specified section of the config file, or the default value if not found."""
		...
	def GetOrSet(self,SectionName:str,ItemName:str,Value:str,Comment:str|None=None,/)->tuple:
		"""Get a value from the config file and set it if it was not found.

		### Parameters:
			- SectionName: Name of the section.
			- ItemName: Name of the item.
			- Value: Reference the the string that will contain the value of the item. If the item is not found in the file, it will be added with the initial value in this string.
			- Comment: Optional parameter that can be used to add a comment.

		### Returns:
		true if the value was found or added, or false if the item was not found and could not be added to the file."""
		...
	def Set(self,SectionName:str,ItemName:str,Value:str,Comment:str|None=None,/)->bool:
		"""Set an item's value.

		Assign a value to an item in the config file. If the item does not exist, it will be created.
		### Parameters:
			- SectionName: Name of the section.
			- ItemName: Name of the item.
			- Value: Value assigned to the item.
			- Comment: Optional parameter that can be used to add a comment.

		### Returns:
		true if the item was written to the config file, false otherwise."""
		...
	@overload
	def __init__(self,ConfigFileName:str,VirtualMode:bool=False,ClearFile:bool=False,/):
		"""This will open the desired config file from the [APPLICATION]/bin/config folder. The file will be created if it does not exists. By prefixing the character '@' to the file name, this will automatically prepend the current machine name to the config file, the way it is done for the other config files of the application.
		### Parameters:
			- ConfigFileName: Name the config file to use.
			- VirtualMode: Enable this to limit disk access, file will only be read at construction and written at destruction.
			- ClearFile: Remove all existing content from the config file."""
		...
	@overload
	def __init__(self,ConfigFileName:str,ConfigFilePath:str,VirtualMode:bool=False,ClearFile:bool=False,/):
		"""This will open the desired config file in the designed folder. The file will be created if it does not exists. By prefixing the character '@' to the file name, this will automatically prepend the current machine name to the config file, the way it is done for the other config files of the application.
		### Parameters:
			- ConfigFileName: Name the config file to use.
			- ConfigFilePath: Location where the file should reside. Missing directories will not be created.
			- VirtualMode: Enable this to limit disk access, file will only be read at construction and written at destruction.
			- ClearFile: Remove all existing content from the config file."""
		...
class FBConstraintInfo:
	"""Constraint information class.

	This data structure is passed to the real-time evaluation callback for a constraint (AnimationNodeNotify())."""
	def GetSnapRequested(self)->bool:
		"""Was a 'snap' requested?

		### Returns:
		true if 'snap' was requeststed."""
		...
	def GetZeroRequested(self)->bool:
		"""Was a 'zero' requested?

		### Returns:
		true if 'zero' was requeststed."""
		...
class FBConstructionOperation:
	"""[FBConstructionOperation](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_construction_operation.html "FBConstructionOperation is used to represent an operation in the construction history.") is used to represent an operation in the construction history.

	The operation can be any valid script. Currently, only python scripts are supported.An instance of this class defaults to the correct value in order to add a new construction history. If the workgroup plugin is loaded, the operation will be replicated on all machine within a session."""
	def GetCommandId(self)->int:...
	def GetExecuteAsLocalOperation(self)->bool:...
	def GetLanguage(self)->str:...
	def GetLanguageVersion(self)->int:...
	def GetOrigin(self)->str:...
	def GetScript(self)->str:...
	def SetCommandId(self,commandId:int,/)->None:
		"""SetCommandId Set the operation's Id so that operation transactions can be resolved properly (eg: command 1 should go before command 2).

		Set this to -1 for new operations.
		### Parameters:
			- commandId: Command Id. Defaults to -1."""
		...
	def SetExecuteAsLocalOperation(self,bIsLocal:bool,/)->None:
		"""SetExecuteAsLocalOperation Whether to execute this operation as local or remote.

		If this is set to false (remote) and an operation is sent to the construction history, it will also execute locally on this motionbuilder.
		### Parameters:
			- bIsLocal: Defaults to true (local)."""
		...
	def SetLanguage(self,language:str,/)->None:
		"""SetLanguage Set the script language for this operation.

		Currently only "python" is supported.
		### Parameters:
			- language: Langugage string. Default to construction history's code generator's language (Currently "python")."""
		...
	def SetLanguageVersion(self,version:int,/)->None:
		"""SetLanguageVersion Set the script language interpreter's version that this operation should be interpreted with.

		### Parameters:
			- version: Version number. Defaults to construction history's code generator's version (Currently 1)."""
		...
	def SetOrigin(self,origin:str,/)->None:
		"""SetOrigin Set operation's original creator.

		For instance "localhost" or . Should mostly be "localhost" for new operations.
		### Parameters:
			- origin: Operation's Origin. Defaults to "localhost"."""
		...
	def SetScript(self,script:str,/)->None:
		"""SetScript Set the script content for this operation.

		### Parameters:
			- script: Script content as a string. Defaults to empty."""
		...
	def __init__(self,arg2:str|None=None,/):...
class FBDeviceNotifyInfo:
	"""Device Input and Output Notification information structure.

	This structure is passed to the real-time device IO callback DeviceIONotify. It furnishes the device callback with the system time, local time, and sync counts for the current device cycle."""
	def GetLocalTime(self)->FBTime:
		"""Get local time.

		### Returns:
		Current local time."""
		...
	def GetSyncCount(self)->int:
		"""Return the wanted timer sync count (internal or external)

		### Returns:
		sync count or -1 if no sync is present"""
		...
	def GetSystemTime(self)->FBTime:
		"""Get system time.

		### Returns:
		Current system time."""
		...
class FBDirMap:
	def Add(self,SourceDir:str,TargetDir:str,/)->None:
		"""Adds an entry in the map.

		Environment variables can be specified for the target path using the syntax. Environment variables are expanded before the paths get added to the map. An error in the formatting of the paths (environment variable tokens) will abort the expansion and both given paths will remained unchanged."""
		...
	def Clear(self)->None:
		"""Clears the map."""
		...
	def GetCount(self)->int:
		"""Returns the number of items in the map."""
		...
	def GetSource(self,Index:int,/)->str:
		"""Returns the source directory for the element at specified index."""
		...
	def GetTarget(self,Index:int,/)->str:
		"""Returns the target directory for the element at specified index."""
		...
	def Map(self,Path:str,/)->str:
		"""Iterates through all the mapped directories.

		If one of the mapped directory's source is found in the given path, that part of the path will be replaced by the mapped directory's target. Only the first occurrence is processed.
		### Parameters:
			- Path: The path to process"""
		...
	def __init__(self):...
class FBEvaluateInfo:
	"""AnimationNodeNotify evaluation information.

	This structure is passed to the AnimationNodeNotify calls (in Constraints, Devices, and Boxes), giving the connectors information with regards to the start or stop times of the evaluation. In general, only the start time is of interest for the current evaluation cycle. The advantage of the structure is to have a common time for the evaluation of all the elements in the scene."""
	def GetEvaluationID(self)->int:
		"""Return the wanted timer sync count (internal or external).

		### Returns:
		sync count or -1 if no sync is present"""
		...
	def GetLocalTime(self)->FBTime:
		"""Return local (scene) time.

		### Returns:
		Local time."""
		...
	def GetSyncCount(self)->int:
		"""Return the wanted timer sync count (internal or external).

		### Returns:
		sync count or -1 if no sync is present"""
		...
	def GetSystemTime(self)->FBTime:
		"""Return system time.

		### Returns:
		System time."""
		...
	def IsStop(self)->bool:
		"""Is local time stopped? (ie: no animation).

		### Returns:
		true if local time is stopped."""
		...
class FBEvent:
	"""Base Event class."""
	Type:int
	"""Read Only Property: Type of event."""
class FBEventActivate(FBEvent):
	"""Activation event."""
	Data:int
	"""Read Write Property: Generic data of event."""
class FBEventClipChange(FBEvent):
	Type:FBStoryClipChangeType
	"""Read Only Property: Type of event."""
	def __init__(self):
		"""### Parameters:
			- Event: Base event (internal) to obtain information from."""
		...
class FBEventConnectionDataNotify(FBEvent):
	"""Connection notify event class."""
	Action:FBConnectionAction
	"""Read Only Property: Connection's action performed."""
	Plug:FBPlug
	"""Read Only Property: The plug involved in the action."""
	def __init__(self):
		"""### Parameters:
			- Event: Base event (internal) to obtain information from."""
		...
class FBEventConnectionKeyingNotify(FBEvent):
	Action:FBConnectionAction
	Plug:FBPlug
	@property
	def Property(self)->FBPropertyAnimatable:...
	@Property.setter
	def Property(self, Value: FBPropertyAnimatable|Any):...
	StartTime:FBTime
	StopTime:FBTime
	def __init__(self):
		"""### Parameters:
			- Event: Base event (internal) to obtain information from."""
		...
class FBEventConnectionNotify(FBEvent):
	"""Connection notify event class."""
	Action:FBConnectionAction
	"""Read Only Property: Connection's action performed."""
	ConnectionType:FBConnectionType
	"""Read Only Property: Connection's type."""
	DstPlug:FBPlug
	"""Read Only Property: The destination plug involved in the action."""
	NewPlug:FBPlug
	"""Read Only Property: New plug created by the action. (Mostly used by merge/replace)"""
	SrcIndex:int
	"""Read Only Property: Index of the source in the destination component."""
	SrcPlug:FBPlug
	"""Read Only Property: The source plug involved in the action."""
	def __init__(self):
		"""### Parameters:
			- Event: Base event (internal) to obtain information from."""
		...
class FBEventConnectionStateNotify(FBEvent):
	"""Connection notify event class."""
	Action:FBConnectionAction
	"""Read Only Property: Connection's action performed."""
	Plug:FBPlug
	"""Read Only Property: The plug involved in the action."""
	def __init__(self):
		"""### Parameters:
			- Event: Base event (internal) to obtain information from."""
		...
class FBEventDblClick(FBEvent):
	"""Input event class."""
	Selection:int
	"""Read Only Property: Id of selection."""
	def __init__(self):
		"""### Parameters:
			- Event: Base event (internal) to obtain information from."""
		...
class FBEventDragAndDrop(FBEvent):
	"""Drag and drop interface. Event: Global Evaluation pipeline critical timing callback event."""
	Components:list
	"""Read Property: List of components drop. (it acces the same data as [FBEventDragAndDrop.Get](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_event_drag_and_drop.html#a642fa6de110af053123bb85b527945fc "Get the FBComponent specified by pIndex from the Drag and Drop list."))"""
	Data:int
	"""Property: User specified reference. (for example, [FBSpread](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_spread.html "Base spreadsheet class."):row)"""
	PosX:int
	"""Property: X position of mouse."""
	PosY:int
	"""Property: Y position of mouse."""
	State:FBDragAndDropState
	"""Property: Drag and drop sub-event."""
	def Accept(self)->None:
		"""Accept a drag and drop sequence.

		This will cause the region in question to accept a drag and drop action when this event occurs."""
		...
	def Add(self,Component:FBComponent,Id:int=0,/)->None:
		"""Add an item to the drag and drop list.

		### Parameters:
			- Component: Item to add to the list.
			- Id: User-defined reference for the item (default = 0 )."""
		...
	def Clear(self)->None:
		"""Clear drag and drop list."""
		...
	def Get(self,Index:int,/)->FBComponent:
		"""Get the [FBComponent](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html "MotionBuilder SDK base class.") specified by pIndex from the Drag and Drop list.

		### Parameters:
			- Index: Index in list where to get [FBComponent](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html "MotionBuilder SDK base class.").

		### Returns:
		Handle to [FBComponent](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html "MotionBuilder SDK base class.") in list at pIndex."""
		...
	def GetCount(self)->int:
		"""Get the number of items in the DragAndDrop list.

		### Returns:
		Number of items in DragAndDrop list."""
		...
class FBEventEvalGlobalCallback(FBEvent):
	Timing:FBGlobalEvalCallbackTiming
class FBEventExpose(FBEvent):
	"""Event sent when a control needs to be displayed."""
	...
class FBEventFileChange(FBEvent):
	"""File change event class.

	This event occurs every time a monitored file changed:"""
	Path:str
	"""Read Only Property: The path of changed file."""
	Type:FBFileMonitoringType
	"""Read Only Property: Type of file change event."""
class FBEventInput(FBEvent):
	"""Input event class."""
	InputType:FBInputType
	"""Read Only Property: Input type."""
	Key:int
	"""Read Only Property: Input key."""
	KeyState:int
	"""Read Only Property: State of key."""
	MouseButton:int
	"""Read Only Property: Mouse Button."""
	X:int
	"""Read Only Property: Mouse X Position."""
	Y:int
	"""Read Only Property: Mouse Y Position."""
class FBEventMenu(FBEvent):
	"""Menu event."""
	Id:int
	"""Read Write Property: Id number for menu item."""
	Name:str
	"""Read Write Property: Name of menu item."""
class FBEventOverrideFileOpen(FBEvent):
	"""Event that is called before a file open/merge."""
	FilePath:str
	"""Read Only Property: Path to the file that will be opened/merged."""
	WillOverride:bool
	"""Read Write Property: Set to true for handling the file load, false by default. If the return value is false, MotionBuilder will proceed with the normal file open/merge process."""
	def __init__(self):
		"""### Parameters:
			- Event: Base event (internal) to obtain information from."""
		...
class FBEventPlayerControlChange(FBEvent):
	Type:FBPlayerControlChangeType
	"""Read Only Property: Type of event."""
	def __init__(self):
		"""### Parameters:
			- Event: Base event (internal) to obtain information from."""
		...
class FBEventResize(FBEvent):
	"""Event sent to a control that resizes."""
	Height:int
	"""Property: New Height of the window."""
	Width:int
	"""Property: New Width of the window."""
	def __init__(self):
		"""### Parameters:
			- Event: Base event (internal) to obtain information from."""
		...
class FBEventSceneChange(FBEvent):
	"""Select model event class.

	This event occurs every time a model is:(un)selectedaddeddestroyedrenamed, etc.."""
	ChildComponent:FBComponent
	"""Read Only Property: Child component of the event."""
	Component:FBComponent
	"""Read Only Property: Modified component"""
	Type:FBSceneChangeType
	"""Read Only Property: Type of selection event."""
	def __init__(self):
		"""### Parameters:
			- Event: Base event (internal) to obtain information from."""
		...
class FBEventShow(FBEvent):
	"""Show event class."""
	Shown:bool
	"""Read Only Property: Was layer just shown?"""
class FBEventSpread(FBEvent):
	"""Spreadsheet event."""
	Action:int
	"""Read Only Property: Action associated to the spread event."""
	Column:int
	"""Read Only Property: Column of event."""
	Row:int
	"""Read Only Property: Row of event."""
class FBEventTakeChange(FBEvent):
	"""Take change event class.

	This event occurs every time a take is:addeddestroyedrenamedselected, etc."""
	Take:FBTake
	"""Read Only Property: The take modified."""
	Type:FBTakeChangeType
	"""Read Only Property: Type of take change event."""
	def __init__(self):
		"""### Parameters:
			- Event: Base event (internal) to obtain information from."""
		...
class FBEventTransaction(FBEvent):
	"""Transaction event."""
	IsBeginTransaction:bool
	"""Read Only Property: Tells if the transaction is at begin."""
class FBEventTree(FBEvent):
	"""[FBTree](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_tree.html "Tree list view.") node event."""
	TreeNode:FBTreeNode
	"""Read Write Property: Tree node."""
	Why:property
	"""Read Write Property: Reason of the event."""
class FBEventTreeSelect(FBEvent):
	"""[FBTree](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_tree.html "Tree list view.") selection event. Event: Video Frame offline Rendering Event."""
	TreeNode:FBTreeNode
	"""Read Write Property: Selected tree node."""
	def __init__(self):
		"""### Parameters:
			- Event: Base event (internal) to obtain information from."""
		...
class FBEventVideoFrameRendering(FBEvent):
	class EState(Enumeration):
		eBeginRendering:FBEventVideoFrameRendering.EState
		eEndRendering:FBEventVideoFrameRendering.EState
		eRendering:FBEventVideoFrameRendering.EState
	FrameCount:int
	FrameNumber:int
	State:EState
	eBeginRendering:FBEventVideoFrameRendering.EState
	eEndRendering:FBEventVideoFrameRendering.EState
	eRendering:FBEventVideoFrameRendering.EState
	def __init__(self):
		"""### Parameters:
			- Event: Base event (internal) to obtain information from."""
		...
class FBFCurveEvent(FBEvent):
	"""This class is used when a modification is made on a FCurve.

	It contains the necessary information to identify the owner of the curve and what modification was made."""
	Curve:FBFCurve
	"""Read Only Property: Curve that will receive the new key."""
	CurveIndex:int
	"""Read Only Property: Index of curve."""
	CurveName:str
	"""Read Only Property: Name of curve."""
	EventType:FBFCurveEventType
	"""Read Only Property: Type of fcurve event."""
	KeyIndexStart:int
	"""Read Only Property: Index of the first key which is involved in the event."""
	KeyIndexStop:int
	"""Read Only Property: Index of the last key which is involved in the event."""
	ParentAnimationNode:FBAnimationNode
	ParentComponent:FBComponent
	@property
	def ParentProperty(self)->FBPropertyAnimatable:...
	@ParentProperty.setter
	def ParentProperty(self, Value: FBPropertyAnimatable|Any):...
	def __init__(self):
		"""### Parameters:
			- Event: Base event (internal) to obtain information from."""
		...
class FBFCurveKey:
	"""KeyFrame for an FCurve.

	[See sample: StartKeysAtCurrentTime.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_start_keys_at_current_time_8py-example.html)"""
	Bias:float
	"""Read Write Property: Bias (TCB)."""
	Continuity:float
	"""Read Write Property: Continuity (TCB)."""
	ExtrapolationMode:FBExtrapolationMode
	"""Read Write Property: Extrapolation mode"""
	Interpolation:FBInterpolation
	"""Read Write Property: Type of interpolation."""
	LeftBezierTangent:float
	"""Read Write Property: Left bezier tangent"""
	LeftDerivative:float
	"""Read Write Property: Left derivative, in units/seconds."""
	LeftTangentWeight:float
	"""Read Write Property: Left tangent weight"""
	MarkedForManipulation:bool
	"""Read Write Property: Is the key marked for manipulation."""
	RightBezierTangent:float
	"""Read Write Property: Right bezier tangent"""
	RightDerivative:float
	"""Read Write Property: Right derivative, in units/seconds."""
	RightTangentWeight:float
	"""Read Write Property: Right tangent weight"""
	Selected:bool
	"""Read Write Property: Is the key selected."""
	TangentBreak:bool
	"""Read Write Property: Tangent's break status"""
	TangentClampMode:FBTangentClampMode
	"""Read Write Property: Tangent's clamp method."""
	TangentConstantMode:FBTangentConstantMode
	"""Read Write Property: Tangent's constant mode"""
	TangentCustomIndex:FBTangentCustomIndex
	"""Read Write Property: Tangent's custom index"""
	TangentMode:FBTangentMode
	"""Read Write Property: Tangent calculation method."""
	TangentWeightMode:FBTangentWeightMode
	"""Read Write Property: Tangent's weight mode. Setting the value for LeftTangentWeight/RightTangentWeight will also activate the weight for that part. Please see the note provided with [FBTangentWeightMode](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_tangent_weight_mode.html "Active tangent weight, no/one/both side are active on a key.") for the left weight of a key."""
	Tension:float
	"""Read Write Property: Tension (TCB)."""
	Time:FBTime
	"""Read Write Property: Time of key."""
	Value:float
	"""Read Write Property: Value of Key"""
	def __init__(self):...
class FBFilePopup:
	"""File Popup (for open/save).

	[See samples: AudioTrackSetupTool.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_complex_tools_0c_audio_track_setup_tool_8py-example.html) [FBFilePopup.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_f_b_file_popup_8py-example.html)"""
	Caption:str
	"""Read Write Property: Caption to put in popup window."""
	FileName:str
	"""Read Write Property: File selected."""
	Filter:str
	"""Read Write Property: Filter to use for popup window file selection."""
	FullFilename:str
	"""Read Only Property: Full filename (path and file)."""
	Path:str
	"""Read Write Property: Path of file selected."""
	Style:FBFilePopupStyle
	"""Read Write Property: Style of file popup."""
	def Execute(self)->bool:
		"""Execute file popup.

		### Returns:
		true if OK is clicked by user."""
		...
	def __init__(self):...
class FBFilterManager:
	"""Filter manager.

	This class provides list of all available filter types and a factory method in order to create an instance of the desired filter type.This manager will list both built-in and plug-in filters.See the class [FBFilter](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_filter.html "Filters are used to modify motion capture data.") for more details.Filter type names are not localised, and are the same as presented in the GUI.The following sample code shows how to use C++ or Python to create an instance of the orfilter_template filter and set one of its property. For the sample code to work, the plugin must have been compiled and copied in the plugins folder prior to the application startup.Sample C++ code:

	```c++
	// Create a filter of a known type. In this case the sample filter
	// provided with the samples: orfilter_template.

	FBFilterManager lFilterManager;

	FBFilter* lFilter = lFilterManager.CreateFilter( "OR - Filter Template" );

	// Set one of the filter property:
	FBPropertyDouble* lPropDouble = (FBPropertyDouble*)lFilter->PropertyList.Find( "Test Double" );
	if( lPropDouble )
	{
		(*lPropDouble) = 2.0;
	}

	// Now we can apply the filter on an FCurve.
	// ...

	// And when we are done, destroy it.
	lFilter->FBDelete();
	lFilter = NULL;
	```
	Sample Python code:

	```python
	from pyfbsdk import *

	# Create a filter of a known type. In this case the sample filter
	# provided with the samples: orfilter_template.

	lFilterManager = FBFilterManager()

	lFilter = lFilterManager.CreateFilter( 'OR - Filter Template' );

	# Set one of the filter property:
	lPropDouble = lFilter.PropertyList.Find( 'Test Double' );
	if lPropDouble: lPropDouble.Data = 2.0

	# Now we can apply the filter on an FCurve.
	# ...

	# And when we are done, destroy it.
	lFilter.FBDelete()
	```"""
	FilterTypeNames:FBStringList
	"""List of available filters."""
	def CreateFilter(self,FilterTypeName:str,/)->FBFilter:
		"""Create a filter instance according to the filter type requested.

		### Parameters:
			- FilterTypeName: String describing the type of the desired filter, as obtained from list FilterTypeNames.

		### Returns:
		A pointer to a filter instance, or a NULL if the type name was invalid."""
		...
	def __init__(self):...
class FBFolderPopup:
	"""Folder Popup (for selecting a directory).

	[See samples: RenderLayers.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_rendering_0c_render_layers_8py-example.html) [BatchExportCharacterAnimationTool.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_batch_export_character_animation_tool_8py-example.html) [RenameFirstTakeOnMultipleFiles.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_rename_first_take_on_multiple_files_8py-example.html) [FBFolderPopup.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_f_b_folder_popup_8py-example.html)"""
	Caption:str
	"""Read Write Property: Caption to put in popup window."""
	Path:str
	"""Read Write Property: Path of folder selected."""
	def Execute(self)->bool:
		"""Execute folder popup.

		### Returns:
		true if OK is clicked by user."""
		...
	def __init__(self):...
class FBMatrix:
	"""[FBMatrix](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_matrix.html "FBMatrix class.") class.

	Four x Four (double) Matrix.

	This class creates a list like object, which can be modified using the list protocol method. But unlike lists, its length is fixed: it always contain 16 floating point values. Thus it does not support the any list methods that would affect its length. The values within can be changed, usually via the bracket operator.

	```python
	# Supported list protocol methods:
	mat = FBMatrix()
	len(mat)
	print(mat[13])
	mat[12] = 1.0
	```
	### Warning:
	The implementation of this 4x4 matrix uses a simple list of 16 elements, not a list of 4 vectors of 4 elements.*

	Slicing is not supported by this object.

	[See sample: Matrix.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_matrix_8py-example.html)"""
	def CopyFrom(self,arg2:FBMatrix,/)->FBMatrix:...
	def GetBufferAddress(self)->int:...
	def Identity(self)->None:
		"""Load identity matrix."""
		...
	def Inverse(self)->None:
		"""Get Inversed matrix.

		### Returns:
		the matrix Inversed."""
		...
	def InverseProduct(self,Matrix:FBMatrix,/)->None:
		"""InverseProduct Matrix.

		### Parameters:
			- Matrix: Matrix to Product.

		### Returns:
		result matrix."""
		...
	def IsEqual(self,arg2:FBMatrix,/)->bool:...
	def NotEqual(self,arg2:FBMatrix,/)->bool:...
	def Set(self,Value:list,/)->None:
		"""Set matrix from an array.

		### Parameters:
			- Value: Array to intialize matrix from."""
		...
	def Transpose(self)->None:
		"""Get Transposed matrix.

		### Returns:
		the matrix Transposed."""
		...
	def Validate(self)->bool:
		"""Validated matrix.

		### Returns:
		true if matrix Validated."""
		...
	def __add__(self,arg2:FBMatrix,/)->FBMatrix:...
	def __getitem__(self,Index:int,/)->float:
		"""Returns the ith component Corresponds to python: print matrix[1].

		### Parameters:
			- Index: Index of the components to get (0 to 15)

		### Returns:
		Matrix element value"""
		...
	def __iadd__(self,arg2:FBMatrix,/)->FBMatrix:...
	@overload
	def __imul__(self,arg2:FBMatrix,/)->FBMatrix:...
	@overload
	def __imul__(self,arg2,/)->FBMatrix:...
	@overload
	def __init__(self):
		"""Constructor Initializes matrix to identity."""
		...
	@overload
	def __init__(self,Value:list,/):
		"""### Parameters:
			- Value: Array to intialize matrix from."""
		...
	@overload
	def __init__(self,Matrix:FBMatrix,/):
		"""Copy Constructor.

		### Parameters:
			- Matrix: Matrix to copy."""
		...
	def __isub__(self,arg2:FBMatrix,/)->FBMatrix:...
	def __len__(self)->int:
		"""Returns the number of elements.

		Corresponds to python: len(object)"""
		...
	@overload
	def __mul__(self,arg2:FBMatrix,/)->FBMatrix:...
	@overload
	def __mul__(self,arg2,/)->FBMatrix:...
	def __neg__(self)->FBMatrix:...
	def __setitem__(self,Index:int,ComponentValue:float,/):
		"""Sets the ith components Corresponds to python: color[1] = 0.5.

		### Parameters:
			- Index: Index of the components to set (0 to 15)
			- ComponentValue: Value of component to set"""
		...
	def __sub__(self,arg2:FBMatrix,/)->FBMatrix:...
	def __iter__(self)->Iterator[float]:...
class FBModelList:
	"""[FBModelList](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model_list.html "FBModelList class.") class.

	This class implements a special sort of list that can only contain instances of [FBModel](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model.html "Model class.") objects. Users can query the content of the list with the bracket operator.

	```python
	# Supported list protocol methods:
	l = FBModelList()
	len(l)
	print(l[0])
	```"""
	def Add(self,Model:FBModel,/)->None:
		"""Append a new modle at the end of the list.

		### Parameters:
			- Model: model to add to the list."""
		...
	def Clear(self)->None:
		"""Empty the list from all models."""
		...
	def GetCount(self)->int:
		"""Get number of models in list."""
		...
	def GetModel(self,Index:int,/)->FBModel:
		"""Get the ith model in list.

		### Parameters:
			- Index: index of modle to get (0 based).

		### Returns:
		The pIndex model"""
		...
	def __getitem__(self,Index:int,/)->FBModel:
		"""Returns the ith component Corresponds to python: print l[1].

		### Parameters:
			- Index: Index of the components to get

		### Returns:
		Model element value"""
		...
	def __init__(self):...
	def __len__(self)->int:
		"""Returns the number of elements.

		Corresponds to python: len(object)"""
		...
	def append(self,Model:FBModel,/)->None:
		"""Append a new modle at the end of the list.

		### Parameters:
			- Model: model to add to the list."""
		...
	def count(self)->int:
		"""Get number of models in list."""
		...
	def removeAll(self)->None:
		"""Empty the list from all models."""
		...
	def __iter__(self)->Iterator[FBModel]:...
class FBMultiLangManager:
	"""Language manager.

	The class [FBMultiLangManager](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_multi_lang_manager.html "Language manager.") indicates the supported languages and allows to query and change the current language.The support for localization is done using conversion tables from internal names to language specific names, so that they can be used in the GUI and other human readable contexts.At this time, changing the current language will not affect the GUI. Only calls to functions '[FBGetMultiLangText()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/namespacepyfbsdk.html#a37519838cb5377d7112a3ef14afa583a "Name lookup in the context of an object.")' will be affected.The following sample code lists the names of the supported languages:Python sample code:

	```python
	from pyfbsdk import *

	lManager = FBMultiLangManager()
	print('Current localization language: ', lManager.GetCurrentLanguage())
	print('Supported languages:')
	for lLanguage in lManager.Languages:
		print('  ', lLanguage)
	```
	C++ sample code:

	```c++
	FBMultiLangManager lManager;
	FBTrace( "Current localization language: %s\\n", lManager.GetCurrentLanguage());
	FBTrace( "Supported languages:\\n" );

	int lIdx = 0;
	while( lIdx < lManager.Languages.GetCount())
	{
	 FBTrace( "  %s\\n", lManager.Languages[lIdx++] );
	}
	```"""
	Languages:FBStringList
	"""List of available languages."""
	def GetCurrentLanguage(self)->str:
		"""Obtain the current language.

		Query the current language used for the GUI.
		### Returns:
		Will return the string associated with the current language used."""
		...
	def SetCurrentLanguage(self,Language:str,/)->bool:
		"""Set the current language.

		Change the current language to another available language.
		### Parameters:
			- Language: The string corresponding to the desired language, as defined in property Languages.

		### Returns:
		Indicate if the change of language was successful.
		### Warning:
		Setting the current language will affect the lookup done with the functions FBGetMultiLangText, but will not have any effect on the GUI."""
		...
	def __init__(self):...
class FBNormal:
	@overload
	def CopyFrom(self,arg2:FBNormal,/)->FBNormal:...
	@overload
	def CopyFrom(self,arg2:list,/)->FBNormal:...
	def CrossProduct(self,arg2:FBNormal,/)->FBNormal:...
	def DotProduct(self,arg2:FBNormal,/)->float:...
	def GetBufferAddress(self)->int:...
	def GetList(self)->list:...
	def IsEqual(self,arg2:FBNormal,/)->bool:...
	def Length(self)->float:...
	def Normalize(self)->FBNormal:...
	def NotEqual(self,arg2:FBNormal,/)->bool:...
	def SquareLength(self)->float:...
	@overload
	def __add__(self,arg2:FBNormal,/)->FBNormal:...
	@overload
	def __add__(self,arg2,/)->FBNormal:...
	def __getitem__(self,arg2,/)->float:...
	@overload
	def __iadd__(self,arg2:FBNormal,/)->FBNormal:...
	@overload
	def __iadd__(self,arg2,/)->FBNormal:...
	@overload
	def __idiv__(self,arg2:FBNormal,/)->FBNormal:...
	@overload
	def __idiv__(self,arg2,/)->FBNormal:...
	@overload
	def __imul__(self,arg2:FBNormal,/)->FBNormal:...
	@overload
	def __imul__(self,arg2,/)->FBNormal:...
	@overload
	def __init__(self):...
	@overload
	def __init__(self,arg2:FBNormal,/):...
	@overload
	def __init__(self,arg2:float,arg3:float,arg4:float,/):...
	@overload
	def __init__(self,arg2,/):...
	@overload
	def __init__(self,arg2:list,/):...
	@overload
	def __isub__(self,arg2:FBNormal,/)->FBNormal:...
	@overload
	def __isub__(self,arg2,/)->FBNormal:...
	def __len__(self)->int:...
	@overload
	def __mul__(self,arg2:FBNormal,/)->FBNormal:...
	@overload
	def __mul__(self,arg2,/)->FBNormal:...
	def __neg__(self)->FBNormal:...
	def __setitem__(self,arg2,arg3:float,/):...
	@overload
	def __sub__(self,arg2:FBNormal,/)->FBNormal:...
	@overload
	def __sub__(self,arg2,/)->FBNormal:...
	@overload
	def __truediv__(self,arg2:FBNormal,/)->FBNormal:...
	@overload
	def __truediv__(self,arg2,/)->FBNormal:...
	def __iter__(self)->Iterator[float]:...
class FBObjectPoseMirrorOptions:
	"""[FBObjectPoseMirrorOptions](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_object_pose_mirror_options.html "FBObjectPoseMirrorOptions class.") class.

	This class exposes the object used to store the options for the mirror of an object pose."""
	mMirrorPlaneEquation:FBVector4d
	"""Equation of the mirror plane."""
	def ClearFlag(self)->None:
		"""Clear all flags."""
		...
	def GetFlag(self,Flag:FBObjectPoseMirrorOptionsFlag,/)->bool:
		"""Get a flag value.

		### Parameters:
			- Flag: Flag to get.

		### Returns:
		Value of the flag."""
		...
	def SetFlag(self,Flag:FBObjectPoseMirrorOptionsFlag,Value:bool,/)->None:
		"""Set a flag value.

		### Parameters:
			- Flag: Flag to set.
			- Value: Value to set."""
		...
	def __init__(self):...
class FBObjectPoseOptions:
	"""[FBObjectPoseOptions](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_object_pose_options.html "FBObjectPoseOptions class.") class.

	This class exposes the object used to store the options for operations on object poses."""
	mPoseTransformType:FBPoseTransformType
	"""Transform type (Local, Global or LocalRef)."""
	mReferenceGRM:FBMatrix
	"""Global rotation matrix of reference object."""
	mReferenceGSM:FBMatrix
	"""Global scaling matrix of reference object."""
	mReferenceGT:FBVector4d
	"""Global translation vector of reference object."""
	def ClearFlag(self)->None:
		"""Clear all flags."""
		...
	def GetFlag(self,Flag:FBObjectPoseOptionsFlag,/)->bool:
		"""Get a flag value.

		### Parameters:
			- Flag: Flag to get.

		### Returns:
		Value of the flag."""
		...
	def SetFlag(self,Flag:FBObjectPoseOptionsFlag,Value:bool,/)->None:
		"""Set a flag value.

		### Parameters:
			- Flag: Flag to set.
			- Value: Value to set."""
		...
	def __init__(self):...
class FBPickInfosList:
	"""[FBPickInfosList](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_pick_infos_list.html "FBPickInfosList class.") class.

	This class implements a special sort of list that can only contains a pick info which is a tuple<FBModel, FBVector3d>. A pick info give the position ([FBVector3d](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_vector3d.html "Vector3d class.")) and the model ([FBModel](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model.html "Model class.")) that was pick on screen.

	To users [FBPickInfosList](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_pick_infos_list.html "FBPickInfosList class.") behave like a typle, since it is not possible to add new objects in the list. Only methods or function that uses [FBPickInfosList](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_pick_infos_list.html "FBPickInfosList class.") as argument can insert new objects. Users can query the content of the list with the bracket operator.

	```python
	# Supported list protocol methods:
	l = FBPickInfosList()
	len(l)

	# tuple unpacking of pick infos.
	model, vector = l[0]
	```"""
	def GetCount(self)->int:...
	def GetPickedModel(self,arg2,/)->Any:...
	def __getitem__(self,Index:int,/)->tuple[FBModel,FBVector3d]:
		"""Returns the ith component Corresponds to python: print l[1].

		### Parameters:
			- Index: Index of the components to get

		### Returns:
		PickInfos element value. A Pick info is a tuple<FBModel, FBVector3d>"""
		...
	def __init__(self):...
	def __len__(self)->int:
		"""Returns the number of elements.

		Corresponds to python: len(object)"""
		...
	def count(self)->int:...
	def __iter__(self)->Iterator[tuple[FBModel,FBVector3d]]:...
class FBPlotOptions:
	"""Option parameters for plotting.

	[See samples: PlotNonSelectedCharStoryTracks.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_plot_non_selected_char_story_tracks_8py-example.html) [PlotSelectedCharStoryTracks.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_plot_selected_char_story_tracks_8py-example.html)"""
	ConstantKeyReducerKeepOneKey:bool
	"""Read Write Property: Should the constant key reducer keep at least one key?"""
	EvaluateDeformation:bool
	"""Read Write Property: Should we evaluate deformation while plotting? This is useful when there is a dependency with the deformation. Disabled by default."""
	PlotAllTakes:bool
	"""Read Write Property: Should we plot all takes?"""
	PlotAuxEffectors:bool
	"""Read Write Property: Should we plot aux effectors?"""
	PlotLockedProperties:bool
	"""Read Write Property: Should we plot locked properties?"""
	PlotOnFrame:bool
	"""Read Write Property: Should we plot on frame?"""
	PlotPeriod:FBTime
	"""Read Write Property: The plot period (1/fps)."""
	PlotTangentMode:FBPlotTangentMode
	"""Read Write Property: The tangent mode for plotted curve."""
	PlotTranslationOnRootOnly:bool
	"""Read Write Property: Should we plot the translation on root only?"""
	PreciseTimeDiscontinuities:bool
	"""Read Write Property: Should we use precise time discontinuities?"""
	RotationFilterToApply:FBRotationFilter
	"""Read Write Property: The rotation filter to apply."""
	UseConstantKeyReducer:bool
	"""Read Write Property: Should we use a constant key reducer with the filter?"""
	def __init__(self):...
class FBPlugList:
	def GetCount(self)->int:...
	def __getitem__(self,arg2,/)->Any:...
	def __init__(self):...
	def __len__(self)->int:...
	def __iter__(self)->Iterator[Any]:...
class FBProfileTaskCycle:
	"""[FBProfileTaskCycle](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_profile_task_cycle.html "FBProfileTaskCycle.").

	Real-time profiling information for a specific task. Profiling information can be collected for:Evaluation: models, constraints, characters, story tracksDevices: DeviceIONotify, DeviceEvaluationNotifyRendering: renderer, render passes (like: Translucent, TranslucentZSort, Selected, OtherPrimitive, SelectiveLighting, etc)SDKInternal synchronization (idle callback, buffer swap, waiting on evaluation to finish before starting new rendering)When profiling a scene within a MotionBuilder session you can discover what tasks are being performed when and for how long. You can use this information to troubleshoot lengthy or repetitive actions, and use MotionBuilder more efficiently.A task is defined as a definite piece of work within MotionBuilder such as the evaluation of a character. If the same task is run numerous times it is called a task cycle. From within a scene, the hierary and dependents of the scene make up the task cycles. A task cycle spends its time computing a specific task within a task parent cycle.A task parent cycle is a hierarchy of individual task cycles, where the parent and child relationship is known to MotionBuilder and displayed in the profiling center.For example, these are all task cycles which are all parented to each other; Eval is parent of TransformNode_Active, which is a parent of Constraint, which is a parent of Character, which is in turn a parent of TransformNode_Active.This is because the evaluation is called for one model which triggers evaluation of the character which then calls the evaluation of the rest of IK/FK models.When an evaluation starts, it calls the evaluation of the character, the time will be computed for time spent on the sample. Then possibly another character is evaluated, so again the time will be computed for the time spent on this sample. This time will be added to the previous sample since that evaluation has not finished yet. The evaluation here is parented, since they both have started but not finished, all children samples are summed. When the evaluation stops, you change the sample for the children.Note: The evaluation dependency/order will be different for each scene.As you can see profiling of task cycles is done by collecting samples. Samples are added to one inside parent sample. The number of samples collected is controlled by the profiler buffer size property.Here are the steps to add profiling into a constraint, a device, or any other class that uses real-time evaluation: 1) Declare FBProfiler_CreateTaskCycle( MyConstraint, 0.5, 0.5, 0.5 ) in MyConstraint.cxx, before the constructor and AnimationNodeNotify function. 2) Set up FBProfiling_SetupTaskCycle( MyConstraint ) in the constuctor MyConstraint::MyConstraint(). 3) At the beginning of MyConstraint::AnimationNodeNotify create the variable: FBProfilerHelper lProfiling( FBProfiling_TaskCycleIndex( MyConstraint ), pEvaluateInfo ); The sample for task will start at the creation of FBProfilerHelper object and stop at the destruction of this object, when returning from AnimationNodeNotify will be done."""
	def GetAvgMinMaxUsage(self)->tuple:
		"""Get the task cycle's average, minimum and maximum usage.

		Results will vary on buffer size. When profiling is disabled all values are set to 1.
		### Parameters:
			- Avg: Average time spend for computation of task (in micro seconds).
			- Min: Minimum time spend for computation of task (in micro seconds).
			- Max: Maximum time spend for computation of task (in micro seconds)."""
		...
	def GetChild(self,Index:int,/)->FBProfileTaskCycle:
		"""Get child task based on specific index.

		Can return NULL if child index is not used.
		### Parameters:
			- Index: Child index.

		### Returns:
		Child at given index."""
		...
	def GetChildCount(self)->int:
		"""Get number of child tasks.

		Task cycles are organized in a hierarchy which is dependent on the scene. Samples can be cumulative in the parent task cycle, or independent. For example, all character evaluation samples will be cumulated in one evaluation cycle.
		### Returns:
		Number of child tasks."""
		...
	def GetColor(self)->FBColor:
		"""Get the color of the task cycle.

		Used in profiling Center for drawing."""
		...
	def GetIndex(self)->int:
		"""Get the unique registration index for each cycle."""
		...
	def GetName(self)->str:
		"""Get the name of task cycle."""
		...
	def IsStarted(self)->bool:
		"""Test to see if sampling has started."""
		...
class FBProfileTimeEvent:
	"""[FBProfileTimeEvent](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_profile_time_event.html "FBProfileTimeEvent.").

	Time event information is collected during sampling (activated with a property in [FBProfiler](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_profiler.html "FBProfiler.") ActiveSampling). Events that can be collected are: render, evaluation, model evaluation, model deformation, synchronization of evaluation and rendering, playback commands, etc.Sampling will stop when the buffers maximum size is reached (maximum is 10MB).Currently users are not able to register any new events from ORSDK/python"""
	def GetColor(self)->FBColor:
		"""Get the color assigned to the event."""
		...
	def GetComment(self)->str:
		"""Get the comment for the event.

		Comments are not editable."""
		...
	def GetThreadID(self)->int:
		"""Get the thread ID used in the event execution."""
		...
	def GetTime(self)->FBTime:
		"""Get the time when the event occurred."""
		...
	def GetTypeName(self)->str:
		"""Get the event registered type name."""
		...
	def IsSingleEvent(self)->bool:
		"""Three types of events exits: single, start and end.

		Some actions that takes more time to execute or when other events can occur inbetween are collected with start time event at begin and end time event at finish."""
		...
class FBPropertyListAnimationNode:
	"""List of animation nodes. List: AudioClip"""
	def FindByLabel(self,NodeLabel:str,/)->FBAnimationNode:
		"""Returns the animation node from its label.

		### Parameters:
			- NodeLabel: Label of the searched animation node.

		### Returns:
		AnimationNode found."""
		...
	def __getitem__(self,Index:int,/)->FBAnimationNode:...
	def __len__(self)->int:...
	def __iter__(self)->Iterator[FBAnimationNode]:...
class FBPropertyListDeviceInstrument:
	"""List of instruments. PropertyList: Device optical marker"""
	def __getitem__(self,Index:int,/)->FBDeviceInstrument:...
	def __len__(self)->int:...
	def __iter__(self)->Iterator[FBDeviceInstrument]:...
class FBPropertyListDeviceOpticalMarker:
	def __getitem__(self,Index:int,/)->FBDeviceOpticalMarker:...
	def __len__(self)->int:...
	def __iter__(self)->Iterator[FBDeviceOpticalMarker]:...
class FBPropertyListFCurveKey:
	"""List of FCurveKey. List: FileReference"""
	def __getitem__(self,Index:int,/)->FBFCurveKey:...
	def __len__(self)->int:...
	def __iter__(self)->Iterator[FBFCurveKey]:...
class FBPropertyListManipulator:
	"""PropertyList: Device optical marker"""
	def __getitem__(self,Index:int,/)->FBManipulator:...
	def __len__(self)->int:...
	def __iter__(self)->Iterator[FBManipulator]:...
class FBPropertyListMarkerSegment:
	"""PropertyList: MarkerSet.

	These classes are under development and may change dramatically between versions."""
	def __getitem__(self,arg2,/)->FBOpticalSegment:...
	def __len__(self)->int:...
	def __iter__(self)->Iterator[FBOpticalSegment]:...
class FBPropertyListModelMarkerOptical:
	"""PropertyList: ModelOptical."""
	def __getitem__(self,Index:int,/)->FBModelMarkerOptical:...
	def __len__(self)->int:...
	def __iter__(self)->Iterator[FBModelMarkerOptical]:...
class FBPropertyListModelTemplate:
	"""PropertyList: ModelTemplateBinding."""
	def __getitem__(self,Index:int,/)->FBModelTemplate:...
	def __len__(self)->int:...
	def __iter__(self)->Iterator[FBModelTemplate]:...
class FBPropertyListModelTemplateBinding:
	"""List: MotionClip

	PropertyList: MotionClip"""
	def __getitem__(self,arg2,/)->Any:...
	def __len__(self)->int:...
	def __iter__(self)->Iterator[Any]:...
class FBPropertyListOpticalGap:
	"""PropertyList: Device optical marker"""
	def __getitem__(self,Index:int,/)->FBOpticalGap:...
	def __len__(self)->int:...
	def __iter__(self)->Iterator[FBOpticalGap]:...
class FBPropertyListOpticalSegment:
	"""PropertyList: Physical properties"""
	def __getitem__(self,Index:int,/)->FBOpticalSegment:...
	def __len__(self)->int:...
	def __iter__(self)->Iterator[FBOpticalSegment]:...
class FBPropertyListRigidBody:
	"""PropertyList: Device optical marker"""
	def __getitem__(self,Index:int,/)->FBRigidBody:...
	def __len__(self)->int:...
	def __iter__(self)->Iterator[FBRigidBody]:...
class FBPropertyListRigidBodyMarkers:
	"""List: Set"""
	def __getitem__(self,arg2,/)->Any:...
	def __len__(self)->int:...
	def __iter__(self)->Iterator[Any]:...
class FBPropertyManager:
	"""Property Manager.

	The property manager exists in all [FBComponent](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html "MotionBuilder SDK base class.") objects, and contains an array of all the registered properties. These properties may be SDK properties, internal properties or both."""
	def Find(self,PropertyName:str,MultilangLookup:bool=True,/)->FBProperty:
		"""Find a property, based on its name.

		### Parameters:
			- PropertyName: Name of property to look for.
			- MultilangLookup: When searching, indicate if the name lookup should also be done on the property name as shown in the GUI. (default = true)

		### Returns:
		Handle to property found."""
		...
	def FindPropertiesByName(self,PropertyNamePattern:str,PropList:list,MultilangLookup:bool=True,/)->None:
		"""This function will query the property list for properties fulfilling a particular name pattern.

		### Parameters:
			- PropertyNamePattern: Indicate the name pattern to search. This pattern can contain any amount of *. (ex: *tr*mod*scene )
			- PropList: List that contains the resulting properties matching the pattern
			- MultilangLookup: When searching, indicate if the name lookup should also be done on the property name as shown in the GUI. (default = true)

		### Note:
		The script FindPropertiesWithWildcard.py shows how to use this function."""
		...
	def __getitem__(self,Index:int,/)->FBProperty:...
	def __len__(self)->int:...
	def __iter__(self)->Iterator[FBProperty]:...
class FBPropertyStateEvent(FBEvent):
	"""This class is used when the state of a property tracked by the [FBFCurveEventManager](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_f_curve_event_manager.html "FCurve Event Manager Interface to the FBFCurveEventManager.") is changed."""
	EventType:FBPropertyStateEventType
	"""Read Only Property: Event type, please see the [FBPropertyStateEventType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_state_event_type.html "This enum indicates what modification was made to the animation of a tracked property....") for the possible types."""
	ParentComponent:FBComponent
	Property:FBProperty
	def __init__(self):
		"""### Parameters:
			- Event: Base event (internal) to obtain information from."""
		...
class FBPropertyViewDefinition:
	"""[FBProperty](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property.html "Generic application property.") View.

	View definition for one property."""
	def IsFolder(self)->bool:
		"""Is view a folder."""
		...
	def IsOpen(self)->bool:
		"""Is property view open at run time."""
		...
	def IsSaved(self)->bool:
		"""Is property view saved on view manager store."""
		...
	def SetOpen(self,pTrue:bool,ApplyUpHierarchy:bool,/)->None:
		"""Set view open/closed at run time."""
		...
	def SetSaved(self,pTrue:bool,ApplyUpHierarchy:bool,/)->None:
		"""Set view to be saved on view manager store."""
		...
class FBPropertyViewList:
	"""[FBProperty](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property.html "Generic application property.") View List.

	Hold list of description for view set."""
	def AddPropertyView(self,Property:FBProperty,Hierarchy:str,/)->FBPropertyViewDefinition:
		"""Add property view.

		### Parameters:
			- Property: Property to add.
			- Hierarchy: Hierarchy under which property view should be created, each level name is separated by dot (for example "Degrees of Freedom.Translation").

		### Returns:
		created object (should not be called on non editable view list)."""
		...
	def FindPropertyView(self,PropertyName:str,/)->FBPropertyViewDefinition:
		"""Find property view for pPropertyName in this list."""
		...
	def IsEditable(self)->bool:
		"""Is property view list editable."""
		...
	def RemovePropertyView(self,PropertyViewDefinition:FBPropertyViewDefinition,/)->bool:
		"""Remove property view from view list.

		### Parameters:
			- PropertyViewDefinition: Property view definition to destroy.

		### Returns:
		true when pPropertyViewDefinition got removed and free (should not be called on non editable view list)."""
		...
class FBPythonWrapper:
	"""Base class of [FBPlug](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_plug.html "Connections Basic Open Reality SDK Element.") in Python.

	This class act as a bridge between the ORSDK C++ world and the Python world. Since each Python objects wrap a ORSDK object we need a way to notify Python if the ORSDK object is destroyed.

	OnUnbind is used in this way: it notifies the user when the wrapped ORSDK objects is destroyed."""
	OnUnbind:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: Will notifier the user when the corresponding ORSDK objects is unbound from the PythonObject."""
class FBPlug(FBPythonWrapper):
	"""Connections Basic Open Reality SDK Element.

	Most elements that are available in the SDK inherit from this base class since [FBComponent](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html "MotionBuilder SDK base class.") and [FBProperty](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property.html "Generic application property.") inherit from [FBPlug](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_plug.html "Connections Basic Open Reality SDK Element."). Basically, all objects can be connected together because they are all "plugs". To simplify the graph, you can think of a "source" connection as a child, and a "destination" connection as a parent. Also, it is correct to assume that a source affect/work on its destination. For example, a shader applied on an object would be seen as the source while the object is the destination. So [FBPlug](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_plug.html "Connections Basic Open Reality SDK Element.") is a set of functions that enables you to control those connections with flexibility and ease.

	[See samples: FBConstraintManager.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_f_b_constraint_manager_8py-example.html) [FBFolder.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_f_b_folder_8py-example.html)"""
	ClassGroupName:str
	"""ClassGroupName of the object."""
	TypeInfo:int
	"""TypeInfo."""
	def BeginChange(self)->bool:...
	def ClassName(self)->str:...
	def ConnectDst(self,arg2:FBPlug,arg3:FBConnectionType|None=None,/)->bool:...
	def ConnectDstAt(self,arg2,arg3:FBPlug,arg4:FBConnectionType|None=None,/)->bool:...
	def ConnectSrc(self,arg2:FBPlug,arg3:FBConnectionType|None=None,/)->bool:...
	def ConnectSrcAt(self,arg2,arg3:FBPlug,arg4:FBConnectionType|None=None,/)->bool:...
	def DisconnectAllDst(self)->None:...
	def DisconnectAllSrc(self)->None:...
	def DisconnectDst(self,arg2:FBPlug,/)->bool:...
	def DisconnectDstAt(self,arg2,/)->bool:...
	def DisconnectSrc(self,arg2:FBPlug,/)->bool:...
	def DisconnectSrcAt(self,arg2,/)->bool:...
	def EndChange(self)->None:...
	def GetContentModified(self,arg2:FBPlugModificationFlag,/)->bool:...
	def GetDst(self,Index:int,/)->FBPlug:...
	def GetDstCount(self)->int:...
	def GetDstType(self,arg2,/)->FBConnectionType:...
	def GetOwned(self,Index:int,/)->FBPlug:...
	def GetOwnedCount(self)->int:...
	def GetOwner(self)->FBPlug:...
	def GetPlugConnectionModifiedList(self,arg2:FBPlugList,arg3:FBPlugModificationFlag,arg4,/)->int:...
	def GetSelfModified(self,arg2:FBPlugModificationFlag,/)->bool:...
	def GetSrc(self,Index:int,/)->FBPlug:...
	def GetSrcCount(self)->int:...
	def GetSrcType(self,arg2,/)->FBConnectionType:...
	def GetStatusFlag(self,arg2:FBPlugStatusFlag,/)->bool:...
	def Is(self,arg2,/)->bool:...
	def IsSDKComponent(self)->bool:...
	@overload
	def MoveSrcAt(self,arg2,arg3,/)->bool:...
	@overload
	def MoveSrcAt(self,arg2:FBPlug,arg3:FBPlug,/)->bool:...
	@staticmethod
	def PrintClassDefinitions()->None:...
	def ReplaceDstAt(self,arg2,arg3:FBPlug,/)->bool:...
	def ReplaceSrcAt(self,arg2,arg3:FBPlug,/)->bool:...
	def RevertModification(self,arg2:FBPlugModificationFlag|None=None,/)->bool:...
	def SetContentModified(self,arg2:FBPlugModificationFlag,arg3,/)->None:...
	def SetSelfModified(self,arg2:FBPlugModificationFlag,arg3,/)->None:...
	def SetStatusFlag(self,arg2:FBPlugStatusFlag,arg3,/)->None:...
	def SwapSrc(self,arg2,arg3,/)->bool:...
class FBRenderOptions:
	def GetIDBufferPickingAlphaThreshold(self)->float:
		"""Get IDBuffer Picking Alpha threshold.

		### Returns:
		ID Buffer picking alpha threshold value."""
		...
	def GetRenderFrameId(self)->int:
		"""Get Render Frame ID.

		### Returns:
		This return a new ID each time a new frame is drawn."""
		...
	def GetRenderingCamera(self)->FBCamera:
		"""Get the rendering camera."""
		...
	def GetViewerOptions(self)->FBViewingOptions:...
	def IsIDBufferPicking(self)->bool:...
	def IsIDBufferRendering(self)->bool:
		"""Get IDBuffer Rendering request status (for display or picking)

		### Returns:
		true if need to render Model (or subitem)'s UniqueColorID into GL Color Buffer."""
		...
	def IsOfflineRendering(self)->bool:
		"""Check if the render request comes from offline render mode (as opposed to viewport refresh).

		### Returns:
		true if the render comes from offline render mode."""
		...
class FBProperty(FBPlug):
	"""Generic application property.

	Property: Action Action property to trigger function.

	[FBProperty](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property.html "Generic application property.") objects cannot be instantiated by the user. Reference to a property can be obtained either via an instance of a [FBComponent](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html "MotionBuilder SDK base class.") object, or by calling the method 'Find()' of a [FBPropertyManager](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_manager.html "Property Manager."). The class [FBComponent](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html "MotionBuilder SDK base class.") has a [FBPropertyManager](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_manager.html "Property Manager.") data member named 'PropertyList'.

	When accessing a [FBProperty](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property.html "Generic application property.") object via its containing object, you can get or set (assuming it is not read-only) its value directly:

	```python
	lObject.Visibility = True
	```
	When accessing a property reference directly, its value is obtained via it's 'Data' member.

	```python
	lProp = lObject.PropertyList.Find( 'Visibility' )
	   if lProp: lProp.Data = True
	```
	The methods 'PropertyCreate()' and 'PropertyRemove' of the class [FBComponent](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html "MotionBuilder SDK base class.") can be used to modify an object's set of properties."""
	Data:Any
	"""Read Write Property: The property data value. Type of this depends on the subclass of [FBProperty](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property.html "Generic application property.") (ex: in a [FBPropertyInt](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_int.html), Data is of type int)."""
	Name:str
	"""Read Property: The property's name."""
	def AllowsLocking(self)->bool:
		"""AllowsLocking.

		### Returns:
		true if property can be locked"""
		...
	def AsString(self,Flag:FBDataAsStringFlag=FBDataAsStringFlag.kFBDataAsStringUI,/)->str:
		"""Get the property value as a string.

		### Parameters:
			- Flag: Indicates the returned string to be used for UI or storage. It defaults to kFBDataAsStringUI.

		### Returns:
		The string version of the property."""
		...
	def EnumList(self,Index:int,/)->str:
		"""Return the string of an enum value.

		### Parameters:
			- Index: Enum value to get string for.

		### Returns:
		String value of enum specified by pIndex."""
		...
	def GetEnumStringList(self,CreateIt:bool=False,/)->FBStringList:
		"""String list for enum properties.

		### Parameters:
			- CreateIt: Create a new list if necessary.

		### Returns:
		the pointer to the string list.."""
		...
	def GetMax(self)->float:
		"""GetMax.

		### Returns:
		Maximum value for the property."""
		...
	def GetMin(self)->float:
		"""GetMin.

		### Returns:
		Minimum value for the property."""
		...
	def GetName(self)->str:
		"""Get the property's name.

		### Returns:
		The property's name."""
		...
	def GetPropertyFlag(self,Flag:FBPropertyFlag,/)->bool:
		"""GetPropertyFlag.

		### Parameters:
			- Flag: Flag to test if it is True or False.

		### Returns:
		If the flag is True, the function returns True and vice-versa.
		### Warning:
		Flags are not saved into or read from a FBX file."""
		...
	def GetPropertyFlags(self)->int:
		"""GetPropertyFlags.

		### Returns:
		Return all flags at once."""
		...
	def GetPropertyType(self)->FBPropertyType:
		"""Get the property's type.

		### Returns:
		The property's type."""
		...
	def GetPropertyTypeName(self)->str:
		"""Get the property's type name.

		### Returns:
		The property's type name."""
		...
	def GetReferencedProperty(self)->FBProperty:
		"""Get the referenced property, in the case of this property is a reference property (see the [IsReferenceProperty()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property.html#ad452a44b96cabe2306c467b53d306635) method).

		### Returns:
		The referenced property, or a null pointer if this property is not a reference property."""
		...
	def GetSubMemberCount(self)->int:
		"""GetSubMemberCount.

		### Returns:
		Number of sub-members."""
		...
	def HasSomethingLocked(self)->bool:
		"""HasSomethingLocked.

		### Returns:
		true if property or any of its members is locked"""
		...
	def IsAnimatable(self)->bool:...
	def IsInternal(self)->bool:...
	def IsList(self)->bool:
		"""Verify if property is of this type.

		### Returns:
		true if property is of type."""
		...
	def IsLocked(self)->bool:
		"""IsLocked.

		### Returns:
		true if property is locked"""
		...
	def IsMaxClamp(self)->bool:
		"""Indicate if maximum value clamping will be applied on user input value.

		### Returns:
		true if property the value will be clamped to a maximum value."""
		...
	def IsMemberLocked(self,Index:int,/)->bool:
		"""IsMemberLocked.

		### Parameters:
			- Index: Index of the sub-member of the property to check.

		### Returns:
		true if property sub-member is locked"""
		...
	def IsMinClamp(self)->bool:
		"""Indicate if minimum value clamping will be applied on user input value.

		### Returns:
		true if property the value will be clamped to a minimum value."""
		...
	def IsObjectList(self)->bool:
		"""Indicate if is an instance of [FBPropertyListObject](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_list_object.html "List-like structure fo system elements.").

		### Warning:
		A [FBPropertyListObject](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_list_object.html "List-like structure fo system elements.") will also return true on a call to '[IsList()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property.html#a37da1d5c27b1223f6d1c30c5ebe6888f "Verify if property is of this type.")'."""
		...
	def IsReadOnly(self)->bool:
		"""Is property read-only?

		### Returns:
		true if property is read-only."""
		...
	def IsReferenceProperty(self)->bool:...
	def IsTextureConnectableProperty(self)->bool:...
	def IsUserProperty(self)->bool:...
	def ModifyPropertyFlag(self,Flag:FBPropertyFlag,Value:bool,/)->None:
		"""ModifyPropertyFlag.

		### Parameters:
			- Flag: The flag to switch to True or False.
			- Value: The value to set about this flag.

		### Warning:
		Flags are not saved into or read from a FBX file."""
		...
	def NotifyEnumStringListChanged(self)->None:
		"""Notify system that the enum list was modified."""
		...
	def OriValueAsString(self)->str:
		"""Get the property original value (before any modification) as string.

		### Returns:
		returns the original value of the property in string with format same as AsString(kDataAsStringPersistence)"""
		...
	def SetLocked(self,Locked:bool,/)->None:
		"""SetLocked.

		### Parameters:
			- Locked: True if the property is to be locked, false if it is to be unlocked."""
		...
	def SetMax(self,Max:float,ForceMaxClamp:bool=False,/)->None:
		"""SetMax.

		### Parameters:
			- Max: Maximum value of the property.
			- ForceMaxClamp: Force clamping to maximum value of the property."""
		...
	def SetMemberLocked(self,Index:int,Locked:bool,/)->None:
		"""SetMemberLocked.

		### Parameters:
			- Index: Index of the sub-member of the property to lock or unlock.
			- Locked: True if the sub-member is to be locked, false if it is to be unlocked."""
		...
	def SetMin(self,Min:float,ForceMinClamp:bool=False,/)->None:
		"""SetMin.

		### Parameters:
			- Min: Minimum value of the property.
			- ForceMinClamp: Force clamping to minimum value of the property."""
		...
	def SetName(self,Name:str,/)->None:
		"""Set the property's name.

		### Parameters:
			- Name: New name for the property."""
		...
	def SetString(self,String:str,/)->bool:
		"""Set the property value from a string.

		### Parameters:
			- String: String to set property value from, with format same as AsString(kFBDataAsStringPersistence)

		### Returns:
		True if it was possible."""
		...
class FBComponent(FBPlug):
	"""MotionBuilder SDK base class.

	[FBComponent](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html "MotionBuilder SDK base class.") defines common object characteristics, including creation and destruction methods. It is used to encapsulate internal application objects so they can be exposed to the SDK. It is also used as the base class to encapsulate objects with [FBProperty](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property.html "Generic application property.") data members and provides a scheme for property management. You cannot instantiate [FBProperty](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property.html "Generic application property.") objects. To reference a property, use an instance of an [FBComponent](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html "MotionBuilder SDK base class.") object. The methods [FBComponent::PropertyCreate](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html#a154c4f7b5a26f60b373d9bb4fa37dfb1 "Create user or dynamic property.") and [FBComponent::PropertyRemove](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html#ab54e85a44712cff01a617655269d3d16 "Remove a Property from the component's Property manager.") can be used to modify an object's properties. Basic operators are overloaded in [FBComponent](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html "MotionBuilder SDK base class."). The constructor and destructor are created and defined with macros in the header files. Objects inheriting from [FBComponent](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html "MotionBuilder SDK base class.") must define [FBComponent::FBCreate()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html#a7f105494ccd451ccd38c0fe0c5c2db6b "Open Reality Creation function."), and [FBComponent::FBDestroy()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html#a2df8268185f2274c0704f6c36dea792e "Open Reality destruction function."). All memory management issues for the component should also be addressed here. Destroy an object with [FBDelete()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html#aa85a55e68d7403dbd4238f3e30e83119 "Open Reality deletion function."). The code sample FBComponent.py shows how to get a handle on a scene object via its name.

	[See sample: ReplaceNamespace.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_replace_namespace_8py-example.html)"""
	Components:FBPropertyListComponent
	"""List: List of components."""
	FullName:str
	LongName:str
	"""Read Write Property: Name and namespace for object."""
	Name:str
	"""Read Write Property: Unique name of object. [See sample: RemoveSuffixFromNameOfSceneElements.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_remove_suffix_from_name_of_scene_elements_8py-example.html)"""
	OwnerNamespace:FBNamespace|None
	Parents:FBPropertyListComponent
	"""List: Parents."""
	PropertyList:FBPropertyManager
	"""Read Only Property: Manages all of the properties for the component."""
	Selected:bool
	"""Read Write Property: Selected property."""
	def DisableObjectFlags(self,Flags:FBObjectFlag,/)->None:
		"""Disable a specific Object Flags.

		### Parameters:
			- Flags: Flags to disable."""
		...
	def EnableObjectFlags(self,Flags:FBObjectFlag,/)->None:
		"""Enable a specific Object Flags.

		### Parameters:
			- Flags: Flags to enable."""
		...
	def FBCreate(self)->bool:
		"""Open Reality Creation function.

		### Returns:
		Outcome of creation (true/false)."""
		...
	def FBDelete(self)->None:
		"""Open Reality deletion function.

		[See sample: DeleteHierarchy.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_delete_hierarchy_8py-example.html)"""
		...
	def FBDestroy(self)->None:
		"""Open Reality destruction function."""
		...
	def GetObjectFlags(self)->FBObjectFlag:
		"""Get all Object Flags (concatenated).

		### Returns:
		Get all object flags in one call. Flags can be concatenated."""
		...
	def GetObjectStatus(self,Status:FBObjectStatus,/)->bool:
		"""Check to see if an object status is enabled.

		### Parameters:
			- Status: Status to query."""
		...
	def GetOwnerFileReference(self)->FBFileReference:
		"""Get the owner FileReference object.

		### Returns:
		the owner FileReference object"""
		...
	def HardSelect(self)->None:
		"""HardSelect.

		Selects the object, and emits a hard select event for UI update notification."""
		...
	def HasObjectFlags(self,Flags:FBObjectFlag,/)->bool:
		"""Check whether a specific object flag is enabled.

		### Parameters:
			- Flags: Flags to check if they are present.

		### Returns:
		True if all flags in pFlags are enabled."""
		...
	def ProcessNamespaceHierarchy(self,NamespaceAction:FBNamespaceAction,NamespaceName:str,ReplaceTo:str|None=None,AddRight:bool=True,/)->bool:
		"""ProcessNamespaceHierarchy.

		New Namespace name should only contains alphabet, digit and '_', Can't start with digit. This recursive function goes through the whole hierarchy (children) to add/replace the prefix. If you need to work on a single object, use the ProcessObjectPrefix function.
		### Parameters:
			- NamespaceAction: Which operation to do on the hierarchy (children).
			- NamespaceName: The Namespace name on Add/Delete or the prefix to replace in case of replace.
			- ReplaceTo: The new Namespace Name or NULL in case of add or delete.
			- AddRight: Whether to add the namespace on right-most or left-most side or other namespace.

		### Returns:
		return true if process successful."""
		...
	def ProcessObjectNamespace(self,NamespaceAction:FBNamespaceAction,NamespaceName:str,ReplaceTo:str|None=None,AddRight:bool=True,/)->bool:
		"""ProcessObjectNamespace.

		New Namespace name should only contains alphabet, digit and '_', Can't start with digit. This function is the same as ProcessNamespaceHierarchy except that it applies only on the current object and not to the object's children.
		### Parameters:
			- NamespaceAction: Which operation to do on the hierarchy (children).
			- NamespaceName: The Namespace name on Add/Delete or the prefix to replace in case of replace.
			- ReplaceTo: The new Namespace Name or NULL in case of add or delete.
			- AddRight: Whether to add the namespace on right-most or left-most side or other namespace.

		### Returns:
		return true if process successful."""
		...
	def PropertyAdd(self,Property:FBProperty,/)->int:
		"""Add a property to the component's property manager.

		### Parameters:
			- Property: The property to add to the property manager.

		### Returns:
		Index in the property array where property was inserted."""
		...
	def PropertyAddReferenceProperty(self,ReferenceProperty:FBProperty,/)->bool:
		"""Add a reference property to the component's property manager.

		### Parameters:
			- ReferenceProperty: The property to from an other object to add a reference to (property cannot be a custom ORSDK property).

		### Returns:
		True if the reference property could be added."""
		...
	def PropertyGetModifiedList(self,arg2:FBPlugModificationFlag,/)->FBPropertyList:
		"""Get list of properties which have been modified since last loading.

		### Parameters:
			- PropList: property list to hold the modified properties.
			- ModificationFlags: type of modification to query."""
		...
	def PropertyRemove(self,Property:FBProperty,/)->None:
		"""Remove a Property from the component's Property manager.

		If the property was dynamically allocated, it is deleted.
		### Parameters:
			- Property: The property to remove from the property manager."""
		...
	def SetObjectFlags(self,Flags:FBObjectFlag,/)->None:
		"""SetObjectFlags.

		### Parameters:
			- Flags: Set flag values. Note: this function overwrites all flags with those passed in parameter."""
		...
	def SetObjectStatus(self,Status:FBObjectStatus,Value:bool,/)->None:
		"""Enable/Disable a specific Object Status.

		### Parameters:
			- Status: Status to change.
			- Value: Value to change the status to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_int],DataType:str,Animatable:Literal[False],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyInt:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_int],DataType:str,Animatable:Literal[True],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyAnimatableInt:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_bool],DataType:str,Animatable:Literal[False],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyBool:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_bool],DataType:str,Animatable:Literal[True],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyAnimatableBool:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_float],DataType:str,Animatable:Literal[False],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyFloat:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_double],DataType:str,Animatable:Literal[False],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyDouble:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_double],DataType:str,Animatable:Literal[True],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyAnimatableDouble:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_charptr],DataType:str,Animatable:bool,IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyString:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_enum],DataType:str,Animatable:Literal[False],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyEnum:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_enum],DataType:str,Animatable:Literal[True],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyAnimatableEnum:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_Time],DataType:str,Animatable:Literal[False],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyTime:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_Time],DataType:str,Animatable:Literal[True],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyAnimatableTime:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_TimeCode],DataType:str,Animatable:Literal[False],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyTimeCode:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_TimeCode],DataType:str,Animatable:Literal[True],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyAnimatableTimeCode:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_object],DataType:str,Animatable:Literal[False],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyListObject:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_event],DataType:str,Animatable:Literal[False],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBProperty:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_stringlist],DataType:str,Animatable:Literal[False],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyStringList:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_Vector4D],DataType:str,Animatable:Literal[False],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyVector4d:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_Vector4D],DataType:str,Animatable:Literal[True],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyAnimatableVector4d:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_Vector3D],DataType:str,Animatable:Literal[False],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyVector3d:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_Vector3D],DataType:str,Animatable:Literal[True],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyAnimatableVector3d:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_ColorRGB],DataType:str,Animatable:Literal[False],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyColor:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_ColorRGB],DataType:str,Animatable:Literal[True],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyAnimatableColor:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_ColorRGBA],DataType:str,Animatable:Literal[False],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyColorAndAlpha:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_ColorRGBA],DataType:str,Animatable:Literal[True],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyAnimatableColorAndAlpha:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_Action],DataType:str,Animatable:Literal[False],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyAction:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_Action],DataType:str,Animatable:Literal[True],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyAnimatableAction:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_Vector2D],DataType:str,Animatable:Literal[False],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyVector2d:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:Literal[FBPropertyType.kFBPT_Vector2D],DataType:str,Animatable:Literal[True],IsUser:bool,ReferenceSource:FBProperty|None,/)->FBPropertyAnimatableVector2d:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
	@overload
	def PropertyCreate(self,Name:str,Type:FBPropertyType,DataType:str,Animatable:bool,IsUser:bool,ReferenceSource:FBProperty|None,/)->FBProperty|None:
		"""Create user or dynamic property.

		### Parameters:
			- Name: The name of the property.
			- Type: Type of the property. See enum [FBPropertyType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_type.html "Property types.").
			- DataType: DataType of the property.
			- Animatable: To specify if the property can be animated.
			- IsUser: To specify if the property is available as a custom property or dynamic and attached to the object.
			- ReferenceSource: Specifies the property that a reference refers to."""
		...
class FBPropertyVector4d(FBProperty):
	Data:FBVector4d
	def __getitem__(self,arg2,/)->float:...
	def __len__(self)->int:...
	def __setitem__(self,arg2,arg3,/):...
	def __iter__(self)->Iterator[float]:...
class FBReferenceTime(FBComponent):
	"""Reference time class.

	Interface for the reference time used by MotionBuilder The reference time are identified using unique ID. A unique ID is given when a reference time is added to the system with [Add()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_reference_time.html#a2b07a7c9e383b708bfe251ae6e988d5c "Add a reference time to list."). Instead of using a linear array to store the reference time, a map is used to link an ID to a reference time. The available IDs can be queried using [GetUniqueIDList()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_reference_time.html#a66ea5d3b1811a945a435e430b46f507b "Get list of currently available IDs.")."""
	Count:int
	"""Read Only Property: Number of reference times."""
	CurrentTimeReferenceID:int
	"""Read Write Property: Current reference time ID"""
	ItemIndex:int
	"""Read Write Property: Current reference time index."""
	def Add(self,Name:str,/)->int:
		"""Add a reference time to list.

		### Parameters:
			- Name: Name of time to add the list.

		### Returns:
		Unique ID of the reference time, use this ID to access the reference time in the future."""
		...
	def GetReferenceTimeName(self,ID:int,/)->str:
		"""Get the name of a time reference.

		### Parameters:
			- ID: ID of the time reference whose name will be returned.

		### Returns:
		Name of reference time with the pID."""
		...
	def GetTime(self,ID:int,System:FBTime,/)->FBTime:
		"""Get a reference time.

		### Parameters:
			- ID: ID of reference to get.
			- System: System time.

		### Returns:
		Reference time at pIndex."""
		...
	def GetUniqueIDList(self)->list:
		"""Get list of currently available IDs.

		### Parameters:
			- IDArray: Array that will be filled with the requested IDs."""
		...
	def Remove(self,ID:int,/)->None:
		"""Remove a reference time from the list.

		### Parameters:
			- ID: ID of reference time to remove."""
		...
	def SetTime(self,ID:int,ReferenceTime:FBTime,System:FBTime,/)->None:
		"""Set a reference time.

		### Parameters:
			- ID: ID of reference time set.
			- ReferenceTime: Time to use as reference time.
			- System: System time."""
		...
	def __init__(self):...
class FBPropertyViewManager(FBComponent):
	"""[FBProperty](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property.html "Generic application property.") View Manager.

	Interface to create new property views. There are two ways of creating properties view:on library load using AddPropertyView, RemovePropertyView, HidePropertyView - example can be found in \\OpenRealitySDK\\Samples\\constraints\\CharacterSolver\\HIK2014Solverwhile application is running using [FBPropertyViewList](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_view_list.html "FBProperty View List.") - example can be found in \\bin\\config\\Scripts\\Samples\\Properties\\PropertyViewManager.py

	[See sample: PropertyViewManager.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_properties_0c_property_view_manager_8py-example.html)"""
	def AddPropertyView(self,ClassName:str,PropertyName:str,Hierarchy:str,/)->FBPropertyViewDefinition:
		"""Add property view to global ('All') view set.

		### Parameters:
			- ClassName: Property owner class name (pClassName if won't be found, a new entry for this class is created).
			- PropertyName: Property name.
			- Hierarchy: Hierarchy under which property view should be created, each level name is separated by dot (for example "Degrees of Freedom.Translation").

		### Returns:
		created object.
		### Note:
		This call should be used on library registration, doesn't cause tool refresh."""
		...
	def CreatePropertyList(self,Object:FBComponent,ViewType:FBPropertyViewType,Name:str,/)->FBPropertyViewList:
		"""Create new property view list.

		### Parameters:
			- Object: Property view set attached to.
			- ViewType: Property view set type.
			- Name: Name for new view list.

		### Returns:
		created object."""
		...
	def FindPropertyList(self,Object:FBComponent,ViewType:FBPropertyViewType,Name:str,/)->FBPropertyViewList:
		"""Find property view list.

		### Parameters:
			- Object: Property view set attached to.
			- ViewType: Property view set type.
			- Name: Name of view set.

		### Returns:
		Found property view set object or NULL."""
		...
	def HidePropertyView(self,ClassName:str,PropertyName:str,Hide:bool,/)->None:
		"""Hide property view in global ('All') view set.

		### Parameters:
			- ClassName: Property owner class name.
			- PropertyName: Property name.
			- Hide: Show/Hide.

		### Note:
		This call should be used on library registration, doesn't cause tool refresh."""
		...
	def RefreshPropertyViews(self)->None:
		"""Force refresh of browsing property tool."""
		...
	def RemovePropertyList(self,Object:FBComponent,ViewType:FBPropertyViewType,Name:str,/)->bool:
		"""Remove property view list (only if editable).

		### Parameters:
			- Object: Property view set attached to.
			- ViewType: Property view set type.
			- Name: Name for property view list.

		### Returns:
		True if successful."""
		...
	def RemovePropertyView(self,ClassName:str,PropertyName:str,/)->bool:
		"""Remove property view from global ('All') view set.

		### Parameters:
			- ClassName: Property owner class name.
			- PropertyName: Property name.

		### Returns:
		true if succeed (should not be call on system views).
		### Note:
		This call should be used on library registration, doesn't cause tool refresh."""
		...
	def __init__(self):...
class FBPropertyVector3d(FBProperty):
	Data:FBVector3d
	def __getitem__(self,arg2,/)->float:...
	def __len__(self)->int:...
	def __setitem__(self,arg2,arg3,/):...
	def __iter__(self)->Iterator[float]:...
class FBPropertyVector2d(FBProperty):
	Data:FBVector2d
	def __getitem__(self,arg2,/)->float:...
	def __len__(self)->int:...
	def __setitem__(self,arg2,arg3,/):...
	def __iter__(self)->Iterator[float]:...
class FBPropertyTimeCode(FBProperty):
	Data:FBTimeCode
class FBPropertyTime(FBProperty):
	Data:FBTime
class FBPropertyStringList(FBProperty):
	"""```python
	# Supported list protocol methods:
	 len(propertyStringList)
	 component= propertyStringList[0]
	 propertyStringList[0] = my_string

	 if my_string in propertyStringList:
		print("it is contained!")
	 del propertyStringList[0]
	```"""
	Data:list[str]
	def __contains__(self,Value:str,/)->bool:
		"""Check if a FCComponent is already in PropertyList Corresponds to python: if object in propertyList:

		### Parameters:
			- Value: Component to check for inclusion

		### Returns:
		Is the String contained or not?"""
		...
	def __delitem__(self,arg2:int,/):...
	def __getitem__(self,Index:int,/)->str:
		"""Returns the ith component Corresponds to python: print v[1].

		### Parameters:
			- Index: Index of the components to get (0 to 2)

		### Returns:
		str component value."""
		...
	def __len__(self)->int:
		"""Returns the number of elements.

		Corresponds to python: len(object)
		### Returns:
		number of elements in list."""
		...
	def append(self,Value:str,/)->None:
		"""Append new str at end of list.

		### Parameters:
			- Value: to append"""
		...
	def count(self,Object:str,/)->int:
		"""Returns the number of elements.

		Corresponds to python: del propertyList[2]
		### Returns:
		number of elements in list."""
		...
	def findFromReference(self,Reference:int,/)->int:
		"""Find the index of an element from its attached reference.

		### Parameters:
			- Reference: Reference of searched object.

		### Returns:
		Returns the index of the element corresponding to reference."""
		...
	def getReferenceAt(self,Index:int,/)->int:
		"""Retrieve the reference of an object at ith position.

		### Parameters:
			- Index: Index of the object to find reference.

		### Returns:
		Returns the reference of the object."""
		...
	def insert(self,Index:int,Value:str,/)->None:
		"""Insert a new element in list.

		### Parameters:
			- Index: Index where to insert string
			- Value: String to append"""
		...
	@overload
	def pop(self)->str:
		"""Remove last element of list.

		### Returns:
		Returns the element that was removed."""
		...
	@overload
	def pop(self,Index:int,/)->str:
		"""Remove an element in list.

		### Parameters:
			- Index: Index where to remove element.

		### Returns:
		Returns the element that was removed."""
		...
	def remove(self,Object:str,/)->None:
		"""Remove an element in list.

		### Parameters:
			- Index: Index where to remove element."""
		...
	def removeAll(self)->None:
		"""Remove all elements of list"""
		...
	def setReferenceAt(self,arg2,arg3,/)->None:
		"""Sets the reference value of an object.

		### Parameters:
			- Reference: Reference of the object."""
		...
	def __iter__(self)->Iterator[str]:...
class FBPropertyString(FBProperty):
	"""Property: StringList"""
	Data:str
class FBPropertyListTreeNode(FBProperty):
	"""PropertyList of nodes in the tree view. PropertyList: UserObject.

	These classes are under development and may change dramatically between versions."""
	Data:list[FBTreeNode]
	def __contains__(self,Object:FBTreeNode,/)->bool:...
	def __delitem__(self,arg2:int,/):...
	def __getitem__(self,Index:int,/)->FBTreeNode:...
	def __len__(self)->int:...
	def append(self,Object:FBTreeNode,/)->None:...
	def count(self,Object:FBTreeNode,/)->int:...
	def insert(self,Index:int,Object:FBTreeNode,/)->None:...
	@overload
	def pop(self)->FBTreeNode:...
	@overload
	def pop(self,Index:int,/)->FBTreeNode:...
	def remove(self,Object:FBTreeNode,/)->None:...
	def removeAll(self)->None:...
	def __iter__(self)->Iterator[FBTreeNode]:...
class FBPropertyListComponent(FBProperty):
	"""PropertyList: Contraint

	```python
	# Supported list protocol methods:
	 len(propertyListComponent)
	 component= propertyListComponent[0]
	 propertyListComponent[0] = my_component

	 if my_component in propertyListComponent:
		print("it is contained!")
	 del propertyListComponent[0]
	```"""
	Data:list[FBComponent]
	def __contains__(self,Component:FBComponent,/)->bool:
		"""Check if a FCComponent is already in PropertyList Corresponds to python: if object in propertyList:

		### Parameters:
			- Component: Component to check for inclusion

		### Returns:
		Is the Component contain or not?"""
		...
	def __delitem__(self,arg2:int,/):...
	def __getitem__(self,Index:int,/)->FBComponent:
		"""Returns the ith component Corresponds to python: print v[1].

		### Parameters:
			- Index: Index of the components to get (0 to 2)

		### Returns:
		[FBComponent](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html "MotionBuilder SDK base class.") component value."""
		...
	def __len__(self)->int:
		"""Returns the number of elements.

		Corresponds to python: len(object)
		### Returns:
		number of elements in list."""
		...
	def append(self,Comp:FBComponent,/)->None:
		"""Append new [FBComponent](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html "MotionBuilder SDK base class.") at end of list.

		### Parameters:
			- Comp: to append"""
		...
	def count(self,Object:FBComponent,/)->int:
		"""Returns the number of elements.

		Corresponds to python: del propertyList[2]
		### Returns:
		number of elements in list."""
		...
	def insert(self,Index:int,Comp:FBComponent,/)->None:
		"""Insert a new element in list.

		### Parameters:
			- Index: Index where to insert component
			- Comp: Component to append"""
		...
	@overload
	def pop(self)->FBComponent:
		"""Remove last element of list.

		### Returns:
		Returns the element that was removed."""
		...
	@overload
	def pop(self,Index:int,/)->FBComponent:
		"""Remove an element in list.

		### Parameters:
			- Index: Index where to remove element.

		### Returns:
		Returns the element that was removed."""
		...
	def remove(self,Object:FBComponent,/)->None:
		"""Remove an element in list.

		### Parameters:
			- Index: Index where to remove element."""
		...
	def removeAll(self)->None:
		"""Remove all elements of list"""
		...
	def __iter__(self)->Iterator[FBComponent]:...
class FBPropertyList(FBProperty):
	"""Tuple-like structure for system elements.

	These list objects are used to expose system wide or instance specific list of objects. Two examples of this are [FBSystem](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_system.html "Provides access to the underlying system, and the MotionBuilder scene.")'s list of Cameras and a [FBModel](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model.html "Model class.")'s list of Shaders. These lists have been exposed to Python as tuple, whose content cannot be modified directly. This is due to the specific nature of each type of list and the access control required by the owner of the list. For example, creating a new [FBCamera](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_camera.html "Creates custom cameras and manages system cameras.") object will automatically add it to the list of [FBSystem](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_system.html "Provides access to the underlying system, and the MotionBuilder scene.")'s Cameras. The user does not have to add it to the list. The same being true for the destruction of the camera which should be done by calling 'FBDelete()' on the object itself. Not by atempting to remove it from the list of cameras.

	```python
	# Supported list operations:
	len(propertyList)
	print(propertyList[0])
	```"""
	Data:list[Any]
	def __contains__(self,Object:Any,/)->bool:...
	def __delitem__(self,arg2:int,/):...
	def __getitem__(self,Index:int,/)->Any:
		"""Returns the ith component Corresponds to python: print l[1].

		### Parameters:
			- Index: Index of the components to get

		### Returns:
		Element contain in property list"""
		...
	def __len__(self)->int:
		"""Returns the number of elements.

		Corresponds to python: len(object)"""
		...
	def append(self,Object:Any,/)->None:...
	def count(self,Object:Any,/)->int:...
	def insert(self,Index:int,Object:Any,/)->None:...
	@overload
	def pop(self)->Any:...
	@overload
	def pop(self,Index:int,/)->Any:...
	def remove(self,Object:Any,/)->None:...
	def removeAll(self)->None:...
	def __iter__(self)->Iterator[Any]:...
class FBPropertyListVideoOut(FBPropertyListComponent):
	Data:list[FBVideoOut]
	def __contains__(self,Object:FBVideoOut,/)->bool:...
	def __getitem__(self,Index:int,/)->FBVideoOut:...
	def append(self,Object:FBVideoOut,/)->None:...
	def count(self,Object:FBVideoOut,/)->int:...
	def insert(self,Index:int,Object:FBVideoOut,/)->None:...
	@overload
	def pop(self)->FBVideoOut:...
	@overload
	def pop(self,Index:int,/)->FBVideoOut:...
	def remove(self,Object:FBVideoOut,/)->None:...
	def __iter__(self)->Iterator[FBVideoOut]:...
class FBPropertyListVideoIn(FBPropertyListComponent):
	"""PropertyList: VideoOut"""
	Data:list[FBVideoIn]
	def __contains__(self,Object:FBVideoIn,/)->bool:...
	def __getitem__(self,Index:int,/)->FBVideoIn:...
	def append(self,Object:FBVideoIn,/)->None:...
	def count(self,Object:FBVideoIn,/)->int:...
	def insert(self,Index:int,Object:FBVideoIn,/)->None:...
	@overload
	def pop(self)->FBVideoIn:...
	@overload
	def pop(self,Index:int,/)->FBVideoIn:...
	def remove(self,Object:FBVideoIn,/)->None:...
	def __iter__(self)->Iterator[FBVideoIn]:...
class FBPropertyListVideoClip(FBPropertyListComponent):
	"""PropertyList: VideoIn"""
	Data:list[FBVideoClip]
	def __contains__(self,Object:FBVideoClip,/)->bool:...
	def __getitem__(self,Index:int,/)->FBVideoClip:...
	def append(self,Object:FBVideoClip,/)->None:...
	def count(self,Object:FBVideoClip,/)->int:...
	def insert(self,Index:int,Object:FBVideoClip,/)->None:...
	@overload
	def pop(self)->FBVideoClip:...
	@overload
	def pop(self,Index:int,/)->FBVideoClip:...
	def remove(self,Object:FBVideoClip,/)->None:...
	def __iter__(self)->Iterator[FBVideoClip]:...
class FBPropertyListUserObject(FBPropertyListComponent):
	"""PropertyList: VideoClip"""
	Data:list[FBUserObject]
	def __contains__(self,Object:FBUserObject,/)->bool:...
	def __getitem__(self,Index:int,/)->FBUserObject:...
	def append(self,Object:FBUserObject,/)->None:...
	def count(self,Object:FBUserObject,/)->int:...
	def insert(self,Index:int,Object:FBUserObject,/)->None:...
	@overload
	def pop(self)->FBUserObject:...
	@overload
	def pop(self,Index:int,/)->FBUserObject:...
	def remove(self,Object:FBUserObject,/)->None:...
	def __iter__(self)->Iterator[FBUserObject]:...
class FBPropertyListTexture(FBPropertyListComponent):
	Data:list[FBTexture]
	def __contains__(self,Object:FBTexture,/)->bool:...
	def __getitem__(self,Index:int,/)->FBTexture:...
	def append(self,Object:FBTexture,/)->None:...
	def count(self,Object:FBTexture,/)->int:...
	def insert(self,Index:int,Object:FBTexture,/)->None:...
	@overload
	def pop(self)->FBTexture:...
	@overload
	def pop(self,Index:int,/)->FBTexture:...
	def remove(self,Object:FBTexture,/)->None:...
	def __iter__(self)->Iterator[FBTexture]:...
class FBPropertyListTake(FBPropertyListComponent):
	"""PropertyList: Texture"""
	Data:list[FBTake]
	def __contains__(self,Object:FBTake,/)->bool:...
	def __getitem__(self,Index:int,/)->FBTake:...
	def append(self,Object:FBTake,/)->None:...
	def count(self,Object:FBTake,/)->int:...
	def insert(self,Index:int,Object:FBTake,/)->None:...
	@overload
	def pop(self)->FBTake:...
	@overload
	def pop(self,Index:int,/)->FBTake:...
	def remove(self,Object:FBTake,/)->None:...
	def __iter__(self)->Iterator[FBTake]:...
class FBPropertyListStoryTrack(FBPropertyListComponent):
	"""List: Take"""
	Data:list[FBStoryTrack]
	def __contains__(self,Object:FBStoryTrack,/)->bool:...
	def __getitem__(self,Index:int,/)->FBStoryTrack:...
	def append(self,Object:FBStoryTrack,/)->None:...
	def count(self,Object:FBStoryTrack,/)->int:...
	def insert(self,Index:int,Object:FBStoryTrack,/)->None:...
	@overload
	def pop(self)->FBStoryTrack:...
	@overload
	def pop(self,Index:int,/)->FBStoryTrack:...
	def remove(self,Object:FBStoryTrack,/)->None:...
	def __iter__(self)->Iterator[FBStoryTrack]:...
class FBPropertyListStorySubTrack(FBPropertyListComponent):
	"""List: StoryTrack"""
	Data:list[FBComponent]
	def __contains__(self,Object:FBComponent,/)->bool:...
	def __getitem__(self,Index:int,/)->FBComponent:...
	def append(self,Object:FBComponent,/)->None:...
	def count(self,Object:FBComponent,/)->int:...
	def insert(self,Index:int,Object:FBComponent,/)->None:...
	@overload
	def pop(self)->FBComponent:...
	@overload
	def pop(self,Index:int,/)->FBComponent:...
	def remove(self,Object:FBComponent,/)->None:...
	def __iter__(self)->Iterator[FBComponent]:...
class FBPropertyListStoryFolder(FBPropertyListComponent):
	"""List: StorySubTrack"""
	Data:list[FBStoryFolder]
	def __contains__(self,Object:FBStoryFolder,/)->bool:...
	def __getitem__(self,Index:int,/)->FBStoryFolder:...
	def append(self,Object:FBStoryFolder,/)->None:...
	def count(self,Object:FBStoryFolder,/)->int:...
	def insert(self,Index:int,Object:FBStoryFolder,/)->None:...
	@overload
	def pop(self)->FBStoryFolder:...
	@overload
	def pop(self,Index:int,/)->FBStoryFolder:...
	def remove(self,Object:FBStoryFolder,/)->None:...
	def __iter__(self)->Iterator[FBStoryFolder]:...
class FBPropertyListStoryDetails(FBPropertyListComponent):
	"""List: StoryFolder"""
	Data:list[FBComponent]
	def __contains__(self,Object:FBComponent,/)->bool:...
	def __getitem__(self,Index:int,/)->FBComponent:...
	def append(self,Object:FBComponent,/)->None:...
	def count(self,Object:FBComponent,/)->int:...
	def insert(self,Index:int,Object:FBComponent,/)->None:...
	@overload
	def pop(self)->FBComponent:...
	@overload
	def pop(self,Index:int,/)->FBComponent:...
	def remove(self,Object:FBComponent,/)->None:...
	def __iter__(self)->Iterator[FBComponent]:...
class FBPropertyListStoryClip(FBPropertyListComponent):
	"""List: Story track Details"""
	Data:list[FBStoryClip]
	def __contains__(self,Object:FBStoryClip,/)->bool:...
	def __getitem__(self,Index:int,/)->FBStoryClip:...
	def append(self,Object:FBStoryClip,/)->None:...
	def count(self,Object:FBStoryClip,/)->int:...
	def insert(self,Index:int,Object:FBStoryClip,/)->None:...
	@overload
	def pop(self)->FBStoryClip:...
	@overload
	def pop(self,Index:int,/)->FBStoryClip:...
	def remove(self,Object:FBStoryClip,/)->None:...
	def __iter__(self)->Iterator[FBStoryClip]:...
class FBPropertyListShader(FBPropertyListComponent):
	"""List: StoryClip"""
	Data:list[FBShader]
	def __contains__(self,Object:FBShader,/)->bool:...
	def __getitem__(self,Index:int,/)->FBShader:...
	def append(self,Object:FBShader,/)->None:...
	def count(self,Object:FBShader,/)->int:...
	def insert(self,Index:int,Object:FBShader,/)->None:...
	@overload
	def pop(self)->FBShader:...
	@overload
	def pop(self,Index:int,/)->FBShader:...
	def remove(self,Object:FBShader,/)->None:...
	def __iter__(self)->Iterator[FBShader]:...
class FBPropertyListSet(FBPropertyListComponent):
	"""PropertyList: Shader"""
	Data:list[FBSet]
	def __contains__(self,Object:FBSet,/)->bool:...
	def __getitem__(self,Index:int,/)->FBSet:...
	def append(self,Object:FBSet,/)->None:...
	def count(self,Object:FBSet,/)->int:...
	def insert(self,Index:int,Object:FBSet,/)->None:...
	@overload
	def pop(self)->FBSet:...
	@overload
	def pop(self,Index:int,/)->FBSet:...
	def remove(self,Object:FBSet,/)->None:...
	def __iter__(self)->Iterator[FBSet]:...
class FBPropertyListRendererCallback(FBPropertyListComponent):
	"""PropertyList: Device optical marker"""
	Data:list[FBRendererCallback]
	def __contains__(self,Object:FBRendererCallback,/)->bool:...
	def __getitem__(self,Index:int,/)->FBRendererCallback:...
	def append(self,Object:FBRendererCallback,/)->None:...
	def count(self,Object:FBRendererCallback,/)->int:...
	def insert(self,Index:int,Object:FBRendererCallback,/)->None:...
	@overload
	def pop(self)->FBRendererCallback:...
	@overload
	def pop(self,Index:int,/)->FBRendererCallback:...
	def remove(self,Object:FBRendererCallback,/)->None:...
	def __iter__(self)->Iterator[FBRendererCallback]:...
class FBPropertyListPose(FBPropertyListComponent):
	"""PropertyList: Texture"""
	Data:list[FBPose]
	def __contains__(self,Object:FBPose,/)->bool:...
	def __getitem__(self,Index:int,/)->FBPose:...
	def append(self,Object:FBPose,/)->None:...
	def count(self,Object:FBPose,/)->int:...
	def insert(self,Index:int,Object:FBPose,/)->None:...
	@overload
	def pop(self)->FBPose:...
	@overload
	def pop(self,Index:int,/)->FBPose:...
	def remove(self,Object:FBPose,/)->None:...
	def __iter__(self)->Iterator[FBPose]:...
class FBPropertyListPivot(FBPropertyListComponent):
	"""List: Model"""
	Data:list[FBComponent]
	def __contains__(self,Object:FBComponent,/)->bool:...
	def __getitem__(self,Index:int,/)->FBComponent:...
	def append(self,Object:FBComponent,/)->None:...
	def count(self,Object:FBComponent,/)->int:...
	def insert(self,Index:int,Object:FBComponent,/)->None:...
	@overload
	def pop(self)->FBComponent:...
	@overload
	def pop(self,Index:int,/)->FBComponent:...
	def remove(self,Object:FBComponent,/)->None:...
	def __iter__(self)->Iterator[FBComponent]:...
class FBPropertyListPhysicalProperties(FBPropertyListComponent):
	"""List: Story Clip pivot models"""
	Data:list[FBPhysicalProperties]
	def __contains__(self,Object:FBPhysicalProperties,/)->bool:...
	def __getitem__(self,Index:int,/)->FBPhysicalProperties:...
	def append(self,Object:FBPhysicalProperties,/)->None:...
	def count(self,Object:FBPhysicalProperties,/)->int:...
	def insert(self,Index:int,Object:FBPhysicalProperties,/)->None:...
	@overload
	def pop(self)->FBPhysicalProperties:...
	@overload
	def pop(self,Index:int,/)->FBPhysicalProperties:...
	def remove(self,Object:FBPhysicalProperties,/)->None:...
	def __iter__(self)->Iterator[FBPhysicalProperties]:...
class FBPropertyListObjectPose(FBPropertyListComponent):
	"""PropertyList: Device optical marker"""
	Data:list[FBObjectPose]
	def __contains__(self,Object:FBObjectPose,/)->bool:...
	def __getitem__(self,Index:int,/)->FBObjectPose:...
	def append(self,Object:FBObjectPose,/)->None:...
	def count(self,Object:FBObjectPose,/)->int:...
	def insert(self,Index:int,Object:FBObjectPose,/)->None:...
	@overload
	def pop(self)->FBObjectPose:...
	@overload
	def pop(self,Index:int,/)->FBObjectPose:...
	def remove(self,Object:FBObjectPose,/)->None:...
	def __iter__(self)->Iterator[FBObjectPose]:...
class FBPropertyListObject(FBPropertyListComponent):
	"""List-like structure fo system elements.

	PropertyList: ObjectPose.

	This container supports most of the list interface, but is limited to contain only [FBComponent](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html "MotionBuilder SDK base class.") objects. New objects can be added, or objects in the list can be removed. The cardinality of the list and the use of the contained object will vary according the container object type. This class supports slice access for query, but not for assignment."""
	Data:list[FBComponent]
	def GetSingleConnect(self)->bool:
		"""Get if the connection support only one connection.

		### Returns:
		true is the connection support only one connection."""
		...
	def SetSingleConnect(self,SingleConnect:bool,/)->None:
		"""Set if the connection is single or multiple.

		### Parameters:
			- SingleConnect: set to true for only one connection allowed."""
		...
	def __contains__(self,Object:FBComponent,/)->bool:...
	def __getitem__(self,Index:int,/)->FBComponent:...
	def append(self,Object:FBComponent,/)->None:...
	def count(self,Object:FBComponent,/)->int:...
	def insert(self,Index:int,Object:FBComponent,/)->None:...
	@overload
	def pop(self)->FBComponent:...
	@overload
	def pop(self,Index:int,/)->FBComponent:...
	def remove(self,Object:FBComponent,/)->None:...
	def __iter__(self)->Iterator[FBComponent]:...
class FBPropertyListNote(FBPropertyListComponent):
	"""List of scene objects.

	This list is a more generic container often used as object properties. The types of actual object that it can contain can be specialized."""
	Data:list[FBNote]
	def __contains__(self,Object:FBNote,/)->bool:...
	def __getitem__(self,Index:int,/)->FBNote:...
	def append(self,Object:FBNote,/)->None:...
	def count(self,Object:FBNote,/)->int:...
	def insert(self,Index:int,Object:FBNote,/)->None:...
	@overload
	def pop(self)->FBNote:...
	@overload
	def pop(self,Index:int,/)->FBNote:...
	def remove(self,Object:FBNote,/)->None:...
	def __iter__(self)->Iterator[FBNote]:...
class FBPropertyListNamespace(FBPropertyListComponent):
	"""List: Note"""
	Data:list[FBNamespace]
	def __contains__(self,Object:FBNamespace,/)->bool:...
	def __getitem__(self,Index:int,/)->FBNamespace:...
	def append(self,Object:FBNamespace,/)->None:...
	def count(self,Object:FBNamespace,/)->int:...
	def insert(self,Index:int,Object:FBNamespace,/)->None:...
	@overload
	def pop(self)->FBNamespace:...
	@overload
	def pop(self,Index:int,/)->FBNamespace:...
	def remove(self,Object:FBNamespace,/)->None:...
	def __iter__(self)->Iterator[FBNamespace]:...
class FBPropertyListMotionClip(FBPropertyListComponent):
	"""List: Namespace"""
	Data:list[FBMotionClip]
	def __contains__(self,Object:FBMotionClip,/)->bool:...
	def __getitem__(self,Index:int,/)->FBMotionClip:...
	def append(self,Object:FBMotionClip,/)->None:...
	def count(self,Object:FBMotionClip,/)->int:...
	def insert(self,Index:int,Object:FBMotionClip,/)->None:...
	@overload
	def pop(self)->FBMotionClip:...
	@overload
	def pop(self,Index:int,/)->FBMotionClip:...
	def remove(self,Object:FBMotionClip,/)->None:...
	def __iter__(self)->Iterator[FBMotionClip]:...
class FBPropertyListModelSkeleton(FBPropertyListComponent):
	"""PropertyList: ModelTemplate."""
	Data:list[FBModelSkeleton]
	def __contains__(self,Object:FBModelSkeleton,/)->bool:...
	def __getitem__(self,Index:int,/)->FBModelSkeleton:...
	def append(self,Object:FBModelSkeleton,/)->None:...
	def count(self,Object:FBModelSkeleton,/)->int:...
	def insert(self,Index:int,Object:FBModelSkeleton,/)->None:...
	@overload
	def pop(self)->FBModelSkeleton:...
	@overload
	def pop(self,Index:int,/)->FBModelSkeleton:...
	def remove(self,Object:FBModelSkeleton,/)->None:...
	def __iter__(self)->Iterator[FBModelSkeleton]:...
class FBPropertyListModelOptical(FBPropertyListComponent):
	"""PropertyList: ModelSkeleton."""
	Data:list[FBModelOptical]
	def __contains__(self,Object:FBModelOptical,/)->bool:...
	def __getitem__(self,Index:int,/)->FBModelOptical:...
	def append(self,Object:FBModelOptical,/)->None:...
	def count(self,Object:FBModelOptical,/)->int:...
	def insert(self,Index:int,Object:FBModelOptical,/)->None:...
	@overload
	def pop(self)->FBModelOptical:...
	@overload
	def pop(self,Index:int,/)->FBModelOptical:...
	def remove(self,Object:FBModelOptical,/)->None:...
	def __iter__(self)->Iterator[FBModelOptical]:...
class FBPropertyListModel(FBPropertyListComponent):
	"""PropertyList: Device optical marker"""
	Data:list[FBModel]
	def __contains__(self,Object:FBModel,/)->bool:...
	def __getitem__(self,Index:int,/)->FBModel:...
	def append(self,Object:FBModel,/)->None:...
	def count(self,Object:FBModel,/)->int:...
	def insert(self,Index:int,Object:FBModel,/)->None:...
	@overload
	def pop(self)->FBModel:...
	@overload
	def pop(self,Index:int,/)->FBModel:...
	def remove(self,Object:FBModel,/)->None:...
	def __iter__(self)->Iterator[FBModel]:...
class FBPropertyListMaterial(FBPropertyListComponent):
	"""List: Model"""
	Data:list[FBMaterial]
	def __contains__(self,Object:FBMaterial,/)->bool:...
	def __getitem__(self,Index:int,/)->FBMaterial:...
	def append(self,Object:FBMaterial,/)->None:...
	def count(self,Object:FBMaterial,/)->int:...
	def insert(self,Index:int,Object:FBMaterial,/)->None:...
	@overload
	def pop(self)->FBMaterial:...
	@overload
	def pop(self,Index:int,/)->FBMaterial:...
	def remove(self,Object:FBMaterial,/)->None:...
	def __iter__(self)->Iterator[FBMaterial]:...
class FBPropertyListMarkerSet(FBPropertyListComponent):
	"""PropertyList: Material"""
	Data:list[FBMarkerSet]
	def __contains__(self,Object:FBMarkerSet,/)->bool:...
	def __getitem__(self,Index:int,/)->FBMarkerSet:...
	def append(self,Object:FBMarkerSet,/)->None:...
	def count(self,Object:FBMarkerSet,/)->int:...
	def insert(self,Index:int,Object:FBMarkerSet,/)->None:...
	@overload
	def pop(self)->FBMarkerSet:...
	@overload
	def pop(self,Index:int,/)->FBMarkerSet:...
	def remove(self,Object:FBMarkerSet,/)->None:...
	def __iter__(self)->Iterator[FBMarkerSet]:...
class FBPropertyListLight(FBPropertyListComponent):
	"""PropertyList: Manipulator."""
	Data:list[FBLight]
	def __contains__(self,Object:FBLight,/)->bool:...
	def __getitem__(self,Index:int,/)->FBLight:...
	def append(self,Object:FBLight,/)->None:...
	def count(self,Object:FBLight,/)->int:...
	def insert(self,Index:int,Object:FBLight,/)->None:...
	@overload
	def pop(self)->FBLight:...
	@overload
	def pop(self,Index:int,/)->FBLight:...
	def remove(self,Object:FBLight,/)->None:...
	def __iter__(self)->Iterator[FBLight]:...
class FBPropertyListKeyingGroup(FBPropertyListComponent):
	"""PropertyList: Light"""
	Data:list[FBKeyingGroup]
	def __contains__(self,Object:FBKeyingGroup,/)->bool:...
	def __getitem__(self,Index:int,/)->FBKeyingGroup:...
	def append(self,Object:FBKeyingGroup,/)->None:...
	def count(self,Object:FBKeyingGroup,/)->int:...
	def insert(self,Index:int,Object:FBKeyingGroup,/)->None:...
	@overload
	def pop(self)->FBKeyingGroup:...
	@overload
	def pop(self,Index:int,/)->FBKeyingGroup:...
	def remove(self,Object:FBKeyingGroup,/)->None:...
	def __iter__(self)->Iterator[FBKeyingGroup]:...
class FBPropertyListHandle(FBPropertyListComponent):
	"""PropertyList: KeyingGroup."""
	Data:list[FBHandle]
	def __contains__(self,Object:FBHandle,/)->bool:...
	def __getitem__(self,Index:int,/)->FBHandle:...
	def append(self,Object:FBHandle,/)->None:...
	def count(self,Object:FBHandle,/)->int:...
	def insert(self,Index:int,Object:FBHandle,/)->None:...
	@overload
	def pop(self)->FBHandle:...
	@overload
	def pop(self,Index:int,/)->FBHandle:...
	def remove(self,Object:FBHandle,/)->None:...
	def __iter__(self)->Iterator[FBHandle]:...
class FBPropertyListHUDElement(FBPropertyListComponent):
	"""PropertyList: Handle."""
	Data:list[FBHUDElement]
	def __contains__(self,Object:FBHUDElement,/)->bool:...
	def __getitem__(self,Index:int,/)->FBHUDElement:...
	def append(self,Object:FBHUDElement,/)->None:...
	def count(self,Object:FBHUDElement,/)->int:...
	def insert(self,Index:int,Object:FBHUDElement,/)->None:...
	@overload
	def pop(self)->FBHUDElement:...
	@overload
	def pop(self,Index:int,/)->FBHUDElement:...
	def remove(self,Object:FBHUDElement,/)->None:...
	def __iter__(self)->Iterator[FBHUDElement]:...
class FBPropertyListHUD(FBPropertyListComponent):
	"""PropertyList: Handle."""
	Data:list[FBHUD]
	def __contains__(self,Object:FBHUD,/)->bool:...
	def __getitem__(self,Index:int,/)->FBHUD:...
	def append(self,Object:FBHUD,/)->None:...
	def count(self,Object:FBHUD,/)->int:...
	def insert(self,Index:int,Object:FBHUD,/)->None:...
	@overload
	def pop(self)->FBHUD:...
	@overload
	def pop(self,Index:int,/)->FBHUD:...
	def remove(self,Object:FBHUD,/)->None:...
	def __iter__(self)->Iterator[FBHUD]:...
class FBPropertyListGroup(FBPropertyListComponent):
	"""PropertyList: Handle."""
	Data:list[FBGroup]
	def __contains__(self,Object:FBGroup,/)->bool:...
	def __getitem__(self,Index:int,/)->FBGroup:...
	def append(self,Object:FBGroup,/)->None:...
	def count(self,Object:FBGroup,/)->int:...
	def insert(self,Index:int,Object:FBGroup,/)->None:...
	@overload
	def pop(self)->FBGroup:...
	@overload
	def pop(self,Index:int,/)->FBGroup:...
	def remove(self,Object:FBGroup,/)->None:...
	def __iter__(self)->Iterator[FBGroup]:...
class FBPropertyListFolder(FBPropertyListComponent):
	"""List: Group"""
	Data:list[FBFolder]
	def __contains__(self,Object:FBFolder,/)->bool:...
	def __getitem__(self,Index:int,/)->FBFolder:...
	def append(self,Object:FBFolder,/)->None:...
	def count(self,Object:FBFolder,/)->int:...
	def insert(self,Index:int,Object:FBFolder,/)->None:...
	@overload
	def pop(self)->FBFolder:...
	@overload
	def pop(self,Index:int,/)->FBFolder:...
	def remove(self,Object:FBFolder,/)->None:...
	def __iter__(self)->Iterator[FBFolder]:...
class FBPropertyListFileReference(FBPropertyListComponent):
	"""PropertyList: Folder"""
	Data:list[FBFileReference]
	def __contains__(self,Object:FBFileReference,/)->bool:...
	def __getitem__(self,Index:int,/)->FBFileReference:...
	def append(self,Object:FBFileReference,/)->None:...
	def count(self,Object:FBFileReference,/)->int:...
	def insert(self,Index:int,Object:FBFileReference,/)->None:...
	@overload
	def pop(self)->FBFileReference:...
	@overload
	def pop(self,Index:int,/)->FBFileReference:...
	def remove(self,Object:FBFileReference,/)->None:...
	def __iter__(self)->Iterator[FBFileReference]:...
class FBPropertyListDevice(FBPropertyListComponent):
	Data:list[FBDevice]
	def __contains__(self,Object:FBDevice,/)->bool:...
	def __getitem__(self,Index:int,/)->FBDevice:...
	def append(self,Object:FBDevice,/)->None:...
	def count(self,Object:FBDevice,/)->int:...
	def insert(self,Index:int,Object:FBDevice,/)->None:...
	@overload
	def pop(self)->FBDevice:...
	@overload
	def pop(self,Index:int,/)->FBDevice:...
	def remove(self,Object:FBDevice,/)->None:...
	def __iter__(self)->Iterator[FBDevice]:...
class FBPropertyListDeformer(FBPropertyListComponent):
	"""PropertyList: Device"""
	Data:list[FBDeformer]
	def __contains__(self,Object:FBDeformer,/)->bool:...
	def __getitem__(self,Index:int,/)->FBDeformer:...
	def append(self,Object:FBDeformer,/)->None:...
	def count(self,Object:FBDeformer,/)->int:...
	def insert(self,Index:int,Object:FBDeformer,/)->None:...
	@overload
	def pop(self)->FBDeformer:...
	@overload
	def pop(self,Index:int,/)->FBDeformer:...
	def remove(self,Object:FBDeformer,/)->None:...
	def __iter__(self)->Iterator[FBDeformer]:...
class FBPropertyListDeck(FBPropertyListComponent):
	Data:list[FBDeck]
	def __contains__(self,Object:FBDeck,/)->bool:...
	def __getitem__(self,Index:int,/)->FBDeck:...
	def append(self,Object:FBDeck,/)->None:...
	def count(self,Object:FBDeck,/)->int:...
	def insert(self,Index:int,Object:FBDeck,/)->None:...
	@overload
	def pop(self)->FBDeck:...
	@overload
	def pop(self,Index:int,/)->FBDeck:...
	def remove(self,Object:FBDeck,/)->None:...
	def __iter__(self)->Iterator[FBDeck]:...
class FBPropertyListControlSet(FBPropertyListComponent):
	"""PropertyList: Deck"""
	Data:list[FBControlSet]
	def __contains__(self,Object:FBControlSet,/)->bool:...
	def __getitem__(self,Index:int,/)->FBControlSet:...
	def append(self,Object:FBControlSet,/)->None:...
	def count(self,Object:FBControlSet,/)->int:...
	def insert(self,Index:int,Object:FBControlSet,/)->None:...
	@overload
	def pop(self)->FBControlSet:...
	@overload
	def pop(self,Index:int,/)->FBControlSet:...
	def remove(self,Object:FBControlSet,/)->None:...
	def __iter__(self)->Iterator[FBControlSet]:...
class FBPropertyListConstraintSolver(FBPropertyListComponent):
	"""PropertyList: MarkerSet.

	These classes are under development and may change dramatically between versions."""
	Data:list[FBConstraintSolver]
	def __contains__(self,Object:FBConstraintSolver,/)->bool:...
	def __getitem__(self,Index:int,/)->FBConstraintSolver:...
	def append(self,Object:FBConstraintSolver,/)->None:...
	def count(self,Object:FBConstraintSolver,/)->int:...
	def insert(self,Index:int,Object:FBConstraintSolver,/)->None:...
	@overload
	def pop(self)->FBConstraintSolver:...
	@overload
	def pop(self,Index:int,/)->FBConstraintSolver:...
	def remove(self,Object:FBConstraintSolver,/)->None:...
	def __iter__(self)->Iterator[FBConstraintSolver]:...
class FBPropertyListActor(FBPropertyListComponent):
	"""PropertyList: Actor face.

	These classes are under development and may change dramatically between versions."""
	Data:list[FBActor]
	def __contains__(self,Object:FBActor,/)->bool:...
	def __getitem__(self,Index:int,/)->FBActor:...
	def append(self,Object:FBActor,/)->None:...
	def count(self,Object:FBActor,/)->int:...
	def insert(self,Index:int,Object:FBActor,/)->None:...
	@overload
	def pop(self)->FBActor:...
	@overload
	def pop(self,Index:int,/)->FBActor:...
	def remove(self,Object:FBActor,/)->None:...
	def __iter__(self)->Iterator[FBActor]:...
class FBPropertyListActorFace(FBPropertyListComponent):
	Data:list[FBActorFace]
	def __contains__(self,Object:FBActorFace,/)->bool:...
	def __getitem__(self,Index:int,/)->FBActorFace:...
	def append(self,Object:FBActorFace,/)->None:...
	def count(self,Object:FBActorFace,/)->int:...
	def insert(self,Index:int,Object:FBActorFace,/)->None:...
	@overload
	def pop(self)->FBActorFace:...
	@overload
	def pop(self,Index:int,/)->FBActorFace:...
	def remove(self,Object:FBActorFace,/)->None:...
	def __iter__(self)->Iterator[FBActorFace]:...
class FBPropertyListAudioClip(FBPropertyListComponent):
	"""List: AudioIn"""
	Data:list[FBAudioClip]
	def __contains__(self,Object:FBAudioClip,/)->bool:...
	def __getitem__(self,Index:int,/)->FBAudioClip:...
	def append(self,Object:FBAudioClip,/)->None:...
	def count(self,Object:FBAudioClip,/)->int:...
	def insert(self,Index:int,Object:FBAudioClip,/)->None:...
	@overload
	def pop(self)->FBAudioClip:...
	@overload
	def pop(self,Index:int,/)->FBAudioClip:...
	def remove(self,Object:FBAudioClip,/)->None:...
	def __iter__(self)->Iterator[FBAudioClip]:...
class FBPropertyListAudioIn(FBPropertyListComponent):
	"""List: AudioOut"""
	Data:list[FBAudioIn]
	def __contains__(self,Object:FBAudioIn,/)->bool:...
	def __getitem__(self,Index:int,/)->FBAudioIn:...
	def append(self,Object:FBAudioIn,/)->None:...
	def count(self,Object:FBAudioIn,/)->int:...
	def insert(self,Index:int,Object:FBAudioIn,/)->None:...
	@overload
	def pop(self)->FBAudioIn:...
	@overload
	def pop(self,Index:int,/)->FBAudioIn:...
	def remove(self,Object:FBAudioIn,/)->None:...
	def __iter__(self)->Iterator[FBAudioIn]:...
class FBPropertyListAudioOut(FBPropertyListComponent):
	"""List: Box informations for constraint relation."""
	Data:list[FBAudioOut]
	def __contains__(self,Object:FBAudioOut,/)->bool:...
	def __getitem__(self,Index:int,/)->FBAudioOut:...
	def append(self,Object:FBAudioOut,/)->None:...
	def count(self,Object:FBAudioOut,/)->int:...
	def insert(self,Index:int,Object:FBAudioOut,/)->None:...
	@overload
	def pop(self)->FBAudioOut:...
	@overload
	def pop(self,Index:int,/)->FBAudioOut:...
	def remove(self,Object:FBAudioOut,/)->None:...
	def __iter__(self)->Iterator[FBAudioOut]:...
class FBPropertyListBox(FBPropertyListComponent):
	"""PropertyList: Camera"""
	Data:list[FBBox]
	def __contains__(self,Object:FBBox,/)->bool:...
	def __getitem__(self,Index:int,/)->FBBox:...
	def append(self,Object:FBBox,/)->None:...
	def count(self,Object:FBBox,/)->int:...
	def insert(self,Index:int,Object:FBBox,/)->None:...
	@overload
	def pop(self)->FBBox:...
	@overload
	def pop(self,Index:int,/)->FBBox:...
	def remove(self,Object:FBBox,/)->None:...
	def __iter__(self)->Iterator[FBBox]:...
class FBPropertyListCamera(FBPropertyListComponent):
	"""PropertyList: Character.

	These classes are under development and may change dramatically between versions."""
	Data:list[FBCamera]
	def __contains__(self,Object:FBCamera,/)->bool:...
	def __getitem__(self,Index:int,/)->FBCamera:...
	def append(self,Object:FBCamera,/)->None:...
	def count(self,Object:FBCamera,/)->int:...
	def insert(self,Index:int,Object:FBCamera,/)->None:...
	@overload
	def pop(self)->FBCamera:...
	@overload
	def pop(self,Index:int,/)->FBCamera:...
	def remove(self,Object:FBCamera,/)->None:...
	def __iter__(self)->Iterator[FBCamera]:...
class FBPropertyListCharacter(FBPropertyListComponent):
	Data:list[FBCharacter]
	def __contains__(self,Object:FBCharacter,/)->bool:...
	def __getitem__(self,Index:int,/)->FBCharacter:...
	def append(self,Object:FBCharacter,/)->None:...
	def count(self,Object:FBCharacter,/)->int:...
	def insert(self,Index:int,Object:FBCharacter,/)->None:...
	@overload
	def pop(self)->FBCharacter:...
	@overload
	def pop(self,Index:int,/)->FBCharacter:...
	def remove(self,Object:FBCharacter,/)->None:...
	def __iter__(self)->Iterator[FBCharacter]:...
class FBPropertyListCharacterExtension(FBPropertyListComponent):
	"""Character extension property list. PropertyList: Character face.

	These classes are under development and may change dramatically between versions."""
	Data:list[FBCharacterExtension]
	def __contains__(self,Object:FBCharacterExtension,/)->bool:...
	def __getitem__(self,Index:int,/)->FBCharacterExtension:...
	def append(self,Object:FBCharacterExtension,/)->None:...
	def count(self,Object:FBCharacterExtension,/)->int:...
	def insert(self,Index:int,Object:FBCharacterExtension,/)->None:...
	@overload
	def pop(self)->FBCharacterExtension:...
	@overload
	def pop(self,Index:int,/)->FBCharacterExtension:...
	def remove(self,Object:FBCharacterExtension,/)->None:...
	def __iter__(self)->Iterator[FBCharacterExtension]:...
class FBPropertyListCharacterFace(FBPropertyListComponent):
	"""PropertyList: CharacterMarkerSet.

	These classes are under development and may change dramatically between versions."""
	Data:list[FBCharacterFace]
	def __contains__(self,Object:FBCharacterFace,/)->bool:...
	def __getitem__(self,Index:int,/)->FBCharacterFace:...
	def append(self,Object:FBCharacterFace,/)->None:...
	def count(self,Object:FBCharacterFace,/)->int:...
	def insert(self,Index:int,Object:FBCharacterFace,/)->None:...
	@overload
	def pop(self)->FBCharacterFace:...
	@overload
	def pop(self,Index:int,/)->FBCharacterFace:...
	def remove(self,Object:FBCharacterFace,/)->None:...
	def __iter__(self)->Iterator[FBCharacterFace]:...
class FBPropertyListCharacterMarkerSet(FBPropertyListComponent):
	"""PropertyList: CharacterPose."""
	Data:list[FBCharacterMarkerSet]
	def __contains__(self,Object:FBCharacterMarkerSet,/)->bool:...
	def __getitem__(self,Index:int,/)->FBCharacterMarkerSet:...
	def append(self,Object:FBCharacterMarkerSet,/)->None:...
	def count(self,Object:FBCharacterMarkerSet,/)->int:...
	def insert(self,Index:int,Object:FBCharacterMarkerSet,/)->None:...
	@overload
	def pop(self)->FBCharacterMarkerSet:...
	@overload
	def pop(self,Index:int,/)->FBCharacterMarkerSet:...
	def remove(self,Object:FBCharacterMarkerSet,/)->None:...
	def __iter__(self)->Iterator[FBCharacterMarkerSet]:...
class FBPropertyListCharacterPose(FBPropertyListComponent):
	"""PropertyList: Concrete class for PropertyList of component"""
	Data:list[FBCharacterPose]
	def __contains__(self,Object:FBCharacterPose,/)->bool:...
	def __getitem__(self,Index:int,/)->FBCharacterPose:...
	def append(self,Object:FBCharacterPose,/)->None:...
	def count(self,Object:FBCharacterPose,/)->int:...
	def insert(self,Index:int,Object:FBCharacterPose,/)->None:...
	@overload
	def pop(self)->FBCharacterPose:...
	@overload
	def pop(self,Index:int,/)->FBCharacterPose:...
	def remove(self,Object:FBCharacterPose,/)->None:...
	def __iter__(self)->Iterator[FBCharacterPose]:...
class FBPropertyListConstraint(FBPropertyListComponent):
	"""PropertyList: Constraint solver"""
	Data:list[FBConstraint]
	def __contains__(self,Object:FBConstraint,/)->bool:...
	def __getitem__(self,Index:int,/)->FBConstraint:...
	def append(self,Object:FBConstraint,/)->None:...
	def count(self,Object:FBConstraint,/)->int:...
	def insert(self,Index:int,Object:FBConstraint,/)->None:...
	@overload
	def pop(self)->FBConstraint:...
	@overload
	def pop(self,Index:int,/)->FBConstraint:...
	def remove(self,Object:FBConstraint,/)->None:...
	def __iter__(self)->Iterator[FBConstraint]:...
class FBPropertyInt(FBProperty):
	Data:int
class FBPropertyFloat(FBProperty):
	Data:float
class FBPropertyEnum(FBProperty):
	"""[Enumeration](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_enumeration.html "Enumeration mapping.") property.

	Certain properties have strings associated with the integer values they may possess. [FBModel](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model.html "Model class.")'s ShadingMode property is one of those example. The actual underlying value of the property is numerical, but it is represented by a string value in the GUI. User can create this type of property via the GUI by creating a list property. The names added to the list can be obtained via the '[EnumList()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_enum.html#ae9d9b3c845a94e776813f0475e0082d6)' method."""
	Data:Enumeration
	"""Return the string associated with the index. Will return None when no value is associated."""
class FBPropertyDouble(FBProperty):
	Data:float
class FBPropertyComponent(FBProperty):
	Data:FBComponent
class FBPropertyColorAndAlpha(FBProperty):
	"""[FBPropertyColorAndAlpha](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_color_and_alpha.html "FBPropertyColorAndAlpha class.") class.

	Similar in use to [FBPropertyColor](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_color.html "FBPropertyColor class.")

	```python
	# Supported list protocol methods:
	c = FBPropertyColorAndAlpha()
	len(c)
	print(c[0])
	c[0] = 1.0
	print(c.Data)
	c.Data=FBColorAndAlpha(1.0,0.5,0.5,1.0)
	```
	### Warning:
	Slicing is not supported by this object."""
	Data:FBColorAndAlpha
	def __getitem__(self,Index:int,/)->float:
		"""Returns the ith component Corresponds to python: print c[1].

		### Parameters:
			- Index: Index of the components to get (0 to 1)

		### Returns:
		Color component value."""
		...
	def __len__(self)->int:
		"""Returns the number of elements.

		Corresponds to python: len(object)"""
		...
	def __setitem__(self,Index:int,ComponentValue:float,/):
		"""Sets the ith components Corresponds to python: c[1] = 0.5.

		### Parameters:
			- Index: Index of the components to set (0 to 1)
			- ComponentValue: Value of component to set"""
		...
	def __iter__(self)->Iterator[float]:...
class FBPropertyColor(FBProperty):
	"""[FBPropertyColor](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_color.html "FBPropertyColor class.") class.

	Similar in use to [FBPropertyVector3d](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_vector3d.html)

	```python
	# Supported list protocol methods:
	c = FBPropertyColor()
	len(c)
	print(c[0])
	c[0] = 1.0
	print(c.Data)
	c.Data=FBColor(1.0,0.5,0.5)
	```
	### Warning:
	Slicing is not supported by this object."""
	Data:FBColor
	def __getitem__(self,Index:int,/)->float:
		"""Returns the ith component Corresponds to python: print c[1].

		### Parameters:
			- Index: Index of the components to get (0 to 1)

		### Returns:
		Color component value."""
		...
	def __len__(self)->int:
		"""Returns the number of elements.

		Corresponds to python: len(object)"""
		...
	def __setitem__(self,Index:int,ComponentValue:float,/):
		"""Sets the ith components Corresponds to python: c[1] = 0.5.

		### Parameters:
			- Index: Index of the components to set (0 to 1)
			- ComponentValue: Value of component to set"""
		...
	def __iter__(self)->Iterator[float]:...
class FBPropertyBool(FBProperty):
	Data:bool
class FBPropertyAnimatable(FBProperty):
	"""Animatable property base class."""
	Data:Any
	"""Read Write Property: The property data value. Type of this depends on the subclass of [FBPropertyAnimatable](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_animatable.html "Animatable property base class.") (ex: in a [FBPropertyAnimatableInt](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_animatable_int.html), Data is of type int)."""
	def AllowsMuting(self)->bool:
		"""AllowsMuting.

		### Returns:
		true if property can be muted"""
		...
	def GetAnimationNode(self)->FBAnimationNode:
		"""Get the animation node for the property.

		### Returns:
		Animation node for property. None is returned if property is not animated."""
		...
	def GetBox(self)->FBBox:
		"""Get the owner box.

		### Returns:
		Handle to the owning box (i.e. model)."""
		...
	def GetColor(self,Index:int,/)->FBColor:
		"""Get the color of a particular FCurve of the property.

		### Parameters:
			- Index: Index of the FCurve to get the color.

		### Returns:
		The color of the FCurve at the specified index, a default [FBColor](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_color.html "FBColor class.") object if the index is invalid."""
		...
	def GetDataTypeName(self)->str:
		"""Get the property datatype name.

		### Returns:
		Datatype of property as a character string."""
		...
	def HasSomethingMuted(self)->bool:
		"""HasSomethingMuted.

		### Returns:
		true if property or any of its members is muted"""
		...
	def IsAnimated(self)->bool:
		"""Is the property animated.

		This is true if the property has an FCurve associated to it.
		### Returns:
		true if animated, false if not animated."""
		...
	def IsFocused(self)->bool:
		"""Is the property focused (keyable).

		### Returns:
		Current focus (keyable) state for the property."""
		...
	def IsFocusedChild(self,Index:int,/)->bool:
		"""Get the focus (keyable) state of child component.

		### Parameters:
			- Index: Index of the child FCurve component.

		### Returns:
		true if the component is in focus, false otherwise"""
		...
	def IsMemberMuted(self,Index:int,/)->bool:
		"""IsMemberMuted.

		### Parameters:
			- Index: Index of the sub-member of the property to check.

		### Returns:
		true if property sub-member is muted"""
		...
	def IsMuted(self)->bool:
		"""IsMuted.

		### Returns:
		true if property is muted"""
		...
	def Key(self)->None:
		"""Key the property."""
		...
	def KeyAt(self,Time:FBTime,/)->None:
		"""Key the property at time (t).

		### Parameters:
			- Time: Time at which to insert the key."""
		...
	def KeyRemoveAt(self,Time:FBTime,/)->None:
		"""Remove the key at time (t).

		### Parameters:
			- Time: Time at which to insert the key."""
		...
	def OriIsAnimated(self)->bool:...
	def ResetColor(self,Index:int,/)->bool:
		"""Revert the FCurves to their default color.

		### Parameters:
			- Index: Index of the FCurve to reset the color, use -1 to reset the color for all FCurves of the property.

		### Returns:
		true if the color was reverted to its default value, false otherwise"""
		...
	def SetAnimated(self,State:bool,CheckLocked:bool=False,/)->None:
		"""Set the animation state of the property.

		### Parameters:
			- State: State of animation for property, true to animate, false to remove curves.
			- CheckLocked: Decides whether to check the locked status."""
		...
	def SetColor(self,Color:FBColor,Index:int,/)->bool:
		"""Set the color of the FCurves for the property.

		### Parameters:
			- Color: Color to set for the FCurve(s).
			- Index: Index of the FCurve to set the new color, use -1 to set the color for all FCurves.

		### Returns:
		true if the color was changed, false otherwise"""
		...
	def SetFocus(self,State:bool,/)->None:
		"""Set the property's focus (keyable) state.

		### Parameters:
			- State: Focus (keyable) state to set for the property."""
		...
	def SetFocusChild(self,Index:int,State:bool,/)->None:
		"""Set the focus (keyable) state of child component.

		### Parameters:
			- Index: Index of the child FCurve component.
			- State: Focus (keyable) state to set for the property component.

		### Returns:
		true if the operation was successful, false otherwise"""
		...
	def SetMemberMuted(self,Index:int,Muted:bool,/)->None:
		"""SetMemberMuted.

		### Parameters:
			- Index: Index of the sub-member of the property to mute or unmute.
			- Muted: True if the sub-member is to be muted, false if it is to be unmuted."""
		...
	def SetMuted(self,Muted:bool,/)->None:
		"""SetMuted.

		### Parameters:
			- Muted: True if the property is to be muted, false if it is to be unmuted."""
		...
class FBPropertyAction(FBProperty):
	Data:bool
class FBPropertyAnimatableVector4d(FBPropertyAnimatable):
	Data:FBVector4d
	def __getitem__(self,arg2,/)->float:...
	def __len__(self)->int:...
	def __setitem__(self,arg2,arg3,/):...
	def __iter__(self)->Iterator[float]:...
class FBPropertyAnimatableVector3d(FBPropertyAnimatable):
	Data:FBVector3d
	def __getitem__(self,arg2,/)->float:...
	def __len__(self)->int:...
	def __setitem__(self,arg2,arg3,/):...
	def __iter__(self)->Iterator[float]:...
class FBPropertyAnimatableVector2d(FBPropertyAnimatable):
	Data:FBVector2d
	def __getitem__(self,arg2,/)->float:...
	def __len__(self)->int:...
	def __setitem__(self,arg2,arg3,/):...
	def __iter__(self)->Iterator[float]:...
class FBPropertyAnimatableUInt64(FBPropertyAnimatable):
	Data:int
class FBPropertyAnimatableTimeCode(FBPropertyAnimatable):
	Data:FBTimeCode
class FBPropertyAnimatableTime(FBPropertyAnimatable):
	Data:FBTime
class FBPropertyAnimatableInt64(FBPropertyAnimatable):
	Data:int
class FBPropertyAnimatableInt(FBPropertyAnimatable):
	Data:int
class FBPropertyAnimatableEnum(FBPropertyAnimatable):
	Data:Enumeration
	"""Return the string associated with the index. Will return None when no value is associated."""
class FBPropertyAnimatableDouble(FBPropertyAnimatable):
	Data:float
	@overload
	def __add__(self,arg2:FBPropertyAnimatableDouble,/)->float:...
	@overload
	def __add__(self,arg2,/)->float:...
	def __float__(self)->float:...
	@overload
	def __mul__(self,arg2:FBPropertyAnimatableDouble,/)->float:...
	@overload
	def __mul__(self,arg2,/)->float:...
	def __radd__(self,arg2,/)->float:...
	def __rmul__(self,arg2,/)->float:...
	def __rsub__(self,arg2,/)->float:...
	def __rtruediv__(self,arg2,/)->float:...
	@overload
	def __sub__(self,arg2:FBPropertyAnimatableDouble,/)->float:...
	@overload
	def __sub__(self,arg2,/)->float:...
	@overload
	def __truediv__(self,arg2:FBPropertyAnimatableDouble,/)->float:...
	@overload
	def __truediv__(self,arg2,/)->float:...
class FBPropertyAnimatableColorAndAlpha(FBPropertyAnimatable):
	Data:FBColorAndAlpha
	def __getitem__(self,arg2,/)->float:...
	def __len__(self)->int:...
	def __setitem__(self,arg2,arg3,/):...
	def __iter__(self)->Iterator[float]:...
class FBPropertyAnimatableColor(FBPropertyAnimatable):
	Data:FBColor
	def __getitem__(self,arg2,/)->float:...
	def __len__(self)->int:...
	def __setitem__(self,arg2,arg3,/):...
	def __iter__(self)->Iterator[float]:...
class FBPropertyAnimatableBool(FBPropertyAnimatable):
	Data:bool
class FBPropertyAnimatableAction(FBPropertyAnimatable):
	Data:bool
class FBRenderer(FBComponent):
	"""Open Reality renderer interface.

	[See samples: render.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_rendering_0crender_8py-example.html) [CameraSwitcher.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_camera_0c_camera_switcher_8py-example.html)"""
	AdvancedLightingMode:bool
	"""Read write Property: Turn on/off advanced lighting setting UI widgets."""
	AdvancedMaterialMode:bool
	"""Read write Property: Turn on/off advanced material setting UI widgets."""
	AutoEvaluate:bool
	"""Read Write Property: Indicate if a call to RenderBegin will also cause a re-evaluation of the scene."""
	Background:bool
	"""Read Write Property: The renderer."""
	CurrentCamera:FBCamera
	CurrentPaneCallbackIndex:int
	"""Read Write Property: Current Pane's Renderer Callback Index."""
	CurrentPaneCallbackPrefIndex:int
	"""Read Write Property: Current Pane's Renderer Callback Preference Index."""
	DisplayNormals:bool
	"""Read Write Property: Display model normals in main viewer."""
	DisplaySetUpdateId:int
	"""Read Only Property: Current DisplaySet Update Id. Add/Delete models, Show/Hide models will affect DisplaySet."""
	DisplayableGeometryCount:int
	"""Read Only Property: Displayable geometry count."""
	DisplayableLightCount:int
	"""Read Only Property: Displayable light count."""
	FrustumCulling:bool
	"""Read Write Property: Turn on/off the early frustum culling optimization."""
	HideManipulatorsOnManip:bool
	"""Read Write Property: Hide manipulators UI elements while manipulating."""
	HideManipulatorsOnPlayback:bool
	"""Read Write Property: Hide manipulators UI elements during playback."""
	IDBufferDisplay:bool
	"""Read write Property: Render Model's unique Color ID into color Buffer (used for picking)"""
	IDBufferPicking:bool
	"""Read write Property: Use ID (Color) Buffer for picking, instead of OpenGl selection buffer picking."""
	IDBufferPickingAlpha:float
	"""Read write Property: Those Semi-transparent (Alpha Blend) geometry(region) contribute less than this threshold, will be considered as invisible during ID picking."""
	PickingEnabled:bool
	"""Read Write Property: Is picking in the viewer enabled?"""
	RegisteredCallbackCount:int
	"""Read Only Property: Registered Renderer Callback Count."""
	RendererCallbacks:FBPropertyListRendererCallback
	"""List: Renderer Callbacks attached."""
	RendererUpdateId:int
	"""Read Only Property: Current Render Update Id. DisplaySet update, material change, texture changes and shader change and other operations will trigger Renderer update."""
	Scene:FBScene
	"""Read Write Property: Scene that the renderer will use/draw"""
	SelectionForceSnapPointsDisplay:bool
	"""Read write Property: Force show all feature points (pivots and etc) on selected models if true, ignore individual model's settings."""
	SelectionOverride:bool
	"""Read write Property: Add transparent color override layer on selected models if true."""
	SelectionOverrideColor:FBColor
	"""Read write Property: Selection override layer color."""
	SelectionOverrideTransparency:float
	"""Read write Property: Selection override layer transparency."""
	ShowStats:bool
	"""Read Write Property: Show the stats about FPS, Evaluation rate ... like when using Shift-F in main viewer."""
	UseCameraSwitcher:bool
	def ArrangeAllInSchematic(self,Mode:FBArrangeMode,/)->None:
		"""Request to arrange all objects in schematic view .

		### Parameters:
			- Mode: Arrange mode."""
		...
	def ArrangeObjectsInSchematicFromModel(self,Model:FBModel,/)->bool:
		"""Request to arrange a node's tree in the Schematic View, given a starting node.

		### Parameters:
			- Model: The starting node from which the arrange operation is requested.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def ArrangeSelectedObjectsInSchematic(self)->None:
		"""Request to arrange selected objects in schematic view ."""
		...
	def CreateSchematicBookmark(self,BookmarkName:str,/)->bool:
		"""Create a new bookmark in the Schematic View.

		### Parameters:
			- BookmarkName: The new bookmark name.

		### Returns:
		True if the operation is successful, false otherwise. False is returned if the bookmark name is empty or if a bookmark with the given name already exists."""
		...
	def DeleteSchematicBookmark(self,BookmarkName:str,/)->bool:
		"""Delete a bookmark from the Schematic View.

		### Parameters:
			- BookmarkName: The bookmark name to delete.

		### Returns:
		True if the operation is successful, false otherwise. False is returned if the bookmark name is empty or if no bookmark exists with the given name."""
		...
	def FrameCurrentCameraWithModels(self,All:bool,/)->bool:
		"""Frame the current camera either with all models or with the currently selected models.

		### Parameters:
			- All: true to frame with all models.

		### Returns:
		true if successful."""
		...
	def GetCameraInPane(self,PaneIndex:int,/)->FBCamera:
		"""Return the camera displayed in the given pane index.

		If the Schematic View is displayed in the pane associated with the given pane index, the returned camera is the camera that would be displayed if the Schematic View was deactivated. If the Camera Switcher is on in the pane associated with the given pane index, the returned camera is the switcher's current camera.Note: To operate current camera in Camera Switcher, it is recommended to use [FBCameraSwitcher()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/class_f_b_camera_switcher.html "Camera switcher.").
		### Parameters:
			- PaneIndex: The pane index.

		### Returns:
		The camera used in the given pane index, NULL if the pane index is invalid."""
		...
	def GetCurrentSchematicBookmarkName(self)->str:
		"""Return the current bookmark name used by the Schematic View.

		### Returns:
		The current bookmark name used by the Schematic View. An empty string is returned if there is no current bookmark."""
		...
	def GetDisplayableGeometry(self,Index:int,/)->FBModel:
		"""Get the displayable geometry model.

		Those geometry models which have Show property ON are considered as "displayable".
		### Parameters:
			- Index: displayable geometry model index to query.

		### Returns:
		displayable geometry model."""
		...
	def GetDisplayableGeometryInCameraFrustum(self,ModelList:FBModelList,Camera:FBCamera,/)->None:
		"""Get a list of displayable geometry inside given camera's frustum.

		This function will return conservative result. It's possible for some geometry outside of the frustum will be considered to be visible, but it will not skip any real visible geometry. This function should only be called in the main rendering thread.
		### Parameters:
			- ModelList: ModelList holding the return models.
			- Camera: use current camera if NULL.

		### Returns:
		Reference to pModelList. if pModelList is NULL return a const reference to internal static [FBModelList](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model_list.html "FBModelList class.") and consecutive call to this function will invalidate the result of previous call."""
		...
	def GetDisplayableLight(self,Index:int,/)->FBLight:
		"""Get the displayable light.

		Those light models which have Show property ON are considered as "displayable".
		### Parameters:
			- Index: displayable light index to query.

		### Returns:
		displayable light."""
		...
	def GetLastPickInfoList(self,PickInfosList:FBPickInfosList,/)->int:
		"""Return the last picking info list in the current view pane.

		### Parameters:
			- PickInfosList: The list of pick infos.

		### Returns:
		number of item in the list."""
		...
	def GetPaneCount(self)->int:
		"""Return the number of panes displayed in the viewer's layout.

		### Returns:
		The number of panes displayed."""
		...
	def GetSchematicBookmarkNames(self)->FBStringList:
		"""Return the bookmark names available in the Schematic View.

		### Returns:
		A string list containing the bookmark names available in the Schematic View. An empty list is returned if no bookmark is available."""
		...
	def GetSchematicNodesBoundingBox(self,arg2,/)->tuple:
		"""Returns the bounding box (top, left, bottom, right) used by all the Schematic View nodes.

		### Parameters:
			- ConsiderCollapsedNodes: True to also consider nodes which are not visible because collapsed, false otherwise.
			- Top: Top value of the bounding box. Will be filled once the method returns.
			- Left: Left value of the bounding box. Will be filled once the method returns.
			- Bottom: Bottom value of the bounding box. Will be filled once the method returns.
			- Right: Right value of the bounding box. Will be filled once the method returns.

		### Returns:
		True if the operation is successful, false otherwise (e.g. the Schematic View has any node in it, etc.)."""
		...
	def GetSchematicNodesBoundingBoxFromModel(self,Model:FBModel,arg3,/)->tuple:
		"""Returns the bounding box (top, left, bottom, right) of a node's tree in the Schematic View, given a starting node.

		### Parameters:
			- Model: The starting node from which the bounding box tree is requested.
			- ConsiderCollapsedNodes: True to also consider nodes which are not visible because collapsed, false otherwise.
			- Top: Top value of the bounding box. Will be filled once the method returns.
			- Left: Left value of the bounding box. Will be filled once the method returns.
			- Bottom: Bottom value of the bounding box. Will be filled once the method returns.
			- Right: Right value of the bounding box. Will be filled once the method returns.

		### Returns:
		True if the operation is successful, false otherwise (e.g. the starting node is not in the Schematic View, etc.)."""
		...
	def GetSchematicViewPaneIndex(self)->int:
		"""Return the pane index of the pane displaying the Schematic View.

		### Returns:
		The pane index of the pane displaying the Schematic View, -1 if the Schematic View is currently not displayed in any pane."""
		...
	def GetSelectedPaneIndex(self)->int:
		"""Return the pane index associated with the selected pane in the active viewer's layout.

		### Returns:
		The selected pane index."""
		...
	def GetViewingOptions(self)->FBViewingOptions:
		"""Obtain the current viewing options.

		### Returns:
		A structure that can be queried and updated for a call to SetViewingOptions."""
		...
	def IsCameraSwitcherInPane(self,PaneIndex:int,/)->bool:
		"""Return the Camera Switcher activeness in the given pane index.

		If the Schematic View is displayed in the pane associated with the given pane index, the returned value is the value that would be returned if the Schematic View was deactivated.
		### Parameters:
			- PaneIndex: The pane index.

		### Returns:
		True if the Camera Switcher is active in the pane associated with the given pane index, False otherwise."""
		...
	def IsCurrentSchematicBookmarkDirty(self)->bool:
		"""Return if the current bookmark used by the Schematic View is dirty or not.

		### Returns:
		True if the current bookmark is dirty, false otherwise. False is returned if there is no current bookmark."""
		...
	def IsModelInsideCameraFrustum(self,Geometry:FBModel,Camera:FBCamera,/)->bool:
		"""To tell if given model is located inside camera's frustum.

		This function will return conservative result. It's possible for some geometry outside of the frustum will be considered to be visible, but it will not skip any real visible geometry. This function should only be called in the main rendering thread.
		### Parameters:
			- Geometry: the geometry to be queried.
			- Camera: use current camera if NULL.

		### Returns:
		true if Model is inside camera frustum."""
		...
	def KeyboardInput(self,KeyIndex:FBDeviceKeyboardKey,KeyState:bool,IsTrigger:bool=False,/)->None:
		"""Keyboard input.

		### Parameters:
			- KeyIndex: Key index. (See "enum FBDeviceKeyboardKey" above for supported keys)
			- KeyState: Key state. (True == key is down, False == key is up)
			- IsTrigger: When setting pKeyState to True, resets key state to False right after operation."""
		...
	def MouseInput(self,X:int,Y:int,InputType:FBInputType,ButtonKey:int,Modifier:FBInputModifier,WheelDeltaValue:int=0,Layer:int=-1,/)->bool:
		"""Mouse input.

		### Parameters:
			- X: X position.
			- Y: Y position.
			- InputType: Type of input.
			- ButtonKey: Button/Key pressed.
			- Modifier: Modifier pressed (CTRL/ALT/SHIFT).
			- WheelDeltaValue: Mouse wheel delta value
			- Layer: Rendering layer ID(default=-1).

		### Returns:
		true if successful."""
		...
	def MouseInputNormalized(self,X:float,Y:float,InputType:FBInputType,ButtonKey:int,Modifier:FBInputModifier,WheelDeltaValue:int|None=None,Layer:int=-1,PaneId:int=-1,/)->bool:
		"""Mouse input.

		### Parameters:
			- X: X position, normalized to the range of [0, 1] in the view port dimension.
			- Y: Y position, normalized to the range of [0, 1] in the view port dimension.
			- InputType: Type of input.
			- ButtonKey: Button/Key pressed.
			- Modifier: Modifier pressed (CTRL/ALT/SHIFT).
			- WheelDeltaValue: Mouse wheel delta value
			- Layer: Rendering layer ID(default=-1).
			- PaneId: specify which pane's dimension used for normalization, default (-1) for the whole viewer.

		### Returns:
		true if successful."""
		...
	def OGLModelDisplay(self,RenderOptions:FBRenderOptions,Model:FBModel,/)->None:...
	def OGLSetupSceneLights(self,RenderOptions:FBRenderOptions,/)->None:
		"""Setup the scene lights in OpenGL.

		### Parameters:
			- RenderOptions: See [FBRenderOptions](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_render_options.html) for more detail."""
		...
	def Pick(self,arg2,arg3,PickInfosList:FBPickInfosList,/)->bool:
		"""Object picking selection.

		### Parameters:
			- X: X position.
			- Y: Y position.
			- PickInfosList: The list of pick infos.
			- NeedIntersectPosition: require valid intersection position if true, this will take more time to process, and not reliable with very dense mesh."""
		...
	def PickNormalized(self,X:float,Y:float,PickInfosList:FBPickInfosList,arg5=None,/)->bool:
		"""Object picking selection.

		### Parameters:
			- X: X position, normalized to the range of [0, 1] in the view port dimension.
			- Y: Y position, normalized to the range of [0, 1] in the view port dimension.
			- PickInfosList: The list of pick infos.
			- NeedIntersectPosition: require valid intersection position if true, this will take more time to process, and not reliable with very dense mesh.
			- PaneId: specify which pane's dimension used for normalization, default (-1) for the whole viewer."""
		...
	def PreRender(self,Layer:int=-1,/)->bool:
		"""PreRenders one frame (needed for some shaders) This functions destroys the frame buffer content and must be called every time a render is called the typical order of call must be Renderer->Prerender // at this point the frame buffer is garbage -Clear the ogl -Do your render functions Renderer->Render.

		### Parameters:
			- Layer: Rendering layer ID(default=-1).

		### Returns:
		true if successful."""
		...
	def RectPick(self,X1:int,Y1:int,X2:int,Y2:int,PickInfosList:FBPickInfosList,/)->bool:
		"""Object rectangle selection.

		### Parameters:
			- X1: Left upper corner X position.
			- Y1: Left upper corner y position.
			- X2: Right bottom corner X position.
			- Y2: Right bottom corner y position.
			- PickInfosList: The list of pick infos."""
		...
	def RectPickNormalized(self,X1:float,Y1:float,X2:float,Y2:float,PickInfosList:FBPickInfosList,PaneId:int=-1,/)->bool:
		"""Object rectangle selection.

		### Parameters:
			- X1: Left upper corner X position, normalized to the range of [0, 1] in the viewport dimension.
			- Y1: Left upper corner y position, normalized to the range of [0, 1] in the viewport dimension.
			- X2: Right bottom corner X position, normalized to the range of [0, 1] in the viewport dimension.
			- Y2: Right bottom corner y position, normalized to the range of [0, 1] in the viewport dimension.
			- PickInfosList: The list of pick infos.
			- PaneId: specify which pane's dimension used for normalization, default (-1) for the whole viewer."""
		...
	def RenameSchematicBookmark(self,OldBookmarkName:str,NewBookmarkName:str,/)->bool:
		"""Rename a bookmark in the Schematic View.

		### Parameters:
			- OldBookmarkName: The bookmark name to rename.
			- NewBookmarkName: The new bookmark name.

		### Returns:
		True if the operation is successful, false otherwise. False is returned if the old/new bookmark name is empty, if the old bookmark doesn't exist or if a bookmark with the new given name already exists."""
		...
	def Render(self,Layer:int=-1,/)->bool:
		"""Renders one frame.

		### Parameters:
			- Layer: Rendering layer ID(default=-1).

		### Returns:
		true if successful."""
		...
	def RenderBegin(self,X:int,Y:int,W:int,H:int,/)->bool:
		"""RenderBegin.

		must be called before rendering can happen
		### Parameters:
			- X: X position where to render.
			- Y: Y position where to render.
			- W: Width of render area.
			- H: Hight of render area."""
		...
	def RenderEnd(self)->bool:
		"""RenderEnd.

		### Parameters:
			- View: If you want the renderer to draw artifacts, such as TimeCode, CameraLabel or SafeArea, you must provide the [FBView](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_view.html "Generic view.") on which the renderer draws on.

		### Remarks:
		Must be called at the end of rendering."""
		...
	def SelectSchematicBookmark(self,BookmarkName:str,/)->bool:
		"""Select an existing bookmark in the Schematic View and use it as the current bookmark.

		### Parameters:
			- BookmarkName: The bookmark name to select.

		### Returns:
		True if the operation is successful, false otherwise. False is returned if the bookmark name is empty or if no bookmark exists with the given name."""
		...
	def SetCameraInPane(self,Camera:FBCamera,PaneIndex:int,/)->None:
		"""Set the camera to display in the given pane index.

		If the Schematic View is displayed in the pane associated with the given pane index, the camera will be displayed when the Schematic View will be deactivated from this pane.Note: If current pane uses Camera Switcher, it will be set to use Camera, rather than old behavior that still uses Camera Switcher and sets Camera to be Camera Switcher's current camera, which introduce a Zombie Camera Switcher problem. By using Camera, the problem is gone.Note: To operate current camera in Camera Switcher, it is recommended to use [FBCameraSwitcher()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/class_f_b_camera_switcher.html "Camera switcher.").
		### Parameters:
			- Camera: The camera to set.
			- PaneIndex: The pane index."""
		...
	def SetCameraSwitcherInPane(self,PaneIndex:int,Active:bool,/)->None:
		"""Set/Remove the Camera Switcher in the given pane index.

		To specify which camera the Camera Switcher should be displaying, use the SetCameraInPane method. If the Schematic View is displayed in the pane associated with the given pane index, the camera switcher will be displayed (if activated) when the Schematic View will be deactivated from this pane.
		### Parameters:
			- PaneIndex: The pane index.
			- Active: True to activate the Camera Switcher in the given pane, False to remove it."""
		...
	def SetPaneCount(self,PaneCount:int,/)->None:
		"""Set the number of panes to display in the viewer's layout.

		### Parameters:
			- PaneCount: The number of panes to display."""
		...
	def SetSchematicViewInPane(self,PaneIndex:int,Active:bool,/)->None:
		"""Set/Remove the Schematic View in the given pane index.

		When activating the Schematic View in the pane, if the Schematic View is already activated in another pane, the Schematic View will be removed from latter before being activated into the new pane.
		### Parameters:
			- PaneIndex: The pane index.
			- Active: True to activate the Schematic View in the given pane, False to remove it."""
		...
	def SetSelectedPaneIndex(self,PaneIndex:int,/)->bool:
		"""Select the pane associated with the given pane index in the active viewer's layout.

		### Parameters:
			- PaneIndex: The pane index.

		### Returns:
		True if the operation is successful, False otherwise."""
		...
	def SetViewingOptions(self,Options:FBViewingOptions,/)->bool:
		"""Set the viewing options.

		### Parameters:
			- Options: See [FBViewingOptions](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_viewing_options.html "Viewing options for rendering.") for more detail."""
		...
	def SetViewport(self,X:int,Y:int,W:int,H:int,/)->None:
		"""Must be called before inputing if the same renderer is used on multiple views/cameras in the same application.

		### Parameters:
			- X: X position where to render.
			- Y: Y position where to render.
			- W: Width of render area.
			- H: Hight of render area."""
		...
	def UpdateCurrentSchematicBookmark(self)->bool:
		"""Update the current bookmark in the Schematic View.

		### Returns:
		True if the operation is successful, false otherwise. False is returned if there is no current bookmark."""
		...
class FBProgress(FBComponent):
	"""Progress bar. Property: Base property class.

	[See samples: 3dsMaxBipedTemplate.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c3ds_max_biped_template_8py-example.html) [MirrorPoseOverTime.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_mirror_pose_over_time_8py-example.html) [FBProgress.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_f_b_progress_8py-example.html)

	A property is a holder for function callbacks into the internals of the application.You cannot instantiate [FBProperty](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property.html "Generic application property.") objects. To reference a property: Use an instance of an [FBComponent](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html "MotionBuilder SDK base class.") object. The methods [FBComponent::PropertyCreate](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html#a154c4f7b5a26f60b373d9bb4fa37dfb1 "Create user or dynamic property.") and [FBComponent::PropertyRemove](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html#ab54e85a44712cff01a617655269d3d16 "Remove a Property from the component's Property manager.") can be used to modify an object's set of properties. When accessing a [FBProperty](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property.html "Generic application property.") object via its containing object, you can get or set (assuming it is not read-only) its value directly, for example in Python: myObject.Visibility = True. [FBPropertyManager](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_property_manager.html "Property Manager.") exists in all [FBComponent](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html "MotionBuilder SDK base class.") objects, and contains an array of all the registered properties. Use FBProperty::Find to find a property by name. When accessing a property reference directly, its value is obtained via its 'Data' member.

	```python
	myProp = myObject.PropertyList.Find( 'Visibility' )
	if myProp: myProp.Data = True
	```
	To see how to create a custom property in Python, see CustomProperty.py.

	[See samples: CustomProperty.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_custom_property_8py-example.html) [SetAllToDoneInAllTakes.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_set_all_to_done_in_all_takes_8py-example.html)"""
	Caption:str
	"""Read Write Property: Caption to be displayed for progress bar."""
	Percent:int
	"""Read Write Property: Percent completed for the operation. Must be used called in between [ProgressBegin()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_progress.html#a74b65ec9004d7726cb2eb88eac9f0929 "Start progress, must be called before set Text & Percent property.")/ProgressDone()"""
	Text:str
	"""Read Write Property: Text to display on progress bar. Must be used in between [ProgressBegin()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_progress.html#a74b65ec9004d7726cb2eb88eac9f0929 "Start progress, must be called before set Text & Percent property.")/ProgressDone()"""
	def ProgressBegin(self)->None:
		"""Start progress, must be called before set Text & Percent property."""
		...
	def ProgressDone(self)->None:
		"""End progress, must be called to reset progress bar UI to normal status after finishing the task."""
		...
	def UserRequestCancell(self)->bool:
		"""Return true if User is pressing and holding "ESC" key to request the cancellation.

		Must be called in between [ProgressBegin()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_progress.html#a74b65ec9004d7726cb2eb88eac9f0929 "Start progress, must be called before set Text & Percent property.")/ProgressDone()."""
		...
	def __init__(self):...
class FBProfiler(FBComponent):
	"""[FBProfiler](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_profiler.html "FBProfiler.").

	Central place to query profiling results and change profiling options.

	[See sample: CreateProfilingEventsLog.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_profiling_0c_create_profiling_events_log_8py-example.html)"""
	ActiveSampling:bool
	"""Read/Write Property: Activate the sampling for time events. Call before quering for [FBProfileTimeEvent](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_profile_time_event.html "FBProfileTimeEvent.")."""
	BufferSize:int
	"""Read/Write Property: Buffer size for average and timing computation (maximum value 200)."""
	EvaluationDepth:int
	"""Read/Write Property: Specify the depth of evaluation profiling for data collection (maximum value is 10)."""
	FrameReference:bool
	"""Read/Write Property: Draw task cycles in relation to main thread cycle time - frame cycle (percentage display)."""
	ProfilingMode:FBProfilingMode
	"""Read/Write Property: Profiling collection modes, including disabling all profiling."""
	def GetEndEventSample(self,Index:int,/)->FBProfileTimeEvent:
		"""Get end time event for event at given index.

		This function and [FBProfileTimeEvent.IsSingleEvent](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_profile_time_event.html#ade7a7e9faef91891c22be75fcc97a0cc "Three types of events exits: single, start and end.") are useful to identify duration of event action.
		### Parameters:
			- Index: Sample index.

		### Returns:
		Sample object if sample at given index is start sample."""
		...
	def GetEventSample(self,Index:int,/)->FBProfileTimeEvent:
		"""Only possible way to query collected [FBProfileTimeEvent](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_profile_time_event.html "FBProfileTimeEvent.").

		### Parameters:
			- Index: Sample index.

		### Returns:
		Sample object."""
		...
	def GetEventSampleCount(self)->int:
		"""Get number of time event samples collected during last sampling.

		### Returns:
		Number of [FBProfileTimeEvent](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_profile_time_event.html "FBProfileTimeEvent.") samples gathered during sampling."""
		...
	def GetProfilingCost(self)->float:
		"""Profiling collection can affect scene performace.

		This function return how costly is profiling.
		### Returns:
		Cost of profiling the scene. (in mini seconds)"""
		...
	def GetStatComment(self,Index:int,/)->str:
		"""Get aditional information about what action is stat refering to.

		### Parameters:
			- Index: Index of stat.

		### Returns:
		Stat comment."""
		...
	def GetStatCount(self)->int:
		"""Stats are holding last execution time/duration of action.

		They are used for actions that doesn't appear frequently, like file IO.
		### Returns:
		Stats count. They are created when stat occurs, so open or save action needs to be done first to get any information stored in stats."""
		...
	def GetStatDuration(self,Index:int,/)->float:
		"""Get time that was spend on execution of action.

		### Parameters:
			- Index: Index of stat.

		### Returns:
		Stat duration (in seconds)."""
		...
	def GetStatIndex(self,Name:str,/)->int:
		"""Search for index of given stat name.

		### Parameters:
			- Name: Name of the sample that we are looking for.

		### Returns:
		Stat index if found, -1 if not in the list."""
		...
	def GetStatName(self,Index:int,/)->str:
		"""Get information about what action is stat refering to.

		### Parameters:
			- Index: Index of stat.

		### Returns:
		Stat name."""
		...
	def GetStatStart(self,Index:int,/)->float:
		"""Get start time of action.

		### Parameters:
			- Index: Index of stat.

		### Returns:
		Start time (in seconds)."""
		...
	def GetStatStop(self,Index:int,/)->float:
		"""Get stop time of action.

		### Parameters:
			- Index: Index of stat.

		### Returns:
		Stop time (in seconds)."""
		...
	def __init__(self):...
class FBPose(FBComponent):
	"""Pose class."""
	Type:FBPoseType
	"""Read Only Property: Type of the pose (bind pose or rest pose)"""
	def AddNode(self,Object:FBModel,Matrix:FBMatrix|None=None,IsLocalMatrix:bool=False,/)->int:
		"""Add a new pose node.

		### Parameters:
			- Object: The object for which we are creating the pose information.
			- Matrix: The transformation of the object we want to save.
			- IsLocalMatrix: Is the matrix a local matrix?"""
		...
	def CreatePoseThumbnail(self)->None:
		"""Create an image thumbnail for the current pose."""
		...
	def Find(self,NodeName:str,/)->int:
		"""Look in this pose if the given node is present.

		### Parameters:
			- NodeName: Name of the node we are looking for.

		### Returns:
		-1 if the node is not in the list or it's position."""
		...
	def GetNodeCount(self)->int:
		"""Returns the number of pose nodes stored."""
		...
	def GetNodeMatrix(self,Index:int,/)->FBMatrix:
		"""Get the pose node matrix.

		### Parameters:
			- Index: Index of the node.

		### Returns:
		a reference to the node's Matrix.
		### Remarks:
		if the index is invalid a reference to an identiy matrix is returned.

		The reference will become undefined if this object is destroyed."""
		...
	def GetNodeName(self,Index:int,/)->str:
		"""Get the pose node at specified index.

		### Parameters:
			- Index: Index of the node.

		### Remarks:
		if the index is invalid a reference to an empty string is returned.

		The reference will become undefined if this object is destroyed."""
		...
	def GetNodeObject(self,Index:int,/)->FBModel:
		"""Get the pose node object.

		### Parameters:
			- Index: Index of the node.

		### Returns:
		a pointer to the node's Object.
		### Remarks:
		if the index is invalid a null pointer is returned."""
		...
	def IsNodeLocalMatrix(self,Index:int,/)->bool:
		"""Get the type of the Matrix for a given node.

		### Parameters:
			- Index: Index of the node.

		### Returns:
		true if the matrix is defined in Local coordinate space.
		### Remarks:
		If this object is configured to hold BindPose data, this method will always return false."""
		...
	def RemoveNode(self,Index:int,/)->None:
		"""Remove the pose node at specified index.

		### Parameters:
			- Index: Index of the node to be removed."""
		...
	def SetIsNodeLocalMatrix(self,Index:int,IsNodeLocalMatrix:bool,/)->None:
		"""Set the type of the Matrix for a given node.

		### Parameters:
			- Index: Index of the node.
			- IsNodeLocalMatrix: True if the matrix of the node is a local matrix."""
		...
	def SetNodeMatrix(self,Index:int,Matrix:FBMatrix,/)->None:
		"""Set the pose node matrix.

		### Parameters:
			- Index: Index of the node.
			- Matrix: Matrix to set for this pose node."""
		...
	def SetNodeObject(self,Index:int,Object:FBModel,/)->None:
		"""Set the pose node object.

		### Parameters:
			- Index: Index of the node.
			- Object: Object to associate with this pose node."""
		...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of pose."""
		...
class FBPointCacheManager(FBComponent):
	"""Point Cache Manager Interface to the point cache manager.

	[See sample: CharacterPointCache.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_point_cache_0c_character_point_cache_8py-example.html)"""
	AllowCacheResampling:bool
	"""Read Write Property: Allow the resample models's existing point cache deformation when true."""
	AlwaysAskForPath:bool
	"""Read Write Property: Always ask for the point cache file save path when true."""
	ApplyCacheOnNewModel:bool
	"""Read Write Property: Duplicated the cached models, and assoicated the point cache to the new models."""
	ApplyGlobalTransform:bool
	"""Read Write Property: Include no-deformable models and the global transform to Vertex Cache when true."""
	CacheAABBox:bool
	"""Read Write Property: Cache AABBox (Axis Aligned Bounding Box) when true."""
	CacheNormal:bool
	"""Read Write Property: Cache normal when true."""
	CreateFilePerFrameCache:bool
	"""Read Write Property: Create the point cache file for each frame when true."""
	CreateMultiChannelCache:bool
	"""Read Write Property: Create a single multiple channel point cache file for all models when true."""
	DefaultPath:str
	"""Read Write Property: Default point cache file save path."""
	Models:FBPropertyListObject
	"""Read Write Property: Models to be recorded"""
	NewModelRoot:FBModel
	"""Read Write Property: Valid only when ApplyCacheOnNewModel is on. Create New Models under NewModelRoot. otherwise, a NULL model will be created."""
	SaveEveryFrame:int
	"""Read Write Property: Recording Frequency."""
	def SetTransformReference(self)->None:
		"""Action Property: Set the model's current transformation as the reference."""
		...
	def __init__(self):...
class FBCharacterPose(FBPose):
	"""Used to work with character poses.

	This class exposes the object used to store the pose of objects.

	[See sample: MirrorPoseOverTime.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_mirror_pose_over_time_8py-example.html)"""
	def ApplyPoseCandidate(self)->None:
		"""After setting the candidate on the skeleton node, calling this function will allow subsequent call to get the TRS value of a skeleton node to return the candidate value."""
		...
	def ClearCharacterExtensionsPose(self)->None:
		"""Clear only the pose of the character extensions (omit the character)."""
		...
	def ClearCharacterPose(self)->None:
		"""Clear only the pose of the character (omit the extensions)."""
		...
	def ClearPose(self)->None:
		"""Clear all the data of the pose."""
		...
	def CopyFrom(self,FromPose:FBCharacterPose,/)->None:
		"""Copy everything from a given object.

		### Parameters:
			- FromPose: Pose from which to copy.

		### Remarks:
		Will copy everything, including the object name, properties, data etc. Objects will be identical."""
		...
	def CopyPose(self,Character:FBCharacter,/)->None:
		"""Copy the pose of a character and its extensions.

		### Parameters:
			- Character: Character to copy the pose from."""
		...
	def CopyPoseCharacter(self,Character:FBCharacter,/)->None:
		"""Copy the pose of only the character (omit the extensions).

		### Parameters:
			- Character: Character to copy the pose from."""
		...
	def CopyPoseCharacterExtension(self,CharacterExtension:FBCharacterExtension,/)->None:
		"""Copy the pose of a single character extension.

		### Parameters:
			- CharacterExtension: Character extension to copy the pose from."""
		...
	def CopyPoseCharacterExtensions(self,Character:FBCharacter,/)->None:
		"""Copy the pose of only the character extensions (omit the character).

		### Parameters:
			- Character: Character to copy the pose of the extensions from."""
		...
	def CopyPoseCharacterExtensionsFrom(self,FromPose:FBCharacterPose,/)->None:
		"""Copy the pose data of only the character extensions from a given pose.

		### Parameters:
			- FromPose: Pose from which to copy the data."""
		...
	def CopyPoseCharacterFrom(self,FromPose:FBCharacterPose,/)->None:
		"""Copy the pose data of only the character from a given pose.

		### Parameters:
			- FromPose: Pose from which to copy the data."""
		...
	def CopyPoseDataFrom(self,FromPose:FBCharacterPose,/)->None:
		"""Copy all the pose data from a given pose.

		### Parameters:
			- FromPose: Pose from which to copy the data.

		### Remarks:
		Will copy all the data of the pose."""
		...
	def GetCharacterExtensionNameFromPose(self,CharacterExtensionPose:FBObjectPose,/)->str:
		"""Get the name of the character extension for the specified pose.

		### Parameters:
			- CharacterExtensionPose: Pose of a character extension to check its name.

		### Returns:
		The name of the character extension (It is the label name of the character extension)."""
		...
	def GetCharacterExtensionPose(self,CharacterExtensionName:str,/)->FBObjectPose:
		"""Get the pose of a character extension.

		### Parameters:
			- CharacterExtensionName: Name of the character extension pose to get (It is the label name of the character extension).

		### Returns:
		The pose of the character extension, NULL if not found."""
		...
	def GetCharacterExtensionPoseAt(self,Index:int,/)->FBObjectPose:
		"""Get the pose of a character extension.

		### Parameters:
			- Index: Index of the character extension pose to get.

		### Returns:
		The pose of the character extension."""
		...
	def GetCharacterExtensionPoseCount(self)->int:
		"""Get the number of character extension stored in the pose.

		### Returns:
		Number of character extension stored in the pose."""
		...
	def GetExtraBoneParentRotationOffset(self,R:FBVector3d,Index:int,/)->None:
		"""Get the extra bone transformation offset.

		### Parameters:
			- R: A vector that will contains the parent rotation offset value on return.
			- Index: Index of the extra bone to get."""
		...
	def GetExtraBoneTransform(self,T:FBVector3d,R:FBVector3d,S:FBVector3d,Index:int,/)->None:
		"""Get the extra bone transformation.

		### Parameters:
			- T: A vector that will contains the translation value on return.
			- R: A vector that will contains the rotation value on return.
			- S: A vector that will contains the scale value on return.
			- Index: Index of the extra bone to get."""
		...
	def GetExtraBoneTransformOffset(self,T:FBVector3d,R:FBVector3d,S:FBVector3d,Index:int,/)->None:
		"""Get the extra bone transformation offset.

		### Parameters:
			- T: A vector that will contains the translation offset value on return.
			- R: A vector that will contains the rotation offset value on return.
			- S: A vector that will contains the scale offset value on return.
			- Index: Index of the extra bone to get."""
		...
	def GetExtraBones(self)->list:...
	def GetMirrorPlaneEquation(self,MirrorPlaneEquation:FBVector4d,Character:FBCharacter,CharacterPoseOptions:FBCharacterPoseOptions,/)->None:
		"""Get the mirror plane equation that would be used to mirror according to the CharacterPoseOptions.

		### Parameters:
			- MirrorPlaneEquation: Out: Mirror plane equation.
			- Character: Character to receive the pose.
			- CharacterPoseOptions: Options used to paste the pose."""
		...
	def GetOrCreateCharacterExtensionPose(self,CharacterExtensionName:str,/)->FBObjectPose:
		"""Get the pose of a character extension and create it if necessary.

		### Parameters:
			- CharacterExtensionName: Name of the character extension pose to get (It is the label name of the character extension).

		### Returns:
		The pose of the character extension.
		### Remarks:
		Use this function to manually add a pose of a character extension."""
		...
	def IsCharacterExtensionPoseStored(self,CharacterExtensionName:str,/)->bool:
		"""Is the pose of the character extension stored in the pose?

		### Parameters:
			- CharacterExtensionName: Name of the character extension.

		### Returns:
		true if the pose of the character extension stored in the pose."""
		...
	def IsCharacterPoseStored(self)->bool:
		"""Is the pose of the character stored in the pose?

		### Returns:
		true if the pose of the character stored in the pose."""
		...
	def PastePose(self,Character:FBCharacter,CharacterPoseOptions:FBCharacterPoseOptions,/)->None:
		"""Paste the pose of a character and its extensions.

		### Parameters:
			- Character: Character to paste the pose to.
			- CharacterPoseOptions: Options used to specify how to paste.

		### Remarks:
		Supports the match and mirror options.

		When pasting in body part, the selected parts and extensions of the character will be pasted."""
		...
	def PastePoseCharacter(self,Character:FBCharacter,CharacterPoseOptions:FBCharacterPoseOptions,/)->None:
		"""Paste the pose of only the character (omit the extensions).

		### Parameters:
			- Character: Character to paste the pose to.
			- CharacterPoseOptions: Options used to specify how to paste.

		### Remarks:
		Does not support the match and mirror options."""
		...
	def PastePoseCharacterExtension(self,CharacterExtension:FBCharacterExtension,CharacterPoseOptions:FBCharacterPoseOptions,/)->None:
		"""Paste the pose of a single character extension.

		### Parameters:
			- CharacterExtension: Character extension to paste the pose to.
			- CharacterPoseOptions: Options used to specify how to paste.

		### Remarks:
		Does not support the match and mirror options."""
		...
	def PastePoseCharacterExtensions(self,Character:FBCharacter,CharacterPoseOptions:FBCharacterPoseOptions,/)->None:
		"""Paste the pose of only the character extensions (omit the character).

		### Parameters:
			- Character: Character to paste the pose of the extensions to.
			- CharacterPoseOptions: Options used to specify how to paste.

		### Remarks:
		Does not support the match and mirror options."""
		...
	def RemoveCharacterExtensionPose(self,CharacterExtensionName:str,/)->None:
		"""Remove the pose of a character extension.

		### Parameters:
			- CharacterExtensionName: Name of the character extension pose to remove (It is the label name of the character extension)."""
		...
	def RemoveCharacterExtensionPoseAt(self,Index:int,/)->None:
		"""Remove the pose of a character extension.

		### Parameters:
			- Index: Index of the character extension pose to remove."""
		...
	def __init__(self,Name:str,/):
		"""Public constructor.

		This constructor is used to create a new object.
		### Parameters:
			- Name: Object name."""
		...
class FBObjectPose(FBPose):
	"""[FBObjectPose](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_object_pose.html "FBObjectPose class.") class.

	This class exposes the object used to store the pose of objects."""
	def AddStanceOffset(self,ObjectName:str,StancePose:FBObjectPose,PoseTransformType:FBPoseTransformType=FBPoseTransformType.kFBPoseTransformInvalid,/)->None:
		"""Add the StanceOffset to an object in the pose.

		### Parameters:
			- ObjectName: Name of the object.
			- StancePose: Pose representing the stance of all objects.
			- PoseTransformType: Transform type in which to add the offset (Local, Global or LocalRef).

		### Remarks:
		Working with poses with their StanceOffset removed is usefull for retargetting.

		If pPoseTransformType is set to kFBPoseTransformInvalid, offsets will be added in all TransformTypes."""
		...
	def AddStanceOffsetAllObjects(self,StancePose:FBObjectPose,PoseTransformType:FBPoseTransformType=FBPoseTransformType.kFBPoseTransformInvalid,/)->None:
		"""Add the StanceOffset to all the objects in the pose.

		### Parameters:
			- StancePose: Pose representing the stance of all objects.
			- PoseTransformType: Transform type in which to add the offset (Local, Global or LocalRef).

		### Remarks:
		Working with poses with their StanceOffset removed is usefull for retargetting.

		If pPoseTransformType is set to kFBPoseTransformInvalid, offsets will be added in all TransformTypes."""
		...
	def ClearPose(self)->None:
		"""Clear all the data of the pose."""
		...
	def CopyFrom(self,FromPose:FBObjectPose,/)->None:
		"""Copy everything from a given object.

		### Parameters:
			- FromPose: Pose from which to copy.

		### Remarks:
		Will copy everything, including the object name, properties, data etc. Objects will be identical."""
		...
	def CopyObjectPose(self,ObjectName:str,Object:FBComponent,/)->None:
		"""Copy the pose of all the properties of an object.

		### Parameters:
			- ObjectName: Name of the object to store in the pose.
			- Object: Object from which we'll read all the property values to store in the pose.

		### Remarks:
		You can specify a pObjectName different from the name of pObject."""
		...
	def CopyPoseAllObjectsTransformFrom(self,FromPose:FBObjectPose,PoseTransformType:FBPoseTransformType=FBPoseTransformType.kFBPoseTransformInvalid,/)->None:
		"""Copy all the transforms from a given pose.

		### Parameters:
			- FromPose: Pose from which to copy the data.
			- PoseTransformType: Transform type from which to copy the transform (Local, Global or LocalRef).

		### Remarks:
		If pPoseTransformType is set to kFBPoseTransformInvalid, copy all TransformTypes."""
		...
	def CopyPoseDataFrom(self,FromPose:FBObjectPose,/)->None:
		"""Copy all the pose data from a given pose.

		### Parameters:
			- FromPose: Pose from which to copy the data.

		### Remarks:
		Will copy all the data of the pose including the transforms."""
		...
	def CopyPoseTransformFrom(self,FromPose:FBObjectPose,ObjectName:str,PoseTransformType:FBPoseTransformType=FBPoseTransformType.kFBPoseTransformInvalid,/)->None:
		"""Copy the transforms of an object from a given pose.

		### Parameters:
			- FromPose: Pose from which to copy the data.
			- ObjectName: Name of object to copy the transform from.
			- PoseTransformType: Transform type from which to copy the transform (Local, Global or LocalRef).

		### Remarks:
		If pPoseTransformType is set to kFBPoseTransformInvalid, copy all TransformTypes."""
		...
	def CopyPropertyPose(self,ObjectName:str,Property:FBProperty,/)->None:
		"""Copy the pose of a property of an object.

		### Parameters:
			- ObjectName: Name of the object to store in the pose.
			- Property: Property from which we'll read the value to store in the pose.

		### Remarks:
		You can specify a pObjectName different from the name of pObject."""
		...
	def CopyTransform(self,ObjectName:str,Object:FBComponent,ObjectPoseOptions:FBObjectPoseOptions,/)->None:
		"""Copy the transform of an object.

		### Parameters:
			- ObjectName: Name of the object to store in the pose.
			- Object: Object from which we'll evaluate the transform values to store in the pose.
			- ObjectPoseOptions: PoseOptions used to specify the transform of the reference object (Default: Identity).

		### Remarks:
		This function will always copy all the TransformAttributes (T,R,S) in all TransformType (Local, Global, LocalRef)."""
		...
	def GetPropertyValue(self,Value:list,Size:int,ObjectName:str,PropertyName:str,/)->None:
		"""Get the value of a property stored in the pose.

		### Parameters:
			- Value: Value to get.
			- Size: Number of elements in pValue.
			- ObjectName: Name of the object to get the value.
			- PropertyName: Name of the property to get the value."""
		...
	def GetStoredObjectNames(self)->FBStringList:
		"""Get all the object names currently stored in this pose.

		### Returns:
		All the object names currently stored in this pose."""
		...
	def GetTransform(self,T:FBVector4d,RM:FBMatrix,SM:FBMatrix,ObjectName:str,PoseTransformType:FBPoseTransformType,/)->bool:
		"""Get the transform of an object in the pose.

		### Parameters:
			- T: Translation to get.
			- RM: Rotation to get.
			- SM: Scaling to get.
			- ObjectName: Name of the object to get the transform.
			- PoseTransformType: Transform type in which to set the transform (Local, Global or LocalRef).

		### Returns:
		True if the transform was found in the pose."""
		...
	def IsPropertyPoseable(self,Property:FBProperty,/)->bool:
		"""Is the property poseable?

		### Returns:
		True if the value of this property can be stored in the pose."""
		...
	def IsPropertyStored(self,ObjectName:str,PropertyName:str,/)->bool:
		"""Is the property stored in the pose?

		### Parameters:
			- ObjectName: Name of the object.
			- PropertyName: Name of the property.

		### Returns:
		True if the property is stored in the pose."""
		...
	def IsTransformStored(self,ObjectName:str,PoseTransformType:FBPoseTransformType=FBPoseTransformType.kFBPoseTransformInvalid,/)->bool:
		"""Is the transform of this object stored in the specified TransformType?

		### Parameters:
			- ObjectName: Name of the object.
			- PoseTransformType: Transform type in which to check.

		### Returns:
		True if the transform of this object is stored in the specified TransformType (Local, Global and LocalRef).
		### Remarks:
		If pPoseTransformType is set to kFBPoseTransformInvalid, will check in all TransformTypes."""
		...
	def MirrorPose(self,ObjectName:str,ObjectPoseMirrorOptions:FBObjectPoseMirrorOptions,/)->None:
		"""Mirror the transform of an object in the pose.

		### Parameters:
			- ObjectName: Name of the object to mirror.
			- ObjectPoseMirrorOptions: MirrorOptions used to specify the mirror plane."""
		...
	def MirrorPoseAllObjects(self,ObjectPoseMirrorOptions:FBObjectPoseMirrorOptions,/)->None:
		"""Mirror the transform of all objects in the pose.

		### Parameters:
			- ObjectPoseMirrorOptions: MirrorOptions used to specify the mirror plane."""
		...
	def MultTransform(self,ObjectName:str,GX:FBMatrix,TransformAttribute:FBModelTransformationType,PoseTransformType:FBPoseTransformType,/)->None:
		"""Multiply the transform of an objects in the pose.

		### Parameters:
			- ObjectName: Name of the object.
			- GX: Transformation matrix to apply.
			- TransformAttribute: Transform attribute to affect. Supported: T,R,S and Transformation.
			- PoseTransformType: Transform type in which to mult the transform (Local, Global or LocalRef)."""
		...
	def MultTransformAllObjects(self,GX:FBMatrix,TransformAttribute:FBModelTransformationType,PoseTransformType:FBPoseTransformType,/)->None:
		"""Multiply the transform of all objects in the pose.

		### Parameters:
			- GX: Transformation matrix to apply.
			- TransformAttribute: Transform attribute to affect. Supported: T,R,S and Transformation.
			- PoseTransformType: Transform type in which to mult the transform (Local, Global or LocalRef)."""
		...
	def PasteObjectPose(self,ObjectName:str,Object:FBComponent,/)->None:
		"""Paste the pose of all the properties of an object.

		### Parameters:
			- ObjectName: Name of the object stored in the pose.
			- Object: Object which will receive the values stored in the pose.

		### Remarks:
		You can specify a pObjectName different from the name of pObject.

		Properties that were not stored in the pose will not be affected."""
		...
	def PastePropertyPose(self,ObjectName:str,Property:FBProperty,/)->None:
		"""Paste the pose of a property of an object.

		### Parameters:
			- ObjectName: Name of the object stored in the pose.
			- Property: Property which will receive the value stored in the pose.

		### Remarks:
		You can specify a pObjectName different from the name of pObject.

		The property will not be affected if it was not stored in the pose."""
		...
	def PasteTransform(self,ObjectName:str,Object:FBComponent,ObjectPoseOptions:FBObjectPoseOptions,/)->None:
		"""Paste the transform of an object.

		### Parameters:
			- ObjectName: Name of the object stored in the pose.
			- Object: Object which will receive the transform values stored in the pose.
			- ObjectPoseOptions: PoseOptions used to specify the transform of the reference object, the TransformType and TransformAttributes to paste.
			- EvaluateInfo: Information concerning the evaluation of the animation (time, etc.)

		### Remarks:
		Use the pObjectPoseOptions to specify which TransformType to use when pasting."""
		...
	def RemoveStanceOffset(self,ObjectName:str,StancePose:FBObjectPose,PoseTransformType:FBPoseTransformType=FBPoseTransformType.kFBPoseTransformInvalid,/)->None:
		"""Remove the StanceOffset from an object in the pose.

		### Parameters:
			- ObjectName: Name of the object.
			- StancePose: Pose representing the stance of all objects.
			- PoseTransformType: Transform type in which to remove the offset (Local, Global or LocalRef).

		### Remarks:
		Working with poses with their StanceOffset removed is usefull for retargetting.

		If pPoseTransformType is set to kFBPoseTransformInvalid, offsets will be removed in all TransformTypes."""
		...
	def RemoveStanceOffsetAllObjects(self,StancePose:FBObjectPose,PoseTransformType:FBPoseTransformType=FBPoseTransformType.kFBPoseTransformInvalid,/)->None:
		"""Remove the StanceOffset from all the objects in the pose.

		### Parameters:
			- StancePose: Pose representing the stance of all objects.
			- PoseTransformType: Transform type in which to remove the offset (Local, Global or LocalRef).

		### Remarks:
		Working with poses with their StanceOffset removed is usefull for retargetting.

		If pPoseTransformType is set to kFBPoseTransformInvalid, offsets will be removed in all TransformTypes."""
		...
	def SetPropertyValue(self,ObjectName:str,PropertyName:str,Value:float,Size:int,/)->None:
		"""Set the value of a property in the pose.

		### Parameters:
			- ObjectName: Name of the object to set the value.
			- PropertyName: Name of the property to set the value.
			- Value: Value to set.
			- Size: Number of elements in pValue."""
		...
	def SetTransform(self,T:FBVector4d,RM:FBMatrix,SM:FBMatrix,ObjectName:str,PoseTransformType:FBPoseTransformType,/)->None:
		"""Set the transform of an object in the pose.

		### Parameters:
			- T: Translation to set.
			- RM: Rotation to set.
			- SM: Scaling to set.
			- ObjectName: Name of the object to set the transform.
			- PoseTransformType: Transform type in which to set the transform (Local, Global or LocalRef)."""
		...
	def __init__(self,Name:str,/):
		"""Public constructor.

		This constructor is used to create a new object.
		### Parameters:
			- Name: Object name. If pObject is not NULL, pName will be ignored."""
		...
class FBCluster(FBComponent):
	"""Weighting interface for meshes.

	This class is experimental.

	[See sample: FBClusterTransactions.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_f_b_cluster_transactions_8py-example.html)"""
	ClusterAccuracy:float
	"""Read Write Property: Cluster accuracy."""
	ClusterMode:FBClusterMode
	"""Read Write Property: Cluster mode."""
	def ClusterBegin(self,Index:int=-1,/)->int:
		"""Begin cluster definition.

		### Parameters:
			- Index: Link index.

		### Returns:
		Index of last item(default=-1)."""
		...
	def ClusterEnd(self)->int:
		"""End cluster definition.

		### Returns:
		0, (Not implemented)."""
		...
	def LinkClearUnused(self,Threshold:float=-1.0,/)->None:
		"""Remove all unused links.

		### Parameters:
			- Threshold: Weight value under which links are considered unused (default=-1)."""
		...
	def LinkGetAssociateModel(self,LinkNumber:int,/)->FBModel:
		"""Get model associated with link.

		### Parameters:
			- LinkNumber: Number value of link to get associated model from.

		### Returns:
		Model associated to link number pLinkNumber."""
		...
	def LinkGetCount(self)->int:
		"""Get number of links.

		### Returns:
		Number of links."""
		...
	def LinkGetModel(self,LinkNumber:int,/)->FBModel:
		"""Get model from a link.

		### Parameters:
			- LinkNumber: Number value of link to get model from.

		### Returns:
		Model at link number pLinkNumber."""
		...
	def LinkGetName(self,LinkNumber:int,/)->str:
		"""Get the name of a link.

		### Parameters:
			- LinkNumber: Number value of link to get name from.

		### Returns:
		Name of link number pLinkNumber."""
		...
	def LinkGetVertexIndex(self,Index:int,/)->int:
		"""Get current vertex at link.

		### Parameters:
			- Index: Index of link to get vertex from.

		### Returns:
		Index value of the current vertex associated to link at index number pIndex"""
		...
	def LinkRemove(self,LinkNumber:int,/)->None:
		"""Remove a link.

		### Parameters:
			- LinkNumber: Number value of link to rename."""
		...
	def LinkSetCurrentVertex(self,LinkIndex:int,PointIndex:int,/)->None:
		"""Link at current vertex.

		### Parameters:
			- LinkIndex: Index of link to add vertex to.
			- PointIndex: Index of vertex to add."""
		...
	def LinkSetModel(self,Model:FBModel,/)->None:
		"""Set model to a link.

		### Parameters:
			- Model: Model to set."""
		...
	def LinkSetName(self,Name:str,LinkNumber:int,/)->None:
		"""Set the name of a link.

		### Parameters:
			- Name: Name of the link.
			- LinkNumber: Number value of link to name."""
		...
	def VertexAdd(self,VertexIndex:int,Weight:float,/)->None:
		"""Add a vertex to a cluster.

		### Parameters:
			- VertexIndex: Index of vertex to add.
			- Weight: Weight to give to vertex."""
		...
	def VertexClear(self)->None:
		"""Clear all linked vertices."""
		...
	def VertexGetCount(self)->int:
		"""Get the number of vertices.

		### Returns:
		Number of vertices in a cluster."""
		...
	def VertexGetNumber(self,Index:int,/)->int:
		"""Get vertex number.

		### Parameters:
			- Index: Index of link to get vertex from.

		### Returns:
		Number value of vertex at link number pIndex"""
		...
	def VertexGetTransform(self,Position:FBVector3d,Rotation:FBVector3d,Scaling:FBVector3d,/)->None:
		"""Get transform of a cluster set.

		### Parameters:
			- Position: Position transform.
			- Rotation: Rotation transform.
			- Scaling: Scaling transform."""
		...
	def VertexGetWeight(self,Index:int,/)->float:
		"""Get vertex weight.

		### Parameters:
			- Index: Index of link to get vertex from.

		### Returns:
		Weight of vertex found at link number pIndex."""
		...
	def VertexRemove(self,VertexIndex:int,/)->None:
		"""Remove a vertex from a cluster.

		### Parameters:
			- VertexIndex: Index of vertex to remove."""
		...
	def VertexSetTransform(self,Position:FBVector3d,Rotation:FBVector3d,Scaling:FBVector3d,/)->None:
		"""Set transform of a cluster set.

		### Parameters:
			- Position: Position transform.
			- Rotation: Rotation transform.
			- Scaling: Scaling transform."""
		...
	def VertexSetWeight(self,Weight:float,Index:int,/)->None:
		"""Set vertex weight.

		### Parameters:
			- Weight: Weight to give to vertex.
			- Index: Index of link to get vertex from."""
		...
	def __init__(self,arg2:FBModel,/):...
class FBCharacterMarkerSet(FBComponent):
	"""Character marker set class.

	These classes are under development and may change dramatically between versions."""
	def GetExtractionProperty(self,NodeId:FBBodyNodeId,/)->FBProperty:
		"""Get the extraction property associated with each body part of the character.

		### Returns:
		The property associated with given pNodeId."""
		...
	def GetMarkersProperty(self,NodeId:FBBodyNodeId,/)->FBProperty:
		"""Get the marker property associated with each body part of the character.

		### Returns:
		The property associated with given pNodeId."""
		...
	def GetSnapProperty(self,NodeId:FBBodyNodeId,What:FBModelTransformationType,/)->FBProperty:
		"""Get the snap property associated with each body part of the character for given transformation.

		Current version snap only translation and rotation.
		### Returns:
		The property associated with given pNodeId and pWhat."""
		...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of new character marker set."""
		...
class FBCameraSwitcherAudioManager(FBComponent):
	"""Camera Switcher Audio Manager class.

	This class allows users to interact with the Audio Manager of the Camera Switcher."""
	def GetAudioClip(self)->FBAudioClip:
		"""Get the Audio Clip displayed on the Camera Switcher.

		### Returns:
		The Audio Clip displayed, nullptr (C++) / None (Python) if any."""
		...
	def GetAudioTrack(self)->FBStoryTrack:
		"""Get the Audio Track displayed on the Camera Switcher.

		### Returns:
		The Audio Track displayed, nullptr (C++) / None (Python) if any."""
		...
	def GetLockPitchToSpeed(self)->bool:
		"""Get the 'Lock Pitch to Speed' state.

		### Returns:
		True if the 'Lock Pitch to Speed' state is set, false otherwise."""
		...
	def GetShowAudio(self)->bool:
		"""Get the 'Show Audio' state.

		### Returns:
		True if the 'Show Audio' state is set, false otherwise."""
		...
	def GetShowLeftChannel(self)->bool:
		"""Get the 'Show Left Channel' state.

		### Returns:
		True if the 'Show Left Channel' state is set, false otherwise."""
		...
	def GetShowRightChannel(self)->bool:
		"""Get the 'Show Right Channel' state.

		### Returns:
		True if the 'Show Right Channel' state is set, false otherwise."""
		...
	def RemoveAudio(self)->bool:
		"""Remove the audio clip or audio track currently displayed on the Camera Switcher.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def SetAudioClip(self,AudioClip:FBAudioClip,/)->bool:
		"""Set the Audio Clip to display on the Camera Switcher.

		### Parameters:
			- AudioClip: The Audio Clip to display.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def SetAudioTrack(self,AudioTrack:FBStoryTrack,/)->bool:
		"""Set the Audio Track to display on the Camera Switcher.

		### Parameters:
			- AudioTrack: The Audio Track to display.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def SetLockPitchToSpeed(self,Lock:bool,/)->bool:
		"""Set the 'Lock Pitch to Speed' state.

		### Parameters:
			- Lock: True to lock pitch to speed, false otherwise.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def SetShowAudio(self,Show:bool,/)->bool:
		"""Set the 'Show Audio' state.

		### Parameters:
			- Show: True to show the Audio waveform, false otherwise.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def SetShowLeftChannel(self,Show:bool,/)->bool:
		"""Set the 'Show Left Channel' state.

		### Parameters:
			- Show: True to show the left channel, false otherwise.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def SetShowRightChannel(self,Show:bool,/)->bool:
		"""Set the 'Show Right Channel' state.

		### Parameters:
			- Show: True to show the right channel, false otherwise.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def __init__(self):...
class FBBox(FBComponent):
	"""A box is a fundamental building block in the application architecture.

	All animatable elements are derived in some way from the main box class, either by deriving directly or owning a box."""
	Animatable:bool
	"""Read Write Property: Is the box animatable."""
	Live:bool
	"""Read Write Property: Is live?"""
	RecordMode:bool
	"""Read Write Property: Is recording?"""
	UniqueName:str
	"""internal Unique name."""
	def AnimationNodeDestroy(self,AnimationNode:FBAnimationNode,/)->bool:
		"""Destroy an animation node.

		### Parameters:
			- AnimationNode: Handle to the animation node to be destroyed.

		### Returns:
		true if destruction was successful."""
		...
	def AnimationNodeInGet(self)->FBAnimationNode:
		"""Get the (IN/OUT) animation node for this box.

		### Returns:
		A handle to the animation node for this box."""
		...
	def AnimationNodeIsUserData(self,AnimationNode:FBAnimationNode,/)->bool:
		"""Is the animation node user data?

		### Parameters:
			- AnimationNode: Handle to the animation to be queried.

		### Returns:
		true if node is user data."""
		...
	def AnimationNodeOutGet(self)->FBAnimationNode:...
	def GetInConnector(self,Index:int,/)->FBAnimationNode:
		"""Get the animation node input associated with the given index.

		### Parameters:
			- Index: The animation node input associated with the given index.

		### Returns:
		The animation node input, or NULL if the pIndex value is invalid."""
		...
	def GetInConnectorCount(self)->int:
		"""Get the number of animation node inputs for this box.

		### Returns:
		The number of animation node inputs for this box."""
		...
	def GetOutConnector(self,Index:int,/)->FBAnimationNode:
		"""Get the animation node output associated with the given index.

		### Parameters:
			- Index: The animation node output associated with the given index.

		### Returns:
		The animation node output, or NULL if the pIndex value is invalid."""
		...
	def GetOutConnectorCount(self)->int:
		"""Get the number of animation node outputs for this box.

		### Returns:
		The number of animation node outputs for this box."""
		...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Box name."""
		...
class FBAudioOut(FBComponent):
	"""Audio Out class.

	Properties of this class are work in progress, but you can still list them and get their names."""
	def __init__(self):...
class FBBoxPlaceHolder(FBBox):
	"""Wrapper around a specific instance of a [FBBox](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_box.html "A box is a fundamental building block in the application architecture.") object.

	This class is mainly used with a constraint relation to have multiple boxes that are a representation of the same underlying box. The underlying box will usually be a device. Instantiation of [FBBoxPlaceHolder](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_box_place_holder.html "Wrapper around a specific instance of a FBBox object.") should be left to the the system."""
	Box:FBBox
	"""Read Only Property: Underlying box object."""
class FBConstraint(FBBox):
	"""Base class for constraints."""
	Active:bool
	"""Read Write Property: Active state."""
	Deformer:bool
	"""Read Write Property: Is a deformer constraint?"""
	Description:str
	"""Read Write Property: Long description of constraint."""
	HasLayout:bool
	"""Read Write Property: Does the constraint have a layout?"""
	Lock:bool
	"""Read Write Property: Lock state."""
	@property
	def Weight(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Weight of constraint."""
		...
	@Weight.setter
	def Weight(self, Value: FBPropertyAnimatableDouble|float):...
	def AnimationNodeInCreate(self,UserId:int,Model:FBModel,Attribute:str,/)->FBAnimationNode:...
	def AnimationNodeOutCreate(self,UserId:int,Model:FBModel,Attribute:str,/)->FBAnimationNode:
		"""Animation Node Creations (IN/OUT).

		Used to create the connectors (in or out) on an animation node. This function will return a newly created animation node, connected to the model specified by pModel.
		### Parameters:
			- UserId: User specified reference number.
			- Model: Model to associate with animation node.
			- Attribute: Attribute of model to animate (i.e. Translation, Lcl Translation, etc.)

		### Returns:
		Newly created IN/OUT animation node."""
		...
	def Clone(self)->FBConstraint:
		"""Clone the constraint.

		### Returns:
		Newly created (and copied) constraint."""
		...
	def DeformerBind(self,Model:FBModel,/)->bool:
		"""Bind/Unbind pModel to deformation constraint.

		These functions are used for adding/removing a deformation binding to/from pModel if the constraint is a deformation constraint.
		### Parameters:
			- Model: Model to bind/unbind.

		### Returns:
		true if successful."""
		...
	def DeformerUnBind(self,Model:FBModel,/)->bool:...
	def Disable(self,Model:FBModel,/)->bool:
		"""Disable constraint on pModel.

		### Parameters:
			- Model: Model on which constraint should be disabled.

		### Returns:
		true if successful."""
		...
	def FreezeSRT(self,Model:FBModel,S:bool,R:bool,T:bool,/)->None:
		"""Freeze current model state.

		### Parameters:
			- Model: Model to freeze constraint on.
			- S: Scaling freeze?
			- R: Rotation freeze?
			- T: Translation freeze?"""
		...
	def FreezeSuggested(self)->None:
		"""Suggest 'freeze'."""
		...
	def ReferenceAdd(self,GroupIndex:int,Model:FBModel,/)->bool:
		"""Add a reference to a specified group.

		### Parameters:
			- GroupIndex: Group to add reference to.
			- Model: Model to place at new reference.

		### Returns:
		true if successful.
		### Warning:
		If you try to add a model to a group that is already full, the success of the operation will be false and the reference will not be added."""
		...
	def ReferenceGet(self,GroupIndex:int,ItemIndex:int=0,/)->FBModel:
		"""Get a reference.

		### Parameters:
			- GroupIndex: Index of reference group containing desired reference.
			- ItemIndex: Index of reference in group to get (default is 0).

		### Returns:
		Model at specified reference."""
		...
	def ReferenceGetCount(self,GroupIndex:int,/)->int:
		"""Get number of references in a specified group.

		### Parameters:
			- GroupIndex: Index of group to query the number of references.

		### Returns:
		Number of references in specified group."""
		...
	def ReferenceGroupAdd(self,GroupName:str,MaxItemCount:int,/)->int:
		"""Add a group of references.

		### Parameters:
			- GroupName: Name of reference group to add.
			- MaxItemCount: Maximum number of items in **pGroupName**.

		### Returns:
		Index of new reference group."""
		...
	def ReferenceGroupGetCount(self)->int:
		"""Return the number of reference groups.

		### Returns:
		Number of reference groups."""
		...
	def ReferenceGroupGetMaxCount(self,GroupIndex:int,/)->int:
		"""Get the maximum number of items that can exist in the reference group in question.

		### Parameters:
			- GroupIndex: Index of reference group.

		### Returns:
		Maximum number of items that can be added to the reference group."""
		...
	def ReferenceGroupGetName(self,GroupIndex:int,/)->str:
		"""Get the name of the reference group.

		### Parameters:
			- GroupIndex: Index of the reference group to get the name for.

		### Returns:
		The name of the reference group pGroupIndex."""
		...
	def ReferenceRemove(self,GroupIndex:int,Model:FBModel,/)->bool:
		"""Remove a reference to pModel from the group at pGroupIndex.

		### Parameters:
			- GroupIndex: Index to remove reference from.
			- Model: Model to remove reference from.

		### Returns:
		true if successful."""
		...
	def RemoveAllAnimationNodes(self)->None:
		"""Remove animation nodes."""
		...
	def RestoreModelState(self,Model:FBModel,/)->None:
		"""Restore the saved model state onto pModel.

		### Parameters:
			- Model: Model to affect with previous state."""
		...
	def SaveModelState(self,Model:FBModel,S:bool,R:bool,T:bool,/)->None:
		"""Save current state of pModel.

		### Parameters:
			- Model: Model to save.
			- S: Scaling information?
			- R: Rotation information?
			- T: Translation information?"""
		...
	def SetupAllAnimationNodes(self)->None:
		"""Setup animation nodes."""
		...
	def Snap(self)->None:
		"""Function Property: Snap constraint."""
		...
	def SnapSuggested(self)->None:
		"""Suggest 'snap'."""
		...
	def __copy__(self)->FBConstraint:...
class FBModelPlaceHolder(FBBoxPlaceHolder):
	"""Wrapper around a specific instance of a [FBModel](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model.html "Model class.") object.

	This class is mainly used with a constraint relation to have multiple boxes that are a representation of the same underlying model. Instantiation of [FBModelPlaceHolder](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model_place_holder.html "Wrapper around a specific instance of a FBModel object.") should be left to the the system."""
	Model:FBModel
	"""Read Only Property: Underlying model object."""
	UseGlobalTransforms:bool
	"""Read Write Property: Indicate if the translations are expressed in local or global mode."""
class FBCharacterSolver(FBConstraint):
	"""Constraint class."""
	ExtraBones:list
	"""Read Property: List of Extra Bones in character"""
	ExtraFK:list
	"""Read Property: List of Extra FK in character"""
	Source:FBComponent
	"""Read Write Property: Source character when doing a character retarget."""
	def GetParentRotationOffset(self,arg2:FBModel,/)->FBVector3d:
		"""Get the Parent Rotation Offset of the Given Extra Bone Index.

		The rotation Offset if extracted at Characterisation (in Stance Pose). You don't need this value if the parent of the bone is characterized too.
		### Parameters:
			- R: Offset Rotation between the Bone and is parent at Stance Pose.
			- Index: Index of extra Bone to get."""
		...
	@staticmethod
	def GetRegisteredSolverNames()->list:...
	def GetTarget(self)->Any:...
	def GetTransformationOffset(self,arg2:FBModel,/)->list:...
	def SetParentRotationOffset(self,R:FBModel,Index:FBVector3d,/)->None:
		"""Set the Parent Rotation Offset of the Given Extra Bone Index.

		The rotation Offset if extracted at Characterisation (in Stance Pose). You don't need this value if the parent of the bone is characterized too.
		### Parameters:
			- R: Offset Rotation between the Bone and is parent at Stance Pose.
			- Index: Index of extra Bone to get."""
		...
	def SetTransformationOffset(self,arg2:FBModel,arg3:FBVector3d,arg4:FBVector3d,arg5:FBVector3d,/)->None:...
	def __init__(self,Name:str,arg3:FBCharacter,arg4:str,/):
		"""### Parameters:
			- Name: Name of constraint."""
		...
class FBCharacterFace(FBConstraint):
	"""Animates a character face using an actor as input.

	These classes are under development and may change dramatically between versions."""
	ActiveInput:bool
	"""Read Write Property: Is the character input active?"""
	InputActorFace:FBActorFace
	"""Read Write Property: The index of the actor used for the input."""
	def ClusterGroupAdd(self,List:FBModelList,Name:str,/)->int:
		"""Add a cluster group to the character face.

		### Parameters:
			- List: List of clusters to add to this group.
			- Name: Optional name to assign to this cluster group.

		### Returns:
		Index of the new cluster group -1 if the operation failed to complete."""
		...
	def ClusterGroupFindByName(self,Name:str,/)->int:
		"""Find a cluster group by name.

		### Parameters:
			- Name: Name to search for on the face.

		### Returns:
		Index of the matching cluster group. -1 if not found."""
		...
	def ClusterGroupGetCount(self)->int:
		"""Retrieve the total number of cluster groups.

		### Returns:
		Number of cluster groups on the face."""
		...
	def ClusterGroupGetName(self,ClusterGrpId:int,/)->str:
		"""Retrieve the name of a cluster group.

		### Parameters:
			- ClusterGrpId: Index of the cluster group to query.

		### Returns:
		Name of the specified cluster group."""
		...
	def ClusterGroupRemove(self,ClusterGrpId:int,/)->bool:
		"""Remove a cluster group from the character face.

		### Parameters:
			- ClusterGrpId: Index of the cluster group to remove.

		### Returns:
		True if the operation completed successfully."""
		...
	def ClusterGroupSetName(self,ClusterGrpId:int,Name:str,/)->bool:
		"""Set the name of a cluster group.

		### Parameters:
			- ClusterGrpId: Index of the cluster group to modify.
			- Name: New name for the cluster group.

		### Returns:
		True of the operation completed successfully."""
		...
	def ClusterGroupSnapRest(self,ClusterGrpId:int,/)->bool:
		"""Set a cluster group's rest pose to the current pose.

		### Parameters:
			- ClusterGrpId: Index of the cluster group to modify.

		### Returns:
		True if the operation completed succesfully."""
		...
	def ClusterShapeAdd(self,ClusterGrpId:int,Name:str,/)->int:
		"""Add a cluster shape to a cluster group.

		### Parameters:
			- ClusterGrpId: Index of the cluster group to modify.
			- Name: Optional name to assign to the shape.

		### Returns:
		Index of the new shape. -1 if the operation failed to complete."""
		...
	def ClusterShapeFindByName(self,ClusterGrpId:int,Name:str,/)->int:
		"""Find a cluster shape in a cluster group by name.

		### Parameters:
			- ClusterGrpId: Index of the cluster group to search.
			- Name: Name to search for in the cluster group.

		### Returns:
		Index of the matching shape. -1 if not found."""
		...
	def ClusterShapeGetCount(self,ClusterGrpId:int,/)->int:
		"""Retrieve the total number of shapes in a cluster group.

		### Parameters:
			- ClusterGrpId: Index of the cluster group to query.

		### Returns:
		Number of shapes in the specified cluster group."""
		...
	def ClusterShapeGetName(self,ClusterGrpId:int,ClusterShapeId:int,/)->str:
		"""Retrieve the name of a shape in a cluster group.

		### Parameters:
			- ClusterGrpId: Index of the cluster group to query.
			- ClusterShapeId: Index of the cluster shape to query.

		### Returns:
		Name of the specified shape."""
		...
	def ClusterShapeRemove(self,ClusterGrpId:int,ClusterShapeId:int,/)->bool:
		"""Remove a cluster shape from a cluster group.

		### Parameters:
			- ClusterGrpId: Index of the cluster group to modify.
			- ClusterShapeId: Index of the shape in the cluster group to remove.

		### Returns:
		True of the operation completed succesfully."""
		...
	def ClusterShapeSetName(self,ClusterGrpId:int,ClusterShapeId:int,Name:str,/)->bool:
		"""Set the name of a shape in a cluster group.

		### Parameters:
			- ClusterGrpId: Index of the cluster group to modify.
			- ClusterShapeId: Index of the cluster shape to modify.
			- Name: Name to assign to the cluster shape.

		### Returns:
		True if the operation completed successfully."""
		...
	def ClusterShapeSnap(self,ClusterGrpId:int,ClusterShapeId:int,/)->bool:
		"""Record the current pose of the cluster group to a cluster shape.

		### Parameters:
			- ClusterGrpId: Index of the cluster group to record.
			- ClusterShapeId: Index of the cluster shape to record the pose.

		### Returns:
		True if the operation completed successfully."""
		...
	def ExpressionAdd(self,Name:str,/)->int:
		"""Add an expression to the face.

		### Parameters:
			- Name: Optional name to assign to the new expression.

		### Returns:
		Index of the new expression. -1 if the operation failed to complete."""
		...
	def ExpressionFindByName(self,Name:str,/)->int:
		"""Find an expression on the face by name.

		### Parameters:
			- Name: Name of the expression to search for.

		### Returns:
		Index of the matching expression. -1 if not found."""
		...
	def ExpressionGetCount(self)->int:
		"""Retrieve the total number of expressions on the face.

		### Returns:
		Number of expressions on the face."""
		...
	def ExpressionGetName(self,ExpressionId:int,/)->str:
		"""Retrieve the name of an expression.

		### Parameters:
			- ExpressionId: Index of the expression to query.

		### Returns:
		Name of the specified expression."""
		...
	def ExpressionGetShapeWeight(self,ExpressionId:int,GrpId:int,ShapeId:int,/)->float:
		"""Retrieve the weight of a shape to an expression.

		### Parameters:
			- ExpressionId: Index of the expression.
			- GrpId: Index of the blendshape or cluster group containing the shape of interest.
			- ShapeId: Index of the blendshape or cluster shape.

		### Returns:
		Weight of the desired shape to an expression. A weight of 0.0 represents 0%, while a weight of 1.0 represents 100%. Returns 0.0 if the weight cannot be found."""
		...
	def ExpressionRemove(self,ExpressionId:int,/)->bool:
		"""Remove an expression from the face.

		### Parameters:
			- ExpressionId: Index of the expression to remove.

		### Returns:
		True if the operation completed successfully."""
		...
	def ExpressionSetName(self,ExpressionId:int,Name:str,/)->bool:
		"""Set the name of an expression.

		### Parameters:
			- ExpressionId: Index of the expression to modify.
			- Name: Name to assign to the expression.

		### Returns:
		True if the operation completed successfully."""
		...
	def ExpressionSetShapeWeight(self,ExpressionId:int,GrpId:int,ShapeId:int,Value:float,/)->bool:
		"""Assign the weight of a shape to an expression.

		### Parameters:
			- ExpressionId: Index of the expression to modify.
			- GrpId: Index of the blendshape or cluster group containing the shape of interest.
			- ShapeId: Index of the blendshape or cluster shape to weight.
			- Value: Weight of the shape to assign to this expression. A weight of 0.0 represents 0%, while a weight of 1.5 represents 150%. The weight cannot be less than 0.0; if so, the weight will be clamped to 0.0.

		### Returns:
		True if the operation completed successfully."""
		...
	def GotoRest(self)->None:
		"""Set the character face back to its rest shape."""
		...
	def PlotAnimation(self)->bool:
		"""Plot the animation of the character face.

		### Returns:
		True if the operation completed successfully."""
		...
	def ShapeFindByName(self,ShapeGrpId:int,Name:str,/)->int:
		"""Find a shape in a blendshape group by name.

		### Parameters:
			- ShapeGrpId: Index of the blendshape group to search.
			- Name: Name to search for.

		### Returns:
		Index of the shape, -1 if not found."""
		...
	def ShapeGetCount(self,ShapeGrpId:int,/)->int:
		"""Retrieve the total number of shapes in a blendshape group.

		### Parameters:
			- ShapeGrpId: Index of the blendshape group to query.

		### Returns:
		Number of shapes in the specified blendshape group."""
		...
	def ShapeGetName(self,ShapeGrpId:int,ShapeId:int,/)->str:
		"""Retrieve the name of the shape in a blendshape group.

		### Parameters:
			- ShapeGrpId: Index of the blendshape group to query.
			- ShapeId: Index of the shape in the blendshape group to query.

		### Returns:
		Name of the specified shape."""
		...
	def ShapeGroupAdd(self,List:FBModelList,Name:str,/)->bool:
		"""Add a blendshape model group for each input model.

		### Parameters:
			- List: List of models to create a blendshape model group.
			- Name: Unused. Instead, use the ShapeGroupGetName member function to set the name of each added blendshape model group individually.

		### Returns:
		True if the operation completed successfully, false otherwise."""
		...
	def ShapeGroupFindByName(self,Name:str,/)->int:
		"""Find a blendshape group by name.

		### Parameters:
			- Name: Name to search for.

		### Returns:
		Index of the blendshape group, -1 if not found."""
		...
	def ShapeGroupGetCount(self)->int:
		"""Retrieve the total number of blendshape groups on this character face.

		### Returns:
		Number of blendshape groups on this character face."""
		...
	def ShapeGroupGetName(self,ShapeGrpId:int,/)->str:
		"""Retrieve the name of a blendshape group.

		### Parameters:
			- ShapeGrpId: Index of the blendshape group to query.

		### Returns:
		Name of the blendshape group."""
		...
	def ShapeGroupRemove(self,ShapeGrpId:int,/)->bool:
		"""Remove a blendshape model group.

		### Parameters:
			- ShapeGrpId: Index of the blendshape group to remove.

		### Returns:
		True if the operation completed successfully."""
		...
	def ShapeGroupSetName(self,ShapeGrpId:int,Name:str,/)->bool:
		"""Set the name of a blendshape group.

		### Parameters:
			- ShapeGrpId: Index of the blendshape group to modify.
			- Name: Name to set on the blendshape group.

		### Returns:
		True if the operation completed successfully."""
		...
	def ShapeSetName(self,ShapeGrpId:int,ShapeId:int,Name:str,/)->bool:
		"""Set the name of the shape in a blendshape group.

		### Parameters:
			- ShapeGrpId: Index of the blendshape group to query.
			- ShapeId: Index of the shape in the blendshape group to set.
			- Name: Name to set on the shape.

		### Returns:
		True if the operation completed successfully."""
		...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of new character."""
		...
class FBCharacter(FBConstraint):
	"""A character is the link between a motion source and a character model.

	These classes are under development and may change dramatically between versions. This class exposes part of the functionality associated with a Character. A character can possess a number of potential sources at the same time, such as an actor and another character, but with only one active at any given time. Before setting the InputType to the desired value, one must make sure to have previously set either the InputCharacter or the InputActor.To obtain the list of characters present in a scene, you need to create an instance of class [FBSystem](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_system.html "Provides access to the underlying system, and the MotionBuilder scene."), to obtain the current scene. The [FBScene](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_scene.html "Access to the MotionBuilder scene.") object holds the list of characters in the property Characters.

	```c++
	FBSystem lSystem;
	FBScene* lScene = lSystem.Scene;
	for( int lIdx = 0; lIdx < lScene->Characters.GetCount(); ++lIdx )
	{
	 FBTrace( "Character[%d]: '%s'\\n", lIdx, (char*)lScene->Characters[lIdx] );
	}
	```
	The current character selected in the Character tool can be obtained via the [FBApplication](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_application.html "FBApplication is used mainly to manage files.") object.

	```c++
	FBApplication lApplication;
	FBCharacter* lCharacter = lApplication.CurrentCharacter;
	if( lCharacter )
	{
	 FBTrace( "Current character is: '%s'\\n", (char*)lCharacter->Name );
	}
	else
	{
	 FBTrace( "No character currently selected\\n" );
	}
	```
	[See samples: CharacterMarkerSet.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_character_0c_character_marker_set_8py-example.html) [EnableGameModeOnSelectedCharacters_Z.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_enable_game_mode_on_selected_characters__z_8py-example.html) [MirrorPoseOverTime.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_mirror_pose_over_time_8py-example.html) [PlotNonSelectedCharStoryTracks.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_plot_non_selected_char_story_tracks_8py-example.html) [PlotSelectedCharStoryTracks.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_plot_selected_char_story_tracks_8py-example.html)"""
	ActiveInput:bool
	"""Read Write Property: Is the character input active?"""
	CharacterExtensions:FBPropertyListCharacterExtension
	"""List: Character Extensions in the character."""
	ContactBehaviour:FBCharacterContactBehaviour
	"""Read Write Property: Contact Behavior selection."""
	@property
	def FKFingerMultiplier(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to augment the amount of FK propagation for unmarkered intermediate finger phalanges."""
		...
	@FKFingerMultiplier.setter
	def FKFingerMultiplier(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def FKFingerTipMultiplier(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to augment the amount of FK propagation for unmarkered finger tip phalanges."""
		...
	@FKFingerTipMultiplier.setter
	def FKFingerTipMultiplier(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def FKThumbTipMultiplier(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to augment the amount of FK propagation for unmarkered thumb tip phalanges."""
		...
	@FKThumbTipMultiplier.setter
	def FKThumbTipMultiplier(self, Value: FBPropertyAnimatableDouble|float):...
	HipsTranslationMode:FBCharacterHipsTranslationMode
	"""Read Write Property: Hips Translation Mode."""
	@property
	def HumanFingerLimits(self)->FBPropertyAnimatableBool:
		"""Read Write Property: Enables/Disables human finger limits during actor solve."""
		...
	@HumanFingerLimits.setter
	def HumanFingerLimits(self, Value: FBPropertyAnimatableBool|bool):...
	InputActor:FBActor
	"""Read Write Property: The index of the actor used for the input."""
	InputCharacter:FBCharacter
	"""Read Write Property: The index of the character used for the input."""
	InputType:FBCharacterInputType
	"""Read Write Property: The input type for the character (ex: Actor)."""
	InverseLeftElbow:bool
	"""Read Write Property: Is left elbow inverted."""
	InverseLeftKnee:bool
	"""Read Write Property: Is left knee inverted."""
	InverseRightElbow:bool
	"""Read Write Property: Is right elbow inverted."""
	InverseRightKnee:bool
	"""Read Write Property: Is right knee inverted."""
	KeyingMode:FBCharacterKeyingMode
	"""Read Write Property: The current keying mode."""
	LeftElbowKillPitch:bool
	"""Read Write Property: is Pitch used for Left elbow."""
	@property
	def LeftHandIndexIndex(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandIndexIndex.setter
	def LeftHandIndexIndex(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandIndexMiddle(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandIndexMiddle.setter
	def LeftHandIndexMiddle(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandIndexPinky(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandIndexPinky.setter
	def LeftHandIndexPinky(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandIndexRing(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandIndexRing.setter
	def LeftHandIndexRing(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandMiddleIndex(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandMiddleIndex.setter
	def LeftHandMiddleIndex(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandMiddleMiddle(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandMiddleMiddle.setter
	def LeftHandMiddleMiddle(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandMiddlePinky(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandMiddlePinky.setter
	def LeftHandMiddlePinky(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandMiddleRing(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandMiddleRing.setter
	def LeftHandMiddleRing(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandPinkyIndex(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandPinkyIndex.setter
	def LeftHandPinkyIndex(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandPinkyMiddle(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandPinkyMiddle.setter
	def LeftHandPinkyMiddle(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandPinkyPinky(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandPinkyPinky.setter
	def LeftHandPinkyPinky(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandPinkyRing(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandPinkyRing.setter
	def LeftHandPinkyRing(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandRingIndex(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandRingIndex.setter
	def LeftHandRingIndex(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandRingMiddle(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandRingMiddle.setter
	def LeftHandRingMiddle(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandRingPinky(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandRingPinky.setter
	def LeftHandRingPinky(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandRingRing(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandRingRing.setter
	def LeftHandRingRing(self, Value: FBPropertyAnimatableDouble|float):...
	LeftKneeKillPitch:bool
	"""Read Write Property: is Pitch used for Left knee."""
	LockX:bool
	"""Read Write Property: Lock character skeleton in place on X axis."""
	LockY:bool
	"""Read Write Property: Lock character skeleton in place on Y axis."""
	LockZ:bool
	"""Read Write Property: Lock character skeleton in place on Z axis."""
	MirrorMode:bool
	"""Read Write Property: is in mirror mode."""
	RightElbowKillPitch:bool
	"""Read Write Property: is Pitch used for Right elbow."""
	@property
	def RightHandIndexIndex(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandIndexIndex.setter
	def RightHandIndexIndex(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandIndexMiddle(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandIndexMiddle.setter
	def RightHandIndexMiddle(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandIndexPinky(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandIndexPinky.setter
	def RightHandIndexPinky(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandIndexRing(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandIndexRing.setter
	def RightHandIndexRing(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandMiddleIndex(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandMiddleIndex.setter
	def RightHandMiddleIndex(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandMiddleMiddle(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandMiddleMiddle.setter
	def RightHandMiddleMiddle(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandMiddlePinky(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandMiddlePinky.setter
	def RightHandMiddlePinky(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandMiddleRing(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandMiddleRing.setter
	def RightHandMiddleRing(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandPinkyIndex(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandPinkyIndex.setter
	def RightHandPinkyIndex(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandPinkyMiddle(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandPinkyMiddle.setter
	def RightHandPinkyMiddle(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandPinkyPinky(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandPinkyPinky.setter
	def RightHandPinkyPinky(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandPinkyRing(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandPinkyRing.setter
	def RightHandPinkyRing(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandRingIndex(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandRingIndex.setter
	def RightHandRingIndex(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandRingMiddle(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandRingMiddle.setter
	def RightHandRingMiddle(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandRingPinky(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandRingPinky.setter
	def RightHandRingPinky(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandRingRing(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandRingRing.setter
	def RightHandRingRing(self, Value: FBPropertyAnimatableDouble|float):...
	RightKneeKillPitch:bool
	"""Read Write Property: is Pitch used for Right knee."""
	RollSolver:FBCharacterRollSolver
	"""Read Write Property: Roll Solver selection."""
	@property
	def ShoulderCorrection(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: shoulder correction values."""
		...
	@ShoulderCorrection.setter
	def ShoulderCorrection(self, Value: FBPropertyAnimatableDouble|float):...
	SyncMode:bool
	"""Read Write Property: is character in sync mode."""
	WriteReference:bool
	"""Read Write Property: are we writing back on reference."""
	def AddCharacterExtension(self,Ext:FBCharacterExtension,/)->None:
		"""AddCharacterExtension.

		### Parameters:
			- Ext: extension to be added to the character."""
		...
	def ConnectControlRig(self,ControlSet:FBControlSet,UpdateLimit:bool,ResetHierarchy:bool,/)->None:
		"""Connect a Control-Rig to the character.

		### Parameters:
			- ControlSet: The control set to connect. NULL will disconnect the Control-Rig from the character.
			- UpdateLimit: Whether to update the models' limit for a character. E.g. the Pre rotation and post rotation.
			- ResetHierarchy: Whether to reset hierarchy for a character."""
		...
	def CopyAnimation(self)->None:
		"""Copy the animation from the input character to us."""
		...
	def CreateAuxiliary(self,EffectorId:FBEffectorId,Pivot:bool,AuxReachT:float=100,AuxReachR:float=100,/)->bool:
		"""Create auxiliary on effector.

		### Parameters:
			- EffectorId: The effector ID.
			- Pivot: Create effector or pivot (pivot offset should be set on IKPivot property, at creation default values are set).
			- AuxReachT: Default auxiliary effector reach for translation (IK Blend T since MotionBuilder 2013).
			- AuxReachR: Default auxiliary effector reach for rotation (IK Blend R since MotionBuilder 2013).

		### Returns:
		True if auxiliary was created (can fail if FBLastEffectorSetIndex limit reached)."""
		...
	def CreateCharacterMarkerSet(self,SetActive:bool,/)->bool:
		"""Create the Character Marker Set.

		### Parameters:
			- SetActive: True when new input should be set and active.

		### Returns:
		True when marker got created and connected to character."""
		...
	def CreateControlRig(self,SetFKIK:bool,/)->bool:
		"""Create the Control-Rig.

		### Parameters:
			- SetFKIK: true to use FK/IK or false to use IK only.

		### Returns:
		current state of the flag after the operation (true if it did succeed)."""
		...
	def CycleAnalysisCurrentCharacter(self)->None:
		"""Run Cycle Analysis on current character."""
		...
	def DisconnectControlRig(self)->None:
		"""Disconnect the Control-Rig from the character."""
		...
	def GetActiveBodyPart(self)->list:
		"""Get the active body part array.

		### Parameters:
			- ActivePart: A pointer to an array of bool. On return, the index with a "true" value are active part."""
		...
	def GetCharacterMarkerSet(self,Force:bool,/)->FBCharacterMarkerSet:
		"""Obtain Input CharacterMarkerSet.

		### Parameters:
			- Force: If True, will return the current CharacterMarkerSet even if the character is not in CharacterMarkerSet Input.

		### Returns:
		Return current Active CharacterMarkerSet, NULL if none."""
		...
	def GetCharacterize(self)->bool:
		"""Get Characterize flag.

		### Returns:
		Current state of the Characterize flag."""
		...
	def GetCharacterizeError(self)->str:
		"""Get error message for the previous SetCharacterizeOn operation.

		### Returns:
		The string containing all errors and warnings."""
		...
	def GetCtrlRigModel(self,BodyNodeId:FBBodyNodeId,/)->FBModel:
		"""Get the model associated with each body part in the Control Rig of the character.

		### Returns:
		The model in the Control Rig corresponding to the specified body part."""
		...
	def GetCurrentControlSet(self)->FBControlSet:
		"""Obtain Input ControlSet.

		### Parameters:
			- Force: If True, will return the current ControlSet even if the character is not in ControlSet Input.

		### Returns:
		Return current Active ControlSet, NULL if none."""
		...
	def GetCycleAnalysisNode(self)->FBCycleAnalysisNode:
		"""Get the Cycle Analysis Node from the current character.

		### Returns:
		Cycle Analysis Node linked to the current character, or create a new node"""
		...
	def GetEffectorModel(self,EffectorId:FBEffectorId,EffectorSetID:FBEffectorSetID=FBEffectorSetID.FBEffectorSetDefault,/)->FBModel:
		"""Get the model associated with each effector in the Control Rig of the character.

		### Parameters:
			- EffectorId: The effector ID.
			- EffectorSetID: Id of the ControlSet to obtain, if not specified the current one is taken.

		### Returns:
		The model in the Control Rig corresponding to the specified Effector."""
		...
	def GetExternalSolver(self)->FBCharacterSolver:
		"""Get a pointer to the external solver of a character, or NULL is no external solver is used on the character.

		### Returns:
		The pointer of the current External Solver, NULL if it's the internal solver."""
		...
	def GetFKVisibility(self)->FBVisibilityState:
		"""Get the FK visibility state.

		### Returns:
		The FK visibility state."""
		...
	def GetFloorContactModel(self,MemberIndex:FBFloorContactID,/)->FBModel:
		"""Get the model associated with the floor contact ID.

		### Parameters:
			- MemberIndex: Id of the floor contact

		### Returns:
		The model associated with the floor contact ID"""
		...
	def GetGoalModel(self,BodyNodeId:FBBodyNodeId,/)->FBModel:
		"""Get the goal model associated with each body part in the Character Marker Set of the character.

		### Returns:
		The model in the Character Marker Set corresponding to the specified body part."""
		...
	def GetIKVisibility(self)->FBVisibilityState:
		"""Get the IK visibility state.

		### Returns:
		The IK visibility state."""
		...
	def GetIndexByModel(self,Model:FBModelSkeleton,/)->FBBodyNodeId:
		"""Get the index associated with Given Model.

		### Returns:
		The model linked to the specified body part."""
		...
	def GetModel(self,BodyNodeId:FBBodyNodeId,/)->FBModel:
		"""Get the model associated with each body part of the character.

		### Returns:
		The model linked to the specified body part."""
		...
	def GetParentROffset(self,BodyNodeId:FBBodyNodeId,RVector:FBVector3d,/)->None:...
	def GetROffset(self,BodyNodeId:FBBodyNodeId,RVector:FBVector3d,/)->None:...
	def GetSOffset(self,BodyNodeId:FBBodyNodeId,SVector:FBVector3d,/)->None:...
	def GetSkeletonVisibility(self)->FBVisibilityState:
		"""Get the skeleton visibility state.

		### Returns:
		The skeleton visibility state."""
		...
	def GetSkinModelList(self,SkinModelList:FBModelList,/)->None:
		"""Get the skin model associated with character bones.

		Could be deformable model connected to bone via cluster, or non deformable model parented directly under the bones.
		### Parameters:
			- SkinModelList: List to be filled up. (will not be cleared)"""
		...
	def GetTOffset(self,BodyNodeId:FBBodyNodeId,TVector:FBVector4d,/)->None:...
	def GetTransformOffset(self,BodyNodeId:FBBodyNodeId,OffsetMatrix:FBMatrix,/)->None:...
	def GoToStancePose(self,PushUndo:bool=False,IncludeCharacterExtensions:bool=True,/)->None:
		"""Set the character in stance pose.

		### Parameters:
			- PushUndo: Should we push an undo transaction on the undo stack? Don't push undo in non UI thread.
			- IncludeCharacterExtensions: Should the character extensions go to stance pose too?"""
		...
	def IsParentNodeOffset(self,NodeId:FBBodyNodeId,/)->bool:
		"""Check if there is an offset on Parent.

		### Parameters:
			- NodeId: Node Id to Check.

		### Returns:
		True if there is an offset on Parent."""
		...
	def IsRotationPin(self,EffectorIndex:FBEffectorId,/)->bool:
		"""Return true if the object is Pinned in Rotation (Manipulation).

		### Parameters:
			- EffectorIndex: Given Index to obtain Model

		### Returns:
		True if the effector is pinned in Rotation"""
		...
	def IsTranslationPin(self,EffectorIndex:FBEffectorId,/)->bool:
		"""Return true if the object is Pinned in Translation (Manipulation).

		### Parameters:
			- EffectorIndex: Given Index to obtain Model

		### Returns:
		True if the effector is pinned in Translation"""
		...
	def PlotAnimation(self,PlotWhere:FBCharacterPlotWhere,PlotOptions:FBPlotOptions,/)->bool:
		"""Plot the animation of the character.

		When plotting onto Control Rig while the Control Rig being the source of the Character, only the selected properties, based on the active keying group, will be plotted.
		### Parameters:
			- PlotWhere: Where to plot a character, control rig or Skeleton
			- PlotOptions: Option parameters for plotting

		### Returns:
		True if the operation completed successfully."""
		...
	def ReadyForRetarget(self)->bool:
		"""Test if character is ready for the Retarget operation (basically, is it in character input ?).

		### Returns:
		True if the character is ready."""
		...
	def RemoveCharacterExtension(self,Ext:FBCharacterExtension,/)->None:
		"""Get the model associated with each body part of the character.

		### Parameters:
			- Ext: extension to be removed to the character."""
		...
	def ResetProperties(self,Type:FBCharacterResetProperties,/)->None:
		"""Reset the properties of the character.

		### Parameters:
			- Type: Speficy which properties will be reset."""
		...
	def Retarget(self,OnBaseLayer:bool,/)->None:
		"""Retarget the animation from the input character to us.

		### Parameters:
			- OnBaseLayer: if true, keys corrections will be made on base layer; else they will be made on another layer."""
		...
	def SelectModels(self,Select:bool,ApplyToCharacter:bool,ApplyToRig:bool,ApplyToExtensions:bool,/)->None:
		"""Select the objects that make a character.

		### Parameters:
			- Select: True to select, false to deselect.
			- ApplyToCharacter: TSould the character contraint be selected ?
			- ApplyToRig: should The rig (and its children) be selected ?
			- ApplyToExtensions: Should the character extensions (and their children) be selected ?"""
		...
	def SetCharacterizeOff(self)->None:
		"""Set Characterize flag off."""
		...
	def SetCharacterizeOn(self,SetAsBiped:bool,/)->bool:
		"""Set the Characterize flag on.

		### Parameters:
			- SetAsBiped: true to use biped characterization or false to use quadruped.

		### Returns:
		current state of the flag after the operation (true if it did succeed).
		[See sample: 3dsMaxBipedTemplate.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c3ds_max_biped_template_8py-example.html)"""
		...
	def SetExternalSolver(self,Solver:FBCharacterSolver,/)->None:
		"""Set character solver.

		### Parameters:
			- Solver: Character solver that will be used by the character."""
		...
	def SetExternalSolverWithIndex(self,arg2,/)->None:...
	def SetFKVisibility(self,State:bool,/)->bool:
		"""Set the FK visibility state.

		### Parameters:
			- State: The FK visibility state.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def SetIKVisibility(self,State:bool,/)->bool:
		"""Set the IK visibility state.

		### Parameters:
			- State: The IK visibility state.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def SetRotationPin(self,EffectorIndex:FBEffectorId,Value:bool,/)->bool:
		"""Set the object Pinned in Rotation (Manipulation) status.

		### Parameters:
			- EffectorIndex: Given Index to obtain Model.
			- Value: The object Pinned in Rotation status.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def SetSkeletonVisibility(self,State:bool,/)->bool:
		"""Set the skeleton visibility state.

		### Parameters:
			- State: The skeleton visibility state.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def SetTranslationPin(self,EffectorIndex:FBEffectorId,Value:bool,/)->bool:
		"""Set the object Pinned in Translation (Manipulation) status.

		### Parameters:
			- EffectorIndex: Given Index to obtain Model
			- Value: The object Pinned in Translation status.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of new character."""
		...
class FBActor(FBConstraint):
	"""[FBActor](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_actor.html "FBActor is used to link motion data to a character.") is used to link motion data to a character.

	In MotionBuilder, an actor is a model used to link captured motion data to a character. Use functions in [FBActor](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_actor.html "FBActor is used to link motion data to a character.") to set the body color, skeleton color, pivot color, marker size, pivot size, pivot information, etc. on an actor.These classes are under development and may change dramatically between versions.To obtain the list of actors present in a scene, you need to create an instance of class [FBSystem](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_system.html "Provides access to the underlying system, and the MotionBuilder scene."), to obtain the current scene. The [FBScene](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_scene.html "Access to the MotionBuilder scene.") object holds the list of actors in the property Actors.

	```c++
	FBSystem lSystem;
	FBScene* lScene = lSystem.Scene;
	for( int lIdx = 0; lIdx < lScene->Actors.GetCount(); ++lIdx )
	{
	 FBTrace( "Actor[%d]: '%s'\\n", lIdx, (char*)lScene->Actors[lIdx] );
	}
	```
	The current actor selected in the Character tool can be obtained via the [FBApplication](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_application.html "FBApplication is used mainly to manage files.") object.

	```c++
	FBApplication lApplication;
	FBActor* lActor = lApplication.CurrentActor;
	if( lActor )
	{
	 FBTrace( "Current actor is: '%s'\\n", (char*)lActor->Name );
	}
	else
	{
	 FBTrace( "No actor currently selected\\n" );
	}
	```"""
	BodyColor:FBColor
	"""Read Write Property: The color of the body of the actor."""
	@property
	def ChestOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@ChestOffsetR.setter
	def ChestOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def ChestOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@ChestOffsetT.setter
	def ChestOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	ChestPosition:FBVector3d
	"""Read Write Property: Body part pivot of the actor."""
	@property
	def FKFingerMultiplier(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to augment the amount of FK propagation for unmarkered intermediate finger phalanges."""
		...
	@FKFingerMultiplier.setter
	def FKFingerMultiplier(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def FKFingerTipMultiplier(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to augment the amount of FK propagation for unmarkered finger tip phalanges."""
		...
	@FKFingerTipMultiplier.setter
	def FKFingerTipMultiplier(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def FKThumbTipMultiplier(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to augment the amount of FK propagation for unmarkered thumb tip phalanges."""
		...
	@FKThumbTipMultiplier.setter
	def FKThumbTipMultiplier(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def HeadOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@HeadOffsetR.setter
	def HeadOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def HeadOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@HeadOffsetT.setter
	def HeadOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	HeadPosition:FBVector3d
	"""Read Write Property: Body part pivot of the actor."""
	@property
	def HipsOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@HipsOffsetR.setter
	def HipsOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def HipsOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@HipsOffsetT.setter
	def HipsOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	HipsPosition:FBVector3d
	"""Read Write Property: Body part pivot of the actor."""
	@property
	def HumanFingerLimits(self)->FBPropertyAnimatableBool:
		"""Read Write Property: Enables/Disables human finger limits during actor solve."""
		...
	@HumanFingerLimits.setter
	def HumanFingerLimits(self, Value: FBPropertyAnimatableBool|bool):...
	IKManip:bool
	"""Read Write Property: Access to the IK Manip mode. This property is shared for all actors."""
	@property
	def LeftAnkleOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@LeftAnkleOffsetR.setter
	def LeftAnkleOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftAnkleOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@LeftAnkleOffsetT.setter
	def LeftAnkleOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	LeftAnklePosition:FBVector3d
	"""Read Write Property: Body part pivot of the actor."""
	@property
	def LeftCollarOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@LeftCollarOffsetR.setter
	def LeftCollarOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftCollarOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@LeftCollarOffsetT.setter
	def LeftCollarOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	LeftCollarPosition:FBVector3d
	"""Read Write Property: Body part pivot of the actor."""
	@property
	def LeftElbowOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@LeftElbowOffsetR.setter
	def LeftElbowOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftElbowOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@LeftElbowOffsetT.setter
	def LeftElbowOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	LeftElbowPosition:FBVector3d
	"""Read Write Property: Body part pivot of the actor."""
	@property
	def LeftFootOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@LeftFootOffsetR.setter
	def LeftFootOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftFootOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@LeftFootOffsetT.setter
	def LeftFootOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	LeftFootPosition:FBVector3d
	"""Read Write Property: Body part pivot of the actor."""
	@property
	def LeftHandIndexIndex(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandIndexIndex.setter
	def LeftHandIndexIndex(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandIndexMiddle(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandIndexMiddle.setter
	def LeftHandIndexMiddle(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandIndexPinky(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandIndexPinky.setter
	def LeftHandIndexPinky(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandIndexRing(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandIndexRing.setter
	def LeftHandIndexRing(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandMiddleIndex(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandMiddleIndex.setter
	def LeftHandMiddleIndex(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandMiddleMiddle(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandMiddleMiddle.setter
	def LeftHandMiddleMiddle(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandMiddlePinky(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandMiddlePinky.setter
	def LeftHandMiddlePinky(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandMiddleRing(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandMiddleRing.setter
	def LeftHandMiddleRing(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandPinkyIndex(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandPinkyIndex.setter
	def LeftHandPinkyIndex(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandPinkyMiddle(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandPinkyMiddle.setter
	def LeftHandPinkyMiddle(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandPinkyPinky(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandPinkyPinky.setter
	def LeftHandPinkyPinky(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandPinkyRing(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandPinkyRing.setter
	def LeftHandPinkyRing(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandRingIndex(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandRingIndex.setter
	def LeftHandRingIndex(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandRingMiddle(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandRingMiddle.setter
	def LeftHandRingMiddle(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandRingPinky(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandRingPinky.setter
	def LeftHandRingPinky(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHandRingRing(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@LeftHandRingRing.setter
	def LeftHandRingRing(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def LeftHipOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@LeftHipOffsetR.setter
	def LeftHipOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftHipOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@LeftHipOffsetT.setter
	def LeftHipOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	LeftHipPosition:FBVector3d
	"""Read Write Property: Body part pivot of the actor."""
	@property
	def LeftIndexAOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@LeftIndexAOffsetR.setter
	def LeftIndexAOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftIndexAOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@LeftIndexAOffsetT.setter
	def LeftIndexAOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftIndexBOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@LeftIndexBOffsetR.setter
	def LeftIndexBOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftIndexBOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@LeftIndexBOffsetT.setter
	def LeftIndexBOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftIndexCOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@LeftIndexCOffsetR.setter
	def LeftIndexCOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftIndexCOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@LeftIndexCOffsetT.setter
	def LeftIndexCOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftKneeOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@LeftKneeOffsetR.setter
	def LeftKneeOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftKneeOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@LeftKneeOffsetT.setter
	def LeftKneeOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	LeftKneePosition:FBVector3d
	"""Read Write Property: Body part pivot of the actor."""
	@property
	def LeftMiddleAOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@LeftMiddleAOffsetR.setter
	def LeftMiddleAOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftMiddleAOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@LeftMiddleAOffsetT.setter
	def LeftMiddleAOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftMiddleBOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@LeftMiddleBOffsetR.setter
	def LeftMiddleBOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftMiddleBOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@LeftMiddleBOffsetT.setter
	def LeftMiddleBOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftMiddleCOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@LeftMiddleCOffsetR.setter
	def LeftMiddleCOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftMiddleCOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@LeftMiddleCOffsetT.setter
	def LeftMiddleCOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftPinkyAOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@LeftPinkyAOffsetR.setter
	def LeftPinkyAOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftPinkyAOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@LeftPinkyAOffsetT.setter
	def LeftPinkyAOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftPinkyBOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@LeftPinkyBOffsetR.setter
	def LeftPinkyBOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftPinkyBOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@LeftPinkyBOffsetT.setter
	def LeftPinkyBOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftPinkyCOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@LeftPinkyCOffsetR.setter
	def LeftPinkyCOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftPinkyCOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@LeftPinkyCOffsetT.setter
	def LeftPinkyCOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftRingAOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@LeftRingAOffsetR.setter
	def LeftRingAOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftRingAOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@LeftRingAOffsetT.setter
	def LeftRingAOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftRingBOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@LeftRingBOffsetR.setter
	def LeftRingBOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftRingBOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@LeftRingBOffsetT.setter
	def LeftRingBOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftRingCOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@LeftRingCOffsetR.setter
	def LeftRingCOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftRingCOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@LeftRingCOffsetT.setter
	def LeftRingCOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftShoulderOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@LeftShoulderOffsetR.setter
	def LeftShoulderOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftShoulderOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@LeftShoulderOffsetT.setter
	def LeftShoulderOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	LeftShoulderPosition:FBVector3d
	"""Read Write Property: Body part pivot of the actor."""
	@property
	def LeftThumbAOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@LeftThumbAOffsetR.setter
	def LeftThumbAOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftThumbAOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@LeftThumbAOffsetT.setter
	def LeftThumbAOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftThumbBOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@LeftThumbBOffsetR.setter
	def LeftThumbBOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftThumbBOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@LeftThumbBOffsetT.setter
	def LeftThumbBOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftThumbCOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@LeftThumbCOffsetR.setter
	def LeftThumbCOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftThumbCOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@LeftThumbCOffsetT.setter
	def LeftThumbCOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftWristOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@LeftWristOffsetR.setter
	def LeftWristOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def LeftWristOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@LeftWristOffsetT.setter
	def LeftWristOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	LeftWristPosition:FBVector3d
	"""Read Write Property: Body part pivot of the actor."""
	ManipulateOffsets:bool
	"""Read Write Property: Flag to compute offsets while manipulating. If it is set to false, the manipulator is re-snapping as before. If it is set to true, offsets properties (T and R) are computed and candidated instead."""
	MarkerSet:FBMarkerSet
	"""Read Write Property: Associated marker set."""
	MarkerSetSize:float
	"""Read Write Property: The size of the markers of the actor."""
	@property
	def NeckOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@NeckOffsetR.setter
	def NeckOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def NeckOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@NeckOffsetT.setter
	def NeckOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	NeckPosition:FBVector3d
	"""Read Write Property: Body part pivot of the actor."""
	OutputMarkerSet:FBMarkerSet
	"""Read Write Property: Associated output marker set."""
	PivotColor:FBColor
	"""Read Write Property: The color of the pivot points of the actor."""
	PivotPointsVisibility:bool
	"""Read Write Property: Show or Hide the Pivot Points."""
	PivotSize:float
	"""Read Write Property: The size of the pivot points of the actor."""
	@property
	def RightAnkleOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@RightAnkleOffsetR.setter
	def RightAnkleOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightAnkleOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@RightAnkleOffsetT.setter
	def RightAnkleOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	RightAnklePosition:FBVector3d
	"""Read Write Property: Body part pivot of the actor."""
	@property
	def RightCollarOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@RightCollarOffsetR.setter
	def RightCollarOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightCollarOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@RightCollarOffsetT.setter
	def RightCollarOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	RightCollarPosition:FBVector3d
	"""Read Write Property: Body part pivot of the actor."""
	@property
	def RightElbowOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@RightElbowOffsetR.setter
	def RightElbowOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightElbowOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@RightElbowOffsetT.setter
	def RightElbowOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	RightElbowPosition:FBVector3d
	"""Read Write Property: Body part pivot of the actor."""
	@property
	def RightFootOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@RightFootOffsetR.setter
	def RightFootOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightFootOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@RightFootOffsetT.setter
	def RightFootOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	RightFootPosition:FBVector3d
	"""Read Write Property: Body part pivot of the actor."""
	@property
	def RightHandIndexIndex(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandIndexIndex.setter
	def RightHandIndexIndex(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandIndexMiddle(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandIndexMiddle.setter
	def RightHandIndexMiddle(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandIndexPinky(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandIndexPinky.setter
	def RightHandIndexPinky(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandIndexRing(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandIndexRing.setter
	def RightHandIndexRing(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandMiddleIndex(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandMiddleIndex.setter
	def RightHandMiddleIndex(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandMiddleMiddle(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandMiddleMiddle.setter
	def RightHandMiddleMiddle(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandMiddlePinky(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandMiddlePinky.setter
	def RightHandMiddlePinky(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandMiddleRing(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandMiddleRing.setter
	def RightHandMiddleRing(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandPinkyIndex(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandPinkyIndex.setter
	def RightHandPinkyIndex(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandPinkyMiddle(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandPinkyMiddle.setter
	def RightHandPinkyMiddle(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandPinkyPinky(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandPinkyPinky.setter
	def RightHandPinkyPinky(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandPinkyRing(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandPinkyRing.setter
	def RightHandPinkyRing(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandRingIndex(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandRingIndex.setter
	def RightHandRingIndex(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandRingMiddle(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandRingMiddle.setter
	def RightHandRingMiddle(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandRingPinky(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandRingPinky.setter
	def RightHandRingPinky(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHandRingRing(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Used to set blending coefficients. Each of the 4 fingers can be a blend of the 4 finger. This is not available for thumbs."""
		...
	@RightHandRingRing.setter
	def RightHandRingRing(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def RightHipOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@RightHipOffsetR.setter
	def RightHipOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightHipOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@RightHipOffsetT.setter
	def RightHipOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	RightHipPosition:FBVector3d
	"""Read Write Property: Body part pivot of the actor."""
	@property
	def RightIndexAOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@RightIndexAOffsetR.setter
	def RightIndexAOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightIndexAOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@RightIndexAOffsetT.setter
	def RightIndexAOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightIndexBOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@RightIndexBOffsetR.setter
	def RightIndexBOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightIndexBOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@RightIndexBOffsetT.setter
	def RightIndexBOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightIndexCOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@RightIndexCOffsetR.setter
	def RightIndexCOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightIndexCOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@RightIndexCOffsetT.setter
	def RightIndexCOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightKneeOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@RightKneeOffsetR.setter
	def RightKneeOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightKneeOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@RightKneeOffsetT.setter
	def RightKneeOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	RightKneePosition:FBVector3d
	"""Read Write Property: Body part pivot of the actor."""
	@property
	def RightMiddleAOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@RightMiddleAOffsetR.setter
	def RightMiddleAOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightMiddleAOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@RightMiddleAOffsetT.setter
	def RightMiddleAOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightMiddleBOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@RightMiddleBOffsetR.setter
	def RightMiddleBOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightMiddleBOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@RightMiddleBOffsetT.setter
	def RightMiddleBOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightMiddleCOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@RightMiddleCOffsetR.setter
	def RightMiddleCOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightMiddleCOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@RightMiddleCOffsetT.setter
	def RightMiddleCOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightPinkyAOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@RightPinkyAOffsetR.setter
	def RightPinkyAOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightPinkyAOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@RightPinkyAOffsetT.setter
	def RightPinkyAOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightPinkyBOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@RightPinkyBOffsetR.setter
	def RightPinkyBOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightPinkyBOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@RightPinkyBOffsetT.setter
	def RightPinkyBOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightPinkyCOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@RightPinkyCOffsetR.setter
	def RightPinkyCOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightPinkyCOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@RightPinkyCOffsetT.setter
	def RightPinkyCOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightRingAOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@RightRingAOffsetR.setter
	def RightRingAOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightRingAOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@RightRingAOffsetT.setter
	def RightRingAOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightRingBOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@RightRingBOffsetR.setter
	def RightRingBOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightRingBOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@RightRingBOffsetT.setter
	def RightRingBOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightRingCOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@RightRingCOffsetR.setter
	def RightRingCOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightRingCOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@RightRingCOffsetT.setter
	def RightRingCOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightShoulderOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@RightShoulderOffsetR.setter
	def RightShoulderOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightShoulderOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@RightShoulderOffsetT.setter
	def RightShoulderOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	RightShoulderPosition:FBVector3d
	"""Read Write Property: Body part pivot of the actor."""
	@property
	def RightThumbAOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@RightThumbAOffsetR.setter
	def RightThumbAOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightThumbAOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@RightThumbAOffsetT.setter
	def RightThumbAOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightThumbBOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@RightThumbBOffsetR.setter
	def RightThumbBOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightThumbBOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@RightThumbBOffsetT.setter
	def RightThumbBOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightThumbCOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@RightThumbCOffsetR.setter
	def RightThumbCOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightThumbCOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@RightThumbCOffsetT.setter
	def RightThumbCOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightWristOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@RightWristOffsetR.setter
	def RightWristOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def RightWristOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@RightWristOffsetT.setter
	def RightWristOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	RightWristPosition:FBVector3d
	"""Read Write Property: Body part pivot of the actor."""
	SkeletonColor:FBColor
	"""Read Write Property: The color of the skeleton of the actor."""
	SkeletonVisibility:bool
	"""Read Write Property: Show or Hide the Skeleton."""
	SymmetryEditRotation:bool
	"""Read Write Property: Symmetry Edit (Rotation) mode state. Only effective when IKManip property is set to false. This property is shared for all actors."""
	SymmetryEditScaling:bool
	"""Read Write Property: Symmetry Edit (Scaling) mode state. Only effective when IKManip property is set to false. This property is shared for all actors."""
	SymmetryEditTranslation:bool
	"""Read Write Property: Symmetry Edit (Translation) mode state. Only effective when IKManip property is set to false. This property is shared for all actors."""
	Visibility:bool
	"""Read Write Property: Show or Hide the Actor Body."""
	@property
	def WaistOffsetR(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local rotation offset that is applied after the actor solve"""
		...
	@WaistOffsetR.setter
	def WaistOffsetR(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def WaistOffsetT(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Local translation offset that is applied after the actor solve"""
		...
	@WaistOffsetT.setter
	def WaistOffsetT(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	WaistPosition:FBVector3d
	"""Read Write Property: Body part pivot of the actor."""
	@overload
	def GetCurrentSkeletonState(self)->FBSkeletonState:...
	@overload
	def GetCurrentSkeletonState(self,ResetOrientation:bool,/)->FBSkeletonState:
		"""Return the Current Skeleton State.

		### Parameters:
			- ResetOrientation: When set to true, all rotations in the state will be reset to characterization values.

		### Returns:
		Current Skeleton State
		### Note:
		Usage of this function can be found in script sample /bin/config/Scripts/Samples/Character/CharacterMarkerSetFromActor.py"""
		...
	def GetDefaultSkeletonState(self)->FBSkeletonState:
		"""Return the Default Skeleton State.

		### Returns:
		Default Skeleton State"""
		...
	def GetDefinitionRotationVector(self,SkeletonId:FBSkeletonNodeId,RotationVector:FBVector3d,/)->None:
		"""Get Actor Rotation Definition.

		Only effective when IKManip property is set to false.
		### Parameters:
			- SkeletonId: Skeleton Node Id
			- RotationVector: Actor Rotation Definition for the given ID"""
		...
	def GetDefinitionScaleVector(self,SkeletonId:FBSkeletonNodeId,ScaleVector:FBVector3d,/)->None:
		"""Get Actor Scaling Definition.

		### Parameters:
			- SkeletonId: Skeleton Node Id
			- ScaleVector: Actor Scaling Definition for the given ID"""
		...
	def GetDefinitionTranslationVector(self,SkeletonId:FBSkeletonNodeId,TranslationVector:FBVector3d,/)->None:
		"""Get Actor Translation Definition.

		Only effective when IKManip property is set to false.
		### Parameters:
			- SkeletonId: Skeleton Node Id
			- TranslationVector: Actor Translation Definition for the given ID"""
		...
	def SetActorTranslation(self,TranslationVector:FBVector3d,/)->None:
		"""Translate Actor, similar to moving the hips of the Actor in the UI.

		Only effective when IKManip property is set to false.
		### Parameters:
			- TranslationVector: Will move the entire Actor to pTranslationVector coordinate"""
		...
	def SetDefinitionRotationVector(self,SkeletonId:FBSkeletonNodeId,RotationVector:FBVector3d,SymmetricUpdate:bool=True,/)->None:
		"""Set Actor Rotation Definition.

		Only effective when IKManip property is set to false.
		### Parameters:
			- SkeletonId: Skeleton Node Id
			- RotationVector: Actor Rotation value for the given ID
			- SymmetricUpdate: Update right and left part at the same time"""
		...
	def SetDefinitionScaleVector(self,SkeletonId:FBSkeletonNodeId,ScaleVector:FBVector3d,SymmetricUpdate:bool=True,/)->None:
		"""Set Actor Scaling Definition.

		### Parameters:
			- SkeletonId: Skeleton Node Id
			- ScaleVector: Actor Scaling value for the given ID
			- SymmetricUpdate: Update right and left part at the same time"""
		...
	def SetDefinitionTranslationVector(self,SkeletonId:FBSkeletonNodeId,TranslationVector:FBVector3d,SymmetricUpdate:bool=True,/)->None:
		"""Set Actor Translation Definition.

		Only effective when IKManip property is set to false.
		### Parameters:
			- SkeletonId: Skeleton Node Id
			- TranslationVector: Actor Translation value for the given ID
			- SymmetricUpdate: Update right and left part at the same time"""
		...
	def UpdateValues(self,EvalInfo:FBEvaluateInfo,/)->None:
		"""Update Internal Values to be corresponding to the Given Evaluate Information.

		### Parameters:
			- EvalInfo: Evaluate Info of the Values"""
		...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of new actor."""
		...
class FBConstraintRelation(FBConstraint):
	"""ConstraintRelation class.

	This class exposes the relation constraint and allows addition of new boxes and removal of existing ones.

	[See sample: TraversingRelationConstraint.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_traversing_relation_constraint_8py-example.html)"""
	Boxes:FBPropertyListBox
	"""List: Boxes used in this constraint."""
	def ConstrainObject(self,ConstrainedObject:FBBox,/)->FBBox:
		"""Create a receiver box.

		Use an existing [FBBox](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_box.html "A box is a fundamental building block in the application architecture.") object to create a receiver in the relation.
		### Parameters:
			- ConstrainedObject: Destination box to insert in the constraint.

		### Returns:
		A place holder box for the object."""
		...
	def CreateFunctionBox(self,Group:str,Name:str,/)->FBBox:
		"""Create a function box.

		Ask the constraint to create new function box.
		### Parameters:
			- Group: Name of the group under which the function is located in the Constraint Relation GUI (case-sensitive!).
			- Name: Name of the function, as seen in the GUI (case-sensitive!).

		### Returns:
		The newly created function box, or NULL if the name/group combination was invalid."""
		...
	def GetBoxPosition(self,arg2:FBBox,/)->tuple[bool,int,int]:
		"""Get a box position in the GUI.

		Get the position of a box within the constraint layout view.
		### Returns:
		A tuple containing: the result of operation (bool), X value (int), and Y value(int)"""
		...
	def SetAsSource(self,Source:FBBox,/)->FBBox:
		"""Create a sender box.

		Use an existing [FBBox](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_box.html "A box is a fundamental building block in the application architecture.") object to create a sender in the relation.
		### Parameters:
			- Source: Source box to insert in the constraint.

		### Returns:
		A place holder box for the object."""
		...
	def SetBoxPosition(self,Box:FBBox,X:int,Y:int,/)->bool:
		"""Set a box position in the GUI.

		Set the position of a box within the constraint layout view.
		### Parameters:
			- Box: Box which needs to be moved.
			- X: New X position.
			- Y: New Y position.

		### Returns:
		A boolean value indicating success (True) or failure (False)."""
		...
	def __init__(self,Name:str|None=None,/):
		"""### Parameters:
			- Name: Name of constraint."""
		...
class FBCycleAnalysisNode(FBBox):
	"""Cycle Analysis class."""
	RealTime:bool
	"""Read Only Property: Real time."""
	RootHMode:FBRootHMode
	"""Read Only Property: RootH Mode."""
	RootRMode:FBRootRMode
	"""Read Only Property: RootR Mode."""
	RootSpeedMode:FBRootSpeedMode
	"""Read Only Property: Root Speed Mode."""
	RootXZMode:FBRootXZMode
	"""Read Only Property: RootXZ Mode."""
	def GetPoseFCurve(self)->FBFCurve:...
	def GetRootHFCurve(self)->FBFCurve:...
	def GetRootRFCurve(self)->FBFCurve:...
	def GetRootSpeedFCurve(self)->FBFCurve:...
	def GetRootXZFCurve(self)->FBFCurve:...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of new cycle analysis node."""
		...
class FBConstraintSolver(FBConstraint):
	"""Base class for constraint solver."""
	def __init__(self,Name:str|None=None,/):...
class FBDevice(FBBox):
	"""Base Device class.

	Cannot be instantiated from Python.

	[See samples: StartDevice.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_start_device_8py-example.html) [StopDevice.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_stop_device_8py-example.html)"""
	CommType:int
	"""Read Write Property: Type of communications."""
	HardwareVersionInfo:str
	"""Read Write Property: Device information: hardware version."""
	Information:str
	"""Read Write Property: Device information: information."""
	ModelBindingRoot:FBModel
	"""Component: Root of model currently binded model hierarchy."""
	ModelTemplate:FBModelTemplate
	"""Component: Root of model template structure."""
	Online:bool
	"""Read Write Property: Is online?"""
	RecordingStartTime:FBTime
	"""Read Only Property: The time at which the recording started."""
	RecordingStopTime:FBTime
	"""Read Only Property: The time at which the recording stopped."""
	SamplingMode:FBDeviceSamplingMode
	"""Read Write Property: Mode to use to record device."""
	SamplingPeriod:FBTime
	"""Read Write Property: Set this to how many times a device is to be evaluated in one second. There is no theoretical maximum value but practically you should consider scene complexity, system resources, network speed, etc. If set to 0: the device is evaluated on the sync signal. When the sync occurs; the device is scheduled to be evaluated. If you do not set, the sampling period is based on the internal variable from the [Sync] section of the .Application.txt file (NTSC, PAL, CINEMA)."""
	Status:str
	"""Read Write Property: Device information: status."""
	def AckOneBadSampleReceived(self)->None:
		"""Acknowlege that one bad sample was received (for statistical purposes)."""
		...
	def AckOneSampleReceived(self)->None:
		"""Acknowlege that one sample was received (for statistical purposes)."""
		...
	def AckOneSampleSent(self)->None:
		"""Acknowlege that one sample was sent (for statistical purposes)."""
		...
	def ModelBindingCreate(self)->FBModel:
		"""Create a new model binding.

		### Returns:
		The model root that has been created or NULL is an error occured."""
		...
	def ModelBindingRootsList(self,List:FBModelList,/)->None:
		"""Get the list of all the possible root models for binding.

		### Parameters:
			- List: List to add found models to."""
		...
	def RecordingDoneAnimation(self,AnimationNode:FBAnimationNode,/)->None:
		"""When recording, finish animation.

		### Parameters:
			- AnimationNode: Animation node to write information to."""
		...
	def RecordingInitAnimation(self,AnimationNode:FBAnimationNode,/)->None:
		"""When recording, initialize animation.

		### Parameters:
			- AnimationNode: Animation node to read information from."""
		...
class FBGlobalLight(FBBox):
	"""Global light class."""
	@property
	def AmbientColor(self)->FBPropertyAnimatableColor:
		"""Read Write Property: Ambient light color."""
		...
	@AmbientColor.setter
	def AmbientColor(self, Value: FBPropertyAnimatableColor|FBColor):...
	@property
	def FogBegin(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Begin fog distance."""
		...
	@FogBegin.setter
	def FogBegin(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def FogColor(self)->FBPropertyAnimatableColor:
		"""Read Write Property: Fog color."""
		...
	@FogColor.setter
	def FogColor(self, Value: FBPropertyAnimatableColor|FBColor):...
	@property
	def FogDensity(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Fog density."""
		...
	@FogDensity.setter
	def FogDensity(self, Value: FBPropertyAnimatableDouble|float):...
	FogEnable:bool
	"""Read Write Property: Enable fog?"""
	@property
	def FogEnd(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: End fog distance."""
		...
	@FogEnd.setter
	def FogEnd(self, Value: FBPropertyAnimatableDouble|float):...
	FogMode:FBFogMode
	"""Read Write Property: Fog falloff mode."""
	def __init__(self):...
class FBDeviceOptical(FBDevice):
	"""Optical device class."""
	AutoAntialiasing:bool
	"""Property: Is it auto-antialiasing?"""
	DampingTime:float
	"""Property: Damping time for device."""
	ForceOpticalSamplingRate:bool
	"""Property: Force the use of the optical sampling rate?"""
	MarkerTimeStamp:FBTime
	"""Property: TimeStamp for marker."""
	Markers:FBPropertyListDeviceOpticalMarker
	"""List: Markers."""
	ModelOptical:FBModel
	"""Property: Optical model for manipulation."""
	OpticalSamplingRate:float
	"""Property: Resampling rate for optical device."""
	SkipFrame:bool
	"""Property: Skip Record Frame"""
	SupportOcclusion:bool
	"""Property: Does the device support occulsion?"""
	UseMarkerTimeStamp:bool
	"""Property: Use the individual marker timestamps?"""
	def DeviceOperation(self,Operation:kDeviceOperations,/)->bool:
		"""Operate device.

		This is an operation such as Init, Start, Done, Reset, etc.
		### Parameters:
			- Operation: Operation to have device perform.

		### Returns:
		Current state : <b true if online."""
		...
	def DeviceOpticalBeginSetup(self)->None:
		"""Begin device setup."""
		...
	def DeviceOpticalEndSetup(self)->None:
		"""End device setup."""
		...
	def DeviceOpticalRecordFrame(self,Time:FBTime,DeviceNotifyInfo:FBDeviceNotifyInfo,/)->None:
		"""Record a frame of information from device.

		Virtual function that derived class may overide
		### Parameters:
			- Time: Time of evaluation.
			- DeviceNotifyInfo: Notification information when thread was called."""
		...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Unique name of optical device."""
		...
class FBGroup(FBBox):
	"""Objects Grouping class.

	This class is an interface to manipulate object's grouping in the scene.

	[See samples: FBGetSelectedModels.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_f_b_get_selected_models_8py-example.html) [FBGroup.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_f_b_group_8py-example.html)"""
	Items:FBPropertyListComponent
	"""List: Items in the group."""
	Pickable:bool
	"""Read Write Property: Controls if objects in the group are pickable."""
	Show:bool
	"""Read Write Property: Controls if objects in the group are displayed."""
	Transformable:bool
	"""Read Write Property: Controls if objects in the group are transformable."""
	def Clone(self)->FBGroup:
		"""Clone the group.

		This will duplicated the current group.
		### Returns:
		Newly created group."""
		...
	def Contains(self,Component:FBComponent,/)->bool:
		"""Contains.

		### Parameters:
			- Component: Component to verify if it is in the Group

		### Returns:
		True if the object is in the Group"""
		...
	def Select(self,Select:bool,/)->None:
		"""Select.

		### Parameters:
			- Select: If **true**, group contents will be selected."""
		...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Group name."""
		...
class FBHUD(FBBox):
	"""Heads Up display.

	Display scene related information to the screen. This information will also be present in the rendered frames when creating AVIs or QuickTime files.

	[See samples: BloopSlate.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_h_u_d_0c_bloop_slate_8py-example.html) [HUDElements.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_h_u_d_0c_h_u_d_elements_8py-example.html) [HUDTextElement.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_h_u_d_0c_h_u_d_text_element_8py-example.html) [RecordLight.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_h_u_d_0c_record_light_8py-example.html) [Timeline.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_h_u_d_0c_timeline_8py-example.html) [HUD.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_h_u_d_8py-example.html)"""
	class EStockElement(Enumeration):
		eBloopSlate:FBHUD.EStockElement
		eFlashElement:FBHUD.EStockElement
		eRecordLight:FBHUD.EStockElement
		eRectElement:FBHUD.EStockElement
		eTextElement:FBHUD.EStockElement
		eTextureElement:FBHUD.EStockElement
		eTimeline:FBHUD.EStockElement
	Elements:FBPropertyListHUDElement
	"""List: Elements present in the HUD."""
	HUDs:FBPropertyListHUD
	"""List: HUDS attached to this HUD."""
	OnDisplay:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: Callback just before HUD is displayed to update custom values"""
	Visibility:bool
	"""Read Write Property: Indicate if the information will be displayed or not."""
	eBloopSlate:FBHUD.EStockElement
	eFlashElement:FBHUD.EStockElement
	eRecordLight:FBHUD.EStockElement
	eRectElement:FBHUD.EStockElement
	eTextElement:FBHUD.EStockElement
	eTextureElement:FBHUD.EStockElement
	eTimeline:FBHUD.EStockElement
	def CreateCustomElement(self,HUDElementClassName:str,Name:str,/)->FBHUDElement:
		"""Creates a custom HUD Element.

		### Parameters:
			- HUDElementClassName: The HUD Element class name (mainly, the ClassName parameter of the FBStorableCustomHUDElementImplementation macro).
			- Name: Name for the custom HUD Element to create.

		### Returns:
		The created custom HUD Element."""
		...
	def CreateElement(self,Type:EStockElement,Name:str,/)->FBHUDElement:
		"""Creates a stock HUD Element.

		### Parameters:
			- Type: View to be called for expose.
			- Name: Name for the HUD Element to create.

		### Returns:
		The created HUD Element."""
		...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of new HUD."""
		...
class FBHUDElement(FBBox):
	"""Heads Up display.

	Display scene related information on a camera output. Rendered on video out, output renderings."""
	Height:float
	"""Read Write Property: Specifies the height of HUD element on the screen. It's in pixel when ScaleByPercent is false and percentage when ScaleByPercent is true."""
	HorizontalDock:FBHUDElementHAlignment
	"""Read Write Property: Specifies if the HUD element will be horizontally docked to the Left, Right, or Center."""
	Justification:FBHUDElementHAlignment
	"""Read Write Property: Specifies if the justification of the HUD element is Left, Right, or Center."""
	PositionByPercent:bool
	"""Read Write Property: When set to true, X and Y position values are in percentage, relative to the corresponding camera view dimension. Otherwise, they are absolute pixel values."""
	ScaleByPercent:bool
	"""Read Write Property: When set to true, Scale is in percentage, relative to the corresponding camera view dimension. Otherwise, it is an absolute value."""
	ScaleUniformly:bool
	"""Read Write Property: Specifies whether the width and height of HUD element will be scaled uniformly according to the initial aspect ratio."""
	Show:bool
	"""Read Write Property: Specifies if the HUD element will be displayed or not."""
	VerticalDock:FBHUDElementVAlignment
	"""Read Write Property: Specifies if the HUD element will be vertically docked to the Bottom, Top, or Center."""
	Visibility:bool
	Width:float
	"""Read Write Property: Specifies the width of HUD element on the screen. It's in pixel when ScaleByPercent is false and percentage when ScaleByPercent is true."""
	X:float
	"""Read Write Property: Specifies the horizontal position of the HUD element, relative to dock position and justification."""
	Y:float
	"""Read Write Property: Specifies the vertical position of the HUD element, relative to dock position and justification."""
class FBHandle(FBBox):
	"""[FBHandle](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_handle.html "FBHandle class exposes the Handle object of the application.") class exposes the Handle object of the application.

	This is a terminal class and should not be used as a base for a new class."""
	Follow:FBPropertyListObject
	"""List: Object to be followed by the handle. Should have a cardinality of 1."""
	Image:FBPropertyListObject
	"""List: Image to be used in the handle display. Only the image at position 0 is used."""
	Manipulate:FBPropertyListObject
	"""List: Objects manipulated by the handle."""
	ManipulateRotation:FBPropertyListObject
	"""List: Objects manipulated by the handle. Only their rotation is affected."""
	ManipulateScaling:FBPropertyListObject
	"""List: Objects manipulated by the handle. Only their scaling is affected."""
	ManipulateTranslation:FBPropertyListObject
	"""List: Objects manipulated by the handle. Only their translation is affected."""
	def Select(self)->None:
		"""Meta selection.

		With this method, the handle itself is selected as well as all the models that are manipulated by the handle."""
		...
	def __init__(self,Name:str,/):
		"""Public constructor.

		This constructor is used to create a new object.
		### Parameters:
			- Name: Object name."""
		...
class FBHUDFlashElement(FBHUDElement):
	"""Heads Up display.

	Flash HUD element. Display a flash (swf) file rendered on the HUD.

	[See sample: HUDElements.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_h_u_d_0c_h_u_d_elements_8py-example.html)"""
	FilePath:str
	"""Read Write Property: Path to load the swf file from"""
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of new HUD flash element."""
		...
class FBHUDRectElement(FBHUDElement):
	"""Heads Up display.

	Rectangle HUD element.

	[See sample: HUDElements.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_h_u_d_0c_h_u_d_elements_8py-example.html)"""
	Color:FBColorAndAlpha
	"""Read Write Property: Color of the rectangluar region."""
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of new HUD rectangle element."""
		...
class FBHUDBloopSlateElement(FBHUDFlashElement):
	"""Heads Up display.

	Bloop Slate HUD element. Display a bloop slate (swf) file rendered on the HUD."""
	BackgroundColor:FBColorAndAlpha
	"""Read Write Property: Bloop slate background color, by default it is 100% transparent."""
	Enable:bool
	"""Read Write Property: Bloop slate will appear if set to true."""
	ForegroundColor:FBColorAndAlpha
	"""Read Write Property: Bloop slate foreground color."""
	ShowAfterDelayOnRecordPlay:FBTime
	"""Read Write Property: Delay before the bloop slate is displayed after recording has started."""
	ShowDuration:FBTime
	"""Read Write Property: Time that the bloop slate will be displayed."""
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of new HUD flash element."""
		...
class FBHUDTimelineElement(FBHUDFlashElement):
	"""Heads Up display.

	HUD Timeline element. Displays a timeline that shows Head, Cut, Tail regions, and current time cursor. The drawing is defined in the flash file(timeline.swf).

	[See sample: Timeline.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_h_u_d_0c_timeline_8py-example.html)"""
	CutActiveColor:FBColorAndAlpha
	"""Read Write Property: Specifies color of the Cut region when it is active."""
	CutIdleColor:FBColorAndAlpha
	"""Read Write Property: Specifies color of the Cut region when it is idle."""
	HeadActiveColor:FBColorAndAlpha
	"""Read Write Property: Specifies color of the Head region when it is active."""
	HeadDuration:FBTime
	"""Read Write Property: Specifies duration of the Head region."""
	HeadIdleColor:FBColorAndAlpha
	"""Read Write Property: Specifies color of the Head region when it is idle."""
	TailActiveColor:FBColorAndAlpha
	"""Read Write Property: Specifies color of the Tail region when it is active."""
	TailDuration:FBTime
	"""Read Write Property: Specifies duration of the Tail region."""
	TailIdleColor:FBColorAndAlpha
	"""Read Write Property: Specifies color of the Tail region when it is idle."""
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of new HUD flash element."""
		...
class FBHUDTextElement(FBHUDElement):
	"""Heads Up display.

	Text element. Render text with a background rectangle to the HUD.

	[See samples: HUDElements.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_h_u_d_0c_h_u_d_elements_8py-example.html) [HUDTextElement.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_h_u_d_0c_h_u_d_text_element_8py-example.html) [HUD.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_h_u_d_8py-example.html)"""
	AdjustWidthToFitText:bool
	"""Read Write Property: If On it it will adjust the width of a text element so that a text character's aspect ratio does not change as the content grows or shrinks."""
	BackgroundColor:FBColorAndAlpha
	"""Read Write Property: Background text color."""
	Color:FBColorAndAlpha
	"""Read Write Property: Text color."""
	Content:str
	"""Read Write Property: C like format to display like in printf."""
	Font:str
	"""Read Write Property: Specifies the font."""
	ForceTimeCodeDisplay:bool
	"""Read Write Property: Specifies if the display of time-related reference property will be in timecode format."""
	def GetFontList(self)->FBStringList:
		"""Returns a list of supported fonts."""
		...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of new HUD text element."""
		...
class FBHUDTextureElement(FBHUDElement):
	"""Heads Up display.

	Texture HUD element. Display a texture on a rectangle on the HUD.

	[See sample: HUDElements.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_h_u_d_0c_h_u_d_elements_8py-example.html)"""
	Texture:FBPropertyListTexture
	"""Read Write Property: Texture to display."""
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of new HUD texture element."""
		...
class FBMaterial(FBBox):
	"""Material class.

	[See samples: MaterialAndTexture.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_material_and_texture_0c_material_and_texture_8py-example.html) [TextureAnimation.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_material_and_texture_0c_texture_animation_8py-example.html) [VideoInput.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_video_0c_video_input_8py-example.html) [VideoMemory.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_video_0c_video_memory_8py-example.html)"""
	@property
	def Ambient(self)->FBPropertyAnimatableColor:
		"""Read Write Property: Ambient color."""
		...
	@Ambient.setter
	def Ambient(self, Value: FBPropertyAnimatableColor|FBColor):...
	@property
	def AmbientFactor(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Ambient Factor value."""
		...
	@AmbientFactor.setter
	def AmbientFactor(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def Bump(self)->FBPropertyAnimatableColor:
		"""Read Write Property: Bump."""
		...
	@Bump.setter
	def Bump(self, Value: FBPropertyAnimatableColor|FBColor):...
	@property
	def BumpFactor(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Bump Factor value."""
		...
	@BumpFactor.setter
	def BumpFactor(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def Diffuse(self)->FBPropertyAnimatableColor:
		"""Read Write Property: Diffuse color."""
		...
	@Diffuse.setter
	def Diffuse(self, Value: FBPropertyAnimatableColor|FBColor):...
	@property
	def DiffuseFactor(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Diffuse Factor value."""
		...
	@DiffuseFactor.setter
	def DiffuseFactor(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def DisplacementColor(self)->FBPropertyAnimatableColor:
		"""Read Write Property: Displacement color."""
		...
	@DisplacementColor.setter
	def DisplacementColor(self, Value: FBPropertyAnimatableColor|FBColor):...
	@property
	def DisplacementFactor(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Displacement Factor value."""
		...
	@DisplacementFactor.setter
	def DisplacementFactor(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def Emissive(self)->FBPropertyAnimatableColor:
		"""Read Write Property: Emissive color."""
		...
	@Emissive.setter
	def Emissive(self, Value: FBPropertyAnimatableColor|FBColor):...
	@property
	def EmissiveFactor(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Emissive Factor value."""
		...
	@EmissiveFactor.setter
	def EmissiveFactor(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def NormalMap(self)->FBPropertyAnimatableColor:
		"""Read Write Property: Normal Map."""
		...
	@NormalMap.setter
	def NormalMap(self, Value: FBPropertyAnimatableColor|FBColor):...
	@property
	def Reflection(self)->FBPropertyAnimatableColor:
		"""Read Write Property: Reflection color."""
		...
	@Reflection.setter
	def Reflection(self, Value: FBPropertyAnimatableColor|FBColor):...
	@property
	def ReflectionFactor(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Reflection Factor value."""
		...
	@ReflectionFactor.setter
	def ReflectionFactor(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def Shininess(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Shininess value."""
		...
	@Shininess.setter
	def Shininess(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def Specular(self)->FBPropertyAnimatableColor:
		"""Read Write Property: Specular color."""
		...
	@Specular.setter
	def Specular(self, Value: FBPropertyAnimatableColor|FBColor):...
	@property
	def SpecularFactor(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Specular Factor value."""
		...
	@SpecularFactor.setter
	def SpecularFactor(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def TransparencyFactor(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Transparency Factor value."""
		...
	@TransparencyFactor.setter
	def TransparencyFactor(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def TransparentColor(self)->FBPropertyAnimatableColor:
		"""Read Write Property: Transparent color."""
		...
	@TransparentColor.setter
	def TransparentColor(self, Value: FBPropertyAnimatableColor|FBColor):...
	def Clone(self)->FBMaterial:
		"""Clone the material.

		This will duplicated the current material.
		### Returns:
		Newly created material."""
		...
	def GetTexture(self,Type:FBMaterialTextureType=FBMaterialTextureType.kFBMaterialTextureDiffuse,/)->FBTexture:
		"""Retrieve associated texture.

		### Parameters:
			- Type: MaterialTextureType to get connected texture from (default is Diffuse is not specified)."""
		...
	def OGLInit(self)->None:
		"""Setup OpenGL fixed pipeline material settings."""
		...
	def SetTexture(self,Texture:FBTexture,Type:FBMaterialTextureType=FBMaterialTextureType.kFBMaterialTextureDiffuse,/)->None:
		"""Set associated texture.

		### Parameters:
			- Texture: texture to be connected.
			- Type: MaterialTextureType to set connected texture to."""
		...
	def __copy__(self)->FBMaterial:...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of material."""
		...
class FBModel(FBBox):
	"""Model class.

	In the MotionBuilder UI, a model can be any object in a scene, created using geometry. Models can represent simple objects like cubes, or complex objects like characters.FBModel is a base class which is not used so much directly, but is the parent of well-used classes like [FBCamera](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_camera.html "Creates custom cameras and manages system cameras."), [FBLight](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_light.html "Light class."), and FBModelMarker.It also implements a number of widely-implemented functions and attributes, such as: [Clone()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model.html#a274a3375ea62b5634a4b6b00c6b42f8f "Clone the model."), [FBDelete()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model.html#aa85a55e68d7403dbd4238f3e30e83119 "Open Reality deletion function.") UI attributes such as Show, Pickable, and Visibility Positional attributes such as Rotation, Scaling, and Translation The following Python snippet shows how to create, show, rotate, and delete a cube

	```python
	from pyfbsdk import *
	myCube = FBModelCube("cube")
	myCube.Show = True
	myCube.Rotation = FBVector3d(45, 45, 45)
	myCube.FBDelete()
	```
	There is a few ways to get a handle on existing models in a scene: FBFindObjectsByName return a list of objects matching a pattern (can contain *). For usage, see: FindObjectsWithWildcard.py If you know the name of the model, use FBFindModelByLabelName, as demonstrated in FBComponent.py. FBGetSelectedModels can get a handle to an object which is derived from [FBModel](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model.html "Model class."). It searches the scene for a model, based on the model's unique name and returns a list of all the selected things in the scene.

	[See sample: ResetLocalTranslationRotation.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_reset_local_translation_rotation_8py-example.html)"""
	AnimationNode:FBAnimationNode
	"""Read Only Property: Animation node of the model."""
	BlendShapeDeformable:bool
	"""Read Write Property: Model blend-shape deformable. Not Savable"""
	CastsShadows:bool
	"""Read Write Property: If true, the geometry will produce shadows."""
	Children:FBPropertyListModel
	"""List: Children for model."""
	ConstrainDeformable:bool
	"""Read Write Property: Model constraint deformable. Not Savable"""
	CullingMode:FBModelCullingMode
	Deformers:FBPropertyListDeformer
	"""List: Deformers (Skeleton Deformer or Point Cache Deformer)."""
	GeometricRotation:FBVector3d
	"""Read Write Property: Geometric rotation."""
	GeometricScaling:FBVector3d
	"""Read Write Property: Geometric scaling."""
	GeometricTranslation:FBVector3d
	"""Read Write Property: Geometric translation."""
	Geometry:FBGeometry
	"""Read Write Property: Geometry for the model."""
	GeometryUpdateId:int
	"""Read Only Property: model geometry (vertex data) related update id."""
	Icon3D:bool
	"""Read Write Property: Is model a 3D icon?"""
	IsConstrained:bool
	"""Read Only Property: Is model constrained?"""
	IsDeformable:bool
	"""Read Only Property: Is model deformable?"""
	IsVisible:bool
	"""If the model is visible.

	Note. this query will consider self Visibility property, plus parent node/set Visibility. The visibility of a model is affected by 4 parameters:
	### Parameters:
		- EvaluateInfo: evaluate info,

	### Returns:
	true if visible for the given evaluate info."""
	LookAt:FBModel
	"""Read Write Property: Look at model (interest point)."""
	Materials:FBPropertyListMaterial
	"""List: Materials for model."""
	ModelVertexData:FBModelVertexData
	"""Read Only Property: ModelVertexData for the model."""
	Parent:FBModel|None
	"""Read Write Property: Parent model."""
	Pickable:bool
	"""Read Write Property: Indicate if a model can be picked in the viewer. This has a default value of 'true'."""
	PointCacheDeformable:bool
	"""Read Write Property: Model point cache deformable. Not Savable"""
	PointCacheRecord:bool
	"""Read Write Property: Record Point Cache for model? Not Savable"""
	PostRotation:FBVector3d
	"""Read Write Property: Post Rotation (considered if RotationActive is true)"""
	PreRotation:FBVector3d
	"""Read Write Property: Pre Rotation (considered if RotationActive is true)"""
	PrimaryVisibility:bool
	"""Read Write Property: Control the geometry render state. Geometry can still cast shadows even if this is turned off."""
	QuaternionInterpolate:bool
	"""Read Write Property: Use quaternion interpolation."""
	ReceiveShadows:bool
	"""Read Write Property: If true, the geometry will receive shadows."""
	@property
	def Rotation(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Lcl rotation."""
		...
	@Rotation.setter
	def Rotation(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	RotationActive:bool
	"""Read Write Property: Is model using Rotation Limits?"""
	RotationMax:FBVector3d
	"""Read Write Property: Max Rotation Limit (considered if RotationActive is true)"""
	RotationMaxX:bool
	"""Read Write Property: Is model using Maximum Rotation Limits On X?"""
	RotationMaxY:bool
	"""Read Write Property: Is model using Maximum Rotation Limits On Y?"""
	RotationMaxZ:bool
	"""Read Write Property: Is model using Maximum Rotation Limits On Z?"""
	RotationMin:FBVector3d
	"""Read Write Property: Min Rotation Limit (considered if RotationActive is true)"""
	RotationMinX:bool
	"""Read Write Property: Is model using Minimum Rotation Limits On X?"""
	RotationMinY:bool
	"""Read Write Property: Is model using Minimum Rotation Limits On Y?"""
	RotationMinZ:bool
	"""Read Write Property: Is model using Minimum Rotation Limits On Z?"""
	RotationOrder:FBModelRotationOrder
	"""Read Write Property: Rotation order."""
	RotationSpaceForLimitOnly:bool
	"""Read Write Property: Apply Post Rotation Matrix only for Limits?"""
	@property
	def Scaling(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Lcl scaling."""
		...
	@Scaling.setter
	def Scaling(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	Scene:FBScene
	"""Read Only Property: Scene containing the model."""
	Shaders:FBPropertyListShader
	"""List: Shaders for model."""
	ShadingMode:FBModelShadingMode
	"""Read Write Property: Shading mode for the model."""
	Show:bool
	"""Read Write Property: Indicate if the viewer should show the object, according to its visibility value. This has a default value of 'false'."""
	SkeletonDeformable:bool
	"""Read Write Property: Model skeleton deformable. Not Savable"""
	SoftSelected:bool
	"""Read Write Property: Is model Soft selected?"""
	Textures:FBPropertyListTexture
	"""List: Textures with Special UseType (Other than "Color" which should connect to materials)."""
	Transformable:bool
	"""Read Write Property: Indicate if a model can be transformable in the viewer. This has a default value of 'true'."""
	@property
	def Translation(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Lcl translation."""
		...
	@Translation.setter
	def Translation(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	UniqueColorId:FBColor
	"""Read Only Property: Unique Color Id for color based viewer picking. Color channel values are in the range [0, 1] with 1.0/255 precision."""
	UpVector:FBModel
	"""Read Write Property: UpVector model."""
	@property
	def Visibility(self)->FBPropertyAnimatableBool:
		"""Read Write Property: Visibility of model. This can be overridden by the 'Show' property."""
		...
	@Visibility.setter
	def Visibility(self, Value: FBPropertyAnimatableBool|bool):...
	VisibilityInheritance:bool
	"""Read Write Property: //!< When this value is set to True the Visibility of this model is also applied to all its descendants"""
	def Clone(self)->FBModel:
		"""Clone the model.

		This will duplicate the current model.
		### Returns:
		Newly created model."""
		...
	def CollapseInSchematic(self)->None:
		"""Collapse the model in the schematic view."""
		...
	def DofToLRM(self,LM:FBMatrix,Dof:FBVector3d,/)->None:
		"""Convert object space vector to local matrix.

		### Parameters:
			- LM: Resulting local rotation matrix.
			- Dof: Vector to convert

		### Note:
		Use this function when you want to convert euler to local rotation with proper pre/post transformation and rotation order applied from this model."""
		...
	def ExpandInSchematic(self)->None:
		"""Expand the model in the schematic view."""
		...
	def FbxGetObjectSubType(self)->str:
		"""Returns the class sub type inherited by the class of an object, for example: 'Default', 'Mesh'."""
		...
	def FbxGetObjectType(self)->str:
		"""Returns the class type inherited by the class of an object, for example: 'Model'."""
		...
	def ForceAlwaysEvaluate(self)->None:
		"""Force Always Evaluate.

		In some case, MoBu kernel perform optimization by skipping certain evaluation tasks. This function stop skipping for this model."""
		...
	def GetAdditionalUniqueColorID(self,Index:int,/)->FBColor:
		"""Get Additional Unique Color Id.

		### Parameters:
			- Index: the requested unique color id index, can't be larger than GetAdditionalColorIDCount()

		### Returns:
		Additional Unique ColorId."""
		...
	def GetAdditionalUniqueColorIDCount(self)->int:
		"""Get additional unique color count.

		### Returns:
		Additional Unique Color Count."""
		...
	def GetBoundingBox(self,Min:FBVector3d,Max:FBVector3d,/)->None:
		"""Get the bounding box of the model.

		Note. for deformable model, this function will provide the approximated (larger than the smallest) bounding box for performance consideration.
		### Parameters:
			- Min: Output parameter. Minimum value of the bounding box.
			- Max: Output parameter. Maximum value of the bounding box."""
		...
	def GetHierarchyWorldMatrices(self,arg2:int,arg3:FBModelHiercharyTraverserType,arg4:FBEvaluateInfo|None=None,/)->list:
		"""Computes the global transform matrices between this model and all its children (all levels).

		The hierarchy world matrix for a model is represented as a global transform matrix applied on an arbitrary root hierarchy node (this model for instance), considered as the world reference.
		### Parameters:
			- MatricesArray: The matrix array (memory already allocated) to fill in with the hierarchy world matrix of all the model's children models
			- MatricesArrayCount: The size of the matrix array
			- HiercharyTraverserType: The hierarchy traverser type
			- EvaluateInfo: EvaluateInfo, Take Display if none specified."""
		...
	def GetLocalTransformationMatrixWithGlobalRotationDoF(self,Matrix:FBMatrix,Inverse:bool=False,EvaluateInfo:FBEvaluateInfo|None=None,/)->None:
		"""Get the local transformation (or local inverse transformation) matrix with the global Rotation DoF values from the model.

		The GetMatrix method was previously wrongly returning the local transformation (and local inverse transformation) matrices with global Rotation DoF values. The GetMatrix method implementation has been updated to not include the global Rotation DoF values. This method returns the same matrix values returned by the legacy GetMatrix implementation when retrieving the local transformation (and local inverse transformation) matrices.
		### Parameters:
			- Matrix: Matrix to fill with requested information.
			- Inverse: False for the transformation matrix, true for the inverse transformation matrix.
			- EvaluateInfo: EvaluateInfo, Take Display if none specified."""
		...
	def GetMatrix(self,Matrix:FBMatrix,What:FBModelTransformationType=FBModelTransformationType.kModelTransformation,GlobalInfo:bool=True,EvaluateInfo:FBEvaluateInfo|None=None,/)->None:
		"""Get a matrix from the model.

		### Parameters:
			- Matrix: Matrix to fill with requested information.
			- What: Type of information requested (default=transformation).
			- GlobalInfo: **true** if it is GlobalInfo, **false** if Local (default=true).
			- EvaluateInfo: EvaluateInfo, Take Display if none specified."""
		...
	def GetSchematicPosition(self)->FBVector2d:
		"""Get the position in the schematic view for the model.

		### Returns:
		Current position for the model."""
		...
	def GetSelectedPointsCount(self)->int:
		"""Get the number of selected points in the model.

		### Returns:
		Number of selected points."""
		...
	def GetVector(self,Vector:FBVector3d,What:FBModelTransformationType=FBModelTransformationType.kModelTranslation,GlobalInfo:bool=True,EvaluateInfo:FBEvaluateInfo|None=None,/)->None:
		"""Get a vector from the model.

		### Parameters:
			- Vector: Vector to fill with requested values.
			- What: Type of information requested (default=translation, inverses not supported).
			- GlobalInfo: **true** if it is GlobalInfo, **false** if Local (default=true).
			- EvaluateInfo: EvaluateInfo, Take Display if none specified"""
		...
	def IsCollapsedInSchematic(self)->bool:
		"""Returns if the model is collapsed or not (expanded) in the schematic view.

		### Returns:
		true if the model is collapsed in the schematic view, false if it is expanded."""
		...
	def IsEvaluationReady(self,What:FBModelEvaluationTaskType,EvaluateInfo:FBEvaluateInfo|None=None,/)->bool:
		"""Is the model's evaluation task result ready.

		### Parameters:
			- What: Type of evaluation task.
			- EvaluateInfo: EvaluateInfo, Take Display if none specified"""
		...
	def IsForceAlwaysEvaluate(self)->bool:
		"""Return Force Always Evaluate status."""
		...
	def LRMToDof(self,Dof:FBVector3d,LM:FBMatrix,/)->None:
		"""Convert local matrix to object space vector.

		### Parameters:
			- Dof: Resulting object space vector.
			- LM: Local rotation matrix to convert

		### Note:
		Use this function when you want to convert local rotation to euler with proper pre/post transformation and rotation order applied from this model."""
		...
	def MatrixToRotation(self,Rotation:FBVector3d,Matrix:FBMatrix,/)->None:
		"""Convert Rotation Matrix to Euler Vector based on model's rotation order.

		### Parameters:
			- Rotation: Resulting euler vector, whose angles are stored in [X,Y,Z] order.
			- Matrix: Matrix to convert."""
		...
	def NoFrustumCullingRelease(self)->int:
		"""Release no frustum culling request.

		### Returns:
		Current no frustum culling request count after function call."""
		...
	def NoFrustumCullingRequire(self)->int:
		"""Acquire no frustum culling request.

		### Returns:
		Current no frustum culling request count after function call."""
		...
	def RayCast(self,Camera:FBCamera,MouseX:int,MouseY:int,HitPosition:FBVector3d,HitNormal:FBVector3d,/)->bool:
		"""Ray cast test.

		### Parameters:
			- Camera: Camera to use for casting.
			- MouseX: Mouse X position.
			- MouseY: Mouse Y position.
			- HitPosition: Ray cast position on the object.
			- HitNormal: Normal at the ray cast position on the object.

		### Returns:
		true if it hit the meshes, hit would contains the precise position & normal."""
		...
	def RotationToMatrix(self,Matrix:FBMatrix,Rotation:FBVector3d,/)->None:
		"""Convert Euler Vector to Rotation Matrix based on model's rotation order.

		### Parameters:
			- Matrix: Resulting rotation matrix.
			- Rotation: Object space rotation vector to convert, whose angles are stored in [X,Y,Z] order."""
		...
	def SetAdditionalUniqueColorIDCount(self,Count:int,/)->bool:
		"""Request additional Unique color IDs.

		### Parameters:
			- Count: User should note that Unique Color ID resource is limited (only 24 bits), hence should avoid to use unnecessary large number.

		### Returns:
		True if Unique ColorId resource is available."""
		...
	def SetMatrix(self,Matrix:FBMatrix,What:FBModelTransformationType=FBModelTransformationType.kModelTransformation,arg4=None,arg5:FBEvaluateInfo|None=None,/)->None:
		"""Set a matrix for the model.

		### Parameters:
			- Matrix: Information to use to set the model's matrix.
			- What: Type of matrix to set (default=transformation).
			- GlobalInfo: **true** if it is GlobalInfo, **false** if Local (default=true).
			- PushUndo: **true** if this operation is undoable, don't push undo in non UI thread.
			- EvaluateInfo: EvaluateInfo, Take Display if none specified"""
		...
	def SetMatrixWithPrecision(self,Matrix:FBMatrix,What:FBModelTransformationType=FBModelTransformationType.kModelTransformation,arg4=None,arg5:FBEvaluateInfo|None=None,arg6=None,/)->None:
		"""Set a matrix for the model.

		### Parameters:
			- Matrix: Information to use to set the model's matrix.
			- What: Type of matrix to set (default=transformation).
			- GlobalInfo: **true** if it is GlobalInfo, **false** if Local (default=true).
			- PushUndo: **true** if this operation is undoable, don't push undo in non UI thread.
			- EvaluateInfo: EvaluateInfo, Take Display if none specified
			- Precision: Indicate the precision level, used when calculating the threshold value for gimble lock. 16 * pow(10.0, -10)) is the new default value since Mobu 2016, 16 * pow(10.0, -6)) is old default value before then."""
		...
	@overload
	def SetSchematicPosition(self,X:int,Y:int,/)->None:
		"""Set the position in the schematic view for the model.

		### Parameters:
			- X: X position to set.
			- Y: Y position to set."""
		...
	@overload
	def SetSchematicPosition(self,Vector2d:FBVector2d,/)->None:
		"""Set the position in the schematic view for the model.

		### Parameters:
			- Vector2d: Position to set."""
		...
	def SetVector(self,Vector:FBVector3d,What:FBModelTransformationType=FBModelTransformationType.kModelTranslation,arg4=None,arg5:FBEvaluateInfo|None=None,/)->None:
		"""Set a vector for the model.

		### Parameters:
			- Vector: Vector to use to set values.
			- What: Type of information to set (default=translation, inverses not supported).
			- GlobalInfo: **true** if it is GlobalInfo, **false** if Local (default=true).
			- PushUndo: **true** if this operation is undoable, don't push undo in non UI thread.
			- EvaluateInfo: EvaluateInfo, Take Display if none specified"""
		...
	def SetupPropertiesForShapes(self)->None:
		"""Setup Shape Properties.

		Normally this function is called automatically at the next global synchronization point after the geometry has been updated. However you must call it explicitly to access the shape properties immediately after shapes adding/removing before next global synchronization point.

		[See sample: ShapeCreation.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_geometry_0c_shape_creation_8py-example.html)"""
		...
	def UseFrustumCulling(self)->bool:
		"""Get the current Frustum Culling Status.

		### Returns:
		True if model don't use frustum culling currently."""
		...
	def __copy__(self)->FBModel:...
class FBNote(FBBox):
	"""Note class."""
	StaticComment:str
	"""Read Write Property: Comment associated to this note."""
	def Attach(self,Comp:FBComponent|None=None,/)->bool:
		"""Attach the note to a component.

		Will attach the note to the component. If pComp is NULL, the note will only be added to the scene.
		### Parameters:
			- Comp: Component on which to attach note.

		### Returns:
		A boolean indicating if the operation was successful or not."""
		...
	def Detach(self,Comp:FBComponent|None=None,/)->bool:
		"""Detach the note from a component.

		Will detach the note from the component. If pComp is NULL, the note will be removed from the scene and detached from all components.
		### Parameters:
			- Comp: Component from which to detach note.

		### Returns:
		A boolean indicating if the operation was successful or not."""
		...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of note."""
		...
class FBModelCube(FBModel):
	"""Cube model class.

	[See samples: FBGroup.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_f_b_group_8py-example.html) [FBModelCube.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_f_b_model_cube_8py-example.html)"""
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of cube."""
		...
class FBLight(FBModel):
	"""Light class."""
	class EAreaLightShapes(Enumeration):
		eRectangle:FBLight.EAreaLightShapes
		eSphere:FBLight.EAreaLightShapes
	AreaLightShape:FBLight.EAreaLightShapes
	"""Read Write Property: Area light shape."""
	AttenuationType:FBAttenuationType
	"""Read Write Property: Type of attenuation for the light."""
	BottomBarnDoor:float
	"""Read Write Property: Angle of bottom barn door."""
	CastLightOnObject:bool
	"""Read Write Property: Cast light on object?"""
	CastShadows:bool
	"""Read Write Property: Cast shadows on object?"""
	ConeAngle:float
	"""DEPRECATED  Equivalent to OuterAngle."""
	@property
	def DiffuseColor(self)->FBPropertyAnimatableColor:
		"""Read Write Property: Color: Diffuse color."""
		...
	@DiffuseColor.setter
	def DiffuseColor(self, Value: FBPropertyAnimatableColor|FBColor):...
	DrawFrontFacingVolumetric:bool
	"""Read Write Property: Draw front facing volumetric light?"""
	DrawGroundProjection:bool
	"""Read Write Property: Draw ground projection of gobo?"""
	DrawVolumetricLight:bool
	"""Read Write Property: Draw volumetric light with gobo?"""
	EnableBarnDoor:bool
	"""Read Write Property: Whether or not enable barn door."""
	@property
	def FogIntensity(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Intensity of the fog (spot light)."""
		...
	@FogIntensity.setter
	def FogIntensity(self, Value: FBPropertyAnimatableDouble|float):...
	GoboMedia:FBVideo
	"""Read Write Property: Media to use as a Gobo with the light."""
	@property
	def InnerAngle(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Inner Cone angle for light."""
		...
	@InnerAngle.setter
	def InnerAngle(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def Intensity(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Light intensity."""
		...
	@Intensity.setter
	def Intensity(self, Value: FBPropertyAnimatableDouble|float):...
	LeftBarnDoor:float
	"""Read Write Property: Angle of left barn door."""
	LightType:FBLightType
	"""Read Write Property: Type of light."""
	@property
	def OuterAngle(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Outer Cone angle for light."""
		...
	@OuterAngle.setter
	def OuterAngle(self, Value: FBPropertyAnimatableDouble|float):...
	RightBarnDoor:float
	"""Read Write Property: Angle of right barn door."""
	TopBarnDoor:float
	"""Read Write Property: Angle of top barn door."""
	eRectangle:FBLight.EAreaLightShapes
	eSphere:FBLight.EAreaLightShapes
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of light."""
		...
class FBCameraSwitcher(FBModel):
	"""Camera switcher.

	This class is a wrapper around the system's camera switcher object. There can only be one switcher in a given scene. Any attempts at creating a new instance will return the existing one.

	[See sample: CameraSwitcher.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_camera_0c_camera_switcher_8py-example.html)"""
	CurrentCamera:FBCamera
	"""Read Write Property: Camera currently being used by the switcher. Set to NULL to turn on evaluate switch, otherwise manual switch."""
	CurrentCameraIndex:int
	"""Read Write Property: Camera index currently being used by the switcher. Set to -1 to turn on evaluate switch."""
	def PlotToCamera(self,Camera:FBCamera,/)->bool:
		"""Plot the Camera Switcher animation onto a destination camera.

		The destination camera cannot be a system camera nor a camera currently used by the Camera Switcher.
		### Parameters:
			- Camera: Destination camera to plot on.

		### Returns:
		True if the plot operation has been processed successfully, false otherwise."""
		...
	def UseEvaluateSwitch(self)->None:...
	def __init__(self):...
class FBCamera(FBModel):
	"""Creates custom cameras and manages system cameras.

	When you look at a scene in the MotionBuilder Viewer, you are using a camera view.There are two types of cameras: Producer cameras. By default one of the producer cameras is used. These are always present. They can be configured but not destroyed. Custom cameras, created by the user.The SystemCamera property indicates whether a given camera is a producer or a custom camera.When you create a camera you should make it visible with the show property (inherited from [FBModel](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model.html "Model class.")).Use [FBCameraSwitcher](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_camera_switcher.html "Camera switcher.") to get and set the current camera. For usage, see the Python sample CameraSwitcher.py.To see how to create a camera with a marker as an interest, see the Python sample code in FBCamera.py. For usage in C++, see the manipcamera sample.

	[See samples: NewCamera.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_new_camera_8py-example.html) [RenderLayers.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_rendering_0c_render_layers_8py-example.html) [CameraSwitcher.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_camera_0c_camera_switcher_8py-example.html) [SetAllCamerasBackgroundColor.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_set_all_cameras_background_color_8py-example.html) [SetAllCamerasBackgroundColorFromCurrentCamera.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_set_all_cameras_background_color_from_current_camera_8py-example.html) [SetAllCamerasBackgroundColorFromFirstSelectedCamera.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_set_all_cameras_background_color_from_first_selected_camera_8py-example.html) [FBCamera.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_f_b_camera_8py-example.html)"""
	@property
	def AnimatableFarPlane(self)->FBPropertyAnimatableDouble:...
	@AnimatableFarPlane.setter
	def AnimatableFarPlane(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def AnimatableNearPlane(self)->FBPropertyAnimatableDouble:...
	@AnimatableNearPlane.setter
	def AnimatableNearPlane(self, Value: FBPropertyAnimatableDouble|float):...
	AntiAliasingIntensity:float
	"""Read Write Property: Anti-aliasing intensity."""
	AntiAliasingMethod:FBCameraAntiAliasingMethod
	"""Read Write Property: Anti-aliasing method."""
	ApertureMode:FBCameraApertureMode
	"""Read Write Property: Aperture mode."""
	@property
	def BackGroundColor(self)->FBPropertyAnimatableColor:
		"""Read Write Property: Background color for camera."""
		...
	@BackGroundColor.setter
	def BackGroundColor(self, Value: FBPropertyAnimatableColor|FBColor):...
	BackGroundImageCenter:bool
	"""Read Write Property: Center the background image"""
	BackGroundImageCrop:bool
	"""Read Write Property: Crop the background image"""
	BackGroundImageFit:bool
	"""Read Write Property: Fit the background image"""
	BackGroundImageKeepRatio:bool
	"""Read Write Property: Keep the background image's ratio"""
	@property
	def BackGroundImageOffsetX(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Ignored if BackGroundImageFit is true. X offset, in term of percentage of the fit background image width, applied on the background image."""
		...
	@BackGroundImageOffsetX.setter
	def BackGroundImageOffsetX(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def BackGroundImageOffsetY(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Ignored if BackGroundImageFit is true. Y offset, in term of percentage of the fit background image height, applied on the background image."""
		...
	@BackGroundImageOffsetY.setter
	def BackGroundImageOffsetY(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def BackGroundImageScaleX(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Ignored if BackGroundImageFit is true. X scale, in term of percentage of the fit background image width, applied on the background image."""
		...
	@BackGroundImageScaleX.setter
	def BackGroundImageScaleX(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def BackGroundImageScaleY(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Ignored if BackGroundImageFit and/or BackGroundImageKeepRatio is true. Y scale, in term of percentage of the fit background image height, applied on the background image. The X scale property is considered instead of this Y scale property if BackGroundImageKeepRatio is set to true."""
		...
	@BackGroundImageScaleY.setter
	def BackGroundImageScaleY(self, Value: FBPropertyAnimatableDouble|float):...
	BackGroundMedia:FBVideo
	BackGroundPlaneDistance:float
	"""Read Write Property: Set the distance for the background plane."""
	BackGroundPlaneDistanceMode:FBCameraDistanceMode
	"""Read Write Property: Select mode for the background plane's distance."""
	BackGroundTexture:FBTexture
	"""Read Write Property: Background Texture"""
	CameraViewportHeight:int
	"""Read Only Property: Camera Viewport height"""
	CameraViewportWidth:int
	"""Read Only Property: Camera Viewport width"""
	CameraViewportX:int
	"""Read Only Property: Camera Viewport start position's X value"""
	CameraViewportY:int
	"""Read Only Property: Camera Viewport start position's Y value"""
	Display2DMagnifierFrame:bool
	"""Read Write Property: Enable/Disable the drawing of the 2D Magnifier frame box."""
	DisplayTurnTableIcon:bool
	"""Read Write Property: Enable/Disable the drawing of the Turn Table icon."""
	FarPlaneDistance:float
	"""Read Write Property: Far plane distance."""
	@property
	def FieldOfView(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Field of View (used when in horizontal or vertical aperture modes)."""
		...
	@FieldOfView.setter
	def FieldOfView(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def FieldOfViewX(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Field of View X angle (used in horizontal and vertical aperture mode)."""
		...
	@FieldOfViewX.setter
	def FieldOfViewX(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def FieldOfViewY(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Field of View Y angle (used in horizontal and vertical aperture mode)."""
		...
	@FieldOfViewY.setter
	def FieldOfViewY(self, Value: FBPropertyAnimatableDouble|float):...
	FilmAspectRatio:float
	"""Read Write Property: Film aspect ratio."""
	FilmBackType:FBCameraFilmBackType
	"""Read Write Property: Film back standard type."""
	FilmSizeHeight:float
	"""Read Write Property: Height of the film."""
	FilmSizeWidth:float
	"""Read Write Property: Width of the film."""
	@property
	def FocalLength(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Focal Length."""
		...
	@FocalLength.setter
	def FocalLength(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def FocusAngle(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Focus Angle (rendering dof)."""
		...
	@FocusAngle.setter
	def FocusAngle(self, Value: FBPropertyAnimatableDouble|float):...
	FocusDistanceSource:FBCameraFocusDistanceSource
	"""Read Write Property: Select source for focusing."""
	FocusModel:FBModel
	"""Read Write Property: Another model that determines the focus distance."""
	@property
	def FocusSpecificDistance(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Specfic distance for focusing."""
		...
	@FocusSpecificDistance.setter
	def FocusSpecificDistance(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def ForeGroundAlpha(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Opacity of foreground."""
		...
	@ForeGroundAlpha.setter
	def ForeGroundAlpha(self, Value: FBPropertyAnimatableDouble|float):...
	ForeGroundImageCenter:bool
	"""Read Write Property: Center the foreground image"""
	ForeGroundImageCrop:bool
	"""Read Write Property: Crop the foreground image"""
	ForeGroundImageFit:bool
	"""Read Write Property: Fit the foreground image"""
	ForeGroundImageKeepRatio:bool
	"""Read Write Property: Keep the foreground image's ratio?"""
	@property
	def ForeGroundImageOffsetX(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Ignored if ForeGroundImageFit is true. X offset, in term of percentage of the fit foreground image width, applied on the foreground image."""
		...
	@ForeGroundImageOffsetX.setter
	def ForeGroundImageOffsetX(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def ForeGroundImageOffsetY(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Ignored if ForeGroundImageFit is true. Y offset, in term of percentage of the fit foreground image height, applied on the foreground image."""
		...
	@ForeGroundImageOffsetY.setter
	def ForeGroundImageOffsetY(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def ForeGroundImageScaleX(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Ignored if ForeGroundImageFit is true. X scale, in term of percentage of the fit foreground image width, applied on the foreground image."""
		...
	@ForeGroundImageScaleX.setter
	def ForeGroundImageScaleX(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def ForeGroundImageScaleY(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Ignored if ForeGroundImageFit and/or ForeGroundImageKeepRatio is true. Y scale, in term of percentage of the fit foreground image height, applied on the foreground image. The X scale property is considered instead of this Y scale property if ForeGroundImageKeepRatio is set to true."""
		...
	@ForeGroundImageScaleY.setter
	def ForeGroundImageScaleY(self, Value: FBPropertyAnimatableDouble|float):...
	ForeGroundMaterialThreshold:float
	"""Read Write Property: Material threshold for a transparent foreground."""
	ForeGroundMedia:FBVideo
	ForeGroundPlaneDistance:float
	"""Read Write Property: Set the distance for the foreground plane."""
	ForeGroundPlaneDistanceMode:FBCameraDistanceMode
	"""Read Write Property: Select mode for the foreground plane's distance."""
	ForeGroundTexture:FBTexture
	"""Read Write Property: ForeGround Texture"""
	ForeGroundTransparent:bool
	"""Read Write Property: Is the foreground transparent?"""
	FrameColor:FBColor
	"""Read Write Property: Frame color for camera."""
	FrameSizeMode:FBCameraFrameSizeMode
	"""Read Write Property: Frame size standard mode."""
	HUDs:FBPropertyListHUD
	"""List : HUDs present in this camera"""
	InteractiveMode:bool
	"""Read Write Property: Interactive mode?"""
	Interest:FBModel
	"""Read Write Property: Direct camera's interest."""
	@property
	def MagnifierPosX(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: 2D Magnifier X Position."""
		...
	@MagnifierPosX.setter
	def MagnifierPosX(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def MagnifierPosY(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: 2D Magnifier Y Position."""
		...
	@MagnifierPosY.setter
	def MagnifierPosY(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def MagnifierZoom(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: 2D Magnifier Zoom value."""
		...
	@MagnifierZoom.setter
	def MagnifierZoom(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def MotionBlurIntensity(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Motion Blur Intensity."""
		...
	@MotionBlurIntensity.setter
	def MotionBlurIntensity(self, Value: FBPropertyAnimatableDouble|float):...
	MouseLockCamera:bool
	"""Read Write Property: Mouse lock for camera?"""
	NearPlaneDistance:float
	"""Read Write Property: Near plane distance."""
	NumberOfSamples:int
	"""Read Write Property: Number of samples to oversample with."""
	@property
	def OpticalCenterX(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Optical Center X (mm)."""
		...
	@OpticalCenterX.setter
	def OpticalCenterX(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def OpticalCenterY(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Optical Center Y (mm)."""
		...
	@OpticalCenterY.setter
	def OpticalCenterY(self, Value: FBPropertyAnimatableDouble|float):...
	OrthoFactor:float
	"""Constant scale factor to be used with OrthoZoom for orthographic cameras."""
	OrthoZoom:float
	"""Read Write Property: Zoom factor of an orthographic camera."""
	PixelAspectRatio:float
	"""Read Write Property: Pixel aspect ratio."""
	ResolutionHeight:float
	"""Read Write Property: Resolution height."""
	ResolutionMode:FBCameraResolutionMode
	"""Read Write Property: Resolution standard mode."""
	ResolutionWidth:float
	"""Read Write Property: Resolution width."""
	@property
	def Roll(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Camera's roll on it's Z axis."""
		...
	@Roll.setter
	def Roll(self, Value: FBPropertyAnimatableDouble|float):...
	SafeAreaMode:FBCameraSafeAreaMode
	"""Read Write Property: Select mode for safe area."""
	SamplingType:FBCameraSamplingType
	"""Read Write Property: Type of over sampling."""
	SqueezeRatio:float
	"""Read Write Property: Squeeze ratio."""
	SystemCamera:bool
	"""Read Only Property: Indicate if this a producer (default or system) camera or a custom (user-created) camera."""
	@property
	def TurnTable(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Camera's rotation around its interest."""
		...
	@TurnTable.setter
	def TurnTable(self, Value: FBPropertyAnimatableDouble|float):...
	Type:FBCameraType
	"""Read Write Property: Type of camera"""
	Use2DMagnifier:bool
	"""Read Write Property: Enable/Disable the 2D Magnifier."""
	UseAccumulationBuffer:bool
	"""Read Write Property: Use accumulation buffer?"""
	UseAntiAliasing:bool
	"""Read Write Property: Use anti-aliasing?"""
	@property
	def UseDepthOfField(self)->FBPropertyAnimatableBool:
		"""Read Write Property: Use depth of field calculations?"""
		...
	@UseDepthOfField.setter
	def UseDepthOfField(self, Value: FBPropertyAnimatableBool|bool):...
	UseFrameColor:bool
	"""Read Write Property: Use frame color?"""
	UseMotionBlur:bool
	"""Read Write Property: Enable Motion Blur."""
	UseRealTimeMotionBlur:bool
	"""Read Write Property: Enable Real-time Motion Blur."""
	ViewBackGroundPlaneMode:FBCameraViewPlaneMode
	"""Read Write Property: Background plane view mode"""
	ViewCameraInterest:bool
	"""Read Write Property: Show the camera interest?"""
	ViewDisplaySafeArea:bool
	"""Read Write Property: Display safe area?"""
	ViewForeGroundPlaneMode:FBCameraViewPlaneMode
	"""Read Write Property: Foreground plane view mode"""
	ViewNearFarPlane:bool
	"""Read Write Property: Show near/far planes?"""
	ViewOpticalCenter:bool
	"""Read Write Property: View optical center?"""
	ViewShowAxis:bool
	"""Read Write Property: Show axis?"""
	ViewShowGrid:bool
	"""Read Write Property: Show grid?"""
	ViewShowName:bool
	"""Read Write Property: Show name?"""
	ViewShowTimeCode:bool
	"""Read Write Property: Show time code?"""
	WindowHeight:float
	"""Read Only Property: Window height."""
	WindowWidth:float
	"""Read Only Property: Window width."""
	def GetCameraMatrix(self,Matrix:FBMatrix,Type:FBCameraMatrixType,EvalInfo:FBEvaluateInfo|None=None,/)->None:
		"""Obtains the camera's matrix.

		### Parameters:
			- Matrix: Matrix to fill with requested information.
			- Type: Camera Matrix type to obtain.
			- EvalInfo: Take Display if none specified."""
		...
	@overload
	def InverseProjection(self,arg2,arg3,arg4,/)->FBVector4d:...
	@overload
	def InverseProjection(self,X:int,Y:int,DistanceFromCamera:float,RelativeToViewport:bool,/)->FBVector4d:
		"""Returns the world coordinates based on screen coordinates and input distance from the camera.

		### Parameters:
			- X: Screen horizontal coordinate in pixel. When pRelativeToViewport is false, the range is between 0 and (WindowWidth - 1). When pRelativeToViewport is true, the range is between 0 to (CameraViewportWidth - 1). The coordinate starts at left of the region.
			- Y: Screen vertical coordinate in pixel. When pRelativeToViewport is false, the range is between 0 and (WindowHeight - 1). When pRelativeToViewport is true, the range is between 0 to (CameraViewportHeight - 1). The coordinate starts at top of the region.
			- DistanceFromCamera: Distance from the camera to the resulting world coordinate position
			- RelativeToViewport: true indicates (pX,pY) is relative to the window; false indicates (pX,pY) is relative to the viewport of the camera.

		### Returns:
		The world coordinates in 3D space"""
		...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of camera."""
		...
class FBModelMarker(FBModel):
	"""Model marker class.

	[See sample: FBCamera.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_f_b_camera_8py-example.html)"""
	Color:FBColor
	"""Read Write Property: Color of model marker."""
	IKPivot:FBVector3d
	"""Read Write Property: marker Pivot Offset."""
	Length:float
	"""Read Write Property: Length for capsule (not related to scaling)."""
	Look:FBMarkerLook
	"""Read Write Property: Look of model marker."""
	ResLevel:FBMarkerResolutionLevel
	"""Read Write Property: Resolution level of model marker."""
	Size:float
	"""Read Write Property: Size (not related to scaling)."""
	Type:FBMarkerType
	"""Read Write Property: Type of model marker."""
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of model marker. If pObject is not NULL, pName will be ignored."""
		...
class FBCameraStereo(FBCamera):
	CenterCamera:FBCamera
	"""Read Write Property:  This property hold the center camera connected to it. Must be either the master, left or right camera."""
	DisplayZeroParallaxPlane:bool
	"""Read Write Property:  Display the zero parallax plane."""
	@property
	def FilmOffsetLeftCam(self)->FBPropertyAnimatableDouble:
		"""Read Write Property:  This property handles the film offset for the left camera. (inch)"""
		...
	@FilmOffsetLeftCam.setter
	def FilmOffsetLeftCam(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def FilmOffsetRightCam(self)->FBPropertyAnimatableDouble:
		"""Read Write Property:  This property handles the film offset for the right camera. (inch)"""
		...
	@FilmOffsetRightCam.setter
	def FilmOffsetRightCam(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def InteraxialSeparation(self)->FBPropertyAnimatableDouble:
		"""Read Write Property:  This property handles the distance between left and right cameras."""
		...
	@InteraxialSeparation.setter
	def InteraxialSeparation(self, Value: FBPropertyAnimatableDouble|float):...
	LeftCamera:FBCamera
	"""Read Write Property:  This property hold the left camera connected to it."""
	PrecompFileName:str
	"""Read Write Property:  This property handles the precomp file name."""
	RelativePrecompFileName:str
	"""Read Write Property:  This property handles the relative precomp file name."""
	RightCamera:FBCamera
	"""Read Write Property:  This property hold the right camera connected to it."""
	Stereo:FBCameraStereoType
	"""Read Write Property:  //!< This property handles the types of Stereo camera."""
	@property
	def ToeInAdjust(self)->FBPropertyAnimatableDouble:
		"""Read Write Property:  This property is to offset the computed toe-in effect when it's in Converged mode."""
		...
	@ToeInAdjust.setter
	def ToeInAdjust(self, Value: FBPropertyAnimatableDouble|float):...
	@property
	def ZeroParallax(self)->FBPropertyAnimatableDouble:
		"""Read Write Property:  This property handles the distance on the camera view axis where the zero parallax plane occurs."""
		...
	@ZeroParallax.setter
	def ZeroParallax(self, Value: FBPropertyAnimatableDouble|float):...
	ZeroParallaxPlaneColor:FBColor
	"""Read Write Property:  Zero parallax plane color."""
	ZeroParallaxPlaneTransparency:float
	"""Read Write Property:  Zero parallax plane transparency."""
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of stereo camera."""
		...
class FBModelNull(FBModel):
	"""Null object class."""
	Size:float
	"""Read Write Property: Size (not related to scaling)."""
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of null."""
		...
class FBModelMarkerOptical(FBModelMarker):
	"""Optical model marker class."""
	Data:FBAnimationNode
	"""Property: Data."""
	Done:bool
	"""Property: Done?"""
	Gaps:FBPropertyListOpticalGap
	"""Property: Gaps."""
	Optical:FBModelOptical
	"""Property: Optical model."""
	Segments:FBPropertyListMarkerSegment
	"""Property: Marker segments."""
	def ExportBegin(self)->int:
		"""Begin export of optical data.

		Sample communication with optical device and return the number of samples that were taken during the sampling period for statistical purposes.
		### Returns:
		Number of frames to export."""
		...
	def ExportEnd(self)->bool:
		"""End exportation from optical model.

		### Returns:
		true if successful."""
		...
	def ExportKey(self,X:float,Y:float,Z:float|None=None,Occlusion:float|None=None,/)->bool:
		"""Export a key of optical data.

		### Parameters:
			- X: X position.
			- Y: Y position.
			- Z: Z position(default=NULL).
			- Occlusion: Occlusion value(default=NULL).

		### Returns:
		true if successful."""
		...
	def GetRigidBody(self)->FBRigidBody:
		"""Get the rigid body for the marker.

		### Returns:
		Rigid body for marker (check IsValid())"""
		...
	def ImportBegin(self)->int:
		"""Begin import of optical data.

		Sample communication with optical device and return the number of samples that were taken during the sampling period for statistical purposes.
		### Returns:
		The number of samples taken."""
		...
	def ImportEnd(self)->bool:
		"""End importation and clean up data.

		Interpolates optical data to create a curve from the input key frams.
		### Returns:
		true if successful."""
		...
	def ImportKey(self,X:float,Y:float,Z:float=0.0,Occlusion:float=0.0,/)->bool:
		"""Import a key of optical data.

		### Parameters:
			- X: X position.
			- Y: Y position.
			- Z: Z position(default=0.0).
			- Occlusion: Occlusion value(default=0.0).

		### Returns:
		true if successful."""
		...
	def InsertSegmentedData(self,TData:FBAnimationNode,OData:FBAnimationNode,/)->None:
		"""Insert segmented data.

		### Parameters:
			- TData: Translation data.
			- OData: Occlusion data."""
		...
	def SetModelOptical(self,Optical:FBModelOptical,/)->None:
		"""Set the current optical model.

		### Parameters:
			- Optical: New optical model."""
		...
	def __init__(self,Name:str,Optical:FBModelOptical,/):
		"""If no optical model is given, be sure to add one before accessing the Segments and Gaps properties.
		### Parameters:
			- Name: Name of optical marker(default=NULL).
			- Optical: Optical model(default=NULL)."""
		...
class FBModelOptical(FBModel):
	"""Optical model class."""
	MarkerSize:float
	"""Read Write Property: Size of markers."""
	Markers:FBPropertyListModelMarkerOptical
	"""List: Markers."""
	RigidBodies:FBPropertyListRigidBody
	"""List: Rigid bodies."""
	SamplingPeriod:FBTime
	"""Read Write Property:Sampling period."""
	SamplingStart:FBTime
	"""Read Write Property: Sampling start time."""
	SamplingStop:FBTime
	"""Read Write Property:Sampling stop time."""
	Segments:FBPropertyListOpticalSegment
	"""List: Segments."""
	def ClearSegments(self,UnUsedOnly:bool=True,/)->None:
		"""Clear the segments (by default only the unused).

		### Parameters:
			- UnUsedOnly: Clear only the unused segments if **true**(default=true)."""
		...
	def CreateRigidBody(self,RigidBodyName:str,Markers:list[FBModelMarkerOptical],/)->FBRigidBody:
		"""Create a new rigid body from the given optical markers.

		### Parameters:
			- RigidBodyName: The name for the new rigid body to create. If left empty, the default "Rigid Body" name will be used.
			- Markers: The optical markers for creating the new rigid body.

		### Returns:
		The created rigid body if successful, and invalid rigid body otherwise. You can use the [FBRigidBody.IsValid()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_rigid_body.html#a9dcb9b43a3d0fa9003d4c1c9d921f6b2 "Check if valid (if item exists).") method to test if the returned rigid body object is valid or not."""
		...
	def ExportSetup(self)->bool:
		"""Setup exportation from optical model.

		### Returns:
		true if successful."""
		...
	def ImportSetup(self)->bool:
		"""Setup importation for optical model.

		### Returns:
		true if successful."""
		...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of optical model."""
		...
class FBModelPath3D(FBModel):
	"""Path 3D model class."""
	class EKeyPropertyBehavior(Enumeration):
		eLegacyVector4:FBModelPath3D.EKeyPropertyBehavior
		eVector:FBModelPath3D.EKeyPropertyBehavior
	class ELengthUnitType(Enumeration):
		eArchitectural:FBModelPath3D.ELengthUnitType
		eCM:FBModelPath3D.ELengthUnitType
		eKM:FBModelPath3D.ELengthUnitType
		eM:FBModelPath3D.ELengthUnitType
		eMI:FBModelPath3D.ELengthUnitType
	class EPathEndCapStyle(Enumeration):
		eArrow:FBModelPath3D.EPathEndCapStyle
		eNone:FBModelPath3D.EPathEndCapStyle
	AutoControlNode:bool
	"""Read Write Property: Automatically create key control nodes."""
	@property
	def Color(self)->FBPropertyAnimatableColor:
		"""Read Write Property: Path display color in viewport."""
		...
	@Color.setter
	def Color(self, Value: FBPropertyAnimatableColor|FBColor):...
	KeyPropertyBehavior:FBModelPath3D.EKeyPropertyBehavior
	"""Read Only Property: Key property behavior."""
	PathEndCapScale:float
	"""Read Write Property: Path end cap display scale."""
	PathEndCapStyle:EPathEndCapStyle
	"""Read Write Property: Path end cap display style."""
	PathLength:float
	"""Read Only Property: Path Length In Centimeter."""
	PathLengthInString:str
	"""Read Only Property: Path Length Display String According To The Current Unit."""
	PathLengthShow:bool
	"""Read Write Property: Path length label display or not."""
	PathLengthUnit:FBModelPath3D.ELengthUnitType
	"""Read Write Property: Path Length Unit."""
	TextBackground:FBColorAndAlpha
	"""Read Write Property: Path Length label display background color."""
	TextScale:float
	"""Read Write Property: Path Length label display scale."""
	eArchitectural:FBModelPath3D.ELengthUnitType
	eArrow:FBModelPath3D.EPathEndCapStyle
	eCM:FBModelPath3D.ELengthUnitType
	eKM:FBModelPath3D.ELengthUnitType
	eLegacyVector4:FBModelPath3D.EKeyPropertyBehavior
	eM:FBModelPath3D.ELengthUnitType
	eMI:FBModelPath3D.ELengthUnitType
	eNone:FBModelPath3D.EPathEndCapStyle
	eVector:FBModelPath3D.EKeyPropertyBehavior
	def ConvertSegmentPercentToTotalPercent(self,Percent:float,EvaluateInfo:FBEvaluateInfo|None=None,/)->float:
		"""Converting one key type Segment (time) to Total (percent).

		### Parameters:
			- Percent: Double value (as time)

		### Returns:
		Double value which represents the corresponding percentage"""
		...
	def ConvertToSegmentPercentFactor(self)->float:
		"""Get factor for multiplying the derivative of a key for segment mode.

		### Returns:
		Returns the derivative multiplication factor"""
		...
	def ConvertToTotalPercentFactor(self)->float:
		"""Get factor for multiplying the derivative of a key for total mode.

		### Returns:
		Returns the time factor"""
		...
	def ConvertTotalPercentToSegmentPercent(self,Percent:float,EvaluateInfo:FBEvaluateInfo|None=None,/)->float:
		"""Converting one key type Total (percent) to Segment (time).

		### Parameters:
			- Percent: Double value (as percentage)

		### Returns:
		Double value which represents the corresponding time."""
		...
	def GetSelectedPathKeyCount(self)->int:
		"""Query the number of keys present in the selected path.

		### Returns:
		Returns the number of keys in the selected path"""
		...
	def InsertNewEndKey(self)->int:
		"""Insert a new key at the end of the path.

		### Returns:
		Returns (N) where (N+1) is the new total number of keys, and since the new key becomes the Nth key (index starts from 0). If path is invalid, returns 0."""
		...
	def InsertNewStartKey(self)->int:
		"""Insert a new key at the start of the path.

		### Returns:
		Returns 0 since the new key becomes the first key. If path is invalid, returns 0."""
		...
	def PathKeyClear(self)->None:
		"""Clear the path keys."""
		...
	def PathKeyEndAdd(self,TLocal:FBVector4d,/)->int:
		"""Adds a new key to the end of the path (with time gap of 1 sec).

		The derivative value for the new key is copied from the left tangent of the last key.
		### Parameters:
			- TLocal: Vector value for the new added Key

		### Returns:
		Returns (N) where (N+1) is the new total number of keys, and since the new key becomes the Nth key (index starts from 0). If path is invalid, returns 0."""
		...
	def PathKeyGet(self,KeyIndex:int,/)->FBVector4d:
		"""Get path's key vector for at a particular key index.

		### Parameters:
			- KeyIndex: Key ID to set with

		### Returns:
		Return the vector containing the value of the path key."""
		...
	def PathKeyGetControlNode(self,KeyIndex:int,/)->FBModel:
		"""Get the path key's control node.

		Only works when KeyPropertyBehavior is eVector.
		### Parameters:
			- KeyIndex: Key ID to get

		### Returns:
		Path key's corresponding control node if successful, otherwise NULL."""
		...
	def PathKeyGetCount(self)->int:
		"""Query the number of keys present in the path.

		### Returns:
		Number of keys present in the path"""
		...
	def PathKeyGetLeftTangent(self,KeyIndex:int,/)->FBVector4d:
		"""Get the path key left tangent's vector value for designated index.

		### Parameters:
			- KeyIndex: Key ID at which left tangent value is required

		### Returns:
		Vector containing value of left tangent"""
		...
	def PathKeyGetLeftTangentLength(self,KeyIndex:int,/)->float:
		"""Query the length of the left tangent.

		### Parameters:
			- KeyIndex: Key ID to set with

		### Returns:
		Double value of the length of left tangent"""
		...
	def PathKeyGetProperty(self,KeyIndex:int,/)->FBProperty:
		"""Get the path key's corresponding property.

		Only works when KeyPropertyBehavior is eVector.
		### Parameters:
			- KeyIndex: Key ID to get

		### Returns:
		Path key's corresponding property if successful, otherwise NULL."""
		...
	def PathKeyGetRightTangent(self,KeyIndex:int,/)->FBVector4d:
		"""Get the path key right tangent's vector value for designated index.

		### Parameters:
			- KeyIndex: Key ID to set with

		### Returns:
		Vector containing value of left tangent"""
		...
	def PathKeyGetRightTangentLength(self,KeyIndex:int,/)->float:
		"""Query the value of the right tangent.

		### Parameters:
			- KeyIndex: Key ID to set with

		### Returns:
		Double value of the length of right tangent"""
		...
	def PathKeyGetXYZDerivative(self,KeyIndex:int,/)->FBVector4d:
		"""Get vector in XYZ coordinates for a path tangent.

		This works only if key interpolation type is CUBIC and tangent mode is User, Break or Auto.
		### Parameters:
			- KeyIndex: Key ID to set with

		### Returns:
		Vector with value for path's tangent XYZ derivatives"""
		...
	def PathKeyInsertAfter(self,KeyIndex:int,TLocal:FBVector4d,/)->int:
		"""Adds a new key immediately after the specified key ID (with time gap of 1 sec).

		The following keys are all shifted by 1 sec.
		### Parameters:
			- KeyIndex: Key ID to insert after. If key ID < 0 then the behavior is the same as PathKeyStartAdd. If key ID >= PathKeyGetCount-1 then the behavior is the same as PathKeyEndAdd.
			- TLocal: Vector value for the new added Key

		### Returns:
		Returns the newly inserted key ID."""
		...
	def PathKeyRemove(self,KeyIndex:int,/)->None:
		"""Remove key at a particular index.

		### Parameters:
			- KeyIndex: Key ID at which key is to be removed."""
		...
	def PathKeyRemoveSelected(self)->None:
		"""Remove the selected keys from the path."""
		...
	def PathKeySet(self,KeyIndex:int,TLocal:FBVector4d,Update:bool=True,/)->None:
		"""Set the local coordinate vector values for path at a particular key index.

		### Parameters:
			- KeyIndex: Key ID to set with
			- TLocal: Vector to use to set values to Key
			- Update: **true** if geometry update is required, **false** if not required (default=true)"""
		...
	def PathKeySetControlNode(self,KeyIndex:int,ControlNode:FBModel,/)->bool:
		"""Set the path key's control node.

		Only works when KeyPropertyBehavior is eVector and AutoControlNode is disabled.
		### Parameters:
			- KeyIndex: Key ID to set
			- ControlNode: Model to set as path key's control node.

		### Returns:
		True if successful, otherwise false."""
		...
	def PathKeySetLeftRightTangent(self,KeyIndex:int,KeyTLocal:FBVector4d,LeftTangentTLocal:FBVector4d,RightTangentTLocal:FBVector4d,Update:bool=True,/)->None:
		"""Set path's vectors for key, left tangent and right tangent at a particular key index.

		### Parameters:
			- KeyIndex: Key ID to set key for left and right tangents
			- KeyTLocal: Vector to use to set values to Key
			- LeftTangentTLocal: Vector to use to set values to Key Left Tangent
			- RightTangentTLocal: Vector to use to set values to Key Right Tangent
			- Update: **true** if geometry update is required, **false** if not required (default=true)"""
		...
	def PathKeySetLeftTangent(self,KeyIndex:int,TLocal:FBVector4d,Update:bool=True,/)->None:
		"""Set path's key left tangent vector for designated index.

		### Parameters:
			- KeyIndex: Key ID at which left tangent is to be set
			- TLocal: Vector to use to set values to Key
			- Update: **true** if geometry update is required, **false** if not required (default=true)"""
		...
	def PathKeySetRightTangent(self,KeyIndex:int,TLocal:FBVector4d,Update:bool=True,/)->None:
		"""Set 3D path's key right tangent vector for designated index.

		### Parameters:
			- KeyIndex: Key ID at which right tangent is to be set
			- TLocal: Vector to use to set values to Key
			- Update: **true** if geometry update is required, **false** if not required (default=true)"""
		...
	def PathKeySetXDerivative(self,KeyIndex:int,Derivative:float,Update:bool,/)->None:
		"""Set derivative in X coordinate for a path tangent.

		This works only if key interpolation type is CUBIC and tangent mode is User, Break or Auto.
		### Parameters:
			- KeyIndex: Key ID to set with
			- Derivative: Value of the derivative to apply to tangent
			- Update: **true** if geometry update is required, **false** if not required (default=true)"""
		...
	def PathKeySetXYZDerivative(self,KeyIndex:int,Derivative:FBVector4d,Update:bool,/)->None:
		"""Set derivative in XYZ coordinates for a path tangent.

		This works only if key interpolation type is CUBIC and tangent mode is User, Break or Auto.
		### Parameters:
			- KeyIndex: Key ID to set with
			- Derivative: Value of the derivative to apply to tangent
			- Update: **true** if geometry update is required, **false** if not required (default=true)"""
		...
	def PathKeySetYDerivative(self,KeyIndex:int,Derivative:float,Update:bool,/)->None:
		"""Set derivative in Y coordinate for a path tangent.

		This works only if key interpolation type is CUBIC and tangent mode is User, Break or Auto.
		### Parameters:
			- KeyIndex: Key ID to set with
			- Derivative: Value of the derivative to apply to tangent
			- Update: **true** if geometry update is required, **false** if not required (default=true)"""
		...
	def PathKeySetZDerivative(self,KeyIndex:int,Derivative:float,Update:bool,/)->None:
		"""Set derivative in Z coordinate for a path tangent.

		This works only if key interpolation type is CUBIC and tangent mode is User, Break or Auto.
		### Parameters:
			- KeyIndex: Key ID to set with
			- Derivative: Value of the derivative to apply to tangent
			- Update: **true** if geometry update is required, **false** if not required (default=true)"""
		...
	def PathKeyStartAdd(self,TLocal:FBVector4d,/)->int:
		"""Adds a new key to the start of the path (with time gap of 1 sec).

		The derivative value for the new key is copied from the right tangent of the first key.
		### Parameters:
			- TLocal: Vector value for the new added Key

		### Returns:
		Returns 0 since the new key becomes the first key. If path is invalid, returns 0."""
		...
	def Segment_GlobalPathEvaluate(self,SegmentPercent:float,EvaluateInfo:FBEvaluateInfo|None=None,/)->FBVector4d:
		"""Get the path's vector at a particular point within the curve, in global coordinates.

		### Parameters:
			- SegmentPercent: Double value (as time) at which the path vector would be computed

		### Returns:
		Vector value at the required point in the path"""
		...
	def Segment_GlobalPathEvaluateDerivative(self,SegmentPercent:float,EvaluateInfo:FBEvaluateInfo|None=None,/)->FBVector4d:
		"""Get the path's derivative at a particular point within the curve, in global coordinates.

		### Parameters:
			- SegmentPercent: Double value (as time) at which the path derivative would be computed

		### Returns:
		Vector value at the required point in the path"""
		...
	def Segment_IsPathKey(self,SegmentPercent:float,EvaluateInfo:FBEvaluateInfo|None=None,/)->int:
		"""Query whether a percentage value has a key associated at that point in the path.

		### Parameters:
			- SegmentPercent: Double value (as time) at which the path would be queried for existence of key

		### Returns:
		A valid key index in integer if key is present, otherwise -1"""
		...
	def Segment_LocalPathEvaluate(self,SegmentPercent:float,EvaluateInfo:FBEvaluateInfo|None=None,/)->FBVector4d:
		"""Get the path's vector at a particular point within the curve, in local coordinates.

		### Parameters:
			- SegmentPercent: Double value (as time) at which the path vector would be computed

		### Returns:
		Vector value at the required point in the path"""
		...
	def Segment_LocalPathEvaluateDerivative(self,SegmentPercent:float,EvaluateInfo:FBEvaluateInfo|None=None,/)->FBVector4d:
		"""Get the path's derivative at a particular point within the curve, in local coordinates.

		### Parameters:
			- SegmentPercent: Double value (as time) at which the path derivative would be computed

		### Returns:
		Vector value at the required point in the path"""
		...
	def ShowCurveControls(self,Show:bool,/)->None:
		"""Enable or disable displaying Curve Controls for the 3D model path.

		### Parameters:
			- Show: **true** if curve controls are to be displayed **false** if not required"""
		...
	def ShowCurvePoints(self,Show:bool,/)->None:
		"""Enable or disable displaying Curve Points for the 3D model path.

		### Parameters:
			- Show: **true** if curve points are to be displayed **false** if not required"""
		...
	def Total_GlobalPathEvaluate(self,TotalPercent:float,EvaluateInfo:FBEvaluateInfo|None=None,/)->FBVector4d:
		"""Get the path's vector at a particular point within the curve, in global coordinates.

		### Parameters:
			- TotalPercent: Double value (as percentage) at which the path vector would be computed

		### Returns:
		Vector value at the required point in the path"""
		...
	def Total_GlobalPathEvaluateDerivative(self,TotalPercent:float,EvaluateInfo:FBEvaluateInfo|None=None,/)->FBVector4d:
		"""Get the path's derivative at a particular point within the curve, in global coordinates.

		### Parameters:
			- TotalPercent: Double value (as percentage) at which the path derivative would be computed

		### Returns:
		Derivative value at the required point in the path"""
		...
	def Total_IsPathKey(self,TotalPercent:float,EvaluateInfo:FBEvaluateInfo|None=None,/)->int:
		"""Query whether a percentage value has a key associated at that point in the path.

		### Parameters:
			- TotalPercent: Double value (as percentage) at which the path would be queried for existence of key

		### Returns:
		A valid key index in integer if key is present, otherwise -1"""
		...
	def Total_LocalPathEvaluate(self,TotalPercent:float,EvaluateInfo:FBEvaluateInfo|None=None,/)->FBVector4d:
		"""Get the path's vector at a particular point within the curve, in local coordinates.

		### Parameters:
			- TotalPercent: Double value (as percentage) at which the path vector would be computed

		### Returns:
		Vector value at the required point in the path"""
		...
	def Total_LocalPathEvaluateDerivative(self,TotalPercent:float,EvaluateInfo:FBEvaluateInfo|None=None,/)->FBVector4d:
		"""Get the path's derivative at a particular point within the curve, in local coordinates.

		### Parameters:
			- TotalPercent: Double value (as percentage) at which the path derivative would be computed

		### Returns:
		Derivative value at the required point in the path"""
		...
	def UpdateGeometry(self)->None:
		"""Update path geometry explicitly."""
		...
	def __init__(self,Name:str,/):
		"""Python sample code:

		```python
		from pyfbsdk import *

		path = FBModelPath3D("Test")
		## After creation, a path always contain two default keys.
		## At this point, path.PathKeyGetCount() will be 2.
		path.Show = True
		## Reposition the two default keys
		path.PathKeySet(0,FBVector4d(0,0,50,0))
		path.PathKeySet(1,FBVector4d(50,0,0,0))
		## Add new keys at start and end of the path
		path.PathKeyStartAdd(FBVector4d(0,0,100,0))
		path.PathKeyEndAdd(FBVector4d(100,0,0,0))
		## Insert keys inbetween existing keys
		path.PathKeyInsertAfter(1,FBVector4d(0,25,50,0))
		path.PathKeyInsertAfter(2,FBVector4d(50,25,0,0))
		```
		### Parameters:
			- Name: Name of Path 3D."""
		...
class FBModelPlane(FBModel):
	"""Plane model class."""
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of Plane."""
		...
class FBModelRoot(FBModel):
	"""Root object class.

	[See sample: SelectModelsWithNameContainingSubstring.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_select_models_with_name_containing_substring_8py-example.html)"""
	Size:float
	"""Read Write Property: Size (not related to scaling)."""
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of root."""
		...
class FBModelSkeleton(FBModel):
	"""Root object class."""
	Color:FBColor
	"""Read Write Property: Color of skeleton node."""
	Length:float
	"""Read Write Property: Length of skeleton node. (Note: Only effective when the look is set to: Capsule)"""
	LinkFollowGeometryOffset:bool
	"""Read Write Property: Whether link to parent node must follow skeleton node or not, when skeleton node has a geometry offset."""
	Look:FBSkeletonLook
	"""Read Write Property: Look of skeleton node."""
	PreserveLinkEndPosition:bool
	"""Read Write Property: Whether skeleton node must preserve its links' end position to children nodes, when skeleton node has a geometry offset. (Note: Only effective when the look is set to: Bone, Box or Stick)"""
	Resolution:FBSkeletonResolutionLevel
	"""Read Write Property: Resolution of skeleton node. (Note: Only effective when the look is set to: Sphere, Capsule or Stick)"""
	Size:float
	"""Read Write Property: Size (not related to scaling)."""
	def GetSkinModelList(self,SkinModelList:FBModelList,/)->None:
		"""Return the list of skin model associated with this Skeleton(Bone), which could be the deformable skins connected via cluster, or non deformable skins which are parented directly under this bone.

		### Parameters:
			- SkinModelList: List to be appended with skin models (with no duplicated items)."""
		...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of skeleton."""
		...
class FBPhysicalProperties(FBBox):
	"""Base class for physical properties attach to a model.

	[See sample: RigiBody.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_rigi_body_8py-example.html)"""
	def __init__(self,Name:str|None=None,/):...
class FBAudioIn(FBComponent):
	"""Audio In class.

	Used to control Audio In objects (like a Microphone Audio Device).

	```python
	# This example shows how to prepare an FBAudioIn object for recording
	# by redirecting the audio to an FBAudioOut object and
	# by specifying a desired audio format and target audio file

	from pyfbsdk import *

	# Let's see how many FBAudioIn objects are available
	lAudioIns = FBSystem().AudioInputs
	print("The number of Audio Inputs:", len( lAudioIns ))
	if len( lAudioIns ) > 0:
		# Work with the first Audio In object available
		lAudioIn = lAudioIns[0]
		print("Audio Input Name:", lAudioIn.Name)
		# Let's turn it offline, if not already
	 if lAudioIn.IsOnline():
			print("Turned offline successful?", lAudioIn.SetOnline( False ))
		# Let's set the first AudioOut available as the Audio In destination
		# if any destination is set yet
		# (Windows Only)
	 if lAudioIn.GetDestination() == None:
			lAudioOuts = FBSystem().AudioOutputs
			print("The number of Audio Outputs:", len( lAudioOuts ))
	 if len( lAudioOuts ) > 0:
				# Work with the first Audio Out object available
				lAudioOut = lAudioOuts[0]
				print("Audio Output Name:", lAudioOut.Name)
				print("Setting destination successful?", lAudioIn.SetDestination( lAudioOut ))
	 else:
				print("No available Audio Out object available for destination")
	 else:
			print("Audio Output <", lAudioIn.GetDestination().Name, "> already set for destination")
		# Let's try to record an audio file in 8-bit, 22060 hz and in stereo
		# Make sure this Audio In object supports this format
		lSupportedFormats = lAudioIn.GetSupportedFormats()
	 if lSupportedFormats & FBAudioFmt_ConvertBitDepthMode( FBAudioBitDepthMode.kFBAudioBitDepthMode_8 ) != 0 and \\
		   lSupportedFormats & FBAudioFmt_ConvertRateMode( FBAudioRateMode.kFBAudioRateMode_22050 ) != 0 and \\
		   lSupportedFormats & FBAudioFmt_ConvertChannelMode( FBAudioChannelMode.kFBAudioChannelModeStereo ) != 0:

			# This format is supported, let's set it now
			lNewFormat  = FBAudioFmt_ConvertBitDepthMode( FBAudioBitDepthMode.kFBAudioBitDepthMode_8 )
			lNewFormat |= FBAudioFmt_ConvertRateMode( FBAudioRateMode.kFBAudioRateMode_22050 )
			lNewFormat |= FBAudioFmt_ConvertChannelMode( FBAudioChannelMode.kFBAudioChannelModeStereo )
			print("Setting recording format successful?", lAudioIn.SetRecordingFormat( lNewFormat ))
	 # Let's add a delay of 3 frames
			# (Windows only)
			print("Setting delay successful?", lAudioIn.SetDelay( FBTime( 0, 0, 0, 3 ) ))
			# Let's turn it online now
			print("Turned online successful?", lAudioIn.SetOnline( True ))
			# Now, prepare the Audio In object for recording
			# To turn it off first, if already in "Record" state
	 if lAudioIn.IsReadyToRecord():
				print("Turned Off Recording?", lAudioIn.TurnOffRecording())
			lAudioFilePath = "C:\\\\temp\\\\myRecordedAudioFile.wav"

			# Note: To remove pop-ups that may occurs, if required,
			# look at the optional parameters of the PrepareToRecord method
			print("Preparing to record successful?", lAudioIn.PrepareToRecord( lAudioFilePath ))
	 if lAudioIn.IsReadyToRecord():
				print("You are now ready to start recording and playback!")
	 else:
				print("Something failed while preparing to record! Tip: Do you have a C:\\temp folder?")
	 else:
			print("This format (8-bit, 22060 hz, stereo) is not supported!")
	else:
		print("No available Audio In object available")
	```"""
	def GetDelay(self)->FBTime:
		"""Returns the delay currently set.

		(Windows only).
		### Returns:
		The delay currently set."""
		...
	def GetDestination(self)->FBAudioOut:
		"""Returns the Audio Out object currently used as the destination.

		(Windows only).
		### Returns:
		The Audio Out object currently used as the destination. Returns a NULL pointer (None in Python) if any Audio Out object is currently set."""
		...
	def GetRecordingFormat(self)->int:
		"""Returns the recording format (i.e.

		Bit Depth, Rate and Channel(s)) currently set.
		### Returns:
		The audio format currently set for recording."""
		...
	def GetSupportedFormats(self)->int:
		"""Returns all the Audio In supported formats (i.e.

		Bit Depths, Rates and Channels).
		### Returns:
		The Audio In supported formats."""
		...
	def IsOnline(self)->bool:
		"""Is the Audio In online?

		### Returns:
		True if the Audio In is online, false if it is offline."""
		...
	def IsReadyToRecord(self)->bool:
		"""Is the Audio In ready to record (has it been prepared properly)?

		### Returns:
		True if the audio is ready to record, false otherwise."""
		...
	def PrepareToRecord(self,RecordingPath:str,ExistingClipAction:FBExistingClipAction=FBExistingClipAction.kFBExistingClipAskUser,ExistingFileAction:FBExistingFileAction=FBExistingFileAction.kFBExistingFileAskUser,/)->bool:
		"""Prepares the Audio In for recording (similar as checking the "Record" checkbox in the UI).

		If the Audio In is not already online, it will turn it online automatically. If the Audio In is already ready to record, it will turn it off first automatically.
		### Parameters:
			- RecordingPath: The file path for the desired output wav file. The file must have the .wav extension.
			- ExistingClipAction: The action to perform when the action clip associated to the recording path is already in the scene.
			- ExistingFileAction: The action to perform when the file associated to the recording path already exists on disk and it not empty.

		### Returns:
		True if operation is successful, false otherwise. It could fail for different reasons (e.g. the specified file is not a WAV file or is invalid, the operation is abort by the user, etc.)."""
		...
	def SetDelay(self,Delay:FBTime,/)->bool:
		"""Sets the delay to use.

		The Audio In must be offline when this method is called. (Windows only).
		### Parameters:
			- Delay: The delay to use. To mimic the UI, the [FBTime](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_time.html "Time data structure.") should refer to a frame number.

		### Returns:
		True if operation is successful, false otherwise."""
		...
	def SetDestination(self,AudioOut:FBAudioOut,/)->bool:
		"""Sets the Audio Out object to be used as the destination.

		The Audio In must be offline when this method is called. (Windows only).
		### Parameters:
			- AudioOut: The Audio Out object to be used as the destination. Use a NULL pointer (None in Python) to unset the destination.

		### Returns:
		True if operation is successful, false otherwise."""
		...
	def SetOnline(self,Online:bool,/)->bool:
		"""Turns Audio In online or offline.

		### Parameters:
			- Online: True to turn the Audio In online, false to turn it offline.

		### Returns:
		True if operation is successful, false otherwise."""
		...
	def SetRecordingFormat(self,AudioFormat:int,/)->bool:
		"""Sets the recording format (i.e.

		Bit Depth, Rate and Channel(s)) to use. The Audio In must be offline when this method is called.
		### Parameters:
			- AudioFormat: The audio format to use for recording. It must specify a unique Bit Depth, Rate and Channels.

		### Returns:
		True if operation is successful, false otherwise. It could fail for different reasons (e.g. the specified audio format is not supported, more than one Bit Depth is specified, etc.)."""
		...
	def TurnOffRecording(self)->bool:
		"""Turns off the Audio In recording (similar as un-checking the "Record" checkbox in the UI).

		### Returns:
		True if operation is successful, false otherwise."""
		...
	def __init__(self):...
class FBAudioClip(FBComponent):
	"""Used to play audio clips and access their properties.

	This class permits you to access audio clip's properties to read or change them.

	[See sample: AudioTrackSetupTool.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_complex_tools_0c_audio_track_setup_tool_8py-example.html)"""
	AccessMode:FBAccessMode
	"""Read Write Property: Specify the media data access mode between disk or memory."""
	Bits:int
	"""Read Only Property: the bits of media."""
	Channels:int
	"""Read Only Property: the number of channels in use."""
	ClipSpeed:float
	"""Read Write Property: The speed of the media when being played."""
	ConstrainDstToTake:bool
	"""Read Write Property: Indicates whether to constrain the EndPoint to the end of the take."""
	CurrentTake:FBTake
	"""Read Write Property: The take this media belongs to."""
	Destination:FBAudioOut
	"""Read Write Property: The audio output destination where the clip will be played."""
	DstDuration:FBTime
	"""Read Write Property: When not used in the Story, this specify when the clips stops playing."""
	DstEnd:FBTime
	"""Read Write Property: Total duration of this audio clip."""
	DstIn:FBTime
	"""Read Write Property: When not used in the Story, this specify when the clips begin to play."""
	Duration:FBTime
	"""[Deprecated]Read Write Property: Refer to DstDuration."""
	EndPoint:FBTime
	"""[Deprecated]Read Write Property: Refer to DstEnd."""
	Filename:str
	"""[Deprecated]Read Only Property: Refer to Path"""
	Format:int
	"""Read Only Property: Data format of media, including rate, bits and channels count. You can typecast it to a FBAudioFmt."""
	InPoint:FBTime
	"""[Deprecated]Read Write Property: Refer to DstIn."""
	LockClipSpeed:bool
	"""Read Write Property: Indicates whether to lock the current playing speed."""
	LockPitchToSpeed:bool
	"""Read Write Property: Time stretch enabled factor."""
	Path:str
	"""Read Only Property: Full Path of the media."""
	Pitch:float
	"""Read Write Property: The audio clip pitch value. To write to this property, you must first set LockPitchToSpeed property to false."""
	Rate:int
	"""Read Only Property: the rate of media."""
	RelativePath:str
	"""Read Only Property: Relative path of media."""
	Scrubbing:bool
	"""Read Write Property: Control which clip (one at a time) can shuttle when playing a various speeds."""
	SrcDuration:FBTime
	"""Read Only Property: The duration time of media."""
	SrcEnd:FBTime
	"""Read Only Property: The end time of media."""
	SrcIn:FBTime
	"""Read Only Property: The begin time of media."""
	TakeSetsInPoint:bool
	"""[Deprecated]Read Write Property: Indicates whether to lock the InPoint to the start of the take."""
	UseChannel:FBUseChnMode
	"""Read Write Property: Enables you to control which track are used with stereo clips."""
	UseChannelMode:FBUseChnMode
	"""[Deprecated]Read Write Property: Enables you to control which track are used with stereo clips."""
	def IsMediaReady(self)->bool:
		"""Check if the audio clip constructed properly.

		### Returns:
		true if the audio clip was constructed properly."""
		...
	def Play(self,Style:FBTriggerStyle=FBTriggerStyle.kFBTriggerStyleContinue,Destination:FBAudioOut|None=None,/)->bool:
		"""Play audio clip now.

		### Parameters:
			- Style: How the audio clip should be triggered.
			- Destination: Where the audio clip should be played. If NULL, it will play on the default destination.

		### Returns:
		Return true if the buffer for the audio clip was successfully allocated so that you can hear the sound."""
		...
	def Stop(self,Destination:FBAudioOut|None=None,/)->None:
		"""Stop any playing triggered audio clip on a specified destination.

		### Parameters:
			- Destination: Where the audio clip is playing. If NULL, the default destination will be used."""
		...
	def __init__(self,FileName:str,/):
		"""### Parameters:
			- FileName: The complete file path of the media file to access.
			- SetToDefaultDest: If true and the media file open successfully, it will automatically be connected to an output device."""
		...
class FBAssetMng(FBComponent):
	"""Used to access asset manager functionity to get files locally or from a server."""
	Description:str
	"""Read Write Property: Description of the manager."""
	LastError:str
	"""Last error string."""
	MenuFlags:int
	"""Read Write Property: Flags specifing which menu items are added by the manager."""
	def BrowseForFile(self)->FBAssetFile:
		"""Let the user browse the asset database to select a file.

		### Returns:
		A file object representing the file that was selected, or NULL if none."""
		...
	def BrowseForFolder(self)->FBAssetFolder:
		"""Let the user browse the asset database to select a folder.

		### Returns:
		A FBAssetFolder* object representing the folder that was selected, or NULL if none."""
		...
	def CheckAvailability(self)->bool:
		"""Check if this manager can be used on the computer."""
		...
	def CreateServerPath(self,ServerPath:str,/)->FBAssetFolder:
		"""Create a folder path on the server side by adding each missing folders.

		### Parameters:
			- ServerPath: The path to create on the server side.

		### Returns:
		A FBAssetFolder* object representing the deepest folder of the path."""
		...
	def FileIsManaged(self,Filename:str,/)->bool:
		"""Is the specified local file managed (ie.

		also present in the database).
		### Parameters:
			- Filename: Path to the file on the local disk.

		### Returns:
		A boolean indicating if the file is managed or not."""
		...
	def GetAssetFile(self,ServerFilename:str,/)->FBAssetFile:
		"""Get a file object using it's server path.

		### Parameters:
			- ServerFilename: Path to the file on the server.

		### Returns:
		An FBAssetFile* object, or NULL if the file was not found."""
		...
	def GetAssetFileFromLocalPath(self,LocalFilename:str,/)->FBAssetFile:
		"""Get a file object using it's local path.

		### Parameters:
			- LocalFilename: Path to the file on the local disk.

		### Returns:
		An FBAssetFile* object, or NULL if the file was not found or no mapping could be done."""
		...
	def GetAssetFolder(self,ServerPath:str,/)->FBAssetFolder:
		"""Get a folder object using it's server path.

		### Parameters:
			- ServerPath: Path the the folder on the server.

		### Returns:
		An FBAssetFolder* object, or NULL if the folder was not found."""
		...
	def GetAssetFolderFromLocalPath(self,LocalPath:str,/)->FBAssetFolder:
		"""Get a folder object using it's local path.

		### Parameters:
			- LocalPath: Path to the folder on the local disk.

		### Returns:
		An FBAssetFolder* object, or NULL if the folder was not found or no mapping could be done."""
		...
	def GetFileOptions(self)->int:
		"""Get the file options (i.e.

		what to do when loading, saving or closing managed files).
		### Returns:
		The options."""
		...
	def Initialize(self)->bool:
		"""Initialize the connection to the server.

		### Returns:
		True if the connection was established, false otherwise."""
		...
	def MapLocalPathToServerPath(self,LocalPath:str,/)->str:
		"""Convert the local path to a server path by using managed paths mapping.

		### Parameters:
			- LocalPath: Local path to be mapped.

		### Returns:
		A string with the resulting server path, will be empty if the mapping fail."""
		...
	def ShowSettings(self)->None:
		"""Display a dialog that let the user changes settings."""
		...
	def WithinManagedPath(self,LocalPath:str,/)->bool:
		"""Is the specified local path below a managed path.

		### Parameters:
			- LocalPath: Local path to be checked.

		### Returns:
		A boolean indicating if the path is within a managed path or not."""
		...
class FBAssetItem(FBComponent):
	"""Base class for all managed assets."""
	LastError:str
	"""Last error string."""
	def CheckIn(self,Comment:str="",KeepCheckedOut:bool=False,Silent:bool=False,/)->bool:
		"""Checks in this item and all its children (if this is a folder item).

		### Parameters:
			- Comment: Comment to be applied for the check in.
			- KeepCheckedOut: Flag that indicates whether the item will be kept checked out.
			- Silent: If pSilent is set to true, no dialog will be displayed by this method.

		### Returns:
		A boolean indicating if the operation was successful."""
		...
	def CheckOut(self,Comment:str="",DontGetLocal:bool=False,Silent:bool=False,/)->bool:
		"""Checks out this item and it's childs (if this is a folder item) and makes them writeable on the local disk.

		### Parameters:
			- Comment: Comment to be applied for the check out.
			- DontGetLocal: Indicate if local copy should retrieved or not.
			- Silent: If pSilent is set to true, no dialog will be displayed by this method.

		### Returns:
		A boolean indicating if the operation was successful."""
		...
	def GetLatest(self,ReplaceCheckedOut:bool=False,Silent:bool=False,/)->bool:
		"""Obtain the latest version of the item from the server.

		### Parameters:
			- ReplaceCheckedOut: Whether to replace the checked out file or not.
			- Silent: If pSilent is set to true, no dialog will be displayed by this method.

		### Returns:
		A boolean indicating if the operation was successful."""
		...
	def GetLocalPath(self)->str:
		"""Get the path to this item on the local hard disk.

		### Returns:
		The path as an FBString."""
		...
	def GetName(self)->str:
		"""Get the name of this item (file name or folder name).

		### Returns:
		The name of the item, as an FBString."""
		...
	def GetParent(self)->FBAssetFolder:
		"""Get the parent folder of this item.

		### Returns:
		An FBAssetFolder* if the parent was found, or NULL if this is the root item."""
		...
	def GetServerPath(self)->str:
		"""Get the path to this item on the database.

		### Returns:
		The server path as an FBString."""
		...
	def ShowHistory(self)->None:
		"""Display a dialog with this item history."""
		...
	def ShowProperties(self)->None:
		"""Display a dialog showing the properties of this item."""
		...
	def UndoCheckOut(self,ReplaceLocalFile:bool=True,Silent:bool=False,/)->bool:
		"""Cancel the last check out operation.

		### Parameters:
			- ReplaceLocalFile: Flag indicating if the local item(s) should be replaced by the server version.
			- Silent: If pSilent is set to true, no dialog will be displayed by this method.

		### Returns:
		A boolean indicating if the operation was successful."""
		...
class FBApplication(FBComponent):
	"""[FBApplication](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_application.html "FBApplication is used mainly to manage files.") is used mainly to manage files.

	It provides functionality like that in the MotionBuilder file menu, for example, open file, save file.Note that event registration is instanced-based. When an [FBApplication](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_application.html "FBApplication is used mainly to manage files.") object is destroyed, all the event callbacks are unregistered. If you want to have a tool to be notified of events, it needs to have a [FBApplication](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_application.html "FBApplication is used mainly to manage files.") data member.

	[See samples: FBFbxOptions.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_f_b_fbx_options_8py-example.html) [FBSystemEvents.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_f_b_system_events_8py-example.html) [ImportWithNamespace.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_import_with_namespace_8py-example.html) [BatchExportCharacterAnimationTool.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_batch_export_character_animation_tool_8py-example.html) [ExportAnimationLibrary.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_export_animation_library_8py-example.html) [SaveOneTakePerFile.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_save_one_take_per_file_8py-example.html)"""
	CurrentActor:FBActor
	"""Read Write Property: Indicate the current actor, as used by the character tool. Can be NULL. If not null, CurrentCharacter must be null, as the character tool works on only one item at a time."""
	CurrentCharacter:FBCharacter
	"""Read Write Property: Indicate the current character, as used by the character tool. Can be NULL. If not null, CurrentActor must be null, as the character tool works on only one item at a time. [See sample: CurrentCharacterGoToStancePose.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_current_character_go_to_stance_pose_8py-example.html)"""
	FBXFileName:str
	"""Read Write Property: Current scene filename."""
	OnFileExit:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: A File Exit as been requested, nothing has been destroyed yet."""
	OnFileMerge:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: A File Merge has been requested, nothing has been loaded yet."""
	OnFileNew:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: A File New has been requested, nothing has been destroyed yet."""
	OnFileNewCompleted:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: A File New has been completed."""
	OnFileOpen:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: A File Open has been requested, nothing has been loaded yet."""
	OnFileOpenCompleted:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: A File Open has been completed."""
	OnFileSave:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: A File Save has been requested, nothing has been saved yet."""
	OnFileSaveCompleted:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: A File Save has been completed."""
	OnOverrideFileOpen:callbackframework.FBEventSource[Self, FBEventOverrideFileOpen]
	"""Event: Called when a file is about to be opened/merged. The user can override the process with his own file import system."""
	def AudioRender(self,AudioRenderOptions:FBAudioRenderOptions|None=None,/)->bool:
		"""Render audio of current scene to media file, currently WAV file only.

		### Parameters:
			- AudioRenderOptions: The options used when rendering audio of the scene. Default value: 2 channels, 16 bits, 44100 hz, the begin and end time span for current time referential, Default file name is "Output.wav" in the last audio output path, ro the default document path if the last path doesn't exist.

		### Returns:
		True if the file was rendered successfully
		### Warning:
		If the destination media file exist, it will be overwritten by default. If the destination media file is opened by other application, the audio render process may not success because of not able to open it."""
		...
	def ExecuteScript(self,Filename:str,/)->bool:
		"""Execute a python script file.

		### Parameters:
			- Filename: The script file to execute.

		### Returns:
		True if the script file was found and executed.
		### Remarks:
		This function can only be used in the UI thread."""
		...
	def FileAppend(self,Filename:str,ShowUIMsg:bool=False,Options:FBFbxOptions|None=None,/)->bool:
		"""Append one or multiple files to the current scene.

		Same as File->Merge in the menus with all options set to append. In earlier versions of MotionBuilder, a namespace could be specified with a parameter in this function, or FBFbxOptions::CustomImportNamespace, Now this is now done with [FBFbxOptions::NamespaceList](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_fbx_options.html#a0a39e5fc1811f92fa35ed80c332bb75f "Read Write Property: A list of namespaces separated by '~'. On Load, duplicate the loaded objects int...").
		### Parameters:
			- Filename: File(s) to merge. For multiple files, use a list of files separated by '~'.
			- ShowUIMsg: Set false if don't want to popup any UI dialog or messages (default=false).
			- Options: Provide finer control on file open options (default=NULL). if not null, Option dialog will only show if both option's ShowOptionsDialog property and pShowUIMsg are true. It is possible to append multiple scenes, each one within its own user specified namespace, by calling the [FBFbxOptions::SetMultiLoadNamespaceList](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_fbx_options.html#a3d8bb25ae4070d38ebaf3b96937dc9e2 "Sets the list of namespaces that will be used when merging multiple scenes (see FBApplication::FileMe...") method first. When doing so though, the FBFbxOption.NamespaceList property is then ignored.

		### Returns:
		true if successful."""
		...
	def FileBatch(self,BatchOptions:FBBatchOptions,PlotOptions:FBPlotOptions|None=None,/)->FBBatchStatus:
		"""Start a batch.

		Command File->Batch... in the menus.
		### Parameters:
			- BatchOptions: The options for the batch process (same as in the batch UI).
			- PlotOptions: The options for plotting (same as in the plot UI)(default=NULL).

		### Returns:
		The status of the operation."""
		...
	def FileExit(self,Save:bool=False,ExitCode:int=0,/)->None:
		"""Quit application.

		Command File->Exit in the menus.
		### Parameters:
			- Save: true if file is saved on exit(default=false).
			- ExitCode: Exit code of the application(default=0)."""
		...
	def FileExport(self,Filename:str,/)->bool:
		"""Export a motion file.

		Command File->Motion File Export... in the menus.
		### Parameters:
			- Filename: The file to create. To create two files at the same time (ex: .amc & .asf), separate the two files path with a comma ("Path1,Path2").

		### Returns:
		True if the export succeeded.
		### Remarks:
		If the file exists, it will be overwritten.

		current take is use.

		The last parameter is only used for motion files.

		For now, you cannot export custom file types.

		Currently, only the default export options are used.
		### Warning:
		The signature of this function might change in the future to support export options."""
		...
	def FileExportBatch(self,Name:str,Take:FBTake,BatchOptions:FBBatchOptions,ExportModels:FBModelList,/)->bool:
		"""Export a motion file using batch options.

		Export used for saving files in batch process.
		### Parameters:
			- Name: The name of the file without extension. Extension and path will be taken from batch options.
			- Take: Animation take to the export.
			- BatchOptions: The options for the export.
			- ExportModels: Models to the export.

		### Returns:
		True if the export succeeded.
		### Remarks:
		Not all options have to be set, only those that belong to process."""
		...
	def FileImport(self,Filename:str,MatchModels:bool=False,CreateUnmatchedModels:bool=True,/)->bool:
		"""Import a motion file.

		Command File->Motion File Import... in the menus.
		### Parameters:
			- Filename: The file to import. To import two files at the same time (ex: .amc & .asf), separate the two files path with a comma ("Path1,Path2").
			- MatchModels: If there is already a model in the scene with the same name, the model will not be created and we replace the animation of the given model.
			- CreateUnmatchedModels: Whether unmatched models will be created. This flag matters only when pMatchModels is true. when pMatchModels is false, all the models are created.

		### Returns:
		True if the import succeeded.
		### Remarks:
		No models selected, all the models in the scene will be checked for a potential name match.

		If there are models selected in the scene, only these models will be checked for a potential name match.

		If only one model is selected (ex: hips), this models and its hierarchy will be used.

		The data will be imported in the current take.

		The last two parameter are only used for motion files.

		For now, you cannot import custom file types.

		Currently, only the default import options are used.
		### Warning:
		The signature of this function might change in the future to support import options."""
		...
	def FileImportBatch(self,Name:str,BatchOptions:FBBatchOptions,Reference:FBModel,/)->bool:
		"""Import a motion file using batch options.

		Import used for loading files in batch process.
		### Parameters:
			- Name: The name of the file without extension. Extension and path will be taken from batch options.
			- BatchOptions: The options for the import.
			- Reference: Reference model for the import.

		### Returns:
		True if the import succeeded.
		### Remarks:
		Not all options have to be set, only those that belong to process."""
		...
	def FileImportWithOptions(self,Options:FBMotionFileOptions,/)->bool:
		"""Import a motion file with the ability to specify options.

		Command File->Motion File Import... in the menus.
		### Parameters:
			- Options: A [FBMotionFileOptions](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_motion_file_options.html "Customize motion file loading.") object that contains the path to the files, as well as the options to load those motion files.

		### Returns:
		True if the import succeeded.
		### Remarks:
		The import will only work if you open files of the same type.

		For now, you cannot import custom file types.

		Not all options can be applied to a particular motion file type, please use the Motion File Import UI as a reference."""
		...
	@overload
	def FileMerge(self,Filename:str,ShowUIMsg:bool=False,Options:FBFbxOptions|None=None,/)->bool:
		"""Merge one or multiple files with the current scene.

		Command File->Merge in the menus.
		### Parameters:
			- Filename: File(s) to merge. For multiple files, use a list of files separated by '~'.
			- ShowUIMsg: Set false if don't want to popup any UI dialog or messages (default=false).
			- Options: Provide finer control on file open options (default=NULL). if not null, Option dialog will only show if both option's ShowOptionsDialog property and pShowUIMsg are true. It is possible to merge multiple scenes, each one within its own user specified namespace, by calling the [FBFbxOptions::SetMultiLoadNamespaceList](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_fbx_options.html#a3d8bb25ae4070d38ebaf3b96937dc9e2 "Sets the list of namespaces that will be used when merging multiple scenes (see FBApplication::FileMe...") method first. When doing so though, the FBFbxOption.NamespaceList property is then ignored.

		### Returns:
		true if successful."""
		...
	@overload
	def FileMerge(self,Pathlist:FBStringList,ShowUIMsg:bool=False,Options:FBFbxOptions|None=None,/)->bool:
		"""Merge multiple files with the current scene.

		Command File->Merge in the menus.
		### Parameters:
			- Pathlist: Files to merge.
			- ShowUIMsg: Set false if don't want to popup any UI dialog or messages (default=false).
			- Options: Provide finer control on file open options (default=NULL). if not null, Option dialog will only show if both option's ShowOptionsDialog property and pShowUIMsg are true. It is possible to merge multiple scenes, each one within its own user specified namespace, by calling the [FBFbxOptions::SetMultiLoadNamespaceList](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_fbx_options.html#a3d8bb25ae4070d38ebaf3b96937dc9e2 "Sets the list of namespaces that will be used when merging multiple scenes (see FBApplication::FileMe...") method first. When doing so though, the FBFbxOption.NamespaceList property is then ignored.

		### Returns:
		true if successful."""
		...
	def FileNew(self,AskUser:bool=False,ClearSceneName:bool=True,/)->bool:
		"""Command File->New in the menus.

		### Parameters:
			- AskUser: Set to true to cause a save dialog to popup. Default is false.
			- ClearSceneName: Set to true to clear the scene name, set to false to retain it. Default is true.

		### Returns:
		true if successful."""
		...
	@overload
	def FileOpen(self,Filename:str,ShowUIMsg:bool=False,Options:FBFbxOptions|None=None,/)->bool:
		"""Open a file, replacing the current scene.

		Command File->Open in the menus.
		### Parameters:
			- Filename: File to open.
			- ShowUIMsg: Set false if don't want to popup any UI dialog or messages (default=false).
			- Options: Provide finer control on file open options (default=NULL). if not null, Option dialog will only show if both option's ShowOptionsDialog property and pShowUIMsg are true.

		### Returns:
		true if file open successfully.
		[See samples: BatchExportCharacterAnimationTool.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_batch_export_character_animation_tool_8py-example.html) [RenameFirstTakeOnMultipleFiles.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_rename_first_take_on_multiple_files_8py-example.html)"""
		...
	@overload
	def FileOpen(self,Buffer,BufferLength:int,/)->bool:
		"""Open a file from memory.

		### Parameters:
			- Buffer: the memory buffer for the file. Raw memory address is expected in pyfbsdk.
			- BufferLength: the memory buffer size.

		### Returns:
		true if file opened successfully.
		### Warning:
		this is advanced & not supported function, use with caution."""
		...
	def FileRender(self,RenderOptions:FBVideoGrabOptions|None=None,/)->bool:
		"""Render current scene to media file.

		Command File->Render in the menus.
		### Parameters:
			- RenderOptions: The options used when rendering the scene. If you don't specify them, current one are used.

		### Returns:
		True if the file was rendered successfully otherwise False and [FBVideoGrabber.GetLastErrorMsg()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_video_grabber.html#af2af6435ec300fc0b187059a5d762b9c "GetLastErrorMsg.") contains the description of the error.
		### Remarks:
		Render options can be changed if they are not valid.
		### Warning:
		If the destination media file exist, it will be overwritten by default."""
		...
	def FileSave(self,Filename:str|None=None,Options:FBFbxOptions|None=None,/)->bool:
		"""Save the file under another name.

		Command File->SaveAs in the menus.
		### Parameters:
			- Filename: Save file as pFilename. A value of NULL will use the current file name.
			- Options: Provide finer control on file save options (default=NULL)

		### Returns:
		true if successful.
		[See sample: SaveSelected.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_save_selected_8py-example.html)"""
		...
	def FlushEventQueue(self)->None:
		"""Flush event queue.

		Processes all pending events for the calling thread until there are no more events to process. You can call this function occasionally when your code is busy performing a long operation (e.g. copying a file)."""
		...
	def GetMaxFrameCount(self,arg2,arg3:int,arg4,/)->bool:
		"""Get max frame count from a scene file in memory.

		### Parameters:
			- Buffer: the memory buffer for the file. Raw memory address is expected in pyfbsdk.
			- BufferLength: the memory buffer size.
			- FrameCount: out parameter to hold max frame count. this parameter is not needed in pyfbsdk.
			- TimeScale: Time scale.

		### Returns:
		true if file opened successfully. In pyfbsdk, a tuple (bool, kLong) will return instead, the first one is ORSDK function return value, the second is for max frame count.
		### Warning:
		this is advanced & not supported function, use with caution."""
		...
	def GetSceneAuthor(self)->str:
		"""Return the scene author from the scene properties."""
		...
	def GetSceneComment(self)->str:
		"""Return the scene comment from the scene properties."""
		...
	def GetSceneKeywords(self)->str:
		"""Return the scene keywords from the scene properties."""
		...
	def GetSceneRevisionNumber(self)->str:
		"""Return the scene revision number from the scene properties."""
		...
	def GetSceneSubject(self)->str:
		"""Return the scene subject from the scene properties."""
		...
	def GetSceneTitle(self)->str:
		"""Return the scene title from the scene properties."""
		...
	def IsSceneModified(self)->bool:
		"""Is the scene modified since last save / new scene creation?

		### Returns:
		True if the scene is modified since last save / new scene creation, false otherwise."""
		...
	def IsValidBatchFile(self,Filename:str,/)->bool:
		"""Verify motion file readability.

		### Parameters:
			- Filename: The file to test.

		### Returns:
		True if file was opened successfully (file is closed at the end)."""
		...
	def LoadAnimationOnCharacter(self,FileName:str,Character:FBCharacter,FbxOptions:FBFbxOptions,PlotOptions:FBPlotOptions,/)->bool:
		"""Load a rig and its animation from a file.

		### Parameters:
			- FileName: File name.
			- Character: Target character.
			- FbxOptions: The options for the character rig and animation load
			- PlotOptions: If the animation should be plotted on the target rig, these plot options will be used. Set to NULL if animation will not be plotted.

		### Returns:
		true if successful."""
		...
	def Maximize(self)->bool:
		"""Maximize window (minimized).

		### Returns:
		Operation was successful (true or false)."""
		...
	def Minimize(self,Blocking:bool=True,/)->bool:
		"""Minimize window.

		### Parameters:
			- Blocking: Is the minimization blocking operation (default = true).

		### Returns:
		Operation was successful (true or false)."""
		...
	def OneClickAddToCurrentScene(self)->bool:
		"""Send the scene and add it to the current scene in the specified application.

		### Returns:
		True if transfer successful."""
		...
	def OneClickIsConnectedTo(self)->FBOneClickApplication:
		"""Return the other application that MotionBuilder is connected to.

		### Returns:
		The application that MotionBuilder is connected to."""
		...
	def OneClickSelectPreviouslySentObject(self)->None:
		"""Select, in MotionBuilder, the object that were sent."""
		...
	def OneClickSendAsNewScene(self,Application:FBOneClickApplication,/)->bool:
		"""Send the current scene as a new scene in the specified application.

		### Parameters:
			- Application: The application that will receive the scene.

		### Returns:
		True if transfer successful."""
		...
	def OneClickUpdateCurrentScene(self)->bool:
		"""Send the scene to update the current scene in the specified application.

		### Returns:
		True if transfer successful."""
		...
	def SaveCharacterRigAndAnimation(self,FileName:str,Character:FBCharacter,FbxOptions:FBFbxOptions,/)->bool:
		"""Save the rig and its animation in a file.

		### Parameters:
			- FileName: File name.
			- Character: Character to save.
			- FbxOptions: The options for the character rig and animation export

		### Warning:
		After save, the current scene selection will be reset."""
		...
	def SetSceneAuthor(self,Author:str,/)->None:
		"""Set the scene author.

		### Parameters:
			- Author: The author to set in the scene properties."""
		...
	def SetSceneComment(self,Comment:str,/)->None:
		"""Set the scene comment.

		### Parameters:
			- Comment: The comment to set in the scene properties."""
		...
	def SetSceneKeywords(self,Keywords:str,/)->None:
		"""Set the scene keywords.

		### Parameters:
			- Keywords: The keywords to set in the scene properties."""
		...
	def SetSceneRevisionNumber(self,RevNumber:str,/)->None:
		"""Set the scene revision number.

		### Parameters:
			- RevNumber: The revision number to set in the scene properties."""
		...
	def SetSceneSubject(self,Subject:str,/)->None:
		"""Set the scene subject.

		### Parameters:
			- Subject: The subject to set in the scene properties."""
		...
	def SetSceneTitle(self,Title:str,/)->None:
		"""Set the scene title.

		### Parameters:
			- Title: The title to set in the scene properties."""
		...
	def UpdateAllWidgets(self)->None:
		"""Request to refresh display of all UI widgets."""
		...
	def __init__(self):...
class FBAssetFile(FBAssetItem):
	"""Class representing a file stored in a version control database."""
	def GetCheckedOutBy(self)->str:
		"""Returns the name of the user who currently has this file checked out.

		### Returns:
		The user name if the file is checked out, or an empty string if it is not."""
		...
	def IsCheckedOut(self)->bool:
		"""Returns a boolean value indicating if this file is checked out by any user.

		### Returns:
		A boolean value indicating if this node is checked out."""
		...
	def IsCheckedOutByMe(self)->bool:
		"""Returns a boolean value indicating if this file is checked out by the current user.

		### Returns:
		A boolean value indicating if this node is checked out by the current user."""
		...
class FBAssetFolder(FBAssetItem):
	"""Class representing a folder stored in a version control database."""
	def AddFile(self,LocalPath:str,Comment:str,CheckOut:bool,Silent:bool,/)->FBAssetFile:
		"""Add a specified file into the database.

		It will be added in this folder.
		### Parameters:
			- LocalPath: The full path to the file on the local disk.
			- Comment: Comment to be applied for the operation.
			- CheckOut: Whether the file should be checked out or not.
			- Silent: If pSilent is set to true, no dialog will be displayed by this method.

		### Returns:
		An FBAssetfile* object representing the newly added file."""
		...
	def AddFolder(self,Name:str,Comment:str,Silent:bool,/)->FBAssetFolder:
		"""Add a folder in the database.

		It will be added in this folder.
		### Parameters:
			- Name: Name of the folder to be created.
			- Comment: Comment to be applied for the operation.
			- Silent: If pSilent is set to true, no dialog will be displayed by this method.

		### Returns:
		An FBAssetFolder* object representing the newly added folder."""
		...
	def GetChild(self,Index:int,/)->FBAssetItem:
		"""Get the child at index pIndex.

		### Returns:
		The child at pIndex, or NULL if the index was out of range."""
		...
	def GetChildCount(self)->int:
		"""Get the number of items in this folder.

		### Returns:
		The number of items in this folder."""
		...
	def GetFile(self,Name:str,/)->FBAssetFile:
		"""Get a file present in this folder by using it's name.

		### Returns:
		The file with the given name, or NULL if it was not found."""
		...
	def GetFolder(self,Name:str,/)->FBAssetFolder:
		"""Get a folder present in this folder by using it's name.

		### Returns:
		The folder with the given name, or NULL if it was not found."""
		...
class FBAnimationLayer(FBComponent):
	"""Used to access animation layer properties and modify them.

	Changing the various properties of the layers will modify how the animation will be interpreted. For example, muting a layer will mute all the animation contained on the layer. You can access the animation layer object from the take, usign the [FBTake::GetLayer()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_take.html#aebf48efc66cb6d7c90d4ed8786360003 "Get the layer object that have the specified ID.") and [FBTake::GetLayerByName()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_take.html#aa1e573bbb1194f9a30749625cb766939 "Get the layer object that have the specified name."). See the [FBTake](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_take.html "A take is a container for animation in a scene.") class for more details.

	[See samples: AnimationLayers.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_animation_layer_0c_animation_layers_8py-example.html) [MergeAnimationLayers.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_animation_layer_0c_merge_animation_layers_8py-example.html)"""
	LayerMode:FBLayerMode
	"""Read Write Property: Layer mode. By default, the layer is in kFBLayerModeAdditive mode. Cannot be applied to the BaseAnimation Layer."""
	LayerRotationMode:FBLayerRotationMode
	"""Read Only Property: Layer rotation mode. Cannot be applied to the BaseAnimation Layer."""
	Lock:bool
	"""Read Write Property: If true, the layer is locked. You cannot modify keyframes on a locked layer."""
	Mute:bool
	"""Read Write Property: If true, the layer is muted. A muted layer is not included in the result animation. Cannot be applied to the BaseAnimation Layer."""
	Solo:bool
	"""Read Write Property: If true, the layer is soloed. When you solo a layer, you mute other layers that are at the same level in the hierarchy, as well as the children of those layers. Cannot be applied to the BaseAnimation Layer."""
	@property
	def Weight(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: The weight value of a layer determines how much it is present in the result animation. Takes a value from 0 (the layer is not present) to 100. The weighting of a parent layer is factored into the weighting of its child layers, if any. BaseAnimation Layer always has a Weight of 100."""
		...
	@Weight.setter
	def Weight(self, Value: FBPropertyAnimatableDouble|float):...
	def AddChildLayer(self,AnimationLayer:FBAnimationLayer,/)->None:
		"""Add a child to the layer.

		Layer ID of the new child layer might change after parenting depending where the child layer was originally located.
		### Parameters:
			- AnimationLayer: Layer to set as a child."""
		...
	def GetChildCount(self)->int:
		"""Get the child layer count of this layer.

		The count will only includes direct child of the layer.
		### Returns:
		Child layer count, or -1 if unsuccessful"""
		...
	def GetChildLayer(self,Index:int,/)->FBAnimationLayer:
		"""Get the nth child layer of this layer.

		### Parameters:
			- Index: Index of the child layer to get.

		### Returns:
		Child animation layer located at pIndex"""
		...
	def GetCompleteChildHierarchy(self,ChildArray:FBComponent,/)->list:
		"""Get the all the children hierarchy of the layer, including children not directly connected to this layer.

		### Parameters:
			- ChildArray: Array of child layers, will be filled by the function.

		### Python:
		The function takes no parameter and returns a Python list. ex : lArray = lAnimationLayer.GetCompleteChildHierarchy()"""
		...
	def GetLayerIndex(self)->int:
		"""Get the layer index.

		### Returns:
		The layer index in the current layer hierarchy. This value will change if the hierarchy is modified. Return -1 if unsuccessful."""
		...
	def GetParentLayer(self)->FBAnimationLayer:
		"""Get the parent layer.

		### Returns:
		A pointer to the parent layer or NULL if the layer doesn't have a parent."""
		...
	def IsSelected(self)->bool:
		"""Verify if the layer is selected.

		### Returns:
		True if the layer is selected, false otherwise."""
		...
	def SelectLayer(self,Value:bool,ExclusiveSelect:bool,/)->None:
		"""Select the layer.

		This is the equivalent of selecting the layer in the UI in the Animation Layer Editor tool
		### Parameters:
			- Value: True if the layer will be selected, false otherwise.
			- ExclusiveSelect: If pValue is true, passing true will deselect all the other layers, creating an exclusive selection, it will also set the layer as the current layer."""
		...
	def SetParentLayer(self,ParentLayer:FBAnimationLayer,/)->None:
		"""Set the parent layer.

		### Parameters:
			- ParentLayer: A pointer to the parent layer or NULL if you want to unparent the layer."""
		...
	def __init__(self,Name:str,LayerID:int,/):
		"""### Parameters:
			- Name: Name of the animation layer.
			- LayerID: ID to set for the new layer."""
		...
class FBActorFace(FBComponent):
	"""Used to plot actor face animation.

	These classes are under development and may change dramatically between versions."""
	def PlotAnimation(self)->bool:
		"""Plot the animation of the actor face.

		### Returns:
		True if the operation completed successfully."""
		...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of new actor face."""
		...
class FBActionManager(FBComponent):
	"""Action Manager class.

	This class is introduced to enable users to access to the actions related functions. between versions."""
	CurrentInteractionMode:str
	def __init__(self):...
class FBConstraintManager(FBComponent):
	"""Constraint manager.

	[See sample: FBConstraintManager.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_f_b_constraint_manager_8py-example.html)"""
	@overload
	def TypeCreateConstraint(self,TypeIndex:int,/)->FBConstraint:
		"""Create a constraint by index.

		Given the index in the registry, this function create an instance of this constraint. The newly created constraint will be automatically added to the scene.
		### Parameters:
			- TypeIndex: Index of constraint type, must in range [0, [TypeGetCount()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_constraint_manager.html#aec594578e960089aa1e313e10404c668 "Get the number of registered constraint types.") ).

		### Returns:
		The newly created constraint, or NULL if pIndex is out of range."""
		...
	@overload
	def TypeCreateConstraint(self,Name:str,/)->FBConstraint:
		"""Create a constraint by name.

		Given the constraint type name in the registry, this function create an instance of this constraint. The newly created constraint will be automatically added to the scene.
		### Parameters:
			- Name: the name of the constraint to be created.

		### Returns:
		The newly created constraint, or NULL if pName doesn't match any registered constraints."""
		...
	def TypeGetCount(self)->int:
		"""Get the number of registered constraint types.

		### Returns:
		Number of registered constraint types."""
		...
	def TypeGetName(self,TypeIndex:int,/)->str:
		"""Get the name of a registered type of constraint.

		This will search in the registry for a constraint at the index pTypeIndex.
		### Parameters:
			- TypeIndex: Index of a constraint type.

		### Returns:
		Name of constraint type."""
		...
	def __init__(self):...
class FBConstructionHistory(FBComponent):
	"""Access to global construction history functionality."""
	OnChange:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: History changed."""
	def GetDeltaOperations(self,Operations:list,sinceCommandId:int,/)->None:
		"""GetDeltaOperations Get the list of delta operations in the construction history.

		### Parameters:
			- Operations: Array of operations, will be filled by the function."""
		...
	def GetScriptOutput(self,script:list,errors:list,/)->None:
		"""GetScriptOutput Returns the output from the scripting engine.

		### Parameters:
			- script: the script text
			- errors: the error outputted from the scripting engine"""
		...
	def GetState(self)->FBConstructionHistoryState:
		"""GetState returns the current state of the construction history manager.

		### Returns:
		returns a [FBConstructionHistoryState](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_construction_history_state.html "Construction history manager state.") indicating the state"""
		...
	def NetDelete(self,component:FBComponent,key:int,/)->None:
		"""NetDelete Network delete with support for Network Undo.

		### Parameters:
			- key: A key that uniquely identifies the operation"""
		...
	def NetUndo(self,key:int,/)->None:
		"""NetUndo Perform network undo operation.

		### Parameters:
			- key: The operation to undo"""
		...
	def RunOperation(self,operation:FBConstructionOperation,out_errors:list,/)->int:
		"""RunOperation Runs an operation.

		### Parameters:
			- operation: The operation to run
			- out_errors: A string containing the text of errors generated by running the operations (if any)"""
		...
class FBControlSet(FBComponent):
	"""Control set class.

	These classes are under development and may change dramatically between versions."""
	ControlSetType:FBControlSetType
	"""Read Property: the control Set Type (FKIK or IK)."""
	UseAxis:bool
	"""Read Write Property: is using axis."""
	def GetFKIndex(self,Model:FBModel,/)->int:
		"""Return The Index of the Given Model.

		### Parameters:
			- Model: Given Model to obtain Index

		### Returns:
		The Index of the Given Model."""
		...
	def GetFKModel(self,Index:FBBodyNodeId,/)->FBModel:
		"""Return the object associated to the given Index.

		### Parameters:
			- Index: Given Index to obtain Model

		### Returns:
		return the model at the specified Index."""
		...
	def GetFKName(self,Index:FBBodyNodeId,/)->str:
		"""return the name of FK Effector at the given index

		### Parameters:
			- Index: Given Index

		### Returns:
		return the name of IK Effector Slot"""
		...
	def GetIKEffectorIndex(self,Model:FBModel,/)->int:
		"""Return the Index of the Given Model.

		### Parameters:
			- Model: Given Model to Obtain Index

		### Returns:
		The Index of the Given Model."""
		...
	def GetIKEffectorModel(self,EffectorIndex:FBEffectorId,PivotIndex:int,/)->FBModel:
		"""Return the object associated to the given Index.

		### Parameters:
			- EffectorIndex: Given Index to obtain Model
			- PivotIndex: Index of effector pivot

		### Returns:
		return the model at the specified Index."""
		...
	def GetIKEffectorName(self,EffectorIndex:FBEffectorId,/)->str:
		"""return the name of IK Effector

		### Parameters:
			- EffectorIndex: Given Index to obtain Name

		### Returns:
		the name of IK Effector"""
		...
	def GetIKEffectorPivotCount(self,EffectorIndex:FBEffectorId,/)->int:
		"""return the number of IK Effector Slot

		### Returns:
		return the number of IK Effector Slot"""
		...
	def GetReferenceModel(self)->FBModel:
		"""Get the reference model associated with this Control Set.

		### Returns:
		The reference model associated with the Control Set."""
		...
	def GetReferenceName(self)->str:
		"""Get the reference name associated with this Control Set.

		### Returns:
		The reference name associated with the Control Set."""
		...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of new control set."""
		...
class FBCycleCreator(FBComponent):
	"""[See sample: CycleCreator.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_cycle_analysis_0c_cycle_creator_8py-example.html)"""
	def CreateCycle(self,StartTime:FBTime,EndTime:FBTime,Char:FBCharacter|None=None,MoveStartToZero:bool=False,AddZeroKey:bool=True,NewTakeName:str="",ReferencedIK:FBModel|None=None,PasteTx:bool=True,PasteTy:bool=False,PasteTz:bool=True,PasteR:bool=True,PasteG:bool=True,/)->bool:
		"""Create animation cycle for current character if pChar is NULL, else for the character assigned by pChar; during the time scope between pStartTime and pEndTime.

		### Parameters:
			- StartTime: Start time of the cycle
			- EndTime: End time of the cycle
			- Char: Target character, if it is NULL, try to use current character
			- MoveStartToZero: Whether move start time to zero time
			- AddZeroKey: Whether add zero key
			- NewTakeName: The name used to create the new take.
			- ReferencedIK: The IK that used as referenced object in pose pasting.
			- PasteTx: Whether consider Translation X on referenced IK when doing pose pasting
			- PasteTy: Whether consider Translation Y on referenced IK when doing pose pasting
			- PasteTz: Whether consider Translation Z on referenced IK when doing pose pasting
			- PasteR: Whether consider Rotation on referenced IK when doing pose pasting
			- PasteG: Whether respect Gravity when doing pose pasting (Translation = Global XZ / Rotation = Global Y). Note: if G is true then Ty will be forced changed to false.

		### Returns:
		true if successful."""
		...
	def __init__(self):...
class FBDeck(FBComponent):
	"""Interface to a tape deck."""
	CassetteInside:bool
	"""Read Only Property: Is the cassette inside?"""
	EE:bool
	"""Read Write Property: Is EE on?"""
	IconFilename:str
	"""Read Write Property: Filename of icon for deck."""
	Latency:FBTime
	"""Read Write Property: Latency of response for the deck;"""
	Offset:FBTime
	"""Read Write Property: Current offset for the TC."""
	Online:bool
	"""Read Write Property: Is deck online?"""
	PlayingBackward:bool
	"""Read Only Property: Playing backwards?"""
	PlayingForward:bool
	"""Read Only Property: Playing forward?"""
	PostRoll:FBTime
	"""Read Write Property: Post-Roll."""
	PreRoll:FBTime
	"""Read Write Property: Pre-Roll."""
	StandBy:bool
	"""Read Write Property: In standby mode?"""
	TransportControl:FBDeckTransportMode
	"""Read Write Property: Mode w/r to TC (None, Sync, Main );"""
	UniqueName:str
	"""internal Unique name."""
	def CueAt(self,Time:FBTime,/)->None:
		"""Cue deck at a given time.

		### Parameters:
			- Time: Time to cue deck at."""
		...
	def DeckAutoCommandsNotify(self)->None:
		"""Deck auto commands notification."""
		...
	def DeckStatusUpdateNotify(self)->None:
		"""Interface to IObject.

		Deck status update notification."""
		...
	def Eject(self)->None:
		"""Eject tape."""
		...
	def Forward(self)->None:
		"""Fast forward."""
		...
	def GetTime(self)->FBTime:
		"""Get the deck's time.

		### Returns:
		Time of deck."""
		...
	def Play(self,Speed:float=1.0,/)->None:
		"""Play forwards.

		### Parameters:
			- Speed: Playback speed (default is 1.0)."""
		...
	def ReversePlay(self,Speed:float=1.0,/)->None:
		"""Play backwards.

		### Parameters:
			- Speed: Playback speed(default is 1.0)."""
		...
	def Rewind(self)->None:
		"""Rewind."""
		...
	def StepBack(self)->None:
		"""Step backwards."""
		...
	def StepForward(self)->None:
		"""Step forwards."""
		...
	def Stop(self)->None:
		"""Stop."""
		...
	def ThreadSync(self)->None:...
class FBDeformer(FBComponent):
	"""Base Model deformer class."""
	DeformerType:FBDeformerType
	"""Read Only Property: Deformer Type."""
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of deformer."""
		...
class FBDeviceInstrument(FBComponent):
	"""Instrument abstraction layer."""
	Active:bool
	"""Read Write Property: Is instrument active?"""
	Device:FBDevice
	"""Read Write Property: Handle to owner device."""
	ModelTemplate:FBModelTemplate
	"""Read Write Property: Model template to build instruments' structure."""
	def InstrumentRecordFrame(self,RecordTime:FBTime,NotifyInfo:FBDeviceNotifyInfo,/)->None:
		"""Record the data to the function curves for the instrument.

		### Parameters:
			- RecordTime: Time to record data at.
			- NotifyInfo: Device notification information structure."""
		...
	def InstrumentWriteData(self,EvaluateInfo:FBEvaluateInfo,/)->bool:
		"""Write data to instrument's connectors.

		In the evaluation engine callback, this will take the data in the instrument's temporary data holders and write it to the connectors.
		### Parameters:
			- EvaluateInfo: Evaluation information structure.

		### Returns:
		true if successful."""
		...
	def __init__(self,Device:FBDevice,/):
		"""### Parameters:
			- Device: Parent device."""
		...
class FBDeformerPointCache(FBDeformer):
	"""Base Model deformer class."""
	Active:bool
	"""Read Write Property: Active."""
	ChannelCount:int
	"""Read Only Property: Channel Count."""
	ChannelEnd:FBTime
	"""Read Only Property: Channel End."""
	ChannelFrameRate:float
	"""Read Only Property: Channel FrameRate."""
	ChannelIndex:int
	"""Read Write Property: Channel Index."""
	ChannelName:str
	"""Read Only Property: Channel Name."""
	ChannelPointCount:int
	"""Read Only Property: Channel Point Count."""
	ChannelSampleRegular:bool
	"""Read Only Property: Channel Sample Regular."""
	ChannelStart:FBTime
	"""Read Only Property: Channel Start."""
	PointCacheFile:FBPointCacheFile
	"""Read Write Property: Point Cache File Object."""
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of deformer."""
		...
class FBDeviceOpticalMarker(FBComponent):
	"""Device optical marker.

	A device optical marker represents the input locations for interfacing optical hardware. This type of marker corresponds uniquely to the input (from the hardware) and will be represented on-screen by a [FBModelMarkerOptical](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model_marker_optical.html "Optical model marker class.")."""
	IsUsed:bool
	"""Property: Is marker used?"""
	Model:FBModel
	"""Property: Model marker access."""
	Occlusion:float
	"""Property: Occulsion data for marker."""
	Translation:property
	def SetData(self,X:float,Y:float,Z:float=0.0,Occlusion:float=0.0,/)->None:
		"""Set data for optical marker.

		### Parameters:
			- X: X position for marker.
			- Y: Y position for marker.
			- Z: Z position for marker(default=0.0).
			- Occlusion: Occulsion information for marker(default=0.0)."""
		...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of optical marker."""
		...
class FBEvaluateManager(FBComponent):
	DeviceCount:int
	"""Read only Property: Number of devices to evaluate."""
	DualQuaternionSkinning:bool
	"""Read/Write Property: Using state of the Dual Quaternion for skinning (CPU Skinning or GPU Skinning)."""
	FrameSkipOptimization:bool
	"""Read/Write Property: if true, apply frame skip optimization during playback. off-line rendering don't use frame skip optimization."""
	NodeCount:int
	"""Read only Property: Number of nodes to evaluate."""
	OnRenderingPipelineEvent:callbackframework.FBEventSource[Self, FBEventEvalGlobalCallback]
	"""For callback events at rendering pipeline."""
	OnSynchronizationEvent:callbackframework.FBEventSource[Self, FBEventEvalGlobalCallback]
	"""For callback events at synchronization point."""
	ParallelDeformation:bool
	"""Read/Write Property: true if deformation is evaluated in parallel."""
	ParallelEvaluation:bool
	"""Read/Write Property: true if parallel DAG schedule algorithm is being used. false when serial algorithm is being used."""
	ParallelPipeline:bool
	"""Read/Write Property: true if transformation is evaluated in parallel."""
	ParallelScheduleType:FBParallelScheduleType
	"""DEPRICATED Read/Write Property: choose between serial and parallel DAG schedule algorithm. kFBParallelScheduleSimple and kFBParallelScheduleAdvanced will set ParallelEvalution to true. kFBParallelScheduleSerial will set ParallelEvalution to false"""
	UseGPUDeformation:bool
	"""Read/Write Property: true if GPU deformation is used."""
	def InvalidateDAG(self)->None:
		"""Invalidate the DAG and trigger parallel scheduling at the next frame."""
		...
	def IsInteractiveMode(self)->bool:
		"""Check if the application main loop is in interactive or offline render mode.

		### Returns:
		true if is application is is interactive mode."""
		...
	def __init__(self):...
class FBFCurveEditorUtility(FBComponent):
	"""[FBFCurveEditor](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_f_curve_editor.html "FCurve editor.") Utility class Utility class allowing different operations on a [FBFCurveEditor](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_f_curve_editor.html "FCurve editor.") or on the main FCurveEditor."""
	def Frame(self,SelectedKeysOnly:bool,Editor:FBFCurveEditor|None=None,/)->bool:
		"""Frame keys in the FCurve Editor interface.

		### Parameters:
			- SelectedKeysOnly: If true, only the selected keys will be framed, otherwise all keys will be framed.
			- Editor: Pointer to a [FBFCurveEditor](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_f_curve_editor.html "FCurve editor.") for framing the keys in that custom editor, NULL to frame in the default editor.

		### Returns:
		True if successful, false otherwise.
		### Note:
		pEditor is currently not supported in this implementation, as the [FBFCurveEditor](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_f_curve_editor.html "FCurve editor.") is still in development."""
		...
	def GetObjects(self,ObjectList:list[FBComponent],/)->bool:
		"""Get all the objects displayed in the left pane of the FCurve Editor.

		### Parameters:
			- ObjectList: A list that will be filled with the objects displayed in the FCurve Editor.

		### Returns:
		True if successful, false otherwise."""
		...
	def GetProperties(self,Properties:list,SelectedOnly:bool,Editor:FBFCurveEditor|None=None,/)->bool:
		"""Get the displayed properties.

		### Parameters:
			- Properties: Array that will contain the properties displayed.
			- SelectedOnly: If true, only the selected properties will be returned.
			- Editor: Pointer to a [FBFCurveEditor](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_f_curve_editor.html "FCurve editor.") for getting the properties in that custom editor, NULL to frame in the default editor.

		### Returns:
		True if successful, false otherwise."""
		...
	def GetTimeSpan(self,Editor:FBFCurveEditor|None=None,/)->FBTimeSpan:
		"""Get the displayed time range of the FCurve Editor.

		### Parameters:
			- Editor: Pointer to a [FBFCurveEditor](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_f_curve_editor.html "FCurve editor.") where the time span will be get, NULL to get the time span from the default editor.

		### Returns:
		FCurve Editor time span, default [FBTimeSpan](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_time_span.html "TimeSpan class.") if not successful."""
		...
	def SetTimeSpan(self,TimeSpan:FBTimeSpan,Editor:FBFCurveEditor|None=None,/)->bool:
		"""Set the displayed time range of the FCurve Editor.

		### Parameters:
			- TimeSpan: The time span that will be set.
			- Editor: Pointer to a [FBFCurveEditor](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_f_curve_editor.html "FCurve editor.") where the time span will be set, NULL to set the time span on the default editor.

		### Returns:
		True if successful, false otherwise."""
		...
	def __init__(self):...
class FBFCurveEventManager(FBComponent):
	"""FCurve Event Manager Interface to the [FBFCurveEventManager](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_f_curve_event_manager.html "FCurve Event Manager Interface to the FBFCurveEventManager.").

	This class is used to track the changes on a FCurve of a property."""
	OnFCurveEvent:callbackframework.FBEventSource[Self, FBFCurveEvent]
	"""Event: Called when a registered FCurve is modified."""
	OnPropertyEvent:callbackframework.FBEventSource[Self, FBPropertyStateEvent]
	"""Event: Called when a registered property state is modified (detached, destroyed...)."""
	def RegisterProperty(self,Property:FBPropertyAnimatable,/)->bool:
		"""Register a property to the FCurve Event Manager.

		Properties that are registered will receive events with the OnFCurveEvent/OnPropertyEvent properties when their FCurves are modified.
		### Parameters:
			- Property: The property to track.

		### Returns:
		True if the registration was successful, False otherwise."""
		...
	def UnregisterProperty(self,Property:FBPropertyAnimatable,/)->bool:
		"""Unregister a property from the FCurve Event Manager.

		Those properties will not be tracked and no update will be sent with the OnFCurveEvent/OnPropertyEvent properties anymore.
		### Parameters:
			- Property: The property to stop tracking.

		### Returns:
		True if the unregistration was successful, False otherwise."""
		...
	def __init__(self):...
class FBFbxOptions(FBComponent):
	"""Customize file loading and saving.

	[See samples: FBFbxOptions.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_f_b_fbx_options_8py-example.html) [ImportWithNamespace.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_import_with_namespace_8py-example.html) [BatchExportCharacterAnimationTool.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_batch_export_character_animation_tool_8py-example.html)"""
	ActorFaces:FBElementAction
	"""Read Write Property: Handling of the Actor Faces elements."""
	ActorFacesAnimation:bool
	"""Read Write Property: Handling of the Actor Faces animation."""
	Actors:FBElementAction
	"""Read Write Property: Handling of the Actors elements."""
	Audio:FBElementAction
	"""Read Write Property: Handling of the Audio elements."""
	BaseCameras:bool
	"""Read Write Property: Consider base camera settings."""
	Bones:FBElementAction
	"""Read Write Property: Handling of the Bones elements."""
	BonesAnimation:bool
	"""Read Write Property: Handling of the Bones animation."""
	CacheSize:int
	"""Read Write Property: The Cached buffer size used to accelerate IO system."""
	CameraSwitcherSettings:bool
	"""Read Write Property: Consider camera switcher settings."""
	Cameras:FBElementAction
	"""Read Write Property: Handling of the Cameras elements."""
	CamerasAnimation:bool
	"""Read Write Property: Handling of the Cameras animation."""
	CharacterExtensions:FBElementAction
	"""Read Write Property: Handling of the Character Extensions."""
	CharacterFaces:FBElementAction
	"""Read Write Property: Handling of the Character Faces elements."""
	CharacterFacesAnimation:bool
	"""Read Write Property: Handling of the Character Faces animation."""
	Characters:FBElementAction
	"""Read Write Property: Handling of the Characters elements."""
	CharactersAnimation:bool
	"""Read Write Property: Handling of the Characters animation."""
	ClearSelectionBeforeSave:bool
	"""Read Write Property: Set to true if the current selected objects shouldn't saved when call [FBApplication::SaveCharacterRigAndAnimation](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_application.html#a346f461e13aa027da1465de97310530a "Save the rig and its animation in a file.")."""
	ConsiderMuteSolo:bool
	"""Read Write property: Consider the mute/solo settings to identify identical layer when merging."""
	Constraints:FBElementAction
	"""Read Write Property: Handling of the Constraints elements."""
	ConstraintsAnimation:bool
	"""Read Write Property: Handling of the Constraints animation."""
	CopyCharacterExtensions:bool
	"""Read Write Property: pCopyMissingExtensions Set to true if the character extensions on the rig in the file should be copied to the target rig."""
	CurrentCameraSettings:bool
	"""Read Write Property: Consider current camera settings."""
	Devices:FBElementAction
	"""Read Write Property: Handling of the Devices elements."""
	DevicesAnimation:bool
	"""Read Write Property: Handling of the Devices animation."""
	EmbedMedia:bool
	"""Read Write Property: Embed all media in the FBX file itself. When saving in ASCII mode it is not possible to embed media."""
	FileFormatAndVersion:FBFileFormatAndVersion
	"""Read Write Property: File format and version chosen to save the scene."""
	FileReference:bool
	"""Read Write property: Load/Save scene as FileReference."""
	FileReferenceEdit:bool
	"""Read Write Property: Load/Save the edits made to referenced objects or not."""
	FileReferences:FBElementAction
	"""Read Write Property: Handling of the FileReferences elements."""
	GlobalLightingSettings:bool
	"""Read Write Property: Consider global Lighting settings."""
	Groups:FBElementAction
	"""Read Write Property: Handling of the Groups elements."""
	IgnoreConflicts:bool
	"""Read Write Property: Set to true to ignore conflicts between objects in character extensions and objects in the scene. Conflicting objects will be merged in the extension"""
	KeepTransformHierarchy:bool
	"""Read Write Property: Indicate whether we keep transform hierarchy when SaveSelectedModelsOnly is true. Default value is false to ensure consistent behavior with SaveSelected operation via file menu."""
	KeyingGroups:FBElementAction
	"""Read Write Property: Handling of the Keying Groups elements."""
	Lights:FBElementAction
	"""Read Write Property: Handling of the Lights elements."""
	LightsAnimation:bool
	"""Read Write Property: Handling of the Lights animation."""
	Materials:FBElementAction
	"""Read Write Property: Handling of the Materials elements."""
	MaterialsAnimation:bool
	"""Read Write Property: Handling of the Materials animation."""
	Models:FBElementAction
	"""Read Write Property: Handling of the Models elements."""
	ModelsAnimation:bool
	"""Read Write Property: Handling of the Models animation."""
	NamespaceList:str
	"""Read Write Property: A list of namespaces separated by '~'. On Load, duplicate the loaded objects into each namespace in the list. If the SetMultiLoadNamespaceList method is also called, this property is ignored."""
	Notes:FBElementAction
	"""Read Write Property: Handling of the Notes elements."""
	NotesAnimation:bool
	"""Read Write Property: Handling of the Notes animation."""
	OpticalData:FBElementAction
	"""Read Write Property: Handling of the Optical Data elements."""
	PhysicalProperties:FBElementAction
	"""Read Write Property: Handling of the Physical Properties elements."""
	PhysicalPropertiesAnimation:bool
	"""Read Write Property: Handling of the Physical Properties animation."""
	Poses:FBElementAction
	"""Read Write Property: Handling of the Poses elements."""
	ProcessAnimationOnExtension:bool
	"""Read Write Property: Set to true if animation on character extensions should also be transferred."""
	RemoveConstraintReference:bool
	"""Read Write Property: Set to true if we should remove constraint reference."""
	RemoveEmptyLayer:bool
	"""Read Write property: Remove empty animation layers that are in additive mode, without child or parent."""
	ReplaceControlSet:bool
	"""Read Write Property: Set to true if the character extensions (and their children) should be saved when call [FBApplication::SaveCharacterRigAndAnimation](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_application.html#a346f461e13aa027da1465de97310530a "Save the rig and its animation in a file.")."""
	ResetDOF:bool
	"""Read Write Property: Set to true if we should change the limits on the target rig."""
	ResetHierarchy:bool
	"""Read Write Property: Set to true if we should reset the character hierarchy."""
	RetargetOnBaseLayer:bool
	"""Read Write Property: If the transfer method is retarget, set this parameter to control where the retarget correction will be made (on base layer or on another layer)."""
	SaveCharacter:bool
	"""Read Write Property: Set to true if the character should be saved when call [FBApplication::SaveCharacterRigAndAnimation](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_application.html#a346f461e13aa027da1465de97310530a "Save the rig and its animation in a file.")."""
	SaveCharacterExtensions:bool
	"""Read Write Property: Set to true if the character extensions (and their children) should be saved when call [FBApplication::SaveCharacterRigAndAnimation](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_application.html#a346f461e13aa027da1465de97310530a "Save the rig and its animation in a file.")."""
	SaveControlSet:bool
	"""Read Write Property: Set to true if the rig (and its children) should be saved when call [FBApplication::SaveCharacterRigAndAnimation](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_application.html#a346f461e13aa027da1465de97310530a "Save the rig and its animation in a file.")."""
	SaveSelectedModelsOnly:bool
	"""Read Write Property: Indicate that only the selected models will be saved."""
	Scripts:FBElementAction
	"""Read Write Property: Handling of the Scripts elements."""
	SetPropertyStaticIfPossible:bool
	"""Read Write Property: Set to false if want to keep properties' animated flag even when they are not really animated(no keyframe data) while retrieving/storing. [See sample: SetPropertyStaticIfPossibleOption.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_utilities_0c_set_property_static_if_possible_option_8py-example.html)"""
	Sets:FBElementAction
	"""Read Write Property: Handling of the Sets elements."""
	Shaders:FBElementAction
	"""Read Write Property: Handling of the Shaders elements."""
	ShadersAnimation:bool
	"""Read Write Property: Handling of the Shaders animation."""
	ShowFileDialog:bool
	"""Read Write Property: Set to true if want to pop up dialog for FileName, Format, Embed, Compression, UseTakeName, OneTakePerFile."""
	ShowOptionsDialog:bool
	"""Read Write Property: Set to true if want to pop up options dialog for detail settings."""
	Solvers:FBElementAction
	"""Read Write Property: Handling of the Solvers elements."""
	SolversAnimation:bool
	"""Read Write Property: Handling of the Solvers animation."""
	Story:FBElementAction
	"""Read Write Property: Handling of the Story elements."""
	StoryAnimation:bool
	"""Read Write Property: Handling of the Story animation (animatable properties on story objects)."""
	TakeSpan:FBTakeSpanOnLoad
	"""Read Write Property: Indicate how the take start and end point should be set. By default it is read from the file."""
	Textures:FBElementAction
	"""Read Write Property: Handling of the Textures elements."""
	TexturesAnimation:bool
	"""Read Write Property: Handling of the Textures animation."""
	TransferMethod:FBCharacterLoadAnimationMethod
	"""Read Write Property: How should the animation should be transfered on the target rig."""
	TransportSettings:bool
	"""Read Write Property: Consider transport control settings."""
	UpdateRecentFiles:bool
	"""Read Write Property: Set to true to update recent file list."""
	UseASCIIFormat:bool
	"""Read Write Property: Indicate if the resulting FBX file will be in binary or ASCII mode."""
	Video:FBElementAction
	"""Read Write Property: Handling of the Video elements."""
	def GetMultiLoadNamespaceList(self)->FBStringList:
		"""Returns the list of namespaces that will be used when merging multiple scenes (see [FBApplication::FileMerge](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_application.html#abbf8c31278a9d05ff41c5a3826058537 "Merge one or multiple files with the current scene.")).

		This list is affecting only the merge operation. When merging multiple scenes, if this list of namespaces is set, the [FBFbxOptions::NamespaceList](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_fbx_options.html#a0a39e5fc1811f92fa35ed80c332bb75f "Read Write Property: A list of namespaces separated by '~'. On Load, duplicate the loaded objects int...") property value is ignored.
		### Returns:
		The multi load namespace list currently set."""
		...
	def GetTakeCount(self)->int:
		"""Return the count of takes in the scene to saved or the file to loaded.

		### Warning:
		You need to use appropriate constructor to be able to take infos."""
		...
	def GetTakeDescription(self,TakeIndex:int,/)->str:
		"""Take Description.

		### Parameters:
			- TakeIndex: index of take to get."""
		...
	def GetTakeDestinationName(self,TakeIndex:int,/)->str:
		"""Take Destination Name upon save or load.

		### Parameters:
			- TakeIndex: index of take to get."""
		...
	def GetTakeKeyRange(self,TakeIndex:int,/)->FBTimeSpan:
		"""Get take key range.

		### Parameters:
			- TakeIndex: index of take to get.

		### Returns:
		A time range, keys inside that time range will be kept. Keys outside that time range will be removed when importing the animation, by default the time range is [FBTime::MinusInfinity](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_time.html#a7840cbd8a5f56768e40783609ff0f946 "Time constant: Minus Infinity, the lowest negative time value.") -> [FBTime::Infinity](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_time.html#ad4cdfb3a31e984e36d78499115839636 "Time constant: Infinity, the largest time value.")
		### Remarks:
		Valid only on load/merge, not when saving a file."""
		...
	def GetTakeName(self,TakeIndex:int,/)->str:
		"""Take Original Name.

		### Parameters:
			- TakeIndex: index of take to get."""
		...
	def GetTakeSelect(self,TakeIndex:int,/)->bool:
		"""Return if true if the take will be saved or Loaded.

		### Parameters:
			- TakeIndex: index of take to get."""
		...
	def SaveToString(self)->str:
		"""Serialize all options to a string Serialize all options to a string specifying a context.

		### Parameters:
			- String: The string containing all settings, target of serializing
			- context: The context to be used when serializing"""
		...
	def SetAll(self,ElementAction:FBElementAction,Animation:bool,/)->None:
		"""Set All Options.

		Initialize all loading/saving properties to ElementAction and animation specified.
		### Parameters:
			- ElementAction: Default value for all FBPropertyElementAction properties.
			- Animation: Default value for all Animation properties."""
		...
	def SetFromString(self,String:str,/)->None:
		"""Set all options from string Set all parameters from a formatted string (previously serialized with SaveToString)

		### Parameters:
			- String: The string containing all settings. See SaveToFile
			- context: The context to be used when de-serializing"""
		...
	def SetMultiLoadNamespaceList(self,MultiLoadNamespaceList:FBStringList,/)->None:
		"""Sets the list of namespaces that will be used when merging multiple scenes (see [FBApplication::FileMerge](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_application.html#abbf8c31278a9d05ff41c5a3826058537 "Merge one or multiple files with the current scene.")).

		The number of namespaces contained in this list must match the number of files merged, otherwise the merge operation will abort. The first namespace in the list will be applied on the first merged scene, the second namespace in the list will be applied on the second merged scene, and so one and so forth. This list is affecting only the merge operation. When merging multiple scenes, if this list of namespaces is set, the [FBFbxOptions::NamespaceList](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_fbx_options.html#a0a39e5fc1811f92fa35ed80c332bb75f "Read Write Property: A list of namespaces separated by '~'. On Load, duplicate the loaded objects int...") property value is ignored.

		```python
		# This example shows how to merge multiple scenes, each scene in its own user specified namespace:

		# Create an Load FBFbxOptions object
		fbxLoadOptions = FBFbxOptions( True )

		# Create a list of namespaces (2 items here, so the number of scenes to merge must also be 2)
		# and set the list in the FBFbxOptions object
		myNS = FBStringList( "MyFirstNS~MySecondNS" )
		fbxLoadOptions.SetMultiLoadNamespaceList( myNS )

		# Create a list of scenes to merge
		myScenesToMerge = FBStringList( "C:\\Temp\\MyFirstScene.fbx~C:\\Temp\\AnotherScene.fbx" )

		# Let's merge those scenes. The namespaces will be applied on the scenes' contents.
		print(FBApplication().FileMerge( myScenesToMerge, False, fbxLoadOptions ))
		```
		### Parameters:
			- MultiLoadNamespaceList: The multi load namespace list to set."""
		...
	def SetObjectsToSave(self,ObjectsToSave:list[FBComponent],/)->None:
		"""Sets the list of objects that will be saved.

		This needs to be set before calling [FBApplication::FileSave](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_application.html#af8c039b1b182fa56ef15e22d4557157d "Save the file under another name."). The list is affecting only one save operation. Once the save is completed, the list is cleared.
		### Parameters:
			- ObjectsToSave: The objects to save."""
		...
	def SetTakeDescription(self,TakeIndex:int,Description:str,/)->None:
		"""Take Description.

		### Parameters:
			- TakeIndex: index of take to set.
			- Description: take description to set"""
		...
	def SetTakeDestinationName(self,TakeIndex:int,DestinationName:str,/)->None:
		"""Take Destination Name upon save or load.

		### Parameters:
			- TakeIndex: index of take to set.
			- DestinationName: take description to set"""
		...
	def SetTakeKeyRange(self,TakeIndex:int,KeyTimeSpan:FBTimeSpan,/)->None:
		"""Set take key range.

		### Parameters:
			- TakeIndex: index of take to set.
			- KeyTimeSpan: Timespan indicating the time range to keep the keys. Keys that are outside the time range for this take will be removed, by default the time range is [FBTime::MinusInfinity](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_time.html#a7840cbd8a5f56768e40783609ff0f946 "Time constant: Minus Infinity, the lowest negative time value.") -> [FBTime::Infinity](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_time.html#ad4cdfb3a31e984e36d78499115839636 "Time constant: Infinity, the largest time value.")

		### Remarks:
		Valid only on load/merge, not when saving a file."""
		...
	def SetTakeName(self,TakeIndex:int,Name:str,/)->None:
		"""Take Original Name.

		### Parameters:
			- TakeIndex: index of take to set.
			- Name: take name to set"""
		...
	def SetTakeSelect(self,TakeIndex:int,Select:bool,/)->None:
		"""Return if true if the take will be saved or Loaded.

		### Parameters:
			- TakeIndex: index of take to set
			- Select: set true if should be saved or loaded."""
		...
	@overload
	def __init__(self,arg2,/):...
	@overload
	def __init__(self,Load:bool,FilePathToLoad:str,/):
		"""Create a FBFbxOption to be used in [FBApplication](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_application.html "FBApplication is used mainly to manage files.") Save/Load with default settings.
		### Parameters:
			- Load: If true, will init option for a default Load (Append all elements and animation). If false will initialized options for a default Save (Save all elements and animation).
			- FilePathToLoad: If pLoad is true, the client code should pass the file path to load to collect the take info; ignore when pLoad is false."""
		...
class FBFileMonitoringManager(FBComponent):
	"""File Change Monitoring Interface to the file change monitoring."""
	OnFileChangeAnimationClip:callbackframework.FBEventSource[Self, FBEventFileChange]
	"""Event: Animation clip file change event."""
	OnFileChangeFileReference:callbackframework.FBEventSource[Self, FBEventFileChange]
	"""Event: File Reference file change event."""
	OnFileChangeMainScene:callbackframework.FBEventSource[Self, FBEventFileChange]
	"""Event: Main scene file change event."""
	OnFileChangePythonEditorScript:callbackframework.FBEventSource[Self, FBEventFileChange]
	"""Event: Python Editor Script file change event."""
	def AddFileToMonitor(self,FilePath:str,FileMonitoringType:FBFileMonitoringType,/)->None:
		"""Add file to monitor.

		### Parameters:
			- FilePath: The file path to monitor.
			- FileMonitoringType: The monitor type of this file."""
		...
	def CleanFileMonitoring(self,IncludePythonEditorScripts:bool=True,/)->None:
		"""Clean files and directories currently been monitored.

		### Parameters:
			- IncludePythonEditorScripts: True to also clean the monitoring of Python Editor script files loaded, false otherwise."""
		...
	def PauseFileMonitoring(self,Pause:bool=True,/)->None:
		"""Pause file from monitoring, except for Python Editor script files loaded.

		### Parameters:
			- Pause: True to pause the file monitoring, false to resume."""
		...
	def RemoveFileFromMonitor(self,FilePath:str,/)->None:
		"""Remove file from monitoring.

		### Parameters:
			- FilePath: The file path to be removed."""
		...
	def __init__(self):...
class FBFilter(FBComponent):
	"""Filters are used to modify motion capture data.

	Filters are objects which can be applied on a FCurve, or the animation node associated with an animated object property, to modify shape and number of keys. Filters can be created from the GUI, using the Filters tool, or programmatically with an instance of a FBFilterManager.The filter properties can be found in the object's PropertyList data member. They will use the same name, and be of the same type, as what can be seen in the GUI.Instances of [FBFilter](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_filter.html "Filters are used to modify motion capture data.") should be created with the help of the class [FBFilterManager](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_filter_manager.html "Filter manager."). Only internal application code should call the [FBFilter](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_filter.html "Filters are used to modify motion capture data.")'s class constructor.Sample C++ code:

	```c++
	FBFilterManager lFilterManager;

	// Create a filter instace.
	FBFilter* lFilter = lFilterManager.CreateFilter( "Key Reducing" );

	if( lFilter )
	{
	 // Create a FCurve and populate it with keys.
	 FBFCurve lCurve( "Temp Curve" );
	 for( int lIdx = 1; lIdx < 10; ++lIdx )
		{
	 FBTime lTime( 0, 0, 0, lIdx * 5 );
			lCurve.KeyAdd( lTime, lIdx * 5 );
		}

	 FBTrace( "Keys before: %d\\n", lCurve.Keys.GetCount() ); // Should be 9.

	 // Apply the key reducing filter.
		lFilter->Apply( &lCurve );

	 FBTrace( "Keys after: %d\\n", lCurve.Keys.GetCount() ); // Should be 2.
	}
	```
	Sample Python code:

	```python
	from pyfbsdk import *

	# Find a given model in the scene.
	lModel = FBFindModelByLabelName( 'Cube' )

	if lModel:
	 # Create a Key Reducing filter.
		lFilter = FBFilterManager().CreateFilter( 'Key Reducing' )

	 if lFilter:
			# Set the filter's precision to 2.0, and apply it to
			# the object's translation animation.
			lFilter.PropertyList.Find( 'Precision' ).Data = 2.0
			lFilter.Apply( lModel.Translation.GetAnimationNode(), True )
	```"""
	Start:FBTime
	"""Read Write Property: Start time of the filtering region"""
	Stop:FBTime
	"""Read Write Property: Stop time of the filtering region"""
	@overload
	def Apply(self,Node:FBAnimationNode,Recursive:bool,/)->bool:
		"""Apply the filter to an animation node.

		This is the other apply method and it can be used on an object's animation node.
		### Parameters:
			- Node: Node to apply filter to.
			- Recursive: Recursively apply filter on child nodes?

		### Returns:
		true if successful."""
		...
	@overload
	def Apply(self,Curve:FBFCurve,/)->bool:
		"""Apply the filter to an FCurve.

		This is one of the two apply method that is meant to be called by client code. The FCurve can be a standalone independant FCurve, or can be associated to an object's animated property.
		### Parameters:
			- Curve: FCurve to apply filter to.

		### Returns:
		true if successful."""
		...
	def Reset(self)->None:
		"""Reset properties.

		### Warning:
		This method will only work on plug-in filters, not built-in types."""
		...
class FBFolder(FBComponent):
	"""Folder class.

	This class is an interface to manipulate folders in the scene.

	[See sample: FBFolder.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_f_b_folder_8py-example.html)"""
	Items:FBPropertyListComponent
	"""List: List of components in the folder."""
	def __init__(self,Name:str,Component:FBComponent,/):
		"""### Parameters:
			- Name: Name to assign to new folder.
			- Component: Object used to determine folder's category."""
		...
class FBGenericMenu(FBComponent):
	"""A GenericMenu class.

	You can use this class either to create a new menu in the menu bar (or in a menuitem in the menu bar) or you can use this class to create a pop-up menu.

	```python
	#to start a pop up menu use the Execute method
	def mouseClick(x, y):
		item = menu.Execute(x, y)
		if item.Id == 10:
		   [do this]
		else if item.Id == 100:
			[do that...]
	```
	There are 4 ways to insert new item in a menu. Each method needs the name of the menuitem as well as it's unique id. You can also optionally sets a new menu for a specific item.

	```python
	embeededMenu = FBGenericMenu()
	menu.InsertLast("new new item", 67, embeddedMenu)

	#A genericMenu contains a GenericMenuItem for each entry. You can iterate on the different menuitem
	#using GetFirstITem/GetNextItem or if you already know the id of the item you can get it with GetItem.

	item = menu.GetFirstItem()
	while item:
		print(item.Name)
		item = menu.GetNextItem(item)
	```

	```python
	# This example shows how to list the Caption/Id of all the menu items of the Edit menu
	menuManager = FBMenuManager()
	editMenu = menuManager.GetMenu( "Edit" )
	item = editMenu.GetFirstItem()
	while item:
		print("'" + item.Caption + "' (id: " + str( item.Id ) + ")")
		item = editMenu.GetNextItem( item )
	```
	You can also delete a Menu item: this will remove the item from the menu as well as freeing its memory.To be notified when a menuitem is clicked, you can register using OnMenuActivate. This will send a [FBEventMenu](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_event_menu.html "Menu event.") containing the name and the Id of the menu item that was clicked.

	[See sample: FBMenu.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_f_b_menu_8py-example.html)"""
	OnMenuActivate:callbackframework.FBEventSource[Self, FBEventMenu]
	"""Event Property: Register on this property to be notified when a menu item is clicked by the user."""
	def DeleteItem(self,ToDelete:FBGenericMenuItem,/)->None:
		"""Remove a menu item from the menu and delete it.

		### Parameters:
			- ToDelete: The item to remove."""
		...
	def Execute(self,X:int,Y:int,RightAlign:bool=True,/)->FBGenericMenuItem:
		"""Starts the menu as a pop-up menu at a specific location on screen.

		It returns the item that was clicked by the user.
		### Parameters:
			- X: X location in pixel on screen where the menu is to be popped.
			- Y: Y location in pixel on screen where the menu is to be popped.
			- RightAlign: All menu item will be align to the right justified (if true) or left justified (if false)

		### Returns:
		The selected item by the user. Null if the user clicks outside the menu."""
		...
	def GetFirstItem(self)->FBGenericMenuItem:
		"""Returns the first menu item (if existing) in this menu.

		You can then use GetNextItem to iterate on other menu items.
		### Returns:
		The first menu item in this Menu."""
		...
	def GetItem(self,ItemId:int,/)->FBGenericMenuItem:
		"""Returns the menu item corresponding to an id.

		### Parameters:
			- ItemId: Id of the item we are looking for.

		### Returns:
		Will return the Item corresponding to an id (null if not found)."""
		...
	def GetLastItem(self)->FBGenericMenuItem:
		"""Returns the last menu item (if existing) in this menu.

		You can then use GetPrevItem to reverse iterate on other menu items.
		### Returns:
		The last menu item in this Menu."""
		...
	def GetNextItem(self,Item:FBGenericMenuItem,/)->FBGenericMenuItem:
		"""Returns the menu item following an other item.

		Returns null if this is the last item in menu.
		### Parameters:
			- Item: Will return the item after pItem

		### Returns:
		Will return the item after pItem. Null if pItem is the last item."""
		...
	def GetPrevItem(self,Item:FBGenericMenuItem,/)->FBGenericMenuItem:
		"""Returns the menu item preceding an other item.

		Returns null if this is the first item in menu.
		### Parameters:
			- Item: Will return the item BEFORE pItem

		### Returns:
		Will return the item BEFORE pItem. Null if pItem is the first item."""
		...
	def InsertAfter(self,BeforeItem:FBGenericMenuItem,ItemName:str,ItemId:int,Menu:FBGenericMenu|None=None,/)->FBGenericMenuItem:
		"""Inserts a new menu Item AFTER another item.

		### Parameters:
			- BeforeItem: The reference item. We will create a new item AFTER this one.
			- ItemName: Caption of the newly added item.
			- ItemId: Unique id of this menu item.
			- Menu: Optional. If this Item leads to another menu (embedded) it can be specified here.

		### Returns:
		Will return the menu item created from this insertion."""
		...
	def InsertBefore(self,AfterItem:FBGenericMenuItem,ItemName:str,ItemId:int,Menu:FBGenericMenu|None=None,/)->FBGenericMenuItem:
		"""Inserts a new menu Item BEFORE another item.

		### Parameters:
			- AfterItem: The reference item. We will create a new item BEFORE this one.
			- ItemName: Caption of the newly added item.
			- ItemId: Unique id of this menu item.
			- Menu: Optional. If this Item leads to another menu (embedded) it can be specified here.

		### Returns:
		Will return the menu item created from this insertion."""
		...
	def InsertFirst(self,ItemName:str,ItemId:int,Menu:FBGenericMenu|None=None,/)->FBGenericMenuItem:
		"""Inserts a new menu Item at the first position in the menu list.

		### Parameters:
			- ItemName: Caption of the newly added item.
			- ItemId: Unique id of this menu item.
			- Menu: Optional. If this Item leads to another menu (embedded) it can be specified here.

		### Returns:
		Will return the menu item created from this insertion."""
		...
	def InsertLast(self,ItemName:str,ItemId:int,Menu:FBGenericMenu|None=None,/)->FBGenericMenuItem:
		"""Inserts a new menu Item at the last position in the menu list.

		### Parameters:
			- ItemName: Caption of the newly added item.
			- ItemId: Unique id of this menu item.
			- Menu: Optional. If this Item leads to another menu (embedded) it can be specified here.

		### Returns:
		Will return the menu item created from this insertion."""
		...
	def __init__(self):
		"""Default constructor.

		Used to create embedded menu (inside another menu item) or pop-up menu."""
		...
class FBGenericMenuItem(FBComponent):
	"""[FBGenericMenuItem](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_generic_menu_item.html "FBGenericMenuItem This class stores data for a single menu item.") This class stores data for a single menu item.

	A single menu item can contains another menu (embedded menu) or not. A GenericMenuItem has an Id and a Name.You can use a GenericMenuItem to modify the attributes of a menu (it is the only way to change its name).You cannot create a [FBGenericMenuItem](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_generic_menu_item.html "FBGenericMenuItem This class stores data for a single menu item.") directly. You must use the insertion method in FBMenu of [FBMenuManager](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_menu_manager.html "The menu manager allows access to MotionBuilder menu bar.") to obtain a handle on a [FBGenericMenuItem](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_generic_menu_item.html "FBGenericMenuItem This class stores data for a single menu item.").

	[See sample: FBMenu.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_f_b_menu_8py-example.html)"""
	Caption:str
	"""Read/Write Property: Caption of the menu item."""
	Enable:bool
	"""Read/Write Property: Enable or Disable (grey out) a menu Item."""
	Id:int
	"""Read/Write Property: Id of the menu item."""
	Menu:FBGenericMenu
	"""Read/Write Property: If the menu item leads to another menu."""
class FBGeometry(FBComponent):
	"""Geometry class.

	This class groups all geometry related elements which are shared across the different subclasses ([FBMesh](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_mesh.html "Mesh class."), [FBSurface](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_surface.html "Surface class."), [FBNurbs](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_nurbs.html "Nurbs class.") and [FBPatch](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_patch.html "Patch class.")). Geometry Material always use kFBGeometryReference_INDEX mode. While Normal, UV could have different combination of mapping and reference modes.Geometries created with SDK can support FBGeometryMapping_ALL_SAME or kFBGeometryMapping_BY_POLYGON for material, and kFBGeometryMapping_BY_CONTROL_POINT for Normal, Tangent, Binormal, Color and UV. Only one set of UV could be supported.Geometries passed from FBXSDK pipeline could have various complex mapping/reference mode combination for material, normal and UV. And could potentially contains multiple set of UVs.

	[See samples: ShapeCreation.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_geometry_0c_shape_creation_8py-example.html) [VertexArrayManipulation.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_geometry_0c_vertex_array_manipulation_8py-example.html)"""
	BinormalMappingMode:FBGeometryMappingMode
	"""Read Only Property: Binormal mapping mode."""
	BinormalReferenceMode:FBGeometryReferenceMode
	"""Read Only Property: Binormal reference mode."""
	MaterialMappingMode:FBGeometryMappingMode
	"""Read Property: Material mapping mode."""
	NormalMappingMode:FBGeometryMappingMode
	"""Read Only Property: Normal mapping mode."""
	NormalReferenceMode:FBGeometryReferenceMode
	"""Read Only Property: Normal reference mode."""
	TangentMappingMode:FBGeometryMappingMode
	"""Read Only Property: Tangent mapping mode."""
	TangentReferenceMode:FBGeometryReferenceMode
	"""Read Only Property: Tangent reference mode."""
	VertexColorMappingMode:FBGeometryMappingMode
	"""Read Only Property: Vertex Color mapping mode."""
	VertexColorReferenceMode:FBGeometryReferenceMode
	"""Read Only Property: Vertex Color reference mode."""
	def GeometryBegin(self)->bool:
		"""Begin geometry editing.

		### Returns:
		true if successful."""
		...
	def GeometryEnd(self)->bool:
		"""End geometry editing.

		### Returns:
		true if successful."""
		...
	def GetBinormalsDirectArray(self)->list:
		"""Get a pointer to the direct array of binormals.

		Modify array value will be only effective when geometry editing is enabled.
		### Parameters:
			- OutArrayCount: To return the length the array.

		### Returns:
		Pointer to direct array of binormals, or NULL if the array hasn't been allocated yet.
		### See also:
		[GeometryBegin()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_geometry.html#a137880b95679600966415dc2f6cf3916 "Begin geometry editing.")/GeometryEnd()"""
		...
	def GetBinormalsIndexArray(self)->list:
		"""Get a pointer to the index array of binormals.

		Modify array value will be only effective when geometry editing is enabled.
		### Parameters:
			- OutArrayCount: To return the length the array.

		### Returns:
		Pointer to index array of binormals, or NULL if the array hasn't been allocated yet.
		### See also:
		[GeometryBegin()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_geometry.html#a137880b95679600966415dc2f6cf3916 "Begin geometry editing.")/GeometryEnd()"""
		...
	def GetMaterialIndexArray(self)->list:
		"""Get a pointer to the index array of Material.

		Modify array value will be only effective when geometry editing is enabled.
		### Parameters:
			- OutArrayCount: To return the length the array.

		### Returns:
		Pointer to index array of Material, or NULL if the array hasn't been allocated yet.
		### See also:
		[GeometryBegin()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_geometry.html#a137880b95679600966415dc2f6cf3916 "Begin geometry editing.")/GeometryEnd()"""
		...
	def GetNormalsDirectArray(self)->list:
		"""Get a pointer to the direct array of normals.

		Modify array value will be only effective when geometry editing is enabled.
		### Parameters:
			- OutArrayCount: To return the length the array.

		### Returns:
		Pointer to direct array of normals, or NULL if the array hasn't been allocated yet.
		### See also:
		[GeometryBegin()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_geometry.html#a137880b95679600966415dc2f6cf3916 "Begin geometry editing.")/GeometryEnd()"""
		...
	def GetNormalsIndexArray(self)->list:
		"""Get a pointer to the index array of normals.

		Modify array value will be only effective when geometry editing is enabled.
		### Parameters:
			- OutArrayCount: To return the length the array.

		### Returns:
		Pointer to index array of normals, or NULL if the array hasn't been allocated yet.
		### See also:
		[GeometryBegin()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_geometry.html#a137880b95679600966415dc2f6cf3916 "Begin geometry editing.")/GeometryEnd()"""
		...
	def GetPositionsArray(self)->list:
		"""Get a pointer to the position array.

		Modify array value will be only effective when geometry editing is enabled.
		### Parameters:
			- OutArrayCount: To return the length the array.

		### Returns:
		Pointer to index array of normals, or NULL if the array hasn't been allocated yet.
		### See also:
		[GeometryBegin()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_geometry.html#a137880b95679600966415dc2f6cf3916 "Begin geometry editing.")/GeometryEnd()"""
		...
	def GetTangentsDirectArray(self)->list:
		"""Get a pointer to the direct array of tangents.

		Modify array value will be only effective when geometry editing is enabled.
		### Parameters:
			- OutArrayCount: To return the length the array.

		### Returns:
		Pointer to direct array of tangents, or NULL if the array hasn't been allocated yet.
		### See also:
		[GeometryBegin()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_geometry.html#a137880b95679600966415dc2f6cf3916 "Begin geometry editing.")/GeometryEnd()"""
		...
	def GetTangentsIndexArray(self)->list:
		"""Get a pointer to the index array of tangents.

		Modify array value will be only effective when geometry editing is enabled.
		### Parameters:
			- OutArrayCount: To return the length the array.

		### Returns:
		Pointer to index array of tangents, or NULL if the array hasn't been allocated yet.
		### See also:
		[GeometryBegin()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_geometry.html#a137880b95679600966415dc2f6cf3916 "Begin geometry editing.")/GeometryEnd()"""
		...
	def GetUVSetDirectArray(self,arg2:str|None=None,/)->list:
		"""Get a pointer to the direct array of UVset Modify array value will be only effective when geometry editing is enabled.

		### Parameters:
			- OutArrayCount: To return the length the array.
			- UVSetName: The name of UVset, NULL for the first UVset.

		### Returns:
		pointer to the array of UV, or NULL is the array hasn't been allocated yet.
		### See also:
		[GeometryBegin()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_geometry.html#a137880b95679600966415dc2f6cf3916 "Begin geometry editing.")/GeometryEnd()"""
		...
	def GetUVSetIndexArray(self,arg2:str|None=None,/)->list:
		"""Get a pointer to the index array of UVset.

		Modify array value will be only effective when geometry editing is enabled.
		### Parameters:
			- OutArrayCount: To return the length the array.
			- UVSetName: The name of UVset, NULL for the first UVset.

		### Returns:
		Pointer to index array of UVSet, or NULL if the array hasn't been allocated yet.
		### See also:
		[GeometryBegin()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_geometry.html#a137880b95679600966415dc2f6cf3916 "Begin geometry editing.")/GeometryEnd()"""
		...
	def GetUVSetMappingMode(self,UVSetName:str|None=None,/)->FBGeometryMappingMode:
		"""Get UVSet mapping mode.

		### Parameters:
			- UVSetName: The name of UVset, NULL for the first UVset.

		### Returns:
		Mapping mode of the UVset."""
		...
	def GetUVSetReferenceMode(self,UVSetName:str|None=None,/)->FBGeometryReferenceMode:
		"""Get UVSet reference mode.

		### Parameters:
			- UVSetName: The name of UVset, NULL for the first UVset.

		### Returns:
		Reference mode of the UVset."""
		...
	def GetUVSets(self)->FBStringList:
		"""Get available UVSet name.

		### Returns:
		StringList contain all the available UVSets' name."""
		...
	def GetVertexColorsDirectArray(self)->list:
		"""Get a pointer to the direct array of vertex color.

		Modify array value will be only effective when geometry editing is enabled.
		### Parameters:
			- OutArrayCount: To return the length the array.

		### Returns:
		Pointer to direct array of vertex colors, or NULL if the array hasn't been allocated yet.
		### See also:
		[GeometryBegin()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_geometry.html#a137880b95679600966415dc2f6cf3916 "Begin geometry editing.")/GeometryEnd()"""
		...
	def GetVertexColorsIndexArray(self)->list:
		"""Get a pointer to the index array of vertex color.

		Modify array value will be only effective when geometry editing is enabled.
		### Parameters:
			- OutArrayCount: To return the length the array.

		### Returns:
		Pointer to index array of vertex color, or NULL if the array hasn't been allocated yet.
		### See also:
		[GeometryBegin()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_geometry.html#a137880b95679600966415dc2f6cf3916 "Begin geometry editing.")/GeometryEnd()"""
		...
	def SetBinormalsDirectArray(self,arg2:list,/)->bool:...
	def SetBinormalsIndexArray(self,arg2:list,/)->bool:...
	def SetMaterialIndexArray(self,arg2:list,/)->bool:...
	def SetNormalsDirectArray(self,arg2:list,/)->bool:...
	def SetNormalsIndexArray(self,arg2:list,/)->bool:...
	def SetPositionsArray(self,arg2:list,/)->bool:...
	def SetTangentsDirectArray(self,arg2:list,/)->bool:...
	def SetTangentsIndexArray(self,arg2:list,/)->bool:...
	def SetUVSetDirectArray(self,arg2:list,arg3:str|None=None,/)->bool:...
	def SetUVSetIndexArray(self,arg2:list,arg3:str|None=None,/)->bool:...
	def SetVertexColorsDirectArray(self,arg2:list,/)->bool:...
	def SetVertexColorsIndexArray(self,arg2:list,/)->bool:...
	def ShapeAdd(self,Name:str,/)->int:
		"""Add new shape.

		### Parameters:
			- Name: the shape name

		### Returns:
		the index of the new shape, -1 if the shape adding fail."""
		...
	def ShapeClearAll(self)->None:
		"""Clears all the shapes."""
		...
	def ShapeGetCount(self)->int:
		"""Get Shape Count."""
		...
	def ShapeGetDiffPoint(self,ShapeIdx:int,DiffIndex:int,OriIndex:int,PosDiff:FBVertex,NormalDiff:FBNormal,/)->bool:
		"""Get the differentiate point.

		### Parameters:
			- ShapeIdx: The index of the shape
			- DiffIndex: The index of the diff point in this shape.
			- OriIndex: The index of the diff point in the original geometry.
			- PosDiff: The position differentiation.
			- NormalDiff: The normal differentiation."""
		...
	def ShapeGetDiffPointAsList(self,arg2,arg3,arg4:list,arg5:FBVertex,arg6:FBNormal,/)->bool:...
	def ShapeGetName(self,ShapeIdx:int,/)->str:
		"""Return the shape Name."""
		...
	def ShapeInit(self,ShapeIdx:int,DiffSize:int,WithNormal:bool,/)->None:
		"""Init the shape.

		### Parameters:
			- ShapeIdx: The index of the shape to be initialized
			- DiffSize: Total number of different point (pos or normal) compared to base geometry.
			- WithNormal: Currently normal won't be considered during shape blending."""
		...
	def ShapeSetDiffPoint(self,ShapeIdx:int,DiffIndex:int,OriIndex:int,PosDiff:FBVertex,NormalDiff:FBNormal|None=None,/)->bool:
		"""Set the differentiate point.

		### Parameters:
			- ShapeIdx: The index of the shape
			- DiffIndex: The index of the diff point in this shape.
			- OriIndex: The index of the diff point in the original geometry.
			- PosDiff: The position differentiation.
			- NormalDiff: The normal differentiation."""
		...
	@overload
	def VertexAdd(self,Vertex:FBVertex,/)->int:
		"""Add a vertex.

		### Parameters:
			- Vertex: Vertex values used to add vertex.

		### Returns:
		Index where vertex was added.
		### Remarks:
		Set Normal with default value"""
		...
	@overload
	def VertexAdd(self,Vertex:FBVertex,Normal:FBNormal,UV:FBUV,/)->int:
		"""Add a vertex.

		### Parameters:
			- Vertex: Vertex values used to add vertex.
			- Normal: Normal values used to add vertex.
			- UV: UV values used to add vertex.

		### Returns:
		Index where vertex was added."""
		...
	def VertexArrayClear(self)->bool:
		"""Clear all geometry vertex arrays.

		Call this function to clear Position, Normal, UV, Color and etc vertex arrays, and it won't affect geometry's topology (polygon, Surface and etc.,).
		### Returns:
		true if successful."""
		...
	def VertexArrayInit(self,Vertexcount:int,UniqueMaterial:bool,FBGeometryArrayIDs:int=0,/)->bool:
		"""Init geometry vertex arrays.

		Init position, normal and UV arrays (tangent, bi-normal and color on demand) with kFBGeometryMapping_BY_CONTROL_POINT / kFBGeometryReference_DIRECT mode. Will call [VertexArrayClear()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_geometry.html#ab43f405ea6d82de3484e00b77cb209d1 "Clear all geometry vertex arrays.") internally. User should then call GetXXXDirectyArray() to edit the vertex attributes directly.
		### Parameters:
			- Vertexcount: number of control points (vertex)
			- UniqueMaterial: User could specify per polygon mapping mode for mesh
			- FBGeometryArrayIDs: Request to init other attribute arrays, bitwise combined value of [FBGeometryArrayID](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_geometry_array_i_d.html "ID to use when requesting a specific array of data for a model.") enum items, currently support Tangent, Binormal and VertexColor. Only useful for mesh."""
		...
	def VertexClear(self)->bool:
		"""Clear all Vertex arrays.

		Call this function to clear Position, Normal, UV, Color and etc vertex arrays, and it won't affect geometry's topology (polygon, Surface and etc.,).
		### Returns:
		true if successful."""
		...
	def VertexColorGet(self,Index:int,/)->FBColorAndAlpha:
		"""Get a Vertex Color.

		### Parameters:
			- Index: Index of Vertex to get Color for(default=-1).

		### Returns:
		Color of vertex at UVSetIndex."""
		...
	@overload
	def VertexColorSet(self,arg2:FBColorAndAlpha,arg3=None,/)->bool:...
	@overload
	def VertexColorSet(self,Red:float,Green:float,Blue:float,Alpha:float,Index:int=-1,/)->bool:
		"""Set a UV coordinate.

		### Parameters:
			- Red: Red Color Channel to set, range [0, 1].
			- Green: Green Color Channel to set, range [0, 1].
			- Blue: Blue Color Channel to set, range [0, 1].
			- Alpha: Alpha Color Channel to set, range [0, 1].
			- Index: Index of Vertex to affect with Red, Green, Blue and Alpha (default=-1).

		### Returns:
		true if successful."""
		...
	def VertexCount(self)->int:
		"""Get the number of vertices in the geometry.

		### Returns:
		Number of vertices in the geometry."""
		...
	def VertexGet(self,Index:int,/)->FBVertex:
		"""Get a vertex.

		### Parameters:
			- Index: Index of vertex to get.

		### Returns:
		Vertex stored at pIndex."""
		...
	def VertexGetSelected(self,Index:int,/)->bool:
		"""Get the selected state of a vertex.

		### Parameters:
			- Index: The index of the vertex

		### Returns:
		true if the vertex is selected, false if not"""
		...
	def VertexGetTransformable(self,Index:int,/)->bool:
		"""Get the Transformable state of a vertex.

		### Parameters:
			- Index: The index of the vertex

		### Returns:
		true if the vertex is Transformable, false if not"""
		...
	def VertexGetVisible(self,Index:int,/)->bool:
		"""Get the visible state of a vertex.

		### Parameters:
			- Index: The index of the vertex

		### Returns:
		true if the vertex is visible, false if not"""
		...
	def VertexInit(self,Size:int,Resize:bool,InitUV:bool=True,InitVertexColor:bool=False,/)->None:
		"""Resize or Reserve vertex, normal and UV array for performance.

		### Parameters:
			- Size: Number of vertices to resize or reserve.
			- Resize: **True**, for the geometry with known vertex count, we should resize the arrays to fixed size, and call [VertexSet()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_geometry.html#a2e5951370a3f25f2ce5683cb2fc6159a "Set a vertex.") afterwards; **False**, While for dynamic size geometry, we should only reserve the arrays with the estimated optimal size, then call [VertexAdd()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_geometry.html#a41b4845445d2656130fac19d9fb64c51 "Add a vertex.") to dynamically increase the vertex count.
			- InitUV: init Vertex UV array if true
			- InitVertexColor: Init Vertex Color Array if true."""
		...
	def VertexNormalGet(self,Index:int,/)->FBNormal:
		"""Get a normal at a vertex.

		### Parameters:
			- Index: Vertex to get normal at(default=-1).

		### Returns:
		Normal of vertex at pIndex."""
		...
	@overload
	def VertexNormalSet(self,Vertex:FBNormal,Index:int=-1,/)->bool:
		"""Set a normal at a vertex.

		### Parameters:
			- Vertex: Normal to set.
			- Index: Index of vertex to set Normal at(default=-1).

		### Returns:
		true if successful."""
		...
	@overload
	def VertexNormalSet(self,x:float,y:float,z:float,Index:int=-1,/)->bool:
		"""Set a normal at a vertex.

		### Parameters:
			- x: X coordinate of normal.
			- y: Y coordinate of normal.
			- z: Z coordinate of normal.
			- Index: Index of vertex to set Normal at(default=-1).

		### Returns:
		true if successful."""
		...
	@overload
	def VertexSet(self,Vertex:FBVertex,Index:int=-1,/)->bool:
		"""Set a vertex.

		### Parameters:
			- Vertex: Vertex values used to set vertex.
			- Index: Index of vertex to affect (default=-1).

		### Returns:
		true if successful."""
		...
	@overload
	def VertexSet(self,x:float,y:float,z:float,Index:int=-1,/)->bool:
		"""Set a vertex.

		### Parameters:
			- x: X coordinate to set.
			- y: Y coordinate to set.
			- z: Z coordinate to set.
			- Index: Index of vertex to set(default=-1).

		### Returns:
		true if successful."""
		...
	def VertexSetSelected(self,Index:int,State:bool,/)->bool:
		"""Set the selected state of a vertex.

		### Parameters:
			- Index: The index of the vertex
			- State: The true to selected, false to deselect

		### Returns:
		true if the vertex is selected, false if not"""
		...
	def VertexSetVisible(self,Index:int,State:bool,/)->bool:
		"""Set the visible state of a vertex.

		### Parameters:
			- Index: The index of the vertex
			- State: true to be visible

		### Returns:
		true if the vertex is visible, false if not"""
		...
	def VertexUVGet(self,Index:int,/)->FBUV:
		"""Get a UV coordinate.

		### Parameters:
			- Index: Index of Vertex to get UV coordinate for(default=-1).

		### Returns:
		UV coordinate of vertex at UVSetIndex."""
		...
	@overload
	def VertexUVSet(self,UV:FBUV,Index:int=-1,/)->bool:
		"""Set a UV coordinate.

		### Parameters:
			- UV: UV coordinate to set.
			- Index: Index of Vertex to affect with UV coordinate(default=-1).

		### Returns:
		true if successful."""
		...
	@overload
	def VertexUVSet(self,U:float,V:float,Index:int=-1,/)->bool:
		"""Set a UV coordinate.

		### Parameters:
			- U: U coordinate to set.
			- V: V coordinate to set.
			- Index: Index of Vertex to affect with UV coordinate(default=-1).

		### Returns:
		true if successful."""
		...
class FBHUDManager(FBComponent):
	DefaultHUD:FBHUD
	"""Read Write Property: Specifies the HUD to be displayed on cameras that do not have HUD explicitly assigned."""
	def __init__(self):...
class FBMesh(FBGeometry):
	"""Mesh class.

	[See samples: GeometryInstancing.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_geometry_0c_geometry_instancing_8py-example.html) [VertexArrayManipulation.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_geometry_0c_vertex_array_manipulation_8py-example.html) [VertexColor.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_geometry_0c_vertex_color_8py-example.html)"""
	def ComputeVertexNormals(self,CW:bool=False,/)->None:
		"""Compute Mesh Vertex Normal.

		### Parameters:
			- CW: **True** for clock wise normal, otherwise for counter-clock wise"""
		...
	def InverseNormal(self)->None:
		"""Inverse Normal."""
		...
	def IsTriangleMesh(self)->bool:
		"""Determines if the mesh is composed entirely of triangles.

		### Returns:
		true if all polygons are triangles, false otherwise"""
		...
	def PolygonBegin(self,MaterialId:int=0,/)->int:
		"""Begin Polygon definition.

		### Parameters:
			- MaterialId: Index of material for this polygon. Only effective when MaterialMappingMode is kFBGeometryMapping_BY_POLYGON mode.

		### Returns:
		Number of existing polygons in Mesh"""
		...
	def PolygonCount(self)->int:
		"""Get number of polygons in mesh.

		### Returns:
		Number of polygons in mesh."""
		...
	def PolygonEnd(self)->int:
		"""End Polygon definition.

		Clean up and associate vertices internally.
		### Returns:
		Current number of polygons.
		### Note:
		MoBu expect each polygon to contain at least 3 vertices, the behavior is undefined if user add less than 3 vertices polygon."""
		...
	def PolygonListAdd(self,PolygonSize:int,IndexArraySize:int,IndexArray:list,MaterialId:int=0,/)->bool:
		"""Add Polygon List Must be called in-between [FBGeometry::GeometryBegin()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_geometry.html#a137880b95679600966415dc2f6cf3916 "Begin geometry editing.") / [GeometryEnd()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_geometry.html#a1128c32125a8b7347c4990462a8d86cf "End geometry editing.") It's user's responsibility to make sure to input valid index values, otherwise afterwards behavior will be undefined.

		### Parameters:
			- PolygonSize: Size of polygon, 3 mean triangle, 4 for quadrilateral, and so on. minimum input value is 3.
			- IndexArraySize: Size of pIndexArray, Added polygon count is floor(max(pIndexArraySize, 0) / pPolygonSize)
			- IndexArray: Index array of triangle strip.
			- MaterialId: Index of material for this polygon. Only effective when MaterialMappingMode is kFBGeometryMapping_BY_POLYGON mode.

		### Note:
		The indexes' value in input pIndexArray won't be validated, and the behavior is undefined if out of range."""
		...
	def PolygonMaterialIdGet(self,Index:int=-1,/)->int:
		"""Get a Material ID for the given Polygon index.

		### Parameters:
			- Index: Polygon's index to get material ID at (default=-1).

		### Returns:
		ID of material of vertex at pIndex."""
		...
	def PolygonVertexAdd(self,Vertex:int,/)->bool:
		"""Add a vertex.

		### Parameters:
			- Vertex: Index in mesh of vertex to add to polygon, must be in range of [0, ControlPointCount)

		### Returns:
		true if successful."""
		...
	def PolygonVertexArrayGet(self)->list:
		"""Get the array of polygon vertex (i.e.

		index to control points). This array is a concatenation of the list of polygon vertices of all the polygons. Example: a mesh made of 2 triangles [1,2,3] and [2,3,4] results in [1,2,3,2,3,4]. The first polygon starts at position 0 and the second at position 3.
		### Parameters:
			- ArraySize: Polygon vertex array size.

		### Returns:
		Readonly polygon vertex array."""
		...
	def PolygonVertexCount(self,PolygonIndex:int,/)->int:
		"""Get Polygon vertex count.

		### Parameters:
			- PolygonIndex: Index of polygon to get vertex count from.

		### Returns:
		Number of vertices in polygon at pPolygonIndex."""
		...
	def PolygonVertexIndex(self,PolygonIndex:int,VertexPolygonIndex:int,/)->int:
		"""Get global (for the mesh) index of a vertex from a polygon.

		### Parameters:
			- PolygonIndex: Index of polygon in question.
			- VertexPolygonIndex: Polygon vertex index.

		### Returns:
		Index in mesh of vertex."""
		...
	def TriangleListAdd(self,IndexArraySize:int,IndexArray:list,MaterialId:int=0,/)->bool:
		"""Add Triangle List, Must be called in-between [FBGeometry::GeometryBegin()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_geometry.html#a137880b95679600966415dc2f6cf3916 "Begin geometry editing.") / [GeometryEnd()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_geometry.html#a1128c32125a8b7347c4990462a8d86cf "End geometry editing.") It's user's responsibility to make sure to input valid index values, otherwise afterwards behavior will be undefined.

		### Parameters:
			- IndexArraySize: Size of pIndexArray, Added triangle count is floor(max(pIndexArraySize, 0) / 3)
			- IndexArray: Index array of triangle list.
			- MaterialId: Index of material for this polygon. Only effective when MaterialMappingMode is kFBGeometryMapping_BY_POLYGON mode.

		### Note:
		The indexes' value in input pIndexArray won't be validated, and the behavior is undefined if out of range."""
		...
	def TriangleStripAdd(self,IndexArraySize:int,IndexArray:list,MaterialId:int=0,/)->bool:
		"""Add Triangle Strip Must be called in-between [FBGeometry::GeometryBegin()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_geometry.html#a137880b95679600966415dc2f6cf3916 "Begin geometry editing.") / [GeometryEnd()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_geometry.html#a1128c32125a8b7347c4990462a8d86cf "End geometry editing.") It's user's responsibility to make sure to input valid index values, otherwise afterwards behavior will be undefined.

		### Parameters:
			- IndexArraySize: Size of pIndexArray, Added triangle count is max(pIndexArraySize - 2, 0)
			- IndexArray: Index array of triangle strip.
			- MaterialId: Index of material for this polygon. Only effective when MaterialMappingMode is kFBGeometryMapping_BY_POLYGON mode.

		### Note:
		The indexes' value in input pIndexArray won't be validated, and the behavior is undefined if out of range."""
		...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of Mesh."""
		...
class FBImage(FBComponent):
	"""Image class.

	Utility class used to load and get manipulate image data from disk or memory.

	[See sample: VideoMemory.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_video_0c_video_memory_8py-example.html)"""
	Depth:int
	"""Read Write Property: Color depth of the image."""
	Format:FBImageFormat
	"""Read Write Property: Image data format."""
	Height:int
	"""Read Write Property: Height of the image in pixels."""
	InterleaveType:FBImageInterleaveType
	"""Read Only Property: Image interleave type. Only meaningful if image type is field."""
	InterpolationType:FBImageInterpolationType
	"""Read Only Property: Image interpolation type."""
	Type:FBImageType
	"""Read Only Property: Image type, refering to either frame or field."""
	Width:int
	"""Read Write Property: Width of the image in pixels."""
	def Cleanup(self)->None:
		"""Cleanup image data, making it black."""
		...
	def ConvertFormat(self,NewFormat:FBImageFormat,/)->bool:
		"""Convert the image data format to another format.

		### Parameters:
			- NewFormat: The new format to convert the image to.

		### Returns:
		Return true if the convert was successful."""
		...
	def ConvertSize(self,Width:int,Height:int,/)->bool:
		"""Convert the image size.

		### Parameters:
			- Width: New width of the image.
			- Height: New height of the image.

		### Returns:
		Return true if the convert was successful."""
		...
	def GetBufferAddress(self)->int:
		"""Access image data buffer, allow modifications.

		### Returns:
		Pointer to the image data, values ranging from 0 to 255."""
		...
	def Init(self,Format:FBImageFormat,Width:int,Height:int,/)->bool:
		"""Init.

		### Parameters:
			- Format: Image format used to initialize data buffer.
			- Width: Image width in pixels.
			- Height: Image height in pixels."""
		...
	def IsCompressedTif(self,FileName:str,/)->bool:
		"""Query TIF file about its compressed status.

		### Parameters:
			- FileName: Full TIF file path name of the file to query.

		### Returns:
		Return true if the TIF file image data is compressed."""
		...
	def VerticalFlip(self)->None:
		"""Flip the image vertically."""
		...
	def WriteToTif(self,FileName:str,Comments:str,Compressed:bool,/)->bool:
		"""Write image data to a TIF file on disk.

		### Parameters:
			- FileName: Full TIF file path name of the file to write.
			- Comments: Comments appended to the TIF file.
			- Compressed: If true, the image data in the file will be compressed.

		### Returns:
		Return true if the image was successfully written on disk."""
		...
	def __init__(self,FileName:str,/):
		"""### Parameters:
			- FileName: Path to the image file. If pObject is not NULL, pFileName will be ignored."""
		...
class FBKeyControl(FBComponent):
	"""Key control.

	Interface to use the key controls tool.

	[See sample: MirrorPoseOverTime.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_mirror_pose_over_time_8py-example.html)"""
	AutoKey:bool
	"""Read Write Property: Enable/Disable Auto Key feature (key when moving 3D objects)."""
	NewKeyInterpolationType:FBNewKeyInterpolationType
	"""Read Write Property: Current key interpolation type that will be used for new keys."""
	def MoveKeys(self,TimeSpan:FBTimeSpan,Pivot:FBModel,T:FBVector3d,R:FBVector3d,S:FBVector3d,Time:FBTime,ModelList:FBModelList|None=None,/)->None:
		"""Move animation keys in space, with respect to a pivot object.

		Equivalent to using the "Move Keys" button in the Key Controls panel. Only keys that are part of the current animation layer will get affected.
		### Parameters:
			- TimeSpan: The time span in which the animation keys will be modified
			- Pivot: The pivot object to use as a reference. The pivot needs to be part of pModelList (or the current keying group) otherwise the move keys operation will abort
			- T: The global translation to apply to the pivot
			- R: The global Euler rotation to apply to the pivot (deg)
			- S: The global scaling factors to apply to the pivot
			- Time: The time at which the transformation values are applied to the pivot object
			- ModelList: List of models for which the animation will be modified. Optional parameter. If not supplied, the models in the current keying group will be used"""
		...
	def __init__(self):...
class FBKeyingGroup(FBComponent):
	"""KeyingGroup class.

	This class is an interface to manipulate which properties will be keyed when active. A derived class could control when the keying group should activate and what content it should have. For example, a derived class could activate based one that is selected in the scene.To create a custom keying group, use the appropriate [FBKeyingGroupType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_keying_group_type.html "Keying group types.") flag. Then, if it is a local keying group, call [AddObjectDependency()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_keying_group.html#ae5e7be8f49baf7327ad90d5252144c88 "AddObjectDependency An object dependency is the content of a keying group and will activate keying gr...") to add an object to the keying group. You can then add properties belonging to the new object with [AddProperty()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_keying_group.html#affac1578227f9f95c8112bbb37785300 "Add property to be keyed when current keying group is active.").If you are creating an object type keying group, call [SetObjectType()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_keying_group.html#a33974cdb85e3a5dd1e08b76a54122afe "Set the object type filter for and object type keying group.") to specify what kind of object will be keyed by this keying group. Then, add a property from an object, the name of the property will be used by the keying group the find corresponding properties in selected object.If you create a global keying group, simply properties from an object with [AddProperty()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_keying_group.html#affac1578227f9f95c8112bbb37785300 "Add property to be keyed when current keying group is active."). The name of the property will be used by the keying group to find corresponding properties in the selected object."""
	def AddObjectDependency(self,Obj:FBComponent,/)->None:
		"""AddObjectDependency An object dependency is the content of a keying group and will activate keying group when selected (activation only works if the keying group is a character extension).

		### Parameters:
			- Obj: a Dependency of the keying group."""
		...
	def AddProperty(self,Prop:FBProperty,/)->None:
		"""Add property to be keyed when current keying group is active.

		### Parameters:
			- Prop: Property to be added."""
		...
	def ClearAllItems(self)->None:
		"""ClearAllItems clear object dependency, properties and child keying group."""
		...
	@staticmethod
	def DeselectAllAnimatableProperties()->None:
		"""FBDeselectAllAnimatableProperties, deselect all animatable properties in the scene."""
		...
	def FindPropertyIndex(self,Prop:FBProperty,/)->int:
		"""FindPropertyIndex.

		### Parameters:
			- Prop: must be in the list (return -1 if not).

		### Returns:
		the index of pProp in the keyinggroup property list."""
		...
	def GetCumulativeProperty(self,Index:int,StopAtVisible:bool,/)->FBProperty:
		"""GetCumulativeProperty Same as GetSubKeyingGroup but recursive in child keying group.

		### Parameters:
			- Index: index in the content Object Dependency list
			- StopAtVisible: consider all keying group and stop to the first visible keying group.

		### Returns:
		he number of ObjectDependency of the keying group."""
		...
	def GetCumulativePropertyCount(self,StopAtVisible:bool=False,/)->int:
		"""GetCumulativePropertyCount Same as GetSubKeyingGroupCount but recursive in child keying group.

		### Parameters:
			- StopAtVisible: consider all keying group and stop to the first visible keying group.

		### Returns:
		he number of ObjectDependency of the keying group."""
		...
	def GetParentKeyingGroup(self,Index:int,/)->FBKeyingGroup:
		"""GetParentKeyingGroup.

		### Parameters:
			- Index: is the index of the parent list of the current keying group.

		### Returns:
		the parent keying group."""
		...
	def GetParentKeyingGroupCount(self)->int:
		"""GetParentKeyingGroupCount.

		### Returns:
		the number of parent."""
		...
	def GetProperty(self,Index:int,/)->FBProperty:
		"""GetProperty from the keyinggroup list.

		### Parameters:
			- Index: index of the desired property.

		### Returns:
		property coresponding to pIndex."""
		...
	def GetPropertyCount(self)->int:
		"""GetPropertyCount.

		### Returns:
		the number of properties in the keying group."""
		...
	def GetSubKeyingGroup(self,Index:int,/)->FBKeyingGroup:
		"""GetSubKeyingGroup.

		### Parameters:
			- Index: index of the desired keying group child.

		### Returns:
		the the child at the index."""
		...
	def GetSubKeyingGroupCount(self)->int:
		"""GetSubKeyingGroupCount.

		### Returns:
		the number of child keying group."""
		...
	def GetSubObject(self,Index:int,/)->FBComponent:
		"""GetSubObject.

		### Parameters:
			- Index: index in the content Object Dependency list

		### Returns:
		the desired object at pIndex."""
		...
	def GetSubObjectCount(self)->int:
		"""GetSubObjectCount.

		### Returns:
		the number of ObjectDependency of the keying group."""
		...
	def IsObjectDependency(self,Obj:FBComponent,/)->bool:
		"""IsObjectDependency determine if the pObj is a dependency.

		### Parameters:
			- Obj: an object to test the Dependency.

		### Returns:
		true if it depend."""
		...
	def IsObjectDependencySelected(self)->bool:
		"""IsObjectDependencySelected.

		### Returns:
		return true as soon as a Property Owner or another Object Dependency is selected."""
		...
	def RemoveAllObjectDependency(self)->None:
		"""IsObjectDependencySelected empty the content list."""
		...
	def RemoveAllProperties(self)->None:
		"""IsObjectDependencySelected empty the property list."""
		...
	def RemoveAllSubKeyingGroup(self)->None:
		"""RemoveAllSubKeyingGroup empty the child keying group."""
		...
	def RemoveObjectDependency(self,Obj:FBComponent,/)->None:
		"""RemoveObjectDependency An object dependency is the content of a keying group and will activate keying group when selected (activation only works if the keying group is a character extension).

		### Parameters:
			- Obj: a Dependency of the keying group."""
		...
	def RemoveProperty(self,Prop:FBProperty,/)->None:
		"""RemoveProperty from the keyinggroup list.

		### Parameters:
			- Prop: Property to be removed."""
		...
	def SetActive(self,Active:bool,/)->None:
		"""SetActive, activate the keying group, replacing the other keying group."""
		...
	def SetActiveAppend(self,Active:bool,/)->None:
		"""SetActiveAppend, activate and append the keying group to the other keying groups."""
		...
	def SetEnabled(self,Enable:bool,/)->None:
		"""SetEnabled, makes the keying group available in keying group list of the key control UI."""
		...
	def SetObjectType(self,Object:FBComponent,/)->None:
		"""Set the object type filter for and object type keying group.

		### Parameters:
			- Object: Object that will be used to set the keying group object type. Use NULL to remove the filter."""
		...
	def __init__(self,Name:str,Type:FBKeyingGroupType,/):
		"""### Parameters:
			- Name: Group name.
			- Type: Keying group type."""
		...
class FBLogger(FBComponent):
	def DisableClear(self)->None:...
	def DumpObject(self,arg2:FBPlug,arg3,/)->Any:...
	@overload
	def Enable(self,arg2,arg3,/)->bool:...
	@overload
	def Enable(self,arg2:str,arg3,/)->bool:...
	def GetLog(self)->Any:...
	def __init__(self):...
class FBCharacterExtension(FBKeyingGroup):
	"""Objects Grouping class.

	This class is an interface to manipulate object's grouping in the scene.

	[See sample: CreateCharacterExtensionOnSelectedObject.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_create_character_extension_on_selected_object_8py-example.html)"""
	IncludePartInBodyPart:bool
	"""Read Write Property: Include or not this extension when the Body Part mode is active."""
	IncludePartInFullBody:bool
	"""Read Write Property: Include or not this extension when the Full Body mode is active."""
	Label:str
	"""Read Write Property: The logical name of the extension, use for mirroring."""
	MirrorLabel:int
	"""Read Write Property: Enum that indicate which extension is used as mirror, 0 is none, 1 is self, 2-n represent the (ith - 2)character extension in the attached character excluding self."""
	PlotAllowed:FBPlotAllowed
	"""Read Write Property: Controls if objects in the set are transformable."""
	ReferenceModel:FBModel
	"""Read Write Property: Controls the referential of the extension."""
	RetargetMode:FBCharacterExtensionRetargetMode
	"""Read Write Property: Character extension retarget mode."""
	StancePoseMode:FBCharacterExtensionStancePoseMode
	"""Read Write Property: Character extension stance pose mode."""
	SyncActivationAndVisibilityMode:FBSyncActivationAndVisibilityMode
	"""Read Write Property: The "Sync Activation & Visibility" mode."""
	def AddObjectProperties(self,Obj:FBComponent,/)->None:
		"""Add TR Properties from Object.

		### Parameters:
			- Obj: Object to add TR properties."""
		...
	def GetCharacter(self)->FBCharacter:
		"""Return the attached Character.

		### Returns:
		attached Character."""
		...
	def GetExtensionObjectWithLabelName(self,LabelName:str,/)->FBComponent:
		"""Find stored object based on label name.

		### Parameters:
			- LabelName: The label name.

		### Returns:
		The extension object."""
		...
	def GetLabelNameWithExtensionObject(self,arg2:FBComponent,arg3,/)->str:
		"""Find the label name that was used to store object pose.

		### Parameters:
			- LabelName: The label name that was used to store object pose.
			- Obj: The extension object.
			- ReturnObjectNameIfNotFound: If the value is true, if the object is not found, pLabelName will be set to the object name; otherwise pLabelName will be set to empty string. By default the value is false."""
		...
	def GetMirrorExtension(self)->FBCharacterExtension:
		"""Return the character extension determined by MirrorLabel.

		### Returns:
		character extension determined by MirrorLabel."""
		...
	def GetRetargetPropertyCount(self)->int:
		"""Return the total number of retarget properties.

		### Returns:
		The total number of retarget properties."""
		...
	def GetRetargetReferenceProperty(self,PropIndex:int,/)->FBProperty:
		"""Return the reference property of the given index.

		### Parameters:
			- PropIndex: Index to query.

		### Returns:
		Reference property of the given index."""
		...
	def GetRetargetSourceProperty(self,PropIndex:int,/)->FBProperty:
		"""Return the source property of the given index (the source property is the property that drives the reference property during retargeting).

		### Parameters:
			- PropIndex: Index to query.

		### Returns:
		Source property (the property that drives the reference property during retargeting) of the given index."""
		...
	def GetSourceExtension(self)->FBCharacterExtension:
		"""Return the character extension that is used to drive this extension during retargeting.

		### Returns:
		The character extension that is used to drive this extension during retargeting."""
		...
	def GetSourceExtensionIndex(self)->int:
		"""Return the enum that indicate which extension is used as a source during retargeting, 0 is none, 1-n represent the (ith - 1)character extension in the source character.

		### Returns:
		The enum that indicate which extension is used as a source during retargeting, 0 is none, 1-n represent the (ith - 1)character extension in the source character."""
		...
	def GetStancePose(self)->FBObjectPose:
		"""Return stance pose.

		### Returns:
		stance pose."""
		...
	def GoToStancePose(self)->None:
		"""Reset object position to the stance."""
		...
	def IsElementSelected(self)->bool:
		"""Return true if one object in object dependency list is selected.

		### Returns:
		true if one object in object dependency list is selected."""
		...
	def IsPropertyIncluded(self,Prop:FBProperty,/)->bool:
		"""Return true if the property is in character extension.

		### Parameters:
			- Prop: Property to check.

		### Returns:
		true if the property is in character extension."""
		...
	def RemoveObjectAndProperties(self,Obj:FBComponent,/)->None:
		"""Remove TR Properties from Object.

		### Parameters:
			- Obj: Object to remove TR properties."""
		...
	def RemoveRetargetSourceProperty(self,PropIndex:int,/)->None:
		"""Remove the source property for retargeting.

		Only applicable if RetargetMode is Manually Assign.
		### Parameters:
			- PropIndex: Index to remove.

		### Remarks:
		Only applicable if RetargetMode is Manually Assign."""
		...
	def SetRetargetSourceProperty(self,PropIndex:int,SourceProp:FBProperty,/)->None:
		"""Set the source property for retargeting.

		Only applicable if RetargetMode is Manually Assign.
		### Parameters:
			- PropIndex: Index to set.
			- SourceProp: Source property to set.

		### Remarks:
		Only applicable if RetargetMode is Manually Assign."""
		...
	def SetSourceExtension(self,SourceExtension:FBCharacterExtension,/)->None:
		"""Set the character extension to drive this extension during retargeting.

		Only applicable if RetargetMode is Assign.
		### Parameters:
			- SourceExtension: The source extension to drive this extension during retargeting.

		### Remarks:
		Only applicable if RetargetMode is Assign."""
		...
	def SetSourceExtensionIndex(self,SrcExtIndex:int,/)->None:
		"""Set the enum that indicate which extension is used as a source during retargeting, 0 is none, 1-n represent the (ith - 1)character extension in the source character.

		Only applicable if RetargetMode is Manually Assign.
		### Parameters:
			- SrcExtIndex: Enum that indicate which extension is used as a source during retargeting, 0 is none, 1-n represent the (ith - 1)character extension in the source character.

		### Remarks:
		Only applicable if RetargetMode is Manually Assign."""
		...
	def UpdateStancePose(self)->None:
		"""Update the stance pose to the current position of the character extension element."""
		...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Group name."""
		...
class FBManipulator(FBComponent):
	"""Manipulator class."""
	Active:bool
	"""Read Write Property: Is manipulator active?"""
	AlwaysActive:bool
	"""Read Write Property: Is manipulator always active?"""
	ConsumeEvent:bool
	"""Read Write Property: Is manipulator consuming event? If true, this will prevent other manipulators from being called."""
	DefaultBehavior:bool
	"""Read Write Property: Using default manipulator behavior?"""
	ViewerText:str
	"""Read Write Property: Text displayed in view."""
	Visible:bool
	"""Read Write Property: Is manipulator visible?"""
class FBMarkerSet(FBComponent):
	"""Marker set class.

	These classes are under development and may change dramatically between versions."""
	def AddMarker(self,NodeId:FBSkeletonNodeId,Model:FBModel|None=None,IsOriented:bool=False,/)->int:
		"""Add a marker to the marker set.

		### Parameters:
			- NodeId: Id of Actor skeleton node. For hand, use the "C" index (ex:kFBSkeletonLeftThumbCIndex, kFBSkeletonLeftMiddleCIndex...)
			- Model: The model to be associated with the marker (Optional).
			- IsOriented: Set marker to be oriented or not (Optional).

		### Returns:
		Index of the new marker."""
		...
	def BeginTransaction(self)->None:
		"""Specify that you are about to call a group of functions.

		### Remarks:
		This is used to speed up operations, the UI won't be refreshed until [EndTransaction()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_marker_set.html#aa9174b2a947fb2febe9bcbf8aec05637 "Specify that you are done calling a group of functions.") is called."""
		...
	def EndTransaction(self)->None:
		"""Specify that you are done calling a group of functions.

		### Remarks:
		This is used to speed up operations, the UI won't be refreshed until [EndTransaction()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_marker_set.html#aa9174b2a947fb2febe9bcbf8aec05637 "Specify that you are done calling a group of functions.") is called."""
		...
	def GetLinkToModelOk(self)->bool:
		"""Get the marker set association correctness.

		### Returns:
		True if all used markers are link with models."""
		...
	def GetMarkerCount(self,NodeId:FBSkeletonNodeId=FBSkeletonNodeId.kFBSkeletonInvalidIndex,/)->int:
		"""Get the number of marker in the set.

		### Parameters:
			- NodeId: If specified, obtain the number of marker for the specific node.

		### Returns:
		Total number of marker."""
		...
	def GetMarkerModel(self,NodeId:FBSkeletonNodeId,MarkerIndex:int,/)->FBModel:
		"""Get the model associated with a marker.

		### Parameters:
			- NodeId: Id of Actor skeleton node.
			- MarkerIndex: Index of marker.

		### Returns:
		The model associated with the marker."""
		...
	def GetMarkerName(self,NodeId:FBSkeletonNodeId,MarkerIndex:int,/)->str:
		"""Get the name of marker at index pMarkerIndex.

		### Parameters:
			- NodeId: Id of Actor skeleton node.
			- MarkerIndex: Index of marker to access.

		### Returns:
		Name of marker at index pMarkerIndex."""
		...
	def GetMarkerOriented(self,NodeId:FBSkeletonNodeId,MarkerIndex:int,/)->bool:
		"""Is marker orientated ?

		### Parameters:
			- NodeId: Id of Actor body node.
			- MarkerIndex: Index of marker to access.

		### Returns:
		True if marker is oriented, false otherwise."""
		...
	def GetMarkerROffset(self,NodeId:FBSkeletonNodeId,MarkerIndex:int,ROffset:FBVector3d,/)->None:
		"""Get/Set a marker rotation.

		### Parameters:
			- NodeId: Id of Actor skeleton node.
			- MarkerIndex: Index of marker to access.
			- ROffset: Current or new value of the marker rotation."""
		...
	def GetMarkerSetVisibility(self)->int:
		"""Get the marker set visibility.

		### Returns:
		1 if all markers are visible, 2 if some are visible, 0 if none are visible."""
		...
	def GetMarkerTOffset(self,NodeId:FBSkeletonNodeId,MarkerIndex:int,TOffset:FBVector3d,/)->None:
		"""Get/Set a marker translation.

		### Parameters:
			- NodeId: Id of Actor skeleton node.
			- MarkerIndex: Index of marker to access.
			- TOffset: Current or new value of the marker translation."""
		...
	def GetMarkerUsed(self,NodeId:FBSkeletonNodeId,MarkerIndex:int,/)->bool:
		"""Is marker used ?

		### Parameters:
			- NodeId: Id of Actor skeleton node.
			- MarkerIndex: Index of marker to access.

		### Returns:
		True if marker is used, false otherwise."""
		...
	def GetReferenceModel(self)->FBModel:
		"""Get the reference model associated with this marker set.

		### Returns:
		The reference model associated with the marker set."""
		...
	def GetUsedMarkerCount(self,NodeId:FBSkeletonNodeId=FBSkeletonNodeId.kFBSkeletonInvalidIndex,/)->int:
		"""Get the number of used marker in the set.

		### Parameters:
			- NodeId: If specified, obtain the number of used marker for the specific node.

		### Returns:
		Total number of used marker."""
		...
	def SetMarkerModel(self,NodeId:FBSkeletonNodeId,MarkerIndex:int,Model:FBModel,/)->None:
		"""Associate a model to a marker.

		### Parameters:
			- NodeId: Id of Actor skeleton node.
			- MarkerIndex: Index of marker.
			- Model: Model to be associated to the marker."""
		...
	def SetMarkerName(self,NodeId:FBSkeletonNodeId,MarkerIndex:int,MarkerName:str,/)->None:
		"""Set the name of marker at index pMarkerIndex.

		### Parameters:
			- NodeId: Id of Actor skeleton node.
			- MarkerIndex: Index of marker to access.
			- MarkerName: New name to give to the marker."""
		...
	def SetMarkerOriented(self,NodeId:FBSkeletonNodeId,MarkerIndex:int,IsOriented:bool,/)->None:
		"""Set marker to be oriented or not.

		### Parameters:
			- NodeId: Id of Actor skeleton node.
			- MarkerIndex: Index of marker to access.
			- IsOriented: Oriented or not."""
		...
	def SetMarkerROffset(self,NodeId:FBSkeletonNodeId,MarkerIndex:int,ROffset:FBVector3d,/)->None:...
	def SetMarkerSetVisibility(self,Visibility:bool,/)->None:
		"""Set the marker set visibility.

		### Parameters:
			- Visibility: True will make to markers visible, false will hide them."""
		...
	def SetMarkerTOffset(self,NodeId:FBSkeletonNodeId,MarkerIndex:int,TOffset:FBVector3d,/)->None:...
	def SetMarkerUsed(self,NodeId:FBSkeletonNodeId,MarkerIndex:int,Used:bool,/)->None:
		"""Set marker to be used or not.

		### Parameters:
			- NodeId: Id of Actor skeleton node.
			- MarkerIndex: Index of marker to access.
			- Used: Used or not."""
		...
	def SetMultipleMarkerModels(self,ModelList:FBModelList,/)->bool:
		"""Associate multiple models to markers, matching them by name.

		### Parameters:
			- ModelList: A list of models to be matched with marker names.

		### Returns:
		True if at least one marker was matched."""
		...
	def SetReferenceModel(self,ReferenceModel:FBModel,/)->None:
		"""Associate a model to a marker.

		### Parameters:
			- ReferenceModel: Model to be associated to the marker."""
		...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of new marker set."""
		...
class FBMenuManager(FBComponent):
	"""The menu manager allows access to MotionBuilder menu bar.

	It can be used to retrieve the item corresponding to a menu path in the menu bar. A menu path is similar to a file path but it specifies the location of menu item in a hierarchy of menu. ex: to retrieve the item corresponding to MoBu Save item: item = menuMgr.GetMenu("File/Save")Other menu items in MoBu menu bar include the following: "File", "Edit","Animation","Window","Settings", "Layout","Help"The menu manager can be used to insert new menu item in the menubar. You have to specify the menu path at which to insert the menu (to insert a new root menu, use NULL or None as the menu path)

	```python
	#Insert a new Root Menu before the Help menu
	menuMgr.InsertBefore(None, "Help", "before menu")

	#Insert a new Root Menu after the Help menu
	menuMgr.InsertAfter(None, "Help", "After menu")
	```
	As a convenience operation, you can from the menu manager enable and disable menu item (instead of retrieving their corresponding item).

	[See sample: FBMenu.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_f_b_menu_8py-example.html)"""
	def ExecuteMenuItem(self,MenuPath:str,MenuItemID:int,/)->bool:
		"""Execute a particular menu item.

		The menu path specifies the menu containing the menu item to execute. The ID specifies which menu item to execute in the menu.
		### Parameters:
			- MenuPath: Path containing the menu item to execute.
			- MenuItemID: Unique ID of the menu item to execute.

		### Returns:
		True if the menu item has been executed, false otherwise. It could returns false if the menu item cannot be found or if the menu item is found but is disabled or is a separator."""
		...
	def ExecuteMenuItemFromFullPath(self,MenuItemFullPath:str,/)->bool:
		"""Execute a particular menu item.

		The menu path specifies the menu item (NOT menu) to execute. Don't forget that most menu path already in MotionBuilder have a "&" as the first letter of their name. You have to use the "/" character as a separator in the specified menu path (ex: "Settings/&Preferences..."), and exactly what is written in the menu item (ex: "Edit/D&eselect\\tShift+D").

		```python
		# This example shows how to display the About Box, as if the user opened it via the main menu Help > About MotionBuilder:
		menuManager = FBMenuManager()
		aboutBoxFullPath = "Help/&About MotionBuilder"
		menuManager.ExecuteMenuItemFromFullPath( aboutBoxFullPath )
		```
		### Parameters:
			- MenuItemFullPath: Path of the menu item to execute.

		### Returns:
		True if the menu item has been executed, false otherwise. It could returns false if the menu item cannot be found or if the menu item is found but is disabled or is a separator."""
		...
	def GetMenu(self,Path:str,/)->FBGenericMenu:
		"""Get the Menu (NOT menu item) corresponding to a menu path.

		Don't forget that most menu path already in MotionBuilder have a "&" character as the first letter of their name. You have to use the "/" character as a separator in the specified menu path (ex: "Help/&Communities").
		### Parameters:
			- Path: Path of the menu to retrieve

		### Returns:
		the [FBGenericMenu](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_generic_menu.html "A GenericMenu class.") at this path./"""
		...
	def InsertAfter(self,MenuPath:str|None,BeforeMenuName:str,MenuName:str,/)->FBGenericMenuItem:
		"""Insert a new menu at a specific path AFTER another item.

		### Parameters:
			- MenuPath: Path where to insert the menu. If this is NULL (None) it will insert a new root menu.
			- BeforeMenuName: Name of the menu item AFTER which we will insert the new item.

		### Returns:
		Returns the menu item corresponding to the newly inserted menu."""
		...
	def InsertBefore(self,MenuPath:str|None,AfterMenuName:str,MenuName:str,/)->FBGenericMenuItem:
		"""Insert a new menu at a specific path BEFORE another item.

		### Parameters:
			- MenuPath: Path where to insert the menu. If this is NULL (None) it will insert a new root menu.
			- AfterMenuName: Name of the menu item BEFORE which we will insert the new item.

		### Returns:
		Returns the menu item corresponding to the newly inserted menu."""
		...
	def InsertFirst(self,MenuPath:str|None,MenuName:str,/)->FBGenericMenuItem:
		"""Insert a new menu at the first position of a specific path.

		### Parameters:
			- MenuPath: Path where to insert the menu. If this is NULL (None) it will insert a new root menu.
			- MenuName: Name (Caption) of the newly inserted menu.

		### Returns:
		Returns the menu item corresponding to the newly inserted menu."""
		...
	def InsertLast(self,MenuPath:str|None,MenuName:str,/)->FBGenericMenuItem:
		"""Insert a new menu at the last position of a specific path.

		### Parameters:
			- MenuPath: Path where to insert the menu. If this is NULL (None) it will insert a new root menu.
			- MenuName: Name (Caption) of the newly inserted menu.

		### Returns:
		Returns the menu item corresponding to the newly inserted menu."""
		...
	def IsItemEnable(self,MenuPath:str,ItemId:int,/)->bool:
		"""Check if a particular item is enabled or disabled.

		The menu path specifies the menu where we find the item to be enabled/disabled. The Id specifies which item in the menu.
		### Parameters:
			- MenuPath: Path where to find the menu to check
			- ItemId: Id of the item to check.

		### Returns:
		Is the item enable or not."""
		...
	def SetItemEnable(self,MenuPath:str,ItemId:int,Enable:bool,/)->None:
		"""Enable or disable a specific menu item.

		The menu path specifies the menu where we find the item to be enabled/disabled. The Id specifies which item in the menu.
		### Parameters:
			- MenuPath: Path where to find the menu to enable/disable
			- ItemId: Id of the item in the menu to disable.
			- Enable: Enable (true) or disable (false) a menu item."""
		...
	def __init__(self):
		"""There is only one MenuManager in MotionBuilder, creating multiple [FBMenuManager](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_menu_manager.html "The menu manager allows access to MotionBuilder menu bar.") always return the same handle to the same global menu manager."""
		...
class FBModelOpticalAdvanced(FBComponent):
	"""Advanced optical model information."""
	Active:bool
	"""Property: Optical engine for model active?"""
	AutoPlayToNextSegment:bool
	"""Property: Automatic play to next segment ?"""
	ControllerMode:FBControllerMode
	"""Property: Controller mode."""
	GenerationMode:FBGenerationMode
	"""Property: Optical genration mode."""
	InsertSegmentMode:FBInsertSegmentMode
	"""Property: Insert segment mode."""
	MaxMatchDistance:float
	"""Property: Max matching distance."""
	PlayToNextSegment:bool
	"""Property: Play to next segment ?"""
	Quality:FBAnimationNode
	"""Property: Rigid body quality."""
	SegmentMode:FBSegmentMode
	"""Property: Segment mode."""
	ShowRigidQuality:bool
	"""Property: Show the rigid quality?"""
	UsedTake:FBTake
	"""Property: Take used by optical model."""
	def AcceptAllSegments(self)->None:
		"""Accept all segments."""
		...
	def AcceptSegment(self)->None:
		"""Accept current segment."""
		...
	def AutomaticBuild(self)->None:
		"""Automatic build."""
		...
	def CropSegmentsAnimation(self)->None:
		"""Crop segment animation."""
		...
	def SkipSegment(self)->None:
		"""Skip segment."""
		...
	def __init__(self,Optical:FBModelOptical,/):
		"""### Parameters:
			- Optical: Optical model."""
		...
class FBModelTemplate(FBComponent):
	"""Model template class.

	Model templates are 'placeholders' for animation input from devices. These generic 'models' can be any type of element, and permit the abstraction of the input from the actual type of model. In order to animate a model, one should bind the model to an animation node."""
	Bindings:FBPropertyListModelTemplateBinding
	"""List: Bindings for animation interface."""
	Children:FBPropertyListModelTemplate
	"""List: Children for object hierarchy."""
	DefaultRotation:FBVector3d
	"""Read Write Property: Default rotation."""
	DefaultScaling:FBVector3d
	"""Read Write Property: Default scaling."""
	DefaultTranslation:FBVector3d
	"""Read Write Property: Default translation."""
	Model:FBModel
	"""Read Write Property: Model being interfaced."""
	Prefix:str
	"""Read Write Property: Prefix of model template."""
class FBModelVertexData(FBComponent):
	def DisableOGLUVSet(self)->None:
		"""Disable OpenGL UV set array."""
		...
	def DisableOGLVertexData(self)->None:
		"""Disable OpenGL Vertex Array (Pos & Normal)."""
		...
	def DrawSubPatch(self,SubPatchIndex:int,WireFrame:bool=False,/)->None:
		"""Draw the specified sub patch.

		Must be called between Enable/DisableOGLVertexData function calls.
		### Parameters:
			- SubPatchIndex: Index of the sub patch to be drawn.
			- WireFrame: Draw wire frame if true."""
		...
	def DrawSubRegion(self,SubRegionIndex:int,WireFrame:bool=False,/)->None:
		"""Draw the specified sub region.

		Must be called between Enable/DisableOGLVertexData function calls.
		### Parameters:
			- SubRegionIndex: Index of the sub region to be drawn.
			- WireFrame: Draw wire frame if true."""
		...
	def EnableOGLUVSet(self,TextureMapping:FBTextureMapping=FBTextureMapping.kFBTextureMappingUV,UVSet:str|None=None,/)->None:
		"""Enable (Setup) OpenGL UV set array.

		### Parameters:
			- TextureMapping: Texture Mapping Mode.
			- UVSet: UV Set name if pTextureMapping is kFBTextureMappingUV, otherwise ignored."""
		...
	def EnableOGLVertexData(self,AfterDeform:bool=True,/)->None:
		"""Enable (Setup) OpenGL Vertex Array (Pos & Normal).

		### Parameters:
			- AfterDeform: Unused parameter."""
		...
	def GetIndexArray(self)->list:
		"""Return the index array.

		For the size of the array, see [GetIndexArraySize()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model_vertex_data.html#ad396db9f24aa2ebb4e5eed8aa613281e "Return the index array size (see GetIndexArray()).").
		### Returns:
		(C++) The index array pointer. (Python) The index array as a list."""
		...
	def GetIndexArraySize(self)->int:
		"""Return the index array size (see [GetIndexArray()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model_vertex_data.html#ac0ede519b86e20e84f439aa4a8f150c9 "Return the index array.")).

		It will sum the index size of each sub patch (see [GetSubPatchIndexSize()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model_vertex_data.html#a3d6bf9721c1049b4b0b73d9d1a9cb790 "Return the size of the indexes for the specified sub patch (see GetIndexArray()).")).
		### Returns:
		The index array size."""
		...
	def GetIndexArrayVBOId(self)->int:
		"""Return the index array VBO Id.

		### Returns:
		The index array VBO Id."""
		...
	def GetSubPatchCount(self)->int:
		"""Return the number of sub patches.

		### Returns:
		The number of sub patches."""
		...
	def GetSubPatchIndexOffset(self,SubPatchIndex:int,/)->int:
		"""Return the start offset of the indexes for the specified sub patch (see [GetIndexArray()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model_vertex_data.html#ac0ede519b86e20e84f439aa4a8f150c9 "Return the index array.")).

		### Parameters:
			- SubPatchIndex: Index of the sub patch to be queried.

		### Returns:
		The start offset of the indexes for the specified sub patch, -1 if the specific sub path index is invalid."""
		...
	def GetSubPatchIndexSize(self,SubPatchIndex:int,/)->int:
		"""Return the size of the indexes for the specified sub patch (see [GetIndexArray()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model_vertex_data.html#ac0ede519b86e20e84f439aa4a8f150c9 "Return the index array.")).

		### Parameters:
			- SubPatchIndex: Index of the sub patch to be queried.

		### Returns:
		The size of the indexes for the specified sub patch, -1 if the specific sub path index is invalid."""
		...
	def GetSubPatchMaterial(self,SubPatchIndex:int,/)->FBMaterial:
		"""Return the mapped material for the specified sub patch.

		### Parameters:
			- SubPatchIndex: Index of the sub patch to be queried.

		### Returns:
		The mapped material for the specified sub patch, the default material if the specific sub path index is invalid."""
		...
	def GetSubPatchMaterialId(self,SubPatchIndex:int,/)->int:
		"""Return the mapped material ID for the specified sub patch.

		### Parameters:
			- SubPatchIndex: Index of the sub patch to be queried.

		### Returns:
		The mapped material ID for the specified sub patch, -1 if the specific sub path index is invalid."""
		...
	def GetSubPatchPrimitiveType(self,arg2,/)->tuple:
		"""Return the primitive type for the specified sub patch.

		Most of the time, kFBGeometry_TRIANGLES will be returned.
		### Parameters:
			- SubPatchIndex: Index of the sub patch to be queried.
			- IsOptimized: (C++ only) Out parameter, return true if the specified sub patch is optimized for fast rendering, custom shader & render should use the optimized sub patch only.

		### Returns:
		(C++) The primitive type of the queried sub patch. (Python) A tuple with 2 values: (the primitive type of the queried sub patch, the value of pIsOptimized)."""
		...
	def GetSubRegionCount(self)->int:
		"""Return the number of sub regions (mapping with different materials).

		### Returns:
		The number of sub regions."""
		...
	def GetSubRegionMaterial(self,SubRegionIndex:int,/)->FBMaterial:
		"""Return the specified sub region's material.

		### Parameters:
			- SubRegionIndex: Index of the sub region to be queried.

		### Returns:
		The sub region's material, the default material if the specific sub region index is invalid."""
		...
	def GetUVSetArray(self,TextureMapping:FBTextureMapping=FBTextureMapping.kFBTextureMappingUV,UVSet:str|None=None,/)->list:
		"""Return the UV Set array for the specified texture mapping mode.

		### Parameters:
			- TextureMapping: Texture mapping mode to be queried.
			- UVSet: UV Set name to be queried if pTextureMapping is kFBTextureMappingUV, otherwise ignored.

		### Returns:
		(C++) The UV Set array pointer. (Python) The UV Set array as a list.
		```c++
		// The following C++ snippet show how to deal with the UV mapping UV Set array pointer returned.
		void* lUVSetArray = lModelVertexData.GetUVSetArray();
		if( lUVSetArray )
		{
		 int lUVArrayCount = lModelVertexData->GetUVSetUVCount();

		 FBGeometryArrayElementType lArrayType = lModelVertexData->GetUVSetArrayFormat( kFBTextureMappingUV );
		 if( lArrayType == kFBGeometryArrayElementType_Float2 )
			{
				FBUV* lUVArray = (FBUV*)lUVSetArray;

		 for( int i = 0; i < lUVArrayCount; i++ )
				{
		 // Do something useful here
		 FBTrace( "%f, %f\\n", lUVArray[ i ][ 0 ], lUVArray[ i ][ 1 ] );
				}
			}
		}
		```"""
		...
	def GetUVSetArrayFormat(self,TextureMapping:FBTextureMapping=FBTextureMapping.kFBTextureMappingUV,UVSet:str|None=None,/)->FBGeometryArrayElementType:
		"""Return the UV Set array format.

		### Parameters:
			- TextureMapping: Unused parameter.
			- UVSet: Unused parameter.

		### Returns:
		The UV Set array format."""
		...
	def GetUVSetUVCount(self,TextureMapping:FBTextureMapping=FBTextureMapping.kFBTextureMappingUV,UVSet:str|None=None,/)->int:
		"""Return the number of UVs in the UV Set for the specified texture mapping mode.

		### Parameters:
			- TextureMapping: Texture mapping mode to be queried.
			- UVSet: UV Set name to be queried if pTextureMapping is kFBTextureMappingUV, otherwise ignored.

		### Returns:
		The number of UVs in the UV Set for the specified texture mapping mode."""
		...
	def GetUVSetVBOId(self,TextureMapping:FBTextureMapping=FBTextureMapping.kFBTextureMappingUV,UVSet:str|None=None,/)->int:
		"""Return the UV Set Buffer Object (VBO) Id for the specified texture mapping mode.

		### Parameters:
			- TextureMapping: Texture mapping mode to be queried.
			- UVSet: UV Set name to be queried if pTextureMapping is kFBTextureMappingUV, otherwise ignored.

		### Returns:
		The UV Set VBO Id."""
		...
	def GetUVSetVBOOffset(self,TextureMapping:FBTextureMapping=FBTextureMapping.kFBTextureMappingUV,UVSet:str|None=None,/)->int:
		"""Return the UV Set Buffer Object (VBO) offset for the specified texture mapping mode.

		### Parameters:
			- TextureMapping: Texture mapping mode to be queried.
			- UVSet: UV Set name to be queried if pTextureMapping is kFBTextureMappingUV, otherwise ignored.

		### Returns:
		The UV Set VBO offset (C++: as a pointer, Python: as a kReference)."""
		...
	def GetVertexArray(self,ArrayId:FBGeometryArrayID,AfterDeform:bool=True,/)->list:
		"""Return the vertex array for the specified vertex array Id.

		### Parameters:
			- ArrayId: Vertex array Id type to be queried.
			- AfterDeform: True to query the deformed position or normal vertex array (model must be deformable and deformation must occur in CPU), false to query the original vertex array.

		### Returns:
		(C++) The vertex array pointer. (Python) The vertex array as a list. Deformed position & normal vertex arrays could be NULL if one has not requested the mapping vertex array on CPU.
		### Note:
		Use [VertexArrayMappingRequest()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model_vertex_data.html#ad98d06b4eb79ec2b2218f03be0b13469 "Request deformed vertex array mapping on CPU.") to toggle CPU / GPU skinning per model when necessary.
		```c++
		// The following C++ snippet show how to deal with the Point vertex array pointer returned.
		void* lVertexArray = lModelVertexData.GetVertexArray();
		if( lVertexArray )
		{
		 int lVertexArrayCount = lModelVertexData->GetVertexCount();

		 FBGeometryArrayElementType lArrayType = lModelVertexData->GetVertexArrayType( kFBGeometryArrayID_Point );
		 if( lArrayType == kFBGeometryArrayElementType_Float4 )
			{
				FBVector4<float>* lVertexArrayFloat4 = (FBVector4<float>*)lVertexArray;

		 for( int i = 0; i < lVertexArrayCount; i++ )
				{
		 // Do something useful here
		 FBTrace( "%f, %f, %f, %f\\n", lVertexArrayFloat4[ i ][ 0 ], lVertexArrayFloat4[ i ][ 1 ], lVertexArrayFloat4[ i ][ 2 ], lVertexArrayFloat4[ i ][ 3 ] );
				}
			}
		}
		```"""
		...
	def GetVertexArrayDuplicationMap(self)->list:
		"""The FBModel::TessellatedMesh could contain per-face mapping UVSet/Normal or other layer elements.

		In order to build a valid VBO buffer for accelerated rendering, those control points with multiple attribute data must be duplicated. This function returns the duplicated vertices' ID mapping from [FBModel::ModelVertexData](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model.html#a7526d77469f5aac1a496c9cafa2aaf1a "Read Only Property: ModelVertexData for the model.") vertex array to its FBModel::TessellatedMesh vertex array. Note those duplicated vertices are always appended after the original vertex array.
		### Parameters:
			- DuplicatedVertexCount: only) pDuplicatedVertexCount Out parameter, return the count of those duplicated vertices.

		### Returns:
		(C++) A pointer to the original vertex ID mapping for those duplicated vertices. (Python) A list containing the vertex ID mapping for those duplicated vertices."""
		...
	def GetVertexArrayType(self,ArrayId:FBGeometryArrayID,AfterDeform:bool=True,/)->FBGeometryArrayElementType:
		"""Return the vertex array format for the specified array Id.

		### Parameters:
			- ArrayId: Vertex array Id type to be queried.
			- AfterDeform: Unused parameter.

		### Returns:
		The vertex array format for the specified array Id.
		### Note:
		Use [VertexArrayMappingRequest()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model_vertex_data.html#ad98d06b4eb79ec2b2218f03be0b13469 "Request deformed vertex array mapping on CPU.") to toggle CPU / GPU skinning per model when necessary."""
		...
	def GetVertexArrayVBOId(self,ArrayId:FBGeometryArrayID,AfterDeform:bool=True,/)->int:
		"""Return the Vertex Buffer Object (VBO) Id for the specified vertex array Id.

		### Parameters:
			- ArrayId: Vertex array Id type to be queried.
			- AfterDeform: True to query the deformed position or normal vertex array (model must be deformable and deformation must occur in CPU), false to query the original vertex array.

		### Returns:
		The vertex array VBO Id. Deformed position & normal vertex VBO Id could be 0 if model use CPU skinning.
		### Note:
		Use [VertexArrayMappingRequest()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model_vertex_data.html#ad98d06b4eb79ec2b2218f03be0b13469 "Request deformed vertex array mapping on CPU.") to toggle CPU / GPU skinning per model when necessary."""
		...
	def GetVertexArrayVBOOffset(self,ArrayId:FBGeometryArrayID,AfterDeform:bool=True,/)->int:
		"""Return the Vertex Buffer Object (VBO) offset for the specified vertex array Id.

		### Parameters:
			- ArrayId: Vertex array Id type to be queried. Only position or normal vertex array Id types are available.
			- AfterDeform: True to query the deformed position or normal vertex array (model must be deformable and deformation must occur in CPU), false to query the original vertex array.

		### Returns:
		The vertex array VBO offset (C++: as a pointer, Python: as a kReference).
		### Note:
		Use [VertexArrayMappingRequest()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model_vertex_data.html#ad98d06b4eb79ec2b2218f03be0b13469 "Request deformed vertex array mapping on CPU.") to toggle CPU / GPU skinning per model when necessary."""
		...
	def GetVertexCount(self)->int:
		"""Return the number of vertices.

		### Returns:
		The number of vertices."""
		...
	def IsDeformable(self)->bool:
		"""Return true if the model is deformable.

		### Returns:
		True if the model is deformable, false otherwise."""
		...
	def IsDrawable(self)->bool:
		"""Queries if this model should be drawn, e.g., in custom render callback.

		Returns false if e.g., deformed vertex data has not been computed for this frame (thus not ready to be drawn), or if model should be hidden when Z-Depth selection tool is active.
		### Returns:
		True if the model should be drawn, false otherwise."""
		...
	def PopZDepthClipOverride(self)->None:
		"""Re-enables Z-Depth clip plane if it had been disabled via [PushZDepthClipOverride()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model_vertex_data.html#a478fa49bf444e972b3dfaa483207a89b "Disables Z-Depth clip plane if this model is selected using Z-Depth HideFront selection tool.").

		Call this function after drawing each model in custom render callback, so that Z-Depth clip plane is re-enabled if it was earlier disabled via [PushZDepthClipOverride()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model_vertex_data.html#a478fa49bf444e972b3dfaa483207a89b "Disables Z-Depth clip plane if this model is selected using Z-Depth HideFront selection tool.")."""
		...
	def PushZDepthClipOverride(self)->None:
		"""Disables Z-Depth clip plane if this model is selected using Z-Depth HideFront selection tool.

		Call this function before drawing each model in custom render callback, so that the selected model is unaffected by the Z-Depth clip plane, and hence is visible when Z-Depth HideFront selection tool is active. Be sure to call [PopZDepthClipOverride()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model_vertex_data.html#a5fefcc913f7ea12d5d3107a2b3356e62 "Re-enables Z-Depth clip plane if it had been disabled via PushZDepthClipOverride().") after drawing each model."""
		...
	def VertexArrayMappingRelease(self)->None:
		"""Release deformed vertex array mapping on CPU.

		Call this function if plug-in don't need CPU access of the deformed vertex array to be mapped on CPU memory anymore, hence allow the application flexibility to choose higher performance approach."""
		...
	def VertexArrayMappingRequest(self)->None:
		"""Request deformed vertex array mapping on CPU.

		Model's deformation computation could be executed on GPU, and thus the deformed vertex data will reside in GPU memory only by default. Calling this function [VertexArrayMappingRequest()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model_vertex_data.html#ad98d06b4eb79ec2b2218f03be0b13469 "Request deformed vertex array mapping on CPU.") will ensure the deformed vertex array to be always mapped to CPU memory.
		### Note:
		: This function should be called at least once before GetVertexArray(pArrayId, true) to give engine chance to process request properly."""
		...
class FBMotionClip(FBComponent):
	"""Motion class.

	Properties of this class are work in progress, but you can still list them and get their names."""
	Filename:str
	"""Read Write Property: Filename and path of motion file."""
	RelativePath:str
	"""Read Only Property: Relative path to the motion file."""
	Start:FBTime
	"""Read Only Property: Start time of clip."""
	Stop:FBTime
	"""Read Only Property: Stop time of clip."""
	def __init__(self,FileName:str,/):
		"""### Parameters:
			- FileName: The complete file path of the media file to access."""
		...
class FBMotionFileOptions(FBComponent):
	"""Customize motion file loading."""
	BaseRotationOnPreRotation:bool
	"""Read Write Property: If set to true, the base rotation will be imported as Pre Rotation. Used for htr, asf/amc files."""
	BaseTranslationOnRotationOffset:bool
	"""Read Write Property: If set to true, the base translation will be imported as Rotation Pivot offset. Used for htr, asf/amc"""
	CreateInsteadOfMerge:bool
	"""Read Write Property: If set to true, the motion will imported/models will be created in the scene, if set to false, the motion will be merged."""
	CreateOpticalSegments:bool
	"""Read Write Property: If set to true, optical segments will be created. Used for trc, c3d files."""
	CreateReferenceNode:bool
	"""Settings based on file type."""
	CreateUnmatchedModels:bool
	"""Read Write Property: If set to true, nodes will be created to match the hierarchical structure of the imported file."""
	CreateUnusedOpticalSegments:bool
	"""Read Write Property: If set to true, unused optical segments will be created. Used for trc, c3d files."""
	IgnoreModelType:bool
	"""Read Write Property: If set to true, model type will not be considered when finding a matching model in the scene."""
	ImportDOF:bool
	"""Read Write Property: If set to true, the DOF value will be imported from the file."""
	ImportScaling:bool
	"""Read Write Property: If set to true, scaling values will be imported."""
	KeepActorPrefix:bool
	"""Read Write Property: If set to true, the Actor prefix will be kept when naming each optical marker. Used with c3d files."""
	KeepDummyNode:bool
	"""Read Write Property: If set to true, dummy bones from the file are not removed. Used for asf/amc files."""
	ModelSelection:FBModelSelection
	"""Common settings when merging, unused with the CreateInsteadOfMerge property is set to true."""
	SetLimits:bool
	"""Read Write Property: If set to true, use motion limits. Used for asf/amc files."""
	SetOccludedToLastValidPosition:bool
	"""Read Write Property: If set to true, occluded segments will be set to their last valid position. Used for trc, c3d files."""
	TakeStartEnd:FBTakeSpanOnLoad
	"""Read Write Property: Indicates how the start/end value of the take will be modified."""
	UpAxisUsedInFile:FBUpAxis
	"""Read Write Property: Indicated the up axis used in the motion file. Only effective when loading c3d files."""
	def GetTakeCount(self)->int:
		"""Return the take count in the file to be loaded.

		### Returns:
		Take count
		### Warning:
		You need to use an appropriate constructor with the file path to be able to get the take information."""
		...
	def GetTakeName(self,TakeIndex:int,/)->str:
		"""Get the take name.

		### Parameters:
			- TakeIndex: Index of take to get the name.

		### Returns:
		Take name"""
		...
	def GetTakeSamples(self,TakeIndex:int,/)->int:
		"""Return the number of samples.

		### Parameters:
			- TakeIndex: Index of take to get the samples count.

		### Returns:
		Number of samples"""
		...
	def GetTakeSamplingRate(self,TakeIndex:int,/)->float:
		"""Return the actual sampling rate as a double, useful when you have a custom sampling rate.

		### Parameters:
			- TakeIndex: Index of take to get the sampling rate

		### Returns:
		Sample rate"""
		...
	def GetTakeSamplingRateMode(self,TakeIndex:int,/)->FBTimeMode:
		"""Return the sampling rate mode.

		### Parameters:
			- TakeIndex: Index of take to get the sampling rate mode

		### Returns:
		Sample rate mode
		### Remarks:
		Use GetTakeSamplingRate if you have a custom sampling rate to get the actual rate."""
		...
	def GetTakeSelect(self,TakeIndex:int,/)->bool:
		"""Return true if the take will be loaded.

		### Parameters:
			- TakeIndex: Index of take.

		### Returns:
		True is the take will be loaded"""
		...
	def GetTakeStart(self,TakeIndex:int,/)->FBTime:
		"""Return the Take Start time.

		### Parameters:
			- TakeIndex: Index of take to get the start time.

		### Returns:
		Start time of the take"""
		...
	def GetTakeStop(self,TakeIndex:int,/)->FBTime:
		"""Return the Take Stop time.

		### Parameters:
			- TakeIndex: Index of take to get the stop time.

		### Returns:
		Stop time of the take"""
		...
	def SetTakeName(self,TakeIndex:int,Name:str,/)->None:
		"""Set the take name.

		### Parameters:
			- TakeIndex: Index of take to set.
			- Name: Take name to set"""
		...
	def SetTakeSamples(self,TakeIndex:int,SamplesCount:int,/)->None:
		"""Set the number of samples for a particular take.

		### Parameters:
			- TakeIndex: Index of take to set.
			- SamplesCount: Number of samples

		### Remarks:
		Must be set to a value bigger than 0 and smaller than the number of samples in the file. The stop time of the motion will be changed based on the new samples count."""
		...
	def SetTakeSamplingRate(self,TakeIndex:int,TimeMode:FBTimeMode,CustomSamplingRate:float=30.0,/)->None:
		"""Set the sampling rate for a particular take.

		### Parameters:
			- TakeIndex: Index of take to set.
			- TimeMode: Time mode to set.
			- CustomSamplingRate: Custom sampling rate if pTimeMode is set to kFBTimeModeCustom, unused otherwise (default is 30.0)

		### Remarks:
		Changing the sampling rate will change the stop time of the motion."""
		...
	def SetTakeSelect(self,TakeIndex:int,Select:bool,/)->None:
		"""Indicate if the take will be loaded.

		### Parameters:
			- TakeIndex: Index of take to set.
			- Select: Set to true if the take should be loaded."""
		...
	def SetTakeStart(self,TakeIndex:int,StartTime:FBTime,/)->None:
		"""Set the Take Start time.

		### Parameters:
			- TakeIndex: Index of take to set.
			- StartTime: Time of the first frame of the take

		### Remarks:
		Changing the start time of the take will also change the stop time, since the duration is constant. Please change the samples count to change the length of the motion."""
		...
	def SetTakeStop(self,TakeIndex:int,StopTime:FBTime,/)->None:
		"""Set the Take Stop time.

		### Parameters:
			- TakeIndex: Index of take to set.
			- StopTime: Time of the last frame of the take

		### Remarks:
		Changing the stop time of the take will also change the start time, since the duration is constant. Please change the samples count to change the length of the motion."""
		...
	def __init__(self,StringList:FBStringList,/):
		"""Create a [FBMotionFileOptions](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_motion_file_options.html "Customize motion file loading.") to be used when importing a motion file. Pass file paths to get the appropriate information about those files, modify the options and then call the file import process. Not all options are usable at the same time, some of them are for specific motion type. You can see the valid configuration by looking at the motion file dialog (accessible from File/Motion File Import...).
		### Parameters:
			- StringList: The client needs to pass a list of files path to load to collect the motion file information."""
		...
class FBNamespace(FBComponent):
	"""Objects Containing class.

	This class is an interface to manipulate object's containing in the scene."""
	ChildrenNamespaces:FBPropertyListNamespace
	"""List: Direct Children Namespace Objects."""
	ContentCount:int
	ContentLocked:bool
	"""Read Write Property: Content locking state."""
	def GetContent(self,Index:int,/)->FBComponent:
		"""Get the namespace content object count (Not Recursive).

		### Parameters:
			- Index: content object index to query. return content object inside this namespace (not recursive)"""
		...
	def GetContentCount(self)->int:
		"""Get the namespace content objects count (Not Recursive).

		return content objects count inside this namespace (not recursive)"""
		...
	def GetContentList(self,ContentList:FBComponentList,ModificationFlags:FBPlugModificationFlag=FBPlugModificationFlag.kFBPlugAllContent,Recursive:bool=True,TypeInfo:int=FBPlug.TypeInfo,ExactTypeMatch:bool=False,/)->None:
		"""Get List of the namespace content.

		### Parameters:
			- ContentList: the list of content to return.
			- ModificationFlags: bitwise combination of kFBConnectionSrcObjectModified, kFBConnectionDstObjectModified, kFBConnectionSrcPropertyModified, kFBConnectionDstPropertyModified flags. kFBAllContent means all the content.
			- Recursive: **True** only work on the direct children level namespace, otherwise will work on the whole children namespace hierarchy recursively.
			- TypeInfo: the typeInfo of the type of interested object, 0 for all the objects.
			- ExactTypeMatch: if **True**, the derived typeInfo won't be considered (For example, [FBCamera](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_camera.html "Creates custom cameras and manages system cameras.") won't be considered when passing [FBModel::TypeInfo](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html#a9b39fba51413fa925a0d94d2feb13bf9 "Contains the Type information of the object."))."""
		...
	def __init__(self,SingleLevelNamespace:str,ParentNSObj:FBNamespace|None,/):
		"""Create a new direct children namespace object
		### Parameters:
			- SingleLevelNamespace: [FBNamespace](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_namespace.html "Objects Containing class.") name. This name will be used as namespace itself. this name string shouldn't contain namespace string separator ":".
			- ParentNSObj: the parent namespace object. if NULl means to create top level namespace."""
		...
class FBOpticalGap(FBComponent):
	"""Optical Gap class."""
	Data:FBAnimationNode
	"""Property: Gap curve data."""
	Interpolation:FBGapMode
	"""Property: Gap mode."""
	TimeSpan:FBTimeSpan
	"""Property: Current timespan."""
	def InsertControlKey(self,Time:FBTime,/)->None:
		"""Insert a control key for the gap.

		### Parameters:
			- Time: Insert time for the control key."""
		...
	def IsValid(self)->bool:
		"""Check if valid (if item exists).

		### Returns:
		true if segment is valid."""
		...
	def __init__(self,Marker:FBModelMarkerOptical,/):
		"""### Parameters:
			- Marker: Model marker(default=NULL)."""
		...
class FBFileReference(FBNamespace):
	"""Objects Containing class.

	This class is an interface to manipulate object's containing in the scene.

	[See sample: MBFileRefDemo.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_referencing_0c_m_b_file_ref_demo_8py-example.html)"""
	IsLoaded:bool
	"""Read Write Property:  File Reference Load/Unload."""
	ReferenceFilePath:str
	"""Read Write Property:  File Reference file path."""
	def ApplyRefEditPyScriptFromFile(self,RefEditPyScriptFilePath:str,/)->None:
		"""Apply specified reference edits from python script file.

		### Parameters:
			- RefEditPyScriptFilePath: Reference edits Python script file path."""
		...
	def ApplyRefEditPyScriptFromString(self,RefEditPyScript:str,/)->None:
		"""Apply specified reference edits from Python script string.

		### Parameters:
			- RefEditPyScript: Reference edits Python script."""
		...
	def BakeRefEditToFile(self,FilePath:str,/)->bool:
		"""Save the current status of the referenced content back to disk.

		If pFilePath is ReferenceFilePath, we're saving all the modification back to the original referenced file. Otherwise, we will export the referenced file plus modification to another file.
		### Parameters:
			- FilePath: File path to export.

		### Returns:
		true if successful."""
		...
	def ClearAllRefEdit(self)->bool:
		"""Clear all cached Ref edit.

		### Returns:
		True if the RefEdits are cleared properly."""
		...
	def ClearRefEdit(self,FilePath:str,/)->bool:
		"""Clear the cached RefEdit for the given ref file path.

		### Parameters:
			- FilePath: The Ref File Path to query against, default to be current Ref File.

		### Returns:
		True if the RefEdit for the given Ref File Path is cached and cleared properly."""
		...
	def DuplicateFileRef(self,DstNameSpaceList:FBStringList,WithRefEdit:bool=False,/)->bool:
		"""Duplicate/Clone the FileRef object and its referenced content (with/without refEdit).

		### Parameters:
			- DstNameSpaceList: the list of target new namespace(s) for duplication. These new namespace(s) must be residing in editable scene segments.
			- WithRefEdit: false by default, duplication won't include the existing ref edit. otherwise ref edit will be applied on the instantiated FileRef in someway.

		### Returns:
		true if successful, false is fail."""
		...
	def GetRefEdit(self,FilePath:str|None=None,/)->str:
		"""Return the RefEdit for given RefFile Path.

		### Parameters:
			- FilePath: The Ref File Path to query against, default to be current Ref File.

		### Returns:
		RefEdit as string"""
		...
	def GetRefFileList(self,RefFileList:FBStringList,/)->None:
		"""Return a list of ref file path which has cached Ref Edit.

		### Parameters:
			- RefFileList: the output parameter to collect the Ref File Path."""
		...
	def RevertRefEdit(self,Plug:FBPlug|None=None,ModificationFlag:FBPlugModificationFlag=FBPlugModificationFlag.kFBAllModifiedMask,/)->None:
		"""Revert the modification on the referenced object/property to original state.

		### Parameters:
			- Plug: the plug to revert, revert all if NULL.
			- ModificationFlag: the modification type to revert."""
		...
	def SwapReferenceFilePath(self,FilePath:str,ApplyAvailableRefEdit:bool,MergeCurrentRefEdit:bool,/)->bool:
		"""Swap the Ref File Path and apply ref edit.

		### Parameters:
			- FilePath: The new Ref File path to be used
			- ApplyAvailableRefEdit: Apply the cached Ref Edit (if exist) for the Ref File to be used if **True**.
			- MergeCurrentRefEdit: Merge the current RefEdit to if **True** if the reference items' name are matching.

		### Returns:
		True if swap successfully."""
		...
	def __init__(self,SingleLevelNamespace:str,ParentNSObj:FBNamespace,/):
		"""Create a new direct children FileReference object
		### Parameters:
			- SingleLevelNamespace: FileReference name. This name will be used as namespace itself. this name string shouldn't contain namespace string separator ":".
			- ParentNSObj: the parent namespace object. if NULl means to create top level namespace."""
		...
class FBOpticalSegment(FBComponent):
	"""Optical segment class."""
	Data:FBAnimationNode
	"""Property: Segment curve data."""
	Marker:FBModelMarkerOptical
	"""Property: Optical marker."""
	MarkerTimeSpan:FBTimeSpan
	"""Property: Marker/Segment timespan."""
	OriginalTimeSpan:FBTimeSpan
	"""Property: Original timespan for segment."""
	TimeSpan:FBTimeSpan
	"""Property: Current segment timespan."""
	Used:bool
	"""Property: Is segment used?"""
	def Cut(self,Time:FBTime,/)->None:
		"""Cut the segment for the marker at a given time.

		### Parameters:
			- Time: Time to cut segment at."""
		...
	def IsValid(self)->bool:
		"""Check if valid (if item exists).

		### Returns:
		true if segment is valid."""
		...
	def Reset(self)->None:
		"""Reset the marker segment."""
		...
	def __init__(self,Optical:FBModelOptical,/):
		"""### Parameters:
			- Optical: Optical model(default=NULL)."""
		...
class FBPlayerControl(FBComponent):
	"""Player control.

	Interface to use the transport controls (play, stop, etc.) The following Python snippet shows its basic playback operation

	```python
	lPlayer = FBPlayerControl()
	lPlayer.GotoStart()
	lPlayer.Play()
	```
	Keys can also be set and used with [Key()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_player_control.html#a864f3bdec0a6b38a9582783f3dcc16bb "Key default data."), [GotoNextKey()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_player_control.html#a155d00c74503c66a4c1fc2b26dc85c99 "Go to the next key."), and [GotoPreviousKey()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_player_control.html#a6922c0f85114b41e53c549eccb07842d "Go to the previous key."). All actions are performed by default on the current take. The is the MotionBuilder default take, unless you have multiple takes in your scene. To switch between takes, use [FBTake](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_take.html "A take is a container for animation in a scene.").

	[See samples: ShotTrackSetupTool.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_complex_tools_0c_shot_track_setup_tool_8py-example.html) [RenderLayers.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_rendering_0c_render_layers_8py-example.html) [CameraSwitcher.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_camera_0c_camera_switcher_8py-example.html) [BloopSlate.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_h_u_d_0c_bloop_slate_8py-example.html) [RecordLight.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_h_u_d_0c_record_light_8py-example.html) [Timeline.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_h_u_d_0c_timeline_8py-example.html) [CreateProfilingEventsLog.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_profiling_0c_create_profiling_events_log_8py-example.html) [MirrorPoseOverTime.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_mirror_pose_over_time_8py-example.html) [MultiLayerKeying.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_multi_layer_keying_8py-example.html) [StartDevice.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_start_device_8py-example.html) [StopDevice.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_stop_device_8py-example.html) [TimeCodeKeying.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_time_code_keying_8py-example.html)"""
	IsPlaying:bool
	"""Read Only Property: Is the transport control playing?"""
	IsPlotting:bool
	"""Read Only Property: Is there a plotting in progress?"""
	IsRecording:bool
	"""Read Only Property: Is there a recording in progress?"""
	LoopActive:bool
	"""Read Write Property: Is looping active?"""
	LoopMode:FBTransportLoopMode
	"""Read Write Property: Loop mode."""
	LoopStart:FBTime
	"""Read Write Property: Loop begin time."""
	LoopStop:FBTime
	"""Read Write Property: Loop end time."""
	NextMarker:FBTime
	"""Read Only Property: Next marked time."""
	OnChange:callbackframework.FBEventSource[Self, FBEventPlayerControlChange]
	"""Event Property: Fired when something in the player control has changed. (see [FBEventPlayerControlChange](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_event_player_control_change.html))"""
	PlotSamplingPeriod:FBTime
	"""Read Write Property: Sampling period for the model plotting."""
	PreviousMarker:FBTime
	"""Read Only Property: Previous marked time."""
	RecordingSamplingPeriod:FBTime
	"""Read Write Property: Sampling period for the model recording."""
	SnapMode:FBTransportSnapMode
	"""Read Write Property: Set the transport control snap mode."""
	TransportTimeFormat:FBTransportTimeFormat
	"""Read Write Property: Current Time Mode of the transport controls."""
	ZoomWindowStart:FBTime
	"""Read Write Property: Starting time of the transport control zoom window."""
	ZoomWindowStop:FBTime
	"""Read Write Property: Stopping time of the transport control zoom window."""
	def AddGlobalTimeMark(self,Time:FBTime,/)->int:
		"""Add a global time mark.

		It doesn't allow creating a time mark at the same time of another time mark. Note: Internally, the global time marks are stored in time order. Adding a time mark before other existing time marks will modify the index of these other time marks.
		### Parameters:
			- Time: Time where to add the time mark.
			- Name: Name of the time mark to add.

		### Returns:
		The index of the time mark added if the operation is successful, -1 otherwise."""
		...
	def DeleteAllGlobalTimeMarks(self)->None:
		"""Delete all global time marks."""
		...
	def DeleteGlobalTimeMark(self,Index:int,/)->bool:
		"""Delete a global time mark.

		Note: Internally, the global time marks are stored in time order. Deleting a time mark will modify the index of time marks laying after the deleted time mark.
		### Parameters:
			- Index: Index of the time mark to delete.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def EvaluationPause(self)->None:
		"""Pause device evaluation thread."""
		...
	def EvaluationResume(self)->None:
		"""Resume device evaluation thread."""
		...
	def GetEditCurrentTime(self)->FBTime:
		"""Get Edit Current Time.

		### Returns:
		The current time, in the edit time referential."""
		...
	def GetEditStart(self)->FBTime:
		"""Get Edit Start.

		### Returns:
		Start value for the edit time range."""
		...
	def GetEditStop(self)->FBTime:
		"""Get Edit Stop.

		### Returns:
		Stop value for the edit time range."""
		...
	def GetEditZoomStart(self)->FBTime:
		"""Get Edit Zoom Start.

		### Returns:
		Start value for the edit zoom window."""
		...
	def GetEditZoomStop(self)->FBTime:
		"""Get Edit Zoom Stop.

		### Returns:
		Stop value for the edit zoom window."""
		...
	def GetGlobalTimeMarkAction(self,Index:int,/)->FBTimeMarkAction:
		"""Returns the action associated with a global time mark.

		### Parameters:
			- Index: Index of the time mark.

		### Returns:
		The action associated with the time mark."""
		...
	def GetGlobalTimeMarkColor(self,Index:int,/)->FBColor:
		"""Returns the color associated with a global time mark.

		### Parameters:
			- Index: Index of the time mark.

		### Returns:
		The color associated with the time mark."""
		...
	def GetGlobalTimeMarkCount(self)->int:
		"""Returns the number of global time marks.

		### Returns:
		The number of global time marks."""
		...
	def GetGlobalTimeMarkName(self,Index:int,/)->str:
		"""Returns the name associated with a global time mark.

		### Parameters:
			- Index: Index of the time mark.

		### Returns:
		The name associated with the time mark."""
		...
	def GetGlobalTimeMarkTime(self,Index:int,/)->FBTime:
		"""Returns the time associated with a global time mark.

		### Parameters:
			- Index: Index of the time mark.

		### Returns:
		The time associated with the time mark."""
		...
	def GetNextGlobalTimeMarkIndex(self)->int:
		"""Returns the next global time mark index, based on the current local time.

		### Returns:
		The next global time mark index, -1 if any next time mark is available."""
		...
	def GetPlaySpeed(self)->float:
		"""Get Play Speed .

		### Returns:
		transport current playback speed."""
		...
	def GetPlaySpeedMode(self)->FBTransportPlaySpeed:
		"""Get Play Speed Mode.

		### Returns:
		transport current playback speed mode, including kFBSpeed_Custom mode."""
		...
	def GetPreviousGlobalTimeMarkIndex(self)->int:
		"""Returns the previous global time mark index, based on the current local time.

		### Returns:
		The previous global time mark index, -1 if any previous time mark is available."""
		...
	def GetTimeReferential(self)->FBTimeReferential:
		"""Get Time Referential.

		### Returns:
		Current time referential."""
		...
	def GetTransportFps(self)->FBTimeMode:
		"""Get the UI frame rate use for display configure in the system.

		### Returns:
		current FrameRate selected for the system."""
		...
	def GetTransportFpsValue(self,TimeMode:FBTimeMode=FBTimeMode.kFBTimeModeDefault,/)->float:
		"""Get the UI frame rate value.

		### Parameters:
			- TimeMode: the time mode whose frame rate will be returned

		### Returns:
		Frame rate of the input time mode or system time mode when pTimeMode is not provided."""
		...
	def GetTransportMode(self)->FBTransportMode:
		"""Get Transport Mode.

		### Returns:
		Current mode of the transport controls."""
		...
	def Goto(self,p0:FBTime,p1:FBTimeReferential|None=None,/)->bool:
		"""Goto a time specified by pTime.

		### Parameters:
			- p0: Time to jump to.
			- p1: Time referential to use. kFBTimeReferentialAction or kFBTimeReferentialEdit

		### Returns:
		true if successful."""
		...
	def GotoEnd(self,p0:FBTimeReferential|None=None,/)->bool:
		"""GotoEnd button (FastForward).

		### Parameters:
			- p0: Time referential to use. kFBTimeReferentialAction or kFBTimeReferentialEdit

		### Returns:
		true if successful."""
		...
	def GotoNextKey(self)->None:
		"""Go to the next key."""
		...
	def GotoPreviousKey(self)->None:
		"""Go to the previous key."""
		...
	def GotoStart(self,p0:FBTimeReferential|None=None,/)->bool:
		"""GotoStart button (Rewind).

		### Parameters:
			- p0: Time referential to use. kFBTimeReferentialAction or kFBTimeReferentialEdit

		### Returns:
		true if successful."""
		...
	def IsLocked(self)->bool:
		"""Return the current locking state of the transport."""
		...
	def Key(self)->None:
		"""Key default data.

		Key all selected data."""
		...
	def LockTransport(self,Lock:bool,/)->None:
		"""Lock the transport control.

		### Parameters:
			- Lock: boolean value that indicates the new locked state of the transport."""
		...
	def Play(self,UseMarkers:bool=False,/)->bool:
		"""Play button.

		### Parameters:
			- UseMarkers: Play until next marker if true, ignore markers otherwise.

		### Returns:
		true if successful."""
		...
	def PlayReverse(self,UseMarkers:bool=False,/)->bool:
		"""Play Reverse button.

		### Parameters:
			- UseMarkers: Play until next marker if true, ignore markers otherwise.

		### Returns:
		true if successful."""
		...
	def Record(self,OverrideTake:bool=False,CopyData:bool=True,/)->bool:
		"""Begin recording.

		### Parameters:
			- OverrideTake: Write over current take?(default=false)
			- CopyData: Unused. Necessary for compatibility(default=true).

		### Returns:
		true if successful."""
		...
	def SetEditStart(self,Time:FBTime,/)->None:
		"""Set Edit Start.

		### Parameters:
			- Time: The new start value for the edit time range."""
		...
	def SetEditStop(self,Time:FBTime,/)->None:
		"""Set Edit Stop.

		### Parameters:
			- Time: The new stop value for the edit time range."""
		...
	def SetEditZoomStart(self,Time:FBTime,/)->None:
		"""Set Edit Zoom Start.

		### Parameters:
			- Time: The new start value for the edit zoom window."""
		...
	def SetEditZoomStop(self,Time:FBTime,/)->None:
		"""Set Edit Zoom Stop.

		### Parameters:
			- Time: The new stop value for the edit zoom window."""
		...
	def SetGlobalTimeMarkAction(self,Index:int,Action:FBTimeMarkAction,/)->bool:
		"""Sets a new action for an existing global time mark.

		### Parameters:
			- Index: Index of the time mark.
			- Action: The new action for the time mark.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def SetGlobalTimeMarkColor(self,Index:int,Color:FBColor,/)->bool:
		"""Sets a new color for an existing global time mark.

		### Parameters:
			- Index: Index of the time mark.
			- Color: The new color for the time mark.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def SetGlobalTimeMarkName(self,Index:int,Name:str,/)->bool:
		"""Sets a new name for an existing global time mark.

		### Parameters:
			- Index: Index of the time mark.
			- Name: The new name for the time mark.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def SetGlobalTimeMarkTime(self,Index:int,Time:FBTime,/)->int:
		"""Sets a new time for an existing global time mark.

		Note: Internally, the global time marks are stored in time order. Modifying the time of a time mark may modify the index of all time marks.
		### Parameters:
			- Index: Index of the time mark.
			- Time: The new time for the time mark.

		### Returns:
		The new index of the modified time mark."""
		...
	def SetPlaySpeed(self,Speed:float,/)->None:
		"""Set Play Speed.

		### Parameters:
			- Speed: set customized speed. It will automatically convert to one of pre-defined play speed mode if it is equal to the pre-defined speed."""
		...
	def SetPlaySpeedMode(self,PlaySpeedMode:FBTransportPlaySpeed,/)->None:
		"""Set Play Speed Mode.

		### Parameters:
			- PlaySpeedMode: a pre-defined play speed mode. Don't make sense to input kFBSpeed_Custom. To set the custom speed, use [SetPlaySpeed()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_player_control.html#a71716b808406bdac9835b31501b895d4 "Set Play Speed.") function directly."""
		...
	def SetTimeReferential(self,TimeReferential:FBTimeReferential,/)->None:
		"""Set Time Referential.

		### Parameters:
			- TimeReferential: The new time referential. Only kFBTimeReferentialAction and kFBTimeReferentialEdit are supported"""
		...
	def SetTransportFps(self,TimeMode:FBTimeMode,Custom:float=0.0,/)->None:
		"""Set the system frame rate use for display.

		### Parameters:
			- TimeMode: Indicate the frame rate value to use base on the [FBTimeMode](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_time_mode.html "Different time modes available.") values enum.(kFBTimeModeDefault will be stored in fps)
			- Custom: Should the time mode be kFBTimeModeCustom, this is used to specify the custom framerate."""
		...
	def StepBackward(self,p0:FBTimeReferential|None=None,/)->bool:
		"""Step one frame backward.

		### Parameters:
			- p0: Time referential to use. kFBTimeReferentialAction or kFBTimeReferentialEdit

		### Returns:
		true if successful."""
		...
	def StepForward(self,p0:FBTimeReferential|None=None,/)->bool:
		"""Step one frame ahead.

		### Parameters:
			- p0: Time referential to use. kFBTimeReferentialAction or kFBTimeReferentialEdit

		### Returns:
		true if successful."""
		...
	def Stop(self)->bool:
		"""Stop button.

		### Returns:
		true if successful."""
		...
	def __init__(self):...
class FBPointCacheFile(FBComponent):
	"""Base Model deformer class."""
	CacheFileName:str
	"""Read Write Property: Filename of media."""
	ChannelCount:int
	"""Read Only Property: Channel Count."""
	FreeRunning:bool
	"""Read Write Property: Free Running."""
	Loop:bool
	"""Read Write Property: Loop."""
	Offset:FBTime
	"""Read Write Property: Offset."""
	PlaySpeed:float
	"""Read Write Property: Play Speed."""
	StartTime:FBTime
	"""Read Write Property: Start Time."""
	StopTime:FBTime
	"""Read Write Property: Stop Time."""
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of Point Cache File Object."""
		...
class FBRendererCallback(FBComponent):
	"""Open Reality renderer callback interface."""
	DefaultCameraBackPlateRendering:bool
	"""Read write Property: Set true to use default camera back plate rendering; set false to disable it."""
	DefaultCameraFrontPlateRendering:bool
	"""Read write Property: Set true to use default camera front plate rendering; set false to disable it."""
	DefaultLightGroundProjectionRendering:bool
	"""Read write Property: Set true to use default light ground projection rendering; set false to disable it."""
	DefaultLightVolumeRendering:bool
	"""Read write Property: Set true to use default light volume rendering; set false to disable it."""
	SupportIDBufferPicking:bool
	"""Read write Property: Can this Renderer Callback support IDBuffer Picking."""
	def __init__(self,Name:str,/):...
class FBRigidBody(FBComponent):
	"""Rigid body class."""
	Done:bool
	"""Property: Done?"""
	Markers:FBPropertyListRigidBodyMarkers
	"""Property: List of markers composing the rigid body."""
	Mode:FBRigidBodyMode
	"""Property: Rigid body mode."""
	Model:FBModel
	"""Property: Rigid body model."""
	QualityData:FBAnimationNode
	"""Property: Quality of rigid body."""
	SmoothWidth:int
	"""Property: Smoothing width."""
	def ComputeAnimation(self)->None:
		"""Compute the rigid body animation."""
		...
	def IsValid(self)->bool:
		"""Check if valid (if item exists).

		### Returns:
		true if segment is valid."""
		...
	def Snap(self)->None:
		"""Snap the rigid body."""
		...
	def __init__(self,Optical:FBModelOptical,/):
		"""### Parameters:
			- Optical: Optical model(default=NULL)."""
		...
class FBSVector:
	"""Three dimensional scaling vector.

	[See sample: Vectors.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_math_0c_vectors_8py-example.html)"""
	@overload
	def CopyFrom(self,arg2:FBSVector,/)->FBSVector:...
	@overload
	def CopyFrom(self,arg2:list,/)->FBSVector:...
	def DotProduct(self,arg2:FBSVector,/)->float:...
	def GetList(self)->list:...
	def IsEqual(self,arg2:FBSVector,/)->bool:...
	def Length(self)->float:...
	def Normalize(self)->FBSVector:...
	def NotEqual(self,arg2:FBSVector,/)->bool:...
	def SquareLength(self)->float:...
	@overload
	def __add__(self,arg2:FBSVector,/)->FBSVector:...
	@overload
	def __add__(self,arg2,/)->FBSVector:...
	def __getitem__(self,arg2,/)->float:...
	@overload
	def __iadd__(self,arg2:FBSVector,/)->FBSVector:...
	@overload
	def __iadd__(self,arg2,/)->FBSVector:...
	@overload
	def __idiv__(self,arg2:FBSVector,/)->FBSVector:...
	@overload
	def __idiv__(self,arg2,/)->FBSVector:...
	@overload
	def __imul__(self,arg2:FBSVector,/)->FBSVector:...
	@overload
	def __imul__(self,arg2,/)->FBSVector:...
	@overload
	def __init__(self):...
	@overload
	def __init__(self,arg2:FBSVector,/):...
	@overload
	def __init__(self,p1:float,p2:float,p3:float,/):
		"""### Parameters:
			- p1: First element
			- p2: Second element.
			- p3: Third element(default=1.0)."""
		...
	@overload
	def __init__(self,Value:float,/):
		"""Constructor from array.

		### Parameters:
			- Value: Array to take values from."""
		...
	@overload
	def __init__(self,arg2:list,/):...
	@overload
	def __isub__(self,arg2:FBSVector,/)->FBSVector:...
	@overload
	def __isub__(self,arg2,/)->FBSVector:...
	def __len__(self)->int:...
	@overload
	def __mul__(self,arg2:FBSVector,/)->FBSVector:...
	@overload
	def __mul__(self,arg2,/)->FBSVector:...
	def __neg__(self)->FBSVector:...
	def __setitem__(self,arg2,arg3,/):...
	@overload
	def __sub__(self,arg2:FBSVector,/)->FBSVector:...
	@overload
	def __sub__(self,arg2,/)->FBSVector:...
	@overload
	def __truediv__(self,arg2:FBSVector,/)->FBSVector:...
	@overload
	def __truediv__(self,arg2,/)->FBSVector:...
	def __iter__(self)->Iterator[float]:...
class FBScene(FBComponent):
	"""Access to the MotionBuilder scene.

	In MotionBuilder, the scene is the environment where your models exist. The scene contains models which you can import, select, transform, copy, tweak, and animate.The [FBScene](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_scene.html "Access to the MotionBuilder scene.") object is obtained from the scene attribute of FBSystem.The [FBScene](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_scene.html "Access to the MotionBuilder scene.") class contains many attributes that you can use to access objects, e.g cameras, characters, lights, and takes, essentially everything you see in the Navigator in the UI. A project can only contain one scene, and if you try to create an instance of a scene you will get an error, so you must access the scene by getting a handle through [FBSystem](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_system.html "Provides access to the underlying system, and the MotionBuilder scene.").

	```python
	myScene = FBSystem().Scene
	```
	See also the C++ code sample in toolscene.

	[See samples: InsertCurrentTake.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_insert_current_take_8py-example.html) [DeleteUnusedMedia.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_delete_unused_media_8py-example.html) [MirrorPoseOverTime.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_mirror_pose_over_time_8py-example.html) [SelectModelsWithNameContainingSubstring.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_select_models_with_name_containing_substring_8py-example.html) [SetAllCamerasBackgroundColorFromFirstSelectedCamera.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_set_all_cameras_background_color_from_first_selected_camera_8py-example.html) [StartDevice.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_start_device_8py-example.html)"""
	ActorFaces:FBPropertyListActorFace
	"""List: ActorFaces in scene."""
	Actors:FBPropertyListActor
	"""List: Actors in scene."""
	AudioClips:FBPropertyListAudioClip
	"""List: Audio clips in scene."""
	Cameras:FBPropertyListCamera
	"""List: Cameras in scene."""
	CharacterExtensions:FBPropertyListCharacterExtension
	"""List: Character extensions available in the scene."""
	CharacterFaces:FBPropertyListCharacterFace
	"""List: Character faces in scene."""
	CharacterMarkerSets:FBPropertyListCharacterMarkerSet
	"""List: Character marker sets in scene."""
	CharacterPoses:FBPropertyListCharacterPose
	"""List: Character poses in scene."""
	Characters:FBPropertyListCharacter
	"""List: Characters in scene."""
	ConstraintSolvers:FBPropertyListConstraintSolver
	"""List: Constraint Solvers present in the scene."""
	Constraints:FBPropertyListConstraint
	"""List: Constraints in scene."""
	ControlSets:FBPropertyListControlSet
	"""List: Control set rigs in scene."""
	Deformers:FBPropertyListDeformer
	"""List: Deformers for scene."""
	Devices:FBPropertyListDevice
	"""List: Devices for scene."""
	FileReferences:FBPropertyListFileReference
	"""List: FileReference available in the scene."""
	Folders:FBPropertyListFolder
	"""List: Folders in scene."""
	Groups:FBPropertyListGroup
	"""List: Groups available in the scene."""
	HUDs:FBPropertyListHUD
	"""Read Only Property: Heads Up Displays in the scene."""
	Handles:FBPropertyListHandle
	"""List: Handles present in the scene."""
	KeyingGroups:FBPropertyListKeyingGroup
	"""Read Write Property: Keying Groups in the scene."""
	Lights:FBPropertyListLight
	"""List: Lights in scene."""
	MarkerSets:FBPropertyListMarkerSet
	"""List: Marker sets in scene."""
	Materials:FBPropertyListMaterial
	"""List: Materials for scene."""
	ModelOpticals:FBPropertyListModelOptical
	"""Read Write Property: Optical Data in the scene."""
	ModelSkeletons:FBPropertyListModelSkeleton
	"""Read Write Property: Bones (Skeletons) in the scene."""
	MotionClips:FBPropertyListMotionClip
	"""List: Motion clips in scene."""
	Namespaces:FBPropertyListNamespace
	"""List: Namespace (include FileReference) available in the scene"""
	Notes:FBPropertyListNote
	"""List: Notes in scene."""
	ObjectPoses:FBPropertyListObjectPose
	"""List: ObjectPoses in scene."""
	OnChange:callbackframework.FBEventSource[Self, FBEventSceneChange]
	"""Event: Something in the scene has happened.([FBEventSceneChange](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_event_scene_change.html "Select model event class."))"""
	OnTakeChange:callbackframework.FBEventSource[Self, FBEventTakeChange]
	"""Event: Something related to a take has happened.([FBEventTakeChange](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_event_take_change.html "Take change event class."))"""
	PhysicalProperties:FBPropertyListPhysicalProperties
	"""List: PhysicalProperties present in the scene."""
	Poses:FBPropertyListPose
	"""List: Poses in scene."""
	Renderer:FBRenderer
	"""Read Only Property: Local renderer."""
	RootModel:FBModel
	"""Read Only Property: Scene Root model for that scene"""
	Sets:FBPropertyListSet
	"""List: Sets available in the scene."""
	Shaders:FBPropertyListShader
	"""List: Shaders for scene."""
	Takes:FBPropertyListTake
	"""List: Takes for scene."""
	Textures:FBPropertyListTexture
	"""List: Textures for scene."""
	UserObjects:FBPropertyListUserObject
	"""List: User objects"""
	VideoClips:FBPropertyListVideoClip
	"""List: Video clips in scene."""
	def CandidateEvaluationAndResolve(self)->bool:
		"""Resolving the Candidate.

		### Returns:
		true if successful."""
		...
	def CleanEmptyGroups(self)->int:
		"""Remove all empty groups present in the scene.

		### Returns:
		The number of empty groups removed."""
		...
	def CleanEmptyRelationConstraints(self)->int:
		"""Remove all empty relation constraints present in the scene.

		### Returns:
		The number of empty relation constraints removed."""
		...
	def CleanEmptySets(self)->int:
		"""Remove all empty sets present in the scene.

		### Returns:
		The number of empty sets removed."""
		...
	def CleanInactiveConstraints(self)->int:
		"""Remove all inactive constraints present in the scene.

		### Returns:
		The number of inactive constraints removed."""
		...
	def CleanRelationConstraintsUnusedBoxes(self)->int:
		"""Remove all unused boxes in relations constraints present in the scene.

		### Returns:
		The number of unused boxes in relations constraints removed."""
		...
	def CleanUnusedAudioClips(self)->int:
		"""Remove all unused audio clips present in the scene.

		### Returns:
		The number of unused audio clips removed."""
		...
	def CleanUnusedMaterials(self)->int:
		"""Remove all unused materials present in the scene.

		### Returns:
		The number of unused material removed."""
		...
	def CleanUnusedShaders(self)->int:
		"""Remove all unused shaders present in the scene.

		### Returns:
		The number of unused shaders removed."""
		...
	def CleanUnusedTextures(self)->int:
		"""Remove all unused textures present in the scene.

		### Returns:
		The number of unused textures removed."""
		...
	def CleanUnusedVideoClips(self)->int:
		"""Remove all unused video clips present in the scene.

		### Returns:
		The number of unused video clips removed."""
		...
	def Clear(self)->None:
		"""Clears the elements part of the scene.

		Not those that belong to all the scenes."""
		...
	def Evaluate(self)->bool:
		"""Evaluate the scene.

		### Returns:
		true if successful.
		### Note:
		MoBu's is highly optimized for real-time performance, due to its multi-thread, double buffer and lazy-evaluation architecture, complex scripts are often required to call [FBScene::Evaluate()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_scene.html#a133019f4b3a3240f6c2f6716f6c67bf3 "Evaluate the scene.") to commit previous scene change commands before execute following operations. Also, certain operations in SDK may require cached data to be reevaluated. In typical large scenes this call may be consider as very costly. That's why user is responsible to design code in the way that requires as little as possible calls to [FBScene::Evaluate](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_scene.html#a133019f4b3a3240f6c2f6716f6c67bf3 "Evaluate the scene."). We should consider use [FBScene::Evaluate()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_scene.html#a133019f4b3a3240f6c2f6716f6c67bf3 "Evaluate the scene.") between scene change commands as "common scripting practice"""
		...
	def EvaluateDeformations(self)->bool:
		"""Evaluate the deformations of the scene.

		### Returns:
		true if successful."""
		...
	def GetScriptsPaths(self)->FBStringList:
		"""Get paths of all the python scripts object in the scene.

		### Parameters:
			- PathList: Out parameter, to collect the path of python scripts."""
		...
	def NamespaceCleanup(self)->bool:
		"""Remove all empty namespaces.

		During some namespace operations, empty namespace may left over, while this is not harmful but could be annoying. Save the scene and load it back those empty namespaces will disappear. And this function also allow user to remove all empty namespaces from the scene easily via SDK.
		### Returns:
		True if operation successfully."""
		...
	def NamespaceDelete(self,Namespace:str,/)->bool:
		"""Delete the namespace & all its content.

		### Parameters:
			- Namespace: the namespace to work on

		### Returns:
		True if operation successfully, False is this namespace doesn't exist, or is locked (by FileReferencing or etc.,)"""
		...
	def NamespaceDeleteContent(self,Namespace:str,ModificationFlags:FBPlugModificationFlag=FBPlugModificationFlag.kFBPlugAllContent,Recursive:bool=True,TypeInfo:int=FBPlug.TypeInfo,ExactTypeMatch:bool=False,/)->bool:
		"""Delete the namespace content.

		### Parameters:
			- Namespace: the namespace to work on
			- ModificationFlags: bitwise combination of kFBConnectionSrcObjectModified, kFBConnectionDstObjectModified, kFBConnectionSrcPropertyModified, kFBConnectionDstPropertyModified flags. kFBPlugAllContent means all the content. Modification flags beside kFBPlugAllContent will only work on FileReference Namespace.
			- Recursive: **True** only work on the direct children level namespace, otherwise will work on the children namespace hierarchy recursively.
			- TypeInfo: the typeInfo of the type of interested object, default for all the objects.
			- ExactTypeMatch: if **True**, the derived typeInfo won't be considered (For example, [FBCamera](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_camera.html "Creates custom cameras and manages system cameras.") won't be considered when passing [FBModel::TypeInfo](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html#a9b39fba51413fa925a0d94d2feb13bf9 "Contains the Type information of the object.")).

		### Returns:
		False is the given namespace doesn't exist, or is locked (by FileRef or etc.,), True otherwise.
		### Note:
		Not all the objects will be deletable (system objects and etc.,). Deletion of partial FileRef content isn't prevented, however the behavior is undefined."""
		...
	def NamespaceEmpty(self,Namespace:str,/)->bool:
		"""Query if namespace is empty.

		### Parameters:
			- Namespace: the namespace to query, NULL for whole scene.

		### Returns:
		True if the namespace (don't include nested children namespace) is empty"""
		...
	def NamespaceExist(self,Namespace:str,/)->bool:
		"""Query if namespace exists.

		### Parameters:
			- Namespace: the namespace to query

		### Returns:
		True if the namespace exist, otherwise return False."""
		...
	def NamespaceExport(self,Namespace:str,FilePath:str,ASCIIFormat:bool=False,/)->bool:
		"""Export scene content within namespace to file.

		### Parameters:
			- Namespace: the namespace to use, must exist
			- FilePath: the referenced file path to export.
			- ASCIIFormat: save the file in ASCII format.

		### Returns:
		True if successfully."""
		...
	def NamespaceGet(self,Namespace:str,/)->FBNamespace:
		"""Get Namespace object.

		### Parameters:
			- Namespace: the namespace to query

		### Returns:
		Namespace with exact name matching"""
		...
	def NamespaceGetChildrenList(self,NamespaceList:FBStringList,Namespace:str|None=None,Recursive:bool=True,/)->int:
		"""Get list of children namespaces in the given namespace.

		### Parameters:
			- NamespaceList: the list of namespace to return.
			- Namespace: specify the parent namespace, NULL for the whole scene.
			- Recursive: **True** only work on the direct children level namespace, otherwise will work on the whole children namespace hierarchy recursively.

		### Returns:
		the list of children namespaces."""
		...
	def NamespaceGetContentList(self,ContentList:FBComponentList,Namespace:str,ModificationFlags:FBPlugModificationFlag=FBPlugModificationFlag.kFBPlugAllContent,Recursive:bool=True,TypeInfo:int=FBPlug.TypeInfo,ExactTypeMatch:bool=False,/)->None:
		"""Get List of the namespace content.

		### Parameters:
			- ContentList: the list of content to return.
			- Namespace: the namespace to work on, NULL for whole scene.
			- ModificationFlags: bitwise combination of kFBConnectionSrcObjectModified, kFBConnectionDstObjectModified, kFBConnectionSrcPropertyModified, kFBConnectionDstPropertyModified flags. kFBPlugAllContent means all the content. Modification flags beside kFBPlugAllContent will only work on FileReference Namespace.
			- Recursive: **True** only work on the direct children level namespace, otherwise will work on the whole children namespace hierarchy recursively.
			- TypeInfo: the typeInfo of the type of interested object, 0 for all the objects.
			- ExactTypeMatch: if **True**, the derived typeInfo won't be considered (For example, [FBCamera](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_camera.html "Creates custom cameras and manages system cameras.") won't be considered when passing [FBModel::TypeInfo](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html#a9b39fba51413fa925a0d94d2feb13bf9 "Contains the Type information of the object."))."""
		...
	def NamespaceGetOwnerFileReference(self,Namespace:str,/)->FBFileReference:
		"""Get Owner FileReference object if the namespace is originated from File Reference.

		### Parameters:
			- Namespace: the namespace to work on, could be nested namespace inside the FileReference's namespace.

		### Returns:
		the FileReference object is the namespace is originated from. NULL otherwise."""
		...
	def NamespaceImport(self,Namespace:str,FilePath:str,AsFileReference:bool=False,/)->bool:
		"""Import file into Namespace (or as file reference)

		### Parameters:
			- Namespace: the namespace to import to, must be in editable scope.
			- FilePath: the referenced file path to import.
			- AsFileReference: import the file as file reference. The default value is false.

		### Returns:
		True if successfully."""
		...
	def NamespaceImportToMultiple(self,DstNamespaceList:FBStringList,FilePath:str,AsFileReference:bool=False,/)->bool:
		"""Import file into multiple Namespaces (or as file references)

		### Parameters:
			- DstNamespaceList: the Dst namespaces list to import, must not exist or be self contained.
			- FilePath: the referenced file path to import.
			- AsFileReference: import the file as file reference. The default value is false.

		### Returns:
		True if successfully.
		### Note:
		Nested destination namespaces are not allowed (e.g. a DstNamespaceList contains "NS1" and "NS1:NS2" will return False)."""
		...
	def NamespaceRename(self,NameSpace:str,NewNamespace:str,Recursive:bool=True,TypeInfo:int=FBPlug.TypeInfo,ExactTypeMatch:bool=False,/)->bool:
		"""Rename the namespace.

		### Parameters:
			- NameSpace: the namespace to work on, NULL for whole scene.
			- NewNamespace: the new namespace
			- Recursive: **True** only work on the direct children level namespace, otherwise will work on the children namespace hierarchy recursively.
			- TypeInfo: the typeInfo of the type of interested object, default for all the objects.
			- ExactTypeMatch: if **True**, the derived typeInfo won't be considered (For example, [FBCamera](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_camera.html "Creates custom cameras and manages system cameras.") won't be considered when passing [FBModel::TypeInfo](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html#a9b39fba51413fa925a0d94d2feb13bf9 "Contains the Type information of the object.")).

		### Returns:
		True if operation successfully, False is this namespace (or pTypeInfo type of objects) doesn't exist, or locked (by FileReferencing or etc.,)
		### Note:
		call with default parameters is considered as renaming of the whole namespace structure, otherwise will be considered as partially renaming individual objects. Renaming permission will be validated accordingly."""
		...
	def NamespaceSelectContent(self,Namespace:str,Select:bool,ModificationFlags:FBPlugModificationFlag=FBPlugModificationFlag.kFBPlugAllContent,Recursive:bool=True,TypeInfo:int=FBPlug.TypeInfo,ExactTypeMatch:bool=False,/)->None:
		"""Select (or de-select) the namespace content.

		### Parameters:
			- Namespace: the namespace to work on, NULL for whole scene.
			- Select: **True** (or **False**) indicate to select (or de-select)
			- ModificationFlags: bitwise combination of kFBConnectionSrcObjectModified, kFBConnectionDstObjectModified, kFBConnectionSrcPropertyModified, kFBConnectionDstPropertyModified flags. kFBPlugAllContent means all the content. Modification flags beside kFBPlugAllContent will only work on FileReference Namespace.
			- Recursive: **True** only work on the direct children level namespace, otherwise will work on the children namespace hierarchy recursively.
			- TypeInfo: the typeInfo of the type of interested object, default for all the objects.
			- ExactTypeMatch: if **True**, the derived typeInfo won't be considered (For example, [FBCamera](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_camera.html "Creates custom cameras and manages system cameras.") won't be considered when passing [FBModel::TypeInfo](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html#a9b39fba51413fa925a0d94d2feb13bf9 "Contains the Type information of the object."))."""
		...
class FBSet(FBBox):
	"""Objects Set class.

	This class is an interface to manipulate object sets in the scene. Note: an item cannot be in two [FBSet](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_set.html "Objects Set class.") objects at once. Also, an [FBGroup](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_group.html "Objects Grouping class.") cannot contain [FBSet](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_set.html "Objects Set class.") objects, although an [FBSet](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_set.html "Objects Set class.") object can contain an FBGRoup."""
	Items:FBPropertyListComponent
	"""List: Items in the set."""
	Pickable:bool
	"""Read Write Property: Controls if objects in the set are pickable."""
	Transformable:bool
	"""Read Write Property: Controls if objects in the set are transformable."""
	@property
	def Visibility(self)->FBPropertyAnimatableBool:
		"""Read Write Property: Visibility of set (animatable)."""
		...
	@Visibility.setter
	def Visibility(self, Value: FBPropertyAnimatableBool|bool):...
	def Contains(self,Component:FBComponent,/)->int:
		"""Contains.

		### Parameters:
			- Component: Component to verify if it is in the Group

		### Returns:
		0 if the component is not in the [FBSet](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_set.html "Objects Set class."), 1 if it is in this [FBSet](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_set.html "Objects Set class."), 2 if it is in another [FBSet](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_set.html "Objects Set class.")"""
		...
	def Select(self,Select:bool,/)->None:
		"""Select.

		### Parameters:
			- Select: If **true**, set contents will be selected."""
		...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Set name."""
		...
class FBShader(FBBox):
	"""Shader class."""
	RenderingPass:FBRenderingPass
	"""Read Write Property: Rendering pass object are shaded in."""
	ShaderDescription:str
	"""Description."""
	def Append(self,Model:FBModel,/)->bool:
		"""Append shader to pModel.

		### Parameters:
			- Model: Model to append shader to.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def CloneShaderParameter(self,NewShader:FBShader,/)->None:
		"""Clone shader.

		### Parameters:
			- NewShader: Shader to copy data to."""
		...
	def ReplaceAll(self,Model:FBModel,/)->bool:
		"""Replace all shader in pModel.

		### Parameters:
			- Model: Model to replace all shader to.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def ShaderNeedBeginRender(self)->bool:
		"""Does the shader need a begin render call.

		### Remarks:
		Re-implement this function and return true if you need it. This method is called once per shader on each render pass."""
		...
class FBShaderLighted(FBShader):
	"""Lighted shader class.

	This type of shader is the default type used by the application. It allows users to control luminosity, contrast and specularity as well as how the transparency is computed, should it be used.There are two methods to create a [FBShaderLighted](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_shader_lighted.html "Lighted shader class.") object: using the [FBShaderManager](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_shader_manager.html "Shader manager."), or simply by instantiating a class object explicitely.Please consult the application documentation for more infos on shader properties and their effects.This class should not serve as a base class for another class.Sample C++ code:

	```c++
	// Creation of a lighted shader, and setting it to use
	// the constrast and specularity.
	FBShaderLighted* lShader = new FBShaderLighted( "New Shader" );

	lShader->UseContrast  = true;
	lShader->UseSpecular  = true;
	lShader->Specular	 = 35.0;
	lShader->Transparency = kFBAlphaSourceTransluscentAlpha;

	// Use the shader.
	FBModel* lModel = FBFindModelByLabelName( "Cube" );
	if( lModel )
	{
	lShader->ReplaceAll( lModel );
	}

	// Do some more things...

	// And then delete it when no longer necessary;
	lShader->FBDelete();
	```
	The following sample code does the same task, but in Python.Sample Python code:

	```python
	from pyfbsdk import *

	# Creating the shader.
	lShader = FBShaderLighted( 'New Python Shader' )
	lShader.UseContrast  = True
	lShader.UseSpecular  = True
	lShader.Specular	 = 35.0
	lShader.Transparency = FBAlphaSource.kFBAlphaSourceTransluscentAlpha

	# User the shader
	lModel = FBFindModelByLabelName( 'Cube' )
	if lModel <> None:
		lModel.Show = True
		lShader.ReplaceAll( lModel )
	```"""
	@property
	def Alpha(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Controls the actual effect of the shader on the object. At 0.0 it does nothing, and at 1.0 it fully affects the object."""
		...
	@Alpha.setter
	def Alpha(self, Value: FBPropertyAnimatableDouble|float):...
	Contrast:float
	"""Read Write Property: Changes the contrast of the object when it reflects light."""
	Luminosity:float
	"""Read Write Property: Changes the brightness of the object when reflecting light."""
	Specular:float
	"""Read Write Property: Changes an object's level of shininess when it reflects light by affecting the specular highlight."""
	Transparency:FBAlphaSource
	"""Read Write Property: Indicates the computation method of the transparency."""
	UseContrast:bool
	"""Read Write Property: Activate the Contrast option."""
	UseLuminosity:bool
	"""Read Write Property: Activate the Luminosity option."""
	UseSpecular:bool
	"""Read Write Property: Activate the Specularity option."""
	def __init__(self,Name:str|None=None,/):
		"""### Parameters:
			- Name: Name of shader."""
		...
class FBShaderManager:
	"""Shader manager.

	This class provides access to the list of available shaders, both system shaders and user shaders. The list comes in two versions:ShaderTypeNames : which gives the internal names of the shaders,ShaderTypeNamesLocalized : uses the GUI names of the shaders.Both of these lists will have the same number of elements. The strings at position i in the lists refer to the same shader type. In cases where there is no localized version of the shader name, the internal name will be used in ShaderTypeNamesLocalized, thus ensuring consistency between the two lists.It also provides a generic shader creation method that uses the shader type name, internal or localized, to create the new shader instance.The destruction of shaders is achieved by calling the FBDelete method of a shader instance.The list of all the instantiated shaders can be obtained from instances of classes [FBSystem](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_system.html "Provides access to the underlying system, and the MotionBuilder scene.") or [FBScene](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_scene.html "Access to the MotionBuilder scene."). Both classes have a Shaders property which lists the existing shader instances.Strings are used instead of enum, define or typedef values to refer to shader types as this proves to be more flexible.The system has a default shader of type 'Lighted'. Do not attempt to destroy it.The use of localized names in shader creation is non portable as it is dependent of the current language used by the application. The name may also change from one version to another. Using the internal name is the only way to ensure portable shader creation.Sample C++ code:

	```c++
	// This could be a constant value in the code, coming from a custom
	// registry or simply coming from one of the list ShaderTypeNames
	// or ShaderTypeNamesLocalized.
	const char* lDesiredShaderTypeName = "MyShader";

	// Shader creation.
	FBShader* lShader = NULL;
	FBShaderManager lShaderManager;

	if( lShaderManager.ShaderTypeNames.Find( lDesiredShaderTypeName ) != -1 ||
	lShaderManager.ShaderTypeNamesLocalized.Find( lDesiredShaderTypeName ) != -1 )
	{
	lShader = lShaderManager.CreateShader( lDesiredShaderTypeName );

	// Change its name, as the default name will be the type name.
	if( lShader )
	{
	lShader->Name = "My new shader";
	}
	else
	{
	// Warn about creation failure on a correctly registered
	// shader type.
	}
	}
	else
	{
	// Warn about an unknown shader type.
	}

	//
	// Do some work with the shader...
	//

	if( lShader )
	{
	lShader->FBDelete();
	}
	```
	In the previous code sample, the lookup in the manager list is not necessary, as the call to CreateShader would have failed nonetheless and returned a NULL pointer.Sample Python code:

	```python
	from pyfbsdk import *

	lShaderManager = FBShaderManager()

	# This code will create one instance of each of the
	# available shader type, changing its name to add the
	# 'My ' prefix.
	for lShaderTypeName in lShaderManager.ShaderTypeNames:
	lShader = lShaderManager.CreateShader( lShaderTypeName )
	if lShader:
	lShader.Name = "My %s" % lShader.Name
	print("Created new shader '%s'" % lShader.Name)
	else:
	print("Unable to create shader of type '%s'" % lShaderTypeName)
	```
	[See sample: VertexArrayManipulation.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_geometry_0c_vertex_array_manipulation_8py-example.html)"""
	ShaderTypeNames:FBStringList
	"""List of available shaders."""
	ShaderTypeNamesLocalized:FBStringList
	"""List of available shaders."""
	def CreateShader(self,ShaderTypeName:str,/)->FBShader:
		"""Creates a shader according to the shader type provided.

		This method provides a generic way of creating shaders using the type name, internal or localized. The name of the new shader will be the same as the type name used, subject to changes according to the system's unique name policy.
		### Parameters:
			- ShaderTypeName: Name of the type of shader desired.

		### Returns:
		A pointer to the newly created shader object, or a NULL pointer if the type name was not recognised."""
		...
	def __init__(self):...
class FBShaderModelInfo:
	Model:FBModel
	"""Read Write Property: Shader mModel"""
	Model_Version:int
	"""Read Write Property: Shader version informations"""
	Shader_Version:property
class FBShaderShadowLive(FBShader):
	"""Shader Shadow Live class.

	Use the Live Shadow shader to apply real-time shadows to models. You can specify shadow intensity as well as the lights and objects that cast shadows in a scene.There are two methods to create a [FBShaderShadowLive](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_shader_shadow_live.html "Shader Shadow Live class.") object: using the [FBShaderManager](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_shader_manager.html "Shader manager."), or simply by instantiating a class object explicitely.Please consult the application documentation for more infos on shader properties and their effects.This class should not serve as a base class for another class.Sample C++ code:

	```c++
	// Create a shadow shader.
	FBShaderShadowLive* lShader = new FBShaderShadowLive( "New Shader" );

	// Add a cube in its list of affected objects.
	FBModel* lModel = FBFindModelByLabelName( "Cube" )
	if( lModel )
	{
	lShaderShadowLive.Add( lCube );
	}
	```
	Sample Python code:

	```python
	from pyfbsdk import *

	# Create shader.
	lShader = FBShaderShadowLive( 'New Python Shader' )

	# Find a cube to put in our list of affected objects.
	lModel = FBFindModelByLabelName( 'Cube' )
	if lModel:
	lShader.ShadowCasterProperty.append( lModel )
	```"""
	Lights:FBPropertyListObject
	"""List: List of light object which will produce shadows."""
	LocalShadow:bool
	"""Read Write Property: Creates an accurate projection of a shadow for each object."""
	Models:FBPropertyListObject
	"""List: List of object which when lighted will cast a shadow."""
	ShadowFrameType:FBShadowFrameType
	"""Read Write Property: Used to select the shadow calculation method."""
	@property
	def ShadowIntensity(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Controls the darkness of shadows cast by a selected object."""
		...
	@ShadowIntensity.setter
	def ShadowIntensity(self, Value: FBPropertyAnimatableDouble|float):...
	ShadowType:FBShadowType
	"""Read Write Property: Indicate which shadow type is desired."""
	ShadowZOffset:float
	"""Read Write Property: Specifies the offset of the Live Shadow shader's plane from the original selected plane."""
	UseGobo:bool
	"""Read Write Property: Includes the gobo in the shadow map calculation."""
	def __init__(self,Name:str|None=None,/):
		"""### Parameters:
			- Name: Name of shader."""
		...
class FBSkeletonState:
	def GetNodeMatrix(self,SkeletonId:FBSkeletonNodeId,SkeletonGlobalMatrix:FBMatrix,/)->None:
		"""Returned global matrix associated to the given Index.

		### Parameters:
			- SkeletonId: Index of the skeleton Node
			- SkeletonGlobalMatrix: returned global matrix of the index Given"""
		...
class FBSpreadPart(FBComponent):
	"""Spreadsheet part.

	Due to protected constructor, this can only be created by a child object."""
	Column:int
	"""Read Only Property: Column number."""
	Enabled:bool
	"""Read Write Property: Is SpreadPart enabled?"""
	Justify:FBTextJustify
	"""Read Write Property: Text justification for SpreadPart"""
	ReadOnly:bool
	"""Read Write Property: Is SpreadPart read-only?"""
	Row:int
	"""Read Only Property: Row number."""
	Style:FBCellStyle
	"""Read Write Property: Style of cell"""
class FBSpreadRow(FBSpreadPart):
	"""Spreadsheet row."""
	Caption:str
	"""Read Write Property: Caption to display with row."""
	Parent:int
	"""Read Write Property: Parent of row (reference)."""
	RowSelected:bool
	"""Read Write Property: Is row selected?"""
	def EditCaption(self)->bool:
		"""Edit the row caption.

		This will initiate the UI edit of a row caption.
		### Returns:
		Operation was successful (true or false)."""
		...
	def Remove(self)->None:
		"""Remove (destroy) row."""
		...
class FBSpreadColumn(FBSpreadPart):
	"""Spreadsheet column."""
	Caption:str
	"""Read Write Property: Caption of the column."""
	Width:int
	"""Read Write Property: Column width."""
class FBSpreadCell(FBSpreadPart):
	"""Spreadsheet cell."""
	...
class FBStory(FBComponent):
	"""Story Management class.

	This class serve as a management control for the Story global settings and members.

	[See samples: CreateShotClip.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_create_shot_clip_8py-example.html) [InsertCurrentTake.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_insert_current_take_8py-example.html) [BloopSlate.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_h_u_d_0c_bloop_slate_8py-example.html) [RecordLight.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_h_u_d_0c_record_light_8py-example.html) [PlotNonSelectedCharStoryTracks.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_plot_non_selected_char_story_tracks_8py-example.html) [PlotSelectedCharStoryTracks.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_plot_selected_char_story_tracks_8py-example.html) [PrintClipNamesAndStartStopFrames.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_print_clip_names_and_start_stop_frames_8py-example.html)"""
	ClipsTextsVisible:bool
	"""Read Write Property: If true, clips' texts are visible."""
	LockedShot:bool
	"""Read Write Property: If true, shots will be locked (no time discontinuity)."""
	MaintainShotAndClipShotLengthsSynced:bool
	"""Read Write Property: When working in time discontinuity, if true, shots and their corresponding shot clips will be kept in sync in regards of their lengths."""
	Mute:bool
	"""Read Write Property: If true, the Story mode will be globally disabled."""
	NoneBlockingPostprocess:bool
	"""Read Write Property: If true, record to disk will post process recorded data in low priority thread without affecting application performance. Clip in story will remain unloaded."""
	RecordToDisk:bool
	"""Read Write Property: If true, record to story will record directly to disk."""
	RootEditFolder:FBStoryFolder
	"""Read Only Property: Story's root edit folder"""
	RootFolder:FBStoryFolder
	"""Read Only Property: Story's root folder"""
	SummaryClip:bool
	"""Read Write Property: If true, summary clips for story folders will be created to help manipulating folder content."""
	def CleanEmptyTracksAndFolders(self)->int:
		"""Remove all empty tracks and folders present in the Story Tool.

		### Returns:
		The number of empty story tracks and/or folders removed."""
		...
	def __init__(self):...
class FBStoryClip(FBComponent):
	"""Story Clip class.

	Clips represents media, at a specific time, for a specific duration, in a track.Clip offset is depending on Traveling node and Traveling node function. First we compute clip transformation matrix, where scaling is always 1, 1, 1. Translation is in position of Traveling node at clip first frame. Rotation is based on vector from first to last frame position of Traveling node. On top of that we apply offset and expose that as Clip Offset T & R. When you change clip offset T or R we extract clip offset based on current clip transformation matrix. Clip transformation matrix can change when Traveling node change or Traveling node function change.

	[See samples: AudioTrackSetupTool.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_complex_tools_0c_audio_track_setup_tool_8py-example.html) [VideoClip.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_story_0c_video_clip_8py-example.html) [PrintClipNamesAndStartStopFrames.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_print_clip_names_and_start_stop_frames_8py-example.html)"""
	AudioClip:FBAudioClip
	"""Read Only Property: The audio clip used by this StoryClip."""
	AutoLoop:bool
	"""Read Write Property: If true, clip will automatically loop"""
	ClipAnimationPath:str
	"""Read Write Property: Animation clip's file path"""
	ClipAudioPath:str
	"""Read Write Property: Audio clip's file path"""
	ClipPitch:float
	"""Read Write Property: The clip pitch value."""
	ClipVideoPath:str
	"""Read Write Property: Video clip's file path"""
	Color:FBColor
	"""Read Write Property: Color of the clip."""
	ConnectedToTake:bool
	"""Read Write Property: When connected to current take, user can do updating from current take, but user can't edit clip animation by adding keys, only works for clips created by Insert Current Take."""
	CustomTimeWarp:FBAnimationNode
	"""Read Only Property: Animation and Shot clip's custom TimeWarp FCurve."""
	FrameRate:float
	"""Read Write Property: Frame rate value. Only effective when UseSystemFrameRate is false."""
	Ghost:bool
	"""Read Write Property: Show ghosts"""
	GhostCustomTime:FBTime
	"""Read Write Property: Custom time to display ghost, only applicable if ShowGhostClipMode is kFBStoryClipTimeCustom."""
	GhostManipulatorCustomTime:FBTime
	"""Read Write Property: Custom time to display ghost manipulator, only applicable if GhostManipulatorMode is kFBStoryClipGhostCustom."""
	GhostManipulatorMode:FBStoryClipGhostTimeMode
	"""Read Write Property: Time mode to display ghost manipulator. See [FBStoryClipGhostTimeMode](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_story_clip_ghost_time_mode.html "Time mode to display ghost.")."""
	GhostManipulatorOffset:FBVector3d
	"""Read Write Property: Animation clip's ghost manipulator offset."""
	GhostModel:bool
	"""Read Write Property: Show ghost of models"""
	GhostPivot:bool
	"""Read Write Property: Show ghost of match object"""
	GhostTravelling:bool
	"""Read Write Property: Show ghost of clip vector or traveling node"""
	ImageSequence:bool
	"""Read Write Property: Whether is a image sequence."""
	Loaded:bool
	"""Read Write Property: If true, clip file is loaded into memory and can be evaluated (will affect track content)."""
	LockPitchToSpeed:bool
	"""Read Write Property: Time-stretching enabled or not."""
	Loop:bool
	"""Read Write Property: If true, loop clip's animation"""
	LoopTranslation:FBVector3d
	"""Read Write Property: Animation clip's loop translation."""
	MarkIn:FBTime
	"""Read Write Property: Start time inside the clip."""
	MarkOut:FBTime
	"""Read Write Property: Stop time inside the clip."""
	MirrorAnimation:bool
	"""Read Write Property: If true, clip animation will be mirrored"""
	MirrorPlane:FBStoryClipMirrorPlane
	"""Read Write Property: Several mirror planes to mirror animation. See [FBStoryClipMirrorPlane](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_story_clip_mirror_plane.html "Several mirror planes to mirror animation.")"""
	Offset:FBTime
	"""Read Write Property: First loop time offset."""
	OnChange:callbackframework.FBEventSource[Self, FBEventClipChange]
	"""Event: Something in the clip has changed. (FBEventClip)"""
	Pivots:FBPropertyListPivot
	"""List: Pivots models (Generally, only one model is necessary)"""
	PostBlend:FBTimeSpan
	"""Read Write Property: Start/Stop time of the post-blend phase."""
	PreBlend:FBTimeSpan
	"""Read Write Property: Start/Stop time of the pre-blend phase."""
	Rotation:FBVector3d
	"""Read Write Property: Animation clip's rotation offset. Refer to class notes to learn more about how this is applied."""
	Scale:float
	"""Read Write Property: Animation clip's scaling (some don't support this property)"""
	ShotActionStart:FBTime
	"""Read Write Property: If not in locked shot mode (time discontinuity enabled), this time can be different from the Clip->Start property."""
	ShotActionStop:FBTime
	"""Read Write Property: If not in locked shot mode (time discontinuity enabled), this time can be different from the Clip->Start property."""
	ShotBackplate:FBVideo
	"""Read Write Property: The backplate used for that specific shot."""
	ShotCamera:FBCamera
	"""Read Write Property: The camera used for that specific shot."""
	ShotFrontplate:FBVideo
	"""Read Write Property: The frontplate used for that specific shot."""
	ShotStartStopLocked:bool
	"""Read Write Property: Shot clip's 'In/Out Locked' property value. True if the shot clip's In/Out properties (start/stop times of the clip local to its track) are locked, false otherwise."""
	ShowBackplate:bool
	"""Read Write Property: Enable/Disable the shot backplate."""
	ShowEmbeddedTimecode:bool
	"""Read Write Property: Whether to show embedded timecode of the clip, if available."""
	ShowFrontplate:bool
	"""Read Write Property: Enable/Disable the shot frontplate."""
	ShowGhostClipMode:FBStoryClipShowGhostMode
	"""Read Write Property: Show the ghost depending on the time. See [FBStoryClipShowGhostMode](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_story_clip_show_ghost_mode.html "Show Ghost Modes for story animation clips.")"""
	SolvingMode:FBStoryClipSolveMode
	"""Read Write Property: Solve Modes for story character clips. See [FBStoryClipSolveMode](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_story_clip_solve_mode.html "Solve Modes for story character clips.")"""
	Speed:float
	"""Read Write Property: Speed of the clip."""
	Start:FBTime
	"""Read Write Property: Start time of the clip local to its track."""
	StartStopLocked:bool
	"""Read Write Property: Clip's 'In/Out Locked' property value. True if the clip's In/Out properties (start/stop times of the clip local to its track) are locked, false otherwise."""
	Stop:FBTime
	"""Read Write Property: Stop time of the clip local to its track."""
	TimeWarpEnabled:bool
	"""Read Write Property: Animation and Shot clip's TimeWarp activeness."""
	TimeWarpInterpolatorType:FBStoryClipTimeWarpInterpolatorType
	"""Read Write Property: Animation and Shot clip's TimeWarp interpolation type. See [FBStoryClipTimeWarpInterpolatorType](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_story_clip_time_warp_interpolator_type.html "Types of TimeWrap Interpolator for Story Clips.")."""
	TimeWarpReverse:bool
	"""Read Write Property: If true, reverse the Animation or Shot clip's TimeWarp FCurve."""
	Translation:FBVector3d
	"""Read Write Property: Animation clip's translation offset. Refer to class notes to learn more about how this is applied."""
	TravellingNode:FBPropertyListObject
	"""List: Travelling node(s). If set, this property will overwrite the Track's Travelling node(s)."""
	TravellingNodeFunction:FBStoryClipNodeFunction
	"""Read Write Property: Travelling node function. If set, this property will overwrite the Track's Travelling node function. See [FBStoryClipNodeFunction](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_story_clip_node_function.html "Node function.")."""
	UseSystemFrameRate:bool
	"""Read Write Property: Whether always use system frame rate."""
	def CanAssignSourcesToDestinations(self)->bool:
		"""CanAssignSourcesToDestinations.

		Determines if the animation clip can assign its sources to some destinations or not.
		### Returns:
		Returns true if the animation clip can assign its sources to some destinations, false otherwise."""
		...
	def Clone(self)->FBStoryClip:
		"""Clone the clip."""
		...
	def DestinationSetObject(self,SrcName:str,Object:FBComponent,/)->bool:
		"""Assign source to destination if the pSrcName is found in source list and pObject is in the Details list.

		### Parameters:
			- SrcName: The name of the source.
			- Object: The destination object.

		### Returns:
		Returns true if assignment has been executed when the pSrcName is found in source list and pObject is in the Details list.
		### Remarks:
		Assignment success depends on if they have the same name property and with animation on the source property."""
		...
	def ExportToFile(self,OutputFile:str,/)->bool:
		"""ExportToFile.

		Export animation clip to disk file.
		### Parameters:
			- OutputFile: Output file path name.

		### Returns:
		Returns true if successful."""
		...
	def GetAffectedAnimationNodes(self,arg2:FBComponent,/)->list:
		"""GetAffectedAnimationNodes.

		Get the list of animation nodes affected by this story clip, for a specific object.
		### Parameters:
			- AffectedAnimationNodes: Array of affected animation nodes, will be filled by the function.
			- ClipObject: The object for which we search for affected animation nodes.

		### Python:
		The function takes only one parameter (pClipObject) and returns a Python list. ex : lArray = lClip.GetAffectedAnimationNodes(lObject)"""
		...
	def GetAffectedObjects(self)->list:
		"""GetAffectedObjects.

		Get the list of objects affected by this story clip.
		### Parameters:
			- AffectedObjects: Array of affected objects, will be filled by the function.

		### Python:
		The function takes no parameter and returns a Python list. ex : lArray = lClip.GetAffectedObjects()"""
		...
	def GetAssignSourcesToDestinationsInfo(self)->tuple:
		"""GetAssignSourcesToDestinationsInfo.

		Returns the information about the current state of Sources to Destinations assignment. The pSrcList, pDefaultDstList & pEffectiveDstList parameters will all be of same size, each index being related to the same index in the other lists. The pAvailableDstList parameter can contains more item than the other lists.
		### Parameters:
			- SrcList: String list containing all the sources, will be filled by the method.
			- AvailableDstList: String list containing all the available destinations, will be filled by the method.
			- DefaultDstList: String list containing the default destinations (contains each string item that will be put back when pressing the 'Reset' button in the UI), will be filled by the method.
			- EffectiveDstList: String list containing the effective destination (destinations currently active), will be filled by the method."""
		...
	def GetReadOnly(self)->bool:
		"""GetReadOnly Retrieves the clip read-only status.

		### Returns:
		Returns the clip read-only status."""
		...
	def MakeWritable(self)->bool:
		"""MakeWritable.

		Imports FCurves from story clip scene making them accessible for the user.
		### Returns:
		Returns true if successful."""
		...
	@overload
	def Match(self)->None:
		"""Match.

		Match the animation clip with the specified pivot property."""
		...
	@overload
	def Match(self,ObjectName:str,TimeType:FBStoryClipMatchingTimeType,TranslationType:FBStoryClipMatchingTranslationType,RotationType:FBStoryClipMatchingRotationType,/)->None:
		"""Match.

		Match the animation clip to its previous/next animation clip, one to each other.
		### Parameters:
			- ObjectName: The object name that specifies which part of the track content to use to match clips. If the object name is not valid, or empty, the match object will be disabled so that the blend does not take it into account when matching clips.
			- TimeType: The time type specifying which point of a cross-blend the selected clip is matched.
			- TranslationType: The translation type specifying if/how a clip's match object is translated to match another clip's animation.
			- RotationType: The rotation type specifying if/how a clip's match object is rotated to match another clip's animation."""
		...
	def Move(self,Delta:FBTime,Force:bool,/)->FBTime:
		"""Move.

		Move the clip of a delta offset.
		### Parameters:
			- Delta: Delta time to apply to the clip.
			- Force: Force clip to find the nearest position if the move fail.

		### Returns:
		Return the delta between the new and previous clip's position."""
		...
	def MoveTo(self,Time:FBTime,Force:bool,/)->FBTime:
		"""MoveTo.

		Move the clip to the specified time.
		### Parameters:
			- Time: Time where to put the clip.
			- Force: Force clip to find the nearest position if the move fail.

		### Returns:
		Returns the new clip's time position."""
		...
	def Razor(self,Time:FBTime,/)->FBStoryClip:
		"""Razor.

		Cut (razor) the clip at the specified time.
		### Parameters:
			- Time: Time where to cut. This time is local to the track, not to the clip.

		### Returns:
		Returns the new clip generated by the razor action (right part)."""
		...
	def SetAssignSourcesToDestinationsInfo(self,EffectiveDstList:list,/)->bool:
		"""SetAssignSourcesToDestinationsInfo.

		Sets the new effective destinations information for the Sources to Destinations assignment. The input string list size must contain the same number of items than the effective destination list returned by the GetAssignSourcesToDestinationsInfo method. Each item in the input string list must match an item in the available destination list returned by the GetAssignSourcesToDestinationsInfo method. The item at a given index of the input string list will be related to the same index of the sources list returned by the GetAssignSourcesToDestinationsInfo method.
		### Parameters:
			- EffectiveDstList: String list containing the new effective destination.

		### Returns:
		Returns true if the assign succeeded, false otherwise."""
		...
	def SetReadOnly(self,MakeClipReadOnly:bool,OutputFile:str="",/)->bool:
		"""SetReadOnly Assigns the clip read-only status.

		### Parameters:
			- MakeClipReadOnly: New read-only status
			- OutputFile: Output file path name, when setting the clip's read-only status to true.

		### Returns:
		Returns true if successful."""
		...
	def SetTime(self,SourceIn:FBTime,SourceOut:FBTime,DestinationIn:FBTime,DestinationOut:FBTime,UseAlternateSrcInProp:bool,/)->None:
		"""SetTime Sets any in/out values for the source/destination times.

		In and out values are optional and the current values for the story clip will be used if not supplied. The story "Speed" property will be adjusted in order for the supplied values to be respected by the story clip.
		### Parameters:
			- SourceIn: New value for the source IN time. Passing a value will modify the "MarkIn" and/or the "Speed" properties.
			- SourceOut: New value for the source OUT time. Passing a value will modify the "MarkOut" and/or the "Speed" properties.
			- DestinationIn: New value for the destination IN time. Passing a value will modify the "Stop" and/or the "Speed" properties.
			- DestinationOut: New value for the destination OUT time. Passing a value will modify the "Start" and/or the "Speed" properties.
			- UseAlternateSrcInProp: Will work on the "ExtractStart" property instead of the "MarkIn" property when passing pSourceIn."""
		...
	def UpdateFromCurrentTake(self)->bool:
		"""Update clip animation from current take animation for clip track's scope, works only for clip created by Insert Current Take and connected to current take.

		### Returns:
		Returns true if succeed."""
		...
	@overload
	def __init__(self,ClipObject:FBComponent,Track:FBStoryTrack,Time:FBTime,/):
		"""### Parameters:
			- ClipObject: Object (media data) for the clip.
			- Track: The track in which we create the clip.
			- Time: Time where the clip should begin."""
		...
	@overload
	def __init__(self,FilePath:str,Track:FBStoryTrack,Time:FBTime,/):
		"""### Parameters:
			- FilePath: Media file path to create clip with.
			- Track: The track in which we create the clip.
			- Time: Time where the clip should begin."""
		...
	@overload
	def __init__(self,FilePath:str,Track:FBStoryTrack,Time:FBTime,TimeOffset:FBTime,/):
		"""### Parameters:
			- FilePath: Media file path to create clip with.
			- Track: The track in which we create the clip.
			- Time: Time where the clip should begin.
			- TimeOffset: Time offset where the clip should begin."""
		...
class FBStoryFolder(FBComponent):
	"""Story Folder class.

	With folders, you can group tracks together and create different timelines.

	[See sample: FBStoryFolder.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_story_0c_f_b_story_folder_8py-example.html)"""
	Childs:FBPropertyListStoryFolder
	"""List: Children folders of this folder."""
	Collapsed:bool
	"""Read Write Property: Toggle to collapse or expand the story folder."""
	Label:str
	"""Read Write Property: Label to display for this story folder."""
	Mute:bool
	"""Read Write Property: If true, this story folder will be muted."""
	Parent:FBStoryFolder
	"""Read Only Property: Object pointing to the folder's parent."""
	RecordClipPath:str
	"""Read Write Property: Path for story recording. Can be relative or full path."""
	Solo:bool
	"""Read Write Property: If true, this story folder will be the only one to play."""
	Tracks:FBPropertyListStoryTrack
	"""List: Tracks of this folder."""
	def AlignSelectedClips(self,Type:FBStoryClipAlignmentType,ReferenceClip:FBComponent,/)->None:
		"""Used to align selected clips .

		### Parameters:
			- Type: Type of alignment that will be done.
			- ReferenceClip: Needed when kFBStoryClipAlignmentEndPreviousAllAligned, kFBStoryClipAlignmentBeginningNextAllAligned or kFBStoryClipAlignmentCurrentTimelineWithOffset are used."""
		...
	def AlignSelectedClipsGroup(self,Type:FBStoryGroupClipAlignmentType,/)->None:
		"""Used to align clips inside a group.

		### Parameters:
			- Type: Type of alignment that will be done."""
		...
	def ConvertClipsToReadOnly(self,Selected:bool,FilePath:str,/)->None:
		"""Convert all clips to read-only clips.

		Identical clips are replaced by the same read-only clip.
		### Parameters:
			- Selected: Only selected clip will be converted.
			- FilePath: Folder path where the read-only clips will be saved.

		### Remarks:
		Currently only animation clips are supported in the Root Folder"""
		...
	def ExpandSelectedClips(self,PreserveOverlap:bool,/)->None:
		"""Used to expand selected clips .

		### Parameters:
			- PreserveOverlap: If true, portion of clips that overlap other clips won't be modified."""
		...
	def ExpandSelectedClipsGroup(self,PreserveOverlap:bool,/)->None:
		"""ExpandSelectedClipsGroup Used to expand group clip dependent clips.

		### Parameters:
			- PreserveOverlap: If true, portion of clips that overlap other clips won't be modified."""
		...
	def Load(self,Load:bool,/)->None:
		"""Allow to load/unload all story clips under this folder.

		### Remarks:
		Currently only animation clips are supported."""
		...
	def __init__(self,ParentFolder:FBStoryFolder|None=None,/):
		"""### Parameters:
			- ParentFolder: If NULL, parent will be the global root folder, according to its type.

		### Remarks:
		You can't create a folder with the RootEditFolder as parent."""
		...
class FBStoryGroupClip(FBComponent):
	"""Story Group Clip class.

	Group Clip represents a group of clips that can be manipulated together."""
	DependentClips:FBPropertyListObject
	"""Read Write Property: Clips that are included in the group clip."""
	Start:FBTime
	"""Read Write Property: Start time of the clip."""
	StartStopLocked:bool
	"""Read Write Property: Clip's 'In/Out Locked' property value. True if the clip's In/Out properties (start/end times of the clip local to its track) are locked, false otherwise."""
	Stop:FBTime
	"""Read Write Property: Stop time of the clip."""
	def Move(self,Delta:FBTime,Force:bool,/)->FBTime:
		"""Move.

		Move the clip of a delta offset.
		### Parameters:
			- Delta: Delta time to apply to the clip.
			- Force: Force clip to find the nearest position if the move fail.

		### Returns:
		Return the delta between the new and previous clip's position."""
		...
	def MoveTo(self,Time:FBTime,Force:bool,/)->FBTime:
		"""MoveTo.

		Move the clip to the specified time.
		### Parameters:
			- Time: Time where to put the clip.
			- Force: Force clip to find the nearest position if the move fail.

		### Returns:
		Returns the new clip's time position."""
		...
	def Razor(self,Time:FBTime,/)->None:
		"""Razor.

		Cut (razor) the clip at the specified time.
		### Parameters:
			- Time: Time where to cut. This time is local to the track, not to the clip."""
		...
	def __init__(self,AffectedClipObject:list[FBStoryClip],/):
		"""### Parameters:
			- AffectedClipObject: Clips that will be controlled by the group clip."""
		...
class FBStoryTrack(FBConstraint):
	"""Story Track class.

	Tracks are containers for clips (medias), have a specific type which offer different functions. Note: To change the travelling node of a track, search for the "TravellingNode" property on the track and then connect/disconnect the appropriate object. Python example: lPropTravellingNode = lAnimTrack.PropertyList.Find("TravellingNode") lCube.ConnectDst(lPropTravellingNode)

	[See samples: CreateShotClip.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_create_shot_clip_8py-example.html) [AudioTrackSetupTool.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_complex_tools_0c_audio_track_setup_tool_8py-example.html) [BloopSlate.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_h_u_d_0c_bloop_slate_8py-example.html) [RecordLight.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_h_u_d_0c_record_light_8py-example.html) [FBStoryFolder.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_story_0c_f_b_story_folder_8py-example.html) [VideoClip.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_story_0c_video_clip_8py-example.html) [PlotNonSelectedCharStoryTracks.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_plot_non_selected_char_story_tracks_8py-example.html) [PlotSelectedCharStoryTracks.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_plot_selected_char_story_tracks_8py-example.html) [PrintClipNamesAndStartStopFrames.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_print_clip_names_and_start_stop_frames_8py-example.html)"""
	AcceptKey:bool
	"""Read Write Property: Allow track to accept keys"""
	AudioOutIndex:int
	"""Read Write Property: Audio Output's index to use."""
	Character:FBCharacter
	"""Read Write Property: Character to use."""
	CharacterIndex:int
	"""Read Write Property: Character's index to use."""
	ClipNameConvention:str
	"""Read Write Property: Naming convention for each new recording clip that is created. Can use special tags: <Name> <StartTCValue> <StartFrameValue> <StartDate> <StartTime> <TakeName>"""
	Clips:FBPropertyListStoryClip
	"""List: Clips contained in this track."""
	Details:FBPropertyListStoryDetails
	"""List: All objects associated to this track for processing."""
	Ghost:bool
	"""Read Write Property: Show ghosts"""
	GhostModel:bool
	"""Read Write Property: Show ghost of models"""
	GhostPivot:bool
	"""Read Write Property: Show ghost of match object"""
	GhostShowTrackMode:FBStoryTrackGhostShowMode
	"""Read Write Property: Show the ghosts for all the clips or only the adjacent clips. See [FBStoryTrackGhostShowMode](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_story_track_ghost_show_mode.html "Ghost Show Modes for story animation tracks.")"""
	GhostTravelling:bool
	"""Read Write Property: Show ghost of clip vector or traveling node"""
	Label:str
	"""Read Write Property: Label to display for this story track."""
	Mute:bool
	"""Read Write Property: If true, this track wont' play."""
	OffsetEnable:bool
	"""Read Write Property: When enabled, allow clip to be offset"""
	ParentFolder:FBStoryFolder
	"""Read Only Property: Parent folder."""
	ParentTrack:FBStoryTrack
	"""Read Only Property: Parent track, if the track is of Character or Animation type."""
	PassThrough:bool
	"""Read Write Property: Enable passthrough of animation if there is no clip on track animation is taken from other tracks of take"""
	RecordClipPath:str
	"""Read Write Property: Path for story recording. Can be relative or full path."""
	RecordTrack:bool
	"""Read Write Property: Path for story recording. Can be relative or full path."""
	ReferenceMode:FBStoryTrackRefMode
	"""Read Write Property: Track composition mode, kFBStoryTrackOverride or kFBStoryTrackAdditive"""
	ShowBackplate:bool
	"""Read Write Property: If true, the backplate will be shown."""
	ShowFrontplate:bool
	"""Read Write Property: If true, the frontplate will be shown."""
	Solo:bool
	"""Read Write Property: If true, this track will be the only one to play."""
	SubTracks:FBPropertyListStorySubTrack
	"""List: Only Character and Animation tracks can have sub-tracks."""
	TrackVideo:FBVideo
	"""Read Only Property: This [FBVideo](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_video.html "Video media class.") can be used as a texture."""
	Type:FBStoryTrackType
	"""Read Only Property: Type of the track"""
	def AddClip(self,Clip:FBComponent,Time:FBTime,/)->None:
		"""AddClip Add the clip to the track."""
		...
	def ChangeDetailsBegin(self)->None:
		"""ChangeDetailsBegin.

		You must call this function before adding/removing any object to the Details list or it won't work."""
		...
	def ChangeDetailsEnd(self)->None:
		"""ChangeDetailsEnd.

		You must call this function after adding/removing any object to the Details list or it won't work."""
		...
	def CopyTakeIntoTrack(self,TimeSpan:FBTimeSpan,Take:FBTake,OutputOffset:FBTime|None=None,MakeUndoable:bool=False,/)->FBStoryClip:
		"""CopyTakeIntoTrack Copy animation from the specified take for affected objects of the track.

		### Parameters:
			- TimeSpan: Time span for the clip to create.
			- Take: Take to get the animation from.
			- OutputOffset: Time offset for the clip if necessary.
			- MakeUndoable: If the operation should be undoable.

		### Returns:
		Created story clip if the operation succeeded otherwize NULL."""
		...
	def CreateSubTrack(self,TrackType:FBStoryTrackType,RefMode:FBStoryTrackRefMode,/)->FBStoryTrack:
		"""Create a sub track, Only Character and Animation tracks can have sub-tracks.

		### Parameters:
			- TrackType: Type of the sub track to be created.
			- RefMode: Composition mode of the sub track, kFBStoryTrackOverride or kFBStoryTrackAdditive.

		### Returns:
		Created sub story track if the operation succeeded otherwise NULL."""
		...
	def EnableBodyPart(self,Part:FBStoryTrackBodyPart,Enable:bool,/)->None:
		"""EnableBodyPart.

		### Parameters:
			- Part: Which part to enable/disable.
			- Enable: If True, this will enable the body part solving while false will disable it. Enable a specific body part for character solving."""
		...
	def IsBodyPartEnabled(self,Part:FBStoryTrackBodyPart,/)->bool:
		"""IsBodyPartEnabled.

		Is a specific body part is enabled."""
		...
	def Load(self,Load:bool,/)->None:
		"""Allow to load/unload all story clips under this track.

		### Remarks:
		Currently only animation clips are supported."""
		...
	@overload
	def __init__(self,TrackType:FBStoryTrackType,Folder:FBStoryFolder|None=None,/):
		"""### Parameters:
			- TrackType: Type of the track to be created.
			- Folder: If NULL, parent will be the global root folder."""
		...
	@overload
	def __init__(self,Source:FBComponent,Folder:FBStoryFolder|None=None,/):
		"""### Parameters:
			- Source: Source of the track to be created based on media component type.
			- Folder: If NULL, parent will be the global root folder."""
		...
class FBStringList:
	"""String list.

	[See sample: Memo.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_memo_8py-example.html)"""
	def Add(self,S:str,Ref:int=0,/)->int:
		"""Add a string to the list.

		### Parameters:
			- S: String to add to list.
			- Ref: Reference to store with string (default = 0)

		### Returns:
		Index where item was stored."""
		...
	def AsString(self,Separator:str='~',/)->str:
		"""Get as string.

		### Parameters:
			- Separator: the string list separator.

		### Returns:
		String list."""
		...
	def Clear(self)->None:
		"""Clear the list (remove all the items)."""
		...
	@overload
	def Find(self,Ref:int,/)->int:
		"""Find the index where pRef is stored.

		### Parameters:
			- Ref: Reference to look for.

		### Returns:
		Index at which pRef can be found."""
		...
	@overload
	def Find(self,String:str,CaseSensitive:bool=True,StartWith:bool=False,/)->int:
		"""Find the index with the string pString (or start with pString)

		### Parameters:
			- String: String to search for.
			- CaseSensitive: true if considering case.
			- StartWith: true if to find the index of the string which start with pString.

		### Returns:
		Index where S is stored."""
		...
	def GetAt(self,Index:int,/)->str:
		"""Get the string at pIndex.

		### Parameters:
			- Index: Index to get string at.

		### Returns:
		String at pIndex."""
		...
	def GetReferenceAt(self,Index:int,/)->int:
		"""Get the reference store with the string at pIndex.

		### Parameters:
			- Index: Index to get reference at.

		### Returns:
		Reference stored with value at pIndex."""
		...
	def IndexOf(self,S:str,/)->int:
		"""Get the index of a string.

		### Parameters:
			- S: String to look for.

		### Returns:
		Index where string S was found."""
		...
	def InsertAt(self,Index:int,S:str,Ref:int=0,/)->None:
		"""Insert an entry at pIndex.

		### Parameters:
			- Index: Index where item is to be inserted.
			- S: String to insert.
			- Ref: Reference to store with string(default=0)."""
		...
	def Remove(self,S:str,/)->int:
		"""Remove a string from the list.

		### Parameters:
			- S: String to remove from the list.

		### Returns:
		Index where item was found."""
		...
	def RemoveAt(self,Index:int,/)->None:
		"""Remove an entry at pIndex.

		### Parameters:
			- Index: Index where item is to be removed from."""
		...
	def SetAt(self,Index:int,String:str,/)->bool:
		"""Set the string at pIndex.

		### Parameters:
			- Index: Index where string is to be set.
			- String: String to set value at **pIndex** with."""
		...
	def SetReferenceAt(self,Index:int,Ref:int,/)->None:
		"""Set the reference stored with the string at pIndex.

		### Parameters:
			- Index: Index to store reference at.
			- Ref: Reference to store at **pIndex**."""
		...
	def SetString(self,String:str,Separator:str='~',/)->bool:
		"""Set string for list.

		### Parameters:
			- String: String to set for list.
			- Separator: the string list separator."""
		...
	def Sort(self)->None:
		"""Sort the string list (ascending)"""
		...
	def __getitem__(self,arg2,/)->str:...
	@overload
	def __init__(self):...
	@overload
	def __init__(self,String:str,Separator:str='~',/):
		"""### Parameters:
			- String: String to set for list.
			- Separator: the string list separator."""
		...
	def __len__(self)->int:...
	def __setitem__(self,arg2,arg3:str,/)->bool:...
	def __iter__(self)->Iterator[str]:...
class FBSurface(FBGeometry):
	"""Surface class."""
	SurfaceMode:FBSurfaceMode
	"""Read Write Property: Surface mode."""
	UClosed:bool
	"""Read Write Property: U Closed."""
	USize:int
	"""Read Write Property: Size in U directions."""
	UStep:int
	"""Read Write Property: Step in U directions."""
	VClosed:bool
	"""Read Write Property: V Closed"""
	VSize:int
	"""Read Write Property: Size in V directions."""
	VStep:int
	"""Read Write Property: Step in V directions."""
	def ControlPointsBegin(self)->None:...
	def ControlPointsEnd(self)->None:...
	def GetControlPoint(self,Index:int,X:float,Y:float,Z:float,W:float,/)->None:...
	def GetSurfaceCapped(self,UorV:int,Direction:int,/)->bool:...
	def SetControlPoint(self,Index:int,X:float,Y:float,Z:float,W:float,/)->None:...
	def SurfaceBegin(self)->None:...
	def SurfaceEditBegin(self)->None:...
	def SurfaceEditEnd(self)->None:...
	def SurfaceEnd(self)->None:...
class FBSystem(FBComponent):
	"""Provides access to the underlying system, and the MotionBuilder scene.

	Use this class to access system properties such as the computer name, the system time, and the MotionBuilder application version.It is also used to get access to the scene ([FBScene](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_scene.html "Access to the MotionBuilder scene.")) and the current take ([FBTake](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_take.html "A take is a container for animation in a scene.")), as in the following Python snippet:

	```python
	myScene = FBSystem().Scene
	for take in myScene.Takes:
		print(take.Name)
	```
	The Python sample FBSystemEvents.py shows how to register a callback to [FBSystem](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_system.html "Provides access to the underlying system, and the MotionBuilder scene.").

	[See samples: FBSystemEvents.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_f_b_system_events_8py-example.html) [CameraSwitcher.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_camera_0c_camera_switcher_8py-example.html) [BatchExportCharacterAnimationTool.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_batch_export_character_animation_tool_8py-example.html) [ExportAnimationLibrary.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_export_animation_library_8py-example.html)"""
	class EPluginItemInfo(Enumeration):
		ePluginItemDescription:FBSystem.EPluginItemInfo
		ePluginItemFileName:FBSystem.EPluginItemInfo
		ePluginItemIconName:FBSystem.EPluginItemInfo
	ApplicationPath:str
	"""Read Only Property: Location where the application is installed."""
	AreMessageBoxesSuspended:bool
	"""Read Only Property: While true, the system is suspending the messages boxes that would normally be displayed."""
	AssetManager:FBAssetMng
	"""Read Only Property: Current asset manager."""
	AudioInputs:FBPropertyListAudioIn
	"""List: Available audio inputs."""
	AudioOutputs:FBPropertyListAudioOut
	"""List: Available audio outputs."""
	BuildId:str
	"""Read Only Property: Unique build Id string."""
	BuildVersion:str
	"""Read Only Property: Unique build version string. The format of the build version information is: Major.Minor.Revision.BuildNumber. All sub-parts of the build version string are containing only numeric characters."""
	Cameras:FBPropertyListCamera
	"""### Note:
	Deprecated [FBSystem.Cameras](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_system.html#a482e1fbef15c2a165bde7fd64b54a9ae): Use FBSystem.Scene.Cameras to access this property."""
	ComputerName:str
	"""Read Only Property: Computer name. [See sample: ShowMachineNameAndCameraNamePlusResolution.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_show_machine_name_and_camera_name_plus_resolution_8py-example.html)"""
	ConfigPath:str
	ConstructionHistory:FBConstructionHistory
	"""Read Only Property: Construction History."""
	CurrentTake:FBTake
	"""Read Write Property: Current take. [See samples: GoToNextTake.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_go_to_next_take_8py-example.html)"""
	DesktopSize:FBVector2d
	"""Read Only Property: The width and height of the desktop."""
	Devices:FBPropertyListDevice
	"""### Note:
	Deprecated [FBSystem.Devices](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_system.html#a5303064885144f47a9a556a699b920d0): Use FBSystem.Scene.Devices to access this property."""
	FrameRate:float
	"""Read Only Property: The frame rate of the viewer."""
	FullScreenViewer:bool
	"""Read Write Property: Indicates that the viewer is in full screen mode."""
	Lights:FBPropertyListLight
	"""### Note:
	Deprecated [FBSystem.Lights](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_system.html#ae8e37f8bfdb450edb56ae7c079a96993): Use FBSystem.Scene.Lights to access this property."""
	LocalTime:FBTime
	"""Read Only Property: Local time in take."""
	Manipulators:FBPropertyListManipulator
	"""List: of manipulators."""
	Materials:FBPropertyListMaterial
	"""### Note:
	Deprecated [FBSystem.Materials](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_system.html#aed43f9b8e3040057809de92c0d0c052e): Use FBSystem.Scene.Materials to access this property."""
	OnConnectionDataNotify:callbackframework.FBEventSource[Self, FBEventConnectionDataNotify]
	"""Event: A data event occurred between objects in the system."""
	OnConnectionKeyingNotify:callbackframework.FBEventSource[Self, FBEventConnectionKeyingNotify]
	"""Event: A keying event occurred when objects are being keyed."""
	OnConnectionNotify:callbackframework.FBEventSource[Self, FBEventConnectionNotify]
	"""Event: A connection event occurred between objects in the system. [See sample: FBSystemEvents.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_f_b_system_events_8py-example.html)"""
	OnConnectionStateNotify:callbackframework.FBEventSource[Self, FBEventConnectionStateNotify]
	"""Event: A state change event occurred between objects in the system."""
	OnUIIdle:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: User-interface idle event. Useful callback for less frequent GUI refresh and etc. lightweight tasks (occur once per several frames)."""
	OnVideoFrameRendering:callbackframework.FBEventSource[Self, FBEventVideoFrameRendering]
	"""Event: A video frame rendering event occurred when the scene is being off-line rendered into video files."""
	PathImages:str
	"""Read Only Property: Path to images."""
	PathMeshs:str
	"""Read Only Property: Path to meshes"""
	ProcessMemory:float
	"""Read Only Property: The size (MB) of process's working set memory."""
	ProcessMemoryPeak:float
	"""Read Only Property: The size (MB) of process's peak memory."""
	PythonVersion:int
	"""Read Only Property: The Python interpreter version being used. The value is either 27 or 37."""
	Renderer:FBRenderer
	"""Read Only Property: Default renderer."""
	RootModel:FBModel
	"""Read Only Property: Root model."""
	Scene:FBScene
	"""Read Only Property: Scene."""
	SceneRootModel:FBModel
	"""Read Only Property: Scene root model."""
	Shaders:FBPropertyListShader
	"""### Note:
	Deprecated [FBSystem.Shaders](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_system.html#a3f10c9114cb83fd3c16f39d193a5c196): Use FBSystem.Scene.Shaders to access this property."""
	SuspendMessageBoxes:bool
	"""Read Write Property: While true, all the message boxes, that would normally be displayed, are suspended."""
	SystemTime:FBTime
	"""Read Only Property: System time."""
	Takes:FBPropertyListTake
	"""### Note:
	Deprecated [FBSystem.Takes](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_system.html#a9a412cd621bfd300e12c834fa4bbfdb7): Use FBSystem.Scene.Takes to access this property."""
	Textures:FBPropertyListTexture
	"""### Note:
	Deprecated [FBSystem.Textures](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_system.html#aca5aafe69a1f8d0ee13d056f768f1c27): Use FBSystem.Scene.Textures to access this property."""
	UserConfigPath:str
	Version:float
	"""Read Only Property: Application version."""
	VideoInputs:FBPropertyListVideoIn
	"""List: Available video inputs."""
	VideoOutputs:FBPropertyListVideoOut
	"""List: Available video outputs."""
	ePluginItemDescription:FBSystem.EPluginItemInfo
	ePluginItemFileName:FBSystem.EPluginItemInfo
	ePluginItemIconName:FBSystem.EPluginItemInfo
	def CurrentDirectory(self)->str:
		"""Get current work directory.

		### Returns:
		current work directory."""
		...
	def GetCommandLineArgs(self)->FBStringList:
		"""Returns the command line arguments for SDK.

		This function returns portion of the command line arguments within a pair of delimiters (sdk-begin & sdk-end). Example:Note that "-console", "-G500,500", "-suspendMessages" and "C:/temp/sample.fbx" are for MotionBuilder itself hence are consumed accordingly. Only those arguments between sdk-begin and sdk-end are accessible with this function. In this example, they will be "--department mocap --usage on-stage"This SDK command line argument is useful for plugin deployment and management in large production facility, where different department or different workflow may require a different set of plugins or functionality/behavior dynamically.Python users also have access to this through official built-in module sys.argv which could be parsed easily via argparse module.
		### Returns:
		the command line arguments"""
		...
	def GetLoadedPluginItemGroups(self,PluginItemName:str,/)->FBStringList:
		"""Returns a string list containing the groups list in which the specified plug-in item's name belongs to.

		### Returns:
		the groups list in which the specified plug-in item's name belongs to."""
		...
	def GetLoadedPluginItemInfo(self,PluginItemName:str,/)->FBStringList:
		"""Returns a string list containing the information of the specified plug-in item's name.

		A specific plug-in item information can be retrieved from the returned string list with a EPluginItemInfo enum value.
		### Returns:
		the information of the specified plug-in item's name."""
		...
	def GetLoadedPluginItemsName(self)->FBStringList:
		"""Returns a string list containing the names of all the loaded plug-in.

		### Returns:
		the names of all the loaded plug-in."""
		...
	def GetPluginPath(self)->FBStringList:
		"""Returns the plugin path.

		By default, MotionBuilder searches C++ plug-ins and load them at start-up. Users could provide additional plugin paths by setting environment variable "MOTIONBUILDER_PLUGIN_PATH" before running MotionBuilder.
		### Returns:
		the plugin path"""
		...
	def GetPythonStartupPath(self)->FBStringList:
		"""Returns the python startup path.

		User could put python script in the startup folders, and MotionBuilder will search scripts from those folders and run them at startup. By default, there are two startup folders: /config/PythonStartup and /bin/config/PythonStartup. Users could append additional paths by setting environment variable "MOTIONBUILDER_PYTHON_STARTUP" before launching application.
		### Returns:
		the python startup path"""
		...
	def MakeFullPath(self,RelativeFilePath:str,/)->str:
		"""Return the full path.

		### Parameters:
			- RelativeFilePath: The relative file path

		### Returns:
		Full file path based on combining the current directory"""
		...
	def __init__(self):...
class FBPatch(FBSurface):
	"""Patch class."""
	USurfaceType:FBSurfaceType
	"""Read Write Property: Patch mode for U direction."""
	VSurfaceType:FBSurfaceType
	"""Read Write Property: Patch mode for V direction."""
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of Patch."""
		...
class FBNurbs(FBSurface):
	"""Nurbs class."""
	UNurbType:FBNurbType
	"""Read Write Property: Nurbs Type for U direction."""
	UOrder:int
	"""Read Write Property: Nurbs U order."""
	VNurbType:FBNurbType
	"""Read Write Property: Nurbs Type for V direction."""
	VOrder:int
	"""Read Write Property: Nurbs V order."""
	def GetControlKnotValue(self,UorV:int,Index:int,/)->float:
		"""Get knot vector value of control point.

		### Parameters:
			- UorV: **1** if V knot vector, **0** if U knot vector.
			- Index: Index of control point to set knot value for."""
		...
	def GetControlMultiplicity(self,UorV:int,Index:int,/)->int:
		"""Get multiplicity (number of "instances") of control point.

		### Parameters:
			- UorV: **1** if V multiplicity, **0** if U multlipicity.
			- Index: Index of control point to get multiplicity for."""
		...
	def GetControlWeight(self,Index:int,/)->float:
		"""Get weight of control point.

		### Parameters:
			- Index: Index of control point to get weight from.

		### Returns:
		Weight of control point at index pIndex."""
		...
	def GetKnotCount(self,UorV:int,/)->int:
		"""Number of knot vectors.

		### Parameters:
			- UorV: **1** if V knot vector, **0** if U knot vector.

		### Returns:
		Number of knot vectors on NURBS surface"""
		...
	def SetControlKnotValue(self,UorV:int,Index:int,KnotValue:float,/)->None:
		"""Set knot vector value of control point.

		### Parameters:
			- UorV: **1** if V knot vector, **0** if U knot vector.
			- Index: Index of control point to set knot value for.
			- KnotValue: Knot value for control point at pIndex."""
		...
	def SetControlMultiplicity(self,UorV:int,Index:int,Multiplicity:int,/)->None:
		"""Set multiplicity (number of "instances") of control point.

		### Parameters:
			- UorV: **1** if V multiplicity, **0** if U multlipicity.
			- Index: Index of control point to set multiplicity for.
			- Multiplicity: Multiplicity value for control point at pIndex."""
		...
	def SetControlWeight(self,Index:int,Weight:float,/)->None:
		"""Set weight of control point.

		### Parameters:
			- Index: Index of control point to set weight at.
			- Weight: Weight of control point."""
		...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of Nurbs."""
		...
class FBTexture(FBBox):
	"""[See samples: HUDElements.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_h_u_d_0c_h_u_d_elements_8py-example.html) [MaterialAndTexture.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_material_and_texture_0c_material_and_texture_8py-example.html) [TextureAnimation.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_material_and_texture_0c_texture_animation_8py-example.html) [VideoInput.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_video_0c_video_input_8py-example.html) [VideoMemory.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_video_0c_video_memory_8py-example.html) [DeleteUnusedMedia.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_delete_unused_media_8py-example.html)"""
	@property
	def Alpha(self)->FBPropertyAnimatableDouble:
		"""Read Write Property: Texture alpha value."""
		...
	@Alpha.setter
	def Alpha(self, Value: FBPropertyAnimatableDouble|float):...
	BlendMode:FBTextureBlendMode
	"""Read Write Property: Texture blend mode."""
	Height:int
	"""Read Only Property: Height of texture."""
	Mapping:FBTextureMapping
	"""Read Write Property: Texture mapping."""
	@property
	def Rotation(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Rotation coordinates."""
		...
	@Rotation.setter
	def Rotation(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	@property
	def Scaling(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Scaling coordinates."""
		...
	@Scaling.setter
	def Scaling(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	SwapUV:bool
	"""Read Write Property: Swap UV coordinates?"""
	TextureOGLId:int
	"""Read Only: OpenGL texture buffer object Id."""
	@property
	def Translation(self)->FBPropertyAnimatableVector3d:
		"""Read Write Property: Translation coordinates."""
		...
	@Translation.setter
	def Translation(self, Value: FBPropertyAnimatableVector3d|FBVector3d):...
	UseType:FBTextureUseType
	"""Read Write Property: Texture Use Type."""
	Video:FBVideo
	"""Read Write Property: Media used for texturing."""
	Width:int
	"""Read Only Property: Width of texture."""
	def Clone(self)->FBTexture:
		"""Clone the texture.

		This will duplicated the current texture.
		### Returns:
		Newly created texture."""
		...
	def OGLInit(self)->None:...
	def __copy__(self)->FBTexture:...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of the texture media. If pName is a valid path, [FBTexture](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_texture.html "See samples: HUDElements.py, MaterialAndTexture.py, TextureAnimation.py, VideoInput....") will create a [FBVideo](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_video.html "Video media class.") object which is used in the Video property; else just a ordinary name."""
		...
class FBLayeredTexture(FBTexture):
	"""LayeredTexture class.

	This class is used to encapsulate list of textures. User could subclass this class to support customized blending & compostion modes. See /OpenRealitySDK/Samples/miscellaneous/texture_template/ for example.

	[See sample: LayeredTexture.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_material_and_texture_0c_layered_texture_8py-example.html)"""
	@property
	def BackgroundColor(self)->FBPropertyAnimatableColorAndAlpha:
		"""Read/Write Property: Animatable Background color which is used to clear color buffer before composition."""
		...
	@BackgroundColor.setter
	def BackgroundColor(self, Value: FBPropertyAnimatableColorAndAlpha|FBColorAndAlpha):...
	Layers:FBPropertyListTexture
	"""Read/Write Property: Textures Layers."""
	def SetLayerConfigDirty(self)->None:
		"""Set layer config dirty to trigger new composition."""
		...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of texture media. Can be a NULL pointer. If set, this will create a [FBVideo](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_video.html "Video media class.") object used as the Video property."""
		...
class FBTime:
	"""Time data structure.

	[See samples: FBTime.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_f_b_time_8py-example.html) [CameraSwitcher.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_camera_0c_camera_switcher_8py-example.html) [ExportAnimationLibrary.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_export_animation_library_8py-example.html) [StartKeysAtCurrentTime.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_start_keys_at_current_time_8py-example.html)"""
	class ETimeFormats(Enumeration):
		eDefaultFormat:FBTime.ETimeFormats
		eFrame:FBTime.ETimeFormats
		eSMPTE:FBTime.ETimeFormats
	Infinity:FBTime
	"""Time constant: Infinity, the largest time value."""
	MinusInfinity:FBTime
	"""Time constant: Minus Infinity, the lowest negative time value."""
	OneHour:FBTime
	"""Time constant: One Hour."""
	OneMinute:FBTime
	"""Time constant: One Minute."""
	OneSecond:FBTime
	"""Time constant: One Second."""
	Zero:FBTime
	"""Time constant: Zero."""
	eDefaultFormat:FBTime.ETimeFormats
	eFrame:FBTime.ETimeFormats
	eSMPTE:FBTime.ETimeFormats
	def Get(self)->int:
		"""Get time value (long)

		### Returns:
		Time value as long."""
		...
	def GetFrame(self,TimeMode:FBTimeMode=FBTimeMode.kFBTimeModeDefault,/)->int:
		"""Get the frame count.

		With this function, it is possible to obtain the cumulative and local frame counts.
		### Parameters:
			- TimeMode: Time mode to get the constant (default is kFBTimeModeDefault).

		### Returns:
		Frames per second constant for the specified time mode."""
		...
	def GetMilliSeconds(self)->int:
		"""Get milliseconds for time.

		### Returns:
		MilliSeconds value."""
		...
	def GetSecondDouble(self)->float:
		"""Get seconds as double.

		### Returns:
		Seconds in double form."""
		...
	def GetTimeString(self,Mode:FBTimeMode=FBTimeMode.kFBTimeModeDefault,Format:ETimeFormats=eDefaultFormat,/)->str:
		"""Get time as a string.

		### Parameters:
			- Mode: Time mode (default=kFBTimeModeDefault) to use (call [FBSystem()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/class_f_b_system.html "Provides access to the underlying system, and the MotionBuilder scene.").GetTransportFps() to the the current UI displayed mode).
			- Format: Format to use for the returned string(default=FBTime::eDefaultFormat).

		### Returns:
		String value of time."""
		...
	def Set(self,Time:int,/)->None:
		"""Set time value from a long.

		### Parameters:
			- Time: Time value to set."""
		...
	def SetFrame(self,Frames:int,TimeMode:FBTimeMode=FBTimeMode.kFBTimeModeDefault,/)->None:
		"""Set time in frame format.

		### Parameters:
			- Frames: The number of frames.
			- TimeMode: The time mode identifier which will dictate the extraction algorithm."""
		...
	def SetMilliSeconds(self,MilliSeconds:int,/)->None:
		"""Set milliseconds time.

		### Parameters:
			- MilliSeconds: MilliSeconds value."""
		...
	def SetSecondDouble(self,Time:float,/)->None:
		"""Set seconds from double.

		### Parameters:
			- Time: Time to set seconds from."""
		...
	def SetTime(self,Hour:int,Minute:int=0,Second:int=0,Frame:int=0,Field:int=0,TimeMode:FBTimeMode=FBTimeMode.kFBTimeModeDefault,/)->None:
		"""Set time (from separate values)

		### Parameters:
			- Hour: Hour value.
			- Minute: Minute value(default=0).
			- Second: Second value(default=0).
			- Frame: Frame value(default=0).
			- Field: Field value(default=0).
			- TimeMode: Time mode to get time as(default=kFBTimeModeDefault)."""
		...
	def SetTimeString(self,Time:str,/)->None:
		"""Set time from string.

		### Parameters:
			- Time: String to set time from."""
		...
	@overload
	def __add__(self,arg2:FBTime,/)->FBTime:...
	@overload
	def __add__(self,arg2,/)->FBTime:...
	def __ge__(self,arg2:FBTime,/)->bool:...
	def __gt__(self,arg2:FBTime,/)->bool:...
	@overload
	def __init__(self,Time:int=0,/):...
	@overload
	def __init__(self,Hour:int,Minute:int,Second:int=0,Frame:int=0,Field:int=0,TimeMode:FBTimeMode=FBTimeMode.kFBTimeModeDefault,/):
		"""### Parameters:
			- Hour: Hour value.
			- Minute: Minute value.
			- Second: Second value.
			- Frame: Frame value.
			- Field: Field value.
			- TimeMode: Time mode(default=kFBTimeModeDefault)."""
		...
	@overload
	def __init__(self,arg2:FBTime,/):...
	def __le__(self,arg2:FBTime,/)->bool:...
	def __lt__(self,arg2:FBTime,/)->bool:...
	@overload
	def __sub__(self,arg2:FBTime,/)->FBTime:...
	@overload
	def __sub__(self,arg2,/)->FBTime:...
class FBTimeCode:
	"""TimeCode data structure.

	[See sample: TimeCodeKeying.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_time_code_keying_8py-example.html)"""
	FILM_23976:float
	"""-23.976f"""
	FILM_24:float
	"""-24.0f"""
	FRAMES_11988:float
	"""-119.88f"""
	FRAMES_30:float
	"""-30.0f"""
	FRAMES_5994:float
	"""-59.94f"""
	Frame:float
	FrameRate:float
	MPAL_30:float
	"""-29.971f Currently not supported : "1" is added just to differentiate from NTSC_FULL(-29.97f)"""
	NTSC_DROP:float
	"""Rates."""
	NTSC_FULL:float
	"""-29.97f"""
	PAL_25:float
	"""-25.0f"""
	TimeCodeString:property
	def GetRawFrame(self)->float:
		"""Get the raw value for the frame.

		### Returns:
		raw value for the frame."""
		...
	def GetRawRate(self)->float:
		"""Get the raw value for the rate.

		### Returns:
		raw value for the rate."""
		...
	def GetRawSecond(self)->float:
		"""Get the raw value for the second.

		### Returns:
		raw value for the second."""
		...
	def GetTime(self)->FBTime:
		"""Return a Time corresponding to the timecode."""
		...
	def GetTimeCodeString(self,Format:FBTime.ETimeFormats=FBTime.eDefaultFormat,/)->str:
		"""Get time as a string.

		### Parameters:
			- Format: Format to use for the returned string(default=FBTime::eDefaultFormat).

		### Returns:
		String value of time."""
		...
	def SetTime(self,Time:FBTime,/)->None:
		"""Set TimeCode according to the given time.

		### Parameters:
			- Time: Time value to set."""
		...
	def SetTimeCode(self,Hour:int,Minute:int=0,Second:int=0,Frame:float=0,/)->None:
		"""Set timecode.

		### Parameters:
			- Hour: Hour value.
			- Minute: Minute value.
			- Second: Second value.
			- Frame: Frame value."""
		...
	def SetTimeCodeString(self,Time:str,Format:FBTime.ETimeFormats=FBTime.eDefaultFormat,/)->None:
		"""Set time from string.

		### Parameters:
			- Time: String to set time from.
			- Format: Format to use for the string(default=FBTime::eDefaultFormat)."""
		...
	@overload
	def __init__(self):...
	@overload
	def __init__(self,Rate:float=FRAMES_30,/):
		"""### Parameters:
			- Rate: Framerate value."""
		...
	@overload
	def __init__(self,arg2:FBTimeCode,/):...
class FBTake(FBComponent):
	"""A take is a container for animation in a scene.

	A take stores data about animation for objects. The transport controls ([FBPlayerControl](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_player_control.html "Player control.")) act on the current take.In the UI transport controls, a take's start and end determine when the Timeline indicator starts and stops.You get the current take with [FBSystem::CurrentTake](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_system.html#abb1f929df4eb80aa1189a061ee601c30 "Read Write Property: Current take. See samples: GoToNextTake.py,"), as in the following Python sample:

	```python
	for myTake in FBSystem().Scene.Takes:
	print(myTake.Name)
	```
	To create a take and have it accessible in the Transport control you could use CopyTake (called Duplicate in the UI):Python sample code:

	```python
	from pyfbsdk import *
	newTake = FBSystem().CurrentTake.CopyTake("my new take name")
	```
	C++ sample code:

	```c++
	FBTake* lTake = FBSystem::ThenOne().CurrentTake->CopyTake( "my new take" );
	```
	Or simply create a new empty take like the following:Python sample code:

	```python
	from pyfbsdk import *
	newTake = FBTake("my new take name")
	FBSystem().Scene.Takes.append(newTake)
	```
	C++ sample code:

	```c++
	FBSystem::TheOne()::Scene.Takes.Add( new FBTake( "my new take" ));
	```
	[See samples: MergePreviewAnimationLayers.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_animation_layer_0c_merge_preview_animation_layers_8py-example.html) [ExportAnimationLibrary.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_export_animation_library_8py-example.html) [GoToNextTake.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_go_to_next_take_8py-example.html) [GoToPreviousTake.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_go_to_previous_take_8py-example.html) [MirrorPoseOverTime.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_mirror_pose_over_time_8py-example.html) [MultiLayerKeying.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_multi_layer_keying_8py-example.html) [RenameFirstTakeOnMultipleFiles.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_rename_first_take_on_multiple_files_8py-example.html) [SaveOneTakePerFile.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_save_one_take_per_file_8py-example.html) [TimeCodeKeying.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_time_code_keying_8py-example.html)"""
	Comments:str
	"""Read Write Property: Take comments."""
	LocalTimeSpan:FBTimeSpan
	"""Read Write Property: Local time span."""
	ReferenceTimeSpan:FBTimeSpan
	"""Read Write Property: Reference time span."""
	def AddTimeMark(self,Time:FBTime,/)->int:
		"""Add a time mark to the take.

		It doesn't allow creating a time mark at the same time of another time mark. Note: Internally, the time marks are stored in time order. Adding a time mark before other existing time marks will modify the index of these other time marks.
		### Parameters:
			- Time: Time where to add the time mark on the take.
			- Name: Name of the time mark to add.

		### Returns:
		The index of the time mark added if the operation is successful, -1 otherwise."""
		...
	def ClearAllProperties(self,OnSelectedObjectsOnly:bool,OnLockedProperties:bool=False,/)->None:
		"""Clear the animation on all the properties.

		### Parameters:
			- OnSelectedObjectsOnly: Specify if clear will be performed on all objects or only on the one that are currently selected.
			- OnLockedProperties: Specify if clear will be performed on locked properties as well."""
		...
	def ClearAllPropertiesOnCurrentLayer(self)->None:
		"""Clear all the animation on the current layer."""
		...
	def CopyTake(self,NewTakeName:str,/)->FBTake:
		"""Copy the take.

		Will create a copy of the current take, with the current take data. This is analogous to creating a new take, and copying the current take data into it. The Layers data and the TimeWarp date will be copied. The newly created take will be set as the current take. The newly created take is automatically added to the scene and available in the Transport control.
		### Parameters:
			- NewTakeName: The name for the new take.

		### Returns:
		Handle to the newly created take."""
		...
	def CreateNewLayer(self)->None:
		"""Create a new layer."""
		...
	def DeleteAllTimeMarks(self)->None:
		"""Delete all time marks from the take."""
		...
	def DeleteAnimation(self,StartTime:FBTime=FBTime.MinusInfinity,StopTime:FBTime=FBTime.Infinity,Inclusive:bool=True,LayerID:int=-1,OnLockedProperties:bool=False,/)->bool:
		"""Delete animation (FCurve keys) of this take object within a time range.

		### Parameters:
			- StartTime: Start of time range.
			- StopTime: End of time range.
			- Inclusive: True to include within the time range the keys at pStartTime and pStopTime, false otherwise.
			- LayerID: The animation layer ID being affected by the delete operation, -1 to delete the animation of all animations layers.
			- OnLockedProperties: True to delete animation on locked properties, false to skip deleting animation on locked properties.

		### Returns:
		True if the delete operation is successful (at least one FCurve has been modified), false otherwise (e.g. no keys found within the time range, invalid layer ID, etc.)."""
		...
	def DeleteAnimationOnObjects(self,Objects:list[FBBox],StartTime:FBTime=FBTime.MinusInfinity,StopTime:FBTime=FBTime.Infinity,Inclusive:bool=True,LayerID:int=-1,OnLockedProperties:bool=False,/)->bool:
		"""Delete animation (FCurve keys) of this take object on given objects within a time range.

		### Parameters:
			- Objects: Objects affected by the delete operation.
			- StartTime: Start of time range.
			- StopTime: End of time range.
			- Inclusive: True to include within the time range the keys at pStartTime and pStopTime, false otherwise.
			- LayerID: The animation layer ID being affected by the delete operation, -1 to delete the animation of all animations layers.
			- OnLockedProperties: True to delete animation on locked properties, false to skip deleting animation on locked properties.

		### Returns:
		True if the delete operation is successful (at least one FCurve has been modified), false otherwise (e.g. no keys found within the time range, invalid layer ID, etc.)."""
		...
	def DeleteAnimationOnProperties(self,Properties:list,StartTime:FBTime=FBTime.MinusInfinity,StopTime:FBTime=FBTime.Infinity,Inclusive:bool=True,LayerID:int=-1,OnLockedProperties:bool=False,PropertyComponents:FBPropertyComponents=FBPropertyComponents.kFBPropertyComponentAll,/)->bool:
		"""Delete animation (FCurve keys) of this take object on given properties within a time range.

		### Parameters:
			- Properties: Properties affected by the delete operation.
			- StartTime: Start of time range.
			- StopTime: End of time range.
			- Inclusive: True to include within the time range the keys at pStartTime and pStopTime, false otherwise.
			- LayerID: The animation layer ID being affected by the delete operation, -1 to delete the animation of all animations layers.
			- OnLockedProperties: True to delete animation on locked properties, false to skip deleting animation on locked properties.
			- PropertyComponents: The component bit field considered when performing the delete operation, for properties having such components. By default, all components are considered. If a property don't have any component, this parameter is not affecting that property.

		### Returns:
		True if the delete operation is successful (at least one FCurve has been modified), false otherwise (e.g. no keys found within the time range, invalid layer ID, etc.)."""
		...
	def DeleteTimeMark(self,Index:int,/)->bool:
		"""Delete a time mark from the take.

		Note: Internally, the time marks are stored in time order. Deleting a time mark will modify the index of time marks laying after the deleted time mark.
		### Parameters:
			- Index: Index of the time mark to delete.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def DuplicateSelectedLayers(self)->None:
		"""Duplicate the selected layers.

		This is equivalent of doing a copy-paste."""
		...
	def GetCurrentLayer(self)->int:
		"""Get the current layer for the take.

		### Returns:
		The current layer index."""
		...
	def GetLayer(self,LayerIndex:int,/)->FBAnimationLayer:
		"""Get the layer object that have the specified ID.

		### Parameters:
			- LayerIndex: The index of the layer that will be returned.

		### Returns:
		Layer with the specified ID."""
		...
	def GetLayerByName(self,Name:str,/)->FBAnimationLayer:
		"""Get the layer object that have the specified name.

		### Parameters:
			- Name: The name of the animation layer to get.

		### Returns:
		Layer with the specified name or NULL if no layer has been found."""
		...
	def GetLayerCount(self)->int:
		"""Get the layer count.

		### Returns:
		The layer count."""
		...
	def GetLayerRealSelection(self)->bool:
		"""Real selection for layer.

		Check the SetLayerRealSelection function for more information about this.
		### Returns:
		True if selecting a layer will also select the [FBComponent](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html "MotionBuilder SDK base class.") of that layer."""
		...
	def GetNextTimeMarkIndex(self)->int:
		"""Returns the next time mark index, based on the current local time.

		### Returns:
		The next time mark index, -1 if any next time mark is available."""
		...
	def GetPreviousTimeMarkIndex(self)->int:
		"""Returns the previous time mark index, based on the current local time.

		### Returns:
		The previous time mark index, -1 if any previous time mark is available."""
		...
	def GetTimeMarkAction(self,Index:int,/)->FBTimeMarkAction:
		"""Returns the action associated with a time mark.

		### Parameters:
			- Index: Index of the time mark.

		### Returns:
		The action associated with the time mark."""
		...
	def GetTimeMarkColor(self,Index:int,/)->FBColor:
		"""Returns the color associated with a time mark.

		### Parameters:
			- Index: Index of the time mark.

		### Returns:
		The color associated with the time mark."""
		...
	def GetTimeMarkCount(self)->int:
		"""Returns the number of time marks on the take.

		### Returns:
		The number of time marks on the take."""
		...
	def GetTimeMarkName(self,Index:int,/)->str:
		"""Returns the name associated with a time mark.

		### Parameters:
			- Index: Index of the time mark.

		### Returns:
		The name associated with the time mark."""
		...
	def GetTimeMarkTime(self,Index:int,/)->FBTime:
		"""Returns the time associated with a time mark.

		### Parameters:
			- Index: Index of the time mark.

		### Returns:
		The time associated with the time mark."""
		...
	def MergeLayers(self,MergeOptions:FBAnimationLayerMergeOptions,DeleteMergedLayers:bool,MergeMode:FBMergeLayerMode,MergeLockedProperties:bool=False,/)->None:
		"""Merge the selected layers.

		This is equivalent of pressing the merge button in the Animation Layer editor.
		### Parameters:
			- MergeOptions: Indicate which objects, layers and properties (selected or all) should be merged.
			- DeleteMergedLayers: The source layer will be deleted after the merge if no animation is left on those layers, or if those layers are not parent of another layer.
			- MergeMode: Set the layer mode of the resulting layer, if possible (the BaseAnimation layer cannot be modified).
			- MergeLockedProperties: The properties will be merged even if they are locked."""
		...
	def MoveCurrentLayerDown(self)->bool:
		"""Move the current layer down, similar to using the button to move the layer in the Animation Layer tool.

		Use the SetCurrentLayer to specify the current layer.
		### Returns:
		True if successful."""
		...
	def MoveCurrentLayerUp(self)->bool:
		"""Move the current layer up, similar to using the button to move the layer in the Animation Layer tool.

		Use the SetCurrentLayer to specify the current layer.
		### Returns:
		True if successful."""
		...
	def OffsetAnimation(self,OffsetTime:FBTime,StartTime:FBTime=FBTime.MinusInfinity,StopTime:FBTime=FBTime.Infinity,Inclusive:bool=True,LayerID:int=-1,OnLockedProperties:bool=False,/)->bool:
		"""Offset the animation (FCurve keys) of this take object within a time range by a given offset time.

		Non-moving FCurve keys that are situated in the target range are deleted automatically, to preserve the animation being offset.
		### Parameters:
			- OffsetTime: The offset time to apply.
			- StartTime: Start of time range.
			- StopTime: End of time range.
			- Inclusive: True to include within the time range the keys at pStartTime and pStopTime, false otherwise.
			- LayerID: The animation layer ID being affected by the offset operation, -1 to offset the animation of all animations layers.
			- OnLockedProperties: True to offset animation on locked properties, false to skip offsetting animation on locked properties.

		### Returns:
		True if the offset operation is successful (at least one FCurve has been modified), false otherwise (e.g. no keys found within the time range, invalid layer ID, etc.)."""
		...
	def OffsetAnimationOnObjects(self,Objects:list[FBBox],OffsetTime:FBTime,StartTime:FBTime=FBTime.MinusInfinity,StopTime:FBTime=FBTime.Infinity,Inclusive:bool=True,LayerID:int=-1,OnLockedProperties:bool=False,/)->bool:
		"""Offset the animation (FCurve keys) of this take object on given objects within a time range by a given offset time.

		Non-moving FCurve keys that are situated in the target range are deleted automatically, to preserve the animation being offset.
		### Parameters:
			- Objects: Objects affected by the offset operation.
			- OffsetTime: The offset time to apply.
			- StartTime: Start of time range.
			- StopTime: End of time range.
			- Inclusive: True to include within the time range the keys at pStartTime and pStopTime, false otherwise.
			- LayerID: The animation layer ID being affected by the offset operation, -1 to offset the animation of all animations layers.
			- OnLockedProperties: True to offset animation on locked properties, false to skip offsetting animation on locked properties.

		### Returns:
		True if the offset operation is successful (at least one FCurve has been modified), false otherwise (e.g. no keys found within the time range, invalid layer ID, etc.)."""
		...
	def OffsetAnimationOnProperties(self,Properties:list,OffsetTime:FBTime,StartTime:FBTime=FBTime.MinusInfinity,StopTime:FBTime=FBTime.Infinity,Inclusive:bool=True,LayerID:int=-1,OnLockedProperties:bool=False,PropertyComponents:FBPropertyComponents=FBPropertyComponents.kFBPropertyComponentAll,/)->bool:
		"""Offset the animation (FCurve keys) of this take object on given properties within a time range by a given offset time.

		Non-moving FCurve keys that are situated in the target range are deleted automatically, to preserve the animation being offset.
		### Parameters:
			- Properties: Properties affected by the offset operation.
			- OffsetTime: The offset time to apply.
			- StartTime: Start of time range.
			- StopTime: End of time range.
			- Inclusive: True to include within the time range the keys at pStartTime and pStopTime, false otherwise.
			- LayerID: The animation layer ID being affected by the offset operation, -1 to offset the animation of all animations layers.
			- OnLockedProperties: True to offset animation on locked properties, false to skip offsetting animation on locked properties.
			- PropertyComponents: The component bit field considered when performing the offset operation, for properties having such components. By default, all components are considered. If a property don't have any component, this parameter is not affecting that property.

		### Returns:
		True if the offset operation is successful (at least one FCurve has been modified), false otherwise (e.g. no keys found within the time range, invalid layer ID, etc.)."""
		...
	def PlotAllTakesOnObjects(self,PlotPeriod:FBTime,ObjectsToPlot:list[FBBox],/)->None:
		"""Plot the animation on given objects for all takes.

		This method will plot the animation of all takes to the specified objects. Although the method supports boxes, the most common use case it to specify FBModels that have been cast to boxes.
		### Parameters:
			- PlotPeriod: Period for the plot.
			- ObjectsToPlot: Objects to plot."""
		...
	def PlotAllTakesOnProperties(self,PlotPeriod:FBTime,PropertiesToPlot:list,/)->None:
		"""Plot the animation on given properties for all takes.

		Will plot the animation for all takes on the given properties in the scene.
		### Parameters:
			- PlotPeriod: Period for the plot.
			- PropertiesToPlot: Properties to plot."""
		...
	def PlotAllTakesOnSelected(self,PlotPeriod:FBTime,/)->None:
		"""Plot the animation on selected models for all takes.

		Will plot the animation for all takes on the selected models in the scene.
		### Parameters:
			- PlotPeriod: Period for the plot."""
		...
	def PlotAllTakesOnSelectedProperties(self,PlotPeriod:FBTime,/)->None:
		"""Plot the animation on selected properties for all takes.

		Will plot the animation for all takes on the selected properties in the scene.
		### Parameters:
			- PlotPeriod: Period for the plot."""
		...
	@overload
	def PlotTakeOnObjects(self,PlotPeriod:FBTime,ObjectsToPlot:list[FBBox],/)->None:
		"""Plot the animation on given objects.

		This method will plot the animation of the take to the specified objects. Although the method supports boxes, the most common use case it to specify FBModels that have been cast to boxes.
		### Parameters:
			- PlotPeriod: Period for the plot.
			- ObjectsToPlot: Objects to plot."""
		...
	@overload
	def PlotTakeOnObjects(self,PlotOptions:FBPlotOptions,ObjectsToPlot:list[FBBox],/)->None:
		"""Plot the animation on given objects.

		This method will plot the animation of the take to the specified objects. Although the method supports boxes, the most common use case it to specify FBModels that have been cast to boxes.
		### Parameters:
			- PlotOptions: Option parameters for plotting
			- ObjectsToPlot: Objects to plot."""
		...
	def PlotTakeOnProperties(self,PlotPeriod:FBTime,PropertiesToPlot:list,/)->None:
		"""Plot the animation on given properties.

		Will plot the animation of the take in question on the given properties in the scene.
		### Parameters:
			- PlotPeriod: Period for the plot.
			- PropertiesToPlot: Properties to plot."""
		...
	@overload
	def PlotTakeOnSelected(self,PlotPeriod:FBTime,/)->None:
		"""Plot the animation on selected models.

		Will plot the animation of the take in question on the selected models in the scene.
		### Parameters:
			- PlotPeriod: Period for the plot."""
		...
	@overload
	def PlotTakeOnSelected(self,PlotOptions:FBPlotOptions,/)->None:
		"""Plot the animation on selected models.

		Will plot the animation of the take in question on the selected models in the scene.
		### Parameters:
			- PlotOptions: Option parameters for plotting"""
		...
	@overload
	def PlotTakeOnSelectedProperties(self,PlotPeriod:FBTime,/)->None:
		"""Plot the animation on selected properties.

		Will plot the animation of the take in question on the selected properties in the scene.
		### Parameters:
			- PlotPeriod: Period for the plot."""
		...
	@overload
	def PlotTakeOnSelectedProperties(self,PlotOptions:FBPlotOptions,/)->None:
		"""Plot the animation on selected properties.

		Will plot the animation of the take in question on the selected properties in the scene.
		### Parameters:
			- PlotOptions: Option parameters for plotting"""
		...
	def RemoveLayer(self,LayerIndex:int,/)->None:
		"""Remove a layer.

		### Parameters:
			- LayerIndex: Layer with at the specified index will be removed."""
		...
	def SetCurrentLayer(self,LayerIndex:int,/)->None:
		"""Set the current layer for the take.

		Note that this will not deselect the other layers.
		### Parameters:
			- LayerIndex: The layer index to be set as the current one."""
		...
	def SetLayerRealSelection(self,Value:bool,/)->None:
		"""Set real selection for layer.

		This method is used to specify if using the SelectLayer method of the [FBAnimationLayer](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_animation_layer.html "Used to access animation layer properties and modify them.") object will also select the [FBComponent](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html "MotionBuilder SDK base class.") object. In previous version of MotionBuilder, an animation layer was always selected, causing the layer to be displayed in the property editor. Also, when parsing the selected objects in the SDK, a layer would always be there. Setting this value to false will prevent this.
		### Parameters:
			- Value: True if future layer selection will also select the [FBComponent](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html "MotionBuilder SDK base class.") object."""
		...
	def SetTimeMarkAction(self,Index:int,Action:FBTimeMarkAction,/)->bool:
		"""Sets a new action for an existing time mark.

		### Parameters:
			- Index: Index of the time mark.
			- Action: The new action for the time mark.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def SetTimeMarkColor(self,Index:int,Color:FBColor,/)->bool:
		"""Sets a new color for an existing time mark.

		### Parameters:
			- Index: Index of the time mark.
			- Color: The new color for the time mark.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def SetTimeMarkName(self,Index:int,Name:str,/)->bool:
		"""Sets a new name for an existing time mark.

		### Parameters:
			- Index: Index of the time mark.
			- Name: The new name for the time mark.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def SetTimeMarkTime(self,Index:int,Time:FBTime,/)->int:
		"""Sets a new time for an existing time mark.

		Note: Internally, the time marks are stored in time order. Modifying the time of a time mark may modify the index of all time marks.
		### Parameters:
			- Index: Index of the time mark.
			- Time: The new time for the time mark.

		### Returns:
		The new index of the modified time mark."""
		...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of take."""
		...
class FBFCurve(FBComponent):
	"""FCurve class.

	[See samples: ClearKeysOnSelectedModels.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_clear_keys_on_selected_models_8py-example.html) [FCurveEditor.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_f_curve_editor_8py-example.html)"""
	Keys:FBPropertyListFCurveKey
	"""List: Keys."""
	def CreateInterpolatorCurve(self,CurveType:FBInterpolatorCurveType,/)->FBFCurve:
		"""Create and interpolator curve.

		### Parameters:
			- CurveType: Interpolator curve type to create."""
		...
	def EditBegin(self,KeyCount:int=-1,/)->None:
		"""Setup function to begin adding keys.

		### Parameters:
			- KeyCount: Key to begin adding at(default is -1)."""
		...
	def EditClear(self)->None:
		"""Empty FCurve of all keys."""
		...
	def EditEnd(self,KeyCount:int=-1,/)->None:
		"""End key adding sequence.

		### Parameters:
			- KeyCount: Key to finish adding at (default is -1)."""
		...
	def Evaluate(self,Time:FBTime,/)->float:
		"""Evaluate FCurve at pTime.

		### Parameters:
			- Time: Time at which FCurve is to be evaluated.

		### Returns:
		Value of FCurve at pTime."""
		...
	def GetPostExtrapolationCount(self)->int:
		"""Get count for post extrapolation."""
		...
	def GetPostExtrapolationMode(self)->FBExtrapolationMode:
		"""Get modes for post extrapolation."""
		...
	def GetPreExtrapolationCount(self)->int:
		"""Get count for pre extrapolation."""
		...
	def GetPreExtrapolationMode(self)->FBExtrapolationMode:
		"""Get modes for pre extrapolation."""
		...
	def KeyAdd(self,Time:FBTime,arg3,/)->int:
		"""Add a key at the specified time.

		### Parameters:
			- Time: Time at which to insert the key.
			- Value: Value of the key.
			- Interpolation: Interpolation type of the inserted key, default value is Cubic interpolation.
			- TangentMode: Tangent calculation method of the inserted key, default value is Auto (Smooth).

		### Returns:
		The position of the new key in the list of FCurve keys.
		### Warning:
		Since there are no parameter to indicate the interpolation and tangent mode, the neighbor keys may be affected by the newly inserted key."""
		...
	@overload
	def KeyDelete(self,StartIndex:int,StopIndex:int,/)->bool:
		"""Delete keys within an index range.

		This function is much faster than multiple removes.
		### Parameters:
			- StartIndex: Index of first deleted key.
			- StopIndex: Index of last deleted key.

		### Returns:
		True if the delete operation is successful, false otherwise (e.g. the FCurve is locked, the index range is invalid, etc.)."""
		...
	@overload
	def KeyDelete(self,Start:FBTime,Stop:FBTime,Inclusive:bool=False,/)->bool:
		"""Delete keys within a time range.

		This function is much faster than multiple removes.
		### Parameters:
			- Start: Start of time range.
			- Stop: End of time range.
			- Inclusive: True to include within the time range the keys at pStartTime and pStopTime, false otherwise.

		### Returns:
		True if the delete operation is successful, false otherwise (e.g. the FCurve is locked, no keys found within the time range, etc.)."""
		...
	def KeyDeleteByIndexRange(self,arg2,arg3,/)->bool:...
	def KeyDeleteByTimeRange(self,arg2:FBTime,arg3:FBTime,arg4=None,/)->bool:...
	def KeyGetInterpolation(self,Index:int,/)->FBInterpolation:
		"""Get the key interpolation type at the specified index.

		### Parameters:
			- Index: Index of the key to query.

		### Returns:
		Type of interpolation."""
		...
	def KeyGetLeftBezierTangent(self,Index:int,/)->float:
		"""Get the key left bezier tangent value at the specified index.

		### Parameters:
			- Index: Index of the key to query.

		### Returns:
		Left bezier tangent."""
		...
	def KeyGetLeftDerivative(self,Index:int,/)->float:
		"""Get the key left derivative value at the specified index.

		### Parameters:
			- Index: Index of the key to query.

		### Returns:
		Left derivative value, in units/seconds."""
		...
	def KeyGetLeftTangentWeight(self,Index:int,/)->float:
		"""Get the key left tangent weight at the specified index.

		### Parameters:
			- Index: Index of the key to query.

		### Returns:
		Left tangent weight."""
		...
	def KeyGetMarkedForManipulation(self,Index:int,/)->bool:
		"""Get the key manipulation state.

		### Parameters:
			- Index: Index of the key to query.

		### Returns:
		True if the key is being manipulated, false otherwise."""
		...
	def KeyGetRightBezierTangent(self,Index:int,/)->float:
		"""Get the key right bezier tangent value at the specified index.

		### Parameters:
			- Index: Index of the key to query.

		### Returns:
		Right bezier tangent."""
		...
	def KeyGetRightDerivative(self,Index:int,/)->float:
		"""Get the key right derivative value at the specified index.

		### Parameters:
			- Index: Index of the key to query.

		### Returns:
		Right derivative value, in units/seconds."""
		...
	def KeyGetRightTangentWeight(self,Index:int,/)->float:
		"""Get the key right tangent weight at the specified index.

		### Parameters:
			- Index: Index of the key to query.

		### Returns:
		Right tangent weight."""
		...
	def KeyGetSelected(self,Index:int,/)->bool:
		"""Get the key selected state.

		### Parameters:
			- Index: Index of the key to query.

		### Returns:
		True if the key is selected, false otherwise."""
		...
	def KeyGetTCBBias(self,Index:int,/)->float:
		"""Get the key bias value at the specified index (TCB key).

		### Parameters:
			- Index: Index of the key to query.

		### Returns:
		Bias value."""
		...
	def KeyGetTCBContinuity(self,Index:int,/)->float:
		"""Get the key continuity value at the specified index (TCB key).

		### Parameters:
			- Index: Index of the key to query.

		### Returns:
		Continuity value."""
		...
	def KeyGetTCBTension(self,Index:int,/)->float:
		"""Get the key tension value at the specified index (TCB key).

		### Parameters:
			- Index: Index of the key to query.

		### Returns:
		Tension value."""
		...
	def KeyGetTangentBreak(self,Index:int,/)->bool:
		"""Get the key tangent's break status at the specified index.

		### Parameters:
			- Index: Index of the key to query.

		### Returns:
		Tangent's break status."""
		...
	def KeyGetTangentClampMode(self,Index:int,/)->FBTangentClampMode:
		"""Get the key tangent's clamp method at the specified index.

		### Parameters:
			- Index: Index of the key to query.

		### Returns:
		Tangent's clamp method."""
		...
	def KeyGetTangentConstantMode(self,Index:int,/)->FBTangentConstantMode:
		"""Get the key tangent's constant mode at the specified index.

		### Parameters:
			- Index: Index of the key to query.

		### Returns:
		Tangent's constant mode."""
		...
	def KeyGetTangentCustomIndex(self,Index:int,/)->FBTangentCustomIndex:
		"""Get the key tangent's custom index at the specified index.

		### Parameters:
			- Index: Index of the key to query.

		### Returns:
		Tangent's custom index."""
		...
	def KeyGetTangentMode(self,Index:int,/)->FBTangentMode:
		"""Get the key tangent mode at the specified index.

		### Parameters:
			- Index: Index of the key to query.

		### Returns:
		Tangent calculation method."""
		...
	def KeyGetTangentWeightMode(self,Index:int,/)->FBTangentWeightMode:
		"""Get the tangent weight mode for a key.

		### Parameters:
			- Index: Index of the key to query.

		### Returns:
		Current weight mode."""
		...
	def KeyGetTime(self,Index:int,/)->FBTime:
		"""Get the key time value at the specified index.

		### Parameters:
			- Index: Index of the key to query.

		### Returns:
		Time of key."""
		...
	def KeyGetValue(self,Index:int,/)->float:
		"""Get the key value at the specified index.

		### Parameters:
			- Index: Index of the key to query.

		### Returns:
		Value of the key."""
		...
	def KeyInsert(self,Time:FBTime,Interpolation:FBInterpolation=FBInterpolation.kFBInterpolationCubic,TangentMode:FBTangentMode=FBTangentMode.kFBTangentModeAuto,/)->None:
		"""Insert a key without affecting the curve shape.

		### Parameters:
			- Time: Time at which the key is to be inserted.
			- Interpolation: Interpolation type of the inserted key, default value is Cubic interpolation.
			- TangentMode: Tangent calculation method of the inserted key, default value is Auto (Smooth)."""
		...
	@overload
	def KeyOffset(self,OffsetTime:FBTime,StartIndex:int,StopIndex:int,/)->bool:
		"""Offset keys within an index range by a given offset time.

		When offsetting many keys at once, all non-moving keys that are situated in the target range are deleted automatically, to preserve the animation being offset.
		### Parameters:
			- OffsetTime: The offset time to apply on keys.
			- StartIndex: Index of first key to be offset.
			- StopIndex: Index of last key to be offset.

		### Returns:
		True if the offset operation is successful, false otherwise (e.g. the FCurve is locked, the index range is invalid, etc.)."""
		...
	@overload
	def KeyOffset(self,OffsetTime:FBTime,StartTime:FBTime=FBTime.MinusInfinity,StopTime:FBTime=FBTime.Infinity,Inclusive:bool=True,/)->bool:
		"""Offset keys within a time range by a given offset time.

		Non-moving keys that are situated in the target range are deleted automatically, to preserve the animation being offset.
		### Parameters:
			- OffsetTime: The offset time to apply on keys.
			- StartTime: Start of time range.
			- StopTime: End of time range.
			- Inclusive: True to include within the time range the keys at pStartTime and pStopTime, false otherwise.

		### Returns:
		True if the offset operation is successful, false otherwise (e.g. the FCurve is locked, no keys found within the time range, etc.)."""
		...
	def KeyReplaceBy(self,Source:FBFCurve,Start:FBTime=FBTime.MinusInfinity,Stop:FBTime=FBTime.Infinity,UseExactGivenSpan:bool=False,KeyStartEndOnNoKey:bool=True,/)->None:
		"""Replace keys within a range in current function curve with keys found in a source function curve.

		### Parameters:
			- Source: Source function curve.
			- Start: Start of time range.
			- Stop: End of time range.
			- UseExactGivenSpan: When false, the time of the first and last key in the range will be used.
			- KeyStartEndOnNoKey: When true, inserts a key at the beginning and at the end of the range if there is no key to insert."""
		...
	def KeySetInterpolation(self,Index:int,Value:FBInterpolation,/)->None:
		"""Set the key interpolation type at the specified index.

		### Parameters:
			- Index: Index of the key to set.
			- Value: Type of interpolation."""
		...
	def KeySetLeftBezierTangent(self,Index:int,Value:float,/)->None:
		"""Set the key left bezier tangent value at the specified index.

		### Parameters:
			- Index: Index of the key to set.
			- Value: Left bezier tangent."""
		...
	def KeySetLeftDerivative(self,Index:int,Value:float,/)->None:
		"""Set the key left derivative value at the specified index.

		### Parameters:
			- Index: Index of the key to set.
			- Value: Left derivative value, in units/seconds."""
		...
	def KeySetLeftTangentWeight(self,Index:int,Value:float,/)->None:
		"""Set the key left tangent weight at the specified index.

		### Parameters:
			- Index: Index of the key to set.
			- Value: Left tangent weight."""
		...
	def KeySetMarkedForManipulation(self,Index:int,Value:bool,/)->bool:
		"""Set the key manipulation state.

		### Parameters:
			- Index: Index of the key to set.
			- Value: New manipulation state.

		### Returns:
		True if the operation was successful, false otherwise."""
		...
	def KeySetRightBezierTangent(self,Index:int,Value:float,/)->None:
		"""Set the key right bezier tangent value at the specified index.

		### Parameters:
			- Index: Index of the key to set.
			- Value: Right bezier tangent."""
		...
	def KeySetRightDerivative(self,Index:int,Value:float,/)->None:
		"""Set the key right derivative value at the specified index.

		### Parameters:
			- Index: Index of the key to set.
			- Value: Right derivative value, in units/seconds."""
		...
	def KeySetRightTangentWeight(self,Index:int,Value:float,/)->None:
		"""Set the key right tangent weight at the specified index.

		### Parameters:
			- Index: Index of the key to set.
			- Value: Right tangent weight."""
		...
	def KeySetSelected(self,Index:int,Value:bool,/)->bool:
		"""Set the key selected state.

		### Parameters:
			- Index: Index of the key to set.
			- Value: New selection state.

		### Returns:
		True if the operation was successful, false otherwise."""
		...
	def KeySetTCBBias(self,Index:int,Value:float,/)->None:
		"""Set the key bias value at the specified index (TCB key).

		### Parameters:
			- Index: Index of the key to set.
			- Value: Bias value."""
		...
	def KeySetTCBContinuity(self,Index:int,Value:float,/)->None:
		"""Set the key continuity value at the specified index (TCB key).

		### Parameters:
			- Index: Index of the key to set.
			- Value: Continuity value."""
		...
	def KeySetTCBTension(self,Index:int,Value:float,/)->None:
		"""Set the key tension value at the specified index (TCB key).

		### Parameters:
			- Index: Index of the key to set.
			- Value: Tension value."""
		...
	def KeySetTangentBreak(self,Index:int,Value:bool,/)->None:
		"""Set the key tangent's break status at the specified index.

		### Parameters:
			- Index: Index of the key to set.
			- Value: Tangent's break status."""
		...
	def KeySetTangentClampMode(self,Index:int,Value:FBTangentClampMode,/)->None:
		"""Set the key tangent's clamp method at the specified index.

		### Parameters:
			- Index: Index of the key to set.
			- Value: Tangent's clamp method."""
		...
	def KeySetTangentConstantMode(self,Index:int,Value:FBTangentConstantMode,/)->None:
		"""Set the key tangent's constant mode at the specified index.

		### Parameters:
			- Index: Index of the key to set.
			- Value: Tangent's constant mode."""
		...
	def KeySetTangentCustomIndex(self,Index:int,Value:FBTangentCustomIndex,/)->None:
		"""Set the key tangent's custom index at the specified index.

		### Parameters:
			- Index: Index of the key to set.
			- Value: Tangent's custom index."""
		...
	def KeySetTangentMode(self,Index:int,Value:FBTangentMode,/)->None:
		"""Set the key tangent mode at the specified index.

		### Parameters:
			- Index: Index of the key to set.
			- Value: Tangent calculation method."""
		...
	def KeySetTangentWeightMode(self,Index:int,Value:FBTangentWeightMode,/)->None:
		"""Change the tangent weight for a key.

		Setting the value for LeftTangentWeight/RightTangentWeight will also activate the weight for that part. Please see the note provided with [FBTangentWeightMode](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_tangent_weight_mode.html "Active tangent weight, no/one/both side are active on a key.") for the left weight of a key.
		### Parameters:
			- Index: Index of the key to set.
			- Value: Set the pValue according to the desired mode, kFBTangentWeightModeNone to disable it."""
		...
	def KeySetTime(self,Index:int,Value:FBTime,/)->None:
		"""Set the key time value at the specified index.

		### Parameters:
			- Index: Index of the key to set.
			- Value: Time of key."""
		...
	def KeySetValue(self,Index:int,Value:float,/)->None:
		"""Set the key value at the specified index.

		### Parameters:
			- Index: Index of the key to set.
			- Value: Value of the key."""
		...
	def SetPostExtrapolationCount(self,Count:int,/)->None:
		"""Set count for post extrapolation."""
		...
	def SetPostExtrapolationMode(self,ExtrapolationMode:FBExtrapolationMode,/)->None:
		"""Set modes for post extrapolation."""
		...
	def SetPreExtrapolationCount(self,Count:int,/)->None:
		"""Set count for pre extrapolation."""
		...
	def SetPreExtrapolationMode(self,ExtrapolationMode:FBExtrapolationMode,/)->None:
		"""Set modes for pre extrapolation."""
		...
	def __init__(self):...
class FBAnimationNode(FBComponent):
	"""[See samples: CopyAnimation.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_f_curve_0c_copy_animation_8py-example.html) [ClearKeysOnSelectedModels.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_clear_keys_on_selected_models_8py-example.html) [TraversingRelationConstraint.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_traversing_relation_constraint_8py-example.html) [FCurveEditor.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_f_curve_editor_8py-example.html)"""
	ConnectorType:FBAnimationNodeConnectorType
	"""Read Only Property: Animation node connector type."""
	DefaultInterpolation:FBInterpolation
	"""Read Write Property: Default type of interpolation."""
	FCurve:FBFCurve
	"""Read Write Property: FCurve for animation. [See sample: StartKeysAtCurrentTime.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_start_keys_at_current_time_8py-example.html)"""
	KeyCount:int
	"""Read Only Property: Number of keys."""
	Label:str
	"""Read Write Property: Label (UI Name)."""
	Live:bool
	"""Read Write Property: Is animation live?"""
	Nodes:FBPropertyListAnimationNode
	"""List: List of animation nodes."""
	RecordMode:bool
	"""Read Write Property: Is the node in recording mode (device connectors)?"""
	UserName:str
	"""Read Only Property: Name of animation node."""
	def ConvertGlobalToNodeTime(self,KeyTime:FBTime,/)->FBTime:
		"""Convert global time to node time.

		(NOTE: Only used in the context of a story clip)
		### Parameters:
			- KeyTime: Time of the key to convert."""
		...
	def ConvertNodeToGlobalTime(self,KeyTime:FBTime,/)->FBTime:
		"""Convert node time to global time.

		(NOTE: Only used in the context of a story clip)
		### Parameters:
			- KeyTime: Time of the key to convert."""
		...
	def GetAnimationToPlay(self)->FBAnimationNode:
		"""Get animation node to play from.

		### Returns:
		Animation node to be played."""
		...
	def GetAnimationToRecord(self)->FBAnimationNode:
		"""Get animation node to record to.

		### Returns:
		Animation node to record to."""
		...
	def GetDataDoubleArrayCount(self)->int:
		"""If the DataPtr is of numeric value type ...

		get the size of the array ex: Light Intensity:1, Translation 3
		### Returns:
		Size of DataPtr array."""
		...
	def GetSizeOfData(self)->int:
		"""Get sizeof void Data Ptr."""
		...
	def IsKey(self)->bool:
		"""Verifies if there is a key at the current.

		### Returns:
		true if there is a key at the current time."""
		...
	@overload
	def KeyAdd(self,Time:FBTime,Data:float,Interpolation:FBInterpolation=FBInterpolation.kFBInterpolationCubic,TangentMode:FBTangentMode=FBTangentMode.kFBTangentModeAuto,/)->None:
		"""Add a key to the animation node.

		### Parameters:
			- Time: Time to add key at.
			- Data: Value of data to add at **pTime**.
			- Interpolation: Interpolation type of the inserted key, default value is Cubic interpolation.
			- TangentMode: Tangent calculation method of the inserted key, default value is Auto (Smooth)."""
		...
	@overload
	def KeyAdd(self,Data:float,Interpolation:FBInterpolation=FBInterpolation.kFBInterpolationCubic,TangentMode:FBTangentMode=FBTangentMode.kFBTangentModeAuto,/)->None:
		"""Add a key to the animation node at current time.

		### Parameters:
			- Data: Value of data to add.
			- Interpolation: Interpolation type of the inserted key, default value is Cubic interpolation.
			- TangentMode: Tangent calculation method of the inserted key, default value is Auto (Smooth)."""
		...
	@overload
	def KeyAdd(self,arg2:FBTime,arg3:list,arg4:FBInterpolation|None=None,arg5:FBTangentMode|None=None,/)->None:...
	@overload
	def KeyAdd(self,arg2:list,arg3:FBInterpolation|None=None,arg4:FBTangentMode|None=None,/)->None:...
	def KeyCandidate(self,Time:FBTime=FBTime.Infinity,/)->None:
		"""Keys the current candidate values if no time is specified, at current time.

		### Parameters:
			- Time: Time at which to insert the key."""
		...
	def KeyRemove(self)->None:
		"""Remove key at current time."""
		...
	def KeyRemoveAt(self,Time:FBTime,/)->None:
		"""Remove key at the specified time.

		### Parameters:
			- Time: Time for the key"""
		...
	@overload
	def ReadData(self,arg2:FBEvaluateInfo|None=None,arg3=None,/)->list:...
	@overload
	def ReadData(self,arg2:FBTime,arg3=None,/)->list:...
	def ReadLastEvalData(self)->list:...
	def SetBufferType(self,Global:bool,/)->None:
		"""Set buffer type for ANIMATIONNODE_TYPE_LOCAL_TRANSLATION, ANIMATIONNODE_TYPE_LOCAL_ROTATION and ANIMATIONNODE_TYPE_LOCAL_SCALE.

		### Parameters:
			- Global: Is buffer local or global."""
		...
	def SetCandidate(self,Data:list,CheckLocked:bool=False,/)->bool:
		"""Set the current candidate values for current time.

		### Parameters:
			- CheckLocked: Decides whether to check the locked status.

		### Returns:
		true if successful."""
		...
	def WriteData(self,Data:list,EvaluateInfo:FBEvaluateInfo|None=None,/)->int:
		"""Write data to animation node.

		### Parameters:
			- Data: Data to write to animation node.
			- EvaluateInfo: Node evaluation information (access to system and local time).

		### Returns:
		true if successful."""
		...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of animation node (default is NULL)."""
		...
class FBTimeSpan:
	"""TimeSpan class."""
	def GetDirection(self)->int:
		"""Get the direction of the timespan.

		Returns 1 if positive, -1 otherwise.
		### Returns:
		Direction of timespan."""
		...
	def GetDuration(self)->FBTime:
		"""Get the unsigned duration value of a timespan.

		### Returns:
		Unsigned duration of the timespan."""
		...
	def GetSignedDuration(self)->FBTime:
		"""Get the signed duration value of a timespan.

		### Returns:
		Signed duration of the timespan."""
		...
	def GetStart(self)->FBTime:
		"""Get the start/stop time.

		### Returns:
		Start/Stop time."""
		...
	def GetStop(self)->FBTime:...
	def Set(self,Start:FBTime,Stop:FBTime,/)->None:
		"""Set the TimeSpan.

		### Parameters:
			- Start: Start time.
			- Stop: Stop time."""
		...
	def __init__(self,Start:FBTime|None=None,Stop:FBTime|None=None,/):
		"""### Parameters:
			- Start: Start time(default=0).
			- Stop: Stop time(default=0)."""
		...
class FBTimeWarpManager(FBComponent):
	"""Time Warp Manager Interface to the Time Warp Manager.

	[See sample: TimeWarp.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_f_curve_0c_time_warp_8py-example.html)"""
	def ApplyTimeWarp(self,Take:FBTake,EvalProp:FBProperty,TimeWarp:FBAnimationNode,/)->bool:
		"""Apply the TimeWarp in a Take to an evaluation property, just connect the storing property for the TimeWarp to the evaluation property.

		### Parameters:
			- Take: The Take where the TimeWarp in.
			- EvalProp: The evaluation property to be applied on.
			- TimeWarp: The TimeWarp to apply.

		### Returns:
		True if apply successfully."""
		...
	def DestroyTimeWarpFromTake(self,Take:FBTake,TimeWarp:FBAnimationNode,/)->None:
		"""Destroy the TimeWarp in a Take, and removed from the DataSet.

		### Parameters:
			- Take: The Take where the TimeWarp in.
			- TimeWarp: The TimeWarp to be Destroyed."""
		...
	def FindTimeWarpNickNumberGlobal(self,TimeWarp:FBAnimationNode,/)->int:
		"""Find the Nick Number of one timewarp globally.

		### Parameters:
			- TimeWarp: The TimeWarp queried.

		### Returns:
		the Nick Number of the timewarp."""
		...
	def GetTimeWarpAtIndex(self,Take:FBTake,Index:int,/)->FBAnimationNode:
		"""Get the TimeWarp in a Take At specific Index.

		### Parameters:
			- Take: The Take queried.
			- Index: The index of the TimeWarp.

		### Returns:
		TimeWarp at specific Index in a Take."""
		...
	def GetTimeWarpCount(self,Take:FBTake,/)->int:
		"""Get the count of TimeWarp in a Take.

		### Parameters:
			- Take: The Take queried.

		### Returns:
		the TimeWarp count."""
		...
	def GetTimeWarpFromNickNumber(self,Take:FBTake,Number:int,/)->FBAnimationNode:
		"""Get the timeWarp of specific Nick Number in a Take.

		### Parameters:
			- Take: The Take queried.
			- Number: the Nick Number of one TimeWarp.

		### Returns:
		the TimeWarp of specific Nick Number."""
		...
	def GetTimeWarpNickNumber(self,Take:FBTake,TimeWarp:FBAnimationNode,/)->int:
		"""Get the Nick Number of one TimeWarp in a Take.

		### Parameters:
			- Take: The Take queried.
			- TimeWarp: The TimeWarp queried.

		### Returns:
		the Nick Number of one TimeWarp."""
		...
	def GetTimeWarpNickNumberAtIndex(self,Take:FBTake,Index:int,/)->int:
		"""Get the Nick Number of one TimeWarp At specific index in a Take.

		### Parameters:
			- Take: The Take queried.
			- Index: The index a TimeWarp at.

		### Returns:
		the Nick Number of one TimeWarp At specific index."""
		...
	def RemoveTimeWarp(self,Take:FBTake,EvalProp:FBProperty,/)->None:
		"""Undo apply a timeWarp in a Take to an evaluation property, just disconnect the evaluation property from storing property.

		### Parameters:
			- Take: The Take where the TimeWarp evaluation property connected is in.
			- EvalProp: The evaluation property connected a TimeWarp in the storing property of one take."""
		...
	def RemoveTimeWarpFromScene(self,TimeWarp:FBAnimationNode,/)->None:
		"""Remove a TimeWarp from Scene.

		### Parameters:
			- TimeWarp: The TimeWarp to be Removed."""
		...
	def SetTimeWarpNickNumber(self,Take:FBTake,TimeWarp:FBAnimationNode,Number:int,/)->bool:
		"""Set the Nick Number of one TimeWarp in a Take.

		### Parameters:
			- Take: The Take specific.
			- TimeWarp: The TimeWarp specific.
			- Number: The Nick Number to set.

		### Returns:
		True if set successfully."""
		...
	def TimeWarpAddToTake(self,Take:FBTake,TimeWarp:FBAnimationNode,NickNumber:int=0,/)->None:
		"""Add one TimeWarp to a Take.

		### Parameters:
			- Take: The Take one TimeWarp added to.
			- TimeWarp: The TimeWarp to be added.
			- NickNumber: The Nick Number for the TimeWarp."""
		...
	def TimeWarpClearTake(self,Take:FBTake,/)->None:
		"""Clear all TimeWarp in a Take, and removed from the DataSet.

		### Parameters:
			- Take: The Take to be cleared."""
		...
	def TimeWarpCopyTake(self,DstTake:FBTake,SrcTake:FBTake,/)->None:
		"""Copy all the TimeWarp in one Take, add to another Take.

		### Parameters:
			- DstTake: Copy all TimeWarp to.
			- SrcTake: Copy all TimeWarp from."""
		...
	def TimeWarpCreateNew(self,Name:str,/)->FBAnimationNode:
		"""Create a TimeWarp with a specific name.

		### Parameters:
			- Name: The name for the TimeWarp.

		### Returns:
		the TimeWarp created."""
		...
	def TimeWarpInitTake(self,Take:FBTake,/)->None:
		"""Allocate container for the TimeWarp in one Take.

		### Parameters:
			- Take: The Take allocated for."""
		...
	def TimeWarpMergeCurveNode(self,Take:FBTake,EvalProp:FBProperty,Node:FBAnimationNode,TimeWarpNode:FBAnimationNode,/)->None:
		"""Merge the TimeWarp to a function curve, and Remove the connection between the storing property and the evaluation property for the TimeWarp.

		### Parameters:
			- Take: The Take that the TimeWarp is in.
			- EvalProp: the evaluation property the TimeWarp connected.
			- Node: The function curve to merge on.
			- TimeWarpNode: The TimeWarp to be merged."""
		...
	def TimeWarpRename(self,Take:FBTake,TimeWarp:FBAnimationNode,NewName:str,/)->None:
		"""Rename a TimeWarp.

		### Parameters:
			- Take: The Take where the timeWarp is in.
			- TimeWarp: The TimeWarp to be renamed.
			- NewName: The new name for the TimeWarp."""
		...
	def TimeWarpTakeChange(self)->None:
		"""Call registered callbacks when changes related to TimeWarp happen."""
		...
	def __init__(self):
		"""### Note:
		protect"""
		...
class FBToolLayoutManager(FBComponent):
	"""Tool Layout Manager class.

	This class allows users to interact with Layouts.Sample Python code:

	```python
	from pyfbsdk import *

	lToolLayoutMan = FBToolLayoutManager()

	# Delete all existing custom layout
	for i in range( lToolLayoutMan.GetCustomLayoutCount() ):
		lToolLayoutMan.DeleteLayout( lToolLayoutMan.GetCustomLayoutCount() - 1 )

	# Create a new layout
	lToolLayoutMan.CreateLayout( "MyLayout" )

	# Print the names of all the factory layouts
	print("Factory layouts:")
	print("----------------")
	for aLayoutIdx in range(lToolLayoutMan.GetFactoryLayoutCount()):
		print(lToolLayoutMan.GetLayoutName(-aLayoutIdx-1))
	# Print the names of all the custom layouts
	print("")
	print("Custom layouts:")
	print("----------------")
	for aLayoutIdx in range(lToolLayoutMan.GetCustomLayoutCount()):
		print(lToolLayoutMan.GetLayoutName(aLayoutIdx))
	# Set the Scripting Layout
	lToolLayoutMan.SetCurrentLayout( -2 )

	# Delete the custom layout
	lToolLayoutMan.DeleteLayout( "MyLayout" )
	```"""
	def CreateLayout(self,LayoutName:str,/)->str:
		"""Create a new layout from the current layout state.

		### Parameters:
			- LayoutName: The new layout name to create.

		### Returns:
		The new layout's name (could be different that the one supplied) if the operation is successful, nullptr (C++) or None (Python) otherwise."""
		...
	@overload
	def DeleteLayout(self,LayoutIdx:int,/)->bool:
		"""Delete the layout associated with the given layout index.

		Deleting a factory layout is not permitted.
		### Parameters:
			- LayoutIdx: The layout index to delete.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	@overload
	def DeleteLayout(self,LayoutName:str,/)->bool:
		"""Delete the layout with the given layout name.

		Deleting a factory layout is not permitted.
		### Parameters:
			- LayoutName: The layout name to delete.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def GetAutoUpdateLayout(self)->bool:
		"""Get the 'Auto-update Layout' state value.

		### Returns:
		The 'Auto-update Layout' state value."""
		...
	def GetCurrentLayoutIdx(self)->int:
		"""Get the layout index of the current layout.

		### Returns:
		The layout index of the current layout."""
		...
	def GetCurrentLayoutName(self)->str:
		"""Get the name of the current layout.

		### Returns:
		The name of the current layout."""
		...
	def GetCustomLayoutCount(self)->int:
		"""Get the number of custom layouts.

		### Returns:
		The number of custom layouts."""
		...
	def GetFactoryLayoutCount(self)->int:
		"""Get the number of factory layouts.

		### Returns:
		The number of factory layouts."""
		...
	def GetLayoutName(self,LayoutIdx:int,/)->str:
		"""Get the layout name associated with the given layout index.

		### Parameters:
			- LayoutIdx: The layout index to query. The factory layouts are using negative indices.

		### Returns:
		The layout name if the operation is successful, nullptr (C++) or None (Python) otherwise."""
		...
	def RenameLayout(self,OldLayoutName:str,NewLayoutName:str,/)->str:
		"""Rename a layout.

		Renaming a factory layout is not permitted.
		### Parameters:
			- OldLayoutName: The layout's name to rename.
			- NewLayoutName: The new layout name.

		### Returns:
		The new layout's name (could be different that the one supplied) if the operation is successful, nullptr (C++) or None (Python) otherwise."""
		...
	def SetAutoUpdateLayout(self,AutoUpdate:bool,/)->bool:
		"""Set the 'Auto-update Layout' state value.

		### Parameters:
			- AutoUpdate: The 'Auto-update Layout' state value.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	@overload
	def SetCurrentLayout(self,LayoutIdx:int,/)->bool:
		"""Set the current layout from the given layout index.

		### Parameters:
			- LayoutIdx: The layout index to set as the current layout. The factory layouts are using negative indices.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	@overload
	def SetCurrentLayout(self,LayoutName:str,/)->bool:
		"""Set the current layout from the given layout name.

		### Parameters:
			- LayoutName: The layout's name to set as the current layout.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def UpdateCurrentLayout(self)->bool:
		"""Update the current layout from the current layout state.

		Updating a factory layout is not permitted.
		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def __init__(self):...
class FBTransportAudioManager(FBComponent):
	"""Transport Tool Audio Manager class.

	This class allows users to interact with the Audio Manager of the Transport Tool."""
	def GetAudioClip(self)->FBAudioClip:
		"""Get the Audio Clip displayed on the Transport Tool.

		### Returns:
		The Audio Clip displayed, nullptr (C++) / None (Python) if any."""
		...
	def GetAudioTrack(self)->FBStoryTrack:
		"""Get the Audio Track displayed on the Transport Tool.

		### Returns:
		The Audio Track displayed, nullptr (C++) / None (Python) if any."""
		...
	def GetLockPitchToSpeed(self)->bool:
		"""Get the 'Lock Pitch to Speed' state.

		### Returns:
		True if the 'Lock Pitch to Speed' state is set, false otherwise."""
		...
	def GetShowAudio(self)->bool:
		"""Get the 'Show Audio' state.

		### Returns:
		True if the 'Show Audio' state is set, false otherwise."""
		...
	def GetShowLeftChannel(self)->bool:
		"""Get the 'Show Left Channel' state.

		### Returns:
		True if the 'Show Left Channel' state is set, false otherwise."""
		...
	def GetShowRightChannel(self)->bool:
		"""Get the 'Show Right Channel' state.

		### Returns:
		True if the 'Show Right Channel' state is set, false otherwise."""
		...
	def RemoveAudio(self)->bool:
		"""Remove the audio clip or audio track currently displayed on the Transport Tool.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def SetAudioClip(self,AudioClip:FBAudioClip,/)->bool:
		"""Set the Audio Clip to display on the Transport Tool.

		### Parameters:
			- AudioClip: The Audio Clip to display.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def SetAudioTrack(self,AudioTrack:FBStoryTrack,/)->bool:
		"""Set the Audio Track to display on the Transport Tool.

		### Parameters:
			- AudioTrack: The Audio Track to display.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def SetLockPitchToSpeed(self,Lock:bool,/)->bool:
		"""Set the 'Lock Pitch to Speed' state.

		### Parameters:
			- Lock: True to lock pitch to speed, false otherwise.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def SetShowAudio(self,Show:bool,/)->bool:
		"""Set the 'Show Audio' state.

		### Parameters:
			- Show: True to show the Audio waveform, false otherwise.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def SetShowLeftChannel(self,Show:bool,/)->bool:
		"""Set the 'Show Left Channel' state.

		### Parameters:
			- Show: True to show the left channel, false otherwise.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def SetShowRightChannel(self,Show:bool,/)->bool:
		"""Set the 'Show Right Channel' state.

		### Parameters:
			- Show: True to show the right channel, false otherwise.

		### Returns:
		True if the operation is successful, false otherwise."""
		...
	def __init__(self):...
class FBTreeNode(FBComponent):
	"""A node in the tree view."""
	Checked:bool
	"""Read Write Property: Is [FBTreeNode](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_tree_node.html "A node in the tree view.") checked."""
	Reference:int
	"""Read Write Property: Data to be associated to this node."""
class FBUV:
	@overload
	def CopyFrom(self,arg2:FBUV,/)->FBUV:...
	@overload
	def CopyFrom(self,arg2:list,/)->FBUV:...
	def GetBufferAddress(self)->int:...
	def GetList(self)->list:...
	def IsEqual(self,arg2:FBUV,/)->bool:...
	def NotEqual(self,arg2:FBUV,/)->bool:...
	@overload
	def __add__(self,arg2:FBUV,/)->FBUV:...
	@overload
	def __add__(self,arg2,/)->FBUV:...
	def __getitem__(self,arg2,/)->float:...
	@overload
	def __iadd__(self,arg2:FBUV,/)->FBUV:...
	@overload
	def __iadd__(self,arg2,/)->FBUV:...
	@overload
	def __idiv__(self,arg2:FBUV,/)->FBUV:...
	@overload
	def __idiv__(self,arg2,/)->FBUV:...
	@overload
	def __imul__(self,arg2:FBUV,/)->FBUV:...
	@overload
	def __imul__(self,arg2,/)->FBUV:...
	@overload
	def __init__(self):...
	@overload
	def __init__(self,arg2:FBUV,/):...
	@overload
	def __init__(self,arg2:float,arg3:float,/):...
	@overload
	def __init__(self,arg2,/):...
	@overload
	def __init__(self,arg2:list,/):...
	@overload
	def __isub__(self,arg2:FBUV,/)->FBUV:...
	@overload
	def __isub__(self,arg2,/)->FBUV:...
	def __len__(self)->int:...
	@overload
	def __mul__(self,arg2:FBUV,/)->FBUV:...
	@overload
	def __mul__(self,arg2,/)->FBUV:...
	def __neg__(self)->FBUV:...
	def __setitem__(self,arg2,arg3:float,/):...
	@overload
	def __sub__(self,arg2:FBUV,/)->FBUV:...
	@overload
	def __sub__(self,arg2,/)->FBUV:...
	@overload
	def __truediv__(self,arg2:FBUV,/)->FBUV:...
	@overload
	def __truediv__(self,arg2,/)->FBUV:...
	def __iter__(self)->Iterator[float]:...
class FBUndoManager(FBComponent):
	"""Access to global undo and redo functionality.

	Users have the possibility of undoing and redoing actions performed using the GUI, and interacting with the undo and redo stacks with custom actions.All undo/redo related functions should only be called inside UI event callback. Users should call [TransactionBegin()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_undo_manager.html#af7427e75659bfb18a593655de6170fa9 "Open transaction stack for adding transactions.")/TransactionEnd() in pairs, Transaction stack must be closed before UI event callback return.This class cannot be used as a base class.

	[See sample: IndividualUndoCalls.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_basic_operations_0c_individual_undo_calls_8py-example.html)"""
	OnRedo:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: A redo operation will be executed."""
	OnRedoCompleted:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: A redo operation has been executed."""
	OnUndo:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: An undo operation will be executed."""
	OnUndoCompleted:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: An undo operation has been executed."""
	def ActiveOperation(self)->bool:
		"""Determine if an undo operation is in action.

		### Returns:
		true the Undo Manager is performing an Undo or a Redo operation."""
		...
	def Clear(self)->bool:
		"""Clear the undo and redo stacks.

		### Returns:
		A boolean value indicating success (true) or failure (false)."""
		...
	def Redo(self)->None:
		"""Redo last undone action."""
		...
	def TransactionAddModelTRS(self,Model:FBModel,/)->bool:
		"""Add Transaction if transaction stack is open.

		Quick Function to add Model TRS in Undo Stack
		### Parameters:
			- Model: Model to backup TRS

		### Returns:
		true if add transaction successfully."""
		...
	def TransactionAddObjectDestroy(self,Object:FBComponent,/)->bool:
		"""Add Transaction if transaction stack is open.

		Function to add object to destroy in Undo Stack. No need to call [FBDelete()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_component.html#aa85a55e68d7403dbd4238f3e30e83119 "Open Reality deletion function.") on the object after calling this function.
		### Parameters:
			- Object: Object to backup

		### Returns:
		true if add transaction successfully."""
		...
	def TransactionAddProperty(self,Property:FBProperty,/)->bool:
		"""Add Transaction if transaction stack is open.

		Quick Function to add property value in Undo Stack
		### Parameters:
			- Property: Property to backup

		### Returns:
		true if add transaction successfully."""
		...
	def TransactionBegin(self,TransactionName:str,/)->bool:
		"""Open transaction stack for adding transactions.

		Users should call [TransactionBegin()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_undo_manager.html#af7427e75659bfb18a593655de6170fa9 "Open transaction stack for adding transactions.")/TransactionEnd() in pairs, Transaction stack must be closed before UI event callback return.
		### Parameters:
			- TransactionName: Name of Transaction.

		### Returns:
		true if open transaction stack successfully."""
		...
	def TransactionEnd(self)->bool:
		"""Close transaction stack.

		Users should call [TransactionBegin()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_undo_manager.html#af7427e75659bfb18a593655de6170fa9 "Open transaction stack for adding transactions.")/TransactionEnd() in pairs, Transaction stack must be closed before UI event callback return.
		### Returns:
		true if transaction close successfully."""
		...
	def TransactionIsOpen(self)->bool:
		"""Query if transaction stack is already open.

		### Returns:
		true if transaction is already open."""
		...
	def Undo(self,NoRedo:bool=False,/)->None:
		"""Undo last action.

		### Parameters:
			- NoRedo: If true, once the action is undone, it cannot be redone."""
		...
	def __init__(self):...
class FBUserObject(FBBox):
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: User object name."""
		...
class FBVector2d:
	"""Vector2d class.

	This class creates a list like object, which can be modified using the list protocol method. But unlike lists, its length is fixed: it always contain 2 floating point values. Thus it does not support the any list methods that would affect its length. The values within can be changed, usually via the bracket operator.

	```python
	# Supported list protocol methods:
	color = FBColor()
	len(color)
	print(color[0])
	color[0] = 1.0
	```
	### Warning:
	Slicing is not supported by this object."""
	@overload
	def CopyFrom(self,arg2:FBVector2d,/)->FBVector2d:...
	@overload
	def CopyFrom(self,arg2:list,/)->FBVector2d:...
	def GetBufferAddress(self)->int:...
	def GetList(self)->list:...
	def IsEqual(self,arg2:FBVector2d,/)->bool:...
	def NotEqual(self,arg2:FBVector2d,/)->bool:...
	@overload
	def __add__(self,arg2:FBVector2d,/)->FBVector2d:...
	@overload
	def __add__(self,arg2,/)->FBVector2d:...
	def __getitem__(self,Index:int,/)->float:
		"""Returns the ith component Corresponds to python: print v[1].

		### Parameters:
			- Index: Index of the components to get (0 to 1)

		### Returns:
		Color component value."""
		...
	@overload
	def __iadd__(self,arg2:FBVector2d,/)->FBVector2d:...
	@overload
	def __iadd__(self,arg2,/)->FBVector2d:...
	@overload
	def __idiv__(self,arg2:FBVector2d,/)->FBVector2d:...
	@overload
	def __idiv__(self,arg2,/)->FBVector2d:...
	@overload
	def __imul__(self,arg2:FBVector2d,/)->FBVector2d:...
	@overload
	def __imul__(self,arg2,/)->FBVector2d:...
	@overload
	def __init__(self):
		"""Default constructor, both values within are set to 0.0."""
		...
	@overload
	def __init__(self,Vector2d:FBVector2d,/):
		"""Copy constructor. Copy values from another instance."""
		...
	@overload
	def __init__(self,X:float,Y:float,/):
		"""Explicitely construct a vector by specifying its values."""
		...
	@overload
	def __init__(self,arg2:tuple[float,float],/):
		"""A vector can be built from any python object with supports the tuple interface and is of a lenght of 2."""
		...
	@overload
	def __init__(self,arg2:list,/):...
	@overload
	def __isub__(self,arg2:FBVector2d,/)->FBVector2d:...
	@overload
	def __isub__(self,arg2,/)->FBVector2d:...
	def __len__(self)->int:
		"""Returns the number of elements.

		Corresponds to python: len(object)"""
		...
	@overload
	def __mul__(self,arg2:FBVector2d,/)->FBVector2d:...
	@overload
	def __mul__(self,arg2,/)->FBVector2d:...
	def __neg__(self)->FBVector2d:...
	def __setitem__(self,Index:int,ComponentValue:float,/):
		"""Sets the ith components Corresponds to python: v[1] = 0.5.

		### Parameters:
			- Index: Index of the components to set (0 to 1)
			- ComponentValue: Value of component to set"""
		...
	@overload
	def __sub__(self,arg2:FBVector2d,/)->FBVector2d:...
	@overload
	def __sub__(self,arg2,/)->FBVector2d:...
	@overload
	def __truediv__(self,arg2:FBVector2d,/)->FBVector2d:...
	@overload
	def __truediv__(self,arg2,/)->FBVector2d:...
	def __iter__(self)->Iterator[float]:...
class FBVector3d:
	"""Vector3d class.

	This class creates a list like object, which can be modified using the list protocol method. But unlike lists, its length is fixed: it always contain 3 floating point values. Thus it does not support the any list methods that would affect its length. The values within can be changed, usually via the bracket operator.

	```python
	# Supported list protocol methods:
	color = FBColor()
	len(color)
	print(color[0])
	color[0] = 1.0
	```
	### Warning:
	Slicing is not supported by this object."""
	@overload
	def CopyFrom(self,arg2:FBVector3d,/)->FBVector3d:...
	@overload
	def CopyFrom(self,arg2:list,/)->FBVector3d:...
	def CrossProduct(self,arg2:FBVector3d,/)->FBVector3d:...
	def Distance(self,arg2:FBVector3d,/)->float:...
	def DotProduct(self,arg2:FBVector3d,/)->float:...
	def GetBufferAddress(self)->int:...
	def GetList(self)->list:...
	def IsEqual(self,arg2:FBVector3d,/)->bool:...
	def Length(self)->float:...
	def Normalize(self)->FBVector3d:...
	def NotEqual(self,arg2:FBVector3d,/)->bool:...
	def SquareLength(self)->float:...
	@overload
	def __add__(self,arg2:FBVector3d,/)->FBVector3d:...
	@overload
	def __add__(self,arg2,/)->FBVector3d:...
	def __getitem__(self,Index:int,/)->float:
		"""Returns the ith component Corresponds to python: print v[1].

		### Parameters:
			- Index: Index of the components to get (0 to 2)

		### Returns:
		Color component value."""
		...
	@overload
	def __iadd__(self,arg2:FBVector3d,/)->FBVector3d:...
	@overload
	def __iadd__(self,arg2,/)->FBVector3d:...
	@overload
	def __idiv__(self,arg2:FBVector3d,/)->FBVector3d:...
	@overload
	def __idiv__(self,arg2,/)->FBVector3d:...
	@overload
	def __imul__(self,arg2:FBVector3d,/)->FBVector3d:...
	@overload
	def __imul__(self,arg2,/)->FBVector3d:...
	@overload
	def __init__(self):
		"""Default constructor, all 3 values within are set to 0.0."""
		...
	@overload
	def __init__(self,Vector3d:FBVector3d,/):
		"""Copy constructor. Copy values from another instance."""
		...
	@overload
	def __init__(self,X:float,Y:float,Z:float,/):
		"""Explicitely construct a vector by specifying its values."""
		...
	@overload
	def __init__(self,arg2:tuple[float,float,float],/):
		"""A vector can be built from any python object with supports the tuple interface and is of a lenght of 3."""
		...
	@overload
	def __init__(self,arg2:list,/):...
	@overload
	def __isub__(self,arg2:FBVector3d,/)->FBVector3d:...
	@overload
	def __isub__(self,arg2,/)->FBVector3d:...
	def __len__(self)->int:
		"""Returns the number of elements.

		Corresponds to python: len(object)"""
		...
	@overload
	def __mul__(self,arg2:FBVector3d,/)->FBVector3d:...
	@overload
	def __mul__(self,arg2,/)->FBVector3d:...
	def __neg__(self)->FBVector3d:...
	def __setitem__(self,Index:int,ComponentValue:float,/):
		"""Sets the ith components Corresponds to python: v[1] = 0.5.

		### Parameters:
			- Index: Index of the components to set (0 to 2)
			- ComponentValue: Value of component to set"""
		...
	@overload
	def __sub__(self,arg2:FBVector3d,/)->FBVector3d:...
	@overload
	def __sub__(self,arg2,/)->FBVector3d:...
	@overload
	def __truediv__(self,arg2:FBVector3d,/)->FBVector3d:...
	@overload
	def __truediv__(self,arg2,/)->FBVector3d:...
	def __iter__(self)->Iterator[float]:...
class FBVector4d:
	"""Vector4d class.

	This class creates a list like object, which can be modified using the list protocol method. But unlike lists, its length is fixed: it always contain 4 floating point values. Thus it does not support the any list methods that would affect its length. The values within can be changed, usually via the bracket operator.

	```python
	# Supported list protocol methods:
	color = FBColor()
	len(color)
	print(color[0])
	color[0] = 1.0
	```
	### Warning:
	Slicing is not supported by this object."""
	@overload
	def CopyFrom(self,arg2:FBVector4d,/)->FBVector4d:...
	@overload
	def CopyFrom(self,arg2:list,/)->FBVector4d:...
	def CrossProduct(self,arg2:FBVector4d,/)->FBVector4d:...
	def Distance(self,arg2:FBVector4d,/)->float:...
	def DotProduct(self,arg2:FBVector4d,/)->float:...
	def GetBufferAddress(self)->int:...
	def GetList(self)->list:...
	def IsEqual(self,arg2:FBVector4d,/)->bool:...
	def Length(self)->float:...
	def Normalize(self)->FBVector4d:...
	def NotEqual(self,arg2:FBVector4d,/)->bool:...
	def SquareLength(self)->float:...
	@overload
	def __add__(self,arg2:FBVector4d,/)->FBVector4d:...
	@overload
	def __add__(self,arg2,/)->FBVector4d:...
	def __getitem__(self,Index:int,/)->float:
		"""Returns the ith component Corresponds to python: print v[1].

		### Parameters:
			- Index: Index of the components to get (0 to 3)

		### Returns:
		Color component value."""
		...
	@overload
	def __iadd__(self,arg2:FBVector4d,/)->FBVector4d:...
	@overload
	def __iadd__(self,arg2,/)->FBVector4d:...
	@overload
	def __idiv__(self,arg2:FBVector4d,/)->FBVector4d:...
	@overload
	def __idiv__(self,arg2,/)->FBVector4d:...
	@overload
	def __imul__(self,arg2:FBVector4d,/)->FBVector4d:...
	@overload
	def __imul__(self,arg2,/)->FBVector4d:...
	@overload
	def __init__(self):
		"""Default constructor, all 4 values within are set to 0.0."""
		...
	@overload
	def __init__(self,Vector4d:FBVector4d,/):
		"""Copy constructor. Copy values from another instance."""
		...
	@overload
	def __init__(self,X:float,Y:float,Z:float,A:float,/):
		"""Explicitely construct a vector by specifying its values."""
		...
	@overload
	def __init__(self,arg2:tuple[float,float,float,float],/):
		"""A vector can be built from any python object with supports the tuple interface and is of a lenght of 4."""
		...
	@overload
	def __init__(self,arg2:list,/):...
	@overload
	def __isub__(self,arg2:FBVector4d,/)->FBVector4d:...
	@overload
	def __isub__(self,arg2,/)->FBVector4d:...
	def __len__(self)->int:
		"""Returns the number of elements.

		Corresponds to python: len(object)"""
		...
	@overload
	def __mul__(self,arg2:FBVector4d,/)->FBVector4d:...
	@overload
	def __mul__(self,arg2,/)->FBVector4d:...
	def __neg__(self)->FBVector4d:...
	def __setitem__(self,Index:int,ComponentValue:float,/):
		"""Sets the ith components Corresponds to python: v[1] = 0.5.

		### Parameters:
			- Index: Index of the components to set (0 to 3)
			- ComponentValue: Value of component to set"""
		...
	@overload
	def __sub__(self,arg2:FBVector4d,/)->FBVector4d:...
	@overload
	def __sub__(self,arg2,/)->FBVector4d:...
	@overload
	def __truediv__(self,arg2:FBVector4d,/)->FBVector4d:...
	@overload
	def __truediv__(self,arg2,/)->FBVector4d:...
	def __iter__(self)->Iterator[float]:...
class FBVertex:
	"""Vertex class.

	Similar in use to [FBVector4d](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_vector4d.html "Vector4d class.")

	```python
	# Supported list protocol methods:
	v = FBVertex()
	len(v)
	print(v[0])
	v[0] = 1.0
	```
	### Warning:
	Slicing is not supported by this object."""
	@overload
	def CopyFrom(self,arg2:FBVertex,/)->FBVertex:...
	@overload
	def CopyFrom(self,arg2:list,/)->FBVertex:...
	def CrossProduct(self,arg2:FBVertex,/)->FBVertex:...
	def Distance(self,arg2:FBVertex,/)->float:...
	def DotProduct(self,arg2:FBVertex,/)->float:...
	def GetBufferAddress(self)->int:...
	def GetList(self)->list:...
	def IsEqual(self,arg2:FBVertex,/)->bool:...
	def Length(self)->float:...
	def Normalize(self)->FBVertex:...
	def NotEqual(self,arg2:FBVertex,/)->bool:...
	def SquareLength(self)->float:...
	@overload
	def __add__(self,arg2:FBVertex,/)->FBVertex:...
	@overload
	def __add__(self,arg2,/)->FBVertex:...
	def __getitem__(self,Index:int,/)->float:
		"""Returns the ith component Corresponds to python: print v[1].

		### Parameters:
			- Index: Index of the components to get (0 to 1)

		### Returns:
		Color component value."""
		...
	@overload
	def __iadd__(self,arg2:FBVertex,/)->FBVertex:...
	@overload
	def __iadd__(self,arg2,/)->FBVertex:...
	@overload
	def __idiv__(self,arg2:FBVertex,/)->FBVertex:...
	@overload
	def __idiv__(self,arg2,/)->FBVertex:...
	@overload
	def __imul__(self,arg2:FBVertex,/)->FBVertex:...
	@overload
	def __imul__(self,arg2,/)->FBVertex:...
	@overload
	def __init__(self):...
	@overload
	def __init__(self,arg2:FBVertex,/):...
	@overload
	def __init__(self,arg2:float,arg3:float,arg4:float,arg5:float,/):...
	@overload
	def __init__(self,arg2,/):...
	@overload
	def __init__(self,arg2:list,/):...
	@overload
	def __isub__(self,arg2:FBVertex,/)->FBVertex:...
	@overload
	def __isub__(self,arg2,/)->FBVertex:...
	def __len__(self)->int:
		"""Returns the number of elements.

		Corresponds to python: len(object)"""
		...
	@overload
	def __mul__(self,arg2:FBVertex,/)->FBVertex:...
	@overload
	def __mul__(self,arg2,/)->FBVertex:...
	def __neg__(self)->FBVertex:...
	def __setitem__(self,Index:int,ComponentValue:float,/):
		"""Sets the ith components Corresponds to python: v[1] = 0.5.

		### Parameters:
			- Index: Index of the components to set (0 to 1)
			- ComponentValue: Value of component to set"""
		...
	@overload
	def __sub__(self,arg2:FBVertex,/)->FBVertex:...
	@overload
	def __sub__(self,arg2,/)->FBVertex:...
	@overload
	def __truediv__(self,arg2:FBVertex,/)->FBVertex:...
	@overload
	def __truediv__(self,arg2,/)->FBVertex:...
	def __iter__(self)->Iterator[float]:...
class FBVideo(FBBox):
	"""Video media class.

	Similar to the [FBModel](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_model.html "Model class.") class, the [FBVideo](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_video.html "Video media class.") class serves as a general media class for images, video clips and video memory, as well as the possibility of custom formats and custom live cards.To have a valid [FBVideo](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_video.html "Video media class.") object, it must be constructed with a string pointing to a valid media file. After the creation, the method 'IsValid()' should be used to confirm the object's status. An invalid object cannot be used or interact with any other application object. The only property that can be read and modified is its 'Filename'. To make convert an invalid [FBVideo](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_video.html "Video media class.") object into a valid one, simply change its Filename property to point to a supported media file.

	[See sample: DeleteUnusedMedia.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_delete_unused_media_8py-example.html)"""
	KeepOnGPU:bool
	"""Read Write Property: Don't auto flush from GPU if true. session runtime flag, won't be saved."""
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of video media.

		### Warning:
		The pName parameter must point to a valid media file, otherwise the object will not be valid. Use the method 'IsValid()' to confirm the object status."""
		...
class FBVideoClip(FBVideo):
	"""[See sample: VideoClip.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_story_0c_video_clip_8py-example.html)"""
	CurrentFrame:int
	"""Read Write Property: Current frame."""
	CurrentFrameTime:FBTime
	"""Read Write Property: Current time in clip."""
	CurrentFrameTimeCode:FBTime
	"""Read Only Property: Embedded timecode from current frame in clip. Use the method GetEmbeddedTimecode to get the timecode of a different frame than the current frame."""
	Filename:str
	"""Read Write Property: Filename of media."""
	Format:FBVideoFormat
	"""Read Only Property: Video format."""
	FrameRate:float
	"""Read Write Property: Frame rate."""
	FrameTime:FBTime
	"""Read Only Property: Inverse of FPS, time per frame"""
	FreeRunning:bool
	"""Read Write Property: Is free Running on?"""
	Height:int
	"""Read Only Property: Height of image."""
	InterlaceMode:FBVideoInterlaceMode
	"""Read Write Property: Interlace mode."""
	LastFrame:int
	"""Read Only Property: Last frame in clip."""
	LastFrameTime:FBTime
	"""Read Only Property: Time of last frame"""
	Loop:bool
	"""Read Write Property: Loop video clip?"""
	PlaySpeed:float
	"""Read Write Property: Playback speed."""
	PowerOfTwoHeight:int
	"""Read Only Property: Closest power of two value superior to height of image."""
	PowerOfTwoWidth:int
	"""Read Only Property: Closest power of two value superior to width of image."""
	ProxyMode:FBVideoProxyMode
	"""Read Write Property: Proxy mode."""
	RelativePath:str
	"""Read Only Property: Relative path of media."""
	StartFrame:int
	"""Read Write Property: Frame to begin video playback from."""
	StopFrame:int
	"""Read Write Property: Frame to end video playback at."""
	StorageMode:FBVideoStorageMode
	"""Read Write Property: Storage mode."""
	TimeOffset:FBTime
	"""Read Write Property: Temporal offset for beginning of video."""
	Width:int
	"""Read Only Property: Width of image."""
	def DrawImage(self,X:int=0,Y:int=0,W:int=-1,H:int=-1,Frame:int=-1,/)->None:
		"""Draw a frame of the image to the current view.

		### Parameters:
			- X: X position of image (default=0).
			- Y: Y position of image (default=0).
			- W: Width of image (default=-1).
			- H: Height of image (default=-1).
			- Frame: Frame to draw (default=-1)."""
		...
	def GetEmbeddedTimecode(self,arg2,/)->FBTimeCode:
		"""Get the embedded timecode associated to a video clip frame.

		### Parameters:
			- Frame: Video clip frame to get timecode for.
			- TimeCode: The timecode object being filled by this method.

		### Returns:
		True if an embedded timecode is retrieved from the video clip, false otherwise. (Python: If no embedded timecode is retrieved, returns an [FBTimeCode](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_time_code.html "TimeCode data structure.") object with its time set to [FBTime::Infinity](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_time.html#ad4cdfb3a31e984e36d78499115839636 "Time constant: Infinity, the largest time value."))."""
		...
	def GetTextureID(self)->int:
		"""Get the texture ID.

		### Returns:
		ID of the texture"""
		...
	def IsValid(self)->bool:
		"""Verifies the validity of the [FBVideo](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_video.html "Video media class.") object.

		### Returns:
		true if data is valid."""
		...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of video media.

		### Warning:
		The pName parameter must point to a valid media file, otherwise the object will not be valid. Use the method '[IsValid()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_video_clip.html#a9dcb9b43a3d0fa9003d4c1c9d921f6b2 "Verifies the validity of the FBVideo object.")' to confirm the object status."""
		...
class FBVideoClipImage(FBVideoClip):
	ImageSequence:bool
	"""Read Write Property: Clip is an image sequence?"""
	MaxMipMapResolution:FBVideoResolution
	"""Read Write Property: Maximum MipMap resolution will be loaded into GPU."""
	UseSystemFrameRate:bool
	"""Read Write Property: Clip is using system frame rate?"""
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of image file."""
		...
class FBVideoCodecManager:
	"""Video Codec manager class.

	Use to set or get codec used and codec params

	[See samples: codecExamples.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_rendering_0ccodec_examples_8py-example.html) [render.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_rendering_0crender_8py-example.html)"""
	VideoCodecMode:FBVideoCodecMode
	"""Read Write Property: This decide how the system behaves when ask to render a file (codec dialog, uncompress, use default codec)"""
	def GetCodecIdList(self,FileFormatInfo:str,/)->list:
		"""GetCodecIdList.

		Get all codec id available for a given file format.
		### Parameters:
			- FileFormatInfo: file format description string (AVI, MOV...)
			- CodecList: Codec list id"""
		...
	def GetDefaultCodec(self,FileFormatInfo:str,/)->str:
		"""GetDefaultCodec.

		Get the default codec id for a given file format. This is the codec that will be used if codec mode is FBVideoCodecUseDefault
		### Parameters:
			- FileFormatInfo: file format description string (AVI, MOV...)"""
		...
	def RegisterExternalVideoFormat(self,FormatSuffix:str,/)->bool:
		"""Register external video format suffix.

		Only alphabetic and number is allowed in provided suffix, and can not be empty suffix or the system exist suffixes. This will allow this suffix to be appeared in the filters of file dialog when importing video, also allow to create a texture/video object with a path containing this suffix via SDK. However it will the custom SDK plug-in developer's responsibility to load the file into memory.
		### Parameters:
			- FormatSuffix: Suffix/File extension of external video file format

		### Returns:
		true if register successful
		### Remarks:
		After register an external video format, and save a scene with this kind of video. when start MotionBuilder next time and before load the scene back,

		It is necessary to call RegisterExternalVideoFormat to register this kind of video format again, otherwise this kind of video will not be loaded."""
		...
	def SetDefaultCodec(self,FileFormatInfo:str,CodecId:str,/)->None:
		"""SetDefaultCodec.

		Set the default codec id for a given file format. This is the codec that will be used if codec mode is FBVideoCodecUseDefault
		### Parameters:
			- FileFormatInfo: file format description string (AVI, MOV...)
			- CodecId: the codec id to set as default"""
		...
	def __init__(self):...
class FBVideoGrabOptions:
	"""Video Grabbing Options.

	Contain options to control how the grabbing process will occur."""
	AntiAliasing:bool
	"""Read Write Property: If true, video frames will be anti-aliased."""
	AudioCustomStandaloneFileName:FBPropertyString
	"""Destination for the custom audio standalone file, if mAudioUseCustomStandaloneFileName is set to true."""
	AudioOutputLocation:FBAudioOutputLocation
	"""Audio output location when rendering using a video format (for still image formats & SWF (Flash) format, the audio is always rendered in a standalone file)."""
	AudioRenderFormat:int
	"""Read Write Property: Audio render format."""
	AudioUseCustomStandaloneFileName:bool
	"""If true and if the audio is rendered in a standalone output file, the audio file is generated at the file location specified by mAudioCustomStandaloneFileName, otherwise the audio file is generated in the same directory as the rendered images/video files based on their names."""
	BitsPerPixel:FBVideoRenderDepth
	"""Read Write Property: Video grab color depth."""
	CameraResolution:FBCameraResolutionMode
	"""Read Write Property: Camera Resolution."""
	FieldMode:FBVideoRenderFieldMode
	"""Read Write Property: Video grab field mode."""
	OutputFileName:str
	"""Read Write Property: Grabbing destination file."""
	RenderAudio:bool
	"""Read Write Property: If true and there's audio in the scene, render the audio as well."""
	RendererCallbackIndex:int
	RendererCallbackPrefIndex:int
	ShowCameraLabel:bool
	"""Read Write Property: If true, display camera label information."""
	ShowSafeArea:bool
	"""Read Write Property: If true, display safe area."""
	ShowTimeCode:bool
	"""Read Write Property: If true, display time code information."""
	StereoDisplayMode:FBStereoDisplayMode
	StillImageCompression:int
	"""Property: Compression ratio for image(jpg) 0-100 where 0=Greatest compression, 100=Least Compression."""
	TimeSpan:FBTimeSpan
	"""Read Write Property: Start and stop selection time to grab."""
	TimeSteps:FBTime
	"""Read Write Property: Time step length between each grab."""
	ViewingMode:FBVideoRenderViewingMode
	"""Read Write Property: Video grab viewing mode."""
	def __init__(self):...
class FBVideoGrabber(FBComponent):
	"""Video Grabber class.

	Used to grab video frames generated with the [FBRenderer](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_renderer.html "Open Reality renderer interface.").

	[See samples: codecExamples.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_rendering_0ccodec_examples_8py-example.html) [render.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_rendering_0crender_8py-example.html) [RenderLayers.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_rendering_0c_render_layers_8py-example.html) [JpegRender.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_jpeg_render_8py-example.html)"""
	def BeginGrab(self)->bool:
		"""BeginGrab.

		Begin video grabbing session.
		### Returns:
		True if we can begin the grab session."""
		...
	def EndGrab(self)->None:
		"""EndGrab.

		Close video grabbing session."""
		...
	def GetLastErrorMsg(self)->str:
		"""GetLastErrorMsg.

		### Returns:
		If an error occured, this function returns the last error message, otherwise an empty string."""
		...
	def GetOptions(self)->FBVideoGrabOptions:
		"""GetOptions give you a copy of current grabbing options.

		### Returns:
		Struct that contain all grabbing options.
		[See sample: JpegRender.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_tasks_0c_jpeg_render_8py-example.html)"""
		...
	def GetStatistics(self)->Any:
		"""GetStatistics.

		### Returns:
		Struct that contain all grabbing statistics."""
		...
	def Grab(self)->None:
		"""Grab.

		Grab all specified video frames."""
		...
	def RenderSnapshot(self,Width:int=-1,Height:int=-1,CameraLabel:bool=False,TimeCode:bool=False,SafeArea:bool=False,Axis:bool=False,Grid:bool=False,FrontPlate:bool=False,BackPlate:bool=False,/)->FBImage:
		"""Render a snapshot of the actual display.

		### Returns:
		An FBimage containing data of the rendered snapshot."""
		...
	def ResetOptions(self)->None:
		"""SetDefaultOptions.

		This function reset all grabbing options to the default value."""
		...
	def SetOptions(self,Options:FBVideoGrabOptions,/)->None:
		"""SetOptions.

		### Parameters:
			- Options: Struct that contain all grabbing options."""
		...
	def __init__(self):...
class FBVideoIn(FBVideo):
	"""Basic video input class, supporting webcam and DV device.

	[See sample: VideoInput.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_video_0c_video_input_8py-example.html)"""
	FilePath:str
	"""Read Write Property: Location of the generated movie file after a recording session."""
	Online:bool
	"""Read Write Property: If true, the device is online and will display the current video feed."""
	RecordAudio:bool
	"""Read Write Property: If true, the device will also record audio during a recording session."""
	Recording:bool
	"""Read Write Property: If true, the device will record during a recording session."""
	def LiveGetCompressor(self)->int:
		"""Get the current compressor index.

		### Returns:
		Index of the current compressor."""
		...
	def LiveGetCompressorCount(self)->int:
		"""Get the compressor count.

		### Returns:
		Number of available compressor."""
		...
	def LiveGetCompressorName(self,CompressorIndex:int,/)->str:
		"""Get the compressor name at a particular index.

		### Returns:
		Name of the compressor. If the pCompressorIndex is higher than the number of compressor, the function will return NULL."""
		...
	def LiveGetResolutionFR(self)->int:
		"""Get the current resolution and frame rate index.

		### Returns:
		Index of the current resolution and frame rate."""
		...
	def LiveGetResolutionFRCount(self)->int:
		"""Get the number of resolution and frame rate available for the device.

		### Returns:
		Number of available resolution and frame rate."""
		...
	def LiveGetResolutionFRName(self,Index:int,/)->str:
		"""Get the resolution and frame rate string description at the specified index.

		### Parameters:
			- Index: Index of the resolution and frame rate.

		### Returns:
		Name of the resolution and frame rate."""
		...
	def LiveGetType(self)->FBVideoLiveType:
		"""Get the type of the video input device.

		### Returns:
		Type of the video input device."""
		...
	def LiveSetCompressor(self,CompressorIndex:int,/)->None:
		"""Set the current compressor to be used when recording.

		### Parameters:
			- CompressorIndex: Index of the compressor.

		### Returns:
		True if successful."""
		...
	def LiveSetResolutionFR(self,Index:int,/)->None:
		"""Set the current resolution and frame rate for the device.

		### Parameters:
			- Index: Index of the resolution and frame rate."""
		...
	def __init__(self):...
class FBVideoMemory(FBVideo):
	"""[FBVideoMemory](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_video_memory.html "FBVideoMemory allow external media source (which can't be supported by MoBu natively)   User could cr...") allow external media source (which can't be supported by MoBu natively)

	User could create / update OGL texture (GL_TEXTURE_2D type) externally, and pass in GL texture object id to TextureOGLId property.See "Scripts/Samples/Video/VideoMemory.py" for usage example.

	[See sample: VideoMemory.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_video_0c_video_memory_8py-example.html)"""
	TextureOGLId:int
	"""Read Write Property: OpenGL texture buffer object id (GL_TEXTURE_2D type)."""
	def SetObjectImageSize(self,W:int,H:int,/)->None:
		"""Set image size to allow MoBu preview texture with proper dimension / aspect.

		### Parameters:
			- W: Width of image.
			- H: Height of image."""
		...
	def __init__(self,Name:str,/):
		"""### Parameters:
			- Name: Name of video media."""
		...
class FBVideoOut(FBVideo):
	"""Video media class.

	[See sample: VideoOutput.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_video_0c_video_output_8py-example.html)"""
	Online:bool
	"""Read Write Property: If true, the device is online and will output display."""
	def __init__(self):...
class FBViewingOptions:
	"""Viewing options for rendering.

	The [FBRenderer](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_renderer.html "Open Reality renderer interface.") allows to get and set those options."""
	DisplayMode:FBModelShadingMode
	"""Read Write Property: Current Shading mode"""
	DisplayWhat:int
	"""Read Write Property: current display mask."""
	PaneIndex:int
	"""Current Viewer Pane being rendered.

	### Returns:
	Index of the pane being rendered."""
	PickingMode:int
	"""Read Write Property: Reference to the current picking mode."""
	ShowCameraLabel:bool
	"""Read Write Property: Show Camera Label when rendering."""
	ShowSafeArea:bool
	"""Read Write Property: Show Safe Area when rendering."""
	ShowTimeCode:bool
	"""Read Write Property: Show Time Code when rendering."""
	StereoDisplayMode:FBStereoDisplayMode
	"""Get a reference to the stereo display mode.

	### Returns:
	Reference to the current stereo display mode."""
	def InPicking(self)->bool:...
	def IsInColorBufferPicking(self)->bool:
		"""Is the rendering routine during picking status with GL color buffer method."""
		...
	def IsInSelectionBufferPicking(self)->bool:
		"""Is the rendering routine during picking status with GL selection buffer method."""
		...
	def RenderCallbackPrefIndex(self)->int:
		"""Current Render callback Settings Index."""
		...
class FBVisualComponent(FBComponent):
	"""Visual Component base class.

	All of the user interface elements available in the SDK derive from this class."""
	BorderCaption:str
	"""Read Write Property: Caption to display in border."""
	BorderCornerRadius:int
	"""Read Write Property: Corner radius (rounded)."""
	BorderInSet:bool
	"""Read Write Property: Is border inset?"""
	BorderMaxAngle:float
	"""Read Write Property: Max angle for rounding."""
	BorderShowCaption:bool
	"""Read Write Property: Show caption?"""
	BorderSpacing:int
	"""Read Write Property: Spacing of border."""
	BorderStyle:FBBorderStyle
	"""Read Write Property: Style of border."""
	BorderWidth:int
	"""Read Write Property: Width of border."""
	Caption:str
	"""Property: Widget caption."""
	Enabled:bool
	"""Read Write Property: Is visual enabled?"""
	Height:int
	"""Read Write Property: Height."""
	Hint:str
	"""Read Write Property: Hint to show."""
	Left:int
	"""Read Write Property: Left coordinate."""
	ReadOnly:bool
	"""Read Write Property: Is visual component read only?"""
	RegionAttachToHeight:FBVisualComponent
	"""Read Write Property: Height Attachment source."""
	RegionAttachToWidth:FBVisualComponent
	"""Read Write Property: Width Attachment source."""
	RegionAttachToX:FBVisualComponent
	"""Read Write Property X Attachment source."""
	RegionAttachToY:FBVisualComponent
	"""Read Write Property: Y Attachment source."""
	RegionAttachTypeHeight:FBAttachType
	"""Read Write Property: Height Attachment type."""
	RegionAttachTypeWidth:FBAttachType
	"""Read Write Property: Width Attachment type."""
	RegionAttachTypeX:FBAttachType
	"""Read Write Property: X Attachment type."""
	RegionAttachTypeY:FBAttachType
	"""Read Write Property: Y Attachment type."""
	RegionName:str
	"""Read Write Property: Region name."""
	RegionOffsetHeight:int
	"""Read Write Property: Region height offset."""
	RegionOffsetWidth:int
	"""Read Write Property: Region width offset."""
	RegionOffsetX:int
	"""Read Write Property: Region X offset."""
	RegionOffsetY:int
	"""Read Write Property: Region Y offset."""
	RegionPosMaxX:int
	"""Read Write Property: Region X position Max"""
	RegionPosMaxY:int
	"""Read Write Property: Region Y position Max"""
	RegionPosMinX:int
	"""Read Write Property: Region X position Min"""
	RegionPosMinY:int
	"""Read Write Property: Region Y position Min"""
	RegionRatioHeight:float
	"""Read Write Property: Ratio for Height attachment."""
	RegionRatioWidth:float
	"""Read Write Property: Ratio for Width attachment."""
	RegionRatioX:float
	"""Read Write Property: Ratio for X attachment."""
	RegionRatioY:float
	"""Read Write Property: Ratio for Y attachment."""
	Top:int
	"""Read Write Property: Top coordinate."""
	Visible:bool
	"""Read Write Property: Is visual component visible?"""
	Width:int
	"""Read Write Property: Width."""
	def AddChild(self,Child:FBVisualComponent,Id:int=0,/)->bool:
		"""Add a child component.

		### Parameters:
			- Child: Visual component to add as a child.
			- Id: User reference number to associate with **pChild**(default=0).

		### Returns:
		Operation was successful (true or false)."""
		...
	def GetChild(self,Id:int,/)->FBVisualComponent:
		"""Get a child component.

		### Parameters:
			- Id: User reference number to look for child with(default=0).

		### Returns:
		Handle to child (NULL if not found)."""
		...
	def GetQWidgetAddress(self)->int:
		"""Get internal QWidget.

		### Returns:
		Handle to internal QWidget object."""
		...
	def IsView(self)->bool:
		"""Is component a view?

		### Returns:
		true if component is a view."""
		...
	def Refresh(self,Now:bool=False,/)->None:
		"""Refresh component.

		### Parameters:
			- Now: Refresh immediately if **true** (default = **false**)."""
		...
	def ViewExpose(self)->None:
		"""Exposed view callback function."""
		...
	def ViewInput(self,MouseX:int,MouseY:int,Action:FBInputType,ButtonKey:int,Modifier:int,/)->None:
		"""Input callback function.

		### Parameters:
			- MouseX: Mouse X position.
			- MouseY: Mouse Y position.
			- Action: Mouse action.
			- ButtonKey: Keyboard input.
			- Modifier: Keyboard input modifier."""
		...
class FBVisualContainer(FBVisualComponent):
	"""Used to create a container for a tool UI.

	[See samples: Container.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_container_8py-example.html) [PropertyDrop.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_property_drop_8py-example.html) [TutorialBox.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_tutorial_box_8py-example.html)"""
	IconPosition:FBIconPosition
	"""Read Write Property: Where the icon is positioned for the items."""
	ItemHeight:int
	"""Read Write Property: Item height."""
	ItemIndex:int
	"""Read Write Property: Current item selected."""
	ItemWidth:int
	"""Read Write Property: Item width."""
	ItemWrap:bool
	"""Read Write Property: Are items wrapped when enough space is available?"""
	Items:FBStringList
	"""List: Names of items in container."""
	OnChange:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: Container contents changed."""
	OnDblClick:callbackframework.FBEventSource[Self, FBEventDblClick]
	"""Event: Double click."""
	OnDragAndDrop:callbackframework.FBEventSource[Self, FBEventDragAndDrop]
	"""Event: Drag and Drop event."""
	Orientation:FBOrientation
	"""Read Write Property: Orientation of container."""
	def GetSelection(self)->int:
		"""Get the selected item.

		### Returns:
		Index of current selection."""
		...
	@overload
	def ItemIconSet(self,Ref:int,Image:FBImage,UseACopyOfTheImage:bool=True,/)->bool:
		"""Set an item's icon.

		### Parameters:
			- Ref: Reference to item in container.
			- Image: Handle to image to use.
			- UseACopyOfTheImage: Create a copy of the image?(default=true)

		### Returns:
		Operation was successful (true or false)."""
		...
	@overload
	def ItemIconSet(self,Ref:int,Filename:str,/)->bool:
		"""Set an item's icon.

		### Parameters:
			- Ref: Reference to item in container.
			- Filename: Name of file where image is located.

		### Returns:
		Operation was successful (true or false)."""
		...
	def ItemNameEdit(self,Ref:int,/)->bool:
		"""Edit a container item.

		### Parameters:
			- Ref: Reference of container to edit.

		### Returns:
		Operation was successful (true or false)."""
		...
	def __init__(self):...
class FBView(FBVisualComponent):
	"""Generic view."""
	DoubleBuffer:bool
	"""Read Only Property: Indicates if the view is double buffered."""
	GraphicOGL:bool
	"""Read Only Property: Indicates if the view is OpenGL."""
	def DrawString(self,Text:str,X:float,Y:float,Enable:int=-1,/)->None:
		"""Draw a string in the view.

		### Parameters:
			- Text: Text to draw.
			- X: X position of string.
			- Y: Y position of string.
			- Enable: Is string enabled? (default =-1)"""
		...
	def SetViewport(self,X:int,Y:int,W:int,H:int,/)->bool:
		"""Set view's viewport.

		### Parameters:
			- X: Viewport X value.
			- Y: Viewport Y value.
			- W: Viewport W (width) value.
			- H: Viewport H (height) value.

		### Returns:
		Operation was successful (true or false)."""
		...
	def __init__(self):...
class FBTree(FBVisualComponent):
	"""Tree list view.

	[See sample: Tree.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_tree_8py-example.html)"""
	AllowCollapse:bool
	"""Read Write Property: When OnCollapsing occurs, set this to true to allow collapse."""
	AllowExpansion:bool
	"""Read Write Property: When OnExpanding occurs, set this to true to allow expansion."""
	AutoExpandOnDblClick:bool
	"""Read Write Property: Allow automatic expand on double click, default is false."""
	AutoExpandOnDragOver:bool
	"""Read Write Property: Allow automatic expand on drag over, default is false."""
	AutoScroll:bool
	"""Read Write Property: If AutoScroll property is True then the tree window will be automatically scrolled when the user drags item(s) over the boundaries of the tree."""
	AutoScrollOnExpand:bool
	"""Read Write Property: Allow automatic scroll on expand, default is true."""
	CheckBoxes:bool
	"""Read Write Property: Draw check boxe for each node."""
	DeselectOnCollapse:bool
	"""Read Write Property: Tells whether node are deselected if parent node is collapsed."""
	EditNodeOn2Select:bool
	"""Read Write Property: Set to true, to allow automatic node editing on second select."""
	HighlightOnRightClick:bool
	"""Read Write Property: Hightlight node on right click."""
	Indent:int
	"""Read Write Property: Use Indent to determine how far child nodes are indented from their parent nodes when the parent is expanded."""
	ItemHeight:int
	"""Read Write Property: Height of an item."""
	MultiDrag:bool
	"""Read Write Property: Tells whether multiple drag/drop is allowed or not."""
	MultiSelect:bool
	"""Read Write Property: Tells whether multiple selection is allowed or not."""
	NoSelectOnDrag:bool
	"""Read Write Property: Tells whether node are selected if drag is start and node is not already selected."""
	NoSelectOnRightClick:bool
	"""Read Write Property: Tells whether node are selected if right click on node."""
	OnChange:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: Change of the selection."""
	OnClick:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: Click on a node of the tree. Use OnSelect."""
	OnClickCheck:callbackframework.FBEventSource[Self, FBEventTreeSelect]
	"""Event: Click on a node checkbox of the tree."""
	OnCollapsed:callbackframework.FBEventSource[Self, FBEventTree]
	"""Event: Click on the "-" sign before a non-leaf node."""
	OnCollapsing:callbackframework.FBEventSource[Self, FBEventTree]
	"""Event: Fired before the node collapse. To refuse collapsing, set AllowCollapse to false."""
	OnDblClick:callbackframework.FBEventSource[Self, FBEventTreeSelect]
	"""Event: Double-Click on a node of the tree. Use [FBEventTreeSelect](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_event_tree_select.html "FBTree selection event. Event: Video Frame offline Rendering Event.") to cast event."""
	OnDragAndDrop:callbackframework.FBEventSource[Self, FBEventDragAndDrop]
	"""Event: Drag and drop of an element."""
	OnExpanded:callbackframework.FBEventSource[Self, FBEventTree]
	"""Event: Click on the "+" sign before a non-leaf node"""
	OnExpanding:callbackframework.FBEventSource[Self, FBEventTree]
	"""Event: Is fired before the node expand. To refuse expanding set AllowExpansion to false."""
	OnSelect:callbackframework.FBEventSource[Self, FBEventTreeSelect]
	"""Event: A node was selected. Use [FBEventTreeSelect](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_event_tree_select.html "FBTree selection event. Event: Video Frame offline Rendering Event.") to cast event."""
	SelectedCount:int
	"""Read Only Property: Count of selected items."""
	SelectedNodes:FBPropertyListTreeNode
	"""Read Only Property: List of selected nodes."""
	SelectionActive:bool
	"""Read Write Property: Tells whether selection is allowed or not."""
	ShowLines:bool
	"""Read Write Property: On node selection, will draw entire line selected"""
	TreeHeight:int
	"""Read Only Property: Height of the tree."""
	TreeWidth:int
	"""Read Only Property: Width of the tree."""
	VisibleItemCount:int
	"""Read Only Property: Count of visible items."""
	def Clear(self)->None:
		"""Clear the tree (remove all nodes)."""
		...
	def GetRoot(self)->FBTreeNode:
		"""Get the root node.

		### Returns:
		the root node of the tree."""
		...
	def InsertLast(self,Node:FBTreeNode,Name:str,/)->FBTreeNode:
		"""Insert node at the end.

		### Parameters:
			- Node: Node under which the new node will appear.
			- Name: Text to display for this node.

		### Returns:
		the newly created node."""
		...
	def __init__(self):...
class FBThermometer(FBVisualComponent):
	"""Thermometer.

	[See sample: Thermometer.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_thermometer_8py-example.html)"""
	Max:float
	"""Read Write Property: Maximum value."""
	Min:float
	"""Read Write Property: Minimum value."""
	Value:float
	"""Read Write Property: Current value."""
	def Clear(self)->None:
		"""Reset bounds and value."""
		...
	def __init__(self):...
class FBTabPanel(FBVisualComponent):
	"""Tab panel.

	[See sample: TabPanel.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_tab_panel_8py-example.html)"""
	ItemIndex:int
	"""Read Write Property: Current tab panel."""
	Items:FBStringList
	"""List: Names for tab panels."""
	Layout:FBLayout
	"""Read Write Property: Layout for current tab panel."""
	OnChange:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: Tab panel change."""
	TabStyle:int
	"""Read Write Property: Style of the tab panel, 0 creates normal tabs, 1 creates buttons to activate tabs."""
	def __init__(self):...
class FBSpread(FBVisualComponent):
	"""Base spreadsheet class.

	[See samples: ActionScriptMgr.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_complex_tools_0c_action_script_mgr_8py-example.html) [KeyboardMapper.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_complex_tools_0c_keyboard_mapper_8py-example.html) [Spread.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_spread_8py-example.html)"""
	Column:int
	"""Read Write Property: Current column."""
	MultiSelect:bool
	"""Read Write Property: Can there be multiple selections?"""
	OnCellChange:callbackframework.FBEventSource[Self, FBEventSpread]
	"""Event: Cell value changed."""
	OnColumnClick:callbackframework.FBEventSource[Self, FBEventSpread]
	"""Event: Column clicked."""
	OnDragAndDrop:callbackframework.FBEventSource[Self, FBEventDragAndDrop]
	"""Event: Drag and drop event."""
	OnRowClick:callbackframework.FBEventSource[Self, FBEventSpread]
	"""Event: Row clicked."""
	Row:int
	"""Read Write Property: Current row."""
	def Clear(self)->None:
		"""Clear spreadsheet This function will empty spreadsheet of all its rows, columns and cells."""
		...
	def ColumnAdd(self,String:str,Ref:int=0,/)->None:
		"""Add a column.

		### Parameters:
			- String: Text to display with column.
			- Ref: User-define column reference number(default=0)."""
		...
	def GetCellValue(self,Row:int,Column:int,/)->Any:
		"""Get a cell's value.

		### Parameters:
			- Row: Row of cell.
			- Column: Column of cell.

		### Return values:
		| object | Value of the cell (can be str, int or float) |
		| --- | --- |"""
		...
	def GetCellView(self,arg2,arg3,/)->Any:
		"""Get a cell's internal toolkit view.

		### Parameters:
			- Ref: Row of cell.
			- Column: Column of cell.
			- View: Handle of view."""
		...
	def GetColumn(self,Column:int,/)->FBSpreadColumn:
		"""Get a column from a column number.

		### Parameters:
			- Column: Column number.

		### Returns:
		A copy of column."""
		...
	def GetCurrentCell(self)->FBSpreadCell:
		"""Get the current cell.

		### Returns:
		A copy of the the current cell."""
		...
	def GetRow(self,Ref:int,/)->FBSpreadRow:
		"""Get a row from a row reference.

		### Parameters:
			- Ref: Reference to a row.

		### Returns:
		A copy of the row."""
		...
	def GetSpreadCell(self,Ref:int,Column:int,/)->FBSpreadCell:
		"""Get a cell from row and column numbers.

		### Parameters:
			- Ref: Row reference.
			- Column: Column number.

		### Returns:
		A copy of the cell."""
		...
	def RowAdd(self,String:str,Ref:int=0,/)->None:
		"""Add a row.

		### Parameters:
			- String: Text to display with row.
			- Ref: User-defined reference for row(default=0)."""
		...
	def RowSort(self,Ascending:bool=True,/)->None:
		"""Sort rows.

		### Parameters:
			- Ascending: If **true**, sort ascending."""
		...
	def SetCellValue(self,Row:int,Column:int,Value,/)->None:
		"""Set a cell's value.

		This will also set the [FBSpreadCell.Style](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_spread_part.html#ace9cc1d223691293563af70ce414fb91 "Read Write Property: Style of cell") to the type of pValue (kFBCellStyleInteger if pValue is an int, kFBCellStyleDouble if pValue is a float, kFBCellStyleString if pValue is a str).
		### Parameters:
			- Row: Row of cell.
			- Column: Column of cell.
			- Value: Value of the cell (can be str, int or float)"""
		...
	def SetCellView(self,Ref:int,Column:int,View:FBVisualComponent,/)->None:
		"""Set a cell's internal toolkit view.

		### Parameters:
			- Ref: Row of cell.
			- Column: Column of cell.
			- View: View to use to set cell's view."""
		...
	def __init__(self):...
class FBSlider(FBVisualComponent):
	"""Slider.

	[See samples: BlendShape_Editor.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_complex_tools_0c_blend_shape__editor_8py-example.html) [Slider.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_slider_8py-example.html)"""
	Max:float
	"""Read Write Property: Maximum value."""
	Min:float
	"""Read Write Property: Minimum value."""
	OnChange:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: Slider value changed."""
	OnTransaction:callbackframework.FBEventSource[Self, FBEventTransaction]
	"""Event: Transaction begin/end (continuous value changes). This event property doesn't exist in pyfbsdk."""
	Orientation:FBOrientation
	"""Read Write Property: Slider orientation."""
	Value:float
	"""Read Write Property: Current value."""
	def __init__(self):...
class FBScrollBox(FBVisualComponent):
	"""Scroll Box.

	This class provides a layout that will be automatically managed with a scrollbar according to the specified width and height. This provides a way to add dynamic UI control.

	[See sample: Scrollbox.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_scrollbox_8py-example.html)"""
	Content:FBLayout
	"""Read Property: an empty layout in which you can add scrollable content."""
	def SetContentSize(self,arg2,arg3,/)->None:...
	def __init__(self):...
class FBPropertyConnectionEditor(FBVisualComponent):
	"""Property Connection Editor."""
	Property:FBProperty
	"""Read Write Property: Property to edit connections. Set to NULL to disable."""
	def PopupList(self)->None:
		"""Launch a list of connected objects."""
		...
	def PopupTree(self)->None:
		"""Launch a tree of object connections."""
		...
	def __init__(self):...
class FBPlotPopup(FBVisualComponent):
	"""Plot Popup (for setting options only).

	[See sample: FBPlotPopup.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_f_b_plot_popup_8py-example.html)"""
	EnableEvaluateDeformation:bool
	"""Read Write Property: Enable Evaluate Deformation option for popup."""
	EnablePlotAuxEffectors:bool
	"""Read Write Property: Enable Plot Aux Effectors option for popup."""
	EnablePlotCharacterExtension:bool
	"""Read Write Property: Enable Plot Character Extension option for popup."""
	EnablePlotLockedProperties:bool
	"""Read Write Property: Enable Plot Locked Properties option for popup."""
	EnablePlotTranslationOnRootOnly:bool
	"""Read Write Property: Enable Plot Translation On Root Only option for popup."""
	EnableSmartPlotControls:bool
	"""Read Write Property: Enable Smart Plot option for popup."""
	def GetPlotOptions(self)->FBPlotOptions:
		"""Get plot options.

		### Returns:
		plot options."""
		...
	def Popup(self,WindowName:str,/)->bool:
		"""Execute plot popup.

		### Returns:
		true if OK is clicked by user."""
		...
	def SetPlotOptions(self,PlotOptions:FBPlotOptions,/)->None:
		"""Set plot options.

		### Parameters:
			- PlotOptions: Set the plot options that will be used when displaying the plot popup. First use the [GetPlotOptions()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_plot_popup.html#a2f79e68857f65fe637c98616b4b24a97 "Get plot options."), change the options and use the [SetPlotOptions()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_plot_popup.html#aaf85452e3a2fd43906744348fdc4e684 "Set plot options.") to set them before calling the [Popup()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_plot_popup.html#a0138b8dc2bd5bd5715e3d361aaaee3af "Execute plot popup.") function."""
		...
	def __init__(self):...
class FBList(FBVisualComponent):
	"""List of items.

	[See samples: List.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_list_8py-example.html) [ToolCommunicationReceiver.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_tool_communication_receiver_8py-example.html)"""
	ExtendedSelect:bool
	"""Read Write Property: Extended selection state?"""
	ItemIndex:int
	"""Read Write Property: Current item index."""
	Items:FBStringList
	"""List: Names of items in list."""
	MultiSelect:bool
	"""Read Write Property: Can multiple items be selected?"""
	OnChange:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: List changed."""
	OnDragAndDrop:callbackframework.FBEventSource[Self, FBEventDragAndDrop]
	"""Event: Drag and drop event."""
	Style:FBListStyle
	"""Read Write Property: Style or direction of list."""
	def IsSelected(self,Index:int,/)->bool:
		"""Returns whether or not the item pIndex is currently selected.

		### Parameters:
			- Index: Index to see if select or not.

		### Returns:
		true if item at pIndex is selected."""
		...
	def __init__(self):...
class FBLayoutRegion(FBVisualComponent):
	"""Layout region."""
	def __init__(self):...
class FBLayout(FBVisualComponent):
	"""Used to build the user interface.

	Layouts manage areas of the screen called regions. Regions contain UI components such as buttons, viewers, and edit boxes. Regions are added to layouts. When a UI component is bound to a region, the region defines how big it is and how it behaves when the layout is resized.Types of Layouts Device Constraint Manipulator Shader A region is first defined using the [FBLayout::AddRegion()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_layout.html#ada9608d3cc29bcfcb802803c582c7e82 "Add a region to the layout.") function. Once a region is defined and the corresponding UI component is created, and the component is bound to its region with [FBLayout::SetControl()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_layout.html#a037812ff1eb73124773acd374351edbe "Set control of a region to a visual component."). You can use the [FBSystem::OnUIIdle()](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_system.html#a51d224fe3663c140eb8971ed9250a7cf "Event: User-interface idle event. Useful callback for less frequent GUI refresh and etc....") in your layout to update real-time UI components such as guages and status indicators. In Python, FBBoxLayout and FBGridLayout take care of most of the region handling. They are used to create basic control layouts for simple tools. If you have a lot of content you can use [FBScrollBox](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_scroll_box.html "Scroll Box.") to manage it. For an example, see the Python sample Scrollbox.py.* Also see the Python sample Layout.py, and the C++ sample ortooluidemo.

	[See samples: KeyboardMapper.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_complex_tools_0c_keyboard_mapper_8py-example.html) [ShotTrackSetupTool.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_complex_tools_0c_shot_track_setup_tool_8py-example.html) [Attach.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_attach_8py-example.html) [Border.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_border_8py-example.html) [Layout.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_layout_8py-example.html)"""
	OnIdle:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: Idle."""
	OnInput:callbackframework.FBEventSource[Self, FBEventInput]
	"""Event: Input."""
	OnPaint:callbackframework.FBEventSource[Self, FBEventExpose]
	"""Event: Paint layout."""
	OnResize:callbackframework.FBEventSource[Self, FBEventResize]
	"""Event: Resize layout."""
	OnShow:callbackframework.FBEventSource[Self, FBEventShow]
	"""Event: Show layout."""
	def AddRegion(self,Name:str,Title:str,arg4:FBAddRegionParam,arg5:FBAddRegionParam,arg6:FBAddRegionParam,arg7:FBAddRegionParam,/)->bool:
		"""Add a region to the layout.

		### Parameters:
			- Name: Name of region.
			- Title: Title to display.
			- X: X: Position.
			- XType: X: Type of attachment.
			- XRelative: X: Item to attach to.
			- MultX: X: Multiplier of relative value.
			- Y: Y: Position.
			- YType: Y: Type of attachment.
			- YRelative: Y: Item to attach to.
			- MultY: Y: Multiplier of relative value.
			- W: W: Width of region.
			- WType: W: Type of attachment.
			- WRelative: W: Item to attach to.
			- MultW: W: Multiplier of relative value.
			- H: H: Height of region.
			- HType: H: Type of attachment.
			- HRelative: H: Item to attach to.
			- MultH: H: Multiplier of relative value.

		### Returns:
		Operation was successful (true or false)."""
		...
	def ClearControl(self,Name:str,/)->None:
		"""Remove a control from a region in a visual component.

		### Parameters:
			- Name: Name of region to remove control."""
		...
	def GetControl(self,Name:str,/)->FBVisualComponent:
		"""Get control of a region in a visual component.

		### Parameters:
			- Name: Name of region to find.

		### Returns:
		The component if it is found."""
		...
	def GetRegion(self,Name:str,/)->bool:
		"""Verify if a region with pName exists.

		### Parameters:
			- Name: Name of region to check.

		### Returns:
		Operation was successful (true or false)."""
		...
	def GetRegionPositions(self,Name:str,Computed:bool,X:int,Y:int,W:int|None=None,H:int|None=None,/)->bool:
		"""Get region pName information (position and size)

		### Parameters:
			- Name: Name of region.
			- Computed: Is the information retrieved relative or absolute?
			- X: Position in X of the region.
			- Y: Position in Y of the region.
			- W: Width of the region.
			- H: Height of the region.

		### Returns:
		Operation was successful (true or false)."""
		...
	def GetSplitStyle(self,Name:str,/)->FBSplitStyle:
		"""Get a region's splitstyle.

		### Parameters:
			- Name: Name of Region to get splitstyle from.

		### Returns:
		Split style of specified region."""
		...
	def MoveRegion(self,Name:str,X:int,Y:int,/)->bool:
		"""Move a region.

		### Parameters:
			- Name: Name of region to move.
			- X: New X position.
			- Y: New Y position.

		### Returns:
		Operation was successful (true or false)."""
		...
	def RemoveRegion(self,Name:str,/)->bool:
		"""Remove a region.

		### Parameters:
			- Name: Name of region to remove.

		### Returns:
		Operation was successful (true or false)."""
		...
	def RenameRegion(self,OldName:str,NewName:str,/)->bool:
		"""Rename a region.

		### Parameters:
			- OldName: Region's old name.
			- NewName: Region's new name.

		### Returns:
		Operation was successful (true or false)."""
		...
	def Restructure(self,NoMove:bool,/)->None:
		"""Force a recomputation of all region placements in the layout."""
		...
	def SetAutoRestructure(self,AutoRestructure:bool,/)->None:
		"""Suspend all automatic layout recomputation.

		### Parameters:
			- AutoRestructure: If true, Suspend all automatic layout recomputation, else restore it."""
		...
	def SetBorder(self,Name:str,Type:FBBorderStyle,ShowTitle:bool,InSet:bool,Width:int,Spacing:int,MaxAngle:float,CornerRadius:int,/)->bool:
		"""Set border properties for a region.

		### Parameters:
			- Name: Name of Region to change border properties.
			- Type: Border style to use.
			- ShowTitle: Show region title?
			- InSet: Is region inset?
			- Width: Border width.
			- Spacing: Border spacing.
			- MaxAngle: Max angle for rounding.
			- CornerRadius: Corner radius for rounding.

		### Returns:
		Operation was successful (true or false)."""
		...
	def SetControl(self,Name:str,Component:FBVisualComponent,/)->bool:
		"""Set control of a region to a visual component.

		### Parameters:
			- Name: Name of region to affect.
			- Component: Component to control region.

		### Returns:
		Operation was successful (true or false)."""
		...
	def SetRegionTitle(self,Name:str,Title:str,/)->bool:
		"""Set a region's title.

		### Parameters:
			- Name: Name of region to change title.
			- Title: New title for region.

		### Returns:
		Operation was successful (true or false)."""
		...
	def SetSplitStyle(self,Name:str,RegionType:FBSplitStyle,/)->bool:
		"""Set a region's splitstyle.

		### Parameters:
			- Name: Name of Region to set splitstyle.
			- RegionType: Split style give to region.

		### Returns:
		Operation was successful (true or false)."""
		...
	def SetView(self,Name:str,Component:FBVisualComponent,/)->bool:
		"""Set view.

		### Parameters:
			- Name: Name of Region.
			- Component: Component to set as view.

		### Returns:
		Operation was successful (true or false)."""
		...
	def SizeRegion(self,Name:str,W:int,H:int,/)->bool:
		"""Change a region's size.

		### Parameters:
			- Name: Name of region to resize.
			- W: New region width.
			- H: New region height.

		### Returns:
		Operation was successful (true or false)."""
		...
	def __init__(self):...
class FBLabel(FBVisualComponent):
	"""Text label.

	[See sample: Label.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_label_8py-example.html)"""
	Justify:FBTextJustify
	"""Read Write Property: Text justification for label."""
	Style:FBTextStyle
	"""Read Write Property: Text style appearance."""
	WordWrap:bool
	"""Read Write Property: Enable wordwrap on text drawing."""
	def __init__(self):...
class FBTool(FBLayout):
	"""Tool class.

	[See samples: MBFileRefDemo.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_samples_0c_referencing_0c_m_b_file_ref_demo_8py-example.html) [CloseTool.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_close_tool_8py-example.html) [MoveResizeToolExample.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_move_resize_tool_example_8py-example.html) [SafeToolCreationExample.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_safe_tool_creation_example_8py-example.html) [ToolCommunicationReceiver.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_tool_communication_receiver_8py-example.html) [ToolNativeWidgetHolder.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_tool_native_widget_holder_8py-example.html)"""
	DisplayName:str
	"""Read Write Property: Tool Display Name (Caption on the tool's title bar)"""
	MaxSizeX:int
	"""Read Property: Maximum Size in X (Disabled in this version). A value of -1 means no maximum size."""
	MaxSizeY:int
	"""Maximum Size in Y (Disabled in this version). A value of -1 means no maximum size."""
	MinSizeX:int
	"""Read Property: Minimum Size in X. A value of -1 means no minimum value."""
	MinSizeY:int
	"""Read Property: Minimum Size in Y. A value of -1 means no minimum value."""
	StartPosX:int
	"""Read Property: Starting Position in X. This is the initial position when the tool is opened. Default = 450"""
	StartPosY:int
	"""Read Property: Starting Position in Y. This is the initial position when the tool is opened. Default = 450"""
	StartSizeX:int
	"""Read Property: Starting Size. This is the initial size in X when the tool is opened. Default = 800"""
	StartSizeY:int
	"""Read Property: Starting Size. This is the initial size in Y when the tool is opened. Default = 400"""
	ToolName:str
	"""Read Property: Tool Name"""
	def GetPossibleDockPosition(self)->FBToolPossibleDockPosition:
		"""Get the possible docking position for the tool (concatenated).

		### Returns:
		Get all the docking flags in one call. Flags can be concatenated."""
		...
	def SetPossibleDockPosition(self,Flags:FBToolPossibleDockPosition,/)->None:
		"""Set the possible docking position for the tool.

		Be sure to call this function once the tool is visible, a good place to call it is when the OnShow event of the layout is called.
		### Parameters:
			- Flags: Set the docking position flag values. Note: this function overwrites all flags with those passed in parameter."""
		...
	def __init__(self,Name:str,RegisterTool:bool|None=None,/):
		"""Constructor used when creating tools not in the Tools menu of MotionBuilder.

		### Parameters:
			- Name: Name of tool, must be an unique name.
			- RegisterTool: Tells if we should register the tool on the toolmanager. You can later call Showtool to pop it."""
		...
class FBPopup(FBLayout):
	"""Popup window.

	This class lets a window (inheriting from [FBLayout](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_layout.html "Used to build the user interface.")) be created for another interface.

	[See sample: Popup.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_popup_8py-example.html)"""
	Modal:bool
	"""Read Write Property: Modal?"""
	def Close(self,Ok:bool,/)->None:
		"""Close popup.

		### Parameters:
			- Ok: Equivalent of **OK** button clicked if **true** (default = **false**)."""
		...
	def Show(self,Parent:FBVisualComponent|None=None,/)->None:
		"""Show popup.

		### Parameters:
			- Parent: Parent object for popup

		### Returns:
		Operation was successful (true or false)."""
		...
	def __init__(self):...
class FBImageContainer(FBVisualComponent):
	"""Image.

	[See sample: ImageContainer.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_image_container_8py-example.html)"""
	Filename:str
	"""Read Write Property: Filename for image."""
	OnDragAndDrop:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: Drag and drop."""
	def __init__(self):...
class FBFCurveEditor(FBVisualComponent):
	"""FCurve editor.

	[See sample: FCurveEditor.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_f_curve_editor_8py-example.html)"""
	def AddAnimationNode(self,Node:FBAnimationNode,/)->None:
		"""Add an animation node to the editor.

		### Parameters:
			- Node: Animation node to show in the editor."""
		...
	def AddProperty(self,Property:FBPropertyAnimatable,/)->None:
		"""Add an animatable property to the editor.

		### Parameters:
			- Property: Property to show in the editor."""
		...
	def Clear(self)->None:
		"""Clear the editor."""
		...
	def RemoveAnimationNode(self,Node:FBAnimationNode,/)->None:
		"""Remove an animation node from the editor.

		### Parameters:
			- Node: Animation node to hide from editor."""
		...
	def __init__(self):...
class FBEditVector(FBVisualComponent):
	"""Vector edit widget."""
	OnChange:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: Vector value changed."""
	Value:FBVector3d
	"""Read Write Property: Current value of vector."""
	def __init__(self):...
class FBEditTimeCode(FBVisualComponent):
	OnChange:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: Timecode changed."""
	Value:FBTime
	"""Read Write Property: Current timecode value."""
	def __init__(self):...
class FBEditPropertyModern(FBVisualComponent):
	"""Property editor widget.

	This is a more modern version of the widget [FBEditProperty](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_edit_property.html "Property editor widget.") which is used in the property editor tool of the application.See class [FBEditProperty](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_edit_property.html "Property editor widget.") for more details.

	[See sample: PropertyDrop.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_property_drop_8py-example.html)"""
	LargeInc:float
	"""Read Write Property: Indicate the large increment applied when click-draging on the property value (usually left-click-dragging)"""
	Precision:float
	"""Read Write Property: Used to specify the width and precision of the value shown. A value of 7.2 indicates to show at minimum 7 numbers, with 2 decimals."""
	Property:FBProperty
	"""Read Write Property: Property to edit. Set to NULL to disable."""
	SliderMax:float
	"""Read Write Property: Should the property be editable using a slider, set the maximum value atainable with the slider."""
	SliderMin:float
	"""Read Write Property: Should the property be editable using a slider, set the minimum value atainable with the slider."""
	SmallInc:float
	"""Read Write Property: Indicate the small increment applied when click-draging on the property value (usually right-click-dragging)"""
	def SetBackgroundColorIndex(self,Index,/)->None:
		"""Set the background color index.

		Use the system-defined color palette to set the backgound color. By default the color used is kFBColorIndexStdListBg1"""
		...
	def __init__(self):...
class FBEditProperty(FBVisualComponent):
	"""Property editor widget.

	This widget allows users to edit the values of a property without having to manually customize the GUI depending on the type of the property being edited.SDK objects can have three types of properties:An internal property which maps to an actual property that can be seen in the property editor tool of the application. This type of property is usually obtained from the PropertyList data member.SDK-only property which does not maps onto an existing property of the encapsulated object. The existence of these types of property is often to make the object interface simpler. All the FBPropertyList-types will fall into this category, except for FBPropertyListObjects.SDK property which maps onto an existing object property, but does so indirectly using function calls instead of direct property access. This is usually for historical reason. In this case the property will usually be present twice in the PropertyList: once as an SDK-Only property and another time as an internal property.Another limitation of this widget is that it can only display non hidden internal properties. To get around this issue, the property flag can be changed to unhide it. Doing so will also cause the property to be visible via the property tool.

	```c++
	// In a tool header file...
	FBEditProperty mEditProperty;

	// In a tool source file...
	FBModel* lModel = FBFindModelByLabelName( "ModelName" );
	if( lModel )
	{
	 FBProperty* lProperty = lModel->PropertyList.Find( "RotationOrder" );
	 if( lProperty &&
			lProperty->IsInternal() &&
			!lProperty->GetPropertyFlag( kFBPropertyFlagHideProperty ))
		{
			mEditProperty.Property = lProperty;
		}
	}
	```
	[See sample: PropertyDrop.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_property_drop_8py-example.html)"""
	LargeInc:float
	"""Read Write Property: Indicate the large increment applied when click-draging on the property value (usually left-click-dragging)"""
	Precision:float
	"""Read Write Property: Used to specify the width and precision of the value shown. A value of 7.2 indicates to show at minimum 7 numbers, with 2 decimals."""
	Property:FBProperty
	"""Read Write Property: Property to edit. Set to NULL to disable."""
	SliderMax:float
	"""Read Write Property: Should the property be editable using a slider, set the maximum value atainable with the slider."""
	SliderMin:float
	"""Read Write Property: Should the property be editable using a slider, set the minimum value atainable with the slider."""
	SmallInc:float
	"""Read Write Property: Indicate the small increment applied when click-draging on the property value (usually right-click-dragging)"""
	def __init__(self):...
class FBEditNumber(FBVisualComponent):
	"""Number edit box."""
	LargeStep:float
	"""Read Write Property: Large step value."""
	Max:float
	"""Read Write Property: Maximum value."""
	Min:float
	"""Read Write Property: Minimum value."""
	OnChange:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: Number changed."""
	Precision:float
	"""Read Write Property: Precision of value."""
	SmallStep:float
	"""Read Write Property: Small step value."""
	Value:float
	"""Read Write Property: Current value."""
	def __init__(self):...
class FBEditColor(FBVisualComponent):
	"""Color edit widget."""
	ColorMode:int
	"""Read Write Property: 3 for RGB, 4 for RGBA (Default = 3)"""
	OnChange:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: Color changed."""
	Value:FBColor
	"""Read Write Property: Current value of color."""
	def __init__(self):...
class FBEdit(FBVisualComponent):
	"""Text edit box."""
	OnChange:callbackframework.FBEventSource[Self, FBEvent]
	"""Event: Text changed."""
	PasswordMode:bool
	"""Read Write Property: Set password mode for this edit box."""
	Text:str
	"""Read Write Property: Text displayed."""
	def __init__(self):...
class FBButton(FBVisualComponent):
	"""Used to create and manage buttons in a user interface.

	This class includes functionality to create buttons in a user interface and add a callback. In MotionBuilder, buttons are created within regions, which are in turn created in layouts with [FBLayout](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_layout.html "Used to build the user interface."). For usage, see the Python sample Button.py. See also: [FBButtonStyle](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_button_style.html "Style of buttons."), [FBTextJustify](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_text_justify.html "Text justification styles."), [FBButtonLook](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_button_look.html "Button look.").

	[See samples: Button.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_button_8py-example.html) [Popup.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_popup_8py-example.html) [RadioButton.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_radio_button_8py-example.html)"""
	Justify:FBTextJustify
	"""Read Write Property: Current state of button."""
	Look:FBButtonLook
	"""Read Write Property: Current state of button."""
	OnClick:callbackframework.FBEventSource[Self, FBEventActivate]
	"""Event: Button clicked."""
	State:int
	"""Read Write Property: Current state of button."""
	Style:FBButtonStyle
	"""Read Write Property: Button style."""
	def GetStateColor(self,State:FBButtonState,/)->FBColor:
		"""Queries the color associated with a button state.

		This method is only useful for buttons of style kFB2States.
		### Parameters:
			- State: The state to be queried.

		### Returns:
		The color vector."""
		...
	def SetImageFileNames(self,UpImage:str,DownImage:str|None=None,ThirdImage:str|None=None,FromResources:bool=False,/)->None:
		"""Sets the image used to generate a kFBBitmap2States.

		### Parameters:
			- UpImage: The image used when button is unpushed
			- DownImage: The image used when button is pushed
			- FromResources: Add resource path to image path."""
		...
	def SetStateColor(self,State:FBButtonState,Color:FBColor,/)->None:
		"""Returns whether or not the item pIndex is currently selected.

		### Parameters:
			- State: The state to be set.
			- Color: The desired color vector."""
		...
	def __init__(self):...
class FBMemo(FBEdit):
	"""Multi-line text input.

	[See samples: Memo.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_memo_8py-example.html) [TutorialBox.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_tutorial_box_8py-example.html) [TutorialGrid.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_tutorial_grid_8py-example.html)"""
	def GetStrings(self,Lines:FBStringList,/)->None:
		"""Get the content of the memo.

		### Parameters:
			- Lines: Content of the memo will be copied to it."""
		...
	def SetStrings(self,Lines:FBStringList,/)->None:
		"""Set the content of the memo.

		### Parameters:
			- Lines: Content of the memo from will be set to it."""
		...
	def __init__(self):...
class FBBrowsingProperty(FBVisualComponent):
	"""Property browsing.

	[See sample: BrowsingProperty.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_browsing_property_8py-example.html)"""
	def AddObject(self,Object:FBPlug,/)->None:
		"""Add an object whose properties will be displayed.

		### Parameters:
			- Object: Object whose properties will be displayed in the property brwoser."""
		...
	def ObjectGet(self,Index:int,/)->FBPlug:
		"""Return the object at the specified index.

		### Parameters:
			- Index: Index of the object to get.

		### Returns:
		Object at the index specified currently displayed in the property browser."""
		...
	def ObjectGetCount(self)->int:
		"""Get the number of object displayed in the property browser.

		### Returns:
		Object currently displayed in the property browser."""
		...
	def RemoveObject(self,Object:FBPlug,/)->None:
		"""Remove an object from the property browser.

		### Parameters:
			- Object: Object to remove."""
		...
	def __init__(self):...
class FBArrowButton(FBVisualComponent):
	"""Creates a button which opens a layout to display content.

	When pushed a layout to display content (another control or a layout) is opened. A small arrow to the left of the button title, shows whether the content is shown (points down) or not (points to the title).

	[See samples: ArrowButton.py,](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_arrow_button_8py-example.html) [FBCamera.py.](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/_u_i_0c_f_b_camera_8py-example.html)"""
	def SetContent(self,Title:str,Content:FBVisualComponent,ContentWidth:int,ContentHeight:int,/)->None:
		"""Sets the content to be hidden/shown by button.

		The [FBArrowButton](https://help.autodesk.com/cloudhelp/2022/ENU/MotionBuilder-SDK/py_ref/classpyfbsdk_1_1_f_b_arrow_button.ht