# Documentation

Welcome to the Dynamiqs documentation! This page will guide you through learning Dynamiqs, from installation and basic examples to advanced tutorials. You can also find a list of available functions and classes in the [Python API](../python_api/index.md).

## Getting started

First time using Dynamiqs? Get to know the library and run your first simulations.

- [What is Dynamiqs?](getting_started/whatis.md)
- [Installation](getting_started/installation.md)
- [Basic examples](getting_started/examples.md)
- [The sharp bits 🔪](getting_started/sharp-bits.md)

## Learn the basics

Familiarize yourself with Dynamiqs. Learn how to simulate quantum systems, define time-dependent operators, run multiple simulations concurrently, and compute gradients.

- [Workflow in Dynamiqs](basics/workflow.md)
- [Time-dependent operators](basics/time-dependent-operators.md)
- [Closed systems](basics/closed-systems.md)
- [Open systems](basics/open-systems.md)
- [Batching simulations](basics/batching-simulations.md)
- [Computing gradients](basics/computing-gradients.md)
- [Floquet integration](basics/floquet-integration.md)

## Advanced examples

Explore advanced examples and tutorials to deepen your understanding of Dynamiqs.

- [Driven-dissipative Kerr oscillator](advanced_examples/kerr-oscillator.md)
- [Continuous jump measurement](advanced_examples/continuous-jump-measurement.md)
- [Continuous diffusive measurement](advanced_examples/continuous-diffusive-measurement.md)
