import sys
import json  # <--- ADDED
from .lexer import lex
from .parser import Parser
from .interpreter import Interpreter

def main():
    if len(sys.argv) < 2:
        print("Error: Please provide a file to run.")
        print("Usage: iloko <filename.iloko>")
        sys.exit(1)

    file_path = sys.argv[1]

    try:
        with open(file_path, 'r', encoding='utf-8') as f:
            code = f.read()
    except FileNotFoundError:
        print(json.dumps({"error": f"File not found: {file_path}"}))
        sys.exit(1)
    except Exception as e:
        print(json.dumps({"error": f"Error reading file: {str(e)}"}))
        sys.exit(1)

    try:
        # 1. LEX
        tokens = lex(code)
        
        # 2. PARSE
        parser = Parser(tokens)
        ast_statements = parser.parse()
        
        # 3. INTERPRET
        interpreter = Interpreter() 
        for stmt in ast_statements:
            interpreter.visit(stmt)
            
    except Exception as e:
        # <--- CHANGED: Output strictly as JSON string
        error_message = str(e)
        print(json.dumps({"error": error_message}))
        sys.exit(1)

if __name__ == "__main__":
    main()