# coding: utf-8

"""
    authentik

    Making authentication simple.

    The version of the OpenAPI document: 2025.10.0-rc1
    Contact: hello@goauthentik.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from authentik_client.models.group import Group
from authentik_client.models.severity_enum import SeverityEnum
from typing import Optional, Set
from typing_extensions import Self

class NotificationRule(BaseModel):
    """
    NotificationRule Serializer
    """ # noqa: E501
    pk: UUID
    name: StrictStr
    transports: Optional[List[UUID]] = Field(default=None, description="Select which transports should be used to notify the user. If none are selected, the notification will only be shown in the authentik UI.")
    severity: Optional[SeverityEnum] = Field(default=None, description="Controls which severity level the created notifications will have.")
    destination_group: Optional[UUID] = Field(default=None, description="Define which group of users this notification should be sent and shown to. If left empty, Notification won't ben sent.")
    destination_group_obj: Group
    destination_event_user: Optional[StrictBool] = Field(default=None, description="When enabled, notification will be sent to user the user that triggered the event.When destination_group is configured, notification is sent to both.")
    __properties: ClassVar[List[str]] = ["pk", "name", "transports", "severity", "destination_group", "destination_group_obj", "destination_event_user"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NotificationRule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "pk",
            "destination_group_obj",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of destination_group_obj
        if self.destination_group_obj:
            _dict['destination_group_obj'] = self.destination_group_obj.to_dict()
        # set to None if destination_group (nullable) is None
        # and model_fields_set contains the field
        if self.destination_group is None and "destination_group" in self.model_fields_set:
            _dict['destination_group'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NotificationRule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pk": obj.get("pk"),
            "name": obj.get("name"),
            "transports": obj.get("transports"),
            "severity": obj.get("severity"),
            "destination_group": obj.get("destination_group"),
            "destination_group_obj": Group.from_dict(obj["destination_group_obj"]) if obj.get("destination_group_obj") is not None else None,
            "destination_event_user": obj.get("destination_event_user")
        })
        return _obj


