"""Stub file for reflex/components/datadisplay/code.py"""

# ------------------- DO NOT EDIT ----------------------
# This file was generated by `reflex/utils/pyi_generator.py`!
# ------------------------------------------------------
import dataclasses
from collections.abc import Mapping, Sequence
from typing import Any, ClassVar, Literal

from reflex.components.component import Component, ComponentNamespace
from reflex.components.core.breakpoints import Breakpoints
from reflex.components.markdown.markdown import MarkdownComponentMap
from reflex.constants.colors import Color
from reflex.event import EventType, PointerEventInfo
from reflex.vars.base import Var

LiteralCodeLanguage = Literal[
    "abap",
    "abnf",
    "actionscript",
    "ada",
    "agda",
    "al",
    "antlr4",
    "apacheconf",
    "apex",
    "apl",
    "applescript",
    "aql",
    "arduino",
    "arff",
    "asciidoc",
    "asm6502",
    "asmatmel",
    "aspnet",
    "autohotkey",
    "autoit",
    "avisynth",
    "avro-idl",
    "bash",
    "basic",
    "batch",
    "bbcode",
    "bicep",
    "birb",
    "bison",
    "bnf",
    "brainfuck",
    "brightscript",
    "bro",
    "bsl",
    "c",
    "cfscript",
    "chaiscript",
    "cil",
    "clike",
    "clojure",
    "cmake",
    "cobol",
    "coffeescript",
    "concurnas",
    "coq",
    "core",
    "cpp",
    "crystal",
    "csharp",
    "cshtml",
    "csp",
    "css",
    "css-extras",
    "csv",
    "cypher",
    "d",
    "dart",
    "dataweave",
    "dax",
    "dhall",
    "diff",
    "django",
    "dns-zone-file",
    "docker",
    "dot",
    "ebnf",
    "editorconfig",
    "eiffel",
    "ejs",
    "elixir",
    "elm",
    "erb",
    "erlang",
    "etlua",
    "excel-formula",
    "factor",
    "false",
    "firestore-security-rules",
    "flow",
    "fortran",
    "fsharp",
    "ftl",
    "gap",
    "gcode",
    "gdscript",
    "gedcom",
    "gherkin",
    "git",
    "glsl",
    "gml",
    "gn",
    "go",
    "go-module",
    "graphql",
    "groovy",
    "haml",
    "handlebars",
    "haskell",
    "haxe",
    "hcl",
    "hlsl",
    "hoon",
    "hpkp",
    "hsts",
    "http",
    "ichigojam",
    "icon",
    "icu-message-format",
    "idris",
    "iecst",
    "ignore",
    "index",
    "inform7",
    "ini",
    "io",
    "j",
    "java",
    "javadoc",
    "javadoclike",
    "javascript",
    "javastacktrace",
    "jexl",
    "jolie",
    "jq",
    "js-extras",
    "js-templates",
    "jsdoc",
    "json",
    "json5",
    "jsonp",
    "jsstacktrace",
    "jsx",
    "julia",
    "keepalived",
    "keyman",
    "kotlin",
    "kumir",
    "kusto",
    "latex",
    "latte",
    "less",
    "lilypond",
    "liquid",
    "lisp",
    "livescript",
    "llvm",
    "log",
    "lolcode",
    "lua",
    "magma",
    "makefile",
    "markdown",
    "markup",
    "markup-templating",
    "matlab",
    "maxscript",
    "mel",
    "mermaid",
    "mizar",
    "mongodb",
    "monkey",
    "moonscript",
    "n1ql",
    "n4js",
    "nand2tetris-hdl",
    "naniscript",
    "nasm",
    "neon",
    "nevod",
    "nginx",
    "nim",
    "nix",
    "nsis",
    "objectivec",
    "ocaml",
    "opencl",
    "openqasm",
    "oz",
    "parigp",
    "parser",
    "pascal",
    "pascaligo",
    "pcaxis",
    "peoplecode",
    "perl",
    "php",
    "php-extras",
    "phpdoc",
    "plsql",
    "powerquery",
    "powershell",
    "processing",
    "prolog",
    "promql",
    "properties",
    "protobuf",
    "psl",
    "pug",
    "puppet",
    "pure",
    "purebasic",
    "purescript",
    "python",
    "q",
    "qml",
    "qore",
    "qsharp",
    "r",
    "racket",
    "reason",
    "regex",
    "rego",
    "renpy",
    "rest",
    "rip",
    "roboconf",
    "robotframework",
    "ruby",
    "rust",
    "sas",
    "sass",
    "scala",
    "scheme",
    "scss",
    "shell-session",
    "smali",
    "smalltalk",
    "smarty",
    "sml",
    "solidity",
    "solution-file",
    "soy",
    "sparql",
    "splunk-spl",
    "sqf",
    "sql",
    "squirrel",
    "stan",
    "stylus",
    "swift",
    "systemd",
    "t4-cs",
    "t4-templating",
    "t4-vb",
    "tap",
    "tcl",
    "textile",
    "toml",
    "tremor",
    "tsx",
    "tt2",
    "turtle",
    "twig",
    "typescript",
    "typoscript",
    "unrealscript",
    "uorazor",
    "uri",
    "v",
    "vala",
    "vbnet",
    "velocity",
    "verilog",
    "vhdl",
    "vim",
    "visual-basic",
    "warpscript",
    "wasm",
    "web-idl",
    "wiki",
    "wolfram",
    "wren",
    "xeora",
    "xml-doc",
    "xojo",
    "xquery",
    "yaml",
    "yang",
    "zig",
]

def construct_theme_var(theme: str) -> Var[Theme]: ...
@dataclasses.dataclass(init=False)
class Theme:
    a11y_dark: ClassVar[Var[Theme]] = construct_theme_var("a11yDark")
    atom_dark: ClassVar[Var[Theme]] = construct_theme_var("atomDark")
    cb: ClassVar[Var[Theme]] = construct_theme_var("cb")
    coldark_cold: ClassVar[Var[Theme]] = construct_theme_var("coldarkCold")
    coldark_dark: ClassVar[Var[Theme]] = construct_theme_var("coldarkDark")
    coy: ClassVar[Var[Theme]] = construct_theme_var("coy")
    coy_without_shadows: ClassVar[Var[Theme]] = construct_theme_var("coyWithoutShadows")
    darcula: ClassVar[Var[Theme]] = construct_theme_var("darcula")
    dark: ClassVar[Var[Theme]] = construct_theme_var("oneDark")
    dracula: ClassVar[Var[Theme]] = construct_theme_var("dracula")
    duotone_dark: ClassVar[Var[Theme]] = construct_theme_var("duotoneDark")
    duotone_earth: ClassVar[Var[Theme]] = construct_theme_var("duotoneEarth")
    duotone_forest: ClassVar[Var[Theme]] = construct_theme_var("duotoneForest")
    duotone_light: ClassVar[Var[Theme]] = construct_theme_var("duotoneLight")
    duotone_sea: ClassVar[Var[Theme]] = construct_theme_var("duotoneSea")
    duotone_space: ClassVar[Var[Theme]] = construct_theme_var("duotoneSpace")
    funky: ClassVar[Var[Theme]] = construct_theme_var("funky")
    ghcolors: ClassVar[Var[Theme]] = construct_theme_var("ghcolors")
    gruvbox_dark: ClassVar[Var[Theme]] = construct_theme_var("gruvboxDark")
    gruvbox_light: ClassVar[Var[Theme]] = construct_theme_var("gruvboxLight")
    holi_theme: ClassVar[Var[Theme]] = construct_theme_var("holiTheme")
    hopscotch: ClassVar[Var[Theme]] = construct_theme_var("hopscotch")
    light: ClassVar[Var[Theme]] = construct_theme_var("oneLight")
    lucario: ClassVar[Var[Theme]] = construct_theme_var("lucario")
    material_dark: ClassVar[Var[Theme]] = construct_theme_var("materialDark")
    material_light: ClassVar[Var[Theme]] = construct_theme_var("materialLight")
    material_oceanic: ClassVar[Var[Theme]] = construct_theme_var("materialOceanic")
    night_owl: ClassVar[Var[Theme]] = construct_theme_var("nightOwl")
    nord: ClassVar[Var[Theme]] = construct_theme_var("nord")
    okaidia: ClassVar[Var[Theme]] = construct_theme_var("okaidia")
    one_dark: ClassVar[Var[Theme]] = construct_theme_var("oneDark")
    one_light: ClassVar[Var[Theme]] = construct_theme_var("oneLight")
    pojoaque: ClassVar[Var[Theme]] = construct_theme_var("pojoaque")
    prism: ClassVar[Var[Theme]] = construct_theme_var("prism")
    shades_of_purple: ClassVar[Var[Theme]] = construct_theme_var("shadesOfPurple")
    solarized_dark_atom: ClassVar[Var[Theme]] = construct_theme_var("solarizedDarkAtom")
    solarizedlight: ClassVar[Var[Theme]] = construct_theme_var("solarizedlight")
    synthwave84: ClassVar[Var[Theme]] = construct_theme_var("synthwave84")
    tomorrow: ClassVar[Var[Theme]] = construct_theme_var("tomorrow")
    twilight: ClassVar[Var[Theme]] = construct_theme_var("twilight")
    vs: ClassVar[Var[Theme]] = construct_theme_var("vs")
    vs_dark: ClassVar[Var[Theme]] = construct_theme_var("vsDark")
    vsc_dark_plus: ClassVar[Var[Theme]] = construct_theme_var("vscDarkPlus")
    xonokai: ClassVar[Var[Theme]] = construct_theme_var("xonokai")
    z_touch: ClassVar[Var[Theme]] = construct_theme_var("zTouch")

for theme_name in dir(Theme):
    if theme_name.startswith("_"):
        continue
    setattr(Theme, theme_name, getattr(Theme, theme_name)._replace(_var_type=Theme))

class CodeBlock(Component, MarkdownComponentMap):
    @classmethod
    def create(
        cls,
        *children,
        theme: Theme | Var[Theme | str] | str | None = None,
        language: Literal[
            "abap",
            "abnf",
            "actionscript",
            "ada",
            "agda",
            "al",
            "antlr4",
            "apacheconf",
            "apex",
            "apl",
            "applescript",
            "aql",
            "arduino",
            "arff",
            "asciidoc",
            "asm6502",
            "asmatmel",
            "aspnet",
            "autohotkey",
            "autoit",
            "avisynth",
            "avro-idl",
            "bash",
            "basic",
            "batch",
            "bbcode",
            "bicep",
            "birb",
            "bison",
            "bnf",
            "brainfuck",
            "brightscript",
            "bro",
            "bsl",
            "c",
            "cfscript",
            "chaiscript",
            "cil",
            "clike",
            "clojure",
            "cmake",
            "cobol",
            "coffeescript",
            "concurnas",
            "coq",
            "core",
            "cpp",
            "crystal",
            "csharp",
            "cshtml",
            "csp",
            "css",
            "css-extras",
            "csv",
            "cypher",
            "d",
            "dart",
            "dataweave",
            "dax",
            "dhall",
            "diff",
            "django",
            "dns-zone-file",
            "docker",
            "dot",
            "ebnf",
            "editorconfig",
            "eiffel",
            "ejs",
            "elixir",
            "elm",
            "erb",
            "erlang",
            "etlua",
            "excel-formula",
            "factor",
            "false",
            "firestore-security-rules",
            "flow",
            "fortran",
            "fsharp",
            "ftl",
            "gap",
            "gcode",
            "gdscript",
            "gedcom",
            "gherkin",
            "git",
            "glsl",
            "gml",
            "gn",
            "go",
            "go-module",
            "graphql",
            "groovy",
            "haml",
            "handlebars",
            "haskell",
            "haxe",
            "hcl",
            "hlsl",
            "hoon",
            "hpkp",
            "hsts",
            "http",
            "ichigojam",
            "icon",
            "icu-message-format",
            "idris",
            "iecst",
            "ignore",
            "index",
            "inform7",
            "ini",
            "io",
            "j",
            "java",
            "javadoc",
            "javadoclike",
            "javascript",
            "javastacktrace",
            "jexl",
            "jolie",
            "jq",
            "js-extras",
            "js-templates",
            "jsdoc",
            "json",
            "json5",
            "jsonp",
            "jsstacktrace",
            "jsx",
            "julia",
            "keepalived",
            "keyman",
            "kotlin",
            "kumir",
            "kusto",
            "latex",
            "latte",
            "less",
            "lilypond",
            "liquid",
            "lisp",
            "livescript",
            "llvm",
            "log",
            "lolcode",
            "lua",
            "magma",
            "makefile",
            "markdown",
            "markup",
            "markup-templating",
            "matlab",
            "maxscript",
            "mel",
            "mermaid",
            "mizar",
            "mongodb",
            "monkey",
            "moonscript",
            "n1ql",
            "n4js",
            "nand2tetris-hdl",
            "naniscript",
            "nasm",
            "neon",
            "nevod",
            "nginx",
            "nim",
            "nix",
            "nsis",
            "objectivec",
            "ocaml",
            "opencl",
            "openqasm",
            "oz",
            "parigp",
            "parser",
            "pascal",
            "pascaligo",
            "pcaxis",
            "peoplecode",
            "perl",
            "php",
            "php-extras",
            "phpdoc",
            "plsql",
            "powerquery",
            "powershell",
            "processing",
            "prolog",
            "promql",
            "properties",
            "protobuf",
            "psl",
            "pug",
            "puppet",
            "pure",
            "purebasic",
            "purescript",
            "python",
            "q",
            "qml",
            "qore",
            "qsharp",
            "r",
            "racket",
            "reason",
            "regex",
            "rego",
            "renpy",
            "rest",
            "rip",
            "roboconf",
            "robotframework",
            "ruby",
            "rust",
            "sas",
            "sass",
            "scala",
            "scheme",
            "scss",
            "shell-session",
            "smali",
            "smalltalk",
            "smarty",
            "sml",
            "solidity",
            "solution-file",
            "soy",
            "sparql",
            "splunk-spl",
            "sqf",
            "sql",
            "squirrel",
            "stan",
            "stylus",
            "swift",
            "systemd",
            "t4-cs",
            "t4-templating",
            "t4-vb",
            "tap",
            "tcl",
            "textile",
            "toml",
            "tremor",
            "tsx",
            "tt2",
            "turtle",
            "twig",
            "typescript",
            "typoscript",
            "unrealscript",
            "uorazor",
            "uri",
            "v",
            "vala",
            "vbnet",
            "velocity",
            "verilog",
            "vhdl",
            "vim",
            "visual-basic",
            "warpscript",
            "wasm",
            "web-idl",
            "wiki",
            "wolfram",
            "wren",
            "xeora",
            "xml-doc",
            "xojo",
            "xquery",
            "yaml",
            "yang",
            "zig",
        ]
        | Var[
            Literal[
                "abap",
                "abnf",
                "actionscript",
                "ada",
                "agda",
                "al",
                "antlr4",
                "apacheconf",
                "apex",
                "apl",
                "applescript",
                "aql",
                "arduino",
                "arff",
                "asciidoc",
                "asm6502",
                "asmatmel",
                "aspnet",
                "autohotkey",
                "autoit",
                "avisynth",
                "avro-idl",
                "bash",
                "basic",
                "batch",
                "bbcode",
                "bicep",
                "birb",
                "bison",
                "bnf",
                "brainfuck",
                "brightscript",
                "bro",
                "bsl",
                "c",
                "cfscript",
                "chaiscript",
                "cil",
                "clike",
                "clojure",
                "cmake",
                "cobol",
                "coffeescript",
                "concurnas",
                "coq",
                "core",
                "cpp",
                "crystal",
                "csharp",
                "cshtml",
                "csp",
                "css",
                "css-extras",
                "csv",
                "cypher",
                "d",
                "dart",
                "dataweave",
                "dax",
                "dhall",
                "diff",
                "django",
                "dns-zone-file",
                "docker",
                "dot",
                "ebnf",
                "editorconfig",
                "eiffel",
                "ejs",
                "elixir",
                "elm",
                "erb",
                "erlang",
                "etlua",
                "excel-formula",
                "factor",
                "false",
                "firestore-security-rules",
                "flow",
                "fortran",
                "fsharp",
                "ftl",
                "gap",
                "gcode",
                "gdscript",
                "gedcom",
                "gherkin",
                "git",
                "glsl",
                "gml",
                "gn",
                "go",
                "go-module",
                "graphql",
                "groovy",
                "haml",
                "handlebars",
                "haskell",
                "haxe",
                "hcl",
                "hlsl",
                "hoon",
                "hpkp",
                "hsts",
                "http",
                "ichigojam",
                "icon",
                "icu-message-format",
                "idris",
                "iecst",
                "ignore",
                "index",
                "inform7",
                "ini",
                "io",
                "j",
                "java",
                "javadoc",
                "javadoclike",
                "javascript",
                "javastacktrace",
                "jexl",
                "jolie",
                "jq",
                "js-extras",
                "js-templates",
                "jsdoc",
                "json",
                "json5",
                "jsonp",
                "jsstacktrace",
                "jsx",
                "julia",
                "keepalived",
                "keyman",
                "kotlin",
                "kumir",
                "kusto",
                "latex",
                "latte",
                "less",
                "lilypond",
                "liquid",
                "lisp",
                "livescript",
                "llvm",
                "log",
                "lolcode",
                "lua",
                "magma",
                "makefile",
                "markdown",
                "markup",
                "markup-templating",
                "matlab",
                "maxscript",
                "mel",
                "mermaid",
                "mizar",
                "mongodb",
                "monkey",
                "moonscript",
                "n1ql",
                "n4js",
                "nand2tetris-hdl",
                "naniscript",
                "nasm",
                "neon",
                "nevod",
                "nginx",
                "nim",
                "nix",
                "nsis",
                "objectivec",
                "ocaml",
                "opencl",
                "openqasm",
                "oz",
                "parigp",
                "parser",
                "pascal",
                "pascaligo",
                "pcaxis",
                "peoplecode",
                "perl",
                "php",
                "php-extras",
                "phpdoc",
                "plsql",
                "powerquery",
                "powershell",
                "processing",
                "prolog",
                "promql",
                "properties",
                "protobuf",
                "psl",
                "pug",
                "puppet",
                "pure",
                "purebasic",
                "purescript",
                "python",
                "q",
                "qml",
                "qore",
                "qsharp",
                "r",
                "racket",
                "reason",
                "regex",
                "rego",
                "renpy",
                "rest",
                "rip",
                "roboconf",
                "robotframework",
                "ruby",
                "rust",
                "sas",
                "sass",
                "scala",
                "scheme",
                "scss",
                "shell-session",
                "smali",
                "smalltalk",
                "smarty",
                "sml",
                "solidity",
                "solution-file",
                "soy",
                "sparql",
                "splunk-spl",
                "sqf",
                "sql",
                "squirrel",
                "stan",
                "stylus",
                "swift",
                "systemd",
                "t4-cs",
                "t4-templating",
                "t4-vb",
                "tap",
                "tcl",
                "textile",
                "toml",
                "tremor",
                "tsx",
                "tt2",
                "turtle",
                "twig",
                "typescript",
                "typoscript",
                "unrealscript",
                "uorazor",
                "uri",
                "v",
                "vala",
                "vbnet",
                "velocity",
                "verilog",
                "vhdl",
                "vim",
                "visual-basic",
                "warpscript",
                "wasm",
                "web-idl",
                "wiki",
                "wolfram",
                "wren",
                "xeora",
                "xml-doc",
                "xojo",
                "xquery",
                "yaml",
                "yang",
                "zig",
            ]
        ]
        | None = None,
        code: Var[str] | str | None = None,
        show_line_numbers: Var[bool] | bool | None = None,
        starting_line_number: Var[int] | int | None = None,
        wrap_long_lines: Var[bool] | bool | None = None,
        custom_style: dict[str, str | Var | Color] | None = None,
        code_tag_props: Var[dict[str, str]] | dict[str, str] | None = None,
        can_copy: bool | None = None,
        copy_button: Component | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> CodeBlock:
        """Create a text component.

        Args:
            *children: The children of the component.
            theme: The theme to use ("light" or "dark").
            language: The language to use.
            code: The code to display.
            show_line_numbers: If this is enabled line numbers will be shown next to the code block.
            starting_line_number: The starting line number to use.
            wrap_long_lines: Whether to wrap long lines.
            custom_style: A custom style for the code block.
            code_tag_props: Props passed down to the code tag.
            can_copy: Whether a copy button should appear.
            copy_button: A custom copy button to override the default one.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props to pass to the component.

        Returns:
            The text component.
        """

    def add_style(self): ...

class CodeblockNamespace(ComponentNamespace):
    themes = Theme

    @staticmethod
    def __call__(
        *children,
        theme: Theme | Var[Theme | str] | str | None = None,
        language: Literal[
            "abap",
            "abnf",
            "actionscript",
            "ada",
            "agda",
            "al",
            "antlr4",
            "apacheconf",
            "apex",
            "apl",
            "applescript",
            "aql",
            "arduino",
            "arff",
            "asciidoc",
            "asm6502",
            "asmatmel",
            "aspnet",
            "autohotkey",
            "autoit",
            "avisynth",
            "avro-idl",
            "bash",
            "basic",
            "batch",
            "bbcode",
            "bicep",
            "birb",
            "bison",
            "bnf",
            "brainfuck",
            "brightscript",
            "bro",
            "bsl",
            "c",
            "cfscript",
            "chaiscript",
            "cil",
            "clike",
            "clojure",
            "cmake",
            "cobol",
            "coffeescript",
            "concurnas",
            "coq",
            "core",
            "cpp",
            "crystal",
            "csharp",
            "cshtml",
            "csp",
            "css",
            "css-extras",
            "csv",
            "cypher",
            "d",
            "dart",
            "dataweave",
            "dax",
            "dhall",
            "diff",
            "django",
            "dns-zone-file",
            "docker",
            "dot",
            "ebnf",
            "editorconfig",
            "eiffel",
            "ejs",
            "elixir",
            "elm",
            "erb",
            "erlang",
            "etlua",
            "excel-formula",
            "factor",
            "false",
            "firestore-security-rules",
            "flow",
            "fortran",
            "fsharp",
            "ftl",
            "gap",
            "gcode",
            "gdscript",
            "gedcom",
            "gherkin",
            "git",
            "glsl",
            "gml",
            "gn",
            "go",
            "go-module",
            "graphql",
            "groovy",
            "haml",
            "handlebars",
            "haskell",
            "haxe",
            "hcl",
            "hlsl",
            "hoon",
            "hpkp",
            "hsts",
            "http",
            "ichigojam",
            "icon",
            "icu-message-format",
            "idris",
            "iecst",
            "ignore",
            "index",
            "inform7",
            "ini",
            "io",
            "j",
            "java",
            "javadoc",
            "javadoclike",
            "javascript",
            "javastacktrace",
            "jexl",
            "jolie",
            "jq",
            "js-extras",
            "js-templates",
            "jsdoc",
            "json",
            "json5",
            "jsonp",
            "jsstacktrace",
            "jsx",
            "julia",
            "keepalived",
            "keyman",
            "kotlin",
            "kumir",
            "kusto",
            "latex",
            "latte",
            "less",
            "lilypond",
            "liquid",
            "lisp",
            "livescript",
            "llvm",
            "log",
            "lolcode",
            "lua",
            "magma",
            "makefile",
            "markdown",
            "markup",
            "markup-templating",
            "matlab",
            "maxscript",
            "mel",
            "mermaid",
            "mizar",
            "mongodb",
            "monkey",
            "moonscript",
            "n1ql",
            "n4js",
            "nand2tetris-hdl",
            "naniscript",
            "nasm",
            "neon",
            "nevod",
            "nginx",
            "nim",
            "nix",
            "nsis",
            "objectivec",
            "ocaml",
            "opencl",
            "openqasm",
            "oz",
            "parigp",
            "parser",
            "pascal",
            "pascaligo",
            "pcaxis",
            "peoplecode",
            "perl",
            "php",
            "php-extras",
            "phpdoc",
            "plsql",
            "powerquery",
            "powershell",
            "processing",
            "prolog",
            "promql",
            "properties",
            "protobuf",
            "psl",
            "pug",
            "puppet",
            "pure",
            "purebasic",
            "purescript",
            "python",
            "q",
            "qml",
            "qore",
            "qsharp",
            "r",
            "racket",
            "reason",
            "regex",
            "rego",
            "renpy",
            "rest",
            "rip",
            "roboconf",
            "robotframework",
            "ruby",
            "rust",
            "sas",
            "sass",
            "scala",
            "scheme",
            "scss",
            "shell-session",
            "smali",
            "smalltalk",
            "smarty",
            "sml",
            "solidity",
            "solution-file",
            "soy",
            "sparql",
            "splunk-spl",
            "sqf",
            "sql",
            "squirrel",
            "stan",
            "stylus",
            "swift",
            "systemd",
            "t4-cs",
            "t4-templating",
            "t4-vb",
            "tap",
            "tcl",
            "textile",
            "toml",
            "tremor",
            "tsx",
            "tt2",
            "turtle",
            "twig",
            "typescript",
            "typoscript",
            "unrealscript",
            "uorazor",
            "uri",
            "v",
            "vala",
            "vbnet",
            "velocity",
            "verilog",
            "vhdl",
            "vim",
            "visual-basic",
            "warpscript",
            "wasm",
            "web-idl",
            "wiki",
            "wolfram",
            "wren",
            "xeora",
            "xml-doc",
            "xojo",
            "xquery",
            "yaml",
            "yang",
            "zig",
        ]
        | Var[
            Literal[
                "abap",
                "abnf",
                "actionscript",
                "ada",
                "agda",
                "al",
                "antlr4",
                "apacheconf",
                "apex",
                "apl",
                "applescript",
                "aql",
                "arduino",
                "arff",
                "asciidoc",
                "asm6502",
                "asmatmel",
                "aspnet",
                "autohotkey",
                "autoit",
                "avisynth",
                "avro-idl",
                "bash",
                "basic",
                "batch",
                "bbcode",
                "bicep",
                "birb",
                "bison",
                "bnf",
                "brainfuck",
                "brightscript",
                "bro",
                "bsl",
                "c",
                "cfscript",
                "chaiscript",
                "cil",
                "clike",
                "clojure",
                "cmake",
                "cobol",
                "coffeescript",
                "concurnas",
                "coq",
                "core",
                "cpp",
                "crystal",
                "csharp",
                "cshtml",
                "csp",
                "css",
                "css-extras",
                "csv",
                "cypher",
                "d",
                "dart",
                "dataweave",
                "dax",
                "dhall",
                "diff",
                "django",
                "dns-zone-file",
                "docker",
                "dot",
                "ebnf",
                "editorconfig",
                "eiffel",
                "ejs",
                "elixir",
                "elm",
                "erb",
                "erlang",
                "etlua",
                "excel-formula",
                "factor",
                "false",
                "firestore-security-rules",
                "flow",
                "fortran",
                "fsharp",
                "ftl",
                "gap",
                "gcode",
                "gdscript",
                "gedcom",
                "gherkin",
                "git",
                "glsl",
                "gml",
                "gn",
                "go",
                "go-module",
                "graphql",
                "groovy",
                "haml",
                "handlebars",
                "haskell",
                "haxe",
                "hcl",
                "hlsl",
                "hoon",
                "hpkp",
                "hsts",
                "http",
                "ichigojam",
                "icon",
                "icu-message-format",
                "idris",
                "iecst",
                "ignore",
                "index",
                "inform7",
                "ini",
                "io",
                "j",
                "java",
                "javadoc",
                "javadoclike",
                "javascript",
                "javastacktrace",
                "jexl",
                "jolie",
                "jq",
                "js-extras",
                "js-templates",
                "jsdoc",
                "json",
                "json5",
                "jsonp",
                "jsstacktrace",
                "jsx",
                "julia",
                "keepalived",
                "keyman",
                "kotlin",
                "kumir",
                "kusto",
                "latex",
                "latte",
                "less",
                "lilypond",
                "liquid",
                "lisp",
                "livescript",
                "llvm",
                "log",
                "lolcode",
                "lua",
                "magma",
                "makefile",
                "markdown",
                "markup",
                "markup-templating",
                "matlab",
                "maxscript",
                "mel",
                "mermaid",
                "mizar",
                "mongodb",
                "monkey",
                "moonscript",
                "n1ql",
                "n4js",
                "nand2tetris-hdl",
                "naniscript",
                "nasm",
                "neon",
                "nevod",
                "nginx",
                "nim",
                "nix",
                "nsis",
                "objectivec",
                "ocaml",
                "opencl",
                "openqasm",
                "oz",
                "parigp",
                "parser",
                "pascal",
                "pascaligo",
                "pcaxis",
                "peoplecode",
                "perl",
                "php",
                "php-extras",
                "phpdoc",
                "plsql",
                "powerquery",
                "powershell",
                "processing",
                "prolog",
                "promql",
                "properties",
                "protobuf",
                "psl",
                "pug",
                "puppet",
                "pure",
                "purebasic",
                "purescript",
                "python",
                "q",
                "qml",
                "qore",
                "qsharp",
                "r",
                "racket",
                "reason",
                "regex",
                "rego",
                "renpy",
                "rest",
                "rip",
                "roboconf",
                "robotframework",
                "ruby",
                "rust",
                "sas",
                "sass",
                "scala",
                "scheme",
                "scss",
                "shell-session",
                "smali",
                "smalltalk",
                "smarty",
                "sml",
                "solidity",
                "solution-file",
                "soy",
                "sparql",
                "splunk-spl",
                "sqf",
                "sql",
                "squirrel",
                "stan",
                "stylus",
                "swift",
                "systemd",
                "t4-cs",
                "t4-templating",
                "t4-vb",
                "tap",
                "tcl",
                "textile",
                "toml",
                "tremor",
                "tsx",
                "tt2",
                "turtle",
                "twig",
                "typescript",
                "typoscript",
                "unrealscript",
                "uorazor",
                "uri",
                "v",
                "vala",
                "vbnet",
                "velocity",
                "verilog",
                "vhdl",
                "vim",
                "visual-basic",
                "warpscript",
                "wasm",
                "web-idl",
                "wiki",
                "wolfram",
                "wren",
                "xeora",
                "xml-doc",
                "xojo",
                "xquery",
                "yaml",
                "yang",
                "zig",
            ]
        ]
        | None = None,
        code: Var[str] | str | None = None,
        show_line_numbers: Var[bool] | bool | None = None,
        starting_line_number: Var[int] | int | None = None,
        wrap_long_lines: Var[bool] | bool | None = None,
        custom_style: dict[str, str | Var | Color] | None = None,
        code_tag_props: Var[dict[str, str]] | dict[str, str] | None = None,
        can_copy: bool | None = None,
        copy_button: Component | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> CodeBlock:
        """Create a text component.

        Args:
            *children: The children of the component.
            theme: The theme to use ("light" or "dark").
            language: The language to use.
            code: The code to display.
            show_line_numbers: If this is enabled line numbers will be shown next to the code block.
            starting_line_number: The starting line number to use.
            wrap_long_lines: Whether to wrap long lines.
            custom_style: A custom style for the code block.
            code_tag_props: Props passed down to the code tag.
            can_copy: Whether a copy button should appear.
            copy_button: A custom copy button to override the default one.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props to pass to the component.

        Returns:
            The text component.
        """

code_block = CodeblockNamespace()
