"""Stub file for reflex/components/moment/moment.py"""

# ------------------- DO NOT EDIT ----------------------
# This file was generated by `reflex/utils/pyi_generator.py`!
# ------------------------------------------------------
import dataclasses
from collections.abc import Mapping, Sequence
from datetime import date, datetime, time, timedelta
from typing import Any

from reflex.components.component import NoSSRComponent
from reflex.components.core.breakpoints import Breakpoints
from reflex.event import EventType, PointerEventInfo
from reflex.utils.imports import ImportDict
from reflex.vars.base import Var

@dataclasses.dataclass(frozen=True)
class MomentDelta:
    years: int | None
    quarters: int | None
    months: int | None
    weeks: int | None
    days: int | None
    hours: int | None
    minutes: int | None
    seconds: int | None
    milliseconds: int | None

class Moment(NoSSRComponent):
    def add_imports(self) -> ImportDict: ...
    @classmethod
    def create(
        cls,
        *children,
        interval: Var[int] | int | None = None,
        format: Var[str] | str | None = None,
        trim: Var[bool] | bool | None = None,
        parse: Var[str] | str | None = None,
        add: MomentDelta | Var[MomentDelta] | None = None,
        subtract: MomentDelta | Var[MomentDelta] | None = None,
        from_now: Var[bool] | bool | None = None,
        from_now_during: Var[int] | int | None = None,
        to_now: Var[bool] | bool | None = None,
        with_title: Var[bool] | bool | None = None,
        title_format: Var[str] | str | None = None,
        diff: Var[str] | str | None = None,
        decimal: Var[bool] | bool | None = None,
        unit: Var[str] | str | None = None,
        duration: Var[str] | str | None = None,
        date: Var[date | datetime | str | time | timedelta]
        | date
        | datetime
        | str
        | time
        | timedelta
        | None = None,
        duration_from_now: Var[bool] | bool | None = None,
        unix: Var[bool] | bool | None = None,
        local: Var[bool] | bool | None = None,
        tz: Var[str] | str | None = None,
        locale: Var[str] | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_change: EventType[()] | EventType[str] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> Moment:
        """Create the component.

        Args:
            *children: The children of the component.
            interval: How often the date update (how often time update / 0 to disable).
            format: Formats the date according to the given format string.
            trim: When formatting duration time, the largest-magnitude tokens are automatically trimmed when they have no value.
            parse:  Use the parse attribute to tell moment how to parse the given date when non-standard.
            add: Add a delta to the base date (keys are "years", "quarters", "months", "weeks", "days", "hours", "minutes", "seconds")
            subtract: Subtract a delta to the base date (keys are "years", "quarters", "months", "weeks", "days", "hours", "minutes", "seconds")
            from_now: Displays the date as the time from now, e.g. "5 minutes ago".
            from_now_during: Setting fromNowDuring will display the relative time as with fromNow but just during its value in milliseconds, after that format will be used instead.
            to_now: Similar to fromNow, but gives the opposite interval.
            with_title: Adds a title attribute to the element with the complete date.
            title_format: How the title date is formatted when using the withTitle attribute.
            diff: Show the different between this date and the rendered child.
            decimal: Display the diff as decimal.
            unit: Display the diff in given unit.
            duration: Shows the duration (elapsed time) between two dates. duration property should be behind date property time-wise.
            date: The date to display (also work if passed as children).
            duration_from_now: Shows the duration (elapsed time) between now and the provided datetime.
            unix: Tells Moment to parse the given date value as a unix timestamp.
            local: Outputs the result in local time.
            tz: Display the date in the given timezone.
            locale: The locale to use when rendering.
            on_change: Fires when the date changes.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """
