"""Stub file for reflex/components/recharts/polar.py"""

# ------------------- DO NOT EDIT ----------------------
# This file was generated by `reflex/utils/pyi_generator.py`!
# ------------------------------------------------------
from collections.abc import Mapping, Sequence
from typing import Any, Literal

from reflex.components.core.breakpoints import Breakpoints
from reflex.constants.colors import Color
from reflex.event import EventType, PointerEventInfo
from reflex.vars.base import Var

from .recharts import Recharts

class Pie(Recharts):
    @classmethod
    def get_event_triggers(cls) -> dict[str, Var | Any]: ...
    @classmethod
    def create(
        cls,
        *children,
        data: Sequence[dict[str, Any]] | Var[Sequence[dict[str, Any]]] | None = None,
        data_key: Var[int | str] | int | str | None = None,
        cx: Var[int | str] | int | str | None = None,
        cy: Var[int | str] | int | str | None = None,
        inner_radius: Var[int | str] | int | str | None = None,
        outer_radius: Var[int | str] | int | str | None = None,
        start_angle: Var[int] | int | None = None,
        end_angle: Var[int] | int | None = None,
        min_angle: Var[int] | int | None = None,
        padding_angle: Var[int] | int | None = None,
        name_key: Var[str] | str | None = None,
        legend_type: Literal[
            "circle",
            "cross",
            "diamond",
            "line",
            "none",
            "plainline",
            "rect",
            "square",
            "star",
            "triangle",
            "wye",
        ]
        | Var[
            Literal[
                "circle",
                "cross",
                "diamond",
                "line",
                "none",
                "plainline",
                "rect",
                "square",
                "star",
                "triangle",
                "wye",
            ]
        ]
        | None = None,
        label: Var[bool | dict[str, Any]] | bool | dict[str, Any] | None = None,
        label_line: Var[bool | dict[str, Any]] | bool | dict[str, Any] | None = None,
        stroke: Color | Var[Color | str] | str | None = None,
        fill: Color | Var[Color | str] | str | None = None,
        is_animation_active: Var[bool] | bool | None = None,
        animation_begin: Var[int] | int | None = None,
        animation_duration: Var[int] | int | None = None,
        animation_easing: Literal[
            "ease", "ease-in", "ease-in-out", "ease-out", "linear"
        ]
        | Var[Literal["ease", "ease-in", "ease-in-out", "ease-out", "linear"]]
        | None = None,
        root_tab_index: Var[int] | int | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_animation_end: EventType[()] | None = None,
        on_animation_start: EventType[()] | None = None,
        on_click: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        **props,
    ) -> Pie:
        """Create the component.

        Args:
            *children: The children of the component.
            data: The source data which each element is an object.
            data_key: The key of each sector's value.
            cx: The x-coordinate of center. If set a percentage, the final value is obtained by multiplying the percentage of container width. Default: "50%"
            cy: The y-coordinate of center. If set a percentage, the final value is obtained by multiplying the percentage of container height. Default: "50%"
            inner_radius: The inner radius of pie, which can be set to a percent value. Default: 0
            outer_radius: The outer radius of pie, which can be set to a percent value. Default: "80%"
            start_angle: The angle of first sector. Default: 0
            end_angle: The end angle of last sector, which should be unequal to start_angle. Default: 360
            min_angle: The minimum angle of each unzero data. Default: 0
            padding_angle: The angle between two sectors. Default: 0
            name_key: The key of each sector's name. Default: "name"
            legend_type: The type of icon in legend. If set to 'none', no legend item will be rendered. Default: "rect"
            label: If false set, labels will not be drawn. If true set, labels will be drawn which have the props calculated internally. Default: False
            label_line: If false set, label lines will not be drawn. If true set, label lines will be drawn which have the props calculated internally. Default: False
            stroke: Stoke color. Default: rx.color("accent", 9)
            fill: Fill color. Default: rx.color("accent", 3)
            is_animation_active: If set false, animation of tooltip will be disabled. Default: true in CSR, and false in SSR
            animation_begin: Specifies when the animation should begin, the unit of this option is ms. Default: 400
            animation_duration: Specifies the duration of animation, the unit of this option is ms. Default: 1500
            animation_easing: The type of easing function. Default: "ease"
            root_tab_index: The tabindex of wrapper surrounding the cells. Default: 0
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class Radar(Recharts):
    @classmethod
    def get_event_triggers(cls) -> dict[str, Var | Any]: ...
    @classmethod
    def create(
        cls,
        *children,
        data_key: Var[int | str] | int | str | None = None,
        points: Sequence[dict[str, Any]] | Var[Sequence[dict[str, Any]]] | None = None,
        dot: Var[bool | dict[str, Any]] | bool | dict[str, Any] | None = None,
        stroke: Color | Var[Color | str] | str | None = None,
        fill: Color | Var[Color | str] | str | None = None,
        fill_opacity: Var[float] | float | None = None,
        legend_type: Literal[
            "circle",
            "cross",
            "diamond",
            "line",
            "none",
            "plainline",
            "rect",
            "square",
            "star",
            "triangle",
            "wye",
        ]
        | Var[
            Literal[
                "circle",
                "cross",
                "diamond",
                "line",
                "none",
                "plainline",
                "rect",
                "square",
                "star",
                "triangle",
                "wye",
            ]
        ]
        | None = None,
        label: Var[bool | dict[str, Any]] | bool | dict[str, Any] | None = None,
        is_animation_active: Var[bool] | bool | None = None,
        animation_begin: Var[int] | int | None = None,
        animation_duration: Var[int] | int | None = None,
        animation_easing: Literal[
            "ease", "ease-in", "ease-in-out", "ease-out", "linear"
        ]
        | Var[Literal["ease", "ease-in", "ease-in-out", "ease-out", "linear"]]
        | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_animation_end: EventType[()] | None = None,
        on_animation_start: EventType[()] | None = None,
        **props,
    ) -> Radar:
        """Create the component.

        Args:
            *children: The children of the component.
            data_key: The key of a group of data which should be unique in a radar chart.
            points: The coordinates of all the vertices of the radar shape, like [{ x, y }].
            dot: If false set, dots will not be drawn. Default: True
            stroke: Stoke color. Default: rx.color("accent", 9)
            fill: Fill color. Default: rx.color("accent", 3)
            fill_opacity: The opacity to fill the chart. Default: 0.6
            legend_type: The type of icon in legend. If set to 'none', no legend item will be rendered. Default: "rect"
            label: If false set, labels will not be drawn. Default: True
            is_animation_active: If set false, animation of polygon will be disabled. Default: True in CSR, and False in SSR
            animation_begin: Specifies when the animation should begin, the unit of this option is ms. Default: 0
            animation_duration: Specifies the duration of animation, the unit of this option is ms. Default: 1500
            animation_easing: The type of easing function. 'ease' | 'ease-in' | 'ease-out' | 'ease-in-out' | 'linear'. Default: "ease"
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class RadialBar(Recharts):
    @classmethod
    def get_event_triggers(cls) -> dict[str, Var | Any]: ...
    @classmethod
    def create(
        cls,
        *children,
        data: Sequence[dict[str, Any]] | Var[Sequence[dict[str, Any]]] | None = None,
        data_key: Var[int | str] | int | str | None = None,
        min_angle: Var[int] | int | None = None,
        legend_type: Literal[
            "circle",
            "cross",
            "diamond",
            "line",
            "none",
            "plainline",
            "rect",
            "square",
            "star",
            "triangle",
            "wye",
        ]
        | Var[
            Literal[
                "circle",
                "cross",
                "diamond",
                "line",
                "none",
                "plainline",
                "rect",
                "square",
                "star",
                "triangle",
                "wye",
            ]
        ]
        | None = None,
        label: Var[bool | dict[str, Any]] | bool | dict[str, Any] | None = None,
        background: Var[bool | dict[str, Any]] | bool | dict[str, Any] | None = None,
        is_animation_active: Var[bool] | bool | None = None,
        animation_begin: Var[int] | int | None = None,
        animation_duration: Var[int] | int | None = None,
        animation_easing: Literal[
            "ease", "ease-in", "ease-in-out", "ease-out", "linear"
        ]
        | Var[Literal["ease", "ease-in", "ease-in-out", "ease-out", "linear"]]
        | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_animation_end: EventType[()] | None = None,
        on_animation_start: EventType[()] | None = None,
        on_click: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        **props,
    ) -> RadialBar:
        """Create the component.

        Args:
            *children: The children of the component.
            data: The source data which each element is an object.
            data_key: The key of a group of data which should be unique to show the meaning of angle axis.
            min_angle: Min angle of each bar. A positive value between 0 and 360. Default: 0
            legend_type: The type of icon in legend. If set to 'none', no legend item will be rendered. Default: "rect"
            label: If false set, labels will not be drawn. If true set, labels will be drawn which have the props calculated internally. Default: False
            background: If false set, background sector will not be drawn. Default: False
            is_animation_active: If set false, animation of radial bars will be disabled. Default: True
            animation_begin: Specifies when the animation should begin, the unit of this option is ms. Default: 0
            animation_duration: Specifies the duration of animation, the unit of this option is ms. Default 1500
            animation_easing: The type of easing function. 'ease' | 'ease-in' | 'ease-out' | 'ease-in-out' | 'linear'. Default: "ease"
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class PolarAngleAxis(Recharts):
    @classmethod
    def create(
        cls,
        *children,
        data_key: Var[int | str] | int | str | None = None,
        cx: Var[int | str] | int | str | None = None,
        cy: Var[int | str] | int | str | None = None,
        radius: Var[int | str] | int | str | None = None,
        axis_line: Var[bool | dict[str, Any]] | bool | dict[str, Any] | None = None,
        axis_line_type: Literal["circle", "polygon"]
        | Var[Literal["circle", "polygon"]]
        | None = None,
        tick_line: Var[bool | dict[str, Any]] | bool | dict[str, Any] | None = None,
        tick: Var[bool | dict[str, Any]] | bool | dict[str, Any] | None = None,
        ticks: Sequence[dict[str, Any]] | Var[Sequence[dict[str, Any]]] | None = None,
        orientation: Var[str] | str | None = None,
        stroke: Color | Var[Color | str] | str | None = None,
        allow_duplicated_category: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> PolarAngleAxis:
        """Create the component.

        Args:
            *children: The children of the component.
            data_key: The key of a group of data which should be unique to show the meaning of angle axis.
            cx: The x-coordinate of center. If set a percentage, the final value is obtained by multiplying the percentage of container width.
            cy: The y-coordinate of center. If set a percentage, the final value is obtained by multiplying the percentage of container height.
            radius: The outer radius of circle grid. If set a percentage, the final value is obtained by multiplying the percentage of maxRadius which is calculated by the width, height, cx, cy.
            axis_line: If false set, axis line will not be drawn. If true set, axis line will be drawn which have the props calculated internally. If object set, axis line will be drawn which have the props mergered by the internal calculated props and the option. Default: True
            axis_line_type: The type of axis line. Default: "polygon"
            tick_line: If false set, tick lines will not be drawn. If true set, tick lines will be drawn which have the props calculated internally. If object set, tick lines will be drawn which have the props mergered by the internal calculated props and the option. Default: False
            tick: If false set, ticks will not be drawn. If true set, ticks will be drawn which have the props calculated internally. If object set, ticks will be drawn which have the props mergered by the internal calculated props and the option. Default: True
            ticks: The array of every tick's value and angle.
            orientation: The orientation of axis text. Default: "outer"
            stroke: The stroke color of axis. Default: rx.color("gray", 10)
            allow_duplicated_category: Allow the axis has duplicated categorys or not when the type of axis is "category". Default: True
            on_click: The customized event handler of click on the ticks of this axis.
            on_mouse_down: The customized event handler of mousedown on the the ticks of this axis.
            on_mouse_up: The customized event handler of mouseup on the ticks of this axis.
            on_mouse_move: The customized event handler of mousemove on the ticks of this axis.
            on_mouse_over: The customized event handler of mouseover on the ticks of this axis.
            on_mouse_out: The customized event handler of mouseout on the ticks of this axis.
            on_mouse_enter: The customized event handler of moustenter on the ticks of this axis.
            on_mouse_leave: The customized event handler of mouseleave on the ticks of this axis.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class PolarGrid(Recharts):
    @classmethod
    def create(
        cls,
        *children,
        cx: Var[int] | int | None = None,
        cy: Var[int] | int | None = None,
        inner_radius: Var[int] | int | None = None,
        outer_radius: Var[int] | int | None = None,
        polar_angles: Sequence[int] | Var[Sequence[int]] | None = None,
        polar_radius: Sequence[int] | Var[Sequence[int]] | None = None,
        grid_type: Literal["circle", "polygon"]
        | Var[Literal["circle", "polygon"]]
        | None = None,
        stroke: Color | Var[Color | str] | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> PolarGrid:
        """Create the component.

        Args:
            *children: The children of the component.
            cx: The x-coordinate of center.
            cy: The y-coordinate of center.
            inner_radius: The radius of the inner polar grid.
            outer_radius: The radius of the outer polar grid.
            polar_angles: The array of every line grid's angle.
            polar_radius: The array of every line grid's radius.
            grid_type: The type of polar grids. 'polygon' | 'circle'. Default: "polygon"
            stroke: The stroke color of grid. Default: rx.color("gray", 10)
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class PolarRadiusAxis(Recharts):
    @classmethod
    def get_event_triggers(cls) -> dict[str, Var | Any]: ...
    @classmethod
    def create(
        cls,
        *children,
        angle: Var[int] | int | None = None,
        type_: Literal["category", "number"]
        | Var[Literal["category", "number"]]
        | None = None,
        allow_duplicated_category: Var[bool] | bool | None = None,
        cx: Var[int] | int | None = None,
        cy: Var[int] | int | None = None,
        reversed: Var[bool] | bool | None = None,
        orientation: Literal["left", "middle", "right"]
        | Var[Literal["left", "middle", "right"]]
        | None = None,
        axis_line: Var[bool | dict[str, Any]] | bool | dict[str, Any] | None = None,
        tick: Var[bool | dict[str, Any]] | bool | dict[str, Any] | None = None,
        tick_count: Var[int] | int | None = None,
        scale: Literal[
            "auto",
            "band",
            "identity",
            "linear",
            "log",
            "ordinal",
            "point",
            "pow",
            "quantile",
            "quantize",
            "sequential",
            "sqrt",
            "threshold",
            "time",
            "utc",
        ]
        | Var[
            Literal[
                "auto",
                "band",
                "identity",
                "linear",
                "log",
                "ordinal",
                "point",
                "pow",
                "quantile",
                "quantize",
                "sequential",
                "sqrt",
                "threshold",
                "time",
                "utc",
            ]
        ]
        | None = None,
        domain: Sequence[int | str] | Var[Sequence[int | str]] | None = None,
        stroke: Color | Var[Color | str] | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_click: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        **props,
    ) -> PolarRadiusAxis:
        """Create the component.

        Args:
            *children: The children of the component.
            angle: The angle of radial direction line to display axis text. Default: 0
            type_: The type of axis line. 'number' | 'category'. Default: "category"
            allow_duplicated_category: Allow the axis has duplicated categorys or not when the type of axis is "category". Default: True
            cx: The x-coordinate of center.
            cy: The y-coordinate of center.
            reversed: If set to true, the ticks of this axis are reversed. Default: False
            orientation: The orientation of axis text. Default: "right"
            axis_line: If false set, axis line will not be drawn. If true set, axis line will be drawn which have the props calculated internally. If object set, axis line will be drawn which have the props mergered by the internal calculated props and the option. Default: True
            tick: If false set, ticks will not be drawn. If true set, ticks will be drawn which have the props calculated internally. If object set, ticks will be drawn which have the props mergered by the internal calculated props and the option. Default: True
            tick_count: The count of axis ticks. Not used if 'type' is 'category'. Default: 5
            scale: If 'auto' set, the scale function is linear scale. 'auto' | 'linear' | 'pow' | 'sqrt' | 'log' | 'identity' | 'time' | 'band' | 'point' | 'ordinal' | 'quantile' | 'quantize' | 'utc' | 'sequential' | 'threshold'. Default: "auto"
            domain: The domain of the polar radius axis, specifying the minimum and maximum values. Default: [0, "auto"]
            stroke: The stroke color of axis. Default: rx.color("gray", 10)
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

pie = Pie.create
radar = Radar.create
radial_bar = RadialBar.create
polar_angle_axis = PolarAngleAxis.create
polar_grid = PolarGrid.create
polar_radius_axis = PolarRadiusAxis.create
