# tibiapi

[![CI](https://github.com/lucasmonstrox/tibiapi/actions/workflows/ci.yml/badge.svg)](https://github.com/lucasmonstrox/tibiapi/actions/workflows/ci.yml)
[![codecov](https://codecov.io/gh/lucasmonstrox/tibiapi/branch/main/graph/badge.svg?token=7BTPYKHC80)](https://codecov.io/gh/lucasmonstrox/tibiapi)
[![Documentation Status](https://readthedocs.org/projects/tibiapi/badge/?version=latest)](https://tibiapi.readthedocs.io/en/latest/)
[![PyPI version](https://badge.fury.io/py/tibiapi.svg)](https://badge.fury.io/py/tibiapi)

> Fastest Tibia API made in [Python](https://www.python.org/downloads/release/python-3117).

See the full documentation in [https://tibiapi.readthedocs.io](https://tibiapi.readthedocs.io).

## 🗺️ Features

| Features   | Done |
| ---------- | ---- |
| ActionBar  | ❌   |
| Analytics  | ❌   |
| BattleList | 🚧   |
| Chat       | ❌   |
| GameWindow | 🚧   |
| Imbuements | ❌   |
| Inventory  | ❌   |
| Market     | ❌   |
| Minimap    | 🚧   |
| Options    | ❌   |
| PartyList  | ❌   |
| Skills     | 🚧   |
| SpellList  | ❌   |
| StatusBar  | ✔️   |
| Store      | ❌   |
| VIPList    | ❌   |

## 🧰 Installation

### Requirements

- [Python](https://www.python.org/downloads/release/python-3117) 3.11.7

### with [pip](https://pypi.org/project/pip/)

```sh
pip install tibiapi
```

### with [poetry](https://python-poetry.org/)

```sh
poetry install tibiapi
```

### with [git](https://git-scm.com/)

tibiapi can be directly used from GitHub by cloning the repository into a subfolder of your project root which might be useful if you want to use the very latest version:

```sh
git clone https://github.com/lucasmonstrox/tibiapi
```

Next, install the tibiapi and its dependencies with:

```sh
pip install -e tibiapi
```

## ✅ TODO

- configure mypy
- add benchmark tests
- add commit hooks tool

## 👷 Authors

- [**lucasmonstrox**](http://github.com/lucasmonstrox)([**linkedin**](https://www.linkedin.com/in/lucasmonstrox/)) - Owner & Developer

See also the list of [contributors](../../graphs/contributors) who participated
in this project.

If you want to become a contributor, send a message to my [**linkedin**](https://www.linkedin.com/in/lucasmonstrox/).
