"""
Constants used by snapctl
"""
COMPANY_NAME = 'Snapser'
VERSION_PREFIX = ''
VERSION = '0.53.1'
CONFIG_FILE_MAC = '~/.snapser/config'
CONFIG_FILE_WIN = '%homepath%\\.snapser\\config'

DEFAULT_PROFILE = 'default'
API_KEY = 'SNAPSER_API_KEY'
URL_KEY = 'SNAPSER_URL_KEY'
CONFIG_PATH_KEY = 'SNAPSER_CONFIG_PATH'
SERVER_CALL_TIMEOUT = 300

# Telemetry
AMPLITUDE_HTTP_US = "https://api2.amplitude.com/2/httpapi"
AMPLITUDE_HTTP_EU = "https://api.eu.amplitude.com/2/httpapi"

# HTTP codes
HTTP_UNAUTHORIZED = 401
HTTP_FORBIDDEN = 403
HTTP_NOT_FOUND = 404
HTTP_CONFLICT = 409

# HTTP Error codes
HTTP_ERROR_GAME_LIMIT_REACHED = 520
HTTP_ERROR_DUPLICATE_GAME_NAME = 523
HTTP_ERROR_RESOURCE_NOT_FOUND = 541
HTTP_ERROR_SERVICE_VERSION_EXISTS = 542
HTTP_ERROR_SERVICE_IN_USE = 543
HTTP_ERROR_TAG_NOT_AVAILABLE = 544
HTTP_ERROR_ADD_ON_NOT_ENABLED = 547
HTTP_ERROR_SNAPEND_MANIFEST_MISMATCH = 594

# CLI Return Codes
SNAPCTL_SUCCESS = 0
SNAPCTL_ERROR = 1
SNAPCTL_INPUT_ERROR = 2
SNAPCTL_RESOURCE_NOT_FOUND = 3

# Configuration Errors - 10 - 19
SNAPCTL_CONFIGURATION_INCORRECT = 10
SNAPCTL_CONFIGURATION_ERROR = 11
SNAPCTL_DEPENDENCY_MISSING = 12

# BYOGS Errors - 20 - 29
SNAPCTL_BYOGS_GENERIC_ERROR = 20
SNAPCTL_BYOGS_DEPENDENCY_MISSING = 21
SNAPCTL_BYOGS_ECR_LOGIN_ERROR = 22
SNAPCTL_BYOGS_BUILD_ERROR = 23
SNAPCTL_BYOGS_TAG_ERROR = 24
SNAPCTL_BYOGS_PUBLISH_ERROR = 25
SNAPCTL_BYOGS_PUBLISH_PERMISSION_ERROR = 26
SNAPCTL_BYOGS_PUBLISH_DUPLICATE_TAG_ERROR = 27

# BYOSNAP Errors - 30 - 49 then 86 - 90
SNAPCTL_BYOSNAP_NOT_FOUND = SNAPCTL_RESOURCE_NOT_FOUND
SNAPCTL_BYOSNAP_GENERIC_ERROR = 30
SNAPCTL_BYOSNAP_DEPENDENCY_MISSING = 31
SNAPCTL_BYOSNAP_ECR_LOGIN_ERROR = 32
SNAPCTL_BYOSNAP_BUILD_ERROR = 33
SNAPCTL_BYOSNAP_TAG_ERROR = 34
SNAPCTL_BYOSNAP_PUBLISH_IMAGE_ERROR = 35
SNAPCTL_BYOSNAP_PUBLISH_IMAGE_PERMISSION_ERROR = 36
SNAPCTL_BYOSNAP_PUBLISH_IMAGE_DUPLICATE_TAG_ERROR = 37
SNAPCTL_BYOSNAP_CREATE_ERROR = 38
SNAPCTL_BYOSNAP_CREATE_PERMISSION_ERROR = 39
SNAPCTL_BYOSNAP_CREATE_DUPLICATE_NAME_ERROR = 40
SNAPCTL_BYOSNAP_PUBLISH_VERSION_ERROR = 41
SNAPCTL_BYOSNAP_PUBLISH_VERSION_PERMISSION_ERROR = 42
SNAPCTL_BYOSNAP_PUBLISH_VERSION_DUPLICATE_VERSION_ERROR = 43
SNAPCTL_BYOSNAP_PUBLISH_VERSION_DUPLICATE_TAG_ERROR = 44
SNAPCTL_BYOSNAP_UPDATE_VERSION_ERROR = 45
SNAPCTL_BYOSNAP_UPDATE_VERSION_SERVICE_IN_USE_ERROR = 46
SNAPCTL_BYOSNAP_UPDATE_VERSION_TAG_ERROR = 47
SNAPCTL_BYOSNAP_UPDATE_VERSION_INVALID_VERSION_ERROR = 48
SNAPCTL_BYOSNAP_PUBLISH_ERROR = 49
# Starting with new error codes for BYOSNAP post
SNAPCTL_BYOSNAP_GENERATE_PROFILE_ERROR = 86
SNAPCTL_BYOSNAP_SWAGGER_ERROR = 87

# Game Errors - 50 - 60
SNAPCTL_GAME_NOT_FOUND = SNAPCTL_RESOURCE_NOT_FOUND
SNAPCTL_GAME_GENERIC_ERROR = 50
SNAPCTL_GAME_CREATE_ERROR = 51
SNAPCTL_GAME_CREATE_PERMISSION_ERROR = 52
SNAPCTL_GAME_CREATE_LIMIT_ERROR = 53
SNAPCTL_GAME_CREATE_DUPLICATE_NAME_ERROR = 54
SNAPCTL_GAME_ENUMERATE_ERROR = 55

# Snapend Errors - 60 - 79
SNAPCTL_SNAPEND_NOT_FOUND = SNAPCTL_RESOURCE_NOT_FOUND
SNAPCTL_SNAPEND_GENERIC_ERROR = 60
SNAPCTL_SNAPEND_ENUMERATE_ERROR = 61
SNAPCTL_SNAPEND_CLONE_ERROR = 62
SNAPCTL_SNAPEND_CLONE_SERVER_ERROR = 63
SNAPCTL_SNAPEND_CLONE_TIMEOUT_ERROR = 64
SNAPCTL_SNAPEND_APPLY_ERROR = 65
SNAPCTL_SNAPEND_APPLY_SERVER_ERROR = 66
SNAPCTL_SNAPEND_APPLY_TIMEOUT_ERROR = 67
SNAPCTL_SNAPEND_PROMOTE_ERROR = 68
SNAPCTL_SNAPEND_PROMOTE_SERVER_ERROR = 69
SNAPCTL_SNAPEND_PROMOTE_TIMEOUT_ERROR = 70
SNAPCTL_SNAPEND_DOWNLOAD_ERROR = 71
SNAPCTL_SNAPEND_UPDATE_ERROR = 72
SNAPCTL_SNAPEND_UPDATE_SERVER_ERROR = 73
SNAPCTL_SNAPEND_UPDATE_TIMEOUT_ERROR = 74
SNAPCTL_SNAPEND_STATE_ERROR = 75
SNAPCTL_SNAPEND_APPLY_MANIFEST_MISMATCH_ERROR = 76

# Generate Errors - 80 - 85
SNAPCTL_GENERATE_GENERIC_ERROR = 80
SNAPCTL_GENERATE_CREDENTIALS_ERROR = 81

# BYOWs Errors - 95 - 99
SNAPCTL_BYOWS_GENERIC_ERROR = 95
SNAPCTL_BYOWS_ATTACH_ERROR = 96
SNAPCTL_BYOWS_RESET_ERROR = 97
