import os
import argparse


pRTC_usage = '''
==================================== pRTC example commands ====================================

# requires: ruby (bio-nwk, colorize, parallel, csv)

TreeSAK pRTC -i out -m mcmc.txt -r rtc_dir -o after_pRTC_mcmc.txt

python3 # format of RTC file (tab separated)
symbiont_1,symbiont_2    host_1,host_2:0.9876
recipient1,recipient2	 donor1,donor2:0.6789

# The above two lines can be interpreted as follows:
The probability of the last common ancestor (LCA) of symbiont_1 and symbiont_2 being 
younger than that of host_1 and host_2 is 0.9876. Similarly, for a gene transfer event, 
the LCA of the two recipients is younger than that of the two donors, the value 0.6789 
is the PROBABILITY of the occurrence of the transfer event. Please do NOT use this module 
if you are unsure about the interpretation of the value you provided.

# Note
This is a Python wrapper to perform the probabilistic RTC dating proposed by Dr. Sishuo Wang.
If you used it in your dating analysis, please cite:
https://doi.org/10.1101/2023.06.18.545440 or https://github.com/evolbeginner/rrtc.

===============================================================================================
'''


def pRTC(args):

    in_file     = args['i']
    mcmc_txt    = args['m']
    rrtc_dir    = args['r']
    ruby_exe    = args['ruby']
    op_txt      = args['o']

    current_file_path = '/'.join(os.path.realpath(__file__).split('/')[:-1])
    do_rrtc_rb        = '%s/do_rrtc.rb'                             % current_file_path
    do_rrtc_cmd       = '%s %s --mcmctxt %s -i %s --rrtc %s > %s'   % (ruby_exe, do_rrtc_rb, mcmc_txt, in_file, rrtc_dir, op_txt)
    print('Running: ' + do_rrtc_cmd)
    os.system(do_rrtc_cmd)


if __name__ == '__main__':

    pRTC_parser = argparse.ArgumentParser(usage=pRTC_usage)
    pRTC_parser.add_argument('-i',     required=True,                   help='the file "out" generated by MCMCTree')
    pRTC_parser.add_argument('-m',     required=True,                   help='the file "mcmc.txt" generated by MCMCTree')
    pRTC_parser.add_argument('-r',     required=True,                   help='the folder that contains all RTCs')
    pRTC_parser.add_argument('-o',     required=True,                   help='output txt file')
    pRTC_parser.add_argument('-ruby',  required=False, default='ruby',  help='path to ruby executable file, default: ruby')
    args = vars(pRTC_parser.parse_args())
    pRTC(args)
