# 
# Generated by the nebius.base.protos.compiler.  DO NOT EDIT!
# 

"""Auto-generated Nebius SDK package for ``nebius.maintenance.v1alpha1``"""

import builtins as builtins
import collections.abc as abc
import datetime as datetime
import google.protobuf.descriptor as descriptor_1
import google.protobuf.message as message_1
import google.protobuf.timestamp_pb2 as timestamp_pb2
import nebius.aio.client as client
import nebius.aio.request as request
import nebius.aio.request_kwargs as request_kwargs
import nebius.api.nebius.common.v1 as v1_1
import nebius.api.nebius.common.v1.metadata_pb2 as metadata_pb2
import nebius.api.nebius.maintenance.v1alpha1.maintenance_pb2 as maintenance_pb2
import nebius.api.nebius.maintenance.v1alpha1.maintenance_service_pb2 as maintenance_service_pb2
import nebius.base.protos.descriptor as descriptor
import nebius.base.protos.pb_classes as pb_classes
import nebius.base.protos.pb_enum as pb_enum
import nebius.base.protos.unset as unset
import nebius.base.protos.well_known as well_known_1
import typing_extensions as typing_extensions
#@ local imports here @#

# file: nebius/maintenance/v1alpha1/maintenance.proto
class State(pb_enum.Enum):
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.EnumDescriptor](".nebius.maintenance.v1alpha1.State",maintenance_pb2.DESCRIPTOR,descriptor_1.EnumDescriptor)
    STATE_UNSPECIFIED = 0
    STATE_SCHEDULED = 1
    """
    Maintenance operation is scheduled to be run in the future.
    """
    
    STATE_IN_PROGRESS = 2
    """
    Maintenance operation is currently in progress.
    """
    
    STATE_FINISHED = 3
    """
    Maintenance operation has been successfully completed.
    """
    
    STATE_ERROR = 4
    """
    Maintenance operation has encountered an error and could not be completed.
    """
    
    STATE_CANCELLED = 5
    """
    Maintenance operation has been cancelled by the system.
    """
    

class Maintenance(pb_classes.Message):
    """
    Maintenance operations are initiated by Nebius Cloud infrastructure.
    They are used to perform scheduled or urgent operations on Nebius Cloud resources,
    such as Managed Services or Standalone Applications, that are necessary for
    maintaining the service in an operable state. These operations run automatically,
    without user intervention.
    """
    
    __PB2_CLASS__ = maintenance_pb2.Maintenance
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.maintenance.v1alpha1.Maintenance",maintenance_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
        spec: "MaintenanceSpec|maintenance_pb2.MaintenanceSpec|None|unset.UnsetType" = unset.Unset,
        status: "MaintenanceStatus|maintenance_pb2.MaintenanceStatus|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
        if not isinstance(spec, unset.UnsetType):
            self.spec = spec
        if not isinstance(status, unset.UnsetType):
            self.status = status
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
            "spec",
            "status",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        """
        The metadata for the maintenance operation resource.
        """
        
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    @builtins.property
    def spec(self) -> "MaintenanceSpec":
        """
        Specifications for the maintenance operation.
        """
        
        return super()._get_field("spec", explicit_presence=False,
        wrap=MaintenanceSpec,
        )
    @spec.setter
    def spec(self, value: "MaintenanceSpec|maintenance_pb2.MaintenanceSpec|None") -> None:
        return super()._set_field("spec",value,explicit_presence=False,
        )
    
    @builtins.property
    def status(self) -> "MaintenanceStatus":
        """
        Current status of the maintenance operation.
        """
        
        return super()._get_field("status", explicit_presence=False,
        wrap=MaintenanceStatus,
        )
    @status.setter
    def status(self, value: "MaintenanceStatus|maintenance_pb2.MaintenanceStatus|None") -> None:
        return super()._set_field("status",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
        "spec":"spec",
        "status":"status",
    }
    
class MaintenanceSpec(pb_classes.Message):
    __PB2_CLASS__ = maintenance_pb2.MaintenanceSpec
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.maintenance.v1alpha1.MaintenanceSpec",maintenance_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
        "scheduled_at": well_known_1.ts_mask,
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        scheduled_at: "timestamp_pb2.Timestamp|datetime.datetime|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(scheduled_at, unset.UnsetType):
            self.scheduled_at = scheduled_at
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "scheduled_at",
        ]
    
    @builtins.property
    def scheduled_at(self) -> "datetime.datetime":
        """
        Timestamp indicating when the maintenance operation is scheduled to run.
        """
        
        return super()._get_field("scheduled_at", explicit_presence=False,
        wrap=well_known_1.from_timestamp
        )
    @scheduled_at.setter
    def scheduled_at(self, value: "timestamp_pb2.Timestamp|datetime.datetime|None") -> None:
        return super()._set_field("scheduled_at",value,explicit_presence=False,
        unwrap=well_known_1.to_timestamp
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "scheduled_at":"scheduled_at",
    }
    
class MaintenanceStatus(pb_classes.Message):
    __PB2_CLASS__ = maintenance_pb2.MaintenanceStatus
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.maintenance.v1alpha1.MaintenanceStatus",maintenance_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
        "started_at": well_known_1.ts_mask,
        "finished_at": well_known_1.ts_mask,
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        affected_resources: "abc.Iterable[Resource]|None|unset.UnsetType" = unset.Unset,
        started_at: "timestamp_pb2.Timestamp|datetime.datetime|None|unset.UnsetType" = unset.Unset,
        finished_at: "timestamp_pb2.Timestamp|datetime.datetime|None|unset.UnsetType" = unset.Unset,
        state: "State|maintenance_pb2.State|None|unset.UnsetType" = unset.Unset,
        reschedulable: "builtins.bool|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(affected_resources, unset.UnsetType):
            self.affected_resources = affected_resources
        if not isinstance(started_at, unset.UnsetType):
            self.started_at = started_at
        if not isinstance(finished_at, unset.UnsetType):
            self.finished_at = finished_at
        if not isinstance(state, unset.UnsetType):
            self.state = state
        if not isinstance(reschedulable, unset.UnsetType):
            self.reschedulable = reschedulable
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "affected_resources",
            "started_at",
            "finished_at",
            "state",
            "reschedulable",
        ]
    
    @builtins.property
    def affected_resources(self) -> "abc.MutableSequence[Resource]":
        """
        List of resources that are affected by this maintenance operation.
        """
        
        return super()._get_field("affected_resources", explicit_presence=False,
        wrap=pb_classes.Repeated.with_wrap(Resource,None,None),
        )
    @affected_resources.setter
    def affected_resources(self, value: "abc.Iterable[Resource]|None") -> None:
        return super()._set_field("affected_resources",value,explicit_presence=False,
        )
    
    @builtins.property
    def started_at(self) -> "datetime.datetime":
        """
        Timestamp indicating when the maintenance operation started.
        """
        
        return super()._get_field("started_at", explicit_presence=False,
        wrap=well_known_1.from_timestamp
        )
    @started_at.setter
    def started_at(self, value: "timestamp_pb2.Timestamp|datetime.datetime|None") -> None:
        return super()._set_field("started_at",value,explicit_presence=False,
        unwrap=well_known_1.to_timestamp
        )
    
    @builtins.property
    def finished_at(self) -> "datetime.datetime":
        """
        Timestamp indicating when the maintenance operation finished.
        """
        
        return super()._get_field("finished_at", explicit_presence=False,
        wrap=well_known_1.from_timestamp
        )
    @finished_at.setter
    def finished_at(self, value: "timestamp_pb2.Timestamp|datetime.datetime|None") -> None:
        return super()._set_field("finished_at",value,explicit_presence=False,
        unwrap=well_known_1.to_timestamp
        )
    
    @builtins.property
    def state(self) -> "State":
        """
        Current state of the maintenance operation.
        """
        
        return super()._get_field("state", explicit_presence=False,
        wrap=State,
        )
    @state.setter
    def state(self, value: "State|maintenance_pb2.State|None") -> None:
        return super()._set_field("state",value,explicit_presence=False,
        )
    
    @builtins.property
    def reschedulable(self) -> "builtins.bool":
        """
        Indicates whether the maintenance operation's scheduled_at time can be changed.
        """
        
        return super()._get_field("reschedulable", explicit_presence=False,
        )
    @reschedulable.setter
    def reschedulable(self, value: "builtins.bool|None") -> None:
        return super()._set_field("reschedulable",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "affected_resources":"affected_resources",
        "started_at":"started_at",
        "finished_at":"finished_at",
        "state":"state",
        "reschedulable":"reschedulable",
    }
    
class Resource(pb_classes.Message):
    __PB2_CLASS__ = maintenance_pb2.Resource
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.maintenance.v1alpha1.Resource",maintenance_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        parent_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(id, unset.UnsetType):
            self.id = id
        if not isinstance(parent_id, unset.UnsetType):
            self.parent_id = parent_id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "id",
            "parent_id",
        ]
    
    @builtins.property
    def id(self) -> "builtins.str":
        """
        Unique identifier for the resource.
        """
        
        return super()._get_field("id", explicit_presence=False,
        )
    @id.setter
    def id(self, value: "builtins.str|None") -> None:
        return super()._set_field("id",value,explicit_presence=False,
        )
    
    @builtins.property
    def parent_id(self) -> "builtins.str":
        """
        IAM container of the resource.
        """
        
        return super()._get_field("parent_id", explicit_presence=False,
        )
    @parent_id.setter
    def parent_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("parent_id",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "id":"id",
        "parent_id":"parent_id",
    }
    
# file: nebius/maintenance/v1alpha1/maintenance_service.proto
class ListMaintenancesRequest(pb_classes.Message):
    __PB2_CLASS__ = maintenance_service_pb2.ListMaintenancesRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.maintenance.v1alpha1.ListMaintenancesRequest",maintenance_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        parent_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(parent_id, unset.UnsetType):
            self.parent_id = parent_id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "parent_id",
        ]
    
    @builtins.property
    def parent_id(self) -> "builtins.str":
        """
        Identifier of IAM container to list maintenance operations from.
        """
        
        return super()._get_field("parent_id", explicit_presence=False,
        )
    @parent_id.setter
    def parent_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("parent_id",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "parent_id":"parent_id",
    }
    
class ListMaintenancesResponse(pb_classes.Message):
    __PB2_CLASS__ = maintenance_service_pb2.ListMaintenancesResponse
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.maintenance.v1alpha1.ListMaintenancesResponse",maintenance_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        items: "abc.Iterable[Maintenance]|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(items, unset.UnsetType):
            self.items = items
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "items",
        ]
    
    @builtins.property
    def items(self) -> "abc.MutableSequence[Maintenance]":
        """
        List of maintenance operations.
        """
        
        return super()._get_field("items", explicit_presence=False,
        wrap=pb_classes.Repeated.with_wrap(Maintenance,None,None),
        )
    @items.setter
    def items(self, value: "abc.Iterable[Maintenance]|None") -> None:
        return super()._set_field("items",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "items":"items",
    }
    
class GetMaintenanceRequest(pb_classes.Message):
    __PB2_CLASS__ = maintenance_service_pb2.GetMaintenanceRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.maintenance.v1alpha1.GetMaintenanceRequest",maintenance_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(id, unset.UnsetType):
            self.id = id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "id",
        ]
    
    @builtins.property
    def id(self) -> "builtins.str":
        """
        ID of the maintenance operation to return.
        To get the maintenance ID use a [MaintenanceService.List] request.
        """
        
        return super()._get_field("id", explicit_presence=False,
        )
    @id.setter
    def id(self, value: "builtins.str|None") -> None:
        return super()._set_field("id",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "id":"id",
    }
    
class UpdateMaintenanceRequest(pb_classes.Message):
    __PB2_CLASS__ = maintenance_service_pb2.UpdateMaintenanceRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.maintenance.v1alpha1.UpdateMaintenanceRequest",maintenance_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
        spec: "MaintenanceSpec|maintenance_pb2.MaintenanceSpec|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
        if not isinstance(spec, unset.UnsetType):
            self.spec = spec
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
            "spec",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        """
        Metadata associated with the maintenance operation.
        Must include ID of the maintenance operation to update.
        """
        
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    @builtins.property
    def spec(self) -> "MaintenanceSpec":
        """
        Updated specification for the maintenance operation.
        """
        
        return super()._get_field("spec", explicit_presence=False,
        wrap=MaintenanceSpec,
        )
    @spec.setter
    def spec(self, value: "MaintenanceSpec|maintenance_pb2.MaintenanceSpec|None") -> None:
        return super()._set_field("spec",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
        "spec":"spec",
    }
    
class UpdateMaintenanceResponse(pb_classes.Message):
    __PB2_CLASS__ = maintenance_service_pb2.UpdateMaintenanceResponse
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.maintenance.v1alpha1.UpdateMaintenanceResponse",maintenance_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        maintenance: "Maintenance|maintenance_pb2.Maintenance|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(maintenance, unset.UnsetType):
            self.maintenance = maintenance
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "maintenance",
        ]
    
    @builtins.property
    def maintenance(self) -> "Maintenance":
        """
        Updated maintenance operation.
        """
        
        return super()._get_field("maintenance", explicit_presence=False,
        wrap=Maintenance,
        )
    @maintenance.setter
    def maintenance(self, value: "Maintenance|maintenance_pb2.Maintenance|None") -> None:
        return super()._set_field("maintenance",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "maintenance":"maintenance",
    }
    

class MaintenanceServiceClient(client.Client):
    """
    A set of methods for managing maintenance operations.
    
    This class provides the client methods for the ``.nebius.maintenance.v1alpha1.MaintenanceService`` service.
    
    Each method constructs a :class:`nebius.aio.request.Request` object
    that represents the in-flight RPC. The request can be awaited (async)
    or waited synchronously using its ``.wait()`` helpers.
    
    The request methods accept various parameters to configure metadata,
    timeouts, authorization, and retries. See individual method docstrings
    for details.
    
    :cvar __service_name__: The full protobuf service name.
    """
    
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.ServiceDescriptor](".nebius.maintenance.v1alpha1.MaintenanceService",maintenance_service_pb2.DESCRIPTOR,descriptor_1.ServiceDescriptor)
    """The protobuf service descriptor extraction function."""
    __service_name__ = ".nebius.maintenance.v1alpha1.MaintenanceService"
    
    def get(self,
        request: "GetMaintenanceRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request.Request["GetMaintenanceRequest","Maintenance"]:
        """
        Returns the specified maintenance operation.
        To get the list of upcoming and past maintenance operations, make a [List] request.
        
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.maintenance.v1alpha1.GetMaintenanceRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.maintenance.v1alpha1.Maintenance`.
        """
        
        return super().request(
            method="Get",
            request=request,
            result_pb2_class=maintenance_pb2.Maintenance,
            result_wrapper=pb_classes.simple_wrapper(Maintenance),
            **kwargs,
        )
    
    def list(self,
        request: "ListMaintenancesRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request.Request["ListMaintenancesRequest","ListMaintenancesResponse"]:
        """
        Retrieves the list of maintenance operations that belong
        to the specified container.
        
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.maintenance.v1alpha1.ListMaintenancesRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.maintenance.v1alpha1.ListMaintenancesResponse`.
        """
        
        return super().request(
            method="List",
            request=request,
            result_pb2_class=maintenance_service_pb2.ListMaintenancesResponse,
            result_wrapper=pb_classes.simple_wrapper(ListMaintenancesResponse),
            **kwargs,
        )
    
    def update(self,
        request: "UpdateMaintenanceRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request.Request["UpdateMaintenanceRequest","UpdateMaintenanceResponse"]:
        """
        Updates the specified maintenance operation.
        
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.maintenance.v1alpha1.UpdateMaintenanceRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.maintenance.v1alpha1.UpdateMaintenanceResponse`.
        """
        
        return super().request(
            method="Update",
            request=request,
            result_pb2_class=maintenance_service_pb2.UpdateMaintenanceResponse,
            result_wrapper=pb_classes.simple_wrapper(UpdateMaintenanceResponse),
            **kwargs,
        )
    

__all__ = [
    #@ local import names here @#
    "State",
    "Maintenance",
    "MaintenanceSpec",
    "MaintenanceStatus",
    "Resource",
    "ListMaintenancesRequest",
    "ListMaintenancesResponse",
    "GetMaintenanceRequest",
    "UpdateMaintenanceRequest",
    "UpdateMaintenanceResponse",
    "MaintenanceServiceClient",
]
