# 
# Generated by the nebius.base.protos.compiler.  DO NOT EDIT!
# 

"""Auto-generated Nebius SDK package for ``nebius.mysterybox.v1``"""

import builtins as builtins
import collections.abc as abc
import datetime as datetime
import google.protobuf.descriptor as descriptor_1
import google.protobuf.message as message_1
import google.protobuf.timestamp_pb2 as timestamp_pb2
import nebius.aio.client as client
import nebius.aio.operation as operation
import nebius.aio.request as request_1
import nebius.aio.request_kwargs as request_kwargs
import nebius.api.nebius.common.v1 as v1_1
import nebius.api.nebius.common.v1.metadata_pb2 as metadata_pb2
import nebius.api.nebius.common.v1.operation_pb2 as operation_pb2
import nebius.api.nebius.mysterybox.v1.payload_pb2 as payload_pb2
import nebius.api.nebius.mysterybox.v1.payload_service_pb2 as payload_service_pb2
import nebius.api.nebius.mysterybox.v1.secret_pb2 as secret_pb2
import nebius.api.nebius.mysterybox.v1.secret_service_pb2 as secret_service_pb2
import nebius.api.nebius.mysterybox.v1.secret_version_pb2 as secret_version_pb2
import nebius.api.nebius.mysterybox.v1.secret_version_service_pb2 as secret_version_service_pb2
import nebius.base.fieldmask_protobuf as fieldmask_protobuf
import nebius.base.protos.descriptor as descriptor
import nebius.base.protos.pb_classes as pb_classes
import nebius.base.protos.pb_enum as pb_enum
import nebius.base.protos.unset as unset
import nebius.base.protos.well_known as well_known_1
import typing as typing
import typing_extensions as typing_extensions
#@ local imports here @#

# file: nebius/mysterybox/v1/payload.proto
class Payload(pb_classes.Message):
    """
    Represents the secret's content as key-value pair.
    """
    
    __PB2_CLASS__ = payload_pb2.Payload
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.mysterybox.v1.Payload",payload_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    class __OneOfClass_payload__(pb_classes.OneOf):
        name: builtins.str= "payload"
        
        def __init__(self, msg: "Payload") -> None:
            super().__init__()
            self._message: "Payload" = msg
    
    class __OneOfClass_payload_string_value__(__OneOfClass_payload__):
        field: typing.Literal["string_value"] = "string_value"
        
        def __init__(self, msg: "Payload") -> None:
            super().__init__(msg)
        @builtins.property
        def value(self) -> "builtins.str":
            return self._message.string_value
    
    class __OneOfClass_payload_binary_value__(__OneOfClass_payload__):
        field: typing.Literal["binary_value"] = "binary_value"
        
        def __init__(self, msg: "Payload") -> None:
            super().__init__(msg)
        @builtins.property
        def value(self) -> "builtins.bytes":
            return self._message.binary_value
    
    @builtins.property
    def payload(self) -> __OneOfClass_payload_string_value__|__OneOfClass_payload_binary_value__|None:
        field_name_1: str|None = super().which_field_in_oneof("payload")
        match field_name_1:
            case "string_value":
                return self.__OneOfClass_payload_string_value__(self)
            case "binary_value":
                return self.__OneOfClass_payload_binary_value__(self)
            case None:
                return None
            case _:
                raise pb_classes.OneOfMatchError(field_name_1)
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        key: "builtins.str|None|unset.UnsetType" = unset.Unset,
        string_value: "builtins.str|None|unset.UnsetType" = unset.Unset,
        binary_value: "builtins.bytes|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(key, unset.UnsetType):
            self.key = key
        if not isinstance(string_value, unset.UnsetType):
            self.string_value = string_value
        if not isinstance(binary_value, unset.UnsetType):
            self.binary_value = binary_value
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "key",
            "string_value",
            "binary_value",
            "payload",
        ]
    
    @builtins.property
    def key(self) -> "builtins.str":
        """
        Non-confidential key of the payload entry.
        """
        
        return super()._get_field("key", explicit_presence=False,
        )
    @key.setter
    def key(self, value: "builtins.str|None") -> None:
        return super()._set_field("key",value,explicit_presence=False,
        )
    
    @builtins.property
    def string_value(self) -> "builtins.str|None":
        """
        The text data to encrypt and store in the version of the secret.
        """
        
        return super()._get_field("string_value", explicit_presence=True,
        )
    @string_value.setter
    def string_value(self, value: "builtins.str|None") -> None:
        return super()._set_field("string_value",value,explicit_presence=True,
        )
    
    @builtins.property
    def binary_value(self) -> "builtins.bytes|None":
        """
        The binary data to encrypt and store in the version of the secret.
        """
        
        return super()._get_field("binary_value", explicit_presence=True,
        )
    @binary_value.setter
    def binary_value(self, value: "builtins.bytes|None") -> None:
        return super()._set_field("binary_value",value,explicit_presence=True,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "key":"key",
        "string_value":"string_value",
        "binary_value":"binary_value",
        "payload":"payload",
    }
    
# file: nebius/mysterybox/v1/payload_service.proto
class GetPayloadRequest(pb_classes.Message):
    __PB2_CLASS__ = payload_service_pb2.GetPayloadRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.mysterybox.v1.GetPayloadRequest",payload_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        secret_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        version_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(secret_id, unset.UnsetType):
            self.secret_id = secret_id
        if not isinstance(version_id, unset.UnsetType):
            self.version_id = version_id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "secret_id",
            "version_id",
        ]
    
    @builtins.property
    def secret_id(self) -> "builtins.str":
        return super()._get_field("secret_id", explicit_presence=False,
        )
    @secret_id.setter
    def secret_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("secret_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def version_id(self) -> "builtins.str":
        """
        Desired version of the secret. If not provided, the primary version of the secret will be returned.
        """
        
        return super()._get_field("version_id", explicit_presence=False,
        )
    @version_id.setter
    def version_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("version_id",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "secret_id":"secret_id",
        "version_id":"version_id",
    }
    
class GetPayloadByKeyRequest(pb_classes.Message):
    __PB2_CLASS__ = payload_service_pb2.GetPayloadByKeyRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.mysterybox.v1.GetPayloadByKeyRequest",payload_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        secret_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        version_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        key: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(secret_id, unset.UnsetType):
            self.secret_id = secret_id
        if not isinstance(version_id, unset.UnsetType):
            self.version_id = version_id
        if not isinstance(key, unset.UnsetType):
            self.key = key
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "secret_id",
            "version_id",
            "key",
        ]
    
    @builtins.property
    def secret_id(self) -> "builtins.str":
        return super()._get_field("secret_id", explicit_presence=False,
        )
    @secret_id.setter
    def secret_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("secret_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def version_id(self) -> "builtins.str":
        """
        Desired version of the secret. If not provided, the primary version of the secret will be returned.
        """
        
        return super()._get_field("version_id", explicit_presence=False,
        )
    @version_id.setter
    def version_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("version_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def key(self) -> "builtins.str":
        """
        Payload's key to be retrieved.
        """
        
        return super()._get_field("key", explicit_presence=False,
        )
    @key.setter
    def key(self, value: "builtins.str|None") -> None:
        return super()._set_field("key",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "secret_id":"secret_id",
        "version_id":"version_id",
        "key":"key",
    }
    
class SecretPayload(pb_classes.Message):
    __PB2_CLASS__ = payload_service_pb2.SecretPayload
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.mysterybox.v1.SecretPayload",payload_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        version_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        data: "abc.Iterable[Payload]|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(version_id, unset.UnsetType):
            self.version_id = version_id
        if not isinstance(data, unset.UnsetType):
            self.data = data
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "version_id",
            "data",
        ]
    
    @builtins.property
    def version_id(self) -> "builtins.str":
        """
        Secret's version related to returned payload.
        """
        
        return super()._get_field("version_id", explicit_presence=False,
        )
    @version_id.setter
    def version_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("version_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def data(self) -> "abc.MutableSequence[Payload]":
        return super()._get_field("data", explicit_presence=False,
        wrap=pb_classes.Repeated.with_wrap(Payload,None,None),
        )
    @data.setter
    def data(self, value: "abc.Iterable[Payload]|None") -> None:
        return super()._set_field("data",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "version_id":"version_id",
        "data":"data",
    }
    
class SecretPayloadEntry(pb_classes.Message):
    __PB2_CLASS__ = payload_service_pb2.SecretPayloadEntry
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.mysterybox.v1.SecretPayloadEntry",payload_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        version_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        data: "Payload|payload_pb2.Payload|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(version_id, unset.UnsetType):
            self.version_id = version_id
        if not isinstance(data, unset.UnsetType):
            self.data = data
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "version_id",
            "data",
        ]
    
    @builtins.property
    def version_id(self) -> "builtins.str":
        """
        Secret's version related to returned payload.
        """
        
        return super()._get_field("version_id", explicit_presence=False,
        )
    @version_id.setter
    def version_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("version_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def data(self) -> "Payload":
        return super()._get_field("data", explicit_presence=False,
        wrap=Payload,
        )
    @data.setter
    def data(self, value: "Payload|payload_pb2.Payload|None") -> None:
        return super()._set_field("data",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "version_id":"version_id",
        "data":"data",
    }
    

class PayloadServiceClient(client.Client):
    """
    This class provides the client methods for the ``.nebius.mysterybox.v1.PayloadService`` service.
    
    Each method constructs a :class:`nebius.aio.request.Request` object
    that represents the in-flight RPC. The request can be awaited (async)
    or waited synchronously using its ``.wait()`` helpers.
    
    The request methods accept various parameters to configure metadata,
    timeouts, authorization, and retries. See individual method docstrings
    for details.
    
    :cvar __service_name__: The full protobuf service name.
    """
    
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.ServiceDescriptor](".nebius.mysterybox.v1.PayloadService",payload_service_pb2.DESCRIPTOR,descriptor_1.ServiceDescriptor)
    """The protobuf service descriptor extraction function."""
    __service_name__ = ".nebius.mysterybox.v1.PayloadService"
    
    def get(self,
        request: "GetPayloadRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["GetPayloadRequest","SecretPayload"]:
        """
        Returns the secret's payload in its decrypted format.
        
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.mysterybox.v1.GetPayloadRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.mysterybox.v1.SecretPayload`.
        """
        
        return super().request(
            method="Get",
            request=request,
            result_pb2_class=payload_service_pb2.SecretPayload,
            result_wrapper=pb_classes.simple_wrapper(SecretPayload),
            **kwargs,
        )
    
    def get_by_key(self,
        request: "GetPayloadByKeyRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["GetPayloadByKeyRequest","SecretPayloadEntry"]:
        """
        Returns the secret's payload value by key in its decrypted format.
        
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.mysterybox.v1.GetPayloadByKeyRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.mysterybox.v1.SecretPayloadEntry`.
        """
        
        return super().request(
            method="GetByKey",
            request=request,
            result_pb2_class=payload_service_pb2.SecretPayloadEntry,
            result_wrapper=pb_classes.simple_wrapper(SecretPayloadEntry),
            **kwargs,
        )
    

# file: nebius/mysterybox/v1/secret_version.proto
class SecretVersion(pb_classes.Message):
    __PB2_CLASS__ = secret_version_pb2.SecretVersion
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.mysterybox.v1.SecretVersion",secret_version_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
        spec: "SecretVersionSpec|secret_version_pb2.SecretVersionSpec|None|unset.UnsetType" = unset.Unset,
        status: "SecretVersionStatus|secret_version_pb2.SecretVersionStatus|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
        if not isinstance(spec, unset.UnsetType):
            self.spec = spec
        if not isinstance(status, unset.UnsetType):
            self.status = status
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
            "spec",
            "status",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    @builtins.property
    def spec(self) -> "SecretVersionSpec":
        return super()._get_field("spec", explicit_presence=False,
        wrap=SecretVersionSpec,
        )
    @spec.setter
    def spec(self, value: "SecretVersionSpec|secret_version_pb2.SecretVersionSpec|None") -> None:
        return super()._set_field("spec",value,explicit_presence=False,
        )
    
    @builtins.property
    def status(self) -> "SecretVersionStatus":
        """
        The status of the secret version.
        """
        
        return super()._get_field("status", explicit_presence=False,
        wrap=SecretVersionStatus,
        )
    @status.setter
    def status(self, value: "SecretVersionStatus|secret_version_pb2.SecretVersionStatus|None") -> None:
        return super()._set_field("status",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
        "spec":"spec",
        "status":"status",
    }
    
class SecretVersionSpec(pb_classes.Message):
    __PB2_CLASS__ = secret_version_pb2.SecretVersionSpec
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.mysterybox.v1.SecretVersionSpec",secret_version_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        description: "builtins.str|None|unset.UnsetType" = unset.Unset,
        payload: "abc.Iterable[Payload]|None|unset.UnsetType" = unset.Unset,
        set_primary: "builtins.bool|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(description, unset.UnsetType):
            self.description = description
        if not isinstance(payload, unset.UnsetType):
            self.payload = payload
        if not isinstance(set_primary, unset.UnsetType):
            self.set_primary = set_primary
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "description",
            "payload",
            "set_primary",
        ]
    
    @builtins.property
    def description(self) -> "builtins.str":
        """
        Description of the version.
        """
        
        return super()._get_field("description", explicit_presence=False,
        )
    @description.setter
    def description(self, value: "builtins.str|None") -> None:
        return super()._set_field("description",value,explicit_presence=False,
        )
    
    @builtins.property
    def payload(self) -> "abc.MutableSequence[Payload]":
        """
        Payload entries related to the version.
        """
        
        return super()._get_field("payload", explicit_presence=False,
        wrap=pb_classes.Repeated.with_wrap(Payload,None,None),
        )
    @payload.setter
    def payload(self, value: "abc.Iterable[Payload]|None") -> None:
        return super()._set_field("payload",value,explicit_presence=False,
        )
    
    @builtins.property
    def set_primary(self) -> "builtins.bool":
        return super()._get_field("set_primary", explicit_presence=False,
        )
    @set_primary.setter
    def set_primary(self, value: "builtins.bool|None") -> None:
        return super()._set_field("set_primary",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "description":"description",
        "payload":"payload",
        "set_primary":"set_primary",
    }
    
class SecretVersionStatus(pb_classes.Message):
    __PB2_CLASS__ = secret_version_pb2.SecretVersionStatus
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.mysterybox.v1.SecretVersionStatus",secret_version_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
        "deleted_at": well_known_1.ts_mask,
        "purge_at": well_known_1.ts_mask,
    }
    
    class State(pb_enum.Enum):
        __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.EnumDescriptor](".nebius.mysterybox.v1.SecretVersionStatus.State",secret_version_pb2.DESCRIPTOR,descriptor_1.EnumDescriptor)
        STATE_UNSPECIFIED = 0
        ACTIVE = 1
        """
        Resource is active, ready for use
        """
        
        SCHEDULED_FOR_DELETION = 2
        """
        Resource was marked as soft deleted
        """
        
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        state: "SecretVersionStatus.State|secret_version_pb2.SecretVersionStatus.State|None|unset.UnsetType" = unset.Unset,
        deleted_at: "timestamp_pb2.Timestamp|datetime.datetime|None|unset.UnsetType" = unset.Unset,
        purge_at: "timestamp_pb2.Timestamp|datetime.datetime|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(state, unset.UnsetType):
            self.state = state
        if not isinstance(deleted_at, unset.UnsetType):
            self.deleted_at = deleted_at
        if not isinstance(purge_at, unset.UnsetType):
            self.purge_at = purge_at
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "state",
            "deleted_at",
            "purge_at",
            "State",
        ]
    
    @builtins.property
    def state(self) -> "SecretVersionStatus.State":
        """
        State (ACTIVE, SCHEDULED_FOR_DELETION)
        """
        
        return super()._get_field("state", explicit_presence=False,
        wrap=SecretVersionStatus.State,
        )
    @state.setter
    def state(self, value: "SecretVersionStatus.State|secret_version_pb2.SecretVersionStatus.State|None") -> None:
        return super()._set_field("state",value,explicit_presence=False,
        )
    
    @builtins.property
    def deleted_at(self) -> "datetime.datetime":
        """
        Time when user called soft delete method
        """
        
        return super()._get_field("deleted_at", explicit_presence=False,
        wrap=well_known_1.from_timestamp
        )
    @deleted_at.setter
    def deleted_at(self, value: "timestamp_pb2.Timestamp|datetime.datetime|None") -> None:
        return super()._set_field("deleted_at",value,explicit_presence=False,
        unwrap=well_known_1.to_timestamp
        )
    
    @builtins.property
    def purge_at(self) -> "datetime.datetime":
        """
        Time when key should be totally deleted from DB
        """
        
        return super()._get_field("purge_at", explicit_presence=False,
        wrap=well_known_1.from_timestamp
        )
    @purge_at.setter
    def purge_at(self, value: "timestamp_pb2.Timestamp|datetime.datetime|None") -> None:
        return super()._set_field("purge_at",value,explicit_presence=False,
        unwrap=well_known_1.to_timestamp
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "state":"state",
        "deleted_at":"deleted_at",
        "purge_at":"purge_at",
        "State":"State",
    }
    
# file: nebius/mysterybox/v1/secret.proto
class Secret(pb_classes.Message):
    __PB2_CLASS__ = secret_pb2.Secret
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.mysterybox.v1.Secret",secret_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
        spec: "SecretSpec|secret_pb2.SecretSpec|None|unset.UnsetType" = unset.Unset,
        status: "SecretStatus|secret_pb2.SecretStatus|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
        if not isinstance(spec, unset.UnsetType):
            self.spec = spec
        if not isinstance(status, unset.UnsetType):
            self.status = status
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
            "spec",
            "status",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    @builtins.property
    def spec(self) -> "SecretSpec":
        """
        The specifications for creating a secret.
        """
        
        return super()._get_field("spec", explicit_presence=False,
        wrap=SecretSpec,
        )
    @spec.setter
    def spec(self, value: "SecretSpec|secret_pb2.SecretSpec|None") -> None:
        return super()._set_field("spec",value,explicit_presence=False,
        )
    
    @builtins.property
    def status(self) -> "SecretStatus":
        """
        The status of the secret.
        """
        
        return super()._get_field("status", explicit_presence=False,
        wrap=SecretStatus,
        )
    @status.setter
    def status(self, value: "SecretStatus|secret_pb2.SecretStatus|None") -> None:
        return super()._set_field("status",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
        "spec":"spec",
        "status":"status",
    }
    
class SecretSpec(pb_classes.Message):
    __PB2_CLASS__ = secret_pb2.SecretSpec
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.mysterybox.v1.SecretSpec",secret_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    class __OneOfClass__primary_version_id__(pb_classes.OneOf):
        name: builtins.str= "_primary_version_id"
        
        def __init__(self, msg: "SecretSpec") -> None:
            super().__init__()
            self._message: "SecretSpec" = msg
    
    class __OneOfClass__primary_version_id_primary_version_id__(__OneOfClass__primary_version_id__):
        field: typing.Literal["primary_version_id"] = "primary_version_id"
        
        def __init__(self, msg: "SecretSpec") -> None:
            super().__init__(msg)
        @builtins.property
        def value(self) -> "builtins.str":
            return self._message.primary_version_id
    
    @builtins.property
    def _primary_version_id(self) -> __OneOfClass__primary_version_id_primary_version_id__|None:
        field_name_1: str|None = super().which_field_in_oneof("_primary_version_id")
        match field_name_1:
            case "primary_version_id":
                return self.__OneOfClass__primary_version_id_primary_version_id__(self)
            case None:
                return None
            case _:
                raise pb_classes.OneOfMatchError(field_name_1)
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        description: "builtins.str|None|unset.UnsetType" = unset.Unset,
        primary_version_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        secret_version: "SecretVersionSpec|secret_version_pb2.SecretVersionSpec|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(description, unset.UnsetType):
            self.description = description
        if not isinstance(primary_version_id, unset.UnsetType):
            self.primary_version_id = primary_version_id
        if not isinstance(secret_version, unset.UnsetType):
            self.secret_version = secret_version
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "description",
            "primary_version_id",
            "secret_version",
            "_primary_version_id",
        ]
    
    @builtins.property
    def description(self) -> "builtins.str":
        """
        Description of the secret.
        """
        
        return super()._get_field("description", explicit_presence=False,
        )
    @description.setter
    def description(self, value: "builtins.str|None") -> None:
        return super()._set_field("description",value,explicit_presence=False,
        )
    
    @builtins.property
    def primary_version_id(self) -> "builtins.str|None":
        """
        Specifies the primary version of the secret to update its payload. This parameter should only be provided during update operations.
        """
        
        return super()._get_field("primary_version_id", explicit_presence=True,
        )
    @primary_version_id.setter
    def primary_version_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("primary_version_id",value,explicit_presence=True,
        )
    
    @builtins.property
    def secret_version(self) -> "SecretVersionSpec":
        """
        Secret's version specification, defines the secret version, including its payload. This parameter must be specified only during create operations.
        """
        
        return super()._get_field("secret_version", explicit_presence=False,
        wrap=SecretVersionSpec,
        )
    @secret_version.setter
    def secret_version(self, value: "SecretVersionSpec|secret_version_pb2.SecretVersionSpec|None") -> None:
        return super()._set_field("secret_version",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "description":"description",
        "primary_version_id":"primary_version_id",
        "secret_version":"secret_version",
        "_primary_version_id":"_primary_version_id",
    }
    
class SecretStatus(pb_classes.Message):
    __PB2_CLASS__ = secret_pb2.SecretStatus
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.mysterybox.v1.SecretStatus",secret_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
        "deleted_at": well_known_1.ts_mask,
        "purge_at": well_known_1.ts_mask,
    }
    
    class State(pb_enum.Enum):
        __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.EnumDescriptor](".nebius.mysterybox.v1.SecretStatus.State",secret_pb2.DESCRIPTOR,descriptor_1.EnumDescriptor)
        STATE_UNSPECIFIED = 0
        ACTIVE = 1
        """
        Resource is active, ready for use
        """
        
        SCHEDULED_FOR_DELETION = 2
        """
        Resource was marked as soft deleted
        """
        
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        state: "SecretStatus.State|secret_pb2.SecretStatus.State|None|unset.UnsetType" = unset.Unset,
        deleted_at: "timestamp_pb2.Timestamp|datetime.datetime|None|unset.UnsetType" = unset.Unset,
        purge_at: "timestamp_pb2.Timestamp|datetime.datetime|None|unset.UnsetType" = unset.Unset,
        effective_kms_key_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(state, unset.UnsetType):
            self.state = state
        if not isinstance(deleted_at, unset.UnsetType):
            self.deleted_at = deleted_at
        if not isinstance(purge_at, unset.UnsetType):
            self.purge_at = purge_at
        if not isinstance(effective_kms_key_id, unset.UnsetType):
            self.effective_kms_key_id = effective_kms_key_id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "state",
            "deleted_at",
            "purge_at",
            "effective_kms_key_id",
            "State",
        ]
    
    @builtins.property
    def state(self) -> "SecretStatus.State":
        """
        State (ACTIVE, SCHEDULED_FOR_DELETION)
        """
        
        return super()._get_field("state", explicit_presence=False,
        wrap=SecretStatus.State,
        )
    @state.setter
    def state(self, value: "SecretStatus.State|secret_pb2.SecretStatus.State|None") -> None:
        return super()._set_field("state",value,explicit_presence=False,
        )
    
    @builtins.property
    def deleted_at(self) -> "datetime.datetime":
        """
        Time when user called soft delete method
        """
        
        return super()._get_field("deleted_at", explicit_presence=False,
        wrap=well_known_1.from_timestamp
        )
    @deleted_at.setter
    def deleted_at(self, value: "timestamp_pb2.Timestamp|datetime.datetime|None") -> None:
        return super()._set_field("deleted_at",value,explicit_presence=False,
        unwrap=well_known_1.to_timestamp
        )
    
    @builtins.property
    def purge_at(self) -> "datetime.datetime":
        """
        Time when key should be totally deleted from DB
        """
        
        return super()._get_field("purge_at", explicit_presence=False,
        wrap=well_known_1.from_timestamp
        )
    @purge_at.setter
    def purge_at(self, value: "timestamp_pb2.Timestamp|datetime.datetime|None") -> None:
        return super()._set_field("purge_at",value,explicit_presence=False,
        unwrap=well_known_1.to_timestamp
        )
    
    @builtins.property
    def effective_kms_key_id(self) -> "builtins.str":
        return super()._get_field("effective_kms_key_id", explicit_presence=False,
        )
    @effective_kms_key_id.setter
    def effective_kms_key_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("effective_kms_key_id",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "state":"state",
        "deleted_at":"deleted_at",
        "purge_at":"purge_at",
        "effective_kms_key_id":"effective_kms_key_id",
        "State":"State",
    }
    
# file: nebius/mysterybox/v1/secret_service.proto
class CreateSecretRequest(pb_classes.Message):
    __PB2_CLASS__ = secret_service_pb2.CreateSecretRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.mysterybox.v1.CreateSecretRequest",secret_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
        spec: "SecretSpec|secret_pb2.SecretSpec|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
        if not isinstance(spec, unset.UnsetType):
            self.spec = spec
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
            "spec",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    @builtins.property
    def spec(self) -> "SecretSpec":
        return super()._get_field("spec", explicit_presence=False,
        wrap=SecretSpec,
        )
    @spec.setter
    def spec(self, value: "SecretSpec|secret_pb2.SecretSpec|None") -> None:
        return super()._set_field("spec",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
        "spec":"spec",
    }
    
class UpdateSecretRequest(pb_classes.Message):
    __PB2_CLASS__ = secret_service_pb2.UpdateSecretRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.mysterybox.v1.UpdateSecretRequest",secret_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
        spec: "SecretSpec|secret_pb2.SecretSpec|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
        if not isinstance(spec, unset.UnsetType):
            self.spec = spec
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
            "spec",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    @builtins.property
    def spec(self) -> "SecretSpec":
        return super()._get_field("spec", explicit_presence=False,
        wrap=SecretSpec,
        )
    @spec.setter
    def spec(self, value: "SecretSpec|secret_pb2.SecretSpec|None") -> None:
        return super()._set_field("spec",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
        "spec":"spec",
    }
    
class GetSecretRequest(pb_classes.Message):
    __PB2_CLASS__ = secret_service_pb2.GetSecretRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.mysterybox.v1.GetSecretRequest",secret_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        show_scheduled_for_deletion: "builtins.bool|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(id, unset.UnsetType):
            self.id = id
        if not isinstance(show_scheduled_for_deletion, unset.UnsetType):
            self.show_scheduled_for_deletion = show_scheduled_for_deletion
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "id",
            "show_scheduled_for_deletion",
        ]
    
    @builtins.property
    def id(self) -> "builtins.str":
        """
        ID of secret to return.
        """
        
        return super()._get_field("id", explicit_presence=False,
        )
    @id.setter
    def id(self, value: "builtins.str|None") -> None:
        return super()._set_field("id",value,explicit_presence=False,
        )
    
    @builtins.property
    def show_scheduled_for_deletion(self) -> "builtins.bool":
        """
        By default, Get doesn't return resource if it is scheduled for deletion.
        If show_scheduled_for_deletion = true, the Get operation returns the resource even if it is scheduled for deletion.
        If show_scheduled_for_deletion = false, the Get method returns the NOT_FOUND gRPC status code.
        """
        
        return super()._get_field("show_scheduled_for_deletion", explicit_presence=False,
        )
    @show_scheduled_for_deletion.setter
    def show_scheduled_for_deletion(self, value: "builtins.bool|None") -> None:
        return super()._set_field("show_scheduled_for_deletion",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "id":"id",
        "show_scheduled_for_deletion":"show_scheduled_for_deletion",
    }
    
class GetSecretByNameRequest(pb_classes.Message):
    __PB2_CLASS__ = secret_service_pb2.GetSecretByNameRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.mysterybox.v1.GetSecretByNameRequest",secret_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        parent_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        name: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(parent_id, unset.UnsetType):
            self.parent_id = parent_id
        if not isinstance(name, unset.UnsetType):
            self.name = name
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "parent_id",
            "name",
        ]
    
    @builtins.property
    def parent_id(self) -> "builtins.str":
        """
        ParentId and name of the secret to return.
        """
        
        return super()._get_field("parent_id", explicit_presence=False,
        )
    @parent_id.setter
    def parent_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("parent_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def name(self) -> "builtins.str":
        return super()._get_field("name", explicit_presence=False,
        )
    @name.setter
    def name(self, value: "builtins.str|None") -> None:
        return super()._set_field("name",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "parent_id":"parent_id",
        "name":"name",
    }
    
class ListSecretsRequest(pb_classes.Message):
    __PB2_CLASS__ = secret_service_pb2.ListSecretsRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.mysterybox.v1.ListSecretsRequest",secret_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        parent_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        page_size: "builtins.int|None|unset.UnsetType" = unset.Unset,
        page_token: "builtins.str|None|unset.UnsetType" = unset.Unset,
        show_scheduled_for_deletion: "builtins.bool|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(parent_id, unset.UnsetType):
            self.parent_id = parent_id
        if not isinstance(page_size, unset.UnsetType):
            self.page_size = page_size
        if not isinstance(page_token, unset.UnsetType):
            self.page_token = page_token
        if not isinstance(show_scheduled_for_deletion, unset.UnsetType):
            self.show_scheduled_for_deletion = show_scheduled_for_deletion
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "parent_id",
            "page_size",
            "page_token",
            "show_scheduled_for_deletion",
        ]
    
    @builtins.property
    def parent_id(self) -> "builtins.str":
        """
        ParentId of the secret to return.
        """
        
        return super()._get_field("parent_id", explicit_presence=False,
        )
    @parent_id.setter
    def parent_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("parent_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def page_size(self) -> "builtins.int":
        """
        The maximum number of results per page to return. If the number of available
        results is larger than [page_size], the service returns a [ListSecretsResponse.next_page_token]
        that can be used to get the next page of results in subsequent list requests.
        Default value: 100.
        """
        
        return super()._get_field("page_size", explicit_presence=False,
        )
    @page_size.setter
    def page_size(self, value: "builtins.int|None") -> None:
        return super()._set_field("page_size",value,explicit_presence=False,
        )
    
    @builtins.property
    def page_token(self) -> "builtins.str":
        """
        Page token. To get the next page of results, set [page_token] to the
        [ListSecretsResponse.next_page_token] returned by a previous list request.
        """
        
        return super()._get_field("page_token", explicit_presence=False,
        )
    @page_token.setter
    def page_token(self, value: "builtins.str|None") -> None:
        return super()._set_field("page_token",value,explicit_presence=False,
        )
    
    @builtins.property
    def show_scheduled_for_deletion(self) -> "builtins.bool":
        """
        By default, List operation doesn't include resources that are scheduled for deletion.
        If show_scheduled_for_deletion = true, the listing includes resources that are scheduled for deletion.
        """
        
        return super()._get_field("show_scheduled_for_deletion", explicit_presence=False,
        )
    @show_scheduled_for_deletion.setter
    def show_scheduled_for_deletion(self, value: "builtins.bool|None") -> None:
        return super()._set_field("show_scheduled_for_deletion",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "parent_id":"parent_id",
        "page_size":"page_size",
        "page_token":"page_token",
        "show_scheduled_for_deletion":"show_scheduled_for_deletion",
    }
    
class ListSecretsResponse(pb_classes.Message):
    __PB2_CLASS__ = secret_service_pb2.ListSecretsResponse
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.mysterybox.v1.ListSecretsResponse",secret_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        next_page_token: "builtins.str|None|unset.UnsetType" = unset.Unset,
        items: "abc.Iterable[Secret]|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(next_page_token, unset.UnsetType):
            self.next_page_token = next_page_token
        if not isinstance(items, unset.UnsetType):
            self.items = items
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "next_page_token",
            "items",
        ]
    
    @builtins.property
    def next_page_token(self) -> "builtins.str":
        """
        This token allows you to get the next page of results for list requests. If the number
        of results is greater than the specified [ListSecretsRequest.page_size], use
        the [next_page_token] as the value for the [ListSecretsRequest.page_token] query parameter
        in the next list request. Each subsequent list request will have its own
        [next_page_token] to continue paging through the results.
        """
        
        return super()._get_field("next_page_token", explicit_presence=False,
        )
    @next_page_token.setter
    def next_page_token(self, value: "builtins.str|None") -> None:
        return super()._set_field("next_page_token",value,explicit_presence=False,
        )
    
    @builtins.property
    def items(self) -> "abc.MutableSequence[Secret]":
        """
        List of secrets in the specified container, without its Payload.
        """
        
        return super()._get_field("items", explicit_presence=False,
        wrap=pb_classes.Repeated.with_wrap(Secret,None,None),
        )
    @items.setter
    def items(self, value: "abc.Iterable[Secret]|None") -> None:
        return super()._set_field("items",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "next_page_token":"next_page_token",
        "items":"items",
    }
    
class DeleteSecretRequest(pb_classes.Message):
    __PB2_CLASS__ = secret_service_pb2.DeleteSecretRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.mysterybox.v1.DeleteSecretRequest",secret_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(id, unset.UnsetType):
            self.id = id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "id",
        ]
    
    @builtins.property
    def id(self) -> "builtins.str":
        """
        ID of the secret to soft-delete.
        """
        
        return super()._get_field("id", explicit_presence=False,
        )
    @id.setter
    def id(self, value: "builtins.str|None") -> None:
        return super()._set_field("id",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "id":"id",
    }
    
class UndeleteSecretRequest(pb_classes.Message):
    __PB2_CLASS__ = secret_service_pb2.UndeleteSecretRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.mysterybox.v1.UndeleteSecretRequest",secret_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        name: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(id, unset.UnsetType):
            self.id = id
        if not isinstance(name, unset.UnsetType):
            self.name = name
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "id",
            "name",
        ]
    
    @builtins.property
    def id(self) -> "builtins.str":
        """
        ID of the secret version to soft-delete.
        """
        
        return super()._get_field("id", explicit_presence=False,
        )
    @id.setter
    def id(self, value: "builtins.str|None") -> None:
        return super()._set_field("id",value,explicit_presence=False,
        )
    
    @builtins.property
    def name(self) -> "builtins.str":
        """
        A new Secret name in case the current one is already in use.
        Empty value in name field means "use original name for undeleted Secret".
        Undelete will fail if a Secret with the same name already exists.
        """
        
        return super()._get_field("name", explicit_presence=False,
        )
    @name.setter
    def name(self, value: "builtins.str|None") -> None:
        return super()._set_field("name",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "id":"id",
        "name":"name",
    }
    

class SecretServiceClient(client.ClientWithOperations[v1_1.Operation,v1_1.OperationServiceClient]):
    """
    A set of methods for managing secrets.
    
    This class provides the client methods for the ``.nebius.mysterybox.v1.SecretService`` service.
    
    Each method constructs a :class:`nebius.aio.request.Request` object
    that represents the in-flight RPC. The request can be awaited (async)
    or waited synchronously using its ``.wait()`` helpers.
    
    The request methods accept various parameters to configure metadata,
    timeouts, authorization, and retries. See individual method docstrings
    for details.
    
    :cvar __service_name__: The full protobuf service name.
    """
    
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.ServiceDescriptor](".nebius.mysterybox.v1.SecretService",secret_service_pb2.DESCRIPTOR,descriptor_1.ServiceDescriptor)
    """The protobuf service descriptor extraction function."""
    __service_name__ = ".nebius.mysterybox.v1.SecretService"
    __operation_type__ = v1_1.Operation
    __operation_service_class__ = v1_1.OperationServiceClient
    __operation_source_method__ = "Create"
    """The method name that can be used to fetch the address channel for the operation."""
    
    def create(self,
        request: "CreateSecretRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["CreateSecretRequest","operation.Operation[v1_1.Operation]"]:
        """
        Creates a new secret in the specified container.
        
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.mysterybox.v1.CreateSecretRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.common.v1.Operation`.
        """
        
        return super().request(
            method="Create",
            request=request,
            result_pb2_class=operation_pb2.Operation,
            result_wrapper=operation.Operation,
            **kwargs,
        )
    
    def update(self,
        request: "UpdateSecretRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["UpdateSecretRequest","operation.Operation[v1_1.Operation]"]:
        """
        Updates an existing secret, excluded its Payload.
        
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.mysterybox.v1.UpdateSecretRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.common.v1.Operation`.
        """
        
        kwargs['metadata'] = fieldmask_protobuf.ensure_reset_mask_in_metadata(request, kwargs.get('metadata', None))
        return super().request(
            method="Update",
            request=request,
            result_pb2_class=operation_pb2.Operation,
            result_wrapper=operation.Operation,
            **kwargs,
        )
    
    def get(self,
        request: "GetSecretRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["GetSecretRequest","Secret"]:
        """
        Returns the specified secret, without its Payload.
        
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.mysterybox.v1.GetSecretRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.mysterybox.v1.Secret`.
        """
        
        return super().request(
            method="Get",
            request=request,
            result_pb2_class=secret_pb2.Secret,
            result_wrapper=pb_classes.simple_wrapper(Secret),
            **kwargs,
        )
    
    def get_by_name(self,
        request: "GetSecretByNameRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["GetSecretByNameRequest","Secret"]:
        """
        Returns the specified secret by name, without its Payload.
        
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.mysterybox.v1.GetSecretByNameRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.mysterybox.v1.Secret`.
        """
        
        return super().request(
            method="GetByName",
            request=request,
            result_pb2_class=secret_pb2.Secret,
            result_wrapper=pb_classes.simple_wrapper(Secret),
            **kwargs,
        )
    
    def list(self,
        request: "ListSecretsRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["ListSecretsRequest","ListSecretsResponse"]:
        """
        Returns the list of secrets in a specified container, without its Payload.
        
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.mysterybox.v1.ListSecretsRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.mysterybox.v1.ListSecretsResponse`.
        """
        
        return super().request(
            method="List",
            request=request,
            result_pb2_class=secret_service_pb2.ListSecretsResponse,
            result_wrapper=pb_classes.simple_wrapper(ListSecretsResponse),
            **kwargs,
        )
    
    def delete(self,
        request: "DeleteSecretRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["DeleteSecretRequest","operation.Operation[v1_1.Operation]"]:
        """
        Soft delete secret
        
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.mysterybox.v1.DeleteSecretRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.common.v1.Operation`.
        """
        
        return super().request(
            method="Delete",
            request=request,
            result_pb2_class=operation_pb2.Operation,
            result_wrapper=operation.Operation,
            **kwargs,
        )
    
    def undelete(self,
        request: "UndeleteSecretRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["UndeleteSecretRequest","operation.Operation[v1_1.Operation]"]:
        """
        Undelete secret version
        
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.mysterybox.v1.UndeleteSecretRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.common.v1.Operation`.
        """
        
        return super().request(
            method="Undelete",
            request=request,
            result_pb2_class=operation_pb2.Operation,
            result_wrapper=operation.Operation,
            **kwargs,
        )
    

# file: nebius/mysterybox/v1/secret_version_service.proto
class CreateSecretVersionRequest(pb_classes.Message):
    __PB2_CLASS__ = secret_version_service_pb2.CreateSecretVersionRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.mysterybox.v1.CreateSecretVersionRequest",secret_version_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
        spec: "SecretVersionSpec|secret_version_pb2.SecretVersionSpec|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
        if not isinstance(spec, unset.UnsetType):
            self.spec = spec
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
            "spec",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    @builtins.property
    def spec(self) -> "SecretVersionSpec":
        return super()._get_field("spec", explicit_presence=False,
        wrap=SecretVersionSpec,
        )
    @spec.setter
    def spec(self, value: "SecretVersionSpec|secret_version_pb2.SecretVersionSpec|None") -> None:
        return super()._set_field("spec",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
        "spec":"spec",
    }
    
class GetSecretVersionRequest(pb_classes.Message):
    __PB2_CLASS__ = secret_version_service_pb2.GetSecretVersionRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.mysterybox.v1.GetSecretVersionRequest",secret_version_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        show_scheduled_for_deletion: "builtins.bool|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(id, unset.UnsetType):
            self.id = id
        if not isinstance(show_scheduled_for_deletion, unset.UnsetType):
            self.show_scheduled_for_deletion = show_scheduled_for_deletion
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "id",
            "show_scheduled_for_deletion",
        ]
    
    @builtins.property
    def id(self) -> "builtins.str":
        """
        ID of secret versions to return.
        """
        
        return super()._get_field("id", explicit_presence=False,
        )
    @id.setter
    def id(self, value: "builtins.str|None") -> None:
        return super()._set_field("id",value,explicit_presence=False,
        )
    
    @builtins.property
    def show_scheduled_for_deletion(self) -> "builtins.bool":
        """
        By default, Get doesn't return resource if it is scheduled for deletion.
        If show_scheduled_for_deletion = true, the Get operation returns the resource even if it is scheduled for deletion.
        If show_scheduled_for_deletion = false, the Get method returns the NOT_FOUND gRPC status code.
        """
        
        return super()._get_field("show_scheduled_for_deletion", explicit_presence=False,
        )
    @show_scheduled_for_deletion.setter
    def show_scheduled_for_deletion(self, value: "builtins.bool|None") -> None:
        return super()._set_field("show_scheduled_for_deletion",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "id":"id",
        "show_scheduled_for_deletion":"show_scheduled_for_deletion",
    }
    
class ListSecretVersionsRequest(pb_classes.Message):
    __PB2_CLASS__ = secret_version_service_pb2.ListSecretVersionsRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.mysterybox.v1.ListSecretVersionsRequest",secret_version_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        parent_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        page_size: "builtins.int|None|unset.UnsetType" = unset.Unset,
        page_token: "builtins.str|None|unset.UnsetType" = unset.Unset,
        show_scheduled_for_deletion: "builtins.bool|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(parent_id, unset.UnsetType):
            self.parent_id = parent_id
        if not isinstance(page_size, unset.UnsetType):
            self.page_size = page_size
        if not isinstance(page_token, unset.UnsetType):
            self.page_token = page_token
        if not isinstance(show_scheduled_for_deletion, unset.UnsetType):
            self.show_scheduled_for_deletion = show_scheduled_for_deletion
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "parent_id",
            "page_size",
            "page_token",
            "show_scheduled_for_deletion",
        ]
    
    @builtins.property
    def parent_id(self) -> "builtins.str":
        """
        Secret id related to the version.
        """
        
        return super()._get_field("parent_id", explicit_presence=False,
        )
    @parent_id.setter
    def parent_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("parent_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def page_size(self) -> "builtins.int":
        """
        The maximum number of results per page to return. If the number of available
        results is larger than [page_size], the service returns a [ListSecretVersionsResponse.next_page_token]
        that can be used to get the next page of results in subsequent list requests.
        Default value: 100.
        """
        
        return super()._get_field("page_size", explicit_presence=False,
        )
    @page_size.setter
    def page_size(self, value: "builtins.int|None") -> None:
        return super()._set_field("page_size",value,explicit_presence=False,
        )
    
    @builtins.property
    def page_token(self) -> "builtins.str":
        """
        Page token. To get the next page of results, set [page_token] to the
        [ListSecretVersionsResponse.next_page_token] returned by a previous list request.
        """
        
        return super()._get_field("page_token", explicit_presence=False,
        )
    @page_token.setter
    def page_token(self, value: "builtins.str|None") -> None:
        return super()._set_field("page_token",value,explicit_presence=False,
        )
    
    @builtins.property
    def show_scheduled_for_deletion(self) -> "builtins.bool":
        """
        By default, List operation doesn't include resources that are scheduled for deletion.
        If show_scheduled_for_deletion = true, the listing includes resources that are scheduled for deletion.
        """
        
        return super()._get_field("show_scheduled_for_deletion", explicit_presence=False,
        )
    @show_scheduled_for_deletion.setter
    def show_scheduled_for_deletion(self, value: "builtins.bool|None") -> None:
        return super()._set_field("show_scheduled_for_deletion",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "parent_id":"parent_id",
        "page_size":"page_size",
        "page_token":"page_token",
        "show_scheduled_for_deletion":"show_scheduled_for_deletion",
    }
    
class ListSecretVersionsResponse(pb_classes.Message):
    __PB2_CLASS__ = secret_version_service_pb2.ListSecretVersionsResponse
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.mysterybox.v1.ListSecretVersionsResponse",secret_version_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        next_page_token: "builtins.str|None|unset.UnsetType" = unset.Unset,
        items: "abc.Iterable[SecretVersion]|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(next_page_token, unset.UnsetType):
            self.next_page_token = next_page_token
        if not isinstance(items, unset.UnsetType):
            self.items = items
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "next_page_token",
            "items",
        ]
    
    @builtins.property
    def next_page_token(self) -> "builtins.str":
        """
        This token allows you to get the next page of results for list requests. If the number
        of results is greater than the specified [ListSecretVersionsRequest.page_size], use
        the [next_page_token] as the value for the [ListSecretVersionsRequest.page_token] query parameter
        in the next list request. Each subsequent list request will have its own
        [next_page_token] to continue paging through the results.
        """
        
        return super()._get_field("next_page_token", explicit_presence=False,
        )
    @next_page_token.setter
    def next_page_token(self, value: "builtins.str|None") -> None:
        return super()._set_field("next_page_token",value,explicit_presence=False,
        )
    
    @builtins.property
    def items(self) -> "abc.MutableSequence[SecretVersion]":
        """
        List of secret versions in the specified container, without its Payload.
        """
        
        return super()._get_field("items", explicit_presence=False,
        wrap=pb_classes.Repeated.with_wrap(SecretVersion,None,None),
        )
    @items.setter
    def items(self, value: "abc.Iterable[SecretVersion]|None") -> None:
        return super()._set_field("items",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "next_page_token":"next_page_token",
        "items":"items",
    }
    
class DeleteSecretVersionRequest(pb_classes.Message):
    __PB2_CLASS__ = secret_version_service_pb2.DeleteSecretVersionRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.mysterybox.v1.DeleteSecretVersionRequest",secret_version_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(id, unset.UnsetType):
            self.id = id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "id",
        ]
    
    @builtins.property
    def id(self) -> "builtins.str":
        """
        ID of the secret version to soft-delete.
        """
        
        return super()._get_field("id", explicit_presence=False,
        )
    @id.setter
    def id(self, value: "builtins.str|None") -> None:
        return super()._set_field("id",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "id":"id",
    }
    
class UndeleteSecretVersionRequest(pb_classes.Message):
    __PB2_CLASS__ = secret_version_service_pb2.UndeleteSecretVersionRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.mysterybox.v1.UndeleteSecretVersionRequest",secret_version_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(id, unset.UnsetType):
            self.id = id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "id",
        ]
    
    @builtins.property
    def id(self) -> "builtins.str":
        """
        ID of the secret version to soft-delete.
        """
        
        return super()._get_field("id", explicit_presence=False,
        )
    @id.setter
    def id(self, value: "builtins.str|None") -> None:
        return super()._set_field("id",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "id":"id",
    }
    

class SecretVersionServiceClient(client.ClientWithOperations[v1_1.Operation,v1_1.OperationServiceClient]):
    """
    A set of methods for managing secret's versions.
    
    This class provides the client methods for the ``.nebius.mysterybox.v1.SecretVersionService`` service.
    
    Each method constructs a :class:`nebius.aio.request.Request` object
    that represents the in-flight RPC. The request can be awaited (async)
    or waited synchronously using its ``.wait()`` helpers.
    
    The request methods accept various parameters to configure metadata,
    timeouts, authorization, and retries. See individual method docstrings
    for details.
    
    :cvar __service_name__: The full protobuf service name.
    """
    
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.ServiceDescriptor](".nebius.mysterybox.v1.SecretVersionService",secret_version_service_pb2.DESCRIPTOR,descriptor_1.ServiceDescriptor)
    """The protobuf service descriptor extraction function."""
    __service_name__ = ".nebius.mysterybox.v1.SecretVersionService"
    __operation_type__ = v1_1.Operation
    __operation_service_class__ = v1_1.OperationServiceClient
    __operation_source_method__ = "Create"
    """The method name that can be used to fetch the address channel for the operation."""
    
    def create(self,
        request: "CreateSecretVersionRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["CreateSecretVersionRequest","operation.Operation[v1_1.Operation]"]:
        """
        Creates a new secret version in the specified container.
        
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.mysterybox.v1.CreateSecretVersionRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.common.v1.Operation`.
        """
        
        return super().request(
            method="Create",
            request=request,
            result_pb2_class=operation_pb2.Operation,
            result_wrapper=operation.Operation,
            **kwargs,
        )
    
    def get(self,
        request: "GetSecretVersionRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["GetSecretVersionRequest","SecretVersion"]:
        """
        Returns the specified secret version, without its Payload.
        
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.mysterybox.v1.GetSecretVersionRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.mysterybox.v1.SecretVersion`.
        """
        
        return super().request(
            method="Get",
            request=request,
            result_pb2_class=secret_version_pb2.SecretVersion,
            result_wrapper=pb_classes.simple_wrapper(SecretVersion),
            **kwargs,
        )
    
    def list(self,
        request: "ListSecretVersionsRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["ListSecretVersionsRequest","ListSecretVersionsResponse"]:
        """
        Returns the list of secret versions in a specified container, without its Payload.
        
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.mysterybox.v1.ListSecretVersionsRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.mysterybox.v1.ListSecretVersionsResponse`.
        """
        
        return super().request(
            method="List",
            request=request,
            result_pb2_class=secret_version_service_pb2.ListSecretVersionsResponse,
            result_wrapper=pb_classes.simple_wrapper(ListSecretVersionsResponse),
            **kwargs,
        )
    
    def delete(self,
        request: "DeleteSecretVersionRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["DeleteSecretVersionRequest","operation.Operation[v1_1.Operation]"]:
        """
        Soft delete secret version.
        
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.mysterybox.v1.DeleteSecretVersionRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.common.v1.Operation`.
        """
        
        return super().request(
            method="Delete",
            request=request,
            result_pb2_class=operation_pb2.Operation,
            result_wrapper=operation.Operation,
            **kwargs,
        )
    
    def undelete(self,
        request: "UndeleteSecretVersionRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["UndeleteSecretVersionRequest","operation.Operation[v1_1.Operation]"]:
        """
        Undelete secret version
        
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.mysterybox.v1.UndeleteSecretVersionRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.common.v1.Operation`.
        """
        
        return super().request(
            method="Undelete",
            request=request,
            result_pb2_class=operation_pb2.Operation,
            result_wrapper=operation.Operation,
            **kwargs,
        )
    

__all__ = [
    #@ local import names here @#
    "Payload",
    "GetPayloadRequest",
    "GetPayloadByKeyRequest",
    "SecretPayload",
    "SecretPayloadEntry",
    "PayloadServiceClient",
    "SecretVersion",
    "SecretVersionSpec",
    "SecretVersionStatus",
    "Secret",
    "SecretSpec",
    "SecretStatus",
    "CreateSecretRequest",
    "UpdateSecretRequest",
    "GetSecretRequest",
    "GetSecretByNameRequest",
    "ListSecretsRequest",
    "ListSecretsResponse",
    "DeleteSecretRequest",
    "UndeleteSecretRequest",
    "SecretServiceClient",
    "CreateSecretVersionRequest",
    "GetSecretVersionRequest",
    "ListSecretVersionsRequest",
    "ListSecretVersionsResponse",
    "DeleteSecretVersionRequest",
    "UndeleteSecretVersionRequest",
    "SecretVersionServiceClient",
]
