# 
# Generated by the nebius.base.protos.compiler.  DO NOT EDIT!
# 

"""Auto-generated Nebius SDK package for ``nebius.vpc.v1``"""

import builtins as builtins
import collections.abc as abc
import google.protobuf.descriptor as descriptor_1
import google.protobuf.message as message_1
import nebius.aio.client as client
import nebius.aio.operation as operation
import nebius.aio.request as request_1
import nebius.aio.request_kwargs as request_kwargs
import nebius.api.nebius.common.v1 as v1_1
import nebius.api.nebius.common.v1.metadata_pb2 as metadata_pb2
import nebius.api.nebius.common.v1.operation_pb2 as operation_pb2
import nebius.api.nebius.vpc.v1.allocation_pb2 as allocation_pb2
import nebius.api.nebius.vpc.v1.allocation_service_pb2 as allocation_service_pb2
import nebius.api.nebius.vpc.v1.network_pb2 as network_pb2
import nebius.api.nebius.vpc.v1.network_service_pb2 as network_service_pb2
import nebius.api.nebius.vpc.v1.pool_pb2 as pool_pb2
import nebius.api.nebius.vpc.v1.pool_service_pb2 as pool_service_pb2
import nebius.api.nebius.vpc.v1.route_pb2 as route_pb2
import nebius.api.nebius.vpc.v1.route_service_pb2 as route_service_pb2
import nebius.api.nebius.vpc.v1.route_table_pb2 as route_table_pb2
import nebius.api.nebius.vpc.v1.route_table_service_pb2 as route_table_service_pb2
import nebius.api.nebius.vpc.v1.subnet_pb2 as subnet_pb2
import nebius.api.nebius.vpc.v1.subnet_service_pb2 as subnet_service_pb2
import nebius.api.nebius.vpc.v1.target_group_pb2 as target_group_pb2
import nebius.api.nebius.vpc.v1.target_group_service_pb2 as target_group_service_pb2
import nebius.base.fieldmask_protobuf as fieldmask_protobuf
import nebius.base.protos.descriptor as descriptor
import nebius.base.protos.pb_classes as pb_classes
import nebius.base.protos.pb_enum as pb_enum
import nebius.base.protos.unset as unset
import typing as typing
import typing_extensions as typing_extensions
#@ local imports here @#

# file: nebius/vpc/v1/pool.proto
class AddressBlockState(pb_enum.Enum):
    """
    Controls provisioning of IP addresses from this pool to other pools
    or allocations. Defaults to AVAILABLE.
    """
    
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.EnumDescriptor](".nebius.vpc.v1.AddressBlockState",pool_pb2.DESCRIPTOR,descriptor_1.EnumDescriptor)
    STATE_UNSPECIFIED = 0
    """
    Not used, mandated by the protocol.
    """
    
    AVAILABLE = 1
    """
    Default state. Provision of the IP addresses from this CIDR block is allowed.
    """
    
    DISABLED = 2
    """
    Provision of the IP addresses from this CIDR block is denied.
    """
    

class IpVersion(pb_enum.Enum):
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.EnumDescriptor](".nebius.vpc.v1.IpVersion",pool_pb2.DESCRIPTOR,descriptor_1.EnumDescriptor)
    IP_VERSION_UNSPECIFIED = 0
    """
    Default, unspecified IP version.
    """
    
    IPV4 = 1
    """
    IPv4 address.
    """
    
    IPV6 = 2
    """
    IPv6 address.
    """
    

class IpVisibility(pb_enum.Enum):
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.EnumDescriptor](".nebius.vpc.v1.IpVisibility",pool_pb2.DESCRIPTOR,descriptor_1.EnumDescriptor)
    IP_VISIBILITY_UNSPECIFIED = 0
    """
    Default, unspecified IP visibility.
    """
    
    PRIVATE = 1
    """
    Private address.
    """
    
    PUBLIC = 2
    """
    Public address.
    """
    

class Pool(pb_classes.Message):
    __PB2_CLASS__ = pool_pb2.Pool
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.Pool",pool_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
        spec: "PoolSpec|pool_pb2.PoolSpec|None|unset.UnsetType" = unset.Unset,
        status: "PoolStatus|pool_pb2.PoolStatus|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
        if not isinstance(spec, unset.UnsetType):
            self.spec = spec
        if not isinstance(status, unset.UnsetType):
            self.status = status
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
            "spec",
            "status",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        """
        Metadata associated with the Pool.
        ``metadata.parent_id`` represents the Project.
        """
        
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    @builtins.property
    def spec(self) -> "PoolSpec":
        """
        Specification of the Pool.
        """
        
        return super()._get_field("spec", explicit_presence=False,
        wrap=PoolSpec,
        )
    @spec.setter
    def spec(self, value: "PoolSpec|pool_pb2.PoolSpec|None") -> None:
        return super()._set_field("spec",value,explicit_presence=False,
        )
    
    @builtins.property
    def status(self) -> "PoolStatus":
        """
        Status information for the Pool.
        """
        
        return super()._get_field("status", explicit_presence=False,
        wrap=PoolStatus,
        )
    @status.setter
    def status(self, value: "PoolStatus|pool_pb2.PoolStatus|None") -> None:
        return super()._set_field("status",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
        "spec":"spec",
        "status":"status",
    }
    
class PoolSpec(pb_classes.Message):
    __PB2_CLASS__ = pool_pb2.PoolSpec
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.PoolSpec",pool_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        source_pool_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        version: "IpVersion|pool_pb2.IpVersion|None|unset.UnsetType" = unset.Unset,
        visibility: "IpVisibility|pool_pb2.IpVisibility|None|unset.UnsetType" = unset.Unset,
        cidrs: "abc.Iterable[PoolCidr]|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(source_pool_id, unset.UnsetType):
            self.source_pool_id = source_pool_id
        if not isinstance(version, unset.UnsetType):
            self.version = version
        if not isinstance(visibility, unset.UnsetType):
            self.visibility = visibility
        if not isinstance(cidrs, unset.UnsetType):
            self.cidrs = cidrs
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "source_pool_id",
            "version",
            "visibility",
            "cidrs",
        ]
    
    @builtins.property
    def source_pool_id(self) -> "builtins.str":
        """
        ID of the source pool.
        CIDR blocks of a pool must be within the range defined by its source pool.
        """
        
        return super()._get_field("source_pool_id", explicit_presence=False,
        )
    @source_pool_id.setter
    def source_pool_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("source_pool_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def version(self) -> "IpVersion":
        """
        IP version of the pool.
        """
        
        return super()._get_field("version", explicit_presence=False,
        wrap=IpVersion,
        )
    @version.setter
    def version(self, value: "IpVersion|pool_pb2.IpVersion|None") -> None:
        return super()._set_field("version",value,explicit_presence=False,
        )
    
    @builtins.property
    def visibility(self) -> "IpVisibility":
        """
        Configures whether the pool is private or public.
        Only public pools IP addresses are routable in the Internet.
        """
        
        return super()._get_field("visibility", explicit_presence=False,
        wrap=IpVisibility,
        )
    @visibility.setter
    def visibility(self, value: "IpVisibility|pool_pb2.IpVisibility|None") -> None:
        return super()._set_field("visibility",value,explicit_presence=False,
        )
    
    @builtins.property
    def cidrs(self) -> "abc.MutableSequence[PoolCidr]":
        """
        CIDR blocks defined by the pool.
        """
        
        return super()._get_field("cidrs", explicit_presence=False,
        wrap=pb_classes.Repeated.with_wrap(PoolCidr,None,None),
        )
    @cidrs.setter
    def cidrs(self, value: "abc.Iterable[PoolCidr]|None") -> None:
        return super()._set_field("cidrs",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "source_pool_id":"source_pool_id",
        "version":"version",
        "visibility":"visibility",
        "cidrs":"cidrs",
    }
    
class PoolCidr(pb_classes.Message):
    __PB2_CLASS__ = pool_pb2.PoolCidr
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.PoolCidr",pool_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        cidr: "builtins.str|None|unset.UnsetType" = unset.Unset,
        state: "AddressBlockState|pool_pb2.AddressBlockState|None|unset.UnsetType" = unset.Unset,
        max_mask_length: "builtins.int|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(cidr, unset.UnsetType):
            self.cidr = cidr
        if not isinstance(state, unset.UnsetType):
            self.state = state
        if not isinstance(max_mask_length, unset.UnsetType):
            self.max_mask_length = max_mask_length
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "cidr",
            "state",
            "max_mask_length",
        ]
    
    @builtins.property
    def cidr(self) -> "builtins.str":
        """
        A CIDR block (e.g., "10.1.2.0/24") or a prefix length (e.g., "/24").
        If prefix length is specified, the CIDR block will be auto-allocated from
        the available space in the parent pool.
        """
        
        return super()._get_field("cidr", explicit_presence=False,
        )
    @cidr.setter
    def cidr(self, value: "builtins.str|None") -> None:
        return super()._set_field("cidr",value,explicit_presence=False,
        )
    
    @builtins.property
    def state(self) -> "AddressBlockState":
        """
        Controls provisioning of IP addresses from the CIDR block to other pools
        or allocations. Defaults to AVAILABLE.
        """
        
        return super()._get_field("state", explicit_presence=False,
        wrap=AddressBlockState,
        )
    @state.setter
    def state(self, value: "AddressBlockState|pool_pb2.AddressBlockState|None") -> None:
        return super()._set_field("state",value,explicit_presence=False,
        )
    
    @builtins.property
    def max_mask_length(self) -> "builtins.int":
        """
        Maximum mask length for this pool child pools and allocations.
        Default max_mask_length is 32 for IPv4.
        """
        
        return super()._get_field("max_mask_length", explicit_presence=False,
        )
    @max_mask_length.setter
    def max_mask_length(self, value: "builtins.int|None") -> None:
        return super()._set_field("max_mask_length",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "cidr":"cidr",
        "state":"state",
        "max_mask_length":"max_mask_length",
    }
    
class PoolStatus(pb_classes.Message):
    __PB2_CLASS__ = pool_pb2.PoolStatus
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.PoolStatus",pool_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    class State(pb_enum.Enum):
        """
        Possible states of the Pool.
        """
        
        __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.EnumDescriptor](".nebius.vpc.v1.PoolStatus.State",pool_pb2.DESCRIPTOR,descriptor_1.EnumDescriptor)
        STATE_UNSPECIFIED = 0
        """
        Default, unspecified state.
        """
        
        CREATING = 1
        """
        Pool is being created.
        """
        
        READY = 2
        """
        Pool is ready for use.
        """
        
        DELETING = 3
        """
        Pool is being deleted.
        """
        
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        state: "PoolStatus.State|pool_pb2.PoolStatus.State|None|unset.UnsetType" = unset.Unset,
        cidrs: "abc.Iterable[builtins.str]|None|unset.UnsetType" = unset.Unset,
        scope_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        assignment: "PoolAssignment|pool_pb2.PoolAssignment|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(state, unset.UnsetType):
            self.state = state
        if not isinstance(cidrs, unset.UnsetType):
            self.cidrs = cidrs
        if not isinstance(scope_id, unset.UnsetType):
            self.scope_id = scope_id
        if not isinstance(assignment, unset.UnsetType):
            self.assignment = assignment
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "state",
            "cidrs",
            "scope_id",
            "assignment",
            "State",
        ]
    
    @builtins.property
    def state(self) -> "PoolStatus.State":
        """
        Current state of the Pool.
        """
        
        return super()._get_field("state", explicit_presence=False,
        wrap=PoolStatus.State,
        )
    @state.setter
    def state(self, value: "PoolStatus.State|pool_pb2.PoolStatus.State|None") -> None:
        return super()._set_field("state",value,explicit_presence=False,
        )
    
    @builtins.property
    def cidrs(self) -> "abc.MutableSequence[builtins.str]":
        """
        CIDR blocks.
        """
        
        return super()._get_field("cidrs", explicit_presence=False,
        wrap=pb_classes.Repeated,
        )
    @cidrs.setter
    def cidrs(self, value: "abc.Iterable[builtins.str]|None") -> None:
        return super()._set_field("cidrs",value,explicit_presence=False,
        )
    
    @builtins.property
    def scope_id(self) -> "builtins.str":
        """
        Scope is the unique identifier for single pool tree.
        """
        
        return super()._get_field("scope_id", explicit_presence=False,
        )
    @scope_id.setter
    def scope_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("scope_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def assignment(self) -> "PoolAssignment":
        """
        Assignment details for this Pool
        """
        
        return super()._get_field("assignment", explicit_presence=False,
        wrap=PoolAssignment,
        )
    @assignment.setter
    def assignment(self, value: "PoolAssignment|pool_pb2.PoolAssignment|None") -> None:
        return super()._set_field("assignment",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "state":"state",
        "cidrs":"cidrs",
        "scope_id":"scope_id",
        "assignment":"assignment",
        "State":"State",
    }
    
class PoolAssignment(pb_classes.Message):
    __PB2_CLASS__ = pool_pb2.PoolAssignment
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.PoolAssignment",pool_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        networks: "abc.Iterable[builtins.str]|None|unset.UnsetType" = unset.Unset,
        subnets: "abc.Iterable[builtins.str]|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(networks, unset.UnsetType):
            self.networks = networks
        if not isinstance(subnets, unset.UnsetType):
            self.subnets = subnets
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "networks",
            "subnets",
        ]
    
    @builtins.property
    def networks(self) -> "abc.MutableSequence[builtins.str]":
        """
        IDs of Networks to which the Pool is assigned.
        """
        
        return super()._get_field("networks", explicit_presence=False,
        wrap=pb_classes.Repeated,
        )
    @networks.setter
    def networks(self, value: "abc.Iterable[builtins.str]|None") -> None:
        return super()._set_field("networks",value,explicit_presence=False,
        )
    
    @builtins.property
    def subnets(self) -> "abc.MutableSequence[builtins.str]":
        """
        IDs of Subnets to which the Pool is assigned.
        """
        
        return super()._get_field("subnets", explicit_presence=False,
        wrap=pb_classes.Repeated,
        )
    @subnets.setter
    def subnets(self, value: "abc.Iterable[builtins.str]|None") -> None:
        return super()._set_field("subnets",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "networks":"networks",
        "subnets":"subnets",
    }
    
# file: nebius/vpc/v1/allocation.proto
class Allocation(pb_classes.Message):
    __PB2_CLASS__ = allocation_pb2.Allocation
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.Allocation",allocation_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
        spec: "AllocationSpec|allocation_pb2.AllocationSpec|None|unset.UnsetType" = unset.Unset,
        status: "AllocationStatus|allocation_pb2.AllocationStatus|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
        if not isinstance(spec, unset.UnsetType):
            self.spec = spec
        if not isinstance(status, unset.UnsetType):
            self.status = status
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
            "spec",
            "status",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        """
        Metadata for the Allocation.
        ``metadata.parent_id`` represents IAM Container.
        """
        
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    @builtins.property
    def spec(self) -> "AllocationSpec":
        """
        Specifications for the allocation, detailing its name and IP configuration.
        """
        
        return super()._get_field("spec", explicit_presence=False,
        wrap=AllocationSpec,
        )
    @spec.setter
    def spec(self, value: "AllocationSpec|allocation_pb2.AllocationSpec|None") -> None:
        return super()._set_field("spec",value,explicit_presence=False,
        )
    
    @builtins.property
    def status(self) -> "AllocationStatus":
        """
        Contains the current status of the allocation, indicating its state and
        any additional details.
        """
        
        return super()._get_field("status", explicit_presence=False,
        wrap=AllocationStatus,
        )
    @status.setter
    def status(self, value: "AllocationStatus|allocation_pb2.AllocationStatus|None") -> None:
        return super()._set_field("status",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
        "spec":"spec",
        "status":"status",
    }
    
class AllocationSpec(pb_classes.Message):
    __PB2_CLASS__ = allocation_pb2.AllocationSpec
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.AllocationSpec",allocation_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    class __OneOfClass_ip_spec__(pb_classes.OneOf):
        name: builtins.str= "ip_spec"
        
        def __init__(self, msg: "AllocationSpec") -> None:
            super().__init__()
            self._message: "AllocationSpec" = msg
    
    class __OneOfClass_ip_spec_ipv4_private__(__OneOfClass_ip_spec__):
        field: typing.Literal["ipv4_private"] = "ipv4_private"
        
        def __init__(self, msg: "AllocationSpec") -> None:
            super().__init__(msg)
        @builtins.property
        def value(self) -> "IPv4PrivateAllocationSpec":
            return self._message.ipv4_private
    
    class __OneOfClass_ip_spec_ipv4_public__(__OneOfClass_ip_spec__):
        field: typing.Literal["ipv4_public"] = "ipv4_public"
        
        def __init__(self, msg: "AllocationSpec") -> None:
            super().__init__(msg)
        @builtins.property
        def value(self) -> "IPv4PublicAllocationSpec":
            return self._message.ipv4_public
    
    @builtins.property
    def ip_spec(self) -> __OneOfClass_ip_spec_ipv4_private__|__OneOfClass_ip_spec_ipv4_public__|None:
        """
        IP specifications for the allocation.
        """
        
        field_name_1: str|None = super().which_field_in_oneof("ip_spec")
        match field_name_1:
            case "ipv4_private":
                return self.__OneOfClass_ip_spec_ipv4_private__(self)
            case "ipv4_public":
                return self.__OneOfClass_ip_spec_ipv4_public__(self)
            case None:
                return None
            case _:
                raise pb_classes.OneOfMatchError(field_name_1)
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        ipv4_private: "IPv4PrivateAllocationSpec|allocation_pb2.IPv4PrivateAllocationSpec|None|unset.UnsetType" = unset.Unset,
        ipv4_public: "IPv4PublicAllocationSpec|allocation_pb2.IPv4PublicAllocationSpec|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(ipv4_private, unset.UnsetType):
            self.ipv4_private = ipv4_private
        if not isinstance(ipv4_public, unset.UnsetType):
            self.ipv4_public = ipv4_public
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "ipv4_private",
            "ipv4_public",
            "ip_spec",
        ]
    
    @builtins.property
    def ipv4_private(self) -> "IPv4PrivateAllocationSpec|None":
        return super()._get_field("ipv4_private", explicit_presence=True,
        wrap=IPv4PrivateAllocationSpec,
        )
    @ipv4_private.setter
    def ipv4_private(self, value: "IPv4PrivateAllocationSpec|allocation_pb2.IPv4PrivateAllocationSpec|None") -> None:
        return super()._set_field("ipv4_private",value,explicit_presence=True,
        )
    
    @builtins.property
    def ipv4_public(self) -> "IPv4PublicAllocationSpec|None":
        return super()._get_field("ipv4_public", explicit_presence=True,
        wrap=IPv4PublicAllocationSpec,
        )
    @ipv4_public.setter
    def ipv4_public(self, value: "IPv4PublicAllocationSpec|allocation_pb2.IPv4PublicAllocationSpec|None") -> None:
        return super()._set_field("ipv4_public",value,explicit_presence=True,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "ipv4_private":"ipv4_private",
        "ipv4_public":"ipv4_public",
        "ip_spec":"ip_spec",
    }
    
class IPv4PrivateAllocationSpec(pb_classes.Message):
    """
    Private IPv4 address configuration for the allocation.
    """
    
    __PB2_CLASS__ = allocation_pb2.IPv4PrivateAllocationSpec
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.IPv4PrivateAllocationSpec",allocation_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    class __OneOfClass_pool__(pb_classes.OneOf):
        name: builtins.str= "pool"
        
        def __init__(self, msg: "IPv4PrivateAllocationSpec") -> None:
            super().__init__()
            self._message: "IPv4PrivateAllocationSpec" = msg
    
    class __OneOfClass_pool_subnet_id__(__OneOfClass_pool__):
        field: typing.Literal["subnet_id"] = "subnet_id"
        
        def __init__(self, msg: "IPv4PrivateAllocationSpec") -> None:
            super().__init__(msg)
        @builtins.property
        def value(self) -> "builtins.str":
            return self._message.subnet_id
    
    class __OneOfClass_pool_pool_id__(__OneOfClass_pool__):
        field: typing.Literal["pool_id"] = "pool_id"
        
        def __init__(self, msg: "IPv4PrivateAllocationSpec") -> None:
            super().__init__(msg)
        @builtins.property
        def value(self) -> "builtins.str":
            return self._message.pool_id
    
    @builtins.property
    def pool(self) -> __OneOfClass_pool_subnet_id__|__OneOfClass_pool_pool_id__|None:
        field_name_1: str|None = super().which_field_in_oneof("pool")
        match field_name_1:
            case "subnet_id":
                return self.__OneOfClass_pool_subnet_id__(self)
            case "pool_id":
                return self.__OneOfClass_pool_pool_id__(self)
            case None:
                return None
            case _:
                raise pb_classes.OneOfMatchError(field_name_1)
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        cidr: "builtins.str|None|unset.UnsetType" = unset.Unset,
        subnet_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        pool_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(cidr, unset.UnsetType):
            self.cidr = cidr
        if not isinstance(subnet_id, unset.UnsetType):
            self.subnet_id = subnet_id
        if not isinstance(pool_id, unset.UnsetType):
            self.pool_id = pool_id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "cidr",
            "subnet_id",
            "pool_id",
            "pool",
        ]
    
    @builtins.property
    def cidr(self) -> "builtins.str":
        """
        A single IP address (e.g 10.1.2.1), a CIDR block (e.g., "10.1.2.0/24") or
        a prefix length (e.g., "/32").
        If prefix length is specified, the CIDR block will be auto-allocated from
        the available space in the pool or subnet.
        If not specified, defaults to "/32".
        """
        
        return super()._get_field("cidr", explicit_presence=False,
        )
    @cidr.setter
    def cidr(self, value: "builtins.str|None") -> None:
        return super()._set_field("cidr",value,explicit_presence=False,
        )
    
    @builtins.property
    def subnet_id(self) -> "builtins.str|None":
        """
        ID of the subnet that allocation will be associated with.
        IP address of the allocation must be within a CIDR block associated
        with this subnet.
        In order to assign an allocation to a resource (i.e. network interface)
        both must be associated with the same subnet.
        """
        
        return super()._get_field("subnet_id", explicit_presence=True,
        )
    @subnet_id.setter
    def subnet_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("subnet_id",value,explicit_presence=True,
        )
    
    @builtins.property
    def pool_id(self) -> "builtins.str|None":
        """
        ID of the pool that allocation will receive its IP address from.
        """
        
        return super()._get_field("pool_id", explicit_presence=True,
        )
    @pool_id.setter
    def pool_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("pool_id",value,explicit_presence=True,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "cidr":"cidr",
        "subnet_id":"subnet_id",
        "pool_id":"pool_id",
        "pool":"pool",
    }
    
class IPv4PublicAllocationSpec(pb_classes.Message):
    """
    Public IPv4 address configuration for the allocation.
    """
    
    __PB2_CLASS__ = allocation_pb2.IPv4PublicAllocationSpec
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.IPv4PublicAllocationSpec",allocation_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    class __OneOfClass_pool__(pb_classes.OneOf):
        name: builtins.str= "pool"
        
        def __init__(self, msg: "IPv4PublicAllocationSpec") -> None:
            super().__init__()
            self._message: "IPv4PublicAllocationSpec" = msg
    
    class __OneOfClass_pool_subnet_id__(__OneOfClass_pool__):
        field: typing.Literal["subnet_id"] = "subnet_id"
        
        def __init__(self, msg: "IPv4PublicAllocationSpec") -> None:
            super().__init__(msg)
        @builtins.property
        def value(self) -> "builtins.str":
            return self._message.subnet_id
    
    class __OneOfClass_pool_pool_id__(__OneOfClass_pool__):
        field: typing.Literal["pool_id"] = "pool_id"
        
        def __init__(self, msg: "IPv4PublicAllocationSpec") -> None:
            super().__init__(msg)
        @builtins.property
        def value(self) -> "builtins.str":
            return self._message.pool_id
    
    @builtins.property
    def pool(self) -> __OneOfClass_pool_subnet_id__|__OneOfClass_pool_pool_id__|None:
        field_name_1: str|None = super().which_field_in_oneof("pool")
        match field_name_1:
            case "subnet_id":
                return self.__OneOfClass_pool_subnet_id__(self)
            case "pool_id":
                return self.__OneOfClass_pool_pool_id__(self)
            case None:
                return None
            case _:
                raise pb_classes.OneOfMatchError(field_name_1)
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        cidr: "builtins.str|None|unset.UnsetType" = unset.Unset,
        subnet_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        pool_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(cidr, unset.UnsetType):
            self.cidr = cidr
        if not isinstance(subnet_id, unset.UnsetType):
            self.subnet_id = subnet_id
        if not isinstance(pool_id, unset.UnsetType):
            self.pool_id = pool_id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "cidr",
            "subnet_id",
            "pool_id",
            "pool",
        ]
    
    @builtins.property
    def cidr(self) -> "builtins.str":
        """
        A single IP address (e.g. 1.2.3.4), a CIDR block (e.g., "1.2.3.4/24")
        or a prefix length (e.g., "/32").
        If prefix length is specified, the CIDR block will be auto-allocated from
        the available space in the pool or subnet.
        If not specified, defaults to "/32".
        """
        
        return super()._get_field("cidr", explicit_presence=False,
        )
    @cidr.setter
    def cidr(self, value: "builtins.str|None") -> None:
        return super()._set_field("cidr",value,explicit_presence=False,
        )
    
    @builtins.property
    def subnet_id(self) -> "builtins.str|None":
        """
        ID of the subnet that allocation will be associated with.
        IP address of the allocation must be within a CIDR block associated with
        this subnet.
        Assigning an allocation to a resource (i.e. network interface) requires
        both to be associated with the same subnet.
        """
        
        return super()._get_field("subnet_id", explicit_presence=True,
        )
    @subnet_id.setter
    def subnet_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("subnet_id",value,explicit_presence=True,
        )
    
    @builtins.property
    def pool_id(self) -> "builtins.str|None":
        """
        ID of the pool that allocation will receive its IP address from.
        """
        
        return super()._get_field("pool_id", explicit_presence=True,
        )
    @pool_id.setter
    def pool_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("pool_id",value,explicit_presence=True,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "cidr":"cidr",
        "subnet_id":"subnet_id",
        "pool_id":"pool_id",
        "pool":"pool",
    }
    
class AllocationStatus(pb_classes.Message):
    __PB2_CLASS__ = allocation_pb2.AllocationStatus
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.AllocationStatus",allocation_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    class State(pb_enum.Enum):
        """
        Enumeration of possible states of the Allocation.
        """
        
        __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.EnumDescriptor](".nebius.vpc.v1.AllocationStatus.State",allocation_pb2.DESCRIPTOR,descriptor_1.EnumDescriptor)
        STATE_UNSPECIFIED = 0
        """
        Default state, unspecified.
        """
        
        CREATING = 1
        """
        Allocation is being created.
        """
        
        ALLOCATED = 2
        """
        Allocation is ready for use.
        """
        
        ASSIGNED = 3
        """
        Allocation is used.
        """
        
        DELETING = 4
        """
        Allocation is being deleted.
        """
        
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        state: "AllocationStatus.State|allocation_pb2.AllocationStatus.State|None|unset.UnsetType" = unset.Unset,
        details: "AllocationDetails|allocation_pb2.AllocationDetails|None|unset.UnsetType" = unset.Unset,
        assignment: "Assignment|allocation_pb2.Assignment|None|unset.UnsetType" = unset.Unset,
        static: "builtins.bool|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(state, unset.UnsetType):
            self.state = state
        if not isinstance(details, unset.UnsetType):
            self.details = details
        if not isinstance(assignment, unset.UnsetType):
            self.assignment = assignment
        if not isinstance(static, unset.UnsetType):
            self.static = static
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "state",
            "details",
            "assignment",
            "static",
            "State",
        ]
    
    @builtins.property
    def state(self) -> "AllocationStatus.State":
        """
        This field represents the current state of the allocation.
        """
        
        return super()._get_field("state", explicit_presence=False,
        wrap=AllocationStatus.State,
        )
    @state.setter
    def state(self, value: "AllocationStatus.State|allocation_pb2.AllocationStatus.State|None") -> None:
        return super()._set_field("state",value,explicit_presence=False,
        )
    
    @builtins.property
    def details(self) -> "AllocationDetails":
        """
        Detailed information about the allocation status,
        including the allocated CIDR, pool ID and IP version.
        """
        
        return super()._get_field("details", explicit_presence=False,
        wrap=AllocationDetails,
        )
    @details.setter
    def details(self, value: "AllocationDetails|allocation_pb2.AllocationDetails|None") -> None:
        return super()._set_field("details",value,explicit_presence=False,
        )
    
    @builtins.property
    def assignment(self) -> "Assignment":
        """
        Information about the assignment associated with the allocation,
        such as network interface or load balancer assignment.
        """
        
        return super()._get_field("assignment", explicit_presence=False,
        wrap=Assignment,
        )
    @assignment.setter
    def assignment(self, value: "Assignment|allocation_pb2.Assignment|None") -> None:
        return super()._set_field("assignment",value,explicit_presence=False,
        )
    
    @builtins.property
    def static(self) -> "builtins.bool":
        """
        If false - Lifecycle of allocation depends on resource that using it.
        """
        
        return super()._get_field("static", explicit_presence=False,
        )
    @static.setter
    def static(self, value: "builtins.bool|None") -> None:
        return super()._set_field("static",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "state":"state",
        "details":"details",
        "assignment":"assignment",
        "static":"static",
        "State":"State",
    }
    
class AllocationDetails(pb_classes.Message):
    __PB2_CLASS__ = allocation_pb2.AllocationDetails
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.AllocationDetails",allocation_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        allocated_cidr: "builtins.str|None|unset.UnsetType" = unset.Unset,
        pool_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        version: "IpVersion|pool_pb2.IpVersion|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(allocated_cidr, unset.UnsetType):
            self.allocated_cidr = allocated_cidr
        if not isinstance(pool_id, unset.UnsetType):
            self.pool_id = pool_id
        if not isinstance(version, unset.UnsetType):
            self.version = version
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "allocated_cidr",
            "pool_id",
            "version",
        ]
    
    @builtins.property
    def allocated_cidr(self) -> "builtins.str":
        """
        The actual CIDR block that has been allocated.
        """
        
        return super()._get_field("allocated_cidr", explicit_presence=False,
        )
    @allocated_cidr.setter
    def allocated_cidr(self, value: "builtins.str|None") -> None:
        return super()._set_field("allocated_cidr",value,explicit_presence=False,
        )
    
    @builtins.property
    def pool_id(self) -> "builtins.str":
        """
        ID of the pool from which this allocation was made.
        """
        
        return super()._get_field("pool_id", explicit_presence=False,
        )
    @pool_id.setter
    def pool_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("pool_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def version(self) -> "IpVersion":
        """
        The IP version of this allocation (IPv4 or IPv6).
        """
        
        return super()._get_field("version", explicit_presence=False,
        wrap=IpVersion,
        )
    @version.setter
    def version(self, value: "IpVersion|pool_pb2.IpVersion|None") -> None:
        return super()._set_field("version",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "allocated_cidr":"allocated_cidr",
        "pool_id":"pool_id",
        "version":"version",
    }
    
class Assignment(pb_classes.Message):
    __PB2_CLASS__ = allocation_pb2.Assignment
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.Assignment",allocation_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    class __OneOfClass_type__(pb_classes.OneOf):
        name: builtins.str= "type"
        
        def __init__(self, msg: "Assignment") -> None:
            super().__init__()
            self._message: "Assignment" = msg
    
    class __OneOfClass_type_network_interface__(__OneOfClass_type__):
        field: typing.Literal["network_interface"] = "network_interface"
        
        def __init__(self, msg: "Assignment") -> None:
            super().__init__(msg)
        @builtins.property
        def value(self) -> "NetworkInterfaceAssignment":
            return self._message.network_interface
    
    class __OneOfClass_type_load_balancer__(__OneOfClass_type__):
        field: typing.Literal["load_balancer"] = "load_balancer"
        
        def __init__(self, msg: "Assignment") -> None:
            super().__init__(msg)
        @builtins.property
        def value(self) -> "LoadBalancerAssignment":
            return self._message.load_balancer
    
    @builtins.property
    def type(self) -> __OneOfClass_type_network_interface__|__OneOfClass_type_load_balancer__|None:
        """
        This field specifies the type of assignment associated with the allocation,
        which could be a network interface or load balancer assignment.
        """
        
        field_name_1: str|None = super().which_field_in_oneof("type")
        match field_name_1:
            case "network_interface":
                return self.__OneOfClass_type_network_interface__(self)
            case "load_balancer":
                return self.__OneOfClass_type_load_balancer__(self)
            case None:
                return None
            case _:
                raise pb_classes.OneOfMatchError(field_name_1)
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        network_interface: "NetworkInterfaceAssignment|allocation_pb2.NetworkInterfaceAssignment|None|unset.UnsetType" = unset.Unset,
        load_balancer: "LoadBalancerAssignment|allocation_pb2.LoadBalancerAssignment|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(network_interface, unset.UnsetType):
            self.network_interface = network_interface
        if not isinstance(load_balancer, unset.UnsetType):
            self.load_balancer = load_balancer
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "network_interface",
            "load_balancer",
            "type",
        ]
    
    @builtins.property
    def network_interface(self) -> "NetworkInterfaceAssignment|None":
        return super()._get_field("network_interface", explicit_presence=True,
        wrap=NetworkInterfaceAssignment,
        )
    @network_interface.setter
    def network_interface(self, value: "NetworkInterfaceAssignment|allocation_pb2.NetworkInterfaceAssignment|None") -> None:
        return super()._set_field("network_interface",value,explicit_presence=True,
        )
    
    @builtins.property
    def load_balancer(self) -> "LoadBalancerAssignment|None":
        return super()._get_field("load_balancer", explicit_presence=True,
        wrap=LoadBalancerAssignment,
        )
    @load_balancer.setter
    def load_balancer(self, value: "LoadBalancerAssignment|allocation_pb2.LoadBalancerAssignment|None") -> None:
        return super()._set_field("load_balancer",value,explicit_presence=True,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "network_interface":"network_interface",
        "load_balancer":"load_balancer",
        "type":"type",
    }
    
class NetworkInterfaceAssignment(pb_classes.Message):
    __PB2_CLASS__ = allocation_pb2.NetworkInterfaceAssignment
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.NetworkInterfaceAssignment",allocation_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        instance_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        name: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(instance_id, unset.UnsetType):
            self.instance_id = instance_id
        if not isinstance(name, unset.UnsetType):
            self.name = name
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "instance_id",
            "name",
        ]
    
    @builtins.property
    def instance_id(self) -> "builtins.str":
        """
        ID of the Compute instance network interface belongs to.
        """
        
        return super()._get_field("instance_id", explicit_presence=False,
        )
    @instance_id.setter
    def instance_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("instance_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def name(self) -> "builtins.str":
        """
        Network interface name
        """
        
        return super()._get_field("name", explicit_presence=False,
        )
    @name.setter
    def name(self, value: "builtins.str|None") -> None:
        return super()._set_field("name",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "instance_id":"instance_id",
        "name":"name",
    }
    
class LoadBalancerAssignment(pb_classes.Message):
    __PB2_CLASS__ = allocation_pb2.LoadBalancerAssignment
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.LoadBalancerAssignment",allocation_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(id, unset.UnsetType):
            self.id = id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "id",
        ]
    
    @builtins.property
    def id(self) -> "builtins.str":
        """
        ID of the Load Balancer.
        """
        
        return super()._get_field("id", explicit_presence=False,
        )
    @id.setter
    def id(self, value: "builtins.str|None") -> None:
        return super()._set_field("id",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "id":"id",
    }
    
# file: nebius/vpc/v1/allocation_service.proto
class GetAllocationRequest(pb_classes.Message):
    __PB2_CLASS__ = allocation_service_pb2.GetAllocationRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.GetAllocationRequest",allocation_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(id, unset.UnsetType):
            self.id = id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "id",
        ]
    
    @builtins.property
    def id(self) -> "builtins.str":
        return super()._get_field("id", explicit_presence=False,
        )
    @id.setter
    def id(self, value: "builtins.str|None") -> None:
        return super()._set_field("id",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "id":"id",
    }
    
class GetAllocationByNameRequest(pb_classes.Message):
    __PB2_CLASS__ = allocation_service_pb2.GetAllocationByNameRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.GetAllocationByNameRequest",allocation_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        parent_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        name: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(parent_id, unset.UnsetType):
            self.parent_id = parent_id
        if not isinstance(name, unset.UnsetType):
            self.name = name
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "parent_id",
            "name",
        ]
    
    @builtins.property
    def parent_id(self) -> "builtins.str":
        """
        ID of the project.
        """
        
        return super()._get_field("parent_id", explicit_presence=False,
        )
    @parent_id.setter
    def parent_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("parent_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def name(self) -> "builtins.str":
        return super()._get_field("name", explicit_presence=False,
        )
    @name.setter
    def name(self, value: "builtins.str|None") -> None:
        return super()._set_field("name",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "parent_id":"parent_id",
        "name":"name",
    }
    
class ListAllocationsRequest(pb_classes.Message):
    __PB2_CLASS__ = allocation_service_pb2.ListAllocationsRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.ListAllocationsRequest",allocation_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        parent_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        page_size: "builtins.int|None|unset.UnsetType" = unset.Unset,
        page_token: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(parent_id, unset.UnsetType):
            self.parent_id = parent_id
        if not isinstance(page_size, unset.UnsetType):
            self.page_size = page_size
        if not isinstance(page_token, unset.UnsetType):
            self.page_token = page_token
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "parent_id",
            "page_size",
            "page_token",
        ]
    
    @builtins.property
    def parent_id(self) -> "builtins.str":
        """
        ID of the project.
        """
        
        return super()._get_field("parent_id", explicit_presence=False,
        )
    @parent_id.setter
    def parent_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("parent_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def page_size(self) -> "builtins.int":
        return super()._get_field("page_size", explicit_presence=False,
        )
    @page_size.setter
    def page_size(self, value: "builtins.int|None") -> None:
        return super()._set_field("page_size",value,explicit_presence=False,
        )
    
    @builtins.property
    def page_token(self) -> "builtins.str":
        return super()._get_field("page_token", explicit_presence=False,
        )
    @page_token.setter
    def page_token(self, value: "builtins.str|None") -> None:
        return super()._set_field("page_token",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "parent_id":"parent_id",
        "page_size":"page_size",
        "page_token":"page_token",
    }
    
class ListAllocationsByPoolRequest(pb_classes.Message):
    __PB2_CLASS__ = allocation_service_pb2.ListAllocationsByPoolRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.ListAllocationsByPoolRequest",allocation_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        pool_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        page_size: "builtins.int|None|unset.UnsetType" = unset.Unset,
        page_token: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(pool_id, unset.UnsetType):
            self.pool_id = pool_id
        if not isinstance(page_size, unset.UnsetType):
            self.page_size = page_size
        if not isinstance(page_token, unset.UnsetType):
            self.page_token = page_token
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "pool_id",
            "page_size",
            "page_token",
        ]
    
    @builtins.property
    def pool_id(self) -> "builtins.str":
        return super()._get_field("pool_id", explicit_presence=False,
        )
    @pool_id.setter
    def pool_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("pool_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def page_size(self) -> "builtins.int":
        return super()._get_field("page_size", explicit_presence=False,
        )
    @page_size.setter
    def page_size(self, value: "builtins.int|None") -> None:
        return super()._set_field("page_size",value,explicit_presence=False,
        )
    
    @builtins.property
    def page_token(self) -> "builtins.str":
        return super()._get_field("page_token", explicit_presence=False,
        )
    @page_token.setter
    def page_token(self, value: "builtins.str|None") -> None:
        return super()._set_field("page_token",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "pool_id":"pool_id",
        "page_size":"page_size",
        "page_token":"page_token",
    }
    
class ListAllocationsResponse(pb_classes.Message):
    __PB2_CLASS__ = allocation_service_pb2.ListAllocationsResponse
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.ListAllocationsResponse",allocation_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        items: "abc.Iterable[Allocation]|None|unset.UnsetType" = unset.Unset,
        next_page_token: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(items, unset.UnsetType):
            self.items = items
        if not isinstance(next_page_token, unset.UnsetType):
            self.next_page_token = next_page_token
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "items",
            "next_page_token",
        ]
    
    @builtins.property
    def items(self) -> "abc.MutableSequence[Allocation]":
        return super()._get_field("items", explicit_presence=False,
        wrap=pb_classes.Repeated.with_wrap(Allocation,None,None),
        )
    @items.setter
    def items(self, value: "abc.Iterable[Allocation]|None") -> None:
        return super()._set_field("items",value,explicit_presence=False,
        )
    
    @builtins.property
    def next_page_token(self) -> "builtins.str":
        return super()._get_field("next_page_token", explicit_presence=False,
        )
    @next_page_token.setter
    def next_page_token(self, value: "builtins.str|None") -> None:
        return super()._set_field("next_page_token",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "items":"items",
        "next_page_token":"next_page_token",
    }
    
class CreateAllocationRequest(pb_classes.Message):
    __PB2_CLASS__ = allocation_service_pb2.CreateAllocationRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.CreateAllocationRequest",allocation_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
        spec: "AllocationSpec|allocation_pb2.AllocationSpec|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
        if not isinstance(spec, unset.UnsetType):
            self.spec = spec
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
            "spec",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    @builtins.property
    def spec(self) -> "AllocationSpec":
        return super()._get_field("spec", explicit_presence=False,
        wrap=AllocationSpec,
        )
    @spec.setter
    def spec(self, value: "AllocationSpec|allocation_pb2.AllocationSpec|None") -> None:
        return super()._set_field("spec",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
        "spec":"spec",
    }
    
class UpdateAllocationRequest(pb_classes.Message):
    __PB2_CLASS__ = allocation_service_pb2.UpdateAllocationRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.UpdateAllocationRequest",allocation_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
        spec: "AllocationSpec|allocation_pb2.AllocationSpec|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
        if not isinstance(spec, unset.UnsetType):
            self.spec = spec
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
            "spec",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    @builtins.property
    def spec(self) -> "AllocationSpec":
        return super()._get_field("spec", explicit_presence=False,
        wrap=AllocationSpec,
        )
    @spec.setter
    def spec(self, value: "AllocationSpec|allocation_pb2.AllocationSpec|None") -> None:
        return super()._set_field("spec",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
        "spec":"spec",
    }
    
class DeleteAllocationRequest(pb_classes.Message):
    __PB2_CLASS__ = allocation_service_pb2.DeleteAllocationRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.DeleteAllocationRequest",allocation_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(id, unset.UnsetType):
            self.id = id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "id",
        ]
    
    @builtins.property
    def id(self) -> "builtins.str":
        return super()._get_field("id", explicit_presence=False,
        )
    @id.setter
    def id(self, value: "builtins.str|None") -> None:
        return super()._set_field("id",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "id":"id",
    }
    

class AllocationServiceClient(client.ClientWithOperations[v1_1.Operation,v1_1.OperationServiceClient]):
    """
    This class provides the client methods for the ``.nebius.vpc.v1.AllocationService`` service.
    
    Each method constructs a :class:`nebius.aio.request.Request` object
    that represents the in-flight RPC. The request can be awaited (async)
    or waited synchronously using its ``.wait()`` helpers.
    
    The request methods accept various parameters to configure metadata,
    timeouts, authorization, and retries. See individual method docstrings
    for details.
    
    :cvar __service_name__: The full protobuf service name.
    """
    
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.ServiceDescriptor](".nebius.vpc.v1.AllocationService",allocation_service_pb2.DESCRIPTOR,descriptor_1.ServiceDescriptor)
    """The protobuf service descriptor extraction function."""
    __service_name__ = ".nebius.vpc.v1.AllocationService"
    __operation_type__ = v1_1.Operation
    __operation_service_class__ = v1_1.OperationServiceClient
    __operation_source_method__ = "Create"
    """The method name that can be used to fetch the address channel for the operation."""
    
    def get(self,
        request: "GetAllocationRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["GetAllocationRequest","Allocation"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.GetAllocationRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.vpc.v1.Allocation`.
        """
        
        return super().request(
            method="Get",
            request=request,
            result_pb2_class=allocation_pb2.Allocation,
            result_wrapper=pb_classes.simple_wrapper(Allocation),
            **kwargs,
        )
    
    def get_by_name(self,
        request: "GetAllocationByNameRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["GetAllocationByNameRequest","Allocation"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.GetAllocationByNameRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.vpc.v1.Allocation`.
        """
        
        return super().request(
            method="GetByName",
            request=request,
            result_pb2_class=allocation_pb2.Allocation,
            result_wrapper=pb_classes.simple_wrapper(Allocation),
            **kwargs,
        )
    
    def list(self,
        request: "ListAllocationsRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["ListAllocationsRequest","ListAllocationsResponse"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.ListAllocationsRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.vpc.v1.ListAllocationsResponse`.
        """
        
        return super().request(
            method="List",
            request=request,
            result_pb2_class=allocation_service_pb2.ListAllocationsResponse,
            result_wrapper=pb_classes.simple_wrapper(ListAllocationsResponse),
            **kwargs,
        )
    
    def list_by_pool(self,
        request: "ListAllocationsByPoolRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["ListAllocationsByPoolRequest","ListAllocationsResponse"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.ListAllocationsByPoolRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.vpc.v1.ListAllocationsResponse`.
        """
        
        return super().request(
            method="ListByPool",
            request=request,
            result_pb2_class=allocation_service_pb2.ListAllocationsResponse,
            result_wrapper=pb_classes.simple_wrapper(ListAllocationsResponse),
            **kwargs,
        )
    
    def create(self,
        request: "CreateAllocationRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["CreateAllocationRequest","operation.Operation[v1_1.Operation]"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.CreateAllocationRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.common.v1.Operation`.
        """
        
        return super().request(
            method="Create",
            request=request,
            result_pb2_class=operation_pb2.Operation,
            result_wrapper=operation.Operation,
            **kwargs,
        )
    
    def update(self,
        request: "UpdateAllocationRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["UpdateAllocationRequest","operation.Operation[v1_1.Operation]"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.UpdateAllocationRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.common.v1.Operation`.
        """
        
        kwargs['metadata'] = fieldmask_protobuf.ensure_reset_mask_in_metadata(request, kwargs.get('metadata', None))
        return super().request(
            method="Update",
            request=request,
            result_pb2_class=operation_pb2.Operation,
            result_wrapper=operation.Operation,
            **kwargs,
        )
    
    def delete(self,
        request: "DeleteAllocationRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["DeleteAllocationRequest","operation.Operation[v1_1.Operation]"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.DeleteAllocationRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.common.v1.Operation`.
        """
        
        return super().request(
            method="Delete",
            request=request,
            result_pb2_class=operation_pb2.Operation,
            result_wrapper=operation.Operation,
            **kwargs,
        )
    

# file: nebius/vpc/v1/network.proto
class Network(pb_classes.Message):
    """
    Defines a Network, which serves as a virtual representation of a traditional LAN
    within a cloud environment.
    Networks facilitate communication between subnets.
    """
    
    __PB2_CLASS__ = network_pb2.Network
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.Network",network_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
        spec: "NetworkSpec|network_pb2.NetworkSpec|None|unset.UnsetType" = unset.Unset,
        status: "NetworkStatus|network_pb2.NetworkStatus|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
        if not isinstance(spec, unset.UnsetType):
            self.spec = spec
        if not isinstance(status, unset.UnsetType):
            self.status = status
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
            "spec",
            "status",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        """
        Metadata for the network resource.
        ``metadata.parent_id`` represents IAM container
        """
        
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    @builtins.property
    def spec(self) -> "NetworkSpec":
        """
        Specification of the network.
        """
        
        return super()._get_field("spec", explicit_presence=False,
        wrap=NetworkSpec,
        )
    @spec.setter
    def spec(self, value: "NetworkSpec|network_pb2.NetworkSpec|None") -> None:
        return super()._set_field("spec",value,explicit_presence=False,
        )
    
    @builtins.property
    def status(self) -> "NetworkStatus":
        """
        Status of the network.
        """
        
        return super()._get_field("status", explicit_presence=False,
        wrap=NetworkStatus,
        )
    @status.setter
    def status(self, value: "NetworkStatus|network_pb2.NetworkStatus|None") -> None:
        return super()._set_field("status",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
        "spec":"spec",
        "status":"status",
    }
    
class NetworkSpec(pb_classes.Message):
    __PB2_CLASS__ = network_pb2.NetworkSpec
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.NetworkSpec",network_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        ipv4_private_pools: "IPv4PrivateNetworkPools|network_pb2.IPv4PrivateNetworkPools|None|unset.UnsetType" = unset.Unset,
        ipv4_public_pools: "IPv4PublicNetworkPools|network_pb2.IPv4PublicNetworkPools|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(ipv4_private_pools, unset.UnsetType):
            self.ipv4_private_pools = ipv4_private_pools
        if not isinstance(ipv4_public_pools, unset.UnsetType):
            self.ipv4_public_pools = ipv4_public_pools
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "ipv4_private_pools",
            "ipv4_public_pools",
        ]
    
    @builtins.property
    def ipv4_private_pools(self) -> "IPv4PrivateNetworkPools":
        """
        Pools for private IPv4 addresses.
        Default private pools will be created if not specified.
        Default private pools are referred here
        https://docs.nebius.com/vpc/addressing/available-addresses
        """
        
        return super()._get_field("ipv4_private_pools", explicit_presence=False,
        wrap=IPv4PrivateNetworkPools,
        )
    @ipv4_private_pools.setter
    def ipv4_private_pools(self, value: "IPv4PrivateNetworkPools|network_pb2.IPv4PrivateNetworkPools|None") -> None:
        return super()._set_field("ipv4_private_pools",value,explicit_presence=False,
        )
    
    @builtins.property
    def ipv4_public_pools(self) -> "IPv4PublicNetworkPools":
        """
        Pools for public IPv4 addresses.
        Default public pool will be used if not specified.
        """
        
        return super()._get_field("ipv4_public_pools", explicit_presence=False,
        wrap=IPv4PublicNetworkPools,
        )
    @ipv4_public_pools.setter
    def ipv4_public_pools(self, value: "IPv4PublicNetworkPools|network_pb2.IPv4PublicNetworkPools|None") -> None:
        return super()._set_field("ipv4_public_pools",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "ipv4_private_pools":"ipv4_private_pools",
        "ipv4_public_pools":"ipv4_public_pools",
    }
    
class IPv4PrivateNetworkPools(pb_classes.Message):
    __PB2_CLASS__ = network_pb2.IPv4PrivateNetworkPools
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.IPv4PrivateNetworkPools",network_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        pools: "abc.Iterable[NetworkPool]|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(pools, unset.UnsetType):
            self.pools = pools
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "pools",
        ]
    
    @builtins.property
    def pools(self) -> "abc.MutableSequence[NetworkPool]":
        return super()._get_field("pools", explicit_presence=False,
        wrap=pb_classes.Repeated.with_wrap(NetworkPool,None,None),
        )
    @pools.setter
    def pools(self, value: "abc.Iterable[NetworkPool]|None") -> None:
        return super()._set_field("pools",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "pools":"pools",
    }
    
class IPv4PublicNetworkPools(pb_classes.Message):
    __PB2_CLASS__ = network_pb2.IPv4PublicNetworkPools
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.IPv4PublicNetworkPools",network_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        pools: "abc.Iterable[NetworkPool]|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(pools, unset.UnsetType):
            self.pools = pools
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "pools",
        ]
    
    @builtins.property
    def pools(self) -> "abc.MutableSequence[NetworkPool]":
        return super()._get_field("pools", explicit_presence=False,
        wrap=pb_classes.Repeated.with_wrap(NetworkPool,None,None),
        )
    @pools.setter
    def pools(self, value: "abc.Iterable[NetworkPool]|None") -> None:
        return super()._set_field("pools",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "pools":"pools",
    }
    
class NetworkPool(pb_classes.Message):
    __PB2_CLASS__ = network_pb2.NetworkPool
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.NetworkPool",network_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(id, unset.UnsetType):
            self.id = id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "id",
        ]
    
    @builtins.property
    def id(self) -> "builtins.str":
        """
        ID of the pool.
        """
        
        return super()._get_field("id", explicit_presence=False,
        )
    @id.setter
    def id(self, value: "builtins.str|None") -> None:
        return super()._set_field("id",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "id":"id",
    }
    
class NetworkStatus(pb_classes.Message):
    __PB2_CLASS__ = network_pb2.NetworkStatus
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.NetworkStatus",network_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    class State(pb_enum.Enum):
        """
        Enumeration of possible states of the network.
        """
        
        __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.EnumDescriptor](".nebius.vpc.v1.NetworkStatus.State",network_pb2.DESCRIPTOR,descriptor_1.EnumDescriptor)
        STATE_UNSPECIFIED = 0
        """
        Default state, unspecified.
        """
        
        CREATING = 1
        """
        Network is being created.
        """
        
        READY = 2
        """
        Network is ready for use.
        """
        
        DELETING = 3
        """
        Network is being deleted.
        """
        
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        state: "NetworkStatus.State|network_pb2.NetworkStatus.State|None|unset.UnsetType" = unset.Unset,
        default_route_table_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(state, unset.UnsetType):
            self.state = state
        if not isinstance(default_route_table_id, unset.UnsetType):
            self.default_route_table_id = default_route_table_id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "state",
            "default_route_table_id",
            "State",
        ]
    
    @builtins.property
    def state(self) -> "NetworkStatus.State":
        """
        Current state of the network.
        """
        
        return super()._get_field("state", explicit_presence=False,
        wrap=NetworkStatus.State,
        )
    @state.setter
    def state(self, value: "NetworkStatus.State|network_pb2.NetworkStatus.State|None") -> None:
        return super()._set_field("state",value,explicit_presence=False,
        )
    
    @builtins.property
    def default_route_table_id(self) -> "builtins.str":
        """
        ID of the network's default route table.
        """
        
        return super()._get_field("default_route_table_id", explicit_presence=False,
        )
    @default_route_table_id.setter
    def default_route_table_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("default_route_table_id",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "state":"state",
        "default_route_table_id":"default_route_table_id",
        "State":"State",
    }
    
# file: nebius/vpc/v1/network_service.proto
class GetNetworkRequest(pb_classes.Message):
    __PB2_CLASS__ = network_service_pb2.GetNetworkRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.GetNetworkRequest",network_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(id, unset.UnsetType):
            self.id = id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "id",
        ]
    
    @builtins.property
    def id(self) -> "builtins.str":
        return super()._get_field("id", explicit_presence=False,
        )
    @id.setter
    def id(self, value: "builtins.str|None") -> None:
        return super()._set_field("id",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "id":"id",
    }
    
class GetNetworkByNameRequest(pb_classes.Message):
    __PB2_CLASS__ = network_service_pb2.GetNetworkByNameRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.GetNetworkByNameRequest",network_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        parent_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        name: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(parent_id, unset.UnsetType):
            self.parent_id = parent_id
        if not isinstance(name, unset.UnsetType):
            self.name = name
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "parent_id",
            "name",
        ]
    
    @builtins.property
    def parent_id(self) -> "builtins.str":
        """
        ID of the project.
        """
        
        return super()._get_field("parent_id", explicit_presence=False,
        )
    @parent_id.setter
    def parent_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("parent_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def name(self) -> "builtins.str":
        return super()._get_field("name", explicit_presence=False,
        )
    @name.setter
    def name(self, value: "builtins.str|None") -> None:
        return super()._set_field("name",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "parent_id":"parent_id",
        "name":"name",
    }
    
class ListNetworksRequest(pb_classes.Message):
    __PB2_CLASS__ = network_service_pb2.ListNetworksRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.ListNetworksRequest",network_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        parent_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        page_size: "builtins.int|None|unset.UnsetType" = unset.Unset,
        page_token: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(parent_id, unset.UnsetType):
            self.parent_id = parent_id
        if not isinstance(page_size, unset.UnsetType):
            self.page_size = page_size
        if not isinstance(page_token, unset.UnsetType):
            self.page_token = page_token
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "parent_id",
            "page_size",
            "page_token",
        ]
    
    @builtins.property
    def parent_id(self) -> "builtins.str":
        """
        ID of the project.
        """
        
        return super()._get_field("parent_id", explicit_presence=False,
        )
    @parent_id.setter
    def parent_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("parent_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def page_size(self) -> "builtins.int":
        return super()._get_field("page_size", explicit_presence=False,
        )
    @page_size.setter
    def page_size(self, value: "builtins.int|None") -> None:
        return super()._set_field("page_size",value,explicit_presence=False,
        )
    
    @builtins.property
    def page_token(self) -> "builtins.str":
        return super()._get_field("page_token", explicit_presence=False,
        )
    @page_token.setter
    def page_token(self, value: "builtins.str|None") -> None:
        return super()._set_field("page_token",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "parent_id":"parent_id",
        "page_size":"page_size",
        "page_token":"page_token",
    }
    
class ListNetworksResponse(pb_classes.Message):
    __PB2_CLASS__ = network_service_pb2.ListNetworksResponse
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.ListNetworksResponse",network_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        items: "abc.Iterable[Network]|None|unset.UnsetType" = unset.Unset,
        next_page_token: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(items, unset.UnsetType):
            self.items = items
        if not isinstance(next_page_token, unset.UnsetType):
            self.next_page_token = next_page_token
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "items",
            "next_page_token",
        ]
    
    @builtins.property
    def items(self) -> "abc.MutableSequence[Network]":
        return super()._get_field("items", explicit_presence=False,
        wrap=pb_classes.Repeated.with_wrap(Network,None,None),
        )
    @items.setter
    def items(self, value: "abc.Iterable[Network]|None") -> None:
        return super()._set_field("items",value,explicit_presence=False,
        )
    
    @builtins.property
    def next_page_token(self) -> "builtins.str":
        return super()._get_field("next_page_token", explicit_presence=False,
        )
    @next_page_token.setter
    def next_page_token(self, value: "builtins.str|None") -> None:
        return super()._set_field("next_page_token",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "items":"items",
        "next_page_token":"next_page_token",
    }
    
class CreateNetworkRequest(pb_classes.Message):
    __PB2_CLASS__ = network_service_pb2.CreateNetworkRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.CreateNetworkRequest",network_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
        spec: "NetworkSpec|network_pb2.NetworkSpec|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
        if not isinstance(spec, unset.UnsetType):
            self.spec = spec
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
            "spec",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    @builtins.property
    def spec(self) -> "NetworkSpec":
        return super()._get_field("spec", explicit_presence=False,
        wrap=NetworkSpec,
        )
    @spec.setter
    def spec(self, value: "NetworkSpec|network_pb2.NetworkSpec|None") -> None:
        return super()._set_field("spec",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
        "spec":"spec",
    }
    
class CreateDefaultNetworkRequest(pb_classes.Message):
    __PB2_CLASS__ = network_service_pb2.CreateDefaultNetworkRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.CreateDefaultNetworkRequest",network_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
    }
    
class UpdateNetworkRequest(pb_classes.Message):
    __PB2_CLASS__ = network_service_pb2.UpdateNetworkRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.UpdateNetworkRequest",network_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
        spec: "NetworkSpec|network_pb2.NetworkSpec|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
        if not isinstance(spec, unset.UnsetType):
            self.spec = spec
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
            "spec",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    @builtins.property
    def spec(self) -> "NetworkSpec":
        return super()._get_field("spec", explicit_presence=False,
        wrap=NetworkSpec,
        )
    @spec.setter
    def spec(self, value: "NetworkSpec|network_pb2.NetworkSpec|None") -> None:
        return super()._set_field("spec",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
        "spec":"spec",
    }
    
class DeleteNetworkRequest(pb_classes.Message):
    __PB2_CLASS__ = network_service_pb2.DeleteNetworkRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.DeleteNetworkRequest",network_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(id, unset.UnsetType):
            self.id = id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "id",
        ]
    
    @builtins.property
    def id(self) -> "builtins.str":
        return super()._get_field("id", explicit_presence=False,
        )
    @id.setter
    def id(self, value: "builtins.str|None") -> None:
        return super()._set_field("id",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "id":"id",
    }
    

class NetworkServiceClient(client.ClientWithOperations[v1_1.Operation,v1_1.OperationServiceClient]):
    """
    This class provides the client methods for the ``.nebius.vpc.v1.NetworkService`` service.
    
    Each method constructs a :class:`nebius.aio.request.Request` object
    that represents the in-flight RPC. The request can be awaited (async)
    or waited synchronously using its ``.wait()`` helpers.
    
    The request methods accept various parameters to configure metadata,
    timeouts, authorization, and retries. See individual method docstrings
    for details.
    
    :cvar __service_name__: The full protobuf service name.
    """
    
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.ServiceDescriptor](".nebius.vpc.v1.NetworkService",network_service_pb2.DESCRIPTOR,descriptor_1.ServiceDescriptor)
    """The protobuf service descriptor extraction function."""
    __service_name__ = ".nebius.vpc.v1.NetworkService"
    __operation_type__ = v1_1.Operation
    __operation_service_class__ = v1_1.OperationServiceClient
    __operation_source_method__ = "Create"
    """The method name that can be used to fetch the address channel for the operation."""
    
    def get(self,
        request: "GetNetworkRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["GetNetworkRequest","Network"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.GetNetworkRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.vpc.v1.Network`.
        """
        
        return super().request(
            method="Get",
            request=request,
            result_pb2_class=network_pb2.Network,
            result_wrapper=pb_classes.simple_wrapper(Network),
            **kwargs,
        )
    
    def get_by_name(self,
        request: "GetNetworkByNameRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["GetNetworkByNameRequest","Network"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.GetNetworkByNameRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.vpc.v1.Network`.
        """
        
        return super().request(
            method="GetByName",
            request=request,
            result_pb2_class=network_pb2.Network,
            result_wrapper=pb_classes.simple_wrapper(Network),
            **kwargs,
        )
    
    def list(self,
        request: "ListNetworksRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["ListNetworksRequest","ListNetworksResponse"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.ListNetworksRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.vpc.v1.ListNetworksResponse`.
        """
        
        return super().request(
            method="List",
            request=request,
            result_pb2_class=network_service_pb2.ListNetworksResponse,
            result_wrapper=pb_classes.simple_wrapper(ListNetworksResponse),
            **kwargs,
        )
    
    def create(self,
        request: "CreateNetworkRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["CreateNetworkRequest","operation.Operation[v1_1.Operation]"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.CreateNetworkRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.common.v1.Operation`.
        """
        
        return super().request(
            method="Create",
            request=request,
            result_pb2_class=operation_pb2.Operation,
            result_wrapper=operation.Operation,
            **kwargs,
        )
    
    def create_default(self,
        request: "CreateDefaultNetworkRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["CreateDefaultNetworkRequest","operation.Operation[v1_1.Operation]"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.CreateDefaultNetworkRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.common.v1.Operation`.
        """
        
        return super().request(
            method="CreateDefault",
            request=request,
            result_pb2_class=operation_pb2.Operation,
            result_wrapper=operation.Operation,
            **kwargs,
        )
    
    def update(self,
        request: "UpdateNetworkRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["UpdateNetworkRequest","operation.Operation[v1_1.Operation]"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.UpdateNetworkRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.common.v1.Operation`.
        """
        
        kwargs['metadata'] = fieldmask_protobuf.ensure_reset_mask_in_metadata(request, kwargs.get('metadata', None))
        return super().request(
            method="Update",
            request=request,
            result_pb2_class=operation_pb2.Operation,
            result_wrapper=operation.Operation,
            **kwargs,
        )
    
    def delete(self,
        request: "DeleteNetworkRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["DeleteNetworkRequest","operation.Operation[v1_1.Operation]"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.DeleteNetworkRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.common.v1.Operation`.
        """
        
        return super().request(
            method="Delete",
            request=request,
            result_pb2_class=operation_pb2.Operation,
            result_wrapper=operation.Operation,
            **kwargs,
        )
    

# file: nebius/vpc/v1/pool_service.proto
class GetPoolRequest(pb_classes.Message):
    __PB2_CLASS__ = pool_service_pb2.GetPoolRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.GetPoolRequest",pool_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(id, unset.UnsetType):
            self.id = id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "id",
        ]
    
    @builtins.property
    def id(self) -> "builtins.str":
        return super()._get_field("id", explicit_presence=False,
        )
    @id.setter
    def id(self, value: "builtins.str|None") -> None:
        return super()._set_field("id",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "id":"id",
    }
    
class GetPoolByNameRequest(pb_classes.Message):
    __PB2_CLASS__ = pool_service_pb2.GetPoolByNameRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.GetPoolByNameRequest",pool_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        parent_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        name: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(parent_id, unset.UnsetType):
            self.parent_id = parent_id
        if not isinstance(name, unset.UnsetType):
            self.name = name
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "parent_id",
            "name",
        ]
    
    @builtins.property
    def parent_id(self) -> "builtins.str":
        """
        ID of the project.
        """
        
        return super()._get_field("parent_id", explicit_presence=False,
        )
    @parent_id.setter
    def parent_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("parent_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def name(self) -> "builtins.str":
        return super()._get_field("name", explicit_presence=False,
        )
    @name.setter
    def name(self, value: "builtins.str|None") -> None:
        return super()._set_field("name",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "parent_id":"parent_id",
        "name":"name",
    }
    
class ListPoolsRequest(pb_classes.Message):
    __PB2_CLASS__ = pool_service_pb2.ListPoolsRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.ListPoolsRequest",pool_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        parent_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        page_size: "builtins.int|None|unset.UnsetType" = unset.Unset,
        page_token: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(parent_id, unset.UnsetType):
            self.parent_id = parent_id
        if not isinstance(page_size, unset.UnsetType):
            self.page_size = page_size
        if not isinstance(page_token, unset.UnsetType):
            self.page_token = page_token
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "parent_id",
            "page_size",
            "page_token",
        ]
    
    @builtins.property
    def parent_id(self) -> "builtins.str":
        """
        ID of the project.
        """
        
        return super()._get_field("parent_id", explicit_presence=False,
        )
    @parent_id.setter
    def parent_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("parent_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def page_size(self) -> "builtins.int":
        return super()._get_field("page_size", explicit_presence=False,
        )
    @page_size.setter
    def page_size(self, value: "builtins.int|None") -> None:
        return super()._set_field("page_size",value,explicit_presence=False,
        )
    
    @builtins.property
    def page_token(self) -> "builtins.str":
        return super()._get_field("page_token", explicit_presence=False,
        )
    @page_token.setter
    def page_token(self, value: "builtins.str|None") -> None:
        return super()._set_field("page_token",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "parent_id":"parent_id",
        "page_size":"page_size",
        "page_token":"page_token",
    }
    
class ListPoolsBySourcePoolRequest(pb_classes.Message):
    __PB2_CLASS__ = pool_service_pb2.ListPoolsBySourcePoolRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.ListPoolsBySourcePoolRequest",pool_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        pool_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        page_size: "builtins.int|None|unset.UnsetType" = unset.Unset,
        page_token: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(pool_id, unset.UnsetType):
            self.pool_id = pool_id
        if not isinstance(page_size, unset.UnsetType):
            self.page_size = page_size
        if not isinstance(page_token, unset.UnsetType):
            self.page_token = page_token
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "pool_id",
            "page_size",
            "page_token",
        ]
    
    @builtins.property
    def pool_id(self) -> "builtins.str":
        return super()._get_field("pool_id", explicit_presence=False,
        )
    @pool_id.setter
    def pool_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("pool_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def page_size(self) -> "builtins.int":
        return super()._get_field("page_size", explicit_presence=False,
        )
    @page_size.setter
    def page_size(self, value: "builtins.int|None") -> None:
        return super()._set_field("page_size",value,explicit_presence=False,
        )
    
    @builtins.property
    def page_token(self) -> "builtins.str":
        return super()._get_field("page_token", explicit_presence=False,
        )
    @page_token.setter
    def page_token(self, value: "builtins.str|None") -> None:
        return super()._set_field("page_token",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "pool_id":"pool_id",
        "page_size":"page_size",
        "page_token":"page_token",
    }
    
class ListPoolsResponse(pb_classes.Message):
    __PB2_CLASS__ = pool_service_pb2.ListPoolsResponse
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.ListPoolsResponse",pool_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        items: "abc.Iterable[Pool]|None|unset.UnsetType" = unset.Unset,
        next_page_token: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(items, unset.UnsetType):
            self.items = items
        if not isinstance(next_page_token, unset.UnsetType):
            self.next_page_token = next_page_token
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "items",
            "next_page_token",
        ]
    
    @builtins.property
    def items(self) -> "abc.MutableSequence[Pool]":
        return super()._get_field("items", explicit_presence=False,
        wrap=pb_classes.Repeated.with_wrap(Pool,None,None),
        )
    @items.setter
    def items(self, value: "abc.Iterable[Pool]|None") -> None:
        return super()._set_field("items",value,explicit_presence=False,
        )
    
    @builtins.property
    def next_page_token(self) -> "builtins.str":
        return super()._get_field("next_page_token", explicit_presence=False,
        )
    @next_page_token.setter
    def next_page_token(self, value: "builtins.str|None") -> None:
        return super()._set_field("next_page_token",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "items":"items",
        "next_page_token":"next_page_token",
    }
    
class CreatePoolRequest(pb_classes.Message):
    __PB2_CLASS__ = pool_service_pb2.CreatePoolRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.CreatePoolRequest",pool_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
        spec: "PoolSpec|pool_pb2.PoolSpec|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
        if not isinstance(spec, unset.UnsetType):
            self.spec = spec
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
            "spec",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    @builtins.property
    def spec(self) -> "PoolSpec":
        return super()._get_field("spec", explicit_presence=False,
        wrap=PoolSpec,
        )
    @spec.setter
    def spec(self, value: "PoolSpec|pool_pb2.PoolSpec|None") -> None:
        return super()._set_field("spec",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
        "spec":"spec",
    }
    
class UpdatePoolRequest(pb_classes.Message):
    __PB2_CLASS__ = pool_service_pb2.UpdatePoolRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.UpdatePoolRequest",pool_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
        spec: "PoolSpec|pool_pb2.PoolSpec|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
        if not isinstance(spec, unset.UnsetType):
            self.spec = spec
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
            "spec",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    @builtins.property
    def spec(self) -> "PoolSpec":
        return super()._get_field("spec", explicit_presence=False,
        wrap=PoolSpec,
        )
    @spec.setter
    def spec(self, value: "PoolSpec|pool_pb2.PoolSpec|None") -> None:
        return super()._set_field("spec",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
        "spec":"spec",
    }
    
class DeletePoolRequest(pb_classes.Message):
    __PB2_CLASS__ = pool_service_pb2.DeletePoolRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.DeletePoolRequest",pool_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(id, unset.UnsetType):
            self.id = id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "id",
        ]
    
    @builtins.property
    def id(self) -> "builtins.str":
        return super()._get_field("id", explicit_presence=False,
        )
    @id.setter
    def id(self, value: "builtins.str|None") -> None:
        return super()._set_field("id",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "id":"id",
    }
    

class PoolServiceClient(client.ClientWithOperations[v1_1.Operation,v1_1.OperationServiceClient]):
    """
    This class provides the client methods for the ``.nebius.vpc.v1.PoolService`` service.
    
    Each method constructs a :class:`nebius.aio.request.Request` object
    that represents the in-flight RPC. The request can be awaited (async)
    or waited synchronously using its ``.wait()`` helpers.
    
    The request methods accept various parameters to configure metadata,
    timeouts, authorization, and retries. See individual method docstrings
    for details.
    
    :cvar __service_name__: The full protobuf service name.
    """
    
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.ServiceDescriptor](".nebius.vpc.v1.PoolService",pool_service_pb2.DESCRIPTOR,descriptor_1.ServiceDescriptor)
    """The protobuf service descriptor extraction function."""
    __service_name__ = ".nebius.vpc.v1.PoolService"
    __operation_type__ = v1_1.Operation
    __operation_service_class__ = v1_1.OperationServiceClient
    __operation_source_method__ = "Create"
    """The method name that can be used to fetch the address channel for the operation."""
    
    def get(self,
        request: "GetPoolRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["GetPoolRequest","Pool"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.GetPoolRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.vpc.v1.Pool`.
        """
        
        return super().request(
            method="Get",
            request=request,
            result_pb2_class=pool_pb2.Pool,
            result_wrapper=pb_classes.simple_wrapper(Pool),
            **kwargs,
        )
    
    def get_by_name(self,
        request: "GetPoolByNameRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["GetPoolByNameRequest","Pool"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.GetPoolByNameRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.vpc.v1.Pool`.
        """
        
        return super().request(
            method="GetByName",
            request=request,
            result_pb2_class=pool_pb2.Pool,
            result_wrapper=pb_classes.simple_wrapper(Pool),
            **kwargs,
        )
    
    def list(self,
        request: "ListPoolsRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["ListPoolsRequest","ListPoolsResponse"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.ListPoolsRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.vpc.v1.ListPoolsResponse`.
        """
        
        return super().request(
            method="List",
            request=request,
            result_pb2_class=pool_service_pb2.ListPoolsResponse,
            result_wrapper=pb_classes.simple_wrapper(ListPoolsResponse),
            **kwargs,
        )
    
    def list_by_source_pool(self,
        request: "ListPoolsBySourcePoolRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["ListPoolsBySourcePoolRequest","ListPoolsResponse"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.ListPoolsBySourcePoolRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.vpc.v1.ListPoolsResponse`.
        """
        
        return super().request(
            method="ListBySourcePool",
            request=request,
            result_pb2_class=pool_service_pb2.ListPoolsResponse,
            result_wrapper=pb_classes.simple_wrapper(ListPoolsResponse),
            **kwargs,
        )
    
    def create(self,
        request: "CreatePoolRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["CreatePoolRequest","operation.Operation[v1_1.Operation]"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.CreatePoolRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.common.v1.Operation`.
        """
        
        return super().request(
            method="Create",
            request=request,
            result_pb2_class=operation_pb2.Operation,
            result_wrapper=operation.Operation,
            **kwargs,
        )
    
    def update(self,
        request: "UpdatePoolRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["UpdatePoolRequest","operation.Operation[v1_1.Operation]"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.UpdatePoolRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.common.v1.Operation`.
        """
        
        kwargs['metadata'] = fieldmask_protobuf.ensure_reset_mask_in_metadata(request, kwargs.get('metadata', None))
        return super().request(
            method="Update",
            request=request,
            result_pb2_class=operation_pb2.Operation,
            result_wrapper=operation.Operation,
            **kwargs,
        )
    
    def delete(self,
        request: "DeletePoolRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["DeletePoolRequest","operation.Operation[v1_1.Operation]"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.DeletePoolRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.common.v1.Operation`.
        """
        
        return super().request(
            method="Delete",
            request=request,
            result_pb2_class=operation_pb2.Operation,
            result_wrapper=operation.Operation,
            **kwargs,
        )
    

# file: nebius/vpc/v1/route.proto
class Route(pb_classes.Message):
    """
    Routes determine how network traffic is directed within a VPC network,
    specifying the path that traffic should take based on destination addresses.
    """
    
    __PB2_CLASS__ = route_pb2.Route
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.Route",route_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
        spec: "RouteSpec|route_pb2.RouteSpec|None|unset.UnsetType" = unset.Unset,
        status: "RouteStatus|route_pb2.RouteStatus|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
        if not isinstance(spec, unset.UnsetType):
            self.spec = spec
        if not isinstance(status, unset.UnsetType):
            self.status = status
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
            "spec",
            "status",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        """
        ``metadata.parent_id`` represents the RouteTable.
        """
        
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    @builtins.property
    def spec(self) -> "RouteSpec":
        """
        Specification of the route's configuration.
        """
        
        return super()._get_field("spec", explicit_presence=False,
        wrap=RouteSpec,
        )
    @spec.setter
    def spec(self, value: "RouteSpec|route_pb2.RouteSpec|None") -> None:
        return super()._set_field("spec",value,explicit_presence=False,
        )
    
    @builtins.property
    def status(self) -> "RouteStatus":
        """
        Current status of the route.
        """
        
        return super()._get_field("status", explicit_presence=False,
        wrap=RouteStatus,
        )
    @status.setter
    def status(self, value: "RouteStatus|route_pb2.RouteStatus|None") -> None:
        return super()._set_field("status",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
        "spec":"spec",
        "status":"status",
    }
    
class RouteSpec(pb_classes.Message):
    __PB2_CLASS__ = route_pb2.RouteSpec
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.RouteSpec",route_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        description: "builtins.str|None|unset.UnsetType" = unset.Unset,
        destination: "DestinationMatch|route_pb2.DestinationMatch|None|unset.UnsetType" = unset.Unset,
        next_hop: "NextHop|route_pb2.NextHop|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(description, unset.UnsetType):
            self.description = description
        if not isinstance(destination, unset.UnsetType):
            self.destination = destination
        if not isinstance(next_hop, unset.UnsetType):
            self.next_hop = next_hop
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "description",
            "destination",
            "next_hop",
        ]
    
    @builtins.property
    def description(self) -> "builtins.str":
        """
        Optional description of the route.
        """
        
        return super()._get_field("description", explicit_presence=False,
        )
    @description.setter
    def description(self, value: "builtins.str|None") -> None:
        return super()._set_field("description",value,explicit_presence=False,
        )
    
    @builtins.property
    def destination(self) -> "DestinationMatch":
        """
        Destination for the route.
        Each destination CIDR must be unique within a route table.
        When multiple routes match a destination IP, the route with the longest
        matching prefix (most specific match) is selected.
        """
        
        return super()._get_field("destination", explicit_presence=False,
        wrap=DestinationMatch,
        )
    @destination.setter
    def destination(self, value: "DestinationMatch|route_pb2.DestinationMatch|None") -> None:
        return super()._set_field("destination",value,explicit_presence=False,
        )
    
    @builtins.property
    def next_hop(self) -> "NextHop":
        """
        Next hop configuration specifying where to send matching traffic.
        """
        
        return super()._get_field("next_hop", explicit_presence=False,
        wrap=NextHop,
        )
    @next_hop.setter
    def next_hop(self, value: "NextHop|route_pb2.NextHop|None") -> None:
        return super()._set_field("next_hop",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "description":"description",
        "destination":"destination",
        "next_hop":"next_hop",
    }
    
class DestinationMatch(pb_classes.Message):
    __PB2_CLASS__ = route_pb2.DestinationMatch
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.DestinationMatch",route_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        cidr: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(cidr, unset.UnsetType):
            self.cidr = cidr
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "cidr",
        ]
    
    @builtins.property
    def cidr(self) -> "builtins.str":
        """
        Destination CIDR block in IPv4 format (e.g., "0.0.0.0/0" for default route, "192.168.100.0/24" for specific subnet).
        The CIDR notation specifies the range of IP addresses that this route will match.
        Must be unique within a route table.
        """
        
        return super()._get_field("cidr", explicit_presence=False,
        )
    @cidr.setter
    def cidr(self, value: "builtins.str|None") -> None:
        return super()._set_field("cidr",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "cidr":"cidr",
    }
    
class NextHop(pb_classes.Message):
    __PB2_CLASS__ = route_pb2.NextHop
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.NextHop",route_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    class __OneOfClass_next_hop__(pb_classes.OneOf):
        name: builtins.str= "next_hop"
        
        def __init__(self, msg: "NextHop") -> None:
            super().__init__()
            self._message: "NextHop" = msg
    
    class __OneOfClass_next_hop_allocation__(__OneOfClass_next_hop__):
        field: typing.Literal["allocation"] = "allocation"
        
        def __init__(self, msg: "NextHop") -> None:
            super().__init__(msg)
        @builtins.property
        def value(self) -> "AllocationNextHop":
            return self._message.allocation
    
    class __OneOfClass_next_hop_default_egress_gateway__(__OneOfClass_next_hop__):
        field: typing.Literal["default_egress_gateway"] = "default_egress_gateway"
        
        def __init__(self, msg: "NextHop") -> None:
            super().__init__(msg)
        @builtins.property
        def value(self) -> "builtins.bool":
            return self._message.default_egress_gateway
    
    @builtins.property
    def next_hop(self) -> __OneOfClass_next_hop_allocation__|__OneOfClass_next_hop_default_egress_gateway__|None:
        """
        Configuration for the next hop, which must be one of the following options.
        """
        
        field_name_1: str|None = super().which_field_in_oneof("next_hop")
        match field_name_1:
            case "allocation":
                return self.__OneOfClass_next_hop_allocation__(self)
            case "default_egress_gateway":
                return self.__OneOfClass_next_hop_default_egress_gateway__(self)
            case None:
                return None
            case _:
                raise pb_classes.OneOfMatchError(field_name_1)
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        allocation: "AllocationNextHop|route_pb2.AllocationNextHop|None|unset.UnsetType" = unset.Unset,
        default_egress_gateway: "builtins.bool|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(allocation, unset.UnsetType):
            self.allocation = allocation
        if not isinstance(default_egress_gateway, unset.UnsetType):
            self.default_egress_gateway = default_egress_gateway
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "allocation",
            "default_egress_gateway",
            "next_hop",
        ]
    
    @builtins.property
    def allocation(self) -> "AllocationNextHop|None":
        """
        Forward traffic to a specific IP allocation (/32 address only).
        The allocation must be from the same network as the route table.
        The allocation must be assigned to either a Compute instance or a Load Balancer.
        Warning: If the allocation exists but is not assigned to any resource,
        traffic will be forwarded to a "black hole" and dropped.
        """
        
        return super()._get_field("allocation", explicit_presence=True,
        wrap=AllocationNextHop,
        )
    @allocation.setter
    def allocation(self, value: "AllocationNextHop|route_pb2.AllocationNextHop|None") -> None:
        return super()._set_field("allocation",value,explicit_presence=True,
        )
    
    @builtins.property
    def default_egress_gateway(self) -> "builtins.bool|None":
        """
        Use the default egress gateway for outbound traffic.
        Note: For VMs with public addresses (Floating IPs/FIPs), the FIP-specific route
        takes precedence over this default egress gateway route.
        """
        
        return super()._get_field("default_egress_gateway", explicit_presence=True,
        )
    @default_egress_gateway.setter
    def default_egress_gateway(self, value: "builtins.bool|None") -> None:
        return super()._set_field("default_egress_gateway",value,explicit_presence=True,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "allocation":"allocation",
        "default_egress_gateway":"default_egress_gateway",
        "next_hop":"next_hop",
    }
    
class AllocationNextHop(pb_classes.Message):
    """
    AllocationNextHop specifies an IP allocation as the next hop.
    """
    
    __PB2_CLASS__ = route_pb2.AllocationNextHop
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.AllocationNextHop",route_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(id, unset.UnsetType):
            self.id = id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "id",
        ]
    
    @builtins.property
    def id(self) -> "builtins.str":
        """
        ID of the IP allocation to use as the next hop.
        """
        
        return super()._get_field("id", explicit_presence=False,
        )
    @id.setter
    def id(self, value: "builtins.str|None") -> None:
        return super()._set_field("id",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "id":"id",
    }
    
class RouteStatus(pb_classes.Message):
    __PB2_CLASS__ = route_pb2.RouteStatus
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.RouteStatus",route_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    class State(pb_enum.Enum):
        __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.EnumDescriptor](".nebius.vpc.v1.RouteStatus.State",route_pb2.DESCRIPTOR,descriptor_1.EnumDescriptor)
        STATE_UNSPECIFIED = 0
        """
        The state is unknown or not yet set.
        """
        
        READY = 10
        """
        The route is configured and operational.
        """
        
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        state: "RouteStatus.State|route_pb2.RouteStatus.State|None|unset.UnsetType" = unset.Unset,
        next_hop: "NextHopState|route_pb2.NextHopState|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(state, unset.UnsetType):
            self.state = state
        if not isinstance(next_hop, unset.UnsetType):
            self.next_hop = next_hop
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "state",
            "next_hop",
            "State",
        ]
    
    @builtins.property
    def state(self) -> "RouteStatus.State":
        """
        Current state of the route.
        """
        
        return super()._get_field("state", explicit_presence=False,
        wrap=RouteStatus.State,
        )
    @state.setter
    def state(self, value: "RouteStatus.State|route_pb2.RouteStatus.State|None") -> None:
        return super()._set_field("state",value,explicit_presence=False,
        )
    
    @builtins.property
    def next_hop(self) -> "NextHopState":
        """
        Detailed status of the next hop configuration.
        """
        
        return super()._get_field("next_hop", explicit_presence=False,
        wrap=NextHopState,
        )
    @next_hop.setter
    def next_hop(self, value: "NextHopState|route_pb2.NextHopState|None") -> None:
        return super()._set_field("next_hop",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "state":"state",
        "next_hop":"next_hop",
        "State":"State",
    }
    
class NextHopState(pb_classes.Message):
    __PB2_CLASS__ = route_pb2.NextHopState
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.NextHopState",route_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    class __OneOfClass_next_hop__(pb_classes.OneOf):
        name: builtins.str= "next_hop"
        
        def __init__(self, msg: "NextHopState") -> None:
            super().__init__()
            self._message: "NextHopState" = msg
    
    class __OneOfClass_next_hop_allocation__(__OneOfClass_next_hop__):
        field: typing.Literal["allocation"] = "allocation"
        
        def __init__(self, msg: "NextHopState") -> None:
            super().__init__(msg)
        @builtins.property
        def value(self) -> "AllocationNextHopState":
            return self._message.allocation
    
    class __OneOfClass_next_hop_default_egress_gateway__(__OneOfClass_next_hop__):
        field: typing.Literal["default_egress_gateway"] = "default_egress_gateway"
        
        def __init__(self, msg: "NextHopState") -> None:
            super().__init__(msg)
        @builtins.property
        def value(self) -> "DefaultEgressGatewayState":
            return self._message.default_egress_gateway
    
    @builtins.property
    def next_hop(self) -> __OneOfClass_next_hop_allocation__|__OneOfClass_next_hop_default_egress_gateway__|None:
        """
        Current state of the next hop configuration.
        """
        
        field_name_1: str|None = super().which_field_in_oneof("next_hop")
        match field_name_1:
            case "allocation":
                return self.__OneOfClass_next_hop_allocation__(self)
            case "default_egress_gateway":
                return self.__OneOfClass_next_hop_default_egress_gateway__(self)
            case None:
                return None
            case _:
                raise pb_classes.OneOfMatchError(field_name_1)
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        allocation: "AllocationNextHopState|route_pb2.AllocationNextHopState|None|unset.UnsetType" = unset.Unset,
        default_egress_gateway: "DefaultEgressGatewayState|route_pb2.DefaultEgressGatewayState|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(allocation, unset.UnsetType):
            self.allocation = allocation
        if not isinstance(default_egress_gateway, unset.UnsetType):
            self.default_egress_gateway = default_egress_gateway
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "allocation",
            "default_egress_gateway",
            "next_hop",
        ]
    
    @builtins.property
    def allocation(self) -> "AllocationNextHopState|None":
        """
        Status of an allocation-based next hop.
        """
        
        return super()._get_field("allocation", explicit_presence=True,
        wrap=AllocationNextHopState,
        )
    @allocation.setter
    def allocation(self, value: "AllocationNextHopState|route_pb2.AllocationNextHopState|None") -> None:
        return super()._set_field("allocation",value,explicit_presence=True,
        )
    
    @builtins.property
    def default_egress_gateway(self) -> "DefaultEgressGatewayState|None":
        """
        Status of the default egress gateway configuration.
        """
        
        return super()._get_field("default_egress_gateway", explicit_presence=True,
        wrap=DefaultEgressGatewayState,
        )
    @default_egress_gateway.setter
    def default_egress_gateway(self, value: "DefaultEgressGatewayState|route_pb2.DefaultEgressGatewayState|None") -> None:
        return super()._set_field("default_egress_gateway",value,explicit_presence=True,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "allocation":"allocation",
        "default_egress_gateway":"default_egress_gateway",
        "next_hop":"next_hop",
    }
    
class AllocationNextHopState(pb_classes.Message):
    __PB2_CLASS__ = route_pb2.AllocationNextHopState
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.AllocationNextHopState",route_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        cidr: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(cidr, unset.UnsetType):
            self.cidr = cidr
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "cidr",
        ]
    
    @builtins.property
    def cidr(self) -> "builtins.str":
        """
        The CIDR of the allocation being used as the next hop.
        """
        
        return super()._get_field("cidr", explicit_presence=False,
        )
    @cidr.setter
    def cidr(self, value: "builtins.str|None") -> None:
        return super()._set_field("cidr",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "cidr":"cidr",
    }
    
class DefaultEgressGatewayState(pb_classes.Message):
    __PB2_CLASS__ = route_pb2.DefaultEgressGatewayState
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.DefaultEgressGatewayState",route_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
    ) -> None:
        super().__init__(initial_message)
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
        ]
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
    }
    
# file: nebius/vpc/v1/route_service.proto
class GetRouteRequest(pb_classes.Message):
    __PB2_CLASS__ = route_service_pb2.GetRouteRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.GetRouteRequest",route_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(id, unset.UnsetType):
            self.id = id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "id",
        ]
    
    @builtins.property
    def id(self) -> "builtins.str":
        return super()._get_field("id", explicit_presence=False,
        )
    @id.setter
    def id(self, value: "builtins.str|None") -> None:
        return super()._set_field("id",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "id":"id",
    }
    
class GetRouteByNameRequest(pb_classes.Message):
    __PB2_CLASS__ = route_service_pb2.GetRouteByNameRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.GetRouteByNameRequest",route_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        parent_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        name: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(parent_id, unset.UnsetType):
            self.parent_id = parent_id
        if not isinstance(name, unset.UnsetType):
            self.name = name
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "parent_id",
            "name",
        ]
    
    @builtins.property
    def parent_id(self) -> "builtins.str":
        """
        ID of the RouteTable.
        """
        
        return super()._get_field("parent_id", explicit_presence=False,
        )
    @parent_id.setter
    def parent_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("parent_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def name(self) -> "builtins.str":
        return super()._get_field("name", explicit_presence=False,
        )
    @name.setter
    def name(self, value: "builtins.str|None") -> None:
        return super()._set_field("name",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "parent_id":"parent_id",
        "name":"name",
    }
    
class ListRoutesRequest(pb_classes.Message):
    __PB2_CLASS__ = route_service_pb2.ListRoutesRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.ListRoutesRequest",route_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        parent_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        page_size: "builtins.int|None|unset.UnsetType" = unset.Unset,
        page_token: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(parent_id, unset.UnsetType):
            self.parent_id = parent_id
        if not isinstance(page_size, unset.UnsetType):
            self.page_size = page_size
        if not isinstance(page_token, unset.UnsetType):
            self.page_token = page_token
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "parent_id",
            "page_size",
            "page_token",
        ]
    
    @builtins.property
    def parent_id(self) -> "builtins.str":
        """
        ID of the RouteTable.
        """
        
        return super()._get_field("parent_id", explicit_presence=False,
        )
    @parent_id.setter
    def parent_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("parent_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def page_size(self) -> "builtins.int":
        return super()._get_field("page_size", explicit_presence=False,
        )
    @page_size.setter
    def page_size(self, value: "builtins.int|None") -> None:
        return super()._set_field("page_size",value,explicit_presence=False,
        )
    
    @builtins.property
    def page_token(self) -> "builtins.str":
        return super()._get_field("page_token", explicit_presence=False,
        )
    @page_token.setter
    def page_token(self, value: "builtins.str|None") -> None:
        return super()._set_field("page_token",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "parent_id":"parent_id",
        "page_size":"page_size",
        "page_token":"page_token",
    }
    
class ListRoutesResponse(pb_classes.Message):
    __PB2_CLASS__ = route_service_pb2.ListRoutesResponse
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.ListRoutesResponse",route_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        items: "abc.Iterable[Route]|None|unset.UnsetType" = unset.Unset,
        next_page_token: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(items, unset.UnsetType):
            self.items = items
        if not isinstance(next_page_token, unset.UnsetType):
            self.next_page_token = next_page_token
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "items",
            "next_page_token",
        ]
    
    @builtins.property
    def items(self) -> "abc.MutableSequence[Route]":
        return super()._get_field("items", explicit_presence=False,
        wrap=pb_classes.Repeated.with_wrap(Route,None,None),
        )
    @items.setter
    def items(self, value: "abc.Iterable[Route]|None") -> None:
        return super()._set_field("items",value,explicit_presence=False,
        )
    
    @builtins.property
    def next_page_token(self) -> "builtins.str":
        return super()._get_field("next_page_token", explicit_presence=False,
        )
    @next_page_token.setter
    def next_page_token(self, value: "builtins.str|None") -> None:
        return super()._set_field("next_page_token",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "items":"items",
        "next_page_token":"next_page_token",
    }
    
class CreateRouteRequest(pb_classes.Message):
    __PB2_CLASS__ = route_service_pb2.CreateRouteRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.CreateRouteRequest",route_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
        spec: "RouteSpec|route_pb2.RouteSpec|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
        if not isinstance(spec, unset.UnsetType):
            self.spec = spec
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
            "spec",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    @builtins.property
    def spec(self) -> "RouteSpec":
        return super()._get_field("spec", explicit_presence=False,
        wrap=RouteSpec,
        )
    @spec.setter
    def spec(self, value: "RouteSpec|route_pb2.RouteSpec|None") -> None:
        return super()._set_field("spec",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
        "spec":"spec",
    }
    
class UpdateRouteRequest(pb_classes.Message):
    __PB2_CLASS__ = route_service_pb2.UpdateRouteRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.UpdateRouteRequest",route_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
        spec: "RouteSpec|route_pb2.RouteSpec|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
        if not isinstance(spec, unset.UnsetType):
            self.spec = spec
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
            "spec",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    @builtins.property
    def spec(self) -> "RouteSpec":
        return super()._get_field("spec", explicit_presence=False,
        wrap=RouteSpec,
        )
    @spec.setter
    def spec(self, value: "RouteSpec|route_pb2.RouteSpec|None") -> None:
        return super()._set_field("spec",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
        "spec":"spec",
    }
    
class DeleteRouteRequest(pb_classes.Message):
    __PB2_CLASS__ = route_service_pb2.DeleteRouteRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.DeleteRouteRequest",route_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(id, unset.UnsetType):
            self.id = id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "id",
        ]
    
    @builtins.property
    def id(self) -> "builtins.str":
        return super()._get_field("id", explicit_presence=False,
        )
    @id.setter
    def id(self, value: "builtins.str|None") -> None:
        return super()._set_field("id",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "id":"id",
    }
    

class RouteServiceClient(client.ClientWithOperations[v1_1.Operation,v1_1.OperationServiceClient]):
    """
    This class provides the client methods for the ``.nebius.vpc.v1.RouteService`` service.
    
    Each method constructs a :class:`nebius.aio.request.Request` object
    that represents the in-flight RPC. The request can be awaited (async)
    or waited synchronously using its ``.wait()`` helpers.
    
    The request methods accept various parameters to configure metadata,
    timeouts, authorization, and retries. See individual method docstrings
    for details.
    
    :cvar __service_name__: The full protobuf service name.
    """
    
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.ServiceDescriptor](".nebius.vpc.v1.RouteService",route_service_pb2.DESCRIPTOR,descriptor_1.ServiceDescriptor)
    """The protobuf service descriptor extraction function."""
    __service_name__ = ".nebius.vpc.v1.RouteService"
    __operation_type__ = v1_1.Operation
    __operation_service_class__ = v1_1.OperationServiceClient
    __operation_source_method__ = "Create"
    """The method name that can be used to fetch the address channel for the operation."""
    
    def get(self,
        request: "GetRouteRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["GetRouteRequest","Route"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.GetRouteRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.vpc.v1.Route`.
        """
        
        return super().request(
            method="Get",
            request=request,
            result_pb2_class=route_pb2.Route,
            result_wrapper=pb_classes.simple_wrapper(Route),
            **kwargs,
        )
    
    def get_by_name(self,
        request: "GetRouteByNameRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["GetRouteByNameRequest","Route"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.GetRouteByNameRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.vpc.v1.Route`.
        """
        
        return super().request(
            method="GetByName",
            request=request,
            result_pb2_class=route_pb2.Route,
            result_wrapper=pb_classes.simple_wrapper(Route),
            **kwargs,
        )
    
    def list(self,
        request: "ListRoutesRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["ListRoutesRequest","ListRoutesResponse"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.ListRoutesRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.vpc.v1.ListRoutesResponse`.
        """
        
        return super().request(
            method="List",
            request=request,
            result_pb2_class=route_service_pb2.ListRoutesResponse,
            result_wrapper=pb_classes.simple_wrapper(ListRoutesResponse),
            **kwargs,
        )
    
    def create(self,
        request: "CreateRouteRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["CreateRouteRequest","operation.Operation[v1_1.Operation]"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.CreateRouteRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.common.v1.Operation`.
        """
        
        return super().request(
            method="Create",
            request=request,
            result_pb2_class=operation_pb2.Operation,
            result_wrapper=operation.Operation,
            **kwargs,
        )
    
    def update(self,
        request: "UpdateRouteRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["UpdateRouteRequest","operation.Operation[v1_1.Operation]"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.UpdateRouteRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.common.v1.Operation`.
        """
        
        kwargs['metadata'] = fieldmask_protobuf.ensure_reset_mask_in_metadata(request, kwargs.get('metadata', None))
        return super().request(
            method="Update",
            request=request,
            result_pb2_class=operation_pb2.Operation,
            result_wrapper=operation.Operation,
            **kwargs,
        )
    
    def delete(self,
        request: "DeleteRouteRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["DeleteRouteRequest","operation.Operation[v1_1.Operation]"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.DeleteRouteRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.common.v1.Operation`.
        """
        
        return super().request(
            method="Delete",
            request=request,
            result_pb2_class=operation_pb2.Operation,
            result_wrapper=operation.Operation,
            **kwargs,
        )
    

# file: nebius/vpc/v1/route_table.proto
class RouteTable(pb_classes.Message):
    """
    RouteTable represents a routing configuration for a VPC network.
    Each route table can be associated with multiple subnets
    and contains rules for routing traffic to different destinations.
    """
    
    __PB2_CLASS__ = route_table_pb2.RouteTable
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.RouteTable",route_table_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
        spec: "RouteTableSpec|route_table_pb2.RouteTableSpec|None|unset.UnsetType" = unset.Unset,
        status: "RouteTableStatus|route_table_pb2.RouteTableStatus|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
        if not isinstance(spec, unset.UnsetType):
            self.spec = spec
        if not isinstance(status, unset.UnsetType):
            self.status = status
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
            "spec",
            "status",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        """
        ``metadata.parent_id`` represents the Project.
        """
        
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    @builtins.property
    def spec(self) -> "RouteTableSpec":
        """
        Specification of the route table's configuration.
        """
        
        return super()._get_field("spec", explicit_presence=False,
        wrap=RouteTableSpec,
        )
    @spec.setter
    def spec(self, value: "RouteTableSpec|route_table_pb2.RouteTableSpec|None") -> None:
        return super()._set_field("spec",value,explicit_presence=False,
        )
    
    @builtins.property
    def status(self) -> "RouteTableStatus":
        """
        Current status of the route table.
        """
        
        return super()._get_field("status", explicit_presence=False,
        wrap=RouteTableStatus,
        )
    @status.setter
    def status(self, value: "RouteTableStatus|route_table_pb2.RouteTableStatus|None") -> None:
        return super()._set_field("status",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
        "spec":"spec",
        "status":"status",
    }
    
class RouteTableSpec(pb_classes.Message):
    __PB2_CLASS__ = route_table_pb2.RouteTableSpec
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.RouteTableSpec",route_table_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        network_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(network_id, unset.UnsetType):
            self.network_id = network_id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "network_id",
        ]
    
    @builtins.property
    def network_id(self) -> "builtins.str":
        """
        ID of the VPC network this route table belongs to.
        """
        
        return super()._get_field("network_id", explicit_presence=False,
        )
    @network_id.setter
    def network_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("network_id",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "network_id":"network_id",
    }
    
class RouteTableStatus(pb_classes.Message):
    __PB2_CLASS__ = route_table_pb2.RouteTableStatus
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.RouteTableStatus",route_table_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    class State(pb_enum.Enum):
        """
        State indicates the current operational state of the route table.
        """
        
        __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.EnumDescriptor](".nebius.vpc.v1.RouteTableStatus.State",route_table_pb2.DESCRIPTOR,descriptor_1.EnumDescriptor)
        STATE_UNSPECIFIED = 0
        """
        The state is unknown or not yet set.
        """
        
        READY = 10
        """
        The route table is configured and operational.
        """
        
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        state: "RouteTableStatus.State|route_table_pb2.RouteTableStatus.State|None|unset.UnsetType" = unset.Unset,
        default: "builtins.bool|None|unset.UnsetType" = unset.Unset,
        assignment: "RouteTableAssignment|route_table_pb2.RouteTableAssignment|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(state, unset.UnsetType):
            self.state = state
        if not isinstance(default, unset.UnsetType):
            self.default = default
        if not isinstance(assignment, unset.UnsetType):
            self.assignment = assignment
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "state",
            "default",
            "assignment",
            "State",
        ]
    
    @builtins.property
    def state(self) -> "RouteTableStatus.State":
        """
        Current state of the route table.
        """
        
        return super()._get_field("state", explicit_presence=False,
        wrap=RouteTableStatus.State,
        )
    @state.setter
    def state(self, value: "RouteTableStatus.State|route_table_pb2.RouteTableStatus.State|None") -> None:
        return super()._set_field("state",value,explicit_presence=False,
        )
    
    @builtins.property
    def default(self) -> "builtins.bool":
        """
        Indicates if this is the default route table for the network.
        Only one route table can be default per network.
        """
        
        return super()._get_field("default", explicit_presence=False,
        )
    @default.setter
    def default(self, value: "builtins.bool|None") -> None:
        return super()._set_field("default",value,explicit_presence=False,
        )
    
    @builtins.property
    def assignment(self) -> "RouteTableAssignment":
        """
        Information about which subnets are using this route table.
        """
        
        return super()._get_field("assignment", explicit_presence=False,
        wrap=RouteTableAssignment,
        )
    @assignment.setter
    def assignment(self, value: "RouteTableAssignment|route_table_pb2.RouteTableAssignment|None") -> None:
        return super()._set_field("assignment",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "state":"state",
        "default":"default",
        "assignment":"assignment",
        "State":"State",
    }
    
class RouteTableAssignment(pb_classes.Message):
    __PB2_CLASS__ = route_table_pb2.RouteTableAssignment
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.RouteTableAssignment",route_table_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        subnets: "abc.Iterable[builtins.str]|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(subnets, unset.UnsetType):
            self.subnets = subnets
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "subnets",
        ]
    
    @builtins.property
    def subnets(self) -> "abc.MutableSequence[builtins.str]":
        """
        List of subnet IDs that use this route table for their routing configuration.
        """
        
        return super()._get_field("subnets", explicit_presence=False,
        wrap=pb_classes.Repeated,
        )
    @subnets.setter
    def subnets(self, value: "abc.Iterable[builtins.str]|None") -> None:
        return super()._set_field("subnets",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "subnets":"subnets",
    }
    
# file: nebius/vpc/v1/route_table_service.proto
class GetRouteTableRequest(pb_classes.Message):
    __PB2_CLASS__ = route_table_service_pb2.GetRouteTableRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.GetRouteTableRequest",route_table_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(id, unset.UnsetType):
            self.id = id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "id",
        ]
    
    @builtins.property
    def id(self) -> "builtins.str":
        return super()._get_field("id", explicit_presence=False,
        )
    @id.setter
    def id(self, value: "builtins.str|None") -> None:
        return super()._set_field("id",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "id":"id",
    }
    
class GetRouteTableByNameRequest(pb_classes.Message):
    __PB2_CLASS__ = route_table_service_pb2.GetRouteTableByNameRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.GetRouteTableByNameRequest",route_table_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        parent_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        name: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(parent_id, unset.UnsetType):
            self.parent_id = parent_id
        if not isinstance(name, unset.UnsetType):
            self.name = name
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "parent_id",
            "name",
        ]
    
    @builtins.property
    def parent_id(self) -> "builtins.str":
        """
        ID of the Project.
        """
        
        return super()._get_field("parent_id", explicit_presence=False,
        )
    @parent_id.setter
    def parent_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("parent_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def name(self) -> "builtins.str":
        return super()._get_field("name", explicit_presence=False,
        )
    @name.setter
    def name(self, value: "builtins.str|None") -> None:
        return super()._set_field("name",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "parent_id":"parent_id",
        "name":"name",
    }
    
class ListRouteTablesRequest(pb_classes.Message):
    __PB2_CLASS__ = route_table_service_pb2.ListRouteTablesRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.ListRouteTablesRequest",route_table_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        parent_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        page_size: "builtins.int|None|unset.UnsetType" = unset.Unset,
        page_token: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(parent_id, unset.UnsetType):
            self.parent_id = parent_id
        if not isinstance(page_size, unset.UnsetType):
            self.page_size = page_size
        if not isinstance(page_token, unset.UnsetType):
            self.page_token = page_token
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "parent_id",
            "page_size",
            "page_token",
        ]
    
    @builtins.property
    def parent_id(self) -> "builtins.str":
        """
        ID of the Project.
        """
        
        return super()._get_field("parent_id", explicit_presence=False,
        )
    @parent_id.setter
    def parent_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("parent_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def page_size(self) -> "builtins.int":
        return super()._get_field("page_size", explicit_presence=False,
        )
    @page_size.setter
    def page_size(self, value: "builtins.int|None") -> None:
        return super()._set_field("page_size",value,explicit_presence=False,
        )
    
    @builtins.property
    def page_token(self) -> "builtins.str":
        return super()._get_field("page_token", explicit_presence=False,
        )
    @page_token.setter
    def page_token(self, value: "builtins.str|None") -> None:
        return super()._set_field("page_token",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "parent_id":"parent_id",
        "page_size":"page_size",
        "page_token":"page_token",
    }
    
class ListRouteTablesByNetworkRequest(pb_classes.Message):
    __PB2_CLASS__ = route_table_service_pb2.ListRouteTablesByNetworkRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.ListRouteTablesByNetworkRequest",route_table_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        network_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        page_size: "builtins.int|None|unset.UnsetType" = unset.Unset,
        page_token: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(network_id, unset.UnsetType):
            self.network_id = network_id
        if not isinstance(page_size, unset.UnsetType):
            self.page_size = page_size
        if not isinstance(page_token, unset.UnsetType):
            self.page_token = page_token
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "network_id",
            "page_size",
            "page_token",
        ]
    
    @builtins.property
    def network_id(self) -> "builtins.str":
        return super()._get_field("network_id", explicit_presence=False,
        )
    @network_id.setter
    def network_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("network_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def page_size(self) -> "builtins.int":
        return super()._get_field("page_size", explicit_presence=False,
        )
    @page_size.setter
    def page_size(self, value: "builtins.int|None") -> None:
        return super()._set_field("page_size",value,explicit_presence=False,
        )
    
    @builtins.property
    def page_token(self) -> "builtins.str":
        return super()._get_field("page_token", explicit_presence=False,
        )
    @page_token.setter
    def page_token(self, value: "builtins.str|None") -> None:
        return super()._set_field("page_token",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "network_id":"network_id",
        "page_size":"page_size",
        "page_token":"page_token",
    }
    
class ListRouteTablesResponse(pb_classes.Message):
    __PB2_CLASS__ = route_table_service_pb2.ListRouteTablesResponse
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.ListRouteTablesResponse",route_table_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        items: "abc.Iterable[RouteTable]|None|unset.UnsetType" = unset.Unset,
        next_page_token: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(items, unset.UnsetType):
            self.items = items
        if not isinstance(next_page_token, unset.UnsetType):
            self.next_page_token = next_page_token
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "items",
            "next_page_token",
        ]
    
    @builtins.property
    def items(self) -> "abc.MutableSequence[RouteTable]":
        return super()._get_field("items", explicit_presence=False,
        wrap=pb_classes.Repeated.with_wrap(RouteTable,None,None),
        )
    @items.setter
    def items(self, value: "abc.Iterable[RouteTable]|None") -> None:
        return super()._set_field("items",value,explicit_presence=False,
        )
    
    @builtins.property
    def next_page_token(self) -> "builtins.str":
        return super()._get_field("next_page_token", explicit_presence=False,
        )
    @next_page_token.setter
    def next_page_token(self, value: "builtins.str|None") -> None:
        return super()._set_field("next_page_token",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "items":"items",
        "next_page_token":"next_page_token",
    }
    
class CreateRouteTableRequest(pb_classes.Message):
    __PB2_CLASS__ = route_table_service_pb2.CreateRouteTableRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.CreateRouteTableRequest",route_table_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
        spec: "RouteTableSpec|route_table_pb2.RouteTableSpec|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
        if not isinstance(spec, unset.UnsetType):
            self.spec = spec
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
            "spec",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    @builtins.property
    def spec(self) -> "RouteTableSpec":
        return super()._get_field("spec", explicit_presence=False,
        wrap=RouteTableSpec,
        )
    @spec.setter
    def spec(self, value: "RouteTableSpec|route_table_pb2.RouteTableSpec|None") -> None:
        return super()._set_field("spec",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
        "spec":"spec",
    }
    
class UpdateRouteTableRequest(pb_classes.Message):
    __PB2_CLASS__ = route_table_service_pb2.UpdateRouteTableRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.UpdateRouteTableRequest",route_table_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
        spec: "RouteTableSpec|route_table_pb2.RouteTableSpec|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
        if not isinstance(spec, unset.UnsetType):
            self.spec = spec
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
            "spec",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    @builtins.property
    def spec(self) -> "RouteTableSpec":
        return super()._get_field("spec", explicit_presence=False,
        wrap=RouteTableSpec,
        )
    @spec.setter
    def spec(self, value: "RouteTableSpec|route_table_pb2.RouteTableSpec|None") -> None:
        return super()._set_field("spec",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
        "spec":"spec",
    }
    
class DeleteRouteTableRequest(pb_classes.Message):
    __PB2_CLASS__ = route_table_service_pb2.DeleteRouteTableRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.DeleteRouteTableRequest",route_table_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(id, unset.UnsetType):
            self.id = id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "id",
        ]
    
    @builtins.property
    def id(self) -> "builtins.str":
        return super()._get_field("id", explicit_presence=False,
        )
    @id.setter
    def id(self, value: "builtins.str|None") -> None:
        return super()._set_field("id",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "id":"id",
    }
    

class RouteTableServiceClient(client.ClientWithOperations[v1_1.Operation,v1_1.OperationServiceClient]):
    """
    This class provides the client methods for the ``.nebius.vpc.v1.RouteTableService`` service.
    
    Each method constructs a :class:`nebius.aio.request.Request` object
    that represents the in-flight RPC. The request can be awaited (async)
    or waited synchronously using its ``.wait()`` helpers.
    
    The request methods accept various parameters to configure metadata,
    timeouts, authorization, and retries. See individual method docstrings
    for details.
    
    :cvar __service_name__: The full protobuf service name.
    """
    
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.ServiceDescriptor](".nebius.vpc.v1.RouteTableService",route_table_service_pb2.DESCRIPTOR,descriptor_1.ServiceDescriptor)
    """The protobuf service descriptor extraction function."""
    __service_name__ = ".nebius.vpc.v1.RouteTableService"
    __operation_type__ = v1_1.Operation
    __operation_service_class__ = v1_1.OperationServiceClient
    __operation_source_method__ = "Create"
    """The method name that can be used to fetch the address channel for the operation."""
    
    def get(self,
        request: "GetRouteTableRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["GetRouteTableRequest","RouteTable"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.GetRouteTableRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.vpc.v1.RouteTable`.
        """
        
        return super().request(
            method="Get",
            request=request,
            result_pb2_class=route_table_pb2.RouteTable,
            result_wrapper=pb_classes.simple_wrapper(RouteTable),
            **kwargs,
        )
    
    def get_by_name(self,
        request: "GetRouteTableByNameRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["GetRouteTableByNameRequest","RouteTable"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.GetRouteTableByNameRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.vpc.v1.RouteTable`.
        """
        
        return super().request(
            method="GetByName",
            request=request,
            result_pb2_class=route_table_pb2.RouteTable,
            result_wrapper=pb_classes.simple_wrapper(RouteTable),
            **kwargs,
        )
    
    def list(self,
        request: "ListRouteTablesRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["ListRouteTablesRequest","ListRouteTablesResponse"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.ListRouteTablesRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.vpc.v1.ListRouteTablesResponse`.
        """
        
        return super().request(
            method="List",
            request=request,
            result_pb2_class=route_table_service_pb2.ListRouteTablesResponse,
            result_wrapper=pb_classes.simple_wrapper(ListRouteTablesResponse),
            **kwargs,
        )
    
    def list_by_network(self,
        request: "ListRouteTablesByNetworkRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["ListRouteTablesByNetworkRequest","ListRouteTablesResponse"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.ListRouteTablesByNetworkRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.vpc.v1.ListRouteTablesResponse`.
        """
        
        return super().request(
            method="ListByNetwork",
            request=request,
            result_pb2_class=route_table_service_pb2.ListRouteTablesResponse,
            result_wrapper=pb_classes.simple_wrapper(ListRouteTablesResponse),
            **kwargs,
        )
    
    def create(self,
        request: "CreateRouteTableRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["CreateRouteTableRequest","operation.Operation[v1_1.Operation]"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.CreateRouteTableRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.common.v1.Operation`.
        """
        
        return super().request(
            method="Create",
            request=request,
            result_pb2_class=operation_pb2.Operation,
            result_wrapper=operation.Operation,
            **kwargs,
        )
    
    def update(self,
        request: "UpdateRouteTableRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["UpdateRouteTableRequest","operation.Operation[v1_1.Operation]"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.UpdateRouteTableRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.common.v1.Operation`.
        """
        
        kwargs['metadata'] = fieldmask_protobuf.ensure_reset_mask_in_metadata(request, kwargs.get('metadata', None))
        return super().request(
            method="Update",
            request=request,
            result_pb2_class=operation_pb2.Operation,
            result_wrapper=operation.Operation,
            **kwargs,
        )
    
    def delete(self,
        request: "DeleteRouteTableRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["DeleteRouteTableRequest","operation.Operation[v1_1.Operation]"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.DeleteRouteTableRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.common.v1.Operation`.
        """
        
        return super().request(
            method="Delete",
            request=request,
            result_pb2_class=operation_pb2.Operation,
            result_wrapper=operation.Operation,
            **kwargs,
        )
    

# file: nebius/vpc/v1/subnet.proto
class Subnet(pb_classes.Message):
    """
    Defines a Subnet, a segment of a network used for more granular control and management.
    Subnet uses pools to organize address space.
    """
    
    __PB2_CLASS__ = subnet_pb2.Subnet
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.Subnet",subnet_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
        spec: "SubnetSpec|subnet_pb2.SubnetSpec|None|unset.UnsetType" = unset.Unset,
        status: "SubnetStatus|subnet_pb2.SubnetStatus|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
        if not isinstance(spec, unset.UnsetType):
            self.spec = spec
        if not isinstance(status, unset.UnsetType):
            self.status = status
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
            "spec",
            "status",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        """
        Metadata for the subnet resource.
        ``metadata.parent_id`` represents IAM container
        """
        
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    @builtins.property
    def spec(self) -> "SubnetSpec":
        """
        Specification of the subnet.
        """
        
        return super()._get_field("spec", explicit_presence=False,
        wrap=SubnetSpec,
        )
    @spec.setter
    def spec(self, value: "SubnetSpec|subnet_pb2.SubnetSpec|None") -> None:
        return super()._set_field("spec",value,explicit_presence=False,
        )
    
    @builtins.property
    def status(self) -> "SubnetStatus":
        """
        Status of the subnet.
        """
        
        return super()._get_field("status", explicit_presence=False,
        wrap=SubnetStatus,
        )
    @status.setter
    def status(self, value: "SubnetStatus|subnet_pb2.SubnetStatus|None") -> None:
        return super()._set_field("status",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
        "spec":"spec",
        "status":"status",
    }
    
class SubnetSpec(pb_classes.Message):
    __PB2_CLASS__ = subnet_pb2.SubnetSpec
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.SubnetSpec",subnet_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        network_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        ipv4_private_pools: "IPv4PrivateSubnetPools|subnet_pb2.IPv4PrivateSubnetPools|None|unset.UnsetType" = unset.Unset,
        ipv4_public_pools: "IPv4PublicSubnetPools|subnet_pb2.IPv4PublicSubnetPools|None|unset.UnsetType" = unset.Unset,
        route_table_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(network_id, unset.UnsetType):
            self.network_id = network_id
        if not isinstance(ipv4_private_pools, unset.UnsetType):
            self.ipv4_private_pools = ipv4_private_pools
        if not isinstance(ipv4_public_pools, unset.UnsetType):
            self.ipv4_public_pools = ipv4_public_pools
        if not isinstance(route_table_id, unset.UnsetType):
            self.route_table_id = route_table_id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "network_id",
            "ipv4_private_pools",
            "ipv4_public_pools",
            "route_table_id",
        ]
    
    @builtins.property
    def network_id(self) -> "builtins.str":
        """
        ID of the network this subnet belongs to.
        """
        
        return super()._get_field("network_id", explicit_presence=False,
        )
    @network_id.setter
    def network_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("network_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def ipv4_private_pools(self) -> "IPv4PrivateSubnetPools":
        """
        Private IPv4 address pools for this subnet.
        If unspecified, pools from the associated network are used.
        """
        
        return super()._get_field("ipv4_private_pools", explicit_presence=False,
        wrap=IPv4PrivateSubnetPools,
        )
    @ipv4_private_pools.setter
    def ipv4_private_pools(self, value: "IPv4PrivateSubnetPools|subnet_pb2.IPv4PrivateSubnetPools|None") -> None:
        return super()._set_field("ipv4_private_pools",value,explicit_presence=False,
        )
    
    @builtins.property
    def ipv4_public_pools(self) -> "IPv4PublicSubnetPools":
        """
        Public IPv4 address pools for this subnet.
        If unspecified, pools from the associated network are used.
        """
        
        return super()._get_field("ipv4_public_pools", explicit_presence=False,
        wrap=IPv4PublicSubnetPools,
        )
    @ipv4_public_pools.setter
    def ipv4_public_pools(self, value: "IPv4PublicSubnetPools|subnet_pb2.IPv4PublicSubnetPools|None") -> None:
        return super()._set_field("ipv4_public_pools",value,explicit_presence=False,
        )
    
    @builtins.property
    def route_table_id(self) -> "builtins.str":
        """
        ID of the route table to associate with the subnet.
        If unspecified, the network's default route table is used.
        """
        
        return super()._get_field("route_table_id", explicit_presence=False,
        )
    @route_table_id.setter
    def route_table_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("route_table_id",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "network_id":"network_id",
        "ipv4_private_pools":"ipv4_private_pools",
        "ipv4_public_pools":"ipv4_public_pools",
        "route_table_id":"route_table_id",
    }
    
class IPv4PrivateSubnetPools(pb_classes.Message):
    __PB2_CLASS__ = subnet_pb2.IPv4PrivateSubnetPools
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.IPv4PrivateSubnetPools",subnet_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        pools: "abc.Iterable[SubnetPool]|None|unset.UnsetType" = unset.Unset,
        use_network_pools: "builtins.bool|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(pools, unset.UnsetType):
            self.pools = pools
        if not isinstance(use_network_pools, unset.UnsetType):
            self.use_network_pools = use_network_pools
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "pools",
            "use_network_pools",
        ]
    
    @builtins.property
    def pools(self) -> "abc.MutableSequence[SubnetPool]":
        """
        List of private IPv4 CIDR blocks for this subnet.
        Must not overlap with other resources in the network
        Must be empty if ``use_network_pools`` is true.
        """
        
        return super()._get_field("pools", explicit_presence=False,
        wrap=pb_classes.Repeated.with_wrap(SubnetPool,None,None),
        )
    @pools.setter
    def pools(self, value: "abc.Iterable[SubnetPool]|None") -> None:
        return super()._set_field("pools",value,explicit_presence=False,
        )
    
    @builtins.property
    def use_network_pools(self) -> "builtins.bool":
        """
        If true, inherit private IPv4 pools from the network. Defaults to true.
        Must be false if ``pools`` is specified.
        """
        
        return super()._get_field("use_network_pools", explicit_presence=False,
        )
    @use_network_pools.setter
    def use_network_pools(self, value: "builtins.bool|None") -> None:
        return super()._set_field("use_network_pools",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "pools":"pools",
        "use_network_pools":"use_network_pools",
    }
    
class IPv4PublicSubnetPools(pb_classes.Message):
    __PB2_CLASS__ = subnet_pb2.IPv4PublicSubnetPools
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.IPv4PublicSubnetPools",subnet_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        pools: "abc.Iterable[SubnetPool]|None|unset.UnsetType" = unset.Unset,
        use_network_pools: "builtins.bool|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(pools, unset.UnsetType):
            self.pools = pools
        if not isinstance(use_network_pools, unset.UnsetType):
            self.use_network_pools = use_network_pools
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "pools",
            "use_network_pools",
        ]
    
    @builtins.property
    def pools(self) -> "abc.MutableSequence[SubnetPool]":
        """
        List of public IPv4 CIDR blocks for this subnet.
        Must not overlap with other resources in the network.
        Must be empty if ``use_network_pools`` is true.
        """
        
        return super()._get_field("pools", explicit_presence=False,
        wrap=pb_classes.Repeated.with_wrap(SubnetPool,None,None),
        )
    @pools.setter
    def pools(self, value: "abc.Iterable[SubnetPool]|None") -> None:
        return super()._set_field("pools",value,explicit_presence=False,
        )
    
    @builtins.property
    def use_network_pools(self) -> "builtins.bool":
        """
        If true, inherit public IPv4 pools from the network.
        Must be false if ``pools`` is specified.
        """
        
        return super()._get_field("use_network_pools", explicit_presence=False,
        )
    @use_network_pools.setter
    def use_network_pools(self, value: "builtins.bool|None") -> None:
        return super()._set_field("use_network_pools",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "pools":"pools",
        "use_network_pools":"use_network_pools",
    }
    
class SubnetPool(pb_classes.Message):
    __PB2_CLASS__ = subnet_pb2.SubnetPool
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.SubnetPool",subnet_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        cidrs: "abc.Iterable[SubnetCidr]|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(cidrs, unset.UnsetType):
            self.cidrs = cidrs
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "cidrs",
        ]
    
    @builtins.property
    def cidrs(self) -> "abc.MutableSequence[SubnetCidr]":
        return super()._get_field("cidrs", explicit_presence=False,
        wrap=pb_classes.Repeated.with_wrap(SubnetCidr,None,None),
        )
    @cidrs.setter
    def cidrs(self, value: "abc.Iterable[SubnetCidr]|None") -> None:
        return super()._set_field("cidrs",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "cidrs":"cidrs",
    }
    
class SubnetCidr(pb_classes.Message):
    __PB2_CLASS__ = subnet_pb2.SubnetCidr
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.SubnetCidr",subnet_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        cidr: "builtins.str|None|unset.UnsetType" = unset.Unset,
        state: "AddressBlockState|pool_pb2.AddressBlockState|None|unset.UnsetType" = unset.Unset,
        max_mask_length: "builtins.int|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(cidr, unset.UnsetType):
            self.cidr = cidr
        if not isinstance(state, unset.UnsetType):
            self.state = state
        if not isinstance(max_mask_length, unset.UnsetType):
            self.max_mask_length = max_mask_length
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "cidr",
            "state",
            "max_mask_length",
        ]
    
    @builtins.property
    def cidr(self) -> "builtins.str":
        """
        A CIDR block (e.g., "10.1.2.0/24") or a prefix length (e.g., "/24").
        If prefix length is specified, the CIDR block will be auto-allocated
        from the network's available space.
        """
        
        return super()._get_field("cidr", explicit_presence=False,
        )
    @cidr.setter
    def cidr(self, value: "builtins.str|None") -> None:
        return super()._set_field("cidr",value,explicit_presence=False,
        )
    
    @builtins.property
    def state(self) -> "AddressBlockState":
        """
        Controls provisioning of IP addresses from the CIDR block . Defaults to AVAILABLE.
        """
        
        return super()._get_field("state", explicit_presence=False,
        wrap=AddressBlockState,
        )
    @state.setter
    def state(self, value: "AddressBlockState|pool_pb2.AddressBlockState|None") -> None:
        return super()._set_field("state",value,explicit_presence=False,
        )
    
    @builtins.property
    def max_mask_length(self) -> "builtins.int":
        """
        Maximum mask length for an allocation from this block. Defaults to /32 for IPv4.
        """
        
        return super()._get_field("max_mask_length", explicit_presence=False,
        )
    @max_mask_length.setter
    def max_mask_length(self, value: "builtins.int|None") -> None:
        return super()._set_field("max_mask_length",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "cidr":"cidr",
        "state":"state",
        "max_mask_length":"max_mask_length",
    }
    
class SubnetStatus(pb_classes.Message):
    __PB2_CLASS__ = subnet_pb2.SubnetStatus
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.SubnetStatus",subnet_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    class State(pb_enum.Enum):
        """
        Enumeration of possible states of the subnet.
        """
        
        __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.EnumDescriptor](".nebius.vpc.v1.SubnetStatus.State",subnet_pb2.DESCRIPTOR,descriptor_1.EnumDescriptor)
        STATE_UNSPECIFIED = 0
        """
        Default state, unspecified.
        """
        
        CREATING = 1
        """
        Subnet is being created.
        """
        
        READY = 2
        """
        Subnet is ready for use.
        """
        
        DELETING = 3
        """
        Subnet is being deleted.
        """
        
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        state: "SubnetStatus.State|subnet_pb2.SubnetStatus.State|None|unset.UnsetType" = unset.Unset,
        ipv4_private_cidrs: "abc.Iterable[builtins.str]|None|unset.UnsetType" = unset.Unset,
        ipv4_public_cidrs: "abc.Iterable[builtins.str]|None|unset.UnsetType" = unset.Unset,
        route_table: "SubnetAssociatedRouteTable|subnet_pb2.SubnetAssociatedRouteTable|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(state, unset.UnsetType):
            self.state = state
        if not isinstance(ipv4_private_cidrs, unset.UnsetType):
            self.ipv4_private_cidrs = ipv4_private_cidrs
        if not isinstance(ipv4_public_cidrs, unset.UnsetType):
            self.ipv4_public_cidrs = ipv4_public_cidrs
        if not isinstance(route_table, unset.UnsetType):
            self.route_table = route_table
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "state",
            "ipv4_private_cidrs",
            "ipv4_public_cidrs",
            "route_table",
            "State",
        ]
    
    @builtins.property
    def state(self) -> "SubnetStatus.State":
        """
        Current state of the subnet.
        """
        
        return super()._get_field("state", explicit_presence=False,
        wrap=SubnetStatus.State,
        )
    @state.setter
    def state(self, value: "SubnetStatus.State|subnet_pb2.SubnetStatus.State|None") -> None:
        return super()._set_field("state",value,explicit_presence=False,
        )
    
    @builtins.property
    def ipv4_private_cidrs(self) -> "abc.MutableSequence[builtins.str]":
        """
        CIDR blocks.
        """
        
        return super()._get_field("ipv4_private_cidrs", explicit_presence=False,
        wrap=pb_classes.Repeated,
        )
    @ipv4_private_cidrs.setter
    def ipv4_private_cidrs(self, value: "abc.Iterable[builtins.str]|None") -> None:
        return super()._set_field("ipv4_private_cidrs",value,explicit_presence=False,
        )
    
    @builtins.property
    def ipv4_public_cidrs(self) -> "abc.MutableSequence[builtins.str]":
        """
        CIDR blocks.
        """
        
        return super()._get_field("ipv4_public_cidrs", explicit_presence=False,
        wrap=pb_classes.Repeated,
        )
    @ipv4_public_cidrs.setter
    def ipv4_public_cidrs(self, value: "abc.Iterable[builtins.str]|None") -> None:
        return super()._set_field("ipv4_public_cidrs",value,explicit_presence=False,
        )
    
    @builtins.property
    def route_table(self) -> "SubnetAssociatedRouteTable":
        """
        Information about the route table associated with this subnet.
        Can be either a custom route table or the network's default route table.
        """
        
        return super()._get_field("route_table", explicit_presence=False,
        wrap=SubnetAssociatedRouteTable,
        )
    @route_table.setter
    def route_table(self, value: "SubnetAssociatedRouteTable|subnet_pb2.SubnetAssociatedRouteTable|None") -> None:
        return super()._set_field("route_table",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "state":"state",
        "ipv4_private_cidrs":"ipv4_private_cidrs",
        "ipv4_public_cidrs":"ipv4_public_cidrs",
        "route_table":"route_table",
        "State":"State",
    }
    
class SubnetAssociatedRouteTable(pb_classes.Message):
    __PB2_CLASS__ = subnet_pb2.SubnetAssociatedRouteTable
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.SubnetAssociatedRouteTable",subnet_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        default: "builtins.bool|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(id, unset.UnsetType):
            self.id = id
        if not isinstance(default, unset.UnsetType):
            self.default = default
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "id",
            "default",
        ]
    
    @builtins.property
    def id(self) -> "builtins.str":
        """
        ID of the route table.
        """
        
        return super()._get_field("id", explicit_presence=False,
        )
    @id.setter
    def id(self, value: "builtins.str|None") -> None:
        return super()._set_field("id",value,explicit_presence=False,
        )
    
    @builtins.property
    def default(self) -> "builtins.bool":
        """
        Indicates whether this is the network's default route table.
        If true, this is the default route table inherited from the network.
        If false, this is a custom route table explicitly associated with the subnet via spec.
        """
        
        return super()._get_field("default", explicit_presence=False,
        )
    @default.setter
    def default(self, value: "builtins.bool|None") -> None:
        return super()._set_field("default",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "id":"id",
        "default":"default",
    }
    
# file: nebius/vpc/v1/subnet_service.proto
class GetSubnetRequest(pb_classes.Message):
    __PB2_CLASS__ = subnet_service_pb2.GetSubnetRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.GetSubnetRequest",subnet_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(id, unset.UnsetType):
            self.id = id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "id",
        ]
    
    @builtins.property
    def id(self) -> "builtins.str":
        return super()._get_field("id", explicit_presence=False,
        )
    @id.setter
    def id(self, value: "builtins.str|None") -> None:
        return super()._set_field("id",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "id":"id",
    }
    
class GetSubnetByNameRequest(pb_classes.Message):
    __PB2_CLASS__ = subnet_service_pb2.GetSubnetByNameRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.GetSubnetByNameRequest",subnet_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        parent_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        name: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(parent_id, unset.UnsetType):
            self.parent_id = parent_id
        if not isinstance(name, unset.UnsetType):
            self.name = name
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "parent_id",
            "name",
        ]
    
    @builtins.property
    def parent_id(self) -> "builtins.str":
        """
        ID of the project.
        """
        
        return super()._get_field("parent_id", explicit_presence=False,
        )
    @parent_id.setter
    def parent_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("parent_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def name(self) -> "builtins.str":
        return super()._get_field("name", explicit_presence=False,
        )
    @name.setter
    def name(self, value: "builtins.str|None") -> None:
        return super()._set_field("name",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "parent_id":"parent_id",
        "name":"name",
    }
    
class ListSubnetsRequest(pb_classes.Message):
    __PB2_CLASS__ = subnet_service_pb2.ListSubnetsRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.ListSubnetsRequest",subnet_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        parent_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        page_size: "builtins.int|None|unset.UnsetType" = unset.Unset,
        page_token: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(parent_id, unset.UnsetType):
            self.parent_id = parent_id
        if not isinstance(page_size, unset.UnsetType):
            self.page_size = page_size
        if not isinstance(page_token, unset.UnsetType):
            self.page_token = page_token
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "parent_id",
            "page_size",
            "page_token",
        ]
    
    @builtins.property
    def parent_id(self) -> "builtins.str":
        """
        ID of the parent project.
        """
        
        return super()._get_field("parent_id", explicit_presence=False,
        )
    @parent_id.setter
    def parent_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("parent_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def page_size(self) -> "builtins.int":
        return super()._get_field("page_size", explicit_presence=False,
        )
    @page_size.setter
    def page_size(self, value: "builtins.int|None") -> None:
        return super()._set_field("page_size",value,explicit_presence=False,
        )
    
    @builtins.property
    def page_token(self) -> "builtins.str":
        return super()._get_field("page_token", explicit_presence=False,
        )
    @page_token.setter
    def page_token(self, value: "builtins.str|None") -> None:
        return super()._set_field("page_token",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "parent_id":"parent_id",
        "page_size":"page_size",
        "page_token":"page_token",
    }
    
class ListSubnetsByNetworkRequest(pb_classes.Message):
    __PB2_CLASS__ = subnet_service_pb2.ListSubnetsByNetworkRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.ListSubnetsByNetworkRequest",subnet_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        network_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        page_size: "builtins.int|None|unset.UnsetType" = unset.Unset,
        page_token: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(network_id, unset.UnsetType):
            self.network_id = network_id
        if not isinstance(page_size, unset.UnsetType):
            self.page_size = page_size
        if not isinstance(page_token, unset.UnsetType):
            self.page_token = page_token
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "network_id",
            "page_size",
            "page_token",
        ]
    
    @builtins.property
    def network_id(self) -> "builtins.str":
        return super()._get_field("network_id", explicit_presence=False,
        )
    @network_id.setter
    def network_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("network_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def page_size(self) -> "builtins.int":
        return super()._get_field("page_size", explicit_presence=False,
        )
    @page_size.setter
    def page_size(self, value: "builtins.int|None") -> None:
        return super()._set_field("page_size",value,explicit_presence=False,
        )
    
    @builtins.property
    def page_token(self) -> "builtins.str":
        return super()._get_field("page_token", explicit_presence=False,
        )
    @page_token.setter
    def page_token(self, value: "builtins.str|None") -> None:
        return super()._set_field("page_token",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "network_id":"network_id",
        "page_size":"page_size",
        "page_token":"page_token",
    }
    
class ListSubnetsResponse(pb_classes.Message):
    __PB2_CLASS__ = subnet_service_pb2.ListSubnetsResponse
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.ListSubnetsResponse",subnet_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        items: "abc.Iterable[Subnet]|None|unset.UnsetType" = unset.Unset,
        next_page_token: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(items, unset.UnsetType):
            self.items = items
        if not isinstance(next_page_token, unset.UnsetType):
            self.next_page_token = next_page_token
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "items",
            "next_page_token",
        ]
    
    @builtins.property
    def items(self) -> "abc.MutableSequence[Subnet]":
        return super()._get_field("items", explicit_presence=False,
        wrap=pb_classes.Repeated.with_wrap(Subnet,None,None),
        )
    @items.setter
    def items(self, value: "abc.Iterable[Subnet]|None") -> None:
        return super()._set_field("items",value,explicit_presence=False,
        )
    
    @builtins.property
    def next_page_token(self) -> "builtins.str":
        return super()._get_field("next_page_token", explicit_presence=False,
        )
    @next_page_token.setter
    def next_page_token(self, value: "builtins.str|None") -> None:
        return super()._set_field("next_page_token",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "items":"items",
        "next_page_token":"next_page_token",
    }
    
class CreateSubnetRequest(pb_classes.Message):
    __PB2_CLASS__ = subnet_service_pb2.CreateSubnetRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.CreateSubnetRequest",subnet_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
        spec: "SubnetSpec|subnet_pb2.SubnetSpec|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
        if not isinstance(spec, unset.UnsetType):
            self.spec = spec
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
            "spec",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    @builtins.property
    def spec(self) -> "SubnetSpec":
        return super()._get_field("spec", explicit_presence=False,
        wrap=SubnetSpec,
        )
    @spec.setter
    def spec(self, value: "SubnetSpec|subnet_pb2.SubnetSpec|None") -> None:
        return super()._set_field("spec",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
        "spec":"spec",
    }
    
class UpdateSubnetRequest(pb_classes.Message):
    __PB2_CLASS__ = subnet_service_pb2.UpdateSubnetRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.UpdateSubnetRequest",subnet_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
        spec: "SubnetSpec|subnet_pb2.SubnetSpec|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
        if not isinstance(spec, unset.UnsetType):
            self.spec = spec
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
            "spec",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    @builtins.property
    def spec(self) -> "SubnetSpec":
        return super()._get_field("spec", explicit_presence=False,
        wrap=SubnetSpec,
        )
    @spec.setter
    def spec(self, value: "SubnetSpec|subnet_pb2.SubnetSpec|None") -> None:
        return super()._set_field("spec",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
        "spec":"spec",
    }
    
class DeleteSubnetRequest(pb_classes.Message):
    __PB2_CLASS__ = subnet_service_pb2.DeleteSubnetRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.DeleteSubnetRequest",subnet_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(id, unset.UnsetType):
            self.id = id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "id",
        ]
    
    @builtins.property
    def id(self) -> "builtins.str":
        return super()._get_field("id", explicit_presence=False,
        )
    @id.setter
    def id(self, value: "builtins.str|None") -> None:
        return super()._set_field("id",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "id":"id",
    }
    

class SubnetServiceClient(client.ClientWithOperations[v1_1.Operation,v1_1.OperationServiceClient]):
    """
    This class provides the client methods for the ``.nebius.vpc.v1.SubnetService`` service.
    
    Each method constructs a :class:`nebius.aio.request.Request` object
    that represents the in-flight RPC. The request can be awaited (async)
    or waited synchronously using its ``.wait()`` helpers.
    
    The request methods accept various parameters to configure metadata,
    timeouts, authorization, and retries. See individual method docstrings
    for details.
    
    :cvar __service_name__: The full protobuf service name.
    """
    
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.ServiceDescriptor](".nebius.vpc.v1.SubnetService",subnet_service_pb2.DESCRIPTOR,descriptor_1.ServiceDescriptor)
    """The protobuf service descriptor extraction function."""
    __service_name__ = ".nebius.vpc.v1.SubnetService"
    __operation_type__ = v1_1.Operation
    __operation_service_class__ = v1_1.OperationServiceClient
    __operation_source_method__ = "Create"
    """The method name that can be used to fetch the address channel for the operation."""
    
    def get(self,
        request: "GetSubnetRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["GetSubnetRequest","Subnet"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.GetSubnetRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.vpc.v1.Subnet`.
        """
        
        return super().request(
            method="Get",
            request=request,
            result_pb2_class=subnet_pb2.Subnet,
            result_wrapper=pb_classes.simple_wrapper(Subnet),
            **kwargs,
        )
    
    def get_by_name(self,
        request: "GetSubnetByNameRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["GetSubnetByNameRequest","Subnet"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.GetSubnetByNameRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.vpc.v1.Subnet`.
        """
        
        return super().request(
            method="GetByName",
            request=request,
            result_pb2_class=subnet_pb2.Subnet,
            result_wrapper=pb_classes.simple_wrapper(Subnet),
            **kwargs,
        )
    
    def list(self,
        request: "ListSubnetsRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["ListSubnetsRequest","ListSubnetsResponse"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.ListSubnetsRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.vpc.v1.ListSubnetsResponse`.
        """
        
        return super().request(
            method="List",
            request=request,
            result_pb2_class=subnet_service_pb2.ListSubnetsResponse,
            result_wrapper=pb_classes.simple_wrapper(ListSubnetsResponse),
            **kwargs,
        )
    
    def list_by_network(self,
        request: "ListSubnetsByNetworkRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["ListSubnetsByNetworkRequest","ListSubnetsResponse"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.ListSubnetsByNetworkRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.vpc.v1.ListSubnetsResponse`.
        """
        
        return super().request(
            method="ListByNetwork",
            request=request,
            result_pb2_class=subnet_service_pb2.ListSubnetsResponse,
            result_wrapper=pb_classes.simple_wrapper(ListSubnetsResponse),
            **kwargs,
        )
    
    def create(self,
        request: "CreateSubnetRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["CreateSubnetRequest","operation.Operation[v1_1.Operation]"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.CreateSubnetRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.common.v1.Operation`.
        """
        
        return super().request(
            method="Create",
            request=request,
            result_pb2_class=operation_pb2.Operation,
            result_wrapper=operation.Operation,
            **kwargs,
        )
    
    def update(self,
        request: "UpdateSubnetRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["UpdateSubnetRequest","operation.Operation[v1_1.Operation]"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.UpdateSubnetRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.common.v1.Operation`.
        """
        
        kwargs['metadata'] = fieldmask_protobuf.ensure_reset_mask_in_metadata(request, kwargs.get('metadata', None))
        return super().request(
            method="Update",
            request=request,
            result_pb2_class=operation_pb2.Operation,
            result_wrapper=operation.Operation,
            **kwargs,
        )
    
    def delete(self,
        request: "DeleteSubnetRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["DeleteSubnetRequest","operation.Operation[v1_1.Operation]"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.DeleteSubnetRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.common.v1.Operation`.
        """
        
        return super().request(
            method="Delete",
            request=request,
            result_pb2_class=operation_pb2.Operation,
            result_wrapper=operation.Operation,
            **kwargs,
        )
    

# file: nebius/vpc/v1/target_group.proto
class TargetGroup(pb_classes.Message):
    """
    Target group represents the set of resources that receive traffic from a load balancer listener
    """
    
    __PB2_CLASS__ = target_group_pb2.TargetGroup
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.TargetGroup",target_group_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
        spec: "TargetGroupSpec|target_group_pb2.TargetGroupSpec|None|unset.UnsetType" = unset.Unset,
        status: "TargetGroupStatus|target_group_pb2.TargetGroupStatus|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
        if not isinstance(spec, unset.UnsetType):
            self.spec = spec
        if not isinstance(status, unset.UnsetType):
            self.status = status
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
            "spec",
            "status",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        """
        Metadata for the TargetGroup resource.
        ``metadata.parent_id`` represents IAM container
        """
        
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    @builtins.property
    def spec(self) -> "TargetGroupSpec":
        """
        Specification of the TargetGroup.
        """
        
        return super()._get_field("spec", explicit_presence=False,
        wrap=TargetGroupSpec,
        )
    @spec.setter
    def spec(self, value: "TargetGroupSpec|target_group_pb2.TargetGroupSpec|None") -> None:
        return super()._set_field("spec",value,explicit_presence=False,
        )
    
    @builtins.property
    def status(self) -> "TargetGroupStatus":
        """
        Status of the TargetGroup.
        """
        
        return super()._get_field("status", explicit_presence=False,
        wrap=TargetGroupStatus,
        )
    @status.setter
    def status(self, value: "TargetGroupStatus|target_group_pb2.TargetGroupStatus|None") -> None:
        return super()._set_field("status",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
        "spec":"spec",
        "status":"status",
    }
    
class TargetGroupSpec(pb_classes.Message):
    __PB2_CLASS__ = target_group_pb2.TargetGroupSpec
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.TargetGroupSpec",target_group_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        targets: "abc.Iterable[Target]|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(targets, unset.UnsetType):
            self.targets = targets
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "targets",
        ]
    
    @builtins.property
    def targets(self) -> "abc.MutableSequence[Target]":
        """
        Targets of the TargetGroup
        """
        
        return super()._get_field("targets", explicit_presence=False,
        wrap=pb_classes.Repeated.with_wrap(Target,None,None),
        )
    @targets.setter
    def targets(self, value: "abc.Iterable[Target]|None") -> None:
        return super()._set_field("targets",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "targets":"targets",
    }
    
class Target(pb_classes.Message):
    """
    Represents the target which can receive traffic from a load balancer listener
    """
    
    __PB2_CLASS__ = target_group_pb2.Target
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.Target",target_group_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    class __OneOfClass_target__(pb_classes.OneOf):
        name: builtins.str= "target"
        
        def __init__(self, msg: "Target") -> None:
            super().__init__()
            self._message: "Target" = msg
    
    class __OneOfClass_target_compute_instance__(__OneOfClass_target__):
        field: typing.Literal["compute_instance"] = "compute_instance"
        
        def __init__(self, msg: "Target") -> None:
            super().__init__(msg)
        @builtins.property
        def value(self) -> "ComputeInstance":
            return self._message.compute_instance
    
    @builtins.property
    def target(self) -> __OneOfClass_target_compute_instance__|None:
        field_name_1: str|None = super().which_field_in_oneof("target")
        match field_name_1:
            case "compute_instance":
                return self.__OneOfClass_target_compute_instance__(self)
            case None:
                return None
            case _:
                raise pb_classes.OneOfMatchError(field_name_1)
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        compute_instance: "ComputeInstance|target_group_pb2.ComputeInstance|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(compute_instance, unset.UnsetType):
            self.compute_instance = compute_instance
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "compute_instance",
            "target",
        ]
    
    @builtins.property
    def compute_instance(self) -> "ComputeInstance|None":
        """
        Compute instance used as a target
        """
        
        return super()._get_field("compute_instance", explicit_presence=True,
        wrap=ComputeInstance,
        )
    @compute_instance.setter
    def compute_instance(self, value: "ComputeInstance|target_group_pb2.ComputeInstance|None") -> None:
        return super()._set_field("compute_instance",value,explicit_presence=True,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "compute_instance":"compute_instance",
        "target":"target",
    }
    
class ComputeInstance(pb_classes.Message):
    """
    Target representing compute instance
    """
    
    __PB2_CLASS__ = target_group_pb2.ComputeInstance
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.ComputeInstance",target_group_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        network_interface_name: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(id, unset.UnsetType):
            self.id = id
        if not isinstance(network_interface_name, unset.UnsetType):
            self.network_interface_name = network_interface_name
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "id",
            "network_interface_name",
        ]
    
    @builtins.property
    def id(self) -> "builtins.str":
        """
        Compute instance id to send traffic to
        """
        
        return super()._get_field("id", explicit_presence=False,
        )
    @id.setter
    def id(self, value: "builtins.str|None") -> None:
        return super()._set_field("id",value,explicit_presence=False,
        )
    
    @builtins.property
    def network_interface_name(self) -> "builtins.str":
        """
        Name of the compute instance's NetworkInterface to send traffic to. If not specified the first one will be used.
        """
        
        return super()._get_field("network_interface_name", explicit_presence=False,
        )
    @network_interface_name.setter
    def network_interface_name(self, value: "builtins.str|None") -> None:
        return super()._set_field("network_interface_name",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "id":"id",
        "network_interface_name":"network_interface_name",
    }
    
class TargetGroupStatus(pb_classes.Message):
    __PB2_CLASS__ = target_group_pb2.TargetGroupStatus
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.TargetGroupStatus",target_group_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        load_balancer_ids: "abc.Iterable[builtins.str]|None|unset.UnsetType" = unset.Unset,
        target_statuses: "abc.Iterable[TargetStatus]|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(load_balancer_ids, unset.UnsetType):
            self.load_balancer_ids = load_balancer_ids
        if not isinstance(target_statuses, unset.UnsetType):
            self.target_statuses = target_statuses
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "load_balancer_ids",
            "target_statuses",
        ]
    
    @builtins.property
    def load_balancer_ids(self) -> "abc.MutableSequence[builtins.str]":
        """
        LoadBalancer ids target group is attached to
        """
        
        return super()._get_field("load_balancer_ids", explicit_presence=False,
        wrap=pb_classes.Repeated,
        )
    @load_balancer_ids.setter
    def load_balancer_ids(self, value: "abc.Iterable[builtins.str]|None") -> None:
        return super()._set_field("load_balancer_ids",value,explicit_presence=False,
        )
    
    @builtins.property
    def target_statuses(self) -> "abc.MutableSequence[TargetStatus]":
        """
        Statuses of specified targets
        """
        
        return super()._get_field("target_statuses", explicit_presence=False,
        wrap=pb_classes.Repeated.with_wrap(TargetStatus,None,None),
        )
    @target_statuses.setter
    def target_statuses(self, value: "abc.Iterable[TargetStatus]|None") -> None:
        return super()._set_field("target_statuses",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "load_balancer_ids":"load_balancer_ids",
        "target_statuses":"target_statuses",
    }
    
class TargetStatus(pb_classes.Message):
    __PB2_CLASS__ = target_group_pb2.TargetStatus
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.TargetStatus",target_group_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    class TargetState(pb_enum.Enum):
        __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.EnumDescriptor](".nebius.vpc.v1.TargetStatus.TargetState",target_group_pb2.DESCRIPTOR,descriptor_1.EnumDescriptor)
        TARGET_STATE_UNSPECIFIED = 0
        READY = 1
        """
        The target exists and ready to receive traffic
        """
        
        DISABLED = 2
        """
        The target exists, but not ready to receive traffic (i.e. network interface is not allocated)
        """
        
        DELETED = 3
        """
        The target does not exist anymore (i.e. network interface was deleted)
        """
        
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        compute_instance_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        target_state: "TargetStatus.TargetState|target_group_pb2.TargetStatus.TargetState|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(compute_instance_id, unset.UnsetType):
            self.compute_instance_id = compute_instance_id
        if not isinstance(target_state, unset.UnsetType):
            self.target_state = target_state
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "compute_instance_id",
            "target_state",
            "TargetState",
        ]
    
    @builtins.property
    def compute_instance_id(self) -> "builtins.str":
        return super()._get_field("compute_instance_id", explicit_presence=False,
        )
    @compute_instance_id.setter
    def compute_instance_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("compute_instance_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def target_state(self) -> "TargetStatus.TargetState":
        return super()._get_field("target_state", explicit_presence=False,
        wrap=TargetStatus.TargetState,
        )
    @target_state.setter
    def target_state(self, value: "TargetStatus.TargetState|target_group_pb2.TargetStatus.TargetState|None") -> None:
        return super()._set_field("target_state",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "compute_instance_id":"compute_instance_id",
        "target_state":"target_state",
        "TargetState":"TargetState",
    }
    
# file: nebius/vpc/v1/target_group_service.proto
class GetTargetGroupRequest(pb_classes.Message):
    __PB2_CLASS__ = target_group_service_pb2.GetTargetGroupRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.GetTargetGroupRequest",target_group_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        id: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(id, unset.UnsetType):
            self.id = id
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "id",
        ]
    
    @builtins.property
    def id(self) -> "builtins.str":
        return super()._get_field("id", explicit_presence=False,
        )
    @id.setter
    def id(self, value: "builtins.str|None") -> None:
        return super()._set_field("id",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "id":"id",
    }
    
class UpdateTargetGroupRequest(pb_classes.Message):
    __PB2_CLASS__ = target_group_service_pb2.UpdateTargetGroupRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.vpc.v1.UpdateTargetGroupRequest",target_group_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message_1.Message|None = None,
        *,
        metadata: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None|unset.UnsetType" = unset.Unset,
        spec: "TargetGroupSpec|target_group_pb2.TargetGroupSpec|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(metadata, unset.UnsetType):
            self.metadata = metadata
        if not isinstance(spec, unset.UnsetType):
            self.spec = spec
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "metadata",
            "spec",
        ]
    
    @builtins.property
    def metadata(self) -> "v1_1.ResourceMetadata":
        return super()._get_field("metadata", explicit_presence=False,
        wrap=v1_1.ResourceMetadata,
        )
    @metadata.setter
    def metadata(self, value: "v1_1.ResourceMetadata|metadata_pb2.ResourceMetadata|None") -> None:
        return super()._set_field("metadata",value,explicit_presence=False,
        )
    
    @builtins.property
    def spec(self) -> "TargetGroupSpec":
        return super()._get_field("spec", explicit_presence=False,
        wrap=TargetGroupSpec,
        )
    @spec.setter
    def spec(self, value: "TargetGroupSpec|target_group_pb2.TargetGroupSpec|None") -> None:
        return super()._set_field("spec",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "metadata":"metadata",
        "spec":"spec",
    }
    

class TargetGroupServiceClient(client.ClientWithOperations[v1_1.Operation,v1_1.OperationServiceClient]):
    """
    This class provides the client methods for the ``.nebius.vpc.v1.TargetGroupService`` service.
    
    Each method constructs a :class:`nebius.aio.request.Request` object
    that represents the in-flight RPC. The request can be awaited (async)
    or waited synchronously using its ``.wait()`` helpers.
    
    The request methods accept various parameters to configure metadata,
    timeouts, authorization, and retries. See individual method docstrings
    for details.
    
    :cvar __service_name__: The full protobuf service name.
    """
    
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.ServiceDescriptor](".nebius.vpc.v1.TargetGroupService",target_group_service_pb2.DESCRIPTOR,descriptor_1.ServiceDescriptor)
    """The protobuf service descriptor extraction function."""
    __service_name__ = ".nebius.vpc.v1.TargetGroupService"
    __operation_type__ = v1_1.Operation
    __operation_service_class__ = v1_1.OperationServiceClient
    __operation_source_method__ = "Update"
    """The method name that can be used to fetch the address channel for the operation."""
    
    def get(self,
        request: "GetTargetGroupRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["GetTargetGroupRequest","TargetGroup"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.GetTargetGroupRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.vpc.v1.TargetGroup`.
        """
        
        return super().request(
            method="Get",
            request=request,
            result_pb2_class=target_group_pb2.TargetGroup,
            result_wrapper=pb_classes.simple_wrapper(TargetGroup),
            **kwargs,
        )
    
    def update(self,
        request: "UpdateTargetGroupRequest",
        **kwargs: typing_extensions.Unpack[request_kwargs.RequestKwargs]
    ) -> request_1.Request["UpdateTargetGroupRequest","operation.Operation[v1_1.Operation]"]:
        """
        :param request: The request object to send.
        :type request: :class:`nebius.api.nebius.vpc.v1.UpdateTargetGroupRequest`
        
        Other parameters can be provided as keyword arguments in the
        ``**kwargs`` dictionary, including metadata, timeouts, and retries.
        See :class:`nebius.aio.request_kwargs.RequestKwargs` for details.
        
        :return: A :class:`nebius.aio.request.Request` object representing the
            in-flight RPC. It can be awaited (async) or waited
            synchronously using its ``.wait()`` helpers.
        :rtype: :class:`nebius.aio.request.Request` of
            :class:`nebius.api.nebius.common.v1.Operation`.
        """
        
        kwargs['metadata'] = fieldmask_protobuf.ensure_reset_mask_in_metadata(request, kwargs.get('metadata', None))
        return super().request(
            method="Update",
            request=request,
            result_pb2_class=operation_pb2.Operation,
            result_wrapper=operation.Operation,
            **kwargs,
        )
    

__all__ = [
    #@ local import names here @#
    "AddressBlockState",
    "IpVersion",
    "IpVisibility",
    "Pool",
    "PoolSpec",
    "PoolCidr",
    "PoolStatus",
    "PoolAssignment",
    "Allocation",
    "AllocationSpec",
    "IPv4PrivateAllocationSpec",
    "IPv4PublicAllocationSpec",
    "AllocationStatus",
    "AllocationDetails",
    "Assignment",
    "NetworkInterfaceAssignment",
    "LoadBalancerAssignment",
    "GetAllocationRequest",
    "GetAllocationByNameRequest",
    "ListAllocationsRequest",
    "ListAllocationsByPoolRequest",
    "ListAllocationsResponse",
    "CreateAllocationRequest",
    "UpdateAllocationRequest",
    "DeleteAllocationRequest",
    "AllocationServiceClient",
    "Network",
    "NetworkSpec",
    "IPv4PrivateNetworkPools",
    "IPv4PublicNetworkPools",
    "NetworkPool",
    "NetworkStatus",
    "GetNetworkRequest",
    "GetNetworkByNameRequest",
    "ListNetworksRequest",
    "ListNetworksResponse",
    "CreateNetworkRequest",
    "CreateDefaultNetworkRequest",
    "UpdateNetworkRequest",
    "DeleteNetworkRequest",
    "NetworkServiceClient",
    "GetPoolRequest",
    "GetPoolByNameRequest",
    "ListPoolsRequest",
    "ListPoolsBySourcePoolRequest",
    "ListPoolsResponse",
    "CreatePoolRequest",
    "UpdatePoolRequest",
    "DeletePoolRequest",
    "PoolServiceClient",
    "Route",
    "RouteSpec",
    "DestinationMatch",
    "NextHop",
    "AllocationNextHop",
    "RouteStatus",
    "NextHopState",
    "AllocationNextHopState",
    "DefaultEgressGatewayState",
    "GetRouteRequest",
    "GetRouteByNameRequest",
    "ListRoutesRequest",
    "ListRoutesResponse",
    "CreateRouteRequest",
    "UpdateRouteRequest",
    "DeleteRouteRequest",
    "RouteServiceClient",
    "RouteTable",
    "RouteTableSpec",
    "RouteTableStatus",
    "RouteTableAssignment",
    "GetRouteTableRequest",
    "GetRouteTableByNameRequest",
    "ListRouteTablesRequest",
    "ListRouteTablesByNetworkRequest",
    "ListRouteTablesResponse",
    "CreateRouteTableRequest",
    "UpdateRouteTableRequest",
    "DeleteRouteTableRequest",
    "RouteTableServiceClient",
    "Subnet",
    "SubnetSpec",
    "IPv4PrivateSubnetPools",
    "IPv4PublicSubnetPools",
    "SubnetPool",
    "SubnetCidr",
    "SubnetStatus",
    "SubnetAssociatedRouteTable",
    "GetSubnetRequest",
    "GetSubnetByNameRequest",
    "ListSubnetsRequest",
    "ListSubnetsByNetworkRequest",
    "ListSubnetsResponse",
    "CreateSubnetRequest",
    "UpdateSubnetRequest",
    "DeleteSubnetRequest",
    "SubnetServiceClient",
    "TargetGroup",
    "TargetGroupSpec",
    "Target",
    "ComputeInstance",
    "TargetGroupStatus",
    "TargetStatus",
    "GetTargetGroupRequest",
    "UpdateTargetGroupRequest",
    "TargetGroupServiceClient",
]
