# bye-cloud

Convert the iCloud photos archive from Apple so you can move to immich.

## How to get your photos from Apple

Go to [https://privacy.apple.com/accounts](https://privacy.apple.com/accounts) and request a copy of
all of your data. It will take a while -- a few days, and when you get it, it won't be in a very useful
format. It's almost like Apple doesn't want you to control your own photos. (You can also get your iCloud
Drive files and stuff while you're there.)

## Now that you have your iCloud Photos

Once you have downloaded your iCloud backups, they will be in zip files with a very specific naming
convention, like `iCloud Photos Part 1 of 3.zip`. This backup tool assumes that's the case, and if that
changes, this tool won't work until it is updated. But it is open source so you can change it yourself
or at least report an issue!

It's important that you copy all those zip files into a new location where we will be operating on them.
**I haven't extensively tested this program out, so make sure you don't run it against your only copy.**

And you must copy all of your zip files. If you only copy one of three zip files, bye-cloud will notice
and complain. The reason is that apple distributes photos randomly throughout these archives, and if you
try to unpack only one part, the Album spreadsheets will reference photos that bye-cloud won't be able 
to find.

## Install

```
pip install bye-cloud
```

## Usage

With all of your .zip files in a folder, let's say `./icloud-parts`, run the command:

`bye-cloud -i ./icloud-parts ./export`

That's it! Just wait until it finishes and your photos will be organized into folders. These should 
work with image libraries like immich and others.
