from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="arzplus",
    version="1.0.0",
    author="Amirreza - Khezerlou",
    author_email="mrkhezerlou@gmail.com",
    description="ARZ PLUS CLI – Live prices for currency, crypto, and gold in Iran",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/AmirrezaKhezerlou",
    packages=find_packages(),
    py_modules=["arzplus.main"],
    install_requires=[
        "typer>=0.9.0",
        "requests>=2.28.0",
        "beautifulsoup4>=4.11.0",
    ],
    entry_points={
        "console_scripts": [
            "arz=arzplus.main:app",
        ],
    },
    python_requires=">=3.7",
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
)