# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetHealthResult',
    'AwaitableGetHealthResult',
    'get_health',
    'get_health_output',
]

@pulumi.output_type
class GetHealthResult:
    """
    A collection of values returned by getHealth.
    """
    def __init__(__self__, client_configuration=None, control_plane_nodes=None, endpoints=None, id=None, skip_kubernetes_checks=None, timeouts=None, worker_nodes=None):
        if client_configuration and not isinstance(client_configuration, dict):
            raise TypeError("Expected argument 'client_configuration' to be a dict")
        pulumi.set(__self__, "client_configuration", client_configuration)
        if control_plane_nodes and not isinstance(control_plane_nodes, list):
            raise TypeError("Expected argument 'control_plane_nodes' to be a list")
        pulumi.set(__self__, "control_plane_nodes", control_plane_nodes)
        if endpoints and not isinstance(endpoints, list):
            raise TypeError("Expected argument 'endpoints' to be a list")
        pulumi.set(__self__, "endpoints", endpoints)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if skip_kubernetes_checks and not isinstance(skip_kubernetes_checks, bool):
            raise TypeError("Expected argument 'skip_kubernetes_checks' to be a bool")
        pulumi.set(__self__, "skip_kubernetes_checks", skip_kubernetes_checks)
        if timeouts and not isinstance(timeouts, dict):
            raise TypeError("Expected argument 'timeouts' to be a dict")
        pulumi.set(__self__, "timeouts", timeouts)
        if worker_nodes and not isinstance(worker_nodes, list):
            raise TypeError("Expected argument 'worker_nodes' to be a list")
        pulumi.set(__self__, "worker_nodes", worker_nodes)

    @property
    @pulumi.getter(name="clientConfiguration")
    def client_configuration(self) -> 'outputs.GetHealthClientConfigurationResult':
        """
        The client configuration data
        """
        return pulumi.get(self, "client_configuration")

    @property
    @pulumi.getter(name="controlPlaneNodes")
    def control_plane_nodes(self) -> Sequence[builtins.str]:
        """
        List of control plane nodes to check for health.
        """
        return pulumi.get(self, "control_plane_nodes")

    @property
    @pulumi.getter
    def endpoints(self) -> Sequence[builtins.str]:
        """
        endpoints to use for the health check client. Use at least one control plane endpoint.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="skipKubernetesChecks")
    def skip_kubernetes_checks(self) -> Optional[builtins.bool]:
        """
        Skip Kubernetes component checks, this is useful to check if the nodes has finished booting up and kubelet is running. Default is false.
        """
        return pulumi.get(self, "skip_kubernetes_checks")

    @property
    @pulumi.getter
    def timeouts(self) -> Optional['outputs.GetHealthTimeoutsResult']:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter(name="workerNodes")
    def worker_nodes(self) -> Optional[Sequence[builtins.str]]:
        """
        List of worker nodes to check for health.
        """
        return pulumi.get(self, "worker_nodes")


class AwaitableGetHealthResult(GetHealthResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHealthResult(
            client_configuration=self.client_configuration,
            control_plane_nodes=self.control_plane_nodes,
            endpoints=self.endpoints,
            id=self.id,
            skip_kubernetes_checks=self.skip_kubernetes_checks,
            timeouts=self.timeouts,
            worker_nodes=self.worker_nodes)


def get_health(client_configuration: Optional[Union['GetHealthClientConfigurationArgs', 'GetHealthClientConfigurationArgsDict']] = None,
               control_plane_nodes: Optional[Sequence[builtins.str]] = None,
               endpoints: Optional[Sequence[builtins.str]] = None,
               skip_kubernetes_checks: Optional[builtins.bool] = None,
               timeouts: Optional[Union['GetHealthTimeoutsArgs', 'GetHealthTimeoutsArgsDict']] = None,
               worker_nodes: Optional[Sequence[builtins.str]] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHealthResult:
    """
    Waits for the Talos cluster to be healthy. Can be used as a dependency before running other operations on the cluster.


    :param Union['GetHealthClientConfigurationArgs', 'GetHealthClientConfigurationArgsDict'] client_configuration: The client configuration data
    :param Sequence[builtins.str] control_plane_nodes: List of control plane nodes to check for health.
    :param Sequence[builtins.str] endpoints: endpoints to use for the health check client. Use at least one control plane endpoint.
    :param builtins.bool skip_kubernetes_checks: Skip Kubernetes component checks, this is useful to check if the nodes has finished booting up and kubelet is running. Default is false.
    :param Sequence[builtins.str] worker_nodes: List of worker nodes to check for health.
    """
    __args__ = dict()
    __args__['clientConfiguration'] = client_configuration
    __args__['controlPlaneNodes'] = control_plane_nodes
    __args__['endpoints'] = endpoints
    __args__['skipKubernetesChecks'] = skip_kubernetes_checks
    __args__['timeouts'] = timeouts
    __args__['workerNodes'] = worker_nodes
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('talos:cluster/getHealth:getHealth', __args__, opts=opts, typ=GetHealthResult).value

    return AwaitableGetHealthResult(
        client_configuration=pulumi.get(__ret__, 'client_configuration'),
        control_plane_nodes=pulumi.get(__ret__, 'control_plane_nodes'),
        endpoints=pulumi.get(__ret__, 'endpoints'),
        id=pulumi.get(__ret__, 'id'),
        skip_kubernetes_checks=pulumi.get(__ret__, 'skip_kubernetes_checks'),
        timeouts=pulumi.get(__ret__, 'timeouts'),
        worker_nodes=pulumi.get(__ret__, 'worker_nodes'))
def get_health_output(client_configuration: Optional[pulumi.Input[Union['GetHealthClientConfigurationArgs', 'GetHealthClientConfigurationArgsDict']]] = None,
                      control_plane_nodes: Optional[pulumi.Input[Sequence[builtins.str]]] = None,
                      endpoints: Optional[pulumi.Input[Sequence[builtins.str]]] = None,
                      skip_kubernetes_checks: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                      timeouts: Optional[pulumi.Input[Optional[Union['GetHealthTimeoutsArgs', 'GetHealthTimeoutsArgsDict']]]] = None,
                      worker_nodes: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetHealthResult]:
    """
    Waits for the Talos cluster to be healthy. Can be used as a dependency before running other operations on the cluster.


    :param Union['GetHealthClientConfigurationArgs', 'GetHealthClientConfigurationArgsDict'] client_configuration: The client configuration data
    :param Sequence[builtins.str] control_plane_nodes: List of control plane nodes to check for health.
    :param Sequence[builtins.str] endpoints: endpoints to use for the health check client. Use at least one control plane endpoint.
    :param builtins.bool skip_kubernetes_checks: Skip Kubernetes component checks, this is useful to check if the nodes has finished booting up and kubelet is running. Default is false.
    :param Sequence[builtins.str] worker_nodes: List of worker nodes to check for health.
    """
    __args__ = dict()
    __args__['clientConfiguration'] = client_configuration
    __args__['controlPlaneNodes'] = control_plane_nodes
    __args__['endpoints'] = endpoints
    __args__['skipKubernetesChecks'] = skip_kubernetes_checks
    __args__['timeouts'] = timeouts
    __args__['workerNodes'] = worker_nodes
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('talos:cluster/getHealth:getHealth', __args__, opts=opts, typ=GetHealthResult)
    return __ret__.apply(lambda __response__: GetHealthResult(
        client_configuration=pulumi.get(__response__, 'client_configuration'),
        control_plane_nodes=pulumi.get(__response__, 'control_plane_nodes'),
        endpoints=pulumi.get(__response__, 'endpoints'),
        id=pulumi.get(__response__, 'id'),
        skip_kubernetes_checks=pulumi.get(__response__, 'skip_kubernetes_checks'),
        timeouts=pulumi.get(__response__, 'timeouts'),
        worker_nodes=pulumi.get(__response__, 'worker_nodes')))
