# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetConfigurationResult',
    'AwaitableGetConfigurationResult',
    'get_configuration',
    'get_configuration_output',
]

@pulumi.output_type
class GetConfigurationResult:
    """
    A collection of values returned by getConfiguration.
    """
    def __init__(__self__, cluster_endpoint=None, cluster_name=None, config_patches=None, docs=None, examples=None, id=None, kubernetes_version=None, machine_configuration=None, machine_secrets=None, machine_type=None, talos_version=None):
        if cluster_endpoint and not isinstance(cluster_endpoint, str):
            raise TypeError("Expected argument 'cluster_endpoint' to be a str")
        pulumi.set(__self__, "cluster_endpoint", cluster_endpoint)
        if cluster_name and not isinstance(cluster_name, str):
            raise TypeError("Expected argument 'cluster_name' to be a str")
        pulumi.set(__self__, "cluster_name", cluster_name)
        if config_patches and not isinstance(config_patches, list):
            raise TypeError("Expected argument 'config_patches' to be a list")
        pulumi.set(__self__, "config_patches", config_patches)
        if docs and not isinstance(docs, bool):
            raise TypeError("Expected argument 'docs' to be a bool")
        pulumi.set(__self__, "docs", docs)
        if examples and not isinstance(examples, bool):
            raise TypeError("Expected argument 'examples' to be a bool")
        pulumi.set(__self__, "examples", examples)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kubernetes_version and not isinstance(kubernetes_version, str):
            raise TypeError("Expected argument 'kubernetes_version' to be a str")
        pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if machine_configuration and not isinstance(machine_configuration, str):
            raise TypeError("Expected argument 'machine_configuration' to be a str")
        pulumi.set(__self__, "machine_configuration", machine_configuration)
        if machine_secrets and not isinstance(machine_secrets, dict):
            raise TypeError("Expected argument 'machine_secrets' to be a dict")
        pulumi.set(__self__, "machine_secrets", machine_secrets)
        if machine_type and not isinstance(machine_type, str):
            raise TypeError("Expected argument 'machine_type' to be a str")
        pulumi.set(__self__, "machine_type", machine_type)
        if talos_version and not isinstance(talos_version, str):
            raise TypeError("Expected argument 'talos_version' to be a str")
        pulumi.set(__self__, "talos_version", talos_version)

    @property
    @pulumi.getter(name="clusterEndpoint")
    def cluster_endpoint(self) -> builtins.str:
        """
        The endpoint of the talos kubernetes cluster
        """
        return pulumi.get(self, "cluster_endpoint")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> builtins.str:
        """
        The name of the talos kubernetes cluster
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="configPatches")
    def config_patches(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of config patches to apply to the generated configuration
        """
        return pulumi.get(self, "config_patches")

    @property
    @pulumi.getter
    def docs(self) -> Optional[builtins.bool]:
        """
        Whether to generate documentation for the generated configuration. Defaults to false
        """
        return pulumi.get(self, "docs")

    @property
    @pulumi.getter
    def examples(self) -> Optional[builtins.bool]:
        """
        Whether to generate examples for the generated configuration. Defaults to false
        """
        return pulumi.get(self, "examples")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[builtins.str]:
        """
        The version of kubernetes to use
        """
        return pulumi.get(self, "kubernetes_version")

    @property
    @pulumi.getter(name="machineConfiguration")
    def machine_configuration(self) -> builtins.str:
        """
        The generated machine configuration
        """
        return pulumi.get(self, "machine_configuration")

    @property
    @pulumi.getter(name="machineSecrets")
    def machine_secrets(self) -> 'outputs.MachineSecretsResult':
        """
        The secrets for the talos cluster
        """
        return pulumi.get(self, "machine_secrets")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> builtins.str:
        """
        The type of machine to generate the configuration for
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter(name="talosVersion")
    def talos_version(self) -> Optional[builtins.str]:
        """
        The version of talos features to use in generated machine configuration
        """
        return pulumi.get(self, "talos_version")


class AwaitableGetConfigurationResult(GetConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConfigurationResult(
            cluster_endpoint=self.cluster_endpoint,
            cluster_name=self.cluster_name,
            config_patches=self.config_patches,
            docs=self.docs,
            examples=self.examples,
            id=self.id,
            kubernetes_version=self.kubernetes_version,
            machine_configuration=self.machine_configuration,
            machine_secrets=self.machine_secrets,
            machine_type=self.machine_type,
            talos_version=self.talos_version)


def get_configuration(cluster_endpoint: Optional[builtins.str] = None,
                      cluster_name: Optional[builtins.str] = None,
                      config_patches: Optional[Sequence[builtins.str]] = None,
                      docs: Optional[builtins.bool] = None,
                      examples: Optional[builtins.bool] = None,
                      kubernetes_version: Optional[builtins.str] = None,
                      machine_secrets: Optional[Union['MachineSecretsArgs', 'MachineSecretsArgsDict']] = None,
                      machine_type: Optional[builtins.str] = None,
                      talos_version: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConfigurationResult:
    """
    Generate a machine configuration for a node type

    > **Note:** It is recommended to set the optional `talos_version` attribute. Otherwise when using a new version of the provider with a new major version of the Talos SDK, new machineconfig features will be enabled by default which could cause unexpected behavior.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_talos as talos
    import pulumiverse_talos as talos

    this_secrets = talos.machine.Secrets("this")
    this = talos.machine.get_configuration_output(cluster_name="example-cluster",
        machine_type="controlplane",
        cluster_endpoint="https://cluster.local:6443",
        machine_secrets=this_secrets.machine_secrets)
    ```


    :param builtins.str cluster_endpoint: The endpoint of the talos kubernetes cluster
    :param builtins.str cluster_name: The name of the talos kubernetes cluster
    :param Sequence[builtins.str] config_patches: The list of config patches to apply to the generated configuration
    :param builtins.bool docs: Whether to generate documentation for the generated configuration. Defaults to false
    :param builtins.bool examples: Whether to generate examples for the generated configuration. Defaults to false
    :param builtins.str kubernetes_version: The version of kubernetes to use
    :param Union['MachineSecretsArgs', 'MachineSecretsArgsDict'] machine_secrets: The secrets for the talos cluster
    :param builtins.str machine_type: The type of machine to generate the configuration for
    :param builtins.str talos_version: The version of talos features to use in generated machine configuration
    """
    __args__ = dict()
    __args__['clusterEndpoint'] = cluster_endpoint
    __args__['clusterName'] = cluster_name
    __args__['configPatches'] = config_patches
    __args__['docs'] = docs
    __args__['examples'] = examples
    __args__['kubernetesVersion'] = kubernetes_version
    __args__['machineSecrets'] = machine_secrets
    __args__['machineType'] = machine_type
    __args__['talosVersion'] = talos_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('talos:machine/getConfiguration:getConfiguration', __args__, opts=opts, typ=GetConfigurationResult).value

    return AwaitableGetConfigurationResult(
        cluster_endpoint=pulumi.get(__ret__, 'cluster_endpoint'),
        cluster_name=pulumi.get(__ret__, 'cluster_name'),
        config_patches=pulumi.get(__ret__, 'config_patches'),
        docs=pulumi.get(__ret__, 'docs'),
        examples=pulumi.get(__ret__, 'examples'),
        id=pulumi.get(__ret__, 'id'),
        kubernetes_version=pulumi.get(__ret__, 'kubernetes_version'),
        machine_configuration=pulumi.get(__ret__, 'machine_configuration'),
        machine_secrets=pulumi.get(__ret__, 'machine_secrets'),
        machine_type=pulumi.get(__ret__, 'machine_type'),
        talos_version=pulumi.get(__ret__, 'talos_version'))
def get_configuration_output(cluster_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                             cluster_name: Optional[pulumi.Input[builtins.str]] = None,
                             config_patches: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                             docs: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                             examples: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                             kubernetes_version: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             machine_secrets: Optional[pulumi.Input[Union['MachineSecretsArgs', 'MachineSecretsArgsDict']]] = None,
                             machine_type: Optional[pulumi.Input[builtins.str]] = None,
                             talos_version: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConfigurationResult]:
    """
    Generate a machine configuration for a node type

    > **Note:** It is recommended to set the optional `talos_version` attribute. Otherwise when using a new version of the provider with a new major version of the Talos SDK, new machineconfig features will be enabled by default which could cause unexpected behavior.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_talos as talos
    import pulumiverse_talos as talos

    this_secrets = talos.machine.Secrets("this")
    this = talos.machine.get_configuration_output(cluster_name="example-cluster",
        machine_type="controlplane",
        cluster_endpoint="https://cluster.local:6443",
        machine_secrets=this_secrets.machine_secrets)
    ```


    :param builtins.str cluster_endpoint: The endpoint of the talos kubernetes cluster
    :param builtins.str cluster_name: The name of the talos kubernetes cluster
    :param Sequence[builtins.str] config_patches: The list of config patches to apply to the generated configuration
    :param builtins.bool docs: Whether to generate documentation for the generated configuration. Defaults to false
    :param builtins.bool examples: Whether to generate examples for the generated configuration. Defaults to false
    :param builtins.str kubernetes_version: The version of kubernetes to use
    :param Union['MachineSecretsArgs', 'MachineSecretsArgsDict'] machine_secrets: The secrets for the talos cluster
    :param builtins.str machine_type: The type of machine to generate the configuration for
    :param builtins.str talos_version: The version of talos features to use in generated machine configuration
    """
    __args__ = dict()
    __args__['clusterEndpoint'] = cluster_endpoint
    __args__['clusterName'] = cluster_name
    __args__['configPatches'] = config_patches
    __args__['docs'] = docs
    __args__['examples'] = examples
    __args__['kubernetesVersion'] = kubernetes_version
    __args__['machineSecrets'] = machine_secrets
    __args__['machineType'] = machine_type
    __args__['talosVersion'] = talos_version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('talos:machine/getConfiguration:getConfiguration', __args__, opts=opts, typ=GetConfigurationResult)
    return __ret__.apply(lambda __response__: GetConfigurationResult(
        cluster_endpoint=pulumi.get(__response__, 'cluster_endpoint'),
        cluster_name=pulumi.get(__response__, 'cluster_name'),
        config_patches=pulumi.get(__response__, 'config_patches'),
        docs=pulumi.get(__response__, 'docs'),
        examples=pulumi.get(__response__, 'examples'),
        id=pulumi.get(__response__, 'id'),
        kubernetes_version=pulumi.get(__response__, 'kubernetes_version'),
        machine_configuration=pulumi.get(__response__, 'machine_configuration'),
        machine_secrets=pulumi.get(__response__, 'machine_secrets'),
        machine_type=pulumi.get(__response__, 'machine_type'),
        talos_version=pulumi.get(__response__, 'talos_version')))
