# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BootstrapTimeouts',
    'ConfigurationApplyOnDestroy',
    'Timeout',
    'CertificateResult',
    'CertificatesResult',
    'ClientConfiguration',
    'ClusterResult',
    'KeyResult',
    'KubernetesSecretsResult',
    'MachineSecretsResult',
    'TrustdInfoResult',
    'GetDisksClientConfigurationResult',
    'GetDisksDiskResult',
    'GetDisksTimeoutsResult',
]

@pulumi.output_type
class BootstrapTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[builtins.str] = None):
        """
        :param builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")


@pulumi.output_type
class ConfigurationApplyOnDestroy(dict):
    def __init__(__self__, *,
                 graceful: Optional[builtins.bool] = None,
                 reboot: Optional[builtins.bool] = None,
                 reset: Optional[builtins.bool] = None):
        """
        :param builtins.bool graceful: Graceful indicates whether node should leave etcd before the upgrade, it also enforces etcd checks before leaving. Default true
        :param builtins.bool reboot: Reboot indicates whether node should reboot or halt after resetting. Default false
        :param builtins.bool reset: Reset the machine to the initial state (STATE and EPHEMERAL will be wiped). Default false
        """
        if graceful is not None:
            pulumi.set(__self__, "graceful", graceful)
        if reboot is not None:
            pulumi.set(__self__, "reboot", reboot)
        if reset is not None:
            pulumi.set(__self__, "reset", reset)

    @property
    @pulumi.getter
    def graceful(self) -> Optional[builtins.bool]:
        """
        Graceful indicates whether node should leave etcd before the upgrade, it also enforces etcd checks before leaving. Default true
        """
        return pulumi.get(self, "graceful")

    @property
    @pulumi.getter
    def reboot(self) -> Optional[builtins.bool]:
        """
        Reboot indicates whether node should reboot or halt after resetting. Default false
        """
        return pulumi.get(self, "reboot")

    @property
    @pulumi.getter
    def reset(self) -> Optional[builtins.bool]:
        """
        Reset the machine to the initial state (STATE and EPHEMERAL will be wiped). Default false
        """
        return pulumi.get(self, "reset")


@pulumi.output_type
class Timeout(dict):
    def __init__(__self__, *,
                 create: Optional[builtins.str] = None,
                 delete: Optional[builtins.str] = None,
                 update: Optional[builtins.str] = None):
        """
        :param builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def update(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class CertificateResult(dict):
    """
    A Machine Secrets Certificate
    """
    def __init__(__self__, *,
                 cert: builtins.str,
                 key: builtins.str):
        """
        A Machine Secrets Certificate
        :param builtins.str cert: Certificate
        :param builtins.str key: Private Key
        """
        pulumi.set(__self__, "cert", cert)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def cert(self) -> builtins.str:
        """
        Certificate
        """
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Private Key
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class CertificatesResult(dict):
    """
    A complete Machine Secrets Certificates configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "k8sAggregator":
            suggest = "k8s_aggregator"
        elif key == "k8sServiceaccount":
            suggest = "k8s_serviceaccount"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificatesResult. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificatesResult.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificatesResult.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etcd: 'outputs.CertificateResult',
                 k8s: 'outputs.CertificateResult',
                 k8s_aggregator: 'outputs.CertificateResult',
                 k8s_serviceaccount: 'outputs.KeyResult',
                 os: 'outputs.CertificateResult'):
        """
        A complete Machine Secrets Certificates configuration
        """
        pulumi.set(__self__, "etcd", etcd)
        pulumi.set(__self__, "k8s", k8s)
        pulumi.set(__self__, "k8s_aggregator", k8s_aggregator)
        pulumi.set(__self__, "k8s_serviceaccount", k8s_serviceaccount)
        pulumi.set(__self__, "os", os)

    @property
    @pulumi.getter
    def etcd(self) -> 'outputs.CertificateResult':
        return pulumi.get(self, "etcd")

    @property
    @pulumi.getter
    def k8s(self) -> 'outputs.CertificateResult':
        return pulumi.get(self, "k8s")

    @property
    @pulumi.getter(name="k8sAggregator")
    def k8s_aggregator(self) -> 'outputs.CertificateResult':
        return pulumi.get(self, "k8s_aggregator")

    @property
    @pulumi.getter(name="k8sServiceaccount")
    def k8s_serviceaccount(self) -> 'outputs.KeyResult':
        return pulumi.get(self, "k8s_serviceaccount")

    @property
    @pulumi.getter
    def os(self) -> 'outputs.CertificateResult':
        return pulumi.get(self, "os")


@pulumi.output_type
class ClientConfiguration(dict):
    """
    A Client Configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCertificate":
            suggest = "ca_certificate"
        elif key == "clientCertificate":
            suggest = "client_certificate"
        elif key == "clientKey":
            suggest = "client_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_certificate: builtins.str,
                 client_certificate: builtins.str,
                 client_key: builtins.str):
        """
        A Client Configuration
        :param builtins.str ca_certificate: The client CA certificate
        :param builtins.str client_certificate: The client certificate
        :param builtins.str client_key: The client private key
        """
        pulumi.set(__self__, "ca_certificate", ca_certificate)
        pulumi.set(__self__, "client_certificate", client_certificate)
        pulumi.set(__self__, "client_key", client_key)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> builtins.str:
        """
        The client CA certificate
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> builtins.str:
        """
        The client certificate
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> builtins.str:
        """
        The client private key
        """
        return pulumi.get(self, "client_key")


@pulumi.output_type
class ClusterResult(dict):
    """
    A Machine Secrets Cluster Info
    """
    def __init__(__self__, *,
                 id: builtins.str,
                 secret: builtins.str):
        """
        A Machine Secrets Cluster Info
        :param builtins.str id: Certificate
        :param builtins.str secret: Private Key
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Certificate
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def secret(self) -> builtins.str:
        """
        Private Key
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class KeyResult(dict):
    """
    A Machine Secrets Private Key
    """
    def __init__(__self__, *,
                 key: builtins.str):
        """
        A Machine Secrets Private Key
        :param builtins.str key: Private Key
        """
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Private Key
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class KubernetesSecretsResult(dict):
    """
    A Machine Secrets Bootstrap data
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootstrapToken":
            suggest = "bootstrap_token"
        elif key == "secretboxEncryptionSecret":
            suggest = "secretbox_encryption_secret"
        elif key == "aescbcEncryptionSecret":
            suggest = "aescbc_encryption_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesSecretsResult. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesSecretsResult.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesSecretsResult.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bootstrap_token: builtins.str,
                 secretbox_encryption_secret: builtins.str,
                 aescbc_encryption_secret: Optional[builtins.str] = None):
        """
        A Machine Secrets Bootstrap data
        :param builtins.str bootstrap_token: The bootstrap token for the talos kubernetes cluster
        :param builtins.str secretbox_encryption_secret: The secretbox encryption secret for the talos kubernetes cluster
        :param builtins.str aescbc_encryption_secret: The aescbc encryption secret for the talos kubernetes cluster
        """
        pulumi.set(__self__, "bootstrap_token", bootstrap_token)
        pulumi.set(__self__, "secretbox_encryption_secret", secretbox_encryption_secret)
        if aescbc_encryption_secret is not None:
            pulumi.set(__self__, "aescbc_encryption_secret", aescbc_encryption_secret)

    @property
    @pulumi.getter(name="bootstrapToken")
    def bootstrap_token(self) -> builtins.str:
        """
        The bootstrap token for the talos kubernetes cluster
        """
        return pulumi.get(self, "bootstrap_token")

    @property
    @pulumi.getter(name="secretboxEncryptionSecret")
    def secretbox_encryption_secret(self) -> builtins.str:
        """
        The secretbox encryption secret for the talos kubernetes cluster
        """
        return pulumi.get(self, "secretbox_encryption_secret")

    @property
    @pulumi.getter(name="aescbcEncryptionSecret")
    def aescbc_encryption_secret(self) -> Optional[builtins.str]:
        """
        The aescbc encryption secret for the talos kubernetes cluster
        """
        return pulumi.get(self, "aescbc_encryption_secret")


@pulumi.output_type
class MachineSecretsResult(dict):
    """
    A complete Machine Secrets configuration
    """
    def __init__(__self__, *,
                 certs: 'outputs.CertificatesResult',
                 cluster: 'outputs.ClusterResult',
                 secrets: 'outputs.KubernetesSecretsResult',
                 trustdinfo: 'outputs.TrustdInfoResult'):
        """
        A complete Machine Secrets configuration
        """
        pulumi.set(__self__, "certs", certs)
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "secrets", secrets)
        pulumi.set(__self__, "trustdinfo", trustdinfo)

    @property
    @pulumi.getter
    def certs(self) -> 'outputs.CertificatesResult':
        return pulumi.get(self, "certs")

    @property
    @pulumi.getter
    def cluster(self) -> 'outputs.ClusterResult':
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter
    def secrets(self) -> 'outputs.KubernetesSecretsResult':
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter
    def trustdinfo(self) -> 'outputs.TrustdInfoResult':
        return pulumi.get(self, "trustdinfo")


@pulumi.output_type
class TrustdInfoResult(dict):
    """
    A Machine Secrets Trust daemon info
    """
    def __init__(__self__, *,
                 token: builtins.str):
        """
        A Machine Secrets Trust daemon info
        :param builtins.str token: The trustd token for the talos kubernetes cluster
        """
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def token(self) -> builtins.str:
        """
        The trustd token for the talos kubernetes cluster
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class GetDisksClientConfigurationResult(dict):
    def __init__(__self__, *,
                 ca_certificate: builtins.str,
                 client_certificate: builtins.str,
                 client_key: builtins.str):
        """
        :param builtins.str ca_certificate: The client CA certificate
        :param builtins.str client_certificate: The client certificate
        :param builtins.str client_key: The client key
        """
        pulumi.set(__self__, "ca_certificate", ca_certificate)
        pulumi.set(__self__, "client_certificate", client_certificate)
        pulumi.set(__self__, "client_key", client_key)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> builtins.str:
        """
        The client CA certificate
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> builtins.str:
        """
        The client certificate
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> builtins.str:
        """
        The client key
        """
        return pulumi.get(self, "client_key")


@pulumi.output_type
class GetDisksDiskResult(dict):
    def __init__(__self__, *,
                 bus_path: builtins.str,
                 cdrom: builtins.bool,
                 dev_path: builtins.str,
                 io_size: builtins.int,
                 modalias: builtins.str,
                 model: builtins.str,
                 pretty_size: builtins.str,
                 readonly: builtins.bool,
                 rotational: builtins.bool,
                 secondary_disks: Sequence[builtins.str],
                 sector_size: builtins.int,
                 serial: builtins.str,
                 size: builtins.int,
                 sub_system: builtins.str,
                 symlinks: Sequence[builtins.str],
                 transport: builtins.str,
                 uuid: builtins.str,
                 wwid: builtins.str):
        pulumi.set(__self__, "bus_path", bus_path)
        pulumi.set(__self__, "cdrom", cdrom)
        pulumi.set(__self__, "dev_path", dev_path)
        pulumi.set(__self__, "io_size", io_size)
        pulumi.set(__self__, "modalias", modalias)
        pulumi.set(__self__, "model", model)
        pulumi.set(__self__, "pretty_size", pretty_size)
        pulumi.set(__self__, "readonly", readonly)
        pulumi.set(__self__, "rotational", rotational)
        pulumi.set(__self__, "secondary_disks", secondary_disks)
        pulumi.set(__self__, "sector_size", sector_size)
        pulumi.set(__self__, "serial", serial)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "sub_system", sub_system)
        pulumi.set(__self__, "symlinks", symlinks)
        pulumi.set(__self__, "transport", transport)
        pulumi.set(__self__, "uuid", uuid)
        pulumi.set(__self__, "wwid", wwid)

    @property
    @pulumi.getter(name="busPath")
    def bus_path(self) -> builtins.str:
        return pulumi.get(self, "bus_path")

    @property
    @pulumi.getter
    def cdrom(self) -> builtins.bool:
        return pulumi.get(self, "cdrom")

    @property
    @pulumi.getter(name="devPath")
    def dev_path(self) -> builtins.str:
        return pulumi.get(self, "dev_path")

    @property
    @pulumi.getter(name="ioSize")
    def io_size(self) -> builtins.int:
        return pulumi.get(self, "io_size")

    @property
    @pulumi.getter
    def modalias(self) -> builtins.str:
        return pulumi.get(self, "modalias")

    @property
    @pulumi.getter
    def model(self) -> builtins.str:
        return pulumi.get(self, "model")

    @property
    @pulumi.getter(name="prettySize")
    def pretty_size(self) -> builtins.str:
        return pulumi.get(self, "pretty_size")

    @property
    @pulumi.getter
    def readonly(self) -> builtins.bool:
        return pulumi.get(self, "readonly")

    @property
    @pulumi.getter
    def rotational(self) -> builtins.bool:
        return pulumi.get(self, "rotational")

    @property
    @pulumi.getter(name="secondaryDisks")
    def secondary_disks(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "secondary_disks")

    @property
    @pulumi.getter(name="sectorSize")
    def sector_size(self) -> builtins.int:
        return pulumi.get(self, "sector_size")

    @property
    @pulumi.getter
    def serial(self) -> builtins.str:
        return pulumi.get(self, "serial")

    @property
    @pulumi.getter
    def size(self) -> builtins.int:
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="subSystem")
    def sub_system(self) -> builtins.str:
        return pulumi.get(self, "sub_system")

    @property
    @pulumi.getter
    def symlinks(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "symlinks")

    @property
    @pulumi.getter
    def transport(self) -> builtins.str:
        return pulumi.get(self, "transport")

    @property
    @pulumi.getter
    def uuid(self) -> builtins.str:
        return pulumi.get(self, "uuid")

    @property
    @pulumi.getter
    def wwid(self) -> builtins.str:
        return pulumi.get(self, "wwid")


@pulumi.output_type
class GetDisksTimeoutsResult(dict):
    def __init__(__self__, *,
                 read: Optional[builtins.str] = None):
        """
        :param builtins.str read: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Read operations occur during any refresh or planning operation when refresh is enabled.
        """
        if read is not None:
            pulumi.set(__self__, "read", read)

    @property
    @pulumi.getter
    def read(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Read operations occur during any refresh or planning operation when refresh is enabled.
        """
        return pulumi.get(self, "read")


